###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for tightvnc MDKSA-2007:080-1 (tightvnc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830338);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:080-1");
  script_cve_id("CVE-2007-1003", "CVE-2007-1351", "CVE-2007-1352");
  script_name(english: "Mandriva Update for tightvnc MDKSA-2007:080-1 (tightvnc)");
  desc["english"] = "

  Vulnerability Insight:

  Local exploitation of a memory corruption vulnerability in the X.Org
  and XFree86 X server could allow an attacker to execute arbitrary
  code with privileges of the X server, typically root.
  
  The vulnerability exists in the ProcXCMiscGetXIDList() function in the
  XC-MISC extension. This request is used to determine what resource IDs
  are available for use. This function contains two vulnerabilities,
  both result in memory corruption of either the stack or heap. The
  ALLOCATE_LOCAL() macro used by this function allocates memory on the
  stack using alloca() on systems where alloca() is present, or using
  the heap otherwise. The handler function takes a user provided value,
  multiplies it, and then passes it to the above macro. This results in
  both an integer overflow vulnerability, and an alloca() stack pointer
  shifting vulnerability. Both can be exploited to execute arbitrary
  code. (CVE-2007-1003)
  
  iDefense reported two integer overflows in the way X.org handled
  various font files. A malicious local user could exploit these issues
  to potentially execute arbitrary code with the privileges of the
  X.org server. (CVE-2007-1351, CVE-2007-1352)
  
  TightVNC uses some of the same code base as Xorg, and has the same
  vulnerable code.
  
  Updated packages are patched to address these issues.
  
  Update:
  
  Packages for Mandriva Linux 2007.1 are now available.

  Affected Software/OS:
  tightvnc on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00014.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tightvnc");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"tightvnc", rpm:"tightvnc~1.2.9~16.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tightvnc-doc", rpm:"tightvnc-doc~1.2.9~16.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tightvnc-server", rpm:"tightvnc-server~1.2.9~16.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}