###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for eclipse MDKA-2007:114 (eclipse)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830217);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:114");
  script_cve_id("");
  script_name(english: "Mandriva Update for eclipse MDKA-2007:114 (eclipse)");
  desc["english"] = "

  Vulnerability Insight:

  The Eclipse IDE provided with 2008.0 does not run, instead outputting
  a glibc error or JVM termination error.  This update fixes that,
  and some other bugs in the package.

  Affected Software/OS:
  eclipse on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00043.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of eclipse");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"eclipse-cvs-client", rpm:"eclipse-cvs-client~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-ecj", rpm:"eclipse-ecj~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-jdt", rpm:"eclipse-jdt~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-pde", rpm:"eclipse-pde~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-pde-runtime", rpm:"eclipse-pde-runtime~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-platform", rpm:"eclipse-platform~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-rcp", rpm:"eclipse-rcp~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libswt3-gtk2", rpm:"libswt3-gtk2~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse", rpm:"eclipse~3.3.0~0.20.8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}