###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for glibc MDKA-2007:111 (glibc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830037);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:111");
  script_cve_id("");
  script_name(english: "Mandriva Update for glibc MDKA-2007:111 (glibc)");
  desc["english"] = "

  Vulnerability Insight:

  Two issues were discovered in the glibc package, after Mandriva Linux
  2008.0 release. First is a bug, reported in glibc-utils package,
  that cause the memusage and xtrace utilities to not run correctly. The
  second is a minor problem with file integrity check when using rpm -V,
  that gives a false positive entry for one packaged file.
  
  This update package fixes these issues.

  Affected Software/OS:
  glibc on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00039.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of glibc");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"glibc", rpm:"glibc~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-devel", rpm:"glibc-devel~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-doc", rpm:"glibc-doc~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-doc-pdf", rpm:"glibc-doc-pdf~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-i18ndata", rpm:"glibc-i18ndata~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-profile", rpm:"glibc-profile~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-static-devel", rpm:"glibc-static-devel~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glibc-utils", rpm:"glibc-utils~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.6.1~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}