###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for initscripts MDKA-2007:037 (initscripts)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830048);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:037");
  script_cve_id("");
  script_name(english: "Mandriva Update for initscripts MDKA-2007:037 (initscripts)");
  desc["english"] = "

  Vulnerability Insight:

  The text message printed over the bootsplash image was always displayed
  in English during shutdown or reboot, never being translated using the
  system's locale settings.  This update package resolves the problem.

  Affected Software/OS:
  initscripts on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of initscripts");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"initscripts", rpm:"initscripts~8.51~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}