###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_ftp_clnt_xss_vuln_win.nasl 387 2008-10-24 12:17:20Z oct $
#
# Firefox Web Browser FTP Client XSS Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800042);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4723");
  script_bugtraq_id(31855);
  script_name(english:"Firefox Web Browser FTP Client XSS Vulnerability (Win)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to Cross Site Scripting (XSS) Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the way browser handles web script or html via
  ftp://URL for an html document within a JPG, PDF, or TXT files.

  Impact: Successful remote attack result in injection of arbitrary web
  script or HTML code.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.0.1 to 3.0.3 on Windows.

  Fix: No solution/patch is available as on 24th October, 2008. Information
  regarding this issue will be updated once the solution details are available.

  References:
  http://www.securityfocus.com/bid/31855/exploit
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4723

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.2
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("gb_firefox_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

# Grep for firefox version 3.0.1 to 3.0.3
if(version_in_range(version:get_kb_item("Firefox/Win/Ver"),
                    test_version:"3.0.1", test_version2:"3.0.3")){
  security_hole(0);
}
