###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ffftp_list_cmd_dir_traversal.nasl 837 2009-03-11 12:22:39Z mar $
#
# FFFTP LIST Command Directory Traversal Vulnerability.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800533);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6424");
  script_bugtraq_id(29459);
  script_name(english:"FFFTP LIST Command Directory Traversal Vulnerability");
  desc["english"] = "

  Overview: This host is installed with FFFTP Client and is prone to directory
  traversal vulnerability.

  Vulnerability Insight:
  The flaw is caused due to input validation error when processing FTP
  responses to a LIST command with a filename and is followed by ../ (dot dot
  forward-slash).

  Impact:
  Successful exploitation will allow remote attackers to create or overwrite
  arbitrary files on a vulnerable system by tricking a user into downloading
  a directory containing files.

  Impact Level: System

  Affected Software/OS:
  FFFTP version 1.96b and prior on Windows.

  Fix: Upgrade to version 1.96d or later from,
  http://www2.biglobe.ne.jp/~sota/ffftp-e.html

  References:
  http://secunia.com/advisories/30428/
  http://www.vupen.com/english/advisories/2008/1708/references

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:N/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of FFFTP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"FTP");
  script_dependencies("gb_ffftp_detect.nasl");
  script_require_keys("FFFTP/Ver");
  exit(0);
}


include("version_func.inc");

ffftpVer = get_kb_item("FFFTP/Ver");
if(!ffftpVer){
  exit(0);
}

# Check for FFFTP Version 1.96b (1.96.2.0)
if(version_is_less_equal(version:ffftpVer, test_version:"1.96.2.0")){
  security_hole(0);
}
