###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cairo-dock FEDORA-2008-11551
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860385);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-11551");
  script_cve_id("CVE-2008-5500", "CVE-2008-5508", "CVE-2008-5513", "CVE-2008-5503", "CVE-2008-5504", "CVE-2008-5506", "CVE-2008-5511", "CVE-2008-5507", "CVE-2008-5510", "CVE-2008-5512");
  script_name(english: "Fedora Update for cairo-dock FEDORA-2008-11551");
  desc["english"] = "

  Vulnerability Insight:
  An light eye-candy fully themable animated dock for any
  Linux desktop. It has a family-likeness with OSX dock,
  but with more options.


  Affected Software/OS:
  cairo-dock on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg01115.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cairo-dock");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"cairo-dock", rpm:"cairo-dock~1.6.3.1~1.fc8.2", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}