###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for freetype FEDORA-2007-561
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861389);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-561");
  script_cve_id("");
  script_name(english: "Fedora Update for freetype FEDORA-2007-561");
  desc["english"] = "

  Vulnerability Insight:
  The FreeType engine is a free and portable font rendering
  engine, developed to provide advanced font support for a variety of
  platforms and environments. FreeType is a library which can open and
  manages font files as well as efficiently load, hint and render
  individual glyphs. FreeType is not a font server or a complete
  text-rendering library.


  Affected Software/OS:
  freetype on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00406.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of freetype");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"freetype", rpm:"freetype~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/freetype", rpm:"x86_64/freetype~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/freetype-demos", rpm:"x86_64/freetype-demos~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/freetype-debuginfo", rpm:"x86_64/debug/freetype-debuginfo~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/freetype-devel", rpm:"x86_64/freetype-devel~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/freetype-demos", rpm:"i386/freetype-demos~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/freetype-debuginfo", rpm:"i386/debug/freetype-debuginfo~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/freetype", rpm:"i386/freetype~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/freetype-devel", rpm:"i386/freetype-devel~2.2.1~17.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}