###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for vim FEDORA-2007-492
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861202);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-492");
  script_cve_id("");
  script_name(english: "Fedora Update for vim FEDORA-2007-492");
  desc["english"] = "

  Vulnerability Insight:
  VIM (VIsual editor iMproved) is an updated and improved version of the
  vi editor.  Vi was the first real screen-based editor for UNIX, and is
  still very popular.  VIM improves on vi by adding new features:
  multiple windows, multi-level undo, block highlighting and more.


  Affected Software/OS:
  vim on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00011.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of vim");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"vim", rpm:"vim~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/vim-debuginfo", rpm:"x86_64/debug/vim-debuginfo~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/vim-minimal", rpm:"x86_64/vim-minimal~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/vim-enhanced", rpm:"x86_64/vim-enhanced~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/vim-common", rpm:"x86_64/vim-common~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/vim-X11", rpm:"x86_64/vim-X11~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/vim-minimal", rpm:"i386/vim-minimal~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/vim-common", rpm:"i386/vim-common~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/vim-enhanced", rpm:"i386/vim-enhanced~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/vim-X11", rpm:"i386/vim-X11~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/vim-debuginfo", rpm:"i386/debug/vim-debuginfo~7.0.235~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}