###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for qt FEDORA-2007-2216
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861158);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2216");
  script_cve_id("CVE-2007-4137", "CVE-2007-3388");
  script_name(english: "Fedora Update for qt FEDORA-2007-2216");
  desc["english"] = "

  Vulnerability Insight:
  Qt is a GUI software toolkit which simplifies the task of writing and
  maintaining GUI (Graphical User Interface) applications
  for the X Window System.
  
  Qt is written in C++ and is fully object-oriented.
  
  This package contains the shared library needed to run qt
  applications, as well as the README files for qt.


  Affected Software/OS:
  qt on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00322.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of qt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"qt", rpm:"qt~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-debuginfo", rpm:"qt-debuginfo~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-devel", rpm:"qt-devel~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-PostgreSQL", rpm:"qt-PostgreSQL~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-designer", rpm:"qt-designer~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt", rpm:"qt~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-ODBC", rpm:"qt-ODBC~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-config", rpm:"qt-config~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-devel-docs", rpm:"qt-devel-docs~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-MySQL", rpm:"qt-MySQL~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-sqlite", rpm:"qt-sqlite~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-config", rpm:"qt-config~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-PostgreSQL", rpm:"qt-PostgreSQL~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-ODBC", rpm:"qt-ODBC~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-MySQL", rpm:"qt-MySQL~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-debuginfo", rpm:"qt-debuginfo~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-devel-docs", rpm:"qt-devel-docs~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-devel", rpm:"qt-devel~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-sqlite", rpm:"qt-sqlite~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt-designer", rpm:"qt-designer~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt", rpm:"qt~3.3.8~7.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}