###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tor FEDORA-2007-1674
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861562);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-1674");
  script_cve_id("CVE-2007-3165", "CVE-2007-4174");
  script_name(english: "Fedora Update for tor FEDORA-2007-1674");
  desc["english"] = "

  Vulnerability Insight:
  Tor is a connection-based low-latency anonymous communication system.
  
  Applications connect to the local Tor proxy using the SOCKS protocol. The
  local proxy chooses a path through a set of relays, in which each relay
  knows its predecessor and successor, but no others. Traffic flowing down
  the circuit is unwrapped by a symmetric key at each relay, which reveals
  the downstream relay.
  
  Warnings: Tor does no protocol cleaning.  That means there is a danger
  that application protocols and associated programs can be induced to
  reveal information about the initiator. Tor depends on Privoxy and
  similar protocol cleaners to solve this problem. This is alpha code,
  and is even more likely than released code to have anonymity-spoiling
  bugs. The present network is very small -- this further reduces the
  strength of the anonymity provided. Tor is not presently suitable for
  high-stakes anonymity.


  Affected Software/OS:
  tor on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00286.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tor");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"tor", rpm:"tor~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-core", rpm:"tor-core~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-debuginfo", rpm:"tor-debuginfo~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor", rpm:"tor~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-lsb", rpm:"tor-lsb~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor", rpm:"tor~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-debuginfo", rpm:"tor-debuginfo~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-lsb", rpm:"tor-lsb~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tor-core", rpm:"tor-core~0.1.2.16~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}