###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for jasper FEDORA-2007-0001
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861067);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-0001");
  script_cve_id("CVE-2007-2721");
  script_name(english: "Fedora Update for jasper FEDORA-2007-0001");
  desc["english"] = "

  Vulnerability Insight:
  This package contains an implementation of the image compression
  standard JPEG-2000, Part 1. It consists of tools for conversion to and
  from the JP2 and JPC formats.


  Affected Software/OS:
  jasper on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00077.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of jasper");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper-devel", rpm:"jasper-devel~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper-debuginfo", rpm:"jasper-debuginfo~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper-debuginfo", rpm:"jasper-debuginfo~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper-devel", rpm:"jasper-devel~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.900.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}