###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for firefox RHSA-2008:0978-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870076);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0978-01");
  script_cve_id("CVE-2008-0017", "CVE-2008-5014", "CVE-2008-5015", "CVE-2008-5016", "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-5019", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5023", "CVE-2008-5024");
  script_name(english: "RedHat Update for firefox RHSA-2008:0978-01");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Firefox is an open source Web browser.
  
  Several flaws were found in the processing of malformed web content. A web
  page containing malicious content could cause Firefox to crash or,
  potentially, execute arbitrary code as the user running Firefox.
  (CVE-2008-0017, CVE-2008-5014, CVE-2008-5016, CVE-2008-5017,
  CVE-2008-5018, CVE-2008-5019, CVE-2008-5021)
  
  Several flaws were found in the way malformed content was processed. A web
  site containing specially-crafted content could potentially trick a Firefox
  user into surrendering sensitive information. (CVE-2008-5022,
  CVE-2008-5023, CVE-2008-5024)
  
  A flaw was found in the way Firefox opened &quot;file:&quot; URIs. If a file: URI was
  loaded in the same tab as a chrome or privileged &quot;about:&quot; page, the file:
  URI could execute arbitrary code with the permissions of the user running
  Firefox. (CVE-2008-5015)
  
  For technical details regarding these flaws, please see the Mozilla
  security advisories for Firefox 3.0.4. You can find a link to the Mozilla
  advisories in the References section.
  
  All firefox users should upgrade to these updated packages, which contain
  backported patches that correct these issues.


  Affected Software/OS:
  firefox on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-November/msg00008.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"devhelp", rpm:"devhelp~0.12~20.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-debuginfo", rpm:"devhelp-debuginfo~0.12~20.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-devel", rpm:"devhelp-devel~0.12~20.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.1.1~3.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.1.1~3.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.1.1~3.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-pkcs11-devel", rpm:"nss-pkcs11-devel~3.12.1.1~3.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-tools", rpm:"nss-tools~3.12.1.1~3.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.0.4~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.16.0~22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yelp-debuginfo", rpm:"yelp-debuginfo~2.16.0~22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.4~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.4~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.1.1~3.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.1.1~3.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.1.1~3.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}