###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for enscript CESA-2008:1021 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880214);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:1021");
  script_cve_id("CVE-2008-3863", "CVE-2008-4306", "CVE-2008-5078");
  script_name(english: "CentOS Update for enscript CESA-2008:1021 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  GNU enscript converts ASCII files to PostScript(R) language files and
  spools the generated output to a specified printer or saves it to a file.
  Enscript can be extended to handle different output media and includes
  options for customizing printouts.
  
  Several buffer overflow flaws were found in GNU enscript. An attacker could
  craft an ASCII file in such a way that it could execute arbitrary commands
  if the file was opened with enscript with the &quot;special escapes&quot; option (-e
  or --escapes) enabled. (CVE-2008-3863, CVE-2008-4306, CVE-2008-5078)
  
  All users of enscript should upgrade to these updated packages, which
  contain backported patches to correct these issues.


  Affected Software/OS:
  enscript on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-December/015510.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of enscript");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"enscript", rpm:"enscript~1.6.1~33.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}