###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for lynx CESA-2008:0965 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880125);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0965");
  script_cve_id("CVE-2008-4690", "CVE-2006-7234");
  script_name(english: "CentOS Update for lynx CESA-2008:0965 centos4 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  Lynx is a text-based Web browser.
  
  An arbitrary command execution flaw was found in the Lynx &quot;lynxcgi:&quot; URI
  handler. An attacker could create a web page redirecting to a malicious URL
  that could execute arbitrary code as the user running Lynx in the
  non-default &quot;Advanced&quot; user mode. (CVE-2008-4690)
  
  Note: In these updated lynx packages, Lynx will always prompt users before
  loading a &quot;lynxcgi:&quot; URI. Additionally, the default lynx.cfg configuration
  file now marks all &quot;lynxcgi:&quot; URIs as untrusted by default.
  
  A flaw was found in a way Lynx handled &quot;.mailcap&quot; and &quot;.mime.types&quot;
  configuration files. Files in the browser's current working directory were
  opened before those in the user's home directory. A local attacker, able to
  convince a user to run Lynx in a directory under their control, could
  possibly execute arbitrary commands as the user running Lynx. (CVE-2006-7234)
  
  All users of Lynx are advised to upgrade to this updated package, which
  contains backported patches correcting these issues.


  Affected Software/OS:
  lynx on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-October/015358.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of lynx");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"lynx", rpm:"lynx~2.8.5~18.2.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}