###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for freetype CESA-2008:0556 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880102);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0556");
  script_cve_id("CVE-2008-1806", "CVE-2008-1807", "CVE-2008-1808");
  script_name(english: "CentOS Update for freetype CESA-2008:0556 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  FreeType is a free, high-quality, portable font engine that can open and
  manage font files, as well as efficiently load, hint and render individual
  glyphs.
  
  Multiple flaws were discovered in FreeType's Printer Font Binary (PFB)
  font-file format parser. If a user loaded a carefully crafted font-file
  with a program linked against FreeType, it could cause the application to
  crash, or possibly execute arbitrary code. (CVE-2008-1806, CVE-2008-1807,
  CVE-2008-1808)
  
  Note: the flaw in FreeType's TrueType Font (TTF) font-file format parser,
  covered by CVE-2008-1808, did not affect the freetype packages as shipped
  in Red Hat Enterprise Linux 3, 4, and 5, as they are not compiled with TTF
  Byte Code Interpreter (BCI) support.
  
  Users of freetype should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  freetype on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-June/015007.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of freetype");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"freetype", rpm:"freetype~2.1.4~10.el3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype-devel", rpm:"freetype-devel~2.1.4~10.el3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype-demos", rpm:"freetype-demos~2.1.4~10.el3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype-utils", rpm:"freetype-utils~2.1.4~10.el3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}