###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for bind CESA-2008:0533 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880259);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0533");
  script_cve_id("CVE-2008-1447");
  script_name(english: "CentOS Update for bind CESA-2008:0533 centos4 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  ISC BIND (Berkeley Internet Name Domain) is an implementation of the DNS
  (Domain Name System) protocols.
  
  The DNS protocol protects against spoofing attacks by requiring an attacker
  to predict both the DNS transaction ID and UDP source port of a request. In
  recent years, a number of papers have found problems with DNS
  implementations which make it easier for an attacker to perform DNS
  cache-poisoning attacks.
  
  Previous versions of BIND did not use randomized UDP source ports. If an
  attacker was able to predict the random DNS transaction ID, this could make
  DNS cache-poisoning attacks easier. In order to provide more resilience,
  BIND has been updated to use a range of random UDP source ports.
  (CVE-2008-1447)
  
  Note: This errata also updates SELinux policy on Red Hat Enterprise Linux 4
  and 5 to allow BIND to use random UDP source ports.
  
  Users of BIND are advised to upgrade to these updated packages, which
  contain a backported patch to add this functionality.
  
  Red Hat would like to thank Dan Kaminsky for reporting this issue.


  Affected Software/OS:
  bind on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-July/015081.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.4~28.0.1.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.2.4~28.0.1.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.4~28.0.1.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.2.4~28.0.1.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.4~28.0.1.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"selinux-policy-targeted", rpm:"selinux-policy-targeted~1.17.30~2.150.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"selinux-policy-targeted-sources", rpm:"selinux-policy-targeted-sources~1.17.30~2.150.el4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}