#
#VID baece347-c489-11dd-a721-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID baece347-c489-11dd-a721-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62851);
 script_cve_id("CVE-2008-5285");
 script_version ("$");
 name["english"] = "wireshark -- SMTP Processing Denial of Service Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   wireshark
   wireshark-lite
   ethereal
   ethereal-lite
   tethereal
   tethereal-lite

CVE-2008-5285
Wireshark 1.0.4 and earlier allows remote attackers to cause a denial
of service via a long SMTP request, which triggers an infinite loop.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/32840/
http://lists.grok.org.uk/pipermail/full-disclosure/2008-November/065840.html
http://www.vuxml.org/freebsd/baece347-c489-11dd-a721-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "wireshark -- SMTP Processing Denial of Service Vulnerability";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wireshark");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package wireshark version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wireshark-lite");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package wireshark-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package ethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package ethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package tethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4_1")<0) {
    security_note(0, data:"Package tethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
