#
#VID abcacb5a-e7f1-11dd-afcd-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID abcacb5a-e7f1-11dd-afcd-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63280);
 script_cve_id("CVE-2008-3651", "CVE-2008-3652");
 script_bugtraq_id(30657);
 script_version ("$");
 name["english"] = "FreeBSD Ports: ipsec-tools";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: ipsec-tools

CVE-2008-3651
Memory leak in racoon/proposal.c in the racoon daemon in ipsec-tools
before 0.7.1 allows remote authenticated users to cause a denial of
service (memory consumption) via invalid proposals.

CVE-2008-3652
src/racoon/handler.c in racoon in ipsec-tools does not remove an
'orphaned ph1' (phase 1) handle when it has been initiated remotely,
which allows remote attackers to cause a denial of service (resource
consumption).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.info/?l=ipsec-tools-devel&m=121688914101709&w=2
http://www.vuxml.org/freebsd/abcacb5a-e7f1-11dd-afcd-00e0815b8da8.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ipsec-tools";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ipsec-tools");
if(!isnull(bver) && revcomp(a:bver, b:"0.7.1")<0) {
    security_note(0, data:"Package ipsec-tools version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
