#
#VID e480ccb2-6bc8-11d9-8dbe-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52218);
 script_cve_id("CVE-2004-1030", "CVE-2004-1031", "CVE-2004-1032", "CVE-2004-1033");
 script_version ("$");
 name["english"] = "FreeBSD Ports: fcron";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: fcron

CVE-2004-1030
fcronsighup in Fcron 2.0.1, 2.9.4, and possibly earlier versions
allows local users to gain sensitive information by calling
fcronsighup with an arbitrary file, which reveals the contents of the
file that can not be parsed in an error message.

CVE-2004-1031
fcronsighup in Fcron 2.0.1, 2.9.4, and possibly earlier versions
allows local users to bypass access restrictions and load an arbitrary
configuration file by starting an suid process and pointing the
fcronsighup configuration file to a /proc entry that is owned by root
but modifiable by the user, such as /proc/self/cmdline or
/proc/self/environ.

CVE-2004-1032
fcronsighup in Fcron 2.0.1, 2.9.4, and possibly earlier versions
allows local users to delete arbitrary files or create arbitrary empty
files via a target filename with a large number of leading slash (/)
characters such that fcronsighup does not properly append the intended
fcrontab.sig to the resulting string.

CVE-2004-1033
Fcron 2.0.1, 2.9.4, and possibly earlier versions leak file
descriptors of open files, which allows local users to bypass access
restrictions and read fcron.allow and fcron.deny via the EDITOR
environment variable.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.idefense.com/application/poi/display?id=157&type=vulnerabilities&flashstatus=false
http://www.vuxml.org/freebsd/e480ccb2-6bc8-11d9-8dbe-000a95bc6fae.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: fcron";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"fcron");
if(!isnull(bver) && revcomp(a:bver, b:"2.9.5.1")<0) {
    security_note(0, data:"Package fcron version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
