# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3426 (java-1.6.0-openjdk)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63776);
 script_cve_id("CVE-2009-0794", "CVE-2009-0793");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3426 (java-1.6.0-openjdk)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to java-1.6.0-openjdk
announced via advisory FEDORA-2009-3426.

Update Information:

Fixes remaining LCMS issue, which resolves a TCK failure
ChangeLog:

* Mon Apr  6 2009 Lillian Angel  - 1:1.6.0-15.b14
- Updated java-1.6.0-openjdk-lcms.patch
* Thu Apr  2 2009 Lillian Angel  - 1:1.6.0-14.b14
- Added java-1.6.0-openjdk-pulsejava.patch.
- Updated release.
- Updated java-1.6.0-openjdk-lcms.patch.
- Resolves: rhbz#492367
- Resolves: rhbz#493276

References:

[ 1 ] Bug #492367 - CVE-2009-0794 pulse-java integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=492367
[ 2 ] Bug #492353 - CVE-2009-0793 lcms: Null pointer dereference (DoS) by handling transformations of monochrome profiles
https://bugzilla.redhat.com/show_bug.cgi?id=492353

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update java-1.6.0-openjdk' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3426

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3426 (java-1.6.0-openjdk)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~1.6.0.0~15.b14.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~demo~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~devel~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~javadoc~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~plugin~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~src~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~debuginfo~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
