# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1225 (gpsdrive)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63326);
 script_cve_id("CVE-2008-4959", "CVE-2008-5380", "CVE-2008-5703");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-1225 (gpsdrive)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gpsdrive
announced via advisory FEDORA-2009-1225.

Gpsdrive is a map-based navigation system.
It displays your position on a zoomable map
provided from a NMEA-capable GPS receiver. The maps are autoselected
for the best resolution, depending of your position, and the displayed
image can be zoomed. Maps can be downloaded from the Internet with one
mouse click. The program provides information about speed, direction,
bearing, arrival time, actual position, and target position.
Speech output is also available. MySQL is supported.

Update Information:

This update removes several helper scripts: geo-code, geo-nearest, and
gpssmswatch, which have been removed upstream due to security issues. This
update also has a fix for an issue with the splash screen.
ChangeLog:

* Mon Feb  2 2009 Kevin Fenzi  - 2.09-7
- fix for CVE-2008-4959 - bug 470241
- fix for CVE-2008-5380 - bug 475478
- fix for CVE-2008-5703 - bug 481702

References:

[ 1 ] Bug #470241 - CVE-2008-4959 gpsdrive: geo-code insecure temporary file use
https://bugzilla.redhat.com/show_bug.cgi?id=470241
[ 2 ] Bug #475478 - CVE-2008-5380 gpsdrive: Insecure temporary file use in geo-code, geo-nearest (symlink attack)
https://bugzilla.redhat.com/show_bug.cgi?id=475478
[ 3 ] Bug #481702 - CVE-2008-5703 gpsdrive: insecure temporary file use in gpssmswatch and splash.c
https://bugzilla.redhat.com/show_bug.cgi?id=481702

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gpsdrive' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1225

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-1225 (gpsdrive)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gpsdrive", rpm:"gpsdrive~2.09~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpsdrive-debuginfo", rpm:"gpsdrive-debuginfo~2.09~7.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
