# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0543 (tqsllib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63214);
 script_cve_id("CVE-2008-5077");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-0543 (tqsllib)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tqsllib
announced via advisory FEDORA-2009-0543.

Update Information:

The TrustedQSL library incorrectly checked the result after  calling the
EVP_VerifyFinal function, allowing a malformed signature to be treated as a good
signature rather than as an error. Package includes a patch to fix
EVP_VerifyFinal result check.

ChangeLog:

* Mon Jan 12 2009 Lucian Langa  - 2.0-5
- modify patch0 to include fix for #479650 (CVE-2008-5077 related)

References:

[ 1 ] Bug #479650 - tqsllib: OpenSSL incorrect checks for malformed signatures
https://bugzilla.redhat.com/show_bug.cgi?id=479650

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update tqsllib' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0543

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-0543 (tqsllib)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"tqsllib", rpm:"tqsllib~2.0~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tqsllib-devel", rpm:"tqsllib-devel~2.0~5.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tqsllib-debuginfo", rpm:"tqsllib-debuginfo~2.0~5.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
