# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 850-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55603);
 script_bugtraq_id(13389, 13380);
 script_cve_id("CVE-2005-1279");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 850-1 (tcpdump)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tcpdump
announced via advisory DSA 850-1.

Vade 79 discovered that the BGP dissector in tcpdump, a powerful
tool for network monitoring and data acquisition, does not properly
handle RT_ROUTING_INFO.  A specially crafted BGP packet can cause a
denial of service via an infinite loop.

For the old stable distribution (woody) this problem has been fixed in
version 3.6.2-2.9.

For the stable distribution (sarge) this problem has been fixed in
version 3.8.3-4.

For the unstable distribution (sid) this problem has been fixed in
version 3.8.3-4.

We recommend that you upgrade your tcpdump package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20850-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 850-1 (tcpdump)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tcpdump", ver:"3.6.2-2.9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
