# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 764-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54411);
 script_cve_id("CVE-2005-1524", "CVE-2005-1525", "CVE-2005-1526", "CVE-2005-2148", "CVE-2005-2149");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 764-1 (cacti)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cacti
announced via advisory DSA 764-1.

Several vulnerabilities have been discovered in cacti, a round-robin
database (RRD) tool that helps create graphs from database
information.  The Common Vulnerabilities and Exposures Project
identifies the following problems:

CVE-2005-1524

Maciej Piotr Falkiewicz and an anonymous researcher discovered an
input validation bug that allows an attacker to include arbitrary
PHP code from remote sites which will allow the execution of
arbitrary code on the server running cacti.

CVE-2005-1525

Due to mising input validation cacti allows a remote attacker to
insert arbitrary SQL statements.

CVE-2005-1526

Maciej Piotr Falkiewicz discovered an input validation bug that
allows an attacker to include arbitrary PHP code from remote sites
which will allow the execution of arbitrary code on the server
running cacti.

CVE-2005-2148

Stefan Esser discovered that the update for the abovely mentioned
vulnerabilities does not perform proper input validation to
protect against common attacks.

CVE-2005-2149

Stefan Esser discovered that the update for CVE-2005-1525 allows
remote attackers to modify session information to gain privileges
and disable the use of addslashes to protect against SQL
injection.

For the old stable distribution (woody) these problems have been fixed in
version 0.6.7-2.5.

For the stable distribution (sarge) these problems have been fixed in
version 0.8.6c-7sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 0.8.6e-1.

We recommend that you upgrade your cacti package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20764-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 764-1 (cacti)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cacti", ver:"0.6.7-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cacti", ver:"0.8.6c-7sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
