# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 508-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53198);
 script_bugtraq_id(10403);
 script_cve_id("CVE-2004-0402");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 508-1 (xpcd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xpcd
announced via advisory DSA 508-1.

Jaguar discovered a vulnerability in one component of xpcd, a PhotoCD
viewer.  xpcd-svga, part of xpcd which uses svgalib to display
graphics on the console, would copy user-supplied data of arbitrary
length into a fixed-size buffer in the pcd_open function.

For the current stable distribution (woody) this problem has been
fixed in version 2.08-8woody2.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your xpcd package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20508-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 508-1 (xpcd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpcd", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpcd-gimp", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpcd-svga", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
