# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 434-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53132);
 script_cve_id("CVE-2004-0005", "CVE-2004-0006", "CVE-2004-0007", "CVE-2004-0008");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 434-1 (gaim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gaim
announced via advisory DSA 434-1.

Stefan Esser discovered several security related problems in Gaim, a
multi-protocol instant messaging client.  Not all of them are
applicable for the version in Debian stable, but affected the version
in the unstable distribution at least.  The problems were grouped for
the Common Vulnerabilities and Exposures as follows:

CVE-2004-0005

When the Yahoo Messenger handler decodes an octal value for email
notification functions two different kinds of overflows can be
triggered.  When the MIME decoder decoded a quoted printable
encoded string for email notification two other different kinds of
overflows can be triggered.  These problems only affect the
version in the unstable distribution.

CVE-2004-0006

When parsing the cookies within the HTTP reply header of a Yahoo
web connection a buffer overflow can happen.  When parsing the
Yahoo Login Webpage the YMSG protocol overflows stack buffers if
the web page returns oversized values.  When splitting an URL into
its parts a stack overflow can be caused.  These problems only
affect the version in the unstable distribution

When an oversized keyname is read from a Yahoo Messenger packet a
stack overflow can be triggered.  When Gaim is setup to use a HTTP
proxy for connecting to the server a malicious HTTP proxy can
exploit it.  These problems affect all versions Debian ships.
However, the connection to Yahoo doesn't work in the version in
Debian stable.

CVE-2004-0007

Internally data is copied between two tokens into a fixed size
stack buffer without a size check.  This only affects the version
of gaim in the unstable distribution

CVE-2004-0008

When allocating memory for AIM/Oscar DirectIM packets an integer
overflow can happen, resulting in a heap overflow.  This only
affects the version of gaim in the unstable distribution

For the stable distribution (woody) this problem has been fixed in
version 0.58-2.4.

For the unstable distribution (sid) this problem has been fixed in
version 0.75-2.

We recommend that you upgrade your gaim packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20434-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 434-1 (gaim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gaim", ver:"0.58-2.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-common", ver:"0.58-2.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-gnome", ver:"0.58-2.4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
