# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 228-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53310);
 script_cve_id("CVE-2003-0031", "CVE-2003-0032");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 228-1 (libmcrypt)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libmcrypt
announced via advisory DSA 228-1.

Ilia Alshanetsky discovered several buffer overflows in libmcrypt, a
decryption and encryption library, that originates in from improper or
lacking input validation.  By passing input which is longer then
expected to a number of functions (multiple functions are affected)
the user can successful make libmcrypt crash and may be able to insert
arbitrary, malicious, code which will be executed under the user
libmcrypt runs as, e.g. inside a web server.

Another vulnerability exists in the way libmcrypt loads algorithms via
libtool.  When different algorithms are loaded dynamically, each time
an algorithm is loaded a small part of memory is leaked.  In a
persistant enviroment (web server) this could lead to a memory
exhaustion attack that will exhaust all avaliable memory by launching
repeated requests at an application utilizing the mcrypt library.

For the current stable distribution (woody) this problem has been
fixed in version 2.5.0-1woody1.

The old stable distribution (potato) does not contain libmcrypt packages.

For the unstable distribution (sid) these problems have been fixed in
version 2.5.5-1.

We recommend that you upgrade your libmcrypt packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20228-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 228-1 (libmcrypt)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmcrypt-dev", ver:"2.5.0-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmcrypt4", ver:"2.5.0-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
