# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1803-1 (nsd, nsd3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64035);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1803-1 (nsd, nsd3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to nsd, nsd3
announced via advisory DSA 1803-1.

Ilja van Sprundel discovered that a buffer overflow in NSD, an authoritative
name service daemon, allowed to crash the server by sending a crafted packet,
creating a denial of service.

For the old stable distribution (etch), this problem has been fixed in
version 2.3.6-1+etch1 of the nsd package.

For the stable distribution (lenny), this problem has been fixed in
version 2.3.7-1.1+lenny1 of the nsd package and version 3.0.7-3.lenny2
of the nsd3 package.

For the unstable distribution (sid), this problem has been fixed in
version 2.3.7-3 for nsd; nsd3 will be fixed soon.

We recommend that you upgrade your nsd or nsd3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201803-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1803-1 (nsd, nsd3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nsd", ver:"2.3.6-1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nsd3", ver:"3.0.7-3.lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nsd", ver:"2.3.7-1.1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
