# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1725-1 (websvn)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63571);
 script_cve_id("CVE-2009-0240");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1725-1 (websvn)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to websvn
announced via advisory DSA 1725-1.

Bas van Schaik discovered that WebSVN, a tool to view Subversion
repositories over the web, did not properly restrict access to private
repositories, allowing a remote attacker to read significant parts of
their content.

The old stable distribution (etch) is not affected by this problem.

For the stable distribution (lenny), this problem has been fixed in
version 2.0-4+lenny1.

For the unstable distribution (sid), this problem has also been fixed in
version 2.0-4+lenny1.

We recommend that you upgrade your websvn package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201725-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1725-1 (websvn)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"websvn", ver:"2.0-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
