# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1648-1 (mon)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61713);
 script_cve_id("CVE-2008-4477");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1648-1 (mon)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mon
announced via advisory DSA 1648-1.

Dmitry E. Oboukhov discovered that the test.alert script used in one of the
alert functions in mon, a system to monitor hosts or services and alert
about problems, creates temporary files insecurely, which may lead to a local
denial of service through symlink attacks.

For the stable distribution (etch), this problem has been fixed in
version 0.99.2-9+etch2.

For the testing (lenny) and unstable distribution (sid), this problem has
been fixed in version 0.99.2-13.

We recommend that you upgrade your mon package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201648-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1648-1 (mon)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mon", ver:"0.99.2-9+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
