# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1612-1 (ruby1.8)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61362);
 script_cve_id("CVE-2008-2662", "CVE-2008-2663", "CVE-2008-2664", "CVE-2008-2725", "CVE-2008-2726", "CVE-2008-2376", "CVE-2006-2662");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1612-1 (ruby1.8)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ruby1.8
announced via advisory DSA 1612-1.

Several vulnerabilities have been discovered in the interpreter for
the Ruby language, which may lead to denial of service or the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2006-2662

Drew Yao discovered that multiple integer overflows in the string
processing code may lead to denial of service and potentially the
execution of arbitrary code.

CVE-2008-2663

Drew Yao discovered that multiple integer overflows in the string
processing code may lead to denial of service and potentially the
execution of arbitrary code.

CVE-2008-2664

Drew Yao discovered that a programming error in the string
processing code may lead to denial of service and potentially the
execution of arbitrary code.

CVE-2008-2725

Drew Yao discovered that an integer overflow in the array handling
code may lead to denial of service and potentially the execution
of arbitrary code.

CVE-2008-2726

Drew Yao discovered that an integer overflow in the array handling
code may lead to denial of service and potentially the execution
of arbitrary code.

CVE-2008-2376

It was discovered that an integer overflow in the array handling
code may lead to denial of service and potentially the execution
of arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 1.8.5-4etch2.

For the unstable distribution (sid), these problems have been fixed in
version 1.8.7.22-2.

We recommend that you upgrade your ruby1.8 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201612-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1612-1 (ruby1.8)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.5-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
