# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 157-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53728);
 script_cve_id("CVE-2002-0983");
 script_bugtraq_id(5055);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 157-1 (irssi-text)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to irssi-text
announced via advisory DSA 157-1.

The IRC client irssi is vulnerable to a denial of service condition.
The problem occurs when a user attempts to join a channel that has an
overly long topic description.  When a certain string is appended to
the topic, irssi will crash.

This problem has been fixed in version 0.8.4-3.1 for the current
stable stable distribution (woody) and in version 0.8.5-2 for the
unstable distribution (sid).  The old stable distribution (potato) is
not affected, since the corresponding portions of code are not
present.  The same applies to irssi-gnome and irssi-gtk, which don't
seem to be affected as well.

We recommend that you upgrade your irssi-text package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20157-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 157-1 (irssi-text)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"irssi-text", ver:"0.8.4-3.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
