# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1504-1 (kernel-source-2.6.8 (2.6.8-17sarge1))
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60438);
 script_cve_id("CVE-2006-5823", "CVE-2006-6054", "CVE-2006-6058", "CVE-2006-7203", "CVE-2007-1353", "CVE-2007-2172", "CVE-2007-2525", "CVE-2007-3105", "CVE-2007-3739", "CVE-2007-3740", "CVE-2007-3848", "CVE-2007-4133", "CVE-2007-4308", "CVE-2007-4573", "CVE-2007-5093", "CVE-2007-6063", "CVE-2007-6151", "CVE-2007-6206", "CVE-2007-6694", "CVE-2008-0007");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1504-1 (kernel-source-2.6.8 (2.6.8-17sarge1))";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kernel-source-2.6.8 (2.6.8-17sarge1)
announced via advisory DSA 1504-1.

Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code. For details, please visit the referenced security advisories.

The following matrix lists additional packages that were rebuilt for
compatibility with or to take advantage of this update:

Debian 3.1 (sarge)
kernel-image-2.6.8-alpha    2.6.8-17sarge1
kernel-image-2.6.8-amd64    2.6.8-17sarge1
kernel-image-2.6.8-hppa     2.6.8-7sarge1
kernel-image-2.6.8-i386     2.6.8-17sarge1
kernel-image-2.6.8-ia64     2.6.8-15sarge1
kernel-image-2.6.8-m68k     2.6.8-5sarge1
kernel-image-2.6.8-s390     2.6.8-6sarge1
kernel-image-2.6.8-sparc    2.6.8-16sarge1
kernel-patch-powerpc-2.6.8  2.6.8-13sarge1
fai-kernels                 1.9.1sarge8

We recommend that you upgrade your kernel package immediately and reboot

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201504-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1504-1 (kernel-source-2.6.8 (2.6.8-17sarge1))";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-source-2.6.8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-2.6.8-s390", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-tree-2.6.8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-doc-2.6.8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-debian-2.6.8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-generic", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-generic", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13-em64t-p4-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13-em64t-p4", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-13-amd64-generic", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13-amd64-generic", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-13-amd64-k8-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-13-em64t-p4-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-13-amd64-k8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13-amd64-k8-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-13-amd64-k8", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-13-em64t-p4", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-64", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-64-smp", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-64-smp", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-32-smp", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-32-smp", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-32", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-32", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-64", ver:"2.6.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-k7-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-386", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-686", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-686-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-k7-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-386", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-k7", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-686-smp", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-686", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fai-kernels", ver:"1.9.1sarge8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-k7", ver:"2.6.8-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-itanium", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-itanium-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-mckinley-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-mckinley", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-mckinley", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-mckinley-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-itanium", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-itanium", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-mckinley", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6-itanium-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-mckinley", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-mckinley-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-itanium-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-itanium", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-mckinley-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6-itanium-smp", ver:"2.6.8-15sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-sun3", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mvme16x", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-q40", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-amiga", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-hp", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mac", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-mvme147", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-bvme6000", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-atari", ver:"2.6.8-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-power3-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-power3", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-powerpc-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-power4-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-power3", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-powerpc", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-power4-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-powerpc", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-power4", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-powerpc-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4-power3-smp", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-power4", ver:"2.6.8-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-s390x", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-s390", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-s390-tape", ver:"2.6.8-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-sparc64-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-sparc32", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.6.8-4-sparc64", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-sparc32", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-sparc64-smp", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-build-2.6.8-4", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.6.8-4-sparc64", ver:"2.6.8-16sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
