# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1493-1 (sdl-image1.2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60368);
 script_cve_id("CVE-2007-6697", "CVE-2008-0554", "CVE-2008-0544");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1493-1 (sdl-image1.2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to sdl-image1.2
announced via advisory DSA 1493-1.

Several local/remote vulnerabilities have been discovered in the image
loading library for the Simple DirectMedia Layer 1.2. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-6697

Gynvael Coldwind discovered a buffer overflow in GIF image parsing,
which could result in denial of service and potentially the
execution of arbitrary code.

CVE-2008-0544

It was discovered that a buffer overflow in IFF ILBM image parsing
could result in denial of service and potentially the execution of
arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 1.2.5-2etch1.

For the old stable distribution (sarge), these problems have been fixed
in version 1.2.4-1etch1. Due to a copy & paste error etch1 was appended
to the version number instead of sarge1. Since the update is otherwise
technically correct, the update was not rebuild to the buildd network.

We recommend that you upgrade your sdl-image1.2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201493-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1493-1 (sdl-image1.2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsdl-image1.2", ver:"1.2.4-1etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsdl-image1.2-dev", ver:"1.2.4-1etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsdl-image1.2-dev", ver:"1.2.5-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsdl-image1.2", ver:"1.2.5-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
