# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1425-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59959);
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1425-1 (xulrunner)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xulrunner
announced via advisory DSA 1425-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2007-5947

Jesse Ruderman and Petko D. Petkov discovered that the URI handler
for JAR archives allows cross-site scripting.

CVE-2007-5959

Several crashes in the layout engine were discovered, which might
allow the execution of arbitrary code.

CVE-2007-5960

Gregory Fleischer discovered a race condition in the handling of
the window.location property, which might lead to cross-site
request forgery.

The oldstable distribution (sarge) doesn't contain xulrunner.

For the stable distribution (etch) these problems have been fixed in
version 1.8.0.14~pre071019c-0etch1.

For the unstable distribution (sid) these problems have been fixed in
version 1.8.1.11-1.

We recommend that you upgrade your xulrunner packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201425-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1425-1 (xulrunner)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmjs-dev", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul-common", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-dev", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmjs1", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul-dev", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d-dbg", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d-dbg", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d-dbg", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d-dbg", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-gnome-support", ver:"1.8.0.14~pre071019c-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
