# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1406-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58738);
 script_cve_id("CVE-2006-3548", "CVE-2006-3549", "CVE-2006-4256", "CVE-2007-1473", "CVE-2007-1474");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1406-1 (horde3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to horde3
announced via advisory DSA 1406-1.

Several remote vulnerabilities have been discovered in the Horde web
application framework. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-3548

Moritz Naumann discovered that Horde allows remote attackers
to inject arbitrary web script or HTML in the context of a logged
in user (cross site scripting).

This vulnerability applies to oldstable (sarge) only.

CVE-2006-3549

Moritz Naumann discovered that Horde does not properly restrict
its image proxy, allowing remote attackers to use the server as a
proxy.

This vulnerability applies to oldstable (sarge) only.

CVE-2006-4256

Marc Ruef discovered that Horde allows remote attackers to
include web pages from other sites, which could be useful for
phishing attacks.

This vulnerability applies to oldstable (sarge) only.

CVE-2007-1473

Moritz Naumann discovered that Horde allows remote attackers
to inject arbitrary web script or HTML in the context of a logged
in user (cross site scripting).

This vulnerability applies to both stable (etch) and oldstable (sarge).

CVE-2007-1474

iDefense discovered that the cleanup cron script in Horde
allows local users to delete arbitrary files.

This vulnerability applies to oldstable (sarge) only.


For the old stable distribution (sarge) these problems have been fixed in
version 3.0.4-4sarge6.

For the stable distribution (etch) these problems have been fixed in
version 3.1.3-4etch1.

For the unstable distribution (sid) these problems have been fixed in
version 3.1.4-1.

We recommend that you upgrade your horde3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201406-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1406-1 (horde3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde3", ver:"3.0.4-4sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"horde3", ver:"3.1.3-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
