# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1291-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58343);
 script_cve_id("CVE-2007-2446", "CVE-2007-2447");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1291-2 (samba)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to samba
announced via advisory DSA 1291-2.

This update to DSA-1291 covers the old stable version of Debian, 3.1
(sarge).  The current stable distribution, 4.0 (etch) was updated
previously.

Several issues have been identified in Samba, the SMB/CIFS
file- and print-server implementation for GNU/Linux.

CVE-2007-2446
Various bugs in Samba's NDR parsing can allow a user to send specially
crafted MS-RPC requests that will overwrite the heap space with user
defined data.

CVE-2007-2447
Unescaped user input parameters are passed as arguments to /bin/sh
allowing for remote command execution

For the old stable distribution (sarge), these problems have been fixed
in version 3.0.14a-3sarge6

We recommend that you upgrade your samba package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201291-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1291-2 (samba)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-samba", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.14a-3sarge6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
