# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1075-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56807);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1075-1 (awstats)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to awstats
announced via advisory DSA 1075-1.

Hendrik Weimer discovered that awstats can execute arbitrary commands
under the user id the web-server runs when users are allowed to supply
arbitrary configuration files.  Even though, this bug was referenced
in DSA 1058 accidently, it was not fixed yet.

The new default behaviour is not ao accept arbitrary configuration
directories from the user.  This can be overwritten by the
AWSTATS_ENABLE_CONFIG_DIR environment variable when users are to be
trusted.

The old stable distribution (woody) does not seem to be affected by
this problem.

For the stable distribution (sarge) this problem has been fixed in
version 6.4-1sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 6.5-2.

We recommend that you upgrade your awstats package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201075-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1075-1 (awstats)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"awstats", ver:"6.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
