# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 098-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53836);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 098-1 (libgtop)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libgtop
announced via advisory DSA 098-1.

Two different problems where found in libgtop-daemon:

* The laboratory intexxia found a format string problem in the logging
code from libgtop_daemon. There were two logging functions which are
called when authorizing a client which could be exploited by a remote
user.

* Flavio Veloso found a buffer overflow in the function that authorizes
clients

Since libgtop_daemon runs as user nobody both bugs could be used
to gain access as the nobody user to a system running libgtop_daemon.

Both problems have been fixed in version 1.0.6-1.1 and we recommend
you upgrade your libgtop-daemon package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20098-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 098-1 (libgtop)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgtop-daemon", ver:"1.0.6-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtop-dev", ver:"1.0.6-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgtop1", ver:"1.0.6-1.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
