###############################################################################
# OpenVAS Vulnerability Test
# $Id: Yap_Blog_cve_2009_1038.nasl 2943 2009-03-29 15:14:47Z mime $
#
# YAP Multiple SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100087);
 script_bugtraq_id(34274);
 script_cve_id("CVE-2009-1038");
 script_version ("1.0");

 script_name(english:"YAP Multiple SQL Injection Vulnerabilities");
 desc["english"] = "

 Overview:
  YAP is prone to multiple SQL-injection vulnerabilities because it
  fails to sufficiently sanitize user-supplied data before using it in
  an SQL query.

  Exploiting these issues could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  YAP 1.1.1 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34274

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Yap Blog is vulnerable to Multiple SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = make_list("/blog","/yap",cgi_dirs());
foreach d (dir)
{ 
 url = string(d, "/comments.php?image_id=1'");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )continue;

 if( egrep(pattern:"erreur dans la", string: buf) )
   {    
     security_warning(port:port);
     exit(0);
   } 
}
exit(0);
