# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:1060 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64020);
 script_cve_id("CVE-2009-1373", "CVE-2009-1374", "CVE-2009-1375", "CVE-2009-1376", "CVE-2008-2927");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:1060";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to Pidgin announced in
advisory RHSA-2009:1060.

A buffer overflow flaw was found in the way Pidgin initiates file transfers
when using the Extensible Messaging and Presence Protocol (XMPP). If a
Pidgin client initiates a file transfer, and the remote target sends a
malformed response, it could cause Pidgin to crash or, potentially, execute
arbitrary code with the permissions of the user running Pidgin. This flaw
only affects accounts using XMPP, such as Jabber and Google Talk.
(CVE-2009-1373)

A denial of service flaw was found in Pidgin's QQ protocol decryption
handler. When the QQ protocol decrypts packet information, heap data can be
overwritten, possibly causing Pidgin to crash. (CVE-2009-1374)

A flaw was found in the way Pidgin's PurpleCircBuffer object is expanded.
If the buffer is full when more data arrives, the data stored in this
buffer becomes corrupted. This corrupted data could result in confusing or
misleading data being presented to the user, or possibly crash Pidgin.
(CVE-2009-1375)

It was discovered that on 32-bit platforms, the Red Hat Security Advisory
RHSA-2008:0584 provided an incomplete fix for the integer overflow flaw
affecting Pidgin's MSN protocol handler. If a Pidgin client receives a
specially-crafted MSN message, it may be possible to execute arbitrary code
with the permissions of the user running Pidgin. (CVE-2009-1376)

Note: By default, when using an MSN account, only users on your buddy list
can send you messages. This prevents arbitrary MSN users from exploiting
this flaw.

All Pidgin users should upgrade to these updated packages, which contain
backported patches to resolve these issues. Pidgin must be restarted for
this update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-1060.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:1060";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"finch", rpm:"finch~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.5.5~2.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch", rpm:"finch~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.5.5~3.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
