# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0010 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63134);
 script_cve_id("CVE-2008-2379", "CVE-2008-3663");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0010";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0010.

Ivan Markovic discovered a cross-site scripting (XSS) flaw in SquirrelMail
caused by insufficient HTML mail sanitization. A remote attacker could send
a specially-crafted HTML mail or attachment that could cause a user's Web
browser to execute a malicious script in the context of the SquirrelMail
session when that email or attachment was opened by the user.
(CVE-2008-2379)

It was discovered that SquirrelMail allowed cookies over insecure
connections (ie did not restrict cookies to HTTPS connections). An attacker
who controlled the communication channel between a user and the
SquirrelMail server, or who was able to sniff the user's network
communication, could use this flaw to obtain the user's session cookie, if
a user made an HTTP request to the server. (CVE-2008-3663)

Note: After applying this update, all session cookies set for SquirrelMail
sessions started over HTTPS connections will have the secure flag set.
That is, browsers will only send such cookies over an HTTPS connection. If
needed, you can revert to the previous behavior by setting the
configuration option $only_secure_cookies to false in SquirrelMail's
/etc/squirrelmail/config.php configuration file.

Users of squirrelmail should upgrade to this updated package, which
contains backported patches to correct these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0010.html
http://www.redhat.com/security/updates/classification/#moderate
http://www.squirrelmail.org/security/issue/2008-09-28
http://www.squirrelmail.org/security/issue/2008-12-04

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0010";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"squirrelmail", rpm:"squirrelmail~1.4.8~8.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail", rpm:"squirrelmail~1.4.8~5.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail", rpm:"squirrelmail~1.4.8~5.el5_2.2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
