#pragma region Copyright (c) 2014-2017 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#include "TrackData.h"

/** rct2: 0x008A42F4 */
// clang-format off
static constexpr const uint32 _OldSpiralRollerCoasterTrackPaintFunctions[256] = {
    0x008A4ABC, // TRACK_ELEM_FLAT
    0x008A4D0C, // TRACK_ELEM_END_STATION
    0x008A4D1C, // TRACK_ELEM_BEGIN_STATION
    0x008A4D2C, // TRACK_ELEM_MIDDLE_STATION
    0x008A4ACC, // TRACK_ELEM_25_DEG_UP
    0x008A4ADC, // TRACK_ELEM_60_DEG_UP
    0x008A4AEC, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A4AFC, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A4B0C, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A4B1C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A4B2C, // TRACK_ELEM_25_DEG_DOWN
    0x008A4B3C, // TRACK_ELEM_60_DEG_DOWN
    0x008A4B4C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A4B5C, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A4B6C, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A4B7C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A4B8C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A4B9C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A4BAC, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A4BBC, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A4BCC, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A4BDC, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A4BEC, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A4BFC, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A4C0C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A4C1C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A4C2C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A4C3C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A4C4C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A4C5C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A4C6C, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A4C7C, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A4C8C, // TRACK_ELEM_LEFT_BANK
    0x008A4C9C, // TRACK_ELEM_RIGHT_BANK
    0x008A4CAC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A4CBC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A4CCC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A4CDC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A4CEC, // TRACK_ELEM_S_BEND_LEFT
    0x008A4CFC, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008A4D3C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A4D4C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A4D5C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A4D6C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A4D7C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A4D8C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A4D9C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A4DAC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A4DBC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A4DCC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A4DDC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A4DEC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A4DFC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A4E0C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A4E1C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A4E2C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A4E5C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A4E3C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A4E4C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A4E6C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A4E7C, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A50CC, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008A50DC, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008A4E8C, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008A50EC, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008A50FC, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A4EAC, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A4EBC, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A4ECC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A4EDC, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A4EEC, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A4EFC, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A4F0C, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A4F1C, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A4E9C, // TRACK_ELEM_DIAG_FLAT
    0x008A4F4C, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A4FAC, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A4F2C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A4F8C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A4F9C, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A4F3C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A4F7C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A4FDC, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A4F5C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A4FBC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A4FCC, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A4F6C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A500C, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A501C, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A502C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A503C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A506C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A507C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A504C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A505C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A508C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A509C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A50AC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A50BC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A4FEC, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A4FFC, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A531C, // TRACK_ELEM_LEFT_CURVED_LIFT_HILL
    0x008A532C, // TRACK_ELEM_RIGHT_CURVED_LIFT_HILL
    0,
    0,
    0,
    0,
    0,
    0x008A530C, // TRACK_ELEM_BLOCK_BRAKES
    0x008A510C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A511C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A512C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A513C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A514C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A515C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A516C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A517C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A518C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008A519C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008A51AC, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A51BC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A51CC, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A51DC, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A51EC, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A51FC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A520C, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A521C, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A524C, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008A525C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008A526C, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A527C, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A522C, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008A523C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008A528C, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A529C, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A52AC, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008A52BC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008A52CC, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A52DC, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A52EC, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A52FC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A6DB0 */
static constexpr const uint32 _OldStandUpRollerCoasterTrackPaintFunctions[256] = {
    0x008A7114, // TRACK_ELEM_FLAT
    0x008A7384, // TRACK_ELEM_END_STATION
    0x008A7394, // TRACK_ELEM_BEGIN_STATION
    0x008A73A4, // TRACK_ELEM_MIDDLE_STATION
    0x008A7124, // TRACK_ELEM_25_DEG_UP
    0x008A7134, // TRACK_ELEM_60_DEG_UP
    0x008A7144, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A7154, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A7164, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A7174, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A7184, // TRACK_ELEM_25_DEG_DOWN
    0x008A7194, // TRACK_ELEM_60_DEG_DOWN
    0x008A71A4, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A71B4, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A71C4, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A71D4, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A71E4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A71F4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A7204, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A7214, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A7224, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A7234, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A7244, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A7254, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A7264, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A7274, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A7284, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A7294, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A72A4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A72B4, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A72C4, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A72D4, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A72E4, // TRACK_ELEM_LEFT_BANK
    0x008A72F4, // TRACK_ELEM_RIGHT_BANK
    0x008A7304, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A7314, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A7324, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A7334, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A7344, // TRACK_ELEM_S_BEND_LEFT
    0x008A7354, // TRACK_ELEM_S_BEND_RIGHT
    0x008A7364, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008A7374, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008A73B4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A73C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A73D4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A73E4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A73F4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A7404, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A7414, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A7424, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7434, // TRACK_ELEM_HALF_LOOP_UP
    0x008A7444, // TRACK_ELEM_HALF_LOOP_DOWN
    0x008A7454, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008A7464, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008A7474, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008A7484, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7734, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A7744, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A7754, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A7764, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A76F4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A7704, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A7714, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A7724, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x008A7494, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A74A4, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A74B4, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A74C4, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A74D4, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A74E4, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A76A4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A76B4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A76C4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A76D4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A74F4, // TRACK_ELEM_DIAG_FLAT
    0x008A7524, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A7584, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A7504, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A7564, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A7574, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A7514, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A7554, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A75B4, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A7534, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A7594, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A75A4, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A7544, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A75E4, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A75F4, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A7604, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A7614, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A7644, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A7654, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A7624, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A7634, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A7664, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A7674, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A7684, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A7694, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A75C4, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A75D4, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A76E4, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A85E4 */
static constexpr const uint32 _OldSuspendedSwingingCoasterTrackPaintFunctions[256] = {
    0x008A8958, // TRACK_ELEM_FLAT
    0x008A8AA8, // TRACK_ELEM_END_STATION
    0x008A8AB8, // TRACK_ELEM_BEGIN_STATION
    0x008A8AC8, // TRACK_ELEM_MIDDLE_STATION
    0x008A8968, // TRACK_ELEM_25_DEG_UP
    0x008A8978, // TRACK_ELEM_60_DEG_UP
    0x008A8988, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A8998, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A89A8, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A89B8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A89C8, // TRACK_ELEM_25_DEG_DOWN
    0x008A89D8, // TRACK_ELEM_60_DEG_DOWN
    0x008A89E8, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A89F8, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A8A08, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A8A18, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A8A28, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A8A38, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8A48, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A8A58, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A8A68, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A8A78, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A8A88, // TRACK_ELEM_S_BEND_LEFT
    0x008A8A98, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008A8AD8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A8AE8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0x008A8AF8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A8B08, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A8B18, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A8B28, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8B38, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8B48, // TRACK_ELEM_LEFT_QUARTER_HELIX_LARGE_UP
    0x008A8B58, // TRACK_ELEM_RIGHT_QUARTER_HELIX_LARGE_UP
    0x008A8B68, // TRACK_ELEM_LEFT_QUARTER_HELIX_LARGE_DOWN
    0x008A8B78, // TRACK_ELEM_RIGHT_QUARTER_HELIX_LARGE_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8B88, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A8B98, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A8BA8, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A8BB8, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008A8BC8, // TRACK_ELEM_DIAG_FLAT
    0x008A8BF8, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A8C58, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A8BD8, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A8C38, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A8C48, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A8BE8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A8C28, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A8C88, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A8C08, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A8C68, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A8C78, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A8C18, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8B38, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A8EE4 */
static constexpr const uint32 _OldInvertedRollerCoasterTrackPaintFunctions[256] = {
    0x008A92E8, // TRACK_ELEM_FLAT
    0x008A9558, // TRACK_ELEM_END_STATION
    0x008A9568, // TRACK_ELEM_BEGIN_STATION
    0x008A9578, // TRACK_ELEM_MIDDLE_STATION
    0x008A92F8, // TRACK_ELEM_25_DEG_UP
    0x008A9308, // TRACK_ELEM_60_DEG_UP
    0x008A9318, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A9328, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A9338, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A9348, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A9358, // TRACK_ELEM_25_DEG_DOWN
    0x008A9368, // TRACK_ELEM_60_DEG_DOWN
    0x008A9378, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A9388, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A9398, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A93A8, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A93B8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A93C8, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A93D8, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A93E8, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A93F8, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A9408, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A9418, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A9428, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A9438, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A9448, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A9458, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A9468, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A9478, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A9488, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A9498, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A94A8, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A94B8, // TRACK_ELEM_LEFT_BANK
    0x008A94C8, // TRACK_ELEM_RIGHT_BANK
    0x008A94D8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A94E8, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A94F8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A9508, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A9518, // TRACK_ELEM_S_BEND_LEFT
    0x008A9528, // TRACK_ELEM_S_BEND_RIGHT
    0x008A9538, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008A9548, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008A9588, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A9598, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A95A8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A95B8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A95C8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A95D8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A95E8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A95F8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0x008A9608, // TRACK_ELEM_LEFT_TWIST_DOWN_TO_UP
    0x008A9618, // TRACK_ELEM_RIGHT_TWIST_DOWN_TO_UP
    0x008A9628, // TRACK_ELEM_LEFT_TWIST_UP_TO_DOWN
    0x008A9638, // TRACK_ELEM_RIGHT_TWIST_UP_TO_DOWN
    0x008A9648, // TRACK_ELEM_HALF_LOOP_UP
    0x008A9658, // TRACK_ELEM_HALF_LOOP_DOWN
    0x008A9668, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008A9678, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008A9688, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008A9698, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A96D8, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A96B8, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A96C8, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A96E8, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A96A8, // TRACK_ELEM_BRAKES
    0,
    0,
    0x008A96F8, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_UP
    0x008A9708, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_UP
    0x008A9718, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0x008A9728, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0,
    0,
    0,
    0,
    0x008A9A38, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008A9A48, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008A9738, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008A9A58, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008A9A68, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A9748, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A9758, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A9768, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A9778, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A9938, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A9948, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A9958, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A9968, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A9788, // TRACK_ELEM_DIAG_FLAT
    0x008A97B8, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A9818, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A9798, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A97F8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A9808, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A97A8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A97E8, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A9848, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A97C8, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A9828, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A9838, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A97D8, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A9878, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A9888, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A9898, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A98A8, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A98D8, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A98E8, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A98B8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A98C8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A98F8, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A9908, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A9918, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A9928, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A9858, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A9868, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A9978, // TRACK_ELEM_LEFT_LARGE_HALF_LOOP_UP
    0x008A9988, // TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_UP
    0x008A9998, // TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_DOWN
    0x008A99A8, // TRACK_ELEM_LEFT_LARGE_HALF_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A96A8, // TRACK_ELEM_BLOCK_BRAKES
    0x008A9A78, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A9A88, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A9A98, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A9AA8, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A9BB8, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A9BC8, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A9BD8, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A9BE8, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A9AB8, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008A9AC8, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008A9AD8, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A9AE8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A9AF8, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A9B08, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A9B18, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A9B28, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A9B38, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A9B48, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A9B58, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008A9B68, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008A9B78, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A9B88, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A9B98, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008A9BA8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008A99B8, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A99C8, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A99D8, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008A99E8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008A99F8, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A9A08, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A9A18, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A9A28, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AAA0C */
static constexpr const uint32 _OldJuniorRollerCoasterTrackPaintFunctions[256] = {
    0x008AAD80, // TRACK_ELEM_FLAT
    0x008AAE70, // TRACK_ELEM_END_STATION
    0x008AAE80, // TRACK_ELEM_BEGIN_STATION
    0x008AAE90, // TRACK_ELEM_MIDDLE_STATION
    0x008AAD90, // TRACK_ELEM_25_DEG_UP
    0,
    0x008AADA0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AADB0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AADC0, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008AADD0, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AADE0, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AADF0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AAE00, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AAFC0, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AAFD0, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AAFE0, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AAFF0, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AB000, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AB010, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AB020, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AB030, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AB040, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AB050, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AB060, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AB070, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AB080, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AB090, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AB0A0, // TRACK_ELEM_LEFT_BANK
    0x008AB0B0, // TRACK_ELEM_RIGHT_BANK
    0x008AAE10, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AAE20, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AAE30, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AAE40, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AAE50, // TRACK_ELEM_S_BEND_LEFT
    0x008AAE60, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AAEA0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AAEB0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AB0C0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AB0D0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AAEC0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AAED0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AAEE0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AAEF0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AB0E0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008AB0F0, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008AB100, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AB110, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AB120, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008AB130, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008AB140, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008AB150, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x008AAF00, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AAF80, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AAF90, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AAFA0, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AAFB0, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008AB160, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008AB170, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008AB180, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AB190, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AAF10, // TRACK_ELEM_DIAG_FLAT
    0x008AAF40, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008AAF20, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AAF30, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AAF70, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008AAF50, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AAF60, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008AB1C0, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008AB1D0, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008AB1E0, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008AB1F0, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008AB220, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008AB230, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008AB200, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008AB210, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008AB240, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008AB250, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AB260, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008AB270, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AB1A0, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008AB1B0, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AB280, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008ACE48 */
static constexpr const uint32 _OldMiniatureRailwayTrackPaintFunctions[256] = {
    0x008AD0C0, // TRACK_ELEM_FLAT
    0x008AD170, // TRACK_ELEM_END_STATION
    0x008AD180, // TRACK_ELEM_BEGIN_STATION
    0x008AD190, // TRACK_ELEM_MIDDLE_STATION
    0x008AD0D0, // TRACK_ELEM_25_DEG_UP
    0,
    0x008AD0E0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AD0F0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AD100, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008AD110, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AD120, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AD130, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AD140, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AD150, // TRACK_ELEM_S_BEND_LEFT
    0x008AD160, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AD1A0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AD1B0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AD1C0, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AD1D0, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AD1E0, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AD1F0, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008AD200, // TRACK_ELEM_DIAG_FLAT
    0x008AD230, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008AD210, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AD220, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AD260, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008AD240, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AD250, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008ADF34 */
static constexpr const uint32 _OldMonorailTrackPaintFunctions[256] = {
    0x008AE1AC, // TRACK_ELEM_FLAT
    0x008AE25C, // TRACK_ELEM_END_STATION
    0x008AE26C, // TRACK_ELEM_BEGIN_STATION
    0x008AE27C, // TRACK_ELEM_MIDDLE_STATION
    0x008AE1BC, // TRACK_ELEM_25_DEG_UP
    0,
    0x008AE1CC, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AE1DC, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AE1EC, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008AE1FC, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AE20C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AE21C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AE22C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AE23C, // TRACK_ELEM_S_BEND_LEFT
    0x008AE24C, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AE28C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AE29C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AE31C, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AE32C, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AE33C, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AE34C, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008AE2AC, // TRACK_ELEM_DIAG_FLAT
    0x008AE2DC, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008AE2BC, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AE2CC, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AE30C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008AE2EC, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AE2FC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AFC24 */
static constexpr const uint32 _OldMiniSuspendedCoasterTrackPaintFunctions[256] = {
    0x008AFE9C, // TRACK_ELEM_FLAT
    0x008AFF4C, // TRACK_ELEM_END_STATION
    0x008AFF5C, // TRACK_ELEM_BEGIN_STATION
    0x008AFF6C, // TRACK_ELEM_MIDDLE_STATION
    0x008AFEAC, // TRACK_ELEM_25_DEG_UP
    0,
    0x008AFEBC, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AFECC, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AFEDC, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008AFEEC, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008AFEFC, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AFF0C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AFF1C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFF2C, // TRACK_ELEM_S_BEND_LEFT
    0x008AFF3C, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AFF7C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AFF8C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFFAC, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AFFBC, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AFFCC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AFFDC, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008AFF9C, // TRACK_ELEM_DIAG_FLAT
    0x008B000C, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008AFFEC, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008AFFFC, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008B003C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008B001C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008B002C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008B0D60 */
static constexpr const uint32 _OldBoatHireTrackPaintFunctions[256] = {
    0x008B0E40, // TRACK_ELEM_FLAT
    0x008B0E50, // TRACK_ELEM_END_STATION
    0x008B0E60, // TRACK_ELEM_BEGIN_STATION
    0x008B0E70, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B0E80, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x008B0E90, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A534C */
static constexpr const uint32 _OldWoodenWildMouseTrackPaintFunctions[256] = {
    0x008A5464, // TRACK_ELEM_FLAT
    0x008A5534, // TRACK_ELEM_END_STATION
    0x008A5544, // TRACK_ELEM_BEGIN_STATION
    0x008A5554, // TRACK_ELEM_MIDDLE_STATION
    0x008A5474, // TRACK_ELEM_25_DEG_UP
    0x008A5484, // TRACK_ELEM_60_DEG_UP
    0x008A5494, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A54A4, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A54B4, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A54C4, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A54D4, // TRACK_ELEM_25_DEG_DOWN
    0x008A54E4, // TRACK_ELEM_60_DEG_DOWN
    0x008A54F4, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A5504, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A5514, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A5524, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A5564, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A5574, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0x008A5584, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A5594, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A55A4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A55B4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A55C4, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x008A55D4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A55E4, // TRACK_ELEM_FLAT_TO_60_DEG_UP
    0x008A55F4, // TRACK_ELEM_60_DEG_UP_TO_FLAT
    0x008A5604, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN
    0x008A5614, // TRACK_ELEM_60_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A5634 */
static constexpr const uint32 _OldSteeplechaseTrackPaintFunctions[256] = {
    0x008A59A8, // TRACK_ELEM_FLAT
    0x008A5A58, // TRACK_ELEM_END_STATION
    0x008A5A68, // TRACK_ELEM_BEGIN_STATION
    0x008A5A78, // TRACK_ELEM_MIDDLE_STATION
    0x008A59B8, // TRACK_ELEM_25_DEG_UP
    0,
    0x008A59C8, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008A59D8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A59E8, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008A59F8, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008A5A08, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A5A18, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A5A28, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A5A38, // TRACK_ELEM_S_BEND_LEFT
    0x008A5A48, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008A5A88, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A5A98, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A5AA8, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A5AD8, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A5AE8, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A5AF8, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A5B08, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008A5AC8, // TRACK_ELEM_DIAG_FLAT
    0x008A5B38, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008A5B18, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008A5B28, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A5B68, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008A5B48, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008A5B58, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A5AB8, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x006F7000 */
static constexpr const uint32 _OldCarRideTrackPaintFunctions[256] = {
    0x006F72C8, // TRACK_ELEM_FLAT
    0x006F7338, // TRACK_ELEM_END_STATION
    0x006F7348, // TRACK_ELEM_BEGIN_STATION
    0x006F7358, // TRACK_ELEM_MIDDLE_STATION
    0x006F72D8, // TRACK_ELEM_25_DEG_UP
    0x006F73B8, // TRACK_ELEM_60_DEG_UP
    0x006F72E8, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x006F73C8, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x006F73D8, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x006F72F8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x006F7308, // TRACK_ELEM_25_DEG_DOWN
    0x006F73E8, // TRACK_ELEM_60_DEG_DOWN
    0x006F7318, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x006F73F8, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x006F7408, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x006F7328, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006F7368, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x006F7378, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0x006F7388, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x006F7398, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006F7418, // TRACK_ELEM_RAPIDS
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006F73A8, // TRACK_ELEM_SPINNING_TUNNEL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x006FD0E8 */
static constexpr const uint32 _OldLaunchedFreefallTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006FD1F8, // TRACK_ELEM_TOWER_BASE
    0x006FD208, // TRACK_ELEM_TOWER_SECTION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x006FE240 */
static constexpr const uint32 _OldBobsleighCoasterTrackPaintFunctions[256] = {
    0x006FE5B4, // TRACK_ELEM_FLAT
    0x006FE764, // TRACK_ELEM_END_STATION
    0x006FE774, // TRACK_ELEM_BEGIN_STATION
    0x006FE784, // TRACK_ELEM_MIDDLE_STATION
    0x006FE5C4, // TRACK_ELEM_25_DEG_UP
    0,
    0x006FE5D4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x006FE5E4, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x006FE5F4, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x006FE604, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x006FE614, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x006FE624, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x006FE634, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x006FE644, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x006FE654, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x006FE664, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x006FE674, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x006FE684, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x006FE694, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x006FE6A4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x006FE6B4, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x006FE6C4, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x006FE6D4, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x006FE6E4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x006FE6F4, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x006FE704, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x006FE714, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x006FE724, // TRACK_ELEM_LEFT_BANK
    0x006FE734, // TRACK_ELEM_RIGHT_BANK
    0,
    0,
    0,
    0,
    0x006FE744, // TRACK_ELEM_S_BEND_LEFT
    0x006FE754, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x006FE794, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x006FE7A4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x006FE7B4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x006FE7C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006FE7D4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x006FE7E4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x006FE7F4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x006FE804, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x006FE814, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x006FE824, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x006FE834, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x006FE844, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x006FE854, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x006FE864, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0070DC5C */
static constexpr const uint32 _OldObservationTowerTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0070DD6C, // TRACK_ELEM_TOWER_BASE
    0x0070DD7C, // TRACK_ELEM_TOWER_SECTION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A5B88 */
static constexpr const uint32 _OldLoopingRollerCoasterTrackPaintFunctions[256] = {
    0x008A6370, // TRACK_ELEM_FLAT
    0x008A6600, // TRACK_ELEM_END_STATION
    0x008A6610, // TRACK_ELEM_BEGIN_STATION
    0x008A6620, // TRACK_ELEM_MIDDLE_STATION
    0x008A6380, // TRACK_ELEM_25_DEG_UP
    0x008A6390, // TRACK_ELEM_60_DEG_UP
    0x008A63A0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A63B0, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A63C0, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A63D0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A63E0, // TRACK_ELEM_25_DEG_DOWN
    0x008A63F0, // TRACK_ELEM_60_DEG_DOWN
    0x008A6400, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A6410, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A6420, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6430, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A6440, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A6450, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A6460, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A6470, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A6480, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A6490, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A64A0, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A64B0, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A64C0, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A64D0, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A64E0, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A64F0, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A6500, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A6510, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A6520, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A6530, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A6540, // TRACK_ELEM_LEFT_BANK
    0x008A6550, // TRACK_ELEM_RIGHT_BANK
    0x008A6560, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A6570, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A6580, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A6590, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A65A0, // TRACK_ELEM_S_BEND_LEFT
    0x008A65B0, // TRACK_ELEM_S_BEND_RIGHT
    0x008A65C0, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008A65D0, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008A6630, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A6640, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A6650, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A6660, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A6670, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A6680, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A6690, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A66A0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A66B0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A66C0, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A66D0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A66E0, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A66F0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A6700, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A6710, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A6720, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A6750, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A6730, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A6740, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A6760, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A6770, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6A40, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008A6A50, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008A6780, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008A6A60, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008A6A70, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6860, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A6870, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A6880, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A6890, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A68A0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A68B0, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A68C0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A68D0, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A6790, // TRACK_ELEM_DIAG_FLAT
    0x008A67C0, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A67F0, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A67A0, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A67D0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A67E0, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A67B0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A6820, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A6850, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A6800, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A6830, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A6840, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6810, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A6900, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A6910, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A6920, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A6930, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A6960, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A6970, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A6940, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A6950, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A6980, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A6990, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A69A0, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A69B0, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A68E0, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A68F0, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6C00, // TRACK_ELEM_BLOCK_BRAKES
    0x008A6BC0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A6BD0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A6BE0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A6BF0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A6B80, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A6B90, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A6BA0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A6BB0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A6A80, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008A6A90, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008A6AA0, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A6AB0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A6AC0, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6AD0, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6AE0, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6AF0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6B00, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A6B10, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A6B40, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008A6B50, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008A6B60, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6B70, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6B20, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008A6B30, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008A69C0, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A69D0, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A69E0, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008A69F0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008A6A00, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6A10, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6A20, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A6A30, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0070EDB4 */
static constexpr const uint32 _OldDinghySlideTrackPaintFunctions[256] = {
    0x0070EF20, // TRACK_ELEM_FLAT
    0x0070F030, // TRACK_ELEM_END_STATION
    0x0070F040, // TRACK_ELEM_BEGIN_STATION
    0x0070F050, // TRACK_ELEM_MIDDLE_STATION
    0x0070EF30, // TRACK_ELEM_25_DEG_UP
    0x0070EFD0, // TRACK_ELEM_60_DEG_UP
    0x0070EF40, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x0070EF90, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x0070EFA0, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x0070EF50, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0070EF60, // TRACK_ELEM_25_DEG_DOWN
    0x0070EFE0, // TRACK_ELEM_60_DEG_DOWN
    0x0070EF70, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x0070EFB0, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x0070EFC0, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x0070EF80, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x0070EFF0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0070F000, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0070F010, // TRACK_ELEM_S_BEND_LEFT
    0x0070F020, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x0070F060, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0070F070, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0070F080, // TRACK_ELEM_FLAT_COVERED
    0x0070F090, // TRACK_ELEM_25_DEG_UP_COVERED
    0x0070F130, // TRACK_ELEM_60_DEG_UP_COVERED
    0x0070F0A0, // TRACK_ELEM_FLAT_TO_25_DEG_UP_COVERED
    0x0070F0F0, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP_COVERED
    0x0070F100, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP_COVERED
    0x0070F0B0, // TRACK_ELEM_25_DEG_UP_TO_FLAT_COVERED
    0x0070F0C0, // TRACK_ELEM_25_DEG_DOWN_COVERED
    0x0070F140, // TRACK_ELEM_60_DEG_DOWN_COVERED
    0x0070F0D0, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN_COVERED
    0x0070F110, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN_COVERED
    0x0070F120, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN_COVERED
    0x0070F0E0, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT_COVERED
    0x0070F150, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_COVERED
    0x0070F160, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_COVERED
    0x0070F190, // TRACK_ELEM_S_BEND_LEFT_COVERED
    0x0070F1A0, // TRACK_ELEM_S_BEND_RIGHT_COVERED
    0x0070F170, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_COVERED
    0x0070F180, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_COVERED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0071BC40 */
static constexpr const uint32 _OldMineTrainCoasterTrackPaintFunctions[256] = {
    0x0071BFA4, // TRACK_ELEM_FLAT
    0x0071C154, // TRACK_ELEM_END_STATION
    0x0071C164, // TRACK_ELEM_BEGIN_STATION
    0x0071C174, // TRACK_ELEM_MIDDLE_STATION
    0x0071BFB4, // TRACK_ELEM_25_DEG_UP
    0x0071BFC4, // TRACK_ELEM_60_DEG_UP
    0x0071BFD4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x0071BFE4, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x0071BFF4, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x0071C004, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0071C014, // TRACK_ELEM_25_DEG_DOWN
    0x0071C024, // TRACK_ELEM_60_DEG_DOWN
    0x0071C034, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x0071C044, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x0071C054, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x0071C064, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x0071C0B4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0071C0C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x0071C074, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x0071C084, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x0071C094, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x0071C0A4, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x0071C0D4, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x0071C0E4, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x0071C204, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x0071C214, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x0071C224, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x0071C234, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x0071C244, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x0071C254, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x0071C264, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x0071C274, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x0071C304, // TRACK_ELEM_LEFT_BANK
    0x0071C314, // TRACK_ELEM_RIGHT_BANK
    0x0071C0F4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x0071C104, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x0071C114, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x0071C124, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x0071C134, // TRACK_ELEM_S_BEND_LEFT
    0x0071C144, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x0071C184, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0071C194, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x0071C1A4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x0071C1B4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x0071C1C4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x0071C1D4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x0071C1E4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x0071C1F4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0071C284, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x0071C294, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x0071C2A4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x0071C2B4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x0071C2C4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x0071C2D4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x0071C2E4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x0071C2F4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x0071C324, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0071C334, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0071C354, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x0071C364, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x0071C374, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x0071C384, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x0071C394, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x0071C3A4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x0071C3B4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x0071C3C4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x0071C344, // TRACK_ELEM_DIAG_FLAT
    0x0071C414, // TRACK_ELEM_DIAG_25_DEG_UP
    0x0071C474, // TRACK_ELEM_DIAG_60_DEG_UP
    0x0071C3F4, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x0071C454, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x0071C464, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x0071C404, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x0071C444, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x0071C4A4, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x0071C424, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x0071C484, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x0071C494, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x0071C434, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x0071C4D4, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x0071C4B4, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x0071C4C4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x0071C4E4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x0071C514, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x0071C524, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x0071C4F4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x0071C504, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x0071C534, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x0071C544, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x0071C554, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x0071C564, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x0071C3D4, // TRACK_ELEM_DIAG_LEFT_BANK
    0x0071C3E4, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0071C574, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00743EC8 */
static constexpr const uint32 _OldChairliftTrackPaintFunctions[256] = {
    0x00743FC8, // TRACK_ELEM_FLAT
    0x00743F98, // TRACK_ELEM_END_STATION
    0x00743FA8, // TRACK_ELEM_BEGIN_STATION
    0x00743FB8, // TRACK_ELEM_MIDDLE_STATION
    0x00743FD8, // TRACK_ELEM_25_DEG_UP
    0,
    0x00743FE8, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00743FF8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00744008, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x00744018, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x00744028, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00744038, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00744048, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A7784 */
static constexpr const uint32 _OldCorkscrewRollerCoasterTrackPaintFunctions[256] = {
    0x008A7AF8, // TRACK_ELEM_FLAT
    0x008A7D68, // TRACK_ELEM_END_STATION
    0x008A7D78, // TRACK_ELEM_BEGIN_STATION
    0x008A7D88, // TRACK_ELEM_MIDDLE_STATION
    0x008A7B08, // TRACK_ELEM_25_DEG_UP
    0x008A7B18, // TRACK_ELEM_60_DEG_UP
    0x008A7B28, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A7B38, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A7B48, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A7B58, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A7B68, // TRACK_ELEM_25_DEG_DOWN
    0x008A7B78, // TRACK_ELEM_60_DEG_DOWN
    0x008A7B88, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A7B98, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A7BA8, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A7BB8, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A7BC8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A7BD8, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A7BE8, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A7BF8, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A7C08, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A7C18, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A7C28, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A7C38, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A7C48, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A7C58, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A7C68, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A7C78, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A7C88, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A7C98, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A7CA8, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A7CB8, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A7CC8, // TRACK_ELEM_LEFT_BANK
    0x008A7CD8, // TRACK_ELEM_RIGHT_BANK
    0x008A7CE8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A7CF8, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A7D08, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A7D18, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A7D28, // TRACK_ELEM_S_BEND_LEFT
    0x008A7D38, // TRACK_ELEM_S_BEND_RIGHT
    0x008A7D48, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008A7D58, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008A7D98, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A7DA8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A7DB8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A7DC8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A7DD8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A7DE8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A7DF8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A7E08, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7E18, // TRACK_ELEM_HALF_LOOP_UP
    0x008A7E28, // TRACK_ELEM_HALF_LOOP_DOWN
    0x008A7E38, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008A7E48, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008A7E58, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008A7E68, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7E78, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A7E88, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A7E98, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A7EA8, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A7EB8, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A7EC8, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A7ED8, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A7EE8, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A7F18, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A7EF8, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A7F08, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A7F28, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A7F38, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7F48, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0x008A8198, // TRACK_ELEM_FLAT_TO_60_DEG_UP_LONG_BASE
    0x008A81A8, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE
    0,
    0x008A81B8, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN_LONG_BASE
    0x008A81C8, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE_122
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A7F68, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A7F78, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A7F88, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A7F98, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A7FA8, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A7FB8, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A7FC8, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A7FD8, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A7F58, // TRACK_ELEM_DIAG_FLAT
    0x008A8008, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A8068, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A7FE8, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A8048, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A8058, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A7FF8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A8038, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A8098, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A8018, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A8078, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A8088, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A8028, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A80C8, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A80D8, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A80E8, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A80F8, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A8128, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A8138, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A8108, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A8118, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A8148, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A8158, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A8168, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A8178, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A80A8, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A80B8, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8188, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A81E8 */
static constexpr const uint32 _OldMazeTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8380, // TRACK_ELEM_INVERTED_90_DEG_UP_TO_FLAT_QUARTER_LOOP
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0074840C */
static constexpr const uint32 _OldSpiralSlideTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007485C8, // 110
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0074A668 */
static constexpr const uint32 _OldGoKartsTrackPaintFunctions[256] = {
    0x0074A748, // TRACK_ELEM_FLAT
    0x0074A7B8, // TRACK_ELEM_END_STATION
    0x0074A7C8, // TRACK_ELEM_BEGIN_STATION
    0x0074A7D8, // TRACK_ELEM_MIDDLE_STATION
    0x0074A758, // TRACK_ELEM_25_DEG_UP
    0,
    0x0074A768, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0074A778, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0074A788, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0074A798, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0074A7A8, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0074A7E8, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x0074A7F8, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0074DDEC */
static constexpr const uint32 _OldLogFlumeTrackPaintFunctions[256] = {
    0x0074E0B0, // TRACK_ELEM_FLAT
    0x0074E140, // TRACK_ELEM_END_STATION
    0x0074E150, // TRACK_ELEM_BEGIN_STATION
    0x0074E160, // TRACK_ELEM_MIDDLE_STATION
    0x0074E0C0, // TRACK_ELEM_25_DEG_UP
    0,
    0x0074E0D0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0074E0E0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0074E0F0, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0074E100, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0074E110, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0074E120, // TRACK_ELEM_S_BEND_LEFT
    0x0074E130, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x0074E170, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0074E180, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0074E1A0, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0074E190, // TRACK_ELEM_LOG_FLUME_REVERSER
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0075745C */
static constexpr const uint32 _OldRiverRapidsTrackPaintFunctions[256] = {
    0x00757650, // TRACK_ELEM_FLAT
    0x007576C0, // TRACK_ELEM_END_STATION
    0x007576D0, // TRACK_ELEM_BEGIN_STATION
    0x007576E0, // TRACK_ELEM_MIDDLE_STATION
    0x00757660, // TRACK_ELEM_25_DEG_UP
    0,
    0x00757670, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00757680, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00757690, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x007576A0, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x007576B0, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007576F0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00757700, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00757710, // TRACK_ELEM_WATERFALL
    0x00757720, // TRACK_ELEM_RAPIDS
    0x00757740, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0x00757730, // TRACK_ELEM_WHIRLPOOL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0075C9D0 */
static constexpr const uint32 _OldDodgemsTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0075CBA0, // 111
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A83E0 */
static constexpr const uint32 _OldPirateShipTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A85C4, // 116
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00760070 */
static constexpr const uint32 _OldSwingingInverterShipTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00760260, // 119
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/**
 * FoodStall, 1D, DrinkStall, 1F, Shop, 22, InformationKiosk, CashMachine, 50, 52, 53, 54
 *
 * rct2: 0x00761160
 */
static constexpr const uint32 _OldShopTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00761358, // 118
    0,
    0,
    0x00761358, // 121
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076190C */
static constexpr const uint32 _OldMerryGoRoundTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00761B0C, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/**
 * Toilets, FirstAid
 *
 * rct2: 0x00762D44
 */
static constexpr const uint32 _OldFacilityTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00762F30, // 118
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A8CC8 */
static constexpr const uint32 _OldFerrisWheelTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A8EC4, // 122
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00763520 */
static constexpr const uint32 _OldMotionSimulatorTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007636EC, // 110
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076554C */
static constexpr const uint32 _Old3DCinemaTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076574C, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076659C */
static constexpr const uint32 _OldTopSpinTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076679C, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00767A40 */
static constexpr const uint32 _OldSpaceRingsTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00767C40, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00768BAC */
static constexpr const uint32 _OldReverseFreefallCoasterTrackPaintFunctions[256] = {
    0x00768DB4, // TRACK_ELEM_FLAT
    0x00768DC4, // TRACK_ELEM_END_STATION
    0x00768DD4, // TRACK_ELEM_BEGIN_STATION
    0x00768DE4, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00768DF4, // TRACK_ELEM_REVERSE_FREEFALL_SLOPE
    0x00768E04, // TRACK_ELEM_REVERSE_FREEFALL_VERTICAL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076C5BC */
static constexpr const uint32 _OldLiftTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076C6CC, // TRACK_ELEM_TOWER_BASE
    0x0076C6DC, // TRACK_ELEM_TOWER_SECTION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A9C08 */
static constexpr const uint32 _OldVerticalDropRollerCoasterTrackPaintFunctions[256] = {
    0x008AA00C, // TRACK_ELEM_FLAT
    0x008AA25C, // TRACK_ELEM_END_STATION
    0x008AA26C, // TRACK_ELEM_BEGIN_STATION
    0x008AA27C, // TRACK_ELEM_MIDDLE_STATION
    0x008AA01C, // TRACK_ELEM_25_DEG_UP
    0x008AA02C, // TRACK_ELEM_60_DEG_UP
    0x008AA03C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AA04C, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AA05C, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AA06C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AA07C, // TRACK_ELEM_25_DEG_DOWN
    0x008AA08C, // TRACK_ELEM_60_DEG_DOWN
    0x008AA09C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AA0AC, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AA0BC, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AA0CC, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AA0DC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AA0EC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AA0FC, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AA10C, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AA11C, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AA12C, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AA13C, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AA14C, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AA15C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AA16C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AA17C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AA18C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AA19C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AA1AC, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AA1BC, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AA1CC, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AA1DC, // TRACK_ELEM_LEFT_BANK
    0x008AA1EC, // TRACK_ELEM_RIGHT_BANK
    0x008AA1FC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AA20C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AA21C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AA22C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AA23C, // TRACK_ELEM_S_BEND_LEFT
    0x008AA24C, // TRACK_ELEM_S_BEND_RIGHT
    0x008AA49C, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008AA4AC, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008AA28C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AA29C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AA2AC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AA2BC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AA2CC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AA2DC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AA2EC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AA2FC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA3CC, // TRACK_ELEM_FLAT_TO_60_DEG_UP
    0x008AA3DC, // TRACK_ELEM_60_DEG_UP_TO_FLAT
    0x008AA3EC, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN
    0x008AA3FC, // TRACK_ELEM_60_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA30C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008AA31C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008AA32C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AA33C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AA34C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008AA35C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008AA36C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008AA37C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008AA3AC, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008AA38C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008AA39C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008AA3BC, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008AA40C, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA7EC, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008AA7FC, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008AA41C, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008AA80C, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008AA81C, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA42C, // TRACK_ELEM_90_DEG_UP
    0x008AA43C, // TRACK_ELEM_90_DEG_DOWN
    0x008AA44C, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x008AA45C, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x008AA46C, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x008AA47C, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0x008AA48C, // TRACK_ELEM_BRAKE_FOR_DROP
    0x008AA4CC, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AA4DC, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AA4EC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AA4FC, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008AA50C, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008AA51C, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008AA52C, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AA53C, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AA4BC, // TRACK_ELEM_DIAG_FLAT
    0x008AA56C, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008AA5CC, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008AA54C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008AA5AC, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008AA5BC, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008AA55C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AA59C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008AA5FC, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008AA57C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008AA5DC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AA5EC, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AA58C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0x008AA6EC, // TRACK_ELEM_DIAG_FLAT_TO_60_DEG_UP
    0x008AA6FC, // TRACK_ELEM_DIAG_60_DEG_UP_TO_FLAT
    0x008AA70C, // TRACK_ELEM_DIAG_FLAT_TO_60_DEG_DOWN
    0x008AA71C, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_FLAT
    0x008AA62C, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008AA63C, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008AA64C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008AA65C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008AA68C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008AA69C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008AA66C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008AA67C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008AA6AC, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008AA6BC, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AA6CC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008AA6DC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AA60C, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008AA61C, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA72C, // TRACK_ELEM_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AA73C, // TRACK_ELEM_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AA74C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_LEFT_BANK
    0x008AA75C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AA9EC, // TRACK_ELEM_BLOCK_BRAKES
    0x008AA96C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008AA97C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008AA98C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008AA99C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008AA8AC, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008AA8BC, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008AA8CC, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008AA8DC, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008AA82C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008AA83C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008AA84C, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008AA85C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008AA86C, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008AA87C, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008AA88C, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008AA89C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008AA8EC, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008AA8FC, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008AA92C, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008AA93C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008AA94C, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008AA95C, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008AA90C, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008AA91C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008AA76C, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008AA77C, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008AA78C, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008AA79C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008AA7AC, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008AA7BC, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008AA7CC, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008AA7DC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008AA9AC, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008AA9BC, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008AA9CC, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0x008AA9DC, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0,
    0,
    0,
};

/** rct2: 0x0076D658 */
static constexpr const uint32 _OldTwistTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076D858, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076E7B0 */
static constexpr const uint32 _OldHauntedHouseTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076E9B0, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0076F8D4 */
static constexpr const uint32 _OldCircusShowTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0076FAD4, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00770924 */
static constexpr const uint32 _OldGhostTrainTrackPaintFunctions[256] = {
    0x00770BEC, // TRACK_ELEM_FLAT
    0x00770C5C, // TRACK_ELEM_END_STATION
    0x00770C6C, // TRACK_ELEM_BEGIN_STATION
    0x00770C7C, // TRACK_ELEM_MIDDLE_STATION
    0x00770BFC, // TRACK_ELEM_25_DEG_UP
    0,
    0x00770C0C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00770C1C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00770C2C, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x00770C3C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x00770C4C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00770C8C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00770C9C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0x00770CAC, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00770CBC, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00770CDC, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00770CCC, // TRACK_ELEM_SPINNING_TUNNEL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AB2A0 */
static constexpr const uint32 _OldTwisterRollerCoasterTrackPaintFunctions[256] = {
    0x008AB6A4, // TRACK_ELEM_FLAT
    0x008AB8F4, // TRACK_ELEM_END_STATION
    0x008AB904, // TRACK_ELEM_BEGIN_STATION
    0x008AB914, // TRACK_ELEM_MIDDLE_STATION
    0x008AB6B4, // TRACK_ELEM_25_DEG_UP
    0x008AB6C4, // TRACK_ELEM_60_DEG_UP
    0x008AB6D4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AB6E4, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AB6F4, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AB704, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AB714, // TRACK_ELEM_25_DEG_DOWN
    0x008AB724, // TRACK_ELEM_60_DEG_DOWN
    0x008AB734, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AB744, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AB754, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AB764, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AB774, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AB784, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AB794, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AB7A4, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AB7B4, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AB7C4, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AB7D4, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AB7E4, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AB7F4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AB804, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AB814, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AB824, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AB834, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AB844, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AB854, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AB864, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AB874, // TRACK_ELEM_LEFT_BANK
    0x008AB884, // TRACK_ELEM_RIGHT_BANK
    0x008AB894, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AB8A4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AB8B4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AB8C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AB8D4, // TRACK_ELEM_S_BEND_LEFT
    0x008AB8E4, // TRACK_ELEM_S_BEND_RIGHT
    0x008ABA84, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008ABA94, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008AB924, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AB934, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AB944, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AB954, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AB964, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AB974, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AB984, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AB994, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ABCD4, // TRACK_ELEM_HALF_LOOP_UP
    0x008ABCE4, // TRACK_ELEM_HALF_LOOP_DOWN
    0x008ABD34, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008ABD44, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008ABD54, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008ABD64, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AB9A4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008AB9B4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008AB9C4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AB9D4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AB9E4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008AB9F4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008ABA04, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008ABA14, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008ABA44, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008ABA24, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008ABA34, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008ABA54, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008ABA64, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ABE04, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008ABE14, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008ABA74, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008ABE24, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008ABE34, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0x008AC0F4, // TRACK_ELEM_FLAT_TO_60_DEG_UP_LONG_BASE
    0x008AC104, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE
    0,
    0x008AC114, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN_LONG_BASE
    0x008AC124, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE_122
    0,
    0,
    0,
    0x008ABE44, // TRACK_ELEM_90_DEG_UP
    0x008ABE54, // TRACK_ELEM_90_DEG_DOWN
    0x008ABE64, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x008ABE74, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x008ABE84, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x008ABE94, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0,
    0x008ABAB4, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008ABAC4, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008ABAD4, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008ABAE4, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008ABAF4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008ABB04, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008ABB14, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008ABB24, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008ABAA4, // TRACK_ELEM_DIAG_FLAT
    0x008ABB54, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008ABBB4, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008ABB34, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008ABB94, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008ABBA4, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008ABB44, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008ABB84, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008ABBE4, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008ABB64, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008ABBC4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008ABBD4, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008ABB74, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008ABC14, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008ABC24, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008ABC34, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008ABC44, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008ABC74, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008ABC84, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008ABC54, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008ABC64, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008ABC94, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008ABCA4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008ABCB4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008ABCC4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008ABBF4, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008ABC04, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0x008ABCF4, // TRACK_ELEM_LEFT_BARREL_ROLL_UP_TO_DOWN
    0x008ABD04, // TRACK_ELEM_RIGHT_BARREL_ROLL_UP_TO_DOWN
    0x008ABD14, // TRACK_ELEM_LEFT_BARREL_ROLL_DOWN_TO_UP
    0x008ABD24, // TRACK_ELEM_RIGHT_BARREL_ROLL_DOWN_TO_UP
    0x008ABD74, // TRACK_ELEM_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008ABD84, // TRACK_ELEM_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008ABD94, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_LEFT_BANK
    0x008ABDA4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_RIGHT_BANK
    0x008ABDB4, // TRACK_ELEM_POWERED_LIFT
    0x008ABDC4, // TRACK_ELEM_LEFT_LARGE_HALF_LOOP_UP
    0x008ABDD4, // TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_UP
    0x008ABDE4, // TRACK_ELEM_RIGHT_LARGE_HALF_LOOP_DOWN
    0x008ABDF4, // TRACK_ELEM_LEFT_LARGE_HALF_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AC134, // TRACK_ELEM_90_DEG_TO_INVERTED_FLAT_QUARTER_LOOP_UP
    0x008AC144, // TRACK_ELEM_INVERTED_FLAT_TO_90_DEG_QUARTER_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AC0E4, // TRACK_ELEM_BLOCK_BRAKES
    0x008ABEA4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ABEB4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ABEC4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ABED4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ABEE4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ABEF4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ABF04, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ABF14, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ABF24, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008ABF34, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008ABF44, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ABF54, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ABF64, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ABF74, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ABF84, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ABF94, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ABFA4, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008ABFB4, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008ABFE4, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008ABFF4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008AC004, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008AC014, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ABFC4, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008ABFD4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008AC024, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008AC034, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008AC044, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008AC054, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008AC064, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008AC074, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008AC084, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008AC094, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008AC0A4, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008AC0B4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008AC0C4, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0x008AC0D4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0,
    0,
    0,
};

/** rct2: 0x008AC164 */
static constexpr const uint32 _OldWoodenRollerCoasterTrackPaintFunctions[256] = {
    0x008AC568, // TRACK_ELEM_FLAT
    0x008AC7B8, // TRACK_ELEM_END_STATION
    0x008AC7C8, // TRACK_ELEM_BEGIN_STATION
    0x008AC7D8, // TRACK_ELEM_MIDDLE_STATION
    0x008AC578, // TRACK_ELEM_25_DEG_UP
    0x008AC588, // TRACK_ELEM_60_DEG_UP
    0x008AC598, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AC5A8, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AC5B8, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AC5C8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AC5D8, // TRACK_ELEM_25_DEG_DOWN
    0x008AC5E8, // TRACK_ELEM_60_DEG_DOWN
    0x008AC5F8, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AC608, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AC618, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AC628, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AC638, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AC648, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AC658, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AC668, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AC678, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AC688, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AC698, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AC6A8, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AC6B8, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AC6C8, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AC6D8, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AC6E8, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AC6F8, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AC708, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AC718, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AC728, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AC738, // TRACK_ELEM_LEFT_BANK
    0x008AC748, // TRACK_ELEM_RIGHT_BANK
    0x008AC758, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AC768, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AC778, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AC788, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AC798, // TRACK_ELEM_S_BEND_LEFT
    0x008AC7A8, // TRACK_ELEM_S_BEND_RIGHT
    0x008ACE18, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008ACE28, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008AC7E8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AC7F8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AC808, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AC818, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AC828, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AC838, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AC848, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AC858, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ACAB8, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008ACAC8, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008ACAD8, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008ACAE8, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008ACAF8, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008ACB08, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008ACB18, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008ACB28, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008ACB98, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008ACB78, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008ACB88, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008ACBA8, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008AC868, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ACC78, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008ACC88, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008AC878, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008ACC98, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008ACCA8, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0x008ACE08, // TRACK_ELEM_WATER_SPLASH
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AC958, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AC968, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AC978, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AC988, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008AC998, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008AC9A8, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008AC9B8, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AC9C8, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AC888, // TRACK_ELEM_DIAG_FLAT
    0x008AC8B8, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008AC8E8, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008AC898, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008AC8C8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008AC8D8, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008AC8A8, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AC918, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008AC948, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008AC8F8, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008AC928, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AC938, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AC908, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008ACA18, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008AC9F8, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008ACA08, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008ACA28, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008ACA58, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008ACA68, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008ACA38, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008ACA48, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008ACA78, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008ACA88, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008ACA98, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008ACAA8, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AC9D8, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008AC9E8, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ACB38, // TRACK_ELEM_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008ACB48, // TRACK_ELEM_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008ACB58, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_LEFT_BANK
    0x008ACB68, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN_TO_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ACDF8, // TRACK_ELEM_BLOCK_BRAKES
    0x008ACCB8, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ACCC8, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ACCD8, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ACCE8, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ACC38, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ACC48, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ACC58, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ACC68, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ACCF8, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008ACD08, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008ACD18, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ACD28, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ACD38, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ACD48, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ACD58, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ACD68, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ACD78, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008ACD88, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008ACD98, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008ACDA8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008ACDB8, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ACDC8, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ACDD8, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008ACDE8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008ACBB8, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008ACBC8, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008ACBD8, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008ACBE8, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008ACBF8, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ACC08, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ACC18, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008ACC28, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00778124 */
static constexpr const uint32 _OldSideFrictionRollerCoasterTrackPaintFunctions[256] = {
    0x0077839C, // TRACK_ELEM_FLAT
    0x007784AC, // TRACK_ELEM_END_STATION
    0x007784BC, // TRACK_ELEM_BEGIN_STATION
    0x007784CC, // TRACK_ELEM_MIDDLE_STATION
    0x007783AC, // TRACK_ELEM_25_DEG_UP
    0,
    0x007783CC, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x007783FC, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0077840C, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0077842C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0077845C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x0077846C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0077847C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0077848C, // TRACK_ELEM_S_BEND_LEFT
    0x0077849C, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x007784DC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x007784EC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007784FC, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007785DC, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x007785EC, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x007785FC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x0077860C, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x0077850C, // TRACK_ELEM_DIAG_FLAT
    0x0077853C, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x0077851C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0077852C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x0077859C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x0077857C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0077858C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0078AE80 */
static constexpr const uint32 _OldWildMouseTrackPaintFunctions[256] = {
    0x0078B1E4, // TRACK_ELEM_FLAT
    0x0078B2B4, // TRACK_ELEM_END_STATION
    0x0078B2C4, // TRACK_ELEM_BEGIN_STATION
    0x0078B2D4, // TRACK_ELEM_MIDDLE_STATION
    0x0078B1F4, // TRACK_ELEM_25_DEG_UP
    0x0078B204, // TRACK_ELEM_60_DEG_UP
    0x0078B214, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x0078B224, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x0078B234, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x0078B244, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0078B254, // TRACK_ELEM_25_DEG_DOWN
    0x0078B264, // TRACK_ELEM_60_DEG_DOWN
    0x0078B274, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x0078B284, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x0078B294, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x0078B2A4, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0078B2E4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0078B2F4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0x0078B304, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x0078B314, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x0078B324, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x0078B334, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x0078B394, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x0078B3A4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0078B354, // TRACK_ELEM_FLAT_TO_60_DEG_UP
    0x0078B364, // TRACK_ELEM_60_DEG_UP_TO_FLAT
    0x0078B374, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN
    0x0078B384, // TRACK_ELEM_60_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0078B344, // TRACK_ELEM_BRAKES
    0x0078B3C4, // TRACK_ELEM_ROTATION_CONTROL_TOGGLE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0078B3B4, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00792978 */
static constexpr const uint32 _OldMultiDimensionRollerCoasterTrackPaintFunctions[256] = {
    0x00792D88, // TRACK_ELEM_FLAT
    0x00792F98, // TRACK_ELEM_END_STATION
    0x00792FA8, // TRACK_ELEM_BEGIN_STATION
    0x00792FB8, // TRACK_ELEM_MIDDLE_STATION
    0x00792D98, // TRACK_ELEM_25_DEG_UP
    0x00792DA8, // TRACK_ELEM_60_DEG_UP
    0x00792DB8, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x00792DC8, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x00792DD8, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x00792DE8, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00792DF8, // TRACK_ELEM_25_DEG_DOWN
    0x00792E08, // TRACK_ELEM_60_DEG_DOWN
    0x00792E18, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x00792E28, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x00792E38, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x00792E48, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x00792E58, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x00792E68, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x00792E78, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x00792E88, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x00792E98, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x00792EA8, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x00792EB8, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x00792EC8, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x00792ED8, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x00792EE8, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x00792EF8, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x00792F08, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x00792F18, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x00792F28, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x00792F38, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x00792F48, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x00792F58, // TRACK_ELEM_LEFT_BANK
    0x00792F68, // TRACK_ELEM_RIGHT_BANK
    0,
    0,
    0,
    0,
    0x00792F78, // TRACK_ELEM_S_BEND_LEFT
    0x00792F88, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x00792FC8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00792FD8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x00792FE8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x00792FF8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793008, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x00793018, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x00793028, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x00793038, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x00793048, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x00793058, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x00793068, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x00793078, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x00793088, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793098, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793328, // TRACK_ELEM_90_DEG_UP
    0x00793338, // TRACK_ELEM_90_DEG_DOWN
    0x00793348, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x00793358, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x00793368, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x00793378, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0,
    0x007930B8, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x007930C8, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x007930D8, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x007930E8, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x007930F8, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x00793108, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x00793118, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x00793128, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x007930A8, // TRACK_ELEM_DIAG_FLAT
    0x00793158, // TRACK_ELEM_DIAG_25_DEG_UP
    0x007931B8, // TRACK_ELEM_DIAG_60_DEG_UP
    0x00793138, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x00793198, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x007931A8, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x00793148, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x00793188, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x007931E8, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x00793168, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x007931C8, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x007931D8, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x00793178, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x00793218, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x00793228, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x00793238, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x00793248, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x00793278, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x00793288, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x00793258, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x00793268, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x00793298, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x007932A8, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x007932B8, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x007932C8, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x007931F8, // TRACK_ELEM_DIAG_LEFT_BANK
    0x00793208, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007932D8, // TRACK_ELEM_LEFT_FLYER_TWIST_UP
    0x007932E8, // TRACK_ELEM_RIGHT_FLYER_TWIST_UP
    0x007932F8, // TRACK_ELEM_LEFT_FLYER_TWIST_DOWN
    0x00793308, // TRACK_ELEM_RIGHT_FLYER_TWIST_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793398, // TRACK_ELEM_MULTIDIM_INVERTED_FLAT_TO_90_DEG_QUARTER_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793318, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00793388, // TRACK_ELEM_MULTIDIM_90_DEG_UP_TO_INVERTED_FLAT_QUARTER_LOOP
    0x00793398, // TRACK_ELEM_MULTIDIM_FLAT_TO_90_DEG_DOWN_QUARTER_LOOP
    0x00793388, // (null)
};

/** rct2: 0x007C6C00 */
static constexpr const uint32 _OldFlyingRollerCoasterTrackPaintFunctions[256] = {
    0x007C6FF4, // TRACK_ELEM_FLAT
    0x007C7244, // TRACK_ELEM_END_STATION
    0x007C7254, // TRACK_ELEM_BEGIN_STATION
    0x007C7264, // TRACK_ELEM_MIDDLE_STATION
    0x007C7004, // TRACK_ELEM_25_DEG_UP
    0x007C7014, // TRACK_ELEM_60_DEG_UP
    0x007C7024, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x007C7034, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x007C7044, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x007C7054, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x007C7064, // TRACK_ELEM_25_DEG_DOWN
    0x007C7074, // TRACK_ELEM_60_DEG_DOWN
    0x007C7084, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x007C7094, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x007C70A4, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x007C70B4, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x007C70C4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x007C70D4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x007C70E4, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x007C70F4, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x007C7104, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x007C7114, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x007C7124, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x007C7134, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x007C7144, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x007C7154, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x007C7164, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x007C7174, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x007C7184, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x007C7194, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x007C71A4, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x007C71B4, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x007C71C4, // TRACK_ELEM_LEFT_BANK
    0x007C71D4, // TRACK_ELEM_RIGHT_BANK
    0x007C71E4, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x007C71F4, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x007C7204, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x007C7214, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x007C7224, // TRACK_ELEM_S_BEND_LEFT
    0x007C7234, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x007C7274, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x007C7284, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x007C7294, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x007C72A4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x007C72B4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x007C72C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x007C72D4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x007C72E4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007C7314, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x007C7324, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x007C7334, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x007C7344, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x007C7354, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x007C7364, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x007C7374, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x007C7384, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x007C73B4, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x007C7394, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x007C73A4, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x007C73C4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x007C73D4, // TRACK_ELEM_BRAKES
    0,
    0,
    0x007C7674, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_UP
    0x007C7684, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_UP
    0x007C7694, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0x007C76A4, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0,
    0,
    0,
    0,
    0x007C78B4, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x007C78C4, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x007C73E4, // TRACK_ELEM_ON_RIDE_PHOTO
    0x007C78D4, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x007C78E4, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007C7404, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x007C7414, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x007C7424, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x007C7434, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x007C7444, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x007C7454, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x007C7464, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x007C7474, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x007C73F4, // TRACK_ELEM_DIAG_FLAT
    0x007C74A4, // TRACK_ELEM_DIAG_25_DEG_UP
    0x007C7504, // TRACK_ELEM_DIAG_60_DEG_UP
    0x007C7484, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x007C74E4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x007C74F4, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x007C7494, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x007C74D4, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x007C7534, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x007C74B4, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x007C7514, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x007C7524, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x007C74C4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x007C7564, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x007C7574, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x007C7584, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x007C7594, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x007C75C4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x007C75D4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x007C75A4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x007C75B4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x007C75E4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x007C75F4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x007C7604, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x007C7614, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x007C7544, // TRACK_ELEM_DIAG_LEFT_BANK
    0x007C7554, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007C7624, // TRACK_ELEM_LEFT_FLYER_TWIST_UP
    0x007C7634, // TRACK_ELEM_RIGHT_FLYER_TWIST_UP
    0x007C7644, // TRACK_ELEM_LEFT_FLYER_TWIST_DOWN
    0x007C7654, // TRACK_ELEM_RIGHT_FLYER_TWIST_DOWN
    0x007C72F4, // TRACK_ELEM_FLYER_HALF_LOOP_UP
    0x007C7304, // TRACK_ELEM_FLYER_HALF_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x007C7664, // TRACK_ELEM_BLOCK_BRAKES
    0x007C76B4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x007C76C4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x007C76D4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x007C76E4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x007C76F4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x007C7704, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x007C7714, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x007C7724, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x007C7734, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x007C7744, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x007C7754, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x007C7764, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x007C7774, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x007C7784, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x007C7794, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x007C77A4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x007C77B4, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x007C77C4, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x007C77F4, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x007C7804, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x007C7814, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x007C7824, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x007C77D4, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x007C77E4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x007C7834, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x007C7844, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x007C7854, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x007C7864, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x007C7874, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x007C7884, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x007C7894, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x007C78A4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00811184 */
static constexpr const uint32 _OldVirginiaReelTrackPaintFunctions[256] = {
    0x00811264, // TRACK_ELEM_FLAT
    0x008112D4, // TRACK_ELEM_END_STATION
    0x008112E4, // TRACK_ELEM_BEGIN_STATION
    0x008112F4, // TRACK_ELEM_MIDDLE_STATION
    0x00811274, // TRACK_ELEM_25_DEG_UP
    0,
    0x00811284, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00811294, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008112A4, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008112B4, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008112C4, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00811304, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00811314, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0x00811324, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00811334, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008164AC */
static constexpr const uint32 _OldSplashBoatsTrackPaintFunctions[256] = {
    0x00816584, // TRACK_ELEM_FLAT
    0x00816614, // TRACK_ELEM_END_STATION
    0x00816624, // TRACK_ELEM_BEGIN_STATION
    0x00816634, // TRACK_ELEM_MIDDLE_STATION
    0x00816594, // TRACK_ELEM_25_DEG_UP
    0x008166A4, // TRACK_ELEM_60_DEG_UP
    0x008165A4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x00816664, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x00816674, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008165B4, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008165C4, // TRACK_ELEM_25_DEG_DOWN
    0x008166B4, // TRACK_ELEM_60_DEG_DOWN
    0x008165D4, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x00816684, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x00816694, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008165E4, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x00816644, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x00816654, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008165F4, // TRACK_ELEM_S_BEND_LEFT
    0x00816604, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0081F268 */
static constexpr const uint32 _OldMiniHelicoptersTrackPaintFunctions[256] = {
    0x0081F348, // TRACK_ELEM_FLAT
    0x0081F3B8, // TRACK_ELEM_END_STATION
    0x0081F3C8, // TRACK_ELEM_BEGIN_STATION
    0x0081F3D8, // TRACK_ELEM_MIDDLE_STATION
    0x0081F358, // TRACK_ELEM_25_DEG_UP
    0,
    0x0081F368, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0081F378, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0081F388, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0081F398, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0081F3A8, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0081F3E8, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0081F3F8, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0x0081F408, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x0081F418, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008245A8 */
static constexpr const uint32 _OldLayDownRollerCoasterTrackPaintFunctions[256] = {
    0x0082491C, // TRACK_ELEM_FLAT
    0x00824B8C, // TRACK_ELEM_END_STATION
    0x00824B9C, // TRACK_ELEM_BEGIN_STATION
    0x00824BAC, // TRACK_ELEM_MIDDLE_STATION
    0x0082492C, // TRACK_ELEM_25_DEG_UP
    0x0082493C, // TRACK_ELEM_60_DEG_UP
    0x0082494C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x0082495C, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x0082496C, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x0082497C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0082498C, // TRACK_ELEM_25_DEG_DOWN
    0x0082499C, // TRACK_ELEM_60_DEG_DOWN
    0x008249AC, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008249BC, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008249CC, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008249DC, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008249EC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008249FC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x00824A0C, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x00824A1C, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x00824A2C, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x00824A3C, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x00824A4C, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x00824A5C, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x00824A6C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x00824A7C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x00824A8C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x00824A9C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x00824AAC, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x00824ABC, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x00824ACC, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x00824ADC, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x00824AEC, // TRACK_ELEM_LEFT_BANK
    0x00824AFC, // TRACK_ELEM_RIGHT_BANK
    0x00824B0C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x00824B1C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x00824B2C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x00824B3C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x00824B4C, // TRACK_ELEM_S_BEND_LEFT
    0x00824B5C, // TRACK_ELEM_S_BEND_RIGHT
    0x00824B6C, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x00824B7C, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x00824BBC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00824BCC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x00824BDC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x00824BEC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x00824BFC, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x00824C0C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x00824C1C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x00824C2C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00824C9C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x00824CAC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x00824CBC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x00824CCC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x00824CDC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x00824CEC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x00824CFC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x00824D0C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x00824D3C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x00824D1C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x00824D2C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x00824D4C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x00824D5C, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00824D6C, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00824D8C, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x00824D9C, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x00824DAC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x00824DBC, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x00824DCC, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x00824DDC, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x00824DEC, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x00824DFC, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x00824D7C, // TRACK_ELEM_DIAG_FLAT
    0x00824E2C, // TRACK_ELEM_DIAG_25_DEG_UP
    0x00824E8C, // TRACK_ELEM_DIAG_60_DEG_UP
    0x00824E0C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x00824E6C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x00824E7C, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x00824E1C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x00824E5C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x00824EBC, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x00824E3C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x00824E9C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x00824EAC, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x00824E4C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x00824EEC, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x00824EFC, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x00824F0C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x00824F1C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x00824F4C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x00824F5C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x00824F2C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x00824F3C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x00824F6C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x00824F7C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x00824F8C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x00824F9C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x00824ECC, // TRACK_ELEM_DIAG_LEFT_BANK
    0x00824EDC, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00824FAC, // TRACK_ELEM_LEFT_FLYER_TWIST_UP
    0x00824FBC, // TRACK_ELEM_RIGHT_FLYER_TWIST_UP
    0x00824FCC, // TRACK_ELEM_LEFT_FLYER_TWIST_DOWN
    0x00824FDC, // TRACK_ELEM_RIGHT_FLYER_TWIST_DOWN
    0x00824C3C, // TRACK_ELEM_FLYER_HALF_LOOP_UP
    0x00824C4C, // TRACK_ELEM_FLYER_HALF_LOOP_DOWN
    0x00824C5C, // TRACK_ELEM_LEFT_FLYER_CORKSCREW_UP
    0x00824C6C, // TRACK_ELEM_RIGHT_FLYER_CORKSCREW_UP
    0x00824C7C, // TRACK_ELEM_LEFT_FLYER_CORKSCREW_DOWN
    0x00824C8C, // TRACK_ELEM_RIGHT_FLYER_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00824FEC, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0086347C */
static constexpr const uint32 _OldSuspendedMonorailTrackPaintFunctions[256] = {
    0x008636F4, // TRACK_ELEM_FLAT
    0x008637A4, // TRACK_ELEM_END_STATION
    0x008637B4, // TRACK_ELEM_BEGIN_STATION
    0x008637C4, // TRACK_ELEM_MIDDLE_STATION
    0x00863704, // TRACK_ELEM_25_DEG_UP
    0,
    0x00863714, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00863724, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00863734, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x00863744, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x00863754, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x00863764, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x00863774, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00863784, // TRACK_ELEM_S_BEND_LEFT
    0x00863794, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008637D4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008637E4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00863864, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x00863874, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x00863884, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x00863894, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0,
    0,
    0,
    0,
    0x008637F4, // TRACK_ELEM_DIAG_FLAT
    0x00863824, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x00863804, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x00863814, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x00863854, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x00863834, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x00863844, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0086E2F8 */
static constexpr const uint32 _OldReverserRollerCoasterTrackPaintFunctions[256] = {
    0x0086E65C, // TRACK_ELEM_FLAT
    0x0086E70C, // TRACK_ELEM_END_STATION
    0x0086E71C, // TRACK_ELEM_BEGIN_STATION
    0x0086E72C, // TRACK_ELEM_MIDDLE_STATION
    0x0086E66C, // TRACK_ELEM_25_DEG_UP
    0,
    0x0086E67C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0086E68C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0086E69C, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0086E6AC, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0086E6BC, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x0086E6CC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0086E6DC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0086E6EC, // TRACK_ELEM_S_BEND_LEFT
    0x0086E6FC, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x0086E73C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0086E74C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0086E75C, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0086E76C, // TRACK_ELEM_LEFT_REVERSER
    0x0086E77C, // TRACK_ELEM_RIGHT_REVERSER
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00876618 */
static constexpr const uint32 _OldHeartlineTwisterCoasterTrackPaintFunctions[256] = {
    0x0087694C, // TRACK_ELEM_FLAT
    0x00876A1C, // TRACK_ELEM_END_STATION
    0x00876A2C, // TRACK_ELEM_BEGIN_STATION
    0x00876A3C, // TRACK_ELEM_MIDDLE_STATION
    0x0087695C, // TRACK_ELEM_25_DEG_UP
    0x008769FC, // TRACK_ELEM_60_DEG_UP
    0x0087696C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008769BC, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008769CC, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x0087697C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0087698C, // TRACK_ELEM_25_DEG_DOWN
    0x00876A0C, // TRACK_ELEM_60_DEG_DOWN
    0x0087699C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008769DC, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008769EC, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008769AC, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00876A6C, // TRACK_ELEM_HEARTLINE_TRANSFER_UP
    0x00876A7C, // TRACK_ELEM_HEARTLINE_TRANSFER_DOWN
    0x00876A4C, // TRACK_ELEM_LEFT_HEARTLINE_ROLL
    0x00876A5C, // TRACK_ELEM_RIGHT_HEARTLINE_ROLL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0087EDC4 */
static constexpr const uint32 _OldMiniGolfTrackPaintFunctions[256] = {
    0x0087F10C, // TRACK_ELEM_FLAT
    0x0087F17C, // TRACK_ELEM_END_STATION
    0x0087F18C, // TRACK_ELEM_BEGIN_STATION
    0x0087F19C, // TRACK_ELEM_MIDDLE_STATION
    0x0087F11C, // TRACK_ELEM_25_DEG_UP
    0,
    0x0087F12C, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x0087F13C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x0087F14C, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x0087F15C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x0087F16C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0087F1AC, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x0087F1BC, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0087F1CC, // TRACK_ELEM_MINI_GOLF_HOLE_A
    0x0087F1DC, // TRACK_ELEM_MINI_GOLF_HOLE_B
    0x0087F1EC, // TRACK_ELEM_MINI_GOLF_HOLE_C
    0x0087F1FC, // TRACK_ELEM_MINI_GOLF_HOLE_D
    0x0087F20C, // TRACK_ELEM_MINI_GOLF_HOLE_E
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AD280 */
static constexpr const uint32 _OldGigaCoasterTrackPaintFunctions[256] = {
    0x008AD674, // TRACK_ELEM_FLAT
    0x008AD8C4, // TRACK_ELEM_END_STATION
    0x008AD8D4, // TRACK_ELEM_BEGIN_STATION
    0x008AD8E4, // TRACK_ELEM_MIDDLE_STATION
    0x008AD684, // TRACK_ELEM_25_DEG_UP
    0x008AD694, // TRACK_ELEM_60_DEG_UP
    0x008AD6A4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AD6B4, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AD6C4, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AD6D4, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AD6E4, // TRACK_ELEM_25_DEG_DOWN
    0x008AD6F4, // TRACK_ELEM_60_DEG_DOWN
    0x008AD704, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AD714, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AD724, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AD734, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AD744, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AD754, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AD764, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AD774, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AD784, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AD794, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AD7A4, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AD7B4, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AD7C4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AD7D4, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AD7E4, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AD7F4, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AD804, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AD814, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AD824, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AD834, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AD844, // TRACK_ELEM_LEFT_BANK
    0x008AD854, // TRACK_ELEM_RIGHT_BANK
    0x008AD864, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AD874, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AD884, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AD894, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AD8A4, // TRACK_ELEM_S_BEND_LEFT
    0x008AD8B4, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AD8F4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AD904, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AD914, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AD924, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AD934, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AD944, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AD954, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AD964, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AD974, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008AD984, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008AD994, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AD9A4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AD9B4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008AD9C4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008AD9D4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008AD9E4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008ADA14, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008AD9F4, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008ADA04, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008ADA24, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008ADA34, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ADC84, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008ADC94, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008ADA44, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008ADCA4, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008ADCB4, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0x008ADED4, // TRACK_ELEM_FLAT_TO_60_DEG_UP_LONG_BASE
    0x008ADEE4, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE
    0,
    0x008ADEF4, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN_LONG_BASE
    0x008ADF04, // TRACK_ELEM_60_DEG_UP_TO_FLAT_LONG_BASE_122
    0x008ADF14, // TRACK_ELEM_CABLE_LIFT_HILL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ADA64, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008ADA74, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008ADA84, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008ADA94, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008ADAA4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008ADAB4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008ADAC4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008ADAD4, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008ADA54, // TRACK_ELEM_DIAG_FLAT
    0x008ADB04, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008ADB64, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008ADAE4, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008ADB44, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008ADB54, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008ADAF4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008ADB34, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008ADB94, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008ADB14, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008ADB74, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008ADB84, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008ADB24, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008ADBC4, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008ADBD4, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008ADBE4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008ADBF4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008ADC24, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008ADC34, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008ADC04, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008ADC14, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008ADC44, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008ADC54, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008ADC64, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008ADC74, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008ADBA4, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008ADBB4, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008ADEC4, // TRACK_ELEM_BLOCK_BRAKES
    0x008ADCC4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ADCD4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008ADCE4, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ADCF4, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008ADD04, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ADD14, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008ADD24, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ADD34, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008ADD44, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008ADD54, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008ADD64, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ADD74, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008ADD84, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ADD94, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ADDA4, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ADDB4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008ADDC4, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008ADDD4, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008ADE04, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008ADE14, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008ADE24, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ADE34, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ADDE4, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008ADDF4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008ADE44, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008ADE54, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008ADE64, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008ADE74, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008ADE84, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008ADE94, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008ADEA4, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008ADEB4, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00886074 */
static constexpr const uint32 _OldRoToDropTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00886194, // TRACK_ELEM_TOWER_BASE
    0x008861A4, // TRACK_ELEM_TOWER_SECTION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00887208 */
static constexpr const uint32 _OldFlyingSaucersTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008873D8, // 111
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00889C28 */
static constexpr const uint32 _OldCrookedHouseTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00889E28, // 123
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0088AC88 */
static constexpr const uint32 _OldMonorailCyclesTrackPaintFunctions[256] = {
    0x0088AD48, // TRACK_ELEM_FLAT
    0x0088AD58, // TRACK_ELEM_END_STATION
    0x0088AD68, // TRACK_ELEM_BEGIN_STATION
    0x0088AD78, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0088ADA8, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0088ADB8, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0088ADC8, // TRACK_ELEM_S_BEND_LEFT
    0x0088ADD8, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x0088AD88, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x0088AD98, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AE36C */
static constexpr const uint32 _OldCompactInvertedCoasterTrackPaintFunctions[256] = {
    0x008AE6E0, // TRACK_ELEM_FLAT
    0x008AE950, // TRACK_ELEM_END_STATION
    0x008AE960, // TRACK_ELEM_BEGIN_STATION
    0x008AE970, // TRACK_ELEM_MIDDLE_STATION
    0x008AE6F0, // TRACK_ELEM_25_DEG_UP
    0x008AE700, // TRACK_ELEM_60_DEG_UP
    0x008AE710, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AE720, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AE730, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AE740, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AE750, // TRACK_ELEM_25_DEG_DOWN
    0x008AE760, // TRACK_ELEM_60_DEG_DOWN
    0x008AE770, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AE780, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AE790, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AE7A0, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AE7B0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AE7C0, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AE7D0, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AE7E0, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AE7F0, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AE800, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AE810, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AE820, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AE830, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AE840, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AE850, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AE860, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AE870, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AE880, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AE890, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AE8A0, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AE8B0, // TRACK_ELEM_LEFT_BANK
    0x008AE8C0, // TRACK_ELEM_RIGHT_BANK
    0x008AE8D0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AE8E0, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AE8F0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AE900, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AE910, // TRACK_ELEM_S_BEND_LEFT
    0x008AE920, // TRACK_ELEM_S_BEND_RIGHT
    0x008AE930, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008AE940, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008AE980, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AE990, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AE9A0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AE9B0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AE9C0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AE9D0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AE9E0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AE9F0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0x008AEA00, // TRACK_ELEM_LEFT_TWIST_DOWN_TO_UP
    0x008AEA10, // TRACK_ELEM_RIGHT_TWIST_DOWN_TO_UP
    0x008AEA20, // TRACK_ELEM_LEFT_TWIST_UP_TO_DOWN
    0x008AEA30, // TRACK_ELEM_RIGHT_TWIST_UP_TO_DOWN
    0x008AEA40, // TRACK_ELEM_HALF_LOOP_UP
    0x008AEA50, // TRACK_ELEM_HALF_LOOP_DOWN
    0x008AEA60, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008AEA70, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008AEA80, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008AEA90, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AEAD0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008AEAB0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008AEAC0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008AEAE0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008AEAA0, // TRACK_ELEM_BRAKES
    0,
    0,
    0x008AEAF0, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_UP
    0x008AEB00, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_UP
    0x008AEB10, // TRACK_ELEM_LEFT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0x008AEB20, // TRACK_ELEM_RIGHT_QUARTER_BANKED_HELIX_LARGE_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AEB30, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AEDB0, // TRACK_ELEM_90_DEG_UP
    0x008AEDC0, // TRACK_ELEM_90_DEG_DOWN
    0x008AED70, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x008AED80, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x008AED90, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x008AEDA0, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0,
    0x008AEB40, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AEB50, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AEB60, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AEB70, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008AED30, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008AED40, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008AED50, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AED60, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AEB80, // TRACK_ELEM_DIAG_FLAT
    0x008AEBB0, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008AEC10, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008AEB90, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008AEBF0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008AEC00, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008AEBA0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AEBE0, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008AEC40, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008AEBC0, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008AEC20, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AEC30, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AEBD0, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008AEC70, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008AEC80, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008AEC90, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008AECA0, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008AECD0, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008AECE0, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008AECB0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008AECC0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008AECF0, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008AED00, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AED10, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008AED20, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AEC50, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008AEC60, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AEAA0, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AEDE0 */
static constexpr const uint32 _OldWaterCoasterTrackPaintFunctions[256] = {
    0x008AF154, // TRACK_ELEM_FLAT
    0x008AF2A4, // TRACK_ELEM_END_STATION
    0x008AF2B4, // TRACK_ELEM_BEGIN_STATION
    0x008AF2C4, // TRACK_ELEM_MIDDLE_STATION
    0x008AF164, // TRACK_ELEM_25_DEG_UP
    0x008AF174, // TRACK_ELEM_60_DEG_UP
    0x008AF184, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008AF194, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008AF1A4, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008AF1B4, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008AF1C4, // TRACK_ELEM_25_DEG_DOWN
    0x008AF1D4, // TRACK_ELEM_60_DEG_DOWN
    0x008AF1E4, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008AF1F4, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AF204, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AF214, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008AF224, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AF234, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AF454, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AF464, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AF474, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AF484, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AF494, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AF4A4, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008AF4B4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008AF4C4, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008AF4D4, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008AF4E4, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008AF4F4, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008AF504, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AF514, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008AF524, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AF534, // TRACK_ELEM_LEFT_BANK
    0x008AF544, // TRACK_ELEM_RIGHT_BANK
    0x008AF244, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AF254, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008AF264, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AF274, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008AF284, // TRACK_ELEM_S_BEND_LEFT
    0x008AF294, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008AF2D4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008AF2E4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008AF554, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008AF564, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008AF2F4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AF304, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008AF314, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008AF324, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AF714, // TRACK_ELEM_FLAT_COVERED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AF724, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_COVERED
    0x008AF734, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_COVERED
    0,
    0,
    0,
    0,
    0x008AF574, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008AF584, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008AF594, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AF5A4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008AF5B4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008AF5C4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008AF5D4, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008AF5E4, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0x008AF334, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AF414, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008AF424, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008AF434, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008AF444, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008AF5F4, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008AF604, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008AF614, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AF624, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008AF344, // TRACK_ELEM_DIAG_FLAT
    0x008AF374, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008AF3A4, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008AF354, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008AF384, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008AF394, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008AF364, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008AF3D4, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008AF404, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008AF3B4, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008AF3E4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008AF3F4, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008AF3C4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008AF654, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008AF664, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008AF674, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008AF684, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008AF6B4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008AF6C4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008AF694, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008AF6A4, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008AF6D4, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008AF6E4, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008AF6F4, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008AF704, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008AF634, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008AF644, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AF744, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008AF764 */
static constexpr const uint32 _OldAirPoweredVerticalCoasterTrackPaintFunctions[256] = {
    0x008AFAD4, // TRACK_ELEM_FLAT
    0x008AFAE4, // TRACK_ELEM_END_STATION
    0x008AFAF4, // TRACK_ELEM_BEGIN_STATION
    0x008AFB04, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFB54, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008AFB64, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008AFB74, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008AFB84, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008AFB94, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008AFBA4, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008AFBB4, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008AFBC4, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFBD4, // TRACK_ELEM_LEFT_BANK
    0x008AFBE4, // TRACK_ELEM_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFC04, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFB14, // TRACK_ELEM_REVERSE_FREEFALL_SLOPE
    0x008AFB34, // TRACK_ELEM_REVERSE_FREEFALL_VERTICAL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008AFBF4, // TRACK_ELEM_AIR_THRUST_TOP_CAP
    0x008AFB44, // TRACK_ELEM_AIR_THRUST_VERTICAL_DOWN
    0x008AFB24, // TRACK_ELEM_AIR_THRUST_VERTICAL_DOWN_TO_LEVEL
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00890940 */
static constexpr const uint32 _OldInvertedHairpinCoasterTrackPaintFunctions[256] = {
    0x00890CB4, // TRACK_ELEM_FLAT
    0x00890D84, // TRACK_ELEM_END_STATION
    0x00890D94, // TRACK_ELEM_BEGIN_STATION
    0x00890DA4, // TRACK_ELEM_MIDDLE_STATION
    0x00890CC4, // TRACK_ELEM_25_DEG_UP
    0x00890CD4, // TRACK_ELEM_60_DEG_UP
    0x00890CE4, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x00890CF4, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x00890D04, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x00890D14, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x00890D24, // TRACK_ELEM_25_DEG_DOWN
    0x00890D34, // TRACK_ELEM_60_DEG_DOWN
    0x00890D44, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x00890D54, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x00890D64, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x00890D74, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00890DB4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00890DC4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0x00890DD4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x00890DE4, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x00890DF4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x00890E04, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x00890E64, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00890E74, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00890E24, // TRACK_ELEM_FLAT_TO_60_DEG_UP
    0x00890E34, // TRACK_ELEM_60_DEG_UP_TO_FLAT
    0x00890E44, // TRACK_ELEM_FLAT_TO_60_DEG_DOWN
    0x00890E54, // TRACK_ELEM_60_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00890E14, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00890E84, // TRACK_ELEM_BLOCK_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x00898384 */
static constexpr const uint32 _OldMagicCarpetTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x00898514, // 95
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008995D4 */
static constexpr const uint32 _OldSubmarineRideTrackPaintFunctions[256] = {
    0x008996B4, // TRACK_ELEM_FLAT
    0x008996C4, // TRACK_ELEM_END_STATION
    0x008996D4, // TRACK_ELEM_BEGIN_STATION
    0x008996E4, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008996F4, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x00899704, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0x00899714, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE
    0x00899724, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x0089B0C0 */
static constexpr const uint32 _OldRiverRaftsTrackPaintFunctions[256] = {
    0x0089B170, // TRACK_ELEM_FLAT
    0x0089B1A0, // TRACK_ELEM_END_STATION
    0x0089B1B0, // TRACK_ELEM_BEGIN_STATION
    0x0089B1C0, // TRACK_ELEM_MIDDLE_STATION
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0089B1D0, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x0089B1E0, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x0089B180, // TRACK_ELEM_S_BEND_LEFT
    0x0089B190, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A13B4 */
static constexpr const uint32 _OldEnterpriseTrackPaintFunctions[256] = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A1584, // 111
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008B005C */
static constexpr const uint32 _OldInvertedImpulseCoasterTrackPaintFunctions[256] = {
    0x008B0460, // TRACK_ELEM_FLAT
    0x008B0470, // TRACK_ELEM_END_STATION
    0x008B0480, // TRACK_ELEM_BEGIN_STATION
    0x008B0490, // TRACK_ELEM_MIDDLE_STATION
    0x008B04A0, // TRACK_ELEM_25_DEG_UP
    0x008B04B0, // TRACK_ELEM_60_DEG_UP
    0x008B04C0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008B04D0, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008B04E0, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008B04F0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008B0500, // TRACK_ELEM_25_DEG_DOWN
    0x008B0510, // TRACK_ELEM_60_DEG_DOWN
    0x008B0520, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008B0530, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008B0540, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008B0550, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B05A0, // TRACK_ELEM_90_DEG_UP
    0x008B05B0, // TRACK_ELEM_90_DEG_DOWN
    0x008B0560, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x008B0570, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x008B0580, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x008B0590, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B05C0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008B05D0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008B05E0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0x008B05F0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0,
    0,
    0,
};

/** rct2: 0x008A46D8 */
static constexpr const uint32 _OldMiniRollerCoasterTrackPaintFunctions[256] = {
    0x008A4ABC, // TRACK_ELEM_FLAT
    0x008A4D0C, // TRACK_ELEM_END_STATION
    0x008A4D1C, // TRACK_ELEM_BEGIN_STATION
    0x008A4D2C, // TRACK_ELEM_MIDDLE_STATION
    0x008A4ACC, // TRACK_ELEM_25_DEG_UP
    0x008A4ADC, // TRACK_ELEM_60_DEG_UP
    0x008A4AEC, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A4AFC, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A4B0C, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A4B1C, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A4B2C, // TRACK_ELEM_25_DEG_DOWN
    0x008A4B3C, // TRACK_ELEM_60_DEG_DOWN
    0x008A4B4C, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A4B5C, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A4B6C, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A4B7C, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A4B8C, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A4B9C, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A4BAC, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A4BBC, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A4BCC, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A4BDC, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A4BEC, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A4BFC, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A4C0C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A4C1C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A4C2C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A4C3C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A4C4C, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A4C5C, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A4C6C, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A4C7C, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A4C8C, // TRACK_ELEM_LEFT_BANK
    0x008A4C9C, // TRACK_ELEM_RIGHT_BANK
    0x008A4CAC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A4CBC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A4CCC, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A4CDC, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A4CEC, // TRACK_ELEM_S_BEND_LEFT
    0x008A4CFC, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008A4D3C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A4D4C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A4D5C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A4D6C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A4D7C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A4D8C, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A4D9C, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A4DAC, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A4DBC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A4DCC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A4DDC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A4DEC, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A4DFC, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A4E0C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A4E1C, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A4E2C, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A4E5C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A4E3C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A4E4C, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A4E6C, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A4E7C, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A50CC, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008A50DC, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008A4E8C, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008A50EC, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008A50FC, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A4EAC, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A4EBC, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A4ECC, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A4EDC, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A4EEC, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A4EFC, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A4F0C, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A4F1C, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A4E9C, // TRACK_ELEM_DIAG_FLAT
    0x008A4F4C, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A4FAC, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A4F2C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A4F8C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A4F9C, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A4F3C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A4F7C, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A4FDC, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A4F5C, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A4FBC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A4FCC, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A4F6C, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A500C, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A501C, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A502C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A503C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A506C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A507C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A504C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A505C, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A508C, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A509C, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A50AC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A50BC, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A4FEC, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A4FFC, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A530C, // TRACK_ELEM_BLOCK_BRAKES
    0x008A510C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A511C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A512C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A513C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A514C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A515C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A516C, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A517C, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A518C, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008A519C, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008A51AC, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A51BC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A51CC, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A51DC, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A51EC, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A51FC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A520C, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A521C, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A524C, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008A525C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008A526C, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A527C, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A522C, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008A523C, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008A528C, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A529C, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A52AC, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008A52BC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008A52CC, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A52DC, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A52EC, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A52FC, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008B0610 */
static constexpr const uint32 _OldMineRideTrackPaintFunctions[256] = {
    0x008B08D0, // TRACK_ELEM_FLAT
    0x008B0A80, // TRACK_ELEM_END_STATION
    0x008B0A90, // TRACK_ELEM_BEGIN_STATION
    0x008B0AA0, // TRACK_ELEM_MIDDLE_STATION
    0x008B08E0, // TRACK_ELEM_25_DEG_UP
    0,
    0x008B08F0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008B0900, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008B0910, // TRACK_ELEM_25_DEG_DOWN
    0,
    0x008B0920, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008B0930, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008B0940, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008B0950, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008B0960, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008B0970, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008B0980, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008B0990, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008B09A0, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008B09B0, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008B09C0, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008B09D0, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008B09E0, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008B09F0, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008B0A00, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008B0A10, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008B0A20, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008B0A30, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008B0A40, // TRACK_ELEM_LEFT_BANK
    0x008B0A50, // TRACK_ELEM_RIGHT_BANK
    0,
    0,
    0,
    0,
    0x008B0A60, // TRACK_ELEM_S_BEND_LEFT
    0x008B0A70, // TRACK_ELEM_S_BEND_RIGHT
    0,
    0,
    0x008B0AB0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008B0AC0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008B0AD0, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008B0AE0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B0AF0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008B0B00, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008B0B10, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008B0B20, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008B0B30, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008B0B40, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008B0B50, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008B0B60, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B0B70, // TRACK_ELEM_ON_RIDE_PHOTO
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008B0B90, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008B0BA0, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008B0BB0, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008B0BC0, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008B0BD0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008B0BE0, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008B0BF0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008B0C00, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008B0B80, // TRACK_ELEM_DIAG_FLAT
    0x008B0C30, // TRACK_ELEM_DIAG_25_DEG_UP
    0,
    0x008B0C10, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0,
    0,
    0x008B0C20, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008B0C60, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0,
    0x008B0C40, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0,
    0,
    0x008B0C50, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008B0C90, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008B0CA0, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008B0CB0, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008B0CC0, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008B0CF0, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008B0D00, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008B0CD0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008B0CE0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008B0D10, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008B0D20, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008B0D30, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008B0D40, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008B0C70, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008B0C80, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
};

/** rct2: 0x008A5F6C */
static constexpr const uint32 _OldLimLaunchedRollerCoasterTrackPaintFunctions[256] = {
    0x008A6370, // TRACK_ELEM_FLAT
    0x008A6D50, // TRACK_ELEM_END_STATION
    0x008A6D60, // TRACK_ELEM_BEGIN_STATION
    0x008A6D70, // TRACK_ELEM_MIDDLE_STATION
    0x008A6380, // TRACK_ELEM_25_DEG_UP
    0x008A6390, // TRACK_ELEM_60_DEG_UP
    0x008A63A0, // TRACK_ELEM_FLAT_TO_25_DEG_UP
    0x008A63B0, // TRACK_ELEM_25_DEG_UP_TO_60_DEG_UP
    0x008A63C0, // TRACK_ELEM_60_DEG_UP_TO_25_DEG_UP
    0x008A63D0, // TRACK_ELEM_25_DEG_UP_TO_FLAT
    0x008A63E0, // TRACK_ELEM_25_DEG_DOWN
    0x008A63F0, // TRACK_ELEM_60_DEG_DOWN
    0x008A6400, // TRACK_ELEM_FLAT_TO_25_DEG_DOWN
    0x008A6410, // TRACK_ELEM_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A6420, // TRACK_ELEM_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6430, // TRACK_ELEM_25_DEG_DOWN_TO_FLAT
    0x008A6440, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES
    0x008A6450, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES
    0x008A6460, // TRACK_ELEM_FLAT_TO_LEFT_BANK
    0x008A6470, // TRACK_ELEM_FLAT_TO_RIGHT_BANK
    0x008A6480, // TRACK_ELEM_LEFT_BANK_TO_FLAT
    0x008A6490, // TRACK_ELEM_RIGHT_BANK_TO_FLAT
    0x008A64A0, // TRACK_ELEM_BANKED_LEFT_QUARTER_TURN_5_TILES
    0x008A64B0, // TRACK_ELEM_BANKED_RIGHT_QUARTER_TURN_5_TILES
    0x008A64C0, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_UP
    0x008A64D0, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_UP
    0x008A64E0, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANK
    0x008A64F0, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANK
    0x008A6500, // TRACK_ELEM_LEFT_BANK_TO_25_DEG_DOWN
    0x008A6510, // TRACK_ELEM_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A6520, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANK
    0x008A6530, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A6540, // TRACK_ELEM_LEFT_BANK
    0x008A6550, // TRACK_ELEM_RIGHT_BANK
    0x008A6560, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A6570, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_UP
    0x008A6580, // TRACK_ELEM_LEFT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A6590, // TRACK_ELEM_RIGHT_QUARTER_TURN_5_TILES_25_DEG_DOWN
    0x008A65A0, // TRACK_ELEM_S_BEND_LEFT
    0x008A65B0, // TRACK_ELEM_S_BEND_RIGHT
    0x008A65E0, // TRACK_ELEM_LEFT_VERTICAL_LOOP
    0x008A65F0, // TRACK_ELEM_RIGHT_VERTICAL_LOOP
    0x008A6630, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES
    0x008A6640, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES
    0x008A6650, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_BANK
    0x008A6660, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_BANK
    0x008A6670, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A6680, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_UP
    0x008A6690, // TRACK_ELEM_LEFT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0x008A66A0, // TRACK_ELEM_RIGHT_QUARTER_TURN_3_TILES_25_DEG_DOWN
    0,
    0,
    0x008A6D10, // TRACK_ELEM_LEFT_TWIST_DOWN_TO_UP
    0x008A6D20, // TRACK_ELEM_RIGHT_TWIST_DOWN_TO_UP
    0x008A6D30, // TRACK_ELEM_LEFT_TWIST_UP_TO_DOWN
    0x008A6D40, // TRACK_ELEM_RIGHT_TWIST_UP_TO_DOWN
    0,
    0,
    0x008A6CD0, // TRACK_ELEM_LEFT_CORKSCREW_UP
    0x008A6CE0, // TRACK_ELEM_RIGHT_CORKSCREW_UP
    0x008A6CF0, // TRACK_ELEM_LEFT_CORKSCREW_DOWN
    0x008A6D00, // TRACK_ELEM_RIGHT_CORKSCREW_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A66B0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_SMALL
    0x008A66C0, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_SMALL
    0x008A66D0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A66E0, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_SMALL
    0x008A66F0, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_UP_LARGE
    0x008A6700, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_UP_LARGE
    0x008A6710, // TRACK_ELEM_LEFT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A6720, // TRACK_ELEM_RIGHT_HALF_BANKED_HELIX_DOWN_LARGE
    0x008A6750, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A6730, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_UP
    0x008A6740, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A6760, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_60_DEG_DOWN
    0x008A6D80, // TRACK_ELEM_BRAKES
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6A40, // TRACK_ELEM_25_DEG_UP_LEFT_BANKED
    0x008A6A50, // TRACK_ELEM_25_DEG_UP_RIGHT_BANKED
    0,
    0,
    0x008A6780, // TRACK_ELEM_ON_RIDE_PHOTO
    0x008A6A60, // TRACK_ELEM_25_DEG_DOWN_LEFT_BANKED
    0x008A6A70, // TRACK_ELEM_25_DEG_DOWN_RIGHT_BANKED
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6C10, // TRACK_ELEM_90_DEG_UP
    0x008A6C20, // TRACK_ELEM_90_DEG_DOWN
    0x008A6C30, // TRACK_ELEM_60_DEG_UP_TO_90_DEG_UP
    0x008A6C40, // TRACK_ELEM_90_DEG_DOWN_TO_60_DEG_DOWN
    0x008A6C50, // TRACK_ELEM_90_DEG_UP_TO_60_DEG_UP
    0x008A6C60, // TRACK_ELEM_60_DEG_DOWN_TO_90_DEG_DOWN
    0,
    0x008A6860, // TRACK_ELEM_LEFT_EIGHTH_TO_DIAG
    0x008A6870, // TRACK_ELEM_RIGHT_EIGHTH_TO_DIAG
    0x008A6880, // TRACK_ELEM_LEFT_EIGHTH_TO_ORTHOGONAL
    0x008A6890, // TRACK_ELEM_RIGHT_EIGHTH_TO_ORTHOGONAL
    0x008A68A0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_DIAG
    0x008A68B0, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_DIAG
    0x008A68C0, // TRACK_ELEM_LEFT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A68D0, // TRACK_ELEM_RIGHT_EIGHTH_BANK_TO_ORTHOGONAL
    0x008A6790, // TRACK_ELEM_DIAG_FLAT
    0x008A67C0, // TRACK_ELEM_DIAG_25_DEG_UP
    0x008A67F0, // TRACK_ELEM_DIAG_60_DEG_UP
    0x008A67A0, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_UP
    0x008A67D0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_60_DEG_UP
    0x008A67E0, // TRACK_ELEM_DIAG_60_DEG_UP_TO_25_DEG_UP
    0x008A67B0, // TRACK_ELEM_DIAG_25_DEG_UP_TO_FLAT
    0x008A6820, // TRACK_ELEM_DIAG_25_DEG_DOWN
    0x008A6850, // TRACK_ELEM_DIAG_60_DEG_DOWN
    0x008A6800, // TRACK_ELEM_DIAG_FLAT_TO_25_DEG_DOWN
    0x008A6830, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_60_DEG_DOWN
    0x008A6840, // TRACK_ELEM_DIAG_60_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6810, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_FLAT
    0,
    0,
    0,
    0,
    0x008A6900, // TRACK_ELEM_DIAG_FLAT_TO_LEFT_BANK
    0x008A6910, // TRACK_ELEM_DIAG_FLAT_TO_RIGHT_BANK
    0x008A6920, // TRACK_ELEM_DIAG_LEFT_BANK_TO_FLAT
    0x008A6930, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_FLAT
    0x008A6960, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_UP
    0x008A6970, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_UP
    0x008A6940, // TRACK_ELEM_DIAG_25_DEG_UP_TO_LEFT_BANK
    0x008A6950, // TRACK_ELEM_DIAG_25_DEG_UP_TO_RIGHT_BANK
    0x008A6980, // TRACK_ELEM_DIAG_LEFT_BANK_TO_25_DEG_DOWN
    0x008A6990, // TRACK_ELEM_DIAG_RIGHT_BANK_TO_25_DEG_DOWN
    0x008A69A0, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_LEFT_BANK
    0x008A69B0, // TRACK_ELEM_DIAG_25_DEG_DOWN_TO_RIGHT_BANK
    0x008A68E0, // TRACK_ELEM_DIAG_LEFT_BANK
    0x008A68F0, // TRACK_ELEM_DIAG_RIGHT_BANK
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6C70, // TRACK_ELEM_90_DEG_TO_INVERTED_FLAT_QUARTER_LOOP_UP
    0x008A6C80, // TRACK_ELEM_INVERTED_FLAT_TO_90_DEG_QUARTER_LOOP_DOWN
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0x008A6D90, // TRACK_ELEM_BLOCK_BRAKES
    0x008A6BC0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A6BD0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_UP
    0x008A6BE0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A6BF0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_3_TILE_25_DEG_DOWN
    0x008A6B80, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A6B90, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_UP
    0x008A6BA0, // TRACK_ELEM_LEFT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A6BB0, // TRACK_ELEM_RIGHT_BANKED_QUARTER_TURN_5_TILE_25_DEG_DOWN
    0x008A6A80, // TRACK_ELEM_25_DEG_UP_TO_LEFT_BANKED_25_DEG_UP
    0x008A6A90, // TRACK_ELEM_25_DEG_UP_TO_RIGHT_BANKED_25_DEG_UP
    0x008A6AA0, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A6AB0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_25_DEG_UP
    0x008A6AC0, // TRACK_ELEM_25_DEG_DOWN_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6AD0, // TRACK_ELEM_25_DEG_DOWN_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6AE0, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6AF0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_25_DEG_DOWN
    0x008A6B00, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A6B10, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A6B40, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_LEFT_BANKED_FLAT
    0x008A6B50, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_RIGHT_BANKED_FLAT
    0x008A6B60, // TRACK_ELEM_LEFT_BANKED_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6B70, // TRACK_ELEM_RIGHT_BANKED_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6B20, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_LEFT_BANKED_FLAT
    0x008A6B30, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_RIGHT_BANKED_FLAT
    0x008A69C0, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_UP
    0x008A69D0, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_UP
    0x008A69E0, // TRACK_ELEM_LEFT_BANKED_25_DEG_UP_TO_FLAT
    0x008A69F0, // TRACK_ELEM_RIGHT_BANKED_25_DEG_UP_TO_FLAT
    0x008A6A00, // TRACK_ELEM_FLAT_TO_LEFT_BANKED_25_DEG_DOWN
    0x008A6A10, // TRACK_ELEM_FLAT_TO_RIGHT_BANKED_25_DEG_DOWN
    0x008A6A20, // TRACK_ELEM_LEFT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A6A30, // TRACK_ELEM_RIGHT_BANKED_25_DEG_DOWN_TO_FLAT
    0x008A6C90, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008A6CA0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_UP
    0x008A6CB0, // TRACK_ELEM_LEFT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0x008A6CC0, // TRACK_ELEM_RIGHT_QUARTER_TURN_1_TILE_90_DEG_DOWN
    0,
    0,
    0,
};

static constexpr const uint32 _null[256] = {0};

const uint32 * RideTypeTrackPaintFunctionsOld[RIDE_TYPE_COUNT] = {
    _OldSpiralRollerCoasterTrackPaintFunctions,             // RIDE_TYPE_SPIRAL_ROLLER_COASTER
    _OldStandUpRollerCoasterTrackPaintFunctions,            // RIDE_TYPE_STAND_UP_ROLLER_COASTER
    _OldSuspendedSwingingCoasterTrackPaintFunctions,        // RIDE_TYPE_SUSPENDED_SWINGING_COASTER
    _OldInvertedRollerCoasterTrackPaintFunctions,           // RIDE_TYPE_INVERTED_ROLLER_COASTER
    _OldJuniorRollerCoasterTrackPaintFunctions,             // RIDE_TYPE_JUNIOR_ROLLER_COASTER
    _OldMiniatureRailwayTrackPaintFunctions,                // RIDE_TYPE_MINIATURE_RAILWAY
    _OldMonorailTrackPaintFunctions,                        // RIDE_TYPE_MONORAIL
    _OldMiniSuspendedCoasterTrackPaintFunctions,            // RIDE_TYPE_MINI_SUSPENDED_COASTER
    _OldBoatHireTrackPaintFunctions,                        // RIDE_TYPE_BOAT_HIRE
    _OldWoodenWildMouseTrackPaintFunctions,                 // RIDE_TYPE_WOODEN_WILD_MOUSE
    _OldSteeplechaseTrackPaintFunctions,                    // RIDE_TYPE_STEEPLECHASE
    _OldCarRideTrackPaintFunctions,                         // RIDE_TYPE_CAR_RIDE
    _OldLaunchedFreefallTrackPaintFunctions,                // RIDE_TYPE_LAUNCHED_FREEFALL
    _OldBobsleighCoasterTrackPaintFunctions,                // RIDE_TYPE_BOBSLEIGH_COASTER
    _OldObservationTowerTrackPaintFunctions,                // RIDE_TYPE_OBSERVATION_TOWER
    _OldLoopingRollerCoasterTrackPaintFunctions,            // RIDE_TYPE_LOOPING_ROLLER_COASTER
    _OldDinghySlideTrackPaintFunctions,                     // RIDE_TYPE_DINGHY_SLIDE
    _OldMineTrainCoasterTrackPaintFunctions,                // RIDE_TYPE_MINE_TRAIN_COASTER
    _OldChairliftTrackPaintFunctions,                       // RIDE_TYPE_CHAIRLIFT
    _OldCorkscrewRollerCoasterTrackPaintFunctions,          // RIDE_TYPE_CORKSCREW_ROLLER_COASTER
    _OldMazeTrackPaintFunctions,                            // RIDE_TYPE_MAZE
    _OldSpiralSlideTrackPaintFunctions,                     // RIDE_TYPE_SPIRAL_SLIDE
    _OldGoKartsTrackPaintFunctions,                         // RIDE_TYPE_GO_KARTS
    _OldLogFlumeTrackPaintFunctions,                        // RIDE_TYPE_LOG_FLUME
    _OldRiverRapidsTrackPaintFunctions,                     // RIDE_TYPE_RIVER_RAPIDS
    _OldDodgemsTrackPaintFunctions,                         // RIDE_TYPE_DODGEMS
    _OldPirateShipTrackPaintFunctions,                      // RIDE_TYPE_SWINGING_SHIP
    _OldSwingingInverterShipTrackPaintFunctions,            // RIDE_TYPE_SWINGING_INVERTER_SHIP
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_FOOD_STALL
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_1D
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_DRINK_STALL
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_1F
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_SHOP
    _OldMerryGoRoundTrackPaintFunctions,                    // RIDE_TYPE_MERRY_GO_ROUND
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_22
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_INFORMATION_KIOSK
    _OldFacilityTrackPaintFunctions,                        // RIDE_TYPE_TOILETS
    _OldFerrisWheelTrackPaintFunctions,                     // RIDE_TYPE_FERRIS_WHEEL
    _OldMotionSimulatorTrackPaintFunctions,                 // RIDE_TYPE_MOTION_SIMULATOR
    _Old3DCinemaTrackPaintFunctions,                        // RIDE_TYPE_3D_CINEMA
    _OldTopSpinTrackPaintFunctions,                         // RIDE_TYPE_TOP_SPIN
    _OldSpaceRingsTrackPaintFunctions,                      // RIDE_TYPE_SPACE_RINGS
    _OldReverseFreefallCoasterTrackPaintFunctions,          // RIDE_TYPE_REVERSE_FREEFALL_COASTER
    _OldLiftTrackPaintFunctions,                            // RIDE_TYPE_LIFT
    _OldVerticalDropRollerCoasterTrackPaintFunctions,       // RIDE_TYPE_VERTICAL_DROP_ROLLER_COASTER
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_CASH_MACHINE
    _OldTwistTrackPaintFunctions,                           // RIDE_TYPE_TWIST
    _OldHauntedHouseTrackPaintFunctions,                    // RIDE_TYPE_HAUNTED_HOUSE
    _OldFacilityTrackPaintFunctions,                        // RIDE_TYPE_FIRST_AID
    _OldCircusShowTrackPaintFunctions,                      // RIDE_TYPE_CIRCUS
    _OldGhostTrainTrackPaintFunctions,                      // RIDE_TYPE_GHOST_TRAIN
    _OldTwisterRollerCoasterTrackPaintFunctions,            // RIDE_TYPE_TWISTER_ROLLER_COASTER
    _OldWoodenRollerCoasterTrackPaintFunctions,             // RIDE_TYPE_WOODEN_ROLLER_COASTER
    _OldSideFrictionRollerCoasterTrackPaintFunctions,       // RIDE_TYPE_SIDE_FRICTION_ROLLER_COASTER
    _OldWildMouseTrackPaintFunctions,                       // RIDE_TYPE_STEEL_WILD_MOUSE
    _OldMultiDimensionRollerCoasterTrackPaintFunctions,     // RIDE_TYPE_MULTI_DIMENSION_ROLLER_COASTER
    _OldMultiDimensionRollerCoasterTrackPaintFunctions,     // RIDE_TYPE_MULTI_DIMENSION_ROLLER_COASTER_ALT
    _OldFlyingRollerCoasterTrackPaintFunctions,             // RIDE_TYPE_FLYING_ROLLER_COASTER
    _OldFlyingRollerCoasterTrackPaintFunctions,             // RIDE_TYPE_FLYING_ROLLER_COASTER_ALT
    _OldVirginiaReelTrackPaintFunctions,                    // RIDE_TYPE_VIRGINIA_REEL
    _OldSplashBoatsTrackPaintFunctions,                     // RIDE_TYPE_SPLASH_BOATS
    _OldMiniHelicoptersTrackPaintFunctions,                 // RIDE_TYPE_MINI_HELICOPTERS
    _OldLayDownRollerCoasterTrackPaintFunctions,            // RIDE_TYPE_LAY_DOWN_ROLLER_COASTER
    _OldSuspendedMonorailTrackPaintFunctions,               // RIDE_TYPE_SUSPENDED_MONORAIL
    _OldLayDownRollerCoasterTrackPaintFunctions,            // RIDE_TYPE_LAY_DOWN_ROLLER_COASTER_ALT
    _OldReverserRollerCoasterTrackPaintFunctions,           // RIDE_TYPE_REVERSER_ROLLER_COASTER
    _OldHeartlineTwisterCoasterTrackPaintFunctions,         // RIDE_TYPE_HEARTLINE_TWISTER_COASTER
    _OldMiniGolfTrackPaintFunctions,                        // RIDE_TYPE_MINI_GOLF
    _OldGigaCoasterTrackPaintFunctions,                     // RIDE_TYPE_GIGA_COASTER
    _OldRoToDropTrackPaintFunctions,                        // RIDE_TYPE_ROTO_DROP
    _OldFlyingSaucersTrackPaintFunctions,                   // RIDE_TYPE_FLYING_SAUCERS
    _OldCrookedHouseTrackPaintFunctions,                    // RIDE_TYPE_CROOKED_HOUSE
    _OldMonorailCyclesTrackPaintFunctions,                  // RIDE_TYPE_MONORAIL_CYCLES
    _OldCompactInvertedCoasterTrackPaintFunctions,          // RIDE_TYPE_COMPACT_INVERTED_COASTER
    _OldWaterCoasterTrackPaintFunctions,                    // RIDE_TYPE_WATER_COASTER
    _OldAirPoweredVerticalCoasterTrackPaintFunctions,       // RIDE_TYPE_AIR_POWERED_VERTICAL_COASTER
    _OldInvertedHairpinCoasterTrackPaintFunctions,          // RIDE_TYPE_INVERTED_HAIRPIN_COASTER
    _OldMagicCarpetTrackPaintFunctions,                     // RIDE_TYPE_MAGIC_CARPET
    _OldSubmarineRideTrackPaintFunctions,                   // RIDE_TYPE_SUBMARINE_RIDE
    _OldRiverRaftsTrackPaintFunctions,                      // RIDE_TYPE_RIVER_RAFTS
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_50
    _OldEnterpriseTrackPaintFunctions,                      // RIDE_TYPE_ENTERPRISE
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_52
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_53
    _OldShopTrackPaintFunctions,                            // RIDE_TYPE_54
    _null,                                                  // RIDE_TYPE_55
    _OldInvertedImpulseCoasterTrackPaintFunctions,          // RIDE_TYPE_INVERTED_IMPULSE_COASTER
    _OldMiniRollerCoasterTrackPaintFunctions,               // RIDE_TYPE_MINI_ROLLER_COASTER
    _OldMineRideTrackPaintFunctions,                        // RIDE_TYPE_MINE_RIDE
    _null,                                                  // RIDE_TYPE_59
    _OldLimLaunchedRollerCoasterTrackPaintFunctions,        // RIDE_TYPE_LIM_LAUNCHED_ROLLER_COASTER
};
//clang-format on
