#pragma region Copyright (c) 2014-2018 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#include "ConversionTables.h"
#include "FormatCodes.h"

// clang-format off
const encoding_convert_entry RCT2ToUnicodeTable[256] =
{
    { 0, 0 },
    { 1, FORMAT_MOVE_X },
    { 2, FORMAT_ADJUST_PALETTE },
    { 3, 3 },
    { 4, 4 },
    { 5, FORMAT_NEWLINE },
    { 6, FORMAT_NEWLINE_SMALLER },
    { 7, FORMAT_TINYFONT },
    { 8, FORMAT_BIGFONT },
    { 9, FORMAT_MEDIUMFONT },
    { 10, FORMAT_SMALLFONT },
    { 11, FORMAT_OUTLINE },
    { 12, FORMAT_OUTLINE_OFF },
    { 13, FORMAT_WINDOW_COLOUR_1 },
    { 14, FORMAT_WINDOW_COLOUR_2 },
    { 15, FORMAT_WINDOW_COLOUR_3 },
    { 16, 16 },
    { 17, FORMAT_NEWLINE_X_Y },
    { 18, 18 },
    { 19, 19 },
    { 20, 20 },
    { 21, 21 },
    { 22, 22 },
    { 23, FORMAT_INLINE_SPRITE },
    { 24, 24 },
    { 25, 25 },
    { 26, 26 },
    { 27, 27 },
    { 28, 28 },
    { 29, 29 },
    { 30, 30 },
    { 31, 31 },
    { 32, 32 },
    { 33, 33 },
    { 34, 34 },
    { 35, 35 },
    { 36, 36 },
    { 37, 37 },
    { 38, 38 },
    { 39, 39 },
    { 40, 40 },
    { 41, 41 },
    { 42, 42 },
    { 43, 43 },
    { 44, 44 },
    { 45, 45 },
    { 46, 46 },
    { 47, 47 },
    { 48, 48 },
    { 49, 49 },
    { 50, 50 },
    { 51, 51 },
    { 52, 52 },
    { 53, 53 },
    { 54, 54 },
    { 55, 55 },
    { 56, 56 },
    { 57, 57 },
    { 58, 58 },
    { 59, 59 },
    { 60, 60 },
    { 61, 61 },
    { 62, 62 },
    { 63, 63 },
    { 64, 64 },
    { 65, 65 },
    { 66, 66 },
    { 67, 67 },
    { 68, 68 },
    { 69, 69 },
    { 70, 70 },
    { 71, 71 },
    { 72, 72 },
    { 73, 73 },
    { 74, 74 },
    { 75, 75 },
    { 76, 76 },
    { 77, 77 },
    { 78, 78 },
    { 79, 79 },
    { 80, 80 },
    { 81, 81 },
    { 82, 82 },
    { 83, 83 },
    { 84, 84 },
    { 85, 85 },
    { 86, 86 },
    { 87, 87 },
    { 88, 88 },
    { 89, 89 },
    { 90, 90 },
    { 91, 91 },
    { 92, 92 },
    { 93, 93 },
    { 94, 94 },
    { 95, 95 },
    { 96, 96 },
    { 97, 97 },
    { 98, 98 },
    { 99, 99 },
    { 100, 100 },
    { 101, 101 },
    { 102, 102 },
    { 103, 103 },
    { 104, 104 },
    { 105, 105 },
    { 106, 106 },
    { 107, 107 },
    { 108, 108 },
    { 109, 109 },
    { 110, 110 },
    { 111, 111 },
    { 112, 112 },
    { 113, 113 },
    { 114, 114 },
    { 115, 115 },
    { 116, 116 },
    { 117, 117 },
    { 118, 118 },
    { 119, 119 },
    { 120, 120 },
    { 121, 121 },
    { 122, 122 },
    { 123, FORMAT_COMMA32 },
    { 124, FORMAT_INT32 },
    { 125, FORMAT_COMMA2DP32 },
    { 126, FORMAT_COMMA16 },
    { 127, FORMAT_UINT16 },
    { 128, FORMAT_CURRENCY2DP },
    { 129, FORMAT_CURRENCY },
    { 130, FORMAT_STRINGID },
    { 131, FORMAT_STRINGID2 },
    { 132, FORMAT_STRING },
    { 133, FORMAT_MONTHYEAR },
    { 134, FORMAT_MONTH },
    { 135, FORMAT_VELOCITY },
    { 136, FORMAT_POP16 },
    { 137, FORMAT_PUSH16 },
    { 138, FORMAT_DURATION },
    { 139, FORMAT_REALTIME },
    { 140, FORMAT_LENGTH },
    { 141, FORMAT_SPRITE },
    { 142, FORMAT_BLACK },
    { 143, FORMAT_GREY },
    { 144, FORMAT_WHITE },
    { 145, FORMAT_RED },
    { 146, FORMAT_GREEN },
    { 147, FORMAT_YELLOW },
    { 148, FORMAT_TOPAZ },
    { 149, FORMAT_CELADON },
    { 150, FORMAT_BABYBLUE },
    { 151, FORMAT_PALELAVENDER },
    { 152, FORMAT_PALEGOLD },
    { 153, FORMAT_LIGHTPINK },
    { 154, FORMAT_PEARLAQUA },
    { 155, FORMAT_PALESILVER },
    { 156, 156 },
    { 157, 157 },
    { 158, 158 },
    { RCT2_A_OGONEK_UC, UNICODE_A_OGONEK_UC },
    { 160, FORMAT_UP },
    { 161, FORMAT_INVERTEDEXCLAMATION },
    { RCT2_C_ACUTE_UC, UNICODE_C_ACUTE_UC },
    { 163, FORMAT_POUND },
    { 164, 164 },
    { 165, FORMAT_YEN },
    { RCT2_E_OGONEK_UC, UNICODE_E_OGONEK_UC },
    { RCT2_L_STROKE_UC, UNICODE_L_STROKE_UC },
    { 168, 168 },
    { 169, FORMAT_COPYRIGHT },
    { 170, FORMAT_DOWN },
    { 171, FORMAT_LEFTGUILLEMET },
    { 172, FORMAT_TICK },
    { 173, FORMAT_CROSS },
    { 174, 174 },
    { 175, FORMAT_RIGHT },
    { 176, FORMAT_DEGREE },
    { 177, FORMAT_SYMBOL_RAILWAY },
    { 178, FORMAT_SQUARED },
    { 179, 179 },
    { 180, FORMAT_OPENQUOTES },
    { 181, FORMAT_EURO },
    { 182, FORMAT_SYMBOL_ROAD },
    { 183, FORMAT_SYMBOL_FLAG },
    { 184, FORMAT_APPROX },
    { 185, FORMAT_POWERNEGATIVEONE },
    { 186, FORMAT_BULLET },
    { 187, FORMAT_RIGHTGUILLEMET },
    { 188, FORMAT_SMALLUP },
    { 189, FORMAT_SMALLDOWN },
    { 190, FORMAT_LEFT },
    { 191, FORMAT_INVERTEDQUESTION },
    { 192, 192 },
    { 193, 193 },
    { 194, 194 },
    { 195, 195 },
    { 196, 196 },
    { 197, 197 },
    { RCT2_N_ACUTE_UC, UNICODE_N_ACUTE_UC },
    { 199, 199 },
    { 200, 200 },
    { 201, 201 },
    { 202, 202 },
    { 203, 203 },
    { 204, 204 },
    { 205, 205 },
    { 206, 206 },
    { 207, 207 },
    { RCT2_S_ACUTE_UC, UNICODE_S_ACUTE_UC },
    { 209, 209 },
    { 210, 210 },
    { 211, 211 },
    { 212, 212 },
    { 213, 213 },
    { 214, 214 },
    { RCT2_Z_ACUTE_UC, UNICODE_Z_ACUTE_UC },
    { RCT2_Z_DOT_UC, UNICODE_Z_DOT_UC },
    { 217, 217 },
    { 218, 218 },
    { 219, 219 },
    { 220, 220 },
    { RCT2_A_OGONEK, UNICODE_A_OGONEK },
    { RCT2_C_ACUTE, UNICODE_C_ACUTE },
    { 223, 223 },
    { 224, 224 },
    { 225, 225 },
    { 226, 226 },
    { 227, 227 },
    { 228, 228 },
    { 229, 229 },
    { RCT2_E_OGONEK, UNICODE_E_OGONEK },
    { 231, 231 },
    { 232, 232 },
    { 233, 233 },
    { 234, 234 },
    { 235, 235 },
    { 236, 236 },
    { 237, 237 },
    { 238, 238 },
    { 239, 239 },
    { RCT2_N_ACUTE, UNICODE_N_ACUTE },
    { 241, 241 },
    { 242, 242 },
    { 243, 243 },
    { 244, 244 },
    { 245, 245 },
    { 246, 246 },
    { RCT2_L_STROKE, UNICODE_L_STROKE },
    { RCT2_S_ACUTE, UNICODE_S_ACUTE },
    { 249, 249 },
    { 250, 250 },
    { 251, 251 },
    { 252, 252 },
    { RCT2_Z_DOT, UNICODE_Z_DOT },
    { RCT2_Z_ACUTE, UNICODE_Z_ACUTE },
    { 255, 255 }
};
    
const encoding_convert_entry GB2312ToUnicodeTable[7445] =
{
    { 8481, 12288 },
    { 8482, 12289 },
    { 8483, 12290 },
    { 8484, 12539 },
    { 8485, 713 },
    { 8486, 711 },
    { 8487, 168 },
    { 8488, 12291 },
    { 8489, 12293 },
    { 8490, 8213 },
    { 8491, 65374 },
    { 8492, 8741 },
    { 8493, 8230 },
    { 8494, 8216 },
    { 8495, 8217 },
    { 8496, 8220 },
    { 8497, 8221 },
    { 8498, 12308 },
    { 8499, 12309 },
    { 8500, 12296 },
    { 8501, 12297 },
    { 8502, 12298 },
    { 8503, 12299 },
    { 8504, 12300 },
    { 8505, 12301 },
    { 8506, 12302 },
    { 8507, 12303 },
    { 8508, 12310 },
    { 8509, 12311 },
    { 8510, 12304 },
    { 8511, 12305 },
    { 8512, 177 },
    { 8513, 215 },
    { 8514, 247 },
    { 8515, 8758 },
    { 8516, 8743 },
    { 8517, 8744 },
    { 8518, 8721 },
    { 8519, 8719 },
    { 8520, 8746 },
    { 8521, 8745 },
    { 8522, 8712 },
    { 8523, 8759 },
    { 8524, 8730 },
    { 8525, 8869 },
    { 8526, 8741 },
    { 8527, 8736 },
    { 8528, 8978 },
    { 8529, 8857 },
    { 8530, 8747 },
    { 8531, 8750 },
    { 8532, 8801 },
    { 8533, 8780 },
    { 8534, 8776 },
    { 8535, 8765 },
    { 8536, 8733 },
    { 8537, 8800 },
    { 8538, 8814 },
    { 8539, 8815 },
    { 8540, 8804 },
    { 8541, 8805 },
    { 8542, 8734 },
    { 8543, 8757 },
    { 8544, 8756 },
    { 8545, 9794 },
    { 8546, 9792 },
    { 8547, 176 },
    { 8548, 8242 },
    { 8549, 8243 },
    { 8550, 8451 },
    { 8551, 65284 },
    { 8552, 164 },
    { 8553, 65504 },
    { 8554, 65505 },
    { 8555, 8240 },
    { 8556, 167 },
    { 8557, 8470 },
    { 8558, 9734 },
    { 8559, 9733 },
    { 8560, 9675 },
    { 8561, 9679 },
    { 8562, 9678 },
    { 8563, 9671 },
    { 8564, 9670 },
    { 8565, 9633 },
    { 8566, 9632 },
    { 8567, 9651 },
    { 8568, 9650 },
    { 8569, 8251 },
    { 8570, 8594 },
    { 8571, 8592 },
    { 8572, 8593 },
    { 8573, 8595 },
    { 8574, 12307 },
    { 8753, 9352 },
    { 8754, 9353 },
    { 8755, 9354 },
    { 8756, 9355 },
    { 8757, 9356 },
    { 8758, 9357 },
    { 8759, 9358 },
    { 8760, 9359 },
    { 8761, 9360 },
    { 8762, 9361 },
    { 8763, 9362 },
    { 8764, 9363 },
    { 8765, 9364 },
    { 8766, 9365 },
    { 8767, 9366 },
    { 8768, 9367 },
    { 8769, 9368 },
    { 8770, 9369 },
    { 8771, 9370 },
    { 8772, 9371 },
    { 8773, 9332 },
    { 8774, 9333 },
    { 8775, 9334 },
    { 8776, 9335 },
    { 8777, 9336 },
    { 8778, 9337 },
    { 8779, 9338 },
    { 8780, 9339 },
    { 8781, 9340 },
    { 8782, 9341 },
    { 8783, 9342 },
    { 8784, 9343 },
    { 8785, 9344 },
    { 8786, 9345 },
    { 8787, 9346 },
    { 8788, 9347 },
    { 8789, 9348 },
    { 8790, 9349 },
    { 8791, 9350 },
    { 8792, 9351 },
    { 8793, 9312 },
    { 8794, 9313 },
    { 8795, 9314 },
    { 8796, 9315 },
    { 8797, 9316 },
    { 8798, 9317 },
    { 8799, 9318 },
    { 8800, 9319 },
    { 8801, 9320 },
    { 8802, 9321 },
    { 8805, 12832 },
    { 8806, 12833 },
    { 8807, 12834 },
    { 8808, 12835 },
    { 8809, 12836 },
    { 8810, 12837 },
    { 8811, 12838 },
    { 8812, 12839 },
    { 8813, 12840 },
    { 8814, 12841 },
    { 8817, 8544 },
    { 8818, 8545 },
    { 8819, 8546 },
    { 8820, 8547 },
    { 8821, 8548 },
    { 8822, 8549 },
    { 8823, 8550 },
    { 8824, 8551 },
    { 8825, 8552 },
    { 8826, 8553 },
    { 8827, 8554 },
    { 8828, 8555 },
    { 8993, 65281 },
    { 8994, 65282 },
    { 8995, 65283 },
    { 8996, 65509 },
    { 8997, 65285 },
    { 8998, 65286 },
    { 8999, 65287 },
    { 9000, 65288 },
    { 9001, 65289 },
    { 9002, 65290 },
    { 9003, 65291 },
    { 9004, 65292 },
    { 9005, 65293 },
    { 9006, 65294 },
    { 9007, 65295 },
    { 9008, 65296 },
    { 9009, 65297 },
    { 9010, 65298 },
    { 9011, 65299 },
    { 9012, 65300 },
    { 9013, 65301 },
    { 9014, 65302 },
    { 9015, 65303 },
    { 9016, 65304 },
    { 9017, 65305 },
    { 9018, 65306 },
    { 9019, 65307 },
    { 9020, 65308 },
    { 9021, 65309 },
    { 9022, 65310 },
    { 9023, 65311 },
    { 9024, 65312 },
    { 9025, 65313 },
    { 9026, 65314 },
    { 9027, 65315 },
    { 9028, 65316 },
    { 9029, 65317 },
    { 9030, 65318 },
    { 9031, 65319 },
    { 9032, 65320 },
    { 9033, 65321 },
    { 9034, 65322 },
    { 9035, 65323 },
    { 9036, 65324 },
    { 9037, 65325 },
    { 9038, 65326 },
    { 9039, 65327 },
    { 9040, 65328 },
    { 9041, 65329 },
    { 9042, 65330 },
    { 9043, 65331 },
    { 9044, 65332 },
    { 9045, 65333 },
    { 9046, 65334 },
    { 9047, 65335 },
    { 9048, 65336 },
    { 9049, 65337 },
    { 9050, 65338 },
    { 9051, 65339 },
    { 9052, 65340 },
    { 9053, 65341 },
    { 9054, 65342 },
    { 9055, 65343 },
    { 9056, 65344 },
    { 9057, 65345 },
    { 9058, 65346 },
    { 9059, 65347 },
    { 9060, 65348 },
    { 9061, 65349 },
    { 9062, 65350 },
    { 9063, 65351 },
    { 9064, 65352 },
    { 9065, 65353 },
    { 9066, 65354 },
    { 9067, 65355 },
    { 9068, 65356 },
    { 9069, 65357 },
    { 9070, 65358 },
    { 9071, 65359 },
    { 9072, 65360 },
    { 9073, 65361 },
    { 9074, 65362 },
    { 9075, 65363 },
    { 9076, 65364 },
    { 9077, 65365 },
    { 9078, 65366 },
    { 9079, 65367 },
    { 9080, 65368 },
    { 9081, 65369 },
    { 9082, 65370 },
    { 9083, 65371 },
    { 9084, 65372 },
    { 9085, 65373 },
    { 9086, 65507 },
    { 9249, 12353 },
    { 9250, 12354 },
    { 9251, 12355 },
    { 9252, 12356 },
    { 9253, 12357 },
    { 9254, 12358 },
    { 9255, 12359 },
    { 9256, 12360 },
    { 9257, 12361 },
    { 9258, 12362 },
    { 9259, 12363 },
    { 9260, 12364 },
    { 9261, 12365 },
    { 9262, 12366 },
    { 9263, 12367 },
    { 9264, 12368 },
    { 9265, 12369 },
    { 9266, 12370 },
    { 9267, 12371 },
    { 9268, 12372 },
    { 9269, 12373 },
    { 9270, 12374 },
    { 9271, 12375 },
    { 9272, 12376 },
    { 9273, 12377 },
    { 9274, 12378 },
    { 9275, 12379 },
    { 9276, 12380 },
    { 9277, 12381 },
    { 9278, 12382 },
    { 9279, 12383 },
    { 9280, 12384 },
    { 9281, 12385 },
    { 9282, 12386 },
    { 9283, 12387 },
    { 9284, 12388 },
    { 9285, 12389 },
    { 9286, 12390 },
    { 9287, 12391 },
    { 9288, 12392 },
    { 9289, 12393 },
    { 9290, 12394 },
    { 9291, 12395 },
    { 9292, 12396 },
    { 9293, 12397 },
    { 9294, 12398 },
    { 9295, 12399 },
    { 9296, 12400 },
    { 9297, 12401 },
    { 9298, 12402 },
    { 9299, 12403 },
    { 9300, 12404 },
    { 9301, 12405 },
    { 9302, 12406 },
    { 9303, 12407 },
    { 9304, 12408 },
    { 9305, 12409 },
    { 9306, 12410 },
    { 9307, 12411 },
    { 9308, 12412 },
    { 9309, 12413 },
    { 9310, 12414 },
    { 9311, 12415 },
    { 9312, 12416 },
    { 9313, 12417 },
    { 9314, 12418 },
    { 9315, 12419 },
    { 9316, 12420 },
    { 9317, 12421 },
    { 9318, 12422 },
    { 9319, 12423 },
    { 9320, 12424 },
    { 9321, 12425 },
    { 9322, 12426 },
    { 9323, 12427 },
    { 9324, 12428 },
    { 9325, 12429 },
    { 9326, 12430 },
    { 9327, 12431 },
    { 9328, 12432 },
    { 9329, 12433 },
    { 9330, 12434 },
    { 9331, 12435 },
    { 9505, 12449 },
    { 9506, 12450 },
    { 9507, 12451 },
    { 9508, 12452 },
    { 9509, 12453 },
    { 9510, 12454 },
    { 9511, 12455 },
    { 9512, 12456 },
    { 9513, 12457 },
    { 9514, 12458 },
    { 9515, 12459 },
    { 9516, 12460 },
    { 9517, 12461 },
    { 9518, 12462 },
    { 9519, 12463 },
    { 9520, 12464 },
    { 9521, 12465 },
    { 9522, 12466 },
    { 9523, 12467 },
    { 9524, 12468 },
    { 9525, 12469 },
    { 9526, 12470 },
    { 9527, 12471 },
    { 9528, 12472 },
    { 9529, 12473 },
    { 9530, 12474 },
    { 9531, 12475 },
    { 9532, 12476 },
    { 9533, 12477 },
    { 9534, 12478 },
    { 9535, 12479 },
    { 9536, 12480 },
    { 9537, 12481 },
    { 9538, 12482 },
    { 9539, 12483 },
    { 9540, 12484 },
    { 9541, 12485 },
    { 9542, 12486 },
    { 9543, 12487 },
    { 9544, 12488 },
    { 9545, 12489 },
    { 9546, 12490 },
    { 9547, 12491 },
    { 9548, 12492 },
    { 9549, 12493 },
    { 9550, 12494 },
    { 9551, 12495 },
    { 9552, 12496 },
    { 9553, 12497 },
    { 9554, 12498 },
    { 9555, 12499 },
    { 9556, 12500 },
    { 9557, 12501 },
    { 9558, 12502 },
    { 9559, 12503 },
    { 9560, 12504 },
    { 9561, 12505 },
    { 9562, 12506 },
    { 9563, 12507 },
    { 9564, 12508 },
    { 9565, 12509 },
    { 9566, 12510 },
    { 9567, 12511 },
    { 9568, 12512 },
    { 9569, 12513 },
    { 9570, 12514 },
    { 9571, 12515 },
    { 9572, 12516 },
    { 9573, 12517 },
    { 9574, 12518 },
    { 9575, 12519 },
    { 9576, 12520 },
    { 9577, 12521 },
    { 9578, 12522 },
    { 9579, 12523 },
    { 9580, 12524 },
    { 9581, 12525 },
    { 9582, 12526 },
    { 9583, 12527 },
    { 9584, 12528 },
    { 9585, 12529 },
    { 9586, 12530 },
    { 9587, 12531 },
    { 9588, 12532 },
    { 9589, 12533 },
    { 9590, 12534 },
    { 9761, 913 },
    { 9762, 914 },
    { 9763, 915 },
    { 9764, 916 },
    { 9765, 917 },
    { 9766, 918 },
    { 9767, 919 },
    { 9768, 920 },
    { 9769, 921 },
    { 9770, 922 },
    { 9771, 923 },
    { 9772, 924 },
    { 9773, 925 },
    { 9774, 926 },
    { 9775, 927 },
    { 9776, 928 },
    { 9777, 929 },
    { 9778, 931 },
    { 9779, 932 },
    { 9780, 933 },
    { 9781, 934 },
    { 9782, 935 },
    { 9783, 936 },
    { 9784, 937 },
    { 9793, 945 },
    { 9794, 946 },
    { 9795, 947 },
    { 9796, 948 },
    { 9797, 949 },
    { 9798, 950 },
    { 9799, 951 },
    { 9800, 952 },
    { 9801, 953 },
    { 9802, 954 },
    { 9803, 955 },
    { 9804, 956 },
    { 9805, 957 },
    { 9806, 958 },
    { 9807, 959 },
    { 9808, 960 },
    { 9809, 961 },
    { 9810, 963 },
    { 9811, 964 },
    { 9812, 965 },
    { 9813, 966 },
    { 9814, 967 },
    { 9815, 968 },
    { 9816, 969 },
    { 10017, 1040 },
    { 10018, 1041 },
    { 10019, 1042 },
    { 10020, 1043 },
    { 10021, 1044 },
    { 10022, 1045 },
    { 10023, 1025 },
    { 10024, 1046 },
    { 10025, 1047 },
    { 10026, 1048 },
    { 10027, 1049 },
    { 10028, 1050 },
    { 10029, 1051 },
    { 10030, 1052 },
    { 10031, 1053 },
    { 10032, 1054 },
    { 10033, 1055 },
    { 10034, 1056 },
    { 10035, 1057 },
    { 10036, 1058 },
    { 10037, 1059 },
    { 10038, 1060 },
    { 10039, 1061 },
    { 10040, 1062 },
    { 10041, 1063 },
    { 10042, 1064 },
    { 10043, 1065 },
    { 10044, 1066 },
    { 10045, 1067 },
    { 10046, 1068 },
    { 10047, 1069 },
    { 10048, 1070 },
    { 10049, 1071 },
    { 10065, 1072 },
    { 10066, 1073 },
    { 10067, 1074 },
    { 10068, 1075 },
    { 10069, 1076 },
    { 10070, 1077 },
    { 10071, 1105 },
    { 10072, 1078 },
    { 10073, 1079 },
    { 10074, 1080 },
    { 10075, 1081 },
    { 10076, 1082 },
    { 10077, 1083 },
    { 10078, 1084 },
    { 10079, 1085 },
    { 10080, 1086 },
    { 10081, 1087 },
    { 10082, 1088 },
    { 10083, 1089 },
    { 10084, 1090 },
    { 10085, 1091 },
    { 10086, 1092 },
    { 10087, 1093 },
    { 10088, 1094 },
    { 10089, 1095 },
    { 10090, 1096 },
    { 10091, 1097 },
    { 10092, 1098 },
    { 10093, 1099 },
    { 10094, 1100 },
    { 10095, 1101 },
    { 10096, 1102 },
    { 10097, 1103 },
    { 10273, 257 },
    { 10274, 225 },
    { 10275, 462 },
    { 10276, 224 },
    { 10277, 275 },
    { 10278, 233 },
    { 10279, 283 },
    { 10280, 232 },
    { 10281, 299 },
    { 10282, 237 },
    { 10283, 464 },
    { 10284, 236 },
    { 10285, 333 },
    { 10286, 243 },
    { 10287, 466 },
    { 10288, 242 },
    { 10289, 363 },
    { 10290, 250 },
    { 10291, 468 },
    { 10292, 249 },
    { 10293, 470 },
    { 10294, 472 },
    { 10295, 474 },
    { 10296, 476 },
    { 10297, 252 },
    { 10298, 234 },
    { 10309, 12549 },
    { 10310, 12550 },
    { 10311, 12551 },
    { 10312, 12552 },
    { 10313, 12553 },
    { 10314, 12554 },
    { 10315, 12555 },
    { 10316, 12556 },
    { 10317, 12557 },
    { 10318, 12558 },
    { 10319, 12559 },
    { 10320, 12560 },
    { 10321, 12561 },
    { 10322, 12562 },
    { 10323, 12563 },
    { 10324, 12564 },
    { 10325, 12565 },
    { 10326, 12566 },
    { 10327, 12567 },
    { 10328, 12568 },
    { 10329, 12569 },
    { 10330, 12570 },
    { 10331, 12571 },
    { 10332, 12572 },
    { 10333, 12573 },
    { 10334, 12574 },
    { 10335, 12575 },
    { 10336, 12576 },
    { 10337, 12577 },
    { 10338, 12578 },
    { 10339, 12579 },
    { 10340, 12580 },
    { 10341, 12581 },
    { 10342, 12582 },
    { 10343, 12583 },
    { 10344, 12584 },
    { 10345, 12585 },
    { 10532, 9472 },
    { 10533, 9473 },
    { 10534, 9474 },
    { 10535, 9475 },
    { 10536, 9476 },
    { 10537, 9477 },
    { 10538, 9478 },
    { 10539, 9479 },
    { 10540, 9480 },
    { 10541, 9481 },
    { 10542, 9482 },
    { 10543, 9483 },
    { 10544, 9484 },
    { 10545, 9485 },
    { 10546, 9486 },
    { 10547, 9487 },
    { 10548, 9488 },
    { 10549, 9489 },
    { 10550, 9490 },
    { 10551, 9491 },
    { 10552, 9492 },
    { 10553, 9493 },
    { 10554, 9494 },
    { 10555, 9495 },
    { 10556, 9496 },
    { 10557, 9497 },
    { 10558, 9498 },
    { 10559, 9499 },
    { 10560, 9500 },
    { 10561, 9501 },
    { 10562, 9502 },
    { 10563, 9503 },
    { 10564, 9504 },
    { 10565, 9505 },
    { 10566, 9506 },
    { 10567, 9507 },
    { 10568, 9508 },
    { 10569, 9509 },
    { 10570, 9510 },
    { 10571, 9511 },
    { 10572, 9512 },
    { 10573, 9513 },
    { 10574, 9514 },
    { 10575, 9515 },
    { 10576, 9516 },
    { 10577, 9517 },
    { 10578, 9518 },
    { 10579, 9519 },
    { 10580, 9520 },
    { 10581, 9521 },
    { 10582, 9522 },
    { 10583, 9523 },
    { 10584, 9524 },
    { 10585, 9525 },
    { 10586, 9526 },
    { 10587, 9527 },
    { 10588, 9528 },
    { 10589, 9529 },
    { 10590, 9530 },
    { 10591, 9531 },
    { 10592, 9532 },
    { 10593, 9533 },
    { 10594, 9534 },
    { 10595, 9535 },
    { 10596, 9536 },
    { 10597, 9537 },
    { 10598, 9538 },
    { 10599, 9539 },
    { 10600, 9540 },
    { 10601, 9541 },
    { 10602, 9542 },
    { 10603, 9543 },
    { 10604, 9544 },
    { 10605, 9545 },
    { 10606, 9546 },
    { 10607, 9547 },
    { 12321, 21834 },
    { 12322, 38463 },
    { 12323, 22467 },
    { 12324, 25384 },
    { 12325, 21710 },
    { 12326, 21769 },
    { 12327, 21696 },
    { 12328, 30353 },
    { 12329, 30284 },
    { 12330, 34108 },
    { 12331, 30702 },
    { 12332, 33406 },
    { 12333, 30861 },
    { 12334, 29233 },
    { 12335, 38552 },
    { 12336, 38797 },
    { 12337, 27688 },
    { 12338, 23433 },
    { 12339, 20474 },
    { 12340, 25353 },
    { 12341, 26263 },
    { 12342, 23736 },
    { 12343, 33018 },
    { 12344, 26696 },
    { 12345, 32942 },
    { 12346, 26114 },
    { 12347, 30414 },
    { 12348, 20985 },
    { 12349, 25942 },
    { 12350, 29100 },
    { 12351, 32753 },
    { 12352, 34948 },
    { 12353, 20658 },
    { 12354, 22885 },
    { 12355, 25034 },
    { 12356, 28595 },
    { 12357, 33453 },
    { 12358, 25420 },
    { 12359, 25170 },
    { 12360, 21485 },
    { 12361, 21543 },
    { 12362, 31494 },
    { 12363, 20843 },
    { 12364, 30116 },
    { 12365, 24052 },
    { 12366, 25300 },
    { 12367, 36299 },
    { 12368, 38774 },
    { 12369, 25226 },
    { 12370, 32793 },
    { 12371, 22365 },
    { 12372, 38712 },
    { 12373, 32610 },
    { 12374, 29240 },
    { 12375, 30333 },
    { 12376, 26575 },
    { 12377, 30334 },
    { 12378, 25670 },
    { 12379, 20336 },
    { 12380, 36133 },
    { 12381, 25308 },
    { 12382, 31255 },
    { 12383, 26001 },
    { 12384, 29677 },
    { 12385, 25644 },
    { 12386, 25203 },
    { 12387, 33324 },
    { 12388, 39041 },
    { 12389, 26495 },
    { 12390, 29256 },
    { 12391, 25198 },
    { 12392, 25292 },
    { 12393, 20276 },
    { 12394, 29923 },
    { 12395, 21322 },
    { 12396, 21150 },
    { 12397, 32458 },
    { 12398, 37030 },
    { 12399, 24110 },
    { 12400, 26758 },
    { 12401, 27036 },
    { 12402, 33152 },
    { 12403, 32465 },
    { 12404, 26834 },
    { 12405, 30917 },
    { 12406, 34444 },
    { 12407, 38225 },
    { 12408, 20621 },
    { 12409, 35876 },
    { 12410, 33502 },
    { 12411, 32990 },
    { 12412, 21253 },
    { 12413, 35090 },
    { 12414, 21093 },
    { 12577, 34180 },
    { 12578, 38649 },
    { 12579, 20445 },
    { 12580, 22561 },
    { 12581, 39281 },
    { 12582, 23453 },
    { 12583, 25265 },
    { 12584, 25253 },
    { 12585, 26292 },
    { 12586, 35961 },
    { 12587, 40077 },
    { 12588, 29190 },
    { 12589, 26479 },
    { 12590, 30865 },
    { 12591, 24754 },
    { 12592, 21329 },
    { 12593, 21271 },
    { 12594, 36744 },
    { 12595, 32972 },
    { 12596, 36125 },
    { 12597, 38049 },
    { 12598, 20493 },
    { 12599, 29384 },
    { 12600, 22791 },
    { 12601, 24811 },
    { 12602, 28953 },
    { 12603, 34987 },
    { 12604, 22868 },
    { 12605, 33519 },
    { 12606, 26412 },
    { 12607, 31528 },
    { 12608, 23849 },
    { 12609, 32503 },
    { 12610, 29997 },
    { 12611, 27893 },
    { 12612, 36454 },
    { 12613, 36856 },
    { 12614, 36924 },
    { 12615, 40763 },
    { 12616, 27604 },
    { 12617, 37145 },
    { 12618, 31508 },
    { 12619, 24444 },
    { 12620, 30887 },
    { 12621, 34006 },
    { 12622, 34109 },
    { 12623, 27605 },
    { 12624, 27609 },
    { 12625, 27606 },
    { 12626, 24065 },
    { 12627, 24199 },
    { 12628, 30201 },
    { 12629, 38381 },
    { 12630, 25949 },
    { 12631, 24330 },
    { 12632, 24517 },
    { 12633, 36767 },
    { 12634, 22721 },
    { 12635, 33218 },
    { 12636, 36991 },
    { 12637, 38491 },
    { 12638, 38829 },
    { 12639, 36793 },
    { 12640, 32534 },
    { 12641, 36140 },
    { 12642, 25153 },
    { 12643, 20415 },
    { 12644, 21464 },
    { 12645, 21342 },
    { 12646, 36776 },
    { 12647, 36777 },
    { 12648, 36779 },
    { 12649, 36941 },
    { 12650, 26631 },
    { 12651, 24426 },
    { 12652, 33176 },
    { 12653, 34920 },
    { 12654, 40150 },
    { 12655, 24971 },
    { 12656, 21035 },
    { 12657, 30250 },
    { 12658, 24428 },
    { 12659, 25996 },
    { 12660, 28626 },
    { 12661, 28392 },
    { 12662, 23486 },
    { 12663, 25672 },
    { 12664, 20853 },
    { 12665, 20912 },
    { 12666, 26564 },
    { 12667, 19993 },
    { 12668, 31177 },
    { 12669, 39292 },
    { 12670, 28851 },
    { 12833, 30149 },
    { 12834, 24182 },
    { 12835, 29627 },
    { 12836, 33760 },
    { 12837, 25773 },
    { 12838, 25320 },
    { 12839, 38069 },
    { 12840, 27874 },
    { 12841, 21338 },
    { 12842, 21187 },
    { 12843, 25615 },
    { 12844, 38082 },
    { 12845, 31636 },
    { 12846, 20271 },
    { 12847, 24091 },
    { 12848, 33334 },
    { 12849, 33046 },
    { 12850, 33162 },
    { 12851, 28196 },
    { 12852, 27850 },
    { 12853, 39539 },
    { 12854, 25429 },
    { 12855, 21340 },
    { 12856, 21754 },
    { 12857, 34917 },
    { 12858, 22496 },
    { 12859, 19981 },
    { 12860, 24067 },
    { 12861, 27493 },
    { 12862, 31807 },
    { 12863, 37096 },
    { 12864, 24598 },
    { 12865, 25830 },
    { 12866, 29468 },
    { 12867, 35009 },
    { 12868, 26448 },
    { 12869, 25165 },
    { 12870, 36130 },
    { 12871, 30572 },
    { 12872, 36393 },
    { 12873, 37319 },
    { 12874, 24425 },
    { 12875, 33756 },
    { 12876, 34081 },
    { 12877, 39184 },
    { 12878, 21442 },
    { 12879, 34453 },
    { 12880, 27531 },
    { 12881, 24813 },
    { 12882, 24808 },
    { 12883, 28799 },
    { 12884, 33485 },
    { 12885, 33329 },
    { 12886, 20179 },
    { 12887, 27815 },
    { 12888, 34255 },
    { 12889, 25805 },
    { 12890, 31961 },
    { 12891, 27133 },
    { 12892, 26361 },
    { 12893, 33609 },
    { 12894, 21397 },
    { 12895, 31574 },
    { 12896, 20391 },
    { 12897, 20876 },
    { 12898, 27979 },
    { 12899, 23618 },
    { 12900, 36461 },
    { 12901, 25554 },
    { 12902, 21449 },
    { 12903, 33580 },
    { 12904, 33590 },
    { 12905, 26597 },
    { 12906, 30900 },
    { 12907, 25661 },
    { 12908, 23519 },
    { 12909, 23700 },
    { 12910, 24046 },
    { 12911, 35815 },
    { 12912, 25286 },
    { 12913, 26612 },
    { 12914, 35962 },
    { 12915, 25600 },
    { 12916, 25530 },
    { 12917, 34633 },
    { 12918, 39307 },
    { 12919, 35863 },
    { 12920, 32544 },
    { 12921, 38130 },
    { 12922, 20135 },
    { 12923, 38416 },
    { 12924, 39076 },
    { 12925, 26124 },
    { 12926, 29462 },
    { 13089, 22330 },
    { 13090, 23581 },
    { 13091, 24120 },
    { 13092, 38271 },
    { 13093, 20607 },
    { 13094, 32928 },
    { 13095, 21378 },
    { 13096, 25950 },
    { 13097, 30021 },
    { 13098, 21809 },
    { 13099, 20513 },
    { 13100, 36229 },
    { 13101, 25220 },
    { 13102, 38046 },
    { 13103, 26397 },
    { 13104, 22066 },
    { 13105, 28526 },
    { 13106, 24034 },
    { 13107, 21557 },
    { 13108, 28818 },
    { 13109, 36710 },
    { 13110, 25199 },
    { 13111, 25764 },
    { 13112, 25507 },
    { 13113, 24443 },
    { 13114, 28552 },
    { 13115, 37108 },
    { 13116, 33251 },
    { 13117, 36784 },
    { 13118, 23576 },
    { 13119, 26216 },
    { 13120, 24561 },
    { 13121, 27785 },
    { 13122, 38472 },
    { 13123, 36225 },
    { 13124, 34924 },
    { 13125, 25745 },
    { 13126, 31216 },
    { 13127, 22478 },
    { 13128, 27225 },
    { 13129, 25104 },
    { 13130, 21576 },
    { 13131, 20056 },
    { 13132, 31243 },
    { 13133, 24809 },
    { 13134, 28548 },
    { 13135, 35802 },
    { 13136, 25215 },
    { 13137, 36894 },
    { 13138, 39563 },
    { 13139, 31204 },
    { 13140, 21507 },
    { 13141, 30196 },
    { 13142, 25345 },
    { 13143, 21273 },
    { 13144, 27744 },
    { 13145, 36831 },
    { 13146, 24347 },
    { 13147, 39536 },
    { 13148, 32827 },
    { 13149, 40831 },
    { 13150, 20360 },
    { 13151, 23610 },
    { 13152, 36196 },
    { 13153, 32709 },
    { 13154, 26021 },
    { 13155, 28861 },
    { 13156, 20805 },
    { 13157, 20914 },
    { 13158, 34411 },
    { 13159, 23815 },
    { 13160, 23456 },
    { 13161, 25277 },
    { 13162, 37228 },
    { 13163, 30068 },
    { 13164, 36364 },
    { 13165, 31264 },
    { 13166, 24833 },
    { 13167, 31609 },
    { 13168, 20167 },
    { 13169, 32504 },
    { 13170, 30597 },
    { 13171, 19985 },
    { 13172, 33261 },
    { 13173, 21021 },
    { 13174, 20986 },
    { 13175, 27249 },
    { 13176, 21416 },
    { 13177, 36487 },
    { 13178, 38148 },
    { 13179, 38607 },
    { 13180, 28353 },
    { 13181, 38500 },
    { 13182, 26970 },
    { 13345, 30784 },
    { 13346, 20648 },
    { 13347, 30679 },
    { 13348, 25616 },
    { 13349, 35302 },
    { 13350, 22788 },
    { 13351, 25571 },
    { 13352, 24029 },
    { 13353, 31359 },
    { 13354, 26941 },
    { 13355, 20256 },
    { 13356, 33337 },
    { 13357, 21912 },
    { 13358, 20018 },
    { 13359, 30126 },
    { 13360, 31383 },
    { 13361, 24162 },
    { 13362, 24202 },
    { 13363, 38383 },
    { 13364, 21019 },
    { 13365, 21561 },
    { 13366, 28810 },
    { 13367, 25462 },
    { 13368, 38180 },
    { 13369, 22402 },
    { 13370, 26149 },
    { 13371, 26943 },
    { 13372, 37255 },
    { 13373, 21767 },
    { 13374, 28147 },
    { 13375, 32431 },
    { 13376, 34850 },
    { 13377, 25139 },
    { 13378, 32496 },
    { 13379, 30133 },
    { 13380, 33576 },
    { 13381, 30913 },
    { 13382, 38604 },
    { 13383, 36766 },
    { 13384, 24904 },
    { 13385, 29943 },
    { 13386, 35789 },
    { 13387, 27492 },
    { 13388, 21050 },
    { 13389, 36176 },
    { 13390, 27425 },
    { 13391, 32874 },
    { 13392, 33905 },
    { 13393, 22257 },
    { 13394, 21254 },
    { 13395, 20174 },
    { 13396, 19995 },
    { 13397, 20945 },
    { 13398, 31895 },
    { 13399, 37259 },
    { 13400, 31751 },
    { 13401, 20419 },
    { 13402, 36479 },
    { 13403, 31713 },
    { 13404, 31388 },
    { 13405, 25703 },
    { 13406, 23828 },
    { 13407, 20652 },
    { 13408, 33030 },
    { 13409, 30209 },
    { 13410, 31929 },
    { 13411, 28140 },
    { 13412, 32736 },
    { 13413, 26449 },
    { 13414, 23384 },
    { 13415, 23544 },
    { 13416, 30923 },
    { 13417, 25774 },
    { 13418, 25619 },
    { 13419, 25514 },
    { 13420, 25387 },
    { 13421, 38169 },
    { 13422, 25645 },
    { 13423, 36798 },
    { 13424, 31572 },
    { 13425, 30249 },
    { 13426, 25171 },
    { 13427, 22823 },
    { 13428, 21574 },
    { 13429, 27513 },
    { 13430, 20643 },
    { 13431, 25140 },
    { 13432, 24102 },
    { 13433, 27526 },
    { 13434, 20195 },
    { 13435, 36151 },
    { 13436, 34955 },
    { 13437, 24453 },
    { 13438, 36910 },
    { 13601, 24608 },
    { 13602, 32829 },
    { 13603, 25285 },
    { 13604, 20025 },
    { 13605, 21333 },
    { 13606, 37112 },
    { 13607, 25528 },
    { 13608, 32966 },
    { 13609, 26086 },
    { 13610, 27694 },
    { 13611, 20294 },
    { 13612, 24814 },
    { 13613, 28129 },
    { 13614, 35806 },
    { 13615, 24377 },
    { 13616, 34507 },
    { 13617, 24403 },
    { 13618, 25377 },
    { 13619, 20826 },
    { 13620, 33633 },
    { 13621, 26723 },
    { 13622, 20992 },
    { 13623, 25443 },
    { 13624, 36424 },
    { 13625, 20498 },
    { 13626, 23707 },
    { 13627, 31095 },
    { 13628, 23548 },
    { 13629, 21040 },
    { 13630, 31291 },
    { 13631, 24764 },
    { 13632, 36947 },
    { 13633, 30423 },
    { 13634, 24503 },
    { 13635, 24471 },
    { 13636, 30340 },
    { 13637, 36460 },
    { 13638, 28783 },
    { 13639, 30331 },
    { 13640, 31561 },
    { 13641, 30634 },
    { 13642, 20979 },
    { 13643, 37011 },
    { 13644, 22564 },
    { 13645, 20302 },
    { 13646, 28404 },
    { 13647, 36842 },
    { 13648, 25932 },
    { 13649, 31515 },
    { 13650, 29380 },
    { 13651, 28068 },
    { 13652, 32735 },
    { 13653, 23265 },
    { 13654, 25269 },
    { 13655, 24213 },
    { 13656, 22320 },
    { 13657, 33922 },
    { 13658, 31532 },
    { 13659, 24093 },
    { 13660, 24351 },
    { 13661, 36882 },
    { 13662, 32532 },
    { 13663, 39072 },
    { 13664, 25474 },
    { 13665, 28359 },
    { 13666, 30872 },
    { 13667, 28857 },
    { 13668, 20856 },
    { 13669, 38747 },
    { 13670, 22443 },
    { 13671, 30005 },
    { 13672, 20291 },
    { 13673, 30008 },
    { 13674, 24215 },
    { 13675, 24806 },
    { 13676, 22880 },
    { 13677, 28096 },
    { 13678, 27583 },
    { 13679, 30857 },
    { 13680, 21500 },
    { 13681, 38613 },
    { 13682, 20939 },
    { 13683, 20993 },
    { 13684, 25481 },
    { 13685, 21514 },
    { 13686, 38035 },
    { 13687, 35843 },
    { 13688, 36300 },
    { 13689, 29241 },
    { 13690, 30879 },
    { 13691, 34678 },
    { 13692, 36845 },
    { 13693, 35853 },
    { 13694, 21472 },
    { 13857, 19969 },
    { 13858, 30447 },
    { 13859, 21486 },
    { 13860, 38025 },
    { 13861, 39030 },
    { 13862, 40718 },
    { 13863, 38189 },
    { 13864, 23450 },
    { 13865, 35746 },
    { 13866, 20002 },
    { 13867, 19996 },
    { 13868, 20908 },
    { 13869, 33891 },
    { 13870, 25026 },
    { 13871, 21160 },
    { 13872, 26635 },
    { 13873, 20375 },
    { 13874, 24683 },
    { 13875, 20923 },
    { 13876, 27934 },
    { 13877, 20828 },
    { 13878, 25238 },
    { 13879, 26007 },
    { 13880, 38497 },
    { 13881, 35910 },
    { 13882, 36887 },
    { 13883, 30168 },
    { 13884, 37117 },
    { 13885, 30563 },
    { 13886, 27602 },
    { 13887, 29322 },
    { 13888, 29420 },
    { 13889, 35835 },
    { 13890, 22581 },
    { 13891, 30585 },
    { 13892, 36172 },
    { 13893, 26460 },
    { 13894, 38208 },
    { 13895, 32922 },
    { 13896, 24230 },
    { 13897, 28193 },
    { 13898, 22930 },
    { 13899, 31471 },
    { 13900, 30701 },
    { 13901, 38203 },
    { 13902, 27573 },
    { 13903, 26029 },
    { 13904, 32526 },
    { 13905, 22534 },
    { 13906, 20817 },
    { 13907, 38431 },
    { 13908, 23545 },
    { 13909, 22697 },
    { 13910, 21544 },
    { 13911, 36466 },
    { 13912, 25958 },
    { 13913, 39039 },
    { 13914, 22244 },
    { 13915, 38045 },
    { 13916, 30462 },
    { 13917, 36929 },
    { 13918, 25479 },
    { 13919, 21702 },
    { 13920, 22810 },
    { 13921, 22842 },
    { 13922, 22427 },
    { 13923, 36530 },
    { 13924, 26421 },
    { 13925, 36346 },
    { 13926, 33333 },
    { 13927, 21057 },
    { 13928, 24816 },
    { 13929, 22549 },
    { 13930, 34558 },
    { 13931, 23784 },
    { 13932, 40517 },
    { 13933, 20420 },
    { 13934, 39069 },
    { 13935, 35769 },
    { 13936, 23077 },
    { 13937, 24694 },
    { 13938, 21380 },
    { 13939, 25212 },
    { 13940, 36943 },
    { 13941, 37122 },
    { 13942, 39295 },
    { 13943, 24681 },
    { 13944, 32780 },
    { 13945, 20799 },
    { 13946, 32819 },
    { 13947, 23572 },
    { 13948, 39285 },
    { 13949, 27953 },
    { 13950, 20108 },
    { 14113, 36144 },
    { 14114, 21457 },
    { 14115, 32602 },
    { 14116, 31567 },
    { 14117, 20240 },
    { 14118, 20047 },
    { 14119, 38400 },
    { 14120, 27861 },
    { 14121, 29648 },
    { 14122, 34281 },
    { 14123, 24070 },
    { 14124, 30058 },
    { 14125, 32763 },
    { 14126, 27146 },
    { 14127, 30718 },
    { 14128, 38034 },
    { 14129, 32321 },
    { 14130, 20961 },
    { 14131, 28902 },
    { 14132, 21453 },
    { 14133, 36820 },
    { 14134, 33539 },
    { 14135, 36137 },
    { 14136, 29359 },
    { 14137, 39277 },
    { 14138, 27867 },
    { 14139, 22346 },
    { 14140, 33459 },
    { 14141, 26041 },
    { 14142, 32938 },
    { 14143, 25151 },
    { 14144, 38450 },
    { 14145, 22952 },
    { 14146, 20223 },
    { 14147, 35775 },
    { 14148, 32442 },
    { 14149, 25918 },
    { 14150, 33778 },
    { 14151, 38750 },
    { 14152, 21857 },
    { 14153, 39134 },
    { 14154, 32933 },
    { 14155, 21290 },
    { 14156, 35837 },
    { 14157, 21536 },
    { 14158, 32954 },
    { 14159, 24223 },
    { 14160, 27832 },
    { 14161, 36153 },
    { 14162, 33452 },
    { 14163, 37210 },
    { 14164, 21545 },
    { 14165, 27675 },
    { 14166, 20998 },
    { 14167, 32439 },
    { 14168, 22367 },
    { 14169, 28954 },
    { 14170, 27774 },
    { 14171, 31881 },
    { 14172, 22859 },
    { 14173, 20221 },
    { 14174, 24575 },
    { 14175, 24868 },
    { 14176, 31914 },
    { 14177, 20016 },
    { 14178, 23553 },
    { 14179, 26539 },
    { 14180, 34562 },
    { 14181, 23792 },
    { 14182, 38155 },
    { 14183, 39118 },
    { 14184, 30127 },
    { 14185, 28925 },
    { 14186, 36898 },
    { 14187, 20911 },
    { 14188, 32541 },
    { 14189, 35773 },
    { 14190, 22857 },
    { 14191, 20964 },
    { 14192, 20315 },
    { 14193, 21542 },
    { 14194, 22827 },
    { 14195, 25975 },
    { 14196, 32932 },
    { 14197, 23413 },
    { 14198, 25206 },
    { 14199, 25282 },
    { 14200, 36752 },
    { 14201, 24133 },
    { 14202, 27679 },
    { 14203, 31526 },
    { 14204, 20239 },
    { 14205, 20440 },
    { 14206, 26381 },
    { 14369, 28014 },
    { 14370, 28074 },
    { 14371, 31119 },
    { 14372, 34993 },
    { 14373, 24343 },
    { 14374, 29995 },
    { 14375, 25242 },
    { 14376, 36741 },
    { 14377, 20463 },
    { 14378, 37340 },
    { 14379, 26023 },
    { 14380, 33071 },
    { 14381, 33105 },
    { 14382, 24220 },
    { 14383, 33104 },
    { 14384, 36212 },
    { 14385, 21103 },
    { 14386, 35206 },
    { 14387, 36171 },
    { 14388, 22797 },
    { 14389, 20613 },
    { 14390, 20184 },
    { 14391, 38428 },
    { 14392, 29238 },
    { 14393, 33145 },
    { 14394, 36127 },
    { 14395, 23500 },
    { 14396, 35747 },
    { 14397, 38468 },
    { 14398, 22919 },
    { 14399, 32538 },
    { 14400, 21648 },
    { 14401, 22134 },
    { 14402, 22030 },
    { 14403, 35813 },
    { 14404, 25913 },
    { 14405, 27010 },
    { 14406, 38041 },
    { 14407, 30422 },
    { 14408, 28297 },
    { 14409, 24178 },
    { 14410, 29976 },
    { 14411, 26438 },
    { 14412, 26577 },
    { 14413, 31487 },
    { 14414, 32925 },
    { 14415, 36214 },
    { 14416, 24863 },
    { 14417, 31174 },
    { 14418, 25954 },
    { 14419, 36195 },
    { 14420, 20872 },
    { 14421, 21018 },
    { 14422, 38050 },
    { 14423, 32568 },
    { 14424, 32923 },
    { 14425, 32434 },
    { 14426, 23703 },
    { 14427, 28207 },
    { 14428, 26464 },
    { 14429, 31705 },
    { 14430, 30347 },
    { 14431, 39640 },
    { 14432, 33167 },
    { 14433, 32660 },
    { 14434, 31957 },
    { 14435, 25630 },
    { 14436, 38224 },
    { 14437, 31295 },
    { 14438, 21578 },
    { 14439, 21733 },
    { 14440, 27468 },
    { 14441, 25601 },
    { 14442, 25096 },
    { 14443, 40509 },
    { 14444, 33011 },
    { 14445, 30105 },
    { 14446, 21106 },
    { 14447, 38761 },
    { 14448, 33883 },
    { 14449, 26684 },
    { 14450, 34532 },
    { 14451, 38401 },
    { 14452, 38548 },
    { 14453, 38124 },
    { 14454, 20010 },
    { 14455, 21508 },
    { 14456, 32473 },
    { 14457, 26681 },
    { 14458, 36319 },
    { 14459, 32789 },
    { 14460, 26356 },
    { 14461, 24218 },
    { 14462, 32697 },
    { 14625, 22466 },
    { 14626, 32831 },
    { 14627, 26775 },
    { 14628, 24037 },
    { 14629, 25915 },
    { 14630, 21151 },
    { 14631, 24685 },
    { 14632, 40858 },
    { 14633, 20379 },
    { 14634, 36524 },
    { 14635, 20844 },
    { 14636, 23467 },
    { 14637, 24339 },
    { 14638, 24041 },
    { 14639, 27742 },
    { 14640, 25329 },
    { 14641, 36129 },
    { 14642, 20849 },
    { 14643, 38057 },
    { 14644, 21246 },
    { 14645, 27807 },
    { 14646, 33503 },
    { 14647, 29399 },
    { 14648, 22434 },
    { 14649, 26500 },
    { 14650, 36141 },
    { 14651, 22815 },
    { 14652, 36764 },
    { 14653, 33735 },
    { 14654, 21653 },
    { 14655, 31629 },
    { 14656, 20272 },
    { 14657, 27837 },
    { 14658, 23396 },
    { 14659, 22993 },
    { 14660, 40723 },
    { 14661, 21476 },
    { 14662, 34506 },
    { 14663, 39592 },
    { 14664, 35895 },
    { 14665, 32929 },
    { 14666, 25925 },
    { 14667, 39038 },
    { 14668, 22266 },
    { 14669, 38599 },
    { 14670, 21038 },
    { 14671, 29916 },
    { 14672, 21072 },
    { 14673, 23521 },
    { 14674, 25346 },
    { 14675, 35074 },
    { 14676, 20054 },
    { 14677, 25296 },
    { 14678, 24618 },
    { 14679, 26874 },
    { 14680, 20851 },
    { 14681, 23448 },
    { 14682, 20896 },
    { 14683, 35266 },
    { 14684, 31649 },
    { 14685, 39302 },
    { 14686, 32592 },
    { 14687, 24815 },
    { 14688, 28748 },
    { 14689, 36143 },
    { 14690, 20809 },
    { 14691, 24191 },
    { 14692, 36891 },
    { 14693, 29808 },
    { 14694, 35268 },
    { 14695, 22317 },
    { 14696, 30789 },
    { 14697, 24402 },
    { 14698, 40863 },
    { 14699, 38394 },
    { 14700, 36712 },
    { 14701, 39740 },
    { 14702, 35809 },
    { 14703, 30328 },
    { 14704, 26690 },
    { 14705, 26588 },
    { 14706, 36330 },
    { 14707, 36149 },
    { 14708, 21053 },
    { 14709, 36746 },
    { 14710, 28378 },
    { 14711, 26829 },
    { 14712, 38149 },
    { 14713, 37101 },
    { 14714, 22269 },
    { 14715, 26524 },
    { 14716, 35065 },
    { 14717, 36807 },
    { 14718, 21704 },
    { 14881, 39608 },
    { 14882, 23401 },
    { 14883, 28023 },
    { 14884, 27686 },
    { 14885, 20133 },
    { 14886, 23475 },
    { 14887, 39559 },
    { 14888, 37219 },
    { 14889, 25000 },
    { 14890, 37039 },
    { 14891, 38889 },
    { 14892, 21547 },
    { 14893, 28085 },
    { 14894, 23506 },
    { 14895, 20989 },
    { 14896, 21898 },
    { 14897, 32597 },
    { 14898, 32752 },
    { 14899, 25788 },
    { 14900, 25421 },
    { 14901, 26097 },
    { 14902, 25022 },
    { 14903, 24717 },
    { 14904, 28938 },
    { 14905, 27735 },
    { 14906, 27721 },
    { 14907, 22831 },
    { 14908, 26477 },
    { 14909, 33322 },
    { 14910, 22741 },
    { 14911, 22158 },
    { 14912, 35946 },
    { 14913, 27627 },
    { 14914, 37085 },
    { 14915, 22909 },
    { 14916, 32791 },
    { 14917, 21495 },
    { 14918, 28009 },
    { 14919, 21621 },
    { 14920, 21917 },
    { 14921, 33655 },
    { 14922, 33743 },
    { 14923, 26680 },
    { 14924, 31166 },
    { 14925, 21644 },
    { 14926, 20309 },
    { 14927, 21512 },
    { 14928, 30418 },
    { 14929, 35977 },
    { 14930, 38402 },
    { 14931, 27827 },
    { 14932, 28088 },
    { 14933, 36203 },
    { 14934, 35088 },
    { 14935, 40548 },
    { 14936, 36154 },
    { 14937, 22079 },
    { 14938, 40657 },
    { 14939, 30165 },
    { 14940, 24456 },
    { 14941, 29408 },
    { 14942, 24680 },
    { 14943, 21756 },
    { 14944, 20136 },
    { 14945, 27178 },
    { 14946, 34913 },
    { 14947, 24658 },
    { 14948, 36720 },
    { 14949, 21700 },
    { 14950, 28888 },
    { 14951, 34425 },
    { 14952, 40511 },
    { 14953, 27946 },
    { 14954, 23439 },
    { 14955, 24344 },
    { 14956, 32418 },
    { 14957, 21897 },
    { 14958, 20399 },
    { 14959, 29492 },
    { 14960, 21564 },
    { 14961, 21402 },
    { 14962, 20505 },
    { 14963, 21518 },
    { 14964, 21628 },
    { 14965, 20046 },
    { 14966, 24573 },
    { 14967, 29786 },
    { 14968, 22774 },
    { 14969, 33899 },
    { 14970, 32993 },
    { 14971, 34676 },
    { 14972, 29392 },
    { 14973, 31946 },
    { 14974, 28246 },
    { 15137, 24359 },
    { 15138, 34382 },
    { 15139, 21804 },
    { 15140, 25252 },
    { 15141, 20114 },
    { 15142, 27818 },
    { 15143, 25143 },
    { 15144, 33457 },
    { 15145, 21719 },
    { 15146, 21326 },
    { 15147, 29502 },
    { 15148, 28369 },
    { 15149, 30011 },
    { 15150, 21010 },
    { 15151, 21270 },
    { 15152, 35805 },
    { 15153, 27088 },
    { 15154, 24458 },
    { 15155, 24576 },
    { 15156, 28142 },
    { 15157, 22351 },
    { 15158, 27426 },
    { 15159, 29615 },
    { 15160, 26707 },
    { 15161, 36824 },
    { 15162, 32531 },
    { 15163, 25442 },
    { 15164, 24739 },
    { 15165, 21796 },
    { 15166, 30186 },
    { 15167, 35938 },
    { 15168, 28949 },
    { 15169, 28067 },
    { 15170, 23462 },
    { 15171, 24187 },
    { 15172, 33618 },
    { 15173, 24908 },
    { 15174, 40644 },
    { 15175, 30970 },
    { 15176, 34647 },
    { 15177, 31783 },
    { 15178, 30343 },
    { 15179, 20976 },
    { 15180, 24822 },
    { 15181, 29004 },
    { 15182, 26179 },
    { 15183, 24140 },
    { 15184, 24653 },
    { 15185, 35854 },
    { 15186, 28784 },
    { 15187, 25381 },
    { 15188, 36745 },
    { 15189, 24509 },
    { 15190, 24674 },
    { 15191, 34516 },
    { 15192, 22238 },
    { 15193, 27585 },
    { 15194, 24724 },
    { 15195, 24935 },
    { 15196, 21321 },
    { 15197, 24800 },
    { 15198, 26214 },
    { 15199, 36159 },
    { 15200, 31229 },
    { 15201, 20250 },
    { 15202, 28905 },
    { 15203, 27719 },
    { 15204, 35763 },
    { 15205, 35826 },
    { 15206, 32472 },
    { 15207, 33636 },
    { 15208, 26127 },
    { 15209, 23130 },
    { 15210, 39746 },
    { 15211, 27985 },
    { 15212, 28151 },
    { 15213, 35905 },
    { 15214, 27963 },
    { 15215, 20249 },
    { 15216, 28779 },
    { 15217, 33719 },
    { 15218, 25110 },
    { 15219, 24785 },
    { 15220, 38669 },
    { 15221, 36135 },
    { 15222, 31096 },
    { 15223, 20987 },
    { 15224, 22334 },
    { 15225, 22522 },
    { 15226, 26426 },
    { 15227, 30072 },
    { 15228, 31293 },
    { 15229, 31215 },
    { 15230, 31637 },
    { 15393, 32908 },
    { 15394, 39269 },
    { 15395, 36857 },
    { 15396, 28608 },
    { 15397, 35749 },
    { 15398, 40481 },
    { 15399, 23020 },
    { 15400, 32489 },
    { 15401, 32521 },
    { 15402, 21513 },
    { 15403, 26497 },
    { 15404, 26840 },
    { 15405, 36753 },
    { 15406, 31821 },
    { 15407, 38598 },
    { 15408, 21450 },
    { 15409, 24613 },
    { 15410, 30142 },
    { 15411, 27762 },
    { 15412, 21363 },
    { 15413, 23241 },
    { 15414, 32423 },
    { 15415, 25380 },
    { 15416, 20960 },
    { 15417, 33034 },
    { 15418, 24049 },
    { 15419, 34015 },
    { 15420, 25216 },
    { 15421, 20864 },
    { 15422, 23395 },
    { 15423, 20238 },
    { 15424, 31085 },
    { 15425, 21058 },
    { 15426, 24760 },
    { 15427, 27982 },
    { 15428, 23492 },
    { 15429, 23490 },
    { 15430, 35745 },
    { 15431, 35760 },
    { 15432, 26082 },
    { 15433, 24524 },
    { 15434, 38469 },
    { 15435, 22931 },
    { 15436, 32487 },
    { 15437, 32426 },
    { 15438, 22025 },
    { 15439, 26551 },
    { 15440, 22841 },
    { 15441, 20339 },
    { 15442, 23478 },
    { 15443, 21152 },
    { 15444, 33626 },
    { 15445, 39050 },
    { 15446, 36158 },
    { 15447, 30002 },
    { 15448, 38078 },
    { 15449, 20551 },
    { 15450, 31292 },
    { 15451, 20215 },
    { 15452, 26550 },
    { 15453, 39550 },
    { 15454, 23233 },
    { 15455, 27516 },
    { 15456, 30417 },
    { 15457, 22362 },
    { 15458, 23574 },
    { 15459, 31546 },
    { 15460, 38388 },
    { 15461, 29006 },
    { 15462, 20860 },
    { 15463, 32937 },
    { 15464, 33392 },
    { 15465, 22904 },
    { 15466, 32516 },
    { 15467, 33575 },
    { 15468, 26816 },
    { 15469, 26604 },
    { 15470, 30897 },
    { 15471, 30839 },
    { 15472, 25315 },
    { 15473, 25441 },
    { 15474, 31616 },
    { 15475, 20461 },
    { 15476, 21098 },
    { 15477, 20943 },
    { 15478, 33616 },
    { 15479, 27099 },
    { 15480, 37492 },
    { 15481, 36341 },
    { 15482, 36145 },
    { 15483, 35265 },
    { 15484, 38190 },
    { 15485, 31661 },
    { 15486, 20214 },
    { 15649, 20581 },
    { 15650, 33328 },
    { 15651, 21073 },
    { 15652, 39279 },
    { 15653, 28176 },
    { 15654, 28293 },
    { 15655, 28071 },
    { 15656, 24314 },
    { 15657, 20725 },
    { 15658, 23004 },
    { 15659, 23558 },
    { 15660, 27974 },
    { 15661, 27743 },
    { 15662, 30086 },
    { 15663, 33931 },
    { 15664, 26728 },
    { 15665, 22870 },
    { 15666, 35762 },
    { 15667, 21280 },
    { 15668, 37233 },
    { 15669, 38477 },
    { 15670, 34121 },
    { 15671, 26898 },
    { 15672, 30977 },
    { 15673, 28966 },
    { 15674, 33014 },
    { 15675, 20132 },
    { 15676, 37066 },
    { 15677, 27975 },
    { 15678, 39556 },
    { 15679, 23047 },
    { 15680, 22204 },
    { 15681, 25605 },
    { 15682, 38128 },
    { 15683, 30699 },
    { 15684, 20389 },
    { 15685, 33050 },
    { 15686, 29409 },
    { 15687, 35282 },
    { 15688, 39290 },
    { 15689, 32564 },
    { 15690, 32478 },
    { 15691, 21119 },
    { 15692, 25945 },
    { 15693, 37237 },
    { 15694, 36735 },
    { 15695, 36739 },
    { 15696, 21483 },
    { 15697, 31382 },
    { 15698, 25581 },
    { 15699, 25509 },
    { 15700, 30342 },
    { 15701, 31224 },
    { 15702, 34903 },
    { 15703, 38454 },
    { 15704, 25130 },
    { 15705, 21163 },
    { 15706, 33410 },
    { 15707, 26708 },
    { 15708, 26480 },
    { 15709, 25463 },
    { 15710, 30571 },
    { 15711, 31469 },
    { 15712, 27905 },
    { 15713, 32467 },
    { 15714, 35299 },
    { 15715, 22992 },
    { 15716, 25106 },
    { 15717, 34249 },
    { 15718, 33445 },
    { 15719, 30028 },
    { 15720, 20511 },
    { 15721, 20171 },
    { 15722, 30117 },
    { 15723, 35819 },
    { 15724, 23626 },
    { 15725, 24062 },
    { 15726, 31563 },
    { 15727, 26020 },
    { 15728, 37329 },
    { 15729, 20170 },
    { 15730, 27941 },
    { 15731, 35167 },
    { 15732, 32039 },
    { 15733, 38182 },
    { 15734, 20165 },
    { 15735, 35880 },
    { 15736, 36827 },
    { 15737, 38771 },
    { 15738, 26187 },
    { 15739, 31105 },
    { 15740, 36817 },
    { 15741, 28908 },
    { 15742, 28024 },
    { 15905, 23613 },
    { 15906, 21170 },
    { 15907, 33606 },
    { 15908, 20834 },
    { 15909, 33550 },
    { 15910, 30555 },
    { 15911, 26230 },
    { 15912, 40120 },
    { 15913, 20140 },
    { 15914, 24778 },
    { 15915, 31934 },
    { 15916, 31923 },
    { 15917, 32463 },
    { 15918, 20117 },
    { 15919, 35686 },
    { 15920, 26223 },
    { 15921, 39048 },
    { 15922, 38745 },
    { 15923, 22659 },
    { 15924, 25964 },
    { 15925, 38236 },
    { 15926, 24452 },
    { 15927, 30153 },
    { 15928, 38742 },
    { 15929, 31455 },
    { 15930, 31454 },
    { 15931, 20928 },
    { 15932, 28847 },
    { 15933, 31384 },
    { 15934, 25578 },
    { 15935, 31350 },
    { 15936, 32416 },
    { 15937, 29590 },
    { 15938, 38893 },
    { 15939, 20037 },
    { 15940, 28792 },
    { 15941, 20061 },
    { 15942, 37202 },
    { 15943, 21417 },
    { 15944, 25937 },
    { 15945, 26087 },
    { 15946, 33276 },
    { 15947, 33285 },
    { 15948, 21646 },
    { 15949, 23601 },
    { 15950, 30106 },
    { 15951, 38816 },
    { 15952, 25304 },
    { 15953, 29401 },
    { 15954, 30141 },
    { 15955, 23621 },
    { 15956, 39545 },
    { 15957, 33738 },
    { 15958, 23616 },
    { 15959, 21632 },
    { 15960, 30697 },
    { 15961, 20030 },
    { 15962, 27822 },
    { 15963, 32858 },
    { 15964, 25298 },
    { 15965, 25454 },
    { 15966, 24040 },
    { 15967, 20855 },
    { 15968, 36317 },
    { 15969, 36382 },
    { 15970, 38191 },
    { 15971, 20465 },
    { 15972, 21477 },
    { 15973, 24807 },
    { 15974, 28844 },
    { 15975, 21095 },
    { 15976, 25424 },
    { 15977, 40515 },
    { 15978, 23071 },
    { 15979, 20518 },
    { 15980, 30519 },
    { 15981, 21367 },
    { 15982, 32482 },
    { 15983, 25733 },
    { 15984, 25899 },
    { 15985, 25225 },
    { 15986, 25496 },
    { 15987, 20500 },
    { 15988, 29237 },
    { 15989, 35273 },
    { 15990, 20915 },
    { 15991, 35776 },
    { 15992, 32477 },
    { 15993, 22343 },
    { 15994, 33740 },
    { 15995, 38055 },
    { 15996, 20891 },
    { 15997, 21531 },
    { 15998, 23803 },
    { 16161, 20426 },
    { 16162, 31459 },
    { 16163, 27994 },
    { 16164, 37089 },
    { 16165, 39567 },
    { 16166, 21888 },
    { 16167, 21654 },
    { 16168, 21345 },
    { 16169, 21679 },
    { 16170, 24320 },
    { 16171, 25577 },
    { 16172, 26999 },
    { 16173, 20975 },
    { 16174, 24936 },
    { 16175, 21002 },
    { 16176, 22570 },
    { 16177, 21208 },
    { 16178, 22350 },
    { 16179, 30733 },
    { 16180, 30475 },
    { 16181, 24247 },
    { 16182, 24951 },
    { 16183, 31968 },
    { 16184, 25179 },
    { 16185, 25239 },
    { 16186, 20130 },
    { 16187, 28821 },
    { 16188, 32771 },
    { 16189, 25335 },
    { 16190, 28900 },
    { 16191, 38752 },
    { 16192, 22391 },
    { 16193, 33499 },
    { 16194, 26607 },
    { 16195, 26869 },
    { 16196, 30933 },
    { 16197, 39063 },
    { 16198, 31185 },
    { 16199, 22771 },
    { 16200, 21683 },
    { 16201, 21487 },
    { 16202, 28212 },
    { 16203, 20811 },
    { 16204, 21051 },
    { 16205, 23458 },
    { 16206, 35838 },
    { 16207, 32943 },
    { 16208, 21827 },
    { 16209, 22438 },
    { 16210, 24691 },
    { 16211, 22353 },
    { 16212, 21549 },
    { 16213, 31354 },
    { 16214, 24656 },
    { 16215, 23380 },
    { 16216, 25511 },
    { 16217, 25248 },
    { 16218, 21475 },
    { 16219, 25187 },
    { 16220, 23495 },
    { 16221, 26543 },
    { 16222, 21741 },
    { 16223, 31391 },
    { 16224, 33510 },
    { 16225, 37239 },
    { 16226, 24211 },
    { 16227, 35044 },
    { 16228, 22840 },
    { 16229, 22446 },
    { 16230, 25358 },
    { 16231, 36328 },
    { 16232, 33007 },
    { 16233, 22359 },
    { 16234, 31607 },
    { 16235, 20393 },
    { 16236, 24555 },
    { 16237, 23485 },
    { 16238, 27454 },
    { 16239, 21281 },
    { 16240, 31568 },
    { 16241, 29378 },
    { 16242, 26694 },
    { 16243, 30719 },
    { 16244, 30518 },
    { 16245, 26103 },
    { 16246, 20917 },
    { 16247, 20111 },
    { 16248, 30420 },
    { 16249, 23743 },
    { 16250, 31397 },
    { 16251, 33909 },
    { 16252, 22862 },
    { 16253, 39745 },
    { 16254, 20608 },
    { 16417, 39304 },
    { 16418, 24871 },
    { 16419, 28291 },
    { 16420, 22372 },
    { 16421, 26118 },
    { 16422, 25414 },
    { 16423, 22256 },
    { 16424, 25324 },
    { 16425, 25193 },
    { 16426, 24275 },
    { 16427, 38420 },
    { 16428, 22403 },
    { 16429, 25289 },
    { 16430, 21895 },
    { 16431, 34593 },
    { 16432, 33098 },
    { 16433, 36771 },
    { 16434, 21862 },
    { 16435, 33713 },
    { 16436, 26469 },
    { 16437, 36182 },
    { 16438, 34013 },
    { 16439, 23146 },
    { 16440, 26639 },
    { 16441, 25318 },
    { 16442, 31726 },
    { 16443, 38417 },
    { 16444, 20848 },
    { 16445, 28572 },
    { 16446, 35888 },
    { 16447, 25597 },
    { 16448, 35272 },
    { 16449, 25042 },
    { 16450, 32518 },
    { 16451, 28866 },
    { 16452, 28389 },
    { 16453, 29701 },
    { 16454, 27028 },
    { 16455, 29436 },
    { 16456, 24266 },
    { 16457, 37070 },
    { 16458, 26391 },
    { 16459, 28010 },
    { 16460, 25438 },
    { 16461, 21171 },
    { 16462, 29282 },
    { 16463, 32769 },
    { 16464, 20332 },
    { 16465, 23013 },
    { 16466, 37226 },
    { 16467, 28889 },
    { 16468, 28061 },
    { 16469, 21202 },
    { 16470, 20048 },
    { 16471, 38647 },
    { 16472, 38253 },
    { 16473, 34174 },
    { 16474, 30922 },
    { 16475, 32047 },
    { 16476, 20769 },
    { 16477, 22418 },
    { 16478, 25794 },
    { 16479, 32907 },
    { 16480, 31867 },
    { 16481, 27882 },
    { 16482, 26865 },
    { 16483, 26974 },
    { 16484, 20919 },
    { 16485, 21400 },
    { 16486, 26792 },
    { 16487, 29313 },
    { 16488, 40654 },
    { 16489, 31729 },
    { 16490, 29432 },
    { 16491, 31163 },
    { 16492, 28435 },
    { 16493, 29702 },
    { 16494, 26446 },
    { 16495, 37324 },
    { 16496, 40100 },
    { 16497, 31036 },
    { 16498, 33673 },
    { 16499, 33620 },
    { 16500, 21519 },
    { 16501, 26647 },
    { 16502, 20029 },
    { 16503, 21385 },
    { 16504, 21169 },
    { 16505, 30782 },
    { 16506, 21382 },
    { 16507, 21033 },
    { 16508, 20616 },
    { 16509, 20363 },
    { 16510, 20432 },
    { 16673, 30178 },
    { 16674, 31435 },
    { 16675, 31890 },
    { 16676, 27813 },
    { 16677, 38582 },
    { 16678, 21147 },
    { 16679, 29827 },
    { 16680, 21737 },
    { 16681, 20457 },
    { 16682, 32852 },
    { 16683, 33714 },
    { 16684, 36830 },
    { 16685, 38256 },
    { 16686, 24265 },
    { 16687, 24604 },
    { 16688, 28063 },
    { 16689, 24088 },
    { 16690, 25947 },
    { 16691, 33080 },
    { 16692, 38142 },
    { 16693, 24651 },
    { 16694, 28860 },
    { 16695, 32451 },
    { 16696, 31918 },
    { 16697, 20937 },
    { 16698, 26753 },
    { 16699, 31921 },
    { 16700, 33391 },
    { 16701, 20004 },
    { 16702, 36742 },
    { 16703, 37327 },
    { 16704, 26238 },
    { 16705, 20142 },
    { 16706, 35845 },
    { 16707, 25769 },
    { 16708, 32842 },
    { 16709, 20698 },
    { 16710, 30103 },
    { 16711, 29134 },
    { 16712, 23525 },
    { 16713, 36797 },
    { 16714, 28518 },
    { 16715, 20102 },
    { 16716, 25730 },
    { 16717, 38243 },
    { 16718, 24278 },
    { 16719, 26009 },
    { 16720, 21015 },
    { 16721, 35010 },
    { 16722, 28872 },
    { 16723, 21155 },
    { 16724, 29454 },
    { 16725, 29747 },
    { 16726, 26519 },
    { 16727, 30967 },
    { 16728, 38678 },
    { 16729, 20020 },
    { 16730, 37051 },
    { 16731, 40158 },
    { 16732, 28107 },
    { 16733, 20955 },
    { 16734, 36161 },
    { 16735, 21533 },
    { 16736, 25294 },
    { 16737, 29618 },
    { 16738, 33777 },
    { 16739, 38646 },
    { 16740, 40836 },
    { 16741, 38083 },
    { 16742, 20278 },
    { 16743, 32666 },
    { 16744, 20940 },
    { 16745, 28789 },
    { 16746, 38517 },
    { 16747, 23725 },
    { 16748, 39046 },
    { 16749, 21478 },
    { 16750, 20196 },
    { 16751, 28316 },
    { 16752, 29705 },
    { 16753, 27060 },
    { 16754, 30827 },
    { 16755, 39311 },
    { 16756, 30041 },
    { 16757, 21016 },
    { 16758, 30244 },
    { 16759, 27969 },
    { 16760, 26611 },
    { 16761, 20845 },
    { 16762, 40857 },
    { 16763, 32843 },
    { 16764, 21657 },
    { 16765, 31548 },
    { 16766, 31423 },
    { 16929, 38534 },
    { 16930, 22404 },
    { 16931, 25314 },
    { 16932, 38471 },
    { 16933, 27004 },
    { 16934, 23044 },
    { 16935, 25602 },
    { 16936, 31699 },
    { 16937, 28431 },
    { 16938, 38475 },
    { 16939, 33446 },
    { 16940, 21346 },
    { 16941, 39045 },
    { 16942, 24208 },
    { 16943, 28809 },
    { 16944, 25523 },
    { 16945, 21348 },
    { 16946, 34383 },
    { 16947, 40065 },
    { 16948, 40595 },
    { 16949, 30860 },
    { 16950, 38706 },
    { 16951, 36335 },
    { 16952, 36162 },
    { 16953, 40575 },
    { 16954, 28510 },
    { 16955, 31108 },
    { 16956, 24405 },
    { 16957, 38470 },
    { 16958, 25134 },
    { 16959, 39540 },
    { 16960, 21525 },
    { 16961, 38109 },
    { 16962, 20387 },
    { 16963, 26053 },
    { 16964, 23653 },
    { 16965, 23649 },
    { 16966, 32533 },
    { 16967, 34385 },
    { 16968, 27695 },
    { 16969, 24459 },
    { 16970, 29575 },
    { 16971, 28388 },
    { 16972, 32511 },
    { 16973, 23782 },
    { 16974, 25371 },
    { 16975, 23402 },
    { 16976, 28390 },
    { 16977, 21365 },
    { 16978, 20081 },
    { 16979, 25504 },
    { 16980, 30053 },
    { 16981, 25249 },
    { 16982, 36718 },
    { 16983, 20262 },
    { 16984, 20177 },
    { 16985, 27814 },
    { 16986, 32438 },
    { 16987, 35770 },
    { 16988, 33821 },
    { 16989, 34746 },
    { 16990, 32599 },
    { 16991, 36923 },
    { 16992, 38179 },
    { 16993, 31657 },
    { 16994, 39585 },
    { 16995, 35064 },
    { 16996, 33853 },
    { 16997, 27931 },
    { 16998, 39558 },
    { 16999, 32476 },
    { 17000, 22920 },
    { 17001, 40635 },
    { 17002, 29595 },
    { 17003, 30721 },
    { 17004, 34434 },
    { 17005, 39532 },
    { 17006, 39554 },
    { 17007, 22043 },
    { 17008, 21527 },
    { 17009, 22475 },
    { 17010, 20080 },
    { 17011, 40614 },
    { 17012, 21334 },
    { 17013, 36808 },
    { 17014, 33033 },
    { 17015, 30610 },
    { 17016, 39314 },
    { 17017, 34542 },
    { 17018, 28385 },
    { 17019, 34067 },
    { 17020, 26364 },
    { 17021, 24930 },
    { 17022, 28459 },
    { 17185, 35881 },
    { 17186, 33426 },
    { 17187, 33579 },
    { 17188, 30450 },
    { 17189, 27667 },
    { 17190, 24537 },
    { 17191, 33725 },
    { 17192, 29483 },
    { 17193, 33541 },
    { 17194, 38170 },
    { 17195, 27611 },
    { 17196, 30683 },
    { 17197, 38086 },
    { 17198, 21359 },
    { 17199, 33538 },
    { 17200, 20882 },
    { 17201, 24125 },
    { 17202, 35980 },
    { 17203, 36152 },
    { 17204, 20040 },
    { 17205, 29611 },
    { 17206, 26522 },
    { 17207, 26757 },
    { 17208, 37238 },
    { 17209, 38665 },
    { 17210, 29028 },
    { 17211, 27809 },
    { 17212, 30473 },
    { 17213, 23186 },
    { 17214, 38209 },
    { 17215, 27599 },
    { 17216, 32654 },
    { 17217, 26151 },
    { 17218, 23504 },
    { 17219, 22969 },
    { 17220, 23194 },
    { 17221, 38376 },
    { 17222, 38391 },
    { 17223, 20204 },
    { 17224, 33804 },
    { 17225, 33945 },
    { 17226, 27308 },
    { 17227, 30431 },
    { 17228, 38192 },
    { 17229, 29467 },
    { 17230, 26790 },
    { 17231, 23391 },
    { 17232, 30511 },
    { 17233, 37274 },
    { 17234, 38753 },
    { 17235, 31964 },
    { 17236, 36855 },
    { 17237, 35868 },
    { 17238, 24357 },
    { 17239, 31859 },
    { 17240, 31192 },
    { 17241, 35269 },
    { 17242, 27852 },
    { 17243, 34588 },
    { 17244, 23494 },
    { 17245, 24130 },
    { 17246, 26825 },
    { 17247, 30496 },
    { 17248, 32501 },
    { 17249, 20885 },
    { 17250, 20813 },
    { 17251, 21193 },
    { 17252, 23081 },
    { 17253, 32517 },
    { 17254, 38754 },
    { 17255, 33495 },
    { 17256, 25551 },
    { 17257, 30596 },
    { 17258, 34256 },
    { 17259, 31186 },
    { 17260, 28218 },
    { 17261, 24217 },
    { 17262, 22937 },
    { 17263, 34065 },
    { 17264, 28781 },
    { 17265, 27665 },
    { 17266, 25279 },
    { 17267, 30399 },
    { 17268, 25935 },
    { 17269, 24751 },
    { 17270, 38397 },
    { 17271, 26126 },
    { 17272, 34719 },
    { 17273, 40483 },
    { 17274, 38125 },
    { 17275, 21517 },
    { 17276, 21629 },
    { 17277, 35884 },
    { 17278, 25720 },
    { 17441, 25721 },
    { 17442, 34321 },
    { 17443, 27169 },
    { 17444, 33180 },
    { 17445, 30952 },
    { 17446, 25705 },
    { 17447, 39764 },
    { 17448, 25273 },
    { 17449, 26411 },
    { 17450, 33707 },
    { 17451, 22696 },
    { 17452, 40664 },
    { 17453, 27819 },
    { 17454, 28448 },
    { 17455, 23518 },
    { 17456, 38476 },
    { 17457, 35851 },
    { 17458, 29279 },
    { 17459, 26576 },
    { 17460, 25287 },
    { 17461, 29281 },
    { 17462, 20137 },
    { 17463, 22982 },
    { 17464, 27597 },
    { 17465, 22675 },
    { 17466, 26286 },
    { 17467, 24149 },
    { 17468, 21215 },
    { 17469, 24917 },
    { 17470, 26408 },
    { 17471, 30446 },
    { 17472, 30566 },
    { 17473, 29287 },
    { 17474, 31302 },
    { 17475, 25343 },
    { 17476, 21738 },
    { 17477, 21584 },
    { 17478, 38048 },
    { 17479, 37027 },
    { 17480, 23068 },
    { 17481, 32435 },
    { 17482, 27670 },
    { 17483, 20035 },
    { 17484, 22902 },
    { 17485, 32784 },
    { 17486, 22856 },
    { 17487, 21335 },
    { 17488, 30007 },
    { 17489, 38590 },
    { 17490, 22218 },
    { 17491, 25376 },
    { 17492, 33041 },
    { 17493, 24700 },
    { 17494, 38393 },
    { 17495, 28118 },
    { 17496, 21602 },
    { 17497, 39297 },
    { 17498, 20869 },
    { 17499, 23273 },
    { 17500, 33021 },
    { 17501, 22958 },
    { 17502, 38675 },
    { 17503, 20522 },
    { 17504, 27877 },
    { 17505, 23612 },
    { 17506, 25311 },
    { 17507, 20320 },
    { 17508, 21311 },
    { 17509, 33147 },
    { 17510, 36870 },
    { 17511, 28346 },
    { 17512, 34091 },
    { 17513, 25288 },
    { 17514, 24180 },
    { 17515, 30910 },
    { 17516, 25781 },
    { 17517, 25467 },
    { 17518, 24565 },
    { 17519, 23064 },
    { 17520, 37247 },
    { 17521, 40479 },
    { 17522, 23615 },
    { 17523, 25423 },
    { 17524, 32834 },
    { 17525, 23421 },
    { 17526, 21870 },
    { 17527, 38218 },
    { 17528, 38221 },
    { 17529, 28037 },
    { 17530, 24744 },
    { 17531, 26592 },
    { 17532, 29406 },
    { 17533, 20957 },
    { 17534, 23425 },
    { 17697, 25319 },
    { 17698, 27870 },
    { 17699, 29275 },
    { 17700, 25197 },
    { 17701, 38062 },
    { 17702, 32445 },
    { 17703, 33043 },
    { 17704, 27987 },
    { 17705, 20892 },
    { 17706, 24324 },
    { 17707, 22900 },
    { 17708, 21162 },
    { 17709, 24594 },
    { 17710, 22899 },
    { 17711, 26262 },
    { 17712, 34384 },
    { 17713, 30111 },
    { 17714, 25386 },
    { 17715, 25062 },
    { 17716, 31983 },
    { 17717, 35834 },
    { 17718, 21734 },
    { 17719, 27431 },
    { 17720, 40485 },
    { 17721, 27572 },
    { 17722, 34261 },
    { 17723, 21589 },
    { 17724, 20598 },
    { 17725, 27812 },
    { 17726, 21866 },
    { 17727, 36276 },
    { 17728, 29228 },
    { 17729, 24085 },
    { 17730, 24597 },
    { 17731, 29750 },
    { 17732, 25293 },
    { 17733, 25490 },
    { 17734, 29260 },
    { 17735, 24472 },
    { 17736, 28227 },
    { 17737, 27966 },
    { 17738, 25856 },
    { 17739, 28504 },
    { 17740, 30424 },
    { 17741, 30928 },
    { 17742, 30460 },
    { 17743, 30036 },
    { 17744, 21028 },
    { 17745, 21467 },
    { 17746, 20051 },
    { 17747, 24222 },
    { 17748, 26049 },
    { 17749, 32810 },
    { 17750, 32982 },
    { 17751, 25243 },
    { 17752, 21638 },
    { 17753, 21032 },
    { 17754, 28846 },
    { 17755, 34957 },
    { 17756, 36305 },
    { 17757, 27873 },
    { 17758, 21624 },
    { 17759, 32986 },
    { 17760, 22521 },
    { 17761, 35060 },
    { 17762, 36180 },
    { 17763, 38506 },
    { 17764, 37197 },
    { 17765, 20329 },
    { 17766, 27803 },
    { 17767, 21943 },
    { 17768, 30406 },
    { 17769, 30768 },
    { 17770, 25256 },
    { 17771, 28921 },
    { 17772, 28558 },
    { 17773, 24429 },
    { 17774, 34028 },
    { 17775, 26842 },
    { 17776, 30844 },
    { 17777, 31735 },
    { 17778, 33192 },
    { 17779, 26379 },
    { 17780, 40527 },
    { 17781, 25447 },
    { 17782, 30896 },
    { 17783, 22383 },
    { 17784, 30738 },
    { 17785, 38713 },
    { 17786, 25209 },
    { 17787, 25259 },
    { 17788, 21128 },
    { 17789, 29749 },
    { 17790, 27607 },
    { 17953, 21860 },
    { 17954, 33086 },
    { 17955, 30130 },
    { 17956, 30382 },
    { 17957, 21305 },
    { 17958, 30174 },
    { 17959, 20731 },
    { 17960, 23617 },
    { 17961, 35692 },
    { 17962, 31687 },
    { 17963, 20559 },
    { 17964, 29255 },
    { 17965, 39575 },
    { 17966, 39128 },
    { 17967, 28418 },
    { 17968, 29922 },
    { 17969, 31080 },
    { 17970, 25735 },
    { 17971, 30629 },
    { 17972, 25340 },
    { 17973, 39057 },
    { 17974, 36139 },
    { 17975, 21697 },
    { 17976, 32856 },
    { 17977, 20050 },
    { 17978, 22378 },
    { 17979, 33529 },
    { 17980, 33805 },
    { 17981, 24179 },
    { 17982, 20973 },
    { 17983, 29942 },
    { 17984, 35780 },
    { 17985, 23631 },
    { 17986, 22369 },
    { 17987, 27900 },
    { 17988, 39047 },
    { 17989, 23110 },
    { 17990, 30772 },
    { 17991, 39748 },
    { 17992, 36843 },
    { 17993, 31893 },
    { 17994, 21078 },
    { 17995, 25169 },
    { 17996, 38138 },
    { 17997, 20166 },
    { 17998, 33670 },
    { 17999, 33889 },
    { 18000, 33769 },
    { 18001, 33970 },
    { 18002, 22484 },
    { 18003, 26420 },
    { 18004, 22275 },
    { 18005, 26222 },
    { 18006, 28006 },
    { 18007, 35889 },
    { 18008, 26333 },
    { 18009, 28689 },
    { 18010, 26399 },
    { 18011, 27450 },
    { 18012, 26646 },
    { 18013, 25114 },
    { 18014, 22971 },
    { 18015, 19971 },
    { 18016, 20932 },
    { 18017, 28422 },
    { 18018, 26578 },
    { 18019, 27791 },
    { 18020, 20854 },
    { 18021, 26827 },
    { 18022, 22855 },
    { 18023, 27495 },
    { 18024, 30054 },
    { 18025, 23822 },
    { 18026, 33040 },
    { 18027, 40784 },
    { 18028, 26071 },
    { 18029, 31048 },
    { 18030, 31041 },
    { 18031, 39569 },
    { 18032, 36215 },
    { 18033, 23682 },
    { 18034, 20062 },
    { 18035, 20225 },
    { 18036, 21551 },
    { 18037, 22865 },
    { 18038, 30732 },
    { 18039, 22120 },
    { 18040, 27668 },
    { 18041, 36804 },
    { 18042, 24323 },
    { 18043, 27773 },
    { 18044, 27875 },
    { 18045, 35755 },
    { 18046, 25488 },
    { 18209, 24688 },
    { 18210, 27965 },
    { 18211, 29301 },
    { 18212, 25190 },
    { 18213, 38030 },
    { 18214, 38085 },
    { 18215, 21315 },
    { 18216, 36801 },
    { 18217, 31614 },
    { 18218, 20191 },
    { 18219, 35878 },
    { 18220, 20094 },
    { 18221, 40660 },
    { 18222, 38065 },
    { 18223, 38067 },
    { 18224, 21069 },
    { 18225, 28508 },
    { 18226, 36963 },
    { 18227, 27973 },
    { 18228, 35892 },
    { 18229, 22545 },
    { 18230, 23884 },
    { 18231, 27424 },
    { 18232, 27465 },
    { 18233, 26538 },
    { 18234, 21595 },
    { 18235, 33108 },
    { 18236, 32652 },
    { 18237, 22681 },
    { 18238, 34103 },
    { 18239, 24378 },
    { 18240, 25250 },
    { 18241, 27207 },
    { 18242, 38201 },
    { 18243, 25970 },
    { 18244, 24708 },
    { 18245, 26725 },
    { 18246, 30631 },
    { 18247, 20052 },
    { 18248, 20392 },
    { 18249, 24039 },
    { 18250, 38808 },
    { 18251, 25772 },
    { 18252, 32728 },
    { 18253, 23789 },
    { 18254, 20431 },
    { 18255, 31373 },
    { 18256, 20999 },
    { 18257, 33540 },
    { 18258, 19988 },
    { 18259, 24623 },
    { 18260, 31363 },
    { 18261, 38054 },
    { 18262, 20405 },
    { 18263, 20146 },
    { 18264, 31206 },
    { 18265, 29748 },
    { 18266, 21220 },
    { 18267, 33465 },
    { 18268, 25810 },
    { 18269, 31165 },
    { 18270, 23517 },
    { 18271, 27777 },
    { 18272, 38738 },
    { 18273, 36731 },
    { 18274, 27682 },
    { 18275, 20542 },
    { 18276, 21375 },
    { 18277, 28165 },
    { 18278, 25806 },
    { 18279, 26228 },
    { 18280, 27696 },
    { 18281, 24773 },
    { 18282, 39031 },
    { 18283, 35831 },
    { 18284, 24198 },
    { 18285, 29756 },
    { 18286, 31351 },
    { 18287, 31179 },
    { 18288, 19992 },
    { 18289, 37041 },
    { 18290, 29699 },
    { 18291, 27714 },
    { 18292, 22234 },
    { 18293, 37195 },
    { 18294, 27845 },
    { 18295, 36235 },
    { 18296, 21306 },
    { 18297, 34502 },
    { 18298, 26354 },
    { 18299, 36527 },
    { 18300, 23624 },
    { 18301, 39537 },
    { 18302, 28192 },
    { 18465, 21462 },
    { 18466, 23094 },
    { 18467, 40843 },
    { 18468, 36259 },
    { 18469, 21435 },
    { 18470, 22280 },
    { 18471, 39079 },
    { 18472, 26435 },
    { 18473, 37275 },
    { 18474, 27849 },
    { 18475, 20840 },
    { 18476, 30154 },
    { 18477, 25331 },
    { 18478, 29356 },
    { 18479, 21048 },
    { 18480, 21149 },
    { 18481, 32570 },
    { 18482, 28820 },
    { 18483, 30264 },
    { 18484, 21364 },
    { 18485, 40522 },
    { 18486, 27063 },
    { 18487, 30830 },
    { 18488, 38592 },
    { 18489, 35033 },
    { 18490, 32676 },
    { 18491, 28982 },
    { 18492, 29123 },
    { 18493, 20873 },
    { 18494, 26579 },
    { 18495, 29924 },
    { 18496, 22756 },
    { 18497, 25880 },
    { 18498, 22199 },
    { 18499, 35753 },
    { 18500, 39286 },
    { 18501, 25200 },
    { 18502, 32469 },
    { 18503, 24825 },
    { 18504, 28909 },
    { 18505, 22764 },
    { 18506, 20161 },
    { 18507, 20154 },
    { 18508, 24525 },
    { 18509, 38887 },
    { 18510, 20219 },
    { 18511, 35748 },
    { 18512, 20995 },
    { 18513, 22922 },
    { 18514, 32427 },
    { 18515, 25172 },
    { 18516, 20173 },
    { 18517, 26085 },
    { 18518, 25102 },
    { 18519, 33592 },
    { 18520, 33993 },
    { 18521, 33635 },
    { 18522, 34701 },
    { 18523, 29076 },
    { 18524, 28342 },
    { 18525, 23481 },
    { 18526, 32466 },
    { 18527, 20887 },
    { 18528, 25545 },
    { 18529, 26580 },
    { 18530, 32905 },
    { 18531, 33593 },
    { 18532, 34837 },
    { 18533, 20754 },
    { 18534, 23418 },
    { 18535, 22914 },
    { 18536, 36785 },
    { 18537, 20083 },
    { 18538, 27741 },
    { 18539, 20837 },
    { 18540, 35109 },
    { 18541, 36719 },
    { 18542, 38446 },
    { 18543, 34122 },
    { 18544, 29790 },
    { 18545, 38160 },
    { 18546, 38384 },
    { 18547, 28070 },
    { 18548, 33509 },
    { 18549, 24369 },
    { 18550, 25746 },
    { 18551, 27922 },
    { 18552, 33832 },
    { 18553, 33134 },
    { 18554, 40131 },
    { 18555, 22622 },
    { 18556, 36187 },
    { 18557, 19977 },
    { 18558, 21441 },
    { 18721, 20254 },
    { 18722, 25955 },
    { 18723, 26705 },
    { 18724, 21971 },
    { 18725, 20007 },
    { 18726, 25620 },
    { 18727, 39578 },
    { 18728, 25195 },
    { 18729, 23234 },
    { 18730, 29791 },
    { 18731, 33394 },
    { 18732, 28073 },
    { 18733, 26862 },
    { 18734, 20711 },
    { 18735, 33678 },
    { 18736, 30722 },
    { 18737, 26432 },
    { 18738, 21049 },
    { 18739, 27801 },
    { 18740, 32433 },
    { 18741, 20667 },
    { 18742, 21861 },
    { 18743, 29022 },
    { 18744, 31579 },
    { 18745, 26194 },
    { 18746, 29642 },
    { 18747, 33515 },
    { 18748, 26441 },
    { 18749, 23665 },
    { 18750, 21024 },
    { 18751, 29053 },
    { 18752, 34923 },
    { 18753, 38378 },
    { 18754, 38485 },
    { 18755, 25797 },
    { 18756, 36193 },
    { 18757, 33203 },
    { 18758, 21892 },
    { 18759, 27733 },
    { 18760, 25159 },
    { 18761, 32558 },
    { 18762, 22674 },
    { 18763, 20260 },
    { 18764, 21830 },
    { 18765, 36175 },
    { 18766, 26188 },
    { 18767, 19978 },
    { 18768, 23578 },
    { 18769, 35059 },
    { 18770, 26786 },
    { 18771, 25422 },
    { 18772, 31245 },
    { 18773, 28903 },
    { 18774, 33421 },
    { 18775, 21242 },
    { 18776, 38902 },
    { 18777, 23569 },
    { 18778, 21736 },
    { 18779, 37045 },
    { 18780, 32461 },
    { 18781, 22882 },
    { 18782, 36170 },
    { 18783, 34503 },
    { 18784, 33292 },
    { 18785, 33293 },
    { 18786, 36198 },
    { 18787, 25668 },
    { 18788, 23556 },
    { 18789, 24913 },
    { 18790, 28041 },
    { 18791, 31038 },
    { 18792, 35774 },
    { 18793, 30775 },
    { 18794, 30003 },
    { 18795, 21627 },
    { 18796, 20280 },
    { 18797, 36523 },
    { 18798, 28145 },
    { 18799, 23072 },
    { 18800, 32453 },
    { 18801, 31070 },
    { 18802, 27784 },
    { 18803, 23457 },
    { 18804, 23158 },
    { 18805, 29978 },
    { 18806, 32958 },
    { 18807, 24910 },
    { 18808, 28183 },
    { 18809, 22768 },
    { 18810, 29983 },
    { 18811, 29989 },
    { 18812, 29298 },
    { 18813, 21319 },
    { 18814, 32499 },
    { 18977, 30465 },
    { 18978, 30427 },
    { 18979, 21097 },
    { 18980, 32988 },
    { 18981, 22307 },
    { 18982, 24072 },
    { 18983, 22833 },
    { 18984, 29422 },
    { 18985, 26045 },
    { 18986, 28287 },
    { 18987, 35799 },
    { 18988, 23608 },
    { 18989, 34417 },
    { 18990, 21313 },
    { 18991, 30707 },
    { 18992, 25342 },
    { 18993, 26102 },
    { 18994, 20160 },
    { 18995, 39135 },
    { 18996, 34432 },
    { 18997, 23454 },
    { 18998, 35782 },
    { 18999, 21490 },
    { 19000, 30690 },
    { 19001, 20351 },
    { 19002, 23630 },
    { 19003, 39542 },
    { 19004, 22987 },
    { 19005, 24335 },
    { 19006, 31034 },
    { 19007, 22763 },
    { 19008, 19990 },
    { 19009, 26623 },
    { 19010, 20107 },
    { 19011, 25325 },
    { 19012, 35475 },
    { 19013, 36893 },
    { 19014, 21183 },
    { 19015, 26159 },
    { 19016, 21980 },
    { 19017, 22124 },
    { 19018, 36866 },
    { 19019, 20181 },
    { 19020, 20365 },
    { 19021, 37322 },
    { 19022, 39280 },
    { 19023, 27663 },
    { 19024, 24066 },
    { 19025, 24643 },
    { 19026, 23460 },
    { 19027, 35270 },
    { 19028, 35797 },
    { 19029, 25910 },
    { 19030, 25163 },
    { 19031, 39318 },
    { 19032, 23432 },
    { 19033, 23551 },
    { 19034, 25480 },
    { 19035, 21806 },
    { 19036, 21463 },
    { 19037, 30246 },
    { 19038, 20861 },
    { 19039, 34092 },
    { 19040, 26530 },
    { 19041, 26803 },
    { 19042, 27530 },
    { 19043, 25234 },
    { 19044, 36755 },
    { 19045, 21460 },
    { 19046, 33298 },
    { 19047, 28113 },
    { 19048, 30095 },
    { 19049, 20070 },
    { 19050, 36174 },
    { 19051, 23408 },
    { 19052, 29087 },
    { 19053, 34223 },
    { 19054, 26257 },
    { 19055, 26329 },
    { 19056, 32626 },
    { 19057, 34560 },
    { 19058, 40653 },
    { 19059, 40736 },
    { 19060, 23646 },
    { 19061, 26415 },
    { 19062, 36848 },
    { 19063, 26641 },
    { 19064, 26463 },
    { 19065, 25101 },
    { 19066, 31446 },
    { 19067, 22661 },
    { 19068, 24246 },
    { 19069, 25968 },
    { 19070, 28465 },
    { 19233, 24661 },
    { 19234, 21047 },
    { 19235, 32781 },
    { 19236, 25684 },
    { 19237, 34928 },
    { 19238, 29993 },
    { 19239, 24069 },
    { 19240, 26643 },
    { 19241, 25332 },
    { 19242, 38684 },
    { 19243, 21452 },
    { 19244, 29245 },
    { 19245, 35841 },
    { 19246, 27700 },
    { 19247, 30561 },
    { 19248, 31246 },
    { 19249, 21550 },
    { 19250, 30636 },
    { 19251, 39034 },
    { 19252, 33308 },
    { 19253, 35828 },
    { 19254, 30805 },
    { 19255, 26388 },
    { 19256, 28865 },
    { 19257, 26031 },
    { 19258, 25749 },
    { 19259, 22070 },
    { 19260, 24605 },
    { 19261, 31169 },
    { 19262, 21496 },
    { 19263, 19997 },
    { 19264, 27515 },
    { 19265, 32902 },
    { 19266, 23546 },
    { 19267, 21987 },
    { 19268, 22235 },
    { 19269, 20282 },
    { 19270, 20284 },
    { 19271, 39282 },
    { 19272, 24051 },
    { 19273, 26494 },
    { 19274, 32824 },
    { 19275, 24578 },
    { 19276, 39042 },
    { 19277, 36865 },
    { 19278, 23435 },
    { 19279, 35772 },
    { 19280, 35829 },
    { 19281, 25628 },
    { 19282, 33368 },
    { 19283, 25822 },
    { 19284, 22013 },
    { 19285, 33487 },
    { 19286, 37221 },
    { 19287, 20439 },
    { 19288, 32032 },
    { 19289, 36895 },
    { 19290, 31903 },
    { 19291, 20723 },
    { 19292, 22609 },
    { 19293, 28335 },
    { 19294, 23487 },
    { 19295, 35785 },
    { 19296, 32899 },
    { 19297, 37240 },
    { 19298, 33948 },
    { 19299, 31639 },
    { 19300, 34429 },
    { 19301, 38539 },
    { 19302, 38543 },
    { 19303, 32485 },
    { 19304, 39635 },
    { 19305, 30862 },
    { 19306, 23681 },
    { 19307, 31319 },
    { 19308, 36930 },
    { 19309, 38567 },
    { 19310, 31071 },
    { 19311, 23385 },
    { 19312, 25439 },
    { 19313, 31499 },
    { 19314, 34001 },
    { 19315, 26797 },
    { 19316, 21766 },
    { 19317, 32553 },
    { 19318, 29712 },
    { 19319, 32034 },
    { 19320, 38145 },
    { 19321, 25152 },
    { 19322, 22604 },
    { 19323, 20182 },
    { 19324, 23427 },
    { 19325, 22905 },
    { 19326, 22612 },
    { 19489, 29549 },
    { 19490, 25374 },
    { 19491, 36427 },
    { 19492, 36367 },
    { 19493, 32974 },
    { 19494, 33492 },
    { 19495, 25260 },
    { 19496, 21488 },
    { 19497, 27888 },
    { 19498, 37214 },
    { 19499, 22826 },
    { 19500, 24577 },
    { 19501, 27760 },
    { 19502, 22349 },
    { 19503, 25674 },
    { 19504, 36138 },
    { 19505, 30251 },
    { 19506, 28393 },
    { 19507, 22363 },
    { 19508, 27264 },
    { 19509, 30192 },
    { 19510, 28525 },
    { 19511, 35885 },
    { 19512, 35848 },
    { 19513, 22374 },
    { 19514, 27631 },
    { 19515, 34962 },
    { 19516, 30899 },
    { 19517, 25506 },
    { 19518, 21497 },
    { 19519, 28845 },
    { 19520, 27748 },
    { 19521, 22616 },
    { 19522, 25642 },
    { 19523, 22530 },
    { 19524, 26848 },
    { 19525, 33179 },
    { 19526, 21776 },
    { 19527, 31958 },
    { 19528, 20504 },
    { 19529, 36538 },
    { 19530, 28108 },
    { 19531, 36255 },
    { 19532, 28907 },
    { 19533, 25487 },
    { 19534, 28059 },
    { 19535, 28372 },
    { 19536, 32486 },
    { 19537, 33796 },
    { 19538, 26691 },
    { 19539, 36867 },
    { 19540, 28120 },
    { 19541, 38518 },
    { 19542, 35752 },
    { 19543, 22871 },
    { 19544, 29305 },
    { 19545, 34276 },
    { 19546, 33150 },
    { 19547, 30140 },
    { 19548, 35466 },
    { 19549, 26799 },
    { 19550, 21076 },
    { 19551, 36386 },
    { 19552, 38161 },
    { 19553, 25552 },
    { 19554, 39064 },
    { 19555, 36420 },
    { 19556, 21884 },
    { 19557, 20307 },
    { 19558, 26367 },
    { 19559, 22159 },
    { 19560, 24789 },
    { 19561, 28053 },
    { 19562, 21059 },
    { 19563, 23625 },
    { 19564, 22825 },
    { 19565, 28155 },
    { 19566, 22635 },
    { 19567, 30000 },
    { 19568, 29980 },
    { 19569, 24684 },
    { 19570, 33300 },
    { 19571, 33094 },
    { 19572, 25361 },
    { 19573, 26465 },
    { 19574, 36834 },
    { 19575, 30522 },
    { 19576, 36339 },
    { 19577, 36148 },
    { 19578, 38081 },
    { 19579, 24086 },
    { 19580, 21381 },
    { 19581, 21548 },
    { 19582, 28867 },
    { 19745, 27712 },
    { 19746, 24311 },
    { 19747, 20572 },
    { 19748, 20141 },
    { 19749, 24237 },
    { 19750, 25402 },
    { 19751, 33351 },
    { 19752, 36890 },
    { 19753, 26704 },
    { 19754, 37230 },
    { 19755, 30643 },
    { 19756, 21516 },
    { 19757, 38108 },
    { 19758, 24420 },
    { 19759, 31461 },
    { 19760, 26742 },
    { 19761, 25413 },
    { 19762, 31570 },
    { 19763, 32479 },
    { 19764, 30171 },
    { 19765, 20599 },
    { 19766, 25237 },
    { 19767, 22836 },
    { 19768, 36879 },
    { 19769, 20984 },
    { 19770, 31171 },
    { 19771, 31361 },
    { 19772, 22270 },
    { 19773, 24466 },
    { 19774, 36884 },
    { 19775, 28034 },
    { 19776, 23648 },
    { 19777, 22303 },
    { 19778, 21520 },
    { 19779, 20820 },
    { 19780, 28237 },
    { 19781, 22242 },
    { 19782, 25512 },
    { 19783, 39059 },
    { 19784, 33151 },
    { 19785, 34581 },
    { 19786, 35114 },
    { 19787, 36864 },
    { 19788, 21534 },
    { 19789, 23663 },
    { 19790, 33216 },
    { 19791, 25302 },
    { 19792, 25176 },
    { 19793, 33073 },
    { 19794, 40501 },
    { 19795, 38464 },
    { 19796, 39534 },
    { 19797, 39548 },
    { 19798, 26925 },
    { 19799, 22949 },
    { 19800, 25299 },
    { 19801, 21822 },
    { 19802, 25366 },
    { 19803, 21703 },
    { 19804, 34521 },
    { 19805, 27964 },
    { 19806, 23043 },
    { 19807, 29926 },
    { 19808, 34972 },
    { 19809, 27498 },
    { 19810, 22806 },
    { 19811, 35916 },
    { 19812, 24367 },
    { 19813, 28286 },
    { 19814, 29609 },
    { 19815, 39037 },
    { 19816, 20024 },
    { 19817, 28919 },
    { 19818, 23436 },
    { 19819, 30871 },
    { 19820, 25405 },
    { 19821, 26202 },
    { 19822, 30358 },
    { 19823, 24779 },
    { 19824, 23451 },
    { 19825, 23113 },
    { 19826, 19975 },
    { 19827, 33109 },
    { 19828, 27754 },
    { 19829, 29579 },
    { 19830, 20129 },
    { 19831, 26505 },
    { 19832, 32593 },
    { 19833, 24448 },
    { 19834, 26106 },
    { 19835, 26395 },
    { 19836, 24536 },
    { 19837, 22916 },
    { 19838, 23041 },
    { 20001, 24013 },
    { 20002, 24494 },
    { 20003, 21361 },
    { 20004, 38886 },
    { 20005, 36829 },
    { 20006, 26693 },
    { 20007, 22260 },
    { 20008, 21807 },
    { 20009, 24799 },
    { 20010, 20026 },
    { 20011, 28493 },
    { 20012, 32500 },
    { 20013, 33479 },
    { 20014, 33806 },
    { 20015, 22996 },
    { 20016, 20255 },
    { 20017, 20266 },
    { 20018, 23614 },
    { 20019, 32428 },
    { 20020, 26410 },
    { 20021, 34074 },
    { 20022, 21619 },
    { 20023, 30031 },
    { 20024, 32963 },
    { 20025, 21890 },
    { 20026, 39759 },
    { 20027, 20301 },
    { 20028, 28205 },
    { 20029, 35859 },
    { 20030, 23561 },
    { 20031, 24944 },
    { 20032, 21355 },
    { 20033, 30239 },
    { 20034, 28201 },
    { 20035, 34442 },
    { 20036, 25991 },
    { 20037, 38395 },
    { 20038, 32441 },
    { 20039, 21563 },
    { 20040, 31283 },
    { 20041, 32010 },
    { 20042, 38382 },
    { 20043, 21985 },
    { 20044, 32705 },
    { 20045, 29934 },
    { 20046, 25373 },
    { 20047, 34583 },
    { 20048, 28065 },
    { 20049, 31389 },
    { 20050, 25105 },
    { 20051, 26017 },
    { 20052, 21351 },
    { 20053, 25569 },
    { 20054, 27779 },
    { 20055, 24043 },
    { 20056, 21596 },
    { 20057, 38056 },
    { 20058, 20044 },
    { 20059, 27745 },
    { 20060, 35820 },
    { 20061, 23627 },
    { 20062, 26080 },
    { 20063, 33436 },
    { 20064, 26791 },
    { 20065, 21566 },
    { 20066, 21556 },
    { 20067, 27595 },
    { 20068, 27494 },
    { 20069, 20116 },
    { 20070, 25410 },
    { 20071, 21320 },
    { 20072, 33310 },
    { 20073, 20237 },
    { 20074, 20398 },
    { 20075, 22366 },
    { 20076, 25098 },
    { 20077, 38654 },
    { 20078, 26212 },
    { 20079, 29289 },
    { 20080, 21247 },
    { 20081, 21153 },
    { 20082, 24735 },
    { 20083, 35823 },
    { 20084, 26132 },
    { 20085, 29081 },
    { 20086, 26512 },
    { 20087, 35199 },
    { 20088, 30802 },
    { 20089, 30717 },
    { 20090, 26224 },
    { 20091, 22075 },
    { 20092, 21560 },
    { 20093, 38177 },
    { 20094, 29306 },
    { 20257, 31232 },
    { 20258, 24687 },
    { 20259, 24076 },
    { 20260, 24713 },
    { 20261, 33181 },
    { 20262, 22805 },
    { 20263, 24796 },
    { 20264, 29060 },
    { 20265, 28911 },
    { 20266, 28330 },
    { 20267, 27728 },
    { 20268, 29312 },
    { 20269, 27268 },
    { 20270, 34989 },
    { 20271, 24109 },
    { 20272, 20064 },
    { 20273, 23219 },
    { 20274, 21916 },
    { 20275, 38115 },
    { 20276, 27927 },
    { 20277, 31995 },
    { 20278, 38553 },
    { 20279, 25103 },
    { 20280, 32454 },
    { 20281, 30606 },
    { 20282, 34430 },
    { 20283, 21283 },
    { 20284, 38686 },
    { 20285, 36758 },
    { 20286, 26247 },
    { 20287, 23777 },
    { 20288, 20384 },
    { 20289, 29421 },
    { 20290, 19979 },
    { 20291, 21414 },
    { 20292, 22799 },
    { 20293, 21523 },
    { 20294, 25472 },
    { 20295, 38184 },
    { 20296, 20808 },
    { 20297, 20185 },
    { 20298, 40092 },
    { 20299, 32420 },
    { 20300, 21688 },
    { 20301, 36132 },
    { 20302, 34900 },
    { 20303, 33335 },
    { 20304, 38386 },
    { 20305, 28046 },
    { 20306, 24358 },
    { 20307, 23244 },
    { 20308, 26174 },
    { 20309, 38505 },
    { 20310, 29616 },
    { 20311, 29486 },
    { 20312, 21439 },
    { 20313, 33146 },
    { 20314, 39301 },
    { 20315, 32673 },
    { 20316, 23466 },
    { 20317, 38519 },
    { 20318, 38480 },
    { 20319, 32447 },
    { 20320, 30456 },
    { 20321, 21410 },
    { 20322, 38262 },
    { 20323, 39321 },
    { 20324, 31665 },
    { 20325, 35140 },
    { 20326, 28248 },
    { 20327, 20065 },
    { 20328, 32724 },
    { 20329, 31077 },
    { 20330, 35814 },
    { 20331, 24819 },
    { 20332, 21709 },
    { 20333, 20139 },
    { 20334, 39033 },
    { 20335, 24055 },
    { 20336, 27233 },
    { 20337, 20687 },
    { 20338, 21521 },
    { 20339, 35937 },
    { 20340, 33831 },
    { 20341, 30813 },
    { 20342, 38660 },
    { 20343, 21066 },
    { 20344, 21742 },
    { 20345, 22179 },
    { 20346, 38144 },
    { 20347, 28040 },
    { 20348, 23477 },
    { 20349, 28102 },
    { 20350, 26195 },
    { 20513, 23567 },
    { 20514, 23389 },
    { 20515, 26657 },
    { 20516, 32918 },
    { 20517, 21880 },
    { 20518, 31505 },
    { 20519, 25928 },
    { 20520, 26964 },
    { 20521, 20123 },
    { 20522, 27463 },
    { 20523, 34638 },
    { 20524, 38795 },
    { 20525, 21327 },
    { 20526, 25375 },
    { 20527, 25658 },
    { 20528, 37034 },
    { 20529, 26012 },
    { 20530, 32961 },
    { 20531, 35856 },
    { 20532, 20889 },
    { 20533, 26800 },
    { 20534, 21368 },
    { 20535, 34809 },
    { 20536, 25032 },
    { 20537, 27844 },
    { 20538, 27899 },
    { 20539, 35874 },
    { 20540, 23633 },
    { 20541, 34218 },
    { 20542, 33455 },
    { 20543, 38156 },
    { 20544, 27427 },
    { 20545, 36763 },
    { 20546, 26032 },
    { 20547, 24571 },
    { 20548, 24515 },
    { 20549, 20449 },
    { 20550, 34885 },
    { 20551, 26143 },
    { 20552, 33125 },
    { 20553, 29481 },
    { 20554, 24826 },
    { 20555, 20852 },
    { 20556, 21009 },
    { 20557, 22411 },
    { 20558, 24418 },
    { 20559, 37026 },
    { 20560, 34892 },
    { 20561, 37266 },
    { 20562, 24184 },
    { 20563, 26447 },
    { 20564, 24615 },
    { 20565, 22995 },
    { 20566, 20804 },
    { 20567, 20982 },
    { 20568, 33016 },
    { 20569, 21256 },
    { 20570, 27769 },
    { 20571, 38596 },
    { 20572, 29066 },
    { 20573, 20241 },
    { 20574, 20462 },
    { 20575, 32670 },
    { 20576, 26429 },
    { 20577, 21957 },
    { 20578, 38152 },
    { 20579, 31168 },
    { 20580, 34966 },
    { 20581, 32483 },
    { 20582, 22687 },
    { 20583, 25100 },
    { 20584, 38656 },
    { 20585, 34394 },
    { 20586, 22040 },
    { 20587, 39035 },
    { 20588, 24464 },
    { 20589, 35768 },
    { 20590, 33988 },
    { 20591, 37207 },
    { 20592, 21465 },
    { 20593, 26093 },
    { 20594, 24207 },
    { 20595, 30044 },
    { 20596, 24676 },
    { 20597, 32110 },
    { 20598, 23167 },
    { 20599, 32490 },
    { 20600, 32493 },
    { 20601, 36713 },
    { 20602, 21927 },
    { 20603, 23459 },
    { 20604, 24748 },
    { 20605, 26059 },
    { 20606, 29572 },
    { 20769, 36873 },
    { 20770, 30307 },
    { 20771, 30505 },
    { 20772, 32474 },
    { 20773, 38772 },
    { 20774, 34203 },
    { 20775, 23398 },
    { 20776, 31348 },
    { 20777, 38634 },
    { 20778, 34880 },
    { 20779, 21195 },
    { 20780, 29071 },
    { 20781, 24490 },
    { 20782, 26092 },
    { 20783, 35810 },
    { 20784, 23547 },
    { 20785, 39535 },
    { 20786, 24033 },
    { 20787, 27529 },
    { 20788, 27739 },
    { 20789, 35757 },
    { 20790, 35759 },
    { 20791, 36874 },
    { 20792, 36805 },
    { 20793, 21387 },
    { 20794, 25276 },
    { 20795, 40486 },
    { 20796, 40493 },
    { 20797, 21568 },
    { 20798, 20011 },
    { 20799, 33469 },
    { 20800, 29273 },
    { 20801, 34460 },
    { 20802, 23830 },
    { 20803, 34905 },
    { 20804, 28079 },
    { 20805, 38597 },
    { 20806, 21713 },
    { 20807, 20122 },
    { 20808, 35766 },
    { 20809, 28937 },
    { 20810, 21693 },
    { 20811, 38409 },
    { 20812, 28895 },
    { 20813, 28153 },
    { 20814, 30416 },
    { 20815, 20005 },
    { 20816, 30740 },
    { 20817, 34578 },
    { 20818, 23721 },
    { 20819, 24310 },
    { 20820, 35328 },
    { 20821, 39068 },
    { 20822, 38414 },
    { 20823, 28814 },
    { 20824, 27839 },
    { 20825, 22852 },
    { 20826, 25513 },
    { 20827, 30524 },
    { 20828, 34893 },
    { 20829, 28436 },
    { 20830, 33395 },
    { 20831, 22576 },
    { 20832, 29141 },
    { 20833, 21388 },
    { 20834, 30746 },
    { 20835, 38593 },
    { 20836, 21761 },
    { 20837, 24422 },
    { 20838, 28976 },
    { 20839, 23476 },
    { 20840, 35866 },
    { 20841, 39564 },
    { 20842, 27523 },
    { 20843, 22830 },
    { 20844, 40495 },
    { 20845, 31207 },
    { 20846, 26472 },
    { 20847, 25196 },
    { 20848, 20335 },
    { 20849, 30113 },
    { 20850, 32650 },
    { 20851, 27915 },
    { 20852, 38451 },
    { 20853, 27687 },
    { 20854, 20208 },
    { 20855, 30162 },
    { 20856, 20859 },
    { 20857, 26679 },
    { 20858, 28478 },
    { 20859, 36992 },
    { 20860, 33136 },
    { 20861, 22934 },
    { 20862, 29814 },
    { 21025, 25671 },
    { 21026, 23591 },
    { 21027, 36965 },
    { 21028, 31377 },
    { 21029, 35875 },
    { 21030, 23002 },
    { 21031, 21676 },
    { 21032, 33280 },
    { 21033, 33647 },
    { 21034, 35201 },
    { 21035, 32768 },
    { 21036, 26928 },
    { 21037, 22094 },
    { 21038, 32822 },
    { 21039, 29239 },
    { 21040, 37326 },
    { 21041, 20918 },
    { 21042, 20063 },
    { 21043, 39029 },
    { 21044, 25494 },
    { 21045, 19994 },
    { 21046, 21494 },
    { 21047, 26355 },
    { 21048, 33099 },
    { 21049, 22812 },
    { 21050, 28082 },
    { 21051, 19968 },
    { 21052, 22777 },
    { 21053, 21307 },
    { 21054, 25558 },
    { 21055, 38129 },
    { 21056, 20381 },
    { 21057, 20234 },
    { 21058, 34915 },
    { 21059, 39056 },
    { 21060, 22839 },
    { 21061, 36951 },
    { 21062, 31227 },
    { 21063, 20202 },
    { 21064, 33008 },
    { 21065, 30097 },
    { 21066, 27778 },
    { 21067, 23452 },
    { 21068, 23016 },
    { 21069, 24413 },
    { 21070, 26885 },
    { 21071, 34433 },
    { 21072, 20506 },
    { 21073, 24050 },
    { 21074, 20057 },
    { 21075, 30691 },
    { 21076, 20197 },
    { 21077, 33402 },
    { 21078, 25233 },
    { 21079, 26131 },
    { 21080, 37009 },
    { 21081, 23673 },
    { 21082, 20159 },
    { 21083, 24441 },
    { 21084, 33222 },
    { 21085, 36920 },
    { 21086, 32900 },
    { 21087, 30123 },
    { 21088, 20134 },
    { 21089, 35028 },
    { 21090, 24847 },
    { 21091, 27589 },
    { 21092, 24518 },
    { 21093, 20041 },
    { 21094, 30410 },
    { 21095, 28322 },
    { 21096, 35811 },
    { 21097, 35758 },
    { 21098, 35850 },
    { 21099, 35793 },
    { 21100, 24322 },
    { 21101, 32764 },
    { 21102, 32716 },
    { 21103, 32462 },
    { 21104, 33589 },
    { 21105, 33643 },
    { 21106, 22240 },
    { 21107, 27575 },
    { 21108, 38899 },
    { 21109, 38452 },
    { 21110, 23035 },
    { 21111, 21535 },
    { 21112, 38134 },
    { 21113, 28139 },
    { 21114, 23493 },
    { 21115, 39278 },
    { 21116, 23609 },
    { 21117, 24341 },
    { 21118, 38544 },
    { 21281, 21360 },
    { 21282, 33521 },
    { 21283, 27185 },
    { 21284, 23156 },
    { 21285, 40560 },
    { 21286, 24212 },
    { 21287, 32552 },
    { 21288, 33721 },
    { 21289, 33828 },
    { 21290, 33829 },
    { 21291, 33639 },
    { 21292, 34631 },
    { 21293, 36814 },
    { 21294, 36194 },
    { 21295, 30408 },
    { 21296, 24433 },
    { 21297, 39062 },
    { 21298, 30828 },
    { 21299, 26144 },
    { 21300, 21727 },
    { 21301, 25317 },
    { 21302, 20323 },
    { 21303, 33219 },
    { 21304, 30152 },
    { 21305, 24248 },
    { 21306, 38605 },
    { 21307, 36362 },
    { 21308, 34553 },
    { 21309, 21647 },
    { 21310, 27891 },
    { 21311, 28044 },
    { 21312, 27704 },
    { 21313, 24703 },
    { 21314, 21191 },
    { 21315, 29992 },
    { 21316, 24189 },
    { 21317, 20248 },
    { 21318, 24736 },
    { 21319, 24551 },
    { 21320, 23588 },
    { 21321, 30001 },
    { 21322, 37038 },
    { 21323, 38080 },
    { 21324, 29369 },
    { 21325, 27833 },
    { 21326, 28216 },
    { 21327, 37193 },
    { 21328, 26377 },
    { 21329, 21451 },
    { 21330, 21491 },
    { 21331, 20305 },
    { 21332, 37321 },
    { 21333, 35825 },
    { 21334, 21448 },
    { 21335, 24188 },
    { 21336, 36802 },
    { 21337, 28132 },
    { 21338, 20110 },
    { 21339, 30402 },
    { 21340, 27014 },
    { 21341, 34398 },
    { 21342, 24858 },
    { 21343, 33286 },
    { 21344, 20313 },
    { 21345, 20446 },
    { 21346, 36926 },
    { 21347, 40060 },
    { 21348, 24841 },
    { 21349, 28189 },
    { 21350, 28180 },
    { 21351, 38533 },
    { 21352, 20104 },
    { 21353, 23089 },
    { 21354, 38632 },
    { 21355, 19982 },
    { 21356, 23679 },
    { 21357, 31161 },
    { 21358, 23431 },
    { 21359, 35821 },
    { 21360, 32701 },
    { 21361, 29577 },
    { 21362, 22495 },
    { 21363, 33419 },
    { 21364, 37057 },
    { 21365, 21505 },
    { 21366, 36935 },
    { 21367, 21947 },
    { 21368, 23786 },
    { 21369, 24481 },
    { 21370, 24840 },
    { 21371, 27442 },
    { 21372, 29425 },
    { 21373, 32946 },
    { 21374, 35465 },
    { 21537, 28020 },
    { 21538, 23507 },
    { 21539, 35029 },
    { 21540, 39044 },
    { 21541, 35947 },
    { 21542, 39533 },
    { 21543, 40499 },
    { 21544, 28170 },
    { 21545, 20900 },
    { 21546, 20803 },
    { 21547, 22435 },
    { 21548, 34945 },
    { 21549, 21407 },
    { 21550, 25588 },
    { 21551, 36757 },
    { 21552, 22253 },
    { 21553, 21592 },
    { 21554, 22278 },
    { 21555, 29503 },
    { 21556, 28304 },
    { 21557, 32536 },
    { 21558, 36828 },
    { 21559, 33489 },
    { 21560, 24895 },
    { 21561, 24616 },
    { 21562, 38498 },
    { 21563, 26352 },
    { 21564, 32422 },
    { 21565, 36234 },
    { 21566, 36291 },
    { 21567, 38053 },
    { 21568, 23731 },
    { 21569, 31908 },
    { 21570, 26376 },
    { 21571, 24742 },
    { 21572, 38405 },
    { 21573, 32792 },
    { 21574, 20113 },
    { 21575, 37095 },
    { 21576, 21248 },
    { 21577, 38504 },
    { 21578, 20801 },
    { 21579, 36816 },
    { 21580, 34164 },
    { 21581, 37213 },
    { 21582, 26197 },
    { 21583, 38901 },
    { 21584, 23381 },
    { 21585, 21277 },
    { 21586, 30776 },
    { 21587, 26434 },
    { 21588, 26685 },
    { 21589, 21705 },
    { 21590, 28798 },
    { 21591, 23472 },
    { 21592, 36733 },
    { 21593, 20877 },
    { 21594, 22312 },
    { 21595, 21681 },
    { 21596, 25874 },
    { 21597, 26242 },
    { 21598, 36190 },
    { 21599, 36163 },
    { 21600, 33039 },
    { 21601, 33900 },
    { 21602, 36973 },
    { 21603, 31967 },
    { 21604, 20991 },
    { 21605, 34299 },
    { 21606, 26531 },
    { 21607, 26089 },
    { 21608, 28577 },
    { 21609, 34468 },
    { 21610, 36481 },
    { 21611, 22122 },
    { 21612, 36896 },
    { 21613, 30338 },
    { 21614, 28790 },
    { 21615, 29157 },
    { 21616, 36131 },
    { 21617, 25321 },
    { 21618, 21017 },
    { 21619, 27901 },
    { 21620, 36156 },
    { 21621, 24590 },
    { 21622, 22686 },
    { 21623, 24974 },
    { 21624, 26366 },
    { 21625, 36192 },
    { 21626, 25166 },
    { 21627, 21939 },
    { 21628, 28195 },
    { 21629, 26413 },
    { 21630, 36711 },
    { 21793, 38113 },
    { 21794, 38392 },
    { 21795, 30504 },
    { 21796, 26629 },
    { 21797, 27048 },
    { 21798, 21643 },
    { 21799, 20045 },
    { 21800, 28856 },
    { 21801, 35784 },
    { 21802, 25688 },
    { 21803, 25995 },
    { 21804, 23429 },
    { 21805, 31364 },
    { 21806, 20538 },
    { 21807, 23528 },
    { 21808, 30651 },
    { 21809, 27617 },
    { 21810, 35449 },
    { 21811, 31896 },
    { 21812, 27838 },
    { 21813, 30415 },
    { 21814, 26025 },
    { 21815, 36759 },
    { 21816, 23853 },
    { 21817, 23637 },
    { 21818, 34360 },
    { 21819, 26632 },
    { 21820, 21344 },
    { 21821, 25112 },
    { 21822, 31449 },
    { 21823, 28251 },
    { 21824, 32509 },
    { 21825, 27167 },
    { 21826, 31456 },
    { 21827, 24432 },
    { 21828, 28467 },
    { 21829, 24352 },
    { 21830, 25484 },
    { 21831, 28072 },
    { 21832, 26454 },
    { 21833, 19976 },
    { 21834, 24080 },
    { 21835, 36134 },
    { 21836, 20183 },
    { 21837, 32960 },
    { 21838, 30260 },
    { 21839, 38556 },
    { 21840, 25307 },
    { 21841, 26157 },
    { 21842, 25214 },
    { 21843, 27836 },
    { 21844, 36213 },
    { 21845, 29031 },
    { 21846, 32617 },
    { 21847, 20806 },
    { 21848, 32903 },
    { 21849, 21484 },
    { 21850, 36974 },
    { 21851, 25240 },
    { 21852, 21746 },
    { 21853, 34544 },
    { 21854, 36761 },
    { 21855, 32773 },
    { 21856, 38167 },
    { 21857, 34071 },
    { 21858, 36825 },
    { 21859, 27993 },
    { 21860, 29645 },
    { 21861, 26015 },
    { 21862, 30495 },
    { 21863, 29956 },
    { 21864, 30759 },
    { 21865, 33275 },
    { 21866, 36126 },
    { 21867, 38024 },
    { 21868, 20390 },
    { 21869, 26517 },
    { 21870, 30137 },
    { 21871, 35786 },
    { 21872, 38663 },
    { 21873, 25391 },
    { 21874, 38215 },
    { 21875, 38453 },
    { 21876, 33976 },
    { 21877, 25379 },
    { 21878, 30529 },
    { 21879, 24449 },
    { 21880, 29424 },
    { 21881, 20105 },
    { 21882, 24596 },
    { 21883, 25972 },
    { 21884, 25327 },
    { 21885, 27491 },
    { 21886, 25919 },
    { 22049, 24103 },
    { 22050, 30151 },
    { 22051, 37073 },
    { 22052, 35777 },
    { 22053, 33437 },
    { 22054, 26525 },
    { 22055, 25903 },
    { 22056, 21553 },
    { 22057, 34584 },
    { 22058, 30693 },
    { 22059, 32930 },
    { 22060, 33026 },
    { 22061, 27713 },
    { 22062, 20043 },
    { 22063, 32455 },
    { 22064, 32844 },
    { 22065, 30452 },
    { 22066, 26893 },
    { 22067, 27542 },
    { 22068, 25191 },
    { 22069, 20540 },
    { 22070, 20356 },
    { 22071, 22336 },
    { 22072, 25351 },
    { 22073, 27490 },
    { 22074, 36286 },
    { 22075, 21482 },
    { 22076, 26088 },
    { 22077, 32440 },
    { 22078, 24535 },
    { 22079, 25370 },
    { 22080, 25527 },
    { 22081, 33267 },
    { 22082, 33268 },
    { 22083, 32622 },
    { 22084, 24092 },
    { 22085, 23769 },
    { 22086, 21046 },
    { 22087, 26234 },
    { 22088, 31209 },
    { 22089, 31258 },
    { 22090, 36136 },
    { 22091, 28825 },
    { 22092, 30164 },
    { 22093, 28382 },
    { 22094, 27835 },
    { 22095, 31378 },
    { 22096, 20013 },
    { 22097, 30405 },
    { 22098, 24544 },
    { 22099, 38047 },
    { 22100, 34935 },
    { 22101, 32456 },
    { 22102, 31181 },
    { 22103, 32959 },
    { 22104, 37325 },
    { 22105, 20210 },
    { 22106, 20247 },
    { 22107, 33311 },
    { 22108, 21608 },
    { 22109, 24030 },
    { 22110, 27954 },
    { 22111, 35788 },
    { 22112, 31909 },
    { 22113, 36724 },
    { 22114, 32920 },
    { 22115, 24090 },
    { 22116, 21650 },
    { 22117, 30385 },
    { 22118, 23449 },
    { 22119, 26172 },
    { 22120, 39588 },
    { 22121, 29664 },
    { 22122, 26666 },
    { 22123, 34523 },
    { 22124, 26417 },
    { 22125, 29482 },
    { 22126, 35832 },
    { 22127, 35803 },
    { 22128, 36880 },
    { 22129, 31481 },
    { 22130, 28891 },
    { 22131, 29038 },
    { 22132, 25284 },
    { 22133, 30633 },
    { 22134, 22065 },
    { 22135, 20027 },
    { 22136, 33879 },
    { 22137, 26609 },
    { 22138, 21161 },
    { 22139, 34496 },
    { 22140, 36142 },
    { 22141, 38136 },
    { 22142, 31569 },
    { 22305, 20303 },
    { 22306, 27880 },
    { 22307, 31069 },
    { 22308, 39547 },
    { 22309, 25235 },
    { 22310, 29226 },
    { 22311, 25341 },
    { 22312, 19987 },
    { 22313, 30742 },
    { 22314, 36716 },
    { 22315, 25776 },
    { 22316, 36186 },
    { 22317, 31686 },
    { 22318, 26729 },
    { 22319, 24196 },
    { 22320, 35013 },
    { 22321, 22918 },
    { 22322, 25758 },
    { 22323, 22766 },
    { 22324, 29366 },
    { 22325, 26894 },
    { 22326, 38181 },
    { 22327, 36861 },
    { 22328, 36184 },
    { 22329, 22368 },
    { 22330, 32512 },
    { 22331, 35846 },
    { 22332, 20934 },
    { 22333, 25417 },
    { 22334, 25305 },
    { 22335, 21331 },
    { 22336, 26700 },
    { 22337, 29730 },
    { 22338, 33537 },
    { 22339, 37196 },
    { 22340, 21828 },
    { 22341, 30528 },
    { 22342, 28796 },
    { 22343, 27978 },
    { 22344, 20857 },
    { 22345, 21672 },
    { 22346, 36164 },
    { 22347, 23039 },
    { 22348, 28363 },
    { 22349, 28100 },
    { 22350, 23388 },
    { 22351, 32043 },
    { 22352, 20180 },
    { 22353, 31869 },
    { 22354, 28371 },
    { 22355, 23376 },
    { 22356, 33258 },
    { 22357, 28173 },
    { 22358, 23383 },
    { 22359, 39683 },
    { 22360, 26837 },
    { 22361, 36394 },
    { 22362, 23447 },
    { 22363, 32508 },
    { 22364, 24635 },
    { 22365, 32437 },
    { 22366, 37049 },
    { 22367, 36208 },
    { 22368, 22863 },
    { 22369, 25549 },
    { 22370, 31199 },
    { 22371, 36275 },
    { 22372, 21330 },
    { 22373, 26063 },
    { 22374, 31062 },
    { 22375, 35781 },
    { 22376, 38459 },
    { 22377, 32452 },
    { 22378, 38075 },
    { 22379, 32386 },
    { 22380, 22068 },
    { 22381, 37257 },
    { 22382, 26368 },
    { 22383, 32618 },
    { 22384, 23562 },
    { 22385, 36981 },
    { 22386, 26152 },
    { 22387, 24038 },
    { 22388, 20304 },
    { 22389, 26590 },
    { 22390, 20570 },
    { 22391, 20316 },
    { 22392, 22352 },
    { 22393, 24231 },
    { 22561, 20109 },
    { 22562, 19980 },
    { 22563, 20800 },
    { 22564, 19984 },
    { 22565, 24319 },
    { 22566, 21317 },
    { 22567, 19989 },
    { 22568, 20120 },
    { 22569, 19998 },
    { 22570, 39730 },
    { 22571, 23404 },
    { 22572, 22121 },
    { 22573, 20008 },
    { 22574, 31162 },
    { 22575, 20031 },
    { 22576, 21269 },
    { 22577, 20039 },
    { 22578, 22829 },
    { 22579, 29243 },
    { 22580, 21358 },
    { 22581, 27664 },
    { 22582, 22239 },
    { 22583, 32996 },
    { 22584, 39319 },
    { 22585, 27603 },
    { 22586, 30590 },
    { 22587, 40727 },
    { 22588, 20022 },
    { 22589, 20127 },
    { 22590, 40720 },
    { 22591, 20060 },
    { 22592, 20073 },
    { 22593, 20115 },
    { 22594, 33416 },
    { 22595, 23387 },
    { 22596, 21868 },
    { 22597, 22031 },
    { 22598, 20164 },
    { 22599, 21389 },
    { 22600, 21405 },
    { 22601, 21411 },
    { 22602, 21413 },
    { 22603, 21422 },
    { 22604, 38757 },
    { 22605, 36189 },
    { 22606, 21274 },
    { 22607, 21493 },
    { 22608, 21286 },
    { 22609, 21294 },
    { 22610, 21310 },
    { 22611, 36188 },
    { 22612, 21350 },
    { 22613, 21347 },
    { 22614, 20994 },
    { 22615, 21000 },
    { 22616, 21006 },
    { 22617, 21037 },
    { 22618, 21043 },
    { 22619, 21055 },
    { 22620, 21056 },
    { 22621, 21068 },
    { 22622, 21086 },
    { 22623, 21089 },
    { 22624, 21084 },
    { 22625, 33967 },
    { 22626, 21117 },
    { 22627, 21122 },
    { 22628, 21121 },
    { 22629, 21136 },
    { 22630, 21139 },
    { 22631, 20866 },
    { 22632, 32596 },
    { 22633, 20155 },
    { 22634, 20163 },
    { 22635, 20169 },
    { 22636, 20162 },
    { 22637, 20200 },
    { 22638, 20193 },
    { 22639, 20203 },
    { 22640, 20190 },
    { 22641, 20251 },
    { 22642, 20211 },
    { 22643, 20258 },
    { 22644, 20324 },
    { 22645, 20213 },
    { 22646, 20261 },
    { 22647, 20263 },
    { 22648, 20233 },
    { 22649, 20267 },
    { 22650, 20318 },
    { 22651, 20327 },
    { 22652, 25912 },
    { 22653, 20314 },
    { 22654, 20317 },
    { 22817, 20319 },
    { 22818, 20311 },
    { 22819, 20274 },
    { 22820, 20285 },
    { 22821, 20342 },
    { 22822, 20340 },
    { 22823, 20369 },
    { 22824, 20361 },
    { 22825, 20355 },
    { 22826, 20367 },
    { 22827, 20350 },
    { 22828, 20347 },
    { 22829, 20394 },
    { 22830, 20348 },
    { 22831, 20396 },
    { 22832, 20372 },
    { 22833, 20454 },
    { 22834, 20456 },
    { 22835, 20458 },
    { 22836, 20421 },
    { 22837, 20442 },
    { 22838, 20451 },
    { 22839, 20444 },
    { 22840, 20433 },
    { 22841, 20447 },
    { 22842, 20472 },
    { 22843, 20521 },
    { 22844, 20556 },
    { 22845, 20467 },
    { 22846, 20524 },
    { 22847, 20495 },
    { 22848, 20526 },
    { 22849, 20525 },
    { 22850, 20478 },
    { 22851, 20508 },
    { 22852, 20492 },
    { 22853, 20517 },
    { 22854, 20520 },
    { 22855, 20606 },
    { 22856, 20547 },
    { 22857, 20565 },
    { 22858, 20552 },
    { 22859, 20558 },
    { 22860, 20588 },
    { 22861, 20603 },
    { 22862, 20645 },
    { 22863, 20647 },
    { 22864, 20649 },
    { 22865, 20666 },
    { 22866, 20694 },
    { 22867, 20742 },
    { 22868, 20717 },
    { 22869, 20716 },
    { 22870, 20710 },
    { 22871, 20718 },
    { 22872, 20743 },
    { 22873, 20747 },
    { 22874, 20189 },
    { 22875, 27709 },
    { 22876, 20312 },
    { 22877, 20325 },
    { 22878, 20430 },
    { 22879, 40864 },
    { 22880, 27718 },
    { 22881, 31860 },
    { 22882, 20846 },
    { 22883, 24061 },
    { 22884, 40649 },
    { 22885, 39320 },
    { 22886, 20865 },
    { 22887, 22804 },
    { 22888, 21241 },
    { 22889, 21261 },
    { 22890, 35335 },
    { 22891, 21264 },
    { 22892, 20971 },
    { 22893, 22809 },
    { 22894, 20821 },
    { 22895, 20128 },
    { 22896, 20822 },
    { 22897, 20147 },
    { 22898, 34926 },
    { 22899, 34980 },
    { 22900, 20149 },
    { 22901, 33044 },
    { 22902, 35026 },
    { 22903, 31104 },
    { 22904, 23348 },
    { 22905, 34819 },
    { 22906, 32696 },
    { 22907, 20907 },
    { 22908, 20913 },
    { 22909, 20925 },
    { 22910, 20924 },
    { 23073, 20935 },
    { 23074, 20886 },
    { 23075, 20898 },
    { 23076, 20901 },
    { 23077, 35744 },
    { 23078, 35750 },
    { 23079, 35751 },
    { 23080, 35754 },
    { 23081, 35764 },
    { 23082, 35765 },
    { 23083, 35767 },
    { 23084, 35778 },
    { 23085, 35779 },
    { 23086, 35787 },
    { 23087, 35791 },
    { 23088, 35790 },
    { 23089, 35794 },
    { 23090, 35795 },
    { 23091, 35796 },
    { 23092, 35798 },
    { 23093, 35800 },
    { 23094, 35801 },
    { 23095, 35804 },
    { 23096, 35807 },
    { 23097, 35808 },
    { 23098, 35812 },
    { 23099, 35816 },
    { 23100, 35817 },
    { 23101, 35822 },
    { 23102, 35824 },
    { 23103, 35827 },
    { 23104, 35830 },
    { 23105, 35833 },
    { 23106, 35836 },
    { 23107, 35839 },
    { 23108, 35840 },
    { 23109, 35842 },
    { 23110, 35844 },
    { 23111, 35847 },
    { 23112, 35852 },
    { 23113, 35855 },
    { 23114, 35857 },
    { 23115, 35858 },
    { 23116, 35860 },
    { 23117, 35861 },
    { 23118, 35862 },
    { 23119, 35865 },
    { 23120, 35867 },
    { 23121, 35864 },
    { 23122, 35869 },
    { 23123, 35871 },
    { 23124, 35872 },
    { 23125, 35873 },
    { 23126, 35877 },
    { 23127, 35879 },
    { 23128, 35882 },
    { 23129, 35883 },
    { 23130, 35886 },
    { 23131, 35887 },
    { 23132, 35890 },
    { 23133, 35891 },
    { 23134, 35893 },
    { 23135, 35894 },
    { 23136, 21353 },
    { 23137, 21370 },
    { 23138, 38429 },
    { 23139, 38434 },
    { 23140, 38433 },
    { 23141, 38449 },
    { 23142, 38442 },
    { 23143, 38461 },
    { 23144, 38460 },
    { 23145, 38466 },
    { 23146, 38473 },
    { 23147, 38484 },
    { 23148, 38495 },
    { 23149, 38503 },
    { 23150, 38508 },
    { 23151, 38514 },
    { 23152, 38516 },
    { 23153, 38536 },
    { 23154, 38541 },
    { 23155, 38551 },
    { 23156, 38576 },
    { 23157, 37015 },
    { 23158, 37019 },
    { 23159, 37021 },
    { 23160, 37017 },
    { 23161, 37036 },
    { 23162, 37025 },
    { 23163, 37044 },
    { 23164, 37043 },
    { 23165, 37046 },
    { 23166, 37050 },
    { 23329, 37048 },
    { 23330, 37040 },
    { 23331, 37071 },
    { 23332, 37061 },
    { 23333, 37054 },
    { 23334, 37072 },
    { 23335, 37060 },
    { 23336, 37063 },
    { 23337, 37075 },
    { 23338, 37094 },
    { 23339, 37090 },
    { 23340, 37084 },
    { 23341, 37079 },
    { 23342, 37083 },
    { 23343, 37099 },
    { 23344, 37103 },
    { 23345, 37118 },
    { 23346, 37124 },
    { 23347, 37154 },
    { 23348, 37150 },
    { 23349, 37155 },
    { 23350, 37169 },
    { 23351, 37167 },
    { 23352, 37177 },
    { 23353, 37187 },
    { 23354, 37190 },
    { 23355, 21005 },
    { 23356, 22850 },
    { 23357, 21154 },
    { 23358, 21164 },
    { 23359, 21165 },
    { 23360, 21182 },
    { 23361, 21759 },
    { 23362, 21200 },
    { 23363, 21206 },
    { 23364, 21232 },
    { 23365, 21471 },
    { 23366, 29166 },
    { 23367, 30669 },
    { 23368, 24308 },
    { 23369, 20981 },
    { 23370, 20988 },
    { 23371, 39727 },
    { 23372, 21430 },
    { 23373, 24321 },
    { 23374, 30042 },
    { 23375, 24047 },
    { 23376, 22348 },
    { 23377, 22441 },
    { 23378, 22433 },
    { 23379, 22654 },
    { 23380, 22716 },
    { 23381, 22725 },
    { 23382, 22737 },
    { 23383, 22313 },
    { 23384, 22316 },
    { 23385, 22314 },
    { 23386, 22323 },
    { 23387, 22329 },
    { 23388, 22318 },
    { 23389, 22319 },
    { 23390, 22364 },
    { 23391, 22331 },
    { 23392, 22338 },
    { 23393, 22377 },
    { 23394, 22405 },
    { 23395, 22379 },
    { 23396, 22406 },
    { 23397, 22396 },
    { 23398, 22395 },
    { 23399, 22376 },
    { 23400, 22381 },
    { 23401, 22390 },
    { 23402, 22387 },
    { 23403, 22445 },
    { 23404, 22436 },
    { 23405, 22412 },
    { 23406, 22450 },
    { 23407, 22479 },
    { 23408, 22439 },
    { 23409, 22452 },
    { 23410, 22419 },
    { 23411, 22432 },
    { 23412, 22485 },
    { 23413, 22488 },
    { 23414, 22490 },
    { 23415, 22489 },
    { 23416, 22482 },
    { 23417, 22456 },
    { 23418, 22516 },
    { 23419, 22511 },
    { 23420, 22520 },
    { 23421, 22500 },
    { 23422, 22493 },
    { 23585, 22539 },
    { 23586, 22541 },
    { 23587, 22525 },
    { 23588, 22509 },
    { 23589, 22528 },
    { 23590, 22558 },
    { 23591, 22553 },
    { 23592, 22596 },
    { 23593, 22560 },
    { 23594, 22629 },
    { 23595, 22636 },
    { 23596, 22657 },
    { 23597, 22665 },
    { 23598, 22682 },
    { 23599, 22656 },
    { 23600, 39336 },
    { 23601, 40729 },
    { 23602, 25087 },
    { 23603, 33401 },
    { 23604, 33405 },
    { 23605, 33407 },
    { 23606, 33423 },
    { 23607, 33418 },
    { 23608, 33448 },
    { 23609, 33412 },
    { 23610, 33422 },
    { 23611, 33425 },
    { 23612, 33431 },
    { 23613, 33433 },
    { 23614, 33451 },
    { 23615, 33464 },
    { 23616, 33470 },
    { 23617, 33456 },
    { 23618, 33480 },
    { 23619, 33482 },
    { 23620, 33507 },
    { 23621, 33432 },
    { 23622, 33463 },
    { 23623, 33454 },
    { 23624, 33483 },
    { 23625, 33484 },
    { 23626, 33473 },
    { 23627, 33449 },
    { 23628, 33460 },
    { 23629, 33441 },
    { 23630, 33450 },
    { 23631, 33439 },
    { 23632, 33476 },
    { 23633, 33486 },
    { 23634, 33444 },
    { 23635, 33505 },
    { 23636, 33545 },
    { 23637, 33527 },
    { 23638, 33508 },
    { 23639, 33551 },
    { 23640, 33543 },
    { 23641, 33500 },
    { 23642, 33524 },
    { 23643, 33490 },
    { 23644, 33496 },
    { 23645, 33548 },
    { 23646, 33531 },
    { 23647, 33491 },
    { 23648, 33553 },
    { 23649, 33562 },
    { 23650, 33542 },
    { 23651, 33556 },
    { 23652, 33557 },
    { 23653, 33504 },
    { 23654, 33493 },
    { 23655, 33564 },
    { 23656, 33617 },
    { 23657, 33627 },
    { 23658, 33628 },
    { 23659, 33544 },
    { 23660, 33682 },
    { 23661, 33596 },
    { 23662, 33588 },
    { 23663, 33585 },
    { 23664, 33691 },
    { 23665, 33630 },
    { 23666, 33583 },
    { 23667, 33615 },
    { 23668, 33607 },
    { 23669, 33603 },
    { 23670, 33631 },
    { 23671, 33600 },
    { 23672, 33559 },
    { 23673, 33632 },
    { 23674, 33581 },
    { 23675, 33594 },
    { 23676, 33587 },
    { 23677, 33638 },
    { 23678, 33637 },
    { 23841, 33640 },
    { 23842, 33563 },
    { 23843, 33641 },
    { 23844, 33644 },
    { 23845, 33642 },
    { 23846, 33645 },
    { 23847, 33646 },
    { 23848, 33712 },
    { 23849, 33656 },
    { 23850, 33715 },
    { 23851, 33716 },
    { 23852, 33696 },
    { 23853, 33706 },
    { 23854, 33683 },
    { 23855, 33692 },
    { 23856, 33669 },
    { 23857, 33660 },
    { 23858, 33718 },
    { 23859, 33705 },
    { 23860, 33661 },
    { 23861, 33720 },
    { 23862, 33659 },
    { 23863, 33688 },
    { 23864, 33694 },
    { 23865, 33704 },
    { 23866, 33722 },
    { 23867, 33724 },
    { 23868, 33729 },
    { 23869, 33793 },
    { 23870, 33765 },
    { 23871, 33752 },
    { 23872, 22535 },
    { 23873, 33816 },
    { 23874, 33803 },
    { 23875, 33757 },
    { 23876, 33789 },
    { 23877, 33750 },
    { 23878, 33820 },
    { 23879, 33848 },
    { 23880, 33809 },
    { 23881, 33798 },
    { 23882, 33748 },
    { 23883, 33759 },
    { 23884, 33807 },
    { 23885, 33795 },
    { 23886, 33784 },
    { 23887, 33785 },
    { 23888, 33770 },
    { 23889, 33733 },
    { 23890, 33728 },
    { 23891, 33830 },
    { 23892, 33776 },
    { 23893, 33761 },
    { 23894, 33884 },
    { 23895, 33873 },
    { 23896, 33882 },
    { 23897, 33881 },
    { 23898, 33907 },
    { 23899, 33927 },
    { 23900, 33928 },
    { 23901, 33914 },
    { 23902, 33929 },
    { 23903, 33912 },
    { 23904, 33852 },
    { 23905, 33862 },
    { 23906, 33897 },
    { 23907, 33910 },
    { 23908, 33932 },
    { 23909, 33934 },
    { 23910, 33841 },
    { 23911, 33901 },
    { 23912, 33985 },
    { 23913, 33997 },
    { 23914, 34000 },
    { 23915, 34022 },
    { 23916, 33981 },
    { 23917, 34003 },
    { 23918, 33994 },
    { 23919, 33983 },
    { 23920, 33978 },
    { 23921, 34016 },
    { 23922, 33953 },
    { 23923, 33977 },
    { 23924, 33972 },
    { 23925, 33943 },
    { 23926, 34021 },
    { 23927, 34019 },
    { 23928, 34060 },
    { 23929, 29965 },
    { 23930, 34104 },
    { 23931, 34032 },
    { 23932, 34105 },
    { 23933, 34079 },
    { 23934, 34106 },
    { 24097, 34134 },
    { 24098, 34107 },
    { 24099, 34047 },
    { 24100, 34044 },
    { 24101, 34137 },
    { 24102, 34120 },
    { 24103, 34152 },
    { 24104, 34148 },
    { 24105, 34142 },
    { 24106, 34170 },
    { 24107, 30626 },
    { 24108, 34115 },
    { 24109, 34162 },
    { 24110, 34171 },
    { 24111, 34212 },
    { 24112, 34216 },
    { 24113, 34183 },
    { 24114, 34191 },
    { 24115, 34169 },
    { 24116, 34222 },
    { 24117, 34204 },
    { 24118, 34181 },
    { 24119, 34233 },
    { 24120, 34231 },
    { 24121, 34224 },
    { 24122, 34259 },
    { 24123, 34241 },
    { 24124, 34268 },
    { 24125, 34303 },
    { 24126, 34343 },
    { 24127, 34309 },
    { 24128, 34345 },
    { 24129, 34326 },
    { 24130, 34364 },
    { 24131, 24318 },
    { 24132, 24328 },
    { 24133, 22844 },
    { 24134, 22849 },
    { 24135, 32823 },
    { 24136, 22869 },
    { 24137, 22874 },
    { 24138, 22872 },
    { 24139, 21263 },
    { 24140, 23586 },
    { 24141, 23589 },
    { 24142, 23596 },
    { 24143, 23604 },
    { 24144, 25164 },
    { 24145, 25194 },
    { 24146, 25247 },
    { 24147, 25275 },
    { 24148, 25290 },
    { 24149, 25306 },
    { 24150, 25303 },
    { 24151, 25326 },
    { 24152, 25378 },
    { 24153, 25334 },
    { 24154, 25401 },
    { 24155, 25419 },
    { 24156, 25411 },
    { 24157, 25517 },
    { 24158, 25590 },
    { 24159, 25457 },
    { 24160, 25466 },
    { 24161, 25486 },
    { 24162, 25524 },
    { 24163, 25453 },
    { 24164, 25516 },
    { 24165, 25482 },
    { 24166, 25449 },
    { 24167, 25518 },
    { 24168, 25532 },
    { 24169, 25586 },
    { 24170, 25592 },
    { 24171, 25568 },
    { 24172, 25599 },
    { 24173, 25540 },
    { 24174, 25566 },
    { 24175, 25550 },
    { 24176, 25682 },
    { 24177, 25542 },
    { 24178, 25534 },
    { 24179, 25669 },
    { 24180, 25665 },
    { 24181, 25611 },
    { 24182, 25627 },
    { 24183, 25632 },
    { 24184, 25612 },
    { 24185, 25638 },
    { 24186, 25633 },
    { 24187, 25694 },
    { 24188, 25732 },
    { 24189, 25709 },
    { 24190, 25750 },
    { 24353, 25722 },
    { 24354, 25783 },
    { 24355, 25784 },
    { 24356, 25753 },
    { 24357, 25786 },
    { 24358, 25792 },
    { 24359, 25808 },
    { 24360, 25815 },
    { 24361, 25828 },
    { 24362, 25826 },
    { 24363, 25865 },
    { 24364, 25893 },
    { 24365, 25902 },
    { 24366, 24331 },
    { 24367, 24530 },
    { 24368, 29977 },
    { 24369, 24337 },
    { 24370, 21343 },
    { 24371, 21489 },
    { 24372, 21501 },
    { 24373, 21481 },
    { 24374, 21480 },
    { 24375, 21499 },
    { 24376, 21522 },
    { 24377, 21526 },
    { 24378, 21510 },
    { 24379, 21579 },
    { 24380, 21586 },
    { 24381, 21587 },
    { 24382, 21588 },
    { 24383, 21590 },
    { 24384, 21571 },
    { 24385, 21537 },
    { 24386, 21591 },
    { 24387, 21593 },
    { 24388, 21539 },
    { 24389, 21554 },
    { 24390, 21634 },
    { 24391, 21652 },
    { 24392, 21623 },
    { 24393, 21617 },
    { 24394, 21604 },
    { 24395, 21658 },
    { 24396, 21659 },
    { 24397, 21636 },
    { 24398, 21622 },
    { 24399, 21606 },
    { 24400, 21661 },
    { 24401, 21712 },
    { 24402, 21677 },
    { 24403, 21698 },
    { 24404, 21684 },
    { 24405, 21714 },
    { 24406, 21671 },
    { 24407, 21670 },
    { 24408, 21715 },
    { 24409, 21716 },
    { 24410, 21618 },
    { 24411, 21667 },
    { 24412, 21717 },
    { 24413, 21691 },
    { 24414, 21695 },
    { 24415, 21708 },
    { 24416, 21721 },
    { 24417, 21722 },
    { 24418, 21724 },
    { 24419, 21673 },
    { 24420, 21674 },
    { 24421, 21668 },
    { 24422, 21725 },
    { 24423, 21711 },
    { 24424, 21726 },
    { 24425, 21787 },
    { 24426, 21735 },
    { 24427, 21792 },
    { 24428, 21757 },
    { 24429, 21780 },
    { 24430, 21747 },
    { 24431, 21794 },
    { 24432, 21795 },
    { 24433, 21775 },
    { 24434, 21777 },
    { 24435, 21799 },
    { 24436, 21802 },
    { 24437, 21863 },
    { 24438, 21903 },
    { 24439, 21941 },
    { 24440, 21833 },
    { 24441, 21869 },
    { 24442, 21825 },
    { 24443, 21845 },
    { 24444, 21823 },
    { 24445, 21840 },
    { 24446, 21820 },
    { 24609, 21815 },
    { 24610, 21846 },
    { 24611, 21877 },
    { 24612, 21878 },
    { 24613, 21879 },
    { 24614, 21811 },
    { 24615, 21808 },
    { 24616, 21852 },
    { 24617, 21899 },
    { 24618, 21970 },
    { 24619, 21891 },
    { 24620, 21937 },
    { 24621, 21945 },
    { 24622, 21896 },
    { 24623, 21889 },
    { 24624, 21919 },
    { 24625, 21886 },
    { 24626, 21974 },
    { 24627, 21905 },
    { 24628, 21883 },
    { 24629, 21983 },
    { 24630, 21949 },
    { 24631, 21950 },
    { 24632, 21908 },
    { 24633, 21913 },
    { 24634, 21994 },
    { 24635, 22007 },
    { 24636, 21961 },
    { 24637, 22047 },
    { 24638, 21969 },
    { 24639, 21995 },
    { 24640, 21996 },
    { 24641, 21972 },
    { 24642, 21990 },
    { 24643, 21981 },
    { 24644, 21956 },
    { 24645, 21999 },
    { 24646, 21989 },
    { 24647, 22002 },
    { 24648, 22003 },
    { 24649, 21964 },
    { 24650, 21965 },
    { 24651, 21992 },
    { 24652, 22005 },
    { 24653, 21988 },
    { 24654, 36756 },
    { 24655, 22046 },
    { 24656, 22024 },
    { 24657, 22028 },
    { 24658, 22017 },
    { 24659, 22052 },
    { 24660, 22051 },
    { 24661, 22014 },
    { 24662, 22016 },
    { 24663, 22055 },
    { 24664, 22061 },
    { 24665, 22104 },
    { 24666, 22073 },
    { 24667, 22103 },
    { 24668, 22060 },
    { 24669, 22093 },
    { 24670, 22114 },
    { 24671, 22105 },
    { 24672, 22108 },
    { 24673, 22092 },
    { 24674, 22100 },
    { 24675, 22150 },
    { 24676, 22116 },
    { 24677, 22129 },
    { 24678, 22123 },
    { 24679, 22139 },
    { 24680, 22140 },
    { 24681, 22149 },
    { 24682, 22163 },
    { 24683, 22191 },
    { 24684, 22228 },
    { 24685, 22231 },
    { 24686, 22237 },
    { 24687, 22241 },
    { 24688, 22261 },
    { 24689, 22251 },
    { 24690, 22265 },
    { 24691, 22271 },
    { 24692, 22276 },
    { 24693, 22282 },
    { 24694, 22281 },
    { 24695, 22300 },
    { 24696, 24079 },
    { 24697, 24089 },
    { 24698, 24084 },
    { 24699, 24081 },
    { 24700, 24113 },
    { 24701, 24123 },
    { 24702, 24124 },
    { 24865, 24119 },
    { 24866, 24132 },
    { 24867, 24148 },
    { 24868, 24155 },
    { 24869, 24158 },
    { 24870, 24161 },
    { 24871, 23692 },
    { 24872, 23674 },
    { 24873, 23693 },
    { 24874, 23696 },
    { 24875, 23702 },
    { 24876, 23688 },
    { 24877, 23704 },
    { 24878, 23705 },
    { 24879, 23697 },
    { 24880, 23706 },
    { 24881, 23708 },
    { 24882, 23733 },
    { 24883, 23714 },
    { 24884, 23741 },
    { 24885, 23724 },
    { 24886, 23723 },
    { 24887, 23729 },
    { 24888, 23715 },
    { 24889, 23745 },
    { 24890, 23735 },
    { 24891, 23748 },
    { 24892, 23762 },
    { 24893, 23780 },
    { 24894, 23755 },
    { 24895, 23781 },
    { 24896, 23810 },
    { 24897, 23811 },
    { 24898, 23847 },
    { 24899, 23846 },
    { 24900, 23854 },
    { 24901, 23844 },
    { 24902, 23838 },
    { 24903, 23814 },
    { 24904, 23835 },
    { 24905, 23896 },
    { 24906, 23870 },
    { 24907, 23860 },
    { 24908, 23869 },
    { 24909, 23916 },
    { 24910, 23899 },
    { 24911, 23919 },
    { 24912, 23901 },
    { 24913, 23915 },
    { 24914, 23883 },
    { 24915, 23882 },
    { 24916, 23913 },
    { 24917, 23924 },
    { 24918, 23938 },
    { 24919, 23961 },
    { 24920, 23965 },
    { 24921, 35955 },
    { 24922, 23991 },
    { 24923, 24005 },
    { 24924, 24435 },
    { 24925, 24439 },
    { 24926, 24450 },
    { 24927, 24455 },
    { 24928, 24457 },
    { 24929, 24460 },
    { 24930, 24469 },
    { 24931, 24473 },
    { 24932, 24476 },
    { 24933, 24488 },
    { 24934, 24493 },
    { 24935, 24501 },
    { 24936, 24508 },
    { 24937, 34914 },
    { 24938, 24417 },
    { 24939, 29357 },
    { 24940, 29360 },
    { 24941, 29364 },
    { 24942, 29367 },
    { 24943, 29368 },
    { 24944, 29379 },
    { 24945, 29377 },
    { 24946, 29390 },
    { 24947, 29389 },
    { 24948, 29394 },
    { 24949, 29416 },
    { 24950, 29423 },
    { 24951, 29417 },
    { 24952, 29426 },
    { 24953, 29428 },
    { 24954, 29431 },
    { 24955, 29441 },
    { 24956, 29427 },
    { 24957, 29443 },
    { 24958, 29434 },
    { 25121, 29435 },
    { 25122, 29463 },
    { 25123, 29459 },
    { 25124, 29473 },
    { 25125, 29450 },
    { 25126, 29470 },
    { 25127, 29469 },
    { 25128, 29461 },
    { 25129, 29474 },
    { 25130, 29497 },
    { 25131, 29477 },
    { 25132, 29484 },
    { 25133, 29496 },
    { 25134, 29489 },
    { 25135, 29520 },
    { 25136, 29517 },
    { 25137, 29527 },
    { 25138, 29536 },
    { 25139, 29548 },
    { 25140, 29551 },
    { 25141, 29566 },
    { 25142, 33307 },
    { 25143, 22821 },
    { 25144, 39143 },
    { 25145, 22820 },
    { 25146, 22786 },
    { 25147, 39267 },
    { 25148, 39271 },
    { 25149, 39272 },
    { 25150, 39273 },
    { 25151, 39274 },
    { 25152, 39275 },
    { 25153, 39276 },
    { 25154, 39284 },
    { 25155, 39287 },
    { 25156, 39293 },
    { 25157, 39296 },
    { 25158, 39300 },
    { 25159, 39303 },
    { 25160, 39306 },
    { 25161, 39309 },
    { 25162, 39312 },
    { 25163, 39313 },
    { 25164, 39315 },
    { 25165, 39316 },
    { 25166, 39317 },
    { 25167, 24192 },
    { 25168, 24209 },
    { 25169, 24203 },
    { 25170, 24214 },
    { 25171, 24229 },
    { 25172, 24224 },
    { 25173, 24249 },
    { 25174, 24245 },
    { 25175, 24254 },
    { 25176, 24243 },
    { 25177, 36179 },
    { 25178, 24274 },
    { 25179, 24273 },
    { 25180, 24283 },
    { 25181, 24296 },
    { 25182, 24298 },
    { 25183, 33210 },
    { 25184, 24516 },
    { 25185, 24521 },
    { 25186, 24534 },
    { 25187, 24527 },
    { 25188, 24579 },
    { 25189, 24558 },
    { 25190, 24580 },
    { 25191, 24545 },
    { 25192, 24548 },
    { 25193, 24574 },
    { 25194, 24581 },
    { 25195, 24582 },
    { 25196, 24554 },
    { 25197, 24557 },
    { 25198, 24568 },
    { 25199, 24601 },
    { 25200, 24629 },
    { 25201, 24614 },
    { 25202, 24603 },
    { 25203, 24591 },
    { 25204, 24589 },
    { 25205, 24617 },
    { 25206, 24619 },
    { 25207, 24586 },
    { 25208, 24639 },
    { 25209, 24609 },
    { 25210, 24696 },
    { 25211, 24697 },
    { 25212, 24699 },
    { 25213, 24698 },
    { 25214, 24642 },
    { 25377, 24682 },
    { 25378, 24701 },
    { 25379, 24726 },
    { 25380, 24730 },
    { 25381, 24749 },
    { 25382, 24733 },
    { 25383, 24707 },
    { 25384, 24722 },
    { 25385, 24716 },
    { 25386, 24731 },
    { 25387, 24812 },
    { 25388, 24763 },
    { 25389, 24753 },
    { 25390, 24797 },
    { 25391, 24792 },
    { 25392, 24774 },
    { 25393, 24794 },
    { 25394, 24756 },
    { 25395, 24864 },
    { 25396, 24870 },
    { 25397, 24853 },
    { 25398, 24867 },
    { 25399, 24820 },
    { 25400, 24832 },
    { 25401, 24846 },
    { 25402, 24875 },
    { 25403, 24906 },
    { 25404, 24949 },
    { 25405, 25004 },
    { 25406, 24980 },
    { 25407, 24999 },
    { 25408, 25015 },
    { 25409, 25044 },
    { 25410, 25077 },
    { 25411, 24541 },
    { 25412, 38579 },
    { 25413, 38377 },
    { 25414, 38379 },
    { 25415, 38385 },
    { 25416, 38387 },
    { 25417, 38389 },
    { 25418, 38390 },
    { 25419, 38396 },
    { 25420, 38398 },
    { 25421, 38403 },
    { 25422, 38404 },
    { 25423, 38406 },
    { 25424, 38408 },
    { 25425, 38410 },
    { 25426, 38411 },
    { 25427, 38412 },
    { 25428, 38413 },
    { 25429, 38415 },
    { 25430, 38418 },
    { 25431, 38421 },
    { 25432, 38422 },
    { 25433, 38423 },
    { 25434, 38425 },
    { 25435, 38426 },
    { 25436, 20012 },
    { 25437, 29247 },
    { 25438, 25109 },
    { 25439, 27701 },
    { 25440, 27732 },
    { 25441, 27740 },
    { 25442, 27722 },
    { 25443, 27811 },
    { 25444, 27781 },
    { 25445, 27792 },
    { 25446, 27796 },
    { 25447, 27788 },
    { 25448, 27752 },
    { 25449, 27753 },
    { 25450, 27764 },
    { 25451, 27766 },
    { 25452, 27782 },
    { 25453, 27817 },
    { 25454, 27856 },
    { 25455, 27860 },
    { 25456, 27821 },
    { 25457, 27895 },
    { 25458, 27896 },
    { 25459, 27889 },
    { 25460, 27863 },
    { 25461, 27826 },
    { 25462, 27872 },
    { 25463, 27862 },
    { 25464, 27898 },
    { 25465, 27883 },
    { 25466, 27886 },
    { 25467, 27825 },
    { 25468, 27859 },
    { 25469, 27887 },
    { 25470, 27902 },
    { 25633, 27961 },
    { 25634, 27943 },
    { 25635, 27916 },
    { 25636, 27971 },
    { 25637, 27976 },
    { 25638, 27911 },
    { 25639, 27908 },
    { 25640, 27929 },
    { 25641, 27918 },
    { 25642, 27947 },
    { 25643, 27981 },
    { 25644, 27950 },
    { 25645, 27957 },
    { 25646, 27930 },
    { 25647, 27983 },
    { 25648, 27986 },
    { 25649, 27988 },
    { 25650, 27955 },
    { 25651, 28049 },
    { 25652, 28015 },
    { 25653, 28062 },
    { 25654, 28064 },
    { 25655, 27998 },
    { 25656, 28051 },
    { 25657, 28052 },
    { 25658, 27996 },
    { 25659, 28000 },
    { 25660, 28028 },
    { 25661, 28003 },
    { 25662, 28186 },
    { 25663, 28103 },
    { 25664, 28101 },
    { 25665, 28126 },
    { 25666, 28174 },
    { 25667, 28095 },
    { 25668, 28128 },
    { 25669, 28177 },
    { 25670, 28134 },
    { 25671, 28125 },
    { 25672, 28121 },
    { 25673, 28182 },
    { 25674, 28075 },
    { 25675, 28172 },
    { 25676, 28078 },
    { 25677, 28203 },
    { 25678, 28270 },
    { 25679, 28238 },
    { 25680, 28267 },
    { 25681, 28338 },
    { 25682, 28255 },
    { 25683, 28294 },
    { 25684, 28243 },
    { 25685, 28244 },
    { 25686, 28210 },
    { 25687, 28197 },
    { 25688, 28228 },
    { 25689, 28383 },
    { 25690, 28337 },
    { 25691, 28312 },
    { 25692, 28384 },
    { 25693, 28461 },
    { 25694, 28386 },
    { 25695, 28325 },
    { 25696, 28327 },
    { 25697, 28349 },
    { 25698, 28347 },
    { 25699, 28343 },
    { 25700, 28375 },
    { 25701, 28340 },
    { 25702, 28367 },
    { 25703, 28303 },
    { 25704, 28354 },
    { 25705, 28319 },
    { 25706, 28514 },
    { 25707, 28486 },
    { 25708, 28487 },
    { 25709, 28452 },
    { 25710, 28437 },
    { 25711, 28409 },
    { 25712, 28463 },
    { 25713, 28470 },
    { 25714, 28491 },
    { 25715, 28532 },
    { 25716, 28458 },
    { 25717, 28425 },
    { 25718, 28457 },
    { 25719, 28553 },
    { 25720, 28557 },
    { 25721, 28556 },
    { 25722, 28536 },
    { 25723, 28530 },
    { 25724, 28540 },
    { 25725, 28538 },
    { 25726, 28625 },
    { 25889, 28617 },
    { 25890, 28583 },
    { 25891, 28601 },
    { 25892, 28598 },
    { 25893, 28610 },
    { 25894, 28641 },
    { 25895, 28654 },
    { 25896, 28638 },
    { 25897, 28640 },
    { 25898, 28655 },
    { 25899, 28698 },
    { 25900, 28707 },
    { 25901, 28699 },
    { 25902, 28729 },
    { 25903, 28725 },
    { 25904, 28751 },
    { 25905, 28766 },
    { 25906, 23424 },
    { 25907, 23428 },
    { 25908, 23445 },
    { 25909, 23443 },
    { 25910, 23461 },
    { 25911, 23480 },
    { 25912, 29999 },
    { 25913, 39582 },
    { 25914, 25652 },
    { 25915, 23524 },
    { 25916, 23534 },
    { 25917, 35120 },
    { 25918, 23536 },
    { 25919, 36423 },
    { 25920, 35591 },
    { 25921, 36790 },
    { 25922, 36819 },
    { 25923, 36821 },
    { 25924, 36837 },
    { 25925, 36846 },
    { 25926, 36836 },
    { 25927, 36841 },
    { 25928, 36838 },
    { 25929, 36851 },
    { 25930, 36840 },
    { 25931, 36869 },
    { 25932, 36868 },
    { 25933, 36875 },
    { 25934, 36902 },
    { 25935, 36881 },
    { 25936, 36877 },
    { 25937, 36886 },
    { 25938, 36897 },
    { 25939, 36917 },
    { 25940, 36918 },
    { 25941, 36909 },
    { 25942, 36911 },
    { 25943, 36932 },
    { 25944, 36945 },
    { 25945, 36946 },
    { 25946, 36944 },
    { 25947, 36968 },
    { 25948, 36952 },
    { 25949, 36962 },
    { 25950, 36955 },
    { 25951, 26297 },
    { 25952, 36980 },
    { 25953, 36989 },
    { 25954, 36994 },
    { 25955, 37000 },
    { 25956, 36995 },
    { 25957, 37003 },
    { 25958, 24400 },
    { 25959, 24407 },
    { 25960, 24406 },
    { 25961, 24408 },
    { 25962, 23611 },
    { 25963, 21675 },
    { 25964, 23632 },
    { 25965, 23641 },
    { 25966, 23409 },
    { 25967, 23651 },
    { 25968, 23654 },
    { 25969, 32700 },
    { 25970, 24362 },
    { 25971, 24361 },
    { 25972, 24365 },
    { 25973, 33396 },
    { 25974, 24380 },
    { 25975, 39739 },
    { 25976, 23662 },
    { 25977, 22913 },
    { 25978, 22915 },
    { 25979, 22925 },
    { 25980, 22953 },
    { 25981, 22954 },
    { 25982, 22947 },
    { 26145, 22935 },
    { 26146, 22986 },
    { 26147, 22955 },
    { 26148, 22942 },
    { 26149, 22948 },
    { 26150, 22994 },
    { 26151, 22962 },
    { 26152, 22959 },
    { 26153, 22999 },
    { 26154, 22974 },
    { 26155, 23045 },
    { 26156, 23046 },
    { 26157, 23005 },
    { 26158, 23048 },
    { 26159, 23011 },
    { 26160, 23000 },
    { 26161, 23033 },
    { 26162, 23052 },
    { 26163, 23049 },
    { 26164, 23090 },
    { 26165, 23092 },
    { 26166, 23057 },
    { 26167, 23075 },
    { 26168, 23059 },
    { 26169, 23104 },
    { 26170, 23143 },
    { 26171, 23114 },
    { 26172, 23125 },
    { 26173, 23100 },
    { 26174, 23138 },
    { 26175, 23157 },
    { 26176, 33004 },
    { 26177, 23210 },
    { 26178, 23195 },
    { 26179, 23159 },
    { 26180, 23162 },
    { 26181, 23230 },
    { 26182, 23275 },
    { 26183, 23218 },
    { 26184, 23250 },
    { 26185, 23252 },
    { 26186, 23224 },
    { 26187, 23264 },
    { 26188, 23267 },
    { 26189, 23281 },
    { 26190, 23254 },
    { 26191, 23270 },
    { 26192, 23256 },
    { 26193, 23260 },
    { 26194, 23305 },
    { 26195, 23319 },
    { 26196, 23318 },
    { 26197, 23346 },
    { 26198, 23351 },
    { 26199, 23360 },
    { 26200, 23573 },
    { 26201, 23580 },
    { 26202, 23386 },
    { 26203, 23397 },
    { 26204, 23411 },
    { 26205, 23377 },
    { 26206, 23379 },
    { 26207, 23394 },
    { 26208, 39541 },
    { 26209, 39543 },
    { 26210, 39544 },
    { 26211, 39546 },
    { 26212, 39551 },
    { 26213, 39549 },
    { 26214, 39552 },
    { 26215, 39553 },
    { 26216, 39557 },
    { 26217, 39560 },
    { 26218, 39562 },
    { 26219, 39568 },
    { 26220, 39570 },
    { 26221, 39571 },
    { 26222, 39574 },
    { 26223, 39576 },
    { 26224, 39579 },
    { 26225, 39580 },
    { 26226, 39581 },
    { 26227, 39583 },
    { 26228, 39584 },
    { 26229, 39586 },
    { 26230, 39587 },
    { 26231, 39589 },
    { 26232, 39591 },
    { 26233, 32415 },
    { 26234, 32417 },
    { 26235, 32419 },
    { 26236, 32421 },
    { 26237, 32424 },
    { 26238, 32425 },
    { 26401, 32429 },
    { 26402, 32432 },
    { 26403, 32446 },
    { 26404, 32448 },
    { 26405, 32449 },
    { 26406, 32450 },
    { 26407, 32457 },
    { 26408, 32459 },
    { 26409, 32460 },
    { 26410, 32464 },
    { 26411, 32468 },
    { 26412, 32471 },
    { 26413, 32475 },
    { 26414, 32480 },
    { 26415, 32481 },
    { 26416, 32488 },
    { 26417, 32491 },
    { 26418, 32494 },
    { 26419, 32495 },
    { 26420, 32497 },
    { 26421, 32498 },
    { 26422, 32525 },
    { 26423, 32502 },
    { 26424, 32506 },
    { 26425, 32507 },
    { 26426, 32510 },
    { 26427, 32513 },
    { 26428, 32514 },
    { 26429, 32515 },
    { 26430, 32519 },
    { 26431, 32520 },
    { 26432, 32523 },
    { 26433, 32524 },
    { 26434, 32527 },
    { 26435, 32529 },
    { 26436, 32530 },
    { 26437, 32535 },
    { 26438, 32537 },
    { 26439, 32540 },
    { 26440, 32539 },
    { 26441, 32543 },
    { 26442, 32545 },
    { 26443, 32546 },
    { 26444, 32547 },
    { 26445, 32548 },
    { 26446, 32549 },
    { 26447, 32550 },
    { 26448, 32551 },
    { 26449, 32554 },
    { 26450, 32555 },
    { 26451, 32556 },
    { 26452, 32557 },
    { 26453, 32559 },
    { 26454, 32560 },
    { 26455, 32561 },
    { 26456, 32562 },
    { 26457, 32563 },
    { 26458, 32565 },
    { 26459, 24186 },
    { 26460, 30079 },
    { 26461, 24027 },
    { 26462, 30014 },
    { 26463, 37013 },
    { 26464, 29582 },
    { 26465, 29585 },
    { 26466, 29614 },
    { 26467, 29602 },
    { 26468, 29599 },
    { 26469, 29647 },
    { 26470, 29634 },
    { 26471, 29649 },
    { 26472, 29623 },
    { 26473, 29619 },
    { 26474, 29632 },
    { 26475, 29641 },
    { 26476, 29640 },
    { 26477, 29669 },
    { 26478, 29657 },
    { 26479, 39036 },
    { 26480, 29706 },
    { 26481, 29673 },
    { 26482, 29671 },
    { 26483, 29662 },
    { 26484, 29626 },
    { 26485, 29682 },
    { 26486, 29711 },
    { 26487, 29738 },
    { 26488, 29787 },
    { 26489, 29734 },
    { 26490, 29733 },
    { 26491, 29736 },
    { 26492, 29744 },
    { 26493, 29742 },
    { 26494, 29740 },
    { 26657, 29723 },
    { 26658, 29722 },
    { 26659, 29761 },
    { 26660, 29788 },
    { 26661, 29783 },
    { 26662, 29781 },
    { 26663, 29785 },
    { 26664, 29815 },
    { 26665, 29805 },
    { 26666, 29822 },
    { 26667, 29852 },
    { 26668, 29838 },
    { 26669, 29824 },
    { 26670, 29825 },
    { 26671, 29831 },
    { 26672, 29835 },
    { 26673, 29854 },
    { 26674, 29864 },
    { 26675, 29865 },
    { 26676, 29840 },
    { 26677, 29863 },
    { 26678, 29906 },
    { 26679, 29882 },
    { 26680, 38890 },
    { 26681, 38891 },
    { 26682, 38892 },
    { 26683, 26444 },
    { 26684, 26451 },
    { 26685, 26462 },
    { 26686, 26440 },
    { 26687, 26473 },
    { 26688, 26533 },
    { 26689, 26503 },
    { 26690, 26474 },
    { 26691, 26483 },
    { 26692, 26520 },
    { 26693, 26535 },
    { 26694, 26485 },
    { 26695, 26536 },
    { 26696, 26526 },
    { 26697, 26541 },
    { 26698, 26507 },
    { 26699, 26487 },
    { 26700, 26492 },
    { 26701, 26608 },
    { 26702, 26633 },
    { 26703, 26584 },
    { 26704, 26634 },
    { 26705, 26601 },
    { 26706, 26544 },
    { 26707, 26636 },
    { 26708, 26585 },
    { 26709, 26549 },
    { 26710, 26586 },
    { 26711, 26547 },
    { 26712, 26589 },
    { 26713, 26624 },
    { 26714, 26563 },
    { 26715, 26552 },
    { 26716, 26594 },
    { 26717, 26638 },
    { 26718, 26561 },
    { 26719, 26621 },
    { 26720, 26674 },
    { 26721, 26675 },
    { 26722, 26720 },
    { 26723, 26721 },
    { 26724, 26702 },
    { 26725, 26722 },
    { 26726, 26692 },
    { 26727, 26724 },
    { 26728, 26755 },
    { 26729, 26653 },
    { 26730, 26709 },
    { 26731, 26726 },
    { 26732, 26689 },
    { 26733, 26727 },
    { 26734, 26688 },
    { 26735, 26686 },
    { 26736, 26698 },
    { 26737, 26697 },
    { 26738, 26665 },
    { 26739, 26805 },
    { 26740, 26767 },
    { 26741, 26740 },
    { 26742, 26743 },
    { 26743, 26771 },
    { 26744, 26731 },
    { 26745, 26818 },
    { 26746, 26990 },
    { 26747, 26876 },
    { 26748, 26911 },
    { 26749, 26912 },
    { 26750, 26873 },
    { 26913, 26916 },
    { 26914, 26864 },
    { 26915, 26891 },
    { 26916, 26881 },
    { 26917, 26967 },
    { 26918, 26851 },
    { 26919, 26896 },
    { 26920, 26993 },
    { 26921, 26937 },
    { 26922, 26976 },
    { 26923, 26946 },
    { 26924, 26973 },
    { 26925, 27012 },
    { 26926, 26987 },
    { 26927, 27008 },
    { 26928, 27032 },
    { 26929, 27000 },
    { 26930, 26932 },
    { 26931, 27084 },
    { 26932, 27015 },
    { 26933, 27016 },
    { 26934, 27086 },
    { 26935, 27017 },
    { 26936, 26982 },
    { 26937, 26979 },
    { 26938, 27001 },
    { 26939, 27035 },
    { 26940, 27047 },
    { 26941, 27067 },
    { 26942, 27051 },
    { 26943, 27053 },
    { 26944, 27092 },
    { 26945, 27057 },
    { 26946, 27073 },
    { 26947, 27082 },
    { 26948, 27103 },
    { 26949, 27029 },
    { 26950, 27104 },
    { 26951, 27021 },
    { 26952, 27135 },
    { 26953, 27183 },
    { 26954, 27117 },
    { 26955, 27159 },
    { 26956, 27160 },
    { 26957, 27237 },
    { 26958, 27122 },
    { 26959, 27204 },
    { 26960, 27198 },
    { 26961, 27296 },
    { 26962, 27216 },
    { 26963, 27227 },
    { 26964, 27189 },
    { 26965, 27278 },
    { 26966, 27257 },
    { 26967, 27197 },
    { 26968, 27176 },
    { 26969, 27224 },
    { 26970, 27260 },
    { 26971, 27281 },
    { 26972, 27280 },
    { 26973, 27305 },
    { 26974, 27287 },
    { 26975, 27307 },
    { 26976, 29495 },
    { 26977, 29522 },
    { 26978, 27521 },
    { 26979, 27522 },
    { 26980, 27527 },
    { 26981, 27524 },
    { 26982, 27538 },
    { 26983, 27539 },
    { 26984, 27533 },
    { 26985, 27546 },
    { 26986, 27547 },
    { 26987, 27553 },
    { 26988, 27562 },
    { 26989, 36715 },
    { 26990, 36717 },
    { 26991, 36721 },
    { 26992, 36722 },
    { 26993, 36723 },
    { 26994, 36725 },
    { 26995, 36726 },
    { 26996, 36728 },
    { 26997, 36727 },
    { 26998, 36729 },
    { 26999, 36730 },
    { 27000, 36732 },
    { 27001, 36734 },
    { 27002, 36737 },
    { 27003, 36738 },
    { 27004, 36740 },
    { 27005, 36743 },
    { 27006, 36747 },
    { 27169, 36749 },
    { 27170, 36750 },
    { 27171, 36751 },
    { 27172, 36760 },
    { 27173, 36762 },
    { 27174, 36558 },
    { 27175, 25099 },
    { 27176, 25111 },
    { 27177, 25115 },
    { 27178, 25119 },
    { 27179, 25122 },
    { 27180, 25121 },
    { 27181, 25125 },
    { 27182, 25124 },
    { 27183, 25132 },
    { 27184, 33255 },
    { 27185, 29935 },
    { 27186, 29940 },
    { 27187, 29951 },
    { 27188, 29967 },
    { 27189, 29969 },
    { 27190, 29971 },
    { 27191, 25908 },
    { 27192, 26094 },
    { 27193, 26095 },
    { 27194, 26096 },
    { 27195, 26122 },
    { 27196, 26137 },
    { 27197, 26482 },
    { 27198, 26115 },
    { 27199, 26133 },
    { 27200, 26112 },
    { 27201, 28805 },
    { 27202, 26359 },
    { 27203, 26141 },
    { 27204, 26164 },
    { 27205, 26161 },
    { 27206, 26166 },
    { 27207, 26165 },
    { 27208, 32774 },
    { 27209, 26207 },
    { 27210, 26196 },
    { 27211, 26177 },
    { 27212, 26191 },
    { 27213, 26198 },
    { 27214, 26209 },
    { 27215, 26199 },
    { 27216, 26231 },
    { 27217, 26244 },
    { 27218, 26252 },
    { 27219, 26279 },
    { 27220, 26269 },
    { 27221, 26302 },
    { 27222, 26331 },
    { 27223, 26332 },
    { 27224, 26342 },
    { 27225, 26345 },
    { 27226, 36146 },
    { 27227, 36147 },
    { 27228, 36150 },
    { 27229, 36155 },
    { 27230, 36157 },
    { 27231, 36160 },
    { 27232, 36165 },
    { 27233, 36166 },
    { 27234, 36168 },
    { 27235, 36169 },
    { 27236, 36167 },
    { 27237, 36173 },
    { 27238, 36181 },
    { 27239, 36185 },
    { 27240, 35271 },
    { 27241, 35274 },
    { 27242, 35275 },
    { 27243, 35276 },
    { 27244, 35278 },
    { 27245, 35279 },
    { 27246, 35280 },
    { 27247, 35281 },
    { 27248, 29294 },
    { 27249, 29343 },
    { 27250, 29277 },
    { 27251, 29286 },
    { 27252, 29295 },
    { 27253, 29310 },
    { 27254, 29311 },
    { 27255, 29316 },
    { 27256, 29323 },
    { 27257, 29325 },
    { 27258, 29327 },
    { 27259, 29330 },
    { 27260, 25352 },
    { 27261, 25394 },
    { 27262, 25520 },
    { 27425, 25663 },
    { 27426, 25816 },
    { 27427, 32772 },
    { 27428, 27626 },
    { 27429, 27635 },
    { 27430, 27645 },
    { 27431, 27637 },
    { 27432, 27641 },
    { 27433, 27653 },
    { 27434, 27655 },
    { 27435, 27654 },
    { 27436, 27661 },
    { 27437, 27669 },
    { 27438, 27672 },
    { 27439, 27673 },
    { 27440, 27674 },
    { 27441, 27681 },
    { 27442, 27689 },
    { 27443, 27684 },
    { 27444, 27690 },
    { 27445, 27698 },
    { 27446, 25909 },
    { 27447, 25941 },
    { 27448, 25963 },
    { 27449, 29261 },
    { 27450, 29266 },
    { 27451, 29270 },
    { 27452, 29232 },
    { 27453, 34402 },
    { 27454, 21014 },
    { 27455, 32927 },
    { 27456, 32924 },
    { 27457, 32915 },
    { 27458, 32956 },
    { 27459, 26378 },
    { 27460, 32957 },
    { 27461, 32945 },
    { 27462, 32939 },
    { 27463, 32941 },
    { 27464, 32948 },
    { 27465, 32951 },
    { 27466, 32999 },
    { 27467, 33000 },
    { 27468, 33001 },
    { 27469, 33002 },
    { 27470, 32987 },
    { 27471, 32962 },
    { 27472, 32964 },
    { 27473, 32985 },
    { 27474, 32973 },
    { 27475, 32983 },
    { 27476, 26384 },
    { 27477, 32989 },
    { 27478, 33003 },
    { 27479, 33009 },
    { 27480, 33012 },
    { 27481, 33005 },
    { 27482, 33037 },
    { 27483, 33038 },
    { 27484, 33010 },
    { 27485, 33020 },
    { 27486, 26389 },
    { 27487, 33042 },
    { 27488, 35930 },
    { 27489, 33078 },
    { 27490, 33054 },
    { 27491, 33068 },
    { 27492, 33048 },
    { 27493, 33074 },
    { 27494, 33096 },
    { 27495, 33100 },
    { 27496, 33107 },
    { 27497, 33140 },
    { 27498, 33113 },
    { 27499, 33114 },
    { 27500, 33137 },
    { 27501, 33120 },
    { 27502, 33129 },
    { 27503, 33148 },
    { 27504, 33149 },
    { 27505, 33133 },
    { 27506, 33127 },
    { 27507, 22605 },
    { 27508, 23221 },
    { 27509, 33160 },
    { 27510, 33154 },
    { 27511, 33169 },
    { 27512, 28373 },
    { 27513, 33187 },
    { 27514, 33194 },
    { 27515, 33228 },
    { 27516, 26406 },
    { 27517, 33226 },
    { 27518, 33211 },
    { 27681, 33217 },
    { 27682, 33190 },
    { 27683, 27428 },
    { 27684, 27447 },
    { 27685, 27449 },
    { 27686, 27459 },
    { 27687, 27462 },
    { 27688, 27481 },
    { 27689, 39121 },
    { 27690, 39122 },
    { 27691, 39123 },
    { 27692, 39125 },
    { 27693, 39129 },
    { 27694, 39130 },
    { 27695, 27571 },
    { 27696, 24384 },
    { 27697, 27586 },
    { 27698, 35315 },
    { 27699, 26000 },
    { 27700, 40785 },
    { 27701, 26003 },
    { 27702, 26044 },
    { 27703, 26054 },
    { 27704, 26052 },
    { 27705, 26051 },
    { 27706, 26060 },
    { 27707, 26062 },
    { 27708, 26066 },
    { 27709, 26070 },
    { 27710, 28800 },
    { 27711, 28828 },
    { 27712, 28822 },
    { 27713, 28829 },
    { 27714, 28859 },
    { 27715, 28864 },
    { 27716, 28855 },
    { 27717, 28843 },
    { 27718, 28849 },
    { 27719, 28904 },
    { 27720, 28874 },
    { 27721, 28944 },
    { 27722, 28947 },
    { 27723, 28950 },
    { 27724, 28975 },
    { 27725, 28977 },
    { 27726, 29043 },
    { 27727, 29020 },
    { 27728, 29032 },
    { 27729, 28997 },
    { 27730, 29042 },
    { 27731, 29002 },
    { 27732, 29048 },
    { 27733, 29050 },
    { 27734, 29080 },
    { 27735, 29107 },
    { 27736, 29109 },
    { 27737, 29096 },
    { 27738, 29088 },
    { 27739, 29152 },
    { 27740, 29140 },
    { 27741, 29159 },
    { 27742, 29177 },
    { 27743, 29213 },
    { 27744, 29224 },
    { 27745, 28780 },
    { 27746, 28952 },
    { 27747, 29030 },
    { 27748, 29113 },
    { 27749, 25150 },
    { 27750, 25149 },
    { 27751, 25155 },
    { 27752, 25160 },
    { 27753, 25161 },
    { 27754, 31035 },
    { 27755, 31040 },
    { 27756, 31046 },
    { 27757, 31049 },
    { 27758, 31067 },
    { 27759, 31068 },
    { 27760, 31059 },
    { 27761, 31066 },
    { 27762, 31074 },
    { 27763, 31063 },
    { 27764, 31072 },
    { 27765, 31087 },
    { 27766, 31079 },
    { 27767, 31098 },
    { 27768, 31109 },
    { 27769, 31114 },
    { 27770, 31130 },
    { 27771, 31143 },
    { 27772, 31155 },
    { 27773, 24529 },
    { 27774, 24528 },
    { 27937, 24636 },
    { 27938, 24669 },
    { 27939, 24666 },
    { 27940, 24679 },
    { 27941, 24641 },
    { 27942, 24665 },
    { 27943, 24675 },
    { 27944, 24747 },
    { 27945, 24838 },
    { 27946, 24845 },
    { 27947, 24925 },
    { 27948, 25001 },
    { 27949, 24989 },
    { 27950, 25035 },
    { 27951, 25041 },
    { 27952, 25094 },
    { 27953, 32896 },
    { 27954, 32895 },
    { 27955, 27795 },
    { 27956, 27894 },
    { 27957, 28156 },
    { 27958, 30710 },
    { 27959, 30712 },
    { 27960, 30720 },
    { 27961, 30729 },
    { 27962, 30743 },
    { 27963, 30744 },
    { 27964, 30737 },
    { 27965, 26027 },
    { 27966, 30765 },
    { 27967, 30748 },
    { 27968, 30749 },
    { 27969, 30777 },
    { 27970, 30778 },
    { 27971, 30779 },
    { 27972, 30751 },
    { 27973, 30780 },
    { 27974, 30757 },
    { 27975, 30764 },
    { 27976, 30755 },
    { 27977, 30761 },
    { 27978, 30798 },
    { 27979, 30829 },
    { 27980, 30806 },
    { 27981, 30807 },
    { 27982, 30758 },
    { 27983, 30800 },
    { 27984, 30791 },
    { 27985, 30796 },
    { 27986, 30826 },
    { 27987, 30875 },
    { 27988, 30867 },
    { 27989, 30874 },
    { 27990, 30855 },
    { 27991, 30876 },
    { 27992, 30881 },
    { 27993, 30883 },
    { 27994, 30898 },
    { 27995, 30905 },
    { 27996, 30885 },
    { 27997, 30932 },
    { 27998, 30937 },
    { 27999, 30921 },
    { 28000, 30956 },
    { 28001, 30962 },
    { 28002, 30981 },
    { 28003, 30964 },
    { 28004, 30995 },
    { 28005, 31012 },
    { 28006, 31006 },
    { 28007, 31028 },
    { 28008, 40859 },
    { 28009, 40697 },
    { 28010, 40699 },
    { 28011, 40700 },
    { 28012, 30449 },
    { 28013, 30468 },
    { 28014, 30477 },
    { 28015, 30457 },
    { 28016, 30471 },
    { 28017, 30472 },
    { 28018, 30490 },
    { 28019, 30498 },
    { 28020, 30489 },
    { 28021, 30509 },
    { 28022, 30502 },
    { 28023, 30517 },
    { 28024, 30520 },
    { 28025, 30544 },
    { 28026, 30545 },
    { 28027, 30535 },
    { 28028, 30531 },
    { 28029, 30554 },
    { 28030, 30568 },
    { 28193, 30562 },
    { 28194, 30565 },
    { 28195, 30591 },
    { 28196, 30605 },
    { 28197, 30589 },
    { 28198, 30592 },
    { 28199, 30604 },
    { 28200, 30609 },
    { 28201, 30623 },
    { 28202, 30624 },
    { 28203, 30640 },
    { 28204, 30645 },
    { 28205, 30653 },
    { 28206, 30010 },
    { 28207, 30016 },
    { 28208, 30030 },
    { 28209, 30027 },
    { 28210, 30024 },
    { 28211, 30043 },
    { 28212, 30066 },
    { 28213, 30073 },
    { 28214, 30083 },
    { 28215, 32600 },
    { 28216, 32609 },
    { 28217, 32607 },
    { 28218, 35400 },
    { 28219, 32616 },
    { 28220, 32628 },
    { 28221, 32625 },
    { 28222, 32633 },
    { 28223, 32641 },
    { 28224, 32638 },
    { 28225, 30413 },
    { 28226, 30437 },
    { 28227, 34866 },
    { 28228, 38021 },
    { 28229, 38022 },
    { 28230, 38023 },
    { 28231, 38027 },
    { 28232, 38026 },
    { 28233, 38028 },
    { 28234, 38029 },
    { 28235, 38031 },
    { 28236, 38032 },
    { 28237, 38036 },
    { 28238, 38039 },
    { 28239, 38037 },
    { 28240, 38042 },
    { 28241, 38043 },
    { 28242, 38044 },
    { 28243, 38051 },
    { 28244, 38052 },
    { 28245, 38059 },
    { 28246, 38058 },
    { 28247, 38061 },
    { 28248, 38060 },
    { 28249, 38063 },
    { 28250, 38064 },
    { 28251, 38066 },
    { 28252, 38068 },
    { 28253, 38070 },
    { 28254, 38071 },
    { 28255, 38072 },
    { 28256, 38073 },
    { 28257, 38074 },
    { 28258, 38076 },
    { 28259, 38077 },
    { 28260, 38079 },
    { 28261, 38084 },
    { 28262, 38088 },
    { 28263, 38089 },
    { 28264, 38090 },
    { 28265, 38091 },
    { 28266, 38092 },
    { 28267, 38093 },
    { 28268, 38094 },
    { 28269, 38096 },
    { 28270, 38097 },
    { 28271, 38098 },
    { 28272, 38101 },
    { 28273, 38102 },
    { 28274, 38103 },
    { 28275, 38105 },
    { 28276, 38104 },
    { 28277, 38107 },
    { 28278, 38110 },
    { 28279, 38111 },
    { 28280, 38112 },
    { 28281, 38114 },
    { 28282, 38116 },
    { 28283, 38117 },
    { 28284, 38119 },
    { 28285, 38120 },
    { 28286, 38122 },
    { 28449, 38121 },
    { 28450, 38123 },
    { 28451, 38126 },
    { 28452, 38127 },
    { 28453, 38131 },
    { 28454, 38132 },
    { 28455, 38133 },
    { 28456, 38135 },
    { 28457, 38137 },
    { 28458, 38140 },
    { 28459, 38141 },
    { 28460, 38143 },
    { 28461, 38147 },
    { 28462, 38146 },
    { 28463, 38150 },
    { 28464, 38151 },
    { 28465, 38153 },
    { 28466, 38154 },
    { 28467, 38157 },
    { 28468, 38158 },
    { 28469, 38159 },
    { 28470, 38162 },
    { 28471, 38163 },
    { 28472, 38164 },
    { 28473, 38165 },
    { 28474, 38166 },
    { 28475, 38168 },
    { 28476, 38171 },
    { 28477, 38173 },
    { 28478, 38174 },
    { 28479, 38175 },
    { 28480, 38178 },
    { 28481, 38186 },
    { 28482, 38187 },
    { 28483, 38185 },
    { 28484, 38188 },
    { 28485, 38193 },
    { 28486, 38194 },
    { 28487, 38196 },
    { 28488, 38198 },
    { 28489, 38199 },
    { 28490, 38200 },
    { 28491, 38204 },
    { 28492, 38206 },
    { 28493, 38207 },
    { 28494, 38210 },
    { 28495, 38197 },
    { 28496, 38212 },
    { 28497, 38213 },
    { 28498, 38214 },
    { 28499, 38217 },
    { 28500, 38220 },
    { 28501, 38222 },
    { 28502, 38223 },
    { 28503, 38226 },
    { 28504, 38227 },
    { 28505, 38228 },
    { 28506, 38230 },
    { 28507, 38231 },
    { 28508, 38232 },
    { 28509, 38233 },
    { 28510, 38235 },
    { 28511, 38238 },
    { 28512, 38239 },
    { 28513, 38237 },
    { 28514, 38241 },
    { 28515, 38242 },
    { 28516, 38244 },
    { 28517, 38245 },
    { 28518, 38246 },
    { 28519, 38247 },
    { 28520, 38248 },
    { 28521, 38249 },
    { 28522, 38250 },
    { 28523, 38251 },
    { 28524, 38252 },
    { 28525, 38255 },
    { 28526, 38257 },
    { 28527, 38258 },
    { 28528, 38259 },
    { 28529, 38202 },
    { 28530, 30695 },
    { 28531, 30700 },
    { 28532, 38601 },
    { 28533, 31189 },
    { 28534, 31213 },
    { 28535, 31203 },
    { 28536, 31211 },
    { 28537, 31238 },
    { 28538, 23879 },
    { 28539, 31235 },
    { 28540, 31234 },
    { 28541, 31262 },
    { 28542, 31252 },
    { 28705, 31289 },
    { 28706, 31287 },
    { 28707, 31313 },
    { 28708, 40655 },
    { 28709, 39333 },
    { 28710, 31344 },
    { 28711, 30344 },
    { 28712, 30350 },
    { 28713, 30355 },
    { 28714, 30361 },
    { 28715, 30372 },
    { 28716, 29918 },
    { 28717, 29920 },
    { 28718, 29996 },
    { 28719, 40480 },
    { 28720, 40482 },
    { 28721, 40488 },
    { 28722, 40489 },
    { 28723, 40490 },
    { 28724, 40491 },
    { 28725, 40492 },
    { 28726, 40498 },
    { 28727, 40497 },
    { 28728, 40502 },
    { 28729, 40504 },
    { 28730, 40503 },
    { 28731, 40505 },
    { 28732, 40506 },
    { 28733, 40510 },
    { 28734, 40513 },
    { 28735, 40514 },
    { 28736, 40516 },
    { 28737, 40518 },
    { 28738, 40519 },
    { 28739, 40520 },
    { 28740, 40521 },
    { 28741, 40523 },
    { 28742, 40524 },
    { 28743, 40526 },
    { 28744, 40529 },
    { 28745, 40533 },
    { 28746, 40535 },
    { 28747, 40538 },
    { 28748, 40539 },
    { 28749, 40540 },
    { 28750, 40542 },
    { 28751, 40547 },
    { 28752, 40550 },
    { 28753, 40551 },
    { 28754, 40552 },
    { 28755, 40553 },
    { 28756, 40554 },
    { 28757, 40555 },
    { 28758, 40556 },
    { 28759, 40561 },
    { 28760, 40557 },
    { 28761, 40563 },
    { 28762, 30098 },
    { 28763, 30100 },
    { 28764, 30102 },
    { 28765, 30112 },
    { 28766, 30109 },
    { 28767, 30124 },
    { 28768, 30115 },
    { 28769, 30131 },
    { 28770, 30132 },
    { 28771, 30136 },
    { 28772, 30148 },
    { 28773, 30129 },
    { 28774, 30128 },
    { 28775, 30147 },
    { 28776, 30146 },
    { 28777, 30166 },
    { 28778, 30157 },
    { 28779, 30179 },
    { 28780, 30184 },
    { 28781, 30182 },
    { 28782, 30180 },
    { 28783, 30187 },
    { 28784, 30183 },
    { 28785, 30211 },
    { 28786, 30193 },
    { 28787, 30204 },
    { 28788, 30207 },
    { 28789, 30224 },
    { 28790, 30208 },
    { 28791, 30213 },
    { 28792, 30220 },
    { 28793, 30231 },
    { 28794, 30218 },
    { 28795, 30245 },
    { 28796, 30232 },
    { 28797, 30229 },
    { 28798, 30233 },
    { 28961, 30235 },
    { 28962, 30268 },
    { 28963, 30242 },
    { 28964, 30240 },
    { 28965, 30272 },
    { 28966, 30253 },
    { 28967, 30256 },
    { 28968, 30271 },
    { 28969, 30261 },
    { 28970, 30275 },
    { 28971, 30270 },
    { 28972, 30259 },
    { 28973, 30285 },
    { 28974, 30302 },
    { 28975, 30292 },
    { 28976, 30300 },
    { 28977, 30294 },
    { 28978, 30315 },
    { 28979, 30319 },
    { 28980, 32714 },
    { 28981, 31462 },
    { 28982, 31352 },
    { 28983, 31353 },
    { 28984, 31360 },
    { 28985, 31366 },
    { 28986, 31368 },
    { 28987, 31381 },
    { 28988, 31398 },
    { 28989, 31392 },
    { 28990, 31404 },
    { 28991, 31400 },
    { 28992, 31405 },
    { 28993, 31411 },
    { 28994, 34916 },
    { 28995, 34921 },
    { 28996, 34930 },
    { 28997, 34941 },
    { 28998, 34943 },
    { 28999, 34946 },
    { 29000, 34978 },
    { 29001, 35014 },
    { 29002, 34999 },
    { 29003, 35004 },
    { 29004, 35017 },
    { 29005, 35042 },
    { 29006, 35022 },
    { 29007, 35043 },
    { 29008, 35045 },
    { 29009, 35057 },
    { 29010, 35098 },
    { 29011, 35068 },
    { 29012, 35048 },
    { 29013, 35070 },
    { 29014, 35056 },
    { 29015, 35105 },
    { 29016, 35097 },
    { 29017, 35091 },
    { 29018, 35099 },
    { 29019, 35082 },
    { 29020, 35124 },
    { 29021, 35115 },
    { 29022, 35126 },
    { 29023, 35137 },
    { 29024, 35174 },
    { 29025, 35195 },
    { 29026, 30091 },
    { 29027, 32997 },
    { 29028, 30386 },
    { 29029, 30388 },
    { 29030, 30684 },
    { 29031, 32786 },
    { 29032, 32788 },
    { 29033, 32790 },
    { 29034, 32796 },
    { 29035, 32800 },
    { 29036, 32802 },
    { 29037, 32805 },
    { 29038, 32806 },
    { 29039, 32807 },
    { 29040, 32809 },
    { 29041, 32808 },
    { 29042, 32817 },
    { 29043, 32779 },
    { 29044, 32821 },
    { 29045, 32835 },
    { 29046, 32838 },
    { 29047, 32845 },
    { 29048, 32850 },
    { 29049, 32873 },
    { 29050, 32881 },
    { 29051, 35203 },
    { 29052, 39032 },
    { 29053, 39040 },
    { 29054, 39043 },
    { 29217, 39049 },
    { 29218, 39052 },
    { 29219, 39053 },
    { 29220, 39055 },
    { 29221, 39060 },
    { 29222, 39066 },
    { 29223, 39067 },
    { 29224, 39070 },
    { 29225, 39071 },
    { 29226, 39073 },
    { 29227, 39074 },
    { 29228, 39077 },
    { 29229, 39078 },
    { 29230, 34381 },
    { 29231, 34388 },
    { 29232, 34412 },
    { 29233, 34414 },
    { 29234, 34431 },
    { 29235, 34426 },
    { 29236, 34428 },
    { 29237, 34427 },
    { 29238, 34472 },
    { 29239, 34445 },
    { 29240, 34443 },
    { 29241, 34476 },
    { 29242, 34461 },
    { 29243, 34471 },
    { 29244, 34467 },
    { 29245, 34474 },
    { 29246, 34451 },
    { 29247, 34473 },
    { 29248, 34486 },
    { 29249, 34500 },
    { 29250, 34485 },
    { 29251, 34510 },
    { 29252, 34480 },
    { 29253, 34490 },
    { 29254, 34481 },
    { 29255, 34479 },
    { 29256, 34505 },
    { 29257, 34511 },
    { 29258, 34484 },
    { 29259, 34537 },
    { 29260, 34545 },
    { 29261, 34546 },
    { 29262, 34541 },
    { 29263, 34547 },
    { 29264, 34512 },
    { 29265, 34579 },
    { 29266, 34526 },
    { 29267, 34548 },
    { 29268, 34527 },
    { 29269, 34520 },
    { 29270, 34513 },
    { 29271, 34563 },
    { 29272, 34567 },
    { 29273, 34552 },
    { 29274, 34568 },
    { 29275, 34570 },
    { 29276, 34573 },
    { 29277, 34569 },
    { 29278, 34595 },
    { 29279, 34619 },
    { 29280, 34590 },
    { 29281, 34597 },
    { 29282, 34606 },
    { 29283, 34586 },
    { 29284, 34622 },
    { 29285, 34632 },
    { 29286, 34612 },
    { 29287, 34609 },
    { 29288, 34601 },
    { 29289, 34615 },
    { 29290, 34623 },
    { 29291, 34690 },
    { 29292, 34594 },
    { 29293, 34685 },
    { 29294, 34686 },
    { 29295, 34683 },
    { 29296, 34656 },
    { 29297, 34672 },
    { 29298, 34636 },
    { 29299, 34670 },
    { 29300, 34699 },
    { 29301, 34643 },
    { 29302, 34659 },
    { 29303, 34684 },
    { 29304, 34660 },
    { 29305, 34649 },
    { 29306, 34661 },
    { 29307, 34707 },
    { 29308, 34735 },
    { 29309, 34728 },
    { 29310, 34770 },
    { 29473, 34758 },
    { 29474, 34696 },
    { 29475, 34693 },
    { 29476, 34733 },
    { 29477, 34711 },
    { 29478, 34691 },
    { 29479, 34731 },
    { 29480, 34789 },
    { 29481, 34732 },
    { 29482, 34741 },
    { 29483, 34739 },
    { 29484, 34763 },
    { 29485, 34771 },
    { 29486, 34749 },
    { 29487, 34769 },
    { 29488, 34752 },
    { 29489, 34762 },
    { 29490, 34779 },
    { 29491, 34794 },
    { 29492, 34784 },
    { 29493, 34798 },
    { 29494, 34838 },
    { 29495, 34835 },
    { 29496, 34814 },
    { 29497, 34826 },
    { 29498, 34843 },
    { 29499, 34849 },
    { 29500, 34873 },
    { 29501, 34876 },
    { 29502, 32566 },
    { 29503, 32578 },
    { 29504, 32580 },
    { 29505, 32581 },
    { 29506, 33296 },
    { 29507, 31482 },
    { 29508, 31485 },
    { 29509, 31496 },
    { 29510, 31491 },
    { 29511, 31492 },
    { 29512, 31509 },
    { 29513, 31498 },
    { 29514, 31531 },
    { 29515, 31503 },
    { 29516, 31559 },
    { 29517, 31544 },
    { 29518, 31530 },
    { 29519, 31513 },
    { 29520, 31534 },
    { 29521, 31537 },
    { 29522, 31520 },
    { 29523, 31525 },
    { 29524, 31524 },
    { 29525, 31539 },
    { 29526, 31550 },
    { 29527, 31518 },
    { 29528, 31576 },
    { 29529, 31578 },
    { 29530, 31557 },
    { 29531, 31605 },
    { 29532, 31564 },
    { 29533, 31581 },
    { 29534, 31584 },
    { 29535, 31598 },
    { 29536, 31611 },
    { 29537, 31586 },
    { 29538, 31602 },
    { 29539, 31601 },
    { 29540, 31632 },
    { 29541, 31654 },
    { 29542, 31655 },
    { 29543, 31672 },
    { 29544, 31660 },
    { 29545, 31645 },
    { 29546, 31656 },
    { 29547, 31621 },
    { 29548, 31658 },
    { 29549, 31644 },
    { 29550, 31650 },
    { 29551, 31659 },
    { 29552, 31668 },
    { 29553, 31697 },
    { 29554, 31681 },
    { 29555, 31692 },
    { 29556, 31709 },
    { 29557, 31706 },
    { 29558, 31717 },
    { 29559, 31718 },
    { 29560, 31722 },
    { 29561, 31756 },
    { 29562, 31742 },
    { 29563, 31740 },
    { 29564, 31759 },
    { 29565, 31766 },
    { 29566, 31755 },
    { 29729, 31775 },
    { 29730, 31786 },
    { 29731, 31782 },
    { 29732, 31800 },
    { 29733, 31809 },
    { 29734, 31808 },
    { 29735, 33278 },
    { 29736, 33281 },
    { 29737, 33282 },
    { 29738, 33284 },
    { 29739, 33260 },
    { 29740, 34884 },
    { 29741, 33313 },
    { 29742, 33314 },
    { 29743, 33315 },
    { 29744, 33325 },
    { 29745, 33327 },
    { 29746, 33320 },
    { 29747, 33323 },
    { 29748, 33336 },
    { 29749, 33339 },
    { 29750, 33331 },
    { 29751, 33332 },
    { 29752, 33342 },
    { 29753, 33348 },
    { 29754, 33353 },
    { 29755, 33355 },
    { 29756, 33359 },
    { 29757, 33370 },
    { 29758, 33375 },
    { 29759, 33384 },
    { 29760, 34942 },
    { 29761, 34949 },
    { 29762, 34952 },
    { 29763, 35032 },
    { 29764, 35039 },
    { 29765, 35166 },
    { 29766, 32669 },
    { 29767, 32671 },
    { 29768, 32679 },
    { 29769, 32687 },
    { 29770, 32688 },
    { 29771, 32690 },
    { 29772, 31868 },
    { 29773, 25929 },
    { 29774, 31889 },
    { 29775, 31901 },
    { 29776, 31900 },
    { 29777, 31902 },
    { 29778, 31906 },
    { 29779, 31922 },
    { 29780, 31932 },
    { 29781, 31933 },
    { 29782, 31937 },
    { 29783, 31943 },
    { 29784, 31948 },
    { 29785, 31949 },
    { 29786, 31944 },
    { 29787, 31941 },
    { 29788, 31959 },
    { 29789, 31976 },
    { 29790, 33390 },
    { 29791, 26280 },
    { 29792, 32703 },
    { 29793, 32718 },
    { 29794, 32725 },
    { 29795, 32741 },
    { 29796, 32737 },
    { 29797, 32742 },
    { 29798, 32745 },
    { 29799, 32750 },
    { 29800, 32755 },
    { 29801, 31992 },
    { 29802, 32119 },
    { 29803, 32166 },
    { 29804, 32174 },
    { 29805, 32327 },
    { 29806, 32411 },
    { 29807, 40632 },
    { 29808, 40628 },
    { 29809, 36211 },
    { 29810, 36228 },
    { 29811, 36244 },
    { 29812, 36241 },
    { 29813, 36273 },
    { 29814, 36199 },
    { 29815, 36205 },
    { 29816, 35911 },
    { 29817, 35913 },
    { 29818, 37194 },
    { 29819, 37200 },
    { 29820, 37198 },
    { 29821, 37199 },
    { 29822, 37220 },
    { 29985, 37218 },
    { 29986, 37217 },
    { 29987, 37232 },
    { 29988, 37225 },
    { 29989, 37231 },
    { 29990, 37245 },
    { 29991, 37246 },
    { 29992, 37234 },
    { 29993, 37236 },
    { 29994, 37241 },
    { 29995, 37260 },
    { 29996, 37253 },
    { 29997, 37264 },
    { 29998, 37261 },
    { 29999, 37265 },
    { 30000, 37282 },
    { 30001, 37283 },
    { 30002, 37290 },
    { 30003, 37293 },
    { 30004, 37294 },
    { 30005, 37295 },
    { 30006, 37301 },
    { 30007, 37300 },
    { 30008, 37306 },
    { 30009, 35925 },
    { 30010, 40574 },
    { 30011, 36280 },
    { 30012, 36331 },
    { 30013, 36357 },
    { 30014, 36441 },
    { 30015, 36457 },
    { 30016, 36277 },
    { 30017, 36287 },
    { 30018, 36284 },
    { 30019, 36282 },
    { 30020, 36292 },
    { 30021, 36310 },
    { 30022, 36311 },
    { 30023, 36314 },
    { 30024, 36318 },
    { 30025, 36302 },
    { 30026, 36303 },
    { 30027, 36315 },
    { 30028, 36294 },
    { 30029, 36332 },
    { 30030, 36343 },
    { 30031, 36344 },
    { 30032, 36323 },
    { 30033, 36345 },
    { 30034, 36347 },
    { 30035, 36324 },
    { 30036, 36361 },
    { 30037, 36349 },
    { 30038, 36372 },
    { 30039, 36381 },
    { 30040, 36383 },
    { 30041, 36396 },
    { 30042, 36398 },
    { 30043, 36387 },
    { 30044, 36399 },
    { 30045, 36410 },
    { 30046, 36416 },
    { 30047, 36409 },
    { 30048, 36405 },
    { 30049, 36413 },
    { 30050, 36401 },
    { 30051, 36425 },
    { 30052, 36417 },
    { 30053, 36418 },
    { 30054, 36433 },
    { 30055, 36434 },
    { 30056, 36426 },
    { 30057, 36464 },
    { 30058, 36470 },
    { 30059, 36476 },
    { 30060, 36463 },
    { 30061, 36468 },
    { 30062, 36485 },
    { 30063, 36495 },
    { 30064, 36500 },
    { 30065, 36496 },
    { 30066, 36508 },
    { 30067, 36510 },
    { 30068, 35960 },
    { 30069, 35970 },
    { 30070, 35978 },
    { 30071, 35973 },
    { 30072, 35992 },
    { 30073, 35988 },
    { 30074, 26011 },
    { 30075, 35286 },
    { 30076, 35294 },
    { 30077, 35290 },
    { 30078, 35292 },
    { 30241, 35301 },
    { 30242, 35307 },
    { 30243, 35311 },
    { 30244, 35390 },
    { 30245, 35622 },
    { 30246, 38739 },
    { 30247, 38633 },
    { 30248, 38643 },
    { 30249, 38639 },
    { 30250, 38662 },
    { 30251, 38657 },
    { 30252, 38664 },
    { 30253, 38671 },
    { 30254, 38670 },
    { 30255, 38698 },
    { 30256, 38701 },
    { 30257, 38704 },
    { 30258, 38718 },
    { 30259, 40832 },
    { 30260, 40835 },
    { 30261, 40837 },
    { 30262, 40838 },
    { 30263, 40839 },
    { 30264, 40840 },
    { 30265, 40841 },
    { 30266, 40842 },
    { 30267, 40844 },
    { 30268, 40702 },
    { 30269, 40715 },
    { 30270, 40717 },
    { 30271, 38585 },
    { 30272, 38588 },
    { 30273, 38589 },
    { 30274, 38606 },
    { 30275, 38610 },
    { 30276, 30655 },
    { 30277, 38624 },
    { 30278, 37518 },
    { 30279, 37550 },
    { 30280, 37576 },
    { 30281, 37694 },
    { 30282, 37738 },
    { 30283, 37834 },
    { 30284, 37775 },
    { 30285, 37950 },
    { 30286, 37995 },
    { 30287, 40063 },
    { 30288, 40066 },
    { 30289, 40069 },
    { 30290, 40070 },
    { 30291, 40071 },
    { 30292, 40072 },
    { 30293, 31267 },
    { 30294, 40075 },
    { 30295, 40078 },
    { 30296, 40080 },
    { 30297, 40081 },
    { 30298, 40082 },
    { 30299, 40084 },
    { 30300, 40085 },
    { 30301, 40090 },
    { 30302, 40091 },
    { 30303, 40094 },
    { 30304, 40095 },
    { 30305, 40096 },
    { 30306, 40097 },
    { 30307, 40098 },
    { 30308, 40099 },
    { 30309, 40101 },
    { 30310, 40102 },
    { 30311, 40103 },
    { 30312, 40104 },
    { 30313, 40105 },
    { 30314, 40107 },
    { 30315, 40109 },
    { 30316, 40110 },
    { 30317, 40112 },
    { 30318, 40113 },
    { 30319, 40114 },
    { 30320, 40115 },
    { 30321, 40116 },
    { 30322, 40117 },
    { 30323, 40118 },
    { 30324, 40119 },
    { 30325, 40122 },
    { 30326, 40123 },
    { 30327, 40124 },
    { 30328, 40125 },
    { 30329, 40132 },
    { 30330, 40133 },
    { 30331, 40134 },
    { 30332, 40135 },
    { 30333, 40138 },
    { 30334, 40139 },
    { 30497, 40140 },
    { 30498, 40141 },
    { 30499, 40142 },
    { 30500, 40143 },
    { 30501, 40144 },
    { 30502, 40147 },
    { 30503, 40148 },
    { 30504, 40149 },
    { 30505, 40151 },
    { 30506, 40152 },
    { 30507, 40153 },
    { 30508, 40156 },
    { 30509, 40157 },
    { 30510, 40159 },
    { 30511, 40162 },
    { 30512, 38780 },
    { 30513, 38789 },
    { 30514, 38801 },
    { 30515, 38802 },
    { 30516, 38804 },
    { 30517, 38831 },
    { 30518, 38827 },
    { 30519, 38819 },
    { 30520, 38834 },
    { 30521, 38836 },
    { 30522, 39601 },
    { 30523, 39600 },
    { 30524, 39607 },
    { 30525, 40536 },
    { 30526, 39606 },
    { 30527, 39610 },
    { 30528, 39612 },
    { 30529, 39617 },
    { 30530, 39616 },
    { 30531, 39621 },
    { 30532, 39618 },
    { 30533, 39627 },
    { 30534, 39628 },
    { 30535, 39633 },
    { 30536, 39749 },
    { 30537, 39747 },
    { 30538, 39751 },
    { 30539, 39753 },
    { 30540, 39752 },
    { 30541, 39757 },
    { 30542, 39761 },
    { 30543, 39144 },
    { 30544, 39181 },
    { 30545, 39214 },
    { 30546, 39253 },
    { 30547, 39252 },
    { 30548, 39647 },
    { 30549, 39649 },
    { 30550, 39654 },
    { 30551, 39663 },
    { 30552, 39659 },
    { 30553, 39675 },
    { 30554, 39661 },
    { 30555, 39673 },
    { 30556, 39688 },
    { 30557, 39695 },
    { 30558, 39699 },
    { 30559, 39711 },
    { 30560, 39715 },
    { 30561, 40637 },
    { 30562, 40638 },
    { 30563, 32315 },
    { 30564, 40578 },
    { 30565, 40583 },
    { 30566, 40584 },
    { 30567, 40587 },
    { 30568, 40594 },
    { 30569, 37846 },
    { 30570, 40605 },
    { 30571, 40607 },
    { 30572, 40667 },
    { 30573, 40668 },
    { 30574, 40669 },
    { 30575, 40672 },
    { 30576, 40671 },
    { 30577, 40674 },
    { 30578, 40681 },
    { 30579, 40679 },
    { 30580, 40677 },
    { 30581, 40682 },
    { 30582, 40687 },
    { 30583, 40738 },
    { 30584, 40748 },
    { 30585, 40751 },
    { 30586, 40761 },
    { 30587, 40759 },
    { 30588, 40765 },
    { 30589, 40766 },
    { 30590, 40772 },
};
    
const encoding_convert_entry Big5ToUnicodeTable[13710] =
{
    { 0xA140, 0x3000 },
    { 0xA141, 0xFF0C },
    { 0xA142, 0x3001 },
    { 0xA143, 0x3002 },
    { 0xA144, 0xFF0E },
    { 0xA145, 0x2022 },
    { 0xA146, 0xFF1B },
    { 0xA147, 0xFF1A },
    { 0xA148, 0xFF1F },
    { 0xA149, 0xFF01 },
    { 0xA14A, 0xFE30 },
    { 0xA14B, 0x2026 },
    { 0xA14C, 0x2025 },
    { 0xA14D, 0xFE50 },
    { 0xA14E, 0xFF64 },
    { 0xA14F, 0xFE52 },
    { 0xA150, 0x00B7 },
    { 0xA151, 0xFE54 },
    { 0xA152, 0xFE55 },
    { 0xA153, 0xFE56 },
    { 0xA154, 0xFE57 },
    { 0xA155, 0xFF5C },
    { 0xA156, 0x2013 },
    { 0xA157, 0xFE31 },
    { 0xA158, 0x2014 },
    { 0xA159, 0xFE33 },
    { 0xA15A, 0xFFFD },
    { 0xA15B, 0xFE34 },
    { 0xA15C, 0xFE4F },
    { 0xA15D, 0xFF08 },
    { 0xA15E, 0xFF09 },
    { 0xA15F, 0xFE35 },
    { 0xA160, 0xFE36 },
    { 0xA161, 0xFF5B },
    { 0xA162, 0xFF5D },
    { 0xA163, 0xFE37 },
    { 0xA164, 0xFE38 },
    { 0xA165, 0x3014 },
    { 0xA166, 0x3015 },
    { 0xA167, 0xFE39 },
    { 0xA168, 0xFE3A },
    { 0xA169, 0x3010 },
    { 0xA16A, 0x3011 },
    { 0xA16B, 0xFE3B },
    { 0xA16C, 0xFE3C },
    { 0xA16D, 0x300A },
    { 0xA16E, 0x300B },
    { 0xA16F, 0xFE3D },
    { 0xA170, 0xFE3E },
    { 0xA171, 0x3008 },
    { 0xA172, 0x3009 },
    { 0xA173, 0xFE3F },
    { 0xA174, 0xFE40 },
    { 0xA175, 0x300C },
    { 0xA176, 0x300D },
    { 0xA177, 0xFE41 },
    { 0xA178, 0xFE42 },
    { 0xA179, 0x300E },
    { 0xA17A, 0x300F },
    { 0xA17B, 0xFE43 },
    { 0xA17C, 0xFE44 },
    { 0xA17D, 0xFE59 },
    { 0xA17E, 0xFE5A },
    { 0xA1A1, 0xFE5B },
    { 0xA1A2, 0xFE5C },
    { 0xA1A3, 0xFE5D },
    { 0xA1A4, 0xFE5E },
    { 0xA1A5, 0x2018 },
    { 0xA1A6, 0x2019 },
    { 0xA1A7, 0x201C },
    { 0xA1A8, 0x201D },
    { 0xA1A9, 0x301D },
    { 0xA1AA, 0x301E },
    { 0xA1AB, 0x2035 },
    { 0xA1AC, 0x2032 },
    { 0xA1AD, 0xFF03 },
    { 0xA1AE, 0xFF06 },
    { 0xA1AF, 0xFF0A },
    { 0xA1B0, 0x203B },
    { 0xA1B1, 0x00A7 },
    { 0xA1B2, 0x3003 },
    { 0xA1B3, 0x25CB },
    { 0xA1B4, 0x25CF },
    { 0xA1B5, 0x25B3 },
    { 0xA1B6, 0x25B2 },
    { 0xA1B7, 0x25CE },
    { 0xA1B8, 0x2606 },
    { 0xA1B9, 0x2605 },
    { 0xA1BA, 0x25C7 },
    { 0xA1BB, 0x25C6 },
    { 0xA1BC, 0x25A1 },
    { 0xA1BD, 0x25A0 },
    { 0xA1BE, 0x25BD },
    { 0xA1BF, 0x25BC },
    { 0xA1C0, 0x32A3 },
    { 0xA1C1, 0x2105 },
    { 0xA1C2, 0x203E },
    { 0xA1C3, 0xFFFD },
    { 0xA1C4, 0xFF3F },
    { 0xA1C5, 0xFFFD },
    { 0xA1C6, 0xFE49 },
    { 0xA1C7, 0xFE4A },
    { 0xA1C8, 0xFE4D },
    { 0xA1C9, 0xFE4E },
    { 0xA1CA, 0xFE4B },
    { 0xA1CB, 0xFE4C },
    { 0xA1CC, 0xFE5F },
    { 0xA1CD, 0xFE60 },
    { 0xA1CE, 0xFE61 },
    { 0xA1CF, 0xFF0B },
    { 0xA1D0, 0xFF0D },
    { 0xA1D1, 0x00D7 },
    { 0xA1D2, 0x00F7 },
    { 0xA1D3, 0x00B1 },
    { 0xA1D4, 0x221A },
    { 0xA1D5, 0xFF1C },
    { 0xA1D6, 0xFF1E },
    { 0xA1D7, 0xFF1D },
    { 0xA1D8, 0x2266 },
    { 0xA1D9, 0x2267 },
    { 0xA1DA, 0x2260 },
    { 0xA1DB, 0x221E },
    { 0xA1DC, 0x2252 },
    { 0xA1DD, 0x2261 },
    { 0xA1DE, 0xFE62 },
    { 0xA1DF, 0xFE63 },
    { 0xA1E0, 0xFE64 },
    { 0xA1E1, 0xFE65 },
    { 0xA1E2, 0xFE66 },
    { 0xA1E3, 0x223C },
    { 0xA1E4, 0x2229 },
    { 0xA1E5, 0x222A },
    { 0xA1E6, 0x22A5 },
    { 0xA1E7, 0x2220 },
    { 0xA1E8, 0x221F },
    { 0xA1E9, 0x22BF },
    { 0xA1EA, 0x33D2 },
    { 0xA1EB, 0x33D1 },
    { 0xA1EC, 0x222B },
    { 0xA1ED, 0x222E },
    { 0xA1EE, 0x2235 },
    { 0xA1EF, 0x2234 },
    { 0xA1F0, 0x2640 },
    { 0xA1F1, 0x2642 },
    { 0xA1F2, 0x2641 },
    { 0xA1F3, 0x2609 },
    { 0xA1F4, 0x2191 },
    { 0xA1F5, 0x2193 },
    { 0xA1F6, 0x2190 },
    { 0xA1F7, 0x2192 },
    { 0xA1F8, 0x2196 },
    { 0xA1F9, 0x2197 },
    { 0xA1FA, 0x2199 },
    { 0xA1FB, 0x2198 },
    { 0xA1FC, 0x2225 },
    { 0xA1FD, 0x2223 },
    { 0xA1FE, 0xFFFD },
    { 0xA240, 0xFFFD },
    { 0xA241, 0xFF0F },
    { 0xA242, 0xFF3C },
    { 0xA243, 0xFF04 },
    { 0xA244, 0x00A5 },
    { 0xA245, 0x3012 },
    { 0xA246, 0x00A2 },
    { 0xA247, 0x00A3 },
    { 0xA248, 0xFF05 },
    { 0xA249, 0xFF20 },
    { 0xA24A, 0x2103 },
    { 0xA24B, 0x2109 },
    { 0xA24C, 0xFE69 },
    { 0xA24D, 0xFE6A },
    { 0xA24E, 0xFE6B },
    { 0xA24F, 0x33D5 },
    { 0xA250, 0x339C },
    { 0xA251, 0x339D },
    { 0xA252, 0x339E },
    { 0xA253, 0x33CE },
    { 0xA254, 0x33A1 },
    { 0xA255, 0x338E },
    { 0xA256, 0x338F },
    { 0xA257, 0x33C4 },
    { 0xA258, 0x00B0 },
    { 0xA259, 0x5159 },
    { 0xA25A, 0x515B },
    { 0xA25B, 0x515E },
    { 0xA25C, 0x515D },
    { 0xA25D, 0x5161 },
    { 0xA25E, 0x5163 },
    { 0xA25F, 0x55E7 },
    { 0xA260, 0x74E9 },
    { 0xA261, 0x7CCE },
    { 0xA262, 0x2581 },
    { 0xA263, 0x2582 },
    { 0xA264, 0x2583 },
    { 0xA265, 0x2584 },
    { 0xA266, 0x2585 },
    { 0xA267, 0x2586 },
    { 0xA268, 0x2587 },
    { 0xA269, 0x2588 },
    { 0xA26A, 0x258F },
    { 0xA26B, 0x258E },
    { 0xA26C, 0x258D },
    { 0xA26D, 0x258C },
    { 0xA26E, 0x258B },
    { 0xA26F, 0x258A },
    { 0xA270, 0x2589 },
    { 0xA271, 0x253C },
    { 0xA272, 0x2534 },
    { 0xA273, 0x252C },
    { 0xA274, 0x2524 },
    { 0xA275, 0x251C },
    { 0xA276, 0x2594 },
    { 0xA277, 0x2500 },
    { 0xA278, 0x2502 },
    { 0xA279, 0x2595 },
    { 0xA27A, 0x250C },
    { 0xA27B, 0x2510 },
    { 0xA27C, 0x2514 },
    { 0xA27D, 0x2518 },
    { 0xA27E, 0x256D },
    { 0xA2A1, 0x256E },
    { 0xA2A2, 0x2570 },
    { 0xA2A3, 0x256F },
    { 0xA2A4, 0x2550 },
    { 0xA2A5, 0x255E },
    { 0xA2A6, 0x256A },
    { 0xA2A7, 0x2561 },
    { 0xA2A8, 0x25E2 },
    { 0xA2A9, 0x25E3 },
    { 0xA2AA, 0x25E5 },
    { 0xA2AB, 0x25E4 },
    { 0xA2AC, 0x2571 },
    { 0xA2AD, 0x2572 },
    { 0xA2AE, 0x2573 },
    { 0xA2AF, 0xFF10 },
    { 0xA2B0, 0xFF11 },
    { 0xA2B1, 0xFF12 },
    { 0xA2B2, 0xFF13 },
    { 0xA2B3, 0xFF14 },
    { 0xA2B4, 0xFF15 },
    { 0xA2B5, 0xFF16 },
    { 0xA2B6, 0xFF17 },
    { 0xA2B7, 0xFF18 },
    { 0xA2B8, 0xFF19 },
    { 0xA2B9, 0x2160 },
    { 0xA2BA, 0x2161 },
    { 0xA2BB, 0x2162 },
    { 0xA2BC, 0x2163 },
    { 0xA2BD, 0x2164 },
    { 0xA2BE, 0x2165 },
    { 0xA2BF, 0x2166 },
    { 0xA2C0, 0x2167 },
    { 0xA2C1, 0x2168 },
    { 0xA2C2, 0x2169 },
    { 0xA2C3, 0x3021 },
    { 0xA2C4, 0x3022 },
    { 0xA2C5, 0x3023 },
    { 0xA2C6, 0x3024 },
    { 0xA2C7, 0x3025 },
    { 0xA2C8, 0x3026 },
    { 0xA2C9, 0x3027 },
    { 0xA2CA, 0x3028 },
    { 0xA2CB, 0x3029 },
    { 0xA2CC, 0xFFFD },
    { 0xA2CD, 0x5344 },
    { 0xA2CE, 0xFFFD },
    { 0xA2CF, 0xFF21 },
    { 0xA2D0, 0xFF22 },
    { 0xA2D1, 0xFF23 },
    { 0xA2D2, 0xFF24 },
    { 0xA2D3, 0xFF25 },
    { 0xA2D4, 0xFF26 },
    { 0xA2D5, 0xFF27 },
    { 0xA2D6, 0xFF28 },
    { 0xA2D7, 0xFF29 },
    { 0xA2D8, 0xFF2A },
    { 0xA2D9, 0xFF2B },
    { 0xA2DA, 0xFF2C },
    { 0xA2DB, 0xFF2D },
    { 0xA2DC, 0xFF2E },
    { 0xA2DD, 0xFF2F },
    { 0xA2DE, 0xFF30 },
    { 0xA2DF, 0xFF31 },
    { 0xA2E0, 0xFF32 },
    { 0xA2E1, 0xFF33 },
    { 0xA2E2, 0xFF34 },
    { 0xA2E3, 0xFF35 },
    { 0xA2E4, 0xFF36 },
    { 0xA2E5, 0xFF37 },
    { 0xA2E6, 0xFF38 },
    { 0xA2E7, 0xFF39 },
    { 0xA2E8, 0xFF3A },
    { 0xA2E9, 0xFF41 },
    { 0xA2EA, 0xFF42 },
    { 0xA2EB, 0xFF43 },
    { 0xA2EC, 0xFF44 },
    { 0xA2ED, 0xFF45 },
    { 0xA2EE, 0xFF46 },
    { 0xA2EF, 0xFF47 },
    { 0xA2F0, 0xFF48 },
    { 0xA2F1, 0xFF49 },
    { 0xA2F2, 0xFF4A },
    { 0xA2F3, 0xFF4B },
    { 0xA2F4, 0xFF4C },
    { 0xA2F5, 0xFF4D },
    { 0xA2F6, 0xFF4E },
    { 0xA2F7, 0xFF4F },
    { 0xA2F8, 0xFF50 },
    { 0xA2F9, 0xFF51 },
    { 0xA2FA, 0xFF52 },
    { 0xA2FB, 0xFF53 },
    { 0xA2FC, 0xFF54 },
    { 0xA2FD, 0xFF55 },
    { 0xA2FE, 0xFF56 },
    { 0xA340, 0xFF57 },
    { 0xA341, 0xFF58 },
    { 0xA342, 0xFF59 },
    { 0xA343, 0xFF5A },
    { 0xA344, 0x0391 },
    { 0xA345, 0x0392 },
    { 0xA346, 0x0393 },
    { 0xA347, 0x0394 },
    { 0xA348, 0x0395 },
    { 0xA349, 0x0396 },
    { 0xA34A, 0x0397 },
    { 0xA34B, 0x0398 },
    { 0xA34C, 0x0399 },
    { 0xA34D, 0x039A },
    { 0xA34E, 0x039B },
    { 0xA34F, 0x039C },
    { 0xA350, 0x039D },
    { 0xA351, 0x039E },
    { 0xA352, 0x039F },
    { 0xA353, 0x03A0 },
    { 0xA354, 0x03A1 },
    { 0xA355, 0x03A3 },
    { 0xA356, 0x03A4 },
    { 0xA357, 0x03A5 },
    { 0xA358, 0x03A6 },
    { 0xA359, 0x03A7 },
    { 0xA35A, 0x03A8 },
    { 0xA35B, 0x03A9 },
    { 0xA35C, 0x03B1 },
    { 0xA35D, 0x03B2 },
    { 0xA35E, 0x03B3 },
    { 0xA35F, 0x03B4 },
    { 0xA360, 0x03B5 },
    { 0xA361, 0x03B6 },
    { 0xA362, 0x03B7 },
    { 0xA363, 0x03B8 },
    { 0xA364, 0x03B9 },
    { 0xA365, 0x03BA },
    { 0xA366, 0x03BB },
    { 0xA367, 0x03BC },
    { 0xA368, 0x03BD },
    { 0xA369, 0x03BE },
    { 0xA36A, 0x03BF },
    { 0xA36B, 0x03C0 },
    { 0xA36C, 0x03C1 },
    { 0xA36D, 0x03C3 },
    { 0xA36E, 0x03C4 },
    { 0xA36F, 0x03C5 },
    { 0xA370, 0x03C6 },
    { 0xA371, 0x03C7 },
    { 0xA372, 0x03C8 },
    { 0xA373, 0x03C9 },
    { 0xA374, 0x3105 },
    { 0xA375, 0x3106 },
    { 0xA376, 0x3107 },
    { 0xA377, 0x3108 },
    { 0xA378, 0x3109 },
    { 0xA379, 0x310A },
    { 0xA37A, 0x310B },
    { 0xA37B, 0x310C },
    { 0xA37C, 0x310D },
    { 0xA37D, 0x310E },
    { 0xA37E, 0x310F },
    { 0xA3A1, 0x3110 },
    { 0xA3A2, 0x3111 },
    { 0xA3A3, 0x3112 },
    { 0xA3A4, 0x3113 },
    { 0xA3A5, 0x3114 },
    { 0xA3A6, 0x3115 },
    { 0xA3A7, 0x3116 },
    { 0xA3A8, 0x3117 },
    { 0xA3A9, 0x3118 },
    { 0xA3AA, 0x3119 },
    { 0xA3AB, 0x311A },
    { 0xA3AC, 0x311B },
    { 0xA3AD, 0x311C },
    { 0xA3AE, 0x311D },
    { 0xA3AF, 0x311E },
    { 0xA3B0, 0x311F },
    { 0xA3B1, 0x3120 },
    { 0xA3B2, 0x3121 },
    { 0xA3B3, 0x3122 },
    { 0xA3B4, 0x3123 },
    { 0xA3B5, 0x3124 },
    { 0xA3B6, 0x3125 },
    { 0xA3B7, 0x3126 },
    { 0xA3B8, 0x3127 },
    { 0xA3B9, 0x3128 },
    { 0xA3BA, 0x3129 },
    { 0xA3BB, 0x02D9 },
    { 0xA3BC, 0x02C9 },
    { 0xA3BD, 0x02CA },
    { 0xA3BE, 0x02C7 },
    { 0xA3BF, 0x02CB },
    { 0xA440, 0x4E00 },
    { 0xA441, 0x4E59 },
    { 0xA442, 0x4E01 },
    { 0xA443, 0x4E03 },
    { 0xA444, 0x4E43 },
    { 0xA445, 0x4E5D },
    { 0xA446, 0x4E86 },
    { 0xA447, 0x4E8C },
    { 0xA448, 0x4EBA },
    { 0xA449, 0x513F },
    { 0xA44A, 0x5165 },
    { 0xA44B, 0x516B },
    { 0xA44C, 0x51E0 },
    { 0xA44D, 0x5200 },
    { 0xA44E, 0x5201 },
    { 0xA44F, 0x529B },
    { 0xA450, 0x5315 },
    { 0xA451, 0x5341 },
    { 0xA452, 0x535C },
    { 0xA453, 0x53C8 },
    { 0xA454, 0x4E09 },
    { 0xA455, 0x4E0B },
    { 0xA456, 0x4E08 },
    { 0xA457, 0x4E0A },
    { 0xA458, 0x4E2B },
    { 0xA459, 0x4E38 },
    { 0xA45A, 0x51E1 },
    { 0xA45B, 0x4E45 },
    { 0xA45C, 0x4E48 },
    { 0xA45D, 0x4E5F },
    { 0xA45E, 0x4E5E },
    { 0xA45F, 0x4E8E },
    { 0xA460, 0x4EA1 },
    { 0xA461, 0x5140 },
    { 0xA462, 0x5203 },
    { 0xA463, 0x52FA },
    { 0xA464, 0x5343 },
    { 0xA465, 0x53C9 },
    { 0xA466, 0x53E3 },
    { 0xA467, 0x571F },
    { 0xA468, 0x58EB },
    { 0xA469, 0x5915 },
    { 0xA46A, 0x5927 },
    { 0xA46B, 0x5973 },
    { 0xA46C, 0x5B50 },
    { 0xA46D, 0x5B51 },
    { 0xA46E, 0x5B53 },
    { 0xA46F, 0x5BF8 },
    { 0xA470, 0x5C0F },
    { 0xA471, 0x5C22 },
    { 0xA472, 0x5C38 },
    { 0xA473, 0x5C71 },
    { 0xA474, 0x5DDD },
    { 0xA475, 0x5DE5 },
    { 0xA476, 0x5DF1 },
    { 0xA477, 0x5DF2 },
    { 0xA478, 0x5DF3 },
    { 0xA479, 0x5DFE },
    { 0xA47A, 0x5E72 },
    { 0xA47B, 0x5EFE },
    { 0xA47C, 0x5F0B },
    { 0xA47D, 0x5F13 },
    { 0xA47E, 0x624D },
    { 0xA4A1, 0x4E11 },
    { 0xA4A2, 0x4E10 },
    { 0xA4A3, 0x4E0D },
    { 0xA4A4, 0x4E2D },
    { 0xA4A5, 0x4E30 },
    { 0xA4A6, 0x4E39 },
    { 0xA4A7, 0x4E4B },
    { 0xA4A8, 0x5C39 },
    { 0xA4A9, 0x4E88 },
    { 0xA4AA, 0x4E91 },
    { 0xA4AB, 0x4E95 },
    { 0xA4AC, 0x4E92 },
    { 0xA4AD, 0x4E94 },
    { 0xA4AE, 0x4EA2 },
    { 0xA4AF, 0x4EC1 },
    { 0xA4B0, 0x4EC0 },
    { 0xA4B1, 0x4EC3 },
    { 0xA4B2, 0x4EC6 },
    { 0xA4B3, 0x4EC7 },
    { 0xA4B4, 0x4ECD },
    { 0xA4B5, 0x4ECA },
    { 0xA4B6, 0x4ECB },
    { 0xA4B7, 0x4EC4 },
    { 0xA4B8, 0x5143 },
    { 0xA4B9, 0x5141 },
    { 0xA4BA, 0x5167 },
    { 0xA4BB, 0x516D },
    { 0xA4BC, 0x516E },
    { 0xA4BD, 0x516C },
    { 0xA4BE, 0x5197 },
    { 0xA4BF, 0x51F6 },
    { 0xA4C0, 0x5206 },
    { 0xA4C1, 0x5207 },
    { 0xA4C2, 0x5208 },
    { 0xA4C3, 0x52FB },
    { 0xA4C4, 0x52FE },
    { 0xA4C5, 0x52FF },
    { 0xA4C6, 0x5316 },
    { 0xA4C7, 0x5339 },
    { 0xA4C8, 0x5348 },
    { 0xA4C9, 0x5347 },
    { 0xA4CA, 0x5345 },
    { 0xA4CB, 0x535E },
    { 0xA4CC, 0x5384 },
    { 0xA4CD, 0x53CB },
    { 0xA4CE, 0x53CA },
    { 0xA4CF, 0x53CD },
    { 0xA4D0, 0x58EC },
    { 0xA4D1, 0x5929 },
    { 0xA4D2, 0x592B },
    { 0xA4D3, 0x592A },
    { 0xA4D4, 0x592D },
    { 0xA4D5, 0x5B54 },
    { 0xA4D6, 0x5C11 },
    { 0xA4D7, 0x5C24 },
    { 0xA4D8, 0x5C3A },
    { 0xA4D9, 0x5C6F },
    { 0xA4DA, 0x5DF4 },
    { 0xA4DB, 0x5E7B },
    { 0xA4DC, 0x5EFF },
    { 0xA4DD, 0x5F14 },
    { 0xA4DE, 0x5F15 },
    { 0xA4DF, 0x5FC3 },
    { 0xA4E0, 0x6208 },
    { 0xA4E1, 0x6236 },
    { 0xA4E2, 0x624B },
    { 0xA4E3, 0x624E },
    { 0xA4E4, 0x652F },
    { 0xA4E5, 0x6587 },
    { 0xA4E6, 0x6597 },
    { 0xA4E7, 0x65A4 },
    { 0xA4E8, 0x65B9 },
    { 0xA4E9, 0x65E5 },
    { 0xA4EA, 0x66F0 },
    { 0xA4EB, 0x6708 },
    { 0xA4EC, 0x6728 },
    { 0xA4ED, 0x6B20 },
    { 0xA4EE, 0x6B62 },
    { 0xA4EF, 0x6B79 },
    { 0xA4F0, 0x6BCB },
    { 0xA4F1, 0x6BD4 },
    { 0xA4F2, 0x6BDB },
    { 0xA4F3, 0x6C0F },
    { 0xA4F4, 0x6C34 },
    { 0xA4F5, 0x706B },
    { 0xA4F6, 0x722A },
    { 0xA4F7, 0x7236 },
    { 0xA4F8, 0x723B },
    { 0xA4F9, 0x7247 },
    { 0xA4FA, 0x7259 },
    { 0xA4FB, 0x725B },
    { 0xA4FC, 0x72AC },
    { 0xA4FD, 0x738B },
    { 0xA4FE, 0x4E19 },
    { 0xA540, 0x4E16 },
    { 0xA541, 0x4E15 },
    { 0xA542, 0x4E14 },
    { 0xA543, 0x4E18 },
    { 0xA544, 0x4E3B },
    { 0xA545, 0x4E4D },
    { 0xA546, 0x4E4F },
    { 0xA547, 0x4E4E },
    { 0xA548, 0x4EE5 },
    { 0xA549, 0x4ED8 },
    { 0xA54A, 0x4ED4 },
    { 0xA54B, 0x4ED5 },
    { 0xA54C, 0x4ED6 },
    { 0xA54D, 0x4ED7 },
    { 0xA54E, 0x4EE3 },
    { 0xA54F, 0x4EE4 },
    { 0xA550, 0x4ED9 },
    { 0xA551, 0x4EDE },
    { 0xA552, 0x5145 },
    { 0xA553, 0x5144 },
    { 0xA554, 0x5189 },
    { 0xA555, 0x518A },
    { 0xA556, 0x51AC },
    { 0xA557, 0x51F9 },
    { 0xA558, 0x51FA },
    { 0xA559, 0x51F8 },
    { 0xA55A, 0x520A },
    { 0xA55B, 0x52A0 },
    { 0xA55C, 0x529F },
    { 0xA55D, 0x5305 },
    { 0xA55E, 0x5306 },
    { 0xA55F, 0x5317 },
    { 0xA560, 0x531D },
    { 0xA561, 0x4EDF },
    { 0xA562, 0x534A },
    { 0xA563, 0x5349 },
    { 0xA564, 0x5361 },
    { 0xA565, 0x5360 },
    { 0xA566, 0x536F },
    { 0xA567, 0x536E },
    { 0xA568, 0x53BB },
    { 0xA569, 0x53EF },
    { 0xA56A, 0x53E4 },
    { 0xA56B, 0x53F3 },
    { 0xA56C, 0x53EC },
    { 0xA56D, 0x53EE },
    { 0xA56E, 0x53E9 },
    { 0xA56F, 0x53E8 },
    { 0xA570, 0x53FC },
    { 0xA571, 0x53F8 },
    { 0xA572, 0x53F5 },
    { 0xA573, 0x53EB },
    { 0xA574, 0x53E6 },
    { 0xA575, 0x53EA },
    { 0xA576, 0x53F2 },
    { 0xA577, 0x53F1 },
    { 0xA578, 0x53F0 },
    { 0xA579, 0x53E5 },
    { 0xA57A, 0x53ED },
    { 0xA57B, 0x53FB },
    { 0xA57C, 0x56DB },
    { 0xA57D, 0x56DA },
    { 0xA57E, 0x5916 },
    { 0xA5A1, 0x592E },
    { 0xA5A2, 0x5931 },
    { 0xA5A3, 0x5974 },
    { 0xA5A4, 0x5976 },
    { 0xA5A5, 0x5B55 },
    { 0xA5A6, 0x5B83 },
    { 0xA5A7, 0x5C3C },
    { 0xA5A8, 0x5DE8 },
    { 0xA5A9, 0x5DE7 },
    { 0xA5AA, 0x5DE6 },
    { 0xA5AB, 0x5E02 },
    { 0xA5AC, 0x5E03 },
    { 0xA5AD, 0x5E73 },
    { 0xA5AE, 0x5E7C },
    { 0xA5AF, 0x5F01 },
    { 0xA5B0, 0x5F18 },
    { 0xA5B1, 0x5F17 },
    { 0xA5B2, 0x5FC5 },
    { 0xA5B3, 0x620A },
    { 0xA5B4, 0x6253 },
    { 0xA5B5, 0x6254 },
    { 0xA5B6, 0x6252 },
    { 0xA5B7, 0x6251 },
    { 0xA5B8, 0x65A5 },
    { 0xA5B9, 0x65E6 },
    { 0xA5BA, 0x672E },
    { 0xA5BB, 0x672C },
    { 0xA5BC, 0x672A },
    { 0xA5BD, 0x672B },
    { 0xA5BE, 0x672D },
    { 0xA5BF, 0x6B63 },
    { 0xA5C0, 0x6BCD },
    { 0xA5C1, 0x6C11 },
    { 0xA5C2, 0x6C10 },
    { 0xA5C3, 0x6C38 },
    { 0xA5C4, 0x6C41 },
    { 0xA5C5, 0x6C40 },
    { 0xA5C6, 0x6C3E },
    { 0xA5C7, 0x72AF },
    { 0xA5C8, 0x7384 },
    { 0xA5C9, 0x7389 },
    { 0xA5CA, 0x74DC },
    { 0xA5CB, 0x74E6 },
    { 0xA5CC, 0x7518 },
    { 0xA5CD, 0x751F },
    { 0xA5CE, 0x7528 },
    { 0xA5CF, 0x7529 },
    { 0xA5D0, 0x7530 },
    { 0xA5D1, 0x7531 },
    { 0xA5D2, 0x7532 },
    { 0xA5D3, 0x7533 },
    { 0xA5D4, 0x758B },
    { 0xA5D5, 0x767D },
    { 0xA5D6, 0x76AE },
    { 0xA5D7, 0x76BF },
    { 0xA5D8, 0x76EE },
    { 0xA5D9, 0x77DB },
    { 0xA5DA, 0x77E2 },
    { 0xA5DB, 0x77F3 },
    { 0xA5DC, 0x793A },
    { 0xA5DD, 0x79BE },
    { 0xA5DE, 0x7A74 },
    { 0xA5DF, 0x7ACB },
    { 0xA5E0, 0x4E1E },
    { 0xA5E1, 0x4E1F },
    { 0xA5E2, 0x4E52 },
    { 0xA5E3, 0x4E53 },
    { 0xA5E4, 0x4E69 },
    { 0xA5E5, 0x4E99 },
    { 0xA5E6, 0x4EA4 },
    { 0xA5E7, 0x4EA6 },
    { 0xA5E8, 0x4EA5 },
    { 0xA5E9, 0x4EFF },
    { 0xA5EA, 0x4F09 },
    { 0xA5EB, 0x4F19 },
    { 0xA5EC, 0x4F0A },
    { 0xA5ED, 0x4F15 },
    { 0xA5EE, 0x4F0D },
    { 0xA5EF, 0x4F10 },
    { 0xA5F0, 0x4F11 },
    { 0xA5F1, 0x4F0F },
    { 0xA5F2, 0x4EF2 },
    { 0xA5F3, 0x4EF6 },
    { 0xA5F4, 0x4EFB },
    { 0xA5F5, 0x4EF0 },
    { 0xA5F6, 0x4EF3 },
    { 0xA5F7, 0x4EFD },
    { 0xA5F8, 0x4F01 },
    { 0xA5F9, 0x4F0B },
    { 0xA5FA, 0x5149 },
    { 0xA5FB, 0x5147 },
    { 0xA5FC, 0x5146 },
    { 0xA5FD, 0x5148 },
    { 0xA5FE, 0x5168 },
    { 0xA640, 0x5171 },
    { 0xA641, 0x518D },
    { 0xA642, 0x51B0 },
    { 0xA643, 0x5217 },
    { 0xA644, 0x5211 },
    { 0xA645, 0x5212 },
    { 0xA646, 0x520E },
    { 0xA647, 0x5216 },
    { 0xA648, 0x52A3 },
    { 0xA649, 0x5308 },
    { 0xA64A, 0x5321 },
    { 0xA64B, 0x5320 },
    { 0xA64C, 0x5370 },
    { 0xA64D, 0x5371 },
    { 0xA64E, 0x5409 },
    { 0xA64F, 0x540F },
    { 0xA650, 0x540C },
    { 0xA651, 0x540A },
    { 0xA652, 0x5410 },
    { 0xA653, 0x5401 },
    { 0xA654, 0x540B },
    { 0xA655, 0x5404 },
    { 0xA656, 0x5411 },
    { 0xA657, 0x540D },
    { 0xA658, 0x5408 },
    { 0xA659, 0x5403 },
    { 0xA65A, 0x540E },
    { 0xA65B, 0x5406 },
    { 0xA65C, 0x5412 },
    { 0xA65D, 0x56E0 },
    { 0xA65E, 0x56DE },
    { 0xA65F, 0x56DD },
    { 0xA660, 0x5733 },
    { 0xA661, 0x5730 },
    { 0xA662, 0x5728 },
    { 0xA663, 0x572D },
    { 0xA664, 0x572C },
    { 0xA665, 0x572F },
    { 0xA666, 0x5729 },
    { 0xA667, 0x5919 },
    { 0xA668, 0x591A },
    { 0xA669, 0x5937 },
    { 0xA66A, 0x5938 },
    { 0xA66B, 0x5984 },
    { 0xA66C, 0x5978 },
    { 0xA66D, 0x5983 },
    { 0xA66E, 0x597D },
    { 0xA66F, 0x5979 },
    { 0xA670, 0x5982 },
    { 0xA671, 0x5981 },
    { 0xA672, 0x5B57 },
    { 0xA673, 0x5B58 },
    { 0xA674, 0x5B87 },
    { 0xA675, 0x5B88 },
    { 0xA676, 0x5B85 },
    { 0xA677, 0x5B89 },
    { 0xA678, 0x5BFA },
    { 0xA679, 0x5C16 },
    { 0xA67A, 0x5C79 },
    { 0xA67B, 0x5DDE },
    { 0xA67C, 0x5E06 },
    { 0xA67D, 0x5E76 },
    { 0xA67E, 0x5E74 },
    { 0xA6A1, 0x5F0F },
    { 0xA6A2, 0x5F1B },
    { 0xA6A3, 0x5FD9 },
    { 0xA6A4, 0x5FD6 },
    { 0xA6A5, 0x620E },
    { 0xA6A6, 0x620C },
    { 0xA6A7, 0x620D },
    { 0xA6A8, 0x6210 },
    { 0xA6A9, 0x6263 },
    { 0xA6AA, 0x625B },
    { 0xA6AB, 0x6258 },
    { 0xA6AC, 0x6536 },
    { 0xA6AD, 0x65E9 },
    { 0xA6AE, 0x65E8 },
    { 0xA6AF, 0x65EC },
    { 0xA6B0, 0x65ED },
    { 0xA6B1, 0x66F2 },
    { 0xA6B2, 0x66F3 },
    { 0xA6B3, 0x6709 },
    { 0xA6B4, 0x673D },
    { 0xA6B5, 0x6734 },
    { 0xA6B6, 0x6731 },
    { 0xA6B7, 0x6735 },
    { 0xA6B8, 0x6B21 },
    { 0xA6B9, 0x6B64 },
    { 0xA6BA, 0x6B7B },
    { 0xA6BB, 0x6C16 },
    { 0xA6BC, 0x6C5D },
    { 0xA6BD, 0x6C57 },
    { 0xA6BE, 0x6C59 },
    { 0xA6BF, 0x6C5F },
    { 0xA6C0, 0x6C60 },
    { 0xA6C1, 0x6C50 },
    { 0xA6C2, 0x6C55 },
    { 0xA6C3, 0x6C61 },
    { 0xA6C4, 0x6C5B },
    { 0xA6C5, 0x6C4D },
    { 0xA6C6, 0x6C4E },
    { 0xA6C7, 0x7070 },
    { 0xA6C8, 0x725F },
    { 0xA6C9, 0x725D },
    { 0xA6CA, 0x767E },
    { 0xA6CB, 0x7AF9 },
    { 0xA6CC, 0x7C73 },
    { 0xA6CD, 0x7CF8 },
    { 0xA6CE, 0x7F36 },
    { 0xA6CF, 0x7F8A },
    { 0xA6D0, 0x7FBD },
    { 0xA6D1, 0x8001 },
    { 0xA6D2, 0x8003 },
    { 0xA6D3, 0x800C },
    { 0xA6D4, 0x8012 },
    { 0xA6D5, 0x8033 },
    { 0xA6D6, 0x807F },
    { 0xA6D7, 0x8089 },
    { 0xA6D8, 0x808B },
    { 0xA6D9, 0x808C },
    { 0xA6DA, 0x81E3 },
    { 0xA6DB, 0x81EA },
    { 0xA6DC, 0x81F3 },
    { 0xA6DD, 0x81FC },
    { 0xA6DE, 0x820C },
    { 0xA6DF, 0x821B },
    { 0xA6E0, 0x821F },
    { 0xA6E1, 0x826E },
    { 0xA6E2, 0x8272 },
    { 0xA6E3, 0x827E },
    { 0xA6E4, 0x866B },
    { 0xA6E5, 0x8840 },
    { 0xA6E6, 0x884C },
    { 0xA6E7, 0x8863 },
    { 0xA6E8, 0x897F },
    { 0xA6E9, 0x9621 },
    { 0xA6EA, 0x4E32 },
    { 0xA6EB, 0x4EA8 },
    { 0xA6EC, 0x4F4D },
    { 0xA6ED, 0x4F4F },
    { 0xA6EE, 0x4F47 },
    { 0xA6EF, 0x4F57 },
    { 0xA6F0, 0x4F5E },
    { 0xA6F1, 0x4F34 },
    { 0xA6F2, 0x4F5B },
    { 0xA6F3, 0x4F55 },
    { 0xA6F4, 0x4F30 },
    { 0xA6F5, 0x4F50 },
    { 0xA6F6, 0x4F51 },
    { 0xA6F7, 0x4F3D },
    { 0xA6F8, 0x4F3A },
    { 0xA6F9, 0x4F38 },
    { 0xA6FA, 0x4F43 },
    { 0xA6FB, 0x4F54 },
    { 0xA6FC, 0x4F3C },
    { 0xA6FD, 0x4F46 },
    { 0xA6FE, 0x4F63 },
    { 0xA740, 0x4F5C },
    { 0xA741, 0x4F60 },
    { 0xA742, 0x4F2F },
    { 0xA743, 0x4F4E },
    { 0xA744, 0x4F36 },
    { 0xA745, 0x4F59 },
    { 0xA746, 0x4F5D },
    { 0xA747, 0x4F48 },
    { 0xA748, 0x4F5A },
    { 0xA749, 0x514C },
    { 0xA74A, 0x514B },
    { 0xA74B, 0x514D },
    { 0xA74C, 0x5175 },
    { 0xA74D, 0x51B6 },
    { 0xA74E, 0x51B7 },
    { 0xA74F, 0x5225 },
    { 0xA750, 0x5224 },
    { 0xA751, 0x5229 },
    { 0xA752, 0x522A },
    { 0xA753, 0x5228 },
    { 0xA754, 0x52AB },
    { 0xA755, 0x52A9 },
    { 0xA756, 0x52AA },
    { 0xA757, 0x52AC },
    { 0xA758, 0x5323 },
    { 0xA759, 0x5373 },
    { 0xA75A, 0x5375 },
    { 0xA75B, 0x541D },
    { 0xA75C, 0x542D },
    { 0xA75D, 0x541E },
    { 0xA75E, 0x543E },
    { 0xA75F, 0x5426 },
    { 0xA760, 0x544E },
    { 0xA761, 0x5427 },
    { 0xA762, 0x5446 },
    { 0xA763, 0x5443 },
    { 0xA764, 0x5433 },
    { 0xA765, 0x5448 },
    { 0xA766, 0x5442 },
    { 0xA767, 0x541B },
    { 0xA768, 0x5429 },
    { 0xA769, 0x544A },
    { 0xA76A, 0x5439 },
    { 0xA76B, 0x543B },
    { 0xA76C, 0x5438 },
    { 0xA76D, 0x542E },
    { 0xA76E, 0x5435 },
    { 0xA76F, 0x5436 },
    { 0xA770, 0x5420 },
    { 0xA771, 0x543C },
    { 0xA772, 0x5440 },
    { 0xA773, 0x5431 },
    { 0xA774, 0x542B },
    { 0xA775, 0x541F },
    { 0xA776, 0x542C },
    { 0xA777, 0x56EA },
    { 0xA778, 0x56F0 },
    { 0xA779, 0x56E4 },
    { 0xA77A, 0x56EB },
    { 0xA77B, 0x574A },
    { 0xA77C, 0x5751 },
    { 0xA77D, 0x5740 },
    { 0xA77E, 0x574D },
    { 0xA7A1, 0x5747 },
    { 0xA7A2, 0x574E },
    { 0xA7A3, 0x573E },
    { 0xA7A4, 0x5750 },
    { 0xA7A5, 0x574F },
    { 0xA7A6, 0x573B },
    { 0xA7A7, 0x58EF },
    { 0xA7A8, 0x593E },
    { 0xA7A9, 0x599D },
    { 0xA7AA, 0x5992 },
    { 0xA7AB, 0x59A8 },
    { 0xA7AC, 0x599E },
    { 0xA7AD, 0x59A3 },
    { 0xA7AE, 0x5999 },
    { 0xA7AF, 0x5996 },
    { 0xA7B0, 0x598D },
    { 0xA7B1, 0x59A4 },
    { 0xA7B2, 0x5993 },
    { 0xA7B3, 0x598A },
    { 0xA7B4, 0x59A5 },
    { 0xA7B5, 0x5B5D },
    { 0xA7B6, 0x5B5C },
    { 0xA7B7, 0x5B5A },
    { 0xA7B8, 0x5B5B },
    { 0xA7B9, 0x5B8C },
    { 0xA7BA, 0x5B8B },
    { 0xA7BB, 0x5B8F },
    { 0xA7BC, 0x5C2C },
    { 0xA7BD, 0x5C40 },
    { 0xA7BE, 0x5C41 },
    { 0xA7BF, 0x5C3F },
    { 0xA7C0, 0x5C3E },
    { 0xA7C1, 0x5C90 },
    { 0xA7C2, 0x5C91 },
    { 0xA7C3, 0x5C94 },
    { 0xA7C4, 0x5C8C },
    { 0xA7C5, 0x5DEB },
    { 0xA7C6, 0x5E0C },
    { 0xA7C7, 0x5E8F },
    { 0xA7C8, 0x5E87 },
    { 0xA7C9, 0x5E8A },
    { 0xA7CA, 0x5EF7 },
    { 0xA7CB, 0x5F04 },
    { 0xA7CC, 0x5F1F },
    { 0xA7CD, 0x5F64 },
    { 0xA7CE, 0x5F62 },
    { 0xA7CF, 0x5F77 },
    { 0xA7D0, 0x5F79 },
    { 0xA7D1, 0x5FD8 },
    { 0xA7D2, 0x5FCC },
    { 0xA7D3, 0x5FD7 },
    { 0xA7D4, 0x5FCD },
    { 0xA7D5, 0x5FF1 },
    { 0xA7D6, 0x5FEB },
    { 0xA7D7, 0x5FF8 },
    { 0xA7D8, 0x5FEA },
    { 0xA7D9, 0x6212 },
    { 0xA7DA, 0x6211 },
    { 0xA7DB, 0x6284 },
    { 0xA7DC, 0x6297 },
    { 0xA7DD, 0x6296 },
    { 0xA7DE, 0x6280 },
    { 0xA7DF, 0x6276 },
    { 0xA7E0, 0x6289 },
    { 0xA7E1, 0x626D },
    { 0xA7E2, 0x628A },
    { 0xA7E3, 0x627C },
    { 0xA7E4, 0x627E },
    { 0xA7E5, 0x6279 },
    { 0xA7E6, 0x6273 },
    { 0xA7E7, 0x6292 },
    { 0xA7E8, 0x626F },
    { 0xA7E9, 0x6298 },
    { 0xA7EA, 0x626E },
    { 0xA7EB, 0x6295 },
    { 0xA7EC, 0x6293 },
    { 0xA7ED, 0x6291 },
    { 0xA7EE, 0x6286 },
    { 0xA7EF, 0x6539 },
    { 0xA7F0, 0x653B },
    { 0xA7F1, 0x6538 },
    { 0xA7F2, 0x65F1 },
    { 0xA7F3, 0x66F4 },
    { 0xA7F4, 0x675F },
    { 0xA7F5, 0x674E },
    { 0xA7F6, 0x674F },
    { 0xA7F7, 0x6750 },
    { 0xA7F8, 0x6751 },
    { 0xA7F9, 0x675C },
    { 0xA7FA, 0x6756 },
    { 0xA7FB, 0x675E },
    { 0xA7FC, 0x6749 },
    { 0xA7FD, 0x6746 },
    { 0xA7FE, 0x6760 },
    { 0xA840, 0x6753 },
    { 0xA841, 0x6757 },
    { 0xA842, 0x6B65 },
    { 0xA843, 0x6BCF },
    { 0xA844, 0x6C42 },
    { 0xA845, 0x6C5E },
    { 0xA846, 0x6C99 },
    { 0xA847, 0x6C81 },
    { 0xA848, 0x6C88 },
    { 0xA849, 0x6C89 },
    { 0xA84A, 0x6C85 },
    { 0xA84B, 0x6C9B },
    { 0xA84C, 0x6C6A },
    { 0xA84D, 0x6C7A },
    { 0xA84E, 0x6C90 },
    { 0xA84F, 0x6C70 },
    { 0xA850, 0x6C8C },
    { 0xA851, 0x6C68 },
    { 0xA852, 0x6C96 },
    { 0xA853, 0x6C92 },
    { 0xA854, 0x6C7D },
    { 0xA855, 0x6C83 },
    { 0xA856, 0x6C72 },
    { 0xA857, 0x6C7E },
    { 0xA858, 0x6C74 },
    { 0xA859, 0x6C86 },
    { 0xA85A, 0x6C76 },
    { 0xA85B, 0x6C8D },
    { 0xA85C, 0x6C94 },
    { 0xA85D, 0x6C98 },
    { 0xA85E, 0x6C82 },
    { 0xA85F, 0x7076 },
    { 0xA860, 0x707C },
    { 0xA861, 0x707D },
    { 0xA862, 0x7078 },
    { 0xA863, 0x7262 },
    { 0xA864, 0x7261 },
    { 0xA865, 0x7260 },
    { 0xA866, 0x72C4 },
    { 0xA867, 0x72C2 },
    { 0xA868, 0x7396 },
    { 0xA869, 0x752C },
    { 0xA86A, 0x752B },
    { 0xA86B, 0x7537 },
    { 0xA86C, 0x7538 },
    { 0xA86D, 0x7682 },
    { 0xA86E, 0x76EF },
    { 0xA86F, 0x77E3 },
    { 0xA870, 0x79C1 },
    { 0xA871, 0x79C0 },
    { 0xA872, 0x79BF },
    { 0xA873, 0x7A76 },
    { 0xA874, 0x7CFB },
    { 0xA875, 0x7F55 },
    { 0xA876, 0x8096 },
    { 0xA877, 0x8093 },
    { 0xA878, 0x809D },
    { 0xA879, 0x8098 },
    { 0xA87A, 0x809B },
    { 0xA87B, 0x809A },
    { 0xA87C, 0x80B2 },
    { 0xA87D, 0x826F },
    { 0xA87E, 0x8292 },
    { 0xA8A1, 0x828B },
    { 0xA8A2, 0x828D },
    { 0xA8A3, 0x898B },
    { 0xA8A4, 0x89D2 },
    { 0xA8A5, 0x8A00 },
    { 0xA8A6, 0x8C37 },
    { 0xA8A7, 0x8C46 },
    { 0xA8A8, 0x8C55 },
    { 0xA8A9, 0x8C9D },
    { 0xA8AA, 0x8D64 },
    { 0xA8AB, 0x8D70 },
    { 0xA8AC, 0x8DB3 },
    { 0xA8AD, 0x8EAB },
    { 0xA8AE, 0x8ECA },
    { 0xA8AF, 0x8F9B },
    { 0xA8B0, 0x8FB0 },
    { 0xA8B1, 0x8FC2 },
    { 0xA8B2, 0x8FC6 },
    { 0xA8B3, 0x8FC5 },
    { 0xA8B4, 0x8FC4 },
    { 0xA8B5, 0x5DE1 },
    { 0xA8B6, 0x9091 },
    { 0xA8B7, 0x90A2 },
    { 0xA8B8, 0x90AA },
    { 0xA8B9, 0x90A6 },
    { 0xA8BA, 0x90A3 },
    { 0xA8BB, 0x9149 },
    { 0xA8BC, 0x91C6 },
    { 0xA8BD, 0x91CC },
    { 0xA8BE, 0x9632 },
    { 0xA8BF, 0x962E },
    { 0xA8C0, 0x9631 },
    { 0xA8C1, 0x962A },
    { 0xA8C2, 0x962C },
    { 0xA8C3, 0x4E26 },
    { 0xA8C4, 0x4E56 },
    { 0xA8C5, 0x4E73 },
    { 0xA8C6, 0x4E8B },
    { 0xA8C7, 0x4E9B },
    { 0xA8C8, 0x4E9E },
    { 0xA8C9, 0x4EAB },
    { 0xA8CA, 0x4EAC },
    { 0xA8CB, 0x4F6F },
    { 0xA8CC, 0x4F9D },
    { 0xA8CD, 0x4F8D },
    { 0xA8CE, 0x4F73 },
    { 0xA8CF, 0x4F7F },
    { 0xA8D0, 0x4F6C },
    { 0xA8D1, 0x4F9B },
    { 0xA8D2, 0x4F8B },
    { 0xA8D3, 0x4F86 },
    { 0xA8D4, 0x4F83 },
    { 0xA8D5, 0x4F70 },
    { 0xA8D6, 0x4F75 },
    { 0xA8D7, 0x4F88 },
    { 0xA8D8, 0x4F69 },
    { 0xA8D9, 0x4F7B },
    { 0xA8DA, 0x4F96 },
    { 0xA8DB, 0x4F7E },
    { 0xA8DC, 0x4F8F },
    { 0xA8DD, 0x4F91 },
    { 0xA8DE, 0x4F7A },
    { 0xA8DF, 0x5154 },
    { 0xA8E0, 0x5152 },
    { 0xA8E1, 0x5155 },
    { 0xA8E2, 0x5169 },
    { 0xA8E3, 0x5177 },
    { 0xA8E4, 0x5176 },
    { 0xA8E5, 0x5178 },
    { 0xA8E6, 0x51BD },
    { 0xA8E7, 0x51FD },
    { 0xA8E8, 0x523B },
    { 0xA8E9, 0x5238 },
    { 0xA8EA, 0x5237 },
    { 0xA8EB, 0x523A },
    { 0xA8EC, 0x5230 },
    { 0xA8ED, 0x522E },
    { 0xA8EE, 0x5236 },
    { 0xA8EF, 0x5241 },
    { 0xA8F0, 0x52BE },
    { 0xA8F1, 0x52BB },
    { 0xA8F2, 0x5352 },
    { 0xA8F3, 0x5354 },
    { 0xA8F4, 0x5353 },
    { 0xA8F5, 0x5351 },
    { 0xA8F6, 0x5366 },
    { 0xA8F7, 0x5377 },
    { 0xA8F8, 0x5378 },
    { 0xA8F9, 0x5379 },
    { 0xA8FA, 0x53D6 },
    { 0xA8FB, 0x53D4 },
    { 0xA8FC, 0x53D7 },
    { 0xA8FD, 0x5473 },
    { 0xA8FE, 0x5475 },
    { 0xA940, 0x5496 },
    { 0xA941, 0x5478 },
    { 0xA942, 0x5495 },
    { 0xA943, 0x5480 },
    { 0xA944, 0x547B },
    { 0xA945, 0x5477 },
    { 0xA946, 0x5484 },
    { 0xA947, 0x5492 },
    { 0xA948, 0x5486 },
    { 0xA949, 0x547C },
    { 0xA94A, 0x5490 },
    { 0xA94B, 0x5471 },
    { 0xA94C, 0x5476 },
    { 0xA94D, 0x548C },
    { 0xA94E, 0x549A },
    { 0xA94F, 0x5462 },
    { 0xA950, 0x5468 },
    { 0xA951, 0x548B },
    { 0xA952, 0x547D },
    { 0xA953, 0x548E },
    { 0xA954, 0x56FA },
    { 0xA955, 0x5783 },
    { 0xA956, 0x5777 },
    { 0xA957, 0x576A },
    { 0xA958, 0x5769 },
    { 0xA959, 0x5761 },
    { 0xA95A, 0x5766 },
    { 0xA95B, 0x5764 },
    { 0xA95C, 0x577C },
    { 0xA95D, 0x591C },
    { 0xA95E, 0x5949 },
    { 0xA95F, 0x5947 },
    { 0xA960, 0x5948 },
    { 0xA961, 0x5944 },
    { 0xA962, 0x5954 },
    { 0xA963, 0x59BE },
    { 0xA964, 0x59BB },
    { 0xA965, 0x59D4 },
    { 0xA966, 0x59B9 },
    { 0xA967, 0x59AE },
    { 0xA968, 0x59D1 },
    { 0xA969, 0x59C6 },
    { 0xA96A, 0x59D0 },
    { 0xA96B, 0x59CD },
    { 0xA96C, 0x59CB },
    { 0xA96D, 0x59D3 },
    { 0xA96E, 0x59CA },
    { 0xA96F, 0x59AF },
    { 0xA970, 0x59B3 },
    { 0xA971, 0x59D2 },
    { 0xA972, 0x59C5 },
    { 0xA973, 0x5B5F },
    { 0xA974, 0x5B64 },
    { 0xA975, 0x5B63 },
    { 0xA976, 0x5B97 },
    { 0xA977, 0x5B9A },
    { 0xA978, 0x5B98 },
    { 0xA979, 0x5B9C },
    { 0xA97A, 0x5B99 },
    { 0xA97B, 0x5B9B },
    { 0xA97C, 0x5C1A },
    { 0xA97D, 0x5C48 },
    { 0xA97E, 0x5C45 },
    { 0xA9A1, 0x5C46 },
    { 0xA9A2, 0x5CB7 },
    { 0xA9A3, 0x5CA1 },
    { 0xA9A4, 0x5CB8 },
    { 0xA9A5, 0x5CA9 },
    { 0xA9A6, 0x5CAB },
    { 0xA9A7, 0x5CB1 },
    { 0xA9A8, 0x5CB3 },
    { 0xA9A9, 0x5E18 },
    { 0xA9AA, 0x5E1A },
    { 0xA9AB, 0x5E16 },
    { 0xA9AC, 0x5E15 },
    { 0xA9AD, 0x5E1B },
    { 0xA9AE, 0x5E11 },
    { 0xA9AF, 0x5E78 },
    { 0xA9B0, 0x5E9A },
    { 0xA9B1, 0x5E97 },
    { 0xA9B2, 0x5E9C },
    { 0xA9B3, 0x5E95 },
    { 0xA9B4, 0x5E96 },
    { 0xA9B5, 0x5EF6 },
    { 0xA9B6, 0x5F26 },
    { 0xA9B7, 0x5F27 },
    { 0xA9B8, 0x5F29 },
    { 0xA9B9, 0x5F80 },
    { 0xA9BA, 0x5F81 },
    { 0xA9BB, 0x5F7F },
    { 0xA9BC, 0x5F7C },
    { 0xA9BD, 0x5FDD },
    { 0xA9BE, 0x5FE0 },
    { 0xA9BF, 0x5FFD },
    { 0xA9C0, 0x5FF5 },
    { 0xA9C1, 0x5FFF },
    { 0xA9C2, 0x600F },
    { 0xA9C3, 0x6014 },
    { 0xA9C4, 0x602F },
    { 0xA9C5, 0x6035 },
    { 0xA9C6, 0x6016 },
    { 0xA9C7, 0x602A },
    { 0xA9C8, 0x6015 },
    { 0xA9C9, 0x6021 },
    { 0xA9CA, 0x6027 },
    { 0xA9CB, 0x6029 },
    { 0xA9CC, 0x602B },
    { 0xA9CD, 0x601B },
    { 0xA9CE, 0x6216 },
    { 0xA9CF, 0x6215 },
    { 0xA9D0, 0x623F },
    { 0xA9D1, 0x623E },
    { 0xA9D2, 0x6240 },
    { 0xA9D3, 0x627F },
    { 0xA9D4, 0x62C9 },
    { 0xA9D5, 0x62CC },
    { 0xA9D6, 0x62C4 },
    { 0xA9D7, 0x62BF },
    { 0xA9D8, 0x62C2 },
    { 0xA9D9, 0x62B9 },
    { 0xA9DA, 0x62D2 },
    { 0xA9DB, 0x62DB },
    { 0xA9DC, 0x62AB },
    { 0xA9DD, 0x62D3 },
    { 0xA9DE, 0x62D4 },
    { 0xA9DF, 0x62CB },
    { 0xA9E0, 0x62C8 },
    { 0xA9E1, 0x62A8 },
    { 0xA9E2, 0x62BD },
    { 0xA9E3, 0x62BC },
    { 0xA9E4, 0x62D0 },
    { 0xA9E5, 0x62D9 },
    { 0xA9E6, 0x62C7 },
    { 0xA9E7, 0x62CD },
    { 0xA9E8, 0x62B5 },
    { 0xA9E9, 0x62DA },
    { 0xA9EA, 0x62B1 },
    { 0xA9EB, 0x62D8 },
    { 0xA9EC, 0x62D6 },
    { 0xA9ED, 0x62D7 },
    { 0xA9EE, 0x62C6 },
    { 0xA9EF, 0x62AC },
    { 0xA9F0, 0x62CE },
    { 0xA9F1, 0x653E },
    { 0xA9F2, 0x65A7 },
    { 0xA9F3, 0x65BC },
    { 0xA9F4, 0x65FA },
    { 0xA9F5, 0x6614 },
    { 0xA9F6, 0x6613 },
    { 0xA9F7, 0x660C },
    { 0xA9F8, 0x6606 },
    { 0xA9F9, 0x6602 },
    { 0xA9FA, 0x660E },
    { 0xA9FB, 0x6600 },
    { 0xA9FC, 0x660F },
    { 0xA9FD, 0x6615 },
    { 0xA9FE, 0x660A },
    { 0xAA40, 0x6607 },
    { 0xAA41, 0x670D },
    { 0xAA42, 0x670B },
    { 0xAA43, 0x676D },
    { 0xAA44, 0x678B },
    { 0xAA45, 0x6795 },
    { 0xAA46, 0x6771 },
    { 0xAA47, 0x679C },
    { 0xAA48, 0x6773 },
    { 0xAA49, 0x6777 },
    { 0xAA4A, 0x6787 },
    { 0xAA4B, 0x679D },
    { 0xAA4C, 0x6797 },
    { 0xAA4D, 0x676F },
    { 0xAA4E, 0x6770 },
    { 0xAA4F, 0x677F },
    { 0xAA50, 0x6789 },
    { 0xAA51, 0x677E },
    { 0xAA52, 0x6790 },
    { 0xAA53, 0x6775 },
    { 0xAA54, 0x679A },
    { 0xAA55, 0x6793 },
    { 0xAA56, 0x677C },
    { 0xAA57, 0x676A },
    { 0xAA58, 0x6772 },
    { 0xAA59, 0x6B23 },
    { 0xAA5A, 0x6B66 },
    { 0xAA5B, 0x6B67 },
    { 0xAA5C, 0x6B7F },
    { 0xAA5D, 0x6C13 },
    { 0xAA5E, 0x6C1B },
    { 0xAA5F, 0x6CE3 },
    { 0xAA60, 0x6CE8 },
    { 0xAA61, 0x6CF3 },
    { 0xAA62, 0x6CB1 },
    { 0xAA63, 0x6CCC },
    { 0xAA64, 0x6CE5 },
    { 0xAA65, 0x6CB3 },
    { 0xAA66, 0x6CBD },
    { 0xAA67, 0x6CBE },
    { 0xAA68, 0x6CBC },
    { 0xAA69, 0x6CE2 },
    { 0xAA6A, 0x6CAB },
    { 0xAA6B, 0x6CD5 },
    { 0xAA6C, 0x6CD3 },
    { 0xAA6D, 0x6CB8 },
    { 0xAA6E, 0x6CC4 },
    { 0xAA6F, 0x6CB9 },
    { 0xAA70, 0x6CC1 },
    { 0xAA71, 0x6CAE },
    { 0xAA72, 0x6CD7 },
    { 0xAA73, 0x6CC5 },
    { 0xAA74, 0x6CF1 },
    { 0xAA75, 0x6CBF },
    { 0xAA76, 0x6CBB },
    { 0xAA77, 0x6CE1 },
    { 0xAA78, 0x6CDB },
    { 0xAA79, 0x6CCA },
    { 0xAA7A, 0x6CAC },
    { 0xAA7B, 0x6CEF },
    { 0xAA7C, 0x6CDC },
    { 0xAA7D, 0x6CD6 },
    { 0xAA7E, 0x6CE0 },
    { 0xAAA1, 0x7095 },
    { 0xAAA2, 0x708E },
    { 0xAAA3, 0x7092 },
    { 0xAAA4, 0x708A },
    { 0xAAA5, 0x7099 },
    { 0xAAA6, 0x722C },
    { 0xAAA7, 0x722D },
    { 0xAAA8, 0x7238 },
    { 0xAAA9, 0x7248 },
    { 0xAAAA, 0x7267 },
    { 0xAAAB, 0x7269 },
    { 0xAAAC, 0x72C0 },
    { 0xAAAD, 0x72CE },
    { 0xAAAE, 0x72D9 },
    { 0xAAAF, 0x72D7 },
    { 0xAAB0, 0x72D0 },
    { 0xAAB1, 0x73A9 },
    { 0xAAB2, 0x73A8 },
    { 0xAAB3, 0x739F },
    { 0xAAB4, 0x73AB },
    { 0xAAB5, 0x73A5 },
    { 0xAAB6, 0x753D },
    { 0xAAB7, 0x759D },
    { 0xAAB8, 0x7599 },
    { 0xAAB9, 0x759A },
    { 0xAABA, 0x7684 },
    { 0xAABB, 0x76C2 },
    { 0xAABC, 0x76F2 },
    { 0xAABD, 0x76F4 },
    { 0xAABE, 0x77E5 },
    { 0xAABF, 0x77FD },
    { 0xAAC0, 0x793E },
    { 0xAAC1, 0x7940 },
    { 0xAAC2, 0x7941 },
    { 0xAAC3, 0x79C9 },
    { 0xAAC4, 0x79C8 },
    { 0xAAC5, 0x7A7A },
    { 0xAAC6, 0x7A79 },
    { 0xAAC7, 0x7AFA },
    { 0xAAC8, 0x7CFE },
    { 0xAAC9, 0x7F54 },
    { 0xAACA, 0x7F8C },
    { 0xAACB, 0x7F8B },
    { 0xAACC, 0x8005 },
    { 0xAACD, 0x80BA },
    { 0xAACE, 0x80A5 },
    { 0xAACF, 0x80A2 },
    { 0xAAD0, 0x80B1 },
    { 0xAAD1, 0x80A1 },
    { 0xAAD2, 0x80AB },
    { 0xAAD3, 0x80A9 },
    { 0xAAD4, 0x80B4 },
    { 0xAAD5, 0x80AA },
    { 0xAAD6, 0x80AF },
    { 0xAAD7, 0x81E5 },
    { 0xAAD8, 0x81FE },
    { 0xAAD9, 0x820D },
    { 0xAADA, 0x82B3 },
    { 0xAADB, 0x829D },
    { 0xAADC, 0x8299 },
    { 0xAADD, 0x82AD },
    { 0xAADE, 0x82BD },
    { 0xAADF, 0x829F },
    { 0xAAE0, 0x82B9 },
    { 0xAAE1, 0x82B1 },
    { 0xAAE2, 0x82AC },
    { 0xAAE3, 0x82A5 },
    { 0xAAE4, 0x82AF },
    { 0xAAE5, 0x82B8 },
    { 0xAAE6, 0x82A3 },
    { 0xAAE7, 0x82B0 },
    { 0xAAE8, 0x82BE },
    { 0xAAE9, 0x82B7 },
    { 0xAAEA, 0x864E },
    { 0xAAEB, 0x8671 },
    { 0xAAEC, 0x521D },
    { 0xAAED, 0x8868 },
    { 0xAAEE, 0x8ECB },
    { 0xAAEF, 0x8FCE },
    { 0xAAF0, 0x8FD4 },
    { 0xAAF1, 0x8FD1 },
    { 0xAAF2, 0x90B5 },
    { 0xAAF3, 0x90B8 },
    { 0xAAF4, 0x90B1 },
    { 0xAAF5, 0x90B6 },
    { 0xAAF6, 0x91C7 },
    { 0xAAF7, 0x91D1 },
    { 0xAAF8, 0x9577 },
    { 0xAAF9, 0x9580 },
    { 0xAAFA, 0x961C },
    { 0xAAFB, 0x9640 },
    { 0xAAFC, 0x963F },
    { 0xAAFD, 0x963B },
    { 0xAAFE, 0x9644 },
    { 0xAB40, 0x9642 },
    { 0xAB41, 0x96B9 },
    { 0xAB42, 0x96E8 },
    { 0xAB43, 0x9752 },
    { 0xAB44, 0x975E },
    { 0xAB45, 0x4E9F },
    { 0xAB46, 0x4EAD },
    { 0xAB47, 0x4EAE },
    { 0xAB48, 0x4FE1 },
    { 0xAB49, 0x4FB5 },
    { 0xAB4A, 0x4FAF },
    { 0xAB4B, 0x4FBF },
    { 0xAB4C, 0x4FE0 },
    { 0xAB4D, 0x4FD1 },
    { 0xAB4E, 0x4FCF },
    { 0xAB4F, 0x4FDD },
    { 0xAB50, 0x4FC3 },
    { 0xAB51, 0x4FB6 },
    { 0xAB52, 0x4FD8 },
    { 0xAB53, 0x4FDF },
    { 0xAB54, 0x4FCA },
    { 0xAB55, 0x4FD7 },
    { 0xAB56, 0x4FAE },
    { 0xAB57, 0x4FD0 },
    { 0xAB58, 0x4FC4 },
    { 0xAB59, 0x4FC2 },
    { 0xAB5A, 0x4FDA },
    { 0xAB5B, 0x4FCE },
    { 0xAB5C, 0x4FDE },
    { 0xAB5D, 0x4FB7 },
    { 0xAB5E, 0x5157 },
    { 0xAB5F, 0x5192 },
    { 0xAB60, 0x5191 },
    { 0xAB61, 0x51A0 },
    { 0xAB62, 0x524E },
    { 0xAB63, 0x5243 },
    { 0xAB64, 0x524A },
    { 0xAB65, 0x524D },
    { 0xAB66, 0x524C },
    { 0xAB67, 0x524B },
    { 0xAB68, 0x5247 },
    { 0xAB69, 0x52C7 },
    { 0xAB6A, 0x52C9 },
    { 0xAB6B, 0x52C3 },
    { 0xAB6C, 0x52C1 },
    { 0xAB6D, 0x530D },
    { 0xAB6E, 0x5357 },
    { 0xAB6F, 0x537B },
    { 0xAB70, 0x539A },
    { 0xAB71, 0x53DB },
    { 0xAB72, 0x54AC },
    { 0xAB73, 0x54C0 },
    { 0xAB74, 0x54A8 },
    { 0xAB75, 0x54CE },
    { 0xAB76, 0x54C9 },
    { 0xAB77, 0x54B8 },
    { 0xAB78, 0x54A6 },
    { 0xAB79, 0x54B3 },
    { 0xAB7A, 0x54C7 },
    { 0xAB7B, 0x54C2 },
    { 0xAB7C, 0x54BD },
    { 0xAB7D, 0x54AA },
    { 0xAB7E, 0x54C1 },
    { 0xABA1, 0x54C4 },
    { 0xABA2, 0x54C8 },
    { 0xABA3, 0x54AF },
    { 0xABA4, 0x54AB },
    { 0xABA5, 0x54B1 },
    { 0xABA6, 0x54BB },
    { 0xABA7, 0x54A9 },
    { 0xABA8, 0x54A7 },
    { 0xABA9, 0x54BF },
    { 0xABAA, 0x56FF },
    { 0xABAB, 0x5782 },
    { 0xABAC, 0x578B },
    { 0xABAD, 0x57A0 },
    { 0xABAE, 0x57A3 },
    { 0xABAF, 0x57A2 },
    { 0xABB0, 0x57CE },
    { 0xABB1, 0x57AE },
    { 0xABB2, 0x5793 },
    { 0xABB3, 0x5955 },
    { 0xABB4, 0x5951 },
    { 0xABB5, 0x594F },
    { 0xABB6, 0x594E },
    { 0xABB7, 0x5950 },
    { 0xABB8, 0x59DC },
    { 0xABB9, 0x59D8 },
    { 0xABBA, 0x59FF },
    { 0xABBB, 0x59E3 },
    { 0xABBC, 0x59E8 },
    { 0xABBD, 0x5A03 },
    { 0xABBE, 0x59E5 },
    { 0xABBF, 0x59EA },
    { 0xABC0, 0x59DA },
    { 0xABC1, 0x59E6 },
    { 0xABC2, 0x5A01 },
    { 0xABC3, 0x59FB },
    { 0xABC4, 0x5B69 },
    { 0xABC5, 0x5BA3 },
    { 0xABC6, 0x5BA6 },
    { 0xABC7, 0x5BA4 },
    { 0xABC8, 0x5BA2 },
    { 0xABC9, 0x5BA5 },
    { 0xABCA, 0x5C01 },
    { 0xABCB, 0x5C4E },
    { 0xABCC, 0x5C4F },
    { 0xABCD, 0x5C4D },
    { 0xABCE, 0x5C4B },
    { 0xABCF, 0x5CD9 },
    { 0xABD0, 0x5CD2 },
    { 0xABD1, 0x5DF7 },
    { 0xABD2, 0x5E1D },
    { 0xABD3, 0x5E25 },
    { 0xABD4, 0x5E1F },
    { 0xABD5, 0x5E7D },
    { 0xABD6, 0x5EA0 },
    { 0xABD7, 0x5EA6 },
    { 0xABD8, 0x5EFA },
    { 0xABD9, 0x5F08 },
    { 0xABDA, 0x5F2D },
    { 0xABDB, 0x5F65 },
    { 0xABDC, 0x5F88 },
    { 0xABDD, 0x5F85 },
    { 0xABDE, 0x5F8A },
    { 0xABDF, 0x5F8B },
    { 0xABE0, 0x5F87 },
    { 0xABE1, 0x5F8C },
    { 0xABE2, 0x5F89 },
    { 0xABE3, 0x6012 },
    { 0xABE4, 0x601D },
    { 0xABE5, 0x6020 },
    { 0xABE6, 0x6025 },
    { 0xABE7, 0x600E },
    { 0xABE8, 0x6028 },
    { 0xABE9, 0x604D },
    { 0xABEA, 0x6070 },
    { 0xABEB, 0x6068 },
    { 0xABEC, 0x6062 },
    { 0xABED, 0x6046 },
    { 0xABEE, 0x6043 },
    { 0xABEF, 0x606C },
    { 0xABF0, 0x606B },
    { 0xABF1, 0x606A },
    { 0xABF2, 0x6064 },
    { 0xABF3, 0x6241 },
    { 0xABF4, 0x62DC },
    { 0xABF5, 0x6316 },
    { 0xABF6, 0x6309 },
    { 0xABF7, 0x62FC },
    { 0xABF8, 0x62ED },
    { 0xABF9, 0x6301 },
    { 0xABFA, 0x62EE },
    { 0xABFB, 0x62FD },
    { 0xABFC, 0x6307 },
    { 0xABFD, 0x62F1 },
    { 0xABFE, 0x62F7 },
    { 0xAC40, 0x62EF },
    { 0xAC41, 0x62EC },
    { 0xAC42, 0x62FE },
    { 0xAC43, 0x62F4 },
    { 0xAC44, 0x6311 },
    { 0xAC45, 0x6302 },
    { 0xAC46, 0x653F },
    { 0xAC47, 0x6545 },
    { 0xAC48, 0x65AB },
    { 0xAC49, 0x65BD },
    { 0xAC4A, 0x65E2 },
    { 0xAC4B, 0x6625 },
    { 0xAC4C, 0x662D },
    { 0xAC4D, 0x6620 },
    { 0xAC4E, 0x6627 },
    { 0xAC4F, 0x662F },
    { 0xAC50, 0x661F },
    { 0xAC51, 0x6628 },
    { 0xAC52, 0x6631 },
    { 0xAC53, 0x6624 },
    { 0xAC54, 0x66F7 },
    { 0xAC55, 0x67FF },
    { 0xAC56, 0x67D3 },
    { 0xAC57, 0x67F1 },
    { 0xAC58, 0x67D4 },
    { 0xAC59, 0x67D0 },
    { 0xAC5A, 0x67EC },
    { 0xAC5B, 0x67B6 },
    { 0xAC5C, 0x67AF },
    { 0xAC5D, 0x67F5 },
    { 0xAC5E, 0x67E9 },
    { 0xAC5F, 0x67EF },
    { 0xAC60, 0x67C4 },
    { 0xAC61, 0x67D1 },
    { 0xAC62, 0x67B4 },
    { 0xAC63, 0x67DA },
    { 0xAC64, 0x67E5 },
    { 0xAC65, 0x67B8 },
    { 0xAC66, 0x67CF },
    { 0xAC67, 0x67DE },
    { 0xAC68, 0x67F3 },
    { 0xAC69, 0x67B0 },
    { 0xAC6A, 0x67D9 },
    { 0xAC6B, 0x67E2 },
    { 0xAC6C, 0x67DD },
    { 0xAC6D, 0x67D2 },
    { 0xAC6E, 0x6B6A },
    { 0xAC6F, 0x6B83 },
    { 0xAC70, 0x6B86 },
    { 0xAC71, 0x6BB5 },
    { 0xAC72, 0x6BD2 },
    { 0xAC73, 0x6BD7 },
    { 0xAC74, 0x6C1F },
    { 0xAC75, 0x6CC9 },
    { 0xAC76, 0x6D0B },
    { 0xAC77, 0x6D32 },
    { 0xAC78, 0x6D2A },
    { 0xAC79, 0x6D41 },
    { 0xAC7A, 0x6D25 },
    { 0xAC7B, 0x6D0C },
    { 0xAC7C, 0x6D31 },
    { 0xAC7D, 0x6D1E },
    { 0xAC7E, 0x6D17 },
    { 0xACA1, 0x6D3B },
    { 0xACA2, 0x6D3D },
    { 0xACA3, 0x6D3E },
    { 0xACA4, 0x6D36 },
    { 0xACA5, 0x6D1B },
    { 0xACA6, 0x6CF5 },
    { 0xACA7, 0x6D39 },
    { 0xACA8, 0x6D27 },
    { 0xACA9, 0x6D38 },
    { 0xACAA, 0x6D29 },
    { 0xACAB, 0x6D2E },
    { 0xACAC, 0x6D35 },
    { 0xACAD, 0x6D0E },
    { 0xACAE, 0x6D2B },
    { 0xACAF, 0x70AB },
    { 0xACB0, 0x70BA },
    { 0xACB1, 0x70B3 },
    { 0xACB2, 0x70AC },
    { 0xACB3, 0x70AF },
    { 0xACB4, 0x70AD },
    { 0xACB5, 0x70B8 },
    { 0xACB6, 0x70AE },
    { 0xACB7, 0x70A4 },
    { 0xACB8, 0x7230 },
    { 0xACB9, 0x7272 },
    { 0xACBA, 0x726F },
    { 0xACBB, 0x7274 },
    { 0xACBC, 0x72E9 },
    { 0xACBD, 0x72E0 },
    { 0xACBE, 0x72E1 },
    { 0xACBF, 0x73B7 },
    { 0xACC0, 0x73CA },
    { 0xACC1, 0x73BB },
    { 0xACC2, 0x73B2 },
    { 0xACC3, 0x73CD },
    { 0xACC4, 0x73C0 },
    { 0xACC5, 0x73B3 },
    { 0xACC6, 0x751A },
    { 0xACC7, 0x752D },
    { 0xACC8, 0x754F },
    { 0xACC9, 0x754C },
    { 0xACCA, 0x754E },
    { 0xACCB, 0x754B },
    { 0xACCC, 0x75AB },
    { 0xACCD, 0x75A4 },
    { 0xACCE, 0x75A5 },
    { 0xACCF, 0x75A2 },
    { 0xACD0, 0x75A3 },
    { 0xACD1, 0x7678 },
    { 0xACD2, 0x7686 },
    { 0xACD3, 0x7687 },
    { 0xACD4, 0x7688 },
    { 0xACD5, 0x76C8 },
    { 0xACD6, 0x76C6 },
    { 0xACD7, 0x76C3 },
    { 0xACD8, 0x76C5 },
    { 0xACD9, 0x7701 },
    { 0xACDA, 0x76F9 },
    { 0xACDB, 0x76F8 },
    { 0xACDC, 0x7709 },
    { 0xACDD, 0x770B },
    { 0xACDE, 0x76FE },
    { 0xACDF, 0x76FC },
    { 0xACE0, 0x7707 },
    { 0xACE1, 0x77DC },
    { 0xACE2, 0x7802 },
    { 0xACE3, 0x7814 },
    { 0xACE4, 0x780C },
    { 0xACE5, 0x780D },
    { 0xACE6, 0x7946 },
    { 0xACE7, 0x7949 },
    { 0xACE8, 0x7948 },
    { 0xACE9, 0x7947 },
    { 0xACEA, 0x79B9 },
    { 0xACEB, 0x79BA },
    { 0xACEC, 0x79D1 },
    { 0xACED, 0x79D2 },
    { 0xACEE, 0x79CB },
    { 0xACEF, 0x7A7F },
    { 0xACF0, 0x7A81 },
    { 0xACF1, 0x7AFF },
    { 0xACF2, 0x7AFD },
    { 0xACF3, 0x7C7D },
    { 0xACF4, 0x7D02 },
    { 0xACF5, 0x7D05 },
    { 0xACF6, 0x7D00 },
    { 0xACF7, 0x7D09 },
    { 0xACF8, 0x7D07 },
    { 0xACF9, 0x7D04 },
    { 0xACFA, 0x7D06 },
    { 0xACFB, 0x7F38 },
    { 0xACFC, 0x7F8E },
    { 0xACFD, 0x7FBF },
    { 0xACFE, 0x8004 },
    { 0xAD40, 0x8010 },
    { 0xAD41, 0x800D },
    { 0xAD42, 0x8011 },
    { 0xAD43, 0x8036 },
    { 0xAD44, 0x80D6 },
    { 0xAD45, 0x80E5 },
    { 0xAD46, 0x80DA },
    { 0xAD47, 0x80C3 },
    { 0xAD48, 0x80C4 },
    { 0xAD49, 0x80CC },
    { 0xAD4A, 0x80E1 },
    { 0xAD4B, 0x80DB },
    { 0xAD4C, 0x80CE },
    { 0xAD4D, 0x80DE },
    { 0xAD4E, 0x80E4 },
    { 0xAD4F, 0x80DD },
    { 0xAD50, 0x81F4 },
    { 0xAD51, 0x8222 },
    { 0xAD52, 0x82E7 },
    { 0xAD53, 0x8303 },
    { 0xAD54, 0x8305 },
    { 0xAD55, 0x82E3 },
    { 0xAD56, 0x82DB },
    { 0xAD57, 0x82E6 },
    { 0xAD58, 0x8304 },
    { 0xAD59, 0x82E5 },
    { 0xAD5A, 0x8302 },
    { 0xAD5B, 0x8309 },
    { 0xAD5C, 0x82D2 },
    { 0xAD5D, 0x82D7 },
    { 0xAD5E, 0x82F1 },
    { 0xAD5F, 0x8301 },
    { 0xAD60, 0x82DC },
    { 0xAD61, 0x82D4 },
    { 0xAD62, 0x82D1 },
    { 0xAD63, 0x82DE },
    { 0xAD64, 0x82D3 },
    { 0xAD65, 0x82DF },
    { 0xAD66, 0x82EF },
    { 0xAD67, 0x8306 },
    { 0xAD68, 0x8650 },
    { 0xAD69, 0x8679 },
    { 0xAD6A, 0x867B },
    { 0xAD6B, 0x867A },
    { 0xAD6C, 0x884D },
    { 0xAD6D, 0x886B },
    { 0xAD6E, 0x8981 },
    { 0xAD6F, 0x89D4 },
    { 0xAD70, 0x8A08 },
    { 0xAD71, 0x8A02 },
    { 0xAD72, 0x8A03 },
    { 0xAD73, 0x8C9E },
    { 0xAD74, 0x8CA0 },
    { 0xAD75, 0x8D74 },
    { 0xAD76, 0x8D73 },
    { 0xAD77, 0x8DB4 },
    { 0xAD78, 0x8ECD },
    { 0xAD79, 0x8ECC },
    { 0xAD7A, 0x8FF0 },
    { 0xAD7B, 0x8FE6 },
    { 0xAD7C, 0x8FE2 },
    { 0xAD7D, 0x8FEA },
    { 0xAD7E, 0x8FE5 },
    { 0xADA1, 0x8FED },
    { 0xADA2, 0x8FEB },
    { 0xADA3, 0x8FE4 },
    { 0xADA4, 0x8FE8 },
    { 0xADA5, 0x90CA },
    { 0xADA6, 0x90CE },
    { 0xADA7, 0x90C1 },
    { 0xADA8, 0x90C3 },
    { 0xADA9, 0x914B },
    { 0xADAA, 0x914A },
    { 0xADAB, 0x91CD },
    { 0xADAC, 0x9582 },
    { 0xADAD, 0x9650 },
    { 0xADAE, 0x964B },
    { 0xADAF, 0x964C },
    { 0xADB0, 0x964D },
    { 0xADB1, 0x9762 },
    { 0xADB2, 0x9769 },
    { 0xADB3, 0x97CB },
    { 0xADB4, 0x97ED },
    { 0xADB5, 0x97F3 },
    { 0xADB6, 0x9801 },
    { 0xADB7, 0x98A8 },
    { 0xADB8, 0x98DB },
    { 0xADB9, 0x98DF },
    { 0xADBA, 0x9996 },
    { 0xADBB, 0x9999 },
    { 0xADBC, 0x4E58 },
    { 0xADBD, 0x4EB3 },
    { 0xADBE, 0x500C },
    { 0xADBF, 0x500D },
    { 0xADC0, 0x5023 },
    { 0xADC1, 0x4FEF },
    { 0xADC2, 0x5026 },
    { 0xADC3, 0x5025 },
    { 0xADC4, 0x4FF8 },
    { 0xADC5, 0x5029 },
    { 0xADC6, 0x5016 },
    { 0xADC7, 0x5006 },
    { 0xADC8, 0x503C },
    { 0xADC9, 0x501F },
    { 0xADCA, 0x501A },
    { 0xADCB, 0x5012 },
    { 0xADCC, 0x5011 },
    { 0xADCD, 0x4FFA },
    { 0xADCE, 0x5000 },
    { 0xADCF, 0x5014 },
    { 0xADD0, 0x5028 },
    { 0xADD1, 0x4FF1 },
    { 0xADD2, 0x5021 },
    { 0xADD3, 0x500B },
    { 0xADD4, 0x5019 },
    { 0xADD5, 0x5018 },
    { 0xADD6, 0x4FF3 },
    { 0xADD7, 0x4FEE },
    { 0xADD8, 0x502D },
    { 0xADD9, 0x502A },
    { 0xADDA, 0x4FFE },
    { 0xADDB, 0x502B },
    { 0xADDC, 0x5009 },
    { 0xADDD, 0x517C },
    { 0xADDE, 0x51A4 },
    { 0xADDF, 0x51A5 },
    { 0xADE0, 0x51A2 },
    { 0xADE1, 0x51CD },
    { 0xADE2, 0x51CC },
    { 0xADE3, 0x51C6 },
    { 0xADE4, 0x51CB },
    { 0xADE5, 0x5256 },
    { 0xADE6, 0x525C },
    { 0xADE7, 0x5254 },
    { 0xADE8, 0x525B },
    { 0xADE9, 0x525D },
    { 0xADEA, 0x532A },
    { 0xADEB, 0x537F },
    { 0xADEC, 0x539F },
    { 0xADED, 0x539D },
    { 0xADEE, 0x53DF },
    { 0xADEF, 0x54E8 },
    { 0xADF0, 0x5510 },
    { 0xADF1, 0x5501 },
    { 0xADF2, 0x5537 },
    { 0xADF3, 0x54FC },
    { 0xADF4, 0x54E5 },
    { 0xADF5, 0x54F2 },
    { 0xADF6, 0x5506 },
    { 0xADF7, 0x54FA },
    { 0xADF8, 0x5514 },
    { 0xADF9, 0x54E9 },
    { 0xADFA, 0x54ED },
    { 0xADFB, 0x54E1 },
    { 0xADFC, 0x5509 },
    { 0xADFD, 0x54EE },
    { 0xADFE, 0x54EA },
    { 0xAE40, 0x54E6 },
    { 0xAE41, 0x5527 },
    { 0xAE42, 0x5507 },
    { 0xAE43, 0x54FD },
    { 0xAE44, 0x550F },
    { 0xAE45, 0x5703 },
    { 0xAE46, 0x5704 },
    { 0xAE47, 0x57C2 },
    { 0xAE48, 0x57D4 },
    { 0xAE49, 0x57CB },
    { 0xAE4A, 0x57C3 },
    { 0xAE4B, 0x5809 },
    { 0xAE4C, 0x590F },
    { 0xAE4D, 0x5957 },
    { 0xAE4E, 0x5958 },
    { 0xAE4F, 0x595A },
    { 0xAE50, 0x5A11 },
    { 0xAE51, 0x5A18 },
    { 0xAE52, 0x5A1C },
    { 0xAE53, 0x5A1F },
    { 0xAE54, 0x5A1B },
    { 0xAE55, 0x5A13 },
    { 0xAE56, 0x59EC },
    { 0xAE57, 0x5A20 },
    { 0xAE58, 0x5A23 },
    { 0xAE59, 0x5A29 },
    { 0xAE5A, 0x5A25 },
    { 0xAE5B, 0x5A0C },
    { 0xAE5C, 0x5A09 },
    { 0xAE5D, 0x5B6B },
    { 0xAE5E, 0x5C58 },
    { 0xAE5F, 0x5BB0 },
    { 0xAE60, 0x5BB3 },
    { 0xAE61, 0x5BB6 },
    { 0xAE62, 0x5BB4 },
    { 0xAE63, 0x5BAE },
    { 0xAE64, 0x5BB5 },
    { 0xAE65, 0x5BB9 },
    { 0xAE66, 0x5BB8 },
    { 0xAE67, 0x5C04 },
    { 0xAE68, 0x5C51 },
    { 0xAE69, 0x5C55 },
    { 0xAE6A, 0x5C50 },
    { 0xAE6B, 0x5CED },
    { 0xAE6C, 0x5CFD },
    { 0xAE6D, 0x5CFB },
    { 0xAE6E, 0x5CEA },
    { 0xAE6F, 0x5CE8 },
    { 0xAE70, 0x5CF0 },
    { 0xAE71, 0x5CF6 },
    { 0xAE72, 0x5D01 },
    { 0xAE73, 0x5CF4 },
    { 0xAE74, 0x5DEE },
    { 0xAE75, 0x5E2D },
    { 0xAE76, 0x5E2B },
    { 0xAE77, 0x5EAB },
    { 0xAE78, 0x5EAD },
    { 0xAE79, 0x5EA7 },
    { 0xAE7A, 0x5F31 },
    { 0xAE7B, 0x5F92 },
    { 0xAE7C, 0x5F91 },
    { 0xAE7D, 0x5F90 },
    { 0xAE7E, 0x6059 },
    { 0xAEA1, 0x6063 },
    { 0xAEA2, 0x6065 },
    { 0xAEA3, 0x6050 },
    { 0xAEA4, 0x6055 },
    { 0xAEA5, 0x606D },
    { 0xAEA6, 0x6069 },
    { 0xAEA7, 0x606F },
    { 0xAEA8, 0x6084 },
    { 0xAEA9, 0x609F },
    { 0xAEAA, 0x609A },
    { 0xAEAB, 0x608D },
    { 0xAEAC, 0x6094 },
    { 0xAEAD, 0x608C },
    { 0xAEAE, 0x6085 },
    { 0xAEAF, 0x6096 },
    { 0xAEB0, 0x6247 },
    { 0xAEB1, 0x62F3 },
    { 0xAEB2, 0x6308 },
    { 0xAEB3, 0x62FF },
    { 0xAEB4, 0x634E },
    { 0xAEB5, 0x633E },
    { 0xAEB6, 0x632F },
    { 0xAEB7, 0x6355 },
    { 0xAEB8, 0x6342 },
    { 0xAEB9, 0x6346 },
    { 0xAEBA, 0x634F },
    { 0xAEBB, 0x6349 },
    { 0xAEBC, 0x633A },
    { 0xAEBD, 0x6350 },
    { 0xAEBE, 0x633D },
    { 0xAEBF, 0x632A },
    { 0xAEC0, 0x632B },
    { 0xAEC1, 0x6328 },
    { 0xAEC2, 0x634D },
    { 0xAEC3, 0x634C },
    { 0xAEC4, 0x6548 },
    { 0xAEC5, 0x6549 },
    { 0xAEC6, 0x6599 },
    { 0xAEC7, 0x65C1 },
    { 0xAEC8, 0x65C5 },
    { 0xAEC9, 0x6642 },
    { 0xAECA, 0x6649 },
    { 0xAECB, 0x664F },
    { 0xAECC, 0x6643 },
    { 0xAECD, 0x6652 },
    { 0xAECE, 0x664C },
    { 0xAECF, 0x6645 },
    { 0xAED0, 0x6641 },
    { 0xAED1, 0x66F8 },
    { 0xAED2, 0x6714 },
    { 0xAED3, 0x6715 },
    { 0xAED4, 0x6717 },
    { 0xAED5, 0x6821 },
    { 0xAED6, 0x6838 },
    { 0xAED7, 0x6848 },
    { 0xAED8, 0x6846 },
    { 0xAED9, 0x6853 },
    { 0xAEDA, 0x6839 },
    { 0xAEDB, 0x6842 },
    { 0xAEDC, 0x6854 },
    { 0xAEDD, 0x6829 },
    { 0xAEDE, 0x68B3 },
    { 0xAEDF, 0x6817 },
    { 0xAEE0, 0x684C },
    { 0xAEE1, 0x6851 },
    { 0xAEE2, 0x683D },
    { 0xAEE3, 0x67F4 },
    { 0xAEE4, 0x6850 },
    { 0xAEE5, 0x6840 },
    { 0xAEE6, 0x683C },
    { 0xAEE7, 0x6843 },
    { 0xAEE8, 0x682A },
    { 0xAEE9, 0x6845 },
    { 0xAEEA, 0x6813 },
    { 0xAEEB, 0x6818 },
    { 0xAEEC, 0x6841 },
    { 0xAEED, 0x6B8A },
    { 0xAEEE, 0x6B89 },
    { 0xAEEF, 0x6BB7 },
    { 0xAEF0, 0x6C23 },
    { 0xAEF1, 0x6C27 },
    { 0xAEF2, 0x6C28 },
    { 0xAEF3, 0x6C26 },
    { 0xAEF4, 0x6C24 },
    { 0xAEF5, 0x6CF0 },
    { 0xAEF6, 0x6D6A },
    { 0xAEF7, 0x6D95 },
    { 0xAEF8, 0x6D88 },
    { 0xAEF9, 0x6D87 },
    { 0xAEFA, 0x6D66 },
    { 0xAEFB, 0x6D78 },
    { 0xAEFC, 0x6D77 },
    { 0xAEFD, 0x6D59 },
    { 0xAEFE, 0x6D93 },
    { 0xAF40, 0x6D6C },
    { 0xAF41, 0x6D89 },
    { 0xAF42, 0x6D6E },
    { 0xAF43, 0x6D5A },
    { 0xAF44, 0x6D74 },
    { 0xAF45, 0x6D69 },
    { 0xAF46, 0x6D8C },
    { 0xAF47, 0x6D8A },
    { 0xAF48, 0x6D79 },
    { 0xAF49, 0x6D85 },
    { 0xAF4A, 0x6D65 },
    { 0xAF4B, 0x6D94 },
    { 0xAF4C, 0x70CA },
    { 0xAF4D, 0x70D8 },
    { 0xAF4E, 0x70E4 },
    { 0xAF4F, 0x70D9 },
    { 0xAF50, 0x70C8 },
    { 0xAF51, 0x70CF },
    { 0xAF52, 0x7239 },
    { 0xAF53, 0x7279 },
    { 0xAF54, 0x72FC },
    { 0xAF55, 0x72F9 },
    { 0xAF56, 0x72FD },
    { 0xAF57, 0x72F8 },
    { 0xAF58, 0x72F7 },
    { 0xAF59, 0x7386 },
    { 0xAF5A, 0x73ED },
    { 0xAF5B, 0x7409 },
    { 0xAF5C, 0x73EE },
    { 0xAF5D, 0x73E0 },
    { 0xAF5E, 0x73EA },
    { 0xAF5F, 0x73DE },
    { 0xAF60, 0x7554 },
    { 0xAF61, 0x755D },
    { 0xAF62, 0x755C },
    { 0xAF63, 0x755A },
    { 0xAF64, 0x7559 },
    { 0xAF65, 0x75BE },
    { 0xAF66, 0x75C5 },
    { 0xAF67, 0x75C7 },
    { 0xAF68, 0x75B2 },
    { 0xAF69, 0x75B3 },
    { 0xAF6A, 0x75BD },
    { 0xAF6B, 0x75BC },
    { 0xAF6C, 0x75B9 },
    { 0xAF6D, 0x75C2 },
    { 0xAF6E, 0x75B8 },
    { 0xAF6F, 0x768B },
    { 0xAF70, 0x76B0 },
    { 0xAF71, 0x76CA },
    { 0xAF72, 0x76CD },
    { 0xAF73, 0x76CE },
    { 0xAF74, 0x7729 },
    { 0xAF75, 0x771F },
    { 0xAF76, 0x7720 },
    { 0xAF77, 0x7728 },
    { 0xAF78, 0x77E9 },
    { 0xAF79, 0x7830 },
    { 0xAF7A, 0x7827 },
    { 0xAF7B, 0x7838 },
    { 0xAF7C, 0x781D },
    { 0xAF7D, 0x7834 },
    { 0xAF7E, 0x7837 },
    { 0xAFA1, 0x7825 },
    { 0xAFA2, 0x782D },
    { 0xAFA3, 0x7820 },
    { 0xAFA4, 0x781F },
    { 0xAFA5, 0x7832 },
    { 0xAFA6, 0x7955 },
    { 0xAFA7, 0x7950 },
    { 0xAFA8, 0x7960 },
    { 0xAFA9, 0x795F },
    { 0xAFAA, 0x7956 },
    { 0xAFAB, 0x795E },
    { 0xAFAC, 0x795D },
    { 0xAFAD, 0x7957 },
    { 0xAFAE, 0x795A },
    { 0xAFAF, 0x79E4 },
    { 0xAFB0, 0x79E3 },
    { 0xAFB1, 0x79E7 },
    { 0xAFB2, 0x79DF },
    { 0xAFB3, 0x79E6 },
    { 0xAFB4, 0x79E9 },
    { 0xAFB5, 0x79D8 },
    { 0xAFB6, 0x7A84 },
    { 0xAFB7, 0x7A88 },
    { 0xAFB8, 0x7AD9 },
    { 0xAFB9, 0x7B06 },
    { 0xAFBA, 0x7B11 },
    { 0xAFBB, 0x7C89 },
    { 0xAFBC, 0x7D21 },
    { 0xAFBD, 0x7D17 },
    { 0xAFBE, 0x7D0B },
    { 0xAFBF, 0x7D0A },
    { 0xAFC0, 0x7D20 },
    { 0xAFC1, 0x7D22 },
    { 0xAFC2, 0x7D14 },
    { 0xAFC3, 0x7D10 },
    { 0xAFC4, 0x7D15 },
    { 0xAFC5, 0x7D1A },
    { 0xAFC6, 0x7D1C },
    { 0xAFC7, 0x7D0D },
    { 0xAFC8, 0x7D19 },
    { 0xAFC9, 0x7D1B },
    { 0xAFCA, 0x7F3A },
    { 0xAFCB, 0x7F5F },
    { 0xAFCC, 0x7F94 },
    { 0xAFCD, 0x7FC5 },
    { 0xAFCE, 0x7FC1 },
    { 0xAFCF, 0x8006 },
    { 0xAFD0, 0x8018 },
    { 0xAFD1, 0x8015 },
    { 0xAFD2, 0x8019 },
    { 0xAFD3, 0x8017 },
    { 0xAFD4, 0x803D },
    { 0xAFD5, 0x803F },
    { 0xAFD6, 0x80F1 },
    { 0xAFD7, 0x8102 },
    { 0xAFD8, 0x80F0 },
    { 0xAFD9, 0x8105 },
    { 0xAFDA, 0x80ED },
    { 0xAFDB, 0x80F4 },
    { 0xAFDC, 0x8106 },
    { 0xAFDD, 0x80F8 },
    { 0xAFDE, 0x80F3 },
    { 0xAFDF, 0x8108 },
    { 0xAFE0, 0x80FD },
    { 0xAFE1, 0x810A },
    { 0xAFE2, 0x80FC },
    { 0xAFE3, 0x80EF },
    { 0xAFE4, 0x81ED },
    { 0xAFE5, 0x81EC },
    { 0xAFE6, 0x8200 },
    { 0xAFE7, 0x8210 },
    { 0xAFE8, 0x822A },
    { 0xAFE9, 0x822B },
    { 0xAFEA, 0x8228 },
    { 0xAFEB, 0x822C },
    { 0xAFEC, 0x82BB },
    { 0xAFED, 0x832B },
    { 0xAFEE, 0x8352 },
    { 0xAFEF, 0x8354 },
    { 0xAFF0, 0x834A },
    { 0xAFF1, 0x8338 },
    { 0xAFF2, 0x8350 },
    { 0xAFF3, 0x8349 },
    { 0xAFF4, 0x8335 },
    { 0xAFF5, 0x8334 },
    { 0xAFF6, 0x834F },
    { 0xAFF7, 0x8332 },
    { 0xAFF8, 0x8339 },
    { 0xAFF9, 0x8336 },
    { 0xAFFA, 0x8317 },
    { 0xAFFB, 0x8340 },
    { 0xAFFC, 0x8331 },
    { 0xAFFD, 0x8328 },
    { 0xAFFE, 0x8343 },
    { 0xB040, 0x8654 },
    { 0xB041, 0x868A },
    { 0xB042, 0x86AA },
    { 0xB043, 0x8693 },
    { 0xB044, 0x86A4 },
    { 0xB045, 0x86A9 },
    { 0xB046, 0x868C },
    { 0xB047, 0x86A3 },
    { 0xB048, 0x869C },
    { 0xB049, 0x8870 },
    { 0xB04A, 0x8877 },
    { 0xB04B, 0x8881 },
    { 0xB04C, 0x8882 },
    { 0xB04D, 0x887D },
    { 0xB04E, 0x8879 },
    { 0xB04F, 0x8A18 },
    { 0xB050, 0x8A10 },
    { 0xB051, 0x8A0E },
    { 0xB052, 0x8A0C },
    { 0xB053, 0x8A15 },
    { 0xB054, 0x8A0A },
    { 0xB055, 0x8A17 },
    { 0xB056, 0x8A13 },
    { 0xB057, 0x8A16 },
    { 0xB058, 0x8A0F },
    { 0xB059, 0x8A11 },
    { 0xB05A, 0x8C48 },
    { 0xB05B, 0x8C7A },
    { 0xB05C, 0x8C79 },
    { 0xB05D, 0x8CA1 },
    { 0xB05E, 0x8CA2 },
    { 0xB05F, 0x8D77 },
    { 0xB060, 0x8EAC },
    { 0xB061, 0x8ED2 },
    { 0xB062, 0x8ED4 },
    { 0xB063, 0x8ECF },
    { 0xB064, 0x8FB1 },
    { 0xB065, 0x9001 },
    { 0xB066, 0x9006 },
    { 0xB067, 0x8FF7 },
    { 0xB068, 0x9000 },
    { 0xB069, 0x8FFA },
    { 0xB06A, 0x8FF4 },
    { 0xB06B, 0x9003 },
    { 0xB06C, 0x8FFD },
    { 0xB06D, 0x9005 },
    { 0xB06E, 0x8FF8 },
    { 0xB06F, 0x9095 },
    { 0xB070, 0x90E1 },
    { 0xB071, 0x90DD },
    { 0xB072, 0x90E2 },
    { 0xB073, 0x9152 },
    { 0xB074, 0x914D },
    { 0xB075, 0x914C },
    { 0xB076, 0x91D8 },
    { 0xB077, 0x91DD },
    { 0xB078, 0x91D7 },
    { 0xB079, 0x91DC },
    { 0xB07A, 0x91D9 },
    { 0xB07B, 0x9583 },
    { 0xB07C, 0x9662 },
    { 0xB07D, 0x9663 },
    { 0xB07E, 0x9661 },
    { 0xB0A1, 0x965B },
    { 0xB0A2, 0x965D },
    { 0xB0A3, 0x9664 },
    { 0xB0A4, 0x9658 },
    { 0xB0A5, 0x965E },
    { 0xB0A6, 0x96BB },
    { 0xB0A7, 0x98E2 },
    { 0xB0A8, 0x99AC },
    { 0xB0A9, 0x9AA8 },
    { 0xB0AA, 0x9AD8 },
    { 0xB0AB, 0x9B25 },
    { 0xB0AC, 0x9B32 },
    { 0xB0AD, 0x9B3C },
    { 0xB0AE, 0x4E7E },
    { 0xB0AF, 0x507A },
    { 0xB0B0, 0x507D },
    { 0xB0B1, 0x505C },
    { 0xB0B2, 0x5047 },
    { 0xB0B3, 0x5043 },
    { 0xB0B4, 0x504C },
    { 0xB0B5, 0x505A },
    { 0xB0B6, 0x5049 },
    { 0xB0B7, 0x5065 },
    { 0xB0B8, 0x5076 },
    { 0xB0B9, 0x504E },
    { 0xB0BA, 0x5055 },
    { 0xB0BB, 0x5075 },
    { 0xB0BC, 0x5074 },
    { 0xB0BD, 0x5077 },
    { 0xB0BE, 0x504F },
    { 0xB0BF, 0x500F },
    { 0xB0C0, 0x506F },
    { 0xB0C1, 0x506D },
    { 0xB0C2, 0x515C },
    { 0xB0C3, 0x5195 },
    { 0xB0C4, 0x51F0 },
    { 0xB0C5, 0x526A },
    { 0xB0C6, 0x526F },
    { 0xB0C7, 0x52D2 },
    { 0xB0C8, 0x52D9 },
    { 0xB0C9, 0x52D8 },
    { 0xB0CA, 0x52D5 },
    { 0xB0CB, 0x5310 },
    { 0xB0CC, 0x530F },
    { 0xB0CD, 0x5319 },
    { 0xB0CE, 0x533F },
    { 0xB0CF, 0x5340 },
    { 0xB0D0, 0x533E },
    { 0xB0D1, 0x53C3 },
    { 0xB0D2, 0x66FC },
    { 0xB0D3, 0x5546 },
    { 0xB0D4, 0x556A },
    { 0xB0D5, 0x5566 },
    { 0xB0D6, 0x5544 },
    { 0xB0D7, 0x555E },
    { 0xB0D8, 0x5561 },
    { 0xB0D9, 0x5543 },
    { 0xB0DA, 0x554A },
    { 0xB0DB, 0x5531 },
    { 0xB0DC, 0x5556 },
    { 0xB0DD, 0x554F },
    { 0xB0DE, 0x5555 },
    { 0xB0DF, 0x552F },
    { 0xB0E0, 0x5564 },
    { 0xB0E1, 0x5538 },
    { 0xB0E2, 0x552E },
    { 0xB0E3, 0x555C },
    { 0xB0E4, 0x552C },
    { 0xB0E5, 0x5563 },
    { 0xB0E6, 0x5533 },
    { 0xB0E7, 0x5541 },
    { 0xB0E8, 0x5557 },
    { 0xB0E9, 0x5708 },
    { 0xB0EA, 0x570B },
    { 0xB0EB, 0x5709 },
    { 0xB0EC, 0x57DF },
    { 0xB0ED, 0x5805 },
    { 0xB0EE, 0x580A },
    { 0xB0EF, 0x5806 },
    { 0xB0F0, 0x57E0 },
    { 0xB0F1, 0x57E4 },
    { 0xB0F2, 0x57FA },
    { 0xB0F3, 0x5802 },
    { 0xB0F4, 0x5835 },
    { 0xB0F5, 0x57F7 },
    { 0xB0F6, 0x57F9 },
    { 0xB0F7, 0x5920 },
    { 0xB0F8, 0x5962 },
    { 0xB0F9, 0x5A36 },
    { 0xB0FA, 0x5A41 },
    { 0xB0FB, 0x5A49 },
    { 0xB0FC, 0x5A66 },
    { 0xB0FD, 0x5A6A },
    { 0xB0FE, 0x5A40 },
    { 0xB140, 0x5A3C },
    { 0xB141, 0x5A62 },
    { 0xB142, 0x5A5A },
    { 0xB143, 0x5A46 },
    { 0xB144, 0x5A4A },
    { 0xB145, 0x5B70 },
    { 0xB146, 0x5BC7 },
    { 0xB147, 0x5BC5 },
    { 0xB148, 0x5BC4 },
    { 0xB149, 0x5BC2 },
    { 0xB14A, 0x5BBF },
    { 0xB14B, 0x5BC6 },
    { 0xB14C, 0x5C09 },
    { 0xB14D, 0x5C08 },
    { 0xB14E, 0x5C07 },
    { 0xB14F, 0x5C60 },
    { 0xB150, 0x5C5C },
    { 0xB151, 0x5C5D },
    { 0xB152, 0x5D07 },
    { 0xB153, 0x5D06 },
    { 0xB154, 0x5D0E },
    { 0xB155, 0x5D1B },
    { 0xB156, 0x5D16 },
    { 0xB157, 0x5D22 },
    { 0xB158, 0x5D11 },
    { 0xB159, 0x5D29 },
    { 0xB15A, 0x5D14 },
    { 0xB15B, 0x5D19 },
    { 0xB15C, 0x5D24 },
    { 0xB15D, 0x5D27 },
    { 0xB15E, 0x5D17 },
    { 0xB15F, 0x5DE2 },
    { 0xB160, 0x5E38 },
    { 0xB161, 0x5E36 },
    { 0xB162, 0x5E33 },
    { 0xB163, 0x5E37 },
    { 0xB164, 0x5EB7 },
    { 0xB165, 0x5EB8 },
    { 0xB166, 0x5EB6 },
    { 0xB167, 0x5EB5 },
    { 0xB168, 0x5EBE },
    { 0xB169, 0x5F35 },
    { 0xB16A, 0x5F37 },
    { 0xB16B, 0x5F57 },
    { 0xB16C, 0x5F6C },
    { 0xB16D, 0x5F69 },
    { 0xB16E, 0x5F6B },
    { 0xB16F, 0x5F97 },
    { 0xB170, 0x5F99 },
    { 0xB171, 0x5F9E },
    { 0xB172, 0x5F98 },
    { 0xB173, 0x5FA1 },
    { 0xB174, 0x5FA0 },
    { 0xB175, 0x5F9C },
    { 0xB176, 0x607F },
    { 0xB177, 0x60A3 },
    { 0xB178, 0x6089 },
    { 0xB179, 0x60A0 },
    { 0xB17A, 0x60A8 },
    { 0xB17B, 0x60CB },
    { 0xB17C, 0x60B4 },
    { 0xB17D, 0x60E6 },
    { 0xB17E, 0x60BD },
    { 0xB1A1, 0x60C5 },
    { 0xB1A2, 0x60BB },
    { 0xB1A3, 0x60B5 },
    { 0xB1A4, 0x60DC },
    { 0xB1A5, 0x60BC },
    { 0xB1A6, 0x60D8 },
    { 0xB1A7, 0x60D5 },
    { 0xB1A8, 0x60C6 },
    { 0xB1A9, 0x60DF },
    { 0xB1AA, 0x60B8 },
    { 0xB1AB, 0x60DA },
    { 0xB1AC, 0x60C7 },
    { 0xB1AD, 0x621A },
    { 0xB1AE, 0x621B },
    { 0xB1AF, 0x6248 },
    { 0xB1B0, 0x63A0 },
    { 0xB1B1, 0x63A7 },
    { 0xB1B2, 0x6372 },
    { 0xB1B3, 0x6396 },
    { 0xB1B4, 0x63A2 },
    { 0xB1B5, 0x63A5 },
    { 0xB1B6, 0x6377 },
    { 0xB1B7, 0x6367 },
    { 0xB1B8, 0x6398 },
    { 0xB1B9, 0x63AA },
    { 0xB1BA, 0x6371 },
    { 0xB1BB, 0x63A9 },
    { 0xB1BC, 0x6389 },
    { 0xB1BD, 0x6383 },
    { 0xB1BE, 0x639B },
    { 0xB1BF, 0x636B },
    { 0xB1C0, 0x63A8 },
    { 0xB1C1, 0x6384 },
    { 0xB1C2, 0x6388 },
    { 0xB1C3, 0x6399 },
    { 0xB1C4, 0x63A1 },
    { 0xB1C5, 0x63AC },
    { 0xB1C6, 0x6392 },
    { 0xB1C7, 0x638F },
    { 0xB1C8, 0x6380 },
    { 0xB1C9, 0x637B },
    { 0xB1CA, 0x6369 },
    { 0xB1CB, 0x6368 },
    { 0xB1CC, 0x637A },
    { 0xB1CD, 0x655D },
    { 0xB1CE, 0x6556 },
    { 0xB1CF, 0x6551 },
    { 0xB1D0, 0x6559 },
    { 0xB1D1, 0x6557 },
    { 0xB1D2, 0x555F },
    { 0xB1D3, 0x654F },
    { 0xB1D4, 0x6558 },
    { 0xB1D5, 0x6555 },
    { 0xB1D6, 0x6554 },
    { 0xB1D7, 0x659C },
    { 0xB1D8, 0x659B },
    { 0xB1D9, 0x65AC },
    { 0xB1DA, 0x65CF },
    { 0xB1DB, 0x65CB },
    { 0xB1DC, 0x65CC },
    { 0xB1DD, 0x65CE },
    { 0xB1DE, 0x665D },
    { 0xB1DF, 0x665A },
    { 0xB1E0, 0x6664 },
    { 0xB1E1, 0x6668 },
    { 0xB1E2, 0x6666 },
    { 0xB1E3, 0x665E },
    { 0xB1E4, 0x66F9 },
    { 0xB1E5, 0x52D7 },
    { 0xB1E6, 0x671B },
    { 0xB1E7, 0x6881 },
    { 0xB1E8, 0x68AF },
    { 0xB1E9, 0x68A2 },
    { 0xB1EA, 0x6893 },
    { 0xB1EB, 0x68B5 },
    { 0xB1EC, 0x687F },
    { 0xB1ED, 0x6876 },
    { 0xB1EE, 0x68B1 },
    { 0xB1EF, 0x68A7 },
    { 0xB1F0, 0x6897 },
    { 0xB1F1, 0x68B0 },
    { 0xB1F2, 0x6883 },
    { 0xB1F3, 0x68C4 },
    { 0xB1F4, 0x68AD },
    { 0xB1F5, 0x6886 },
    { 0xB1F6, 0x6885 },
    { 0xB1F7, 0x6894 },
    { 0xB1F8, 0x689D },
    { 0xB1F9, 0x68A8 },
    { 0xB1FA, 0x689F },
    { 0xB1FB, 0x68A1 },
    { 0xB1FC, 0x6882 },
    { 0xB1FD, 0x6B32 },
    { 0xB1FE, 0x6BBA },
    { 0xB240, 0x6BEB },
    { 0xB241, 0x6BEC },
    { 0xB242, 0x6C2B },
    { 0xB243, 0x6D8E },
    { 0xB244, 0x6DBC },
    { 0xB245, 0x6DF3 },
    { 0xB246, 0x6DD9 },
    { 0xB247, 0x6DB2 },
    { 0xB248, 0x6DE1 },
    { 0xB249, 0x6DCC },
    { 0xB24A, 0x6DE4 },
    { 0xB24B, 0x6DFB },
    { 0xB24C, 0x6DFA },
    { 0xB24D, 0x6E05 },
    { 0xB24E, 0x6DC7 },
    { 0xB24F, 0x6DCB },
    { 0xB250, 0x6DAF },
    { 0xB251, 0x6DD1 },
    { 0xB252, 0x6DAE },
    { 0xB253, 0x6DDE },
    { 0xB254, 0x6DF9 },
    { 0xB255, 0x6DB8 },
    { 0xB256, 0x6DF7 },
    { 0xB257, 0x6DF5 },
    { 0xB258, 0x6DC5 },
    { 0xB259, 0x6DD2 },
    { 0xB25A, 0x6E1A },
    { 0xB25B, 0x6DB5 },
    { 0xB25C, 0x6DDA },
    { 0xB25D, 0x6DEB },
    { 0xB25E, 0x6DD8 },
    { 0xB25F, 0x6DEA },
    { 0xB260, 0x6DF1 },
    { 0xB261, 0x6DEE },
    { 0xB262, 0x6DE8 },
    { 0xB263, 0x6DC6 },
    { 0xB264, 0x6DC4 },
    { 0xB265, 0x6DAA },
    { 0xB266, 0x6DEC },
    { 0xB267, 0x6DBF },
    { 0xB268, 0x6DE6 },
    { 0xB269, 0x70F9 },
    { 0xB26A, 0x7109 },
    { 0xB26B, 0x710A },
    { 0xB26C, 0x70FD },
    { 0xB26D, 0x70EF },
    { 0xB26E, 0x723D },
    { 0xB26F, 0x727D },
    { 0xB270, 0x7281 },
    { 0xB271, 0x731C },
    { 0xB272, 0x731B },
    { 0xB273, 0x7316 },
    { 0xB274, 0x7313 },
    { 0xB275, 0x7319 },
    { 0xB276, 0x7387 },
    { 0xB277, 0x7405 },
    { 0xB278, 0x740A },
    { 0xB279, 0x7403 },
    { 0xB27A, 0x7406 },
    { 0xB27B, 0x73FE },
    { 0xB27C, 0x740D },
    { 0xB27D, 0x74E0 },
    { 0xB27E, 0x74F6 },
    { 0xB2A1, 0x74F7 },
    { 0xB2A2, 0x751C },
    { 0xB2A3, 0x7522 },
    { 0xB2A4, 0x7565 },
    { 0xB2A5, 0x7566 },
    { 0xB2A6, 0x7562 },
    { 0xB2A7, 0x7570 },
    { 0xB2A8, 0x758F },
    { 0xB2A9, 0x75D4 },
    { 0xB2AA, 0x75D5 },
    { 0xB2AB, 0x75B5 },
    { 0xB2AC, 0x75CA },
    { 0xB2AD, 0x75CD },
    { 0xB2AE, 0x768E },
    { 0xB2AF, 0x76D4 },
    { 0xB2B0, 0x76D2 },
    { 0xB2B1, 0x76DB },
    { 0xB2B2, 0x7737 },
    { 0xB2B3, 0x773E },
    { 0xB2B4, 0x773C },
    { 0xB2B5, 0x7736 },
    { 0xB2B6, 0x7738 },
    { 0xB2B7, 0x773A },
    { 0xB2B8, 0x786B },
    { 0xB2B9, 0x7843 },
    { 0xB2BA, 0x784E },
    { 0xB2BB, 0x7965 },
    { 0xB2BC, 0x7968 },
    { 0xB2BD, 0x796D },
    { 0xB2BE, 0x79FB },
    { 0xB2BF, 0x7A92 },
    { 0xB2C0, 0x7A95 },
    { 0xB2C1, 0x7B20 },
    { 0xB2C2, 0x7B28 },
    { 0xB2C3, 0x7B1B },
    { 0xB2C4, 0x7B2C },
    { 0xB2C5, 0x7B26 },
    { 0xB2C6, 0x7B19 },
    { 0xB2C7, 0x7B1E },
    { 0xB2C8, 0x7B2E },
    { 0xB2C9, 0x7C92 },
    { 0xB2CA, 0x7C97 },
    { 0xB2CB, 0x7C95 },
    { 0xB2CC, 0x7D46 },
    { 0xB2CD, 0x7D43 },
    { 0xB2CE, 0x7D71 },
    { 0xB2CF, 0x7D2E },
    { 0xB2D0, 0x7D39 },
    { 0xB2D1, 0x7D3C },
    { 0xB2D2, 0x7D40 },
    { 0xB2D3, 0x7D30 },
    { 0xB2D4, 0x7D33 },
    { 0xB2D5, 0x7D44 },
    { 0xB2D6, 0x7D2F },
    { 0xB2D7, 0x7D42 },
    { 0xB2D8, 0x7D32 },
    { 0xB2D9, 0x7D31 },
    { 0xB2DA, 0x7F3D },
    { 0xB2DB, 0x7F9E },
    { 0xB2DC, 0x7F9A },
    { 0xB2DD, 0x7FCC },
    { 0xB2DE, 0x7FCE },
    { 0xB2DF, 0x7FD2 },
    { 0xB2E0, 0x801C },
    { 0xB2E1, 0x804A },
    { 0xB2E2, 0x8046 },
    { 0xB2E3, 0x812F },
    { 0xB2E4, 0x8116 },
    { 0xB2E5, 0x8123 },
    { 0xB2E6, 0x812B },
    { 0xB2E7, 0x8129 },
    { 0xB2E8, 0x8130 },
    { 0xB2E9, 0x8124 },
    { 0xB2EA, 0x8202 },
    { 0xB2EB, 0x8235 },
    { 0xB2EC, 0x8237 },
    { 0xB2ED, 0x8236 },
    { 0xB2EE, 0x8239 },
    { 0xB2EF, 0x838E },
    { 0xB2F0, 0x839E },
    { 0xB2F1, 0x8398 },
    { 0xB2F2, 0x8378 },
    { 0xB2F3, 0x83A2 },
    { 0xB2F4, 0x8396 },
    { 0xB2F5, 0x83BD },
    { 0xB2F6, 0x83AB },
    { 0xB2F7, 0x8392 },
    { 0xB2F8, 0x838A },
    { 0xB2F9, 0x8393 },
    { 0xB2FA, 0x8389 },
    { 0xB2FB, 0x83A0 },
    { 0xB2FC, 0x8377 },
    { 0xB2FD, 0x837B },
    { 0xB2FE, 0x837C },
    { 0xB340, 0x8386 },
    { 0xB341, 0x83A7 },
    { 0xB342, 0x8655 },
    { 0xB343, 0x5F6A },
    { 0xB344, 0x86C7 },
    { 0xB345, 0x86C0 },
    { 0xB346, 0x86B6 },
    { 0xB347, 0x86C4 },
    { 0xB348, 0x86B5 },
    { 0xB349, 0x86C6 },
    { 0xB34A, 0x86CB },
    { 0xB34B, 0x86B1 },
    { 0xB34C, 0x86AF },
    { 0xB34D, 0x86C9 },
    { 0xB34E, 0x8853 },
    { 0xB34F, 0x889E },
    { 0xB350, 0x8888 },
    { 0xB351, 0x88AB },
    { 0xB352, 0x8892 },
    { 0xB353, 0x8896 },
    { 0xB354, 0x888D },
    { 0xB355, 0x888B },
    { 0xB356, 0x8993 },
    { 0xB357, 0x898F },
    { 0xB358, 0x8A2A },
    { 0xB359, 0x8A1D },
    { 0xB35A, 0x8A23 },
    { 0xB35B, 0x8A25 },
    { 0xB35C, 0x8A31 },
    { 0xB35D, 0x8A2D },
    { 0xB35E, 0x8A1F },
    { 0xB35F, 0x8A1B },
    { 0xB360, 0x8A22 },
    { 0xB361, 0x8C49 },
    { 0xB362, 0x8C5A },
    { 0xB363, 0x8CA9 },
    { 0xB364, 0x8CAC },
    { 0xB365, 0x8CAB },
    { 0xB366, 0x8CA8 },
    { 0xB367, 0x8CAA },
    { 0xB368, 0x8CA7 },
    { 0xB369, 0x8D67 },
    { 0xB36A, 0x8D66 },
    { 0xB36B, 0x8DBE },
    { 0xB36C, 0x8DBA },
    { 0xB36D, 0x8EDB },
    { 0xB36E, 0x8EDF },
    { 0xB36F, 0x9019 },
    { 0xB370, 0x900D },
    { 0xB371, 0x901A },
    { 0xB372, 0x9017 },
    { 0xB373, 0x9023 },
    { 0xB374, 0x901F },
    { 0xB375, 0x901D },
    { 0xB376, 0x9010 },
    { 0xB377, 0x9015 },
    { 0xB378, 0x901E },
    { 0xB379, 0x9020 },
    { 0xB37A, 0x900F },
    { 0xB37B, 0x9022 },
    { 0xB37C, 0x9016 },
    { 0xB37D, 0x901B },
    { 0xB37E, 0x9014 },
    { 0xB3A1, 0x90E8 },
    { 0xB3A2, 0x90ED },
    { 0xB3A3, 0x90FD },
    { 0xB3A4, 0x9157 },
    { 0xB3A5, 0x91CE },
    { 0xB3A6, 0x91F5 },
    { 0xB3A7, 0x91E6 },
    { 0xB3A8, 0x91E3 },
    { 0xB3A9, 0x91E7 },
    { 0xB3AA, 0x91ED },
    { 0xB3AB, 0x91E9 },
    { 0xB3AC, 0x9589 },
    { 0xB3AD, 0x966A },
    { 0xB3AE, 0x9675 },
    { 0xB3AF, 0x9673 },
    { 0xB3B0, 0x9678 },
    { 0xB3B1, 0x9670 },
    { 0xB3B2, 0x9674 },
    { 0xB3B3, 0x9676 },
    { 0xB3B4, 0x9677 },
    { 0xB3B5, 0x966C },
    { 0xB3B6, 0x96C0 },
    { 0xB3B7, 0x96EA },
    { 0xB3B8, 0x96E9 },
    { 0xB3B9, 0x7AE0 },
    { 0xB3BA, 0x7ADF },
    { 0xB3BB, 0x9802 },
    { 0xB3BC, 0x9803 },
    { 0xB3BD, 0x9B5A },
    { 0xB3BE, 0x9CE5 },
    { 0xB3BF, 0x9E75 },
    { 0xB3C0, 0x9E7F },
    { 0xB3C1, 0x9EA5 },
    { 0xB3C2, 0x9EBB },
    { 0xB3C3, 0x50A2 },
    { 0xB3C4, 0x508D },
    { 0xB3C5, 0x5085 },
    { 0xB3C6, 0x5099 },
    { 0xB3C7, 0x5091 },
    { 0xB3C8, 0x5080 },
    { 0xB3C9, 0x5096 },
    { 0xB3CA, 0x5098 },
    { 0xB3CB, 0x509A },
    { 0xB3CC, 0x6700 },
    { 0xB3CD, 0x51F1 },
    { 0xB3CE, 0x5272 },
    { 0xB3CF, 0x5274 },
    { 0xB3D0, 0x5275 },
    { 0xB3D1, 0x5269 },
    { 0xB3D2, 0x52DE },
    { 0xB3D3, 0x52DD },
    { 0xB3D4, 0x52DB },
    { 0xB3D5, 0x535A },
    { 0xB3D6, 0x53A5 },
    { 0xB3D7, 0x557B },
    { 0xB3D8, 0x5580 },
    { 0xB3D9, 0x55A7 },
    { 0xB3DA, 0x557C },
    { 0xB3DB, 0x558A },
    { 0xB3DC, 0x559D },
    { 0xB3DD, 0x5598 },
    { 0xB3DE, 0x5582 },
    { 0xB3DF, 0x559C },
    { 0xB3E0, 0x55AA },
    { 0xB3E1, 0x5594 },
    { 0xB3E2, 0x5587 },
    { 0xB3E3, 0x558B },
    { 0xB3E4, 0x5583 },
    { 0xB3E5, 0x55B3 },
    { 0xB3E6, 0x55AE },
    { 0xB3E7, 0x559F },
    { 0xB3E8, 0x553E },
    { 0xB3E9, 0x55B2 },
    { 0xB3EA, 0x559A },
    { 0xB3EB, 0x55BB },
    { 0xB3EC, 0x55AC },
    { 0xB3ED, 0x55B1 },
    { 0xB3EE, 0x557E },
    { 0xB3EF, 0x5589 },
    { 0xB3F0, 0x55AB },
    { 0xB3F1, 0x5599 },
    { 0xB3F2, 0x570D },
    { 0xB3F3, 0x582F },
    { 0xB3F4, 0x582A },
    { 0xB3F5, 0x5834 },
    { 0xB3F6, 0x5824 },
    { 0xB3F7, 0x5830 },
    { 0xB3F8, 0x5831 },
    { 0xB3F9, 0x5821 },
    { 0xB3FA, 0x581D },
    { 0xB3FB, 0x5820 },
    { 0xB3FC, 0x58F9 },
    { 0xB3FD, 0x58FA },
    { 0xB3FE, 0x5960 },
    { 0xB440, 0x5A77 },
    { 0xB441, 0x5A9A },
    { 0xB442, 0x5A7F },
    { 0xB443, 0x5A92 },
    { 0xB444, 0x5A9B },
    { 0xB445, 0x5AA7 },
    { 0xB446, 0x5B73 },
    { 0xB447, 0x5B71 },
    { 0xB448, 0x5BD2 },
    { 0xB449, 0x5BCC },
    { 0xB44A, 0x5BD3 },
    { 0xB44B, 0x5BD0 },
    { 0xB44C, 0x5C0A },
    { 0xB44D, 0x5C0B },
    { 0xB44E, 0x5C31 },
    { 0xB44F, 0x5D4C },
    { 0xB450, 0x5D50 },
    { 0xB451, 0x5D34 },
    { 0xB452, 0x5D47 },
    { 0xB453, 0x5DFD },
    { 0xB454, 0x5E45 },
    { 0xB455, 0x5E3D },
    { 0xB456, 0x5E40 },
    { 0xB457, 0x5E43 },
    { 0xB458, 0x5E7E },
    { 0xB459, 0x5ECA },
    { 0xB45A, 0x5EC1 },
    { 0xB45B, 0x5EC2 },
    { 0xB45C, 0x5EC4 },
    { 0xB45D, 0x5F3C },
    { 0xB45E, 0x5F6D },
    { 0xB45F, 0x5FA9 },
    { 0xB460, 0x5FAA },
    { 0xB461, 0x5FA8 },
    { 0xB462, 0x60D1 },
    { 0xB463, 0x60E1 },
    { 0xB464, 0x60B2 },
    { 0xB465, 0x60B6 },
    { 0xB466, 0x60E0 },
    { 0xB467, 0x611C },
    { 0xB468, 0x6123 },
    { 0xB469, 0x60FA },
    { 0xB46A, 0x6115 },
    { 0xB46B, 0x60F0 },
    { 0xB46C, 0x60FB },
    { 0xB46D, 0x60F4 },
    { 0xB46E, 0x6168 },
    { 0xB46F, 0x60F1 },
    { 0xB470, 0x610E },
    { 0xB471, 0x60F6 },
    { 0xB472, 0x6109 },
    { 0xB473, 0x6100 },
    { 0xB474, 0x6112 },
    { 0xB475, 0x621F },
    { 0xB476, 0x6249 },
    { 0xB477, 0x63A3 },
    { 0xB478, 0x638C },
    { 0xB479, 0x63CF },
    { 0xB47A, 0x63C0 },
    { 0xB47B, 0x63E9 },
    { 0xB47C, 0x63C9 },
    { 0xB47D, 0x63C6 },
    { 0xB47E, 0x63CD },
    { 0xB4A1, 0x63D2 },
    { 0xB4A2, 0x63E3 },
    { 0xB4A3, 0x63D0 },
    { 0xB4A4, 0x63E1 },
    { 0xB4A5, 0x63D6 },
    { 0xB4A6, 0x63ED },
    { 0xB4A7, 0x63EE },
    { 0xB4A8, 0x6376 },
    { 0xB4A9, 0x63F4 },
    { 0xB4AA, 0x63EA },
    { 0xB4AB, 0x63DB },
    { 0xB4AC, 0x6452 },
    { 0xB4AD, 0x63DA },
    { 0xB4AE, 0x63F9 },
    { 0xB4AF, 0x655E },
    { 0xB4B0, 0x6566 },
    { 0xB4B1, 0x6562 },
    { 0xB4B2, 0x6563 },
    { 0xB4B3, 0x6591 },
    { 0xB4B4, 0x6590 },
    { 0xB4B5, 0x65AF },
    { 0xB4B6, 0x666E },
    { 0xB4B7, 0x6670 },
    { 0xB4B8, 0x6674 },
    { 0xB4B9, 0x6676 },
    { 0xB4BA, 0x666F },
    { 0xB4BB, 0x6691 },
    { 0xB4BC, 0x667A },
    { 0xB4BD, 0x667E },
    { 0xB4BE, 0x6677 },
    { 0xB4BF, 0x66FE },
    { 0xB4C0, 0x66FF },
    { 0xB4C1, 0x671F },
    { 0xB4C2, 0x671D },
    { 0xB4C3, 0x68FA },
    { 0xB4C4, 0x68D5 },
    { 0xB4C5, 0x68E0 },
    { 0xB4C6, 0x68D8 },
    { 0xB4C7, 0x68D7 },
    { 0xB4C8, 0x6905 },
    { 0xB4C9, 0x68DF },
    { 0xB4CA, 0x68F5 },
    { 0xB4CB, 0x68EE },
    { 0xB4CC, 0x68E7 },
    { 0xB4CD, 0x68F9 },
    { 0xB4CE, 0x68D2 },
    { 0xB4CF, 0x68F2 },
    { 0xB4D0, 0x68E3 },
    { 0xB4D1, 0x68CB },
    { 0xB4D2, 0x68CD },
    { 0xB4D3, 0x690D },
    { 0xB4D4, 0x6912 },
    { 0xB4D5, 0x690E },
    { 0xB4D6, 0x68C9 },
    { 0xB4D7, 0x68DA },
    { 0xB4D8, 0x696E },
    { 0xB4D9, 0x68FB },
    { 0xB4DA, 0x6B3E },
    { 0xB4DB, 0x6B3A },
    { 0xB4DC, 0x6B3D },
    { 0xB4DD, 0x6B98 },
    { 0xB4DE, 0x6B96 },
    { 0xB4DF, 0x6BBC },
    { 0xB4E0, 0x6BEF },
    { 0xB4E1, 0x6C2E },
    { 0xB4E2, 0x6C2F },
    { 0xB4E3, 0x6C2C },
    { 0xB4E4, 0x6E2F },
    { 0xB4E5, 0x6E38 },
    { 0xB4E6, 0x6E54 },
    { 0xB4E7, 0x6E21 },
    { 0xB4E8, 0x6E32 },
    { 0xB4E9, 0x6E67 },
    { 0xB4EA, 0x6E4A },
    { 0xB4EB, 0x6E20 },
    { 0xB4EC, 0x6E25 },
    { 0xB4ED, 0x6E23 },
    { 0xB4EE, 0x6E1B },
    { 0xB4EF, 0x6E5B },
    { 0xB4F0, 0x6E58 },
    { 0xB4F1, 0x6E24 },
    { 0xB4F2, 0x6E56 },
    { 0xB4F3, 0x6E6E },
    { 0xB4F4, 0x6E2D },
    { 0xB4F5, 0x6E26 },
    { 0xB4F6, 0x6E6F },
    { 0xB4F7, 0x6E34 },
    { 0xB4F8, 0x6E4D },
    { 0xB4F9, 0x6E3A },
    { 0xB4FA, 0x6E2C },
    { 0xB4FB, 0x6E43 },
    { 0xB4FC, 0x6E1D },
    { 0xB4FD, 0x6E3E },
    { 0xB4FE, 0x6ECB },
    { 0xB540, 0x6E89 },
    { 0xB541, 0x6E19 },
    { 0xB542, 0x6E4E },
    { 0xB543, 0x6E63 },
    { 0xB544, 0x6E44 },
    { 0xB545, 0x6E72 },
    { 0xB546, 0x6E69 },
    { 0xB547, 0x6E5F },
    { 0xB548, 0x7119 },
    { 0xB549, 0x711A },
    { 0xB54A, 0x7126 },
    { 0xB54B, 0x7130 },
    { 0xB54C, 0x7121 },
    { 0xB54D, 0x7136 },
    { 0xB54E, 0x716E },
    { 0xB54F, 0x711C },
    { 0xB550, 0x724C },
    { 0xB551, 0x7284 },
    { 0xB552, 0x7280 },
    { 0xB553, 0x7336 },
    { 0xB554, 0x7325 },
    { 0xB555, 0x7334 },
    { 0xB556, 0x7329 },
    { 0xB557, 0x743A },
    { 0xB558, 0x742A },
    { 0xB559, 0x7433 },
    { 0xB55A, 0x7422 },
    { 0xB55B, 0x7425 },
    { 0xB55C, 0x7435 },
    { 0xB55D, 0x7436 },
    { 0xB55E, 0x7434 },
    { 0xB55F, 0x742F },
    { 0xB560, 0x741B },
    { 0xB561, 0x7426 },
    { 0xB562, 0x7428 },
    { 0xB563, 0x7525 },
    { 0xB564, 0x7526 },
    { 0xB565, 0x756B },
    { 0xB566, 0x756A },
    { 0xB567, 0x75E2 },
    { 0xB568, 0x75DB },
    { 0xB569, 0x75E3 },
    { 0xB56A, 0x75D9 },
    { 0xB56B, 0x75D8 },
    { 0xB56C, 0x75DE },
    { 0xB56D, 0x75E0 },
    { 0xB56E, 0x767B },
    { 0xB56F, 0x767C },
    { 0xB570, 0x7696 },
    { 0xB571, 0x7693 },
    { 0xB572, 0x76B4 },
    { 0xB573, 0x76DC },
    { 0xB574, 0x774F },
    { 0xB575, 0x77ED },
    { 0xB576, 0x785D },
    { 0xB577, 0x786C },
    { 0xB578, 0x786F },
    { 0xB579, 0x7A0D },
    { 0xB57A, 0x7A08 },
    { 0xB57B, 0x7A0B },
    { 0xB57C, 0x7A05 },
    { 0xB57D, 0x7A00 },
    { 0xB57E, 0x7A98 },
    { 0xB5A1, 0x7A97 },
    { 0xB5A2, 0x7A96 },
    { 0xB5A3, 0x7AE5 },
    { 0xB5A4, 0x7AE3 },
    { 0xB5A5, 0x7B49 },
    { 0xB5A6, 0x7B56 },
    { 0xB5A7, 0x7B46 },
    { 0xB5A8, 0x7B50 },
    { 0xB5A9, 0x7B52 },
    { 0xB5AA, 0x7B54 },
    { 0xB5AB, 0x7B4D },
    { 0xB5AC, 0x7B4B },
    { 0xB5AD, 0x7B4F },
    { 0xB5AE, 0x7B51 },
    { 0xB5AF, 0x7C9F },
    { 0xB5B0, 0x7CA5 },
    { 0xB5B1, 0x7D5E },
    { 0xB5B2, 0x7D50 },
    { 0xB5B3, 0x7D68 },
    { 0xB5B4, 0x7D55 },
    { 0xB5B5, 0x7D2B },
    { 0xB5B6, 0x7D6E },
    { 0xB5B7, 0x7D72 },
    { 0xB5B8, 0x7D61 },
    { 0xB5B9, 0x7D66 },
    { 0xB5BA, 0x7D62 },
    { 0xB5BB, 0x7D70 },
    { 0xB5BC, 0x7D73 },
    { 0xB5BD, 0x5584 },
    { 0xB5BE, 0x7FD4 },
    { 0xB5BF, 0x7FD5 },
    { 0xB5C0, 0x800B },
    { 0xB5C1, 0x8052 },
    { 0xB5C2, 0x8085 },
    { 0xB5C3, 0x8155 },
    { 0xB5C4, 0x8154 },
    { 0xB5C5, 0x814B },
    { 0xB5C6, 0x8151 },
    { 0xB5C7, 0x814E },
    { 0xB5C8, 0x8139 },
    { 0xB5C9, 0x8146 },
    { 0xB5CA, 0x813E },
    { 0xB5CB, 0x814C },
    { 0xB5CC, 0x8153 },
    { 0xB5CD, 0x8174 },
    { 0xB5CE, 0x8212 },
    { 0xB5CF, 0x821C },
    { 0xB5D0, 0x83E9 },
    { 0xB5D1, 0x8403 },
    { 0xB5D2, 0x83F8 },
    { 0xB5D3, 0x840D },
    { 0xB5D4, 0x83E0 },
    { 0xB5D5, 0x83C5 },
    { 0xB5D6, 0x840B },
    { 0xB5D7, 0x83C1 },
    { 0xB5D8, 0x83EF },
    { 0xB5D9, 0x83F1 },
    { 0xB5DA, 0x83F4 },
    { 0xB5DB, 0x8457 },
    { 0xB5DC, 0x840A },
    { 0xB5DD, 0x83F0 },
    { 0xB5DE, 0x840C },
    { 0xB5DF, 0x83CC },
    { 0xB5E0, 0x83FD },
    { 0xB5E1, 0x83F2 },
    { 0xB5E2, 0x83CA },
    { 0xB5E3, 0x8438 },
    { 0xB5E4, 0x840E },
    { 0xB5E5, 0x8404 },
    { 0xB5E6, 0x83DC },
    { 0xB5E7, 0x8407 },
    { 0xB5E8, 0x83D4 },
    { 0xB5E9, 0x83DF },
    { 0xB5EA, 0x865B },
    { 0xB5EB, 0x86DF },
    { 0xB5EC, 0x86D9 },
    { 0xB5ED, 0x86ED },
    { 0xB5EE, 0x86D4 },
    { 0xB5EF, 0x86DB },
    { 0xB5F0, 0x86E4 },
    { 0xB5F1, 0x86D0 },
    { 0xB5F2, 0x86DE },
    { 0xB5F3, 0x8857 },
    { 0xB5F4, 0x88C1 },
    { 0xB5F5, 0x88C2 },
    { 0xB5F6, 0x88B1 },
    { 0xB5F7, 0x8983 },
    { 0xB5F8, 0x8996 },
    { 0xB5F9, 0x8A3B },
    { 0xB5FA, 0x8A60 },
    { 0xB5FB, 0x8A55 },
    { 0xB5FC, 0x8A5E },
    { 0xB5FD, 0x8A3C },
    { 0xB5FE, 0x8A41 },
    { 0xB640, 0x8A54 },
    { 0xB641, 0x8A5B },
    { 0xB642, 0x8A50 },
    { 0xB643, 0x8A46 },
    { 0xB644, 0x8A34 },
    { 0xB645, 0x8A3A },
    { 0xB646, 0x8A36 },
    { 0xB647, 0x8A56 },
    { 0xB648, 0x8C61 },
    { 0xB649, 0x8C82 },
    { 0xB64A, 0x8CAF },
    { 0xB64B, 0x8CBC },
    { 0xB64C, 0x8CB3 },
    { 0xB64D, 0x8CBD },
    { 0xB64E, 0x8CC1 },
    { 0xB64F, 0x8CBB },
    { 0xB650, 0x8CC0 },
    { 0xB651, 0x8CB4 },
    { 0xB652, 0x8CB7 },
    { 0xB653, 0x8CB6 },
    { 0xB654, 0x8CBF },
    { 0xB655, 0x8CB8 },
    { 0xB656, 0x8D8A },
    { 0xB657, 0x8D85 },
    { 0xB658, 0x8D81 },
    { 0xB659, 0x8DCE },
    { 0xB65A, 0x8DDD },
    { 0xB65B, 0x8DCB },
    { 0xB65C, 0x8DDA },
    { 0xB65D, 0x8DD1 },
    { 0xB65E, 0x8DCC },
    { 0xB65F, 0x8DDB },
    { 0xB660, 0x8DC6 },
    { 0xB661, 0x8EFB },
    { 0xB662, 0x8EF8 },
    { 0xB663, 0x8EFC },
    { 0xB664, 0x8F9C },
    { 0xB665, 0x902E },
    { 0xB666, 0x9035 },
    { 0xB667, 0x9031 },
    { 0xB668, 0x9038 },
    { 0xB669, 0x9032 },
    { 0xB66A, 0x9036 },
    { 0xB66B, 0x9102 },
    { 0xB66C, 0x90F5 },
    { 0xB66D, 0x9109 },
    { 0xB66E, 0x90FE },
    { 0xB66F, 0x9163 },
    { 0xB670, 0x9165 },
    { 0xB671, 0x91CF },
    { 0xB672, 0x9214 },
    { 0xB673, 0x9215 },
    { 0xB674, 0x9223 },
    { 0xB675, 0x9209 },
    { 0xB676, 0x921E },
    { 0xB677, 0x920D },
    { 0xB678, 0x9210 },
    { 0xB679, 0x9207 },
    { 0xB67A, 0x9211 },
    { 0xB67B, 0x9594 },
    { 0xB67C, 0x958F },
    { 0xB67D, 0x958B },
    { 0xB67E, 0x9591 },
    { 0xB6A1, 0x9593 },
    { 0xB6A2, 0x9592 },
    { 0xB6A3, 0x958E },
    { 0xB6A4, 0x968A },
    { 0xB6A5, 0x968E },
    { 0xB6A6, 0x968B },
    { 0xB6A7, 0x967D },
    { 0xB6A8, 0x9685 },
    { 0xB6A9, 0x9686 },
    { 0xB6AA, 0x968D },
    { 0xB6AB, 0x9672 },
    { 0xB6AC, 0x9684 },
    { 0xB6AD, 0x96C1 },
    { 0xB6AE, 0x96C5 },
    { 0xB6AF, 0x96C4 },
    { 0xB6B0, 0x96C6 },
    { 0xB6B1, 0x96C7 },
    { 0xB6B2, 0x96EF },
    { 0xB6B3, 0x96F2 },
    { 0xB6B4, 0x97CC },
    { 0xB6B5, 0x9805 },
    { 0xB6B6, 0x9806 },
    { 0xB6B7, 0x9808 },
    { 0xB6B8, 0x98E7 },
    { 0xB6B9, 0x98EA },
    { 0xB6BA, 0x98EF },
    { 0xB6BB, 0x98E9 },
    { 0xB6BC, 0x98F2 },
    { 0xB6BD, 0x98ED },
    { 0xB6BE, 0x99AE },
    { 0xB6BF, 0x99AD },
    { 0xB6C0, 0x9EC3 },
    { 0xB6C1, 0x9ECD },
    { 0xB6C2, 0x9ED1 },
    { 0xB6C3, 0x4E82 },
    { 0xB6C4, 0x50AD },
    { 0xB6C5, 0x50B5 },
    { 0xB6C6, 0x50B2 },
    { 0xB6C7, 0x50B3 },
    { 0xB6C8, 0x50C5 },
    { 0xB6C9, 0x50BE },
    { 0xB6CA, 0x50AC },
    { 0xB6CB, 0x50B7 },
    { 0xB6CC, 0x50BB },
    { 0xB6CD, 0x50AF },
    { 0xB6CE, 0x50C7 },
    { 0xB6CF, 0x527F },
    { 0xB6D0, 0x5277 },
    { 0xB6D1, 0x527D },
    { 0xB6D2, 0x52DF },
    { 0xB6D3, 0x52E6 },
    { 0xB6D4, 0x52E4 },
    { 0xB6D5, 0x52E2 },
    { 0xB6D6, 0x52E3 },
    { 0xB6D7, 0x532F },
    { 0xB6D8, 0x55DF },
    { 0xB6D9, 0x55E8 },
    { 0xB6DA, 0x55D3 },
    { 0xB6DB, 0x55E6 },
    { 0xB6DC, 0x55CE },
    { 0xB6DD, 0x55DC },
    { 0xB6DE, 0x55C7 },
    { 0xB6DF, 0x55D1 },
    { 0xB6E0, 0x55E3 },
    { 0xB6E1, 0x55E4 },
    { 0xB6E2, 0x55EF },
    { 0xB6E3, 0x55DA },
    { 0xB6E4, 0x55E1 },
    { 0xB6E5, 0x55C5 },
    { 0xB6E6, 0x55C6 },
    { 0xB6E7, 0x55E5 },
    { 0xB6E8, 0x55C9 },
    { 0xB6E9, 0x5712 },
    { 0xB6EA, 0x5713 },
    { 0xB6EB, 0x585E },
    { 0xB6EC, 0x5851 },
    { 0xB6ED, 0x5858 },
    { 0xB6EE, 0x5857 },
    { 0xB6EF, 0x585A },
    { 0xB6F0, 0x5854 },
    { 0xB6F1, 0x586B },
    { 0xB6F2, 0x584C },
    { 0xB6F3, 0x586D },
    { 0xB6F4, 0x584A },
    { 0xB6F5, 0x5862 },
    { 0xB6F6, 0x5852 },
    { 0xB6F7, 0x584B },
    { 0xB6F8, 0x5967 },
    { 0xB6F9, 0x5AC1 },
    { 0xB6FA, 0x5AC9 },
    { 0xB6FB, 0x5ACC },
    { 0xB6FC, 0x5ABE },
    { 0xB6FD, 0x5ABD },
    { 0xB6FE, 0x5ABC },
    { 0xB740, 0x5AB3 },
    { 0xB741, 0x5AC2 },
    { 0xB742, 0x5AB2 },
    { 0xB743, 0x5D69 },
    { 0xB744, 0x5D6F },
    { 0xB745, 0x5E4C },
    { 0xB746, 0x5E79 },
    { 0xB747, 0x5EC9 },
    { 0xB748, 0x5EC8 },
    { 0xB749, 0x5F12 },
    { 0xB74A, 0x5F59 },
    { 0xB74B, 0x5FAC },
    { 0xB74C, 0x5FAE },
    { 0xB74D, 0x611A },
    { 0xB74E, 0x610F },
    { 0xB74F, 0x6148 },
    { 0xB750, 0x611F },
    { 0xB751, 0x60F3 },
    { 0xB752, 0x611B },
    { 0xB753, 0x60F9 },
    { 0xB754, 0x6101 },
    { 0xB755, 0x6108 },
    { 0xB756, 0x614E },
    { 0xB757, 0x614C },
    { 0xB758, 0x6144 },
    { 0xB759, 0x614D },
    { 0xB75A, 0x613E },
    { 0xB75B, 0x6134 },
    { 0xB75C, 0x6127 },
    { 0xB75D, 0x610D },
    { 0xB75E, 0x6106 },
    { 0xB75F, 0x6137 },
    { 0xB760, 0x6221 },
    { 0xB761, 0x6222 },
    { 0xB762, 0x6413 },
    { 0xB763, 0x643E },
    { 0xB764, 0x641E },
    { 0xB765, 0x642A },
    { 0xB766, 0x642D },
    { 0xB767, 0x643D },
    { 0xB768, 0x642C },
    { 0xB769, 0x640F },
    { 0xB76A, 0x641C },
    { 0xB76B, 0x6414 },
    { 0xB76C, 0x640D },
    { 0xB76D, 0x6436 },
    { 0xB76E, 0x6416 },
    { 0xB76F, 0x6417 },
    { 0xB770, 0x6406 },
    { 0xB771, 0x656C },
    { 0xB772, 0x659F },
    { 0xB773, 0x65B0 },
    { 0xB774, 0x6697 },
    { 0xB775, 0x6689 },
    { 0xB776, 0x6687 },
    { 0xB777, 0x6688 },
    { 0xB778, 0x6696 },
    { 0xB779, 0x6684 },
    { 0xB77A, 0x6698 },
    { 0xB77B, 0x668D },
    { 0xB77C, 0x6703 },
    { 0xB77D, 0x6994 },
    { 0xB77E, 0x696D },
    { 0xB7A1, 0x695A },
    { 0xB7A2, 0x6977 },
    { 0xB7A3, 0x6960 },
    { 0xB7A4, 0x6954 },
    { 0xB7A5, 0x6975 },
    { 0xB7A6, 0x6930 },
    { 0xB7A7, 0x6982 },
    { 0xB7A8, 0x694A },
    { 0xB7A9, 0x6968 },
    { 0xB7AA, 0x696B },
    { 0xB7AB, 0x695E },
    { 0xB7AC, 0x6953 },
    { 0xB7AD, 0x6979 },
    { 0xB7AE, 0x6986 },
    { 0xB7AF, 0x695D },
    { 0xB7B0, 0x6963 },
    { 0xB7B1, 0x695B },
    { 0xB7B2, 0x6B47 },
    { 0xB7B3, 0x6B72 },
    { 0xB7B4, 0x6BC0 },
    { 0xB7B5, 0x6BBF },
    { 0xB7B6, 0x6BD3 },
    { 0xB7B7, 0x6BFD },
    { 0xB7B8, 0x6EA2 },
    { 0xB7B9, 0x6EAF },
    { 0xB7BA, 0x6ED3 },
    { 0xB7BB, 0x6EB6 },
    { 0xB7BC, 0x6EC2 },
    { 0xB7BD, 0x6E90 },
    { 0xB7BE, 0x6E9D },
    { 0xB7BF, 0x6EC7 },
    { 0xB7C0, 0x6EC5 },
    { 0xB7C1, 0x6EA5 },
    { 0xB7C2, 0x6E98 },
    { 0xB7C3, 0x6EBC },
    { 0xB7C4, 0x6EBA },
    { 0xB7C5, 0x6EAB },
    { 0xB7C6, 0x6ED1 },
    { 0xB7C7, 0x6E96 },
    { 0xB7C8, 0x6E9C },
    { 0xB7C9, 0x6EC4 },
    { 0xB7CA, 0x6ED4 },
    { 0xB7CB, 0x6EAA },
    { 0xB7CC, 0x6EA7 },
    { 0xB7CD, 0x6EB4 },
    { 0xB7CE, 0x714E },
    { 0xB7CF, 0x7159 },
    { 0xB7D0, 0x7169 },
    { 0xB7D1, 0x7164 },
    { 0xB7D2, 0x7149 },
    { 0xB7D3, 0x7167 },
    { 0xB7D4, 0x715C },
    { 0xB7D5, 0x716C },
    { 0xB7D6, 0x7166 },
    { 0xB7D7, 0x714C },
    { 0xB7D8, 0x7165 },
    { 0xB7D9, 0x715E },
    { 0xB7DA, 0x7146 },
    { 0xB7DB, 0x7168 },
    { 0xB7DC, 0x7156 },
    { 0xB7DD, 0x723A },
    { 0xB7DE, 0x7252 },
    { 0xB7DF, 0x7337 },
    { 0xB7E0, 0x7345 },
    { 0xB7E1, 0x733F },
    { 0xB7E2, 0x733E },
    { 0xB7E3, 0x746F },
    { 0xB7E4, 0x745A },
    { 0xB7E5, 0x7455 },
    { 0xB7E6, 0x745F },
    { 0xB7E7, 0x745E },
    { 0xB7E8, 0x7441 },
    { 0xB7E9, 0x743F },
    { 0xB7EA, 0x7459 },
    { 0xB7EB, 0x745B },
    { 0xB7EC, 0x745C },
    { 0xB7ED, 0x7576 },
    { 0xB7EE, 0x7578 },
    { 0xB7EF, 0x7600 },
    { 0xB7F0, 0x75F0 },
    { 0xB7F1, 0x7601 },
    { 0xB7F2, 0x75F2 },
    { 0xB7F3, 0x75F1 },
    { 0xB7F4, 0x75FA },
    { 0xB7F5, 0x75FF },
    { 0xB7F6, 0x75F4 },
    { 0xB7F7, 0x75F3 },
    { 0xB7F8, 0x76DE },
    { 0xB7F9, 0x76DF },
    { 0xB7FA, 0x775B },
    { 0xB7FB, 0x776B },
    { 0xB7FC, 0x7766 },
    { 0xB7FD, 0x775E },
    { 0xB7FE, 0x7763 },
    { 0xB840, 0x7779 },
    { 0xB841, 0x776A },
    { 0xB842, 0x776C },
    { 0xB843, 0x775C },
    { 0xB844, 0x7765 },
    { 0xB845, 0x7768 },
    { 0xB846, 0x7762 },
    { 0xB847, 0x77EE },
    { 0xB848, 0x788E },
    { 0xB849, 0x78B0 },
    { 0xB84A, 0x7897 },
    { 0xB84B, 0x7898 },
    { 0xB84C, 0x788C },
    { 0xB84D, 0x7889 },
    { 0xB84E, 0x787C },
    { 0xB84F, 0x7891 },
    { 0xB850, 0x7893 },
    { 0xB851, 0x787F },
    { 0xB852, 0x797A },
    { 0xB853, 0x797F },
    { 0xB854, 0x7981 },
    { 0xB855, 0x842C },
    { 0xB856, 0x79BD },
    { 0xB857, 0x7A1C },
    { 0xB858, 0x7A1A },
    { 0xB859, 0x7A20 },
    { 0xB85A, 0x7A14 },
    { 0xB85B, 0x7A1F },
    { 0xB85C, 0x7A1E },
    { 0xB85D, 0x7A9F },
    { 0xB85E, 0x7AA0 },
    { 0xB85F, 0x7B77 },
    { 0xB860, 0x7BC0 },
    { 0xB861, 0x7B60 },
    { 0xB862, 0x7B6E },
    { 0xB863, 0x7B67 },
    { 0xB864, 0x7CB1 },
    { 0xB865, 0x7CB3 },
    { 0xB866, 0x7CB5 },
    { 0xB867, 0x7D93 },
    { 0xB868, 0x7D79 },
    { 0xB869, 0x7D91 },
    { 0xB86A, 0x7D81 },
    { 0xB86B, 0x7D8F },
    { 0xB86C, 0x7D5B },
    { 0xB86D, 0x7F6E },
    { 0xB86E, 0x7F69 },
    { 0xB86F, 0x7F6A },
    { 0xB870, 0x7F72 },
    { 0xB871, 0x7FA9 },
    { 0xB872, 0x7FA8 },
    { 0xB873, 0x7FA4 },
    { 0xB874, 0x8056 },
    { 0xB875, 0x8058 },
    { 0xB876, 0x8086 },
    { 0xB877, 0x8084 },
    { 0xB878, 0x8171 },
    { 0xB879, 0x8170 },
    { 0xB87A, 0x8178 },
    { 0xB87B, 0x8165 },
    { 0xB87C, 0x816E },
    { 0xB87D, 0x8173 },
    { 0xB87E, 0x816B },
    { 0xB8A1, 0x8179 },
    { 0xB8A2, 0x817A },
    { 0xB8A3, 0x8166 },
    { 0xB8A4, 0x8205 },
    { 0xB8A5, 0x8247 },
    { 0xB8A6, 0x8482 },
    { 0xB8A7, 0x8477 },
    { 0xB8A8, 0x843D },
    { 0xB8A9, 0x8431 },
    { 0xB8AA, 0x8475 },
    { 0xB8AB, 0x8466 },
    { 0xB8AC, 0x846B },
    { 0xB8AD, 0x8449 },
    { 0xB8AE, 0x846C },
    { 0xB8AF, 0x845B },
    { 0xB8B0, 0x843C },
    { 0xB8B1, 0x8435 },
    { 0xB8B2, 0x8461 },
    { 0xB8B3, 0x8463 },
    { 0xB8B4, 0x8469 },
    { 0xB8B5, 0x846D },
    { 0xB8B6, 0x8446 },
    { 0xB8B7, 0x865E },
    { 0xB8B8, 0x865C },
    { 0xB8B9, 0x865F },
    { 0xB8BA, 0x86F9 },
    { 0xB8BB, 0x8713 },
    { 0xB8BC, 0x8708 },
    { 0xB8BD, 0x8707 },
    { 0xB8BE, 0x8700 },
    { 0xB8BF, 0x86FE },
    { 0xB8C0, 0x86FB },
    { 0xB8C1, 0x8702 },
    { 0xB8C2, 0x8703 },
    { 0xB8C3, 0x8706 },
    { 0xB8C4, 0x870A },
    { 0xB8C5, 0x8859 },
    { 0xB8C6, 0x88DF },
    { 0xB8C7, 0x88D4 },
    { 0xB8C8, 0x88D9 },
    { 0xB8C9, 0x88DC },
    { 0xB8CA, 0x88D8 },
    { 0xB8CB, 0x88DD },
    { 0xB8CC, 0x88E1 },
    { 0xB8CD, 0x88CA },
    { 0xB8CE, 0x88D5 },
    { 0xB8CF, 0x88D2 },
    { 0xB8D0, 0x899C },
    { 0xB8D1, 0x89E3 },
    { 0xB8D2, 0x8A6B },
    { 0xB8D3, 0x8A72 },
    { 0xB8D4, 0x8A73 },
    { 0xB8D5, 0x8A66 },
    { 0xB8D6, 0x8A69 },
    { 0xB8D7, 0x8A70 },
    { 0xB8D8, 0x8A87 },
    { 0xB8D9, 0x8A7C },
    { 0xB8DA, 0x8A63 },
    { 0xB8DB, 0x8AA0 },
    { 0xB8DC, 0x8A71 },
    { 0xB8DD, 0x8A85 },
    { 0xB8DE, 0x8A6D },
    { 0xB8DF, 0x8A62 },
    { 0xB8E0, 0x8A6E },
    { 0xB8E1, 0x8A6C },
    { 0xB8E2, 0x8A79 },
    { 0xB8E3, 0x8A7B },
    { 0xB8E4, 0x8A3E },
    { 0xB8E5, 0x8A68 },
    { 0xB8E6, 0x8C62 },
    { 0xB8E7, 0x8C8A },
    { 0xB8E8, 0x8C89 },
    { 0xB8E9, 0x8CCA },
    { 0xB8EA, 0x8CC7 },
    { 0xB8EB, 0x8CC8 },
    { 0xB8EC, 0x8CC4 },
    { 0xB8ED, 0x8CB2 },
    { 0xB8EE, 0x8CC3 },
    { 0xB8EF, 0x8CC2 },
    { 0xB8F0, 0x8CC5 },
    { 0xB8F1, 0x8DE1 },
    { 0xB8F2, 0x8DDF },
    { 0xB8F3, 0x8DE8 },
    { 0xB8F4, 0x8DEF },
    { 0xB8F5, 0x8DF3 },
    { 0xB8F6, 0x8DFA },
    { 0xB8F7, 0x8DEA },
    { 0xB8F8, 0x8DE4 },
    { 0xB8F9, 0x8DE6 },
    { 0xB8FA, 0x8EB2 },
    { 0xB8FB, 0x8F03 },
    { 0xB8FC, 0x8F09 },
    { 0xB8FD, 0x8EFE },
    { 0xB8FE, 0x8F0A },
    { 0xB940, 0x8F9F },
    { 0xB941, 0x8FB2 },
    { 0xB942, 0x904B },
    { 0xB943, 0x904A },
    { 0xB944, 0x9053 },
    { 0xB945, 0x9042 },
    { 0xB946, 0x9054 },
    { 0xB947, 0x903C },
    { 0xB948, 0x9055 },
    { 0xB949, 0x9050 },
    { 0xB94A, 0x9047 },
    { 0xB94B, 0x904F },
    { 0xB94C, 0x904E },
    { 0xB94D, 0x904D },
    { 0xB94E, 0x9051 },
    { 0xB94F, 0x903E },
    { 0xB950, 0x9041 },
    { 0xB951, 0x9112 },
    { 0xB952, 0x9117 },
    { 0xB953, 0x916C },
    { 0xB954, 0x916A },
    { 0xB955, 0x9169 },
    { 0xB956, 0x91C9 },
    { 0xB957, 0x9237 },
    { 0xB958, 0x9257 },
    { 0xB959, 0x9238 },
    { 0xB95A, 0x923D },
    { 0xB95B, 0x9240 },
    { 0xB95C, 0x923E },
    { 0xB95D, 0x925B },
    { 0xB95E, 0x924B },
    { 0xB95F, 0x9264 },
    { 0xB960, 0x9251 },
    { 0xB961, 0x9234 },
    { 0xB962, 0x9249 },
    { 0xB963, 0x924D },
    { 0xB964, 0x9245 },
    { 0xB965, 0x9239 },
    { 0xB966, 0x923F },
    { 0xB967, 0x925A },
    { 0xB968, 0x9598 },
    { 0xB969, 0x9698 },
    { 0xB96A, 0x9694 },
    { 0xB96B, 0x9695 },
    { 0xB96C, 0x96CD },
    { 0xB96D, 0x96CB },
    { 0xB96E, 0x96C9 },
    { 0xB96F, 0x96CA },
    { 0xB970, 0x96F7 },
    { 0xB971, 0x96FB },
    { 0xB972, 0x96F9 },
    { 0xB973, 0x96F6 },
    { 0xB974, 0x9756 },
    { 0xB975, 0x9774 },
    { 0xB976, 0x9776 },
    { 0xB977, 0x9810 },
    { 0xB978, 0x9811 },
    { 0xB979, 0x9813 },
    { 0xB97A, 0x980A },
    { 0xB97B, 0x9812 },
    { 0xB97C, 0x980C },
    { 0xB97D, 0x98FC },
    { 0xB97E, 0x98F4 },
    { 0xB9A1, 0x98FD },
    { 0xB9A2, 0x98FE },
    { 0xB9A3, 0x99B3 },
    { 0xB9A4, 0x99B1 },
    { 0xB9A5, 0x99B4 },
    { 0xB9A6, 0x9AE1 },
    { 0xB9A7, 0x9CE9 },
    { 0xB9A8, 0x9E82 },
    { 0xB9A9, 0x9F0E },
    { 0xB9AA, 0x9F13 },
    { 0xB9AB, 0x9F20 },
    { 0xB9AC, 0x50E7 },
    { 0xB9AD, 0x50EE },
    { 0xB9AE, 0x50E5 },
    { 0xB9AF, 0x50D6 },
    { 0xB9B0, 0x50ED },
    { 0xB9B1, 0x50DA },
    { 0xB9B2, 0x50D5 },
    { 0xB9B3, 0x50CF },
    { 0xB9B4, 0x50D1 },
    { 0xB9B5, 0x50F1 },
    { 0xB9B6, 0x50CE },
    { 0xB9B7, 0x50E9 },
    { 0xB9B8, 0x5162 },
    { 0xB9B9, 0x51F3 },
    { 0xB9BA, 0x5283 },
    { 0xB9BB, 0x5282 },
    { 0xB9BC, 0x5331 },
    { 0xB9BD, 0x53AD },
    { 0xB9BE, 0x55FE },
    { 0xB9BF, 0x5600 },
    { 0xB9C0, 0x561B },
    { 0xB9C1, 0x5617 },
    { 0xB9C2, 0x55FD },
    { 0xB9C3, 0x5614 },
    { 0xB9C4, 0x5606 },
    { 0xB9C5, 0x5609 },
    { 0xB9C6, 0x560D },
    { 0xB9C7, 0x560E },
    { 0xB9C8, 0x55F7 },
    { 0xB9C9, 0x5616 },
    { 0xB9CA, 0x561F },
    { 0xB9CB, 0x5608 },
    { 0xB9CC, 0x5610 },
    { 0xB9CD, 0x55F6 },
    { 0xB9CE, 0x5718 },
    { 0xB9CF, 0x5716 },
    { 0xB9D0, 0x5875 },
    { 0xB9D1, 0x587E },
    { 0xB9D2, 0x5883 },
    { 0xB9D3, 0x5893 },
    { 0xB9D4, 0x588A },
    { 0xB9D5, 0x5879 },
    { 0xB9D6, 0x5885 },
    { 0xB9D7, 0x587D },
    { 0xB9D8, 0x58FD },
    { 0xB9D9, 0x5925 },
    { 0xB9DA, 0x5922 },
    { 0xB9DB, 0x5924 },
    { 0xB9DC, 0x596A },
    { 0xB9DD, 0x5969 },
    { 0xB9DE, 0x5AE1 },
    { 0xB9DF, 0x5AE6 },
    { 0xB9E0, 0x5AE9 },
    { 0xB9E1, 0x5AD7 },
    { 0xB9E2, 0x5AD6 },
    { 0xB9E3, 0x5AD8 },
    { 0xB9E4, 0x5AE3 },
    { 0xB9E5, 0x5B75 },
    { 0xB9E6, 0x5BDE },
    { 0xB9E7, 0x5BE7 },
    { 0xB9E8, 0x5BE1 },
    { 0xB9E9, 0x5BE5 },
    { 0xB9EA, 0x5BE6 },
    { 0xB9EB, 0x5BE8 },
    { 0xB9EC, 0x5BE2 },
    { 0xB9ED, 0x5BE4 },
    { 0xB9EE, 0x5BDF },
    { 0xB9EF, 0x5C0D },
    { 0xB9F0, 0x5C62 },
    { 0xB9F1, 0x5D84 },
    { 0xB9F2, 0x5D87 },
    { 0xB9F3, 0x5E5B },
    { 0xB9F4, 0x5E63 },
    { 0xB9F5, 0x5E55 },
    { 0xB9F6, 0x5E57 },
    { 0xB9F7, 0x5E54 },
    { 0xB9F8, 0x5ED3 },
    { 0xB9F9, 0x5ED6 },
    { 0xB9FA, 0x5F0A },
    { 0xB9FB, 0x5F46 },
    { 0xB9FC, 0x5F70 },
    { 0xB9FD, 0x5FB9 },
    { 0xB9FE, 0x6147 },
    { 0xBA40, 0x613F },
    { 0xBA41, 0x614B },
    { 0xBA42, 0x6177 },
    { 0xBA43, 0x6162 },
    { 0xBA44, 0x6163 },
    { 0xBA45, 0x615F },
    { 0xBA46, 0x615A },
    { 0xBA47, 0x6158 },
    { 0xBA48, 0x6175 },
    { 0xBA49, 0x622A },
    { 0xBA4A, 0x6487 },
    { 0xBA4B, 0x6458 },
    { 0xBA4C, 0x6454 },
    { 0xBA4D, 0x64A4 },
    { 0xBA4E, 0x6478 },
    { 0xBA4F, 0x645F },
    { 0xBA50, 0x647A },
    { 0xBA51, 0x6451 },
    { 0xBA52, 0x6467 },
    { 0xBA53, 0x6434 },
    { 0xBA54, 0x646D },
    { 0xBA55, 0x647B },
    { 0xBA56, 0x6572 },
    { 0xBA57, 0x65A1 },
    { 0xBA58, 0x65D7 },
    { 0xBA59, 0x65D6 },
    { 0xBA5A, 0x66A2 },
    { 0xBA5B, 0x66A8 },
    { 0xBA5C, 0x669D },
    { 0xBA5D, 0x699C },
    { 0xBA5E, 0x69A8 },
    { 0xBA5F, 0x6995 },
    { 0xBA60, 0x69C1 },
    { 0xBA61, 0x69AE },
    { 0xBA62, 0x69D3 },
    { 0xBA63, 0x69CB },
    { 0xBA64, 0x699B },
    { 0xBA65, 0x69B7 },
    { 0xBA66, 0x69BB },
    { 0xBA67, 0x69AB },
    { 0xBA68, 0x69B4 },
    { 0xBA69, 0x69D0 },
    { 0xBA6A, 0x69CD },
    { 0xBA6B, 0x69AD },
    { 0xBA6C, 0x69CC },
    { 0xBA6D, 0x69A6 },
    { 0xBA6E, 0x69C3 },
    { 0xBA6F, 0x69A3 },
    { 0xBA70, 0x6B49 },
    { 0xBA71, 0x6B4C },
    { 0xBA72, 0x6C33 },
    { 0xBA73, 0x6F33 },
    { 0xBA74, 0x6F14 },
    { 0xBA75, 0x6EFE },
    { 0xBA76, 0x6F13 },
    { 0xBA77, 0x6EF4 },
    { 0xBA78, 0x6F29 },
    { 0xBA79, 0x6F3E },
    { 0xBA7A, 0x6F20 },
    { 0xBA7B, 0x6F2C },
    { 0xBA7C, 0x6F0F },
    { 0xBA7D, 0x6F02 },
    { 0xBA7E, 0x6F22 },
    { 0xBAA1, 0x6EFF },
    { 0xBAA2, 0x6EEF },
    { 0xBAA3, 0x6F06 },
    { 0xBAA4, 0x6F31 },
    { 0xBAA5, 0x6F38 },
    { 0xBAA6, 0x6F32 },
    { 0xBAA7, 0x6F23 },
    { 0xBAA8, 0x6F15 },
    { 0xBAA9, 0x6F2B },
    { 0xBAAA, 0x6F2F },
    { 0xBAAB, 0x6F88 },
    { 0xBAAC, 0x6F2A },
    { 0xBAAD, 0x6EEC },
    { 0xBAAE, 0x6F01 },
    { 0xBAAF, 0x6EF2 },
    { 0xBAB0, 0x6ECC },
    { 0xBAB1, 0x6EF7 },
    { 0xBAB2, 0x7194 },
    { 0xBAB3, 0x7199 },
    { 0xBAB4, 0x717D },
    { 0xBAB5, 0x718A },
    { 0xBAB6, 0x7184 },
    { 0xBAB7, 0x7192 },
    { 0xBAB8, 0x723E },
    { 0xBAB9, 0x7292 },
    { 0xBABA, 0x7296 },
    { 0xBABB, 0x7344 },
    { 0xBABC, 0x7350 },
    { 0xBABD, 0x7464 },
    { 0xBABE, 0x7463 },
    { 0xBABF, 0x746A },
    { 0xBAC0, 0x7470 },
    { 0xBAC1, 0x746D },
    { 0xBAC2, 0x7504 },
    { 0xBAC3, 0x7591 },
    { 0xBAC4, 0x7627 },
    { 0xBAC5, 0x760D },
    { 0xBAC6, 0x760B },
    { 0xBAC7, 0x7609 },
    { 0xBAC8, 0x7613 },
    { 0xBAC9, 0x76E1 },
    { 0xBACA, 0x76E3 },
    { 0xBACB, 0x7784 },
    { 0xBACC, 0x777D },
    { 0xBACD, 0x777F },
    { 0xBACE, 0x7761 },
    { 0xBACF, 0x78C1 },
    { 0xBAD0, 0x789F },
    { 0xBAD1, 0x78A7 },
    { 0xBAD2, 0x78B3 },
    { 0xBAD3, 0x78A9 },
    { 0xBAD4, 0x78A3 },
    { 0xBAD5, 0x798E },
    { 0xBAD6, 0x798F },
    { 0xBAD7, 0x798D },
    { 0xBAD8, 0x7A2E },
    { 0xBAD9, 0x7A31 },
    { 0xBADA, 0x7AAA },
    { 0xBADB, 0x7AA9 },
    { 0xBADC, 0x7AED },
    { 0xBADD, 0x7AEF },
    { 0xBADE, 0x7BA1 },
    { 0xBADF, 0x7B95 },
    { 0xBAE0, 0x7B8B },
    { 0xBAE1, 0x7B75 },
    { 0xBAE2, 0x7B97 },
    { 0xBAE3, 0x7B9D },
    { 0xBAE4, 0x7B94 },
    { 0xBAE5, 0x7B8F },
    { 0xBAE6, 0x7BB8 },
    { 0xBAE7, 0x7B87 },
    { 0xBAE8, 0x7B84 },
    { 0xBAE9, 0x7CB9 },
    { 0xBAEA, 0x7CBD },
    { 0xBAEB, 0x7CBE },
    { 0xBAEC, 0x7DBB },
    { 0xBAED, 0x7DB0 },
    { 0xBAEE, 0x7D9C },
    { 0xBAEF, 0x7DBD },
    { 0xBAF0, 0x7DBE },
    { 0xBAF1, 0x7DA0 },
    { 0xBAF2, 0x7DCA },
    { 0xBAF3, 0x7DB4 },
    { 0xBAF4, 0x7DB2 },
    { 0xBAF5, 0x7DB1 },
    { 0xBAF6, 0x7DBA },
    { 0xBAF7, 0x7DA2 },
    { 0xBAF8, 0x7DBF },
    { 0xBAF9, 0x7DB5 },
    { 0xBAFA, 0x7DB8 },
    { 0xBAFB, 0x7DAD },
    { 0xBAFC, 0x7DD2 },
    { 0xBAFD, 0x7DC7 },
    { 0xBAFE, 0x7DAC },
    { 0xBB40, 0x7F70 },
    { 0xBB41, 0x7FE0 },
    { 0xBB42, 0x7FE1 },
    { 0xBB43, 0x7FDF },
    { 0xBB44, 0x805E },
    { 0xBB45, 0x805A },
    { 0xBB46, 0x8087 },
    { 0xBB47, 0x8150 },
    { 0xBB48, 0x8180 },
    { 0xBB49, 0x818F },
    { 0xBB4A, 0x8188 },
    { 0xBB4B, 0x818A },
    { 0xBB4C, 0x817F },
    { 0xBB4D, 0x8182 },
    { 0xBB4E, 0x81E7 },
    { 0xBB4F, 0x81FA },
    { 0xBB50, 0x8207 },
    { 0xBB51, 0x8214 },
    { 0xBB52, 0x821E },
    { 0xBB53, 0x824B },
    { 0xBB54, 0x84C9 },
    { 0xBB55, 0x84BF },
    { 0xBB56, 0x84C6 },
    { 0xBB57, 0x84C4 },
    { 0xBB58, 0x8499 },
    { 0xBB59, 0x849E },
    { 0xBB5A, 0x84B2 },
    { 0xBB5B, 0x849C },
    { 0xBB5C, 0x84CB },
    { 0xBB5D, 0x84B8 },
    { 0xBB5E, 0x84C0 },
    { 0xBB5F, 0x84D3 },
    { 0xBB60, 0x8490 },
    { 0xBB61, 0x84BC },
    { 0xBB62, 0x84D1 },
    { 0xBB63, 0x84CA },
    { 0xBB64, 0x873F },
    { 0xBB65, 0x871C },
    { 0xBB66, 0x873B },
    { 0xBB67, 0x8722 },
    { 0xBB68, 0x8725 },
    { 0xBB69, 0x8734 },
    { 0xBB6A, 0x8718 },
    { 0xBB6B, 0x8755 },
    { 0xBB6C, 0x8737 },
    { 0xBB6D, 0x8729 },
    { 0xBB6E, 0x88F3 },
    { 0xBB6F, 0x8902 },
    { 0xBB70, 0x88F4 },
    { 0xBB71, 0x88F9 },
    { 0xBB72, 0x88F8 },
    { 0xBB73, 0x88FD },
    { 0xBB74, 0x88E8 },
    { 0xBB75, 0x891A },
    { 0xBB76, 0x88EF },
    { 0xBB77, 0x8AA6 },
    { 0xBB78, 0x8A8C },
    { 0xBB79, 0x8A9E },
    { 0xBB7A, 0x8AA3 },
    { 0xBB7B, 0x8A8D },
    { 0xBB7C, 0x8AA1 },
    { 0xBB7D, 0x8A93 },
    { 0xBB7E, 0x8AA4 },
    { 0xBBA1, 0x8AAA },
    { 0xBBA2, 0x8AA5 },
    { 0xBBA3, 0x8AA8 },
    { 0xBBA4, 0x8A98 },
    { 0xBBA5, 0x8A91 },
    { 0xBBA6, 0x8A9A },
    { 0xBBA7, 0x8AA7 },
    { 0xBBA8, 0x8C6A },
    { 0xBBA9, 0x8C8D },
    { 0xBBAA, 0x8C8C },
    { 0xBBAB, 0x8CD3 },
    { 0xBBAC, 0x8CD1 },
    { 0xBBAD, 0x8CD2 },
    { 0xBBAE, 0x8D6B },
    { 0xBBAF, 0x8D99 },
    { 0xBBB0, 0x8D95 },
    { 0xBBB1, 0x8DFC },
    { 0xBBB2, 0x8F14 },
    { 0xBBB3, 0x8F12 },
    { 0xBBB4, 0x8F15 },
    { 0xBBB5, 0x8F13 },
    { 0xBBB6, 0x8FA3 },
    { 0xBBB7, 0x9060 },
    { 0xBBB8, 0x9058 },
    { 0xBBB9, 0x905C },
    { 0xBBBA, 0x9063 },
    { 0xBBBB, 0x9059 },
    { 0xBBBC, 0x905E },
    { 0xBBBD, 0x9062 },
    { 0xBBBE, 0x905D },
    { 0xBBBF, 0x905B },
    { 0xBBC0, 0x9119 },
    { 0xBBC1, 0x9118 },
    { 0xBBC2, 0x911E },
    { 0xBBC3, 0x9175 },
    { 0xBBC4, 0x9178 },
    { 0xBBC5, 0x9177 },
    { 0xBBC6, 0x9174 },
    { 0xBBC7, 0x9278 },
    { 0xBBC8, 0x9280 },
    { 0xBBC9, 0x9285 },
    { 0xBBCA, 0x9298 },
    { 0xBBCB, 0x9296 },
    { 0xBBCC, 0x927B },
    { 0xBBCD, 0x9293 },
    { 0xBBCE, 0x929C },
    { 0xBBCF, 0x92A8 },
    { 0xBBD0, 0x927C },
    { 0xBBD1, 0x9291 },
    { 0xBBD2, 0x95A1 },
    { 0xBBD3, 0x95A8 },
    { 0xBBD4, 0x95A9 },
    { 0xBBD5, 0x95A3 },
    { 0xBBD6, 0x95A5 },
    { 0xBBD7, 0x95A4 },
    { 0xBBD8, 0x9699 },
    { 0xBBD9, 0x969C },
    { 0xBBDA, 0x969B },
    { 0xBBDB, 0x96CC },
    { 0xBBDC, 0x96D2 },
    { 0xBBDD, 0x9700 },
    { 0xBBDE, 0x977C },
    { 0xBBDF, 0x9785 },
    { 0xBBE0, 0x97F6 },
    { 0xBBE1, 0x9817 },
    { 0xBBE2, 0x9818 },
    { 0xBBE3, 0x98AF },
    { 0xBBE4, 0x98B1 },
    { 0xBBE5, 0x9903 },
    { 0xBBE6, 0x9905 },
    { 0xBBE7, 0x990C },
    { 0xBBE8, 0x9909 },
    { 0xBBE9, 0x99C1 },
    { 0xBBEA, 0x9AAF },
    { 0xBBEB, 0x9AB0 },
    { 0xBBEC, 0x9AE6 },
    { 0xBBED, 0x9B41 },
    { 0xBBEE, 0x9B42 },
    { 0xBBEF, 0x9CF4 },
    { 0xBBF0, 0x9CF6 },
    { 0xBBF1, 0x9CF3 },
    { 0xBBF2, 0x9EBC },
    { 0xBBF3, 0x9F3B },
    { 0xBBF4, 0x9F4A },
    { 0xBBF5, 0x5104 },
    { 0xBBF6, 0x5100 },
    { 0xBBF7, 0x50FB },
    { 0xBBF8, 0x50F5 },
    { 0xBBF9, 0x50F9 },
    { 0xBBFA, 0x5102 },
    { 0xBBFB, 0x5108 },
    { 0xBBFC, 0x5109 },
    { 0xBBFD, 0x5105 },
    { 0xBBFE, 0x51DC },
    { 0xBC40, 0x5287 },
    { 0xBC41, 0x5288 },
    { 0xBC42, 0x5289 },
    { 0xBC43, 0x528D },
    { 0xBC44, 0x528A },
    { 0xBC45, 0x52F0 },
    { 0xBC46, 0x53B2 },
    { 0xBC47, 0x562E },
    { 0xBC48, 0x563B },
    { 0xBC49, 0x5639 },
    { 0xBC4A, 0x5632 },
    { 0xBC4B, 0x563F },
    { 0xBC4C, 0x5634 },
    { 0xBC4D, 0x5629 },
    { 0xBC4E, 0x5653 },
    { 0xBC4F, 0x564E },
    { 0xBC50, 0x5657 },
    { 0xBC51, 0x5674 },
    { 0xBC52, 0x5636 },
    { 0xBC53, 0x562F },
    { 0xBC54, 0x5630 },
    { 0xBC55, 0x5880 },
    { 0xBC56, 0x589F },
    { 0xBC57, 0x589E },
    { 0xBC58, 0x58B3 },
    { 0xBC59, 0x589C },
    { 0xBC5A, 0x58AE },
    { 0xBC5B, 0x58A9 },
    { 0xBC5C, 0x58A6 },
    { 0xBC5D, 0x596D },
    { 0xBC5E, 0x5B09 },
    { 0xBC5F, 0x5AFB },
    { 0xBC60, 0x5B0B },
    { 0xBC61, 0x5AF5 },
    { 0xBC62, 0x5B0C },
    { 0xBC63, 0x5B08 },
    { 0xBC64, 0x5BEE },
    { 0xBC65, 0x5BEC },
    { 0xBC66, 0x5BE9 },
    { 0xBC67, 0x5BEB },
    { 0xBC68, 0x5C64 },
    { 0xBC69, 0x5C65 },
    { 0xBC6A, 0x5D9D },
    { 0xBC6B, 0x5D94 },
    { 0xBC6C, 0x5E62 },
    { 0xBC6D, 0x5E5F },
    { 0xBC6E, 0x5E61 },
    { 0xBC6F, 0x5EE2 },
    { 0xBC70, 0x5EDA },
    { 0xBC71, 0x5EDF },
    { 0xBC72, 0x5EDD },
    { 0xBC73, 0x5EE3 },
    { 0xBC74, 0x5EE0 },
    { 0xBC75, 0x5F48 },
    { 0xBC76, 0x5F71 },
    { 0xBC77, 0x5FB7 },
    { 0xBC78, 0x5FB5 },
    { 0xBC79, 0x6176 },
    { 0xBC7A, 0x6167 },
    { 0xBC7B, 0x616E },
    { 0xBC7C, 0x615D },
    { 0xBC7D, 0x6155 },
    { 0xBC7E, 0x6182 },
    { 0xBCA1, 0x617C },
    { 0xBCA2, 0x6170 },
    { 0xBCA3, 0x616B },
    { 0xBCA4, 0x617E },
    { 0xBCA5, 0x61A7 },
    { 0xBCA6, 0x6190 },
    { 0xBCA7, 0x61AB },
    { 0xBCA8, 0x618E },
    { 0xBCA9, 0x61AC },
    { 0xBCAA, 0x619A },
    { 0xBCAB, 0x61A4 },
    { 0xBCAC, 0x6194 },
    { 0xBCAD, 0x61AE },
    { 0xBCAE, 0x622E },
    { 0xBCAF, 0x6469 },
    { 0xBCB0, 0x646F },
    { 0xBCB1, 0x6479 },
    { 0xBCB2, 0x649E },
    { 0xBCB3, 0x64B2 },
    { 0xBCB4, 0x6488 },
    { 0xBCB5, 0x6490 },
    { 0xBCB6, 0x64B0 },
    { 0xBCB7, 0x64A5 },
    { 0xBCB8, 0x6493 },
    { 0xBCB9, 0x6495 },
    { 0xBCBA, 0x64A9 },
    { 0xBCBB, 0x6492 },
    { 0xBCBC, 0x64AE },
    { 0xBCBD, 0x64AD },
    { 0xBCBE, 0x64AB },
    { 0xBCBF, 0x649A },
    { 0xBCC0, 0x64AC },
    { 0xBCC1, 0x6499 },
    { 0xBCC2, 0x64A2 },
    { 0xBCC3, 0x64B3 },
    { 0xBCC4, 0x6575 },
    { 0xBCC5, 0x6577 },
    { 0xBCC6, 0x6578 },
    { 0xBCC7, 0x66AE },
    { 0xBCC8, 0x66AB },
    { 0xBCC9, 0x66B4 },
    { 0xBCCA, 0x66B1 },
    { 0xBCCB, 0x6A23 },
    { 0xBCCC, 0x6A1F },
    { 0xBCCD, 0x69E8 },
    { 0xBCCE, 0x6A01 },
    { 0xBCCF, 0x6A1E },
    { 0xBCD0, 0x6A19 },
    { 0xBCD1, 0x69FD },
    { 0xBCD2, 0x6A21 },
    { 0xBCD3, 0x6A13 },
    { 0xBCD4, 0x6A0A },
    { 0xBCD5, 0x69F3 },
    { 0xBCD6, 0x6A02 },
    { 0xBCD7, 0x6A05 },
    { 0xBCD8, 0x69ED },
    { 0xBCD9, 0x6A11 },
    { 0xBCDA, 0x6B50 },
    { 0xBCDB, 0x6B4E },
    { 0xBCDC, 0x6BA4 },
    { 0xBCDD, 0x6BC5 },
    { 0xBCDE, 0x6BC6 },
    { 0xBCDF, 0x6F3F },
    { 0xBCE0, 0x6F7C },
    { 0xBCE1, 0x6F84 },
    { 0xBCE2, 0x6F51 },
    { 0xBCE3, 0x6F66 },
    { 0xBCE4, 0x6F54 },
    { 0xBCE5, 0x6F86 },
    { 0xBCE6, 0x6F6D },
    { 0xBCE7, 0x6F5B },
    { 0xBCE8, 0x6F78 },
    { 0xBCE9, 0x6F6E },
    { 0xBCEA, 0x6F8E },
    { 0xBCEB, 0x6F7A },
    { 0xBCEC, 0x6F70 },
    { 0xBCED, 0x6F64 },
    { 0xBCEE, 0x6F97 },
    { 0xBCEF, 0x6F58 },
    { 0xBCF0, 0x6ED5 },
    { 0xBCF1, 0x6F6F },
    { 0xBCF2, 0x6F60 },
    { 0xBCF3, 0x6F5F },
    { 0xBCF4, 0x719F },
    { 0xBCF5, 0x71AC },
    { 0xBCF6, 0x71B1 },
    { 0xBCF7, 0x71A8 },
    { 0xBCF8, 0x7256 },
    { 0xBCF9, 0x729B },
    { 0xBCFA, 0x734E },
    { 0xBCFB, 0x7357 },
    { 0xBCFC, 0x7469 },
    { 0xBCFD, 0x748B },
    { 0xBCFE, 0x7483 },
    { 0xBD40, 0x747E },
    { 0xBD41, 0x7480 },
    { 0xBD42, 0x757F },
    { 0xBD43, 0x7620 },
    { 0xBD44, 0x7629 },
    { 0xBD45, 0x761F },
    { 0xBD46, 0x7624 },
    { 0xBD47, 0x7626 },
    { 0xBD48, 0x7621 },
    { 0xBD49, 0x7622 },
    { 0xBD4A, 0x769A },
    { 0xBD4B, 0x76BA },
    { 0xBD4C, 0x76E4 },
    { 0xBD4D, 0x778E },
    { 0xBD4E, 0x7787 },
    { 0xBD4F, 0x778C },
    { 0xBD50, 0x7791 },
    { 0xBD51, 0x778B },
    { 0xBD52, 0x78CB },
    { 0xBD53, 0x78C5 },
    { 0xBD54, 0x78BA },
    { 0xBD55, 0x78CA },
    { 0xBD56, 0x78BE },
    { 0xBD57, 0x78D5 },
    { 0xBD58, 0x78BC },
    { 0xBD59, 0x78D0 },
    { 0xBD5A, 0x7A3F },
    { 0xBD5B, 0x7A3C },
    { 0xBD5C, 0x7A40 },
    { 0xBD5D, 0x7A3D },
    { 0xBD5E, 0x7A37 },
    { 0xBD5F, 0x7A3B },
    { 0xBD60, 0x7AAF },
    { 0xBD61, 0x7AAE },
    { 0xBD62, 0x7BAD },
    { 0xBD63, 0x7BB1 },
    { 0xBD64, 0x7BC4 },
    { 0xBD65, 0x7BB4 },
    { 0xBD66, 0x7BC6 },
    { 0xBD67, 0x7BC7 },
    { 0xBD68, 0x7BC1 },
    { 0xBD69, 0x7BA0 },
    { 0xBD6A, 0x7BCC },
    { 0xBD6B, 0x7CCA },
    { 0xBD6C, 0x7DE0 },
    { 0xBD6D, 0x7DF4 },
    { 0xBD6E, 0x7DEF },
    { 0xBD6F, 0x7DFB },
    { 0xBD70, 0x7DD8 },
    { 0xBD71, 0x7DEC },
    { 0xBD72, 0x7DDD },
    { 0xBD73, 0x7DE8 },
    { 0xBD74, 0x7DE3 },
    { 0xBD75, 0x7DDA },
    { 0xBD76, 0x7DDE },
    { 0xBD77, 0x7DE9 },
    { 0xBD78, 0x7D9E },
    { 0xBD79, 0x7DD9 },
    { 0xBD7A, 0x7DF2 },
    { 0xBD7B, 0x7DF9 },
    { 0xBD7C, 0x7F75 },
    { 0xBD7D, 0x7F77 },
    { 0xBD7E, 0x7FAF },
    { 0xBDA1, 0x7FE9 },
    { 0xBDA2, 0x8026 },
    { 0xBDA3, 0x819B },
    { 0xBDA4, 0x819C },
    { 0xBDA5, 0x819D },
    { 0xBDA6, 0x81A0 },
    { 0xBDA7, 0x819A },
    { 0xBDA8, 0x8198 },
    { 0xBDA9, 0x8517 },
    { 0xBDAA, 0x853D },
    { 0xBDAB, 0x851A },
    { 0xBDAC, 0x84EE },
    { 0xBDAD, 0x852C },
    { 0xBDAE, 0x852D },
    { 0xBDAF, 0x8513 },
    { 0xBDB0, 0x8511 },
    { 0xBDB1, 0x8523 },
    { 0xBDB2, 0x8521 },
    { 0xBDB3, 0x8514 },
    { 0xBDB4, 0x84EC },
    { 0xBDB5, 0x8525 },
    { 0xBDB6, 0x84FF },
    { 0xBDB7, 0x8506 },
    { 0xBDB8, 0x8782 },
    { 0xBDB9, 0x8774 },
    { 0xBDBA, 0x8776 },
    { 0xBDBB, 0x8760 },
    { 0xBDBC, 0x8766 },
    { 0xBDBD, 0x8778 },
    { 0xBDBE, 0x8768 },
    { 0xBDBF, 0x8759 },
    { 0xBDC0, 0x8757 },
    { 0xBDC1, 0x874C },
    { 0xBDC2, 0x8753 },
    { 0xBDC3, 0x885B },
    { 0xBDC4, 0x885D },
    { 0xBDC5, 0x8910 },
    { 0xBDC6, 0x8907 },
    { 0xBDC7, 0x8912 },
    { 0xBDC8, 0x8913 },
    { 0xBDC9, 0x8915 },
    { 0xBDCA, 0x890A },
    { 0xBDCB, 0x8ABC },
    { 0xBDCC, 0x8AD2 },
    { 0xBDCD, 0x8AC7 },
    { 0xBDCE, 0x8AC4 },
    { 0xBDCF, 0x8A95 },
    { 0xBDD0, 0x8ACB },
    { 0xBDD1, 0x8AF8 },
    { 0xBDD2, 0x8AB2 },
    { 0xBDD3, 0x8AC9 },
    { 0xBDD4, 0x8AC2 },
    { 0xBDD5, 0x8ABF },
    { 0xBDD6, 0x8AB0 },
    { 0xBDD7, 0x8AD6 },
    { 0xBDD8, 0x8ACD },
    { 0xBDD9, 0x8AB6 },
    { 0xBDDA, 0x8AB9 },
    { 0xBDDB, 0x8ADB },
    { 0xBDDC, 0x8C4C },
    { 0xBDDD, 0x8C4E },
    { 0xBDDE, 0x8C6C },
    { 0xBDDF, 0x8CE0 },
    { 0xBDE0, 0x8CDE },
    { 0xBDE1, 0x8CE6 },
    { 0xBDE2, 0x8CE4 },
    { 0xBDE3, 0x8CEC },
    { 0xBDE4, 0x8CED },
    { 0xBDE5, 0x8CE2 },
    { 0xBDE6, 0x8CE3 },
    { 0xBDE7, 0x8CDC },
    { 0xBDE8, 0x8CEA },
    { 0xBDE9, 0x8CE1 },
    { 0xBDEA, 0x8D6D },
    { 0xBDEB, 0x8D9F },
    { 0xBDEC, 0x8DA3 },
    { 0xBDED, 0x8E2B },
    { 0xBDEE, 0x8E10 },
    { 0xBDEF, 0x8E1D },
    { 0xBDF0, 0x8E22 },
    { 0xBDF1, 0x8E0F },
    { 0xBDF2, 0x8E29 },
    { 0xBDF3, 0x8E1F },
    { 0xBDF4, 0x8E21 },
    { 0xBDF5, 0x8E1E },
    { 0xBDF6, 0x8EBA },
    { 0xBDF7, 0x8F1D },
    { 0xBDF8, 0x8F1B },
    { 0xBDF9, 0x8F1F },
    { 0xBDFA, 0x8F29 },
    { 0xBDFB, 0x8F26 },
    { 0xBDFC, 0x8F2A },
    { 0xBDFD, 0x8F1C },
    { 0xBDFE, 0x8F1E },
    { 0xBE40, 0x8F25 },
    { 0xBE41, 0x9069 },
    { 0xBE42, 0x906E },
    { 0xBE43, 0x9068 },
    { 0xBE44, 0x906D },
    { 0xBE45, 0x9077 },
    { 0xBE46, 0x9130 },
    { 0xBE47, 0x912D },
    { 0xBE48, 0x9127 },
    { 0xBE49, 0x9131 },
    { 0xBE4A, 0x9187 },
    { 0xBE4B, 0x9189 },
    { 0xBE4C, 0x918B },
    { 0xBE4D, 0x9183 },
    { 0xBE4E, 0x92C5 },
    { 0xBE4F, 0x92BB },
    { 0xBE50, 0x92B7 },
    { 0xBE51, 0x92EA },
    { 0xBE52, 0x92AC },
    { 0xBE53, 0x92E4 },
    { 0xBE54, 0x92C1 },
    { 0xBE55, 0x92B3 },
    { 0xBE56, 0x92BC },
    { 0xBE57, 0x92D2 },
    { 0xBE58, 0x92C7 },
    { 0xBE59, 0x92F0 },
    { 0xBE5A, 0x92B2 },
    { 0xBE5B, 0x95AD },
    { 0xBE5C, 0x95B1 },
    { 0xBE5D, 0x9704 },
    { 0xBE5E, 0x9706 },
    { 0xBE5F, 0x9707 },
    { 0xBE60, 0x9709 },
    { 0xBE61, 0x9760 },
    { 0xBE62, 0x978D },
    { 0xBE63, 0x978B },
    { 0xBE64, 0x978F },
    { 0xBE65, 0x9821 },
    { 0xBE66, 0x982B },
    { 0xBE67, 0x981C },
    { 0xBE68, 0x98B3 },
    { 0xBE69, 0x990A },
    { 0xBE6A, 0x9913 },
    { 0xBE6B, 0x9912 },
    { 0xBE6C, 0x9918 },
    { 0xBE6D, 0x99DD },
    { 0xBE6E, 0x99D0 },
    { 0xBE6F, 0x99DF },
    { 0xBE70, 0x99DB },
    { 0xBE71, 0x99D1 },
    { 0xBE72, 0x99D5 },
    { 0xBE73, 0x99D2 },
    { 0xBE74, 0x99D9 },
    { 0xBE75, 0x9AB7 },
    { 0xBE76, 0x9AEE },
    { 0xBE77, 0x9AEF },
    { 0xBE78, 0x9B27 },
    { 0xBE79, 0x9B45 },
    { 0xBE7A, 0x9B44 },
    { 0xBE7B, 0x9B77 },
    { 0xBE7C, 0x9B6F },
    { 0xBE7D, 0x9D06 },
    { 0xBE7E, 0x9D09 },
    { 0xBEA1, 0x9D03 },
    { 0xBEA2, 0x9EA9 },
    { 0xBEA3, 0x9EBE },
    { 0xBEA4, 0x9ECE },
    { 0xBEA5, 0x58A8 },
    { 0xBEA6, 0x9F52 },
    { 0xBEA7, 0x5112 },
    { 0xBEA8, 0x5118 },
    { 0xBEA9, 0x5114 },
    { 0xBEAA, 0x5110 },
    { 0xBEAB, 0x5115 },
    { 0xBEAC, 0x5180 },
    { 0xBEAD, 0x51AA },
    { 0xBEAE, 0x51DD },
    { 0xBEAF, 0x5291 },
    { 0xBEB0, 0x5293 },
    { 0xBEB1, 0x52F3 },
    { 0xBEB2, 0x5659 },
    { 0xBEB3, 0x566B },
    { 0xBEB4, 0x5679 },
    { 0xBEB5, 0x5669 },
    { 0xBEB6, 0x5664 },
    { 0xBEB7, 0x5678 },
    { 0xBEB8, 0x566A },
    { 0xBEB9, 0x5668 },
    { 0xBEBA, 0x5665 },
    { 0xBEBB, 0x5671 },
    { 0xBEBC, 0x566F },
    { 0xBEBD, 0x566C },
    { 0xBEBE, 0x5662 },
    { 0xBEBF, 0x5676 },
    { 0xBEC0, 0x58C1 },
    { 0xBEC1, 0x58BE },
    { 0xBEC2, 0x58C7 },
    { 0xBEC3, 0x58C5 },
    { 0xBEC4, 0x596E },
    { 0xBEC5, 0x5B1D },
    { 0xBEC6, 0x5B34 },
    { 0xBEC7, 0x5B78 },
    { 0xBEC8, 0x5BF0 },
    { 0xBEC9, 0x5C0E },
    { 0xBECA, 0x5F4A },
    { 0xBECB, 0x61B2 },
    { 0xBECC, 0x6191 },
    { 0xBECD, 0x61A9 },
    { 0xBECE, 0x618A },
    { 0xBECF, 0x61CD },
    { 0xBED0, 0x61B6 },
    { 0xBED1, 0x61BE },
    { 0xBED2, 0x61CA },
    { 0xBED3, 0x61C8 },
    { 0xBED4, 0x6230 },
    { 0xBED5, 0x64C5 },
    { 0xBED6, 0x64C1 },
    { 0xBED7, 0x64CB },
    { 0xBED8, 0x64BB },
    { 0xBED9, 0x64BC },
    { 0xBEDA, 0x64DA },
    { 0xBEDB, 0x64C4 },
    { 0xBEDC, 0x64C7 },
    { 0xBEDD, 0x64C2 },
    { 0xBEDE, 0x64CD },
    { 0xBEDF, 0x64BF },
    { 0xBEE0, 0x64D2 },
    { 0xBEE1, 0x64D4 },
    { 0xBEE2, 0x64BE },
    { 0xBEE3, 0x6574 },
    { 0xBEE4, 0x66C6 },
    { 0xBEE5, 0x66C9 },
    { 0xBEE6, 0x66B9 },
    { 0xBEE7, 0x66C4 },
    { 0xBEE8, 0x66C7 },
    { 0xBEE9, 0x66B8 },
    { 0xBEEA, 0x6A3D },
    { 0xBEEB, 0x6A38 },
    { 0xBEEC, 0x6A3A },
    { 0xBEED, 0x6A59 },
    { 0xBEEE, 0x6A6B },
    { 0xBEEF, 0x6A58 },
    { 0xBEF0, 0x6A39 },
    { 0xBEF1, 0x6A44 },
    { 0xBEF2, 0x6A62 },
    { 0xBEF3, 0x6A61 },
    { 0xBEF4, 0x6A4B },
    { 0xBEF5, 0x6A47 },
    { 0xBEF6, 0x6A35 },
    { 0xBEF7, 0x6A5F },
    { 0xBEF8, 0x6A48 },
    { 0xBEF9, 0x6B59 },
    { 0xBEFA, 0x6B77 },
    { 0xBEFB, 0x6C05 },
    { 0xBEFC, 0x6FC2 },
    { 0xBEFD, 0x6FB1 },
    { 0xBEFE, 0x6FA1 },
    { 0xBF40, 0x6FC3 },
    { 0xBF41, 0x6FA4 },
    { 0xBF42, 0x6FC1 },
    { 0xBF43, 0x6FA7 },
    { 0xBF44, 0x6FB3 },
    { 0xBF45, 0x6FC0 },
    { 0xBF46, 0x6FB9 },
    { 0xBF47, 0x6FB6 },
    { 0xBF48, 0x6FA6 },
    { 0xBF49, 0x6FA0 },
    { 0xBF4A, 0x6FB4 },
    { 0xBF4B, 0x71BE },
    { 0xBF4C, 0x71C9 },
    { 0xBF4D, 0x71D0 },
    { 0xBF4E, 0x71D2 },
    { 0xBF4F, 0x71C8 },
    { 0xBF50, 0x71D5 },
    { 0xBF51, 0x71B9 },
    { 0xBF52, 0x71CE },
    { 0xBF53, 0x71D9 },
    { 0xBF54, 0x71DC },
    { 0xBF55, 0x71C3 },
    { 0xBF56, 0x71C4 },
    { 0xBF57, 0x7368 },
    { 0xBF58, 0x749C },
    { 0xBF59, 0x74A3 },
    { 0xBF5A, 0x7498 },
    { 0xBF5B, 0x749F },
    { 0xBF5C, 0x749E },
    { 0xBF5D, 0x74E2 },
    { 0xBF5E, 0x750C },
    { 0xBF5F, 0x750D },
    { 0xBF60, 0x7634 },
    { 0xBF61, 0x7638 },
    { 0xBF62, 0x763A },
    { 0xBF63, 0x76E7 },
    { 0xBF64, 0x76E5 },
    { 0xBF65, 0x77A0 },
    { 0xBF66, 0x779E },
    { 0xBF67, 0x779F },
    { 0xBF68, 0x77A5 },
    { 0xBF69, 0x78E8 },
    { 0xBF6A, 0x78DA },
    { 0xBF6B, 0x78EC },
    { 0xBF6C, 0x78E7 },
    { 0xBF6D, 0x79A6 },
    { 0xBF6E, 0x7A4D },
    { 0xBF6F, 0x7A4E },
    { 0xBF70, 0x7A46 },
    { 0xBF71, 0x7A4C },
    { 0xBF72, 0x7A4B },
    { 0xBF73, 0x7ABA },
    { 0xBF74, 0x7BD9 },
    { 0xBF75, 0x7C11 },
    { 0xBF76, 0x7BC9 },
    { 0xBF77, 0x7BE4 },
    { 0xBF78, 0x7BDB },
    { 0xBF79, 0x7BE1 },
    { 0xBF7A, 0x7BE9 },
    { 0xBF7B, 0x7BE6 },
    { 0xBF7C, 0x7CD5 },
    { 0xBF7D, 0x7CD6 },
    { 0xBF7E, 0x7E0A },
    { 0xBFA1, 0x7E11 },
    { 0xBFA2, 0x7E08 },
    { 0xBFA3, 0x7E1B },
    { 0xBFA4, 0x7E23 },
    { 0xBFA5, 0x7E1E },
    { 0xBFA6, 0x7E1D },
    { 0xBFA7, 0x7E09 },
    { 0xBFA8, 0x7E10 },
    { 0xBFA9, 0x7F79 },
    { 0xBFAA, 0x7FB2 },
    { 0xBFAB, 0x7FF0 },
    { 0xBFAC, 0x7FF1 },
    { 0xBFAD, 0x7FEE },
    { 0xBFAE, 0x8028 },
    { 0xBFAF, 0x81B3 },
    { 0xBFB0, 0x81A9 },
    { 0xBFB1, 0x81A8 },
    { 0xBFB2, 0x81FB },
    { 0xBFB3, 0x8208 },
    { 0xBFB4, 0x8258 },
    { 0xBFB5, 0x8259 },
    { 0xBFB6, 0x854A },
    { 0xBFB7, 0x8559 },
    { 0xBFB8, 0x8548 },
    { 0xBFB9, 0x8568 },
    { 0xBFBA, 0x8569 },
    { 0xBFBB, 0x8543 },
    { 0xBFBC, 0x8549 },
    { 0xBFBD, 0x856D },
    { 0xBFBE, 0x856A },
    { 0xBFBF, 0x855E },
    { 0xBFC0, 0x8783 },
    { 0xBFC1, 0x879F },
    { 0xBFC2, 0x879E },
    { 0xBFC3, 0x87A2 },
    { 0xBFC4, 0x878D },
    { 0xBFC5, 0x8861 },
    { 0xBFC6, 0x892A },
    { 0xBFC7, 0x8932 },
    { 0xBFC8, 0x8925 },
    { 0xBFC9, 0x892B },
    { 0xBFCA, 0x8921 },
    { 0xBFCB, 0x89AA },
    { 0xBFCC, 0x89A6 },
    { 0xBFCD, 0x8AE6 },
    { 0xBFCE, 0x8AFA },
    { 0xBFCF, 0x8AEB },
    { 0xBFD0, 0x8AF1 },
    { 0xBFD1, 0x8B00 },
    { 0xBFD2, 0x8ADC },
    { 0xBFD3, 0x8AE7 },
    { 0xBFD4, 0x8AEE },
    { 0xBFD5, 0x8AFE },
    { 0xBFD6, 0x8B01 },
    { 0xBFD7, 0x8B02 },
    { 0xBFD8, 0x8AF7 },
    { 0xBFD9, 0x8AED },
    { 0xBFDA, 0x8AF3 },
    { 0xBFDB, 0x8AF6 },
    { 0xBFDC, 0x8AFC },
    { 0xBFDD, 0x8C6B },
    { 0xBFDE, 0x8C6D },
    { 0xBFDF, 0x8C93 },
    { 0xBFE0, 0x8CF4 },
    { 0xBFE1, 0x8E44 },
    { 0xBFE2, 0x8E31 },
    { 0xBFE3, 0x8E34 },
    { 0xBFE4, 0x8E42 },
    { 0xBFE5, 0x8E39 },
    { 0xBFE6, 0x8E35 },
    { 0xBFE7, 0x8F3B },
    { 0xBFE8, 0x8F2F },
    { 0xBFE9, 0x8F38 },
    { 0xBFEA, 0x8F33 },
    { 0xBFEB, 0x8FA8 },
    { 0xBFEC, 0x8FA6 },
    { 0xBFED, 0x9075 },
    { 0xBFEE, 0x9074 },
    { 0xBFEF, 0x9078 },
    { 0xBFF0, 0x9072 },
    { 0xBFF1, 0x907C },
    { 0xBFF2, 0x907A },
    { 0xBFF3, 0x9134 },
    { 0xBFF4, 0x9192 },
    { 0xBFF5, 0x9320 },
    { 0xBFF6, 0x9336 },
    { 0xBFF7, 0x92F8 },
    { 0xBFF8, 0x9333 },
    { 0xBFF9, 0x932F },
    { 0xBFFA, 0x9322 },
    { 0xBFFB, 0x92FC },
    { 0xBFFC, 0x932B },
    { 0xBFFD, 0x9304 },
    { 0xBFFE, 0x931A },
    { 0xC040, 0x9310 },
    { 0xC041, 0x9326 },
    { 0xC042, 0x9321 },
    { 0xC043, 0x9315 },
    { 0xC044, 0x932E },
    { 0xC045, 0x9319 },
    { 0xC046, 0x95BB },
    { 0xC047, 0x96A7 },
    { 0xC048, 0x96A8 },
    { 0xC049, 0x96AA },
    { 0xC04A, 0x96D5 },
    { 0xC04B, 0x970E },
    { 0xC04C, 0x9711 },
    { 0xC04D, 0x9716 },
    { 0xC04E, 0x970D },
    { 0xC04F, 0x9713 },
    { 0xC050, 0x970F },
    { 0xC051, 0x975B },
    { 0xC052, 0x975C },
    { 0xC053, 0x9766 },
    { 0xC054, 0x9798 },
    { 0xC055, 0x9830 },
    { 0xC056, 0x9838 },
    { 0xC057, 0x983B },
    { 0xC058, 0x9837 },
    { 0xC059, 0x982D },
    { 0xC05A, 0x9839 },
    { 0xC05B, 0x9824 },
    { 0xC05C, 0x9910 },
    { 0xC05D, 0x9928 },
    { 0xC05E, 0x991E },
    { 0xC05F, 0x991B },
    { 0xC060, 0x9921 },
    { 0xC061, 0x991A },
    { 0xC062, 0x99ED },
    { 0xC063, 0x99E2 },
    { 0xC064, 0x99F1 },
    { 0xC065, 0x9AB8 },
    { 0xC066, 0x9ABC },
    { 0xC067, 0x9AFB },
    { 0xC068, 0x9AED },
    { 0xC069, 0x9B28 },
    { 0xC06A, 0x9B91 },
    { 0xC06B, 0x9D15 },
    { 0xC06C, 0x9D23 },
    { 0xC06D, 0x9D26 },
    { 0xC06E, 0x9D28 },
    { 0xC06F, 0x9D12 },
    { 0xC070, 0x9D1B },
    { 0xC071, 0x9ED8 },
    { 0xC072, 0x9ED4 },
    { 0xC073, 0x9F8D },
    { 0xC074, 0x9F9C },
    { 0xC075, 0x512A },
    { 0xC076, 0x511F },
    { 0xC077, 0x5121 },
    { 0xC078, 0x5132 },
    { 0xC079, 0x52F5 },
    { 0xC07A, 0x568E },
    { 0xC07B, 0x5680 },
    { 0xC07C, 0x5690 },
    { 0xC07D, 0x5685 },
    { 0xC07E, 0x5687 },
    { 0xC0A1, 0x568F },
    { 0xC0A2, 0x58D5 },
    { 0xC0A3, 0x58D3 },
    { 0xC0A4, 0x58D1 },
    { 0xC0A5, 0x58CE },
    { 0xC0A6, 0x5B30 },
    { 0xC0A7, 0x5B2A },
    { 0xC0A8, 0x5B24 },
    { 0xC0A9, 0x5B7A },
    { 0xC0AA, 0x5C37 },
    { 0xC0AB, 0x5C68 },
    { 0xC0AC, 0x5DBC },
    { 0xC0AD, 0x5DBA },
    { 0xC0AE, 0x5DBD },
    { 0xC0AF, 0x5DB8 },
    { 0xC0B0, 0x5E6B },
    { 0xC0B1, 0x5F4C },
    { 0xC0B2, 0x5FBD },
    { 0xC0B3, 0x61C9 },
    { 0xC0B4, 0x61C2 },
    { 0xC0B5, 0x61C7 },
    { 0xC0B6, 0x61E6 },
    { 0xC0B7, 0x61CB },
    { 0xC0B8, 0x6232 },
    { 0xC0B9, 0x6234 },
    { 0xC0BA, 0x64CE },
    { 0xC0BB, 0x64CA },
    { 0xC0BC, 0x64D8 },
    { 0xC0BD, 0x64E0 },
    { 0xC0BE, 0x64F0 },
    { 0xC0BF, 0x64E6 },
    { 0xC0C0, 0x64EC },
    { 0xC0C1, 0x64F1 },
    { 0xC0C2, 0x64E2 },
    { 0xC0C3, 0x64ED },
    { 0xC0C4, 0x6582 },
    { 0xC0C5, 0x6583 },
    { 0xC0C6, 0x66D9 },
    { 0xC0C7, 0x66D6 },
    { 0xC0C8, 0x6A80 },
    { 0xC0C9, 0x6A94 },
    { 0xC0CA, 0x6A84 },
    { 0xC0CB, 0x6AA2 },
    { 0xC0CC, 0x6A9C },
    { 0xC0CD, 0x6ADB },
    { 0xC0CE, 0x6AA3 },
    { 0xC0CF, 0x6A7E },
    { 0xC0D0, 0x6A97 },
    { 0xC0D1, 0x6A90 },
    { 0xC0D2, 0x6AA0 },
    { 0xC0D3, 0x6B5C },
    { 0xC0D4, 0x6BAE },
    { 0xC0D5, 0x6BDA },
    { 0xC0D6, 0x6C08 },
    { 0xC0D7, 0x6FD8 },
    { 0xC0D8, 0x6FF1 },
    { 0xC0D9, 0x6FDF },
    { 0xC0DA, 0x6FE0 },
    { 0xC0DB, 0x6FDB },
    { 0xC0DC, 0x6FE4 },
    { 0xC0DD, 0x6FEB },
    { 0xC0DE, 0x6FEF },
    { 0xC0DF, 0x6F80 },
    { 0xC0E0, 0x6FEC },
    { 0xC0E1, 0x6FE1 },
    { 0xC0E2, 0x6FE9 },
    { 0xC0E3, 0x6FD5 },
    { 0xC0E4, 0x6FEE },
    { 0xC0E5, 0x6FF0 },
    { 0xC0E6, 0x71E7 },
    { 0xC0E7, 0x71DF },
    { 0xC0E8, 0x71EE },
    { 0xC0E9, 0x71E6 },
    { 0xC0EA, 0x71E5 },
    { 0xC0EB, 0x71ED },
    { 0xC0EC, 0x71EC },
    { 0xC0ED, 0x71F4 },
    { 0xC0EE, 0x71E0 },
    { 0xC0EF, 0x7235 },
    { 0xC0F0, 0x7246 },
    { 0xC0F1, 0x7370 },
    { 0xC0F2, 0x7372 },
    { 0xC0F3, 0x74A9 },
    { 0xC0F4, 0x74B0 },
    { 0xC0F5, 0x74A6 },
    { 0xC0F6, 0x74A8 },
    { 0xC0F7, 0x7646 },
    { 0xC0F8, 0x7642 },
    { 0xC0F9, 0x764C },
    { 0xC0FA, 0x76EA },
    { 0xC0FB, 0x77B3 },
    { 0xC0FC, 0x77AA },
    { 0xC0FD, 0x77B0 },
    { 0xC0FE, 0x77AC },
    { 0xC140, 0x77A7 },
    { 0xC141, 0x77AD },
    { 0xC142, 0x77EF },
    { 0xC143, 0x78F7 },
    { 0xC144, 0x78FA },
    { 0xC145, 0x78F4 },
    { 0xC146, 0x78EF },
    { 0xC147, 0x7901 },
    { 0xC148, 0x79A7 },
    { 0xC149, 0x79AA },
    { 0xC14A, 0x7A57 },
    { 0xC14B, 0x7ABF },
    { 0xC14C, 0x7C07 },
    { 0xC14D, 0x7C0D },
    { 0xC14E, 0x7BFE },
    { 0xC14F, 0x7BF7 },
    { 0xC150, 0x7C0C },
    { 0xC151, 0x7BE0 },
    { 0xC152, 0x7CE0 },
    { 0xC153, 0x7CDC },
    { 0xC154, 0x7CDE },
    { 0xC155, 0x7CE2 },
    { 0xC156, 0x7CDF },
    { 0xC157, 0x7CD9 },
    { 0xC158, 0x7CDD },
    { 0xC159, 0x7E2E },
    { 0xC15A, 0x7E3E },
    { 0xC15B, 0x7E46 },
    { 0xC15C, 0x7E37 },
    { 0xC15D, 0x7E32 },
    { 0xC15E, 0x7E43 },
    { 0xC15F, 0x7E2B },
    { 0xC160, 0x7E3D },
    { 0xC161, 0x7E31 },
    { 0xC162, 0x7E45 },
    { 0xC163, 0x7E41 },
    { 0xC164, 0x7E34 },
    { 0xC165, 0x7E39 },
    { 0xC166, 0x7E48 },
    { 0xC167, 0x7E35 },
    { 0xC168, 0x7E3F },
    { 0xC169, 0x7E2F },
    { 0xC16A, 0x7F44 },
    { 0xC16B, 0x7FF3 },
    { 0xC16C, 0x7FFC },
    { 0xC16D, 0x8071 },
    { 0xC16E, 0x8072 },
    { 0xC16F, 0x8070 },
    { 0xC170, 0x806F },
    { 0xC171, 0x8073 },
    { 0xC172, 0x81C6 },
    { 0xC173, 0x81C3 },
    { 0xC174, 0x81BA },
    { 0xC175, 0x81C2 },
    { 0xC176, 0x81C0 },
    { 0xC177, 0x81BF },
    { 0xC178, 0x81BD },
    { 0xC179, 0x81C9 },
    { 0xC17A, 0x81BE },
    { 0xC17B, 0x81E8 },
    { 0xC17C, 0x8209 },
    { 0xC17D, 0x8271 },
    { 0xC17E, 0x85AA },
    { 0xC1A1, 0x8584 },
    { 0xC1A2, 0x857E },
    { 0xC1A3, 0x859C },
    { 0xC1A4, 0x8591 },
    { 0xC1A5, 0x8594 },
    { 0xC1A6, 0x85AF },
    { 0xC1A7, 0x859B },
    { 0xC1A8, 0x8587 },
    { 0xC1A9, 0x85A8 },
    { 0xC1AA, 0x858A },
    { 0xC1AB, 0x8667 },
    { 0xC1AC, 0x87C0 },
    { 0xC1AD, 0x87D1 },
    { 0xC1AE, 0x87B3 },
    { 0xC1AF, 0x87D2 },
    { 0xC1B0, 0x87C6 },
    { 0xC1B1, 0x87AB },
    { 0xC1B2, 0x87BB },
    { 0xC1B3, 0x87BA },
    { 0xC1B4, 0x87C8 },
    { 0xC1B5, 0x87CB },
    { 0xC1B6, 0x893B },
    { 0xC1B7, 0x8936 },
    { 0xC1B8, 0x8944 },
    { 0xC1B9, 0x8938 },
    { 0xC1BA, 0x893D },
    { 0xC1BB, 0x89AC },
    { 0xC1BC, 0x8B0E },
    { 0xC1BD, 0x8B17 },
    { 0xC1BE, 0x8B19 },
    { 0xC1BF, 0x8B1B },
    { 0xC1C0, 0x8B0A },
    { 0xC1C1, 0x8B20 },
    { 0xC1C2, 0x8B1D },
    { 0xC1C3, 0x8B04 },
    { 0xC1C4, 0x8B10 },
    { 0xC1C5, 0x8C41 },
    { 0xC1C6, 0x8C3F },
    { 0xC1C7, 0x8C73 },
    { 0xC1C8, 0x8CFA },
    { 0xC1C9, 0x8CFD },
    { 0xC1CA, 0x8CFC },
    { 0xC1CB, 0x8CF8 },
    { 0xC1CC, 0x8CFB },
    { 0xC1CD, 0x8DA8 },
    { 0xC1CE, 0x8E49 },
    { 0xC1CF, 0x8E4B },
    { 0xC1D0, 0x8E48 },
    { 0xC1D1, 0x8E4A },
    { 0xC1D2, 0x8F44 },
    { 0xC1D3, 0x8F3E },
    { 0xC1D4, 0x8F42 },
    { 0xC1D5, 0x8F45 },
    { 0xC1D6, 0x8F3F },
    { 0xC1D7, 0x907F },
    { 0xC1D8, 0x907D },
    { 0xC1D9, 0x9084 },
    { 0xC1DA, 0x9081 },
    { 0xC1DB, 0x9082 },
    { 0xC1DC, 0x9080 },
    { 0xC1DD, 0x9139 },
    { 0xC1DE, 0x91A3 },
    { 0xC1DF, 0x919E },
    { 0xC1E0, 0x919C },
    { 0xC1E1, 0x934D },
    { 0xC1E2, 0x9382 },
    { 0xC1E3, 0x9328 },
    { 0xC1E4, 0x9375 },
    { 0xC1E5, 0x934A },
    { 0xC1E6, 0x9365 },
    { 0xC1E7, 0x934B },
    { 0xC1E8, 0x9318 },
    { 0xC1E9, 0x937E },
    { 0xC1EA, 0x936C },
    { 0xC1EB, 0x935B },
    { 0xC1EC, 0x9370 },
    { 0xC1ED, 0x935A },
    { 0xC1EE, 0x9354 },
    { 0xC1EF, 0x95CA },
    { 0xC1F0, 0x95CB },
    { 0xC1F1, 0x95CC },
    { 0xC1F2, 0x95C8 },
    { 0xC1F3, 0x95C6 },
    { 0xC1F4, 0x96B1 },
    { 0xC1F5, 0x96B8 },
    { 0xC1F6, 0x96D6 },
    { 0xC1F7, 0x971C },
    { 0xC1F8, 0x971E },
    { 0xC1F9, 0x97A0 },
    { 0xC1FA, 0x97D3 },
    { 0xC1FB, 0x9846 },
    { 0xC1FC, 0x98B6 },
    { 0xC1FD, 0x9935 },
    { 0xC1FE, 0x9A01 },
    { 0xC240, 0x99FF },
    { 0xC241, 0x9BAE },
    { 0xC242, 0x9BAB },
    { 0xC243, 0x9BAA },
    { 0xC244, 0x9BAD },
    { 0xC245, 0x9D3B },
    { 0xC246, 0x9D3F },
    { 0xC247, 0x9E8B },
    { 0xC248, 0x9ECF },
    { 0xC249, 0x9EDE },
    { 0xC24A, 0x9EDC },
    { 0xC24B, 0x9EDD },
    { 0xC24C, 0x9EDB },
    { 0xC24D, 0x9F3E },
    { 0xC24E, 0x9F4B },
    { 0xC24F, 0x53E2 },
    { 0xC250, 0x5695 },
    { 0xC251, 0x56AE },
    { 0xC252, 0x58D9 },
    { 0xC253, 0x58D8 },
    { 0xC254, 0x5B38 },
    { 0xC255, 0x5F5D },
    { 0xC256, 0x61E3 },
    { 0xC257, 0x6233 },
    { 0xC258, 0x64F4 },
    { 0xC259, 0x64F2 },
    { 0xC25A, 0x64FE },
    { 0xC25B, 0x6506 },
    { 0xC25C, 0x64FA },
    { 0xC25D, 0x64FB },
    { 0xC25E, 0x64F7 },
    { 0xC25F, 0x65B7 },
    { 0xC260, 0x66DC },
    { 0xC261, 0x6726 },
    { 0xC262, 0x6AB3 },
    { 0xC263, 0x6AAC },
    { 0xC264, 0x6AC3 },
    { 0xC265, 0x6ABB },
    { 0xC266, 0x6AB8 },
    { 0xC267, 0x6AC2 },
    { 0xC268, 0x6AAE },
    { 0xC269, 0x6AAF },
    { 0xC26A, 0x6B5F },
    { 0xC26B, 0x6B78 },
    { 0xC26C, 0x6BAF },
    { 0xC26D, 0x7009 },
    { 0xC26E, 0x700B },
    { 0xC26F, 0x6FFE },
    { 0xC270, 0x7006 },
    { 0xC271, 0x6FFA },
    { 0xC272, 0x7011 },
    { 0xC273, 0x700F },
    { 0xC274, 0x71FB },
    { 0xC275, 0x71FC },
    { 0xC276, 0x71FE },
    { 0xC277, 0x71F8 },
    { 0xC278, 0x7377 },
    { 0xC279, 0x7375 },
    { 0xC27A, 0x74A7 },
    { 0xC27B, 0x74BF },
    { 0xC27C, 0x7515 },
    { 0xC27D, 0x7656 },
    { 0xC27E, 0x7658 },
    { 0xC2A1, 0x7652 },
    { 0xC2A2, 0x77BD },
    { 0xC2A3, 0x77BF },
    { 0xC2A4, 0x77BB },
    { 0xC2A5, 0x77BC },
    { 0xC2A6, 0x790E },
    { 0xC2A7, 0x79AE },
    { 0xC2A8, 0x7A61 },
    { 0xC2A9, 0x7A62 },
    { 0xC2AA, 0x7A60 },
    { 0xC2AB, 0x7AC4 },
    { 0xC2AC, 0x7AC5 },
    { 0xC2AD, 0x7C2B },
    { 0xC2AE, 0x7C27 },
    { 0xC2AF, 0x7C2A },
    { 0xC2B0, 0x7C1E },
    { 0xC2B1, 0x7C23 },
    { 0xC2B2, 0x7C21 },
    { 0xC2B3, 0x7CE7 },
    { 0xC2B4, 0x7E54 },
    { 0xC2B5, 0x7E55 },
    { 0xC2B6, 0x7E5E },
    { 0xC2B7, 0x7E5A },
    { 0xC2B8, 0x7E61 },
    { 0xC2B9, 0x7E52 },
    { 0xC2BA, 0x7E59 },
    { 0xC2BB, 0x7F48 },
    { 0xC2BC, 0x7FF9 },
    { 0xC2BD, 0x7FFB },
    { 0xC2BE, 0x8077 },
    { 0xC2BF, 0x8076 },
    { 0xC2C0, 0x81CD },
    { 0xC2C1, 0x81CF },
    { 0xC2C2, 0x820A },
    { 0xC2C3, 0x85CF },
    { 0xC2C4, 0x85A9 },
    { 0xC2C5, 0x85CD },
    { 0xC2C6, 0x85D0 },
    { 0xC2C7, 0x85C9 },
    { 0xC2C8, 0x85B0 },
    { 0xC2C9, 0x85BA },
    { 0xC2CA, 0x85B9 },
    { 0xC2CB, 0x85A6 },
    { 0xC2CC, 0x87EF },
    { 0xC2CD, 0x87EC },
    { 0xC2CE, 0x87F2 },
    { 0xC2CF, 0x87E0 },
    { 0xC2D0, 0x8986 },
    { 0xC2D1, 0x89B2 },
    { 0xC2D2, 0x89F4 },
    { 0xC2D3, 0x8B28 },
    { 0xC2D4, 0x8B39 },
    { 0xC2D5, 0x8B2C },
    { 0xC2D6, 0x8B2B },
    { 0xC2D7, 0x8C50 },
    { 0xC2D8, 0x8D05 },
    { 0xC2D9, 0x8E59 },
    { 0xC2DA, 0x8E63 },
    { 0xC2DB, 0x8E66 },
    { 0xC2DC, 0x8E64 },
    { 0xC2DD, 0x8E5F },
    { 0xC2DE, 0x8E55 },
    { 0xC2DF, 0x8EC0 },
    { 0xC2E0, 0x8F49 },
    { 0xC2E1, 0x8F4D },
    { 0xC2E2, 0x9087 },
    { 0xC2E3, 0x9083 },
    { 0xC2E4, 0x9088 },
    { 0xC2E5, 0x91AB },
    { 0xC2E6, 0x91AC },
    { 0xC2E7, 0x91D0 },
    { 0xC2E8, 0x9394 },
    { 0xC2E9, 0x938A },
    { 0xC2EA, 0x9396 },
    { 0xC2EB, 0x93A2 },
    { 0xC2EC, 0x93B3 },
    { 0xC2ED, 0x93AE },
    { 0xC2EE, 0x93AC },
    { 0xC2EF, 0x93B0 },
    { 0xC2F0, 0x9398 },
    { 0xC2F1, 0x939A },
    { 0xC2F2, 0x9397 },
    { 0xC2F3, 0x95D4 },
    { 0xC2F4, 0x95D6 },
    { 0xC2F5, 0x95D0 },
    { 0xC2F6, 0x95D5 },
    { 0xC2F7, 0x96E2 },
    { 0xC2F8, 0x96DC },
    { 0xC2F9, 0x96D9 },
    { 0xC2FA, 0x96DB },
    { 0xC2FB, 0x96DE },
    { 0xC2FC, 0x9724 },
    { 0xC2FD, 0x97A3 },
    { 0xC2FE, 0x97A6 },
    { 0xC340, 0x97AD },
    { 0xC341, 0x97F9 },
    { 0xC342, 0x984D },
    { 0xC343, 0x984F },
    { 0xC344, 0x984C },
    { 0xC345, 0x984E },
    { 0xC346, 0x9853 },
    { 0xC347, 0x98BA },
    { 0xC348, 0x993E },
    { 0xC349, 0x993F },
    { 0xC34A, 0x993D },
    { 0xC34B, 0x992E },
    { 0xC34C, 0x99A5 },
    { 0xC34D, 0x9A0E },
    { 0xC34E, 0x9AC1 },
    { 0xC34F, 0x9B03 },
    { 0xC350, 0x9B06 },
    { 0xC351, 0x9B4F },
    { 0xC352, 0x9B4E },
    { 0xC353, 0x9B4D },
    { 0xC354, 0x9BCA },
    { 0xC355, 0x9BC9 },
    { 0xC356, 0x9BFD },
    { 0xC357, 0x9BC8 },
    { 0xC358, 0x9BC0 },
    { 0xC359, 0x9D51 },
    { 0xC35A, 0x9D5D },
    { 0xC35B, 0x9D60 },
    { 0xC35C, 0x9EE0 },
    { 0xC35D, 0x9F15 },
    { 0xC35E, 0x9F2C },
    { 0xC35F, 0x5133 },
    { 0xC360, 0x56A5 },
    { 0xC361, 0x58DE },
    { 0xC362, 0x58DF },
    { 0xC363, 0x58E2 },
    { 0xC364, 0x5BF5 },
    { 0xC365, 0x9F90 },
    { 0xC366, 0x5EEC },
    { 0xC367, 0x61F2 },
    { 0xC368, 0x61F7 },
    { 0xC369, 0x61F6 },
    { 0xC36A, 0x61F5 },
    { 0xC36B, 0x6500 },
    { 0xC36C, 0x650F },
    { 0xC36D, 0x66E0 },
    { 0xC36E, 0x66DD },
    { 0xC36F, 0x6AE5 },
    { 0xC370, 0x6ADD },
    { 0xC371, 0x6ADA },
    { 0xC372, 0x6AD3 },
    { 0xC373, 0x701B },
    { 0xC374, 0x701F },
    { 0xC375, 0x7028 },
    { 0xC376, 0x701A },
    { 0xC377, 0x701D },
    { 0xC378, 0x7015 },
    { 0xC379, 0x7018 },
    { 0xC37A, 0x7206 },
    { 0xC37B, 0x720D },
    { 0xC37C, 0x7258 },
    { 0xC37D, 0x72A2 },
    { 0xC37E, 0x7378 },
    { 0xC3A1, 0x737A },
    { 0xC3A2, 0x74BD },
    { 0xC3A3, 0x74CA },
    { 0xC3A4, 0x74E3 },
    { 0xC3A5, 0x7587 },
    { 0xC3A6, 0x7586 },
    { 0xC3A7, 0x765F },
    { 0xC3A8, 0x7661 },
    { 0xC3A9, 0x77C7 },
    { 0xC3AA, 0x7919 },
    { 0xC3AB, 0x79B1 },
    { 0xC3AC, 0x7A6B },
    { 0xC3AD, 0x7A69 },
    { 0xC3AE, 0x7C3E },
    { 0xC3AF, 0x7C3F },
    { 0xC3B0, 0x7C38 },
    { 0xC3B1, 0x7C3D },
    { 0xC3B2, 0x7C37 },
    { 0xC3B3, 0x7C40 },
    { 0xC3B4, 0x7E6B },
    { 0xC3B5, 0x7E6D },
    { 0xC3B6, 0x7E79 },
    { 0xC3B7, 0x7E69 },
    { 0xC3B8, 0x7E6A },
    { 0xC3B9, 0x7F85 },
    { 0xC3BA, 0x7E73 },
    { 0xC3BB, 0x7FB6 },
    { 0xC3BC, 0x7FB9 },
    { 0xC3BD, 0x7FB8 },
    { 0xC3BE, 0x81D8 },
    { 0xC3BF, 0x85E9 },
    { 0xC3C0, 0x85DD },
    { 0xC3C1, 0x85EA },
    { 0xC3C2, 0x85D5 },
    { 0xC3C3, 0x85E4 },
    { 0xC3C4, 0x85E5 },
    { 0xC3C5, 0x85F7 },
    { 0xC3C6, 0x87FB },
    { 0xC3C7, 0x8805 },
    { 0xC3C8, 0x880D },
    { 0xC3C9, 0x87F9 },
    { 0xC3CA, 0x87FE },
    { 0xC3CB, 0x8960 },
    { 0xC3CC, 0x895F },
    { 0xC3CD, 0x8956 },
    { 0xC3CE, 0x895E },
    { 0xC3CF, 0x8B41 },
    { 0xC3D0, 0x8B5C },
    { 0xC3D1, 0x8B58 },
    { 0xC3D2, 0x8B49 },
    { 0xC3D3, 0x8B5A },
    { 0xC3D4, 0x8B4E },
    { 0xC3D5, 0x8B4F },
    { 0xC3D6, 0x8B46 },
    { 0xC3D7, 0x8B59 },
    { 0xC3D8, 0x8D08 },
    { 0xC3D9, 0x8D0A },
    { 0xC3DA, 0x8E7C },
    { 0xC3DB, 0x8E72 },
    { 0xC3DC, 0x8E87 },
    { 0xC3DD, 0x8E76 },
    { 0xC3DE, 0x8E6C },
    { 0xC3DF, 0x8E7A },
    { 0xC3E0, 0x8E74 },
    { 0xC3E1, 0x8F54 },
    { 0xC3E2, 0x8F4E },
    { 0xC3E3, 0x8FAD },
    { 0xC3E4, 0x908A },
    { 0xC3E5, 0x908B },
    { 0xC3E6, 0x91B1 },
    { 0xC3E7, 0x91AE },
    { 0xC3E8, 0x93E1 },
    { 0xC3E9, 0x93D1 },
    { 0xC3EA, 0x93DF },
    { 0xC3EB, 0x93C3 },
    { 0xC3EC, 0x93C8 },
    { 0xC3ED, 0x93DC },
    { 0xC3EE, 0x93DD },
    { 0xC3EF, 0x93D6 },
    { 0xC3F0, 0x93E2 },
    { 0xC3F1, 0x93CD },
    { 0xC3F2, 0x93D8 },
    { 0xC3F3, 0x93E4 },
    { 0xC3F4, 0x93D7 },
    { 0xC3F5, 0x93E8 },
    { 0xC3F6, 0x95DC },
    { 0xC3F7, 0x96B4 },
    { 0xC3F8, 0x96E3 },
    { 0xC3F9, 0x972A },
    { 0xC3FA, 0x9727 },
    { 0xC3FB, 0x9761 },
    { 0xC3FC, 0x97DC },
    { 0xC3FD, 0x97FB },
    { 0xC3FE, 0x985E },
    { 0xC440, 0x9858 },
    { 0xC441, 0x985B },
    { 0xC442, 0x98BC },
    { 0xC443, 0x9945 },
    { 0xC444, 0x9949 },
    { 0xC445, 0x9A16 },
    { 0xC446, 0x9A19 },
    { 0xC447, 0x9B0D },
    { 0xC448, 0x9BE8 },
    { 0xC449, 0x9BE7 },
    { 0xC44A, 0x9BD6 },
    { 0xC44B, 0x9BDB },
    { 0xC44C, 0x9D89 },
    { 0xC44D, 0x9D61 },
    { 0xC44E, 0x9D72 },
    { 0xC44F, 0x9D6A },
    { 0xC450, 0x9D6C },
    { 0xC451, 0x9E92 },
    { 0xC452, 0x9E97 },
    { 0xC453, 0x9E93 },
    { 0xC454, 0x9EB4 },
    { 0xC455, 0x52F8 },
    { 0xC456, 0x56A8 },
    { 0xC457, 0x56B7 },
    { 0xC458, 0x56B6 },
    { 0xC459, 0x56B4 },
    { 0xC45A, 0x56BC },
    { 0xC45B, 0x58E4 },
    { 0xC45C, 0x5B40 },
    { 0xC45D, 0x5B43 },
    { 0xC45E, 0x5B7D },
    { 0xC45F, 0x5BF6 },
    { 0xC460, 0x5DC9 },
    { 0xC461, 0x61F8 },
    { 0xC462, 0x61FA },
    { 0xC463, 0x6518 },
    { 0xC464, 0x6514 },
    { 0xC465, 0x6519 },
    { 0xC466, 0x66E6 },
    { 0xC467, 0x6727 },
    { 0xC468, 0x6AEC },
    { 0xC469, 0x703E },
    { 0xC46A, 0x7030 },
    { 0xC46B, 0x7032 },
    { 0xC46C, 0x7210 },
    { 0xC46D, 0x737B },
    { 0xC46E, 0x74CF },
    { 0xC46F, 0x7662 },
    { 0xC470, 0x7665 },
    { 0xC471, 0x7926 },
    { 0xC472, 0x792A },
    { 0xC473, 0x792C },
    { 0xC474, 0x792B },
    { 0xC475, 0x7AC7 },
    { 0xC476, 0x7AF6 },
    { 0xC477, 0x7C4C },
    { 0xC478, 0x7C43 },
    { 0xC479, 0x7C4D },
    { 0xC47A, 0x7CEF },
    { 0xC47B, 0x7CF0 },
    { 0xC47C, 0x8FAE },
    { 0xC47D, 0x7E7D },
    { 0xC47E, 0x7E7C },
    { 0xC4A1, 0x7E82 },
    { 0xC4A2, 0x7F4C },
    { 0xC4A3, 0x8000 },
    { 0xC4A4, 0x81DA },
    { 0xC4A5, 0x8266 },
    { 0xC4A6, 0x85FB },
    { 0xC4A7, 0x85F9 },
    { 0xC4A8, 0x8611 },
    { 0xC4A9, 0x85FA },
    { 0xC4AA, 0x8606 },
    { 0xC4AB, 0x860B },
    { 0xC4AC, 0x8607 },
    { 0xC4AD, 0x860A },
    { 0xC4AE, 0x8814 },
    { 0xC4AF, 0x8815 },
    { 0xC4B0, 0x8964 },
    { 0xC4B1, 0x89BA },
    { 0xC4B2, 0x89F8 },
    { 0xC4B3, 0x8B70 },
    { 0xC4B4, 0x8B6C },
    { 0xC4B5, 0x8B66 },
    { 0xC4B6, 0x8B6F },
    { 0xC4B7, 0x8B5F },
    { 0xC4B8, 0x8B6B },
    { 0xC4B9, 0x8D0F },
    { 0xC4BA, 0x8D0D },
    { 0xC4BB, 0x8E89 },
    { 0xC4BC, 0x8E81 },
    { 0xC4BD, 0x8E85 },
    { 0xC4BE, 0x8E82 },
    { 0xC4BF, 0x91B4 },
    { 0xC4C0, 0x91CB },
    { 0xC4C1, 0x9418 },
    { 0xC4C2, 0x9403 },
    { 0xC4C3, 0x93FD },
    { 0xC4C4, 0x95E1 },
    { 0xC4C5, 0x9730 },
    { 0xC4C6, 0x98C4 },
    { 0xC4C7, 0x9952 },
    { 0xC4C8, 0x9951 },
    { 0xC4C9, 0x99A8 },
    { 0xC4CA, 0x9A2B },
    { 0xC4CB, 0x9A30 },
    { 0xC4CC, 0x9A37 },
    { 0xC4CD, 0x9A35 },
    { 0xC4CE, 0x9C13 },
    { 0xC4CF, 0x9C0D },
    { 0xC4D0, 0x9E79 },
    { 0xC4D1, 0x9EB5 },
    { 0xC4D2, 0x9EE8 },
    { 0xC4D3, 0x9F2F },
    { 0xC4D4, 0x9F5F },
    { 0xC4D5, 0x9F63 },
    { 0xC4D6, 0x9F61 },
    { 0xC4D7, 0x5137 },
    { 0xC4D8, 0x5138 },
    { 0xC4D9, 0x56C1 },
    { 0xC4DA, 0x56C0 },
    { 0xC4DB, 0x56C2 },
    { 0xC4DC, 0x5914 },
    { 0xC4DD, 0x5C6C },
    { 0xC4DE, 0x5DCD },
    { 0xC4DF, 0x61FC },
    { 0xC4E0, 0x61FE },
    { 0xC4E1, 0x651D },
    { 0xC4E2, 0x651C },
    { 0xC4E3, 0x6595 },
    { 0xC4E4, 0x66E9 },
    { 0xC4E5, 0x6AFB },
    { 0xC4E6, 0x6B04 },
    { 0xC4E7, 0x6AFA },
    { 0xC4E8, 0x6BB2 },
    { 0xC4E9, 0x704C },
    { 0xC4EA, 0x721B },
    { 0xC4EB, 0x72A7 },
    { 0xC4EC, 0x74D6 },
    { 0xC4ED, 0x74D4 },
    { 0xC4EE, 0x7669 },
    { 0xC4EF, 0x77D3 },
    { 0xC4F0, 0x7C50 },
    { 0xC4F1, 0x7E8F },
    { 0xC4F2, 0x7E8C },
    { 0xC4F3, 0x7FBC },
    { 0xC4F4, 0x8617 },
    { 0xC4F5, 0x862D },
    { 0xC4F6, 0x861A },
    { 0xC4F7, 0x8823 },
    { 0xC4F8, 0x8822 },
    { 0xC4F9, 0x8821 },
    { 0xC4FA, 0x881F },
    { 0xC4FB, 0x896A },
    { 0xC4FC, 0x896C },
    { 0xC4FD, 0x89BD },
    { 0xC4FE, 0x8B74 },
    { 0xC540, 0x8B77 },
    { 0xC541, 0x8B7D },
    { 0xC542, 0x8D13 },
    { 0xC543, 0x8E8A },
    { 0xC544, 0x8E8D },
    { 0xC545, 0x8E8B },
    { 0xC546, 0x8F5F },
    { 0xC547, 0x8FAF },
    { 0xC548, 0x91BA },
    { 0xC549, 0x942E },
    { 0xC54A, 0x9433 },
    { 0xC54B, 0x9435 },
    { 0xC54C, 0x943A },
    { 0xC54D, 0x9438 },
    { 0xC54E, 0x9432 },
    { 0xC54F, 0x942B },
    { 0xC550, 0x95E2 },
    { 0xC551, 0x9738 },
    { 0xC552, 0x9739 },
    { 0xC553, 0x9732 },
    { 0xC554, 0x97FF },
    { 0xC555, 0x9867 },
    { 0xC556, 0x9865 },
    { 0xC557, 0x9957 },
    { 0xC558, 0x9A45 },
    { 0xC559, 0x9A43 },
    { 0xC55A, 0x9A40 },
    { 0xC55B, 0x9A3E },
    { 0xC55C, 0x9ACF },
    { 0xC55D, 0x9B54 },
    { 0xC55E, 0x9B51 },
    { 0xC55F, 0x9C2D },
    { 0xC560, 0x9C25 },
    { 0xC561, 0x9DAF },
    { 0xC562, 0x9DB4 },
    { 0xC563, 0x9DC2 },
    { 0xC564, 0x9DB8 },
    { 0xC565, 0x9E9D },
    { 0xC566, 0x9EEF },
    { 0xC567, 0x9F19 },
    { 0xC568, 0x9F5C },
    { 0xC569, 0x9F66 },
    { 0xC56A, 0x9F67 },
    { 0xC56B, 0x513C },
    { 0xC56C, 0x513B },
    { 0xC56D, 0x56C8 },
    { 0xC56E, 0x56CA },
    { 0xC56F, 0x56C9 },
    { 0xC570, 0x5B7F },
    { 0xC571, 0x5DD4 },
    { 0xC572, 0x5DD2 },
    { 0xC573, 0x5F4E },
    { 0xC574, 0x61FF },
    { 0xC575, 0x6524 },
    { 0xC576, 0x6B0A },
    { 0xC577, 0x6B61 },
    { 0xC578, 0x7051 },
    { 0xC579, 0x7058 },
    { 0xC57A, 0x7380 },
    { 0xC57B, 0x74E4 },
    { 0xC57C, 0x758A },
    { 0xC57D, 0x766E },
    { 0xC57E, 0x766C },
    { 0xC5A1, 0x79B3 },
    { 0xC5A2, 0x7C60 },
    { 0xC5A3, 0x7C5F },
    { 0xC5A4, 0x807E },
    { 0xC5A5, 0x807D },
    { 0xC5A6, 0x81DF },
    { 0xC5A7, 0x8972 },
    { 0xC5A8, 0x896F },
    { 0xC5A9, 0x89FC },
    { 0xC5AA, 0x8B80 },
    { 0xC5AB, 0x8D16 },
    { 0xC5AC, 0x8D17 },
    { 0xC5AD, 0x8E91 },
    { 0xC5AE, 0x8E93 },
    { 0xC5AF, 0x8F61 },
    { 0xC5B0, 0x9148 },
    { 0xC5B1, 0x9444 },
    { 0xC5B2, 0x9451 },
    { 0xC5B3, 0x9452 },
    { 0xC5B4, 0x973D },
    { 0xC5B5, 0x973E },
    { 0xC5B6, 0x97C3 },
    { 0xC5B7, 0x97C1 },
    { 0xC5B8, 0x986B },
    { 0xC5B9, 0x9955 },
    { 0xC5BA, 0x9A55 },
    { 0xC5BB, 0x9A4D },
    { 0xC5BC, 0x9AD2 },
    { 0xC5BD, 0x9B1A },
    { 0xC5BE, 0x9C49 },
    { 0xC5BF, 0x9C31 },
    { 0xC5C0, 0x9C3E },
    { 0xC5C1, 0x9C3B },
    { 0xC5C2, 0x9DD3 },
    { 0xC5C3, 0x9DD7 },
    { 0xC5C4, 0x9F34 },
    { 0xC5C5, 0x9F6C },
    { 0xC5C6, 0x9F6A },
    { 0xC5C7, 0x9F94 },
    { 0xC5C8, 0x56CC },
    { 0xC5C9, 0x5DD6 },
    { 0xC5CA, 0x6200 },
    { 0xC5CB, 0x6523 },
    { 0xC5CC, 0x652B },
    { 0xC5CD, 0x652A },
    { 0xC5CE, 0x66EC },
    { 0xC5CF, 0x6B10 },
    { 0xC5D0, 0x74DA },
    { 0xC5D1, 0x7ACA },
    { 0xC5D2, 0x7C64 },
    { 0xC5D3, 0x7C63 },
    { 0xC5D4, 0x7C65 },
    { 0xC5D5, 0x7E93 },
    { 0xC5D6, 0x7E96 },
    { 0xC5D7, 0x7E94 },
    { 0xC5D8, 0x81E2 },
    { 0xC5D9, 0x8638 },
    { 0xC5DA, 0x863F },
    { 0xC5DB, 0x8831 },
    { 0xC5DC, 0x8B8A },
    { 0xC5DD, 0x9090 },
    { 0xC5DE, 0x908F },
    { 0xC5DF, 0x9463 },
    { 0xC5E0, 0x9460 },
    { 0xC5E1, 0x9464 },
    { 0xC5E2, 0x9768 },
    { 0xC5E3, 0x986F },
    { 0xC5E4, 0x995C },
    { 0xC5E5, 0x9A5A },
    { 0xC5E6, 0x9A5B },
    { 0xC5E7, 0x9A57 },
    { 0xC5E8, 0x9AD3 },
    { 0xC5E9, 0x9AD4 },
    { 0xC5EA, 0x9AD1 },
    { 0xC5EB, 0x9C54 },
    { 0xC5EC, 0x9C57 },
    { 0xC5ED, 0x9C56 },
    { 0xC5EE, 0x9DE5 },
    { 0xC5EF, 0x9E9F },
    { 0xC5F0, 0x9EF4 },
    { 0xC5F1, 0x56D1 },
    { 0xC5F2, 0x58E9 },
    { 0xC5F3, 0x652C },
    { 0xC5F4, 0x705E },
    { 0xC5F5, 0x7671 },
    { 0xC5F6, 0x7672 },
    { 0xC5F7, 0x77D7 },
    { 0xC5F8, 0x7F50 },
    { 0xC5F9, 0x7F88 },
    { 0xC5FA, 0x8836 },
    { 0xC5FB, 0x8839 },
    { 0xC5FC, 0x8862 },
    { 0xC5FD, 0x8B93 },
    { 0xC5FE, 0x8B92 },
    { 0xC640, 0x8B96 },
    { 0xC641, 0x8277 },
    { 0xC642, 0x8D1B },
    { 0xC643, 0x91C0 },
    { 0xC644, 0x946A },
    { 0xC645, 0x9742 },
    { 0xC646, 0x9748 },
    { 0xC647, 0x9744 },
    { 0xC648, 0x97C6 },
    { 0xC649, 0x9870 },
    { 0xC64A, 0x9A5F },
    { 0xC64B, 0x9B22 },
    { 0xC64C, 0x9B58 },
    { 0xC64D, 0x9C5F },
    { 0xC64E, 0x9DF9 },
    { 0xC64F, 0x9DFA },
    { 0xC650, 0x9E7C },
    { 0xC651, 0x9E7D },
    { 0xC652, 0x9F07 },
    { 0xC653, 0x9F77 },
    { 0xC654, 0x9F72 },
    { 0xC655, 0x5EF3 },
    { 0xC656, 0x6B16 },
    { 0xC657, 0x7063 },
    { 0xC658, 0x7C6C },
    { 0xC659, 0x7C6E },
    { 0xC65A, 0x883B },
    { 0xC65B, 0x89C0 },
    { 0xC65C, 0x8EA1 },
    { 0xC65D, 0x91C1 },
    { 0xC65E, 0x9472 },
    { 0xC65F, 0x9470 },
    { 0xC660, 0x9871 },
    { 0xC661, 0x995E },
    { 0xC662, 0x9AD6 },
    { 0xC663, 0x9B23 },
    { 0xC664, 0x9ECC },
    { 0xC665, 0x7064 },
    { 0xC666, 0x77DA },
    { 0xC667, 0x8B9A },
    { 0xC668, 0x9477 },
    { 0xC669, 0x97C9 },
    { 0xC66A, 0x9A62 },
    { 0xC66B, 0x9A65 },
    { 0xC66C, 0x7E9C },
    { 0xC66D, 0x8B9C },
    { 0xC66E, 0x8EAA },
    { 0xC66F, 0x91C5 },
    { 0xC670, 0x947D },
    { 0xC671, 0x947E },
    { 0xC672, 0x947C },
    { 0xC673, 0x9C77 },
    { 0xC674, 0x9C78 },
    { 0xC675, 0x9EF7 },
    { 0xC676, 0x8C54 },
    { 0xC677, 0x947F },
    { 0xC678, 0x9E1A },
    { 0xC679, 0x7228 },
    { 0xC67A, 0x9A6A },
    { 0xC67B, 0x9B31 },
    { 0xC67C, 0x9E1B },
    { 0xC67D, 0x9E1E },
    { 0xC67E, 0x7C72 },
    { 0xC6A1, 0x30FE },
    { 0xC6A2, 0x309D },
    { 0xC6A3, 0x309E },
    { 0xC6A4, 0x3005 },
    { 0xC6A5, 0x3041 },
    { 0xC6A6, 0x3042 },
    { 0xC6A7, 0x3043 },
    { 0xC6A8, 0x3044 },
    { 0xC6A9, 0x3045 },
    { 0xC6AA, 0x3046 },
    { 0xC6AB, 0x3047 },
    { 0xC6AC, 0x3048 },
    { 0xC6AD, 0x3049 },
    { 0xC6AE, 0x304A },
    { 0xC6AF, 0x304B },
    { 0xC6B0, 0x304C },
    { 0xC6B1, 0x304D },
    { 0xC6B2, 0x304E },
    { 0xC6B3, 0x304F },
    { 0xC6B4, 0x3050 },
    { 0xC6B5, 0x3051 },
    { 0xC6B6, 0x3052 },
    { 0xC6B7, 0x3053 },
    { 0xC6B8, 0x3054 },
    { 0xC6B9, 0x3055 },
    { 0xC6BA, 0x3056 },
    { 0xC6BB, 0x3057 },
    { 0xC6BC, 0x3058 },
    { 0xC6BD, 0x3059 },
    { 0xC6BE, 0x305A },
    { 0xC6BF, 0x305B },
    { 0xC6C0, 0x305C },
    { 0xC6C1, 0x305D },
    { 0xC6C2, 0x305E },
    { 0xC6C3, 0x305F },
    { 0xC6C4, 0x3060 },
    { 0xC6C5, 0x3061 },
    { 0xC6C6, 0x3062 },
    { 0xC6C7, 0x3063 },
    { 0xC6C8, 0x3064 },
    { 0xC6C9, 0x3065 },
    { 0xC6CA, 0x3066 },
    { 0xC6CB, 0x3067 },
    { 0xC6CC, 0x3068 },
    { 0xC6CD, 0x3069 },
    { 0xC6CE, 0x306A },
    { 0xC6CF, 0x306B },
    { 0xC6D0, 0x306C },
    { 0xC6D1, 0x306D },
    { 0xC6D2, 0x306E },
    { 0xC6D3, 0x306F },
    { 0xC6D4, 0x3070 },
    { 0xC6D5, 0x3071 },
    { 0xC6D6, 0x3072 },
    { 0xC6D7, 0x3073 },
    { 0xC6D8, 0x3074 },
    { 0xC6D9, 0x3075 },
    { 0xC6DA, 0x3076 },
    { 0xC6DB, 0x3077 },
    { 0xC6DC, 0x3078 },
    { 0xC6DD, 0x3079 },
    { 0xC6DE, 0x307A },
    { 0xC6DF, 0x307B },
    { 0xC6E0, 0x307C },
    { 0xC6E1, 0x307D },
    { 0xC6E2, 0x307E },
    { 0xC6E3, 0x307F },
    { 0xC6E4, 0x3080 },
    { 0xC6E5, 0x3081 },
    { 0xC6E6, 0x3082 },
    { 0xC6E7, 0x3083 },
    { 0xC6E8, 0x3084 },
    { 0xC6E9, 0x3085 },
    { 0xC6EA, 0x3086 },
    { 0xC6EB, 0x3087 },
    { 0xC6EC, 0x3088 },
    { 0xC6ED, 0x3089 },
    { 0xC6EE, 0x308A },
    { 0xC6EF, 0x308B },
    { 0xC6F0, 0x308C },
    { 0xC6F1, 0x308D },
    { 0xC6F2, 0x308E },
    { 0xC6F3, 0x308F },
    { 0xC6F4, 0x3090 },
    { 0xC6F5, 0x3091 },
    { 0xC6F6, 0x3092 },
    { 0xC6F7, 0x3093 },
    { 0xC6F8, 0x30A1 },
    { 0xC6F9, 0x30A2 },
    { 0xC6FA, 0x30A3 },
    { 0xC6FB, 0x30A4 },
    { 0xC6FC, 0x30A5 },
    { 0xC6FD, 0x30A6 },
    { 0xC6FE, 0x30A7 },
    { 0xC740, 0x30A8 },
    { 0xC741, 0x30A9 },
    { 0xC742, 0x30AA },
    { 0xC743, 0x30AB },
    { 0xC744, 0x30AC },
    { 0xC745, 0x30AD },
    { 0xC746, 0x30AE },
    { 0xC747, 0x30AF },
    { 0xC748, 0x30B0 },
    { 0xC749, 0x30B1 },
    { 0xC74A, 0x30B2 },
    { 0xC74B, 0x30B3 },
    { 0xC74C, 0x30B4 },
    { 0xC74D, 0x30B5 },
    { 0xC74E, 0x30B6 },
    { 0xC74F, 0x30B7 },
    { 0xC750, 0x30B8 },
    { 0xC751, 0x30B9 },
    { 0xC752, 0x30BA },
    { 0xC753, 0x30BB },
    { 0xC754, 0x30BC },
    { 0xC755, 0x30BD },
    { 0xC756, 0x30BE },
    { 0xC757, 0x30BF },
    { 0xC758, 0x30C0 },
    { 0xC759, 0x30C1 },
    { 0xC75A, 0x30C2 },
    { 0xC75B, 0x30C3 },
    { 0xC75C, 0x30C4 },
    { 0xC75D, 0x30C5 },
    { 0xC75E, 0x30C6 },
    { 0xC75F, 0x30C7 },
    { 0xC760, 0x30C8 },
    { 0xC761, 0x30C9 },
    { 0xC762, 0x30CA },
    { 0xC763, 0x30CB },
    { 0xC764, 0x30CC },
    { 0xC765, 0x30CD },
    { 0xC766, 0x30CE },
    { 0xC767, 0x30CF },
    { 0xC768, 0x30D0 },
    { 0xC769, 0x30D1 },
    { 0xC76A, 0x30D2 },
    { 0xC76B, 0x30D3 },
    { 0xC76C, 0x30D4 },
    { 0xC76D, 0x30D5 },
    { 0xC76E, 0x30D6 },
    { 0xC76F, 0x30D7 },
    { 0xC770, 0x30D8 },
    { 0xC771, 0x30D9 },
    { 0xC772, 0x30DA },
    { 0xC773, 0x30DB },
    { 0xC774, 0x30DC },
    { 0xC775, 0x30DD },
    { 0xC776, 0x30DE },
    { 0xC777, 0x30DF },
    { 0xC778, 0x30E0 },
    { 0xC779, 0x30E1 },
    { 0xC77A, 0x30E2 },
    { 0xC77B, 0x30E3 },
    { 0xC77C, 0x30E4 },
    { 0xC77D, 0x30E5 },
    { 0xC77E, 0x30E6 },
    { 0xC7A1, 0x30E7 },
    { 0xC7A2, 0x30E8 },
    { 0xC7A3, 0x30E9 },
    { 0xC7A4, 0x30EA },
    { 0xC7A5, 0x30EB },
    { 0xC7A6, 0x30EC },
    { 0xC7A7, 0x30ED },
    { 0xC7A8, 0x30EE },
    { 0xC7A9, 0x30EF },
    { 0xC7AA, 0x30F0 },
    { 0xC7AB, 0x30F1 },
    { 0xC7AC, 0x30F2 },
    { 0xC7AD, 0x30F3 },
    { 0xC7AE, 0x30F4 },
    { 0xC7AF, 0x30F5 },
    { 0xC7B0, 0x30F6 },
    { 0xC7B1, 0x0414 },
    { 0xC7B2, 0x0415 },
    { 0xC7B3, 0x0401 },
    { 0xC7B4, 0x0416 },
    { 0xC7B5, 0x0417 },
    { 0xC7B6, 0x0418 },
    { 0xC7B7, 0x0419 },
    { 0xC7B8, 0x041A },
    { 0xC7B9, 0x041B },
    { 0xC7BA, 0x041C },
    { 0xC7BB, 0x0423 },
    { 0xC7BC, 0x0424 },
    { 0xC7BD, 0x0425 },
    { 0xC7BE, 0x0426 },
    { 0xC7BF, 0x0427 },
    { 0xC7C0, 0x0428 },
    { 0xC7C1, 0x0429 },
    { 0xC7C2, 0x042A },
    { 0xC7C3, 0x042B },
    { 0xC7C4, 0x042C },
    { 0xC7C5, 0x042D },{ 0xC7C6, 0x042E },
    { 0xC7C7, 0x042F },
    { 0xC7C8, 0x0430 },
    { 0xC7C9, 0x0431 },
    { 0xC7CA, 0x0432 },
    { 0xC7CB, 0x0433 },
    { 0xC7CC, 0x0434 },
    { 0xC7CD, 0x0435 },
    { 0xC7CE, 0x0451 },
    { 0xC7CF, 0x0436 },
    { 0xC7D0, 0x0437 },
    { 0xC7D1, 0x0438 },
    { 0xC7D2, 0x0439 },
    { 0xC7D3, 0x043A },
    { 0xC7D4, 0x043B },
    { 0xC7D5, 0x043C },
    { 0xC7D6, 0x043D },
    { 0xC7D7, 0x043E },
    { 0xC7D8, 0x043F },
    { 0xC7D9, 0x0440 },
    { 0xC7DA, 0x0441 },
    { 0xC7DB, 0x0442 },
    { 0xC7DC, 0x0443 },
    { 0xC7DD, 0x0444 },
    { 0xC7DE, 0x0445 },
    { 0xC7DF, 0x0446 },
    { 0xC7E0, 0x0447 },
    { 0xC7E1, 0x0448 },
    { 0xC7E2, 0x0449 },
    { 0xC7E3, 0x044A },
    { 0xC7E4, 0x044B },
    { 0xC7E5, 0x044C },
    { 0xC7E6, 0x044D },
    { 0xC7E7, 0x044E },
    { 0xC7E8, 0x044F },
    { 0xC7E9, 0x2460 },
    { 0xC7EA, 0x2461 },
    { 0xC7EB, 0x2462 },
    { 0xC7EC, 0x2463 },
    { 0xC7ED, 0x2464 },
    { 0xC7EE, 0x2465 },
    { 0xC7EF, 0x2466 },
    { 0xC7F0, 0x2467 },
    { 0xC7F1, 0x2468 },
    { 0xC7F2, 0x2469 },
    { 0xC7F3, 0x2474 },
    { 0xC7F4, 0x2475 },
    { 0xC7F5, 0x2476 },
    { 0xC7F6, 0x2477 },
    { 0xC7F7, 0x2478 },
    { 0xC7F8, 0x2479 },
    { 0xC7F9, 0x247A },
    { 0xC7FA, 0x247B },
    { 0xC7FB, 0x247C },
    { 0xC7FC, 0x247D },
    { 0xC940, 0x4E42 },
    { 0xC941, 0x4E5C },
    { 0xC942, 0x51F5 },
    { 0xC943, 0x531A },
    { 0xC944, 0x5382 },
    { 0xC945, 0x4E07 },
    { 0xC946, 0x4E0C },
    { 0xC947, 0x4E47 },
    { 0xC948, 0x4E8D },
    { 0xC949, 0x56D7 },
    { 0xC94A, 0xFA0C },
    { 0xC94B, 0x5C6E },
    { 0xC94C, 0x5F73 },
    { 0xC94D, 0x4E0F },
    { 0xC94E, 0x5187 },
    { 0xC94F, 0x4E0E },
    { 0xC950, 0x4E2E },
    { 0xC951, 0x4E93 },
    { 0xC952, 0x4EC2 },
    { 0xC953, 0x4EC9 },
    { 0xC954, 0x4EC8 },
    { 0xC955, 0x5198 },
    { 0xC956, 0x52FC },
    { 0xC957, 0x536C },
    { 0xC958, 0x53B9 },
    { 0xC959, 0x5720 },
    { 0xC95A, 0x5903 },
    { 0xC95B, 0x592C },
    { 0xC95C, 0x5C10 },
    { 0xC95D, 0x5DFF },
    { 0xC95E, 0x65E1 },
    { 0xC95F, 0x6BB3 },
    { 0xC960, 0x6BCC },
    { 0xC961, 0x6C14 },
    { 0xC962, 0x723F },
    { 0xC963, 0x4E31 },
    { 0xC964, 0x4E3C },
    { 0xC965, 0x4EE8 },
    { 0xC966, 0x4EDC },
    { 0xC967, 0x4EE9 },
    { 0xC968, 0x4EE1 },
    { 0xC969, 0x4EDD },
    { 0xC96A, 0x4EDA },
    { 0xC96B, 0x520C },
    { 0xC96C, 0x531C },
    { 0xC96D, 0x534C },
    { 0xC96E, 0x5722 },
    { 0xC96F, 0x5723 },
    { 0xC970, 0x5917 },
    { 0xC971, 0x592F },
    { 0xC972, 0x5B81 },
    { 0xC973, 0x5B84 },
    { 0xC974, 0x5C12 },
    { 0xC975, 0x5C3B },
    { 0xC976, 0x5C74 },
    { 0xC977, 0x5C73 },
    { 0xC978, 0x5E04 },
    { 0xC979, 0x5E80 },
    { 0xC97A, 0x5E82 },
    { 0xC97B, 0x5FC9 },
    { 0xC97C, 0x6209 },
    { 0xC97D, 0x6250 },
    { 0xC97E, 0x6C15 },
    { 0xC9A1, 0x6C36 },
    { 0xC9A2, 0x6C43 },
    { 0xC9A3, 0x6C3F },
    { 0xC9A4, 0x6C3B },
    { 0xC9A5, 0x72AE },
    { 0xC9A6, 0x72B0 },
    { 0xC9A7, 0x738A },
    { 0xC9A8, 0x79B8 },
    { 0xC9A9, 0x808A },
    { 0xC9AA, 0x961E },
    { 0xC9AB, 0x4F0E },
    { 0xC9AC, 0x4F18 },
    { 0xC9AD, 0x4F2C },
    { 0xC9AE, 0x4EF5 },
    { 0xC9AF, 0x4F14 },
    { 0xC9B0, 0x4EF1 },
    { 0xC9B1, 0x4F00 },
    { 0xC9B2, 0x4EF7 },
    { 0xC9B3, 0x4F08 },
    { 0xC9B4, 0x4F1D },
    { 0xC9B5, 0x4F02 },
    { 0xC9B6, 0x4F05 },
    { 0xC9B7, 0x4F22 },
    { 0xC9B8, 0x4F13 },
    { 0xC9B9, 0x4F04 },
    { 0xC9BA, 0x4EF4 },
    { 0xC9BB, 0x4F12 },
    { 0xC9BC, 0x51B1 },
    { 0xC9BD, 0x5213 },
    { 0xC9BE, 0x5209 },
    { 0xC9BF, 0x5210 },
    { 0xC9C0, 0x52A6 },
    { 0xC9C1, 0x5322 },
    { 0xC9C2, 0x531F },
    { 0xC9C3, 0x534D },
    { 0xC9C4, 0x538A },
    { 0xC9C5, 0x5407 },
    { 0xC9C6, 0x56E1 },
    { 0xC9C7, 0x56DF },
    { 0xC9C8, 0x572E },
    { 0xC9C9, 0x572A },
    { 0xC9CA, 0x5734 },
    { 0xC9CB, 0x593C },
    { 0xC9CC, 0x5980 },
    { 0xC9CD, 0x597C },
    { 0xC9CE, 0x5985 },
    { 0xC9CF, 0x597B },
    { 0xC9D0, 0x597E },
    { 0xC9D1, 0x5977 },
    { 0xC9D2, 0x597F },
    { 0xC9D3, 0x5B56 },
    { 0xC9D4, 0x5C15 },
    { 0xC9D5, 0x5C25 },
    { 0xC9D6, 0x5C7C },
    { 0xC9D7, 0x5C7A },
    { 0xC9D8, 0x5C7B },
    { 0xC9D9, 0x5C7E },
    { 0xC9DA, 0x5DDF },
    { 0xC9DB, 0x5E75 },
    { 0xC9DC, 0x5E84 },
    { 0xC9DD, 0x5F02 },
    { 0xC9DE, 0x5F1A },
    { 0xC9DF, 0x5F74 },
    { 0xC9E0, 0x5FD5 },
    { 0xC9E1, 0x5FD4 },
    { 0xC9E2, 0x5FCF },
    { 0xC9E3, 0x625C },
    { 0xC9E4, 0x625E },
    { 0xC9E5, 0x6264 },
    { 0xC9E6, 0x6261 },
    { 0xC9E7, 0x6266 },
    { 0xC9E8, 0x6262 },
    { 0xC9E9, 0x6259 },
    { 0xC9EA, 0x6260 },
    { 0xC9EB, 0x625A },
    { 0xC9EC, 0x6265 },
    { 0xC9ED, 0x65EF },
    { 0xC9EE, 0x65EE },
    { 0xC9EF, 0x673E },
    { 0xC9F0, 0x6739 },
    { 0xC9F1, 0x6738 },
    { 0xC9F2, 0x673B },
    { 0xC9F3, 0x673A },
    { 0xC9F4, 0x673F },
    { 0xC9F5, 0x673C },
    { 0xC9F6, 0x6733 },
    { 0xC9F7, 0x6C18 },
    { 0xC9F8, 0x6C46 },
    { 0xC9F9, 0x6C52 },
    { 0xC9FA, 0x6C5C },
    { 0xC9FB, 0x6C4F },
    { 0xC9FC, 0x6C4A },
    { 0xC9FD, 0x6C54 },
    { 0xC9FE, 0x6C4B },
    { 0xCA40, 0x6C4C },
    { 0xCA41, 0x7071 },
    { 0xCA42, 0x725E },
    { 0xCA43, 0x72B4 },
    { 0xCA44, 0x72B5 },
    { 0xCA45, 0x738E },
    { 0xCA46, 0x752A },
    { 0xCA47, 0x767F },
    { 0xCA48, 0x7A75 },
    { 0xCA49, 0x7F51 },
    { 0xCA4A, 0x8278 },
    { 0xCA4B, 0x827C },
    { 0xCA4C, 0x8280 },
    { 0xCA4D, 0x827D },
    { 0xCA4E, 0x827F },
    { 0xCA4F, 0x864D },
    { 0xCA50, 0x897E },
    { 0xCA51, 0x9099 },
    { 0xCA52, 0x9097 },
    { 0xCA53, 0x9098 },
    { 0xCA54, 0x909B },
    { 0xCA55, 0x9094 },
    { 0xCA56, 0x9622 },
    { 0xCA57, 0x9624 },
    { 0xCA58, 0x9620 },
    { 0xCA59, 0x9623 },
    { 0xCA5A, 0x4F56 },
    { 0xCA5B, 0x4F3B },
    { 0xCA5C, 0x4F62 },
    { 0xCA5D, 0x4F49 },
    { 0xCA5E, 0x4F53 },
    { 0xCA5F, 0x4F64 },
    { 0xCA60, 0x4F3E },
    { 0xCA61, 0x4F67 },
    { 0xCA62, 0x4F52 },
    { 0xCA63, 0x4F5F },
    { 0xCA64, 0x4F41 },
    { 0xCA65, 0x4F58 },
    { 0xCA66, 0x4F2D },
    { 0xCA67, 0x4F33 },
    { 0xCA68, 0x4F3F },
    { 0xCA69, 0x4F61 },
    { 0xCA6A, 0x518F },
    { 0xCA6B, 0x51B9 },
    { 0xCA6C, 0x521C },
    { 0xCA6D, 0x521E },
    { 0xCA6E, 0x5221 },
    { 0xCA6F, 0x52AD },
    { 0xCA70, 0x52AE },
    { 0xCA71, 0x5309 },
    { 0xCA72, 0x5363 },
    { 0xCA73, 0x5372 },
    { 0xCA74, 0x538E },
    { 0xCA75, 0x538F },
    { 0xCA76, 0x5430 },
    { 0xCA77, 0x5437 },
    { 0xCA78, 0x542A },
    { 0xCA79, 0x5454 },
    { 0xCA7A, 0x5445 },
    { 0xCA7B, 0x5419 },
    { 0xCA7C, 0x541C },
    { 0xCA7D, 0x5425 },
    { 0xCA7E, 0x5418 },
    { 0xCAA1, 0x543D },
    { 0xCAA2, 0x544F },
    { 0xCAA3, 0x5441 },
    { 0xCAA4, 0x5428 },
    { 0xCAA5, 0x5424 },
    { 0xCAA6, 0x5447 },
    { 0xCAA7, 0x56EE },
    { 0xCAA8, 0x56E7 },
    { 0xCAA9, 0x56E5 },
    { 0xCAAA, 0x5741 },
    { 0xCAAB, 0x5745 },
    { 0xCAAC, 0x574C },
    { 0xCAAD, 0x5749 },
    { 0xCAAE, 0x574B },
    { 0xCAAF, 0x5752 },
    { 0xCAB0, 0x5906 },
    { 0xCAB1, 0x5940 },
    { 0xCAB2, 0x59A6 },
    { 0xCAB3, 0x5998 },
    { 0xCAB4, 0x59A0 },
    { 0xCAB5, 0x5997 },
    { 0xCAB6, 0x598E },
    { 0xCAB7, 0x59A2 },
    { 0xCAB8, 0x5990 },
    { 0xCAB9, 0x598F },
    { 0xCABA, 0x59A7 },
    { 0xCABB, 0x59A1 },
    { 0xCABC, 0x5B8E },
    { 0xCABD, 0x5B92 },
    { 0xCABE, 0x5C28 },
    { 0xCABF, 0x5C2A },
    { 0xCAC0, 0x5C8D },
    { 0xCAC1, 0x5C8F },
    { 0xCAC2, 0x5C88 },
    { 0xCAC3, 0x5C8B },
    { 0xCAC4, 0x5C89 },
    { 0xCAC5, 0x5C92 },
    { 0xCAC6, 0x5C8A },
    { 0xCAC7, 0x5C86 },
    { 0xCAC8, 0x5C93 },
    { 0xCAC9, 0x5C95 },
    { 0xCACA, 0x5DE0 },
    { 0xCACB, 0x5E0A },
    { 0xCACC, 0x5E0E },
    { 0xCACD, 0x5E8B },
    { 0xCACE, 0x5E89 },
    { 0xCACF, 0x5E8C },
    { 0xCAD0, 0x5E88 },
    { 0xCAD1, 0x5E8D },
    { 0xCAD2, 0x5F05 },
    { 0xCAD3, 0x5F1D },
    { 0xCAD4, 0x5F78 },
    { 0xCAD5, 0x5F76 },
    { 0xCAD6, 0x5FD2 },
    { 0xCAD7, 0x5FD1 },
    { 0xCAD8, 0x5FD0 },
    { 0xCAD9, 0x5FED },
    { 0xCADA, 0x5FE8 },
    { 0xCADB, 0x5FEE },
    { 0xCADC, 0x5FF3 },
    { 0xCADD, 0x5FE1 },
    { 0xCADE, 0x5FE4 },
    { 0xCADF, 0x5FE3 },
    { 0xCAE0, 0x5FFA },
    { 0xCAE1, 0x5FEF },
    { 0xCAE2, 0x5FF7 },
    { 0xCAE3, 0x5FFB },
    { 0xCAE4, 0x6000 },
    { 0xCAE5, 0x5FF4 },
    { 0xCAE6, 0x623A },
    { 0xCAE7, 0x6283 },
    { 0xCAE8, 0x628C },
    { 0xCAE9, 0x628E },
    { 0xCAEA, 0x628F },
    { 0xCAEB, 0x6294 },
    { 0xCAEC, 0x6287 },
    { 0xCAED, 0x6271 },
    { 0xCAEE, 0x627B },
    { 0xCAEF, 0x627A },
    { 0xCAF0, 0x6270 },
    { 0xCAF1, 0x6281 },
    { 0xCAF2, 0x6288 },
    { 0xCAF3, 0x6277 },
    { 0xCAF4, 0x627D },
    { 0xCAF5, 0x6272 },
    { 0xCAF6, 0x6274 },
    { 0xCAF7, 0x6537 },
    { 0xCAF8, 0x65F0 },
    { 0xCAF9, 0x65F4 },
    { 0xCAFA, 0x65F3 },
    { 0xCAFB, 0x65F2 },
    { 0xCAFC, 0x65F5 },
    { 0xCAFD, 0x6745 },
    { 0xCAFE, 0x6747 },
    { 0xCB40, 0x6759 },
    { 0xCB41, 0x6755 },
    { 0xCB42, 0x674C },
    { 0xCB43, 0x6748 },
    { 0xCB44, 0x675D },
    { 0xCB45, 0x674D },
    { 0xCB46, 0x675A },
    { 0xCB47, 0x674B },
    { 0xCB48, 0x6BD0 },
    { 0xCB49, 0x6C19 },
    { 0xCB4A, 0x6C1A },
    { 0xCB4B, 0x6C78 },
    { 0xCB4C, 0x6C67 },
    { 0xCB4D, 0x6C6B },
    { 0xCB4E, 0x6C84 },
    { 0xCB4F, 0x6C8B },
    { 0xCB50, 0x6C8F },
    { 0xCB51, 0x6C71 },
    { 0xCB52, 0x6C6F },
    { 0xCB53, 0x6C69 },
    { 0xCB54, 0x6C9A },
    { 0xCB55, 0x6C6D },
    { 0xCB56, 0x6C87 },
    { 0xCB57, 0x6C95 },
    { 0xCB58, 0x6C9C },
    { 0xCB59, 0x6C66 },
    { 0xCB5A, 0x6C73 },
    { 0xCB5B, 0x6C65 },
    { 0xCB5C, 0x6C7B },
    { 0xCB5D, 0x6C8E },
    { 0xCB5E, 0x7074 },
    { 0xCB5F, 0x707A },
    { 0xCB60, 0x7263 },
    { 0xCB61, 0x72BF },
    { 0xCB62, 0x72BD },
    { 0xCB63, 0x72C3 },
    { 0xCB64, 0x72C6 },
    { 0xCB65, 0x72C1 },
    { 0xCB66, 0x72BA },
    { 0xCB67, 0x72C5 },
    { 0xCB68, 0x7395 },
    { 0xCB69, 0x7397 },
    { 0xCB6A, 0x7393 },
    { 0xCB6B, 0x7394 },
    { 0xCB6C, 0x7392 },
    { 0xCB6D, 0x753A },
    { 0xCB6E, 0x7539 },
    { 0xCB6F, 0x7594 },
    { 0xCB70, 0x7595 },
    { 0xCB71, 0x7681 },
    { 0xCB72, 0x793D },
    { 0xCB73, 0x8034 },
    { 0xCB74, 0x8095 },
    { 0xCB75, 0x8099 },
    { 0xCB76, 0x8090 },
    { 0xCB77, 0x8092 },
    { 0xCB78, 0x809C },
    { 0xCB79, 0x8290 },
    { 0xCB7A, 0x828F },
    { 0xCB7B, 0x8285 },
    { 0xCB7C, 0x828E },
    { 0xCB7D, 0x8291 },
    { 0xCB7E, 0x8293 },
    { 0xCBA1, 0x828A },
    { 0xCBA2, 0x8283 },
    { 0xCBA3, 0x8284 },
    { 0xCBA4, 0x8C78 },
    { 0xCBA5, 0x8FC9 },
    { 0xCBA6, 0x8FBF },
    { 0xCBA7, 0x909F },
    { 0xCBA8, 0x90A1 },
    { 0xCBA9, 0x90A5 },
    { 0xCBAA, 0x909E },
    { 0xCBAB, 0x90A7 },
    { 0xCBAC, 0x90A0 },
    { 0xCBAD, 0x9630 },
    { 0xCBAE, 0x9628 },
    { 0xCBAF, 0x962F },
    { 0xCBB0, 0x962D },
    { 0xCBB1, 0x4E33 },
    { 0xCBB2, 0x4F98 },
    { 0xCBB3, 0x4F7C },
    { 0xCBB4, 0x4F85 },
    { 0xCBB5, 0x4F7D },
    { 0xCBB6, 0x4F80 },
    { 0xCBB7, 0x4F87 },
    { 0xCBB8, 0x4F76 },
    { 0xCBB9, 0x4F74 },
    { 0xCBBA, 0x4F89 },
    { 0xCBBB, 0x4F84 },
    { 0xCBBC, 0x4F77 },
    { 0xCBBD, 0x4F4C },
    { 0xCBBE, 0x4F97 },
    { 0xCBBF, 0x4F6A },
    { 0xCBC0, 0x4F9A },
    { 0xCBC1, 0x4F79 },
    { 0xCBC2, 0x4F81 },
    { 0xCBC3, 0x4F78 },
    { 0xCBC4, 0x4F90 },
    { 0xCBC5, 0x4F9C },
    { 0xCBC6, 0x4F94 },
    { 0xCBC7, 0x4F9E },
    { 0xCBC8, 0x4F92 },
    { 0xCBC9, 0x4F82 },
    { 0xCBCA, 0x4F95 },
    { 0xCBCB, 0x4F6B },
    { 0xCBCC, 0x4F6E },
    { 0xCBCD, 0x519E },
    { 0xCBCE, 0x51BC },
    { 0xCBCF, 0x51BE },
    { 0xCBD0, 0x5235 },
    { 0xCBD1, 0x5232 },
    { 0xCBD2, 0x5233 },
    { 0xCBD3, 0x5246 },
    { 0xCBD4, 0x5231 },
    { 0xCBD5, 0x52BC },
    { 0xCBD6, 0x530A },
    { 0xCBD7, 0x530B },
    { 0xCBD8, 0x533C },
    { 0xCBD9, 0x5392 },
    { 0xCBDA, 0x5394 },
    { 0xCBDB, 0x5487 },
    { 0xCBDC, 0x547F },
    { 0xCBDD, 0x5481 },
    { 0xCBDE, 0x5491 },
    { 0xCBDF, 0x5482 },
    { 0xCBE0, 0x5488 },
    { 0xCBE1, 0x546B },
    { 0xCBE2, 0x547A },
    { 0xCBE3, 0x547E },
    { 0xCBE4, 0x5465 },
    { 0xCBE5, 0x546C },
    { 0xCBE6, 0x5474 },
    { 0xCBE7, 0x5466 },
    { 0xCBE8, 0x548D },
    { 0xCBE9, 0x546F },
    { 0xCBEA, 0x5461 },
    { 0xCBEB, 0x5460 },
    { 0xCBEC, 0x5498 },
    { 0xCBED, 0x5463 },
    { 0xCBEE, 0x5467 },
    { 0xCBEF, 0x5464 },
    { 0xCBF0, 0x56F7 },
    { 0xCBF1, 0x56F9 },
    { 0xCBF2, 0x576F },
    { 0xCBF3, 0x5772 },
    { 0xCBF4, 0x576D },
    { 0xCBF5, 0x576B },
    { 0xCBF6, 0x5771 },
    { 0xCBF7, 0x5770 },
    { 0xCBF8, 0x5776 },
    { 0xCBF9, 0x5780 },
    { 0xCBFA, 0x5775 },
    { 0xCBFB, 0x577B },
    { 0xCBFC, 0x5773 },
    { 0xCBFD, 0x5774 },
    { 0xCBFE, 0x5762 },
    { 0xCC40, 0x5768 },
    { 0xCC41, 0x577D },
    { 0xCC42, 0x590C },
    { 0xCC43, 0x5945 },
    { 0xCC44, 0x59B5 },
    { 0xCC45, 0x59BA },
    { 0xCC46, 0x59CF },
    { 0xCC47, 0x59CE },
    { 0xCC48, 0x59B2 },
    { 0xCC49, 0x59CC },
    { 0xCC4A, 0x59C1 },
    { 0xCC4B, 0x59B6 },
    { 0xCC4C, 0x59BC },
    { 0xCC4D, 0x59C3 },
    { 0xCC4E, 0x59D6 },
    { 0xCC4F, 0x59B1 },
    { 0xCC50, 0x59BD },
    { 0xCC51, 0x59C0 },
    { 0xCC52, 0x59C8 },
    { 0xCC53, 0x59B4 },
    { 0xCC54, 0x59C7 },
    { 0xCC55, 0x5B62 },
    { 0xCC56, 0x5B65 },
    { 0xCC57, 0x5B93 },
    { 0xCC58, 0x5B95 },
    { 0xCC59, 0x5C44 },
    { 0xCC5A, 0x5C47 },
    { 0xCC5B, 0x5CAE },
    { 0xCC5C, 0x5CA4 },
    { 0xCC5D, 0x5CA0 },
    { 0xCC5E, 0x5CB5 },
    { 0xCC5F, 0x5CAF },
    { 0xCC60, 0x5CA8 },
    { 0xCC61, 0x5CAC },
    { 0xCC62, 0x5C9F },
    { 0xCC63, 0x5CA3 },
    { 0xCC64, 0x5CAD },
    { 0xCC65, 0x5CA2 },
    { 0xCC66, 0x5CAA },
    { 0xCC67, 0x5CA7 },
    { 0xCC68, 0x5C9D },
    { 0xCC69, 0x5CA5 },
    { 0xCC6A, 0x5CB6 },
    { 0xCC6B, 0x5CB0 },
    { 0xCC6C, 0x5CA6 },
    { 0xCC6D, 0x5E17 },
    { 0xCC6E, 0x5E14 },
    { 0xCC6F, 0x5E19 },
    { 0xCC70, 0x5F28 },
    { 0xCC71, 0x5F22 },
    { 0xCC72, 0x5F23 },
    { 0xCC73, 0x5F24 },
    { 0xCC74, 0x5F54 },
    { 0xCC75, 0x5F82 },
    { 0xCC76, 0x5F7E },
    { 0xCC77, 0x5F7D },
    { 0xCC78, 0x5FDE },
    { 0xCC79, 0x5FE5 },
    { 0xCC7A, 0x602D },
    { 0xCC7B, 0x6026 },
    { 0xCC7C, 0x6019 },
    { 0xCC7D, 0x6032 },
    { 0xCC7E, 0x600B },
    { 0xCCA1, 0x6034 },
    { 0xCCA2, 0x600A },
    { 0xCCA3, 0x6017 },
    { 0xCCA4, 0x6033 },
    { 0xCCA5, 0x601A },
    { 0xCCA6, 0x601E },
    { 0xCCA7, 0x602C },
    { 0xCCA8, 0x6022 },
    { 0xCCA9, 0x600D },
    { 0xCCAA, 0x6010 },
    { 0xCCAB, 0x602E },
    { 0xCCAC, 0x6013 },
    { 0xCCAD, 0x6011 },
    { 0xCCAE, 0x600C },
    { 0xCCAF, 0x6009 },
    { 0xCCB0, 0x601C },
    { 0xCCB1, 0x6214 },
    { 0xCCB2, 0x623D },
    { 0xCCB3, 0x62AD },
    { 0xCCB4, 0x62B4 },
    { 0xCCB5, 0x62D1 },
    { 0xCCB6, 0x62BE },
    { 0xCCB7, 0x62AA },
    { 0xCCB8, 0x62B6 },
    { 0xCCB9, 0x62CA },
    { 0xCCBA, 0x62AE },
    { 0xCCBB, 0x62B3 },
    { 0xCCBC, 0x62AF },
    { 0xCCBD, 0x62BB },
    { 0xCCBE, 0x62A9 },
    { 0xCCBF, 0x62B0 },
    { 0xCCC0, 0x62B8 },
    { 0xCCC1, 0x653D },
    { 0xCCC2, 0x65A8 },
    { 0xCCC3, 0x65BB },
    { 0xCCC4, 0x6609 },
    { 0xCCC5, 0x65FC },
    { 0xCCC6, 0x6604 },
    { 0xCCC7, 0x6612 },
    { 0xCCC8, 0x6608 },
    { 0xCCC9, 0x65FB },
    { 0xCCCA, 0x6603 },
    { 0xCCCB, 0x660B },
    { 0xCCCC, 0x660D },
    { 0xCCCD, 0x6605 },
    { 0xCCCE, 0x65FD },
    { 0xCCCF, 0x6611 },
    { 0xCCD0, 0x6610 },
    { 0xCCD1, 0x66F6 },
    { 0xCCD2, 0x670A },
    { 0xCCD3, 0x6785 },
    { 0xCCD4, 0x676C },
    { 0xCCD5, 0x678E },
    { 0xCCD6, 0x6792 },
    { 0xCCD7, 0x6776 },
    { 0xCCD8, 0x677B },
    { 0xCCD9, 0x6798 },
    { 0xCCDA, 0x6786 },
    { 0xCCDB, 0x6784 },
    { 0xCCDC, 0x6774 },
    { 0xCCDD, 0x678D },
    { 0xCCDE, 0x678C },
    { 0xCCDF, 0x677A },
    { 0xCCE0, 0x679F },
    { 0xCCE1, 0x6791 },
    { 0xCCE2, 0x6799 },
    { 0xCCE3, 0x6783 },
    { 0xCCE4, 0x677D },
    { 0xCCE5, 0x6781 },
    { 0xCCE6, 0x6778 },
    { 0xCCE7, 0x6779 },
    { 0xCCE8, 0x6794 },
    { 0xCCE9, 0x6B25 },
    { 0xCCEA, 0x6B80 },
    { 0xCCEB, 0x6B7E },
    { 0xCCEC, 0x6BDE },
    { 0xCCED, 0x6C1D },
    { 0xCCEE, 0x6C93 },
    { 0xCCEF, 0x6CEC },
    { 0xCCF0, 0x6CEB },
    { 0xCCF1, 0x6CEE },
    { 0xCCF2, 0x6CD9 },
    { 0xCCF3, 0x6CB6 },
    { 0xCCF4, 0x6CD4 },
    { 0xCCF5, 0x6CAD },
    { 0xCCF6, 0x6CE7 },
    { 0xCCF7, 0x6CB7 },
    { 0xCCF8, 0x6CD0 },
    { 0xCCF9, 0x6CC2 },
    { 0xCCFA, 0x6CBA },
    { 0xCCFB, 0x6CC3 },
    { 0xCCFC, 0x6CC6 },
    { 0xCCFD, 0x6CED },
    { 0xCCFE, 0x6CF2 },
    { 0xCD40, 0x6CD2 },
    { 0xCD41, 0x6CDD },
    { 0xCD42, 0x6CB4 },
    { 0xCD43, 0x6C8A },
    { 0xCD44, 0x6C9D },
    { 0xCD45, 0x6C80 },
    { 0xCD46, 0x6CDE },
    { 0xCD47, 0x6CC0 },
    { 0xCD48, 0x6D30 },
    { 0xCD49, 0x6CCD },
    { 0xCD4A, 0x6CC7 },
    { 0xCD4B, 0x6CB0 },
    { 0xCD4C, 0x6CF9 },
    { 0xCD4D, 0x6CCF },
    { 0xCD4E, 0x6CE9 },
    { 0xCD4F, 0x6CD1 },
    { 0xCD50, 0x7094 },
    { 0xCD51, 0x7098 },
    { 0xCD52, 0x7085 },
    { 0xCD53, 0x7093 },
    { 0xCD54, 0x7086 },
    { 0xCD55, 0x7084 },
    { 0xCD56, 0x7091 },
    { 0xCD57, 0x7096 },
    { 0xCD58, 0x7082 },
    { 0xCD59, 0x709A },
    { 0xCD5A, 0x7083 },
    { 0xCD5B, 0x726A },
    { 0xCD5C, 0x72D6 },
    { 0xCD5D, 0x72CB },
    { 0xCD5E, 0x72D8 },
    { 0xCD5F, 0x72C9 },
    { 0xCD60, 0x72DC },
    { 0xCD61, 0x72D2 },
    { 0xCD62, 0x72D4 },
    { 0xCD63, 0x72DA },
    { 0xCD64, 0x72CC },
    { 0xCD65, 0x72D1 },
    { 0xCD66, 0x73A4 },
    { 0xCD67, 0x73A1 },
    { 0xCD68, 0x73AD },
    { 0xCD69, 0x73A6 },
    { 0xCD6A, 0x73A2 },
    { 0xCD6B, 0x73A0 },
    { 0xCD6C, 0x73AC },
    { 0xCD6D, 0x739D },
    { 0xCD6E, 0x74DD },
    { 0xCD6F, 0x74E8 },
    { 0xCD70, 0x753F },
    { 0xCD71, 0x7540 },
    { 0xCD72, 0x753E },
    { 0xCD73, 0x758C },
    { 0xCD74, 0x7598 },
    { 0xCD75, 0x76AF },
    { 0xCD76, 0x76F3 },
    { 0xCD77, 0x76F1 },
    { 0xCD78, 0x76F0 },
    { 0xCD79, 0x76F5 },
    { 0xCD7A, 0x77F8 },
    { 0xCD7B, 0x77FC },
    { 0xCD7C, 0x77F9 },
    { 0xCD7D, 0x77FB },
    { 0xCD7E, 0x77FA },
    { 0xCDA1, 0x77F7 },
    { 0xCDA2, 0x7942 },
    { 0xCDA3, 0x793F },
    { 0xCDA4, 0x79C5 },
    { 0xCDA5, 0x7A78 },
    { 0xCDA6, 0x7A7B },
    { 0xCDA7, 0x7AFB },
    { 0xCDA8, 0x7C75 },
    { 0xCDA9, 0x7CFD },
    { 0xCDAA, 0x8035 },
    { 0xCDAB, 0x808F },
    { 0xCDAC, 0x80AE },
    { 0xCDAD, 0x80A3 },
    { 0xCDAE, 0x80B8 },
    { 0xCDAF, 0x80B5 },
    { 0xCDB0, 0x80AD },
    { 0xCDB1, 0x8220 },
    { 0xCDB2, 0x82A0 },
    { 0xCDB3, 0x82C0 },
    { 0xCDB4, 0x82AB },
    { 0xCDB5, 0x829A },
    { 0xCDB6, 0x8298 },
    { 0xCDB7, 0x829B },
    { 0xCDB8, 0x82B5 },
    { 0xCDB9, 0x82A7 },
    { 0xCDBA, 0x82AE },
    { 0xCDBB, 0x82BC },
    { 0xCDBC, 0x829E },
    { 0xCDBD, 0x82BA },
    { 0xCDBE, 0x82B4 },
    { 0xCDBF, 0x82A8 },
    { 0xCDC0, 0x82A1 },
    { 0xCDC1, 0x82A9 },
    { 0xCDC2, 0x82C2 },
    { 0xCDC3, 0x82A4 },
    { 0xCDC4, 0x82C3 },
    { 0xCDC5, 0x82B6 },
    { 0xCDC6, 0x82A2 },
    { 0xCDC7, 0x8670 },
    { 0xCDC8, 0x866F },
    { 0xCDC9, 0x866D },
    { 0xCDCA, 0x866E },
    { 0xCDCB, 0x8C56 },
    { 0xCDCC, 0x8FD2 },
    { 0xCDCD, 0x8FCB },
    { 0xCDCE, 0x8FD3 },
    { 0xCDCF, 0x8FCD },
    { 0xCDD0, 0x8FD6 },
    { 0xCDD1, 0x8FD5 },
    { 0xCDD2, 0x8FD7 },
    { 0xCDD3, 0x90B2 },
    { 0xCDD4, 0x90B4 },
    { 0xCDD5, 0x90AF },
    { 0xCDD6, 0x90B3 },
    { 0xCDD7, 0x90B0 },
    { 0xCDD8, 0x9639 },
    { 0xCDD9, 0x963D },
    { 0xCDDA, 0x963C },
    { 0xCDDB, 0x963A },
    { 0xCDDC, 0x9643 },
    { 0xCDDD, 0x4FCD },
    { 0xCDDE, 0x4FC5 },
    { 0xCDDF, 0x4FD3 },
    { 0xCDE0, 0x4FB2 },
    { 0xCDE1, 0x4FC9 },
    { 0xCDE2, 0x4FCB },
    { 0xCDE3, 0x4FC1 },
    { 0xCDE4, 0x4FD4 },
    { 0xCDE5, 0x4FDC },
    { 0xCDE6, 0x4FD9 },
    { 0xCDE7, 0x4FBB },
    { 0xCDE8, 0x4FB3 },
    { 0xCDE9, 0x4FDB },
    { 0xCDEA, 0x4FC7 },
    { 0xCDEB, 0x4FD6 },
    { 0xCDEC, 0x4FBA },
    { 0xCDED, 0x4FC0 },
    { 0xCDEE, 0x4FB9 },
    { 0xCDEF, 0x4FEC },
    { 0xCDF0, 0x5244 },
    { 0xCDF1, 0x5249 },
    { 0xCDF2, 0x52C0 },
    { 0xCDF3, 0x52C2 },
    { 0xCDF4, 0x533D },
    { 0xCDF5, 0x537C },
    { 0xCDF6, 0x5397 },
    { 0xCDF7, 0x5396 },
    { 0xCDF8, 0x5399 },
    { 0xCDF9, 0x5398 },
    { 0xCDFA, 0x54BA },
    { 0xCDFB, 0x54A1 },
    { 0xCDFC, 0x54AD },
    { 0xCDFD, 0x54A5 },
    { 0xCDFE, 0x54CF },
    { 0xCE40, 0x54C3 },
    { 0xCE41, 0x830D },
    { 0xCE42, 0x54B7 },
    { 0xCE43, 0x54AE },
    { 0xCE44, 0x54D6 },
    { 0xCE45, 0x54B6 },
    { 0xCE46, 0x54C5 },
    { 0xCE47, 0x54C6 },
    { 0xCE48, 0x54A0 },
    { 0xCE49, 0x5470 },
    { 0xCE4A, 0x54BC },
    { 0xCE4B, 0x54A2 },
    { 0xCE4C, 0x54BE },
    { 0xCE4D, 0x5472 },
    { 0xCE4E, 0x54DE },
    { 0xCE4F, 0x54B0 },
    { 0xCE50, 0x57B5 },
    { 0xCE51, 0x579E },
    { 0xCE52, 0x579F },
    { 0xCE53, 0x57A4 },
    { 0xCE54, 0x578C },
    { 0xCE55, 0x5797 },
    { 0xCE56, 0x579D },
    { 0xCE57, 0x579B },
    { 0xCE58, 0x5794 },
    { 0xCE59, 0x5798 },
    { 0xCE5A, 0x578F },
    { 0xCE5B, 0x5799 },
    { 0xCE5C, 0x57A5 },
    { 0xCE5D, 0x579A },
    { 0xCE5E, 0x5795 },
    { 0xCE5F, 0x58F4 },
    { 0xCE60, 0x590D },
    { 0xCE61, 0x5953 },
    { 0xCE62, 0x59E1 },
    { 0xCE63, 0x59DE },
    { 0xCE64, 0x59EE },
    { 0xCE65, 0x5A00 },
    { 0xCE66, 0x59F1 },
    { 0xCE67, 0x59DD },
    { 0xCE68, 0x59FA },
    { 0xCE69, 0x59FD },
    { 0xCE6A, 0x59FC },
    { 0xCE6B, 0x59F6 },
    { 0xCE6C, 0x59E4 },
    { 0xCE6D, 0x59F2 },
    { 0xCE6E, 0x59F7 },
    { 0xCE6F, 0x59DB },
    { 0xCE70, 0x59E9 },
    { 0xCE71, 0x59F3 },
    { 0xCE72, 0x59F5 },
    { 0xCE73, 0x59E0 },
    { 0xCE74, 0x59FE },
    { 0xCE75, 0x59F4 },
    { 0xCE76, 0x59ED },
    { 0xCE77, 0x5BA8 },
    { 0xCE78, 0x5C4C },
    { 0xCE79, 0x5CD0 },
    { 0xCE7A, 0x5CD8 },
    { 0xCE7B, 0x5CCC },
    { 0xCE7C, 0x5CD7 },
    { 0xCE7D, 0x5CCB },
    { 0xCE7E, 0x5CDB },
    { 0xCEA1, 0x5CDE },
    { 0xCEA2, 0x5CDA },
    { 0xCEA3, 0x5CC9 },
    { 0xCEA4, 0x5CC7 },
    { 0xCEA5, 0x5CCA },
    { 0xCEA6, 0x5CD6 },
    { 0xCEA7, 0x5CD3 },
    { 0xCEA8, 0x5CD4 },
    { 0xCEA9, 0x5CCF },
    { 0xCEAA, 0x5CC8 },
    { 0xCEAB, 0x5CC6 },
    { 0xCEAC, 0x5CCE },
    { 0xCEAD, 0x5CDF },
    { 0xCEAE, 0x5CF8 },
    { 0xCEAF, 0x5DF9 },
    { 0xCEB0, 0x5E21 },
    { 0xCEB1, 0x5E22 },
    { 0xCEB2, 0x5E23 },
    { 0xCEB3, 0x5E20 },
    { 0xCEB4, 0x5E24 },
    { 0xCEB5, 0x5EB0 },
    { 0xCEB6, 0x5EA4 },
    { 0xCEB7, 0x5EA2 },
    { 0xCEB8, 0x5E9B },
    { 0xCEB9, 0x5EA3 },
    { 0xCEBA, 0x5EA5 },
    { 0xCEBB, 0x5F07 },
    { 0xCEBC, 0x5F2E },
    { 0xCEBD, 0x5F56 },
    { 0xCEBE, 0x5F86 },
    { 0xCEBF, 0x6037 },
    { 0xCEC0, 0x6039 },
    { 0xCEC1, 0x6054 },
    { 0xCEC2, 0x6072 },
    { 0xCEC3, 0x605E },
    { 0xCEC4, 0x6045 },
    { 0xCEC5, 0x6053 },
    { 0xCEC6, 0x6047 },
    { 0xCEC7, 0x6049 },
    { 0xCEC8, 0x605B },
    { 0xCEC9, 0x604C },
    { 0xCECA, 0x6040 },
    { 0xCECB, 0x6042 },
    { 0xCECC, 0x605F },
    { 0xCECD, 0x6024 },
    { 0xCECE, 0x6044 },
    { 0xCECF, 0x6058 },
    { 0xCED0, 0x6066 },
    { 0xCED1, 0x606E },
    { 0xCED2, 0x6242 },
    { 0xCED3, 0x6243 },
    { 0xCED4, 0x62CF },
    { 0xCED5, 0x630D },
    { 0xCED6, 0x630B },
    { 0xCED7, 0x62F5 },
    { 0xCED8, 0x630E },
    { 0xCED9, 0x6303 },
    { 0xCEDA, 0x62EB },
    { 0xCEDB, 0x62F9 },
    { 0xCEDC, 0x630F },
    { 0xCEDD, 0x630C },
    { 0xCEDE, 0x62F8 },
    { 0xCEDF, 0x62F6 },
    { 0xCEE0, 0x6300 },
    { 0xCEE1, 0x6313 },
    { 0xCEE2, 0x6314 },
    { 0xCEE3, 0x62FA },
    { 0xCEE4, 0x6315 },
    { 0xCEE5, 0x62FB },
    { 0xCEE6, 0x62F0 },
    { 0xCEE7, 0x6541 },
    { 0xCEE8, 0x6543 },
    { 0xCEE9, 0x65AA },
    { 0xCEEA, 0x65BF },
    { 0xCEEB, 0x6636 },
    { 0xCEEC, 0x6621 },
    { 0xCEED, 0x6632 },
    { 0xCEEE, 0x6635 },
    { 0xCEEF, 0x661C },
    { 0xCEF0, 0x6626 },
    { 0xCEF1, 0x6622 },
    { 0xCEF2, 0x6633 },
    { 0xCEF3, 0x662B },
    { 0xCEF4, 0x663A },
    { 0xCEF5, 0x661D },
    { 0xCEF6, 0x6634 },
    { 0xCEF7, 0x6639 },
    { 0xCEF8, 0x662E },
    { 0xCEF9, 0x670F },
    { 0xCEFA, 0x6710 },
    { 0xCEFB, 0x67C1 },
    { 0xCEFC, 0x67F2 },
    { 0xCEFD, 0x67C8 },
    { 0xCEFE, 0x67BA },
    { 0xCF40, 0x67DC },
    { 0xCF41, 0x67BB },
    { 0xCF42, 0x67F8 },
    { 0xCF43, 0x67D8 },
    { 0xCF44, 0x67C0 },
    { 0xCF45, 0x67B7 },
    { 0xCF46, 0x67C5 },
    { 0xCF47, 0x67EB },
    { 0xCF48, 0x67E4 },
    { 0xCF49, 0x67DF },
    { 0xCF4A, 0x67B5 },
    { 0xCF4B, 0x67CD },
    { 0xCF4C, 0x67B3 },
    { 0xCF4D, 0x67F7 },
    { 0xCF4E, 0x67F6 },
    { 0xCF4F, 0x67EE },
    { 0xCF50, 0x67E3 },
    { 0xCF51, 0x67C2 },
    { 0xCF52, 0x67B9 },
    { 0xCF53, 0x67CE },
    { 0xCF54, 0x67E7 },
    { 0xCF55, 0x67F0 },
    { 0xCF56, 0x67B2 },
    { 0xCF57, 0x67FC },
    { 0xCF58, 0x67C6 },
    { 0xCF59, 0x67ED },
    { 0xCF5A, 0x67CC },
    { 0xCF5B, 0x67AE },
    { 0xCF5C, 0x67E6 },
    { 0xCF5D, 0x67DB },
    { 0xCF5E, 0x67FA },
    { 0xCF5F, 0x67C9 },
    { 0xCF60, 0x67CA },
    { 0xCF61, 0x67C3 },
    { 0xCF62, 0x67EA },
    { 0xCF63, 0x67CB },
    { 0xCF64, 0x6B28 },
    { 0xCF65, 0x6B82 },
    { 0xCF66, 0x6B84 },
    { 0xCF67, 0x6BB6 },
    { 0xCF68, 0x6BD6 },
    { 0xCF69, 0x6BD8 },
    { 0xCF6A, 0x6BE0 },
    { 0xCF6B, 0x6C20 },
    { 0xCF6C, 0x6C21 },
    { 0xCF6D, 0x6D28 },
    { 0xCF6E, 0x6D34 },
    { 0xCF6F, 0x6D2D },
    { 0xCF70, 0x6D1F },
    { 0xCF71, 0x6D3C },
    { 0xCF72, 0x6D3F },
    { 0xCF73, 0x6D12 },
    { 0xCF74, 0x6D0A },
    { 0xCF75, 0x6CDA },
    { 0xCF76, 0x6D33 },
    { 0xCF77, 0x6D04 },
    { 0xCF78, 0x6D19 },
    { 0xCF79, 0x6D3A },
    { 0xCF7A, 0x6D1A },
    { 0xCF7B, 0x6D11 },
    { 0xCF7C, 0x6D00 },
    { 0xCF7D, 0x6D1D },
    { 0xCF7E, 0x6D42 },
    { 0xCFA1, 0x6D01 },
    { 0xCFA2, 0x6D18 },
    { 0xCFA3, 0x6D37 },
    { 0xCFA4, 0x6D03 },
    { 0xCFA5, 0x6D0F },
    { 0xCFA6, 0x6D40 },
    { 0xCFA7, 0x6D07 },
    { 0xCFA8, 0x6D20 },
    { 0xCFA9, 0x6D2C },
    { 0xCFAA, 0x6D08 },
    { 0xCFAB, 0x6D22 },
    { 0xCFAC, 0x6D09 },
    { 0xCFAD, 0x6D10 },
    { 0xCFAE, 0x70B7 },
    { 0xCFAF, 0x709F },
    { 0xCFB0, 0x70BE },
    { 0xCFB1, 0x70B1 },
    { 0xCFB2, 0x70B0 },
    { 0xCFB3, 0x70A1 },
    { 0xCFB4, 0x70B4 },
    { 0xCFB5, 0x70B5 },
    { 0xCFB6, 0x70A9 },
    { 0xCFB7, 0x7241 },
    { 0xCFB8, 0x7249 },
    { 0xCFB9, 0x724A },
    { 0xCFBA, 0x726C },
    { 0xCFBB, 0x7270 },
    { 0xCFBC, 0x7273 },
    { 0xCFBD, 0x726E },
    { 0xCFBE, 0x72CA },
    { 0xCFBF, 0x72E4 },
    { 0xCFC0, 0x72E8 },
    { 0xCFC1, 0x72EB },
    { 0xCFC2, 0x72DF },
    { 0xCFC3, 0x72EA },
    { 0xCFC4, 0x72E6 },
    { 0xCFC5, 0x72E3 },
    { 0xCFC6, 0x7385 },
    { 0xCFC7, 0x73CC },
    { 0xCFC8, 0x73C2 },
    { 0xCFC9, 0x73C8 },
    { 0xCFCA, 0x73C5 },
    { 0xCFCB, 0x73B9 },
    { 0xCFCC, 0x73B6 },
    { 0xCFCD, 0x73B5 },
    { 0xCFCE, 0x73B4 },
    { 0xCFCF, 0x73EB },
    { 0xCFD0, 0x73BF },
    { 0xCFD1, 0x73C7 },
    { 0xCFD2, 0x73BE },
    { 0xCFD3, 0x73C3 },
    { 0xCFD4, 0x73C6 },
    { 0xCFD5, 0x73B8 },
    { 0xCFD6, 0x73CB },
    { 0xCFD7, 0x74EC },
    { 0xCFD8, 0x74EE },
    { 0xCFD9, 0x752E },
    { 0xCFDA, 0x7547 },
    { 0xCFDB, 0x7548 },
    { 0xCFDC, 0x75A7 },
    { 0xCFDD, 0x75AA },
    { 0xCFDE, 0x7679 },
    { 0xCFDF, 0x76C4 },
    { 0xCFE0, 0x7708 },
    { 0xCFE1, 0x7703 },
    { 0xCFE2, 0x7704 },
    { 0xCFE3, 0x7705 },
    { 0xCFE4, 0x770A },
    { 0xCFE5, 0x76F7 },
    { 0xCFE6, 0x76FB },
    { 0xCFE7, 0x76FA },
    { 0xCFE8, 0x77E7 },
    { 0xCFE9, 0x77E8 },
    { 0xCFEA, 0x7806 },
    { 0xCFEB, 0x7811 },
    { 0xCFEC, 0x7812 },
    { 0xCFED, 0x7805 },
    { 0xCFEE, 0x7810 },
    { 0xCFEF, 0x780F },
    { 0xCFF0, 0x780E },
    { 0xCFF1, 0x7809 },
    { 0xCFF2, 0x7803 },
    { 0xCFF3, 0x7813 },
    { 0xCFF4, 0x794A },
    { 0xCFF5, 0x794C },
    { 0xCFF6, 0x794B },
    { 0xCFF7, 0x7945 },
    { 0xCFF8, 0x7944 },
    { 0xCFF9, 0x79D5 },
    { 0xCFFA, 0x79CD },
    { 0xCFFB, 0x79CF },
    { 0xCFFC, 0x79D6 },
    { 0xCFFD, 0x79CE },
    { 0xCFFE, 0x7A80 },
    { 0xD040, 0x7A7E },
    { 0xD041, 0x7AD1 },
    { 0xD042, 0x7B00 },
    { 0xD043, 0x7B01 },
    { 0xD044, 0x7C7A },
    { 0xD045, 0x7C78 },
    { 0xD046, 0x7C79 },
    { 0xD047, 0x7C7F },
    { 0xD048, 0x7C80 },
    { 0xD049, 0x7C81 },
    { 0xD04A, 0x7D03 },
    { 0xD04B, 0x7D08 },
    { 0xD04C, 0x7D01 },
    { 0xD04D, 0x7F58 },
    { 0xD04E, 0x7F91 },
    { 0xD04F, 0x7F8D },
    { 0xD050, 0x7FBE },
    { 0xD051, 0x8007 },
    { 0xD052, 0x800E },
    { 0xD053, 0x800F },
    { 0xD054, 0x8014 },
    { 0xD055, 0x8037 },
    { 0xD056, 0x80D8 },
    { 0xD057, 0x80C7 },
    { 0xD058, 0x80E0 },
    { 0xD059, 0x80D1 },
    { 0xD05A, 0x80C8 },
    { 0xD05B, 0x80C2 },
    { 0xD05C, 0x80D0 },
    { 0xD05D, 0x80C5 },
    { 0xD05E, 0x80E3 },
    { 0xD05F, 0x80D9 },
    { 0xD060, 0x80DC },
    { 0xD061, 0x80CA },
    { 0xD062, 0x80D5 },
    { 0xD063, 0x80C9 },
    { 0xD064, 0x80CF },
    { 0xD065, 0x80D7 },
    { 0xD066, 0x80E6 },
    { 0xD067, 0x80CD },
    { 0xD068, 0x81FF },
    { 0xD069, 0x8221 },
    { 0xD06A, 0x8294 },
    { 0xD06B, 0x82D9 },
    { 0xD06C, 0x82FE },
    { 0xD06D, 0x82F9 },
    { 0xD06E, 0x8307 },
    { 0xD06F, 0x82E8 },
    { 0xD070, 0x8300 },
    { 0xD071, 0x82D5 },
    { 0xD072, 0x833A },
    { 0xD073, 0x82EB },
    { 0xD074, 0x82D6 },
    { 0xD075, 0x82F4 },
    { 0xD076, 0x82EC },
    { 0xD077, 0x82E1 },
    { 0xD078, 0x82F2 },
    { 0xD079, 0x82F5 },
    { 0xD07A, 0x830C },
    { 0xD07B, 0x82FB },
    { 0xD07C, 0x82F6 },
    { 0xD07D, 0x82F0 },
    { 0xD07E, 0x82EA },
    { 0xD0A1, 0x82E4 },
    { 0xD0A2, 0x82E0 },
    { 0xD0A3, 0x82FA },
    { 0xD0A4, 0x82F3 },
    { 0xD0A5, 0x82ED },
    { 0xD0A6, 0x8677 },
    { 0xD0A7, 0x8674 },
    { 0xD0A8, 0x867C },
    { 0xD0A9, 0x8673 },
    { 0xD0AA, 0x8841 },
    { 0xD0AB, 0x884E },
    { 0xD0AC, 0x8867 },
    { 0xD0AD, 0x886A },
    { 0xD0AE, 0x8869 },
    { 0xD0AF, 0x89D3 },
    { 0xD0B0, 0x8A04 },
    { 0xD0B1, 0x8A07 },
    { 0xD0B2, 0x8D72 },
    { 0xD0B3, 0x8FE3 },
    { 0xD0B4, 0x8FE1 },
    { 0xD0B5, 0x8FEE },
    { 0xD0B6, 0x8FE0 },
    { 0xD0B7, 0x90F1 },
    { 0xD0B8, 0x90BD },
    { 0xD0B9, 0x90BF },
    { 0xD0BA, 0x90D5 },
    { 0xD0BB, 0x90C5 },
    { 0xD0BC, 0x90BE },
    { 0xD0BD, 0x90C7 },
    { 0xD0BE, 0x90CB },
    { 0xD0BF, 0x90C8 },
    { 0xD0C0, 0x91D4 },
    { 0xD0C1, 0x91D3 },
    { 0xD0C2, 0x9654 },
    { 0xD0C3, 0x964F },
    { 0xD0C4, 0x9651 },
    { 0xD0C5, 0x9653 },
    { 0xD0C6, 0x964A },
    { 0xD0C7, 0x964E },
    { 0xD0C8, 0x501E },
    { 0xD0C9, 0x5005 },
    { 0xD0CA, 0x5007 },
    { 0xD0CB, 0x5013 },
    { 0xD0CC, 0x5022 },
    { 0xD0CD, 0x5030 },
    { 0xD0CE, 0x501B },
    { 0xD0CF, 0x4FF5 },
    { 0xD0D0, 0x4FF4 },
    { 0xD0D1, 0x5033 },
    { 0xD0D2, 0x5037 },
    { 0xD0D3, 0x502C },
    { 0xD0D4, 0x4FF6 },
    { 0xD0D5, 0x4FF7 },
    { 0xD0D6, 0x5017 },
    { 0xD0D7, 0x501C },
    { 0xD0D8, 0x5020 },
    { 0xD0D9, 0x5027 },
    { 0xD0DA, 0x5035 },
    { 0xD0DB, 0x502F },
    { 0xD0DC, 0x5031 },
    { 0xD0DD, 0x500E },
    { 0xD0DE, 0x515A },
    { 0xD0DF, 0x5194 },
    { 0xD0E0, 0x5193 },
    { 0xD0E1, 0x51CA },
    { 0xD0E2, 0x51C4 },
    { 0xD0E3, 0x51C5 },
    { 0xD0E4, 0x51C8 },
    { 0xD0E5, 0x51CE },
    { 0xD0E6, 0x5261 },
    { 0xD0E7, 0x525A },
    { 0xD0E8, 0x5252 },
    { 0xD0E9, 0x525E },
    { 0xD0EA, 0x525F },
    { 0xD0EB, 0x5255 },
    { 0xD0EC, 0x5262 },
    { 0xD0ED, 0x52CD },
    { 0xD0EE, 0x530E },
    { 0xD0EF, 0x539E },
    { 0xD0F0, 0x5526 },
    { 0xD0F1, 0x54E2 },
    { 0xD0F2, 0x5517 },
    { 0xD0F3, 0x5512 },
    { 0xD0F4, 0x54E7 },
    { 0xD0F5, 0x54F3 },
    { 0xD0F6, 0x54E4 },
    { 0xD0F7, 0x551A },
    { 0xD0F8, 0x54FF },
    { 0xD0F9, 0x5504 },
    { 0xD0FA, 0x5508 },
    { 0xD0FB, 0x54EB },
    { 0xD0FC, 0x5511 },
    { 0xD0FD, 0x5505 },
    { 0xD0FE, 0x54F1 },
    { 0xD140, 0x550A },
    { 0xD141, 0x54FB },
    { 0xD142, 0x54F7 },
    { 0xD143, 0x54F8 },
    { 0xD144, 0x54E0 },
    { 0xD145, 0x550E },
    { 0xD146, 0x5503 },
    { 0xD147, 0x550B },
    { 0xD148, 0x5701 },
    { 0xD149, 0x5702 },
    { 0xD14A, 0x57CC },
    { 0xD14B, 0x5832 },
    { 0xD14C, 0x57D5 },
    { 0xD14D, 0x57D2 },
    { 0xD14E, 0x57BA },
    { 0xD14F, 0x57C6 },
    { 0xD150, 0x57BD },
    { 0xD151, 0x57BC },
    { 0xD152, 0x57B8 },
    { 0xD153, 0x57B6 },
    { 0xD154, 0x57BF },
    { 0xD155, 0x57C7 },
    { 0xD156, 0x57D0 },
    { 0xD157, 0x57B9 },
    { 0xD158, 0x57C1 },
    { 0xD159, 0x590E },
    { 0xD15A, 0x594A },
    { 0xD15B, 0x5A19 },
    { 0xD15C, 0x5A16 },
    { 0xD15D, 0x5A2D },
    { 0xD15E, 0x5A2E },
    { 0xD15F, 0x5A15 },
    { 0xD160, 0x5A0F },
    { 0xD161, 0x5A17 },
    { 0xD162, 0x5A0A },
    { 0xD163, 0x5A1E },
    { 0xD164, 0x5A33 },
    { 0xD165, 0x5B6C },
    { 0xD166, 0x5BA7 },
    { 0xD167, 0x5BAD },
    { 0xD168, 0x5BAC },
    { 0xD169, 0x5C03 },
    { 0xD16A, 0x5C56 },
    { 0xD16B, 0x5C54 },
    { 0xD16C, 0x5CEC },
    { 0xD16D, 0x5CFF },
    { 0xD16E, 0x5CEE },
    { 0xD16F, 0x5CF1 },
    { 0xD170, 0x5CF7 },
    { 0xD171, 0x5D00 },
    { 0xD172, 0x5CF9 },
    { 0xD173, 0x5E29 },
    { 0xD174, 0x5E28 },
    { 0xD175, 0x5EA8 },
    { 0xD176, 0x5EAE },
    { 0xD177, 0x5EAA },
    { 0xD178, 0x5EAC },
    { 0xD179, 0x5F33 },
    { 0xD17A, 0x5F30 },
    { 0xD17B, 0x5F67 },
    { 0xD17C, 0x605D },
    { 0xD17D, 0x605A },
    { 0xD17E, 0x6067 },
    { 0xD1A1, 0x6041 },
    { 0xD1A2, 0x60A2 },
    { 0xD1A3, 0x6088 },
    { 0xD1A4, 0x6080 },
    { 0xD1A5, 0x6092 },
    { 0xD1A6, 0x6081 },
    { 0xD1A7, 0x609D },
    { 0xD1A8, 0x6083 },
    { 0xD1A9, 0x6095 },
    { 0xD1AA, 0x609B },
    { 0xD1AB, 0x6097 },
    { 0xD1AC, 0x6087 },
    { 0xD1AD, 0x609C },
    { 0xD1AE, 0x608E },
    { 0xD1AF, 0x6219 },
    { 0xD1B0, 0x6246 },
    { 0xD1B1, 0x62F2 },
    { 0xD1B2, 0x6310 },
    { 0xD1B3, 0x6356 },
    { 0xD1B4, 0x632C },
    { 0xD1B5, 0x6344 },
    { 0xD1B6, 0x6345 },
    { 0xD1B7, 0x6336 },
    { 0xD1B8, 0x6343 },
    { 0xD1B9, 0x63E4 },
    { 0xD1BA, 0x6339 },
    { 0xD1BB, 0x634B },
    { 0xD1BC, 0x634A },
    { 0xD1BD, 0x633C },
    { 0xD1BE, 0x6329 },
    { 0xD1BF, 0x6341 },
    { 0xD1C0, 0x6334 },
    { 0xD1C1, 0x6358 },
    { 0xD1C2, 0x6354 },
    { 0xD1C3, 0x6359 },
    { 0xD1C4, 0x632D },
    { 0xD1C5, 0x6347 },
    { 0xD1C6, 0x6333 },
    { 0xD1C7, 0x635A },
    { 0xD1C8, 0x6351 },
    { 0xD1C9, 0x6338 },
    { 0xD1CA, 0x6357 },
    { 0xD1CB, 0x6340 },
    { 0xD1CC, 0x6348 },
    { 0xD1CD, 0x654A },
    { 0xD1CE, 0x6546 },
    { 0xD1CF, 0x65C6 },
    { 0xD1D0, 0x65C3 },
    { 0xD1D1, 0x65C4 },
    { 0xD1D2, 0x65C2 },
    { 0xD1D3, 0x664A },
    { 0xD1D4, 0x665F },
    { 0xD1D5, 0x6647 },
    { 0xD1D6, 0x6651 },
    { 0xD1D7, 0x6712 },
    { 0xD1D8, 0x6713 },
    { 0xD1D9, 0x681F },
    { 0xD1DA, 0x681A },
    { 0xD1DB, 0x6849 },
    { 0xD1DC, 0x6832 },
    { 0xD1DD, 0x6833 },
    { 0xD1DE, 0x683B },
    { 0xD1DF, 0x684B },
    { 0xD1E0, 0x684F },
    { 0xD1E1, 0x6816 },
    { 0xD1E2, 0x6831 },
    { 0xD1E3, 0x681C },
    { 0xD1E4, 0x6835 },
    { 0xD1E5, 0x682B },
    { 0xD1E6, 0x682D },
    { 0xD1E7, 0x682F },
    { 0xD1E8, 0x684E },
    { 0xD1E9, 0x6844 },
    { 0xD1EA, 0x6834 },
    { 0xD1EB, 0x681D },
    { 0xD1EC, 0x6812 },
    { 0xD1ED, 0x6814 },
    { 0xD1EE, 0x6826 },
    { 0xD1EF, 0x6828 },
    { 0xD1F0, 0x682E },
    { 0xD1F1, 0x684D },
    { 0xD1F2, 0x683A },
    { 0xD1F3, 0x6825 },
    { 0xD1F4, 0x6820 },
    { 0xD1F5, 0x6B2C },
    { 0xD1F6, 0x6B2F },
    { 0xD1F7, 0x6B2D },
    { 0xD1F8, 0x6B31 },
    { 0xD1F9, 0x6B34 },
    { 0xD1FA, 0x6B6D },
    { 0xD1FB, 0x8082 },
    { 0xD1FC, 0x6B88 },
    { 0xD1FD, 0x6BE6 },
    { 0xD1FE, 0x6BE4 },
    { 0xD240, 0x6BE8 },
    { 0xD241, 0x6BE3 },
    { 0xD242, 0x6BE2 },
    { 0xD243, 0x6BE7 },
    { 0xD244, 0x6C25 },
    { 0xD245, 0x6D7A },
    { 0xD246, 0x6D63 },
    { 0xD247, 0x6D64 },
    { 0xD248, 0x6D76 },
    { 0xD249, 0x6D0D },
    { 0xD24A, 0x6D61 },
    { 0xD24B, 0x6D92 },
    { 0xD24C, 0x6D58 },
    { 0xD24D, 0x6D62 },
    { 0xD24E, 0x6D6D },
    { 0xD24F, 0x6D6F },
    { 0xD250, 0x6D91 },
    { 0xD251, 0x6D8D },
    { 0xD252, 0x6DEF },
    { 0xD253, 0x6D7F },
    { 0xD254, 0x6D86 },
    { 0xD255, 0x6D5E },
    { 0xD256, 0x6D67 },
    { 0xD257, 0x6D60 },
    { 0xD258, 0x6D97 },
    { 0xD259, 0x6D70 },
    { 0xD25A, 0x6D7C },
    { 0xD25B, 0x6D5F },
    { 0xD25C, 0x6D82 },
    { 0xD25D, 0x6D98 },
    { 0xD25E, 0x6D2F },
    { 0xD25F, 0x6D68 },
    { 0xD260, 0x6D8B },
    { 0xD261, 0x6D7E },
    { 0xD262, 0x6D80 },
    { 0xD263, 0x6D84 },
    { 0xD264, 0x6D16 },
    { 0xD265, 0x6D83 },
    { 0xD266, 0x6D7B },
    { 0xD267, 0x6D7D },
    { 0xD268, 0x6D75 },
    { 0xD269, 0x6D90 },
    { 0xD26A, 0x70DC },
    { 0xD26B, 0x70D3 },
    { 0xD26C, 0x70D1 },
    { 0xD26D, 0x70DD },
    { 0xD26E, 0x70CB },
    { 0xD26F, 0x7F39 },
    { 0xD270, 0x70E2 },
    { 0xD271, 0x70D7 },
    { 0xD272, 0x70D2 },
    { 0xD273, 0x70DE },
    { 0xD274, 0x70E0 },
    { 0xD275, 0x70D4 },
    { 0xD276, 0x70CD },
    { 0xD277, 0x70C5 },
    { 0xD278, 0x70C6 },
    { 0xD279, 0x70C7 },
    { 0xD27A, 0x70DA },
    { 0xD27B, 0x70CE },
    { 0xD27C, 0x70E1 },
    { 0xD27D, 0x7242 },
    { 0xD27E, 0x7278 },
    { 0xD2A1, 0x7277 },
    { 0xD2A2, 0x7276 },
    { 0xD2A3, 0x7300 },
    { 0xD2A4, 0x72FA },
    { 0xD2A5, 0x72F4 },
    { 0xD2A6, 0x72FE },
    { 0xD2A7, 0x72F6 },
    { 0xD2A8, 0x72F3 },
    { 0xD2A9, 0x72FB },
    { 0xD2AA, 0x7301 },
    { 0xD2AB, 0x73D3 },
    { 0xD2AC, 0x73D9 },
    { 0xD2AD, 0x73E5 },
    { 0xD2AE, 0x73D6 },
    { 0xD2AF, 0x73BC },
    { 0xD2B0, 0x73E7 },
    { 0xD2B1, 0x73E3 },
    { 0xD2B2, 0x73E9 },
    { 0xD2B3, 0x73DC },
    { 0xD2B4, 0x73D2 },
    { 0xD2B5, 0x73DB },
    { 0xD2B6, 0x73D4 },
    { 0xD2B7, 0x73DD },
    { 0xD2B8, 0x73DA },
    { 0xD2B9, 0x73D7 },
    { 0xD2BA, 0x73D8 },
    { 0xD2BB, 0x73E8 },
    { 0xD2BC, 0x74DE },
    { 0xD2BD, 0x74DF },
    { 0xD2BE, 0x74F4 },
    { 0xD2BF, 0x74F5 },
    { 0xD2C0, 0x7521 },
    { 0xD2C1, 0x755B },
    { 0xD2C2, 0x755F },
    { 0xD2C3, 0x75B0 },
    { 0xD2C4, 0x75C1 },
    { 0xD2C5, 0x75BB },
    { 0xD2C6, 0x75C4 },
    { 0xD2C7, 0x75C0 },
    { 0xD2C8, 0x75BF },
    { 0xD2C9, 0x75B6 },
    { 0xD2CA, 0x75BA },
    { 0xD2CB, 0x768A },
    { 0xD2CC, 0x76C9 },
    { 0xD2CD, 0x771D },
    { 0xD2CE, 0x771B },
    { 0xD2CF, 0x7710 },
    { 0xD2D0, 0x7713 },
    { 0xD2D1, 0x7712 },
    { 0xD2D2, 0x7723 },
    { 0xD2D3, 0x7711 },
    { 0xD2D4, 0x7715 },
    { 0xD2D5, 0x7719 },
    { 0xD2D6, 0x771A },
    { 0xD2D7, 0x7722 },
    { 0xD2D8, 0x7727 },
    { 0xD2D9, 0x7823 },
    { 0xD2DA, 0x782C },
    { 0xD2DB, 0x7822 },
    { 0xD2DC, 0x7835 },
    { 0xD2DD, 0x782F },
    { 0xD2DE, 0x7828 },
    { 0xD2DF, 0x782E },
    { 0xD2E0, 0x782B },
    { 0xD2E1, 0x7821 },
    { 0xD2E2, 0x7829 },
    { 0xD2E3, 0x7833 },
    { 0xD2E4, 0x782A },
    { 0xD2E5, 0x7831 },
    { 0xD2E6, 0x7954 },
    { 0xD2E7, 0x795B },
    { 0xD2E8, 0x794F },
    { 0xD2E9, 0x795C },
    { 0xD2EA, 0x7953 },
    { 0xD2EB, 0x7952 },
    { 0xD2EC, 0x7951 },
    { 0xD2ED, 0x79EB },
    { 0xD2EE, 0x79EC },
    { 0xD2EF, 0x79E0 },
    { 0xD2F0, 0x79EE },
    { 0xD2F1, 0x79ED },
    { 0xD2F2, 0x79EA },
    { 0xD2F3, 0x79DC },
    { 0xD2F4, 0x79DE },
    { 0xD2F5, 0x79DD },
    { 0xD2F6, 0x7A86 },
    { 0xD2F7, 0x7A89 },
    { 0xD2F8, 0x7A85 },
    { 0xD2F9, 0x7A8B },
    { 0xD2FA, 0x7A8C },
    { 0xD2FB, 0x7A8A },
    { 0xD2FC, 0x7A87 },
    { 0xD2FD, 0x7AD8 },
    { 0xD2FE, 0x7B10 },
    { 0xD340, 0x7B04 },
    { 0xD341, 0x7B13 },
    { 0xD342, 0x7B05 },
    { 0xD343, 0x7B0F },
    { 0xD344, 0x7B08 },
    { 0xD345, 0x7B0A },
    { 0xD346, 0x7B0E },
    { 0xD347, 0x7B09 },
    { 0xD348, 0x7B12 },
    { 0xD349, 0x7C84 },
    { 0xD34A, 0x7C91 },
    { 0xD34B, 0x7C8A },
    { 0xD34C, 0x7C8C },
    { 0xD34D, 0x7C88 },
    { 0xD34E, 0x7C8D },
    { 0xD34F, 0x7C85 },
    { 0xD350, 0x7D1E },
    { 0xD351, 0x7D1D },
    { 0xD352, 0x7D11 },
    { 0xD353, 0x7D0E },
    { 0xD354, 0x7D18 },
    { 0xD355, 0x7D16 },
    { 0xD356, 0x7D13 },
    { 0xD357, 0x7D1F },
    { 0xD358, 0x7D12 },
    { 0xD359, 0x7D0F },
    { 0xD35A, 0x7D0C },
    { 0xD35B, 0x7F5C },
    { 0xD35C, 0x7F61 },
    { 0xD35D, 0x7F5E },
    { 0xD35E, 0x7F60 },
    { 0xD35F, 0x7F5D },
    { 0xD360, 0x7F5B },
    { 0xD361, 0x7F96 },
    { 0xD362, 0x7F92 },
    { 0xD363, 0x7FC3 },
    { 0xD364, 0x7FC2 },
    { 0xD365, 0x7FC0 },
    { 0xD366, 0x8016 },
    { 0xD367, 0x803E },
    { 0xD368, 0x8039 },
    { 0xD369, 0x80FA },
    { 0xD36A, 0x80F2 },
    { 0xD36B, 0x80F9 },
    { 0xD36C, 0x80F5 },
    { 0xD36D, 0x8101 },
    { 0xD36E, 0x80FB },
    { 0xD36F, 0x8100 },
    { 0xD370, 0x8201 },
    { 0xD371, 0x822F },
    { 0xD372, 0x8225 },
    { 0xD373, 0x8333 },
    { 0xD374, 0x832D },
    { 0xD375, 0x8344 },
    { 0xD376, 0x8319 },
    { 0xD377, 0x8351 },
    { 0xD378, 0x8325 },
    { 0xD379, 0x8356 },
    { 0xD37A, 0x833F },
    { 0xD37B, 0x8341 },
    { 0xD37C, 0x8326 },
    { 0xD37D, 0x831C },
    { 0xD37E, 0x8322 },
    { 0xD3A1, 0x8342 },
    { 0xD3A2, 0x834E },
    { 0xD3A3, 0x831B },
    { 0xD3A4, 0x832A },
    { 0xD3A5, 0x8308 },
    { 0xD3A6, 0x833C },
    { 0xD3A7, 0x834D },
    { 0xD3A8, 0x8316 },
    { 0xD3A9, 0x8324 },
    { 0xD3AA, 0x8320 },
    { 0xD3AB, 0x8337 },
    { 0xD3AC, 0x832F },
    { 0xD3AD, 0x8329 },
    { 0xD3AE, 0x8347 },
    { 0xD3AF, 0x8345 },
    { 0xD3B0, 0x834C },
    { 0xD3B1, 0x8353 },
    { 0xD3B2, 0x831E },
    { 0xD3B3, 0x832C },
    { 0xD3B4, 0x834B },
    { 0xD3B5, 0x8327 },
    { 0xD3B6, 0x8348 },
    { 0xD3B7, 0x8653 },
    { 0xD3B8, 0x8652 },
    { 0xD3B9, 0x86A2 },
    { 0xD3BA, 0x86A8 },
    { 0xD3BB, 0x8696 },
    { 0xD3BC, 0x868D },
    { 0xD3BD, 0x8691 },
    { 0xD3BE, 0x869E },
    { 0xD3BF, 0x8687 },
    { 0xD3C0, 0x8697 },
    { 0xD3C1, 0x8686 },
    { 0xD3C2, 0x868B },
    { 0xD3C3, 0x869A },
    { 0xD3C4, 0x8685 },
    { 0xD3C5, 0x86A5 },
    { 0xD3C6, 0x8699 },
    { 0xD3C7, 0x86A1 },
    { 0xD3C8, 0x86A7 },
    { 0xD3C9, 0x8695 },
    { 0xD3CA, 0x8698 },
    { 0xD3CB, 0x868E },
    { 0xD3CC, 0x869D },
    { 0xD3CD, 0x8690 },
    { 0xD3CE, 0x8694 },
    { 0xD3CF, 0x8843 },
    { 0xD3D0, 0x8844 },
    { 0xD3D1, 0x886D },
    { 0xD3D2, 0x8875 },
    { 0xD3D3, 0x8876 },
    { 0xD3D4, 0x8872 },
    { 0xD3D5, 0x8880 },
    { 0xD3D6, 0x8871 },
    { 0xD3D7, 0x887F },
    { 0xD3D8, 0x886F },
    { 0xD3D9, 0x8883 },
    { 0xD3DA, 0x887E },
    { 0xD3DB, 0x8874 },
    { 0xD3DC, 0x887C },
    { 0xD3DD, 0x8A12 },
    { 0xD3DE, 0x8C47 },
    { 0xD3DF, 0x8C57 },
    { 0xD3E0, 0x8C7B },
    { 0xD3E1, 0x8CA4 },
    { 0xD3E2, 0x8CA3 },
    { 0xD3E3, 0x8D76 },
    { 0xD3E4, 0x8D78 },
    { 0xD3E5, 0x8DB5 },
    { 0xD3E6, 0x8DB7 },
    { 0xD3E7, 0x8DB6 },
    { 0xD3E8, 0x8ED1 },
    { 0xD3E9, 0x8ED3 },
    { 0xD3EA, 0x8FFE },
    { 0xD3EB, 0x8FF5 },
    { 0xD3EC, 0x9002 },
    { 0xD3ED, 0x8FFF },
    { 0xD3EE, 0x8FFB },
    { 0xD3EF, 0x9004 },
    { 0xD3F0, 0x8FFC },
    { 0xD3F1, 0x8FF6 },
    { 0xD3F2, 0x90D6 },
    { 0xD3F3, 0x90E0 },
    { 0xD3F4, 0x90D9 },
    { 0xD3F5, 0x90DA },
    { 0xD3F6, 0x90E3 },
    { 0xD3F7, 0x90DF },
    { 0xD3F8, 0x90E5 },
    { 0xD3F9, 0x90D8 },
    { 0xD3FA, 0x90DB },
    { 0xD3FB, 0x90D7 },
    { 0xD3FC, 0x90DC },
    { 0xD3FD, 0x90E4 },
    { 0xD3FE, 0x9150 },
    { 0xD440, 0x914E },
    { 0xD441, 0x914F },
    { 0xD442, 0x91D5 },
    { 0xD443, 0x91E2 },
    { 0xD444, 0x91DA },
    { 0xD445, 0x965C },
    { 0xD446, 0x965F },
    { 0xD447, 0x96BC },
    { 0xD448, 0x98E3 },
    { 0xD449, 0x9ADF },
    { 0xD44A, 0x9B2F },
    { 0xD44B, 0x4E7F },
    { 0xD44C, 0x5070 },
    { 0xD44D, 0x506A },
    { 0xD44E, 0x5061 },
    { 0xD44F, 0x505E },
    { 0xD450, 0x5060 },
    { 0xD451, 0x5053 },
    { 0xD452, 0x504B },
    { 0xD453, 0x505D },
    { 0xD454, 0x5072 },
    { 0xD455, 0x5048 },
    { 0xD456, 0x504D },
    { 0xD457, 0x5041 },
    { 0xD458, 0x505B },
    { 0xD459, 0x504A },
    { 0xD45A, 0x5062 },
    { 0xD45B, 0x5015 },
    { 0xD45C, 0x5045 },
    { 0xD45D, 0x505F },
    { 0xD45E, 0x5069 },
    { 0xD45F, 0x506B },
    { 0xD460, 0x5063 },
    { 0xD461, 0x5064 },
    { 0xD462, 0x5046 },
    { 0xD463, 0x5040 },
    { 0xD464, 0x506E },
    { 0xD465, 0x5073 },
    { 0xD466, 0x5057 },
    { 0xD467, 0x5051 },
    { 0xD468, 0x51D0 },
    { 0xD469, 0x526B },
    { 0xD46A, 0x526D },
    { 0xD46B, 0x526C },
    { 0xD46C, 0x526E },
    { 0xD46D, 0x52D6 },
    { 0xD46E, 0x52D3 },
    { 0xD46F, 0x532D },
    { 0xD470, 0x539C },
    { 0xD471, 0x5575 },
    { 0xD472, 0x5576 },
    { 0xD473, 0x553C },
    { 0xD474, 0x554D },
    { 0xD475, 0x5550 },
    { 0xD476, 0x5534 },
    { 0xD477, 0x552A },
    { 0xD478, 0x5551 },
    { 0xD479, 0x5562 },
    { 0xD47A, 0x5536 },
    { 0xD47B, 0x5535 },
    { 0xD47C, 0x5530 },
    { 0xD47D, 0x5552 },
    { 0xD47E, 0x5545 },
    { 0xD4A1, 0x550C },
    { 0xD4A2, 0x5532 },
    { 0xD4A3, 0x5565 },
    { 0xD4A4, 0x554E },
    { 0xD4A5, 0x5539 },
    { 0xD4A6, 0x5548 },
    { 0xD4A7, 0x552D },
    { 0xD4A8, 0x553B },
    { 0xD4A9, 0x5540 },
    { 0xD4AA, 0x554B },
    { 0xD4AB, 0x570A },
    { 0xD4AC, 0x5707 },
    { 0xD4AD, 0x57FB },
    { 0xD4AE, 0x5814 },
    { 0xD4AF, 0x57E2 },
    { 0xD4B0, 0x57F6 },
    { 0xD4B1, 0x57DC },
    { 0xD4B2, 0x57F4 },
    { 0xD4B3, 0x5800 },
    { 0xD4B4, 0x57ED },
    { 0xD4B5, 0x57FD },
    { 0xD4B6, 0x5808 },
    { 0xD4B7, 0x57F8 },
    { 0xD4B8, 0x580B },
    { 0xD4B9, 0x57F3 },
    { 0xD4BA, 0x57CF },
    { 0xD4BB, 0x5807 },
    { 0xD4BC, 0x57EE },
    { 0xD4BD, 0x57E3 },
    { 0xD4BE, 0x57F2 },
    { 0xD4BF, 0x57E5 },
    { 0xD4C0, 0x57EC },
    { 0xD4C1, 0x57E1 },
    { 0xD4C2, 0x580E },
    { 0xD4C3, 0x57FC },
    { 0xD4C4, 0x5810 },
    { 0xD4C5, 0x57E7 },
    { 0xD4C6, 0x5801 },
    { 0xD4C7, 0x580C },
    { 0xD4C8, 0x57F1 },
    { 0xD4C9, 0x57E9 },
    { 0xD4CA, 0x57F0 },
    { 0xD4CB, 0x580D },
    { 0xD4CC, 0x5804 },
    { 0xD4CD, 0x595C },
    { 0xD4CE, 0x5A60 },
    { 0xD4CF, 0x5A58 },
    { 0xD4D0, 0x5A55 },
    { 0xD4D1, 0x5A67 },
    { 0xD4D2, 0x5A5E },
    { 0xD4D3, 0x5A38 },
    { 0xD4D4, 0x5A35 },
    { 0xD4D5, 0x5A6D },
    { 0xD4D6, 0x5A50 },
    { 0xD4D7, 0x5A5F },
    { 0xD4D8, 0x5A65 },
    { 0xD4D9, 0x5A6C },
    { 0xD4DA, 0x5A53 },
    { 0xD4DB, 0x5A64 },
    { 0xD4DC, 0x5A57 },
    { 0xD4DD, 0x5A43 },
    { 0xD4DE, 0x5A5D },
    { 0xD4DF, 0x5A52 },
    { 0xD4E0, 0x5A44 },
    { 0xD4E1, 0x5A5B },
    { 0xD4E2, 0x5A48 },
    { 0xD4E3, 0x5A8E },
    { 0xD4E4, 0x5A3E },
    { 0xD4E5, 0x5A4D },
    { 0xD4E6, 0x5A39 },
    { 0xD4E7, 0x5A4C },
    { 0xD4E8, 0x5A70 },
    { 0xD4E9, 0x5A69 },
    { 0xD4EA, 0x5A47 },
    { 0xD4EB, 0x5A51 },
    { 0xD4EC, 0x5A56 },
    { 0xD4ED, 0x5A42 },
    { 0xD4EE, 0x5A5C },
    { 0xD4EF, 0x5B72 },
    { 0xD4F0, 0x5B6E },
    { 0xD4F1, 0x5BC1 },
    { 0xD4F2, 0x5BC0 },
    { 0xD4F3, 0x5C59 },
    { 0xD4F4, 0x5D1E },
    { 0xD4F5, 0x5D0B },
    { 0xD4F6, 0x5D1D },
    { 0xD4F7, 0x5D1A },
    { 0xD4F8, 0x5D20 },
    { 0xD4F9, 0x5D0C },
    { 0xD4FA, 0x5D28 },
    { 0xD4FB, 0x5D0D },
    { 0xD4FC, 0x5D26 },
    { 0xD4FD, 0x5D25 },
    { 0xD4FE, 0x5D0F },
    { 0xD540, 0x5D30 },
    { 0xD541, 0x5D12 },
    { 0xD542, 0x5D23 },
    { 0xD543, 0x5D1F },
    { 0xD544, 0x5D2E },
    { 0xD545, 0x5E3E },
    { 0xD546, 0x5E34 },
    { 0xD547, 0x5EB1 },
    { 0xD548, 0x5EB4 },
    { 0xD549, 0x5EB9 },
    { 0xD54A, 0x5EB2 },
    { 0xD54B, 0x5EB3 },
    { 0xD54C, 0x5F36 },
    { 0xD54D, 0x5F38 },
    { 0xD54E, 0x5F9B },
    { 0xD54F, 0x5F96 },
    { 0xD550, 0x5F9F },
    { 0xD551, 0x608A },
    { 0xD552, 0x6090 },
    { 0xD553, 0x6086 },
    { 0xD554, 0x60BE },
    { 0xD555, 0x60B0 },
    { 0xD556, 0x60BA },
    { 0xD557, 0x60D3 },
    { 0xD558, 0x60D4 },
    { 0xD559, 0x60CF },
    { 0xD55A, 0x60E4 },
    { 0xD55B, 0x60D9 },
    { 0xD55C, 0x60DD },
    { 0xD55D, 0x60C8 },
    { 0xD55E, 0x60B1 },
    { 0xD55F, 0x60DB },
    { 0xD560, 0x60B7 },
    { 0xD561, 0x60CA },
    { 0xD562, 0x60BF },
    { 0xD563, 0x60C3 },
    { 0xD564, 0x60CD },
    { 0xD565, 0x60C0 },
    { 0xD566, 0x6332 },
    { 0xD567, 0x6365 },
    { 0xD568, 0x638A },
    { 0xD569, 0x6382 },
    { 0xD56A, 0x637D },
    { 0xD56B, 0x63BD },
    { 0xD56C, 0x639E },
    { 0xD56D, 0x63AD },
    { 0xD56E, 0x639D },
    { 0xD56F, 0x6397 },
    { 0xD570, 0x63AB },
    { 0xD571, 0x638E },
    { 0xD572, 0x636F },
    { 0xD573, 0x6387 },
    { 0xD574, 0x6390 },
    { 0xD575, 0x636E },
    { 0xD576, 0x63AF },
    { 0xD577, 0x6375 },
    { 0xD578, 0x639C },
    { 0xD579, 0x636D },
    { 0xD57A, 0x63AE },
    { 0xD57B, 0x637C },
    { 0xD57C, 0x63A4 },
    { 0xD57D, 0x633B },
    
    
    { 0xD57E, 0x639F },
    { 0xD5A1, 0x6378 },
    { 0xD5A2, 0x6385 },
    { 0xD5A3, 0x6381 },
    { 0xD5A4, 0x6391 },
    { 0xD5A5, 0x638D },
    { 0xD5A6, 0x6370 },
    { 0xD5A7, 0x6553 },
    { 0xD5A8, 0x65CD },
    { 0xD5A9, 0x6665 },
    { 0xD5AA, 0x6661 },
    { 0xD5AB, 0x665B },
    { 0xD5AC, 0x6659 },
    { 0xD5AD, 0x665C },
    { 0xD5AE, 0x6662 },
    { 0xD5AF, 0x6718 },
    { 0xD5B0, 0x6879 },
    { 0xD5B1, 0x6887 },
    { 0xD5B2, 0x6890 },
    { 0xD5B3, 0x689C },
    { 0xD5B4, 0x686D },
    { 0xD5B5, 0x686E },
    { 0xD5B6, 0x68AE },
    { 0xD5B7, 0x68AB },
    { 0xD5B8, 0x6956 },
    { 0xD5B9, 0x686F },
    { 0xD5BA, 0x68A3 },
    { 0xD5BB, 0x68AC },
    { 0xD5BC, 0x68A9 },
    { 0xD5BD, 0x6875 },
    { 0xD5BE, 0x6874 },
    { 0xD5BF, 0x68B2 },
    { 0xD5C0, 0x688F },
    { 0xD5C1, 0x6877 },
    { 0xD5C2, 0x6892 },
    { 0xD5C3, 0x687C },
    { 0xD5C4, 0x686B },
    { 0xD5C5, 0x6872 },
    { 0xD5C6, 0x68AA },
    { 0xD5C7, 0x6880 },
    { 0xD5C8, 0x6871 },
    { 0xD5C9, 0x687E },
    { 0xD5CA, 0x689B },
    { 0xD5CB, 0x6896 },
    { 0xD5CC, 0x688B },
    { 0xD5CD, 0x68A0 },
    { 0xD5CE, 0x6889 },
    { 0xD5CF, 0x68A4 },
    { 0xD5D0, 0x6878 },
    { 0xD5D1, 0x687B },
    { 0xD5D2, 0x6891 },
    { 0xD5D3, 0x688C },
    { 0xD5D4, 0x688A },
    { 0xD5D5, 0x687D },
    { 0xD5D6, 0x6B36 },
    { 0xD5D7, 0x6B33 },
    { 0xD5D8, 0x6B37 },
    { 0xD5D9, 0x6B38 },
    { 0xD5DA, 0x6B91 },
    { 0xD5DB, 0x6B8F },
    { 0xD5DC, 0x6B8D },
    { 0xD5DD, 0x6B8E },
    { 0xD5DE, 0x6B8C },
    { 0xD5DF, 0x6C2A },
    { 0xD5E0, 0x6DC0 },
    { 0xD5E1, 0x6DAB },
    { 0xD5E2, 0x6DB4 },
    { 0xD5E3, 0x6DB3 },
    { 0xD5E4, 0x6E74 },
    { 0xD5E5, 0x6DAC },
    { 0xD5E6, 0x6DE9 },
    { 0xD5E7, 0x6DE2 },
    { 0xD5E8, 0x6DB7 },
    { 0xD5E9, 0x6DF6 },
    { 0xD5EA, 0x6DD4 },
    { 0xD5EB, 0x6E00 },
    { 0xD5EC, 0x6DC8 },
    { 0xD5ED, 0x6DE0 },
    { 0xD5EE, 0x6DDF },
    { 0xD5EF, 0x6DD6 },
    { 0xD5F0, 0x6DBE },
    { 0xD5F1, 0x6DE5 },
    { 0xD5F2, 0x6DDC },
    { 0xD5F3, 0x6DDD },
    { 0xD5F4, 0x6DDB },
    { 0xD5F5, 0x6DF4 },
    { 0xD5F6, 0x6DCA },
    { 0xD5F7, 0x6DBD },
    { 0xD5F8, 0x6DED },
    { 0xD5F9, 0x6DF0 },
    { 0xD5FA, 0x6DBA },
    { 0xD5FB, 0x6DD5 },
    { 0xD5FC, 0x6DC2 },
    { 0xD5FD, 0x6DCF },
    { 0xD5FE, 0x6DC9 },
    { 0xD640, 0x6DD0 },
    { 0xD641, 0x6DF2 },
    { 0xD642, 0x6DD3 },
    { 0xD643, 0x6DFD },
    { 0xD644, 0x6DD7 },
    { 0xD645, 0x6DCD },
    { 0xD646, 0x6DE3 },
    { 0xD647, 0x6DBB },
    { 0xD648, 0x70FA },
    { 0xD649, 0x710D },
    { 0xD64A, 0x70F7 },
    { 0xD64B, 0x7117 },
    { 0xD64C, 0x70F4 },
    { 0xD64D, 0x710C },
    { 0xD64E, 0x70F0 },
    { 0xD64F, 0x7104 },
    { 0xD650, 0x70F3 },
    { 0xD651, 0x7110 },
    { 0xD652, 0x70FC },
    { 0xD653, 0x70FF },
    { 0xD654, 0x7106 },
    { 0xD655, 0x7113 },
    { 0xD656, 0x7100 },
    { 0xD657, 0x70F8 },
    { 0xD658, 0x70F6 },
    { 0xD659, 0x710B },
    { 0xD65A, 0x7102 },
    { 0xD65B, 0x710E },
    { 0xD65C, 0x727E },
    { 0xD65D, 0x727B },
    { 0xD65E, 0x727C },
    { 0xD65F, 0x727F },
    { 0xD660, 0x731D },
    { 0xD661, 0x7317 },
    { 0xD662, 0x7307 },
    { 0xD663, 0x7311 },
    { 0xD664, 0x7318 },
    { 0xD665, 0x730A },
    { 0xD666, 0x7308 },
    { 0xD667, 0x72FF },
    { 0xD668, 0x730F },
    { 0xD669, 0x731E },
    { 0xD66A, 0x7388 },
    { 0xD66B, 0x73F6 },
    { 0xD66C, 0x73F8 },
    { 0xD66D, 0x73F5 },
    { 0xD66E, 0x7404 },
    { 0xD66F, 0x7401 },
    { 0xD670, 0x73FD },
    { 0xD671, 0x7407 },
    { 0xD672, 0x7400 },
    { 0xD673, 0x73FA },
    { 0xD674, 0x73FC },
    { 0xD675, 0x73FF },
    { 0xD676, 0x740C },
    { 0xD677, 0x740B },
    { 0xD678, 0x73F4 },
    { 0xD679, 0x7408 },
    { 0xD67A, 0x7564 },
    { 0xD67B, 0x7563 },
    { 0xD67C, 0x75CE },
    { 0xD67D, 0x75D2 },
    { 0xD67E, 0x75CF },
    { 0xD6A1, 0x75CB },
    { 0xD6A2, 0x75CC },
    { 0xD6A3, 0x75D1 },
    { 0xD6A4, 0x75D0 },
    { 0xD6A5, 0x768F },
    { 0xD6A6, 0x7689 },
    { 0xD6A7, 0x76D3 },
    { 0xD6A8, 0x7739 },
    { 0xD6A9, 0x772F },
    { 0xD6AA, 0x772D },
    { 0xD6AB, 0x7731 },
    { 0xD6AC, 0x7732 },
    { 0xD6AD, 0x7734 },
    { 0xD6AE, 0x7733 },
    { 0xD6AF, 0x773D },
    { 0xD6B0, 0x7725 },
    { 0xD6B1, 0x773B },
    { 0xD6B2, 0x7735 },
    { 0xD6B3, 0x7848 },
    { 0xD6B4, 0x7852 },
    { 0xD6B5, 0x7849 },
    { 0xD6B6, 0x784D },
    { 0xD6B7, 0x784A },
    { 0xD6B8, 0x784C },
    { 0xD6B9, 0x7826 },
    { 0xD6BA, 0x7845 },
    { 0xD6BB, 0x7850 },
    { 0xD6BC, 0x7964 },
    { 0xD6BD, 0x7967 },
    { 0xD6BE, 0x7969 },
    { 0xD6BF, 0x796A },
    { 0xD6C0, 0x7963 },
    { 0xD6C1, 0x796B },
    { 0xD6C2, 0x7961 },
    { 0xD6C3, 0x79BB },
    { 0xD6C4, 0x79FA },
    { 0xD6C5, 0x79F8 },
    { 0xD6C6, 0x79F6 },
    { 0xD6C7, 0x79F7 },
    { 0xD6C8, 0x7A8F },
    { 0xD6C9, 0x7A94 },
    { 0xD6CA, 0x7A90 },
    { 0xD6CB, 0x7B35 },
    { 0xD6CC, 0x7B47 },
    { 0xD6CD, 0x7B34 },
    { 0xD6CE, 0x7B25 },
    { 0xD6CF, 0x7B30 },
    { 0xD6D0, 0x7B22 },
    { 0xD6D1, 0x7B24 },
    { 0xD6D2, 0x7B33 },
    { 0xD6D3, 0x7B18 },
    { 0xD6D4, 0x7B2A },
    { 0xD6D5, 0x7B1D },
    { 0xD6D6, 0x7B31 },
    { 0xD6D7, 0x7B2B },
    { 0xD6D8, 0x7B2D },
    { 0xD6D9, 0x7B2F },
    { 0xD6DA, 0x7B32 },
    { 0xD6DB, 0x7B38 },
    { 0xD6DC, 0x7B1A },
    { 0xD6DD, 0x7B23 },
    { 0xD6DE, 0x7C94 },
    { 0xD6DF, 0x7C98 },
    { 0xD6E0, 0x7C96 },
    { 0xD6E1, 0x7CA3 },
    { 0xD6E2, 0x7D35 },
    { 0xD6E3, 0x7D3D },
    { 0xD6E4, 0x7D38 },
    { 0xD6E5, 0x7D36 },
    { 0xD6E6, 0x7D3A },
    { 0xD6E7, 0x7D45 },
    { 0xD6E8, 0x7D2C },
    { 0xD6E9, 0x7D29 },
    { 0xD6EA, 0x7D41 },
    { 0xD6EB, 0x7D47 },
    { 0xD6EC, 0x7D3E },
    { 0xD6ED, 0x7D3F },
    { 0xD6EE, 0x7D4A },
    { 0xD6EF, 0x7D3B },
    { 0xD6F0, 0x7D28 },
    { 0xD6F1, 0x7F63 },
    { 0xD6F2, 0x7F95 },
    { 0xD6F3, 0x7F9C },
    { 0xD6F4, 0x7F9D },
    { 0xD6F5, 0x7F9B },
    { 0xD6F6, 0x7FCA },
    { 0xD6F7, 0x7FCB },
    { 0xD6F8, 0x7FCD },
    { 0xD6F9, 0x7FD0 },
    { 0xD6FA, 0x7FD1 },
    { 0xD6FB, 0x7FC7 },
    { 0xD6FC, 0x7FCF },
    { 0xD6FD, 0x7FC9 },
    { 0xD6FE, 0x801F },
    { 0xD740, 0x801E },
    { 0xD741, 0x801B },
    { 0xD742, 0x8047 },
    { 0xD743, 0x8043 },
    { 0xD744, 0x8048 },
    { 0xD745, 0x8118 },
    { 0xD746, 0x8125 },
    { 0xD747, 0x8119 },
    { 0xD748, 0x811B },
    { 0xD749, 0x812D },
    { 0xD74A, 0x811F },
    { 0xD74B, 0x812C },
    { 0xD74C, 0x811E },
    { 0xD74D, 0x8121 },
    { 0xD74E, 0x8115 },
    { 0xD74F, 0x8127 },
    { 0xD750, 0x811D },
    { 0xD751, 0x8122 },
    { 0xD752, 0x8211 },
    { 0xD753, 0x8238 },
    { 0xD754, 0x8233 },
    { 0xD755, 0x823A },
    { 0xD756, 0x8234 },
    { 0xD757, 0x8232 },
    { 0xD758, 0x8274 },
    { 0xD759, 0x8390 },
    { 0xD75A, 0x83A3 },
    { 0xD75B, 0x83A8 },
    { 0xD75C, 0x838D },
    { 0xD75D, 0x837A },
    { 0xD75E, 0x8373 },
    { 0xD75F, 0x83A4 },
    { 0xD760, 0x8374 },
    { 0xD761, 0x838F },
    { 0xD762, 0x8381 },
    { 0xD763, 0x8395 },
    { 0xD764, 0x8399 },
    { 0xD765, 0x8375 },
    { 0xD766, 0x8394 },
    { 0xD767, 0x83A9 },
    { 0xD768, 0x837D },
    { 0xD769, 0x8383 },
    { 0xD76A, 0x838C },
    { 0xD76B, 0x839D },
    { 0xD76C, 0x839B },
    { 0xD76D, 0x83AA },
    { 0xD76E, 0x838B },
    { 0xD76F, 0x837E },
    { 0xD770, 0x83A5 },
    { 0xD771, 0x83AF },
    { 0xD772, 0x8388 },
    { 0xD773, 0x8397 },
    { 0xD774, 0x83B0 },
    { 0xD775, 0x837F },
    { 0xD776, 0x83A6 },
    { 0xD777, 0x8387 },
    { 0xD778, 0x83AE },
    { 0xD779, 0x8376 },
    { 0xD77A, 0x839A },
    { 0xD77B, 0x8659 },
    { 0xD77C, 0x8656 },
    { 0xD77D, 0x86BF },
    { 0xD77E, 0x86B7 },
    { 0xD7A1, 0x86C2 },
    { 0xD7A2, 0x86C1 },
    { 0xD7A3, 0x86C5 },
    { 0xD7A4, 0x86BA },
    { 0xD7A5, 0x86B0 },
    { 0xD7A6, 0x86C8 },
    { 0xD7A7, 0x86B9 },
    { 0xD7A8, 0x86B3 },
    { 0xD7A9, 0x86B8 },
    { 0xD7AA, 0x86CC },
    { 0xD7AB, 0x86B4 },
    { 0xD7AC, 0x86BB },
    { 0xD7AD, 0x86BC },
    { 0xD7AE, 0x86C3 },
    { 0xD7AF, 0x86BD },
    { 0xD7B0, 0x86BE },
    { 0xD7B1, 0x8852 },
    { 0xD7B2, 0x8889 },
    { 0xD7B3, 0x8895 },
    { 0xD7B4, 0x88A8 },
    { 0xD7B5, 0x88A2 },
    { 0xD7B6, 0x88AA },
    { 0xD7B7, 0x889A },
    { 0xD7B8, 0x8891 },
    { 0xD7B9, 0x88A1 },
    { 0xD7BA, 0x889F },
    { 0xD7BB, 0x8898 },
    { 0xD7BC, 0x88A7 },
    { 0xD7BD, 0x8899 },
    { 0xD7BE, 0x889B },
    { 0xD7BF, 0x8897 },
    { 0xD7C0, 0x88A4 },
    { 0xD7C1, 0x88AC },
    { 0xD7C2, 0x888C },
    { 0xD7C3, 0x8893 },
    { 0xD7C4, 0x888E },
    { 0xD7C5, 0x8982 },
    { 0xD7C6, 0x89D6 },
    { 0xD7C7, 0x89D9 },
    { 0xD7C8, 0x89D5 },
    { 0xD7C9, 0x8A30 },
    { 0xD7CA, 0x8A27 },
    { 0xD7CB, 0x8A2C },
    { 0xD7CC, 0x8A1E },
    { 0xD7CD, 0x8C39 },
    { 0xD7CE, 0x8C3B },
    { 0xD7CF, 0x8C5C },
    { 0xD7D0, 0x8C5D },
    { 0xD7D1, 0x8C7D },
    { 0xD7D2, 0x8CA5 },
    { 0xD7D3, 0x8D7D },
    { 0xD7D4, 0x8D7B },
    { 0xD7D5, 0x8D79 },
    { 0xD7D6, 0x8DBC },
    { 0xD7D7, 0x8DC2 },
    { 0xD7D8, 0x8DB9 },
    { 0xD7D9, 0x8DBF },
    { 0xD7DA, 0x8DC1 },
    { 0xD7DB, 0x8ED8 },
    { 0xD7DC, 0x8EDE },
    { 0xD7DD, 0x8EDD },
    { 0xD7DE, 0x8EDC },
    { 0xD7DF, 0x8ED7 },
    { 0xD7E0, 0x8EE0 },
    { 0xD7E1, 0x8EE1 },
    { 0xD7E2, 0x9024 },
    { 0xD7E3, 0x900B },
    { 0xD7E4, 0x9011 },
    { 0xD7E5, 0x901C },
    { 0xD7E6, 0x900C },
    { 0xD7E7, 0x9021 },
    { 0xD7E8, 0x90EF },
    { 0xD7E9, 0x90EA },
    { 0xD7EA, 0x90F0 },
    { 0xD7EB, 0x90F4 },
    { 0xD7EC, 0x90F2 },
    { 0xD7ED, 0x90F3 },
    { 0xD7EE, 0x90D4 },
    { 0xD7EF, 0x90EB },
    { 0xD7F0, 0x90EC },
    { 0xD7F1, 0x90E9 },
    { 0xD7F2, 0x9156 },
    { 0xD7F3, 0x9158 },
    { 0xD7F4, 0x915A },
    { 0xD7F5, 0x9153 },
    { 0xD7F6, 0x9155 },
    { 0xD7F7, 0x91EC },
    { 0xD7F8, 0x91F4 },
    { 0xD7F9, 0x91F1 },
    { 0xD7FA, 0x91F3 },
    { 0xD7FB, 0x91F8 },
    { 0xD7FC, 0x91E4 },
    { 0xD7FD, 0x91F9 },
    { 0xD7FE, 0x91EA },
    { 0xD840, 0x91EB },
    { 0xD841, 0x91F7 },
    { 0xD842, 0x91E8 },
    { 0xD843, 0x91EE },
    { 0xD844, 0x957A },
    { 0xD845, 0x9586 },
    { 0xD846, 0x9588 },
    { 0xD847, 0x967C },
    { 0xD848, 0x966D },
    { 0xD849, 0x966B },
    { 0xD84A, 0x9671 },
    { 0xD84B, 0x966F },
    { 0xD84C, 0x96BF },
    { 0xD84D, 0x976A },
    { 0xD84E, 0x9804 },
    { 0xD84F, 0x98E5 },
    { 0xD850, 0x9997 },
    { 0xD851, 0x509B },
    { 0xD852, 0x5095 },
    { 0xD853, 0x5094 },
    { 0xD854, 0x509E },
    { 0xD855, 0x508B },
    { 0xD856, 0x50A3 },
    { 0xD857, 0x5083 },
    { 0xD858, 0x508C },
    { 0xD859, 0x508E },
    { 0xD85A, 0x509D },
    { 0xD85B, 0x5068 },
    { 0xD85C, 0x509C },
    { 0xD85D, 0x5092 },
    { 0xD85E, 0x5082 },
    { 0xD85F, 0x5087 },
    { 0xD860, 0x515F },
    { 0xD861, 0x51D4 },
    { 0xD862, 0x5312 },
    { 0xD863, 0x5311 },
    { 0xD864, 0x53A4 },
    { 0xD865, 0x53A7 },
    { 0xD866, 0x5591 },
    { 0xD867, 0x55A8 },
    { 0xD868, 0x55A5 },
    { 0xD869, 0x55AD },
    { 0xD86A, 0x5577 },
    { 0xD86B, 0x5645 },
    { 0xD86C, 0x55A2 },
    { 0xD86D, 0x5593 },
    { 0xD86E, 0x5588 },
    { 0xD86F, 0x558F },
    { 0xD870, 0x55B5 },
    { 0xD871, 0x5581 },
    { 0xD872, 0x55A3 },
    { 0xD873, 0x5592 },
    { 0xD874, 0x55A4 },
    { 0xD875, 0x557D },
    { 0xD876, 0x558C },
    { 0xD877, 0x55A6 },
    { 0xD878, 0x557F },
    { 0xD879, 0x5595 },
    { 0xD87A, 0x55A1 },
    { 0xD87B, 0x558E },
    { 0xD87C, 0x570C },
    { 0xD87D, 0x5829 },
    { 0xD87E, 0x5837 },
    { 0xD8A1, 0x5819 },
    { 0xD8A2, 0x581E },
    { 0xD8A3, 0x5827 },
    { 0xD8A4, 0x5823 },
    { 0xD8A5, 0x5828 },
    { 0xD8A6, 0x57F5 },
    { 0xD8A7, 0x5848 },
    { 0xD8A8, 0x5825 },
    { 0xD8A9, 0x581C },
    { 0xD8AA, 0x581B },
    { 0xD8AB, 0x5833 },
    { 0xD8AC, 0x583F },
    { 0xD8AD, 0x5836 },
    { 0xD8AE, 0x582E },
    { 0xD8AF, 0x5839 },
    { 0xD8B0, 0x5838 },
    { 0xD8B1, 0x582D },
    { 0xD8B2, 0x582C },
    { 0xD8B3, 0x583B },
    { 0xD8B4, 0x5961 },
    { 0xD8B5, 0x5AAF },
    { 0xD8B6, 0x5A94 },
    { 0xD8B7, 0x5A9F },
    { 0xD8B8, 0x5A7A },
    { 0xD8B9, 0x5AA2 },
    { 0xD8BA, 0x5A9E },
    { 0xD8BB, 0x5A78 },
    { 0xD8BC, 0x5AA6 },
    { 0xD8BD, 0x5A7C },
    { 0xD8BE, 0x5AA5 },
    { 0xD8BF, 0x5AAC },
    { 0xD8C0, 0x5A95 },
    { 0xD8C1, 0x5AAE },
    { 0xD8C2, 0x5A37 },
    { 0xD8C3, 0x5A84 },
    { 0xD8C4, 0x5A8A },
    { 0xD8C5, 0x5A97 },
    { 0xD8C6, 0x5A83 },
    { 0xD8C7, 0x5A8B },
    { 0xD8C8, 0x5AA9 },
    { 0xD8C9, 0x5A7B },
    { 0xD8CA, 0x5A7D },
    { 0xD8CB, 0x5A8C },
    { 0xD8CC, 0x5A9C },
    { 0xD8CD, 0x5A8F },
    { 0xD8CE, 0x5A93 },
    { 0xD8CF, 0x5A9D },
    { 0xD8D0, 0x5BEA },
    { 0xD8D1, 0x5BCD },
    { 0xD8D2, 0x5BCB },
    { 0xD8D3, 0x5BD4 },
    { 0xD8D4, 0x5BD1 },
    { 0xD8D5, 0x5BCA },
    { 0xD8D6, 0x5BCE },
    { 0xD8D7, 0x5C0C },
    { 0xD8D8, 0x5C30 },
    { 0xD8D9, 0x5D37 },
    { 0xD8DA, 0x5D43 },
    { 0xD8DB, 0x5D6B },
    { 0xD8DC, 0x5D41 },
    { 0xD8DD, 0x5D4B },
    { 0xD8DE, 0x5D3F },
    { 0xD8DF, 0x5D35 },
    { 0xD8E0, 0x5D51 },
    { 0xD8E1, 0x5D4E },
    { 0xD8E2, 0x5D55 },
    { 0xD8E3, 0x5D33 },
    { 0xD8E4, 0x5D3A },
    { 0xD8E5, 0x5D52 },
    { 0xD8E6, 0x5D3D },
    { 0xD8E7, 0x5D31 },
    { 0xD8E8, 0x5D59 },
    { 0xD8E9, 0x5D42 },
    { 0xD8EA, 0x5D39 },
    { 0xD8EB, 0x5D49 },
    { 0xD8EC, 0x5D38 },
    { 0xD8ED, 0x5D3C },
    { 0xD8EE, 0x5D32 },
    { 0xD8EF, 0x5D36 },
    { 0xD8F0, 0x5D40 },
    { 0xD8F1, 0x5D45 },
    { 0xD8F2, 0x5E44 },
    { 0xD8F3, 0x5E41 },
    { 0xD8F4, 0x5F58 },
    { 0xD8F5, 0x5FA6 },
    { 0xD8F6, 0x5FA5 },
    { 0xD8F7, 0x5FAB },
    { 0xD8F8, 0x60C9 },
    { 0xD8F9, 0x60B9 },
    { 0xD8FA, 0x60CC },
    { 0xD8FB, 0x60E2 },
    { 0xD8FC, 0x60CE },
    { 0xD8FD, 0x60C4 },
    { 0xD8FE, 0x6114 },
    { 0xD940, 0x60F2 },
    { 0xD941, 0x610A },
    { 0xD942, 0x6116 },
    { 0xD943, 0x6105 },
    { 0xD944, 0x60F5 },
    { 0xD945, 0x6113 },
    { 0xD946, 0x60F8 },
    { 0xD947, 0x60FC },
    { 0xD948, 0x60FE },
    { 0xD949, 0x60C1 },
    { 0xD94A, 0x6103 },
    { 0xD94B, 0x6118 },
    { 0xD94C, 0x611D },
    { 0xD94D, 0x6110 },
    { 0xD94E, 0x60FF },
    { 0xD94F, 0x6104 },
    { 0xD950, 0x610B },
    { 0xD951, 0x624A },
    { 0xD952, 0x6394 },
    { 0xD953, 0x63B1 },
    { 0xD954, 0x63B0 },
    { 0xD955, 0x63CE },
    { 0xD956, 0x63E5 },
    { 0xD957, 0x63E8 },
    { 0xD958, 0x63EF },
    { 0xD959, 0x63C3 },
    { 0xD95A, 0x649D },
    { 0xD95B, 0x63F3 },
    { 0xD95C, 0x63CA },
    { 0xD95D, 0x63E0 },
    { 0xD95E, 0x63F6 },
    { 0xD95F, 0x63D5 },
    { 0xD960, 0x63F2 },
    { 0xD961, 0x63F5 },
    { 0xD962, 0x6461 },
    { 0xD963, 0x63DF },
    { 0xD964, 0x63BE },
    { 0xD965, 0x63DD },
    { 0xD966, 0x63DC },
    { 0xD967, 0x63C4 },
    { 0xD968, 0x63D8 },
    { 0xD969, 0x63D3 },
    { 0xD96A, 0x63C2 },
    { 0xD96B, 0x63C7 },
    { 0xD96C, 0x63CC },
    { 0xD96D, 0x63CB },
    { 0xD96E, 0x63C8 },
    { 0xD96F, 0x63F0 },
    { 0xD970, 0x63D7 },
    { 0xD971, 0x63D9 },
    { 0xD972, 0x6532 },
    { 0xD973, 0x6567 },
    { 0xD974, 0x656A },
    { 0xD975, 0x6564 },
    { 0xD976, 0x655C },
    { 0xD977, 0x6568 },
    { 0xD978, 0x6565 },
    { 0xD979, 0x658C },
    { 0xD97A, 0x659D },
    { 0xD97B, 0x659E },
    { 0xD97C, 0x65AE },
    { 0xD97D, 0x65D0 },
    { 0xD97E, 0x65D2 },
    { 0xD9A1, 0x667C },
    { 0xD9A2, 0x666C },
    { 0xD9A3, 0x667B },
    { 0xD9A4, 0x6680 },
    { 0xD9A5, 0x6671 },
    { 0xD9A6, 0x6679 },
    { 0xD9A7, 0x666A },
    { 0xD9A8, 0x6672 },
    { 0xD9A9, 0x6701 },
    { 0xD9AA, 0x690C },
    { 0xD9AB, 0x68D3 },
    { 0xD9AC, 0x6904 },
    { 0xD9AD, 0x68DC },
    { 0xD9AE, 0x692A },
    { 0xD9AF, 0x68EC },
    { 0xD9B0, 0x68EA },
    { 0xD9B1, 0x68F1 },
    { 0xD9B2, 0x690F },
    { 0xD9B3, 0x68D6 },
    { 0xD9B4, 0x68F7 },
    { 0xD9B5, 0x68EB },
    { 0xD9B6, 0x68E4 },
    { 0xD9B7, 0x68F6 },
    { 0xD9B8, 0x6913 },
    { 0xD9B9, 0x6910 },
    { 0xD9BA, 0x68F3 },
    { 0xD9BB, 0x68E1 },
    { 0xD9BC, 0x6907 },
    { 0xD9BD, 0x68CC },
    { 0xD9BE, 0x6908 },
    { 0xD9BF, 0x6970 },
    { 0xD9C0, 0x68B4 },
    { 0xD9C1, 0x6911 },
    { 0xD9C2, 0x68EF },
    { 0xD9C3, 0x68C6 },
    { 0xD9C4, 0x6914 },
    { 0xD9C5, 0x68F8 },
    { 0xD9C6, 0x68D0 },
    { 0xD9C7, 0x68FD },
    { 0xD9C8, 0x68FC },
    { 0xD9C9, 0x68E8 },
    { 0xD9CA, 0x690B },
    { 0xD9CB, 0x690A },
    { 0xD9CC, 0x6917 },
    { 0xD9CD, 0x68CE },
    { 0xD9CE, 0x68C8 },
    { 0xD9CF, 0x68DD },
    { 0xD9D0, 0x68DE },
    { 0xD9D1, 0x68E6 },
    { 0xD9D2, 0x68F4 },
    { 0xD9D3, 0x68D1 },
    { 0xD9D4, 0x6906 },
    { 0xD9D5, 0x68D4 },
    { 0xD9D6, 0x68E9 },
    { 0xD9D7, 0x6915 },
    { 0xD9D8, 0x6925 },
    { 0xD9D9, 0x68C7 },
    { 0xD9DA, 0x6B39 },
    { 0xD9DB, 0x6B3B },
    { 0xD9DC, 0x6B3F },
    { 0xD9DD, 0x6B3C },
    { 0xD9DE, 0x6B94 },
    { 0xD9DF, 0x6B97 },
    { 0xD9E0, 0x6B99 },
    { 0xD9E1, 0x6B95 },
    { 0xD9E2, 0x6BBD },
    { 0xD9E3, 0x6BF0 },
    { 0xD9E4, 0x6BF2 },
    { 0xD9E5, 0x6BF3 },
    { 0xD9E6, 0x6C30 },
    { 0xD9E7, 0x6DFC },
    { 0xD9E8, 0x6E46 },
    { 0xD9E9, 0x6E47 },
    { 0xD9EA, 0x6E1F },
    { 0xD9EB, 0x6E49 },
    { 0xD9EC, 0x6E88 },
    { 0xD9ED, 0x6E3C },
    { 0xD9EE, 0x6E3D },
    { 0xD9EF, 0x6E45 },
    { 0xD9F0, 0x6E62 },
    { 0xD9F1, 0x6E2B },
    { 0xD9F2, 0x6E3F },
    { 0xD9F3, 0x6E41 },
    { 0xD9F4, 0x6E5D },
    { 0xD9F5, 0x6E73 },
    { 0xD9F6, 0x6E1C },
    { 0xD9F7, 0x6E33 },
    { 0xD9F8, 0x6E4B },
    { 0xD9F9, 0x6E40 },
    { 0xD9FA, 0x6E51 },
    { 0xD9FB, 0x6E3B },
    { 0xD9FC, 0x6E03 },
    { 0xD9FD, 0x6E2E },
    { 0xD9FE, 0x6E5E },
    { 0xDA40, 0x6E68 },
    { 0xDA41, 0x6E5C },
    { 0xDA42, 0x6E61 },
    { 0xDA43, 0x6E31 },
    { 0xDA44, 0x6E28 },
    { 0xDA45, 0x6E60 },
    { 0xDA46, 0x6E71 },
    { 0xDA47, 0x6E6B },
    { 0xDA48, 0x6E39 },
    { 0xDA49, 0x6E22 },
    { 0xDA4A, 0x6E30 },
    { 0xDA4B, 0x6E53 },
    { 0xDA4C, 0x6E65 },
    { 0xDA4D, 0x6E27 },
    { 0xDA4E, 0x6E78 },
    { 0xDA4F, 0x6E64 },
    { 0xDA50, 0x6E77 },
    { 0xDA51, 0x6E55 },
    { 0xDA52, 0x6E79 },
    { 0xDA53, 0x6E52 },
    { 0xDA54, 0x6E66 },
    { 0xDA55, 0x6E35 },
    { 0xDA56, 0x6E36 },
    { 0xDA57, 0x6E5A },
    { 0xDA58, 0x7120 },
    { 0xDA59, 0x711E },
    { 0xDA5A, 0x712F },
    { 0xDA5B, 0x70FB },
    { 0xDA5C, 0x712E },
    { 0xDA5D, 0x7131 },
    { 0xDA5E, 0x7123 },
    { 0xDA5F, 0x7125 },
    { 0xDA60, 0x7122 },
    { 0xDA61, 0x7132 },
    { 0xDA62, 0x711F },
    { 0xDA63, 0x7128 },
    { 0xDA64, 0x713A },
    { 0xDA65, 0x711B },
    { 0xDA66, 0x724B },
    { 0xDA67, 0x725A },
    { 0xDA68, 0x7288 },
    { 0xDA69, 0x7289 },
    { 0xDA6A, 0x7286 },
    { 0xDA6B, 0x7285 },
    { 0xDA6C, 0x728B },
    { 0xDA6D, 0x7312 },
    { 0xDA6E, 0x730B },
    { 0xDA6F, 0x7330 },
    { 0xDA70, 0x7322 },
    { 0xDA71, 0x7331 },
    { 0xDA72, 0x7333 },
    { 0xDA73, 0x7327 },
    { 0xDA74, 0x7332 },
    { 0xDA75, 0x732D },
    { 0xDA76, 0x7326 },
    { 0xDA77, 0x7323 },
    { 0xDA78, 0x7335 },
    { 0xDA79, 0x730C },
    { 0xDA7A, 0x742E },
    { 0xDA7B, 0x742C },
    { 0xDA7C, 0x7430 },
    { 0xDA7D, 0x742B },
    { 0xDA7E, 0x7416 },
    { 0xDAA1, 0x741A },
    { 0xDAA2, 0x7421 },
    { 0xDAA3, 0x742D },
    { 0xDAA4, 0x7431 },
    { 0xDAA5, 0x7424 },
    { 0xDAA6, 0x7423 },
    { 0xDAA7, 0x741D },
    { 0xDAA8, 0x7429 },
    { 0xDAA9, 0x7420 },
    { 0xDAAA, 0x7432 },
    { 0xDAAB, 0x74FB },
    { 0xDAAC, 0x752F },
    { 0xDAAD, 0x756F },
    { 0xDAAE, 0x756C },
    { 0xDAAF, 0x75E7 },
    { 0xDAB0, 0x75DA },
    { 0xDAB1, 0x75E1 },
    { 0xDAB2, 0x75E6 },
    { 0xDAB3, 0x75DD },
    { 0xDAB4, 0x75DF },
    { 0xDAB5, 0x75E4 },
    { 0xDAB6, 0x75D7 },
    { 0xDAB7, 0x7695 },
    { 0xDAB8, 0x7692 },
    { 0xDAB9, 0x76DA },
    { 0xDABA, 0x7746 },
    { 0xDABB, 0x7747 },
    { 0xDABC, 0x7744 },
    { 0xDABD, 0x774D },
    { 0xDABE, 0x7745 },
    { 0xDABF, 0x774A },
    { 0xDAC0, 0x774E },
    { 0xDAC1, 0x774B },
    { 0xDAC2, 0x774C },
    { 0xDAC3, 0x77DE },
    { 0xDAC4, 0x77EC },
    { 0xDAC5, 0x7860 },
    { 0xDAC6, 0x7864 },
    { 0xDAC7, 0x7865 },
    { 0xDAC8, 0x785C },
    { 0xDAC9, 0x786D },
    { 0xDACA, 0x7871 },
    { 0xDACB, 0x786A },
    { 0xDACC, 0x786E },
    { 0xDACD, 0x7870 },
    { 0xDACE, 0x7869 },
    { 0xDACF, 0x7868 },
    { 0xDAD0, 0x785E },
    { 0xDAD1, 0x7862 },
    { 0xDAD2, 0x7974 },
    { 0xDAD3, 0x7973 },
    { 0xDAD4, 0x7972 },
    { 0xDAD5, 0x7970 },
    { 0xDAD6, 0x7A02 },
    { 0xDAD7, 0x7A0A },
    { 0xDAD8, 0x7A03 },
    { 0xDAD9, 0x7A0C },
    { 0xDADA, 0x7A04 },
    { 0xDADB, 0x7A99 },
    { 0xDADC, 0x7AE6 },
    { 0xDADD, 0x7AE4 },
    { 0xDADE, 0x7B4A },
    { 0xDADF, 0x7B3B },
    { 0xDAE0, 0x7B44 },
    { 0xDAE1, 0x7B48 },
    { 0xDAE2, 0x7B4C },
    { 0xDAE3, 0x7B4E },
    { 0xDAE4, 0x7B40 },
    { 0xDAE5, 0x7B58 },
    { 0xDAE6, 0x7B45 },
    { 0xDAE7, 0x7CA2 },
    { 0xDAE8, 0x7C9E },
    { 0xDAE9, 0x7CA8 },
    { 0xDAEA, 0x7CA1 },
    { 0xDAEB, 0x7D58 },
    { 0xDAEC, 0x7D6F },
    { 0xDAED, 0x7D63 },
    { 0xDAEE, 0x7D53 },
    { 0xDAEF, 0x7D56 },
    { 0xDAF0, 0x7D67 },
    { 0xDAF1, 0x7D6A },
    { 0xDAF2, 0x7D4F },
    { 0xDAF3, 0x7D6D },
    { 0xDAF4, 0x7D5C },
    { 0xDAF5, 0x7D6B },
    { 0xDAF6, 0x7D52 },
    { 0xDAF7, 0x7D54 },
    { 0xDAF8, 0x7D69 },
    { 0xDAF9, 0x7D51 },
    { 0xDAFA, 0x7D5F },
    { 0xDAFB, 0x7D4E },
    { 0xDAFC, 0x7F3E },
    { 0xDAFD, 0x7F3F },
    { 0xDAFE, 0x7F65 },
    { 0xDB40, 0x7F66 },
    { 0xDB41, 0x7FA2 },
    { 0xDB42, 0x7FA0 },
    { 0xDB43, 0x7FA1 },
    { 0xDB44, 0x7FD7 },
    { 0xDB45, 0x8051 },
    { 0xDB46, 0x804F },
    { 0xDB47, 0x8050 },
    { 0xDB48, 0x80FE },
    { 0xDB49, 0x80D4 },
    { 0xDB4A, 0x8143 },
    { 0xDB4B, 0x814A },
    { 0xDB4C, 0x8152 },
    { 0xDB4D, 0x814F },
    { 0xDB4E, 0x8147 },
    { 0xDB4F, 0x813D },
    { 0xDB50, 0x814D },
    { 0xDB51, 0x813A },
    { 0xDB52, 0x81E6 },
    { 0xDB53, 0x81EE },
    { 0xDB54, 0x81F7 },
    { 0xDB55, 0x81F8 },
    { 0xDB56, 0x81F9 },
    { 0xDB57, 0x8204 },
    { 0xDB58, 0x823C },
    { 0xDB59, 0x823D },
    { 0xDB5A, 0x823F },
    { 0xDB5B, 0x8275 },
    { 0xDB5C, 0x833B },
    { 0xDB5D, 0x83CF },
    { 0xDB5E, 0x83F9 },
    { 0xDB5F, 0x8423 },
    { 0xDB60, 0x83C0 },
    { 0xDB61, 0x83E8 },
    { 0xDB62, 0x8412 },
    { 0xDB63, 0x83E7 },
    { 0xDB64, 0x83E4 },
    { 0xDB65, 0x83FC },
    { 0xDB66, 0x83F6 },
    { 0xDB67, 0x8410 },
    { 0xDB68, 0x83C6 },
    { 0xDB69, 0x83C8 },
    { 0xDB6A, 0x83EB },
    { 0xDB6B, 0x83E3 },
    { 0xDB6C, 0x83BF },
    { 0xDB6D, 0x8401 },
    { 0xDB6E, 0x83DD },
    { 0xDB6F, 0x83E5 },
    { 0xDB70, 0x83D8 },
    { 0xDB71, 0x83FF },
    { 0xDB72, 0x83E1 },
    { 0xDB73, 0x83CB },
    { 0xDB74, 0x83CE },
    { 0xDB75, 0x83D6 },
    { 0xDB76, 0x83F5 },
    { 0xDB77, 0x83C9 },
    { 0xDB78, 0x8409 },
    { 0xDB79, 0x840F },
    { 0xDB7A, 0x83DE },
    { 0xDB7B, 0x8411 },
    { 0xDB7C, 0x8406 },
    { 0xDB7D, 0x83C2 },
    { 0xDB7E, 0x83F3 },
    { 0xDBA1, 0x83D5 },
    { 0xDBA2, 0x83FA },
    { 0xDBA3, 0x83C7 },
    { 0xDBA4, 0x83D1 },
    { 0xDBA5, 0x83EA },
    { 0xDBA6, 0x8413 },
    { 0xDBA7, 0x83C3 },
    { 0xDBA8, 0x83EC },
    { 0xDBA9, 0x83EE },
    { 0xDBAA, 0x83C4 },
    { 0xDBAB, 0x83FB },
    { 0xDBAC, 0x83D7 },
    { 0xDBAD, 0x83E2 },
    { 0xDBAE, 0x841B },
    { 0xDBAF, 0x83DB },
    { 0xDBB0, 0x83FE },
    { 0xDBB1, 0x86D8 },
    { 0xDBB2, 0x86E2 },
    { 0xDBB3, 0x86E6 },
    { 0xDBB4, 0x86D3 },
    { 0xDBB5, 0x86E3 },
    { 0xDBB6, 0x86DA },
    { 0xDBB7, 0x86EA },
    { 0xDBB8, 0x86DD },
    { 0xDBB9, 0x86EB },
    { 0xDBBA, 0x86DC },
    { 0xDBBB, 0x86EC },
    { 0xDBBC, 0x86E9 },
    { 0xDBBD, 0x86D7 },
    { 0xDBBE, 0x86E8 },
    { 0xDBBF, 0x86D1 },
    { 0xDBC0, 0x8848 },
    { 0xDBC1, 0x8856 },
    { 0xDBC2, 0x8855 },
    { 0xDBC3, 0x88BA },
    { 0xDBC4, 0x88D7 },
    { 0xDBC5, 0x88B9 },
    { 0xDBC6, 0x88B8 },
    { 0xDBC7, 0x88C0 },
    { 0xDBC8, 0x88BE },
    { 0xDBC9, 0x88B6 },
    { 0xDBCA, 0x88BC },
    { 0xDBCB, 0x88B7 },
    { 0xDBCC, 0x88BD },
    { 0xDBCD, 0x88B2 },
    { 0xDBCE, 0x8901 },
    { 0xDBCF, 0x88C9 },
    { 0xDBD0, 0x8995 },
    { 0xDBD1, 0x8998 },
    { 0xDBD2, 0x8997 },
    { 0xDBD3, 0x89DD },
    { 0xDBD4, 0x89DA },
    { 0xDBD5, 0x89DB },
    { 0xDBD6, 0x8A4E },
    { 0xDBD7, 0x8A4D },
    { 0xDBD8, 0x8A39 },
    { 0xDBD9, 0x8A59 },
    { 0xDBDA, 0x8A40 },
    { 0xDBDB, 0x8A57 },
    { 0xDBDC, 0x8A58 },
    { 0xDBDD, 0x8A44 },
    { 0xDBDE, 0x8A45 },
    { 0xDBDF, 0x8A52 },
    { 0xDBE0, 0x8A48 },
    { 0xDBE1, 0x8A51 },
    { 0xDBE2, 0x8A4A },
    { 0xDBE3, 0x8A4C },
    { 0xDBE4, 0x8A4F },
    { 0xDBE5, 0x8C5F },
    { 0xDBE6, 0x8C81 },
    { 0xDBE7, 0x8C80 },
    { 0xDBE8, 0x8CBA },
    { 0xDBE9, 0x8CBE },
    { 0xDBEA, 0x8CB0 },
    { 0xDBEB, 0x8CB9 },
    { 0xDBEC, 0x8CB5 },
    { 0xDBED, 0x8D84 },
    { 0xDBEE, 0x8D80 },
    { 0xDBEF, 0x8D89 },
    { 0xDBF0, 0x8DD8 },
    { 0xDBF1, 0x8DD3 },
    { 0xDBF2, 0x8DCD },
    { 0xDBF3, 0x8DC7 },
    { 0xDBF4, 0x8DD6 },
    { 0xDBF5, 0x8DDC },
    { 0xDBF6, 0x8DCF },
    { 0xDBF7, 0x8DD5 },
    { 0xDBF8, 0x8DD9 },
    { 0xDBF9, 0x8DC8 },
    { 0xDBFA, 0x8DD7 },
    { 0xDBFB, 0x8DC5 },
    { 0xDBFC, 0x8EEF },
    { 0xDBFD, 0x8EF7 },
    { 0xDBFE, 0x8EFA },
    { 0xDC40, 0x8EF9 },
    { 0xDC41, 0x8EE6 },
    { 0xDC42, 0x8EEE },
    { 0xDC43, 0x8EE5 },
    { 0xDC44, 0x8EF5 },
    { 0xDC45, 0x8EE7 },
    { 0xDC46, 0x8EE8 },
    { 0xDC47, 0x8EF6 },
    { 0xDC48, 0x8EEB },
    { 0xDC49, 0x8EF1 },
    { 0xDC4A, 0x8EEC },
    { 0xDC4B, 0x8EF4 },
    { 0xDC4C, 0x8EE9 },
    { 0xDC4D, 0x902D },
    { 0xDC4E, 0x9034 },
    { 0xDC4F, 0x902F },
    { 0xDC50, 0x9106 },
    { 0xDC51, 0x912C },
    { 0xDC52, 0x9104 },
    { 0xDC53, 0x90FF },
    { 0xDC54, 0x90FC },
    { 0xDC55, 0x9108 },
    { 0xDC56, 0x90F9 },
    { 0xDC57, 0x90FB },
    { 0xDC58, 0x9101 },
    { 0xDC59, 0x9100 },
    { 0xDC5A, 0x9107 },
    { 0xDC5B, 0x9105 },
    { 0xDC5C, 0x9103 },
    { 0xDC5D, 0x9161 },
    { 0xDC5E, 0x9164 },
    { 0xDC5F, 0x915F },
    { 0xDC60, 0x9162 },
    { 0xDC61, 0x9160 },
    { 0xDC62, 0x9201 },
    { 0xDC63, 0x920A },
    { 0xDC64, 0x9225 },
    { 0xDC65, 0x9203 },
    { 0xDC66, 0x921A },
    { 0xDC67, 0x9226 },
    { 0xDC68, 0x920F },
    { 0xDC69, 0x920C },
    { 0xDC6A, 0x9200 },
    { 0xDC6B, 0x9212 },
    { 0xDC6C, 0x91FF },
    { 0xDC6D, 0x91FD },
    { 0xDC6E, 0x9206 },
    { 0xDC6F, 0x9204 },
    { 0xDC70, 0x9227 },
    { 0xDC71, 0x9202 },
    { 0xDC72, 0x921C },
    { 0xDC73, 0x9224 },
    { 0xDC74, 0x9219 },
    { 0xDC75, 0x9217 },
    { 0xDC76, 0x9205 },
    { 0xDC77, 0x9216 },
    { 0xDC78, 0x957B },
    { 0xDC79, 0x958D },
    { 0xDC7A, 0x958C },
    { 0xDC7B, 0x9590 },
    { 0xDC7C, 0x9687 },
    { 0xDC7D, 0x967E },
    { 0xDC7E, 0x9688 },
    { 0xDCA1, 0x9689 },
    { 0xDCA2, 0x9683 },
    { 0xDCA3, 0x9680 },
    { 0xDCA4, 0x96C2 },
    { 0xDCA5, 0x96C8 },
    { 0xDCA6, 0x96C3 },
    { 0xDCA7, 0x96F1 },
    { 0xDCA8, 0x96F0 },
    { 0xDCA9, 0x976C },
    { 0xDCAA, 0x9770 },
    { 0xDCAB, 0x976E },
    { 0xDCAC, 0x9807 },
    { 0xDCAD, 0x98A9 },
    { 0xDCAE, 0x98EB },
    { 0xDCAF, 0x9CE6 },
    { 0xDCB0, 0x9EF9 },
    { 0xDCB1, 0x4E83 },
    { 0xDCB2, 0x4E84 },
    { 0xDCB3, 0x4EB6 },
    { 0xDCB4, 0x50BD },
    { 0xDCB5, 0x50BF },
    { 0xDCB6, 0x50C6 },
    { 0xDCB7, 0x50AE },
    { 0xDCB8, 0x50C4 },
    { 0xDCB9, 0x50CA },
    { 0xDCBA, 0x50B4 },
    { 0xDCBB, 0x50C8 },
    { 0xDCBC, 0x50C2 },
    { 0xDCBD, 0x50B0 },
    { 0xDCBE, 0x50C1 },
    { 0xDCBF, 0x50BA },
    { 0xDCC0, 0x50B1 },
    { 0xDCC1, 0x50CB },
    { 0xDCC2, 0x50C9 },
    { 0xDCC3, 0x50B6 },
    { 0xDCC4, 0x50B8 },
    { 0xDCC5, 0x51D7 },
    { 0xDCC6, 0x527A },
    { 0xDCC7, 0x5278 },
    { 0xDCC8, 0x527B },
    { 0xDCC9, 0x527C },
    { 0xDCCA, 0x55C3 },
    { 0xDCCB, 0x55DB },
    { 0xDCCC, 0x55CC },
    { 0xDCCD, 0x55D0 },
    { 0xDCCE, 0x55CB },
    { 0xDCCF, 0x55CA },
    { 0xDCD0, 0x55DD },
    { 0xDCD1, 0x55C0 },
    { 0xDCD2, 0x55D4 },
    { 0xDCD3, 0x55C4 },
    { 0xDCD4, 0x55E9 },
    { 0xDCD5, 0x55BF },
    { 0xDCD6, 0x55D2 },
    { 0xDCD7, 0x558D },
    { 0xDCD8, 0x55CF },
    { 0xDCD9, 0x55D5 },
    { 0xDCDA, 0x55E2 },
    { 0xDCDB, 0x55D6 },
    { 0xDCDC, 0x55C8 },
    { 0xDCDD, 0x55F2 },
    { 0xDCDE, 0x55CD },
    { 0xDCDF, 0x55D9 },
    { 0xDCE0, 0x55C2 },
    { 0xDCE1, 0x5714 },
    { 0xDCE2, 0x5853 },
    { 0xDCE3, 0x5868 },
    { 0xDCE4, 0x5864 },
    { 0xDCE5, 0x584F },
    { 0xDCE6, 0x584D },
    { 0xDCE7, 0x5849 },
    { 0xDCE8, 0x586F },
    { 0xDCE9, 0x5855 },
    { 0xDCEA, 0x584E },
    { 0xDCEB, 0x585D },
    { 0xDCEC, 0x5859 },
    { 0xDCED, 0x5865 },
    { 0xDCEE, 0x585B },
    { 0xDCEF, 0x583D },
    { 0xDCF0, 0x5863 },
    { 0xDCF1, 0x5871 },
    { 0xDCF2, 0x58FC },
    { 0xDCF3, 0x5AC7 },
    { 0xDCF4, 0x5AC4 },
    { 0xDCF5, 0x5ACB },
    { 0xDCF6, 0x5ABA },
    { 0xDCF7, 0x5AB8 },
    { 0xDCF8, 0x5AB1 },
    { 0xDCF9, 0x5AB5 },
    { 0xDCFA, 0x5AB0 },
    { 0xDCFB, 0x5ABF },
    { 0xDCFC, 0x5AC8 },
    { 0xDCFD, 0x5ABB },
    { 0xDCFE, 0x5AC6 },
    { 0xDD40, 0x5AB7 },
    { 0xDD41, 0x5AC0 },
    { 0xDD42, 0x5ACA },
    { 0xDD43, 0x5AB4 },
    { 0xDD44, 0x5AB6 },
    { 0xDD45, 0x5ACD },
    { 0xDD46, 0x5AB9 },
    { 0xDD47, 0x5A90 },
    { 0xDD48, 0x5BD6 },
    { 0xDD49, 0x5BD8 },
    { 0xDD4A, 0x5BD9 },
    { 0xDD4B, 0x5C1F },
    { 0xDD4C, 0x5C33 },
    { 0xDD4D, 0x5D71 },
    { 0xDD4E, 0x5D63 },
    { 0xDD4F, 0x5D4A },
    { 0xDD50, 0x5D65 },
    { 0xDD51, 0x5D72 },
    { 0xDD52, 0x5D6C },
    { 0xDD53, 0x5D5E },
    { 0xDD54, 0x5D68 },
    { 0xDD55, 0x5D67 },
    { 0xDD56, 0x5D62 },
    { 0xDD57, 0x5DF0 },
    { 0xDD58, 0x5E4F },
    { 0xDD59, 0x5E4E },
    { 0xDD5A, 0x5E4A },
    { 0xDD5B, 0x5E4D },
    { 0xDD5C, 0x5E4B },
    { 0xDD5D, 0x5EC5 },
    { 0xDD5E, 0x5ECC },
    { 0xDD5F, 0x5EC6 },
    { 0xDD60, 0x5ECB },
    { 0xDD61, 0x5EC7 },
    { 0xDD62, 0x5F40 },
    { 0xDD63, 0x5FAF },
    { 0xDD64, 0x5FAD },
    { 0xDD65, 0x60F7 },
    { 0xDD66, 0x6149 },
    { 0xDD67, 0x614A },
    { 0xDD68, 0x612B },
    { 0xDD69, 0x6145 },
    { 0xDD6A, 0x6136 },
    { 0xDD6B, 0x6132 },
    { 0xDD6C, 0x612E },
    { 0xDD6D, 0x6146 },
    { 0xDD6E, 0x612F },
    { 0xDD6F, 0x614F },
    { 0xDD70, 0x6129 },
    { 0xDD71, 0x6140 },
    { 0xDD72, 0x6220 },
    { 0xDD73, 0x9168 },
    { 0xDD74, 0x6223 },
    { 0xDD75, 0x6225 },
    { 0xDD76, 0x6224 },
    { 0xDD77, 0x63C5 },
    { 0xDD78, 0x63F1 },
    { 0xDD79, 0x63EB },
    { 0xDD7A, 0x6410 },
    { 0xDD7B, 0x6412 },
    { 0xDD7C, 0x6409 },
    { 0xDD7D, 0x6420 },
    { 0xDD7E, 0x6424 },
    { 0xDDA1, 0x6433 },
    { 0xDDA2, 0x6443 },
    { 0xDDA3, 0x641F },
    { 0xDDA4, 0x6415 },
    { 0xDDA5, 0x6418 },
    { 0xDDA6, 0x6439 },
    { 0xDDA7, 0x6437 },
    { 0xDDA8, 0x6422 },
    { 0xDDA9, 0x6423 },
    { 0xDDAA, 0x640C },
    { 0xDDAB, 0x6426 },
    { 0xDDAC, 0x6430 },
    { 0xDDAD, 0x6428 },
    { 0xDDAE, 0x6441 },
    { 0xDDAF, 0x6435 },
    { 0xDDB0, 0x642F },
    { 0xDDB1, 0x640A },
    { 0xDDB2, 0x641A },
    { 0xDDB3, 0x6440 },
    { 0xDDB4, 0x6425 },
    { 0xDDB5, 0x6427 },
    { 0xDDB6, 0x640B },
    { 0xDDB7, 0x63E7 },
    { 0xDDB8, 0x641B },
    { 0xDDB9, 0x642E },
    { 0xDDBA, 0x6421 },
    { 0xDDBB, 0x640E },
    { 0xDDBC, 0x656F },
    { 0xDDBD, 0x6592 },
    { 0xDDBE, 0x65D3 },
    { 0xDDBF, 0x6686 },
    { 0xDDC0, 0x668C },
    { 0xDDC1, 0x6695 },
    { 0xDDC2, 0x6690 },
    { 0xDDC3, 0x668B },
    { 0xDDC4, 0x668A },
    { 0xDDC5, 0x6699 },
    { 0xDDC6, 0x6694 },
    { 0xDDC7, 0x6678 },
    { 0xDDC8, 0x6720 },
    { 0xDDC9, 0x6966 },
    { 0xDDCA, 0x695F },
    { 0xDDCB, 0x6938 },
    { 0xDDCC, 0x694E },
    { 0xDDCD, 0x6962 },
    { 0xDDCE, 0x6971 },
    { 0xDDCF, 0x693F },
    { 0xDDD0, 0x6945 },
    { 0xDDD1, 0x696A },
    { 0xDDD2, 0x6939 },
    { 0xDDD3, 0x6942 },
    { 0xDDD4, 0x6957 },
    { 0xDDD5, 0x6959 },
    { 0xDDD6, 0x697A },
    { 0xDDD7, 0x6948 },
    { 0xDDD8, 0x6949 },
    { 0xDDD9, 0x6935 },
    { 0xDDDA, 0x696C },
    { 0xDDDB, 0x6933 },
    { 0xDDDC, 0x693D },
    { 0xDDDD, 0x6965 },
    { 0xDDDE, 0x68F0 },
    { 0xDDDF, 0x6978 },
    { 0xDDE0, 0x6934 },
    { 0xDDE1, 0x6969 },
    { 0xDDE2, 0x6940 },
    { 0xDDE3, 0x696F },
    { 0xDDE4, 0x6944 },
    { 0xDDE5, 0x6976 },
    { 0xDDE6, 0x6958 },
    { 0xDDE7, 0x6941 },
    { 0xDDE8, 0x6974 },
    { 0xDDE9, 0x694C },
    { 0xDDEA, 0x693B },
    { 0xDDEB, 0x694B },
    { 0xDDEC, 0x6937 },
    { 0xDDED, 0x695C },
    { 0xDDEE, 0x694F },
    { 0xDDEF, 0x6951 },
    { 0xDDF0, 0x6932 },
    { 0xDDF1, 0x6952 },
    { 0xDDF2, 0x692F },
    { 0xDDF3, 0x697B },
    { 0xDDF4, 0x693C },
    { 0xDDF5, 0x6B46 },
    { 0xDDF6, 0x6B45 },
    { 0xDDF7, 0x6B43 },
    { 0xDDF8, 0x6B42 },
    { 0xDDF9, 0x6B48 },
    { 0xDDFA, 0x6B41 },
    { 0xDDFB, 0x6B9B },
    { 0xDDFC, 0xFA0D },
    { 0xDDFD, 0x6BFB },
    { 0xDDFE, 0x6BFC },
    { 0xDE40, 0x6BF9 },
    { 0xDE41, 0x6BF7 },
    { 0xDE42, 0x6BF8 },
    { 0xDE43, 0x6E9B },
    { 0xDE44, 0x6ED6 },
    { 0xDE45, 0x6EC8 },
    { 0xDE46, 0x6E8F },
    { 0xDE47, 0x6EC0 },
    { 0xDE48, 0x6E9F },
    { 0xDE49, 0x6E93 },
    { 0xDE4A, 0x6E94 },
    { 0xDE4B, 0x6EA0 },
    { 0xDE4C, 0x6EB1 },
    { 0xDE4D, 0x6EB9 },
    { 0xDE4E, 0x6EC6 },
    { 0xDE4F, 0x6ED2 },
    { 0xDE50, 0x6EBD },
    { 0xDE51, 0x6EC1 },
    { 0xDE52, 0x6E9E },
    { 0xDE53, 0x6EC9 },
    { 0xDE54, 0x6EB7 },
    { 0xDE55, 0x6EB0 },
    { 0xDE56, 0x6ECD },
    { 0xDE57, 0x6EA6 },
    { 0xDE58, 0x6ECF },
    { 0xDE59, 0x6EB2 },
    { 0xDE5A, 0x6EBE },
    { 0xDE5B, 0x6EC3 },
    { 0xDE5C, 0x6EDC },
    { 0xDE5D, 0x6ED8 },
    { 0xDE5E, 0x6E99 },
    { 0xDE5F, 0x6E92 },
    { 0xDE60, 0x6E8E },
    { 0xDE61, 0x6E8D },
    { 0xDE62, 0x6EA4 },
    { 0xDE63, 0x6EA1 },
    { 0xDE64, 0x6EBF },
    { 0xDE65, 0x6EB3 },
    { 0xDE66, 0x6ED0 },
    { 0xDE67, 0x6ECA },
    { 0xDE68, 0x6E97 },
    { 0xDE69, 0x6EAE },
    { 0xDE6A, 0x6EA3 },
    { 0xDE6B, 0x7147 },
    { 0xDE6C, 0x7154 },
    { 0xDE6D, 0x7152 },
    { 0xDE6E, 0x7163 },
    { 0xDE6F, 0x7160 },
    { 0xDE70, 0x7141 },
    { 0xDE71, 0x715D },
    { 0xDE72, 0x7162 },
    { 0xDE73, 0x7172 },
    { 0xDE74, 0x7178 },
    { 0xDE75, 0x716A },
    { 0xDE76, 0x7161 },
    { 0xDE77, 0x7142 },
    { 0xDE78, 0x7158 },
    { 0xDE79, 0x7143 },
    { 0xDE7A, 0x714B },
    { 0xDE7B, 0x7170 },
    { 0xDE7C, 0x715F },
    { 0xDE7D, 0x7150 },
    { 0xDE7E, 0x7153 },
    { 0xDEA1, 0x7144 },
    { 0xDEA2, 0x714D },
    { 0xDEA3, 0x715A },
    { 0xDEA4, 0x724F },
    { 0xDEA5, 0x728D },
    { 0xDEA6, 0x728C },
    { 0xDEA7, 0x7291 },
    { 0xDEA8, 0x7290 },
    { 0xDEA9, 0x728E },
    { 0xDEAA, 0x733C },
    { 0xDEAB, 0x7342 },
    { 0xDEAC, 0x733B },
    { 0xDEAD, 0x733A },
    { 0xDEAE, 0x7340 },
    { 0xDEAF, 0x734A },
    { 0xDEB0, 0x7349 },
    { 0xDEB1, 0x7444 },
    { 0xDEB2, 0x744A },
    { 0xDEB3, 0x744B },
    { 0xDEB4, 0x7452 },
    { 0xDEB5, 0x7451 },
    { 0xDEB6, 0x7457 },
    { 0xDEB7, 0x7440 },
    { 0xDEB8, 0x744F },
    { 0xDEB9, 0x7450 },
    { 0xDEBA, 0x744E },
    { 0xDEBB, 0x7442 },
    { 0xDEBC, 0x7446 },
    { 0xDEBD, 0x744D },
    { 0xDEBE, 0x7454 },
    { 0xDEBF, 0x74E1 },
    { 0xDEC0, 0x74FF },
    { 0xDEC1, 0x74FE },
    { 0xDEC2, 0x74FD },
    { 0xDEC3, 0x751D },
    { 0xDEC4, 0x7579 },
    { 0xDEC5, 0x7577 },
    { 0xDEC6, 0x6983 },
    { 0xDEC7, 0x75EF },
    { 0xDEC8, 0x760F },
    { 0xDEC9, 0x7603 },
    { 0xDECA, 0x75F7 },
    { 0xDECB, 0x75FE },
    { 0xDECC, 0x75FC },
    { 0xDECD, 0x75F9 },
    { 0xDECE, 0x75F8 },
    { 0xDECF, 0x7610 },
    { 0xDED0, 0x75FB },
    { 0xDED1, 0x75F6 },
    { 0xDED2, 0x75ED },
    { 0xDED3, 0x75F5 },
    { 0xDED4, 0x75FD },
    { 0xDED5, 0x7699 },
    { 0xDED6, 0x76B5 },
    { 0xDED7, 0x76DD },
    { 0xDED8, 0x7755 },
    { 0xDED9, 0x775F },
    { 0xDEDA, 0x7760 },
    { 0xDEDB, 0x7752 },
    { 0xDEDC, 0x7756 },
    { 0xDEDD, 0x775A },
    { 0xDEDE, 0x7769 },
    { 0xDEDF, 0x7767 },
    { 0xDEE0, 0x7754 },
    { 0xDEE1, 0x7759 },
    { 0xDEE2, 0x776D },
    { 0xDEE3, 0x77E0 },
    { 0xDEE4, 0x7887 },
    { 0xDEE5, 0x789A },
    { 0xDEE6, 0x7894 },
    { 0xDEE7, 0x788F },
    { 0xDEE8, 0x7884 },
    { 0xDEE9, 0x7895 },
    { 0xDEEA, 0x7885 },
    { 0xDEEB, 0x7886 },
    { 0xDEEC, 0x78A1 },
    { 0xDEED, 0x7883 },
    { 0xDEEE, 0x7879 },
    { 0xDEEF, 0x7899 },
    { 0xDEF0, 0x7880 },
    { 0xDEF1, 0x7896 },
    { 0xDEF2, 0x787B },
    { 0xDEF3, 0x797C },
    { 0xDEF4, 0x7982 },
    { 0xDEF5, 0x797D },
    { 0xDEF6, 0x7979 },
    { 0xDEF7, 0x7A11 },
    { 0xDEF8, 0x7A18 },
    { 0xDEF9, 0x7A19 },
    { 0xDEFA, 0x7A12 },
    { 0xDEFB, 0x7A17 },
    { 0xDEFC, 0x7A15 },
    { 0xDEFD, 0x7A22 },
    { 0xDEFE, 0x7A13 },
    { 0xDF40, 0x7A1B },
    { 0xDF41, 0x7A10 },
    { 0xDF42, 0x7AA3 },
    { 0xDF43, 0x7AA2 },
    { 0xDF44, 0x7A9E },
    { 0xDF45, 0x7AEB },
    { 0xDF46, 0x7B66 },
    { 0xDF47, 0x7B64 },
    { 0xDF48, 0x7B6D },
    { 0xDF49, 0x7B74 },
    { 0xDF4A, 0x7B69 },
    { 0xDF4B, 0x7B72 },
    { 0xDF4C, 0x7B65 },
    { 0xDF4D, 0x7B73 },
    { 0xDF4E, 0x7B71 },
    { 0xDF4F, 0x7B70 },
    { 0xDF50, 0x7B61 },
    { 0xDF51, 0x7B78 },
    { 0xDF52, 0x7B76 },
    { 0xDF53, 0x7B63 },
    { 0xDF54, 0x7CB2 },
    { 0xDF55, 0x7CB4 },
    { 0xDF56, 0x7CAF },
    { 0xDF57, 0x7D88 },
    { 0xDF58, 0x7D86 },
    { 0xDF59, 0x7D80 },
    { 0xDF5A, 0x7D8D },
    { 0xDF5B, 0x7D7F },
    { 0xDF5C, 0x7D85 },
    { 0xDF5D, 0x7D7A },
    { 0xDF5E, 0x7D8E },
    { 0xDF5F, 0x7D7B },
    { 0xDF60, 0x7D83 },
    { 0xDF61, 0x7D7C },
    { 0xDF62, 0x7D8C },
    { 0xDF63, 0x7D94 },
    { 0xDF64, 0x7D84 },
    { 0xDF65, 0x7D7D },
    { 0xDF66, 0x7D92 },
    { 0xDF67, 0x7F6D },
    { 0xDF68, 0x7F6B },
    { 0xDF69, 0x7F67 },
    { 0xDF6A, 0x7F68 },
    { 0xDF6B, 0x7F6C },
    { 0xDF6C, 0x7FA6 },
    { 0xDF6D, 0x7FA5 },
    { 0xDF6E, 0x7FA7 },
    { 0xDF6F, 0x7FDB },
    { 0xDF70, 0x7FDC },
    { 0xDF71, 0x8021 },
    { 0xDF72, 0x8164 },
    { 0xDF73, 0x8160 },
    { 0xDF74, 0x8177 },
    { 0xDF75, 0x815C },
    { 0xDF76, 0x8169 },
    { 0xDF77, 0x815B },
    { 0xDF78, 0x8162 },
    { 0xDF79, 0x8172 },
    { 0xDF7A, 0x6721 },
    { 0xDF7B, 0x815E },
    { 0xDF7C, 0x8176 },
    { 0xDF7D, 0x8167 },
    { 0xDF7E, 0x816F },
    { 0xDFA1, 0x8144 },
    { 0xDFA2, 0x8161 },
    { 0xDFA3, 0x821D },
    { 0xDFA4, 0x8249 },
    { 0xDFA5, 0x8244 },
    { 0xDFA6, 0x8240 },
    { 0xDFA7, 0x8242 },
    { 0xDFA8, 0x8245 },
    { 0xDFA9, 0x84F1 },
    { 0xDFAA, 0x843F },
    { 0xDFAB, 0x8456 },
    { 0xDFAC, 0x8476 },
    { 0xDFAD, 0x8479 },
    { 0xDFAE, 0x848F },
    { 0xDFAF, 0x848D },
    { 0xDFB0, 0x8465 },
    { 0xDFB1, 0x8451 },
    { 0xDFB2, 0x8440 },
    { 0xDFB3, 0x8486 },
    { 0xDFB4, 0x8467 },
    { 0xDFB5, 0x8430 },
    { 0xDFB6, 0x844D },
    { 0xDFB7, 0x847D },
    { 0xDFB8, 0x845A },
    { 0xDFB9, 0x8459 },
    { 0xDFBA, 0x8474 },
    { 0xDFBB, 0x8473 },
    { 0xDFBC, 0x845D },
    { 0xDFBD, 0x8507 },
    { 0xDFBE, 0x845E },
    { 0xDFBF, 0x8437 },
    { 0xDFC0, 0x843A },
    { 0xDFC1, 0x8434 },
    { 0xDFC2, 0x847A },
    { 0xDFC3, 0x8443 },
    { 0xDFC4, 0x8478 },
    { 0xDFC5, 0x8432 },
    { 0xDFC6, 0x8445 },
    { 0xDFC7, 0x8429 },
    { 0xDFC8, 0x83D9 },
    { 0xDFC9, 0x844B },
    { 0xDFCA, 0x842F },
    { 0xDFCB, 0x8442 },
    { 0xDFCC, 0x842D },
    { 0xDFCD, 0x845F },
    { 0xDFCE, 0x8470 },
    { 0xDFCF, 0x8439 },
    { 0xDFD0, 0x844E },
    { 0xDFD1, 0x844C },
    { 0xDFD2, 0x8452 },
    { 0xDFD3, 0x846F },
    { 0xDFD4, 0x84C5 },
    { 0xDFD5, 0x848E },
    { 0xDFD6, 0x843B },
    { 0xDFD7, 0x8447 },
    { 0xDFD8, 0x8436 },
    { 0xDFD9, 0x8433 },
    { 0xDFDA, 0x8468 },
    { 0xDFDB, 0x847E },
    { 0xDFDC, 0x8444 },
    { 0xDFDD, 0x842B },
    { 0xDFDE, 0x8460 },
    { 0xDFDF, 0x8454 },
    { 0xDFE0, 0x846E },
    { 0xDFE1, 0x8450 },
    { 0xDFE2, 0x870B },
    { 0xDFE3, 0x8704 },
    { 0xDFE4, 0x86F7 },
    { 0xDFE5, 0x870C },
    { 0xDFE6, 0x86FA },
    { 0xDFE7, 0x86D6 },
    { 0xDFE8, 0x86F5 },
    { 0xDFE9, 0x874D },
    { 0xDFEA, 0x86F8 },
    { 0xDFEB, 0x870E },
    { 0xDFEC, 0x8709 },
    { 0xDFED, 0x8701 },
    { 0xDFEE, 0x86F6 },
    { 0xDFEF, 0x870D },
    { 0xDFF0, 0x8705 },
    { 0xDFF1, 0x88D6 },
    { 0xDFF2, 0x88CB },
    { 0xDFF3, 0x88CD },
    { 0xDFF4, 0x88CE },
    { 0xDFF5, 0x88DE },
    { 0xDFF6, 0x88DB },
    { 0xDFF7, 0x88DA },
    { 0xDFF8, 0x88CC },
    { 0xDFF9, 0x88D0 },
    { 0xDFFA, 0x8985 },
    { 0xDFFB, 0x899B },
    { 0xDFFC, 0x89DF },
    { 0xDFFD, 0x89E5 },
    { 0xDFFE, 0x89E4 },
    { 0xE040, 0x89E1 },
    { 0xE041, 0x89E0 },
    { 0xE042, 0x89E2 },
    { 0xE043, 0x89DC },
    { 0xE044, 0x89E6 },
    { 0xE045, 0x8A76 },
    { 0xE046, 0x8A86 },
    { 0xE047, 0x8A7F },
    { 0xE048, 0x8A61 },
    { 0xE049, 0x8A3F },
    { 0xE04A, 0x8A77 },
    { 0xE04B, 0x8A82 },
    { 0xE04C, 0x8A84 },
    { 0xE04D, 0x8A75 },
    { 0xE04E, 0x8A83 },
    { 0xE04F, 0x8A81 },
    { 0xE050, 0x8A74 },
    { 0xE051, 0x8A7A },
    { 0xE052, 0x8C3C },
    { 0xE053, 0x8C4B },
    { 0xE054, 0x8C4A },
    { 0xE055, 0x8C65 },
    { 0xE056, 0x8C64 },
    { 0xE057, 0x8C66 },
    { 0xE058, 0x8C86 },
    { 0xE059, 0x8C84 },
    { 0xE05A, 0x8C85 },
    { 0xE05B, 0x8CCC },
    { 0xE05C, 0x8D68 },
    { 0xE05D, 0x8D69 },
    { 0xE05E, 0x8D91 },
    { 0xE05F, 0x8D8C },
    { 0xE060, 0x8D8E },
    { 0xE061, 0x8D8F },
    { 0xE062, 0x8D8D },
    { 0xE063, 0x8D93 },
    { 0xE064, 0x8D94 },
    { 0xE065, 0x8D90 },
    { 0xE066, 0x8D92 },
    { 0xE067, 0x8DF0 },
    { 0xE068, 0x8DE0 },
    { 0xE069, 0x8DEC },
    { 0xE06A, 0x8DF1 },
    { 0xE06B, 0x8DEE },
    { 0xE06C, 0x8DD0 },
    { 0xE06D, 0x8DE9 },
    { 0xE06E, 0x8DE3 },
    { 0xE06F, 0x8DE2 },
    { 0xE070, 0x8DE7 },
    { 0xE071, 0x8DF2 },
    { 0xE072, 0x8DEB },
    { 0xE073, 0x8DF4 },
    { 0xE074, 0x8F06 },
    { 0xE075, 0x8EFF },
    { 0xE076, 0x8F01 },
    { 0xE077, 0x8F00 },
    { 0xE078, 0x8F05 },
    { 0xE079, 0x8F07 },
    { 0xE07A, 0x8F08 },
    { 0xE07B, 0x8F02 },
    { 0xE07C, 0x8F0B },
    { 0xE07D, 0x9052 },
    { 0xE07E, 0x903F },
    { 0xE0A1, 0x9044 },
    { 0xE0A2, 0x9049 },
    { 0xE0A3, 0x903D },
    { 0xE0A4, 0x9110 },
    { 0xE0A5, 0x910D },
    { 0xE0A6, 0x910F },
    { 0xE0A7, 0x9111 },
    { 0xE0A8, 0x9116 },
    { 0xE0A9, 0x9114 },
    { 0xE0AA, 0x910B },
    { 0xE0AB, 0x910E },
    { 0xE0AC, 0x916E },
    { 0xE0AD, 0x916F },
    { 0xE0AE, 0x9248 },
    { 0xE0AF, 0x9252 },
    { 0xE0B0, 0x9230 },
    { 0xE0B1, 0x923A },
    { 0xE0B2, 0x9266 },
    { 0xE0B3, 0x9233 },
    { 0xE0B4, 0x9265 },
    { 0xE0B5, 0x925E },
    { 0xE0B6, 0x9283 },
    { 0xE0B7, 0x922E },
    { 0xE0B8, 0x924A },
    { 0xE0B9, 0x9246 },
    { 0xE0BA, 0x926D },
    { 0xE0BB, 0x926C },
    { 0xE0BC, 0x924F },
    { 0xE0BD, 0x9260 },
    { 0xE0BE, 0x9267 },
    { 0xE0BF, 0x926F },
    { 0xE0C0, 0x9236 },
    { 0xE0C1, 0x9261 },
    { 0xE0C2, 0x9270 },
    { 0xE0C3, 0x9231 },
    { 0xE0C4, 0x9254 },
    { 0xE0C5, 0x9263 },
    { 0xE0C6, 0x9250 },
    { 0xE0C7, 0x9272 },
    { 0xE0C8, 0x924E },
    { 0xE0C9, 0x9253 },
    { 0xE0CA, 0x924C },
    { 0xE0CB, 0x9256 },
    { 0xE0CC, 0x9232 },
    { 0xE0CD, 0x959F },
    { 0xE0CE, 0x959C },
    { 0xE0CF, 0x959E },
    { 0xE0D0, 0x959B },
    { 0xE0D1, 0x9692 },
    { 0xE0D2, 0x9693 },
    { 0xE0D3, 0x9691 },
    { 0xE0D4, 0x9697 },
    { 0xE0D5, 0x96CE },
    { 0xE0D6, 0x96FA },
    { 0xE0D7, 0x96FD },
    { 0xE0D8, 0x96F8 },
    { 0xE0D9, 0x96F5 },
    { 0xE0DA, 0x9773 },
    { 0xE0DB, 0x9777 },
    { 0xE0DC, 0x9778 },
    { 0xE0DD, 0x9772 },
    { 0xE0DE, 0x980F },
    { 0xE0DF, 0x980D },
    { 0xE0E0, 0x980E },
    { 0xE0E1, 0x98AC },
    { 0xE0E2, 0x98F6 },
    { 0xE0E3, 0x98F9 },
    { 0xE0E4, 0x99AF },
    { 0xE0E5, 0x99B2 },
    { 0xE0E6, 0x99B0 },
    { 0xE0E7, 0x99B5 },
    { 0xE0E8, 0x9AAD },
    { 0xE0E9, 0x9AAB },
    { 0xE0EA, 0x9B5B },
    { 0xE0EB, 0x9CEA },
    { 0xE0EC, 0x9CED },
    { 0xE0ED, 0x9CE7 },
    { 0xE0EE, 0x9E80 },
    { 0xE0EF, 0x9EFD },
    { 0xE0F0, 0x50E6 },
    { 0xE0F1, 0x50D4 },
    { 0xE0F2, 0x50D7 },
    { 0xE0F3, 0x50E8 },
    { 0xE0F4, 0x50F3 },
    { 0xE0F5, 0x50DB },
    { 0xE0F6, 0x50EA },
    { 0xE0F7, 0x50DD },
    { 0xE0F8, 0x50E4 },
    { 0xE0F9, 0x50D3 },
    { 0xE0FA, 0x50EC },
    { 0xE0FB, 0x50F0 },
    { 0xE0FC, 0x50EF },
    { 0xE0FD, 0x50E3 },
    { 0xE0FE, 0x50E0 },
    { 0xE140, 0x51D8 },
    { 0xE141, 0x5280 },
    { 0xE142, 0x5281 },
    { 0xE143, 0x52E9 },
    { 0xE144, 0x52EB },
    { 0xE145, 0x5330 },
    { 0xE146, 0x53AC },
    { 0xE147, 0x5627 },
    { 0xE148, 0x5615 },
    { 0xE149, 0x560C },
    { 0xE14A, 0x5612 },
    { 0xE14B, 0x55FC },
    { 0xE14C, 0x560F },
    { 0xE14D, 0x561C },
    { 0xE14E, 0x5601 },
    { 0xE14F, 0x5613 },
    { 0xE150, 0x5602 },
    { 0xE151, 0x55FA },
    { 0xE152, 0x561D },
    { 0xE153, 0x5604 },
    { 0xE154, 0x55FF },
    { 0xE155, 0x55F9 },
    { 0xE156, 0x5889 },
    { 0xE157, 0x587C },
    { 0xE158, 0x5890 },
    { 0xE159, 0x5898 },
    { 0xE15A, 0x5886 },
    { 0xE15B, 0x5881 },
    { 0xE15C, 0x587F },
    { 0xE15D, 0x5874 },
    { 0xE15E, 0x588B },
    { 0xE15F, 0x587A },
    { 0xE160, 0x5887 },
    { 0xE161, 0x5891 },
    { 0xE162, 0x588E },
    { 0xE163, 0x5876 },
    { 0xE164, 0x5882 },
    { 0xE165, 0x5888 },
    { 0xE166, 0x587B },
    { 0xE167, 0x5894 },
    { 0xE168, 0x588F },
    { 0xE169, 0x58FE },
    { 0xE16A, 0x596B },
    { 0xE16B, 0x5ADC },
    { 0xE16C, 0x5AEE },
    { 0xE16D, 0x5AE5 },
    { 0xE16E, 0x5AD5 },
    { 0xE16F, 0x5AEA },
    { 0xE170, 0x5ADA },
    { 0xE171, 0x5AED },
    { 0xE172, 0x5AEB },
    { 0xE173, 0x5AF3 },
    { 0xE174, 0x5AE2 },
    { 0xE175, 0x5AE0 },
    { 0xE176, 0x5ADB },
    { 0xE177, 0x5AEC },
    { 0xE178, 0x5ADE },
    { 0xE179, 0x5ADD },
    { 0xE17A, 0x5AD9 },
    { 0xE17B, 0x5AE8 },
    { 0xE17C, 0x5ADF },
    { 0xE17D, 0x5B77 },
    { 0xE17E, 0x5BE0 },
    { 0xE1A1, 0x5BE3 },
    { 0xE1A2, 0x5C63 },
    { 0xE1A3, 0x5D82 },
    { 0xE1A4, 0x5D80 },
    { 0xE1A5, 0x5D7D },
    { 0xE1A6, 0x5D86 },
    { 0xE1A7, 0x5D7A },
    { 0xE1A8, 0x5D81 },
    { 0xE1A9, 0x5D77 },
    { 0xE1AA, 0x5D8A },
    { 0xE1AB, 0x5D89 },
    { 0xE1AC, 0x5D88 },
    { 0xE1AD, 0x5D7E },
    { 0xE1AE, 0x5D7C },
    { 0xE1AF, 0x5D8D },
    { 0xE1B0, 0x5D79 },
    { 0xE1B1, 0x5D7F },
    { 0xE1B2, 0x5E58 },
    { 0xE1B3, 0x5E59 },
    { 0xE1B4, 0x5E53 },
    { 0xE1B5, 0x5ED8 },
    { 0xE1B6, 0x5ED1 },
    { 0xE1B7, 0x5ED7 },
    { 0xE1B8, 0x5ECE },
    { 0xE1B9, 0x5EDC },
    { 0xE1BA, 0x5ED5 },
    { 0xE1BB, 0x5ED9 },
    { 0xE1BC, 0x5ED2 },
    { 0xE1BD, 0x5ED4 },
    { 0xE1BE, 0x5F44 },
    { 0xE1BF, 0x5F43 },
    { 0xE1C0, 0x5F6F },
    { 0xE1C1, 0x5FB6 },
    { 0xE1C2, 0x612C },
    { 0xE1C3, 0x6128 },
    { 0xE1C4, 0x6141 },
    { 0xE1C5, 0x615E },
    { 0xE1C6, 0x6171 },
    { 0xE1C7, 0x6173 },
    { 0xE1C8, 0x6152 },
    { 0xE1C9, 0x6153 },
    { 0xE1CA, 0x6172 },
    { 0xE1CB, 0x616C },
    { 0xE1CC, 0x6180 },
    { 0xE1CD, 0x6174 },
    { 0xE1CE, 0x6154 },
    { 0xE1CF, 0x617A },
    { 0xE1D0, 0x615B },
    { 0xE1D1, 0x6165 },
    { 0xE1D2, 0x613B },
    { 0xE1D3, 0x616A },
    { 0xE1D4, 0x6161 },
    { 0xE1D5, 0x6156 },
    { 0xE1D6, 0x6229 },
    { 0xE1D7, 0x6227 },
    { 0xE1D8, 0x622B },
    { 0xE1D9, 0x642B },
    { 0xE1DA, 0x644D },
    { 0xE1DB, 0x645B },
    { 0xE1DC, 0x645D },
    { 0xE1DD, 0x6474 },
    { 0xE1DE, 0x6476 },
    { 0xE1DF, 0x6472 },
    { 0xE1E0, 0x6473 },
    { 0xE1E1, 0x647D },
    { 0xE1E2, 0x6475 },
    { 0xE1E3, 0x6466 },
    { 0xE1E4, 0x64A6 },
    { 0xE1E5, 0x644E },
    { 0xE1E6, 0x6482 },
    { 0xE1E7, 0x645E },
    { 0xE1E8, 0x645C },
    { 0xE1E9, 0x644B },
    { 0xE1EA, 0x6453 },
    { 0xE1EB, 0x6460 },
    { 0xE1EC, 0x6450 },
    { 0xE1ED, 0x647F },
    { 0xE1EE, 0x643F },
    { 0xE1EF, 0x646C },
    { 0xE1F0, 0x646B },
    { 0xE1F1, 0x6459 },
    { 0xE1F2, 0x6465 },
    { 0xE1F3, 0x6477 },
    { 0xE1F4, 0x6573 },
    { 0xE1F5, 0x65A0 },
    { 0xE1F6, 0x66A1 },
    { 0xE1F7, 0x66A0 },
    { 0xE1F8, 0x669F },
    { 0xE1F9, 0x6705 },
    { 0xE1FA, 0x6704 },
    { 0xE1FB, 0x6722 },
    { 0xE1FC, 0x69B1 },
    { 0xE1FD, 0x69B6 },
    { 0xE1FE, 0x69C9 },
    { 0xE240, 0x69A0 },
    { 0xE241, 0x69CE },
    { 0xE242, 0x6996 },
    { 0xE243, 0x69B0 },
    { 0xE244, 0x69AC },
    { 0xE245, 0x69BC },
    { 0xE246, 0x6991 },
    { 0xE247, 0x6999 },
    { 0xE248, 0x698E },
    { 0xE249, 0x69A7 },
    { 0xE24A, 0x698D },
    { 0xE24B, 0x69A9 },
    { 0xE24C, 0x69BE },
    { 0xE24D, 0x69AF },
    { 0xE24E, 0x69BF },
    { 0xE24F, 0x69C4 },
    { 0xE250, 0x69BD },
    { 0xE251, 0x69A4 },
    { 0xE252, 0x69D4 },
    { 0xE253, 0x69B9 },
    { 0xE254, 0x69CA },
    { 0xE255, 0x699A },
    { 0xE256, 0x69CF },
    { 0xE257, 0x69B3 },
    { 0xE258, 0x6993 },
    { 0xE259, 0x69AA },
    { 0xE25A, 0x69A1 },
    { 0xE25B, 0x699E },
    { 0xE25C, 0x69D9 },
    { 0xE25D, 0x6997 },
    { 0xE25E, 0x6990 },
    { 0xE25F, 0x69C2 },
    { 0xE260, 0x69B5 },
    { 0xE261, 0x69A5 },
    { 0xE262, 0x69C6 },
    { 0xE263, 0x6B4A },
    { 0xE264, 0x6B4D },
    { 0xE265, 0x6B4B },
    { 0xE266, 0x6B9E },
    { 0xE267, 0x6B9F },
    { 0xE268, 0x6BA0 },
    { 0xE269, 0x6BC3 },
    { 0xE26A, 0x6BC4 },
    { 0xE26B, 0x6BFE },
    { 0xE26C, 0x6ECE },
    { 0xE26D, 0x6EF5 },
    { 0xE26E, 0x6EF1 },
    { 0xE26F, 0x6F03 },
    { 0xE270, 0x6F25 },
    { 0xE271, 0x6EF8 },
    { 0xE272, 0x6F37 },
    { 0xE273, 0x6EFB },
    { 0xE274, 0x6F2E },
    { 0xE275, 0x6F09 },
    { 0xE276, 0x6F4E },
    { 0xE277, 0x6F19 },
    { 0xE278, 0x6F1A },
    { 0xE279, 0x6F27 },
    { 0xE27A, 0x6F18 },
    { 0xE27B, 0x6F3B },
    { 0xE27C, 0x6F12 },
    { 0xE27D, 0x6EED },
    { 0xE27E, 0x6F0A },
    { 0xE2A1, 0x6F36 },
    { 0xE2A2, 0x6F73 },
    { 0xE2A3, 0x6EF9 },
    { 0xE2A4, 0x6EEE },
    { 0xE2A5, 0x6F2D },
    { 0xE2A6, 0x6F40 },
    { 0xE2A7, 0x6F30 },
    { 0xE2A8, 0x6F3C },
    { 0xE2A9, 0x6F35 },
    { 0xE2AA, 0x6EEB },
    { 0xE2AB, 0x6F07 },
    { 0xE2AC, 0x6F0E },
    { 0xE2AD, 0x6F43 },
    { 0xE2AE, 0x6F05 },
    { 0xE2AF, 0x6EFD },
    { 0xE2B0, 0x6EF6 },
    { 0xE2B1, 0x6F39 },
    { 0xE2B2, 0x6F1C },
    { 0xE2B3, 0x6EFC },
    { 0xE2B4, 0x6F3A },
    { 0xE2B5, 0x6F1F },
    { 0xE2B6, 0x6F0D },
    { 0xE2B7, 0x6F1E },
    { 0xE2B8, 0x6F08 },
    { 0xE2B9, 0x6F21 },
    { 0xE2BA, 0x7187 },
    { 0xE2BB, 0x7190 },
    { 0xE2BC, 0x7189 },
    { 0xE2BD, 0x7180 },
    { 0xE2BE, 0x7185 },
    { 0xE2BF, 0x7182 },
    { 0xE2C0, 0x718F },
    { 0xE2C1, 0x717B },
    { 0xE2C2, 0x7186 },
    { 0xE2C3, 0x7181 },
    { 0xE2C4, 0x7197 },
    { 0xE2C5, 0x7244 },
    { 0xE2C6, 0x7253 },
    { 0xE2C7, 0x7297 },
    { 0xE2C8, 0x7295 },
    { 0xE2C9, 0x7293 },
    { 0xE2CA, 0x7343 },
    { 0xE2CB, 0x734D },
    { 0xE2CC, 0x7351 },
    { 0xE2CD, 0x734C },
    { 0xE2CE, 0x7462 },
    { 0xE2CF, 0x7473 },
    { 0xE2D0, 0x7471 },
    { 0xE2D1, 0x7475 },
    { 0xE2D2, 0x7472 },
    { 0xE2D3, 0x7467 },
    { 0xE2D4, 0x746E },
    { 0xE2D5, 0x7500 },
    { 0xE2D6, 0x7502 },
    { 0xE2D7, 0x7503 },
    { 0xE2D8, 0x757D },
    { 0xE2D9, 0x7590 },
    { 0xE2DA, 0x7616 },
    { 0xE2DB, 0x7608 },
    { 0xE2DC, 0x760C },
    { 0xE2DD, 0x7615 },
    { 0xE2DE, 0x7611 },
    { 0xE2DF, 0x760A },
    { 0xE2E0, 0x7614 },
    { 0xE2E1, 0x76B8 },
    { 0xE2E2, 0x7781 },
    { 0xE2E3, 0x777C },
    { 0xE2E4, 0x7785 },
    { 0xE2E5, 0x7782 },
    { 0xE2E6, 0x776E },
    { 0xE2E7, 0x7780 },
    { 0xE2E8, 0x776F },
    { 0xE2E9, 0x777E },
    { 0xE2EA, 0x7783 },
    { 0xE2EB, 0x78B2 },
    { 0xE2EC, 0x78AA },
    { 0xE2ED, 0x78B4 },
    { 0xE2EE, 0x78AD },
    { 0xE2EF, 0x78A8 },
    { 0xE2F0, 0x787E },
    { 0xE2F1, 0x78AB },
    { 0xE2F2, 0x789E },
    { 0xE2F3, 0x78A5 },
    { 0xE2F4, 0x78A0 },
    { 0xE2F5, 0x78AC },
    { 0xE2F6, 0x78A2 },
    { 0xE2F7, 0x78A4 },
    { 0xE2F8, 0x7998 },
    { 0xE2F9, 0x798A },
    { 0xE2FA, 0x798B },
    { 0xE2FB, 0x7996 },
    { 0xE2FC, 0x7995 },
    { 0xE2FD, 0x7994 },
    { 0xE2FE, 0x7993 },
    { 0xE340, 0x7997 },
    { 0xE341, 0x7988 },
    { 0xE342, 0x7992 },
    { 0xE343, 0x7990 },
    { 0xE344, 0x7A2B },
    { 0xE345, 0x7A4A },
    { 0xE346, 0x7A30 },
    { 0xE347, 0x7A2F },
    { 0xE348, 0x7A28 },
    { 0xE349, 0x7A26 },
    { 0xE34A, 0x7AA8 },
    { 0xE34B, 0x7AAB },
    { 0xE34C, 0x7AAC },
    { 0xE34D, 0x7AEE },
    { 0xE34E, 0x7B88 },
    { 0xE34F, 0x7B9C },
    { 0xE350, 0x7B8A },
    { 0xE351, 0x7B91 },
    { 0xE352, 0x7B90 },
    { 0xE353, 0x7B96 },
    { 0xE354, 0x7B8D },
    { 0xE355, 0x7B8C },
    { 0xE356, 0x7B9B },
    { 0xE357, 0x7B8E },
    { 0xE358, 0x7B85 },
    { 0xE359, 0x7B98 },
    { 0xE35A, 0x5284 },
    { 0xE35B, 0x7B99 },
    { 0xE35C, 0x7BA4 },
    { 0xE35D, 0x7B82 },
    { 0xE35E, 0x7CBB },
    { 0xE35F, 0x7CBF },
    { 0xE360, 0x7CBC },
    { 0xE361, 0x7CBA },
    { 0xE362, 0x7DA7 },
    { 0xE363, 0x7DB7 },
    { 0xE364, 0x7DC2 },
    { 0xE365, 0x7DA3 },
    { 0xE366, 0x7DAA },
    { 0xE367, 0x7DC1 },
    { 0xE368, 0x7DC0 },
    { 0xE369, 0x7DC5 },
    { 0xE36A, 0x7D9D },
    { 0xE36B, 0x7DCE },
    { 0xE36C, 0x7DC4 },
    { 0xE36D, 0x7DC6 },
    { 0xE36E, 0x7DCB },
    { 0xE36F, 0x7DCC },
    { 0xE370, 0x7DAF },
    { 0xE371, 0x7DB9 },
    { 0xE372, 0x7D96 },
    { 0xE373, 0x7DBC },
    { 0xE374, 0x7D9F },
    { 0xE375, 0x7DA6 },
    { 0xE376, 0x7DAE },
    { 0xE377, 0x7DA9 },
    { 0xE378, 0x7DA1 },
    { 0xE379, 0x7DC9 },
    { 0xE37A, 0x7F73 },
    { 0xE37B, 0x7FE2 },
    { 0xE37C, 0x7FE3 },
    { 0xE37D, 0x7FE5 },
    { 0xE37E, 0x7FDE },
    { 0xE3A1, 0x8024 },
    { 0xE3A2, 0x805D },
    { 0xE3A3, 0x805C },
    { 0xE3A4, 0x8189 },
    { 0xE3A5, 0x8186 },
    { 0xE3A6, 0x8183 },
    { 0xE3A7, 0x8187 },
    { 0xE3A8, 0x818D },
    { 0xE3A9, 0x818C },
    { 0xE3AA, 0x818B },
    { 0xE3AB, 0x8215 },
    { 0xE3AC, 0x8497 },
    { 0xE3AD, 0x84A4 },
    { 0xE3AE, 0x84A1 },
    { 0xE3AF, 0x849F },
    { 0xE3B0, 0x84BA },
    { 0xE3B1, 0x84CE },
    { 0xE3B2, 0x84C2 },
    { 0xE3B3, 0x84AC },
    { 0xE3B4, 0x84AE },
    { 0xE3B5, 0x84AB },
    { 0xE3B6, 0x84B9 },
    { 0xE3B7, 0x84B4 },
    { 0xE3B8, 0x84C1 },
    { 0xE3B9, 0x84CD },
    { 0xE3BA, 0x84AA },
    { 0xE3BB, 0x849A },
    { 0xE3BC, 0x84B1 },
    { 0xE3BD, 0x84D0 },
    { 0xE3BE, 0x849D },
    { 0xE3BF, 0x84A7 },
    { 0xE3C0, 0x84BB },
    { 0xE3C1, 0x84A2 },
    { 0xE3C2, 0x8494 },
    { 0xE3C3, 0x84C7 },
    { 0xE3C4, 0x84CC },
    { 0xE3C5, 0x849B },
    { 0xE3C6, 0x84A9 },
    { 0xE3C7, 0x84AF },
    { 0xE3C8, 0x84A8 },
    { 0xE3C9, 0x84D6 },
    { 0xE3CA, 0x8498 },
    { 0xE3CB, 0x84B6 },
    { 0xE3CC, 0x84CF },
    { 0xE3CD, 0x84A0 },
    { 0xE3CE, 0x84D7 },
    { 0xE3CF, 0x84D4 },
    { 0xE3D0, 0x84D2 },
    { 0xE3D1, 0x84DB },
    { 0xE3D2, 0x84B0 },
    { 0xE3D3, 0x8491 },
    { 0xE3D4, 0x8661 },
    { 0xE3D5, 0x8733 },
    { 0xE3D6, 0x8723 },
    { 0xE3D7, 0x8728 },
    { 0xE3D8, 0x876B },
    { 0xE3D9, 0x8740 },
    { 0xE3DA, 0x872E },
    { 0xE3DB, 0x871E },
    { 0xE3DC, 0x8721 },
    { 0xE3DD, 0x8719 },
    { 0xE3DE, 0x871B },
    { 0xE3DF, 0x8743 },
    { 0xE3E0, 0x872C },
    { 0xE3E1, 0x8741 },
    { 0xE3E2, 0x873E },
    { 0xE3E3, 0x8746 },
    { 0xE3E4, 0x8720 },
    { 0xE3E5, 0x8732 },
    { 0xE3E6, 0x872A },
    { 0xE3E7, 0x872D },
    { 0xE3E8, 0x873C },
    { 0xE3E9, 0x8712 },
    { 0xE3EA, 0x873A },
    { 0xE3EB, 0x8731 },
    { 0xE3EC, 0x8735 },
    { 0xE3ED, 0x8742 },
    { 0xE3EE, 0x8726 },
    { 0xE3EF, 0x8727 },
    { 0xE3F0, 0x8738 },
    { 0xE3F1, 0x8724 },
    { 0xE3F2, 0x871A },
    { 0xE3F3, 0x8730 },
    { 0xE3F4, 0x8711 },
    { 0xE3F5, 0x88F7 },
    { 0xE3F6, 0x88E7 },
    { 0xE3F7, 0x88F1 },
    { 0xE3F8, 0x88F2 },
    { 0xE3F9, 0x88FA },
    { 0xE3FA, 0x88FE },
    { 0xE3FB, 0x88EE },
    { 0xE3FC, 0x88FC },
    { 0xE3FD, 0x88F6 },
    { 0xE3FE, 0x88FB },
    { 0xE440, 0x88F0 },
    { 0xE441, 0x88EC },
    { 0xE442, 0x88EB },
    { 0xE443, 0x899D },
    { 0xE444, 0x89A1 },
    { 0xE445, 0x899F },
    { 0xE446, 0x899E },
    { 0xE447, 0x89E9 },
    { 0xE448, 0x89EB },
    { 0xE449, 0x89E8 },
    { 0xE44A, 0x8AAB },
    { 0xE44B, 0x8A99 },
    { 0xE44C, 0x8A8B },
    { 0xE44D, 0x8A92 },
    { 0xE44E, 0x8A8F },
    { 0xE44F, 0x8A96 },
    { 0xE450, 0x8C3D },
    { 0xE451, 0x8C68 },
    { 0xE452, 0x8C69 },
    { 0xE453, 0x8CD5 },
    { 0xE454, 0x8CCF },
    { 0xE455, 0x8CD7 },
    { 0xE456, 0x8D96 },
    { 0xE457, 0x8E09 },
    { 0xE458, 0x8E02 },
    { 0xE459, 0x8DFF },
    { 0xE45A, 0x8E0D },
    { 0xE45B, 0x8DFD },
    { 0xE45C, 0x8E0A },
    { 0xE45D, 0x8E03 },
    { 0xE45E, 0x8E07 },
    { 0xE45F, 0x8E06 },
    { 0xE460, 0x8E05 },
    { 0xE461, 0x8DFE },
    { 0xE462, 0x8E00 },
    { 0xE463, 0x8E04 },
    { 0xE464, 0x8F10 },
    { 0xE465, 0x8F11 },
    { 0xE466, 0x8F0E },
    { 0xE467, 0x8F0D },
    { 0xE468, 0x9123 },
    { 0xE469, 0x911C },
    { 0xE46A, 0x9120 },
    { 0xE46B, 0x9122 },
    { 0xE46C, 0x911F },
    { 0xE46D, 0x911D },
    { 0xE46E, 0x911A },
    { 0xE46F, 0x9124 },
    { 0xE470, 0x9121 },
    { 0xE471, 0x911B },
    { 0xE472, 0x917A },
    { 0xE473, 0x9172 },
    { 0xE474, 0x9179 },
    { 0xE475, 0x9173 },
    { 0xE476, 0x92A5 },
    { 0xE477, 0x92A4 },
    { 0xE478, 0x9276 },
    { 0xE479, 0x929B },
    { 0xE47A, 0x927A },
    { 0xE47B, 0x92A0 },
    { 0xE47C, 0x9294 },
    { 0xE47D, 0x92AA },
    { 0xE47E, 0x928D },
    { 0xE4A1, 0x92A6 },
    { 0xE4A2, 0x929A },
    { 0xE4A3, 0x92AB },
    { 0xE4A4, 0x9279 },
    { 0xE4A5, 0x9297 },
    { 0xE4A6, 0x927F },
    { 0xE4A7, 0x92A3 },
    { 0xE4A8, 0x92EE },
    { 0xE4A9, 0x928E },
    { 0xE4AA, 0x9282 },
    { 0xE4AB, 0x9295 },
    { 0xE4AC, 0x92A2 },
    { 0xE4AD, 0x927D },
    { 0xE4AE, 0x9288 },
    { 0xE4AF, 0x92A1 },
    { 0xE4B0, 0x928A },
    { 0xE4B1, 0x9286 },
    { 0xE4B2, 0x928C },
    { 0xE4B3, 0x9299 },
    { 0xE4B4, 0x92A7 },
    { 0xE4B5, 0x927E },
    { 0xE4B6, 0x9287 },
    { 0xE4B7, 0x92A9 },
    { 0xE4B8, 0x929D },
    { 0xE4B9, 0x928B },
    { 0xE4BA, 0x922D },
    { 0xE4BB, 0x969E },
    { 0xE4BC, 0x96A1 },
    { 0xE4BD, 0x96FF },
    { 0xE4BE, 0x9758 },
    { 0xE4BF, 0x977D },
    { 0xE4C0, 0x977A },
    { 0xE4C1, 0x977E },
    { 0xE4C2, 0x9783 },
    { 0xE4C3, 0x9780 },
    { 0xE4C4, 0x9782 },
    { 0xE4C5, 0x977B },
    { 0xE4C6, 0x9784 },
    { 0xE4C7, 0x9781 },
    { 0xE4C8, 0x977F },
    { 0xE4C9, 0x97CE },
    { 0xE4CA, 0x97CD },
    { 0xE4CB, 0x9816 },
    { 0xE4CC, 0x98AD },
    { 0xE4CD, 0x98AE },
    { 0xE4CE, 0x9902 },
    { 0xE4CF, 0x9900 },
    { 0xE4D0, 0x9907 },
    { 0xE4D1, 0x999D },
    { 0xE4D2, 0x999C },
    { 0xE4D3, 0x99C3 },
    { 0xE4D4, 0x99B9 },
    { 0xE4D5, 0x99BB },
    { 0xE4D6, 0x99BA },
    { 0xE4D7, 0x99C2 },
    { 0xE4D8, 0x99BD },
    { 0xE4D9, 0x99C7 },
    { 0xE4DA, 0x9AB1 },
    { 0xE4DB, 0x9AE3 },
    { 0xE4DC, 0x9AE7 },
    { 0xE4DD, 0x9B3E },
    { 0xE4DE, 0x9B3F },
    { 0xE4DF, 0x9B60 },
    { 0xE4E0, 0x9B61 },
    { 0xE4E1, 0x9B5F },
    { 0xE4E2, 0x9CF1 },
    { 0xE4E3, 0x9CF2 },
    { 0xE4E4, 0x9CF5 },
    { 0xE4E5, 0x9EA7 },
    { 0xE4E6, 0x50FF },
    { 0xE4E7, 0x5103 },
    { 0xE4E8, 0x5130 },
    { 0xE4E9, 0x50F8 },
    { 0xE4EA, 0x5106 },
    { 0xE4EB, 0x5107 },
    { 0xE4EC, 0x50F6 },
    { 0xE4ED, 0x50FE },
    { 0xE4EE, 0x510B },
    { 0xE4EF, 0x510C },
    { 0xE4F0, 0x50FD },
    { 0xE4F1, 0x510A },
    { 0xE4F2, 0x528B },
    { 0xE4F3, 0x528C },
    { 0xE4F4, 0x52F1 },
    { 0xE4F5, 0x52EF },
    { 0xE4F6, 0x5648 },
    { 0xE4F7, 0x5642 },
    { 0xE4F8, 0x564C },
    { 0xE4F9, 0x5635 },
    { 0xE4FA, 0x5641 },
    { 0xE4FB, 0x564A },
    { 0xE4FC, 0x5649 },
    { 0xE4FD, 0x5646 },
    { 0xE4FE, 0x5658 },
    { 0xE540, 0x565A },
    { 0xE541, 0x5640 },
    { 0xE542, 0x5633 },
    { 0xE543, 0x563D },
    { 0xE544, 0x562C },
    { 0xE545, 0x563E },
    { 0xE546, 0x5638 },
    { 0xE547, 0x562A },
    { 0xE548, 0x563A },
    { 0xE549, 0x571A },
    { 0xE54A, 0x58AB },
    { 0xE54B, 0x589D },
    { 0xE54C, 0x58B1 },
    { 0xE54D, 0x58A0 },
    { 0xE54E, 0x58A3 },
    { 0xE54F, 0x58AF },
    { 0xE550, 0x58AC },
    { 0xE551, 0x58A5 },
    { 0xE552, 0x58A1 },
    { 0xE553, 0x58FF },
    { 0xE554, 0x5AFF },
    { 0xE555, 0x5AF4 },
    { 0xE556, 0x5AFD },
    { 0xE557, 0x5AF7 },
    { 0xE558, 0x5AF6 },
    { 0xE559, 0x5B03 },
    { 0xE55A, 0x5AF8 },
    { 0xE55B, 0x5B02 },
    { 0xE55C, 0x5AF9 },
    { 0xE55D, 0x5B01 },
    { 0xE55E, 0x5B07 },
    { 0xE55F, 0x5B05 },
    { 0xE560, 0x5B0F },
    { 0xE561, 0x5C67 },
    { 0xE562, 0x5D99 },
    { 0xE563, 0x5D97 },
    { 0xE564, 0x5D9F },
    { 0xE565, 0x5D92 },
    { 0xE566, 0x5DA2 },
    { 0xE567, 0x5D93 },
    { 0xE568, 0x5D95 },
    { 0xE569, 0x5DA0 },
    { 0xE56A, 0x5D9C },
    { 0xE56B, 0x5DA1 },
    { 0xE56C, 0x5D9A },
    { 0xE56D, 0x5D9E },
    { 0xE56E, 0x5E69 },
    { 0xE56F, 0x5E5D },
    { 0xE570, 0x5E60 },
    { 0xE571, 0x5E5C },
    { 0xE572, 0x7DF3 },
    { 0xE573, 0x5EDB },
    { 0xE574, 0x5EDE },
    { 0xE575, 0x5EE1 },
    { 0xE576, 0x5F49 },
    { 0xE577, 0x5FB2 },
    { 0xE578, 0x618B },
    { 0xE579, 0x6183 },
    { 0xE57A, 0x6179 },
    { 0xE57B, 0x61B1 },
    { 0xE57C, 0x61B0 },
    { 0xE57D, 0x61A2 },
    { 0xE57E, 0x6189 },
    { 0xE5A1, 0x619B },
    { 0xE5A2, 0x6193 },
    { 0xE5A3, 0x61AF },
    { 0xE5A4, 0x61AD },
    { 0xE5A5, 0x619F },
    { 0xE5A6, 0x6192 },
    { 0xE5A7, 0x61AA },
    { 0xE5A8, 0x61A1 },
    { 0xE5A9, 0x618D },
    { 0xE5AA, 0x6166 },
    { 0xE5AB, 0x61B3 },
    { 0xE5AC, 0x622D },
    { 0xE5AD, 0x646E },
    { 0xE5AE, 0x6470 },
    { 0xE5AF, 0x6496 },
    { 0xE5B0, 0x64A0 },
    { 0xE5B1, 0x6485 },
    { 0xE5B2, 0x6497 },
    { 0xE5B3, 0x649C },
    { 0xE5B4, 0x648F },
    { 0xE5B5, 0x648B },
    { 0xE5B6, 0x648A },
    { 0xE5B7, 0x648C },
    { 0xE5B8, 0x64A3 },
    { 0xE5B9, 0x649F },
    { 0xE5BA, 0x6468 },
    { 0xE5BB, 0x64B1 },
    { 0xE5BC, 0x6498 },
    { 0xE5BD, 0x6576 },
    { 0xE5BE, 0x657A },
    { 0xE5BF, 0x6579 },
    { 0xE5C0, 0x657B },
    { 0xE5C1, 0x65B2 },
    { 0xE5C2, 0x65B3 },
    { 0xE5C3, 0x66B5 },
    { 0xE5C4, 0x66B0 },
    { 0xE5C5, 0x66A9 },
    { 0xE5C6, 0x66B2 },
    { 0xE5C7, 0x66B7 },
    { 0xE5C8, 0x66AA },
    { 0xE5C9, 0x66AF },
    { 0xE5CA, 0x6A00 },
    { 0xE5CB, 0x6A06 },
    { 0xE5CC, 0x6A17 },
    { 0xE5CD, 0x69E5 },
    { 0xE5CE, 0x69F8 },
    { 0xE5CF, 0x6A15 },
    { 0xE5D0, 0x69F1 },
    { 0xE5D1, 0x69E4 },
    { 0xE5D2, 0x6A20 },
    { 0xE5D3, 0x69FF },
    { 0xE5D4, 0x69EC },
    { 0xE5D5, 0x69E2 },
    { 0xE5D6, 0x6A1B },
    { 0xE5D7, 0x6A1D },
    { 0xE5D8, 0x69FE },
    { 0xE5D9, 0x6A27 },
    { 0xE5DA, 0x69F2 },
    { 0xE5DB, 0x69EE },
    { 0xE5DC, 0x6A14 },
    { 0xE5DD, 0x69F7 },
    { 0xE5DE, 0x69E7 },
    { 0xE5DF, 0x6A40 },
    { 0xE5E0, 0x6A08 },
    { 0xE5E1, 0x69E6 },
    { 0xE5E2, 0x69FB },
    { 0xE5E3, 0x6A0D },
    { 0xE5E4, 0x69FC },
    { 0xE5E5, 0x69EB },
    { 0xE5E6, 0x6A09 },
    { 0xE5E7, 0x6A04 },
    { 0xE5E8, 0x6A18 },
    { 0xE5E9, 0x6A25 },
    { 0xE5EA, 0x6A0F },
    { 0xE5EB, 0x69F6 },
    { 0xE5EC, 0x6A26 },
    { 0xE5ED, 0x6A07 },
    { 0xE5EE, 0x69F4 },
    { 0xE5EF, 0x6A16 },
    { 0xE5F0, 0x6B51 },
    { 0xE5F1, 0x6BA5 },
    { 0xE5F2, 0x6BA3 },
    { 0xE5F3, 0x6BA2 },
    { 0xE5F4, 0x6BA6 },
    { 0xE5F5, 0x6C01 },
    { 0xE5F6, 0x6C00 },
    { 0xE5F7, 0x6BFF },
    { 0xE5F8, 0x6C02 },
    { 0xE5F9, 0x6F41 },
    { 0xE5FA, 0x6F26 },
    { 0xE5FB, 0x6F7E },
    { 0xE5FC, 0x6F87 },
    { 0xE5FD, 0x6FC6 },
    { 0xE5FE, 0x6F92 },
    { 0xE640, 0x6F8D },
    { 0xE641, 0x6F89 },
    { 0xE642, 0x6F8C },
    { 0xE643, 0x6F62 },
    { 0xE644, 0x6F4F },
    { 0xE645, 0x6F85 },
    { 0xE646, 0x6F5A },
    { 0xE647, 0x6F96 },
    { 0xE648, 0x6F76 },
    { 0xE649, 0x6F6C },
    { 0xE64A, 0x6F82 },
    { 0xE64B, 0x6F55 },
    { 0xE64C, 0x6F72 },
    { 0xE64D, 0x6F52 },
    { 0xE64E, 0x6F50 },
    { 0xE64F, 0x6F57 },
    { 0xE650, 0x6F94 },
    { 0xE651, 0x6F93 },
    { 0xE652, 0x6F5D },
    { 0xE653, 0x6F00 },
    { 0xE654, 0x6F61 },
    { 0xE655, 0x6F6B },
    { 0xE656, 0x6F7D },
    { 0xE657, 0x6F67 },
    { 0xE658, 0x6F90 },
    { 0xE659, 0x6F53 },
    { 0xE65A, 0x6F8B },
    { 0xE65B, 0x6F69 },
    { 0xE65C, 0x6F7F },
    { 0xE65D, 0x6F95 },
    { 0xE65E, 0x6F63 },
    { 0xE65F, 0x6F77 },
    { 0xE660, 0x6F6A },
    { 0xE661, 0x6F7B },
    { 0xE662, 0x71B2 },
    { 0xE663, 0x71AF },
    { 0xE664, 0x719B },
    { 0xE665, 0x71B0 },
    { 0xE666, 0x71A0 },
    { 0xE667, 0x719A },
    { 0xE668, 0x71A9 },
    { 0xE669, 0x71B5 },
    { 0xE66A, 0x719D },
    { 0xE66B, 0x71A5 },
    { 0xE66C, 0x719E },
    { 0xE66D, 0x71A4 },
    { 0xE66E, 0x71A1 },
    { 0xE66F, 0x71AA },
    { 0xE670, 0x719C },
    { 0xE671, 0x71A7 },
    { 0xE672, 0x71B3 },
    { 0xE673, 0x7298 },
    { 0xE674, 0x729A },
    { 0xE675, 0x7358 },
    { 0xE676, 0x7352 },
    { 0xE677, 0x735E },
    { 0xE678, 0x735F },
    { 0xE679, 0x7360 },
    { 0xE67A, 0x735D },
    { 0xE67B, 0x735B },
    { 0xE67C, 0x7361 },
    { 0xE67D, 0x735A },
    { 0xE67E, 0x7359 },
    { 0xE6A1, 0x7362 },
    { 0xE6A2, 0x7487 },
    { 0xE6A3, 0x7489 },
    { 0xE6A4, 0x748A },
    { 0xE6A5, 0x7486 },
    { 0xE6A6, 0x7481 },
    { 0xE6A7, 0x747D },
    { 0xE6A8, 0x7485 },
    { 0xE6A9, 0x7488 },
    { 0xE6AA, 0x747C },
    { 0xE6AB, 0x7479 },
    { 0xE6AC, 0x7508 },
    { 0xE6AD, 0x7507 },
    { 0xE6AE, 0x757E },
    { 0xE6AF, 0x7625 },
    { 0xE6B0, 0x761E },
    { 0xE6B1, 0x7619 },
    { 0xE6B2, 0x761D },
    { 0xE6B3, 0x761C },
    { 0xE6B4, 0x7623 },
    { 0xE6B5, 0x761A },
    { 0xE6B6, 0x7628 },
    { 0xE6B7, 0x761B },
    { 0xE6B8, 0x769C },
    { 0xE6B9, 0x769D },
    { 0xE6BA, 0x769E },
    { 0xE6BB, 0x769B },
    { 0xE6BC, 0x778D },
    { 0xE6BD, 0x778F },
    { 0xE6BE, 0x7789 },
    { 0xE6BF, 0x7788 },
    { 0xE6C0, 0x78CD },
    { 0xE6C1, 0x78BB },
    { 0xE6C2, 0x78CF },
    { 0xE6C3, 0x78CC },
    { 0xE6C4, 0x78D1 },
    { 0xE6C5, 0x78CE },
    { 0xE6C6, 0x78D4 },
    { 0xE6C7, 0x78C8 },
    { 0xE6C8, 0x78C3 },
    { 0xE6C9, 0x78C4 },
    { 0xE6CA, 0x78C9 },
    { 0xE6CB, 0x799A },
    { 0xE6CC, 0x79A1 },
    { 0xE6CD, 0x79A0 },
    { 0xE6CE, 0x799C },
    { 0xE6CF, 0x79A2 },
    { 0xE6D0, 0x799B },
    { 0xE6D1, 0x6B76 },
    { 0xE6D2, 0x7A39 },
    { 0xE6D3, 0x7AB2 },
    { 0xE6D4, 0x7AB4 },
    { 0xE6D5, 0x7AB3 },
    { 0xE6D6, 0x7BB7 },
    { 0xE6D7, 0x7BCB },
    { 0xE6D8, 0x7BBE },
    { 0xE6D9, 0x7BAC },
    { 0xE6DA, 0x7BCE },
    { 0xE6DB, 0x7BAF },
    { 0xE6DC, 0x7BB9 },
    { 0xE6DD, 0x7BCA },
    { 0xE6DE, 0x7BB5 },
    { 0xE6DF, 0x7CC5 },
    { 0xE6E0, 0x7CC8 },
    { 0xE6E1, 0x7CCC },
    { 0xE6E2, 0x7CCB },
    { 0xE6E3, 0x7DF7 },
    { 0xE6E4, 0x7DDB },
    { 0xE6E5, 0x7DEA },
    { 0xE6E6, 0x7DE7 },
    { 0xE6E7, 0x7DD7 },
    { 0xE6E8, 0x7DE1 },
    { 0xE6E9, 0x7E03 },
    { 0xE6EA, 0x7DFA },
    { 0xE6EB, 0x7DE6 },
    { 0xE6EC, 0x7DF6 },
    { 0xE6ED, 0x7DF1 },
    { 0xE6EE, 0x7DF0 },
    { 0xE6EF, 0x7DEE },
    { 0xE6F0, 0x7DDF },
    { 0xE6F1, 0x7F76 },
    { 0xE6F2, 0x7FAC },
    { 0xE6F3, 0x7FB0 },
    { 0xE6F4, 0x7FAD },
    { 0xE6F5, 0x7FED },
    { 0xE6F6, 0x7FEB },
    { 0xE6F7, 0x7FEA },
    { 0xE6F8, 0x7FEC },
    { 0xE6F9, 0x7FE6 },
    { 0xE6FA, 0x7FE8 },
    { 0xE6FB, 0x8064 },
    { 0xE6FC, 0x8067 },
    { 0xE6FD, 0x81A3 },
    { 0xE6FE, 0x819F },
    { 0xE740, 0x819E },
    { 0xE741, 0x8195 },
    { 0xE742, 0x81A2 },
    { 0xE743, 0x8199 },
    { 0xE744, 0x8197 },
    { 0xE745, 0x8216 },
    { 0xE746, 0x824F },
    { 0xE747, 0x8253 },
    { 0xE748, 0x8252 },
    { 0xE749, 0x8250 },
    { 0xE74A, 0x824E },
    { 0xE74B, 0x8251 },
    { 0xE74C, 0x8524 },
    { 0xE74D, 0x853B },
    { 0xE74E, 0x850F },
    { 0xE74F, 0x8500 },
    { 0xE750, 0x8529 },
    { 0xE751, 0x850E },
    { 0xE752, 0x8509 },
    { 0xE753, 0x850D },
    { 0xE754, 0x851F },
    { 0xE755, 0x850A },
    { 0xE756, 0x8527 },
    { 0xE757, 0x851C },
    { 0xE758, 0x84FB },
    { 0xE759, 0x852B },
    { 0xE75A, 0x84FA },
    { 0xE75B, 0x8508 },
    { 0xE75C, 0x850C },
    { 0xE75D, 0x84F4 },
    { 0xE75E, 0x852A },
    { 0xE75F, 0x84F2 },
    { 0xE760, 0x8515 },
    { 0xE761, 0x84F7 },
    { 0xE762, 0x84EB },
    { 0xE763, 0x84F3 },
    { 0xE764, 0x84FC },
    { 0xE765, 0x8512 },
    { 0xE766, 0x84EA },
    { 0xE767, 0x84E9 },
    { 0xE768, 0x8516 },
    { 0xE769, 0x84FE },
    { 0xE76A, 0x8528 },
    { 0xE76B, 0x851D },
    { 0xE76C, 0x852E },
    { 0xE76D, 0x8502 },
    { 0xE76E, 0x84FD },
    { 0xE76F, 0x851E },
    { 0xE770, 0x84F6 },
    { 0xE771, 0x8531 },
    { 0xE772, 0x8526 },
    { 0xE773, 0x84E7 },
    { 0xE774, 0x84E8 },
    { 0xE775, 0x84F0 },
    { 0xE776, 0x84EF },
    { 0xE777, 0x84F9 },
    { 0xE778, 0x8518 },
    { 0xE779, 0x8520 },
    { 0xE77A, 0x8530 },
    { 0xE77B, 0x850B },
    { 0xE77C, 0x8519 },
    { 0xE77D, 0x852F },
    { 0xE77E, 0x8662 },
    { 0xE7A1, 0x8756 },
    { 0xE7A2, 0x8763 },
    { 0xE7A3, 0x8764 },
    { 0xE7A4, 0x8777 },
    { 0xE7A5, 0x87E1 },
    { 0xE7A6, 0x8773 },
    { 0xE7A7, 0x8758 },
    { 0xE7A8, 0x8754 },
    { 0xE7A9, 0x875B },
    { 0xE7AA, 0x8752 },
    { 0xE7AB, 0x8761 },
    { 0xE7AC, 0x875A },
    { 0xE7AD, 0x8751 },
    { 0xE7AE, 0x875E },
    { 0xE7AF, 0x876D },
    { 0xE7B0, 0x876A },
    { 0xE7B1, 0x8750 },
    { 0xE7B2, 0x874E },
    { 0xE7B3, 0x875F },
    { 0xE7B4, 0x875D },
    { 0xE7B5, 0x876F },
    { 0xE7B6, 0x876C },
    { 0xE7B7, 0x877A },
    { 0xE7B8, 0x876E },
    { 0xE7B9, 0x875C },
    { 0xE7BA, 0x8765 },
    { 0xE7BB, 0x874F },
    { 0xE7BC, 0x877B },
    { 0xE7BD, 0x8775 },
    { 0xE7BE, 0x8762 },
    { 0xE7BF, 0x8767 },
    { 0xE7C0, 0x8769 },
    { 0xE7C1, 0x885A },
    { 0xE7C2, 0x8905 },
    { 0xE7C3, 0x890C },
    { 0xE7C4, 0x8914 },
    { 0xE7C5, 0x890B },
    { 0xE7C6, 0x8917 },
    { 0xE7C7, 0x8918 },
    { 0xE7C8, 0x8919 },
    { 0xE7C9, 0x8906 },
    { 0xE7CA, 0x8916 },
    { 0xE7CB, 0x8911 },
    { 0xE7CC, 0x890E },
    { 0xE7CD, 0x8909 },
    { 0xE7CE, 0x89A2 },
    { 0xE7CF, 0x89A4 },
    { 0xE7D0, 0x89A3 },
    { 0xE7D1, 0x89ED },
    { 0xE7D2, 0x89F0 },
    { 0xE7D3, 0x89EC },
    { 0xE7D4, 0x8ACF },
    { 0xE7D5, 0x8AC6 },
    { 0xE7D6, 0x8AB8 },
    { 0xE7D7, 0x8AD3 },
    { 0xE7D8, 0x8AD1 },
    { 0xE7D9, 0x8AD4 },
    { 0xE7DA, 0x8AD5 },
    { 0xE7DB, 0x8ABB },
    { 0xE7DC, 0x8AD7 },
    { 0xE7DD, 0x8ABE },
    { 0xE7DE, 0x8AC0 },
    { 0xE7DF, 0x8AC5 },
    { 0xE7E0, 0x8AD8 },
    { 0xE7E1, 0x8AC3 },
    { 0xE7E2, 0x8ABA },
    { 0xE7E3, 0x8ABD },
    { 0xE7E4, 0x8AD9 },
    { 0xE7E5, 0x8C3E },
    { 0xE7E6, 0x8C4D },
    { 0xE7E7, 0x8C8F },
    { 0xE7E8, 0x8CE5 },
    { 0xE7E9, 0x8CDF },
    { 0xE7EA, 0x8CD9 },
    { 0xE7EB, 0x8CE8 },
    { 0xE7EC, 0x8CDA },
    { 0xE7ED, 0x8CDD },
    { 0xE7EE, 0x8CE7 },
    { 0xE7EF, 0x8DA0 },
    { 0xE7F0, 0x8D9C },
    { 0xE7F1, 0x8DA1 },
    { 0xE7F2, 0x8D9B },
    { 0xE7F3, 0x8E20 },
    { 0xE7F4, 0x8E23 },
    { 0xE7F5, 0x8E25 },
    { 0xE7F6, 0x8E24 },
    { 0xE7F7, 0x8E2E },
    { 0xE7F8, 0x8E15 },
    { 0xE7F9, 0x8E1B },
    { 0xE7FA, 0x8E16 },
    { 0xE7FB, 0x8E11 },
    { 0xE7FC, 0x8E19 },
    { 0xE7FD, 0x8E26 },
    { 0xE7FE, 0x8E27 },
    { 0xE840, 0x8E14 },
    { 0xE841, 0x8E12 },
    { 0xE842, 0x8E18 },
    { 0xE843, 0x8E13 },
    { 0xE844, 0x8E1C },
    { 0xE845, 0x8E17 },
    { 0xE846, 0x8E1A },
    { 0xE847, 0x8F2C },
    { 0xE848, 0x8F24 },
    { 0xE849, 0x8F18 },
    { 0xE84A, 0x8F1A },
    { 0xE84B, 0x8F20 },
    { 0xE84C, 0x8F23 },
    { 0xE84D, 0x8F16 },
    { 0xE84E, 0x8F17 },
    { 0xE84F, 0x9073 },
    { 0xE850, 0x9070 },
    { 0xE851, 0x906F },
    { 0xE852, 0x9067 },
    { 0xE853, 0x906B },
    { 0xE854, 0x912F },
    { 0xE855, 0x912B },
    { 0xE856, 0x9129 },
    { 0xE857, 0x912A },
    { 0xE858, 0x9132 },
    { 0xE859, 0x9126 },
    { 0xE85A, 0x912E },
    { 0xE85B, 0x9185 },
    { 0xE85C, 0x9186 },
    { 0xE85D, 0x918A },
    { 0xE85E, 0x9181 },
    { 0xE85F, 0x9182 },
    { 0xE860, 0x9184 },
    { 0xE861, 0x9180 },
    { 0xE862, 0x92D0 },
    { 0xE863, 0x92C3 },
    { 0xE864, 0x92C4 },
    { 0xE865, 0x92C0 },
    { 0xE866, 0x92D9 },
    { 0xE867, 0x92B6 },
    { 0xE868, 0x92CF },
    { 0xE869, 0x92F1 },
    { 0xE86A, 0x92DF },
    { 0xE86B, 0x92D8 },
    { 0xE86C, 0x92E9 },
    { 0xE86D, 0x92D7 },
    { 0xE86E, 0x92DD },
    { 0xE86F, 0x92CC },
    { 0xE870, 0x92EF },
    { 0xE871, 0x92C2 },
    { 0xE872, 0x92E8 },
    { 0xE873, 0x92CA },
    { 0xE874, 0x92C8 },
    { 0xE875, 0x92CE },
    { 0xE876, 0x92E6 },
    { 0xE877, 0x92CD },
    { 0xE878, 0x92D5 },
    { 0xE879, 0x92C9 },
    { 0xE87A, 0x92E0 },
    { 0xE87B, 0x92DE },
    { 0xE87C, 0x92E7 },
    { 0xE87D, 0x92D1 },
    { 0xE87E, 0x92D3 },
    { 0xE8A1, 0x92B5 },
    { 0xE8A2, 0x92E1 },
    { 0xE8A3, 0x92C6 },
    { 0xE8A4, 0x92B4 },
    { 0xE8A5, 0x957C },
    { 0xE8A6, 0x95AC },
    { 0xE8A7, 0x95AB },
    { 0xE8A8, 0x95AE },
    { 0xE8A9, 0x95B0 },
    { 0xE8AA, 0x96A4 },
    { 0xE8AB, 0x96A2 },
    { 0xE8AC, 0x96D3 },
    { 0xE8AD, 0x9705 },
    { 0xE8AE, 0x9708 },
    { 0xE8AF, 0x9702 },
    { 0xE8B0, 0x975A },
    { 0xE8B1, 0x978A },
    { 0xE8B2, 0x978E },
    { 0xE8B3, 0x9788 },
    { 0xE8B4, 0x97D0 },
    { 0xE8B5, 0x97CF },
    { 0xE8B6, 0x981E },
    { 0xE8B7, 0x981D },
    { 0xE8B8, 0x9826 },
    { 0xE8B9, 0x9829 },
    { 0xE8BA, 0x9828 },
    { 0xE8BB, 0x9820 },
    { 0xE8BC, 0x981B },
    { 0xE8BD, 0x9827 },
    { 0xE8BE, 0x98B2 },
    { 0xE8BF, 0x9908 },
    { 0xE8C0, 0x98FA },
    { 0xE8C1, 0x9911 },
    { 0xE8C2, 0x9914 },
    { 0xE8C3, 0x9916 },
    { 0xE8C4, 0x9917 },
    { 0xE8C5, 0x9915 },
    { 0xE8C6, 0x99DC },
    { 0xE8C7, 0x99CD },
    { 0xE8C8, 0x99CF },
    { 0xE8C9, 0x99D3 },
    { 0xE8CA, 0x99D4 },
    { 0xE8CB, 0x99CE },
    { 0xE8CC, 0x99C9 },
    { 0xE8CD, 0x99D6 },
    { 0xE8CE, 0x99D8 },
    { 0xE8CF, 0x99CB },
    { 0xE8D0, 0x99D7 },
    { 0xE8D1, 0x99CC },
    { 0xE8D2, 0x9AB3 },
    { 0xE8D3, 0x9AEC },
    { 0xE8D4, 0x9AEB },
    { 0xE8D5, 0x9AF3 },
    { 0xE8D6, 0x9AF2 },
    { 0xE8D7, 0x9AF1 },
    { 0xE8D8, 0x9B46 },
    { 0xE8D9, 0x9B43 },
    { 0xE8DA, 0x9B67 },
    { 0xE8DB, 0x9B74 },
    { 0xE8DC, 0x9B71 },
    { 0xE8DD, 0x9B66 },
    { 0xE8DE, 0x9B76 },
    { 0xE8DF, 0x9B75 },
    { 0xE8E0, 0x9B70 },
    { 0xE8E1, 0x9B68 },
    { 0xE8E2, 0x9B64 },
    { 0xE8E3, 0x9B6C },
    { 0xE8E4, 0x9CFC },
    { 0xE8E5, 0x9CFA },
    { 0xE8E6, 0x9CFD },
    { 0xE8E7, 0x9CFF },
    { 0xE8E8, 0x9CF7 },
    { 0xE8E9, 0x9D07 },
    { 0xE8EA, 0x9D00 },
    { 0xE8EB, 0x9CF9 },
    { 0xE8EC, 0x9CFB },
    { 0xE8ED, 0x9D08 },
    { 0xE8EE, 0x9D05 },
    { 0xE8EF, 0x9D04 },
    { 0xE8F0, 0x9E83 },
    { 0xE8F1, 0x9ED3 },
    { 0xE8F2, 0x9F0F },
    { 0xE8F3, 0x9F10 },
    { 0xE8F4, 0x511C },
    { 0xE8F5, 0x5113 },
    { 0xE8F6, 0x5117 },
    { 0xE8F7, 0x511A },
    { 0xE8F8, 0x5111 },
    { 0xE8F9, 0x51DE },
    { 0xE8FA, 0x5334 },
    { 0xE8FB, 0x53E1 },
    { 0xE8FC, 0x5670 },
    { 0xE8FD, 0x5660 },
    { 0xE8FE, 0x566E },
    { 0xE940, 0x5673 },
    { 0xE941, 0x5666 },
    { 0xE942, 0x5663 },
    { 0xE943, 0x566D },
    { 0xE944, 0x5672 },
    { 0xE945, 0x565E },
    { 0xE946, 0x5677 },
    { 0xE947, 0x571C },
    { 0xE948, 0x571B },
    { 0xE949, 0x58C8 },
    { 0xE94A, 0x58BD },
    { 0xE94B, 0x58C9 },
    { 0xE94C, 0x58BF },
    { 0xE94D, 0x58BA },
    { 0xE94E, 0x58C2 },
    { 0xE94F, 0x58BC },
    { 0xE950, 0x58C6 },
    { 0xE951, 0x5B17 },
    { 0xE952, 0x5B19 },
    { 0xE953, 0x5B1B },
    { 0xE954, 0x5B21 },
    { 0xE955, 0x5B14 },
    { 0xE956, 0x5B13 },
    { 0xE957, 0x5B10 },
    { 0xE958, 0x5B16 },
    { 0xE959, 0x5B28 },
    { 0xE95A, 0x5B1A },
    { 0xE95B, 0x5B20 },
    { 0xE95C, 0x5B1E },
    { 0xE95D, 0x5BEF },
    { 0xE95E, 0x5DAC },
    { 0xE95F, 0x5DB1 },
    { 0xE960, 0x5DA9 },
    { 0xE961, 0x5DA7 },
    { 0xE962, 0x5DB5 },
    { 0xE963, 0x5DB0 },
    { 0xE964, 0x5DAE },
    { 0xE965, 0x5DAA },
    { 0xE966, 0x5DA8 },
    { 0xE967, 0x5DB2 },
    { 0xE968, 0x5DAD },
    { 0xE969, 0x5DAF },
    { 0xE96A, 0x5DB4 },
    { 0xE96B, 0x5E67 },
    { 0xE96C, 0x5E68 },
    { 0xE96D, 0x5E66 },
    { 0xE96E, 0x5E6F },
    { 0xE96F, 0x5EE9 },
    { 0xE970, 0x5EE7 },
    { 0xE971, 0x5EE6 },
    { 0xE972, 0x5EE8 },
    { 0xE973, 0x5EE5 },
    { 0xE974, 0x5F4B },
    { 0xE975, 0x5FBC },
    { 0xE976, 0x619D },
    { 0xE977, 0x61A8 },
    { 0xE978, 0x6196 },
    { 0xE979, 0x61C5 },
    { 0xE97A, 0x61B4 },
    { 0xE97B, 0x61C6 },
    { 0xE97C, 0x61C1 },
    { 0xE97D, 0x61CC },
    { 0xE97E, 0x61BA },
    { 0xE9A1, 0x61BF },
    { 0xE9A2, 0x61B8 },
    { 0xE9A3, 0x618C },
    { 0xE9A4, 0x64D7 },
    { 0xE9A5, 0x64D6 },
    { 0xE9A6, 0x64D0 },
    { 0xE9A7, 0x64CF },
    { 0xE9A8, 0x64C9 },
    { 0xE9A9, 0x64BD },
    { 0xE9AA, 0x6489 },
    { 0xE9AB, 0x64C3 },
    { 0xE9AC, 0x64DB },
    { 0xE9AD, 0x64F3 },
    { 0xE9AE, 0x64D9 },
    { 0xE9AF, 0x6533 },
    { 0xE9B0, 0x657F },
    { 0xE9B1, 0x657C },
    { 0xE9B2, 0x65A2 },
    { 0xE9B3, 0x66C8 },
    { 0xE9B4, 0x66BE },
    { 0xE9B5, 0x66C0 },
    { 0xE9B6, 0x66CA },
    { 0xE9B7, 0x66CB },
    { 0xE9B8, 0x66CF },
    { 0xE9B9, 0x66BD },
    { 0xE9BA, 0x66BB },
    { 0xE9BB, 0x66BA },
    { 0xE9BC, 0x66CC },
    { 0xE9BD, 0x6723 },
    { 0xE9BE, 0x6A34 },
    { 0xE9BF, 0x6A66 },
    { 0xE9C0, 0x6A49 },
    { 0xE9C1, 0x6A67 },
    { 0xE9C2, 0x6A32 },
    { 0xE9C3, 0x6A68 },
    { 0xE9C4, 0x6A3E },
    { 0xE9C5, 0x6A5D },
    { 0xE9C6, 0x6A6D },
    { 0xE9C7, 0x6A76 },
    { 0xE9C8, 0x6A5B },
    { 0xE9C9, 0x6A51 },
    { 0xE9CA, 0x6A28 },
    { 0xE9CB, 0x6A5A },
    { 0xE9CC, 0x6A3B },
    { 0xE9CD, 0x6A3F },
    { 0xE9CE, 0x6A41 },
    { 0xE9CF, 0x6A6A },
    { 0xE9D0, 0x6A64 },
    { 0xE9D1, 0x6A50 },
    { 0xE9D2, 0x6A4F },
    { 0xE9D3, 0x6A54 },
    { 0xE9D4, 0x6A6F },
    { 0xE9D5, 0x6A69 },
    { 0xE9D6, 0x6A60 },
    { 0xE9D7, 0x6A3C },
    { 0xE9D8, 0x6A5E },
    { 0xE9D9, 0x6A56 },
    { 0xE9DA, 0x6A55 },
    { 0xE9DB, 0x6A4D },
    { 0xE9DC, 0x6A4E },
    { 0xE9DD, 0x6A46 },
    { 0xE9DE, 0x6B55 },
    { 0xE9DF, 0x6B54 },
    { 0xE9E0, 0x6B56 },
    { 0xE9E1, 0x6BA7 },
    { 0xE9E2, 0x6BAA },
    { 0xE9E3, 0x6BAB },
    { 0xE9E4, 0x6BC8 },
    { 0xE9E5, 0x6BC7 },
    { 0xE9E6, 0x6C04 },
    { 0xE9E7, 0x6C03 },
    { 0xE9E8, 0x6C06 },
    { 0xE9E9, 0x6FAD },
    { 0xE9EA, 0x6FCB },
    { 0xE9EB, 0x6FA3 },
    { 0xE9EC, 0x6FC7 },
    { 0xE9ED, 0x6FBC },
    { 0xE9EE, 0x6FCE },
    { 0xE9EF, 0x6FC8 },
    { 0xE9F0, 0x6F5E },
    { 0xE9F1, 0x6FC4 },
    { 0xE9F2, 0x6FBD },
    { 0xE9F3, 0x6F9E },
    { 0xE9F4, 0x6FCA },
    { 0xE9F5, 0x6FA8 },
    { 0xE9F6, 0x7004 },
    { 0xE9F7, 0x6FA5 },
    { 0xE9F8, 0x6FAE },
    { 0xE9F9, 0x6FBA },
    { 0xE9FA, 0x6FAC },
    { 0xE9FB, 0x6FAA },
    { 0xE9FC, 0x6FCF },
    { 0xE9FD, 0x6FBF },
    { 0xE9FE, 0x6FB8 },
    { 0xEA40, 0x6FA2 },
    { 0xEA41, 0x6FC9 },
    { 0xEA42, 0x6FAB },
    { 0xEA43, 0x6FCD },
    { 0xEA44, 0x6FAF },
    { 0xEA45, 0x6FB2 },
    { 0xEA46, 0x6FB0 },
    { 0xEA47, 0x71C5 },
    { 0xEA48, 0x71C2 },
    { 0xEA49, 0x71BF },
    { 0xEA4A, 0x71B8 },
    { 0xEA4B, 0x71D6 },
    { 0xEA4C, 0x71C0 },
    { 0xEA4D, 0x71C1 },
    { 0xEA4E, 0x71CB },
    { 0xEA4F, 0x71D4 },
    { 0xEA50, 0x71CA },
    { 0xEA51, 0x71C7 },
    { 0xEA52, 0x71CF },
    { 0xEA53, 0x71BD },
    { 0xEA54, 0x71D8 },
    { 0xEA55, 0x71BC },
    { 0xEA56, 0x71C6 },
    { 0xEA57, 0x71DA },
    { 0xEA58, 0x71DB },
    { 0xEA59, 0x729D },
    { 0xEA5A, 0x729E },
    { 0xEA5B, 0x7369 },
    { 0xEA5C, 0x7366 },
    { 0xEA5D, 0x7367 },
    { 0xEA5E, 0x736C },
    { 0xEA5F, 0x7365 },
    { 0xEA60, 0x736B },
    { 0xEA61, 0x736A },
    { 0xEA62, 0x747F },
    { 0xEA63, 0x749A },
    { 0xEA64, 0x74A0 },
    { 0xEA65, 0x7494 },
    { 0xEA66, 0x7492 },
    { 0xEA67, 0x7495 },
    { 0xEA68, 0x74A1 },
    { 0xEA69, 0x750B },
    { 0xEA6A, 0x7580 },
    { 0xEA6B, 0x762F },
    { 0xEA6C, 0x762D },
    { 0xEA6D, 0x7631 },
    { 0xEA6E, 0x763D },
    { 0xEA6F, 0x7633 },
    { 0xEA70, 0x763C },
    { 0xEA71, 0x7635 },
    { 0xEA72, 0x7632 },
    { 0xEA73, 0x7630 },
    { 0xEA74, 0x76BB },
    { 0xEA75, 0x76E6 },
    { 0xEA76, 0x779A },
    { 0xEA77, 0x779D },
    { 0xEA78, 0x77A1 },
    { 0xEA79, 0x779C },
    { 0xEA7A, 0x779B },
    { 0xEA7B, 0x77A2 },
    { 0xEA7C, 0x77A3 },
    { 0xEA7D, 0x7795 },
    { 0xEA7E, 0x7799 },
    { 0xEAA1, 0x7797 },
    { 0xEAA2, 0x78DD },
    { 0xEAA3, 0x78E9 },
    { 0xEAA4, 0x78E5 },
    { 0xEAA5, 0x78EA },
    { 0xEAA6, 0x78DE },
    { 0xEAA7, 0x78E3 },
    { 0xEAA8, 0x78DB },
    { 0xEAA9, 0x78E1 },
    { 0xEAAA, 0x78E2 },
    { 0xEAAB, 0x78ED },
    { 0xEAAC, 0x78DF },
    { 0xEAAD, 0x78E0 },
    { 0xEAAE, 0x79A4 },
    { 0xEAAF, 0x7A44 },
    { 0xEAB0, 0x7A48 },
    { 0xEAB1, 0x7A47 },
    { 0xEAB2, 0x7AB6 },
    { 0xEAB3, 0x7AB8 },
    { 0xEAB4, 0x7AB5 },
    { 0xEAB5, 0x7AB1 },
    { 0xEAB6, 0x7AB7 },
    { 0xEAB7, 0x7BDE },
    { 0xEAB8, 0x7BE3 },
    { 0xEAB9, 0x7BE7 },
    { 0xEABA, 0x7BDD },
    { 0xEABB, 0x7BD5 },
    { 0xEABC, 0x7BE5 },
    { 0xEABD, 0x7BDA },
    { 0xEABE, 0x7BE8 },
    { 0xEABF, 0x7BF9 },
    { 0xEAC0, 0x7BD4 },
    { 0xEAC1, 0x7BEA },
    { 0xEAC2, 0x7BE2 },
    { 0xEAC3, 0x7BDC },
    { 0xEAC4, 0x7BEB },
    { 0xEAC5, 0x7BD8 },
    { 0xEAC6, 0x7BDF },
    { 0xEAC7, 0x7CD2 },
    { 0xEAC8, 0x7CD4 },
    { 0xEAC9, 0x7CD7 },
    { 0xEACA, 0x7CD0 },
    { 0xEACB, 0x7CD1 },
    { 0xEACC, 0x7E12 },
    { 0xEACD, 0x7E21 },
    { 0xEACE, 0x7E17 },
    { 0xEACF, 0x7E0C },
    { 0xEAD0, 0x7E1F },
    { 0xEAD1, 0x7E20 },
    { 0xEAD2, 0x7E13 },
    { 0xEAD3, 0x7E0E },
    { 0xEAD4, 0x7E1C },
    { 0xEAD5, 0x7E15 },
    { 0xEAD6, 0x7E1A },
    { 0xEAD7, 0x7E22 },
    { 0xEAD8, 0x7E0B },
    { 0xEAD9, 0x7E0F },
    { 0xEADA, 0x7E16 },
    { 0xEADB, 0x7E0D },
    { 0xEADC, 0x7E14 },
    { 0xEADD, 0x7E25 },
    { 0xEADE, 0x7E24 },
    { 0xEADF, 0x7F43 },
    { 0xEAE0, 0x7F7B },
    { 0xEAE1, 0x7F7C },
    { 0xEAE2, 0x7F7A },
    { 0xEAE3, 0x7FB1 },
    { 0xEAE4, 0x7FEF },
    { 0xEAE5, 0x802A },
    { 0xEAE6, 0x8029 },
    { 0xEAE7, 0x806C },
    { 0xEAE8, 0x81B1 },
    { 0xEAE9, 0x81A6 },
    { 0xEAEA, 0x81AE },
    { 0xEAEB, 0x81B9 },
    { 0xEAEC, 0x81B5 },
    { 0xEAED, 0x81AB },
    { 0xEAEE, 0x81B0 },
    { 0xEAEF, 0x81AC },
    { 0xEAF0, 0x81B4 },
    { 0xEAF1, 0x81B2 },
    { 0xEAF2, 0x81B7 },
    { 0xEAF3, 0x81A7 },
    { 0xEAF4, 0x81F2 },
    { 0xEAF5, 0x8255 },
    { 0xEAF6, 0x8256 },
    { 0xEAF7, 0x8257 },
    { 0xEAF8, 0x8556 },
    { 0xEAF9, 0x8545 },
    { 0xEAFA, 0x856B },
    { 0xEAFB, 0x854D },
    { 0xEAFC, 0x8553 },
    { 0xEAFD, 0x8561 },
    { 0xEAFE, 0x8558 },
    { 0xEB40, 0x8540 },
    { 0xEB41, 0x8546 },
    { 0xEB42, 0x8564 },
    { 0xEB43, 0x8541 },
    { 0xEB44, 0x8562 },
    { 0xEB45, 0x8544 },
    { 0xEB46, 0x8551 },
    { 0xEB47, 0x8547 },
    { 0xEB48, 0x8563 },
    { 0xEB49, 0x853E },
    { 0xEB4A, 0x855B },
    { 0xEB4B, 0x8571 },
    { 0xEB4C, 0x854E },
    { 0xEB4D, 0x856E },
    { 0xEB4E, 0x8575 },
    { 0xEB4F, 0x8555 },
    { 0xEB50, 0x8567 },
    { 0xEB51, 0x8560 },
    { 0xEB52, 0x858C },
    { 0xEB53, 0x8566 },
    { 0xEB54, 0x855D },
    { 0xEB55, 0x8554 },
    { 0xEB56, 0x8565 },
    { 0xEB57, 0x856C },
    { 0xEB58, 0x8663 },
    { 0xEB59, 0x8665 },
    { 0xEB5A, 0x8664 },
    { 0xEB5B, 0x879B },
    { 0xEB5C, 0x878F },
    { 0xEB5D, 0x8797 },
    { 0xEB5E, 0x8793 },
    { 0xEB5F, 0x8792 },
    { 0xEB60, 0x8788 },
    { 0xEB61, 0x8781 },
    { 0xEB62, 0x8796 },
    { 0xEB63, 0x8798 },
    { 0xEB64, 0x8779 },
    { 0xEB65, 0x8787 },
    { 0xEB66, 0x87A3 },
    { 0xEB67, 0x8785 },
    { 0xEB68, 0x8790 },
    { 0xEB69, 0x8791 },
    { 0xEB6A, 0x879D },
    { 0xEB6B, 0x8784 },
    { 0xEB6C, 0x8794 },
    { 0xEB6D, 0x879C },
    { 0xEB6E, 0x879A },
    { 0xEB6F, 0x8789 },
    { 0xEB70, 0x891E },
    { 0xEB71, 0x8926 },
    { 0xEB72, 0x8930 },
    { 0xEB73, 0x892D },
    { 0xEB74, 0x892E },
    { 0xEB75, 0x8927 },
    { 0xEB76, 0x8931 },
    { 0xEB77, 0x8922 },
    { 0xEB78, 0x8929 },
    { 0xEB79, 0x8923 },
    { 0xEB7A, 0x892F },
    { 0xEB7B, 0x892C },
    { 0xEB7C, 0x891F },
    { 0xEB7D, 0x89F1 },
    { 0xEB7E, 0x8AE0 },
    { 0xEBA1, 0x8AE2 },
    { 0xEBA2, 0x8AF2 },
    { 0xEBA3, 0x8AF4 },
    { 0xEBA4, 0x8AF5 },
    { 0xEBA5, 0x8ADD },
    { 0xEBA6, 0x8B14 },
    { 0xEBA7, 0x8AE4 },
    { 0xEBA8, 0x8ADF },
    { 0xEBA9, 0x8AF0 },
    { 0xEBAA, 0x8AC8 },
    { 0xEBAB, 0x8ADE },
    { 0xEBAC, 0x8AE1 },
    { 0xEBAD, 0x8AE8 },
    { 0xEBAE, 0x8AFF },
    { 0xEBAF, 0x8AEF },
    { 0xEBB0, 0x8AFB },
    { 0xEBB1, 0x8C91 },
    { 0xEBB2, 0x8C92 },
    { 0xEBB3, 0x8C90 },
    { 0xEBB4, 0x8CF5 },
    { 0xEBB5, 0x8CEE },
    { 0xEBB6, 0x8CF1 },
    { 0xEBB7, 0x8CF0 },
    { 0xEBB8, 0x8CF3 },
    { 0xEBB9, 0x8D6C },
    { 0xEBBA, 0x8D6E },
    { 0xEBBB, 0x8DA5 },
    { 0xEBBC, 0x8DA7 },
    { 0xEBBD, 0x8E33 },
    { 0xEBBE, 0x8E3E },
    { 0xEBBF, 0x8E38 },
    { 0xEBC0, 0x8E40 },
    { 0xEBC1, 0x8E45 },
    { 0xEBC2, 0x8E36 },
    { 0xEBC3, 0x8E3C },
    { 0xEBC4, 0x8E3D },
    { 0xEBC5, 0x8E41 },
    { 0xEBC6, 0x8E30 },
    { 0xEBC7, 0x8E3F },
    { 0xEBC8, 0x8EBD },
    { 0xEBC9, 0x8F36 },
    { 0xEBCA, 0x8F2E },
    { 0xEBCB, 0x8F35 },
    { 0xEBCC, 0x8F32 },
    { 0xEBCD, 0x8F39 },
    { 0xEBCE, 0x8F37 },
    { 0xEBCF, 0x8F34 },
    { 0xEBD0, 0x9076 },
    { 0xEBD1, 0x9079 },
    { 0xEBD2, 0x907B },
    { 0xEBD3, 0x9086 },
    { 0xEBD4, 0x90FA },
    { 0xEBD5, 0x9133 },
    { 0xEBD6, 0x9135 },
    { 0xEBD7, 0x9136 },
    { 0xEBD8, 0x9193 },
    { 0xEBD9, 0x9190 },
    { 0xEBDA, 0x9191 },
    { 0xEBDB, 0x918D },
    { 0xEBDC, 0x918F },
    { 0xEBDD, 0x9327 },
    { 0xEBDE, 0x931E },
    { 0xEBDF, 0x9308 },
    { 0xEBE0, 0x931F },
    { 0xEBE1, 0x9306 },
    { 0xEBE2, 0x930F },
    { 0xEBE3, 0x937A },
    { 0xEBE4, 0x9338 },
    { 0xEBE5, 0x933C },
    { 0xEBE6, 0x931B },
    { 0xEBE7, 0x9323 },
    { 0xEBE8, 0x9312 },
    { 0xEBE9, 0x9301 },
    { 0xEBEA, 0x9346 },
    { 0xEBEB, 0x932D },
    { 0xEBEC, 0x930E },
    { 0xEBED, 0x930D },
    { 0xEBEE, 0x92CB },
    { 0xEBEF, 0x931D },
    { 0xEBF0, 0x92FA },
    { 0xEBF1, 0x9325 },
    { 0xEBF2, 0x9313 },
    { 0xEBF3, 0x92F9 },
    { 0xEBF4, 0x92F7 },
    { 0xEBF5, 0x9334 },
    { 0xEBF6, 0x9302 },
    { 0xEBF7, 0x9324 },
    { 0xEBF8, 0x92FF },
    { 0xEBF9, 0x9329 },
    { 0xEBFA, 0x9339 },
    { 0xEBFB, 0x9335 },
    { 0xEBFC, 0x932A },
    { 0xEBFD, 0x9314 },
    { 0xEBFE, 0x930C },
    { 0xEC40, 0x930B },
    { 0xEC41, 0x92FE },
    { 0xEC42, 0x9309 },
    { 0xEC43, 0x9300 },
    { 0xEC44, 0x92FB },
    { 0xEC45, 0x9316 },
    { 0xEC46, 0x95BC },
    { 0xEC47, 0x95CD },
    { 0xEC48, 0x95BE },
    { 0xEC49, 0x95B9 },
    { 0xEC4A, 0x95BA },
    { 0xEC4B, 0x95B6 },
    { 0xEC4C, 0x95BF },
    { 0xEC4D, 0x95B5 },
    { 0xEC4E, 0x95BD },
    { 0xEC4F, 0x96A9 },
    { 0xEC50, 0x96D4 },
    { 0xEC51, 0x970B },
    { 0xEC52, 0x9712 },
    { 0xEC53, 0x9710 },
    { 0xEC54, 0x9799 },
    { 0xEC55, 0x9797 },
    { 0xEC56, 0x9794 },
    { 0xEC57, 0x97F0 },
    { 0xEC58, 0x97F8 },
    { 0xEC59, 0x9835 },
    { 0xEC5A, 0x982F },
    { 0xEC5B, 0x9832 },
    { 0xEC5C, 0x9924 },
    { 0xEC5D, 0x991F },
    { 0xEC5E, 0x9927 },
    { 0xEC5F, 0x9929 },
    { 0xEC60, 0x999E },
    { 0xEC61, 0x99EE },
    { 0xEC62, 0x99EC },
    { 0xEC63, 0x99E5 },
    { 0xEC64, 0x99E4 },
    { 0xEC65, 0x99F0 },
    { 0xEC66, 0x99E3 },
    { 0xEC67, 0x99EA },
    { 0xEC68, 0x99E9 },
    { 0xEC69, 0x99E7 },
    { 0xEC6A, 0x9AB9 },
    { 0xEC6B, 0x9ABF },
    { 0xEC6C, 0x9AB4 },
    { 0xEC6D, 0x9ABB },
    { 0xEC6E, 0x9AF6 },
    { 0xEC6F, 0x9AFA },
    { 0xEC70, 0x9AF9 },
    { 0xEC71, 0x9AF7 },
    { 0xEC72, 0x9B33 },
    { 0xEC73, 0x9B80 },
    { 0xEC74, 0x9B85 },
    { 0xEC75, 0x9B87 },
    { 0xEC76, 0x9B7C },
    { 0xEC77, 0x9B7E },
    { 0xEC78, 0x9B7B },
    { 0xEC79, 0x9B82 },
    { 0xEC7A, 0x9B93 },
    { 0xEC7B, 0x9B92 },
    { 0xEC7C, 0x9B90 },
    { 0xEC7D, 0x9B7A },
    { 0xEC7E, 0x9B95 },
    { 0xECA1, 0x9B7D },
    { 0xECA2, 0x9B88 },
    { 0xECA3, 0x9D25 },
    { 0xECA4, 0x9D17 },
    { 0xECA5, 0x9D20 },
    { 0xECA6, 0x9D1E },
    { 0xECA7, 0x9D14 },
    { 0xECA8, 0x9D29 },
    { 0xECA9, 0x9D1D },
    { 0xECAA, 0x9D18 },
    { 0xECAB, 0x9D22 },
    { 0xECAC, 0x9D10 },
    { 0xECAD, 0x9D19 },
    { 0xECAE, 0x9D1F },
    { 0xECAF, 0x9E88 },
    { 0xECB0, 0x9E86 },
    { 0xECB1, 0x9E87 },
    { 0xECB2, 0x9EAE },
    { 0xECB3, 0x9EAD },
    { 0xECB4, 0x9ED5 },
    { 0xECB5, 0x9ED6 },
    { 0xECB6, 0x9EFA },
    { 0xECB7, 0x9F12 },
    { 0xECB8, 0x9F3D },
    { 0xECB9, 0x5126 },
    { 0xECBA, 0x5125 },
    { 0xECBB, 0x5122 },
    { 0xECBC, 0x5124 },
    { 0xECBD, 0x5120 },
    { 0xECBE, 0x5129 },
    { 0xECBF, 0x52F4 },
    { 0xECC0, 0x5693 },
    { 0xECC1, 0x568C },
    { 0xECC2, 0x568D },
    { 0xECC3, 0x5686 },
    { 0xECC4, 0x5684 },
    { 0xECC5, 0x5683 },
    { 0xECC6, 0x567E },
    { 0xECC7, 0x5682 },
    { 0xECC8, 0x567F },
    { 0xECC9, 0x5681 },
    { 0xECCA, 0x58D6 },
    { 0xECCB, 0x58D4 },
    { 0xECCC, 0x58CF },
    { 0xECCD, 0x58D2 },
    { 0xECCE, 0x5B2D },
    { 0xECCF, 0x5B25 },
    { 0xECD0, 0x5B32 },
    { 0xECD1, 0x5B23 },
    { 0xECD2, 0x5B2C },
    { 0xECD3, 0x5B27 },
    { 0xECD4, 0x5B26 },
    { 0xECD5, 0x5B2F },
    { 0xECD6, 0x5B2E },
    { 0xECD7, 0x5B7B },
    { 0xECD8, 0x5BF1 },
    { 0xECD9, 0x5BF2 },
    { 0xECDA, 0x5DB7 },
    { 0xECDB, 0x5E6C },
    { 0xECDC, 0x5E6A },
    { 0xECDD, 0x5FBE },
    { 0xECDE, 0x5FBB },
    { 0xECDF, 0x61C3 },
    { 0xECE0, 0x61B5 },
    { 0xECE1, 0x61BC },
    { 0xECE2, 0x61E7 },
    { 0xECE3, 0x61E0 },
    { 0xECE4, 0x61E5 },
    { 0xECE5, 0x61E4 },
    { 0xECE6, 0x61E8 },
    { 0xECE7, 0x61DE },
    { 0xECE8, 0x64EF },
    { 0xECE9, 0x64E9 },
    { 0xECEA, 0x64E3 },
    { 0xECEB, 0x64EB },
    { 0xECEC, 0x64E4 },
    { 0xECED, 0x64E8 },
    { 0xECEE, 0x6581 },
    { 0xECEF, 0x6580 },
    { 0xECF0, 0x65B6 },
    { 0xECF1, 0x65DA },
    { 0xECF2, 0x66D2 },
    { 0xECF3, 0x6A8D },
    { 0xECF4, 0x6A96 },
    { 0xECF5, 0x6A81 },
    { 0xECF6, 0x6AA5 },
    { 0xECF7, 0x6A89 },
    { 0xECF8, 0x6A9F },
    { 0xECF9, 0x6A9B },
    { 0xECFA, 0x6AA1 },
    { 0xECFB, 0x6A9E },
    { 0xECFC, 0x6A87 },
    { 0xECFD, 0x6A93 },
    { 0xECFE, 0x6A8E },
    { 0xED40, 0x6A95 },
    { 0xED41, 0x6A83 },
    { 0xED42, 0x6AA8 },
    { 0xED43, 0x6AA4 },
    { 0xED44, 0x6A91 },
    { 0xED45, 0x6A7F },
    { 0xED46, 0x6AA6 },
    { 0xED47, 0x6A9A },
    { 0xED48, 0x6A85 },
    { 0xED49, 0x6A8C },
    { 0xED4A, 0x6A92 },
    { 0xED4B, 0x6B5B },
    { 0xED4C, 0x6BAD },
    { 0xED4D, 0x6C09 },
    { 0xED4E, 0x6FCC },
    { 0xED4F, 0x6FA9 },
    { 0xED50, 0x6FF4 },
    { 0xED51, 0x6FD4 },
    { 0xED52, 0x6FE3 },
    { 0xED53, 0x6FDC },
    { 0xED54, 0x6FED },
    { 0xED55, 0x6FE7 },
    { 0xED56, 0x6FE6 },
    { 0xED57, 0x6FDE },
    { 0xED58, 0x6FF2 },
    { 0xED59, 0x6FDD },
    { 0xED5A, 0x6FE2 },
    { 0xED5B, 0x6FE8 },
    { 0xED5C, 0x71E1 },
    { 0xED5D, 0x71F1 },
    { 0xED5E, 0x71E8 },
    { 0xED5F, 0x71F2 },
    { 0xED60, 0x71E4 },
    { 0xED61, 0x71F0 },
    { 0xED62, 0x71E2 },
    { 0xED63, 0x7373 },
    { 0xED64, 0x736E },
    { 0xED65, 0x736F },
    { 0xED66, 0x7497 },
    { 0xED67, 0x74B2 },
    { 0xED68, 0x74AB },
    { 0xED69, 0x7490 },
    { 0xED6A, 0x74AA },
    { 0xED6B, 0x74AD },
    { 0xED6C, 0x74B1 },
    { 0xED6D, 0x74A5 },
    { 0xED6E, 0x74AF },
    { 0xED6F, 0x7510 },
    { 0xED70, 0x7511 },
    { 0xED71, 0x7512 },
    { 0xED72, 0x750F },
    { 0xED73, 0x7584 },
    { 0xED74, 0x7643 },
    { 0xED75, 0x7648 },
    { 0xED76, 0x7649 },
    { 0xED77, 0x7647 },
    { 0xED78, 0x76A4 },
    { 0xED79, 0x76E9 },
    { 0xED7A, 0x77B5 },
    { 0xED7B, 0x77AB },
    { 0xED7C, 0x77B2 },
    { 0xED7D, 0x77B7 },
    { 0xED7E, 0x77B6 },
    { 0xEDA1, 0x77B4 },
    { 0xEDA2, 0x77B1 },
    { 0xEDA3, 0x77A8 },
    { 0xEDA4, 0x77F0 },
    { 0xEDA5, 0x78F3 },
    { 0xEDA6, 0x78FD },
    { 0xEDA7, 0x7902 },
    { 0xEDA8, 0x78FB },
    { 0xEDA9, 0x78FC },
    { 0xEDAA, 0x78F2 },
    { 0xEDAB, 0x7905 },
    { 0xEDAC, 0x78F9 },
    { 0xEDAD, 0x78FE },
    { 0xEDAE, 0x7904 },
    { 0xEDAF, 0x79AB },
    { 0xEDB0, 0x79A8 },
    { 0xEDB1, 0x7A5C },
    { 0xEDB2, 0x7A5B },
    { 0xEDB3, 0x7A56 },
    { 0xEDB4, 0x7A58 },
    { 0xEDB5, 0x7A54 },
    { 0xEDB6, 0x7A5A },
    { 0xEDB7, 0x7ABE },
    { 0xEDB8, 0x7AC0 },
    { 0xEDB9, 0x7AC1 },
    { 0xEDBA, 0x7C05 },
    { 0xEDBB, 0x7C0F },
    { 0xEDBC, 0x7BF2 },
    { 0xEDBD, 0x7C00 },
    { 0xEDBE, 0x7BFF },
    { 0xEDBF, 0x7BFB },
    { 0xEDC0, 0x7C0E },
    { 0xEDC1, 0x7BF4 },
    { 0xEDC2, 0x7C0B },
    { 0xEDC3, 0x7BF3 },
    { 0xEDC4, 0x7C02 },
    { 0xEDC5, 0x7C09 },
    { 0xEDC6, 0x7C03 },
    { 0xEDC7, 0x7C01 },
    { 0xEDC8, 0x7BF8 },
    { 0xEDC9, 0x7BFD },
    { 0xEDCA, 0x7C06 },
    { 0xEDCB, 0x7BF0 },
    { 0xEDCC, 0x7BF1 },
    { 0xEDCD, 0x7C10 },
    { 0xEDCE, 0x7C0A },
    { 0xEDCF, 0x7CE8 },
    { 0xEDD0, 0x7E2D },
    { 0xEDD1, 0x7E3C },
    { 0xEDD2, 0x7E42 },
    { 0xEDD3, 0x7E33 },
    { 0xEDD4, 0x9848 },
    { 0xEDD5, 0x7E38 },
    { 0xEDD6, 0x7E2A },
    { 0xEDD7, 0x7E49 },
    { 0xEDD8, 0x7E40 },
    { 0xEDD9, 0x7E47 },
    { 0xEDDA, 0x7E29 },
    { 0xEDDB, 0x7E4C },
    { 0xEDDC, 0x7E30 },
    { 0xEDDD, 0x7E3B },
    { 0xEDDE, 0x7E36 },
    { 0xEDDF, 0x7E44 },
    { 0xEDE0, 0x7E3A },
    { 0xEDE1, 0x7F45 },
    { 0xEDE2, 0x7F7F },
    { 0xEDE3, 0x7F7E },
    { 0xEDE4, 0x7F7D },
    { 0xEDE5, 0x7FF4 },
    { 0xEDE6, 0x7FF2 },
    { 0xEDE7, 0x802C },
    { 0xEDE8, 0x81BB },
    { 0xEDE9, 0x81C4 },
    { 0xEDEA, 0x81CC },
    { 0xEDEB, 0x81CA },
    { 0xEDEC, 0x81C5 },
    { 0xEDED, 0x81C7 },
    { 0xEDEE, 0x81BC },
    { 0xEDEF, 0x81E9 },
    { 0xEDF0, 0x825B },
    { 0xEDF1, 0x825A },
    { 0xEDF2, 0x825C },
    { 0xEDF3, 0x8583 },
    { 0xEDF4, 0x8580 },
    { 0xEDF5, 0x858F },
    { 0xEDF6, 0x85A7 },
    { 0xEDF7, 0x8595 },
    { 0xEDF8, 0x85A0 },
    { 0xEDF9, 0x858B },
    { 0xEDFA, 0x85A3 },
    { 0xEDFB, 0x857B },
    { 0xEDFC, 0x85A4 },
    { 0xEDFD, 0x859A },
    { 0xEDFE, 0x859E },
    { 0xEE40, 0x8577 },
    { 0xEE41, 0x857C },
    { 0xEE42, 0x8589 },
    { 0xEE43, 0x85A1 },
    { 0xEE44, 0x857A },
    { 0xEE45, 0x8578 },
    { 0xEE46, 0x8557 },
    { 0xEE47, 0x858E },
    { 0xEE48, 0x8596 },
    { 0xEE49, 0x8586 },
    { 0xEE4A, 0x858D },
    { 0xEE4B, 0x8599 },
    { 0xEE4C, 0x859D },
    { 0xEE4D, 0x8581 },
    { 0xEE4E, 0x85A2 },
    { 0xEE4F, 0x8582 },
    { 0xEE50, 0x8588 },
    { 0xEE51, 0x8585 },
    { 0xEE52, 0x8579 },
    { 0xEE53, 0x8576 },
    { 0xEE54, 0x8598 },
    { 0xEE55, 0x8590 },
    { 0xEE56, 0x859F },
    { 0xEE57, 0x8668 },
    { 0xEE58, 0x87BE },
    { 0xEE59, 0x87AA },
    { 0xEE5A, 0x87AD },
    { 0xEE5B, 0x87C5 },
    { 0xEE5C, 0x87B0 },
    { 0xEE5D, 0x87AC },
    { 0xEE5E, 0x87B9 },
    { 0xEE5F, 0x87B5 },
    { 0xEE60, 0x87BC },
    { 0xEE61, 0x87AE },
    { 0xEE62, 0x87C9 },
    { 0xEE63, 0x87C3 },
    { 0xEE64, 0x87C2 },
    { 0xEE65, 0x87CC },
    { 0xEE66, 0x87B7 },
    { 0xEE67, 0x87AF },
    { 0xEE68, 0x87C4 },
    { 0xEE69, 0x87CA },
    { 0xEE6A, 0x87B4 },
    { 0xEE6B, 0x87B6 },
    { 0xEE6C, 0x87BF },
    { 0xEE6D, 0x87B8 },
    { 0xEE6E, 0x87BD },
    { 0xEE6F, 0x87DE },
    { 0xEE70, 0x87B2 },
    { 0xEE71, 0x8935 },
    { 0xEE72, 0x8933 },
    { 0xEE73, 0x893C },
    { 0xEE74, 0x893E },
    { 0xEE75, 0x8941 },
    { 0xEE76, 0x8952 },
    { 0xEE77, 0x8937 },
    { 0xEE78, 0x8942 },
    { 0xEE79, 0x89AD },
    { 0xEE7A, 0x89AF },
    { 0xEE7B, 0x89AE },
    { 0xEE7C, 0x89F2 },
    { 0xEE7D, 0x89F3 },
    { 0xEE7E, 0x8B1E },
    { 0xEEA1, 0x8B18 },
    { 0xEEA2, 0x8B16 },
    { 0xEEA3, 0x8B11 },
    { 0xEEA4, 0x8B05 },
    { 0xEEA5, 0x8B0B },
    { 0xEEA6, 0x8B22 },
    { 0xEEA7, 0x8B0F },
    { 0xEEA8, 0x8B12 },
    { 0xEEA9, 0x8B15 },
    { 0xEEAA, 0x8B07 },
    { 0xEEAB, 0x8B0D },
    { 0xEEAC, 0x8B08 },
    { 0xEEAD, 0x8B06 },
    { 0xEEAE, 0x8B1C },
    { 0xEEAF, 0x8B13 },
    { 0xEEB0, 0x8B1A },
    { 0xEEB1, 0x8C4F },
    { 0xEEB2, 0x8C70 },
    { 0xEEB3, 0x8C72 },
    { 0xEEB4, 0x8C71 },
    { 0xEEB5, 0x8C6F },
    { 0xEEB6, 0x8C95 },
    { 0xEEB7, 0x8C94 },
    { 0xEEB8, 0x8CF9 },
    { 0xEEB9, 0x8D6F },
    { 0xEEBA, 0x8E4E },
    { 0xEEBB, 0x8E4D },
    { 0xEEBC, 0x8E53 },
    { 0xEEBD, 0x8E50 },
    { 0xEEBE, 0x8E4C },
    { 0xEEBF, 0x8E47 },
    { 0xEEC0, 0x8F43 },
    { 0xEEC1, 0x8F40 },
    { 0xEEC2, 0x9085 },
    { 0xEEC3, 0x907E },
    { 0xEEC4, 0x9138 },
    { 0xEEC5, 0x919A },
    { 0xEEC6, 0x91A2 },
    { 0xEEC7, 0x919B },
    { 0xEEC8, 0x9199 },
    { 0xEEC9, 0x919F },
    { 0xEECA, 0x91A1 },
    { 0xEECB, 0x919D },
    { 0xEECC, 0x91A0 },
    { 0xEECD, 0x93A1 },
    { 0xEECE, 0x9383 },
    { 0xEECF, 0x93AF },
    { 0xEED0, 0x9364 },
    { 0xEED1, 0x9356 },
    { 0xEED2, 0x9347 },
    { 0xEED3, 0x937C },
    { 0xEED4, 0x9358 },
    { 0xEED5, 0x935C },
    { 0xEED6, 0x9376 },
    { 0xEED7, 0x9349 },
    { 0xEED8, 0x9350 },
    { 0xEED9, 0x9351 },
    { 0xEEDA, 0x9360 },
    { 0xEEDB, 0x936D },
    { 0xEEDC, 0x938F },
    { 0xEEDD, 0x934C },
    { 0xEEDE, 0x936A },
    { 0xEEDF, 0x9379 },
    { 0xEEE0, 0x9357 },
    { 0xEEE1, 0x9355 },
    { 0xEEE2, 0x9352 },
    { 0xEEE3, 0x934F },
    { 0xEEE4, 0x9371 },
    { 0xEEE5, 0x9377 },
    { 0xEEE6, 0x937B },
    { 0xEEE7, 0x9361 },
    { 0xEEE8, 0x935E },
    { 0xEEE9, 0x9363 },
    { 0xEEEA, 0x9367 },
    { 0xEEEB, 0x9380 },
    { 0xEEEC, 0x934E },
    
    
    { 0xEEED, 0x9359 },
    { 0xEEEE, 0x95C7 },
    { 0xEEEF, 0x95C0 },
    { 0xEEF0, 0x95C9 },
    { 0xEEF1, 0x95C3 },
    { 0xEEF2, 0x95C5 },
    { 0xEEF3, 0x95B7 },
    { 0xEEF4, 0x96AE },
    { 0xEEF5, 0x96B0 },
    { 0xEEF6, 0x96AC },
    { 0xEEF7, 0x9720 },
    { 0xEEF8, 0x971F },
    { 0xEEF9, 0x9718 },
    { 0xEEFA, 0x971D },
    { 0xEEFB, 0x9719 },
    { 0xEEFC, 0x979A },
    { 0xEEFD, 0x97A1 },
    { 0xEEFE, 0x979C },
    { 0xEF40, 0x979E },
    { 0xEF41, 0x979D },
    { 0xEF42, 0x97D5 },
    { 0xEF43, 0x97D4 },
    { 0xEF44, 0x97F1 },
    { 0xEF45, 0x9841 },
    { 0xEF46, 0x9844 },
    { 0xEF47, 0x984A },
    { 0xEF48, 0x9849 },
    { 0xEF49, 0x9845 },
    { 0xEF4A, 0x9843 },
    { 0xEF4B, 0x9925 },
    { 0xEF4C, 0x992B },
    { 0xEF4D, 0x992C },
    { 0xEF4E, 0x992A },
    { 0xEF4F, 0x9933 },
    { 0xEF50, 0x9932 },
    { 0xEF51, 0x992F },
    { 0xEF52, 0x992D },
    { 0xEF53, 0x9931 },
    { 0xEF54, 0x9930 },
    { 0xEF55, 0x9998 },
    { 0xEF56, 0x99A3 },
    { 0xEF57, 0x99A1 },
    { 0xEF58, 0x9A02 },
    { 0xEF59, 0x99FA },
    { 0xEF5A, 0x99F4 },
    { 0xEF5B, 0x99F7 },
    { 0xEF5C, 0x99F9 },
    { 0xEF5D, 0x99F8 },
    { 0xEF5E, 0x99F6 },
    { 0xEF5F, 0x99FB },
    { 0xEF60, 0x99FD },
    { 0xEF61, 0x99FE },
    { 0xEF62, 0x99FC },
    { 0xEF63, 0x9A03 },
    { 0xEF64, 0x9ABE },
    { 0xEF65, 0x9AFE },
    { 0xEF66, 0x9AFD },
    { 0xEF67, 0x9B01 },
    { 0xEF68, 0x9AFC },
    { 0xEF69, 0x9B48 },
    { 0xEF6A, 0x9B9A },
    { 0xEF6B, 0x9BA8 },
    { 0xEF6C, 0x9B9E },
    { 0xEF6D, 0x9B9B },
    { 0xEF6E, 0x9BA6 },
    { 0xEF6F, 0x9BA1 },
    { 0xEF70, 0x9BA5 },
    { 0xEF71, 0x9BA4 },
    { 0xEF72, 0x9B86 },
    { 0xEF73, 0x9BA2 },
    { 0xEF74, 0x9BA0 },
    { 0xEF75, 0x9BAF },
    { 0xEF76, 0x9D33 },
    { 0xEF77, 0x9D41 },
    { 0xEF78, 0x9D67 },
    { 0xEF79, 0x9D36 },
    { 0xEF7A, 0x9D2E },
    { 0xEF7B, 0x9D2F },
    { 0xEF7C, 0x9D31 },
    { 0xEF7D, 0x9D38 },
    { 0xEF7E, 0x9D30 },
    { 0xEFA1, 0x9D45 },
    { 0xEFA2, 0x9D42 },
    { 0xEFA3, 0x9D43 },
    { 0xEFA4, 0x9D3E },
    { 0xEFA5, 0x9D37 },
    { 0xEFA6, 0x9D40 },
    { 0xEFA7, 0x9D3D },
    { 0xEFA8, 0x7FF5 },
    { 0xEFA9, 0x9D2D },
    { 0xEFAA, 0x9E8A },
    { 0xEFAB, 0x9E89 },
    { 0xEFAC, 0x9E8D },
    { 0xEFAD, 0x9EB0 },
    { 0xEFAE, 0x9EC8 },
    { 0xEFAF, 0x9EDA },
    { 0xEFB0, 0x9EFB },
    { 0xEFB1, 0x9EFF },
    { 0xEFB2, 0x9F24 },
    { 0xEFB3, 0x9F23 },
    { 0xEFB4, 0x9F22 },
    { 0xEFB5, 0x9F54 },
    { 0xEFB6, 0x9FA0 },
    { 0xEFB7, 0x5131 },
    { 0xEFB8, 0x512D },
    { 0xEFB9, 0x512E },
    { 0xEFBA, 0x5698 },
    { 0xEFBB, 0x569C },
    { 0xEFBC, 0x5697 },
    { 0xEFBD, 0x569A },
    { 0xEFBE, 0x569D },
    { 0xEFBF, 0x5699 },
    { 0xEFC0, 0x5970 },
    { 0xEFC1, 0x5B3C },
    { 0xEFC2, 0x5C69 },
    { 0xEFC3, 0x5C6A },
    { 0xEFC4, 0x5DC0 },
    { 0xEFC5, 0x5E6D },
    { 0xEFC6, 0x5E6E },
    { 0xEFC7, 0x61D8 },
    { 0xEFC8, 0x61DF },
    { 0xEFC9, 0x61ED },
    { 0xEFCA, 0x61EE },
    { 0xEFCB, 0x61F1 },
    { 0xEFCC, 0x61EA },
    { 0xEFCD, 0x61F0 },
    { 0xEFCE, 0x61EB },
    { 0xEFCF, 0x61D6 },
    { 0xEFD0, 0x61E9 },
    { 0xEFD1, 0x64FF },
    { 0xEFD2, 0x6504 },
    { 0xEFD3, 0x64FD },
    { 0xEFD4, 0x64F8 },
    { 0xEFD5, 0x6501 },
    { 0xEFD6, 0x6503 },
    { 0xEFD7, 0x64FC },
    { 0xEFD8, 0x6594 },
    { 0xEFD9, 0x65DB },
    { 0xEFDA, 0x66DA },
    { 0xEFDB, 0x66DB },
    { 0xEFDC, 0x66D8 },
    { 0xEFDD, 0x6AC5 },
    { 0xEFDE, 0x6AB9 },
    { 0xEFDF, 0x6ABD },
    { 0xEFE0, 0x6AE1 },
    { 0xEFE1, 0x6AC6 },
    { 0xEFE2, 0x6ABA },
    { 0xEFE3, 0x6AB6 },
    { 0xEFE4, 0x6AB7 },
    { 0xEFE5, 0x6AC7 },
    { 0xEFE6, 0x6AB4 },
    { 0xEFE7, 0x6AAD },
    { 0xEFE8, 0x6B5E },
    { 0xEFE9, 0x6BC9 },
    { 0xEFEA, 0x6C0B },
    { 0xEFEB, 0x7007 },
    { 0xEFEC, 0x700C },
    { 0xEFED, 0x700D },
    { 0xEFEE, 0x7001 },
    { 0xEFEF, 0x7005 },
    { 0xEFF0, 0x7014 },
    { 0xEFF1, 0x700E },
    { 0xEFF2, 0x6FFF },
    { 0xEFF3, 0x7000 },
    { 0xEFF4, 0x6FFB },
    { 0xEFF5, 0x7026 },
    { 0xEFF6, 0x6FFC },
    { 0xEFF7, 0x6FF7 },
    { 0xEFF8, 0x700A },
    { 0xEFF9, 0x7201 },
    { 0xEFFA, 0x71FF },
    { 0xEFFB, 0x71F9 },
    { 0xEFFC, 0x7203 },
    { 0xEFFD, 0x71FD },
    { 0xEFFE, 0x7376 },
    { 0xF040, 0x74B8 },
    { 0xF041, 0x74C0 },
    { 0xF042, 0x74B5 },
    { 0xF043, 0x74C1 },
    { 0xF044, 0x74BE },
    { 0xF045, 0x74B6 },
    { 0xF046, 0x74BB },
    { 0xF047, 0x74C2 },
    { 0xF048, 0x7514 },
    { 0xF049, 0x7513 },
    { 0xF04A, 0x765C },
    { 0xF04B, 0x7664 },
    { 0xF04C, 0x7659 },
    { 0xF04D, 0x7650 },
    { 0xF04E, 0x7653 },
    { 0xF04F, 0x7657 },
    { 0xF050, 0x765A },
    { 0xF051, 0x76A6 },
    { 0xF052, 0x76BD },
    { 0xF053, 0x76EC },
    { 0xF054, 0x77C2 },
    { 0xF055, 0x77BA },
    { 0xF056, 0x78FF },
    { 0xF057, 0x790C },
    { 0xF058, 0x7913 },
    { 0xF059, 0x7914 },
    { 0xF05A, 0x7909 },
    { 0xF05B, 0x7910 },
    { 0xF05C, 0x7912 },
    { 0xF05D, 0x7911 },
    { 0xF05E, 0x79AD },
    { 0xF05F, 0x79AC },
    { 0xF060, 0x7A5F },
    { 0xF061, 0x7C1C },
    { 0xF062, 0x7C29 },
    { 0xF063, 0x7C19 },
    { 0xF064, 0x7C20 },
    { 0xF065, 0x7C1F },
    { 0xF066, 0x7C2D },
    { 0xF067, 0x7C1D },
    { 0xF068, 0x7C26 },
    { 0xF069, 0x7C28 },
    { 0xF06A, 0x7C22 },
    { 0xF06B, 0x7C25 },
    { 0xF06C, 0x7C30 },
    { 0xF06D, 0x7E5C },
    { 0xF06E, 0x7E50 },
    { 0xF06F, 0x7E56 },
    { 0xF070, 0x7E63 },
    { 0xF071, 0x7E58 },
    { 0xF072, 0x7E62 },
    { 0xF073, 0x7E5F },
    { 0xF074, 0x7E51 },
    { 0xF075, 0x7E60 },
    { 0xF076, 0x7E57 },
    { 0xF077, 0x7E53 },
    { 0xF078, 0x7FB5 },
    { 0xF079, 0x7FB3 },
    { 0xF07A, 0x7FF7 },
    { 0xF07B, 0x7FF8 },
    { 0xF07C, 0x8075 },
    { 0xF07D, 0x81D1 },
    { 0xF07E, 0x81D2 },
    { 0xF0A1, 0x81D0 },
    { 0xF0A2, 0x825F },
    { 0xF0A3, 0x825E },
    { 0xF0A4, 0x85B4 },
    { 0xF0A5, 0x85C6 },
    { 0xF0A6, 0x85C0 },
    { 0xF0A7, 0x85C3 },
    { 0xF0A8, 0x85C2 },
    { 0xF0A9, 0x85B3 },
    { 0xF0AA, 0x85B5 },
    { 0xF0AB, 0x85BD },
    { 0xF0AC, 0x85C7 },
    { 0xF0AD, 0x85C4 },
    { 0xF0AE, 0x85BF },
    { 0xF0AF, 0x85CB },
    { 0xF0B0, 0x85CE },
    { 0xF0B1, 0x85C8 },
    { 0xF0B2, 0x85C5 },
    { 0xF0B3, 0x85B1 },
    { 0xF0B4, 0x85B6 },
    { 0xF0B5, 0x85D2 },
    { 0xF0B6, 0x8624 },
    { 0xF0B7, 0x85B8 },
    { 0xF0B8, 0x85B7 },
    { 0xF0B9, 0x85BE },
    { 0xF0BA, 0x8669 },
    { 0xF0BB, 0x87E7 },
    { 0xF0BC, 0x87E6 },
    { 0xF0BD, 0x87E2 },
    { 0xF0BE, 0x87DB },
    { 0xF0BF, 0x87EB },
    { 0xF0C0, 0x87EA },
    { 0xF0C1, 0x87E5 },
    { 0xF0C2, 0x87DF },
    { 0xF0C3, 0x87F3 },
    { 0xF0C4, 0x87E4 },
    { 0xF0C5, 0x87D4 },
    { 0xF0C6, 0x87DC },
    { 0xF0C7, 0x87D3 },
    { 0xF0C8, 0x87ED },
    { 0xF0C9, 0x87D8 },
    { 0xF0CA, 0x87E3 },
    { 0xF0CB, 0x87A4 },
    { 0xF0CC, 0x87D7 },
    { 0xF0CD, 0x87D9 },
    { 0xF0CE, 0x8801 },
    { 0xF0CF, 0x87F4 },
    { 0xF0D0, 0x87E8 },
    { 0xF0D1, 0x87DD },
    { 0xF0D2, 0x8953 },
    { 0xF0D3, 0x894B },
    { 0xF0D4, 0x894F },
    { 0xF0D5, 0x894C },
    { 0xF0D6, 0x8946 },
    { 0xF0D7, 0x8950 },
    { 0xF0D8, 0x8951 },
    { 0xF0D9, 0x8949 },
    { 0xF0DA, 0x8B2A },
    { 0xF0DB, 0x8B27 },
    { 0xF0DC, 0x8B23 },
    { 0xF0DD, 0x8B33 },
    { 0xF0DE, 0x8B30 },
    { 0xF0DF, 0x8B35 },
    { 0xF0E0, 0x8B47 },
    { 0xF0E1, 0x8B2F },
    { 0xF0E2, 0x8B3C },
    { 0xF0E3, 0x8B3E },
    { 0xF0E4, 0x8B31 },
    { 0xF0E5, 0x8B25 },
    { 0xF0E6, 0x8B37 },
    { 0xF0E7, 0x8B26 },
    { 0xF0E8, 0x8B36 },
    { 0xF0E9, 0x8B2E },
    { 0xF0EA, 0x8B24 },
    { 0xF0EB, 0x8B3B },
    { 0xF0EC, 0x8B3D },
    { 0xF0ED, 0x8B3A },
    { 0xF0EE, 0x8C42 },
    { 0xF0EF, 0x8C75 },
    { 0xF0F0, 0x8C99 },
    { 0xF0F1, 0x8C98 },
    { 0xF0F2, 0x8C97 },
    { 0xF0F3, 0x8CFE },
    { 0xF0F4, 0x8D04 },
    { 0xF0F5, 0x8D02 },
    { 0xF0F6, 0x8D00 },
    { 0xF0F7, 0x8E5C },
    { 0xF0F8, 0x8E62 },
    { 0xF0F9, 0x8E60 },
    { 0xF0FA, 0x8E57 },
    { 0xF0FB, 0x8E56 },
    { 0xF0FC, 0x8E5E },
    { 0xF0FD, 0x8E65 },
    { 0xF0FE, 0x8E67 },
    { 0xF140, 0x8E5B },
    { 0xF141, 0x8E5A },
    { 0xF142, 0x8E61 },
    { 0xF143, 0x8E5D },
    { 0xF144, 0x8E69 },
    { 0xF145, 0x8E54 },
    { 0xF146, 0x8F46 },
    { 0xF147, 0x8F47 },
    { 0xF148, 0x8F48 },
    { 0xF149, 0x8F4B },
    { 0xF14A, 0x9128 },
    { 0xF14B, 0x913A },
    { 0xF14C, 0x913B },
    { 0xF14D, 0x913E },
    { 0xF14E, 0x91A8 },
    { 0xF14F, 0x91A5 },
    { 0xF150, 0x91A7 },
    { 0xF151, 0x91AF },
    { 0xF152, 0x91AA },
    { 0xF153, 0x93B5 },
    { 0xF154, 0x938C },
    { 0xF155, 0x9392 },
    { 0xF156, 0x93B7 },
    { 0xF157, 0x939B },
    { 0xF158, 0x939D },
    { 0xF159, 0x9389 },
    { 0xF15A, 0x93A7 },
    { 0xF15B, 0x938E },
    { 0xF15C, 0x93AA },
    { 0xF15D, 0x939E },
    { 0xF15E, 0x93A6 },
    { 0xF15F, 0x9395 },
    { 0xF160, 0x9388 },
    { 0xF161, 0x9399 },
    { 0xF162, 0x939F },
    { 0xF163, 0x938D },
    { 0xF164, 0x93B1 },
    { 0xF165, 0x9391 },
    { 0xF166, 0x93B2 },
    { 0xF167, 0x93A4 },
    { 0xF168, 0x93A8 },
    { 0xF169, 0x93B4 },
    { 0xF16A, 0x93A3 },
    { 0xF16B, 0x93A5 },
    { 0xF16C, 0x95D2 },
    { 0xF16D, 0x95D3 },
    { 0xF16E, 0x95D1 },
    { 0xF16F, 0x96B3 },
    { 0xF170, 0x96D7 },
    { 0xF171, 0x96DA },
    { 0xF172, 0x5DC2 },
    { 0xF173, 0x96DF },
    { 0xF174, 0x96D8 },
    { 0xF175, 0x96DD },
    { 0xF176, 0x9723 },
    { 0xF177, 0x9722 },
    { 0xF178, 0x9725 },
    { 0xF179, 0x97AC },
    { 0xF17A, 0x97AE },
    { 0xF17B, 0x97A8 },
    { 0xF17C, 0x97AB },
    { 0xF17D, 0x97A4 },
    { 0xF17E, 0x97AA },
    { 0xF1A1, 0x97A2 },
    { 0xF1A2, 0x97A5 },
    { 0xF1A3, 0x97D7 },
    { 0xF1A4, 0x97D9 },
    { 0xF1A5, 0x97D6 },
    { 0xF1A6, 0x97D8 },
    { 0xF1A7, 0x97FA },
    { 0xF1A8, 0x9850 },
    { 0xF1A9, 0x9851 },
    { 0xF1AA, 0x9852 },
    { 0xF1AB, 0x98B8 },
    { 0xF1AC, 0x9941 },
    { 0xF1AD, 0x993C },
    { 0xF1AE, 0x993A },
    { 0xF1AF, 0x9A0F },
    { 0xF1B0, 0x9A0B },
    { 0xF1B1, 0x9A09 },
    { 0xF1B2, 0x9A0D },
    { 0xF1B3, 0x9A04 },
    { 0xF1B4, 0x9A11 },
    { 0xF1B5, 0x9A0A },
    { 0xF1B6, 0x9A05 },
    { 0xF1B7, 0x9A07 },
    { 0xF1B8, 0x9A06 },
    { 0xF1B9, 0x9AC0 },
    { 0xF1BA, 0x9ADC },
    { 0xF1BB, 0x9B08 },
    { 0xF1BC, 0x9B04 },
    { 0xF1BD, 0x9B05 },
    { 0xF1BE, 0x9B29 },
    { 0xF1BF, 0x9B35 },
    { 0xF1C0, 0x9B4A },
    { 0xF1C1, 0x9B4C },
    { 0xF1C2, 0x9B4B },
    { 0xF1C3, 0x9BC7 },
    { 0xF1C4, 0x9BC6 },
    { 0xF1C5, 0x9BC3 },
    { 0xF1C6, 0x9BBF },
    { 0xF1C7, 0x9BC1 },
    { 0xF1C8, 0x9BB5 },
    { 0xF1C9, 0x9BB8 },
    { 0xF1CA, 0x9BD3 },
    { 0xF1CB, 0x9BB6 },
    { 0xF1CC, 0x9BC4 },
    { 0xF1CD, 0x9BB9 },
    { 0xF1CE, 0x9BBD },
    { 0xF1CF, 0x9D5C },
    { 0xF1D0, 0x9D53 },
    { 0xF1D1, 0x9D4F },
    { 0xF1D2, 0x9D4A },
    { 0xF1D3, 0x9D5B },
    { 0xF1D4, 0x9D4B },
    { 0xF1D5, 0x9D59 },
    { 0xF1D6, 0x9D56 },
    { 0xF1D7, 0x9D4C },
    { 0xF1D8, 0x9D57 },
    { 0xF1D9, 0x9D52 },
    { 0xF1DA, 0x9D54 },
    { 0xF1DB, 0x9D5F },
    { 0xF1DC, 0x9D58 },
    { 0xF1DD, 0x9D5A },
    { 0xF1DE, 0x9E8E },
    { 0xF1DF, 0x9E8C },
    { 0xF1E0, 0x9EDF },
    { 0xF1E1, 0x9F01 },
    { 0xF1E2, 0x9F00 },
    { 0xF1E3, 0x9F16 },
    { 0xF1E4, 0x9F25 },
    { 0xF1E5, 0x9F2B },
    { 0xF1E6, 0x9F2A },
    { 0xF1E7, 0x9F29 },
    { 0xF1E8, 0x9F28 },
    { 0xF1E9, 0x9F4C },
    { 0xF1EA, 0x9F55 },
    { 0xF1EB, 0x5134 },
    { 0xF1EC, 0x5135 },
    { 0xF1ED, 0x5296 },
    { 0xF1EE, 0x52F7 },
    { 0xF1EF, 0x53B4 },
    { 0xF1F0, 0x56AB },
    { 0xF1F1, 0x56AD },
    { 0xF1F2, 0x56A6 },
    { 0xF1F3, 0x56A7 },
    { 0xF1F4, 0x56AA },
    { 0xF1F5, 0x56AC },
    { 0xF1F6, 0x58DA },
    { 0xF1F7, 0x58DD },
    { 0xF1F8, 0x58DB },
    { 0xF1F9, 0x5912 },
    { 0xF1FA, 0x5B3D },
    { 0xF1FB, 0x5B3E },
    { 0xF1FC, 0x5B3F },
    { 0xF1FD, 0x5DC3 },
    { 0xF1FE, 0x5E70 },
    { 0xF240, 0x5FBF },
    { 0xF241, 0x61FB },
    { 0xF242, 0x6507 },
    { 0xF243, 0x6510 },
    { 0xF244, 0x650D },
    { 0xF245, 0x6509 },
    { 0xF246, 0x650C },
    { 0xF247, 0x650E },
    { 0xF248, 0x6584 },
    { 0xF249, 0x65DE },
    { 0xF24A, 0x65DD },
    { 0xF24B, 0x66DE },
    { 0xF24C, 0x6AE7 },
    { 0xF24D, 0x6AE0 },
    { 0xF24E, 0x6ACC },
    { 0xF24F, 0x6AD1 },
    { 0xF250, 0x6AD9 },
    { 0xF251, 0x6ACB },
    { 0xF252, 0x6ADF },
    { 0xF253, 0x6ADC },
    { 0xF254, 0x6AD0 },
    { 0xF255, 0x6AEB },
    { 0xF256, 0x6ACF },
    { 0xF257, 0x6ACD },
    { 0xF258, 0x6ADE },
    { 0xF259, 0x6B60 },
    { 0xF25A, 0x6BB0 },
    { 0xF25B, 0x6C0C },
    { 0xF25C, 0x7019 },
    { 0xF25D, 0x7027 },
    { 0xF25E, 0x7020 },
    { 0xF25F, 0x7016 },
    { 0xF260, 0x702B },
    { 0xF261, 0x7021 },
    { 0xF262, 0x7022 },
    { 0xF263, 0x7023 },
    { 0xF264, 0x7029 },
    { 0xF265, 0x7017 },
    { 0xF266, 0x7024 },
    { 0xF267, 0x701C },
    { 0xF268, 0x702A },
    { 0xF269, 0x720C },
    { 0xF26A, 0x720A },
    { 0xF26B, 0x7207 },
    { 0xF26C, 0x7202 },
    { 0xF26D, 0x7205 },
    { 0xF26E, 0x72A5 },
    { 0xF26F, 0x72A6 },
    { 0xF270, 0x72A4 },
    { 0xF271, 0x72A3 },
    { 0xF272, 0x72A1 },
    { 0xF273, 0x74CB },
    { 0xF274, 0x74C5 },
    { 0xF275, 0x74B7 },
    { 0xF276, 0x74C3 },
    { 0xF277, 0x7516 },
    { 0xF278, 0x7660 },
    { 0xF279, 0x77C9 },
    { 0xF27A, 0x77CA },
    { 0xF27B, 0x77C4 },
    { 0xF27C, 0x77F1 },
    { 0xF27D, 0x791D },
    { 0xF27E, 0x791B },
    { 0xF2A1, 0x7921 },
    { 0xF2A2, 0x791C },
    { 0xF2A3, 0x7917 },
    { 0xF2A4, 0x791E },
    { 0xF2A5, 0x79B0 },
    { 0xF2A6, 0x7A67 },
    { 0xF2A7, 0x7A68 },
    { 0xF2A8, 0x7C33 },
    { 0xF2A9, 0x7C3C },
    { 0xF2AA, 0x7C39 },
    { 0xF2AB, 0x7C2C },
    { 0xF2AC, 0x7C3B },
    { 0xF2AD, 0x7CEC },
    { 0xF2AE, 0x7CEA },
    { 0xF2AF, 0x7E76 },
    { 0xF2B0, 0x7E75 },
    { 0xF2B1, 0x7E78 },
    { 0xF2B2, 0x7E70 },
    { 0xF2B3, 0x7E77 },
    { 0xF2B4, 0x7E6F },
    { 0xF2B5, 0x7E7A },
    { 0xF2B6, 0x7E72 },
    { 0xF2B7, 0x7E74 },
    { 0xF2B8, 0x7E68 },
    { 0xF2B9, 0x7F4B },
    { 0xF2BA, 0x7F4A },
    { 0xF2BB, 0x7F83 },
    { 0xF2BC, 0x7F86 },
    { 0xF2BD, 0x7FB7 },
    { 0xF2BE, 0x7FFD },
    { 0xF2BF, 0x7FFE },
    { 0xF2C0, 0x8078 },
    { 0xF2C1, 0x81D7 },
    { 0xF2C2, 0x81D5 },
    { 0xF2C3, 0x8264 },
    { 0xF2C4, 0x8261 },
    { 0xF2C5, 0x8263 },
    { 0xF2C6, 0x85EB },
    { 0xF2C7, 0x85F1 },
    { 0xF2C8, 0x85ED },
    { 0xF2C9, 0x85D9 },
    { 0xF2CA, 0x85E1 },
    { 0xF2CB, 0x85E8 },
    { 0xF2CC, 0x85DA },
    { 0xF2CD, 0x85D7 },
    { 0xF2CE, 0x85EC },
    { 0xF2CF, 0x85F2 },
    { 0xF2D0, 0x85F8 },
    { 0xF2D1, 0x85D8 },
    { 0xF2D2, 0x85DF },
    { 0xF2D3, 0x85E3 },
    { 0xF2D4, 0x85DC },
    { 0xF2D5, 0x85D1 },
    { 0xF2D6, 0x85F0 },
    { 0xF2D7, 0x85E6 },
    { 0xF2D8, 0x85EF },
    { 0xF2D9, 0x85DE },
    { 0xF2DA, 0x85E2 },
    { 0xF2DB, 0x8800 },
    { 0xF2DC, 0x87FA },
    { 0xF2DD, 0x8803 },
    { 0xF2DE, 0x87F6 },
    { 0xF2DF, 0x87F7 },
    { 0xF2E0, 0x8809 },
    { 0xF2E1, 0x880C },
    { 0xF2E2, 0x880B },
    { 0xF2E3, 0x8806 },
    { 0xF2E4, 0x87FC },
    { 0xF2E5, 0x8808 },
    { 0xF2E6, 0x87FF },
    { 0xF2E7, 0x880A },
    { 0xF2E8, 0x8802 },
    { 0xF2E9, 0x8962 },
    { 0xF2EA, 0x895A },
    { 0xF2EB, 0x895B },
    { 0xF2EC, 0x8957 },
    { 0xF2ED, 0x8961 },
    { 0xF2EE, 0x895C },
    { 0xF2EF, 0x8958 },
    { 0xF2F0, 0x895D },
    { 0xF2F1, 0x8959 },
    { 0xF2F2, 0x8988 },
    { 0xF2F3, 0x89B7 },
    { 0xF2F4, 0x89B6 },
    { 0xF2F5, 0x89F6 },
    { 0xF2F6, 0x8B50 },
    { 0xF2F7, 0x8B48 },
    { 0xF2F8, 0x8B4A },
    { 0xF2F9, 0x8B40 },
    { 0xF2FA, 0x8B53 },
    { 0xF2FB, 0x8B56 },
    { 0xF2FC, 0x8B54 },
    { 0xF2FD, 0x8B4B },
    { 0xF2FE, 0x8B55 },
    { 0xF340, 0x8B51 },
    { 0xF341, 0x8B42 },
    { 0xF342, 0x8B52 },
    { 0xF343, 0x8B57 },
    { 0xF344, 0x8C43 },
    { 0xF345, 0x8C77 },
    { 0xF346, 0x8C76 },
    { 0xF347, 0x8C9A },
    { 0xF348, 0x8D06 },
    { 0xF349, 0x8D07 },
    { 0xF34A, 0x8D09 },
    { 0xF34B, 0x8DAC },
    { 0xF34C, 0x8DAA },
    { 0xF34D, 0x8DAD },
    { 0xF34E, 0x8DAB },
    { 0xF34F, 0x8E6D },
    { 0xF350, 0x8E78 },
    { 0xF351, 0x8E73 },
    { 0xF352, 0x8E6A },
    { 0xF353, 0x8E6F },
    { 0xF354, 0x8E7B },
    { 0xF355, 0x8EC2 },
    { 0xF356, 0x8F52 },
    { 0xF357, 0x8F51 },
    { 0xF358, 0x8F4F },
    { 0xF359, 0x8F50 },
    { 0xF35A, 0x8F53 },
    { 0xF35B, 0x8FB4 },
    { 0xF35C, 0x9140 },
    { 0xF35D, 0x913F },
    { 0xF35E, 0x91B0 },
    { 0xF35F, 0x91AD },
    { 0xF360, 0x93DE },
    { 0xF361, 0x93C7 },
    { 0xF362, 0x93CF },
    { 0xF363, 0x93C2 },
    { 0xF364, 0x93DA },
    { 0xF365, 0x93D0 },
    { 0xF366, 0x93F9 },
    { 0xF367, 0x93EC },
    { 0xF368, 0x93CC },
    { 0xF369, 0x93D9 },
    { 0xF36A, 0x93A9 },
    { 0xF36B, 0x93E6 },
    { 0xF36C, 0x93CA },
    { 0xF36D, 0x93D4 },
    { 0xF36E, 0x93EE },
    { 0xF36F, 0x93E3 },
    { 0xF370, 0x93D5 },
    { 0xF371, 0x93C4 },
    { 0xF372, 0x93CE },
    { 0xF373, 0x93C0 },
    { 0xF374, 0x93D2 },
    { 0xF375, 0x93E7 },
    { 0xF376, 0x957D },
    { 0xF377, 0x95DA },
    { 0xF378, 0x95DB },
    { 0xF379, 0x96E1 },
    { 0xF37A, 0x9729 },
    { 0xF37B, 0x972B },
    { 0xF37C, 0x972C },
    { 0xF37D, 0x9728 },
    { 0xF37E, 0x9726 },
    { 0xF3A1, 0x97B3 },
    { 0xF3A2, 0x97B7 },
    { 0xF3A3, 0x97B6 },
    { 0xF3A4, 0x97DD },
    { 0xF3A5, 0x97DE },
    { 0xF3A6, 0x97DF },
    { 0xF3A7, 0x985C },
    { 0xF3A8, 0x9859 },
    { 0xF3A9, 0x985D },
    { 0xF3AA, 0x9857 },
    { 0xF3AB, 0x98BF },
    { 0xF3AC, 0x98BD },
    { 0xF3AD, 0x98BB },
    { 0xF3AE, 0x98BE },
    { 0xF3AF, 0x9948 },
    { 0xF3B0, 0x9947 },
    { 0xF3B1, 0x9943 },
    { 0xF3B2, 0x99A6 },
    { 0xF3B3, 0x99A7 },
    { 0xF3B4, 0x9A1A },
    { 0xF3B5, 0x9A15 },
    { 0xF3B6, 0x9A25 },
    { 0xF3B7, 0x9A1D },
    { 0xF3B8, 0x9A24 },
    { 0xF3B9, 0x9A1B },
    { 0xF3BA, 0x9A22 },
    { 0xF3BB, 0x9A20 },
    { 0xF3BC, 0x9A27 },
    { 0xF3BD, 0x9A23 },
    { 0xF3BE, 0x9A1E },
    { 0xF3BF, 0x9A1C },
    { 0xF3C0, 0x9A14 },
    { 0xF3C1, 0x9AC2 },
    { 0xF3C2, 0x9B0B },
    { 0xF3C3, 0x9B0A },
    { 0xF3C4, 0x9B0E },
    { 0xF3C5, 0x9B0C },
    { 0xF3C6, 0x9B37 },
    { 0xF3C7, 0x9BEA },
    { 0xF3C8, 0x9BEB },
    { 0xF3C9, 0x9BE0 },
    { 0xF3CA, 0x9BDE },
    { 0xF3CB, 0x9BE4 },
    { 0xF3CC, 0x9BE6 },
    { 0xF3CD, 0x9BE2 },
    { 0xF3CE, 0x9BF0 },
    { 0xF3CF, 0x9BD4 },
    { 0xF3D0, 0x9BD7 },
    { 0xF3D1, 0x9BEC },
    { 0xF3D2, 0x9BDC },
    { 0xF3D3, 0x9BD9 },
    { 0xF3D4, 0x9BE5 },
    { 0xF3D5, 0x9BD5 },
    { 0xF3D6, 0x9BE1 },
    { 0xF3D7, 0x9BDA },
    { 0xF3D8, 0x9D77 },
    { 0xF3D9, 0x9D81 },
    { 0xF3DA, 0x9D8A },
    { 0xF3DB, 0x9D84 },
    { 0xF3DC, 0x9D88 },
    { 0xF3DD, 0x9D71 },
    { 0xF3DE, 0x9D80 },
    { 0xF3DF, 0x9D78 },
    { 0xF3E0, 0x9D86 },
    { 0xF3E1, 0x9D8B },
    { 0xF3E2, 0x9D8C },
    { 0xF3E3, 0x9D7D },
    { 0xF3E4, 0x9D6B },
    { 0xF3E5, 0x9D74 },
    { 0xF3E6, 0x9D75 },
    { 0xF3E7, 0x9D70 },
    { 0xF3E8, 0x9D69 },
    { 0xF3E9, 0x9D85 },
    { 0xF3EA, 0x9D73 },
    { 0xF3EB, 0x9D7B },
    { 0xF3EC, 0x9D82 },
    { 0xF3ED, 0x9D6F },
    { 0xF3EE, 0x9D79 },
    { 0xF3EF, 0x9D7F },
    { 0xF3F0, 0x9D87 },
    { 0xF3F1, 0x9D68 },
    { 0xF3F2, 0x9E94 },
    { 0xF3F3, 0x9E91 },
    { 0xF3F4, 0x9EC0 },
    { 0xF3F5, 0x9EFC },
    { 0xF3F6, 0x9F2D },
    { 0xF3F7, 0x9F40 },
    { 0xF3F8, 0x9F41 },
    { 0xF3F9, 0x9F4D },
    { 0xF3FA, 0x9F56 },
    { 0xF3FB, 0x9F57 },
    { 0xF3FC, 0x9F58 },
    { 0xF3FD, 0x5337 },
    { 0xF3FE, 0x56B2 },
    { 0xF440, 0x56B5 },
    { 0xF441, 0x56B3 },
    { 0xF442, 0x58E3 },
    { 0xF443, 0x5B45 },
    { 0xF444, 0x5DC6 },
    { 0xF445, 0x5DC7 },
    { 0xF446, 0x5EEE },
    { 0xF447, 0x5EEF },
    { 0xF448, 0x5FC0 },
    { 0xF449, 0x5FC1 },
    { 0xF44A, 0x61F9 },
    { 0xF44B, 0x6517 },
    { 0xF44C, 0x6516 },
    { 0xF44D, 0x6515 },
    { 0xF44E, 0x6513 },
    { 0xF44F, 0x65DF },
    { 0xF450, 0x66E8 },
    { 0xF451, 0x66E3 },
    { 0xF452, 0x66E4 },
    { 0xF453, 0x6AF3 },
    { 0xF454, 0x6AF0 },
    { 0xF455, 0x6AEA },
    { 0xF456, 0x6AE8 },
    { 0xF457, 0x6AF9 },
    { 0xF458, 0x6AF1 },
    { 0xF459, 0x6AEE },
    { 0xF45A, 0x6AEF },
    { 0xF45B, 0x703C },
    { 0xF45C, 0x7035 },
    { 0xF45D, 0x702F },
    { 0xF45E, 0x7037 },
    { 0xF45F, 0x7034 },
    { 0xF460, 0x7031 },
    { 0xF461, 0x7042 },
    { 0xF462, 0x7038 },
    { 0xF463, 0x703F },
    { 0xF464, 0x703A },
    { 0xF465, 0x7039 },
    { 0xF466, 0x7040 },
    { 0xF467, 0x703B },
    { 0xF468, 0x7033 },
    { 0xF469, 0x7041 },
    { 0xF46A, 0x7213 },
    { 0xF46B, 0x7214 },
    { 0xF46C, 0x72A8 },
    { 0xF46D, 0x737D },
    { 0xF46E, 0x737C },
    { 0xF46F, 0x74BA },
    { 0xF470, 0x76AB },
    { 0xF471, 0x76AA },
    { 0xF472, 0x76BE },
    { 0xF473, 0x76ED },
    { 0xF474, 0x77CC },
    { 0xF475, 0x77CE },
    { 0xF476, 0x77CF },
    { 0xF477, 0x77CD },
    { 0xF478, 0x77F2 },
    { 0xF479, 0x7925 },
    { 0xF47A, 0x7923 },
    { 0xF47B, 0x7927 },
    { 0xF47C, 0x7928 },
    { 0xF47D, 0x7924 },
    { 0xF47E, 0x7929 },
    { 0xF4A1, 0x79B2 },
    { 0xF4A2, 0x7A6E },
    { 0xF4A3, 0x7A6C },
    { 0xF4A4, 0x7A6D },
    { 0xF4A5, 0x7AF7 },
    { 0xF4A6, 0x7C49 },
    { 0xF4A7, 0x7C48 },
    { 0xF4A8, 0x7C4A },
    { 0xF4A9, 0x7C47 },
    { 0xF4AA, 0x7C45 },
    { 0xF4AB, 0x7CEE },
    { 0xF4AC, 0x7E7B },
    { 0xF4AD, 0x7E7E },
    { 0xF4AE, 0x7E81 },
    { 0xF4AF, 0x7E80 },
    { 0xF4B0, 0x7FBA },
    { 0xF4B1, 0x7FFF },
    { 0xF4B2, 0x8079 },
    { 0xF4B3, 0x81DB },
    { 0xF4B4, 0x81D9 },
    { 0xF4B5, 0x820B },
    { 0xF4B6, 0x8268 },
    { 0xF4B7, 0x8269 },
    { 0xF4B8, 0x8622 },
    { 0xF4B9, 0x85FF },
    { 0xF4BA, 0x8601 },
    { 0xF4BB, 0x85FE },
    { 0xF4BC, 0x861B },
    { 0xF4BD, 0x8600 },
    { 0xF4BE, 0x85F6 },
    { 0xF4BF, 0x8604 },
    { 0xF4C0, 0x8609 },
    { 0xF4C1, 0x8605 },
    { 0xF4C2, 0x860C },
    { 0xF4C3, 0x85FD },
    { 0xF4C4, 0x8819 },
    { 0xF4C5, 0x8810 },
    { 0xF4C6, 0x8811 },
    { 0xF4C7, 0x8817 },
    { 0xF4C8, 0x8813 },
    { 0xF4C9, 0x8816 },
    { 0xF4CA, 0x8963 },
    { 0xF4CB, 0x8966 },
    { 0xF4CC, 0x89B9 },
    { 0xF4CD, 0x89F7 },
    { 0xF4CE, 0x8B60 },
    { 0xF4CF, 0x8B6A },
    { 0xF4D0, 0x8B5D },
    { 0xF4D1, 0x8B68 },
    { 0xF4D2, 0x8B63 },
    { 0xF4D3, 0x8B65 },
    { 0xF4D4, 0x8B67 },
    { 0xF4D5, 0x8B6D },
    { 0xF4D6, 0x8DAE },
    { 0xF4D7, 0x8E86 },
    { 0xF4D8, 0x8E88 },
    { 0xF4D9, 0x8E84 },
    { 0xF4DA, 0x8F59 },
    { 0xF4DB, 0x8F56 },
    { 0xF4DC, 0x8F57 },
    { 0xF4DD, 0x8F55 },
    { 0xF4DE, 0x8F58 },
    { 0xF4DF, 0x8F5A },
    { 0xF4E0, 0x908D },
    { 0xF4E1, 0x9143 },
    { 0xF4E2, 0x9141 },
    { 0xF4E3, 0x91B7 },
    { 0xF4E4, 0x91B5 },
    { 0xF4E5, 0x91B2 },
    { 0xF4E6, 0x91B3 },
    { 0xF4E7, 0x940B },
    { 0xF4E8, 0x9413 },
    { 0xF4E9, 0x93FB },
    { 0xF4EA, 0x9420 },
    { 0xF4EB, 0x940F },
    { 0xF4EC, 0x9414 },
    { 0xF4ED, 0x93FE },
    { 0xF4EE, 0x9415 },
    { 0xF4EF, 0x9410 },
    { 0xF4F0, 0x9428 },
    { 0xF4F1, 0x9419 },
    { 0xF4F2, 0x940D },
    { 0xF4F3, 0x93F5 },
    { 0xF4F4, 0x9400 },
    { 0xF4F5, 0x93F7 },
    { 0xF4F6, 0x9407 },
    { 0xF4F7, 0x940E },
    { 0xF4F8, 0x9416 },
    { 0xF4F9, 0x9412 },
    { 0xF4FA, 0x93FA },
    { 0xF4FB, 0x9409 },
    { 0xF4FC, 0x93F8 },
    { 0xF4FD, 0x940A },
    { 0xF4FE, 0x93FF },
    { 0xF540, 0x93FC },
    { 0xF541, 0x940C },
    { 0xF542, 0x93F6 },
    { 0xF543, 0x9411 },
    { 0xF544, 0x9406 },
    { 0xF545, 0x95DE },
    { 0xF546, 0x95E0 },
    { 0xF547, 0x95DF },
    { 0xF548, 0x972E },
    { 0xF549, 0x972F },
    { 0xF54A, 0x97B9 },
    { 0xF54B, 0x97BB },
    { 0xF54C, 0x97FD },
    { 0xF54D, 0x97FE },
    { 0xF54E, 0x9860 },
    { 0xF54F, 0x9862 },
    { 0xF550, 0x9863 },
    { 0xF551, 0x985F },
    { 0xF552, 0x98C1 },
    { 0xF553, 0x98C2 },
    { 0xF554, 0x9950 },
    { 0xF555, 0x994E },
    { 0xF556, 0x9959 },
    { 0xF557, 0x994C },
    { 0xF558, 0x994B },
    { 0xF559, 0x9953 },
    { 0xF55A, 0x9A32 },
    { 0xF55B, 0x9A34 },
    { 0xF55C, 0x9A31 },
    { 0xF55D, 0x9A2C },
    { 0xF55E, 0x9A2A },
    { 0xF55F, 0x9A36 },
    { 0xF560, 0x9A29 },
    { 0xF561, 0x9A2E },
    { 0xF562, 0x9A38 },
    { 0xF563, 0x9A2D },
    { 0xF564, 0x9AC7 },
    { 0xF565, 0x9ACA },
    { 0xF566, 0x9AC6 },
    { 0xF567, 0x9B10 },
    { 0xF568, 0x9B12 },
    { 0xF569, 0x9B11 },
    { 0xF56A, 0x9C0B },
    { 0xF56B, 0x9C08 },
    { 0xF56C, 0x9BF7 },
    { 0xF56D, 0x9C05 },
    { 0xF56E, 0x9C12 },
    { 0xF56F, 0x9BF8 },
    { 0xF570, 0x9C40 },
    { 0xF571, 0x9C07 },
    { 0xF572, 0x9C0E },
    { 0xF573, 0x9C06 },
    { 0xF574, 0x9C17 },
    { 0xF575, 0x9C14 },
    { 0xF576, 0x9C09 },
    { 0xF577, 0x9D9F },
    { 0xF578, 0x9D99 },
    { 0xF579, 0x9DA4 },
    { 0xF57A, 0x9D9D },
    { 0xF57B, 0x9D92 },
    { 0xF57C, 0x9D98 },
    { 0xF57D, 0x9D90 },
    { 0xF57E, 0x9D9B },
    { 0xF5A1, 0x9DA0 },
    { 0xF5A2, 0x9D94 },
    { 0xF5A3, 0x9D9C },
    { 0xF5A4, 0x9DAA },
    { 0xF5A5, 0x9D97 },
    { 0xF5A6, 0x9DA1 },
    { 0xF5A7, 0x9D9A },
    { 0xF5A8, 0x9DA2 },
    { 0xF5A9, 0x9DA8 },
    { 0xF5AA, 0x9D9E },
    { 0xF5AB, 0x9DA3 },
    { 0xF5AC, 0x9DBF },
    { 0xF5AD, 0x9DA9 },
    { 0xF5AE, 0x9D96 },
    { 0xF5AF, 0x9DA6 },
    { 0xF5B0, 0x9DA7 },
    { 0xF5B1, 0x9E99 },
    { 0xF5B2, 0x9E9B },
    { 0xF5B3, 0x9E9A },
    { 0xF5B4, 0x9EE5 },
    { 0xF5B5, 0x9EE4 },
    { 0xF5B6, 0x9EE7 },
    { 0xF5B7, 0x9EE6 },
    { 0xF5B8, 0x9F30 },
    { 0xF5B9, 0x9F2E },
    { 0xF5BA, 0x9F5B },
    { 0xF5BB, 0x9F60 },
    { 0xF5BC, 0x9F5E },
    { 0xF5BD, 0x9F5D },
    { 0xF5BE, 0x9F59 },
    { 0xF5BF, 0x9F91 },
    { 0xF5C0, 0x513A },
    { 0xF5C1, 0x5139 },
    { 0xF5C2, 0x5298 },
    { 0xF5C3, 0x5297 },
    { 0xF5C4, 0x56C3 },
    { 0xF5C5, 0x56BD },
    { 0xF5C6, 0x56BE },
    { 0xF5C7, 0x5B48 },
    { 0xF5C8, 0x5B47 },
    { 0xF5C9, 0x5DCB },
    { 0xF5CA, 0x5DCF },
    { 0xF5CB, 0x5EF1 },
    { 0xF5CC, 0x61FD },
    { 0xF5CD, 0x651B },
    { 0xF5CE, 0x6B02 },
    { 0xF5CF, 0x6AFC },
    { 0xF5D0, 0x6B03 },
    { 0xF5D1, 0x6AF8 },
    { 0xF5D2, 0x6B00 },
    { 0xF5D3, 0x7043 },
    { 0xF5D4, 0x7044 },
    { 0xF5D5, 0x704A },
    { 0xF5D6, 0x7048 },
    { 0xF5D7, 0x7049 },
    { 0xF5D8, 0x7045 },
    { 0xF5D9, 0x7046 },
    { 0xF5DA, 0x721D },
    { 0xF5DB, 0x721A },
    { 0xF5DC, 0x7219 },
    { 0xF5DD, 0x737E },
    { 0xF5DE, 0x7517 },
    { 0xF5DF, 0x766A },
    { 0xF5E0, 0x77D0 },
    { 0xF5E1, 0x792D },
    { 0xF5E2, 0x7931 },
    { 0xF5E3, 0x792F },
    { 0xF5E4, 0x7C54 },
    { 0xF5E5, 0x7C53 },
    { 0xF5E6, 0x7CF2 },
    { 0xF5E7, 0x7E8A },
    { 0xF5E8, 0x7E87 },
    { 0xF5E9, 0x7E88 },
    { 0xF5EA, 0x7E8B },
    { 0xF5EB, 0x7E86 },
    { 0xF5EC, 0x7E8D },
    { 0xF5ED, 0x7F4D },
    { 0xF5EE, 0x7FBB },
    { 0xF5EF, 0x8030 },
    { 0xF5F0, 0x81DD },
    { 0xF5F1, 0x8618 },
    { 0xF5F2, 0x862A },
    { 0xF5F3, 0x8626 },
    { 0xF5F4, 0x861F },
    { 0xF5F5, 0x8623 },
    { 0xF5F6, 0x861C },
    { 0xF5F7, 0x8619 },
    { 0xF5F8, 0x8627 },
    { 0xF5F9, 0x862E },
    { 0xF5FA, 0x8621 },
    { 0xF5FB, 0x8620 },
    { 0xF5FC, 0x8629 },
    { 0xF5FD, 0x861E },
    { 0xF5FE, 0x8625 },
    { 0xF640, 0x8829 },
    { 0xF641, 0x881D },
    { 0xF642, 0x881B },
    { 0xF643, 0x8820 },
    { 0xF644, 0x8824 },
    { 0xF645, 0x881C },
    { 0xF646, 0x882B },
    { 0xF647, 0x884A },
    { 0xF648, 0x896D },
    { 0xF649, 0x8969 },
    { 0xF64A, 0x896E },
    { 0xF64B, 0x896B },
    { 0xF64C, 0x89FA },
    { 0xF64D, 0x8B79 },
    { 0xF64E, 0x8B78 },
    { 0xF64F, 0x8B45 },
    { 0xF650, 0x8B7A },
    { 0xF651, 0x8B7B },
    { 0xF652, 0x8D10 },
    { 0xF653, 0x8D14 },
    { 0xF654, 0x8DAF },
    { 0xF655, 0x8E8E },
    { 0xF656, 0x8E8C },
    { 0xF657, 0x8F5E },
    { 0xF658, 0x8F5B },
    { 0xF659, 0x8F5D },
    { 0xF65A, 0x9146 },
    { 0xF65B, 0x9144 },
    { 0xF65C, 0x9145 },
    { 0xF65D, 0x91B9 },
    { 0xF65E, 0x943F },
    { 0xF65F, 0x943B },
    { 0xF660, 0x9436 },
    { 0xF661, 0x9429 },
    { 0xF662, 0x943D },
    { 0xF663, 0x943C },
    { 0xF664, 0x9430 },
    { 0xF665, 0x9439 },
    { 0xF666, 0x942A },
    { 0xF667, 0x9437 },
    { 0xF668, 0x942C },
    { 0xF669, 0x9440 },
    { 0xF66A, 0x9431 },
    { 0xF66B, 0x95E5 },
    { 0xF66C, 0x95E4 },
    { 0xF66D, 0x95E3 },
    { 0xF66E, 0x9735 },
    { 0xF66F, 0x973A },
    { 0xF670, 0x97BF },
    { 0xF671, 0x97E1 },
    { 0xF672, 0x9864 },
    { 0xF673, 0x98C9 },
    { 0xF674, 0x98C6 },
    { 0xF675, 0x98C0 },
    { 0xF676, 0x9958 },
    { 0xF677, 0x9956 },
    { 0xF678, 0x9A39 },
    { 0xF679, 0x9A3D },
    { 0xF67A, 0x9A46 },
    { 0xF67B, 0x9A44 },
    { 0xF67C, 0x9A42 },
    { 0xF67D, 0x9A41 },
    { 0xF67E, 0x9A3A },
    { 0xF6A1, 0x9A3F },
    { 0xF6A2, 0x9ACD },
    { 0xF6A3, 0x9B15 },
    { 0xF6A4, 0x9B17 },
    { 0xF6A5, 0x9B18 },
    { 0xF6A6, 0x9B16 },
    { 0xF6A7, 0x9B3A },
    { 0xF6A8, 0x9B52 },
    { 0xF6A9, 0x9C2B },
    { 0xF6AA, 0x9C1D },
    { 0xF6AB, 0x9C1C },
    { 0xF6AC, 0x9C2C },
    { 0xF6AD, 0x9C23 },
    { 0xF6AE, 0x9C28 },
    { 0xF6AF, 0x9C29 },
    { 0xF6B0, 0x9C24 },
    { 0xF6B1, 0x9C21 },
    { 0xF6B2, 0x9DB7 },
    { 0xF6B3, 0x9DB6 },
    { 0xF6B4, 0x9DBC },
    { 0xF6B5, 0x9DC1 },
    { 0xF6B6, 0x9DC7 },
    { 0xF6B7, 0x9DCA },
    { 0xF6B8, 0x9DCF },
    { 0xF6B9, 0x9DBE },
    { 0xF6BA, 0x9DC5 },
    { 0xF6BB, 0x9DC3 },
    { 0xF6BC, 0x9DBB },
    { 0xF6BD, 0x9DB5 },
    { 0xF6BE, 0x9DCE },
    { 0xF6BF, 0x9DB9 },
    { 0xF6C0, 0x9DBA },
    { 0xF6C1, 0x9DAC },
    { 0xF6C2, 0x9DC8 },
    { 0xF6C3, 0x9DB1 },
    { 0xF6C4, 0x9DAD },
    { 0xF6C5, 0x9DCC },
    { 0xF6C6, 0x9DB3 },
    { 0xF6C7, 0x9DCD },
    { 0xF6C8, 0x9DB2 },
    { 0xF6C9, 0x9E7A },
    { 0xF6CA, 0x9E9C },
    { 0xF6CB, 0x9EEB },
    { 0xF6CC, 0x9EEE },
    { 0xF6CD, 0x9EED },
    { 0xF6CE, 0x9F1B },
    { 0xF6CF, 0x9F18 },
    { 0xF6D0, 0x9F1A },
    { 0xF6D1, 0x9F31 },
    { 0xF6D2, 0x9F4E },
    { 0xF6D3, 0x9F65 },
    { 0xF6D4, 0x9F64 },
    { 0xF6D5, 0x9F92 },
    { 0xF6D6, 0x4EB9 },
    { 0xF6D7, 0x56C6 },
    { 0xF6D8, 0x56C5 },
    { 0xF6D9, 0x56CB },
    { 0xF6DA, 0x5971 },
    { 0xF6DB, 0x5B4B },
    { 0xF6DC, 0x5B4C },
    { 0xF6DD, 0x5DD5 },
    { 0xF6DE, 0x5DD1 },
    { 0xF6DF, 0x5EF2 },
    { 0xF6E0, 0x6521 },
    { 0xF6E1, 0x6520 },
    { 0xF6E2, 0x6526 },
    { 0xF6E3, 0x6522 },
    { 0xF6E4, 0x6B0B },
    { 0xF6E5, 0x6B08 },
    { 0xF6E6, 0x6B09 },
    { 0xF6E7, 0x6C0D },
    { 0xF6E8, 0x7055 },
    { 0xF6E9, 0x7056 },
    { 0xF6EA, 0x7057 },
    { 0xF6EB, 0x7052 },
    { 0xF6EC, 0x721E },
    { 0xF6ED, 0x721F },
    { 0xF6EE, 0x72A9 },
    { 0xF6EF, 0x737F },
    { 0xF6F0, 0x74D8 },
    { 0xF6F1, 0x74D5 },
    { 0xF6F2, 0x74D9 },
    { 0xF6F3, 0x74D7 },
    { 0xF6F4, 0x766D },
    { 0xF6F5, 0x76AD },
    { 0xF6F6, 0x7935 },
    { 0xF6F7, 0x79B4 },
    { 0xF6F8, 0x7A70 },
    { 0xF6F9, 0x7A71 },
    { 0xF6FA, 0x7C57 },
    { 0xF6FB, 0x7C5C },
    { 0xF6FC, 0x7C59 },
    { 0xF6FD, 0x7C5B },
    { 0xF6FE, 0x7C5A },
    { 0xF740, 0x7CF4 },
    { 0xF741, 0x7CF1 },
    { 0xF742, 0x7E91 },
    { 0xF743, 0x7F4F },
    { 0xF744, 0x7F87 },
    { 0xF745, 0x81DE },
    { 0xF746, 0x826B },
    { 0xF747, 0x8634 },
    { 0xF748, 0x8635 },
    { 0xF749, 0x8633 },
    { 0xF74A, 0x862C },
    { 0xF74B, 0x8632 },
    { 0xF74C, 0x8636 },
    { 0xF74D, 0x882C },
    { 0xF74E, 0x8828 },
    { 0xF74F, 0x8826 },
    { 0xF750, 0x882A },
    { 0xF751, 0x8825 },
    { 0xF752, 0x8971 },
    { 0xF753, 0x89BF },
    { 0xF754, 0x89BE },
    { 0xF755, 0x89FB },
    { 0xF756, 0x8B7E },
    { 0xF757, 0x8B84 },
    { 0xF758, 0x8B82 },
    { 0xF759, 0x8B86 },
    { 0xF75A, 0x8B85 },
    { 0xF75B, 0x8B7F },
    { 0xF75C, 0x8D15 },
    { 0xF75D, 0x8E95 },
    { 0xF75E, 0x8E94 },
    { 0xF75F, 0x8E9A },
    { 0xF760, 0x8E92 },
    { 0xF761, 0x8E90 },
    { 0xF762, 0x8E96 },
    { 0xF763, 0x8E97 },
    { 0xF764, 0x8F60 },
    { 0xF765, 0x8F62 },
    { 0xF766, 0x9147 },
    { 0xF767, 0x944C },
    { 0xF768, 0x9450 },
    { 0xF769, 0x944A },
    { 0xF76A, 0x944B },
    { 0xF76B, 0x944F },
    { 0xF76C, 0x9447 },
    { 0xF76D, 0x9445 },
    { 0xF76E, 0x9448 },
    { 0xF76F, 0x9449 },
    { 0xF770, 0x9446 },
    { 0xF771, 0x973F },
    { 0xF772, 0x97E3 },
    { 0xF773, 0x986A },
    { 0xF774, 0x9869 },
    { 0xF775, 0x98CB },
    { 0xF776, 0x9954 },
    { 0xF777, 0x995B },
    { 0xF778, 0x9A4E },
    { 0xF779, 0x9A53 },
    { 0xF77A, 0x9A54 },
    { 0xF77B, 0x9A4C },
    { 0xF77C, 0x9A4F },
    { 0xF77D, 0x9A48 },
    { 0xF77E, 0x9A4A },
    { 0xF7A1, 0x9A49 },
    { 0xF7A2, 0x9A52 },
    { 0xF7A3, 0x9A50 },
    { 0xF7A4, 0x9AD0 },
    { 0xF7A5, 0x9B19 },
    { 0xF7A6, 0x9B2B },
    { 0xF7A7, 0x9B3B },
    { 0xF7A8, 0x9B56 },
    { 0xF7A9, 0x9B55 },
    { 0xF7AA, 0x9C46 },
    { 0xF7AB, 0x9C48 },
    { 0xF7AC, 0x9C3F },
    { 0xF7AD, 0x9C44 },
    { 0xF7AE, 0x9C39 },
    { 0xF7AF, 0x9C33 },
    { 0xF7B0, 0x9C41 },
    { 0xF7B1, 0x9C3C },
    { 0xF7B2, 0x9C37 },
    { 0xF7B3, 0x9C34 },
    { 0xF7B4, 0x9C32 },
    { 0xF7B5, 0x9C3D },
    { 0xF7B6, 0x9C36 },
    { 0xF7B7, 0x9DDB },
    { 0xF7B8, 0x9DD2 },
    { 0xF7B9, 0x9DDE },
    { 0xF7BA, 0x9DDA },
    { 0xF7BB, 0x9DCB },
    { 0xF7BC, 0x9DD0 },
    { 0xF7BD, 0x9DDC },
    { 0xF7BE, 0x9DD1 },
    { 0xF7BF, 0x9DDF },
    { 0xF7C0, 0x9DE9 },
    { 0xF7C1, 0x9DD9 },
    { 0xF7C2, 0x9DD8 },
    { 0xF7C3, 0x9DD6 },
    { 0xF7C4, 0x9DF5 },
    { 0xF7C5, 0x9DD5 },
    { 0xF7C6, 0x9DDD },
    { 0xF7C7, 0x9EB6 },
    { 0xF7C8, 0x9EF0 },
    { 0xF7C9, 0x9F35 },
    { 0xF7CA, 0x9F33 },
    { 0xF7CB, 0x9F32 },
    { 0xF7CC, 0x9F42 },
    { 0xF7CD, 0x9F6B },
    { 0xF7CE, 0x9F95 },
    { 0xF7CF, 0x9FA2 },
    { 0xF7D0, 0x513D },
    { 0xF7D1, 0x5299 },
    { 0xF7D2, 0x58E8 },
    { 0xF7D3, 0x58E7 },
    { 0xF7D4, 0x5972 },
    { 0xF7D5, 0x5B4D },
    { 0xF7D6, 0x5DD8 },
    { 0xF7D7, 0x882F },
    { 0xF7D8, 0x5F4F },
    { 0xF7D9, 0x6201 },
    { 0xF7DA, 0x6203 },
    { 0xF7DB, 0x6204 },
    { 0xF7DC, 0x6529 },
    { 0xF7DD, 0x6525 },
    { 0xF7DE, 0x6596 },
    { 0xF7DF, 0x66EB },
    { 0xF7E0, 0x6B11 },
    { 0xF7E1, 0x6B12 },
    { 0xF7E2, 0x6B0F },
    { 0xF7E3, 0x6BCA },
    { 0xF7E4, 0x705B },
    { 0xF7E5, 0x705A },
    { 0xF7E6, 0x7222 },
    { 0xF7E7, 0x7382 },
    { 0xF7E8, 0x7381 },
    { 0xF7E9, 0x7383 },
    { 0xF7EA, 0x7670 },
    { 0xF7EB, 0x77D4 },
    { 0xF7EC, 0x7C67 },
    { 0xF7ED, 0x7C66 },
    { 0xF7EE, 0x7E95 },
    { 0xF7EF, 0x826C },
    { 0xF7F0, 0x863A },
    { 0xF7F1, 0x8640 },
    { 0xF7F2, 0x8639 },
    { 0xF7F3, 0x863C },
    { 0xF7F4, 0x8631 },
    { 0xF7F5, 0x863B },
    { 0xF7F6, 0x863E },
    { 0xF7F7, 0x8830 },
    { 0xF7F8, 0x8832 },
    { 0xF7F9, 0x882E },
    { 0xF7FA, 0x8833 },
    { 0xF7FB, 0x8976 },
    { 0xF7FC, 0x8974 },
    { 0xF7FD, 0x8973 },
    { 0xF7FE, 0x89FE },
    { 0xF840, 0x8B8C },
    { 0xF841, 0x8B8E },
    { 0xF842, 0x8B8B },
    { 0xF843, 0x8B88 },
    { 0xF844, 0x8C45 },
    { 0xF845, 0x8D19 },
    { 0xF846, 0x8E98 },
    { 0xF847, 0x8F64 },
    { 0xF848, 0x8F63 },
    { 0xF849, 0x91BC },
    { 0xF84A, 0x9462 },
    { 0xF84B, 0x9455 },
    { 0xF84C, 0x945D },
    { 0xF84D, 0x9457 },
    { 0xF84E, 0x945E },
    { 0xF84F, 0x97C4 },
    { 0xF850, 0x97C5 },
    { 0xF851, 0x9800 },
    { 0xF852, 0x9A56 },
    { 0xF853, 0x9A59 },
    { 0xF854, 0x9B1E },
    { 0xF855, 0x9B1F },
    { 0xF856, 0x9B20 },
    { 0xF857, 0x9C52 },
    { 0xF858, 0x9C58 },
    { 0xF859, 0x9C50 },
    { 0xF85A, 0x9C4A },
    { 0xF85B, 0x9C4D },
    { 0xF85C, 0x9C4B },
    { 0xF85D, 0x9C55 },
    { 0xF85E, 0x9C59 },
    { 0xF85F, 0x9C4C },
    { 0xF860, 0x9C4E },
    { 0xF861, 0x9DFB },
    { 0xF862, 0x9DF7 },
    { 0xF863, 0x9DEF },
    { 0xF864, 0x9DE3 },
    { 0xF865, 0x9DEB },
    { 0xF866, 0x9DF8 },
    { 0xF867, 0x9DE4 },
    { 0xF868, 0x9DF6 },
    { 0xF869, 0x9DE1 },
    { 0xF86A, 0x9DEE },
    { 0xF86B, 0x9DE6 },
    { 0xF86C, 0x9DF2 },
    { 0xF86D, 0x9DF0 },
    { 0xF86E, 0x9DE2 },
    { 0xF86F, 0x9DEC },
    { 0xF870, 0x9DF4 },
    { 0xF871, 0x9DF3 },
    { 0xF872, 0x9DE8 },
    { 0xF873, 0x9DED },
    { 0xF874, 0x9EC2 },
    { 0xF875, 0x9ED0 },
    { 0xF876, 0x9EF2 },
    { 0xF877, 0x9EF3 },
    { 0xF878, 0x9F06 },
    { 0xF879, 0x9F1C },
    { 0xF87A, 0x9F38 },
    { 0xF87B, 0x9F37 },
    { 0xF87C, 0x9F36 },
    { 0xF87D, 0x9F43 },
    { 0xF87E, 0x9F4F },
    { 0xF8A1, 0x9F71 },
    { 0xF8A2, 0x9F70 },
    { 0xF8A3, 0x9F6E },
    { 0xF8A4, 0x9F6F },
    { 0xF8A5, 0x56D3 },
    { 0xF8A6, 0x56CD },
    { 0xF8A7, 0x5B4E },
    { 0xF8A8, 0x5C6D },
    { 0xF8A9, 0x652D },
    { 0xF8AA, 0x66ED },
    { 0xF8AB, 0x66EE },
    { 0xF8AC, 0x6B13 },
    { 0xF8AD, 0x705F },
    { 0xF8AE, 0x7061 },
    { 0xF8AF, 0x705D },
    { 0xF8B0, 0x7060 },
    { 0xF8B1, 0x7223 },
    { 0xF8B2, 0x74DB },
    { 0xF8B3, 0x74E5 },
    { 0xF8B4, 0x77D5 },
    { 0xF8B5, 0x7938 },
    { 0xF8B6, 0x79B7 },
    { 0xF8B7, 0x79B6 },
    { 0xF8B8, 0x7C6A },
    { 0xF8B9, 0x7E97 },
    { 0xF8BA, 0x7F89 },
    { 0xF8BB, 0x826D },
    { 0xF8BC, 0x8643 },
    { 0xF8BD, 0x8838 },
    { 0xF8BE, 0x8837 },
    { 0xF8BF, 0x8835 },
    { 0xF8C0, 0x884B },
    { 0xF8C1, 0x8B94 },
    { 0xF8C2, 0x8B95 },
    { 0xF8C3, 0x8E9E },
    { 0xF8C4, 0x8E9F },
    { 0xF8C5, 0x8EA0 },
    { 0xF8C6, 0x8E9D },
    { 0xF8C7, 0x91BE },
    { 0xF8C8, 0x91BD },
    { 0xF8C9, 0x91C2 },
    { 0xF8CA, 0x946B },
    { 0xF8CB, 0x9468 },
    { 0xF8CC, 0x9469 },
    { 0xF8CD, 0x96E5 },
    { 0xF8CE, 0x9746 },
    { 0xF8CF, 0x9743 },
    { 0xF8D0, 0x9747 },
    { 0xF8D1, 0x97C7 },
    { 0xF8D2, 0x97E5 },
    { 0xF8D3, 0x9A5E },
    { 0xF8D4, 0x9AD5 },
    { 0xF8D5, 0x9B59 },
    { 0xF8D6, 0x9C63 },
    { 0xF8D7, 0x9C67 },
    { 0xF8D8, 0x9C66 },
    { 0xF8D9, 0x9C62 },
    { 0xF8DA, 0x9C5E },
    { 0xF8DB, 0x9C60 },
    { 0xF8DC, 0x9E02 },
    { 0xF8DD, 0x9DFE },
    { 0xF8DE, 0x9E07 },
    { 0xF8DF, 0x9E03 },
    { 0xF8E0, 0x9E06 },
    { 0xF8E1, 0x9E05 },
    { 0xF8E2, 0x9E00 },
    { 0xF8E3, 0x9E01 },
    { 0xF8E4, 0x9E09 },
    { 0xF8E5, 0x9DFF },
    { 0xF8E6, 0x9DFD },
    { 0xF8E7, 0x9E04 },
    { 0xF8E8, 0x9EA0 },
    { 0xF8E9, 0x9F1E },
    { 0xF8EA, 0x9F46 },
    { 0xF8EB, 0x9F74 },
    { 0xF8EC, 0x9F75 },
    { 0xF8ED, 0x9F76 },
    { 0xF8EE, 0x56D4 },
    { 0xF8EF, 0x652E },
    { 0xF8F0, 0x65B8 },
    { 0xF8F1, 0x6B18 },
    { 0xF8F2, 0x6B19 },
    { 0xF8F3, 0x6B17 },
    { 0xF8F4, 0x6B1A },
    { 0xF8F5, 0x7062 },
    { 0xF8F6, 0x7226 },
    { 0xF8F7, 0x72AA },
    { 0xF8F8, 0x77D8 },
    { 0xF8F9, 0x77D9 },
    { 0xF8FA, 0x7939 },
    { 0xF8FB, 0x7C69 },
    { 0xF8FC, 0x7C6B },
    { 0xF8FD, 0x7CF6 },
    { 0xF8FE, 0x7E9A },
    { 0xF940, 0x7E98 },
    { 0xF941, 0x7E9B },
    { 0xF942, 0x7E99 },
    { 0xF943, 0x81E0 },
    { 0xF944, 0x81E1 },
    { 0xF945, 0x8646 },
    { 0xF946, 0x8647 },
    { 0xF947, 0x8648 },
    { 0xF948, 0x8979 },
    { 0xF949, 0x897A },
    { 0xF94A, 0x897C },
    { 0xF94B, 0x897B },
    { 0xF94C, 0x89FF },
    { 0xF94D, 0x8B98 },
    { 0xF94E, 0x8B99 },
    { 0xF94F, 0x8EA5 },
    { 0xF950, 0x8EA4 },
    { 0xF951, 0x8EA3 },
    { 0xF952, 0x946E },
    { 0xF953, 0x946D },
    { 0xF954, 0x946F },
    { 0xF955, 0x9471 },
    { 0xF956, 0x9473 },
    { 0xF957, 0x9749 },
    { 0xF958, 0x9872 },
    { 0xF959, 0x995F },
    { 0xF95A, 0x9C68 },
    { 0xF95B, 0x9C6E },
    { 0xF95C, 0x9C6D },
    { 0xF95D, 0x9E0B },
    { 0xF95E, 0x9E0D },
    { 0xF95F, 0x9E10 },
    { 0xF960, 0x9E0F },
    { 0xF961, 0x9E12 },
    { 0xF962, 0x9E11 },
    { 0xF963, 0x9EA1 },
    { 0xF964, 0x9EF5 },
    { 0xF965, 0x9F09 },
    { 0xF966, 0x9F47 },
    { 0xF967, 0x9F78 },
    { 0xF968, 0x9F7B },
    { 0xF969, 0x9F7A },
    { 0xF96A, 0x9F79 },
    { 0xF96B, 0x571E },
    { 0xF96C, 0x7066 },
    { 0xF96D, 0x7C6F },
    { 0xF96E, 0x883C },
    { 0xF96F, 0x8DB2 },
    { 0xF970, 0x8EA6 },
    { 0xF971, 0x91C3 },
    { 0xF972, 0x9474 },
    { 0xF973, 0x9478 },
    { 0xF974, 0x9476 },
    { 0xF975, 0x9475 },
    { 0xF976, 0x9A60 },
    { 0xF977, 0x9C74 },
    { 0xF978, 0x9C73 },
    { 0xF979, 0x9C71 },
    { 0xF97A, 0x9C75 },
    { 0xF97B, 0x9E14 },
    { 0xF97C, 0x9E13 },
    { 0xF97D, 0x9EF6 },
    { 0xF97E, 0x9F0A },
    { 0xF9A1, 0x9FA4 },
    { 0xF9A2, 0x7068 },
    { 0xF9A3, 0x7065 },
    { 0xF9A4, 0x7CF7 },
    { 0xF9A5, 0x866A },
    { 0xF9A6, 0x883E },
    { 0xF9A7, 0x883D },
    { 0xF9A8, 0x883F },
    { 0xF9A9, 0x8B9E },
    { 0xF9AA, 0x8C9C },
    { 0xF9AB, 0x8EA9 },
    { 0xF9AC, 0x8EC9 },
    { 0xF9AD, 0x974B },
    { 0xF9AE, 0x9873 },
    { 0xF9AF, 0x9874 },
    { 0xF9B0, 0x98CC },
    { 0xF9B1, 0x9961 },
    { 0xF9B2, 0x99AB },
    { 0xF9B3, 0x9A64 },
    { 0xF9B4, 0x9A66 },
    { 0xF9B5, 0x9A67 },
    { 0xF9B6, 0x9B24 },
    { 0xF9B7, 0x9E15 },
    { 0xF9B8, 0x9E17 },
    { 0xF9B9, 0x9F48 },
    { 0xF9BA, 0x6207 },
    { 0xF9BB, 0x6B1E },
    { 0xF9BC, 0x7227 },
    { 0xF9BD, 0x864C },
    { 0xF9BE, 0x8EA8 },
    { 0xF9BF, 0x9482 },
    { 0xF9C0, 0x9480 },
    { 0xF9C1, 0x9481 },
    { 0xF9C2, 0x9A69 },
    { 0xF9C3, 0x9A68 },
    { 0xF9C4, 0x9B2E },
    { 0xF9C5, 0x9E19 },
    { 0xF9C6, 0x7229 },
    { 0xF9C7, 0x864B },
    { 0xF9C8, 0x8B9F },
    { 0xF9C9, 0x9483 },
    { 0xF9CA, 0x9C79 },
    { 0xF9CB, 0x9EB7 },
    { 0xF9CC, 0x7675 },
    { 0xF9CD, 0x9A6B },
    { 0xF9CE, 0x9C7A },
    { 0xF9CF, 0x9E1D },
    { 0xF9D0, 0x7069 },
    { 0xF9D1, 0x706A },
    { 0xF9D2, 0x9EA4 },
    { 0xF9D3, 0x9F7E },
    { 0xF9D4, 0x9F49 },
    { 0xF9D5, 0x9F98 },
    };
    
    /*  Adapted from ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP932.TXT
        Column #1 is the cp932 code (in hex)
        Column #2 is the Unicode (in hex as 0xXXXX)
        Column #3 is the Unicode name (follows a comment sign, '//') */
const encoding_convert_entry CP932ToUnicodeTable[7916] =
{
    { 0xA1, 0xFF61 }, // HALFWIDTH IDEOGRAPHIC FULL STOP
    { 0xA2, 0xFF62 }, // HALFWIDTH LEFT CORNER BRACKET
    { 0xA3, 0xFF63 }, // HALFWIDTH RIGHT CORNER BRACKET
    { 0xA4, 0xFF64 }, // HALFWIDTH IDEOGRAPHIC COMMA
    { 0xA5, 0xFF65 }, // HALFWIDTH KATAKANA MIDDLE DOT
    { 0xA6, 0xFF66 }, // HALFWIDTH KATAKANA LETTER WO
    { 0xA7, 0xFF67 }, // HALFWIDTH KATAKANA LETTER SMALL A
    { 0xA8, 0xFF68 }, // HALFWIDTH KATAKANA LETTER SMALL I
    { 0xA9, 0xFF69 }, // HALFWIDTH KATAKANA LETTER SMALL U
    { 0xAA, 0xFF6A }, // HALFWIDTH KATAKANA LETTER SMALL E
    { 0xAB, 0xFF6B }, // HALFWIDTH KATAKANA LETTER SMALL O
    { 0xAC, 0xFF6C }, // HALFWIDTH KATAKANA LETTER SMALL YA
    { 0xAD, 0xFF6D }, // HALFWIDTH KATAKANA LETTER SMALL YU
    { 0xAE, 0xFF6E }, // HALFWIDTH KATAKANA LETTER SMALL YO
    { 0xAF, 0xFF6F }, // HALFWIDTH KATAKANA LETTER SMALL TU
    { 0xB0, 0xFF70 }, // HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
    { 0xB1, 0xFF71 }, // HALFWIDTH KATAKANA LETTER A
    { 0xB2, 0xFF72 }, // HALFWIDTH KATAKANA LETTER I
    { 0xB3, 0xFF73 }, // HALFWIDTH KATAKANA LETTER U
    { 0xB4, 0xFF74 }, // HALFWIDTH KATAKANA LETTER E
    { 0xB5, 0xFF75 }, // HALFWIDTH KATAKANA LETTER O
    { 0xB6, 0xFF76 }, // HALFWIDTH KATAKANA LETTER KA
    { 0xB7, 0xFF77 }, // HALFWIDTH KATAKANA LETTER KI
    { 0xB8, 0xFF78 }, // HALFWIDTH KATAKANA LETTER KU
    { 0xB9, 0xFF79 }, // HALFWIDTH KATAKANA LETTER KE
    { 0xBA, 0xFF7A }, // HALFWIDTH KATAKANA LETTER KO
    { 0xBB, 0xFF7B }, // HALFWIDTH KATAKANA LETTER SA
    { 0xBC, 0xFF7C }, // HALFWIDTH KATAKANA LETTER SI
    { 0xBD, 0xFF7D }, // HALFWIDTH KATAKANA LETTER SU
    { 0xBE, 0xFF7E }, // HALFWIDTH KATAKANA LETTER SE
    { 0xBF, 0xFF7F }, // HALFWIDTH KATAKANA LETTER SO
    { 0xC0, 0xFF80 }, // HALFWIDTH KATAKANA LETTER TA
    { 0xC1, 0xFF81 }, // HALFWIDTH KATAKANA LETTER TI
    { 0xC2, 0xFF82 }, // HALFWIDTH KATAKANA LETTER TU
    { 0xC3, 0xFF83 }, // HALFWIDTH KATAKANA LETTER TE
    { 0xC4, 0xFF84 }, // HALFWIDTH KATAKANA LETTER TO
    { 0xC5, 0xFF85 }, // HALFWIDTH KATAKANA LETTER NA
    { 0xC6, 0xFF86 }, // HALFWIDTH KATAKANA LETTER NI
    { 0xC7, 0xFF87 }, // HALFWIDTH KATAKANA LETTER NU
    { 0xC8, 0xFF88 }, // HALFWIDTH KATAKANA LETTER NE
    { 0xC9, 0xFF89 }, // HALFWIDTH KATAKANA LETTER NO
    { 0xCA, 0xFF8A }, // HALFWIDTH KATAKANA LETTER HA
    { 0xCB, 0xFF8B }, // HALFWIDTH KATAKANA LETTER HI
    { 0xCC, 0xFF8C }, // HALFWIDTH KATAKANA LETTER HU
    { 0xCD, 0xFF8D }, // HALFWIDTH KATAKANA LETTER HE
    { 0xCE, 0xFF8E }, // HALFWIDTH KATAKANA LETTER HO
    { 0xCF, 0xFF8F }, // HALFWIDTH KATAKANA LETTER MA
    { 0xD0, 0xFF90 }, // HALFWIDTH KATAKANA LETTER MI
    { 0xD1, 0xFF91 }, // HALFWIDTH KATAKANA LETTER MU
    { 0xD2, 0xFF92 }, // HALFWIDTH KATAKANA LETTER ME
    { 0xD3, 0xFF93 }, // HALFWIDTH KATAKANA LETTER MO
    { 0xD4, 0xFF94 }, // HALFWIDTH KATAKANA LETTER YA
    { 0xD5, 0xFF95 }, // HALFWIDTH KATAKANA LETTER YU
    { 0xD6, 0xFF96 }, // HALFWIDTH KATAKANA LETTER YO
    { 0xD7, 0xFF97 }, // HALFWIDTH KATAKANA LETTER RA
    { 0xD8, 0xFF98 }, // HALFWIDTH KATAKANA LETTER RI
    { 0xD9, 0xFF99 }, // HALFWIDTH KATAKANA LETTER RU
    { 0xDA, 0xFF9A }, // HALFWIDTH KATAKANA LETTER RE
    { 0xDB, 0xFF9B }, // HALFWIDTH KATAKANA LETTER RO
    { 0xDC, 0xFF9C }, // HALFWIDTH KATAKANA LETTER WA
    { 0xDD, 0xFF9D }, // HALFWIDTH KATAKANA LETTER N
    { 0xDE, 0xFF9E }, // HALFWIDTH KATAKANA VOICED SOUND MARK
    { 0xDF, 0xFF9F }, // HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
    { 0x8140, 0x3000 }, // IDEOGRAPHIC SPACE
    { 0x8141, 0x3001 }, // IDEOGRAPHIC COMMA
    { 0x8142, 0x3002 }, // IDEOGRAPHIC FULL STOP
    { 0x8143, 0xFF0C }, // FULLWIDTH COMMA
    { 0x8144, 0xFF0E }, // FULLWIDTH FULL STOP
    { 0x8145, 0x30FB }, // KATAKANA MIDDLE DOT
    { 0x8146, 0xFF1A }, // FULLWIDTH COLON
    { 0x8147, 0xFF1B }, // FULLWIDTH SEMICOLON
    { 0x8148, 0xFF1F }, // FULLWIDTH QUESTION MARK
    { 0x8149, 0xFF01 }, // FULLWIDTH EXCLAMATION MARK
    { 0x814A, 0x309B }, // KATAKANA-HIRAGANA VOICED SOUND MARK
    { 0x814B, 0x309C }, // KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    { 0x814C, 0x00B4 }, // ACUTE ACCENT
    { 0x814D, 0xFF40 }, // FULLWIDTH GRAVE ACCENT
    { 0x814E, 0x00A8 }, // DIAERESIS
    { 0x814F, 0xFF3E }, // FULLWIDTH CIRCUMFLEX ACCENT
    { 0x8150, 0xFFE3 }, // FULLWIDTH MACRON
    { 0x8151, 0xFF3F }, // FULLWIDTH LOW LINE
    { 0x8152, 0x30FD }, // KATAKANA ITERATION MARK
    { 0x8153, 0x30FE }, // KATAKANA VOICED ITERATION MARK
    { 0x8154, 0x309D }, // HIRAGANA ITERATION MARK
    { 0x8155, 0x309E }, // HIRAGANA VOICED ITERATION MARK
    { 0x8156, 0x3003 }, // DITTO MARK
    { 0x8157, 0x4EDD }, // CJK UNIFIED IDEOGRAPH
    { 0x8158, 0x3005 }, // IDEOGRAPHIC ITERATION MARK
    { 0x8159, 0x3006 }, // IDEOGRAPHIC CLOSING MARK
    { 0x815A, 0x3007 }, // IDEOGRAPHIC NUMBER ZERO
    { 0x815B, 0x30FC }, // KATAKANA-HIRAGANA PROLONGED SOUND MARK
    { 0x815C, 0x2015 }, // HORIZONTAL BAR
    { 0x815D, 0x2010 }, // HYPHEN
    { 0x815E, 0xFF0F }, // FULLWIDTH SOLIDUS
    { 0x815F, 0xFF3C }, // FULLWIDTH REVERSE SOLIDUS
    { 0x8160, 0xFF5E }, // FULLWIDTH TILDE
    { 0x8161, 0x2225 }, // PARALLEL TO
    { 0x8162, 0xFF5C }, // FULLWIDTH VERTICAL LINE
    { 0x8163, 0x2026 }, // HORIZONTAL ELLIPSIS
    { 0x8164, 0x2025 }, // TWO DOT LEADER
    { 0x8165, 0x2018 }, // LEFT SINGLE QUOTATION MARK
    { 0x8166, 0x2019 }, // RIGHT SINGLE QUOTATION MARK
    { 0x8167, 0x201C }, // LEFT DOUBLE QUOTATION MARK
    { 0x8168, 0x201D }, // RIGHT DOUBLE QUOTATION MARK
    { 0x8169, 0xFF08 }, // FULLWIDTH LEFT PARENTHESIS
    { 0x816A, 0xFF09 }, // FULLWIDTH RIGHT PARENTHESIS
    { 0x816B, 0x3014 }, // LEFT TORTOISE SHELL BRACKET
    { 0x816C, 0x3015 }, // RIGHT TORTOISE SHELL BRACKET
    { 0x816D, 0xFF3B }, // FULLWIDTH LEFT SQUARE BRACKET
    { 0x816E, 0xFF3D }, // FULLWIDTH RIGHT SQUARE BRACKET
    { 0x816F, 0xFF5B }, // FULLWIDTH LEFT CURLY BRACKET
    { 0x8170, 0xFF5D }, // FULLWIDTH RIGHT CURLY BRACKET
    { 0x8171, 0x3008 }, // LEFT ANGLE BRACKET
    { 0x8172, 0x3009 }, // RIGHT ANGLE BRACKET
    { 0x8173, 0x300A }, // LEFT DOUBLE ANGLE BRACKET
    { 0x8174, 0x300B }, // RIGHT DOUBLE ANGLE BRACKET
    { 0x8175, 0x300C }, // LEFT CORNER BRACKET
    { 0x8176, 0x300D }, // RIGHT CORNER BRACKET
    { 0x8177, 0x300E }, // LEFT WHITE CORNER BRACKET
    { 0x8178, 0x300F }, // RIGHT WHITE CORNER BRACKET
    { 0x8179, 0x3010 }, // LEFT BLACK LENTICULAR BRACKET
    { 0x817A, 0x3011 }, // RIGHT BLACK LENTICULAR BRACKET
    { 0x817B, 0xFF0B }, // FULLWIDTH PLUS SIGN
    { 0x817C, 0xFF0D }, // FULLWIDTH HYPHEN-MINUS
    { 0x817D, 0x00B1 }, // PLUS-MINUS SIGN
    { 0x817E, 0x00D7 }, // MULTIPLICATION SIGN
    { 0x8180, 0x00F7 }, // DIVISION SIGN
    { 0x8181, 0xFF1D }, // FULLWIDTH EQUALS SIGN
    { 0x8182, 0x2260 }, // NOT EQUAL TO
    { 0x8183, 0xFF1C }, // FULLWIDTH LESS-THAN SIGN
    { 0x8184, 0xFF1E }, // FULLWIDTH GREATER-THAN SIGN
    { 0x8185, 0x2266 }, // LESS-THAN OVER EQUAL TO
    { 0x8186, 0x2267 }, // GREATER-THAN OVER EQUAL TO
    { 0x8187, 0x221E }, // INFINITY
    { 0x8188, 0x2234 }, // THEREFORE
    { 0x8189, 0x2642 }, // MALE SIGN
    { 0x818A, 0x2640 }, // FEMALE SIGN
    { 0x818B, 0x00B0 }, // DEGREE SIGN
    { 0x818C, 0x2032 }, // PRIME
    { 0x818D, 0x2033 }, // DOUBLE PRIME
    { 0x818E, 0x2103 }, // DEGREE CELSIUS
    { 0x818F, 0xFFE5 }, // FULLWIDTH YEN SIGN
    { 0x8190, 0xFF04 }, // FULLWIDTH DOLLAR SIGN
    { 0x8191, 0xFFE0 }, // FULLWIDTH CENT SIGN
    { 0x8192, 0xFFE1 }, // FULLWIDTH POUND SIGN
    { 0x8193, 0xFF05 }, // FULLWIDTH PERCENT SIGN
    { 0x8194, 0xFF03 }, // FULLWIDTH NUMBER SIGN
    { 0x8195, 0xFF06 }, // FULLWIDTH AMPERSAND
    { 0x8196, 0xFF0A }, // FULLWIDTH ASTERISK
    { 0x8197, 0xFF20 }, // FULLWIDTH COMMERCIAL AT
    { 0x8198, 0x00A7 }, // SECTION SIGN
    { 0x8199, 0x2606 }, // WHITE STAR
    { 0x819A, 0x2605 }, // BLACK STAR
    { 0x819B, 0x25CB }, // WHITE CIRCLE
    { 0x819C, 0x25CF }, // BLACK CIRCLE
    { 0x819D, 0x25CE }, // BULLSEYE
    { 0x819E, 0x25C7 }, // WHITE DIAMOND
    { 0x819F, 0x25C6 }, // BLACK DIAMOND
    { 0x81A0, 0x25A1 }, // WHITE SQUARE
    { 0x81A1, 0x25A0 }, // BLACK SQUARE
    { 0x81A2, 0x25B3 }, // WHITE UP-POINTING TRIANGLE
    { 0x81A3, 0x25B2 }, // BLACK UP-POINTING TRIANGLE
    { 0x81A4, 0x25BD }, // WHITE DOWN-POINTING TRIANGLE
    { 0x81A5, 0x25BC }, // BLACK DOWN-POINTING TRIANGLE
    { 0x81A6, 0x203B }, // REFERENCE MARK
    { 0x81A7, 0x3012 }, // POSTAL MARK
    { 0x81A8, 0x2192 }, // RIGHTWARDS ARROW
    { 0x81A9, 0x2190 }, // LEFTWARDS ARROW
    { 0x81AA, 0x2191 }, // UPWARDS ARROW
    { 0x81AB, 0x2193 }, // DOWNWARDS ARROW
    { 0x81AC, 0x3013 }, // GETA MARK
    { 0x81B8, 0x2208 }, // ELEMENT OF
    { 0x81B9, 0x220B }, // CONTAINS AS MEMBER
    { 0x81BA, 0x2286 }, // SUBSET OF OR EQUAL TO
    { 0x81BB, 0x2287 }, // SUPERSET OF OR EQUAL TO
    { 0x81BC, 0x2282 }, // SUBSET OF
    { 0x81BD, 0x2283 }, // SUPERSET OF
    { 0x81BE, 0x222A }, // UNION
    { 0x81BF, 0x2229 }, // INTERSECTION
    { 0x81C8, 0x2227 }, // LOGICAL AND
    { 0x81C9, 0x2228 }, // LOGICAL OR
    { 0x81CA, 0xFFE2 }, // FULLWIDTH NOT SIGN
    { 0x81CB, 0x21D2 }, // RIGHTWARDS DOUBLE ARROW
    { 0x81CC, 0x21D4 }, // LEFT RIGHT DOUBLE ARROW
    { 0x81CD, 0x2200 }, // FOR ALL
    { 0x81CE, 0x2203 }, // THERE EXISTS
    { 0x81DA, 0x2220 }, // ANGLE
    { 0x81DB, 0x22A5 }, // UP TACK
    { 0x81DC, 0x2312 }, // ARC
    { 0x81DD, 0x2202 }, // PARTIAL DIFFERENTIAL
    { 0x81DE, 0x2207 }, // NABLA
    { 0x81DF, 0x2261 }, // IDENTICAL TO
    { 0x81E0, 0x2252 }, // APPROXIMATELY EQUAL TO OR THE IMAGE OF
    { 0x81E1, 0x226A }, // MUCH LESS-THAN
    { 0x81E2, 0x226B }, // MUCH GREATER-THAN
    { 0x81E3, 0x221A }, // SQUARE ROOT
    { 0x81E4, 0x223D }, // REVERSED TILDE
    { 0x81E5, 0x221D }, // PROPORTIONAL TO
    { 0x81E6, 0x2235 }, // BECAUSE
    { 0x81E7, 0x222B }, // INTEGRAL
    { 0x81E8, 0x222C }, // DOUBLE INTEGRAL
    { 0x81F0, 0x212B }, // ANGSTROM SIGN
    { 0x81F1, 0x2030 }, // PER MILLE SIGN
    { 0x81F2, 0x266F }, // MUSIC SHARP SIGN
    { 0x81F3, 0x266D }, // MUSIC FLAT SIGN
    { 0x81F4, 0x266A }, // EIGHTH NOTE
    { 0x81F5, 0x2020 }, // DAGGER
    { 0x81F6, 0x2021 }, // DOUBLE DAGGER
    { 0x81F7, 0x00B6 }, // PILCROW SIGN
    { 0x81FC, 0x25EF }, // LARGE CIRCLE
    { 0x824F, 0xFF10 }, // FULLWIDTH DIGIT ZERO
    { 0x8250, 0xFF11 }, // FULLWIDTH DIGIT ONE
    { 0x8251, 0xFF12 }, // FULLWIDTH DIGIT TWO
    { 0x8252, 0xFF13 }, // FULLWIDTH DIGIT THREE
    { 0x8253, 0xFF14 }, // FULLWIDTH DIGIT FOUR
    { 0x8254, 0xFF15 }, // FULLWIDTH DIGIT FIVE
    { 0x8255, 0xFF16 }, // FULLWIDTH DIGIT SIX
    { 0x8256, 0xFF17 }, // FULLWIDTH DIGIT SEVEN
    { 0x8257, 0xFF18 }, // FULLWIDTH DIGIT EIGHT
    { 0x8258, 0xFF19 }, // FULLWIDTH DIGIT NINE
    { 0x8260, 0xFF21 }, // FULLWIDTH LATIN CAPITAL LETTER A
    { 0x8261, 0xFF22 }, // FULLWIDTH LATIN CAPITAL LETTER B
    { 0x8262, 0xFF23 }, // FULLWIDTH LATIN CAPITAL LETTER C
    { 0x8263, 0xFF24 }, // FULLWIDTH LATIN CAPITAL LETTER D
    { 0x8264, 0xFF25 }, // FULLWIDTH LATIN CAPITAL LETTER E
    { 0x8265, 0xFF26 }, // FULLWIDTH LATIN CAPITAL LETTER F
    { 0x8266, 0xFF27 }, // FULLWIDTH LATIN CAPITAL LETTER G
    { 0x8267, 0xFF28 }, // FULLWIDTH LATIN CAPITAL LETTER H
    { 0x8268, 0xFF29 }, // FULLWIDTH LATIN CAPITAL LETTER I
    { 0x8269, 0xFF2A }, // FULLWIDTH LATIN CAPITAL LETTER J
    { 0x826A, 0xFF2B }, // FULLWIDTH LATIN CAPITAL LETTER K
    { 0x826B, 0xFF2C }, // FULLWIDTH LATIN CAPITAL LETTER L
    { 0x826C, 0xFF2D }, // FULLWIDTH LATIN CAPITAL LETTER M
    { 0x826D, 0xFF2E }, // FULLWIDTH LATIN CAPITAL LETTER N
    { 0x826E, 0xFF2F }, // FULLWIDTH LATIN CAPITAL LETTER O
    { 0x826F, 0xFF30 }, // FULLWIDTH LATIN CAPITAL LETTER P
    { 0x8270, 0xFF31 }, // FULLWIDTH LATIN CAPITAL LETTER Q
    { 0x8271, 0xFF32 }, // FULLWIDTH LATIN CAPITAL LETTER R
    { 0x8272, 0xFF33 }, // FULLWIDTH LATIN CAPITAL LETTER S
    { 0x8273, 0xFF34 }, // FULLWIDTH LATIN CAPITAL LETTER T
    { 0x8274, 0xFF35 }, // FULLWIDTH LATIN CAPITAL LETTER U
    { 0x8275, 0xFF36 }, // FULLWIDTH LATIN CAPITAL LETTER V
    { 0x8276, 0xFF37 }, // FULLWIDTH LATIN CAPITAL LETTER W
    { 0x8277, 0xFF38 }, // FULLWIDTH LATIN CAPITAL LETTER X
    { 0x8278, 0xFF39 }, // FULLWIDTH LATIN CAPITAL LETTER Y
    { 0x8279, 0xFF3A }, // FULLWIDTH LATIN CAPITAL LETTER Z
    { 0x8281, 0xFF41 }, // FULLWIDTH LATIN SMALL LETTER A
    { 0x8282, 0xFF42 }, // FULLWIDTH LATIN SMALL LETTER B
    { 0x8283, 0xFF43 }, // FULLWIDTH LATIN SMALL LETTER C
    { 0x8284, 0xFF44 }, // FULLWIDTH LATIN SMALL LETTER D
    { 0x8285, 0xFF45 }, // FULLWIDTH LATIN SMALL LETTER E
    { 0x8286, 0xFF46 }, // FULLWIDTH LATIN SMALL LETTER F
    { 0x8287, 0xFF47 }, // FULLWIDTH LATIN SMALL LETTER G
    { 0x8288, 0xFF48 }, // FULLWIDTH LATIN SMALL LETTER H
    { 0x8289, 0xFF49 }, // FULLWIDTH LATIN SMALL LETTER I
    { 0x828A, 0xFF4A }, // FULLWIDTH LATIN SMALL LETTER J
    { 0x828B, 0xFF4B }, // FULLWIDTH LATIN SMALL LETTER K
    { 0x828C, 0xFF4C }, // FULLWIDTH LATIN SMALL LETTER L
    { 0x828D, 0xFF4D }, // FULLWIDTH LATIN SMALL LETTER M
    { 0x828E, 0xFF4E }, // FULLWIDTH LATIN SMALL LETTER N
    { 0x828F, 0xFF4F }, // FULLWIDTH LATIN SMALL LETTER O
    { 0x8290, 0xFF50 }, // FULLWIDTH LATIN SMALL LETTER P
    { 0x8291, 0xFF51 }, // FULLWIDTH LATIN SMALL LETTER Q
    { 0x8292, 0xFF52 }, // FULLWIDTH LATIN SMALL LETTER R
    { 0x8293, 0xFF53 }, // FULLWIDTH LATIN SMALL LETTER S
    { 0x8294, 0xFF54 }, // FULLWIDTH LATIN SMALL LETTER T
    { 0x8295, 0xFF55 }, // FULLWIDTH LATIN SMALL LETTER U
    { 0x8296, 0xFF56 }, // FULLWIDTH LATIN SMALL LETTER V
    { 0x8297, 0xFF57 }, // FULLWIDTH LATIN SMALL LETTER W
    { 0x8298, 0xFF58 }, // FULLWIDTH LATIN SMALL LETTER X
    { 0x8299, 0xFF59 }, // FULLWIDTH LATIN SMALL LETTER Y
    { 0x829A, 0xFF5A }, // FULLWIDTH LATIN SMALL LETTER Z
    { 0x829F, 0x3041 }, // HIRAGANA LETTER SMALL A
    { 0x82A0, 0x3042 }, // HIRAGANA LETTER A
    { 0x82A1, 0x3043 }, // HIRAGANA LETTER SMALL I
    { 0x82A2, 0x3044 }, // HIRAGANA LETTER I
    { 0x82A3, 0x3045 }, // HIRAGANA LETTER SMALL U
    { 0x82A4, 0x3046 }, // HIRAGANA LETTER U
    { 0x82A5, 0x3047 }, // HIRAGANA LETTER SMALL E
    { 0x82A6, 0x3048 }, // HIRAGANA LETTER E
    { 0x82A7, 0x3049 }, // HIRAGANA LETTER SMALL O
    { 0x82A8, 0x304A }, // HIRAGANA LETTER O
    { 0x82A9, 0x304B }, // HIRAGANA LETTER KA
    { 0x82AA, 0x304C }, // HIRAGANA LETTER GA
    { 0x82AB, 0x304D }, // HIRAGANA LETTER KI
    { 0x82AC, 0x304E }, // HIRAGANA LETTER GI
    { 0x82AD, 0x304F }, // HIRAGANA LETTER KU
    { 0x82AE, 0x3050 }, // HIRAGANA LETTER GU
    { 0x82AF, 0x3051 }, // HIRAGANA LETTER KE
    { 0x82B0, 0x3052 }, // HIRAGANA LETTER GE
    { 0x82B1, 0x3053 }, // HIRAGANA LETTER KO
    { 0x82B2, 0x3054 }, // HIRAGANA LETTER GO
    { 0x82B3, 0x3055 }, // HIRAGANA LETTER SA
    { 0x82B4, 0x3056 }, // HIRAGANA LETTER ZA
    { 0x82B5, 0x3057 }, // HIRAGANA LETTER SI
    { 0x82B6, 0x3058 }, // HIRAGANA LETTER ZI
    { 0x82B7, 0x3059 }, // HIRAGANA LETTER SU
    { 0x82B8, 0x305A }, // HIRAGANA LETTER ZU
    { 0x82B9, 0x305B }, // HIRAGANA LETTER SE
    { 0x82BA, 0x305C }, // HIRAGANA LETTER ZE
    { 0x82BB, 0x305D }, // HIRAGANA LETTER SO
    { 0x82BC, 0x305E }, // HIRAGANA LETTER ZO
    { 0x82BD, 0x305F }, // HIRAGANA LETTER TA
    { 0x82BE, 0x3060 }, // HIRAGANA LETTER DA
    { 0x82BF, 0x3061 }, // HIRAGANA LETTER TI
    { 0x82C0, 0x3062 }, // HIRAGANA LETTER DI
    { 0x82C1, 0x3063 }, // HIRAGANA LETTER SMALL TU
    { 0x82C2, 0x3064 }, // HIRAGANA LETTER TU
    { 0x82C3, 0x3065 }, // HIRAGANA LETTER DU
    { 0x82C4, 0x3066 }, // HIRAGANA LETTER TE
    { 0x82C5, 0x3067 }, // HIRAGANA LETTER DE
    { 0x82C6, 0x3068 }, // HIRAGANA LETTER TO
    { 0x82C7, 0x3069 }, // HIRAGANA LETTER DO
    { 0x82C8, 0x306A }, // HIRAGANA LETTER NA
    { 0x82C9, 0x306B }, // HIRAGANA LETTER NI
    { 0x82CA, 0x306C }, // HIRAGANA LETTER NU
    { 0x82CB, 0x306D }, // HIRAGANA LETTER NE
    { 0x82CC, 0x306E }, // HIRAGANA LETTER NO
    { 0x82CD, 0x306F }, // HIRAGANA LETTER HA
    { 0x82CE, 0x3070 }, // HIRAGANA LETTER BA
    { 0x82CF, 0x3071 }, // HIRAGANA LETTER PA
    { 0x82D0, 0x3072 }, // HIRAGANA LETTER HI
    { 0x82D1, 0x3073 }, // HIRAGANA LETTER BI
    { 0x82D2, 0x3074 }, // HIRAGANA LETTER PI
    { 0x82D3, 0x3075 }, // HIRAGANA LETTER HU
    { 0x82D4, 0x3076 }, // HIRAGANA LETTER BU
    { 0x82D5, 0x3077 }, // HIRAGANA LETTER PU
    { 0x82D6, 0x3078 }, // HIRAGANA LETTER HE
    { 0x82D7, 0x3079 }, // HIRAGANA LETTER BE
    { 0x82D8, 0x307A }, // HIRAGANA LETTER PE
    { 0x82D9, 0x307B }, // HIRAGANA LETTER HO
    { 0x82DA, 0x307C }, // HIRAGANA LETTER BO
    { 0x82DB, 0x307D }, // HIRAGANA LETTER PO
    { 0x82DC, 0x307E }, // HIRAGANA LETTER MA
    { 0x82DD, 0x307F }, // HIRAGANA LETTER MI
    { 0x82DE, 0x3080 }, // HIRAGANA LETTER MU
    { 0x82DF, 0x3081 }, // HIRAGANA LETTER ME
    { 0x82E0, 0x3082 }, // HIRAGANA LETTER MO
    { 0x82E1, 0x3083 }, // HIRAGANA LETTER SMALL YA
    { 0x82E2, 0x3084 }, // HIRAGANA LETTER YA
    { 0x82E3, 0x3085 }, // HIRAGANA LETTER SMALL YU
    { 0x82E4, 0x3086 }, // HIRAGANA LETTER YU
    { 0x82E5, 0x3087 }, // HIRAGANA LETTER SMALL YO
    { 0x82E6, 0x3088 }, // HIRAGANA LETTER YO
    { 0x82E7, 0x3089 }, // HIRAGANA LETTER RA
    { 0x82E8, 0x308A }, // HIRAGANA LETTER RI
    { 0x82E9, 0x308B }, // HIRAGANA LETTER RU
    { 0x82EA, 0x308C }, // HIRAGANA LETTER RE
    { 0x82EB, 0x308D }, // HIRAGANA LETTER RO
    { 0x82EC, 0x308E }, // HIRAGANA LETTER SMALL WA
    { 0x82ED, 0x308F }, // HIRAGANA LETTER WA
    { 0x82EE, 0x3090 }, // HIRAGANA LETTER WI
    { 0x82EF, 0x3091 }, // HIRAGANA LETTER WE
    { 0x82F0, 0x3092 }, // HIRAGANA LETTER WO
    { 0x82F1, 0x3093 }, // HIRAGANA LETTER N
    { 0x8340, 0x30A1 }, // KATAKANA LETTER SMALL A
    { 0x8341, 0x30A2 }, // KATAKANA LETTER A
    { 0x8342, 0x30A3 }, // KATAKANA LETTER SMALL I
    { 0x8343, 0x30A4 }, // KATAKANA LETTER I
    { 0x8344, 0x30A5 }, // KATAKANA LETTER SMALL U
    { 0x8345, 0x30A6 }, // KATAKANA LETTER U
    { 0x8346, 0x30A7 }, // KATAKANA LETTER SMALL E
    { 0x8347, 0x30A8 }, // KATAKANA LETTER E
    { 0x8348, 0x30A9 }, // KATAKANA LETTER SMALL O
    { 0x8349, 0x30AA }, // KATAKANA LETTER O
    { 0x834A, 0x30AB }, // KATAKANA LETTER KA
    { 0x834B, 0x30AC }, // KATAKANA LETTER GA
    { 0x834C, 0x30AD }, // KATAKANA LETTER KI
    { 0x834D, 0x30AE }, // KATAKANA LETTER GI
    { 0x834E, 0x30AF }, // KATAKANA LETTER KU
    { 0x834F, 0x30B0 }, // KATAKANA LETTER GU
    { 0x8350, 0x30B1 }, // KATAKANA LETTER KE
    { 0x8351, 0x30B2 }, // KATAKANA LETTER GE
    { 0x8352, 0x30B3 }, // KATAKANA LETTER KO
    { 0x8353, 0x30B4 }, // KATAKANA LETTER GO
    { 0x8354, 0x30B5 }, // KATAKANA LETTER SA
    { 0x8355, 0x30B6 }, // KATAKANA LETTER ZA
    { 0x8356, 0x30B7 }, // KATAKANA LETTER SI
    { 0x8357, 0x30B8 }, // KATAKANA LETTER ZI
    { 0x8358, 0x30B9 }, // KATAKANA LETTER SU
    { 0x8359, 0x30BA }, // KATAKANA LETTER ZU
    { 0x835A, 0x30BB }, // KATAKANA LETTER SE
    { 0x835B, 0x30BC }, // KATAKANA LETTER ZE
    { 0x835C, 0x30BD }, // KATAKANA LETTER SO
    { 0x835D, 0x30BE }, // KATAKANA LETTER ZO
    { 0x835E, 0x30BF }, // KATAKANA LETTER TA
    { 0x835F, 0x30C0 }, // KATAKANA LETTER DA
    { 0x8360, 0x30C1 }, // KATAKANA LETTER TI
    { 0x8361, 0x30C2 }, // KATAKANA LETTER DI
    { 0x8362, 0x30C3 }, // KATAKANA LETTER SMALL TU
    { 0x8363, 0x30C4 }, // KATAKANA LETTER TU
    { 0x8364, 0x30C5 }, // KATAKANA LETTER DU
    { 0x8365, 0x30C6 }, // KATAKANA LETTER TE
    { 0x8366, 0x30C7 }, // KATAKANA LETTER DE
    { 0x8367, 0x30C8 }, // KATAKANA LETTER TO
    { 0x8368, 0x30C9 }, // KATAKANA LETTER DO
    { 0x8369, 0x30CA }, // KATAKANA LETTER NA
    { 0x836A, 0x30CB }, // KATAKANA LETTER NI
    { 0x836B, 0x30CC }, // KATAKANA LETTER NU
    { 0x836C, 0x30CD }, // KATAKANA LETTER NE
    { 0x836D, 0x30CE }, // KATAKANA LETTER NO
    { 0x836E, 0x30CF }, // KATAKANA LETTER HA
    { 0x836F, 0x30D0 }, // KATAKANA LETTER BA
    { 0x8370, 0x30D1 }, // KATAKANA LETTER PA
    { 0x8371, 0x30D2 }, // KATAKANA LETTER HI
    { 0x8372, 0x30D3 }, // KATAKANA LETTER BI
    { 0x8373, 0x30D4 }, // KATAKANA LETTER PI
    { 0x8374, 0x30D5 }, // KATAKANA LETTER HU
    { 0x8375, 0x30D6 }, // KATAKANA LETTER BU
    { 0x8376, 0x30D7 }, // KATAKANA LETTER PU
    { 0x8377, 0x30D8 }, // KATAKANA LETTER HE
    { 0x8378, 0x30D9 }, // KATAKANA LETTER BE
    { 0x8379, 0x30DA }, // KATAKANA LETTER PE
    { 0x837A, 0x30DB }, // KATAKANA LETTER HO
    { 0x837B, 0x30DC }, // KATAKANA LETTER BO
    { 0x837C, 0x30DD }, // KATAKANA LETTER PO
    { 0x837D, 0x30DE }, // KATAKANA LETTER MA
    { 0x837E, 0x30DF }, // KATAKANA LETTER MI
    { 0x8380, 0x30E0 }, // KATAKANA LETTER MU
    { 0x8381, 0x30E1 }, // KATAKANA LETTER ME
    { 0x8382, 0x30E2 }, // KATAKANA LETTER MO
    { 0x8383, 0x30E3 }, // KATAKANA LETTER SMALL YA
    { 0x8384, 0x30E4 }, // KATAKANA LETTER YA
    { 0x8385, 0x30E5 }, // KATAKANA LETTER SMALL YU
    { 0x8386, 0x30E6 }, // KATAKANA LETTER YU
    { 0x8387, 0x30E7 }, // KATAKANA LETTER SMALL YO
    { 0x8388, 0x30E8 }, // KATAKANA LETTER YO
    { 0x8389, 0x30E9 }, // KATAKANA LETTER RA
    { 0x838A, 0x30EA }, // KATAKANA LETTER RI
    { 0x838B, 0x30EB }, // KATAKANA LETTER RU
    { 0x838C, 0x30EC }, // KATAKANA LETTER RE
    { 0x838D, 0x30ED }, // KATAKANA LETTER RO
    { 0x838E, 0x30EE }, // KATAKANA LETTER SMALL WA
    { 0x838F, 0x30EF }, // KATAKANA LETTER WA
    { 0x8390, 0x30F0 }, // KATAKANA LETTER WI
    { 0x8391, 0x30F1 }, // KATAKANA LETTER WE
    { 0x8392, 0x30F2 }, // KATAKANA LETTER WO
    { 0x8393, 0x30F3 }, // KATAKANA LETTER N
    { 0x8394, 0x30F4 }, // KATAKANA LETTER VU
    { 0x8395, 0x30F5 }, // KATAKANA LETTER SMALL KA
    { 0x8396, 0x30F6 }, // KATAKANA LETTER SMALL KE
    { 0x839F, 0x0391 }, // GREEK CAPITAL LETTER ALPHA
    { 0x83A0, 0x0392 }, // GREEK CAPITAL LETTER BETA
    { 0x83A1, 0x0393 }, // GREEK CAPITAL LETTER GAMMA
    { 0x83A2, 0x0394 }, // GREEK CAPITAL LETTER DELTA
    { 0x83A3, 0x0395 }, // GREEK CAPITAL LETTER EPSILON
    { 0x83A4, 0x0396 }, // GREEK CAPITAL LETTER ZETA
    { 0x83A5, 0x0397 }, // GREEK CAPITAL LETTER ETA
    { 0x83A6, 0x0398 }, // GREEK CAPITAL LETTER THETA
    { 0x83A7, 0x0399 }, // GREEK CAPITAL LETTER IOTA
    { 0x83A8, 0x039A }, // GREEK CAPITAL LETTER KAPPA
    { 0x83A9, 0x039B }, // GREEK CAPITAL LETTER LAMDA
    { 0x83AA, 0x039C }, // GREEK CAPITAL LETTER MU
    { 0x83AB, 0x039D }, // GREEK CAPITAL LETTER NU
    { 0x83AC, 0x039E }, // GREEK CAPITAL LETTER XI
    { 0x83AD, 0x039F }, // GREEK CAPITAL LETTER OMICRON
    { 0x83AE, 0x03A0 }, // GREEK CAPITAL LETTER PI
    { 0x83AF, 0x03A1 }, // GREEK CAPITAL LETTER RHO
    { 0x83B0, 0x03A3 }, // GREEK CAPITAL LETTER SIGMA
    { 0x83B1, 0x03A4 }, // GREEK CAPITAL LETTER TAU
    { 0x83B2, 0x03A5 }, // GREEK CAPITAL LETTER UPSILON
    { 0x83B3, 0x03A6 }, // GREEK CAPITAL LETTER PHI
    { 0x83B4, 0x03A7 }, // GREEK CAPITAL LETTER CHI
    { 0x83B5, 0x03A8 }, // GREEK CAPITAL LETTER PSI
    { 0x83B6, 0x03A9 }, // GREEK CAPITAL LETTER OMEGA
    { 0x83BF, 0x03B1 }, // GREEK SMALL LETTER ALPHA
    { 0x83C0, 0x03B2 }, // GREEK SMALL LETTER BETA
    { 0x83C1, 0x03B3 }, // GREEK SMALL LETTER GAMMA
    { 0x83C2, 0x03B4 }, // GREEK SMALL LETTER DELTA
    { 0x83C3, 0x03B5 }, // GREEK SMALL LETTER EPSILON
    { 0x83C4, 0x03B6 }, // GREEK SMALL LETTER ZETA
    { 0x83C5, 0x03B7 }, // GREEK SMALL LETTER ETA
    { 0x83C6, 0x03B8 }, // GREEK SMALL LETTER THETA
    { 0x83C7, 0x03B9 }, // GREEK SMALL LETTER IOTA
    { 0x83C8, 0x03BA }, // GREEK SMALL LETTER KAPPA
    { 0x83C9, 0x03BB }, // GREEK SMALL LETTER LAMDA
    { 0x83CA, 0x03BC }, // GREEK SMALL LETTER MU
    { 0x83CB, 0x03BD }, // GREEK SMALL LETTER NU
    { 0x83CC, 0x03BE }, // GREEK SMALL LETTER XI
    { 0x83CD, 0x03BF }, // GREEK SMALL LETTER OMICRON
    { 0x83CE, 0x03C0 }, // GREEK SMALL LETTER PI
    { 0x83CF, 0x03C1 }, // GREEK SMALL LETTER RHO
    { 0x83D0, 0x03C3 }, // GREEK SMALL LETTER SIGMA
    { 0x83D1, 0x03C4 }, // GREEK SMALL LETTER TAU
    { 0x83D2, 0x03C5 }, // GREEK SMALL LETTER UPSILON
    { 0x83D3, 0x03C6 }, // GREEK SMALL LETTER PHI
    { 0x83D4, 0x03C7 }, // GREEK SMALL LETTER CHI
    { 0x83D5, 0x03C8 }, // GREEK SMALL LETTER PSI
    { 0x83D6, 0x03C9 }, // GREEK SMALL LETTER OMEGA
    { 0x8440, 0x0410 }, // CYRILLIC CAPITAL LETTER A
    { 0x8441, 0x0411 }, // CYRILLIC CAPITAL LETTER BE
    { 0x8442, 0x0412 }, // CYRILLIC CAPITAL LETTER VE
    { 0x8443, 0x0413 }, // CYRILLIC CAPITAL LETTER GHE
    { 0x8444, 0x0414 }, // CYRILLIC CAPITAL LETTER DE
    { 0x8445, 0x0415 }, // CYRILLIC CAPITAL LETTER IE
    { 0x8446, 0x0401 }, // CYRILLIC CAPITAL LETTER IO
    { 0x8447, 0x0416 }, // CYRILLIC CAPITAL LETTER ZHE
    { 0x8448, 0x0417 }, // CYRILLIC CAPITAL LETTER ZE
    { 0x8449, 0x0418 }, // CYRILLIC CAPITAL LETTER I
    { 0x844A, 0x0419 }, // CYRILLIC CAPITAL LETTER SHORT I
    { 0x844B, 0x041A }, // CYRILLIC CAPITAL LETTER KA
    { 0x844C, 0x041B }, // CYRILLIC CAPITAL LETTER EL
    { 0x844D, 0x041C }, // CYRILLIC CAPITAL LETTER EM
    { 0x844E, 0x041D }, // CYRILLIC CAPITAL LETTER EN
    { 0x844F, 0x041E }, // CYRILLIC CAPITAL LETTER O
    { 0x8450, 0x041F }, // CYRILLIC CAPITAL LETTER PE
    { 0x8451, 0x0420 }, // CYRILLIC CAPITAL LETTER ER
    { 0x8452, 0x0421 }, // CYRILLIC CAPITAL LETTER ES
    { 0x8453, 0x0422 }, // CYRILLIC CAPITAL LETTER TE
    { 0x8454, 0x0423 }, // CYRILLIC CAPITAL LETTER U
    { 0x8455, 0x0424 }, // CYRILLIC CAPITAL LETTER EF
    { 0x8456, 0x0425 }, // CYRILLIC CAPITAL LETTER HA
    { 0x8457, 0x0426 }, // CYRILLIC CAPITAL LETTER TSE
    { 0x8458, 0x0427 }, // CYRILLIC CAPITAL LETTER CHE
    { 0x8459, 0x0428 }, // CYRILLIC CAPITAL LETTER SHA
    { 0x845A, 0x0429 }, // CYRILLIC CAPITAL LETTER SHCHA
    { 0x845B, 0x042A }, // CYRILLIC CAPITAL LETTER HARD SIGN
    { 0x845C, 0x042B }, // CYRILLIC CAPITAL LETTER YERU
    { 0x845D, 0x042C }, // CYRILLIC CAPITAL LETTER SOFT SIGN
    { 0x845E, 0x042D }, // CYRILLIC CAPITAL LETTER E
    { 0x845F, 0x042E }, // CYRILLIC CAPITAL LETTER YU
    { 0x8460, 0x042F }, // CYRILLIC CAPITAL LETTER YA
    { 0x8470, 0x0430 }, // CYRILLIC SMALL LETTER A
    { 0x8471, 0x0431 }, // CYRILLIC SMALL LETTER BE
    { 0x8472, 0x0432 }, // CYRILLIC SMALL LETTER VE
    { 0x8473, 0x0433 }, // CYRILLIC SMALL LETTER GHE
    { 0x8474, 0x0434 }, // CYRILLIC SMALL LETTER DE
    { 0x8475, 0x0435 }, // CYRILLIC SMALL LETTER IE
    { 0x8476, 0x0451 }, // CYRILLIC SMALL LETTER IO
    { 0x8477, 0x0436 }, // CYRILLIC SMALL LETTER ZHE
    { 0x8478, 0x0437 }, // CYRILLIC SMALL LETTER ZE
    { 0x8479, 0x0438 }, // CYRILLIC SMALL LETTER I
    { 0x847A, 0x0439 }, // CYRILLIC SMALL LETTER SHORT I
    { 0x847B, 0x043A }, // CYRILLIC SMALL LETTER KA
    { 0x847C, 0x043B }, // CYRILLIC SMALL LETTER EL
    { 0x847D, 0x043C }, // CYRILLIC SMALL LETTER EM
    { 0x847E, 0x043D }, // CYRILLIC SMALL LETTER EN
    { 0x8480, 0x043E }, // CYRILLIC SMALL LETTER O
    { 0x8481, 0x043F }, // CYRILLIC SMALL LETTER PE
    { 0x8482, 0x0440 }, // CYRILLIC SMALL LETTER ER
    { 0x8483, 0x0441 }, // CYRILLIC SMALL LETTER ES
    { 0x8484, 0x0442 }, // CYRILLIC SMALL LETTER TE
    { 0x8485, 0x0443 }, // CYRILLIC SMALL LETTER U
    { 0x8486, 0x0444 }, // CYRILLIC SMALL LETTER EF
    { 0x8487, 0x0445 }, // CYRILLIC SMALL LETTER HA
    { 0x8488, 0x0446 }, // CYRILLIC SMALL LETTER TSE
    { 0x8489, 0x0447 }, // CYRILLIC SMALL LETTER CHE
    { 0x848A, 0x0448 }, // CYRILLIC SMALL LETTER SHA
    { 0x848B, 0x0449 }, // CYRILLIC SMALL LETTER SHCHA
    { 0x848C, 0x044A }, // CYRILLIC SMALL LETTER HARD SIGN
    { 0x848D, 0x044B }, // CYRILLIC SMALL LETTER YERU
    { 0x848E, 0x044C }, // CYRILLIC SMALL LETTER SOFT SIGN
    { 0x848F, 0x044D }, // CYRILLIC SMALL LETTER E
    { 0x8490, 0x044E }, // CYRILLIC SMALL LETTER YU
    { 0x8491, 0x044F }, // CYRILLIC SMALL LETTER YA
    { 0x849F, 0x2500 }, // BOX DRAWINGS LIGHT HORIZONTAL
    { 0x84A0, 0x2502 }, // BOX DRAWINGS LIGHT VERTICAL
    { 0x84A1, 0x250C }, // BOX DRAWINGS LIGHT DOWN AND RIGHT
    { 0x84A2, 0x2510 }, // BOX DRAWINGS LIGHT DOWN AND LEFT
    { 0x84A3, 0x2518 }, // BOX DRAWINGS LIGHT UP AND LEFT
    { 0x84A4, 0x2514 }, // BOX DRAWINGS LIGHT UP AND RIGHT
    { 0x84A5, 0x251C }, // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    { 0x84A6, 0x252C }, // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    { 0x84A7, 0x2524 }, // BOX DRAWINGS LIGHT VERTICAL AND LEFT
    { 0x84A8, 0x2534 }, // BOX DRAWINGS LIGHT UP AND HORIZONTAL
    { 0x84A9, 0x253C }, // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    { 0x84AA, 0x2501 }, // BOX DRAWINGS HEAVY HORIZONTAL
    { 0x84AB, 0x2503 }, // BOX DRAWINGS HEAVY VERTICAL
    { 0x84AC, 0x250F }, // BOX DRAWINGS HEAVY DOWN AND RIGHT
    { 0x84AD, 0x2513 }, // BOX DRAWINGS HEAVY DOWN AND LEFT
    { 0x84AE, 0x251B }, // BOX DRAWINGS HEAVY UP AND LEFT
    { 0x84AF, 0x2517 }, // BOX DRAWINGS HEAVY UP AND RIGHT
    { 0x84B0, 0x2523 }, // BOX DRAWINGS HEAVY VERTICAL AND RIGHT
    { 0x84B1, 0x2533 }, // BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
    { 0x84B2, 0x252B }, // BOX DRAWINGS HEAVY VERTICAL AND LEFT
    { 0x84B3, 0x253B }, // BOX DRAWINGS HEAVY UP AND HORIZONTAL
    { 0x84B4, 0x254B }, // BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
    { 0x84B5, 0x2520 }, // BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
    { 0x84B6, 0x252F }, // BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
    { 0x84B7, 0x2528 }, // BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
    { 0x84B8, 0x2537 }, // BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
    { 0x84B9, 0x253F }, // BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
    { 0x84BA, 0x251D }, // BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
    { 0x84BB, 0x2530 }, // BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
    { 0x84BC, 0x2525 }, // BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
    { 0x84BD, 0x2538 }, // BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
    { 0x84BE, 0x2542 }, // BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
    { 0x8740, 0x2460 }, // CIRCLED DIGIT ONE
    { 0x8741, 0x2461 }, // CIRCLED DIGIT TWO
    { 0x8742, 0x2462 }, // CIRCLED DIGIT THREE
    { 0x8743, 0x2463 }, // CIRCLED DIGIT FOUR
    { 0x8744, 0x2464 }, // CIRCLED DIGIT FIVE
    { 0x8745, 0x2465 }, // CIRCLED DIGIT SIX
    { 0x8746, 0x2466 }, // CIRCLED DIGIT SEVEN
    { 0x8747, 0x2467 }, // CIRCLED DIGIT EIGHT
    { 0x8748, 0x2468 }, // CIRCLED DIGIT NINE
    { 0x8749, 0x2469 }, // CIRCLED NUMBER TEN
    { 0x874A, 0x246A }, // CIRCLED NUMBER ELEVEN
    { 0x874B, 0x246B }, // CIRCLED NUMBER TWELVE
    { 0x874C, 0x246C }, // CIRCLED NUMBER THIRTEEN
    { 0x874D, 0x246D }, // CIRCLED NUMBER FOURTEEN
    { 0x874E, 0x246E }, // CIRCLED NUMBER FIFTEEN
    { 0x874F, 0x246F }, // CIRCLED NUMBER SIXTEEN
    { 0x8750, 0x2470 }, // CIRCLED NUMBER SEVENTEEN
    { 0x8751, 0x2471 }, // CIRCLED NUMBER EIGHTEEN
    { 0x8752, 0x2472 }, // CIRCLED NUMBER NINETEEN
    { 0x8753, 0x2473 }, // CIRCLED NUMBER TWENTY
    { 0x8754, 0x2160 }, // ROMAN NUMERAL ONE
    { 0x8755, 0x2161 }, // ROMAN NUMERAL TWO
    { 0x8756, 0x2162 }, // ROMAN NUMERAL THREE
    { 0x8757, 0x2163 }, // ROMAN NUMERAL FOUR
    { 0x8758, 0x2164 }, // ROMAN NUMERAL FIVE
    { 0x8759, 0x2165 }, // ROMAN NUMERAL SIX
    { 0x875A, 0x2166 }, // ROMAN NUMERAL SEVEN
    { 0x875B, 0x2167 }, // ROMAN NUMERAL EIGHT
    { 0x875C, 0x2168 }, // ROMAN NUMERAL NINE
    { 0x875D, 0x2169 }, // ROMAN NUMERAL TEN
    { 0x875F, 0x3349 }, // SQUARE MIRI
    { 0x8760, 0x3314 }, // SQUARE KIRO
    { 0x8761, 0x3322 }, // SQUARE SENTI
    { 0x8762, 0x334D }, // SQUARE MEETORU
    { 0x8763, 0x3318 }, // SQUARE GURAMU
    { 0x8764, 0x3327 }, // SQUARE TON
    { 0x8765, 0x3303 }, // SQUARE AARU
    { 0x8766, 0x3336 }, // SQUARE HEKUTAARU
    { 0x8767, 0x3351 }, // SQUARE RITTORU
    { 0x8768, 0x3357 }, // SQUARE WATTO
    { 0x8769, 0x330D }, // SQUARE KARORII
    { 0x876A, 0x3326 }, // SQUARE DORU
    { 0x876B, 0x3323 }, // SQUARE SENTO
    { 0x876C, 0x332B }, // SQUARE PAASENTO
    { 0x876D, 0x334A }, // SQUARE MIRIBAARU
    { 0x876E, 0x333B }, // SQUARE PEEZI
    { 0x876F, 0x339C }, // SQUARE MM
    { 0x8770, 0x339D }, // SQUARE CM
    { 0x8771, 0x339E }, // SQUARE KM
    { 0x8772, 0x338E }, // SQUARE MG
    { 0x8773, 0x338F }, // SQUARE KG
    { 0x8774, 0x33C4 }, // SQUARE CC
    { 0x8775, 0x33A1 }, // SQUARE M SQUARED
    { 0x877E, 0x337B }, // SQUARE ERA NAME HEISEI
    { 0x8780, 0x301D }, // REVERSED DOUBLE PRIME QUOTATION MARK
    { 0x8781, 0x301F }, // LOW DOUBLE PRIME QUOTATION MARK
    { 0x8782, 0x2116 }, // NUMERO SIGN
    { 0x8783, 0x33CD }, // SQUARE KK
    { 0x8784, 0x2121 }, // TELEPHONE SIGN
    { 0x8785, 0x32A4 }, // CIRCLED IDEOGRAPH HIGH
    { 0x8786, 0x32A5 }, // CIRCLED IDEOGRAPH CENTRE
    { 0x8787, 0x32A6 }, // CIRCLED IDEOGRAPH LOW
    { 0x8788, 0x32A7 }, // CIRCLED IDEOGRAPH LEFT
    { 0x8789, 0x32A8 }, // CIRCLED IDEOGRAPH RIGHT
    { 0x878A, 0x3231 }, // PARENTHESIZED IDEOGRAPH STOCK
    { 0x878B, 0x3232 }, // PARENTHESIZED IDEOGRAPH HAVE
    { 0x878C, 0x3239 }, // PARENTHESIZED IDEOGRAPH REPRESENT
    { 0x878D, 0x337E }, // SQUARE ERA NAME MEIZI
    { 0x878E, 0x337D }, // SQUARE ERA NAME TAISYOU
    { 0x878F, 0x337C }, // SQUARE ERA NAME SYOUWA
    { 0x8790, 0x2252 }, // APPROXIMATELY EQUAL TO OR THE IMAGE OF
    { 0x8791, 0x2261 }, // IDENTICAL TO
    { 0x8792, 0x222B }, // INTEGRAL
    { 0x8793, 0x222E }, // CONTOUR INTEGRAL
    { 0x8794, 0x2211 }, // N-ARY SUMMATION
    { 0x8795, 0x221A }, // SQUARE ROOT
    { 0x8796, 0x22A5 }, // UP TACK
    { 0x8797, 0x2220 }, // ANGLE
    { 0x8798, 0x221F }, // RIGHT ANGLE
    { 0x8799, 0x22BF }, // RIGHT TRIANGLE
    { 0x879A, 0x2235 }, // BECAUSE
    { 0x879B, 0x2229 }, // INTERSECTION
    { 0x879C, 0x222A }, // UNION
    { 0x889F, 0x4E9C }, // CJK UNIFIED IDEOGRAPH
    { 0x88A0, 0x5516 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A1, 0x5A03 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A2, 0x963F }, // CJK UNIFIED IDEOGRAPH
    { 0x88A3, 0x54C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A4, 0x611B }, // CJK UNIFIED IDEOGRAPH
    { 0x88A5, 0x6328 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A6, 0x59F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A7, 0x9022 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A8, 0x8475 }, // CJK UNIFIED IDEOGRAPH
    { 0x88A9, 0x831C }, // CJK UNIFIED IDEOGRAPH
    { 0x88AA, 0x7A50 }, // CJK UNIFIED IDEOGRAPH
    { 0x88AB, 0x60AA }, // CJK UNIFIED IDEOGRAPH
    { 0x88AC, 0x63E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x88AD, 0x6E25 }, // CJK UNIFIED IDEOGRAPH
    { 0x88AE, 0x65ED }, // CJK UNIFIED IDEOGRAPH
    { 0x88AF, 0x8466 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B0, 0x82A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B1, 0x9BF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B2, 0x6893 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B3, 0x5727 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B4, 0x65A1 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B5, 0x6271 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B6, 0x5B9B }, // CJK UNIFIED IDEOGRAPH
    { 0x88B7, 0x59D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x88B8, 0x867B }, // CJK UNIFIED IDEOGRAPH
    { 0x88B9, 0x98F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x88BA, 0x7D62 }, // CJK UNIFIED IDEOGRAPH
    { 0x88BB, 0x7DBE }, // CJK UNIFIED IDEOGRAPH
    { 0x88BC, 0x9B8E }, // CJK UNIFIED IDEOGRAPH
    { 0x88BD, 0x6216 }, // CJK UNIFIED IDEOGRAPH
    { 0x88BE, 0x7C9F }, // CJK UNIFIED IDEOGRAPH
    { 0x88BF, 0x88B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C0, 0x5B89 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C1, 0x5EB5 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C2, 0x6309 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C3, 0x6697 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C4, 0x6848 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C5, 0x95C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C6, 0x978D }, // CJK UNIFIED IDEOGRAPH
    { 0x88C7, 0x674F }, // CJK UNIFIED IDEOGRAPH
    { 0x88C8, 0x4EE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x88C9, 0x4F0A }, // CJK UNIFIED IDEOGRAPH
    { 0x88CA, 0x4F4D }, // CJK UNIFIED IDEOGRAPH
    { 0x88CB, 0x4F9D }, // CJK UNIFIED IDEOGRAPH
    { 0x88CC, 0x5049 }, // CJK UNIFIED IDEOGRAPH
    { 0x88CD, 0x56F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x88CE, 0x5937 }, // CJK UNIFIED IDEOGRAPH
    { 0x88CF, 0x59D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D0, 0x5A01 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D1, 0x5C09 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D2, 0x60DF }, // CJK UNIFIED IDEOGRAPH
    { 0x88D3, 0x610F }, // CJK UNIFIED IDEOGRAPH
    { 0x88D4, 0x6170 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D5, 0x6613 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D6, 0x6905 }, // CJK UNIFIED IDEOGRAPH
    { 0x88D7, 0x70BA }, // CJK UNIFIED IDEOGRAPH
    { 0x88D8, 0x754F }, // CJK UNIFIED IDEOGRAPH
    { 0x88D9, 0x7570 }, // CJK UNIFIED IDEOGRAPH
    { 0x88DA, 0x79FB }, // CJK UNIFIED IDEOGRAPH
    { 0x88DB, 0x7DAD }, // CJK UNIFIED IDEOGRAPH
    { 0x88DC, 0x7DEF }, // CJK UNIFIED IDEOGRAPH
    { 0x88DD, 0x80C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x88DE, 0x840E }, // CJK UNIFIED IDEOGRAPH
    { 0x88DF, 0x8863 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E0, 0x8B02 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E1, 0x9055 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E2, 0x907A }, // CJK UNIFIED IDEOGRAPH
    { 0x88E3, 0x533B }, // CJK UNIFIED IDEOGRAPH
    { 0x88E4, 0x4E95 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E5, 0x4EA5 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E6, 0x57DF }, // CJK UNIFIED IDEOGRAPH
    { 0x88E7, 0x80B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E8, 0x90C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x88E9, 0x78EF }, // CJK UNIFIED IDEOGRAPH
    { 0x88EA, 0x4E00 }, // CJK UNIFIED IDEOGRAPH
    { 0x88EB, 0x58F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x88EC, 0x6EA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x88ED, 0x9038 }, // CJK UNIFIED IDEOGRAPH
    { 0x88EE, 0x7A32 }, // CJK UNIFIED IDEOGRAPH
    { 0x88EF, 0x8328 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F0, 0x828B }, // CJK UNIFIED IDEOGRAPH
    { 0x88F1, 0x9C2F }, // CJK UNIFIED IDEOGRAPH
    { 0x88F2, 0x5141 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F3, 0x5370 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F4, 0x54BD }, // CJK UNIFIED IDEOGRAPH
    { 0x88F5, 0x54E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F6, 0x56E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F7, 0x59FB }, // CJK UNIFIED IDEOGRAPH
    { 0x88F8, 0x5F15 }, // CJK UNIFIED IDEOGRAPH
    { 0x88F9, 0x98F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x88FA, 0x6DEB }, // CJK UNIFIED IDEOGRAPH
    { 0x88FB, 0x80E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x88FC, 0x852D }, // CJK UNIFIED IDEOGRAPH
    { 0x8940, 0x9662 }, // CJK UNIFIED IDEOGRAPH
    { 0x8941, 0x9670 }, // CJK UNIFIED IDEOGRAPH
    { 0x8942, 0x96A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8943, 0x97FB }, // CJK UNIFIED IDEOGRAPH
    { 0x8944, 0x540B }, // CJK UNIFIED IDEOGRAPH
    { 0x8945, 0x53F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8946, 0x5B87 }, // CJK UNIFIED IDEOGRAPH
    { 0x8947, 0x70CF }, // CJK UNIFIED IDEOGRAPH
    { 0x8948, 0x7FBD }, // CJK UNIFIED IDEOGRAPH
    { 0x8949, 0x8FC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x894A, 0x96E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x894B, 0x536F }, // CJK UNIFIED IDEOGRAPH
    { 0x894C, 0x9D5C }, // CJK UNIFIED IDEOGRAPH
    { 0x894D, 0x7ABA }, // CJK UNIFIED IDEOGRAPH
    { 0x894E, 0x4E11 }, // CJK UNIFIED IDEOGRAPH
    { 0x894F, 0x7893 }, // CJK UNIFIED IDEOGRAPH
    { 0x8950, 0x81FC }, // CJK UNIFIED IDEOGRAPH
    { 0x8951, 0x6E26 }, // CJK UNIFIED IDEOGRAPH
    { 0x8952, 0x5618 }, // CJK UNIFIED IDEOGRAPH
    { 0x8953, 0x5504 }, // CJK UNIFIED IDEOGRAPH
    { 0x8954, 0x6B1D }, // CJK UNIFIED IDEOGRAPH
    { 0x8955, 0x851A }, // CJK UNIFIED IDEOGRAPH
    { 0x8956, 0x9C3B }, // CJK UNIFIED IDEOGRAPH
    { 0x8957, 0x59E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8958, 0x53A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8959, 0x6D66 }, // CJK UNIFIED IDEOGRAPH
    { 0x895A, 0x74DC }, // CJK UNIFIED IDEOGRAPH
    { 0x895B, 0x958F }, // CJK UNIFIED IDEOGRAPH
    { 0x895C, 0x5642 }, // CJK UNIFIED IDEOGRAPH
    { 0x895D, 0x4E91 }, // CJK UNIFIED IDEOGRAPH
    { 0x895E, 0x904B }, // CJK UNIFIED IDEOGRAPH
    { 0x895F, 0x96F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8960, 0x834F }, // CJK UNIFIED IDEOGRAPH
    { 0x8961, 0x990C }, // CJK UNIFIED IDEOGRAPH
    { 0x8962, 0x53E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8963, 0x55B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8964, 0x5B30 }, // CJK UNIFIED IDEOGRAPH
    { 0x8965, 0x5F71 }, // CJK UNIFIED IDEOGRAPH
    { 0x8966, 0x6620 }, // CJK UNIFIED IDEOGRAPH
    { 0x8967, 0x66F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8968, 0x6804 }, // CJK UNIFIED IDEOGRAPH
    { 0x8969, 0x6C38 }, // CJK UNIFIED IDEOGRAPH
    { 0x896A, 0x6CF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x896B, 0x6D29 }, // CJK UNIFIED IDEOGRAPH
    { 0x896C, 0x745B }, // CJK UNIFIED IDEOGRAPH
    { 0x896D, 0x76C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x896E, 0x7A4E }, // CJK UNIFIED IDEOGRAPH
    { 0x896F, 0x9834 }, // CJK UNIFIED IDEOGRAPH
    { 0x8970, 0x82F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8971, 0x885B }, // CJK UNIFIED IDEOGRAPH
    { 0x8972, 0x8A60 }, // CJK UNIFIED IDEOGRAPH
    { 0x8973, 0x92ED }, // CJK UNIFIED IDEOGRAPH
    { 0x8974, 0x6DB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8975, 0x75AB }, // CJK UNIFIED IDEOGRAPH
    { 0x8976, 0x76CA }, // CJK UNIFIED IDEOGRAPH
    { 0x8977, 0x99C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8978, 0x60A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8979, 0x8B01 }, // CJK UNIFIED IDEOGRAPH
    { 0x897A, 0x8D8A }, // CJK UNIFIED IDEOGRAPH
    { 0x897B, 0x95B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x897C, 0x698E }, // CJK UNIFIED IDEOGRAPH
    { 0x897D, 0x53AD }, // CJK UNIFIED IDEOGRAPH
    { 0x897E, 0x5186 }, // CJK UNIFIED IDEOGRAPH
    { 0x8980, 0x5712 }, // CJK UNIFIED IDEOGRAPH
    { 0x8981, 0x5830 }, // CJK UNIFIED IDEOGRAPH
    { 0x8982, 0x5944 }, // CJK UNIFIED IDEOGRAPH
    { 0x8983, 0x5BB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8984, 0x5EF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8985, 0x6028 }, // CJK UNIFIED IDEOGRAPH
    { 0x8986, 0x63A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8987, 0x63F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8988, 0x6CBF }, // CJK UNIFIED IDEOGRAPH
    { 0x8989, 0x6F14 }, // CJK UNIFIED IDEOGRAPH
    { 0x898A, 0x708E }, // CJK UNIFIED IDEOGRAPH
    { 0x898B, 0x7114 }, // CJK UNIFIED IDEOGRAPH
    { 0x898C, 0x7159 }, // CJK UNIFIED IDEOGRAPH
    { 0x898D, 0x71D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x898E, 0x733F }, // CJK UNIFIED IDEOGRAPH
    { 0x898F, 0x7E01 }, // CJK UNIFIED IDEOGRAPH
    { 0x8990, 0x8276 }, // CJK UNIFIED IDEOGRAPH
    { 0x8991, 0x82D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8992, 0x8597 }, // CJK UNIFIED IDEOGRAPH
    { 0x8993, 0x9060 }, // CJK UNIFIED IDEOGRAPH
    { 0x8994, 0x925B }, // CJK UNIFIED IDEOGRAPH
    { 0x8995, 0x9D1B }, // CJK UNIFIED IDEOGRAPH
    { 0x8996, 0x5869 }, // CJK UNIFIED IDEOGRAPH
    { 0x8997, 0x65BC }, // CJK UNIFIED IDEOGRAPH
    { 0x8998, 0x6C5A }, // CJK UNIFIED IDEOGRAPH
    { 0x8999, 0x7525 }, // CJK UNIFIED IDEOGRAPH
    { 0x899A, 0x51F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x899B, 0x592E }, // CJK UNIFIED IDEOGRAPH
    { 0x899C, 0x5965 }, // CJK UNIFIED IDEOGRAPH
    { 0x899D, 0x5F80 }, // CJK UNIFIED IDEOGRAPH
    { 0x899E, 0x5FDC }, // CJK UNIFIED IDEOGRAPH
    { 0x899F, 0x62BC }, // CJK UNIFIED IDEOGRAPH
    { 0x89A0, 0x65FA }, // CJK UNIFIED IDEOGRAPH
    { 0x89A1, 0x6A2A }, // CJK UNIFIED IDEOGRAPH
    { 0x89A2, 0x6B27 }, // CJK UNIFIED IDEOGRAPH
    { 0x89A3, 0x6BB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x89A4, 0x738B }, // CJK UNIFIED IDEOGRAPH
    { 0x89A5, 0x7FC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89A6, 0x8956 }, // CJK UNIFIED IDEOGRAPH
    { 0x89A7, 0x9D2C }, // CJK UNIFIED IDEOGRAPH
    { 0x89A8, 0x9D0E }, // CJK UNIFIED IDEOGRAPH
    { 0x89A9, 0x9EC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x89AA, 0x5CA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89AB, 0x6C96 }, // CJK UNIFIED IDEOGRAPH
    { 0x89AC, 0x837B }, // CJK UNIFIED IDEOGRAPH
    { 0x89AD, 0x5104 }, // CJK UNIFIED IDEOGRAPH
    { 0x89AE, 0x5C4B }, // CJK UNIFIED IDEOGRAPH
    { 0x89AF, 0x61B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B0, 0x81C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B1, 0x6876 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B2, 0x7261 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B3, 0x4E59 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B4, 0x4FFA }, // CJK UNIFIED IDEOGRAPH
    { 0x89B5, 0x5378 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B6, 0x6069 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B7, 0x6E29 }, // CJK UNIFIED IDEOGRAPH
    { 0x89B8, 0x7A4F }, // CJK UNIFIED IDEOGRAPH
    { 0x89B9, 0x97F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x89BA, 0x4E0B }, // CJK UNIFIED IDEOGRAPH
    { 0x89BB, 0x5316 }, // CJK UNIFIED IDEOGRAPH
    { 0x89BC, 0x4EEE }, // CJK UNIFIED IDEOGRAPH
    { 0x89BD, 0x4F55 }, // CJK UNIFIED IDEOGRAPH
    { 0x89BE, 0x4F3D }, // CJK UNIFIED IDEOGRAPH
    { 0x89BF, 0x4FA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C0, 0x4F73 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C1, 0x52A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C2, 0x53EF }, // CJK UNIFIED IDEOGRAPH
    { 0x89C3, 0x5609 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C4, 0x590F }, // CJK UNIFIED IDEOGRAPH
    { 0x89C5, 0x5AC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C6, 0x5BB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C7, 0x5BE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C8, 0x79D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89C9, 0x6687 }, // CJK UNIFIED IDEOGRAPH
    { 0x89CA, 0x679C }, // CJK UNIFIED IDEOGRAPH
    { 0x89CB, 0x67B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x89CC, 0x6B4C }, // CJK UNIFIED IDEOGRAPH
    { 0x89CD, 0x6CB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x89CE, 0x706B }, // CJK UNIFIED IDEOGRAPH
    { 0x89CF, 0x73C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x89D0, 0x798D }, // CJK UNIFIED IDEOGRAPH
    { 0x89D1, 0x79BE }, // CJK UNIFIED IDEOGRAPH
    { 0x89D2, 0x7A3C }, // CJK UNIFIED IDEOGRAPH
    { 0x89D3, 0x7B87 }, // CJK UNIFIED IDEOGRAPH
    { 0x89D4, 0x82B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x89D5, 0x82DB }, // CJK UNIFIED IDEOGRAPH
    { 0x89D6, 0x8304 }, // CJK UNIFIED IDEOGRAPH
    { 0x89D7, 0x8377 }, // CJK UNIFIED IDEOGRAPH
    { 0x89D8, 0x83EF }, // CJK UNIFIED IDEOGRAPH
    { 0x89D9, 0x83D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DA, 0x8766 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DB, 0x8AB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DC, 0x5629 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DD, 0x8CA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DE, 0x8FE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x89DF, 0x904E }, // CJK UNIFIED IDEOGRAPH
    { 0x89E0, 0x971E }, // CJK UNIFIED IDEOGRAPH
    { 0x89E1, 0x868A }, // CJK UNIFIED IDEOGRAPH
    { 0x89E2, 0x4FC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x89E3, 0x5CE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x89E4, 0x6211 }, // CJK UNIFIED IDEOGRAPH
    { 0x89E5, 0x7259 }, // CJK UNIFIED IDEOGRAPH
    { 0x89E6, 0x753B }, // CJK UNIFIED IDEOGRAPH
    { 0x89E7, 0x81E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x89E8, 0x82BD }, // CJK UNIFIED IDEOGRAPH
    { 0x89E9, 0x86FE }, // CJK UNIFIED IDEOGRAPH
    { 0x89EA, 0x8CC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x89EB, 0x96C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x89EC, 0x9913 }, // CJK UNIFIED IDEOGRAPH
    { 0x89ED, 0x99D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x89EE, 0x4ECB }, // CJK UNIFIED IDEOGRAPH
    { 0x89EF, 0x4F1A }, // CJK UNIFIED IDEOGRAPH
    { 0x89F0, 0x89E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x89F1, 0x56DE }, // CJK UNIFIED IDEOGRAPH
    { 0x89F2, 0x584A }, // CJK UNIFIED IDEOGRAPH
    { 0x89F3, 0x58CA }, // CJK UNIFIED IDEOGRAPH
    { 0x89F4, 0x5EFB }, // CJK UNIFIED IDEOGRAPH
    { 0x89F5, 0x5FEB }, // CJK UNIFIED IDEOGRAPH
    { 0x89F6, 0x602A }, // CJK UNIFIED IDEOGRAPH
    { 0x89F7, 0x6094 }, // CJK UNIFIED IDEOGRAPH
    { 0x89F8, 0x6062 }, // CJK UNIFIED IDEOGRAPH
    { 0x89F9, 0x61D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x89FA, 0x6212 }, // CJK UNIFIED IDEOGRAPH
    { 0x89FB, 0x62D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x89FC, 0x6539 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A40, 0x9B41 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A41, 0x6666 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A42, 0x68B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A43, 0x6D77 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A44, 0x7070 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A45, 0x754C }, // CJK UNIFIED IDEOGRAPH
    { 0x8A46, 0x7686 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A47, 0x7D75 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A48, 0x82A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A49, 0x87F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4A, 0x958B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4B, 0x968E }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4C, 0x8C9D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4D, 0x51F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4E, 0x52BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8A4F, 0x5916 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A50, 0x54B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A51, 0x5BB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A52, 0x5D16 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A53, 0x6168 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A54, 0x6982 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A55, 0x6DAF }, // CJK UNIFIED IDEOGRAPH
    { 0x8A56, 0x788D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A57, 0x84CB }, // CJK UNIFIED IDEOGRAPH
    { 0x8A58, 0x8857 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A59, 0x8A72 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5A, 0x93A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5B, 0x9AB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5C, 0x6D6C }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5D, 0x99A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5E, 0x86D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A5F, 0x57A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A60, 0x67FF }, // CJK UNIFIED IDEOGRAPH
    { 0x8A61, 0x86CE }, // CJK UNIFIED IDEOGRAPH
    { 0x8A62, 0x920E }, // CJK UNIFIED IDEOGRAPH
    { 0x8A63, 0x5283 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A64, 0x5687 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A65, 0x5404 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A66, 0x5ED3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A67, 0x62E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A68, 0x64B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A69, 0x683C }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6A, 0x6838 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6B, 0x6BBB }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6C, 0x7372 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6D, 0x78BA }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6E, 0x7A6B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A6F, 0x899A }, // CJK UNIFIED IDEOGRAPH
    { 0x8A70, 0x89D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A71, 0x8D6B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A72, 0x8F03 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A73, 0x90ED }, // CJK UNIFIED IDEOGRAPH
    { 0x8A74, 0x95A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A75, 0x9694 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A76, 0x9769 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A77, 0x5B66 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A78, 0x5CB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A79, 0x697D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A7A, 0x984D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A7B, 0x984E }, // CJK UNIFIED IDEOGRAPH
    { 0x8A7C, 0x639B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A7D, 0x7B20 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A7E, 0x6A2B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A80, 0x6A7F }, // CJK UNIFIED IDEOGRAPH
    { 0x8A81, 0x68B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A82, 0x9C0D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A83, 0x6F5F }, // CJK UNIFIED IDEOGRAPH
    { 0x8A84, 0x5272 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A85, 0x559D }, // CJK UNIFIED IDEOGRAPH
    { 0x8A86, 0x6070 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A87, 0x62EC }, // CJK UNIFIED IDEOGRAPH
    { 0x8A88, 0x6D3B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A89, 0x6E07 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8A, 0x6ED1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8B, 0x845B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8C, 0x8910 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8D, 0x8F44 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8E, 0x4E14 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A8F, 0x9C39 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A90, 0x53F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A91, 0x691B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A92, 0x6A3A }, // CJK UNIFIED IDEOGRAPH
    { 0x8A93, 0x9784 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A94, 0x682A }, // CJK UNIFIED IDEOGRAPH
    { 0x8A95, 0x515C }, // CJK UNIFIED IDEOGRAPH
    { 0x8A96, 0x7AC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A97, 0x84B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A98, 0x91DC }, // CJK UNIFIED IDEOGRAPH
    { 0x8A99, 0x938C }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9A, 0x565B }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9B, 0x9D28 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9C, 0x6822 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9D, 0x8305 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9E, 0x8431 }, // CJK UNIFIED IDEOGRAPH
    { 0x8A9F, 0x7CA5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA0, 0x5208 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA1, 0x82C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA2, 0x74E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA3, 0x4E7E }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA4, 0x4F83 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA5, 0x51A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA6, 0x5BD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA7, 0x520A }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA8, 0x52D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AA9, 0x52E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAA, 0x5DFB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAB, 0x559A }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAC, 0x582A }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAD, 0x59E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAE, 0x5B8C }, // CJK UNIFIED IDEOGRAPH
    { 0x8AAF, 0x5B98 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB0, 0x5BDB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB1, 0x5E72 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB2, 0x5E79 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB3, 0x60A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB4, 0x611F }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB5, 0x6163 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB6, 0x61BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB7, 0x63DB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB8, 0x6562 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AB9, 0x67D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABA, 0x6853 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABB, 0x68FA }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABC, 0x6B3E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABD, 0x6B53 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABE, 0x6C57 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ABF, 0x6F22 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC0, 0x6F97 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC1, 0x6F45 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC2, 0x74B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC3, 0x7518 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC4, 0x76E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC5, 0x770B }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC6, 0x7AFF }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC7, 0x7BA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC8, 0x7C21 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AC9, 0x7DE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACA, 0x7F36 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACB, 0x7FF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACC, 0x809D }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACD, 0x8266 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACE, 0x839E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ACF, 0x89B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD0, 0x8ACC }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD1, 0x8CAB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD2, 0x9084 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD3, 0x9451 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD4, 0x9593 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD5, 0x9591 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD6, 0x95A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD7, 0x9665 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD8, 0x97D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AD9, 0x9928 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADA, 0x8218 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADB, 0x4E38 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADC, 0x542B }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADD, 0x5CB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADE, 0x5DCC }, // CJK UNIFIED IDEOGRAPH
    { 0x8ADF, 0x73A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE0, 0x764C }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE1, 0x773C }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE2, 0x5CA9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE3, 0x7FEB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE4, 0x8D0B }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE5, 0x96C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE6, 0x9811 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE7, 0x9854 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE8, 0x9858 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AE9, 0x4F01 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AEA, 0x4F0E }, // CJK UNIFIED IDEOGRAPH
    { 0x8AEB, 0x5371 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AEC, 0x559C }, // CJK UNIFIED IDEOGRAPH
    { 0x8AED, 0x5668 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AEE, 0x57FA }, // CJK UNIFIED IDEOGRAPH
    { 0x8AEF, 0x5947 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF0, 0x5B09 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF1, 0x5BC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF2, 0x5C90 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF3, 0x5E0C }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF4, 0x5E7E }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF5, 0x5FCC }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF6, 0x63EE }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF7, 0x673A }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF8, 0x65D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AF9, 0x65E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8AFA, 0x671F }, // CJK UNIFIED IDEOGRAPH
    { 0x8AFB, 0x68CB }, // CJK UNIFIED IDEOGRAPH
    { 0x8AFC, 0x68C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B40, 0x6A5F }, // CJK UNIFIED IDEOGRAPH
    { 0x8B41, 0x5E30 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B42, 0x6BC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B43, 0x6C17 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B44, 0x6C7D }, // CJK UNIFIED IDEOGRAPH
    { 0x8B45, 0x757F }, // CJK UNIFIED IDEOGRAPH
    { 0x8B46, 0x7948 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B47, 0x5B63 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B48, 0x7A00 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B49, 0x7D00 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4A, 0x5FBD }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4B, 0x898F }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4C, 0x8A18 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4D, 0x8CB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4E, 0x8D77 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B4F, 0x8ECC }, // CJK UNIFIED IDEOGRAPH
    { 0x8B50, 0x8F1D }, // CJK UNIFIED IDEOGRAPH
    { 0x8B51, 0x98E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B52, 0x9A0E }, // CJK UNIFIED IDEOGRAPH
    { 0x8B53, 0x9B3C }, // CJK UNIFIED IDEOGRAPH
    { 0x8B54, 0x4E80 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B55, 0x507D }, // CJK UNIFIED IDEOGRAPH
    { 0x8B56, 0x5100 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B57, 0x5993 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B58, 0x5B9C }, // CJK UNIFIED IDEOGRAPH
    { 0x8B59, 0x622F }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5A, 0x6280 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5B, 0x64EC }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5C, 0x6B3A }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5D, 0x72A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5E, 0x7591 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B5F, 0x7947 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B60, 0x7FA9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B61, 0x87FB }, // CJK UNIFIED IDEOGRAPH
    { 0x8B62, 0x8ABC }, // CJK UNIFIED IDEOGRAPH
    { 0x8B63, 0x8B70 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B64, 0x63AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8B65, 0x83CA }, // CJK UNIFIED IDEOGRAPH
    { 0x8B66, 0x97A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B67, 0x5409 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B68, 0x5403 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B69, 0x55AB }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6A, 0x6854 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6B, 0x6A58 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6C, 0x8A70 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6D, 0x7827 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6E, 0x6775 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B6F, 0x9ECD }, // CJK UNIFIED IDEOGRAPH
    { 0x8B70, 0x5374 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B71, 0x5BA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B72, 0x811A }, // CJK UNIFIED IDEOGRAPH
    { 0x8B73, 0x8650 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B74, 0x9006 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B75, 0x4E18 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B76, 0x4E45 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B77, 0x4EC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B78, 0x4F11 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B79, 0x53CA }, // CJK UNIFIED IDEOGRAPH
    { 0x8B7A, 0x5438 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B7B, 0x5BAE }, // CJK UNIFIED IDEOGRAPH
    { 0x8B7C, 0x5F13 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B7D, 0x6025 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B7E, 0x6551 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B80, 0x673D }, // CJK UNIFIED IDEOGRAPH
    { 0x8B81, 0x6C42 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B82, 0x6C72 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B83, 0x6CE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B84, 0x7078 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B85, 0x7403 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B86, 0x7A76 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B87, 0x7AAE }, // CJK UNIFIED IDEOGRAPH
    { 0x8B88, 0x7B08 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B89, 0x7D1A }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8A, 0x7CFE }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8B, 0x7D66 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8C, 0x65E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8D, 0x725B }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8E, 0x53BB }, // CJK UNIFIED IDEOGRAPH
    { 0x8B8F, 0x5C45 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B90, 0x5DE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B91, 0x62D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B92, 0x62E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B93, 0x6319 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B94, 0x6E20 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B95, 0x865A }, // CJK UNIFIED IDEOGRAPH
    { 0x8B96, 0x8A31 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B97, 0x8DDD }, // CJK UNIFIED IDEOGRAPH
    { 0x8B98, 0x92F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B99, 0x6F01 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9A, 0x79A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9B, 0x9B5A }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9C, 0x4EA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9D, 0x4EAB }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9E, 0x4EAC }, // CJK UNIFIED IDEOGRAPH
    { 0x8B9F, 0x4F9B }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA0, 0x4FA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA1, 0x50D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA2, 0x5147 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA3, 0x7AF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA4, 0x5171 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA5, 0x51F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA6, 0x5354 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA7, 0x5321 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA8, 0x537F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BA9, 0x53EB }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAA, 0x55AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAB, 0x5883 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAC, 0x5CE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAD, 0x5F37 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAE, 0x5F4A }, // CJK UNIFIED IDEOGRAPH
    { 0x8BAF, 0x602F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB0, 0x6050 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB1, 0x606D }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB2, 0x631F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB3, 0x6559 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB4, 0x6A4B }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB5, 0x6CC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB6, 0x72C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB7, 0x72ED }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB8, 0x77EF }, // CJK UNIFIED IDEOGRAPH
    { 0x8BB9, 0x80F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBA, 0x8105 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBB, 0x8208 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBC, 0x854E }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBD, 0x90F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBE, 0x93E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BBF, 0x97FF }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC0, 0x9957 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC1, 0x9A5A }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC2, 0x4EF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC3, 0x51DD }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC4, 0x5C2D }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC5, 0x6681 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC6, 0x696D }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC7, 0x5C40 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC8, 0x66F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BC9, 0x6975 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCA, 0x7389 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCB, 0x6850 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCC, 0x7C81 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCD, 0x50C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCE, 0x52E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BCF, 0x5747 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD0, 0x5DFE }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD1, 0x9326 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD2, 0x65A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD3, 0x6B23 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD4, 0x6B3D }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD5, 0x7434 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD6, 0x7981 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD7, 0x79BD }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD8, 0x7B4B }, // CJK UNIFIED IDEOGRAPH
    { 0x8BD9, 0x7DCA }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDA, 0x82B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDB, 0x83CC }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDC, 0x887F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDD, 0x895F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDE, 0x8B39 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BDF, 0x8FD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE0, 0x91D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE1, 0x541F }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE2, 0x9280 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE3, 0x4E5D }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE4, 0x5036 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE5, 0x53E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE6, 0x533A }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE7, 0x72D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE8, 0x7396 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BE9, 0x77E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BEA, 0x82E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BEB, 0x8EAF }, // CJK UNIFIED IDEOGRAPH
    { 0x8BEC, 0x99C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BED, 0x99C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BEE, 0x99D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BEF, 0x5177 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF0, 0x611A }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF1, 0x865E }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF2, 0x55B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF3, 0x7A7A }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF4, 0x5076 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF5, 0x5BD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF6, 0x9047 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF7, 0x9685 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF8, 0x4E32 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BF9, 0x6ADB }, // CJK UNIFIED IDEOGRAPH
    { 0x8BFA, 0x91E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BFB, 0x5C51 }, // CJK UNIFIED IDEOGRAPH
    { 0x8BFC, 0x5C48 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C40, 0x6398 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C41, 0x7A9F }, // CJK UNIFIED IDEOGRAPH
    { 0x8C42, 0x6C93 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C43, 0x9774 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C44, 0x8F61 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C45, 0x7AAA }, // CJK UNIFIED IDEOGRAPH
    { 0x8C46, 0x718A }, // CJK UNIFIED IDEOGRAPH
    { 0x8C47, 0x9688 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C48, 0x7C82 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C49, 0x6817 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4A, 0x7E70 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4B, 0x6851 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4C, 0x936C }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4D, 0x52F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4E, 0x541B }, // CJK UNIFIED IDEOGRAPH
    { 0x8C4F, 0x85AB }, // CJK UNIFIED IDEOGRAPH
    { 0x8C50, 0x8A13 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C51, 0x7FA4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C52, 0x8ECD }, // CJK UNIFIED IDEOGRAPH
    { 0x8C53, 0x90E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C54, 0x5366 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C55, 0x8888 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C56, 0x7941 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C57, 0x4FC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C58, 0x50BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8C59, 0x5211 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5A, 0x5144 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5B, 0x5553 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5C, 0x572D }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5D, 0x73EA }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5E, 0x578B }, // CJK UNIFIED IDEOGRAPH
    { 0x8C5F, 0x5951 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C60, 0x5F62 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C61, 0x5F84 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C62, 0x6075 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C63, 0x6176 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C64, 0x6167 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C65, 0x61A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C66, 0x63B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C67, 0x643A }, // CJK UNIFIED IDEOGRAPH
    { 0x8C68, 0x656C }, // CJK UNIFIED IDEOGRAPH
    { 0x8C69, 0x666F }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6A, 0x6842 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6B, 0x6E13 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6C, 0x7566 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6D, 0x7A3D }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6E, 0x7CFB }, // CJK UNIFIED IDEOGRAPH
    { 0x8C6F, 0x7D4C }, // CJK UNIFIED IDEOGRAPH
    { 0x8C70, 0x7D99 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C71, 0x7E4B }, // CJK UNIFIED IDEOGRAPH
    { 0x8C72, 0x7F6B }, // CJK UNIFIED IDEOGRAPH
    { 0x8C73, 0x830E }, // CJK UNIFIED IDEOGRAPH
    { 0x8C74, 0x834A }, // CJK UNIFIED IDEOGRAPH
    { 0x8C75, 0x86CD }, // CJK UNIFIED IDEOGRAPH
    { 0x8C76, 0x8A08 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C77, 0x8A63 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C78, 0x8B66 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C79, 0x8EFD }, // CJK UNIFIED IDEOGRAPH
    { 0x8C7A, 0x981A }, // CJK UNIFIED IDEOGRAPH
    { 0x8C7B, 0x9D8F }, // CJK UNIFIED IDEOGRAPH
    { 0x8C7C, 0x82B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C7D, 0x8FCE }, // CJK UNIFIED IDEOGRAPH
    { 0x8C7E, 0x9BE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C80, 0x5287 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C81, 0x621F }, // CJK UNIFIED IDEOGRAPH
    { 0x8C82, 0x6483 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C83, 0x6FC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C84, 0x9699 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C85, 0x6841 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C86, 0x5091 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C87, 0x6B20 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C88, 0x6C7A }, // CJK UNIFIED IDEOGRAPH
    { 0x8C89, 0x6F54 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8A, 0x7A74 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8B, 0x7D50 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8C, 0x8840 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8D, 0x8A23 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8E, 0x6708 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C8F, 0x4EF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C90, 0x5039 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C91, 0x5026 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C92, 0x5065 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C93, 0x517C }, // CJK UNIFIED IDEOGRAPH
    { 0x8C94, 0x5238 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C95, 0x5263 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C96, 0x55A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C97, 0x570F }, // CJK UNIFIED IDEOGRAPH
    { 0x8C98, 0x5805 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C99, 0x5ACC }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9A, 0x5EFA }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9B, 0x61B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9C, 0x61F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9D, 0x62F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9E, 0x6372 }, // CJK UNIFIED IDEOGRAPH
    { 0x8C9F, 0x691C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA0, 0x6A29 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA1, 0x727D }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA2, 0x72AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA3, 0x732E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA4, 0x7814 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA5, 0x786F }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA6, 0x7D79 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA7, 0x770C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA8, 0x80A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CA9, 0x898B }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAA, 0x8B19 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAB, 0x8CE2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAC, 0x8ED2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAD, 0x9063 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAE, 0x9375 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CAF, 0x967A }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB0, 0x9855 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB1, 0x9A13 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB2, 0x9E78 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB3, 0x5143 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB4, 0x539F }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB5, 0x53B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB6, 0x5E7B }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB7, 0x5F26 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB8, 0x6E1B }, // CJK UNIFIED IDEOGRAPH
    { 0x8CB9, 0x6E90 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBA, 0x7384 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBB, 0x73FE }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBC, 0x7D43 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBD, 0x8237 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBE, 0x8A00 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CBF, 0x8AFA }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC0, 0x9650 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC1, 0x4E4E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC2, 0x500B }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC3, 0x53E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC4, 0x547C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC5, 0x56FA }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC6, 0x59D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC7, 0x5B64 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC8, 0x5DF1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CC9, 0x5EAB }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCA, 0x5F27 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCB, 0x6238 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCC, 0x6545 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCD, 0x67AF }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCE, 0x6E56 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CCF, 0x72D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD0, 0x7CCA }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD1, 0x88B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD2, 0x80A1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD3, 0x80E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD4, 0x83F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD5, 0x864E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD6, 0x8A87 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD7, 0x8DE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD8, 0x9237 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CD9, 0x96C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDA, 0x9867 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDB, 0x9F13 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDC, 0x4E94 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDD, 0x4E92 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDE, 0x4F0D }, // CJK UNIFIED IDEOGRAPH
    { 0x8CDF, 0x5348 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE0, 0x5449 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE1, 0x543E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE2, 0x5A2F }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE3, 0x5F8C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE4, 0x5FA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE5, 0x609F }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE6, 0x68A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE7, 0x6A8E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE8, 0x745A }, // CJK UNIFIED IDEOGRAPH
    { 0x8CE9, 0x7881 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CEA, 0x8A9E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CEB, 0x8AA4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CEC, 0x8B77 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CED, 0x9190 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CEE, 0x4E5E }, // CJK UNIFIED IDEOGRAPH
    { 0x8CEF, 0x9BC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF0, 0x4EA4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF1, 0x4F7C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF2, 0x4FAF }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF3, 0x5019 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF4, 0x5016 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF5, 0x5149 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF6, 0x516C }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF7, 0x529F }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF8, 0x52B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CF9, 0x52FE }, // CJK UNIFIED IDEOGRAPH
    { 0x8CFA, 0x539A }, // CJK UNIFIED IDEOGRAPH
    { 0x8CFB, 0x53E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8CFC, 0x5411 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D40, 0x540E }, // CJK UNIFIED IDEOGRAPH
    { 0x8D41, 0x5589 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D42, 0x5751 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D43, 0x57A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D44, 0x597D }, // CJK UNIFIED IDEOGRAPH
    { 0x8D45, 0x5B54 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D46, 0x5B5D }, // CJK UNIFIED IDEOGRAPH
    { 0x8D47, 0x5B8F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D48, 0x5DE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D49, 0x5DE7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4A, 0x5DF7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4B, 0x5E78 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4C, 0x5E83 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4D, 0x5E9A }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4E, 0x5EB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D4F, 0x5F18 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D50, 0x6052 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D51, 0x614C }, // CJK UNIFIED IDEOGRAPH
    { 0x8D52, 0x6297 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D53, 0x62D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D54, 0x63A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D55, 0x653B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D56, 0x6602 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D57, 0x6643 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D58, 0x66F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D59, 0x676D }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5A, 0x6821 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5B, 0x6897 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5C, 0x69CB }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5D, 0x6C5F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5E, 0x6D2A }, // CJK UNIFIED IDEOGRAPH
    { 0x8D5F, 0x6D69 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D60, 0x6E2F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D61, 0x6E9D }, // CJK UNIFIED IDEOGRAPH
    { 0x8D62, 0x7532 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D63, 0x7687 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D64, 0x786C }, // CJK UNIFIED IDEOGRAPH
    { 0x8D65, 0x7A3F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D66, 0x7CE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D67, 0x7D05 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D68, 0x7D18 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D69, 0x7D5E }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6A, 0x7DB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6B, 0x8015 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6C, 0x8003 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6D, 0x80AF }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6E, 0x80B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D6F, 0x8154 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D70, 0x818F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D71, 0x822A }, // CJK UNIFIED IDEOGRAPH
    { 0x8D72, 0x8352 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D73, 0x884C }, // CJK UNIFIED IDEOGRAPH
    { 0x8D74, 0x8861 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D75, 0x8B1B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D76, 0x8CA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D77, 0x8CFC }, // CJK UNIFIED IDEOGRAPH
    { 0x8D78, 0x90CA }, // CJK UNIFIED IDEOGRAPH
    { 0x8D79, 0x9175 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D7A, 0x9271 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D7B, 0x783F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D7C, 0x92FC }, // CJK UNIFIED IDEOGRAPH
    { 0x8D7D, 0x95A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D7E, 0x964D }, // CJK UNIFIED IDEOGRAPH
    { 0x8D80, 0x9805 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D81, 0x9999 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D82, 0x9AD8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D83, 0x9D3B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D84, 0x525B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D85, 0x52AB }, // CJK UNIFIED IDEOGRAPH
    { 0x8D86, 0x53F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D87, 0x5408 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D88, 0x58D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D89, 0x62F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8A, 0x6FE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8B, 0x8C6A }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8C, 0x8F5F }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8D, 0x9EB9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8E, 0x514B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D8F, 0x523B }, // CJK UNIFIED IDEOGRAPH
    { 0x8D90, 0x544A }, // CJK UNIFIED IDEOGRAPH
    { 0x8D91, 0x56FD }, // CJK UNIFIED IDEOGRAPH
    { 0x8D92, 0x7A40 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D93, 0x9177 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D94, 0x9D60 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D95, 0x9ED2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D96, 0x7344 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D97, 0x6F09 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D98, 0x8170 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D99, 0x7511 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9A, 0x5FFD }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9B, 0x60DA }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9C, 0x9AA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9D, 0x72DB }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9E, 0x8FBC }, // CJK UNIFIED IDEOGRAPH
    { 0x8D9F, 0x6B64 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA0, 0x9803 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA1, 0x4ECA }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA2, 0x56F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA3, 0x5764 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA4, 0x58BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA5, 0x5A5A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA6, 0x6068 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA7, 0x61C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA8, 0x660F }, // CJK UNIFIED IDEOGRAPH
    { 0x8DA9, 0x6606 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAA, 0x6839 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAB, 0x68B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAC, 0x6DF7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAD, 0x75D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAE, 0x7D3A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DAF, 0x826E }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB0, 0x9B42 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB1, 0x4E9B }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB2, 0x4F50 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB3, 0x53C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB4, 0x5506 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB5, 0x5D6F }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB6, 0x5DE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB7, 0x5DEE }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB8, 0x67FB }, // CJK UNIFIED IDEOGRAPH
    { 0x8DB9, 0x6C99 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBA, 0x7473 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBB, 0x7802 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBC, 0x8A50 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBD, 0x9396 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBE, 0x88DF }, // CJK UNIFIED IDEOGRAPH
    { 0x8DBF, 0x5750 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC0, 0x5EA7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC1, 0x632B }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC2, 0x50B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC3, 0x50AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC4, 0x518D }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC5, 0x6700 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC6, 0x54C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC7, 0x585E }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC8, 0x59BB }, // CJK UNIFIED IDEOGRAPH
    { 0x8DC9, 0x5BB0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCA, 0x5F69 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCB, 0x624D }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCC, 0x63A1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCD, 0x683D }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCE, 0x6B73 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DCF, 0x6E08 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD0, 0x707D }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD1, 0x91C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD2, 0x7280 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD3, 0x7815 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD4, 0x7826 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD5, 0x796D }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD6, 0x658E }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD7, 0x7D30 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD8, 0x83DC }, // CJK UNIFIED IDEOGRAPH
    { 0x8DD9, 0x88C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDA, 0x8F09 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDB, 0x969B }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDC, 0x5264 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDD, 0x5728 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDE, 0x6750 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DDF, 0x7F6A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE0, 0x8CA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE1, 0x51B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE2, 0x5742 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE3, 0x962A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE4, 0x583A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE5, 0x698A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE6, 0x80B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE7, 0x54B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE8, 0x5D0E }, // CJK UNIFIED IDEOGRAPH
    { 0x8DE9, 0x57FC }, // CJK UNIFIED IDEOGRAPH
    { 0x8DEA, 0x7895 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DEB, 0x9DFA }, // CJK UNIFIED IDEOGRAPH
    { 0x8DEC, 0x4F5C }, // CJK UNIFIED IDEOGRAPH
    { 0x8DED, 0x524A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DEE, 0x548B }, // CJK UNIFIED IDEOGRAPH
    { 0x8DEF, 0x643E }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF0, 0x6628 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF1, 0x6714 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF2, 0x67F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF3, 0x7A84 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF4, 0x7B56 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF5, 0x7D22 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF6, 0x932F }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF7, 0x685C }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF8, 0x9BAD }, // CJK UNIFIED IDEOGRAPH
    { 0x8DF9, 0x7B39 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DFA, 0x5319 }, // CJK UNIFIED IDEOGRAPH
    { 0x8DFB, 0x518A }, // CJK UNIFIED IDEOGRAPH
    { 0x8DFC, 0x5237 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E40, 0x5BDF }, // CJK UNIFIED IDEOGRAPH
    { 0x8E41, 0x62F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E42, 0x64AE }, // CJK UNIFIED IDEOGRAPH
    { 0x8E43, 0x64E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E44, 0x672D }, // CJK UNIFIED IDEOGRAPH
    { 0x8E45, 0x6BBA }, // CJK UNIFIED IDEOGRAPH
    { 0x8E46, 0x85A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E47, 0x96D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E48, 0x7690 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E49, 0x9BD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4A, 0x634C }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4B, 0x9306 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4C, 0x9BAB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4D, 0x76BF }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4E, 0x6652 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E4F, 0x4E09 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E50, 0x5098 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E51, 0x53C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E52, 0x5C71 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E53, 0x60E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E54, 0x6492 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E55, 0x6563 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E56, 0x685F }, // CJK UNIFIED IDEOGRAPH
    { 0x8E57, 0x71E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E58, 0x73CA }, // CJK UNIFIED IDEOGRAPH
    { 0x8E59, 0x7523 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5A, 0x7B97 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5B, 0x7E82 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5C, 0x8695 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5D, 0x8B83 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5E, 0x8CDB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E5F, 0x9178 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E60, 0x9910 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E61, 0x65AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8E62, 0x66AB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E63, 0x6B8B }, // CJK UNIFIED IDEOGRAPH
    { 0x8E64, 0x4ED5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E65, 0x4ED4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E66, 0x4F3A }, // CJK UNIFIED IDEOGRAPH
    { 0x8E67, 0x4F7F }, // CJK UNIFIED IDEOGRAPH
    { 0x8E68, 0x523A }, // CJK UNIFIED IDEOGRAPH
    { 0x8E69, 0x53F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6A, 0x53F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6B, 0x55E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6C, 0x56DB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6D, 0x58EB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6E, 0x59CB }, // CJK UNIFIED IDEOGRAPH
    { 0x8E6F, 0x59C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E70, 0x59FF }, // CJK UNIFIED IDEOGRAPH
    { 0x8E71, 0x5B50 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E72, 0x5C4D }, // CJK UNIFIED IDEOGRAPH
    { 0x8E73, 0x5E02 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E74, 0x5E2B }, // CJK UNIFIED IDEOGRAPH
    { 0x8E75, 0x5FD7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E76, 0x601D }, // CJK UNIFIED IDEOGRAPH
    { 0x8E77, 0x6307 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E78, 0x652F }, // CJK UNIFIED IDEOGRAPH
    { 0x8E79, 0x5B5C }, // CJK UNIFIED IDEOGRAPH
    { 0x8E7A, 0x65AF }, // CJK UNIFIED IDEOGRAPH
    { 0x8E7B, 0x65BD }, // CJK UNIFIED IDEOGRAPH
    { 0x8E7C, 0x65E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E7D, 0x679D }, // CJK UNIFIED IDEOGRAPH
    { 0x8E7E, 0x6B62 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E80, 0x6B7B }, // CJK UNIFIED IDEOGRAPH
    { 0x8E81, 0x6C0F }, // CJK UNIFIED IDEOGRAPH
    { 0x8E82, 0x7345 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E83, 0x7949 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E84, 0x79C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E85, 0x7CF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E86, 0x7D19 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E87, 0x7D2B }, // CJK UNIFIED IDEOGRAPH
    { 0x8E88, 0x80A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E89, 0x8102 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8A, 0x81F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8B, 0x8996 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8C, 0x8A5E }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8D, 0x8A69 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8E, 0x8A66 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E8F, 0x8A8C }, // CJK UNIFIED IDEOGRAPH
    { 0x8E90, 0x8AEE }, // CJK UNIFIED IDEOGRAPH
    { 0x8E91, 0x8CC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E92, 0x8CDC }, // CJK UNIFIED IDEOGRAPH
    { 0x8E93, 0x96CC }, // CJK UNIFIED IDEOGRAPH
    { 0x8E94, 0x98FC }, // CJK UNIFIED IDEOGRAPH
    { 0x8E95, 0x6B6F }, // CJK UNIFIED IDEOGRAPH
    { 0x8E96, 0x4E8B }, // CJK UNIFIED IDEOGRAPH
    { 0x8E97, 0x4F3C }, // CJK UNIFIED IDEOGRAPH
    { 0x8E98, 0x4F8D }, // CJK UNIFIED IDEOGRAPH
    { 0x8E99, 0x5150 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9A, 0x5B57 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9B, 0x5BFA }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9C, 0x6148 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9D, 0x6301 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9E, 0x6642 }, // CJK UNIFIED IDEOGRAPH
    { 0x8E9F, 0x6B21 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA0, 0x6ECB }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA1, 0x6CBB }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA2, 0x723E }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA3, 0x74BD }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA4, 0x75D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA5, 0x78C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA6, 0x793A }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA7, 0x800C }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA8, 0x8033 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EA9, 0x81EA }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAA, 0x8494 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAB, 0x8F9E }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAC, 0x6C50 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAD, 0x9E7F }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAE, 0x5F0F }, // CJK UNIFIED IDEOGRAPH
    { 0x8EAF, 0x8B58 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB0, 0x9D2B }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB1, 0x7AFA }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB2, 0x8EF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB3, 0x5B8D }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB4, 0x96EB }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB5, 0x4E03 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB6, 0x53F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB7, 0x57F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB8, 0x5931 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EB9, 0x5AC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBA, 0x5BA4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBB, 0x6089 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBC, 0x6E7F }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBD, 0x6F06 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBE, 0x75BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8EBF, 0x8CEA }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC0, 0x5B9F }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC1, 0x8500 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC2, 0x7BE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC3, 0x5072 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC4, 0x67F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC5, 0x829D }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC6, 0x5C61 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC7, 0x854A }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC8, 0x7E1E }, // CJK UNIFIED IDEOGRAPH
    { 0x8EC9, 0x820E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECA, 0x5199 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECB, 0x5C04 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECC, 0x6368 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECD, 0x8D66 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECE, 0x659C }, // CJK UNIFIED IDEOGRAPH
    { 0x8ECF, 0x716E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED0, 0x793E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED1, 0x7D17 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED2, 0x8005 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED3, 0x8B1D }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED4, 0x8ECA }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED5, 0x906E }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED6, 0x86C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED7, 0x90AA }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED8, 0x501F }, // CJK UNIFIED IDEOGRAPH
    { 0x8ED9, 0x52FA }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDA, 0x5C3A }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDB, 0x6753 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDC, 0x707C }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDD, 0x7235 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDE, 0x914C }, // CJK UNIFIED IDEOGRAPH
    { 0x8EDF, 0x91C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE0, 0x932B }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE1, 0x82E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE2, 0x5BC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE3, 0x5F31 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE4, 0x60F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE5, 0x4E3B }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE6, 0x53D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE7, 0x5B88 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE8, 0x624B }, // CJK UNIFIED IDEOGRAPH
    { 0x8EE9, 0x6731 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EEA, 0x6B8A }, // CJK UNIFIED IDEOGRAPH
    { 0x8EEB, 0x72E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EEC, 0x73E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EED, 0x7A2E }, // CJK UNIFIED IDEOGRAPH
    { 0x8EEE, 0x816B }, // CJK UNIFIED IDEOGRAPH
    { 0x8EEF, 0x8DA3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF0, 0x9152 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF1, 0x9996 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF2, 0x5112 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF3, 0x53D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF4, 0x546A }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF5, 0x5BFF }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF6, 0x6388 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF7, 0x6A39 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF8, 0x7DAC }, // CJK UNIFIED IDEOGRAPH
    { 0x8EF9, 0x9700 }, // CJK UNIFIED IDEOGRAPH
    { 0x8EFA, 0x56DA }, // CJK UNIFIED IDEOGRAPH
    { 0x8EFB, 0x53CE }, // CJK UNIFIED IDEOGRAPH
    { 0x8EFC, 0x5468 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F40, 0x5B97 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F41, 0x5C31 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F42, 0x5DDE }, // CJK UNIFIED IDEOGRAPH
    { 0x8F43, 0x4FEE }, // CJK UNIFIED IDEOGRAPH
    { 0x8F44, 0x6101 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F45, 0x62FE }, // CJK UNIFIED IDEOGRAPH
    { 0x8F46, 0x6D32 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F47, 0x79C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F48, 0x79CB }, // CJK UNIFIED IDEOGRAPH
    { 0x8F49, 0x7D42 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4A, 0x7E4D }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4B, 0x7FD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4C, 0x81ED }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4D, 0x821F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4E, 0x8490 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F4F, 0x8846 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F50, 0x8972 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F51, 0x8B90 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F52, 0x8E74 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F53, 0x8F2F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F54, 0x9031 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F55, 0x914B }, // CJK UNIFIED IDEOGRAPH
    { 0x8F56, 0x916C }, // CJK UNIFIED IDEOGRAPH
    { 0x8F57, 0x96C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F58, 0x919C }, // CJK UNIFIED IDEOGRAPH
    { 0x8F59, 0x4EC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5A, 0x4F4F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5B, 0x5145 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5C, 0x5341 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5D, 0x5F93 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5E, 0x620E }, // CJK UNIFIED IDEOGRAPH
    { 0x8F5F, 0x67D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F60, 0x6C41 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F61, 0x6E0B }, // CJK UNIFIED IDEOGRAPH
    { 0x8F62, 0x7363 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F63, 0x7E26 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F64, 0x91CD }, // CJK UNIFIED IDEOGRAPH
    { 0x8F65, 0x9283 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F66, 0x53D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F67, 0x5919 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F68, 0x5BBF }, // CJK UNIFIED IDEOGRAPH
    { 0x8F69, 0x6DD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6A, 0x795D }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6B, 0x7E2E }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6C, 0x7C9B }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6D, 0x587E }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6E, 0x719F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F6F, 0x51FA }, // CJK UNIFIED IDEOGRAPH
    { 0x8F70, 0x8853 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F71, 0x8FF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F72, 0x4FCA }, // CJK UNIFIED IDEOGRAPH
    { 0x8F73, 0x5CFB }, // CJK UNIFIED IDEOGRAPH
    { 0x8F74, 0x6625 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F75, 0x77AC }, // CJK UNIFIED IDEOGRAPH
    { 0x8F76, 0x7AE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F77, 0x821C }, // CJK UNIFIED IDEOGRAPH
    { 0x8F78, 0x99FF }, // CJK UNIFIED IDEOGRAPH
    { 0x8F79, 0x51C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F7A, 0x5FAA }, // CJK UNIFIED IDEOGRAPH
    { 0x8F7B, 0x65EC }, // CJK UNIFIED IDEOGRAPH
    { 0x8F7C, 0x696F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F7D, 0x6B89 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F7E, 0x6DF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F80, 0x6E96 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F81, 0x6F64 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F82, 0x76FE }, // CJK UNIFIED IDEOGRAPH
    { 0x8F83, 0x7D14 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F84, 0x5DE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F85, 0x9075 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F86, 0x9187 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F87, 0x9806 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F88, 0x51E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F89, 0x521D }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8A, 0x6240 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8B, 0x6691 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8C, 0x66D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8D, 0x6E1A }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8E, 0x5EB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F8F, 0x7DD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F90, 0x7F72 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F91, 0x66F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F92, 0x85AF }, // CJK UNIFIED IDEOGRAPH
    { 0x8F93, 0x85F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F94, 0x8AF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F95, 0x52A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F96, 0x53D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F97, 0x5973 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F98, 0x5E8F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F99, 0x5F90 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9A, 0x6055 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9B, 0x92E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9C, 0x9664 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9D, 0x50B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9E, 0x511F }, // CJK UNIFIED IDEOGRAPH
    { 0x8F9F, 0x52DD }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA0, 0x5320 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA1, 0x5347 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA2, 0x53EC }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA3, 0x54E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA4, 0x5546 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA5, 0x5531 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA6, 0x5617 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA7, 0x5968 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA8, 0x59BE }, // CJK UNIFIED IDEOGRAPH
    { 0x8FA9, 0x5A3C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAA, 0x5BB5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAB, 0x5C06 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAC, 0x5C0F }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAD, 0x5C11 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAE, 0x5C1A }, // CJK UNIFIED IDEOGRAPH
    { 0x8FAF, 0x5E84 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB0, 0x5E8A }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB1, 0x5EE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB2, 0x5F70 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB3, 0x627F }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB4, 0x6284 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB5, 0x62DB }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB6, 0x638C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB7, 0x6377 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB8, 0x6607 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FB9, 0x660C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBA, 0x662D }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBB, 0x6676 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBC, 0x677E }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBD, 0x68A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBE, 0x6A1F }, // CJK UNIFIED IDEOGRAPH
    { 0x8FBF, 0x6A35 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC0, 0x6CBC }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC1, 0x6D88 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC2, 0x6E09 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC3, 0x6E58 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC4, 0x713C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC5, 0x7126 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC6, 0x7167 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC7, 0x75C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC8, 0x7701 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FC9, 0x785D }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCA, 0x7901 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCB, 0x7965 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCC, 0x79F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCD, 0x7AE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCE, 0x7B11 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FCF, 0x7CA7 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD0, 0x7D39 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD1, 0x8096 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD2, 0x83D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD3, 0x848B }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD4, 0x8549 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD5, 0x885D }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD6, 0x88F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD7, 0x8A1F }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD8, 0x8A3C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FD9, 0x8A54 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDA, 0x8A73 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDB, 0x8C61 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDC, 0x8CDE }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDD, 0x91A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDE, 0x9266 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FDF, 0x937E }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE0, 0x9418 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE1, 0x969C }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE2, 0x9798 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE3, 0x4E0A }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE4, 0x4E08 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE5, 0x4E1E }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE6, 0x4E57 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE7, 0x5197 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE8, 0x5270 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FE9, 0x57CE }, // CJK UNIFIED IDEOGRAPH
    { 0x8FEA, 0x5834 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FEB, 0x58CC }, // CJK UNIFIED IDEOGRAPH
    { 0x8FEC, 0x5B22 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FED, 0x5E38 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FEE, 0x60C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FEF, 0x64FE }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF0, 0x6761 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF1, 0x6756 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF2, 0x6D44 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF3, 0x72B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF4, 0x7573 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF5, 0x7A63 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF6, 0x84B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF7, 0x8B72 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF8, 0x91B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FF9, 0x9320 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FFA, 0x5631 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FFB, 0x57F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x8FFC, 0x98FE }, // CJK UNIFIED IDEOGRAPH
    { 0x9040, 0x62ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9041, 0x690D }, // CJK UNIFIED IDEOGRAPH
    { 0x9042, 0x6B96 }, // CJK UNIFIED IDEOGRAPH
    { 0x9043, 0x71ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9044, 0x7E54 }, // CJK UNIFIED IDEOGRAPH
    { 0x9045, 0x8077 }, // CJK UNIFIED IDEOGRAPH
    { 0x9046, 0x8272 }, // CJK UNIFIED IDEOGRAPH
    { 0x9047, 0x89E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9048, 0x98DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9049, 0x8755 }, // CJK UNIFIED IDEOGRAPH
    { 0x904A, 0x8FB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x904B, 0x5C3B }, // CJK UNIFIED IDEOGRAPH
    { 0x904C, 0x4F38 }, // CJK UNIFIED IDEOGRAPH
    { 0x904D, 0x4FE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x904E, 0x4FB5 }, // CJK UNIFIED IDEOGRAPH
    { 0x904F, 0x5507 }, // CJK UNIFIED IDEOGRAPH
    { 0x9050, 0x5A20 }, // CJK UNIFIED IDEOGRAPH
    { 0x9051, 0x5BDD }, // CJK UNIFIED IDEOGRAPH
    { 0x9052, 0x5BE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9053, 0x5FC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9054, 0x614E }, // CJK UNIFIED IDEOGRAPH
    { 0x9055, 0x632F }, // CJK UNIFIED IDEOGRAPH
    { 0x9056, 0x65B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9057, 0x664B }, // CJK UNIFIED IDEOGRAPH
    { 0x9058, 0x68EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9059, 0x699B }, // CJK UNIFIED IDEOGRAPH
    { 0x905A, 0x6D78 }, // CJK UNIFIED IDEOGRAPH
    { 0x905B, 0x6DF1 }, // CJK UNIFIED IDEOGRAPH
    { 0x905C, 0x7533 }, // CJK UNIFIED IDEOGRAPH
    { 0x905D, 0x75B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x905E, 0x771F }, // CJK UNIFIED IDEOGRAPH
    { 0x905F, 0x795E }, // CJK UNIFIED IDEOGRAPH
    { 0x9060, 0x79E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9061, 0x7D33 }, // CJK UNIFIED IDEOGRAPH
    { 0x9062, 0x81E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9063, 0x82AF }, // CJK UNIFIED IDEOGRAPH
    { 0x9064, 0x85AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9065, 0x89AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9066, 0x8A3A }, // CJK UNIFIED IDEOGRAPH
    { 0x9067, 0x8EAB }, // CJK UNIFIED IDEOGRAPH
    { 0x9068, 0x8F9B }, // CJK UNIFIED IDEOGRAPH
    { 0x9069, 0x9032 }, // CJK UNIFIED IDEOGRAPH
    { 0x906A, 0x91DD }, // CJK UNIFIED IDEOGRAPH
    { 0x906B, 0x9707 }, // CJK UNIFIED IDEOGRAPH
    { 0x906C, 0x4EBA }, // CJK UNIFIED IDEOGRAPH
    { 0x906D, 0x4EC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x906E, 0x5203 }, // CJK UNIFIED IDEOGRAPH
    { 0x906F, 0x5875 }, // CJK UNIFIED IDEOGRAPH
    { 0x9070, 0x58EC }, // CJK UNIFIED IDEOGRAPH
    { 0x9071, 0x5C0B }, // CJK UNIFIED IDEOGRAPH
    { 0x9072, 0x751A }, // CJK UNIFIED IDEOGRAPH
    { 0x9073, 0x5C3D }, // CJK UNIFIED IDEOGRAPH
    { 0x9074, 0x814E }, // CJK UNIFIED IDEOGRAPH
    { 0x9075, 0x8A0A }, // CJK UNIFIED IDEOGRAPH
    { 0x9076, 0x8FC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9077, 0x9663 }, // CJK UNIFIED IDEOGRAPH
    { 0x9078, 0x976D }, // CJK UNIFIED IDEOGRAPH
    { 0x9079, 0x7B25 }, // CJK UNIFIED IDEOGRAPH
    { 0x907A, 0x8ACF }, // CJK UNIFIED IDEOGRAPH
    { 0x907B, 0x9808 }, // CJK UNIFIED IDEOGRAPH
    { 0x907C, 0x9162 }, // CJK UNIFIED IDEOGRAPH
    { 0x907D, 0x56F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x907E, 0x53A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9080, 0x9017 }, // CJK UNIFIED IDEOGRAPH
    { 0x9081, 0x5439 }, // CJK UNIFIED IDEOGRAPH
    { 0x9082, 0x5782 }, // CJK UNIFIED IDEOGRAPH
    { 0x9083, 0x5E25 }, // CJK UNIFIED IDEOGRAPH
    { 0x9084, 0x63A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9085, 0x6C34 }, // CJK UNIFIED IDEOGRAPH
    { 0x9086, 0x708A }, // CJK UNIFIED IDEOGRAPH
    { 0x9087, 0x7761 }, // CJK UNIFIED IDEOGRAPH
    { 0x9088, 0x7C8B }, // CJK UNIFIED IDEOGRAPH
    { 0x9089, 0x7FE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x908A, 0x8870 }, // CJK UNIFIED IDEOGRAPH
    { 0x908B, 0x9042 }, // CJK UNIFIED IDEOGRAPH
    { 0x908C, 0x9154 }, // CJK UNIFIED IDEOGRAPH
    { 0x908D, 0x9310 }, // CJK UNIFIED IDEOGRAPH
    { 0x908E, 0x9318 }, // CJK UNIFIED IDEOGRAPH
    { 0x908F, 0x968F }, // CJK UNIFIED IDEOGRAPH
    { 0x9090, 0x745E }, // CJK UNIFIED IDEOGRAPH
    { 0x9091, 0x9AC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9092, 0x5D07 }, // CJK UNIFIED IDEOGRAPH
    { 0x9093, 0x5D69 }, // CJK UNIFIED IDEOGRAPH
    { 0x9094, 0x6570 }, // CJK UNIFIED IDEOGRAPH
    { 0x9095, 0x67A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9096, 0x8DA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9097, 0x96DB }, // CJK UNIFIED IDEOGRAPH
    { 0x9098, 0x636E }, // CJK UNIFIED IDEOGRAPH
    { 0x9099, 0x6749 }, // CJK UNIFIED IDEOGRAPH
    { 0x909A, 0x6919 }, // CJK UNIFIED IDEOGRAPH
    { 0x909B, 0x83C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x909C, 0x9817 }, // CJK UNIFIED IDEOGRAPH
    { 0x909D, 0x96C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x909E, 0x88FE }, // CJK UNIFIED IDEOGRAPH
    { 0x909F, 0x6F84 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A0, 0x647A }, // CJK UNIFIED IDEOGRAPH
    { 0x90A1, 0x5BF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A2, 0x4E16 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A3, 0x702C }, // CJK UNIFIED IDEOGRAPH
    { 0x90A4, 0x755D }, // CJK UNIFIED IDEOGRAPH
    { 0x90A5, 0x662F }, // CJK UNIFIED IDEOGRAPH
    { 0x90A6, 0x51C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A7, 0x5236 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A8, 0x52E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x90A9, 0x59D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x90AA, 0x5F81 }, // CJK UNIFIED IDEOGRAPH
    { 0x90AB, 0x6027 }, // CJK UNIFIED IDEOGRAPH
    { 0x90AC, 0x6210 }, // CJK UNIFIED IDEOGRAPH
    { 0x90AD, 0x653F }, // CJK UNIFIED IDEOGRAPH
    { 0x90AE, 0x6574 }, // CJK UNIFIED IDEOGRAPH
    { 0x90AF, 0x661F }, // CJK UNIFIED IDEOGRAPH
    { 0x90B0, 0x6674 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B1, 0x68F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B2, 0x6816 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B3, 0x6B63 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B4, 0x6E05 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B5, 0x7272 }, // CJK UNIFIED IDEOGRAPH
    { 0x90B6, 0x751F }, // CJK UNIFIED IDEOGRAPH
    { 0x90B7, 0x76DB }, // CJK UNIFIED IDEOGRAPH
    { 0x90B8, 0x7CBE }, // CJK UNIFIED IDEOGRAPH
    { 0x90B9, 0x8056 }, // CJK UNIFIED IDEOGRAPH
    { 0x90BA, 0x58F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x90BB, 0x88FD }, // CJK UNIFIED IDEOGRAPH
    { 0x90BC, 0x897F }, // CJK UNIFIED IDEOGRAPH
    { 0x90BD, 0x8AA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x90BE, 0x8A93 }, // CJK UNIFIED IDEOGRAPH
    { 0x90BF, 0x8ACB }, // CJK UNIFIED IDEOGRAPH
    { 0x90C0, 0x901D }, // CJK UNIFIED IDEOGRAPH
    { 0x90C1, 0x9192 }, // CJK UNIFIED IDEOGRAPH
    { 0x90C2, 0x9752 }, // CJK UNIFIED IDEOGRAPH
    { 0x90C3, 0x9759 }, // CJK UNIFIED IDEOGRAPH
    { 0x90C4, 0x6589 }, // CJK UNIFIED IDEOGRAPH
    { 0x90C5, 0x7A0E }, // CJK UNIFIED IDEOGRAPH
    { 0x90C6, 0x8106 }, // CJK UNIFIED IDEOGRAPH
    { 0x90C7, 0x96BB }, // CJK UNIFIED IDEOGRAPH
    { 0x90C8, 0x5E2D }, // CJK UNIFIED IDEOGRAPH
    { 0x90C9, 0x60DC }, // CJK UNIFIED IDEOGRAPH
    { 0x90CA, 0x621A }, // CJK UNIFIED IDEOGRAPH
    { 0x90CB, 0x65A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x90CC, 0x6614 }, // CJK UNIFIED IDEOGRAPH
    { 0x90CD, 0x6790 }, // CJK UNIFIED IDEOGRAPH
    { 0x90CE, 0x77F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x90CF, 0x7A4D }, // CJK UNIFIED IDEOGRAPH
    { 0x90D0, 0x7C4D }, // CJK UNIFIED IDEOGRAPH
    { 0x90D1, 0x7E3E }, // CJK UNIFIED IDEOGRAPH
    { 0x90D2, 0x810A }, // CJK UNIFIED IDEOGRAPH
    { 0x90D3, 0x8CAC }, // CJK UNIFIED IDEOGRAPH
    { 0x90D4, 0x8D64 }, // CJK UNIFIED IDEOGRAPH
    { 0x90D5, 0x8DE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x90D6, 0x8E5F }, // CJK UNIFIED IDEOGRAPH
    { 0x90D7, 0x78A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x90D8, 0x5207 }, // CJK UNIFIED IDEOGRAPH
    { 0x90D9, 0x62D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x90DA, 0x63A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x90DB, 0x6442 }, // CJK UNIFIED IDEOGRAPH
    { 0x90DC, 0x6298 }, // CJK UNIFIED IDEOGRAPH
    { 0x90DD, 0x8A2D }, // CJK UNIFIED IDEOGRAPH
    { 0x90DE, 0x7A83 }, // CJK UNIFIED IDEOGRAPH
    { 0x90DF, 0x7BC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E0, 0x8AAC }, // CJK UNIFIED IDEOGRAPH
    { 0x90E1, 0x96EA }, // CJK UNIFIED IDEOGRAPH
    { 0x90E2, 0x7D76 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E3, 0x820C }, // CJK UNIFIED IDEOGRAPH
    { 0x90E4, 0x8749 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E5, 0x4ED9 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E6, 0x5148 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E7, 0x5343 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E8, 0x5360 }, // CJK UNIFIED IDEOGRAPH
    { 0x90E9, 0x5BA3 }, // CJK UNIFIED IDEOGRAPH
    { 0x90EA, 0x5C02 }, // CJK UNIFIED IDEOGRAPH
    { 0x90EB, 0x5C16 }, // CJK UNIFIED IDEOGRAPH
    { 0x90EC, 0x5DDD }, // CJK UNIFIED IDEOGRAPH
    { 0x90ED, 0x6226 }, // CJK UNIFIED IDEOGRAPH
    { 0x90EE, 0x6247 }, // CJK UNIFIED IDEOGRAPH
    { 0x90EF, 0x64B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F0, 0x6813 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F1, 0x6834 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F2, 0x6CC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F3, 0x6D45 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F4, 0x6D17 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F5, 0x67D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x90F6, 0x6F5C }, // CJK UNIFIED IDEOGRAPH
    { 0x90F7, 0x714E }, // CJK UNIFIED IDEOGRAPH
    { 0x90F8, 0x717D }, // CJK UNIFIED IDEOGRAPH
    { 0x90F9, 0x65CB }, // CJK UNIFIED IDEOGRAPH
    { 0x90FA, 0x7A7F }, // CJK UNIFIED IDEOGRAPH
    { 0x90FB, 0x7BAD }, // CJK UNIFIED IDEOGRAPH
    { 0x90FC, 0x7DDA }, // CJK UNIFIED IDEOGRAPH
    { 0x9140, 0x7E4A }, // CJK UNIFIED IDEOGRAPH
    { 0x9141, 0x7FA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9142, 0x817A }, // CJK UNIFIED IDEOGRAPH
    { 0x9143, 0x821B }, // CJK UNIFIED IDEOGRAPH
    { 0x9144, 0x8239 }, // CJK UNIFIED IDEOGRAPH
    { 0x9145, 0x85A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9146, 0x8A6E }, // CJK UNIFIED IDEOGRAPH
    { 0x9147, 0x8CCE }, // CJK UNIFIED IDEOGRAPH
    { 0x9148, 0x8DF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9149, 0x9078 }, // CJK UNIFIED IDEOGRAPH
    { 0x914A, 0x9077 }, // CJK UNIFIED IDEOGRAPH
    { 0x914B, 0x92AD }, // CJK UNIFIED IDEOGRAPH
    { 0x914C, 0x9291 }, // CJK UNIFIED IDEOGRAPH
    { 0x914D, 0x9583 }, // CJK UNIFIED IDEOGRAPH
    { 0x914E, 0x9BAE }, // CJK UNIFIED IDEOGRAPH
    { 0x914F, 0x524D }, // CJK UNIFIED IDEOGRAPH
    { 0x9150, 0x5584 }, // CJK UNIFIED IDEOGRAPH
    { 0x9151, 0x6F38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9152, 0x7136 }, // CJK UNIFIED IDEOGRAPH
    { 0x9153, 0x5168 }, // CJK UNIFIED IDEOGRAPH
    { 0x9154, 0x7985 }, // CJK UNIFIED IDEOGRAPH
    { 0x9155, 0x7E55 }, // CJK UNIFIED IDEOGRAPH
    { 0x9156, 0x81B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9157, 0x7CCE }, // CJK UNIFIED IDEOGRAPH
    { 0x9158, 0x564C }, // CJK UNIFIED IDEOGRAPH
    { 0x9159, 0x5851 }, // CJK UNIFIED IDEOGRAPH
    { 0x915A, 0x5CA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x915B, 0x63AA }, // CJK UNIFIED IDEOGRAPH
    { 0x915C, 0x66FE }, // CJK UNIFIED IDEOGRAPH
    { 0x915D, 0x66FD }, // CJK UNIFIED IDEOGRAPH
    { 0x915E, 0x695A }, // CJK UNIFIED IDEOGRAPH
    { 0x915F, 0x72D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9160, 0x758F }, // CJK UNIFIED IDEOGRAPH
    { 0x9161, 0x758E }, // CJK UNIFIED IDEOGRAPH
    { 0x9162, 0x790E }, // CJK UNIFIED IDEOGRAPH
    { 0x9163, 0x7956 }, // CJK UNIFIED IDEOGRAPH
    { 0x9164, 0x79DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9165, 0x7C97 }, // CJK UNIFIED IDEOGRAPH
    { 0x9166, 0x7D20 }, // CJK UNIFIED IDEOGRAPH
    { 0x9167, 0x7D44 }, // CJK UNIFIED IDEOGRAPH
    { 0x9168, 0x8607 }, // CJK UNIFIED IDEOGRAPH
    { 0x9169, 0x8A34 }, // CJK UNIFIED IDEOGRAPH
    { 0x916A, 0x963B }, // CJK UNIFIED IDEOGRAPH
    { 0x916B, 0x9061 }, // CJK UNIFIED IDEOGRAPH
    { 0x916C, 0x9F20 }, // CJK UNIFIED IDEOGRAPH
    { 0x916D, 0x50E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x916E, 0x5275 }, // CJK UNIFIED IDEOGRAPH
    { 0x916F, 0x53CC }, // CJK UNIFIED IDEOGRAPH
    { 0x9170, 0x53E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9171, 0x5009 }, // CJK UNIFIED IDEOGRAPH
    { 0x9172, 0x55AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9173, 0x58EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9174, 0x594F }, // CJK UNIFIED IDEOGRAPH
    { 0x9175, 0x723D }, // CJK UNIFIED IDEOGRAPH
    { 0x9176, 0x5B8B }, // CJK UNIFIED IDEOGRAPH
    { 0x9177, 0x5C64 }, // CJK UNIFIED IDEOGRAPH
    { 0x9178, 0x531D }, // CJK UNIFIED IDEOGRAPH
    { 0x9179, 0x60E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x917A, 0x60F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x917B, 0x635C }, // CJK UNIFIED IDEOGRAPH
    { 0x917C, 0x6383 }, // CJK UNIFIED IDEOGRAPH
    { 0x917D, 0x633F }, // CJK UNIFIED IDEOGRAPH
    { 0x917E, 0x63BB }, // CJK UNIFIED IDEOGRAPH
    { 0x9180, 0x64CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9181, 0x65E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9182, 0x66F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9183, 0x5DE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9184, 0x69CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9185, 0x69FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9186, 0x6F15 }, // CJK UNIFIED IDEOGRAPH
    { 0x9187, 0x71E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9188, 0x4E89 }, // CJK UNIFIED IDEOGRAPH
    { 0x9189, 0x75E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x918A, 0x76F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x918B, 0x7A93 }, // CJK UNIFIED IDEOGRAPH
    { 0x918C, 0x7CDF }, // CJK UNIFIED IDEOGRAPH
    { 0x918D, 0x7DCF }, // CJK UNIFIED IDEOGRAPH
    { 0x918E, 0x7D9C }, // CJK UNIFIED IDEOGRAPH
    { 0x918F, 0x8061 }, // CJK UNIFIED IDEOGRAPH
    { 0x9190, 0x8349 }, // CJK UNIFIED IDEOGRAPH
    { 0x9191, 0x8358 }, // CJK UNIFIED IDEOGRAPH
    { 0x9192, 0x846C }, // CJK UNIFIED IDEOGRAPH
    { 0x9193, 0x84BC }, // CJK UNIFIED IDEOGRAPH
    { 0x9194, 0x85FB }, // CJK UNIFIED IDEOGRAPH
    { 0x9195, 0x88C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9196, 0x8D70 }, // CJK UNIFIED IDEOGRAPH
    { 0x9197, 0x9001 }, // CJK UNIFIED IDEOGRAPH
    { 0x9198, 0x906D }, // CJK UNIFIED IDEOGRAPH
    { 0x9199, 0x9397 }, // CJK UNIFIED IDEOGRAPH
    { 0x919A, 0x971C }, // CJK UNIFIED IDEOGRAPH
    { 0x919B, 0x9A12 }, // CJK UNIFIED IDEOGRAPH
    { 0x919C, 0x50CF }, // CJK UNIFIED IDEOGRAPH
    { 0x919D, 0x5897 }, // CJK UNIFIED IDEOGRAPH
    { 0x919E, 0x618E }, // CJK UNIFIED IDEOGRAPH
    { 0x919F, 0x81D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A0, 0x8535 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A1, 0x8D08 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A2, 0x9020 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A3, 0x4FC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A4, 0x5074 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A5, 0x5247 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A6, 0x5373 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A7, 0x606F }, // CJK UNIFIED IDEOGRAPH
    { 0x91A8, 0x6349 }, // CJK UNIFIED IDEOGRAPH
    { 0x91A9, 0x675F }, // CJK UNIFIED IDEOGRAPH
    { 0x91AA, 0x6E2C }, // CJK UNIFIED IDEOGRAPH
    { 0x91AB, 0x8DB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91AC, 0x901F }, // CJK UNIFIED IDEOGRAPH
    { 0x91AD, 0x4FD7 }, // CJK UNIFIED IDEOGRAPH
    { 0x91AE, 0x5C5E }, // CJK UNIFIED IDEOGRAPH
    { 0x91AF, 0x8CCA }, // CJK UNIFIED IDEOGRAPH
    { 0x91B0, 0x65CF }, // CJK UNIFIED IDEOGRAPH
    { 0x91B1, 0x7D9A }, // CJK UNIFIED IDEOGRAPH
    { 0x91B2, 0x5352 }, // CJK UNIFIED IDEOGRAPH
    { 0x91B3, 0x8896 }, // CJK UNIFIED IDEOGRAPH
    { 0x91B4, 0x5176 }, // CJK UNIFIED IDEOGRAPH
    { 0x91B5, 0x63C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91B6, 0x5B58 }, // CJK UNIFIED IDEOGRAPH
    { 0x91B7, 0x5B6B }, // CJK UNIFIED IDEOGRAPH
    { 0x91B8, 0x5C0A }, // CJK UNIFIED IDEOGRAPH
    { 0x91B9, 0x640D }, // CJK UNIFIED IDEOGRAPH
    { 0x91BA, 0x6751 }, // CJK UNIFIED IDEOGRAPH
    { 0x91BB, 0x905C }, // CJK UNIFIED IDEOGRAPH
    { 0x91BC, 0x4ED6 }, // CJK UNIFIED IDEOGRAPH
    { 0x91BD, 0x591A }, // CJK UNIFIED IDEOGRAPH
    { 0x91BE, 0x592A }, // CJK UNIFIED IDEOGRAPH
    { 0x91BF, 0x6C70 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C0, 0x8A51 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C1, 0x553E }, // CJK UNIFIED IDEOGRAPH
    { 0x91C2, 0x5815 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C3, 0x59A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C4, 0x60F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C5, 0x6253 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C6, 0x67C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C7, 0x8235 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C8, 0x6955 }, // CJK UNIFIED IDEOGRAPH
    { 0x91C9, 0x9640 }, // CJK UNIFIED IDEOGRAPH
    { 0x91CA, 0x99C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x91CB, 0x9A28 }, // CJK UNIFIED IDEOGRAPH
    { 0x91CC, 0x4F53 }, // CJK UNIFIED IDEOGRAPH
    { 0x91CD, 0x5806 }, // CJK UNIFIED IDEOGRAPH
    { 0x91CE, 0x5BFE }, // CJK UNIFIED IDEOGRAPH
    { 0x91CF, 0x8010 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D0, 0x5CB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D1, 0x5E2F }, // CJK UNIFIED IDEOGRAPH
    { 0x91D2, 0x5F85 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D3, 0x6020 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D4, 0x614B }, // CJK UNIFIED IDEOGRAPH
    { 0x91D5, 0x6234 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D6, 0x66FF }, // CJK UNIFIED IDEOGRAPH
    { 0x91D7, 0x6CF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x91D8, 0x6EDE }, // CJK UNIFIED IDEOGRAPH
    { 0x91D9, 0x80CE }, // CJK UNIFIED IDEOGRAPH
    { 0x91DA, 0x817F }, // CJK UNIFIED IDEOGRAPH
    { 0x91DB, 0x82D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x91DC, 0x888B }, // CJK UNIFIED IDEOGRAPH
    { 0x91DD, 0x8CB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x91DE, 0x9000 }, // CJK UNIFIED IDEOGRAPH
    { 0x91DF, 0x902E }, // CJK UNIFIED IDEOGRAPH
    { 0x91E0, 0x968A }, // CJK UNIFIED IDEOGRAPH
    { 0x91E1, 0x9EDB }, // CJK UNIFIED IDEOGRAPH
    { 0x91E2, 0x9BDB }, // CJK UNIFIED IDEOGRAPH
    { 0x91E3, 0x4EE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91E4, 0x53F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x91E5, 0x5927 }, // CJK UNIFIED IDEOGRAPH
    { 0x91E6, 0x7B2C }, // CJK UNIFIED IDEOGRAPH
    { 0x91E7, 0x918D }, // CJK UNIFIED IDEOGRAPH
    { 0x91E8, 0x984C }, // CJK UNIFIED IDEOGRAPH
    { 0x91E9, 0x9DF9 }, // CJK UNIFIED IDEOGRAPH
    { 0x91EA, 0x6EDD }, // CJK UNIFIED IDEOGRAPH
    { 0x91EB, 0x7027 }, // CJK UNIFIED IDEOGRAPH
    { 0x91EC, 0x5353 }, // CJK UNIFIED IDEOGRAPH
    { 0x91ED, 0x5544 }, // CJK UNIFIED IDEOGRAPH
    { 0x91EE, 0x5B85 }, // CJK UNIFIED IDEOGRAPH
    { 0x91EF, 0x6258 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F0, 0x629E }, // CJK UNIFIED IDEOGRAPH
    { 0x91F1, 0x62D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F2, 0x6CA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F3, 0x6FEF }, // CJK UNIFIED IDEOGRAPH
    { 0x91F4, 0x7422 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F5, 0x8A17 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F6, 0x9438 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F7, 0x6FC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x91F8, 0x8AFE }, // CJK UNIFIED IDEOGRAPH
    { 0x91F9, 0x8338 }, // CJK UNIFIED IDEOGRAPH
    { 0x91FA, 0x51E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x91FB, 0x86F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x91FC, 0x53EA }, // CJK UNIFIED IDEOGRAPH
    { 0x9240, 0x53E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9241, 0x4F46 }, // CJK UNIFIED IDEOGRAPH
    { 0x9242, 0x9054 }, // CJK UNIFIED IDEOGRAPH
    { 0x9243, 0x8FB0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9244, 0x596A }, // CJK UNIFIED IDEOGRAPH
    { 0x9245, 0x8131 }, // CJK UNIFIED IDEOGRAPH
    { 0x9246, 0x5DFD }, // CJK UNIFIED IDEOGRAPH
    { 0x9247, 0x7AEA }, // CJK UNIFIED IDEOGRAPH
    { 0x9248, 0x8FBF }, // CJK UNIFIED IDEOGRAPH
    { 0x9249, 0x68DA }, // CJK UNIFIED IDEOGRAPH
    { 0x924A, 0x8C37 }, // CJK UNIFIED IDEOGRAPH
    { 0x924B, 0x72F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x924C, 0x9C48 }, // CJK UNIFIED IDEOGRAPH
    { 0x924D, 0x6A3D }, // CJK UNIFIED IDEOGRAPH
    { 0x924E, 0x8AB0 }, // CJK UNIFIED IDEOGRAPH
    { 0x924F, 0x4E39 }, // CJK UNIFIED IDEOGRAPH
    { 0x9250, 0x5358 }, // CJK UNIFIED IDEOGRAPH
    { 0x9251, 0x5606 }, // CJK UNIFIED IDEOGRAPH
    { 0x9252, 0x5766 }, // CJK UNIFIED IDEOGRAPH
    { 0x9253, 0x62C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9254, 0x63A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9255, 0x65E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9256, 0x6B4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9257, 0x6DE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9258, 0x6E5B }, // CJK UNIFIED IDEOGRAPH
    { 0x9259, 0x70AD }, // CJK UNIFIED IDEOGRAPH
    { 0x925A, 0x77ED }, // CJK UNIFIED IDEOGRAPH
    { 0x925B, 0x7AEF }, // CJK UNIFIED IDEOGRAPH
    { 0x925C, 0x7BAA }, // CJK UNIFIED IDEOGRAPH
    { 0x925D, 0x7DBB }, // CJK UNIFIED IDEOGRAPH
    { 0x925E, 0x803D }, // CJK UNIFIED IDEOGRAPH
    { 0x925F, 0x80C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9260, 0x86CB }, // CJK UNIFIED IDEOGRAPH
    { 0x9261, 0x8A95 }, // CJK UNIFIED IDEOGRAPH
    { 0x9262, 0x935B }, // CJK UNIFIED IDEOGRAPH
    { 0x9263, 0x56E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9264, 0x58C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9265, 0x5F3E }, // CJK UNIFIED IDEOGRAPH
    { 0x9266, 0x65AD }, // CJK UNIFIED IDEOGRAPH
    { 0x9267, 0x6696 }, // CJK UNIFIED IDEOGRAPH
    { 0x9268, 0x6A80 }, // CJK UNIFIED IDEOGRAPH
    { 0x9269, 0x6BB5 }, // CJK UNIFIED IDEOGRAPH
    { 0x926A, 0x7537 }, // CJK UNIFIED IDEOGRAPH
    { 0x926B, 0x8AC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x926C, 0x5024 }, // CJK UNIFIED IDEOGRAPH
    { 0x926D, 0x77E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x926E, 0x5730 }, // CJK UNIFIED IDEOGRAPH
    { 0x926F, 0x5F1B }, // CJK UNIFIED IDEOGRAPH
    { 0x9270, 0x6065 }, // CJK UNIFIED IDEOGRAPH
    { 0x9271, 0x667A }, // CJK UNIFIED IDEOGRAPH
    { 0x9272, 0x6C60 }, // CJK UNIFIED IDEOGRAPH
    { 0x9273, 0x75F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9274, 0x7A1A }, // CJK UNIFIED IDEOGRAPH
    { 0x9275, 0x7F6E }, // CJK UNIFIED IDEOGRAPH
    { 0x9276, 0x81F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9277, 0x8718 }, // CJK UNIFIED IDEOGRAPH
    { 0x9278, 0x9045 }, // CJK UNIFIED IDEOGRAPH
    { 0x9279, 0x99B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x927A, 0x7BC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x927B, 0x755C }, // CJK UNIFIED IDEOGRAPH
    { 0x927C, 0x7AF9 }, // CJK UNIFIED IDEOGRAPH
    { 0x927D, 0x7B51 }, // CJK UNIFIED IDEOGRAPH
    { 0x927E, 0x84C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9280, 0x9010 }, // CJK UNIFIED IDEOGRAPH
    { 0x9281, 0x79E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9282, 0x7A92 }, // CJK UNIFIED IDEOGRAPH
    { 0x9283, 0x8336 }, // CJK UNIFIED IDEOGRAPH
    { 0x9284, 0x5AE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9285, 0x7740 }, // CJK UNIFIED IDEOGRAPH
    { 0x9286, 0x4E2D }, // CJK UNIFIED IDEOGRAPH
    { 0x9287, 0x4EF2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9288, 0x5B99 }, // CJK UNIFIED IDEOGRAPH
    { 0x9289, 0x5FE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x928A, 0x62BD }, // CJK UNIFIED IDEOGRAPH
    { 0x928B, 0x663C }, // CJK UNIFIED IDEOGRAPH
    { 0x928C, 0x67F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x928D, 0x6CE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x928E, 0x866B }, // CJK UNIFIED IDEOGRAPH
    { 0x928F, 0x8877 }, // CJK UNIFIED IDEOGRAPH
    { 0x9290, 0x8A3B }, // CJK UNIFIED IDEOGRAPH
    { 0x9291, 0x914E }, // CJK UNIFIED IDEOGRAPH
    { 0x9292, 0x92F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9293, 0x99D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9294, 0x6A17 }, // CJK UNIFIED IDEOGRAPH
    { 0x9295, 0x7026 }, // CJK UNIFIED IDEOGRAPH
    { 0x9296, 0x732A }, // CJK UNIFIED IDEOGRAPH
    { 0x9297, 0x82E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9298, 0x8457 }, // CJK UNIFIED IDEOGRAPH
    { 0x9299, 0x8CAF }, // CJK UNIFIED IDEOGRAPH
    { 0x929A, 0x4E01 }, // CJK UNIFIED IDEOGRAPH
    { 0x929B, 0x5146 }, // CJK UNIFIED IDEOGRAPH
    { 0x929C, 0x51CB }, // CJK UNIFIED IDEOGRAPH
    { 0x929D, 0x558B }, // CJK UNIFIED IDEOGRAPH
    { 0x929E, 0x5BF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x929F, 0x5E16 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A0, 0x5E33 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A1, 0x5E81 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A2, 0x5F14 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A3, 0x5F35 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A4, 0x5F6B }, // CJK UNIFIED IDEOGRAPH
    { 0x92A5, 0x5FB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A6, 0x61F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A7, 0x6311 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A8, 0x66A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x92A9, 0x671D }, // CJK UNIFIED IDEOGRAPH
    { 0x92AA, 0x6F6E }, // CJK UNIFIED IDEOGRAPH
    { 0x92AB, 0x7252 }, // CJK UNIFIED IDEOGRAPH
    { 0x92AC, 0x753A }, // CJK UNIFIED IDEOGRAPH
    { 0x92AD, 0x773A }, // CJK UNIFIED IDEOGRAPH
    { 0x92AE, 0x8074 }, // CJK UNIFIED IDEOGRAPH
    { 0x92AF, 0x8139 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B0, 0x8178 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B1, 0x8776 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B2, 0x8ABF }, // CJK UNIFIED IDEOGRAPH
    { 0x92B3, 0x8ADC }, // CJK UNIFIED IDEOGRAPH
    { 0x92B4, 0x8D85 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B5, 0x8DF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B6, 0x929A }, // CJK UNIFIED IDEOGRAPH
    { 0x92B7, 0x9577 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B8, 0x9802 }, // CJK UNIFIED IDEOGRAPH
    { 0x92B9, 0x9CE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BA, 0x52C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BB, 0x6357 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BC, 0x76F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BD, 0x6715 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BE, 0x6C88 }, // CJK UNIFIED IDEOGRAPH
    { 0x92BF, 0x73CD }, // CJK UNIFIED IDEOGRAPH
    { 0x92C0, 0x8CC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x92C1, 0x93AE }, // CJK UNIFIED IDEOGRAPH
    { 0x92C2, 0x9673 }, // CJK UNIFIED IDEOGRAPH
    { 0x92C3, 0x6D25 }, // CJK UNIFIED IDEOGRAPH
    { 0x92C4, 0x589C }, // CJK UNIFIED IDEOGRAPH
    { 0x92C5, 0x690E }, // CJK UNIFIED IDEOGRAPH
    { 0x92C6, 0x69CC }, // CJK UNIFIED IDEOGRAPH
    { 0x92C7, 0x8FFD }, // CJK UNIFIED IDEOGRAPH
    { 0x92C8, 0x939A }, // CJK UNIFIED IDEOGRAPH
    { 0x92C9, 0x75DB }, // CJK UNIFIED IDEOGRAPH
    { 0x92CA, 0x901A }, // CJK UNIFIED IDEOGRAPH
    { 0x92CB, 0x585A }, // CJK UNIFIED IDEOGRAPH
    { 0x92CC, 0x6802 }, // CJK UNIFIED IDEOGRAPH
    { 0x92CD, 0x63B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x92CE, 0x69FB }, // CJK UNIFIED IDEOGRAPH
    { 0x92CF, 0x4F43 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D0, 0x6F2C }, // CJK UNIFIED IDEOGRAPH
    { 0x92D1, 0x67D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D2, 0x8FBB }, // CJK UNIFIED IDEOGRAPH
    { 0x92D3, 0x8526 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D4, 0x7DB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D5, 0x9354 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D6, 0x693F }, // CJK UNIFIED IDEOGRAPH
    { 0x92D7, 0x6F70 }, // CJK UNIFIED IDEOGRAPH
    { 0x92D8, 0x576A }, // CJK UNIFIED IDEOGRAPH
    { 0x92D9, 0x58F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x92DA, 0x5B2C }, // CJK UNIFIED IDEOGRAPH
    { 0x92DB, 0x7D2C }, // CJK UNIFIED IDEOGRAPH
    { 0x92DC, 0x722A }, // CJK UNIFIED IDEOGRAPH
    { 0x92DD, 0x540A }, // CJK UNIFIED IDEOGRAPH
    { 0x92DE, 0x91E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x92DF, 0x9DB4 }, // CJK UNIFIED IDEOGRAPH
    { 0x92E0, 0x4EAD }, // CJK UNIFIED IDEOGRAPH
    { 0x92E1, 0x4F4E }, // CJK UNIFIED IDEOGRAPH
    { 0x92E2, 0x505C }, // CJK UNIFIED IDEOGRAPH
    { 0x92E3, 0x5075 }, // CJK UNIFIED IDEOGRAPH
    { 0x92E4, 0x5243 }, // CJK UNIFIED IDEOGRAPH
    { 0x92E5, 0x8C9E }, // CJK UNIFIED IDEOGRAPH
    { 0x92E6, 0x5448 }, // CJK UNIFIED IDEOGRAPH
    { 0x92E7, 0x5824 }, // CJK UNIFIED IDEOGRAPH
    { 0x92E8, 0x5B9A }, // CJK UNIFIED IDEOGRAPH
    { 0x92E9, 0x5E1D }, // CJK UNIFIED IDEOGRAPH
    { 0x92EA, 0x5E95 }, // CJK UNIFIED IDEOGRAPH
    { 0x92EB, 0x5EAD }, // CJK UNIFIED IDEOGRAPH
    { 0x92EC, 0x5EF7 }, // CJK UNIFIED IDEOGRAPH
    { 0x92ED, 0x5F1F }, // CJK UNIFIED IDEOGRAPH
    { 0x92EE, 0x608C }, // CJK UNIFIED IDEOGRAPH
    { 0x92EF, 0x62B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F0, 0x633A }, // CJK UNIFIED IDEOGRAPH
    { 0x92F1, 0x63D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F2, 0x68AF }, // CJK UNIFIED IDEOGRAPH
    { 0x92F3, 0x6C40 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F4, 0x7887 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F5, 0x798E }, // CJK UNIFIED IDEOGRAPH
    { 0x92F6, 0x7A0B }, // CJK UNIFIED IDEOGRAPH
    { 0x92F7, 0x7DE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F8, 0x8247 }, // CJK UNIFIED IDEOGRAPH
    { 0x92F9, 0x8A02 }, // CJK UNIFIED IDEOGRAPH
    { 0x92FA, 0x8AE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x92FB, 0x8E44 }, // CJK UNIFIED IDEOGRAPH
    { 0x92FC, 0x9013 }, // CJK UNIFIED IDEOGRAPH
    { 0x9340, 0x90B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9341, 0x912D }, // CJK UNIFIED IDEOGRAPH
    { 0x9342, 0x91D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9343, 0x9F0E }, // CJK UNIFIED IDEOGRAPH
    { 0x9344, 0x6CE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9345, 0x6458 }, // CJK UNIFIED IDEOGRAPH
    { 0x9346, 0x64E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9347, 0x6575 }, // CJK UNIFIED IDEOGRAPH
    { 0x9348, 0x6EF4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9349, 0x7684 }, // CJK UNIFIED IDEOGRAPH
    { 0x934A, 0x7B1B }, // CJK UNIFIED IDEOGRAPH
    { 0x934B, 0x9069 }, // CJK UNIFIED IDEOGRAPH
    { 0x934C, 0x93D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x934D, 0x6EBA }, // CJK UNIFIED IDEOGRAPH
    { 0x934E, 0x54F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x934F, 0x5FB9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9350, 0x64A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9351, 0x8F4D }, // CJK UNIFIED IDEOGRAPH
    { 0x9352, 0x8FED }, // CJK UNIFIED IDEOGRAPH
    { 0x9353, 0x9244 }, // CJK UNIFIED IDEOGRAPH
    { 0x9354, 0x5178 }, // CJK UNIFIED IDEOGRAPH
    { 0x9355, 0x586B }, // CJK UNIFIED IDEOGRAPH
    { 0x9356, 0x5929 }, // CJK UNIFIED IDEOGRAPH
    { 0x9357, 0x5C55 }, // CJK UNIFIED IDEOGRAPH
    { 0x9358, 0x5E97 }, // CJK UNIFIED IDEOGRAPH
    { 0x9359, 0x6DFB }, // CJK UNIFIED IDEOGRAPH
    { 0x935A, 0x7E8F }, // CJK UNIFIED IDEOGRAPH
    { 0x935B, 0x751C }, // CJK UNIFIED IDEOGRAPH
    { 0x935C, 0x8CBC }, // CJK UNIFIED IDEOGRAPH
    { 0x935D, 0x8EE2 }, // CJK UNIFIED IDEOGRAPH
    { 0x935E, 0x985B }, // CJK UNIFIED IDEOGRAPH
    { 0x935F, 0x70B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9360, 0x4F1D }, // CJK UNIFIED IDEOGRAPH
    { 0x9361, 0x6BBF }, // CJK UNIFIED IDEOGRAPH
    { 0x9362, 0x6FB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9363, 0x7530 }, // CJK UNIFIED IDEOGRAPH
    { 0x9364, 0x96FB }, // CJK UNIFIED IDEOGRAPH
    { 0x9365, 0x514E }, // CJK UNIFIED IDEOGRAPH
    { 0x9366, 0x5410 }, // CJK UNIFIED IDEOGRAPH
    { 0x9367, 0x5835 }, // CJK UNIFIED IDEOGRAPH
    { 0x9368, 0x5857 }, // CJK UNIFIED IDEOGRAPH
    { 0x9369, 0x59AC }, // CJK UNIFIED IDEOGRAPH
    { 0x936A, 0x5C60 }, // CJK UNIFIED IDEOGRAPH
    { 0x936B, 0x5F92 }, // CJK UNIFIED IDEOGRAPH
    { 0x936C, 0x6597 }, // CJK UNIFIED IDEOGRAPH
    { 0x936D, 0x675C }, // CJK UNIFIED IDEOGRAPH
    { 0x936E, 0x6E21 }, // CJK UNIFIED IDEOGRAPH
    { 0x936F, 0x767B }, // CJK UNIFIED IDEOGRAPH
    { 0x9370, 0x83DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9371, 0x8CED }, // CJK UNIFIED IDEOGRAPH
    { 0x9372, 0x9014 }, // CJK UNIFIED IDEOGRAPH
    { 0x9373, 0x90FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9374, 0x934D }, // CJK UNIFIED IDEOGRAPH
    { 0x9375, 0x7825 }, // CJK UNIFIED IDEOGRAPH
    { 0x9376, 0x783A }, // CJK UNIFIED IDEOGRAPH
    { 0x9377, 0x52AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9378, 0x5EA6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9379, 0x571F }, // CJK UNIFIED IDEOGRAPH
    { 0x937A, 0x5974 }, // CJK UNIFIED IDEOGRAPH
    { 0x937B, 0x6012 }, // CJK UNIFIED IDEOGRAPH
    { 0x937C, 0x5012 }, // CJK UNIFIED IDEOGRAPH
    { 0x937D, 0x515A }, // CJK UNIFIED IDEOGRAPH
    { 0x937E, 0x51AC }, // CJK UNIFIED IDEOGRAPH
    { 0x9380, 0x51CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9381, 0x5200 }, // CJK UNIFIED IDEOGRAPH
    { 0x9382, 0x5510 }, // CJK UNIFIED IDEOGRAPH
    { 0x9383, 0x5854 }, // CJK UNIFIED IDEOGRAPH
    { 0x9384, 0x5858 }, // CJK UNIFIED IDEOGRAPH
    { 0x9385, 0x5957 }, // CJK UNIFIED IDEOGRAPH
    { 0x9386, 0x5B95 }, // CJK UNIFIED IDEOGRAPH
    { 0x9387, 0x5CF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9388, 0x5D8B }, // CJK UNIFIED IDEOGRAPH
    { 0x9389, 0x60BC }, // CJK UNIFIED IDEOGRAPH
    { 0x938A, 0x6295 }, // CJK UNIFIED IDEOGRAPH
    { 0x938B, 0x642D }, // CJK UNIFIED IDEOGRAPH
    { 0x938C, 0x6771 }, // CJK UNIFIED IDEOGRAPH
    { 0x938D, 0x6843 }, // CJK UNIFIED IDEOGRAPH
    { 0x938E, 0x68BC }, // CJK UNIFIED IDEOGRAPH
    { 0x938F, 0x68DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9390, 0x76D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9391, 0x6DD8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9392, 0x6E6F }, // CJK UNIFIED IDEOGRAPH
    { 0x9393, 0x6D9B }, // CJK UNIFIED IDEOGRAPH
    { 0x9394, 0x706F }, // CJK UNIFIED IDEOGRAPH
    { 0x9395, 0x71C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9396, 0x5F53 }, // CJK UNIFIED IDEOGRAPH
    { 0x9397, 0x75D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9398, 0x7977 }, // CJK UNIFIED IDEOGRAPH
    { 0x9399, 0x7B49 }, // CJK UNIFIED IDEOGRAPH
    { 0x939A, 0x7B54 }, // CJK UNIFIED IDEOGRAPH
    { 0x939B, 0x7B52 }, // CJK UNIFIED IDEOGRAPH
    { 0x939C, 0x7CD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x939D, 0x7D71 }, // CJK UNIFIED IDEOGRAPH
    { 0x939E, 0x5230 }, // CJK UNIFIED IDEOGRAPH
    { 0x939F, 0x8463 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A0, 0x8569 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A1, 0x85E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A2, 0x8A0E }, // CJK UNIFIED IDEOGRAPH
    { 0x93A3, 0x8B04 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A4, 0x8C46 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A5, 0x8E0F }, // CJK UNIFIED IDEOGRAPH
    { 0x93A6, 0x9003 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A7, 0x900F }, // CJK UNIFIED IDEOGRAPH
    { 0x93A8, 0x9419 }, // CJK UNIFIED IDEOGRAPH
    { 0x93A9, 0x9676 }, // CJK UNIFIED IDEOGRAPH
    { 0x93AA, 0x982D }, // CJK UNIFIED IDEOGRAPH
    { 0x93AB, 0x9A30 }, // CJK UNIFIED IDEOGRAPH
    { 0x93AC, 0x95D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x93AD, 0x50CD }, // CJK UNIFIED IDEOGRAPH
    { 0x93AE, 0x52D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x93AF, 0x540C }, // CJK UNIFIED IDEOGRAPH
    { 0x93B0, 0x5802 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B1, 0x5C0E }, // CJK UNIFIED IDEOGRAPH
    { 0x93B2, 0x61A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B3, 0x649E }, // CJK UNIFIED IDEOGRAPH
    { 0x93B4, 0x6D1E }, // CJK UNIFIED IDEOGRAPH
    { 0x93B5, 0x77B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B6, 0x7AE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B7, 0x80F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B8, 0x8404 }, // CJK UNIFIED IDEOGRAPH
    { 0x93B9, 0x9053 }, // CJK UNIFIED IDEOGRAPH
    { 0x93BA, 0x9285 }, // CJK UNIFIED IDEOGRAPH
    { 0x93BB, 0x5CE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x93BC, 0x9D07 }, // CJK UNIFIED IDEOGRAPH
    { 0x93BD, 0x533F }, // CJK UNIFIED IDEOGRAPH
    { 0x93BE, 0x5F97 }, // CJK UNIFIED IDEOGRAPH
    { 0x93BF, 0x5FB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C0, 0x6D9C }, // CJK UNIFIED IDEOGRAPH
    { 0x93C1, 0x7279 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C2, 0x7763 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C3, 0x79BF }, // CJK UNIFIED IDEOGRAPH
    { 0x93C4, 0x7BE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C5, 0x6BD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C6, 0x72EC }, // CJK UNIFIED IDEOGRAPH
    { 0x93C7, 0x8AAD }, // CJK UNIFIED IDEOGRAPH
    { 0x93C8, 0x6803 }, // CJK UNIFIED IDEOGRAPH
    { 0x93C9, 0x6A61 }, // CJK UNIFIED IDEOGRAPH
    { 0x93CA, 0x51F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x93CB, 0x7A81 }, // CJK UNIFIED IDEOGRAPH
    { 0x93CC, 0x6934 }, // CJK UNIFIED IDEOGRAPH
    { 0x93CD, 0x5C4A }, // CJK UNIFIED IDEOGRAPH
    { 0x93CE, 0x9CF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x93CF, 0x82EB }, // CJK UNIFIED IDEOGRAPH
    { 0x93D0, 0x5BC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x93D1, 0x9149 }, // CJK UNIFIED IDEOGRAPH
    { 0x93D2, 0x701E }, // CJK UNIFIED IDEOGRAPH
    { 0x93D3, 0x5678 }, // CJK UNIFIED IDEOGRAPH
    { 0x93D4, 0x5C6F }, // CJK UNIFIED IDEOGRAPH
    { 0x93D5, 0x60C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x93D6, 0x6566 }, // CJK UNIFIED IDEOGRAPH
    { 0x93D7, 0x6C8C }, // CJK UNIFIED IDEOGRAPH
    { 0x93D8, 0x8C5A }, // CJK UNIFIED IDEOGRAPH
    { 0x93D9, 0x9041 }, // CJK UNIFIED IDEOGRAPH
    { 0x93DA, 0x9813 }, // CJK UNIFIED IDEOGRAPH
    { 0x93DB, 0x5451 }, // CJK UNIFIED IDEOGRAPH
    { 0x93DC, 0x66C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x93DD, 0x920D }, // CJK UNIFIED IDEOGRAPH
    { 0x93DE, 0x5948 }, // CJK UNIFIED IDEOGRAPH
    { 0x93DF, 0x90A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x93E0, 0x5185 }, // CJK UNIFIED IDEOGRAPH
    { 0x93E1, 0x4E4D }, // CJK UNIFIED IDEOGRAPH
    { 0x93E2, 0x51EA }, // CJK UNIFIED IDEOGRAPH
    { 0x93E3, 0x8599 }, // CJK UNIFIED IDEOGRAPH
    { 0x93E4, 0x8B0E }, // CJK UNIFIED IDEOGRAPH
    { 0x93E5, 0x7058 }, // CJK UNIFIED IDEOGRAPH
    { 0x93E6, 0x637A }, // CJK UNIFIED IDEOGRAPH
    { 0x93E7, 0x934B }, // CJK UNIFIED IDEOGRAPH
    { 0x93E8, 0x6962 }, // CJK UNIFIED IDEOGRAPH
    { 0x93E9, 0x99B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x93EA, 0x7E04 }, // CJK UNIFIED IDEOGRAPH
    { 0x93EB, 0x7577 }, // CJK UNIFIED IDEOGRAPH
    { 0x93EC, 0x5357 }, // CJK UNIFIED IDEOGRAPH
    { 0x93ED, 0x6960 }, // CJK UNIFIED IDEOGRAPH
    { 0x93EE, 0x8EDF }, // CJK UNIFIED IDEOGRAPH
    { 0x93EF, 0x96E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F0, 0x6C5D }, // CJK UNIFIED IDEOGRAPH
    { 0x93F1, 0x4E8C }, // CJK UNIFIED IDEOGRAPH
    { 0x93F2, 0x5C3C }, // CJK UNIFIED IDEOGRAPH
    { 0x93F3, 0x5F10 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F4, 0x8FE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F5, 0x5302 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F6, 0x8CD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F7, 0x8089 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F8, 0x8679 }, // CJK UNIFIED IDEOGRAPH
    { 0x93F9, 0x5EFF }, // CJK UNIFIED IDEOGRAPH
    { 0x93FA, 0x65E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x93FB, 0x4E73 }, // CJK UNIFIED IDEOGRAPH
    { 0x93FC, 0x5165 }, // CJK UNIFIED IDEOGRAPH
    { 0x9440, 0x5982 }, // CJK UNIFIED IDEOGRAPH
    { 0x9441, 0x5C3F }, // CJK UNIFIED IDEOGRAPH
    { 0x9442, 0x97EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9443, 0x4EFB }, // CJK UNIFIED IDEOGRAPH
    { 0x9444, 0x598A }, // CJK UNIFIED IDEOGRAPH
    { 0x9445, 0x5FCD }, // CJK UNIFIED IDEOGRAPH
    { 0x9446, 0x8A8D }, // CJK UNIFIED IDEOGRAPH
    { 0x9447, 0x6FE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9448, 0x79B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9449, 0x7962 }, // CJK UNIFIED IDEOGRAPH
    { 0x944A, 0x5BE7 }, // CJK UNIFIED IDEOGRAPH
    { 0x944B, 0x8471 }, // CJK UNIFIED IDEOGRAPH
    { 0x944C, 0x732B }, // CJK UNIFIED IDEOGRAPH
    { 0x944D, 0x71B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x944E, 0x5E74 }, // CJK UNIFIED IDEOGRAPH
    { 0x944F, 0x5FF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9450, 0x637B }, // CJK UNIFIED IDEOGRAPH
    { 0x9451, 0x649A }, // CJK UNIFIED IDEOGRAPH
    { 0x9452, 0x71C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9453, 0x7C98 }, // CJK UNIFIED IDEOGRAPH
    { 0x9454, 0x4E43 }, // CJK UNIFIED IDEOGRAPH
    { 0x9455, 0x5EFC }, // CJK UNIFIED IDEOGRAPH
    { 0x9456, 0x4E4B }, // CJK UNIFIED IDEOGRAPH
    { 0x9457, 0x57DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9458, 0x56A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9459, 0x60A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x945A, 0x6FC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x945B, 0x7D0D }, // CJK UNIFIED IDEOGRAPH
    { 0x945C, 0x80FD }, // CJK UNIFIED IDEOGRAPH
    { 0x945D, 0x8133 }, // CJK UNIFIED IDEOGRAPH
    { 0x945E, 0x81BF }, // CJK UNIFIED IDEOGRAPH
    { 0x945F, 0x8FB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9460, 0x8997 }, // CJK UNIFIED IDEOGRAPH
    { 0x9461, 0x86A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9462, 0x5DF4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9463, 0x628A }, // CJK UNIFIED IDEOGRAPH
    { 0x9464, 0x64AD }, // CJK UNIFIED IDEOGRAPH
    { 0x9465, 0x8987 }, // CJK UNIFIED IDEOGRAPH
    { 0x9466, 0x6777 }, // CJK UNIFIED IDEOGRAPH
    { 0x9467, 0x6CE2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9468, 0x6D3E }, // CJK UNIFIED IDEOGRAPH
    { 0x9469, 0x7436 }, // CJK UNIFIED IDEOGRAPH
    { 0x946A, 0x7834 }, // CJK UNIFIED IDEOGRAPH
    { 0x946B, 0x5A46 }, // CJK UNIFIED IDEOGRAPH
    { 0x946C, 0x7F75 }, // CJK UNIFIED IDEOGRAPH
    { 0x946D, 0x82AD }, // CJK UNIFIED IDEOGRAPH
    { 0x946E, 0x99AC }, // CJK UNIFIED IDEOGRAPH
    { 0x946F, 0x4FF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9470, 0x5EC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9471, 0x62DD }, // CJK UNIFIED IDEOGRAPH
    { 0x9472, 0x6392 }, // CJK UNIFIED IDEOGRAPH
    { 0x9473, 0x6557 }, // CJK UNIFIED IDEOGRAPH
    { 0x9474, 0x676F }, // CJK UNIFIED IDEOGRAPH
    { 0x9475, 0x76C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9476, 0x724C }, // CJK UNIFIED IDEOGRAPH
    { 0x9477, 0x80CC }, // CJK UNIFIED IDEOGRAPH
    { 0x9478, 0x80BA }, // CJK UNIFIED IDEOGRAPH
    { 0x9479, 0x8F29 }, // CJK UNIFIED IDEOGRAPH
    { 0x947A, 0x914D }, // CJK UNIFIED IDEOGRAPH
    { 0x947B, 0x500D }, // CJK UNIFIED IDEOGRAPH
    { 0x947C, 0x57F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x947D, 0x5A92 }, // CJK UNIFIED IDEOGRAPH
    { 0x947E, 0x6885 }, // CJK UNIFIED IDEOGRAPH
    { 0x9480, 0x6973 }, // CJK UNIFIED IDEOGRAPH
    { 0x9481, 0x7164 }, // CJK UNIFIED IDEOGRAPH
    { 0x9482, 0x72FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9483, 0x8CB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9484, 0x58F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9485, 0x8CE0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9486, 0x966A }, // CJK UNIFIED IDEOGRAPH
    { 0x9487, 0x9019 }, // CJK UNIFIED IDEOGRAPH
    { 0x9488, 0x877F }, // CJK UNIFIED IDEOGRAPH
    { 0x9489, 0x79E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x948A, 0x77E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x948B, 0x8429 }, // CJK UNIFIED IDEOGRAPH
    { 0x948C, 0x4F2F }, // CJK UNIFIED IDEOGRAPH
    { 0x948D, 0x5265 }, // CJK UNIFIED IDEOGRAPH
    { 0x948E, 0x535A }, // CJK UNIFIED IDEOGRAPH
    { 0x948F, 0x62CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9490, 0x67CF }, // CJK UNIFIED IDEOGRAPH
    { 0x9491, 0x6CCA }, // CJK UNIFIED IDEOGRAPH
    { 0x9492, 0x767D }, // CJK UNIFIED IDEOGRAPH
    { 0x9493, 0x7B94 }, // CJK UNIFIED IDEOGRAPH
    { 0x9494, 0x7C95 }, // CJK UNIFIED IDEOGRAPH
    { 0x9495, 0x8236 }, // CJK UNIFIED IDEOGRAPH
    { 0x9496, 0x8584 }, // CJK UNIFIED IDEOGRAPH
    { 0x9497, 0x8FEB }, // CJK UNIFIED IDEOGRAPH
    { 0x9498, 0x66DD }, // CJK UNIFIED IDEOGRAPH
    { 0x9499, 0x6F20 }, // CJK UNIFIED IDEOGRAPH
    { 0x949A, 0x7206 }, // CJK UNIFIED IDEOGRAPH
    { 0x949B, 0x7E1B }, // CJK UNIFIED IDEOGRAPH
    { 0x949C, 0x83AB }, // CJK UNIFIED IDEOGRAPH
    { 0x949D, 0x99C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x949E, 0x9EA6 }, // CJK UNIFIED IDEOGRAPH
    { 0x949F, 0x51FD }, // CJK UNIFIED IDEOGRAPH
    { 0x94A0, 0x7BB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A1, 0x7872 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A2, 0x7BB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A3, 0x8087 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A4, 0x7B48 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A5, 0x6AE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A6, 0x5E61 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A7, 0x808C }, // CJK UNIFIED IDEOGRAPH
    { 0x94A8, 0x7551 }, // CJK UNIFIED IDEOGRAPH
    { 0x94A9, 0x7560 }, // CJK UNIFIED IDEOGRAPH
    { 0x94AA, 0x516B }, // CJK UNIFIED IDEOGRAPH
    { 0x94AB, 0x9262 }, // CJK UNIFIED IDEOGRAPH
    { 0x94AC, 0x6E8C }, // CJK UNIFIED IDEOGRAPH
    { 0x94AD, 0x767A }, // CJK UNIFIED IDEOGRAPH
    { 0x94AE, 0x9197 }, // CJK UNIFIED IDEOGRAPH
    { 0x94AF, 0x9AEA }, // CJK UNIFIED IDEOGRAPH
    { 0x94B0, 0x4F10 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B1, 0x7F70 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B2, 0x629C }, // CJK UNIFIED IDEOGRAPH
    { 0x94B3, 0x7B4F }, // CJK UNIFIED IDEOGRAPH
    { 0x94B4, 0x95A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B5, 0x9CE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B6, 0x567A }, // CJK UNIFIED IDEOGRAPH
    { 0x94B7, 0x5859 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B8, 0x86E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x94B9, 0x96BC }, // CJK UNIFIED IDEOGRAPH
    { 0x94BA, 0x4F34 }, // CJK UNIFIED IDEOGRAPH
    { 0x94BB, 0x5224 }, // CJK UNIFIED IDEOGRAPH
    { 0x94BC, 0x534A }, // CJK UNIFIED IDEOGRAPH
    { 0x94BD, 0x53CD }, // CJK UNIFIED IDEOGRAPH
    { 0x94BE, 0x53DB }, // CJK UNIFIED IDEOGRAPH
    { 0x94BF, 0x5E06 }, // CJK UNIFIED IDEOGRAPH
    { 0x94C0, 0x642C }, // CJK UNIFIED IDEOGRAPH
    { 0x94C1, 0x6591 }, // CJK UNIFIED IDEOGRAPH
    { 0x94C2, 0x677F }, // CJK UNIFIED IDEOGRAPH
    { 0x94C3, 0x6C3E }, // CJK UNIFIED IDEOGRAPH
    { 0x94C4, 0x6C4E }, // CJK UNIFIED IDEOGRAPH
    { 0x94C5, 0x7248 }, // CJK UNIFIED IDEOGRAPH
    { 0x94C6, 0x72AF }, // CJK UNIFIED IDEOGRAPH
    { 0x94C7, 0x73ED }, // CJK UNIFIED IDEOGRAPH
    { 0x94C8, 0x7554 }, // CJK UNIFIED IDEOGRAPH
    { 0x94C9, 0x7E41 }, // CJK UNIFIED IDEOGRAPH
    { 0x94CA, 0x822C }, // CJK UNIFIED IDEOGRAPH
    { 0x94CB, 0x85E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x94CC, 0x8CA9 }, // CJK UNIFIED IDEOGRAPH
    { 0x94CD, 0x7BC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x94CE, 0x91C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x94CF, 0x7169 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D0, 0x9812 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D1, 0x98EF }, // CJK UNIFIED IDEOGRAPH
    { 0x94D2, 0x633D }, // CJK UNIFIED IDEOGRAPH
    { 0x94D3, 0x6669 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D4, 0x756A }, // CJK UNIFIED IDEOGRAPH
    { 0x94D5, 0x76E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D6, 0x78D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D7, 0x8543 }, // CJK UNIFIED IDEOGRAPH
    { 0x94D8, 0x86EE }, // CJK UNIFIED IDEOGRAPH
    { 0x94D9, 0x532A }, // CJK UNIFIED IDEOGRAPH
    { 0x94DA, 0x5351 }, // CJK UNIFIED IDEOGRAPH
    { 0x94DB, 0x5426 }, // CJK UNIFIED IDEOGRAPH
    { 0x94DC, 0x5983 }, // CJK UNIFIED IDEOGRAPH
    { 0x94DD, 0x5E87 }, // CJK UNIFIED IDEOGRAPH
    { 0x94DE, 0x5F7C }, // CJK UNIFIED IDEOGRAPH
    { 0x94DF, 0x60B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E0, 0x6249 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E1, 0x6279 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E2, 0x62AB }, // CJK UNIFIED IDEOGRAPH
    { 0x94E3, 0x6590 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E4, 0x6BD4 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E5, 0x6CCC }, // CJK UNIFIED IDEOGRAPH
    { 0x94E6, 0x75B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E7, 0x76AE }, // CJK UNIFIED IDEOGRAPH
    { 0x94E8, 0x7891 }, // CJK UNIFIED IDEOGRAPH
    { 0x94E9, 0x79D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x94EA, 0x7DCB }, // CJK UNIFIED IDEOGRAPH
    { 0x94EB, 0x7F77 }, // CJK UNIFIED IDEOGRAPH
    { 0x94EC, 0x80A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x94ED, 0x88AB }, // CJK UNIFIED IDEOGRAPH
    { 0x94EE, 0x8AB9 }, // CJK UNIFIED IDEOGRAPH
    { 0x94EF, 0x8CBB }, // CJK UNIFIED IDEOGRAPH
    { 0x94F0, 0x907F }, // CJK UNIFIED IDEOGRAPH
    { 0x94F1, 0x975E }, // CJK UNIFIED IDEOGRAPH
    { 0x94F2, 0x98DB }, // CJK UNIFIED IDEOGRAPH
    { 0x94F3, 0x6A0B }, // CJK UNIFIED IDEOGRAPH
    { 0x94F4, 0x7C38 }, // CJK UNIFIED IDEOGRAPH
    { 0x94F5, 0x5099 }, // CJK UNIFIED IDEOGRAPH
    { 0x94F6, 0x5C3E }, // CJK UNIFIED IDEOGRAPH
    { 0x94F7, 0x5FAE }, // CJK UNIFIED IDEOGRAPH
    { 0x94F8, 0x6787 }, // CJK UNIFIED IDEOGRAPH
    { 0x94F9, 0x6BD8 }, // CJK UNIFIED IDEOGRAPH
    { 0x94FA, 0x7435 }, // CJK UNIFIED IDEOGRAPH
    { 0x94FB, 0x7709 }, // CJK UNIFIED IDEOGRAPH
    { 0x94FC, 0x7F8E }, // CJK UNIFIED IDEOGRAPH
    { 0x9540, 0x9F3B }, // CJK UNIFIED IDEOGRAPH
    { 0x9541, 0x67CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9542, 0x7A17 }, // CJK UNIFIED IDEOGRAPH
    { 0x9543, 0x5339 }, // CJK UNIFIED IDEOGRAPH
    { 0x9544, 0x758B }, // CJK UNIFIED IDEOGRAPH
    { 0x9545, 0x9AED }, // CJK UNIFIED IDEOGRAPH
    { 0x9546, 0x5F66 }, // CJK UNIFIED IDEOGRAPH
    { 0x9547, 0x819D }, // CJK UNIFIED IDEOGRAPH
    { 0x9548, 0x83F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9549, 0x8098 }, // CJK UNIFIED IDEOGRAPH
    { 0x954A, 0x5F3C }, // CJK UNIFIED IDEOGRAPH
    { 0x954B, 0x5FC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x954C, 0x7562 }, // CJK UNIFIED IDEOGRAPH
    { 0x954D, 0x7B46 }, // CJK UNIFIED IDEOGRAPH
    { 0x954E, 0x903C }, // CJK UNIFIED IDEOGRAPH
    { 0x954F, 0x6867 }, // CJK UNIFIED IDEOGRAPH
    { 0x9550, 0x59EB }, // CJK UNIFIED IDEOGRAPH
    { 0x9551, 0x5A9B }, // CJK UNIFIED IDEOGRAPH
    { 0x9552, 0x7D10 }, // CJK UNIFIED IDEOGRAPH
    { 0x9553, 0x767E }, // CJK UNIFIED IDEOGRAPH
    { 0x9554, 0x8B2C }, // CJK UNIFIED IDEOGRAPH
    { 0x9555, 0x4FF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9556, 0x5F6A }, // CJK UNIFIED IDEOGRAPH
    { 0x9557, 0x6A19 }, // CJK UNIFIED IDEOGRAPH
    { 0x9558, 0x6C37 }, // CJK UNIFIED IDEOGRAPH
    { 0x9559, 0x6F02 }, // CJK UNIFIED IDEOGRAPH
    { 0x955A, 0x74E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x955B, 0x7968 }, // CJK UNIFIED IDEOGRAPH
    { 0x955C, 0x8868 }, // CJK UNIFIED IDEOGRAPH
    { 0x955D, 0x8A55 }, // CJK UNIFIED IDEOGRAPH
    { 0x955E, 0x8C79 }, // CJK UNIFIED IDEOGRAPH
    { 0x955F, 0x5EDF }, // CJK UNIFIED IDEOGRAPH
    { 0x9560, 0x63CF }, // CJK UNIFIED IDEOGRAPH
    { 0x9561, 0x75C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9562, 0x79D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9563, 0x82D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9564, 0x9328 }, // CJK UNIFIED IDEOGRAPH
    { 0x9565, 0x92F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9566, 0x849C }, // CJK UNIFIED IDEOGRAPH
    { 0x9567, 0x86ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9568, 0x9C2D }, // CJK UNIFIED IDEOGRAPH
    { 0x9569, 0x54C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x956A, 0x5F6C }, // CJK UNIFIED IDEOGRAPH
    { 0x956B, 0x658C }, // CJK UNIFIED IDEOGRAPH
    { 0x956C, 0x6D5C }, // CJK UNIFIED IDEOGRAPH
    { 0x956D, 0x7015 }, // CJK UNIFIED IDEOGRAPH
    { 0x956E, 0x8CA7 }, // CJK UNIFIED IDEOGRAPH
    { 0x956F, 0x8CD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9570, 0x983B }, // CJK UNIFIED IDEOGRAPH
    { 0x9571, 0x654F }, // CJK UNIFIED IDEOGRAPH
    { 0x9572, 0x74F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9573, 0x4E0D }, // CJK UNIFIED IDEOGRAPH
    { 0x9574, 0x4ED8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9575, 0x57E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9576, 0x592B }, // CJK UNIFIED IDEOGRAPH
    { 0x9577, 0x5A66 }, // CJK UNIFIED IDEOGRAPH
    { 0x9578, 0x5BCC }, // CJK UNIFIED IDEOGRAPH
    { 0x9579, 0x51A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x957A, 0x5E03 }, // CJK UNIFIED IDEOGRAPH
    { 0x957B, 0x5E9C }, // CJK UNIFIED IDEOGRAPH
    { 0x957C, 0x6016 }, // CJK UNIFIED IDEOGRAPH
    { 0x957D, 0x6276 }, // CJK UNIFIED IDEOGRAPH
    { 0x957E, 0x6577 }, // CJK UNIFIED IDEOGRAPH
    { 0x9580, 0x65A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9581, 0x666E }, // CJK UNIFIED IDEOGRAPH
    { 0x9582, 0x6D6E }, // CJK UNIFIED IDEOGRAPH
    { 0x9583, 0x7236 }, // CJK UNIFIED IDEOGRAPH
    { 0x9584, 0x7B26 }, // CJK UNIFIED IDEOGRAPH
    { 0x9585, 0x8150 }, // CJK UNIFIED IDEOGRAPH
    { 0x9586, 0x819A }, // CJK UNIFIED IDEOGRAPH
    { 0x9587, 0x8299 }, // CJK UNIFIED IDEOGRAPH
    { 0x9588, 0x8B5C }, // CJK UNIFIED IDEOGRAPH
    { 0x9589, 0x8CA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x958A, 0x8CE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x958B, 0x8D74 }, // CJK UNIFIED IDEOGRAPH
    { 0x958C, 0x961C }, // CJK UNIFIED IDEOGRAPH
    { 0x958D, 0x9644 }, // CJK UNIFIED IDEOGRAPH
    { 0x958E, 0x4FAE }, // CJK UNIFIED IDEOGRAPH
    { 0x958F, 0x64AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9590, 0x6B66 }, // CJK UNIFIED IDEOGRAPH
    { 0x9591, 0x821E }, // CJK UNIFIED IDEOGRAPH
    { 0x9592, 0x8461 }, // CJK UNIFIED IDEOGRAPH
    { 0x9593, 0x856A }, // CJK UNIFIED IDEOGRAPH
    { 0x9594, 0x90E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9595, 0x5C01 }, // CJK UNIFIED IDEOGRAPH
    { 0x9596, 0x6953 }, // CJK UNIFIED IDEOGRAPH
    { 0x9597, 0x98A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9598, 0x847A }, // CJK UNIFIED IDEOGRAPH
    { 0x9599, 0x8557 }, // CJK UNIFIED IDEOGRAPH
    { 0x959A, 0x4F0F }, // CJK UNIFIED IDEOGRAPH
    { 0x959B, 0x526F }, // CJK UNIFIED IDEOGRAPH
    { 0x959C, 0x5FA9 }, // CJK UNIFIED IDEOGRAPH
    { 0x959D, 0x5E45 }, // CJK UNIFIED IDEOGRAPH
    { 0x959E, 0x670D }, // CJK UNIFIED IDEOGRAPH
    { 0x959F, 0x798F }, // CJK UNIFIED IDEOGRAPH
    { 0x95A0, 0x8179 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A1, 0x8907 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A2, 0x8986 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A3, 0x6DF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A4, 0x5F17 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A5, 0x6255 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A6, 0x6CB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A7, 0x4ECF }, // CJK UNIFIED IDEOGRAPH
    { 0x95A8, 0x7269 }, // CJK UNIFIED IDEOGRAPH
    { 0x95A9, 0x9B92 }, // CJK UNIFIED IDEOGRAPH
    { 0x95AA, 0x5206 }, // CJK UNIFIED IDEOGRAPH
    { 0x95AB, 0x543B }, // CJK UNIFIED IDEOGRAPH
    { 0x95AC, 0x5674 }, // CJK UNIFIED IDEOGRAPH
    { 0x95AD, 0x58B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x95AE, 0x61A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x95AF, 0x626E }, // CJK UNIFIED IDEOGRAPH
    { 0x95B0, 0x711A }, // CJK UNIFIED IDEOGRAPH
    { 0x95B1, 0x596E }, // CJK UNIFIED IDEOGRAPH
    { 0x95B2, 0x7C89 }, // CJK UNIFIED IDEOGRAPH
    { 0x95B3, 0x7CDE }, // CJK UNIFIED IDEOGRAPH
    { 0x95B4, 0x7D1B }, // CJK UNIFIED IDEOGRAPH
    { 0x95B5, 0x96F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x95B6, 0x6587 }, // CJK UNIFIED IDEOGRAPH
    { 0x95B7, 0x805E }, // CJK UNIFIED IDEOGRAPH
    { 0x95B8, 0x4E19 }, // CJK UNIFIED IDEOGRAPH
    { 0x95B9, 0x4F75 }, // CJK UNIFIED IDEOGRAPH
    { 0x95BA, 0x5175 }, // CJK UNIFIED IDEOGRAPH
    { 0x95BB, 0x5840 }, // CJK UNIFIED IDEOGRAPH
    { 0x95BC, 0x5E63 }, // CJK UNIFIED IDEOGRAPH
    { 0x95BD, 0x5E73 }, // CJK UNIFIED IDEOGRAPH
    { 0x95BE, 0x5F0A }, // CJK UNIFIED IDEOGRAPH
    { 0x95BF, 0x67C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C0, 0x4E26 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C1, 0x853D }, // CJK UNIFIED IDEOGRAPH
    { 0x95C2, 0x9589 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C3, 0x965B }, // CJK UNIFIED IDEOGRAPH
    { 0x95C4, 0x7C73 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C5, 0x9801 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C6, 0x50FB }, // CJK UNIFIED IDEOGRAPH
    { 0x95C7, 0x58C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C8, 0x7656 }, // CJK UNIFIED IDEOGRAPH
    { 0x95C9, 0x78A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x95CA, 0x5225 }, // CJK UNIFIED IDEOGRAPH
    { 0x95CB, 0x77A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x95CC, 0x8511 }, // CJK UNIFIED IDEOGRAPH
    { 0x95CD, 0x7B86 }, // CJK UNIFIED IDEOGRAPH
    { 0x95CE, 0x504F }, // CJK UNIFIED IDEOGRAPH
    { 0x95CF, 0x5909 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D0, 0x7247 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D1, 0x7BC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D2, 0x7DE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D3, 0x8FBA }, // CJK UNIFIED IDEOGRAPH
    { 0x95D4, 0x8FD4 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D5, 0x904D }, // CJK UNIFIED IDEOGRAPH
    { 0x95D6, 0x4FBF }, // CJK UNIFIED IDEOGRAPH
    { 0x95D7, 0x52C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D8, 0x5A29 }, // CJK UNIFIED IDEOGRAPH
    { 0x95D9, 0x5F01 }, // CJK UNIFIED IDEOGRAPH
    { 0x95DA, 0x97AD }, // CJK UNIFIED IDEOGRAPH
    { 0x95DB, 0x4FDD }, // CJK UNIFIED IDEOGRAPH
    { 0x95DC, 0x8217 }, // CJK UNIFIED IDEOGRAPH
    { 0x95DD, 0x92EA }, // CJK UNIFIED IDEOGRAPH
    { 0x95DE, 0x5703 }, // CJK UNIFIED IDEOGRAPH
    { 0x95DF, 0x6355 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E0, 0x6B69 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E1, 0x752B }, // CJK UNIFIED IDEOGRAPH
    { 0x95E2, 0x88DC }, // CJK UNIFIED IDEOGRAPH
    { 0x95E3, 0x8F14 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E4, 0x7A42 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E5, 0x52DF }, // CJK UNIFIED IDEOGRAPH
    { 0x95E6, 0x5893 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E7, 0x6155 }, // CJK UNIFIED IDEOGRAPH
    { 0x95E8, 0x620A }, // CJK UNIFIED IDEOGRAPH
    { 0x95E9, 0x66AE }, // CJK UNIFIED IDEOGRAPH
    { 0x95EA, 0x6BCD }, // CJK UNIFIED IDEOGRAPH
    { 0x95EB, 0x7C3F }, // CJK UNIFIED IDEOGRAPH
    { 0x95EC, 0x83E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x95ED, 0x5023 }, // CJK UNIFIED IDEOGRAPH
    { 0x95EE, 0x4FF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x95EF, 0x5305 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F0, 0x5446 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F1, 0x5831 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F2, 0x5949 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F3, 0x5B9D }, // CJK UNIFIED IDEOGRAPH
    { 0x95F4, 0x5CF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F5, 0x5CEF }, // CJK UNIFIED IDEOGRAPH
    { 0x95F6, 0x5D29 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F7, 0x5E96 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F8, 0x62B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x95F9, 0x6367 }, // CJK UNIFIED IDEOGRAPH
    { 0x95FA, 0x653E }, // CJK UNIFIED IDEOGRAPH
    { 0x95FB, 0x65B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x95FC, 0x670B }, // CJK UNIFIED IDEOGRAPH
    { 0x9640, 0x6CD5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9641, 0x6CE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9642, 0x70F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9643, 0x7832 }, // CJK UNIFIED IDEOGRAPH
    { 0x9644, 0x7E2B }, // CJK UNIFIED IDEOGRAPH
    { 0x9645, 0x80DE }, // CJK UNIFIED IDEOGRAPH
    { 0x9646, 0x82B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9647, 0x840C }, // CJK UNIFIED IDEOGRAPH
    { 0x9648, 0x84EC }, // CJK UNIFIED IDEOGRAPH
    { 0x9649, 0x8702 }, // CJK UNIFIED IDEOGRAPH
    { 0x964A, 0x8912 }, // CJK UNIFIED IDEOGRAPH
    { 0x964B, 0x8A2A }, // CJK UNIFIED IDEOGRAPH
    { 0x964C, 0x8C4A }, // CJK UNIFIED IDEOGRAPH
    { 0x964D, 0x90A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x964E, 0x92D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x964F, 0x98FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9650, 0x9CF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9651, 0x9D6C }, // CJK UNIFIED IDEOGRAPH
    { 0x9652, 0x4E4F }, // CJK UNIFIED IDEOGRAPH
    { 0x9653, 0x4EA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9654, 0x508D }, // CJK UNIFIED IDEOGRAPH
    { 0x9655, 0x5256 }, // CJK UNIFIED IDEOGRAPH
    { 0x9656, 0x574A }, // CJK UNIFIED IDEOGRAPH
    { 0x9657, 0x59A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9658, 0x5E3D }, // CJK UNIFIED IDEOGRAPH
    { 0x9659, 0x5FD8 }, // CJK UNIFIED IDEOGRAPH
    { 0x965A, 0x5FD9 }, // CJK UNIFIED IDEOGRAPH
    { 0x965B, 0x623F }, // CJK UNIFIED IDEOGRAPH
    { 0x965C, 0x66B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x965D, 0x671B }, // CJK UNIFIED IDEOGRAPH
    { 0x965E, 0x67D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x965F, 0x68D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9660, 0x5192 }, // CJK UNIFIED IDEOGRAPH
    { 0x9661, 0x7D21 }, // CJK UNIFIED IDEOGRAPH
    { 0x9662, 0x80AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9663, 0x81A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9664, 0x8B00 }, // CJK UNIFIED IDEOGRAPH
    { 0x9665, 0x8C8C }, // CJK UNIFIED IDEOGRAPH
    { 0x9666, 0x8CBF }, // CJK UNIFIED IDEOGRAPH
    { 0x9667, 0x927E }, // CJK UNIFIED IDEOGRAPH
    { 0x9668, 0x9632 }, // CJK UNIFIED IDEOGRAPH
    { 0x9669, 0x5420 }, // CJK UNIFIED IDEOGRAPH
    { 0x966A, 0x982C }, // CJK UNIFIED IDEOGRAPH
    { 0x966B, 0x5317 }, // CJK UNIFIED IDEOGRAPH
    { 0x966C, 0x50D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x966D, 0x535C }, // CJK UNIFIED IDEOGRAPH
    { 0x966E, 0x58A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x966F, 0x64B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9670, 0x6734 }, // CJK UNIFIED IDEOGRAPH
    { 0x9671, 0x7267 }, // CJK UNIFIED IDEOGRAPH
    { 0x9672, 0x7766 }, // CJK UNIFIED IDEOGRAPH
    { 0x9673, 0x7A46 }, // CJK UNIFIED IDEOGRAPH
    { 0x9674, 0x91E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9675, 0x52C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9676, 0x6CA1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9677, 0x6B86 }, // CJK UNIFIED IDEOGRAPH
    { 0x9678, 0x5800 }, // CJK UNIFIED IDEOGRAPH
    { 0x9679, 0x5E4C }, // CJK UNIFIED IDEOGRAPH
    { 0x967A, 0x5954 }, // CJK UNIFIED IDEOGRAPH
    { 0x967B, 0x672C }, // CJK UNIFIED IDEOGRAPH
    { 0x967C, 0x7FFB }, // CJK UNIFIED IDEOGRAPH
    { 0x967D, 0x51E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x967E, 0x76C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9680, 0x6469 }, // CJK UNIFIED IDEOGRAPH
    { 0x9681, 0x78E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9682, 0x9B54 }, // CJK UNIFIED IDEOGRAPH
    { 0x9683, 0x9EBB }, // CJK UNIFIED IDEOGRAPH
    { 0x9684, 0x57CB }, // CJK UNIFIED IDEOGRAPH
    { 0x9685, 0x59B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9686, 0x6627 }, // CJK UNIFIED IDEOGRAPH
    { 0x9687, 0x679A }, // CJK UNIFIED IDEOGRAPH
    { 0x9688, 0x6BCE }, // CJK UNIFIED IDEOGRAPH
    { 0x9689, 0x54E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x968A, 0x69D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x968B, 0x5E55 }, // CJK UNIFIED IDEOGRAPH
    { 0x968C, 0x819C }, // CJK UNIFIED IDEOGRAPH
    { 0x968D, 0x6795 }, // CJK UNIFIED IDEOGRAPH
    { 0x968E, 0x9BAA }, // CJK UNIFIED IDEOGRAPH
    { 0x968F, 0x67FE }, // CJK UNIFIED IDEOGRAPH
    { 0x9690, 0x9C52 }, // CJK UNIFIED IDEOGRAPH
    { 0x9691, 0x685D }, // CJK UNIFIED IDEOGRAPH
    { 0x9692, 0x4EA6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9693, 0x4FE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9694, 0x53C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9695, 0x62B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9696, 0x672B }, // CJK UNIFIED IDEOGRAPH
    { 0x9697, 0x6CAB }, // CJK UNIFIED IDEOGRAPH
    { 0x9698, 0x8FC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9699, 0x4FAD }, // CJK UNIFIED IDEOGRAPH
    { 0x969A, 0x7E6D }, // CJK UNIFIED IDEOGRAPH
    { 0x969B, 0x9EBF }, // CJK UNIFIED IDEOGRAPH
    { 0x969C, 0x4E07 }, // CJK UNIFIED IDEOGRAPH
    { 0x969D, 0x6162 }, // CJK UNIFIED IDEOGRAPH
    { 0x969E, 0x6E80 }, // CJK UNIFIED IDEOGRAPH
    { 0x969F, 0x6F2B }, // CJK UNIFIED IDEOGRAPH
    { 0x96A0, 0x8513 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A1, 0x5473 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A2, 0x672A }, // CJK UNIFIED IDEOGRAPH
    { 0x96A3, 0x9B45 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A4, 0x5DF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A5, 0x7B95 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A6, 0x5CAC }, // CJK UNIFIED IDEOGRAPH
    { 0x96A7, 0x5BC6 }, // CJK UNIFIED IDEOGRAPH
    { 0x96A8, 0x871C }, // CJK UNIFIED IDEOGRAPH
    { 0x96A9, 0x6E4A }, // CJK UNIFIED IDEOGRAPH
    { 0x96AA, 0x84D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x96AB, 0x7A14 }, // CJK UNIFIED IDEOGRAPH
    { 0x96AC, 0x8108 }, // CJK UNIFIED IDEOGRAPH
    { 0x96AD, 0x5999 }, // CJK UNIFIED IDEOGRAPH
    { 0x96AE, 0x7C8D }, // CJK UNIFIED IDEOGRAPH
    { 0x96AF, 0x6C11 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B0, 0x7720 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B1, 0x52D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B2, 0x5922 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B3, 0x7121 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B4, 0x725F }, // CJK UNIFIED IDEOGRAPH
    { 0x96B5, 0x77DB }, // CJK UNIFIED IDEOGRAPH
    { 0x96B6, 0x9727 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B7, 0x9D61 }, // CJK UNIFIED IDEOGRAPH
    { 0x96B8, 0x690B }, // CJK UNIFIED IDEOGRAPH
    { 0x96B9, 0x5A7F }, // CJK UNIFIED IDEOGRAPH
    { 0x96BA, 0x5A18 }, // CJK UNIFIED IDEOGRAPH
    { 0x96BB, 0x51A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x96BC, 0x540D }, // CJK UNIFIED IDEOGRAPH
    { 0x96BD, 0x547D }, // CJK UNIFIED IDEOGRAPH
    { 0x96BE, 0x660E }, // CJK UNIFIED IDEOGRAPH
    { 0x96BF, 0x76DF }, // CJK UNIFIED IDEOGRAPH
    { 0x96C0, 0x8FF7 }, // CJK UNIFIED IDEOGRAPH
    { 0x96C1, 0x9298 }, // CJK UNIFIED IDEOGRAPH
    { 0x96C2, 0x9CF4 }, // CJK UNIFIED IDEOGRAPH
    { 0x96C3, 0x59EA }, // CJK UNIFIED IDEOGRAPH
    { 0x96C4, 0x725D }, // CJK UNIFIED IDEOGRAPH
    { 0x96C5, 0x6EC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x96C6, 0x514D }, // CJK UNIFIED IDEOGRAPH
    { 0x96C7, 0x68C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x96C8, 0x7DBF }, // CJK UNIFIED IDEOGRAPH
    { 0x96C9, 0x7DEC }, // CJK UNIFIED IDEOGRAPH
    { 0x96CA, 0x9762 }, // CJK UNIFIED IDEOGRAPH
    { 0x96CB, 0x9EBA }, // CJK UNIFIED IDEOGRAPH
    { 0x96CC, 0x6478 }, // CJK UNIFIED IDEOGRAPH
    { 0x96CD, 0x6A21 }, // CJK UNIFIED IDEOGRAPH
    { 0x96CE, 0x8302 }, // CJK UNIFIED IDEOGRAPH
    { 0x96CF, 0x5984 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D0, 0x5B5F }, // CJK UNIFIED IDEOGRAPH
    { 0x96D1, 0x6BDB }, // CJK UNIFIED IDEOGRAPH
    { 0x96D2, 0x731B }, // CJK UNIFIED IDEOGRAPH
    { 0x96D3, 0x76F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D4, 0x7DB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D5, 0x8017 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D6, 0x8499 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D7, 0x5132 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D8, 0x6728 }, // CJK UNIFIED IDEOGRAPH
    { 0x96D9, 0x9ED9 }, // CJK UNIFIED IDEOGRAPH
    { 0x96DA, 0x76EE }, // CJK UNIFIED IDEOGRAPH
    { 0x96DB, 0x6762 }, // CJK UNIFIED IDEOGRAPH
    { 0x96DC, 0x52FF }, // CJK UNIFIED IDEOGRAPH
    { 0x96DD, 0x9905 }, // CJK UNIFIED IDEOGRAPH
    { 0x96DE, 0x5C24 }, // CJK UNIFIED IDEOGRAPH
    { 0x96DF, 0x623B }, // CJK UNIFIED IDEOGRAPH
    { 0x96E0, 0x7C7E }, // CJK UNIFIED IDEOGRAPH
    { 0x96E1, 0x8CB0 }, // CJK UNIFIED IDEOGRAPH
    { 0x96E2, 0x554F }, // CJK UNIFIED IDEOGRAPH
    { 0x96E3, 0x60B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x96E4, 0x7D0B }, // CJK UNIFIED IDEOGRAPH
    { 0x96E5, 0x9580 }, // CJK UNIFIED IDEOGRAPH
    { 0x96E6, 0x5301 }, // CJK UNIFIED IDEOGRAPH
    { 0x96E7, 0x4E5F }, // CJK UNIFIED IDEOGRAPH
    { 0x96E8, 0x51B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x96E9, 0x591C }, // CJK UNIFIED IDEOGRAPH
    { 0x96EA, 0x723A }, // CJK UNIFIED IDEOGRAPH
    { 0x96EB, 0x8036 }, // CJK UNIFIED IDEOGRAPH
    { 0x96EC, 0x91CE }, // CJK UNIFIED IDEOGRAPH
    { 0x96ED, 0x5F25 }, // CJK UNIFIED IDEOGRAPH
    { 0x96EE, 0x77E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x96EF, 0x5384 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F0, 0x5F79 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F1, 0x7D04 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F2, 0x85AC }, // CJK UNIFIED IDEOGRAPH
    { 0x96F3, 0x8A33 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F4, 0x8E8D }, // CJK UNIFIED IDEOGRAPH
    { 0x96F5, 0x9756 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F6, 0x67F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F7, 0x85AE }, // CJK UNIFIED IDEOGRAPH
    { 0x96F8, 0x9453 }, // CJK UNIFIED IDEOGRAPH
    { 0x96F9, 0x6109 }, // CJK UNIFIED IDEOGRAPH
    { 0x96FA, 0x6108 }, // CJK UNIFIED IDEOGRAPH
    { 0x96FB, 0x6CB9 }, // CJK UNIFIED IDEOGRAPH
    { 0x96FC, 0x7652 }, // CJK UNIFIED IDEOGRAPH
    { 0x9740, 0x8AED }, // CJK UNIFIED IDEOGRAPH
    { 0x9741, 0x8F38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9742, 0x552F }, // CJK UNIFIED IDEOGRAPH
    { 0x9743, 0x4F51 }, // CJK UNIFIED IDEOGRAPH
    { 0x9744, 0x512A }, // CJK UNIFIED IDEOGRAPH
    { 0x9745, 0x52C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9746, 0x53CB }, // CJK UNIFIED IDEOGRAPH
    { 0x9747, 0x5BA5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9748, 0x5E7D }, // CJK UNIFIED IDEOGRAPH
    { 0x9749, 0x60A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x974A, 0x6182 }, // CJK UNIFIED IDEOGRAPH
    { 0x974B, 0x63D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x974C, 0x6709 }, // CJK UNIFIED IDEOGRAPH
    { 0x974D, 0x67DA }, // CJK UNIFIED IDEOGRAPH
    { 0x974E, 0x6E67 }, // CJK UNIFIED IDEOGRAPH
    { 0x974F, 0x6D8C }, // CJK UNIFIED IDEOGRAPH
    { 0x9750, 0x7336 }, // CJK UNIFIED IDEOGRAPH
    { 0x9751, 0x7337 }, // CJK UNIFIED IDEOGRAPH
    { 0x9752, 0x7531 }, // CJK UNIFIED IDEOGRAPH
    { 0x9753, 0x7950 }, // CJK UNIFIED IDEOGRAPH
    { 0x9754, 0x88D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9755, 0x8A98 }, // CJK UNIFIED IDEOGRAPH
    { 0x9756, 0x904A }, // CJK UNIFIED IDEOGRAPH
    { 0x9757, 0x9091 }, // CJK UNIFIED IDEOGRAPH
    { 0x9758, 0x90F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9759, 0x96C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x975A, 0x878D }, // CJK UNIFIED IDEOGRAPH
    { 0x975B, 0x5915 }, // CJK UNIFIED IDEOGRAPH
    { 0x975C, 0x4E88 }, // CJK UNIFIED IDEOGRAPH
    { 0x975D, 0x4F59 }, // CJK UNIFIED IDEOGRAPH
    { 0x975E, 0x4E0E }, // CJK UNIFIED IDEOGRAPH
    { 0x975F, 0x8A89 }, // CJK UNIFIED IDEOGRAPH
    { 0x9760, 0x8F3F }, // CJK UNIFIED IDEOGRAPH
    { 0x9761, 0x9810 }, // CJK UNIFIED IDEOGRAPH
    { 0x9762, 0x50AD }, // CJK UNIFIED IDEOGRAPH
    { 0x9763, 0x5E7C }, // CJK UNIFIED IDEOGRAPH
    { 0x9764, 0x5996 }, // CJK UNIFIED IDEOGRAPH
    { 0x9765, 0x5BB9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9766, 0x5EB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9767, 0x63DA }, // CJK UNIFIED IDEOGRAPH
    { 0x9768, 0x63FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9769, 0x64C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x976A, 0x66DC }, // CJK UNIFIED IDEOGRAPH
    { 0x976B, 0x694A }, // CJK UNIFIED IDEOGRAPH
    { 0x976C, 0x69D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x976D, 0x6D0B }, // CJK UNIFIED IDEOGRAPH
    { 0x976E, 0x6EB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x976F, 0x7194 }, // CJK UNIFIED IDEOGRAPH
    { 0x9770, 0x7528 }, // CJK UNIFIED IDEOGRAPH
    { 0x9771, 0x7AAF }, // CJK UNIFIED IDEOGRAPH
    { 0x9772, 0x7F8A }, // CJK UNIFIED IDEOGRAPH
    { 0x9773, 0x8000 }, // CJK UNIFIED IDEOGRAPH
    { 0x9774, 0x8449 }, // CJK UNIFIED IDEOGRAPH
    { 0x9775, 0x84C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9776, 0x8981 }, // CJK UNIFIED IDEOGRAPH
    { 0x9777, 0x8B21 }, // CJK UNIFIED IDEOGRAPH
    { 0x9778, 0x8E0A }, // CJK UNIFIED IDEOGRAPH
    { 0x9779, 0x9065 }, // CJK UNIFIED IDEOGRAPH
    { 0x977A, 0x967D }, // CJK UNIFIED IDEOGRAPH
    { 0x977B, 0x990A }, // CJK UNIFIED IDEOGRAPH
    { 0x977C, 0x617E }, // CJK UNIFIED IDEOGRAPH
    { 0x977D, 0x6291 }, // CJK UNIFIED IDEOGRAPH
    { 0x977E, 0x6B32 }, // CJK UNIFIED IDEOGRAPH
    { 0x9780, 0x6C83 }, // CJK UNIFIED IDEOGRAPH
    { 0x9781, 0x6D74 }, // CJK UNIFIED IDEOGRAPH
    { 0x9782, 0x7FCC }, // CJK UNIFIED IDEOGRAPH
    { 0x9783, 0x7FFC }, // CJK UNIFIED IDEOGRAPH
    { 0x9784, 0x6DC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9785, 0x7F85 }, // CJK UNIFIED IDEOGRAPH
    { 0x9786, 0x87BA }, // CJK UNIFIED IDEOGRAPH
    { 0x9787, 0x88F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9788, 0x6765 }, // CJK UNIFIED IDEOGRAPH
    { 0x9789, 0x83B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x978A, 0x983C }, // CJK UNIFIED IDEOGRAPH
    { 0x978B, 0x96F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x978C, 0x6D1B }, // CJK UNIFIED IDEOGRAPH
    { 0x978D, 0x7D61 }, // CJK UNIFIED IDEOGRAPH
    { 0x978E, 0x843D }, // CJK UNIFIED IDEOGRAPH
    { 0x978F, 0x916A }, // CJK UNIFIED IDEOGRAPH
    { 0x9790, 0x4E71 }, // CJK UNIFIED IDEOGRAPH
    { 0x9791, 0x5375 }, // CJK UNIFIED IDEOGRAPH
    { 0x9792, 0x5D50 }, // CJK UNIFIED IDEOGRAPH
    { 0x9793, 0x6B04 }, // CJK UNIFIED IDEOGRAPH
    { 0x9794, 0x6FEB }, // CJK UNIFIED IDEOGRAPH
    { 0x9795, 0x85CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9796, 0x862D }, // CJK UNIFIED IDEOGRAPH
    { 0x9797, 0x89A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9798, 0x5229 }, // CJK UNIFIED IDEOGRAPH
    { 0x9799, 0x540F }, // CJK UNIFIED IDEOGRAPH
    { 0x979A, 0x5C65 }, // CJK UNIFIED IDEOGRAPH
    { 0x979B, 0x674E }, // CJK UNIFIED IDEOGRAPH
    { 0x979C, 0x68A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x979D, 0x7406 }, // CJK UNIFIED IDEOGRAPH
    { 0x979E, 0x7483 }, // CJK UNIFIED IDEOGRAPH
    { 0x979F, 0x75E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x97A0, 0x88CF }, // CJK UNIFIED IDEOGRAPH
    { 0x97A1, 0x88E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x97A2, 0x91CC }, // CJK UNIFIED IDEOGRAPH
    { 0x97A3, 0x96E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x97A4, 0x9678 }, // CJK UNIFIED IDEOGRAPH
    { 0x97A5, 0x5F8B }, // CJK UNIFIED IDEOGRAPH
    { 0x97A6, 0x7387 }, // CJK UNIFIED IDEOGRAPH
    { 0x97A7, 0x7ACB }, // CJK UNIFIED IDEOGRAPH
    { 0x97A8, 0x844E }, // CJK UNIFIED IDEOGRAPH
    { 0x97A9, 0x63A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x97AA, 0x7565 }, // CJK UNIFIED IDEOGRAPH
    { 0x97AB, 0x5289 }, // CJK UNIFIED IDEOGRAPH
    { 0x97AC, 0x6D41 }, // CJK UNIFIED IDEOGRAPH
    { 0x97AD, 0x6E9C }, // CJK UNIFIED IDEOGRAPH
    { 0x97AE, 0x7409 }, // CJK UNIFIED IDEOGRAPH
    { 0x97AF, 0x7559 }, // CJK UNIFIED IDEOGRAPH
    { 0x97B0, 0x786B }, // CJK UNIFIED IDEOGRAPH
    { 0x97B1, 0x7C92 }, // CJK UNIFIED IDEOGRAPH
    { 0x97B2, 0x9686 }, // CJK UNIFIED IDEOGRAPH
    { 0x97B3, 0x7ADC }, // CJK UNIFIED IDEOGRAPH
    { 0x97B4, 0x9F8D }, // CJK UNIFIED IDEOGRAPH
    { 0x97B5, 0x4FB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x97B6, 0x616E }, // CJK UNIFIED IDEOGRAPH
    { 0x97B7, 0x65C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x97B8, 0x865C }, // CJK UNIFIED IDEOGRAPH
    { 0x97B9, 0x4E86 }, // CJK UNIFIED IDEOGRAPH
    { 0x97BA, 0x4EAE }, // CJK UNIFIED IDEOGRAPH
    { 0x97BB, 0x50DA }, // CJK UNIFIED IDEOGRAPH
    { 0x97BC, 0x4E21 }, // CJK UNIFIED IDEOGRAPH
    { 0x97BD, 0x51CC }, // CJK UNIFIED IDEOGRAPH
    { 0x97BE, 0x5BEE }, // CJK UNIFIED IDEOGRAPH
    { 0x97BF, 0x6599 }, // CJK UNIFIED IDEOGRAPH
    { 0x97C0, 0x6881 }, // CJK UNIFIED IDEOGRAPH
    { 0x97C1, 0x6DBC }, // CJK UNIFIED IDEOGRAPH
    { 0x97C2, 0x731F }, // CJK UNIFIED IDEOGRAPH
    { 0x97C3, 0x7642 }, // CJK UNIFIED IDEOGRAPH
    { 0x97C4, 0x77AD }, // CJK UNIFIED IDEOGRAPH
    { 0x97C5, 0x7A1C }, // CJK UNIFIED IDEOGRAPH
    { 0x97C6, 0x7CE7 }, // CJK UNIFIED IDEOGRAPH
    { 0x97C7, 0x826F }, // CJK UNIFIED IDEOGRAPH
    { 0x97C8, 0x8AD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x97C9, 0x907C }, // CJK UNIFIED IDEOGRAPH
    { 0x97CA, 0x91CF }, // CJK UNIFIED IDEOGRAPH
    { 0x97CB, 0x9675 }, // CJK UNIFIED IDEOGRAPH
    { 0x97CC, 0x9818 }, // CJK UNIFIED IDEOGRAPH
    { 0x97CD, 0x529B }, // CJK UNIFIED IDEOGRAPH
    { 0x97CE, 0x7DD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x97CF, 0x502B }, // CJK UNIFIED IDEOGRAPH
    { 0x97D0, 0x5398 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D1, 0x6797 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D2, 0x6DCB }, // CJK UNIFIED IDEOGRAPH
    { 0x97D3, 0x71D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D4, 0x7433 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D5, 0x81E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D6, 0x8F2A }, // CJK UNIFIED IDEOGRAPH
    { 0x97D7, 0x96A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D8, 0x9C57 }, // CJK UNIFIED IDEOGRAPH
    { 0x97D9, 0x9E9F }, // CJK UNIFIED IDEOGRAPH
    { 0x97DA, 0x7460 }, // CJK UNIFIED IDEOGRAPH
    { 0x97DB, 0x5841 }, // CJK UNIFIED IDEOGRAPH
    { 0x97DC, 0x6D99 }, // CJK UNIFIED IDEOGRAPH
    { 0x97DD, 0x7D2F }, // CJK UNIFIED IDEOGRAPH
    { 0x97DE, 0x985E }, // CJK UNIFIED IDEOGRAPH
    { 0x97DF, 0x4EE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E0, 0x4F36 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E1, 0x4F8B }, // CJK UNIFIED IDEOGRAPH
    { 0x97E2, 0x51B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E3, 0x52B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E4, 0x5DBA }, // CJK UNIFIED IDEOGRAPH
    { 0x97E5, 0x601C }, // CJK UNIFIED IDEOGRAPH
    { 0x97E6, 0x73B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E7, 0x793C }, // CJK UNIFIED IDEOGRAPH
    { 0x97E8, 0x82D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x97E9, 0x9234 }, // CJK UNIFIED IDEOGRAPH
    { 0x97EA, 0x96B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x97EB, 0x96F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x97EC, 0x970A }, // CJK UNIFIED IDEOGRAPH
    { 0x97ED, 0x9E97 }, // CJK UNIFIED IDEOGRAPH
    { 0x97EE, 0x9F62 }, // CJK UNIFIED IDEOGRAPH
    { 0x97EF, 0x66A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F0, 0x6B74 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F1, 0x5217 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F2, 0x52A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F3, 0x70C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F4, 0x88C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F5, 0x5EC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F6, 0x604B }, // CJK UNIFIED IDEOGRAPH
    { 0x97F7, 0x6190 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F8, 0x6F23 }, // CJK UNIFIED IDEOGRAPH
    { 0x97F9, 0x7149 }, // CJK UNIFIED IDEOGRAPH
    { 0x97FA, 0x7C3E }, // CJK UNIFIED IDEOGRAPH
    { 0x97FB, 0x7DF4 }, // CJK UNIFIED IDEOGRAPH
    { 0x97FC, 0x806F }, // CJK UNIFIED IDEOGRAPH
    { 0x9840, 0x84EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9841, 0x9023 }, // CJK UNIFIED IDEOGRAPH
    { 0x9842, 0x932C }, // CJK UNIFIED IDEOGRAPH
    { 0x9843, 0x5442 }, // CJK UNIFIED IDEOGRAPH
    { 0x9844, 0x9B6F }, // CJK UNIFIED IDEOGRAPH
    { 0x9845, 0x6AD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9846, 0x7089 }, // CJK UNIFIED IDEOGRAPH
    { 0x9847, 0x8CC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9848, 0x8DEF }, // CJK UNIFIED IDEOGRAPH
    { 0x9849, 0x9732 }, // CJK UNIFIED IDEOGRAPH
    { 0x984A, 0x52B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x984B, 0x5A41 }, // CJK UNIFIED IDEOGRAPH
    { 0x984C, 0x5ECA }, // CJK UNIFIED IDEOGRAPH
    { 0x984D, 0x5F04 }, // CJK UNIFIED IDEOGRAPH
    { 0x984E, 0x6717 }, // CJK UNIFIED IDEOGRAPH
    { 0x984F, 0x697C }, // CJK UNIFIED IDEOGRAPH
    { 0x9850, 0x6994 }, // CJK UNIFIED IDEOGRAPH
    { 0x9851, 0x6D6A }, // CJK UNIFIED IDEOGRAPH
    { 0x9852, 0x6F0F }, // CJK UNIFIED IDEOGRAPH
    { 0x9853, 0x7262 }, // CJK UNIFIED IDEOGRAPH
    { 0x9854, 0x72FC }, // CJK UNIFIED IDEOGRAPH
    { 0x9855, 0x7BED }, // CJK UNIFIED IDEOGRAPH
    { 0x9856, 0x8001 }, // CJK UNIFIED IDEOGRAPH
    { 0x9857, 0x807E }, // CJK UNIFIED IDEOGRAPH
    { 0x9858, 0x874B }, // CJK UNIFIED IDEOGRAPH
    { 0x9859, 0x90CE }, // CJK UNIFIED IDEOGRAPH
    { 0x985A, 0x516D }, // CJK UNIFIED IDEOGRAPH
    { 0x985B, 0x9E93 }, // CJK UNIFIED IDEOGRAPH
    { 0x985C, 0x7984 }, // CJK UNIFIED IDEOGRAPH
    { 0x985D, 0x808B }, // CJK UNIFIED IDEOGRAPH
    { 0x985E, 0x9332 }, // CJK UNIFIED IDEOGRAPH
    { 0x985F, 0x8AD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9860, 0x502D }, // CJK UNIFIED IDEOGRAPH
    { 0x9861, 0x548C }, // CJK UNIFIED IDEOGRAPH
    { 0x9862, 0x8A71 }, // CJK UNIFIED IDEOGRAPH
    { 0x9863, 0x6B6A }, // CJK UNIFIED IDEOGRAPH
    { 0x9864, 0x8CC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9865, 0x8107 }, // CJK UNIFIED IDEOGRAPH
    { 0x9866, 0x60D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9867, 0x67A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9868, 0x9DF2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9869, 0x4E99 }, // CJK UNIFIED IDEOGRAPH
    { 0x986A, 0x4E98 }, // CJK UNIFIED IDEOGRAPH
    { 0x986B, 0x9C10 }, // CJK UNIFIED IDEOGRAPH
    { 0x986C, 0x8A6B }, // CJK UNIFIED IDEOGRAPH
    { 0x986D, 0x85C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x986E, 0x8568 }, // CJK UNIFIED IDEOGRAPH
    { 0x986F, 0x6900 }, // CJK UNIFIED IDEOGRAPH
    { 0x9870, 0x6E7E }, // CJK UNIFIED IDEOGRAPH
    { 0x9871, 0x7897 }, // CJK UNIFIED IDEOGRAPH
    { 0x9872, 0x8155 }, // CJK UNIFIED IDEOGRAPH
    { 0x989F, 0x5F0C }, // CJK UNIFIED IDEOGRAPH
    { 0x98A0, 0x4E10 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A1, 0x4E15 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A2, 0x4E2A }, // CJK UNIFIED IDEOGRAPH
    { 0x98A3, 0x4E31 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A4, 0x4E36 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A5, 0x4E3C }, // CJK UNIFIED IDEOGRAPH
    { 0x98A6, 0x4E3F }, // CJK UNIFIED IDEOGRAPH
    { 0x98A7, 0x4E42 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A8, 0x4E56 }, // CJK UNIFIED IDEOGRAPH
    { 0x98A9, 0x4E58 }, // CJK UNIFIED IDEOGRAPH
    { 0x98AA, 0x4E82 }, // CJK UNIFIED IDEOGRAPH
    { 0x98AB, 0x4E85 }, // CJK UNIFIED IDEOGRAPH
    { 0x98AC, 0x8C6B }, // CJK UNIFIED IDEOGRAPH
    { 0x98AD, 0x4E8A }, // CJK UNIFIED IDEOGRAPH
    { 0x98AE, 0x8212 }, // CJK UNIFIED IDEOGRAPH
    { 0x98AF, 0x5F0D }, // CJK UNIFIED IDEOGRAPH
    { 0x98B0, 0x4E8E }, // CJK UNIFIED IDEOGRAPH
    { 0x98B1, 0x4E9E }, // CJK UNIFIED IDEOGRAPH
    { 0x98B2, 0x4E9F }, // CJK UNIFIED IDEOGRAPH
    { 0x98B3, 0x4EA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x98B4, 0x4EA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x98B5, 0x4EB0 }, // CJK UNIFIED IDEOGRAPH
    { 0x98B6, 0x4EB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x98B7, 0x4EB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x98B8, 0x4ECE }, // CJK UNIFIED IDEOGRAPH
    { 0x98B9, 0x4ECD }, // CJK UNIFIED IDEOGRAPH
    { 0x98BA, 0x4EC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x98BB, 0x4EC6 }, // CJK UNIFIED IDEOGRAPH
    { 0x98BC, 0x4EC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x98BD, 0x4ED7 }, // CJK UNIFIED IDEOGRAPH
    { 0x98BE, 0x4EDE }, // CJK UNIFIED IDEOGRAPH
    { 0x98BF, 0x4EED }, // CJK UNIFIED IDEOGRAPH
    { 0x98C0, 0x4EDF }, // CJK UNIFIED IDEOGRAPH
    { 0x98C1, 0x4EF7 }, // CJK UNIFIED IDEOGRAPH
    { 0x98C2, 0x4F09 }, // CJK UNIFIED IDEOGRAPH
    { 0x98C3, 0x4F5A }, // CJK UNIFIED IDEOGRAPH
    { 0x98C4, 0x4F30 }, // CJK UNIFIED IDEOGRAPH
    { 0x98C5, 0x4F5B }, // CJK UNIFIED IDEOGRAPH
    { 0x98C6, 0x4F5D }, // CJK UNIFIED IDEOGRAPH
    { 0x98C7, 0x4F57 }, // CJK UNIFIED IDEOGRAPH
    { 0x98C8, 0x4F47 }, // CJK UNIFIED IDEOGRAPH
    { 0x98C9, 0x4F76 }, // CJK UNIFIED IDEOGRAPH
    { 0x98CA, 0x4F88 }, // CJK UNIFIED IDEOGRAPH
    { 0x98CB, 0x4F8F }, // CJK UNIFIED IDEOGRAPH
    { 0x98CC, 0x4F98 }, // CJK UNIFIED IDEOGRAPH
    { 0x98CD, 0x4F7B }, // CJK UNIFIED IDEOGRAPH
    { 0x98CE, 0x4F69 }, // CJK UNIFIED IDEOGRAPH
    { 0x98CF, 0x4F70 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D0, 0x4F91 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D1, 0x4F6F }, // CJK UNIFIED IDEOGRAPH
    { 0x98D2, 0x4F86 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D3, 0x4F96 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D4, 0x5118 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D5, 0x4FD4 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D6, 0x4FDF }, // CJK UNIFIED IDEOGRAPH
    { 0x98D7, 0x4FCE }, // CJK UNIFIED IDEOGRAPH
    { 0x98D8, 0x4FD8 }, // CJK UNIFIED IDEOGRAPH
    { 0x98D9, 0x4FDB }, // CJK UNIFIED IDEOGRAPH
    { 0x98DA, 0x4FD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x98DB, 0x4FDA }, // CJK UNIFIED IDEOGRAPH
    { 0x98DC, 0x4FD0 }, // CJK UNIFIED IDEOGRAPH
    { 0x98DD, 0x4FE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x98DE, 0x4FE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x98DF, 0x501A }, // CJK UNIFIED IDEOGRAPH
    { 0x98E0, 0x5028 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E1, 0x5014 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E2, 0x502A }, // CJK UNIFIED IDEOGRAPH
    { 0x98E3, 0x5025 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E4, 0x5005 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E5, 0x4F1C }, // CJK UNIFIED IDEOGRAPH
    { 0x98E6, 0x4FF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E7, 0x5021 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E8, 0x5029 }, // CJK UNIFIED IDEOGRAPH
    { 0x98E9, 0x502C }, // CJK UNIFIED IDEOGRAPH
    { 0x98EA, 0x4FFE }, // CJK UNIFIED IDEOGRAPH
    { 0x98EB, 0x4FEF }, // CJK UNIFIED IDEOGRAPH
    { 0x98EC, 0x5011 }, // CJK UNIFIED IDEOGRAPH
    { 0x98ED, 0x5006 }, // CJK UNIFIED IDEOGRAPH
    { 0x98EE, 0x5043 }, // CJK UNIFIED IDEOGRAPH
    { 0x98EF, 0x5047 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F0, 0x6703 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F1, 0x5055 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F2, 0x5050 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F3, 0x5048 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F4, 0x505A }, // CJK UNIFIED IDEOGRAPH
    { 0x98F5, 0x5056 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F6, 0x506C }, // CJK UNIFIED IDEOGRAPH
    { 0x98F7, 0x5078 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F8, 0x5080 }, // CJK UNIFIED IDEOGRAPH
    { 0x98F9, 0x509A }, // CJK UNIFIED IDEOGRAPH
    { 0x98FA, 0x5085 }, // CJK UNIFIED IDEOGRAPH
    { 0x98FB, 0x50B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x98FC, 0x50B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9940, 0x50C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9941, 0x50CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9942, 0x50B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9943, 0x50C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9944, 0x50D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9945, 0x50DE }, // CJK UNIFIED IDEOGRAPH
    { 0x9946, 0x50E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9947, 0x50ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9948, 0x50E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9949, 0x50EE }, // CJK UNIFIED IDEOGRAPH
    { 0x994A, 0x50F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x994B, 0x50F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x994C, 0x5109 }, // CJK UNIFIED IDEOGRAPH
    { 0x994D, 0x5101 }, // CJK UNIFIED IDEOGRAPH
    { 0x994E, 0x5102 }, // CJK UNIFIED IDEOGRAPH
    { 0x994F, 0x5116 }, // CJK UNIFIED IDEOGRAPH
    { 0x9950, 0x5115 }, // CJK UNIFIED IDEOGRAPH
    { 0x9951, 0x5114 }, // CJK UNIFIED IDEOGRAPH
    { 0x9952, 0x511A }, // CJK UNIFIED IDEOGRAPH
    { 0x9953, 0x5121 }, // CJK UNIFIED IDEOGRAPH
    { 0x9954, 0x513A }, // CJK UNIFIED IDEOGRAPH
    { 0x9955, 0x5137 }, // CJK UNIFIED IDEOGRAPH
    { 0x9956, 0x513C }, // CJK UNIFIED IDEOGRAPH
    { 0x9957, 0x513B }, // CJK UNIFIED IDEOGRAPH
    { 0x9958, 0x513F }, // CJK UNIFIED IDEOGRAPH
    { 0x9959, 0x5140 }, // CJK UNIFIED IDEOGRAPH
    { 0x995A, 0x5152 }, // CJK UNIFIED IDEOGRAPH
    { 0x995B, 0x514C }, // CJK UNIFIED IDEOGRAPH
    { 0x995C, 0x5154 }, // CJK UNIFIED IDEOGRAPH
    { 0x995D, 0x5162 }, // CJK UNIFIED IDEOGRAPH
    { 0x995E, 0x7AF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x995F, 0x5169 }, // CJK UNIFIED IDEOGRAPH
    { 0x9960, 0x516A }, // CJK UNIFIED IDEOGRAPH
    { 0x9961, 0x516E }, // CJK UNIFIED IDEOGRAPH
    { 0x9962, 0x5180 }, // CJK UNIFIED IDEOGRAPH
    { 0x9963, 0x5182 }, // CJK UNIFIED IDEOGRAPH
    { 0x9964, 0x56D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9965, 0x518C }, // CJK UNIFIED IDEOGRAPH
    { 0x9966, 0x5189 }, // CJK UNIFIED IDEOGRAPH
    { 0x9967, 0x518F }, // CJK UNIFIED IDEOGRAPH
    { 0x9968, 0x5191 }, // CJK UNIFIED IDEOGRAPH
    { 0x9969, 0x5193 }, // CJK UNIFIED IDEOGRAPH
    { 0x996A, 0x5195 }, // CJK UNIFIED IDEOGRAPH
    { 0x996B, 0x5196 }, // CJK UNIFIED IDEOGRAPH
    { 0x996C, 0x51A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x996D, 0x51A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x996E, 0x51A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x996F, 0x51A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9970, 0x51AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9971, 0x51AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9972, 0x51B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9973, 0x51B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9974, 0x51B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9975, 0x51B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9976, 0x51B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9977, 0x51BD }, // CJK UNIFIED IDEOGRAPH
    { 0x9978, 0x51C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9979, 0x51C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x997A, 0x51DB }, // CJK UNIFIED IDEOGRAPH
    { 0x997B, 0x51E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x997C, 0x8655 }, // CJK UNIFIED IDEOGRAPH
    { 0x997D, 0x51E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x997E, 0x51ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9980, 0x51F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9981, 0x51F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9982, 0x51FE }, // CJK UNIFIED IDEOGRAPH
    { 0x9983, 0x5204 }, // CJK UNIFIED IDEOGRAPH
    { 0x9984, 0x520B }, // CJK UNIFIED IDEOGRAPH
    { 0x9985, 0x5214 }, // CJK UNIFIED IDEOGRAPH
    { 0x9986, 0x520E }, // CJK UNIFIED IDEOGRAPH
    { 0x9987, 0x5227 }, // CJK UNIFIED IDEOGRAPH
    { 0x9988, 0x522A }, // CJK UNIFIED IDEOGRAPH
    { 0x9989, 0x522E }, // CJK UNIFIED IDEOGRAPH
    { 0x998A, 0x5233 }, // CJK UNIFIED IDEOGRAPH
    { 0x998B, 0x5239 }, // CJK UNIFIED IDEOGRAPH
    { 0x998C, 0x524F }, // CJK UNIFIED IDEOGRAPH
    { 0x998D, 0x5244 }, // CJK UNIFIED IDEOGRAPH
    { 0x998E, 0x524B }, // CJK UNIFIED IDEOGRAPH
    { 0x998F, 0x524C }, // CJK UNIFIED IDEOGRAPH
    { 0x9990, 0x525E }, // CJK UNIFIED IDEOGRAPH
    { 0x9991, 0x5254 }, // CJK UNIFIED IDEOGRAPH
    { 0x9992, 0x526A }, // CJK UNIFIED IDEOGRAPH
    { 0x9993, 0x5274 }, // CJK UNIFIED IDEOGRAPH
    { 0x9994, 0x5269 }, // CJK UNIFIED IDEOGRAPH
    { 0x9995, 0x5273 }, // CJK UNIFIED IDEOGRAPH
    { 0x9996, 0x527F }, // CJK UNIFIED IDEOGRAPH
    { 0x9997, 0x527D }, // CJK UNIFIED IDEOGRAPH
    { 0x9998, 0x528D }, // CJK UNIFIED IDEOGRAPH
    { 0x9999, 0x5294 }, // CJK UNIFIED IDEOGRAPH
    { 0x999A, 0x5292 }, // CJK UNIFIED IDEOGRAPH
    { 0x999B, 0x5271 }, // CJK UNIFIED IDEOGRAPH
    { 0x999C, 0x5288 }, // CJK UNIFIED IDEOGRAPH
    { 0x999D, 0x5291 }, // CJK UNIFIED IDEOGRAPH
    { 0x999E, 0x8FA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x999F, 0x8FA7 }, // CJK UNIFIED IDEOGRAPH
    { 0x99A0, 0x52AC }, // CJK UNIFIED IDEOGRAPH
    { 0x99A1, 0x52AD }, // CJK UNIFIED IDEOGRAPH
    { 0x99A2, 0x52BC }, // CJK UNIFIED IDEOGRAPH
    { 0x99A3, 0x52B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x99A4, 0x52C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x99A5, 0x52CD }, // CJK UNIFIED IDEOGRAPH
    { 0x99A6, 0x52D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x99A7, 0x52DE }, // CJK UNIFIED IDEOGRAPH
    { 0x99A8, 0x52E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x99A9, 0x52E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x99AA, 0x98ED }, // CJK UNIFIED IDEOGRAPH
    { 0x99AB, 0x52E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x99AC, 0x52F3 }, // CJK UNIFIED IDEOGRAPH
    { 0x99AD, 0x52F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x99AE, 0x52F8 }, // CJK UNIFIED IDEOGRAPH
    { 0x99AF, 0x52F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B0, 0x5306 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B1, 0x5308 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B2, 0x7538 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B3, 0x530D }, // CJK UNIFIED IDEOGRAPH
    { 0x99B4, 0x5310 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B5, 0x530F }, // CJK UNIFIED IDEOGRAPH
    { 0x99B6, 0x5315 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B7, 0x531A }, // CJK UNIFIED IDEOGRAPH
    { 0x99B8, 0x5323 }, // CJK UNIFIED IDEOGRAPH
    { 0x99B9, 0x532F }, // CJK UNIFIED IDEOGRAPH
    { 0x99BA, 0x5331 }, // CJK UNIFIED IDEOGRAPH
    { 0x99BB, 0x5333 }, // CJK UNIFIED IDEOGRAPH
    { 0x99BC, 0x5338 }, // CJK UNIFIED IDEOGRAPH
    { 0x99BD, 0x5340 }, // CJK UNIFIED IDEOGRAPH
    { 0x99BE, 0x5346 }, // CJK UNIFIED IDEOGRAPH
    { 0x99BF, 0x5345 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C0, 0x4E17 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C1, 0x5349 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C2, 0x534D }, // CJK UNIFIED IDEOGRAPH
    { 0x99C3, 0x51D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C4, 0x535E }, // CJK UNIFIED IDEOGRAPH
    { 0x99C5, 0x5369 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C6, 0x536E }, // CJK UNIFIED IDEOGRAPH
    { 0x99C7, 0x5918 }, // CJK UNIFIED IDEOGRAPH
    { 0x99C8, 0x537B }, // CJK UNIFIED IDEOGRAPH
    { 0x99C9, 0x5377 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CA, 0x5382 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CB, 0x5396 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CC, 0x53A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CD, 0x53A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CE, 0x53A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x99CF, 0x53AE }, // CJK UNIFIED IDEOGRAPH
    { 0x99D0, 0x53B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x99D1, 0x53B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x99D2, 0x53C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x99D3, 0x7C12 }, // CJK UNIFIED IDEOGRAPH
    { 0x99D4, 0x96D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x99D5, 0x53DF }, // CJK UNIFIED IDEOGRAPH
    { 0x99D6, 0x66FC }, // CJK UNIFIED IDEOGRAPH
    { 0x99D7, 0x71EE }, // CJK UNIFIED IDEOGRAPH
    { 0x99D8, 0x53EE }, // CJK UNIFIED IDEOGRAPH
    { 0x99D9, 0x53E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x99DA, 0x53ED }, // CJK UNIFIED IDEOGRAPH
    { 0x99DB, 0x53FA }, // CJK UNIFIED IDEOGRAPH
    { 0x99DC, 0x5401 }, // CJK UNIFIED IDEOGRAPH
    { 0x99DD, 0x543D }, // CJK UNIFIED IDEOGRAPH
    { 0x99DE, 0x5440 }, // CJK UNIFIED IDEOGRAPH
    { 0x99DF, 0x542C }, // CJK UNIFIED IDEOGRAPH
    { 0x99E0, 0x542D }, // CJK UNIFIED IDEOGRAPH
    { 0x99E1, 0x543C }, // CJK UNIFIED IDEOGRAPH
    { 0x99E2, 0x542E }, // CJK UNIFIED IDEOGRAPH
    { 0x99E3, 0x5436 }, // CJK UNIFIED IDEOGRAPH
    { 0x99E4, 0x5429 }, // CJK UNIFIED IDEOGRAPH
    { 0x99E5, 0x541D }, // CJK UNIFIED IDEOGRAPH
    { 0x99E6, 0x544E }, // CJK UNIFIED IDEOGRAPH
    { 0x99E7, 0x548F }, // CJK UNIFIED IDEOGRAPH
    { 0x99E8, 0x5475 }, // CJK UNIFIED IDEOGRAPH
    { 0x99E9, 0x548E }, // CJK UNIFIED IDEOGRAPH
    { 0x99EA, 0x545F }, // CJK UNIFIED IDEOGRAPH
    { 0x99EB, 0x5471 }, // CJK UNIFIED IDEOGRAPH
    { 0x99EC, 0x5477 }, // CJK UNIFIED IDEOGRAPH
    { 0x99ED, 0x5470 }, // CJK UNIFIED IDEOGRAPH
    { 0x99EE, 0x5492 }, // CJK UNIFIED IDEOGRAPH
    { 0x99EF, 0x547B }, // CJK UNIFIED IDEOGRAPH
    { 0x99F0, 0x5480 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F1, 0x5476 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F2, 0x5484 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F3, 0x5490 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F4, 0x5486 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F5, 0x54C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F6, 0x54A2 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F7, 0x54B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F8, 0x54A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x99F9, 0x54AC }, // CJK UNIFIED IDEOGRAPH
    { 0x99FA, 0x54C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x99FB, 0x54C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x99FC, 0x54A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A40, 0x54AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9A41, 0x54C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A42, 0x54A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A43, 0x54BE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A44, 0x54BC }, // CJK UNIFIED IDEOGRAPH
    { 0x9A45, 0x54D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A46, 0x54E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A47, 0x54E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A48, 0x550F }, // CJK UNIFIED IDEOGRAPH
    { 0x9A49, 0x5514 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4A, 0x54FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4B, 0x54EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4C, 0x54ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4D, 0x54FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4E, 0x54E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A4F, 0x5539 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A50, 0x5540 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A51, 0x5563 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A52, 0x554C }, // CJK UNIFIED IDEOGRAPH
    { 0x9A53, 0x552E }, // CJK UNIFIED IDEOGRAPH
    { 0x9A54, 0x555C }, // CJK UNIFIED IDEOGRAPH
    { 0x9A55, 0x5545 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A56, 0x5556 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A57, 0x5557 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A58, 0x5538 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A59, 0x5533 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5A, 0x555D }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5B, 0x5599 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5C, 0x5580 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5D, 0x54AF }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5E, 0x558A }, // CJK UNIFIED IDEOGRAPH
    { 0x9A5F, 0x559F }, // CJK UNIFIED IDEOGRAPH
    { 0x9A60, 0x557B }, // CJK UNIFIED IDEOGRAPH
    { 0x9A61, 0x557E }, // CJK UNIFIED IDEOGRAPH
    { 0x9A62, 0x5598 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A63, 0x559E }, // CJK UNIFIED IDEOGRAPH
    { 0x9A64, 0x55AE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A65, 0x557C }, // CJK UNIFIED IDEOGRAPH
    { 0x9A66, 0x5583 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A67, 0x55A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A68, 0x5587 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A69, 0x55A8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6A, 0x55DA }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6B, 0x55C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6C, 0x55DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6D, 0x55C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6E, 0x55DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9A6F, 0x55E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A70, 0x55D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A71, 0x5614 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A72, 0x55F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A73, 0x5616 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A74, 0x55FE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A75, 0x55FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9A76, 0x561B }, // CJK UNIFIED IDEOGRAPH
    { 0x9A77, 0x55F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A78, 0x564E }, // CJK UNIFIED IDEOGRAPH
    { 0x9A79, 0x5650 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A7A, 0x71DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9A7B, 0x5634 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A7C, 0x5636 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A7D, 0x5632 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A7E, 0x5638 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A80, 0x566B }, // CJK UNIFIED IDEOGRAPH
    { 0x9A81, 0x5664 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A82, 0x562F }, // CJK UNIFIED IDEOGRAPH
    { 0x9A83, 0x566C }, // CJK UNIFIED IDEOGRAPH
    { 0x9A84, 0x566A }, // CJK UNIFIED IDEOGRAPH
    { 0x9A85, 0x5686 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A86, 0x5680 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A87, 0x568A }, // CJK UNIFIED IDEOGRAPH
    { 0x9A88, 0x56A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A89, 0x5694 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8A, 0x568F }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8B, 0x56A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8C, 0x56AE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8D, 0x56B6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8E, 0x56B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A8F, 0x56C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A90, 0x56BC }, // CJK UNIFIED IDEOGRAPH
    { 0x9A91, 0x56C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A92, 0x56C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A93, 0x56C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A94, 0x56C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A95, 0x56CE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A96, 0x56D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A97, 0x56D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A98, 0x56D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A99, 0x56EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9A, 0x56F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9B, 0x5700 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9C, 0x56FF }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9D, 0x5704 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9E, 0x5709 }, // CJK UNIFIED IDEOGRAPH
    { 0x9A9F, 0x5708 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA0, 0x570B }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA1, 0x570D }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA2, 0x5713 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA3, 0x5718 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA4, 0x5716 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA5, 0x55C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA6, 0x571C }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA7, 0x5726 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA8, 0x5737 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AA9, 0x5738 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAA, 0x574E }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAB, 0x573B }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAC, 0x5740 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAD, 0x574F }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAE, 0x5769 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AAF, 0x57C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB0, 0x5788 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB1, 0x5761 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB2, 0x577F }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB3, 0x5789 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB4, 0x5793 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB5, 0x57A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB6, 0x57B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB7, 0x57A4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB8, 0x57AA }, // CJK UNIFIED IDEOGRAPH
    { 0x9AB9, 0x57B0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABA, 0x57C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABB, 0x57C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABC, 0x57D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABD, 0x57D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABE, 0x57D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ABF, 0x580A }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC0, 0x57D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC1, 0x57E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC2, 0x580B }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC3, 0x5819 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC4, 0x581D }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC5, 0x5872 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC6, 0x5821 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC7, 0x5862 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC8, 0x584B }, // CJK UNIFIED IDEOGRAPH
    { 0x9AC9, 0x5870 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACA, 0x6BC0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACB, 0x5852 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACC, 0x583D }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACD, 0x5879 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACE, 0x5885 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ACF, 0x58B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD0, 0x589F }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD1, 0x58AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD2, 0x58BA }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD3, 0x58DE }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD4, 0x58BB }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD5, 0x58B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD6, 0x58AE }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD7, 0x58C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD8, 0x58D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AD9, 0x58D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADA, 0x58D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADB, 0x58D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADC, 0x58D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADD, 0x58E5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADE, 0x58DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9ADF, 0x58E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE0, 0x58DF }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE1, 0x58EF }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE2, 0x58FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE3, 0x58F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE4, 0x58FB }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE5, 0x58FC }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE6, 0x58FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE7, 0x5902 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE8, 0x590A }, // CJK UNIFIED IDEOGRAPH
    { 0x9AE9, 0x5910 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AEA, 0x591B }, // CJK UNIFIED IDEOGRAPH
    { 0x9AEB, 0x68A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AEC, 0x5925 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AED, 0x592C }, // CJK UNIFIED IDEOGRAPH
    { 0x9AEE, 0x592D }, // CJK UNIFIED IDEOGRAPH
    { 0x9AEF, 0x5932 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF0, 0x5938 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF1, 0x593E }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF2, 0x7AD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF3, 0x5955 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF4, 0x5950 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF5, 0x594E }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF6, 0x595A }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF7, 0x5958 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF8, 0x5962 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AF9, 0x5960 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AFA, 0x5967 }, // CJK UNIFIED IDEOGRAPH
    { 0x9AFB, 0x596C }, // CJK UNIFIED IDEOGRAPH
    { 0x9AFC, 0x5969 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B40, 0x5978 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B41, 0x5981 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B42, 0x599D }, // CJK UNIFIED IDEOGRAPH
    { 0x9B43, 0x4F5E }, // CJK UNIFIED IDEOGRAPH
    { 0x9B44, 0x4FAB }, // CJK UNIFIED IDEOGRAPH
    { 0x9B45, 0x59A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B46, 0x59B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B47, 0x59C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B48, 0x59E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B49, 0x59DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4A, 0x598D }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4B, 0x59D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4C, 0x59DA }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4D, 0x5A25 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4E, 0x5A1F }, // CJK UNIFIED IDEOGRAPH
    { 0x9B4F, 0x5A11 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B50, 0x5A1C }, // CJK UNIFIED IDEOGRAPH
    { 0x9B51, 0x5A09 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B52, 0x5A1A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B53, 0x5A40 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B54, 0x5A6C }, // CJK UNIFIED IDEOGRAPH
    { 0x9B55, 0x5A49 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B56, 0x5A35 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B57, 0x5A36 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B58, 0x5A62 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B59, 0x5A6A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5A, 0x5A9A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5B, 0x5ABC }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5C, 0x5ABE }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5D, 0x5ACB }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5E, 0x5AC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B5F, 0x5ABD }, // CJK UNIFIED IDEOGRAPH
    { 0x9B60, 0x5AE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B61, 0x5AD7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B62, 0x5AE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B63, 0x5AE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B64, 0x5AD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B65, 0x5AFA }, // CJK UNIFIED IDEOGRAPH
    { 0x9B66, 0x5AFB }, // CJK UNIFIED IDEOGRAPH
    { 0x9B67, 0x5B0C }, // CJK UNIFIED IDEOGRAPH
    { 0x9B68, 0x5B0B }, // CJK UNIFIED IDEOGRAPH
    { 0x9B69, 0x5B16 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6A, 0x5B32 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6B, 0x5AD0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6C, 0x5B2A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6D, 0x5B36 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6E, 0x5B3E }, // CJK UNIFIED IDEOGRAPH
    { 0x9B6F, 0x5B43 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B70, 0x5B45 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B71, 0x5B40 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B72, 0x5B51 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B73, 0x5B55 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B74, 0x5B5A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B75, 0x5B5B }, // CJK UNIFIED IDEOGRAPH
    { 0x9B76, 0x5B65 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B77, 0x5B69 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B78, 0x5B70 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B79, 0x5B73 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B7A, 0x5B75 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B7B, 0x5B78 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B7C, 0x6588 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B7D, 0x5B7A }, // CJK UNIFIED IDEOGRAPH
    { 0x9B7E, 0x5B80 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B80, 0x5B83 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B81, 0x5BA6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B82, 0x5BB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B83, 0x5BC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B84, 0x5BC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B85, 0x5BC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B86, 0x5BD4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B87, 0x5BD0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B88, 0x5BE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B89, 0x5BE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8A, 0x5BE2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8B, 0x5BDE }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8C, 0x5BE5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8D, 0x5BEB }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8E, 0x5BF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B8F, 0x5BF6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B90, 0x5BF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B91, 0x5C05 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B92, 0x5C07 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B93, 0x5C08 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B94, 0x5C0D }, // CJK UNIFIED IDEOGRAPH
    { 0x9B95, 0x5C13 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B96, 0x5C20 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B97, 0x5C22 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B98, 0x5C28 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B99, 0x5C38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9A, 0x5C39 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9B, 0x5C41 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9C, 0x5C46 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9D, 0x5C4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9E, 0x5C53 }, // CJK UNIFIED IDEOGRAPH
    { 0x9B9F, 0x5C50 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA0, 0x5C4F }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA1, 0x5B71 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA2, 0x5C6C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA3, 0x5C6E }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA4, 0x4E62 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA5, 0x5C76 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA6, 0x5C79 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA7, 0x5C8C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA8, 0x5C91 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BA9, 0x5C94 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAA, 0x599B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAB, 0x5CAB }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAC, 0x5CBB }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAD, 0x5CB6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAE, 0x5CBC }, // CJK UNIFIED IDEOGRAPH
    { 0x9BAF, 0x5CB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB0, 0x5CC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB1, 0x5CBE }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB2, 0x5CC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB3, 0x5CD9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB4, 0x5CE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB5, 0x5CFD }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB6, 0x5CFA }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB7, 0x5CED }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB8, 0x5D8C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BB9, 0x5CEA }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBA, 0x5D0B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBB, 0x5D15 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBC, 0x5D17 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBD, 0x5D5C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBE, 0x5D1F }, // CJK UNIFIED IDEOGRAPH
    { 0x9BBF, 0x5D1B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC0, 0x5D11 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC1, 0x5D14 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC2, 0x5D22 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC3, 0x5D1A }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC4, 0x5D19 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC5, 0x5D18 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC6, 0x5D4C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC7, 0x5D52 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC8, 0x5D4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9BC9, 0x5D4B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCA, 0x5D6C }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCB, 0x5D73 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCC, 0x5D76 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCD, 0x5D87 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCE, 0x5D84 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BCF, 0x5D82 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD0, 0x5DA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD1, 0x5D9D }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD2, 0x5DAC }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD3, 0x5DAE }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD4, 0x5DBD }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD5, 0x5D90 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD6, 0x5DB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD7, 0x5DBC }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD8, 0x5DC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BD9, 0x5DCD }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDA, 0x5DD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDB, 0x5DD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDC, 0x5DD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDD, 0x5DDB }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDE, 0x5DEB }, // CJK UNIFIED IDEOGRAPH
    { 0x9BDF, 0x5DF2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE0, 0x5DF5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE1, 0x5E0B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE2, 0x5E1A }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE3, 0x5E19 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE4, 0x5E11 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE5, 0x5E1B }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE6, 0x5E36 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE7, 0x5E37 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE8, 0x5E44 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BE9, 0x5E43 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BEA, 0x5E40 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BEB, 0x5E4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9BEC, 0x5E57 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BED, 0x5E54 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BEE, 0x5E5F }, // CJK UNIFIED IDEOGRAPH
    { 0x9BEF, 0x5E62 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF0, 0x5E64 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF1, 0x5E47 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF2, 0x5E75 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF3, 0x5E76 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF4, 0x5E7A }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF5, 0x9EBC }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF6, 0x5E7F }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF7, 0x5EA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF8, 0x5EC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BF9, 0x5EC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BFA, 0x5EC8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BFB, 0x5ED0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9BFC, 0x5ECF }, // CJK UNIFIED IDEOGRAPH
    { 0x9C40, 0x5ED6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C41, 0x5EE3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C42, 0x5EDD }, // CJK UNIFIED IDEOGRAPH
    { 0x9C43, 0x5EDA }, // CJK UNIFIED IDEOGRAPH
    { 0x9C44, 0x5EDB }, // CJK UNIFIED IDEOGRAPH
    { 0x9C45, 0x5EE2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C46, 0x5EE1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C47, 0x5EE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C48, 0x5EE9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C49, 0x5EEC }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4A, 0x5EF1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4B, 0x5EF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4C, 0x5EF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4D, 0x5EF4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4E, 0x5EF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C4F, 0x5EFE }, // CJK UNIFIED IDEOGRAPH
    { 0x9C50, 0x5F03 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C51, 0x5F09 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C52, 0x5F5D }, // CJK UNIFIED IDEOGRAPH
    { 0x9C53, 0x5F5C }, // CJK UNIFIED IDEOGRAPH
    { 0x9C54, 0x5F0B }, // CJK UNIFIED IDEOGRAPH
    { 0x9C55, 0x5F11 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C56, 0x5F16 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C57, 0x5F29 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C58, 0x5F2D }, // CJK UNIFIED IDEOGRAPH
    { 0x9C59, 0x5F38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5A, 0x5F41 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5B, 0x5F48 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5C, 0x5F4C }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5D, 0x5F4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5E, 0x5F2F }, // CJK UNIFIED IDEOGRAPH
    { 0x9C5F, 0x5F51 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C60, 0x5F56 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C61, 0x5F57 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C62, 0x5F59 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C63, 0x5F61 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C64, 0x5F6D }, // CJK UNIFIED IDEOGRAPH
    { 0x9C65, 0x5F73 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C66, 0x5F77 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C67, 0x5F83 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C68, 0x5F82 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C69, 0x5F7F }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6A, 0x5F8A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6B, 0x5F88 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6C, 0x5F91 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6D, 0x5F87 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6E, 0x5F9E }, // CJK UNIFIED IDEOGRAPH
    { 0x9C6F, 0x5F99 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C70, 0x5F98 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C71, 0x5FA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C72, 0x5FA8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C73, 0x5FAD }, // CJK UNIFIED IDEOGRAPH
    { 0x9C74, 0x5FBC }, // CJK UNIFIED IDEOGRAPH
    { 0x9C75, 0x5FD6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C76, 0x5FFB }, // CJK UNIFIED IDEOGRAPH
    { 0x9C77, 0x5FE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C78, 0x5FF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C79, 0x5FF1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C7A, 0x5FDD }, // CJK UNIFIED IDEOGRAPH
    { 0x9C7B, 0x60B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C7C, 0x5FFF }, // CJK UNIFIED IDEOGRAPH
    { 0x9C7D, 0x6021 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C7E, 0x6060 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C80, 0x6019 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C81, 0x6010 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C82, 0x6029 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C83, 0x600E }, // CJK UNIFIED IDEOGRAPH
    { 0x9C84, 0x6031 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C85, 0x601B }, // CJK UNIFIED IDEOGRAPH
    { 0x9C86, 0x6015 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C87, 0x602B }, // CJK UNIFIED IDEOGRAPH
    { 0x9C88, 0x6026 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C89, 0x600F }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8A, 0x603A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8B, 0x605A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8C, 0x6041 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8D, 0x606A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8E, 0x6077 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C8F, 0x605F }, // CJK UNIFIED IDEOGRAPH
    { 0x9C90, 0x604A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C91, 0x6046 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C92, 0x604D }, // CJK UNIFIED IDEOGRAPH
    { 0x9C93, 0x6063 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C94, 0x6043 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C95, 0x6064 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C96, 0x6042 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C97, 0x606C }, // CJK UNIFIED IDEOGRAPH
    { 0x9C98, 0x606B }, // CJK UNIFIED IDEOGRAPH
    { 0x9C99, 0x6059 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9A, 0x6081 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9B, 0x608D }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9C, 0x60E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9D, 0x6083 }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9E, 0x609A }, // CJK UNIFIED IDEOGRAPH
    { 0x9C9F, 0x6084 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA0, 0x609B }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA1, 0x6096 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA2, 0x6097 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA3, 0x6092 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA4, 0x60A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA5, 0x608B }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA6, 0x60E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA7, 0x60B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA8, 0x60E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CA9, 0x60D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAA, 0x60B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAB, 0x5FF0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAC, 0x60BD }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAD, 0x60C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAE, 0x60B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CAF, 0x60D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB0, 0x614D }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB1, 0x6115 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB2, 0x6106 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB3, 0x60F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB4, 0x60F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB5, 0x6100 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB6, 0x60F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB7, 0x60FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB8, 0x6103 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CB9, 0x6121 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBA, 0x60FB }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBB, 0x60F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBC, 0x610D }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBD, 0x610E }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBE, 0x6147 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CBF, 0x613E }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC0, 0x6128 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC1, 0x6127 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC2, 0x614A }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC3, 0x613F }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC4, 0x613C }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC5, 0x612C }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC6, 0x6134 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC7, 0x613D }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC8, 0x6142 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CC9, 0x6144 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCA, 0x6173 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCB, 0x6177 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCC, 0x6158 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCD, 0x6159 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCE, 0x615A }, // CJK UNIFIED IDEOGRAPH
    { 0x9CCF, 0x616B }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD0, 0x6174 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD1, 0x616F }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD2, 0x6165 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD3, 0x6171 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD4, 0x615F }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD5, 0x615D }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD6, 0x6153 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD7, 0x6175 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD8, 0x6199 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CD9, 0x6196 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDA, 0x6187 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDB, 0x61AC }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDC, 0x6194 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDD, 0x619A }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDE, 0x618A }, // CJK UNIFIED IDEOGRAPH
    { 0x9CDF, 0x6191 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE0, 0x61AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE1, 0x61AE }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE2, 0x61CC }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE3, 0x61CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE4, 0x61C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE5, 0x61F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE6, 0x61C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE7, 0x61C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE8, 0x61C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CE9, 0x61BA }, // CJK UNIFIED IDEOGRAPH
    { 0x9CEA, 0x61CB }, // CJK UNIFIED IDEOGRAPH
    { 0x9CEB, 0x7F79 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CEC, 0x61CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9CED, 0x61E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CEE, 0x61E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CEF, 0x61F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF0, 0x61FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF1, 0x61F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF2, 0x61FF }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF3, 0x61FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF4, 0x61FC }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF5, 0x61FE }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF6, 0x6200 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF7, 0x6208 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF8, 0x6209 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CF9, 0x620D }, // CJK UNIFIED IDEOGRAPH
    { 0x9CFA, 0x620C }, // CJK UNIFIED IDEOGRAPH
    { 0x9CFB, 0x6214 }, // CJK UNIFIED IDEOGRAPH
    { 0x9CFC, 0x621B }, // CJK UNIFIED IDEOGRAPH
    { 0x9D40, 0x621E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D41, 0x6221 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D42, 0x622A }, // CJK UNIFIED IDEOGRAPH
    { 0x9D43, 0x622E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D44, 0x6230 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D45, 0x6232 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D46, 0x6233 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D47, 0x6241 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D48, 0x624E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D49, 0x625E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4A, 0x6263 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4B, 0x625B }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4C, 0x6260 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4D, 0x6268 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4E, 0x627C }, // CJK UNIFIED IDEOGRAPH
    { 0x9D4F, 0x6282 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D50, 0x6289 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D51, 0x627E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D52, 0x6292 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D53, 0x6293 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D54, 0x6296 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D55, 0x62D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D56, 0x6283 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D57, 0x6294 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D58, 0x62D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D59, 0x62D1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5A, 0x62BB }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5B, 0x62CF }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5C, 0x62FF }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5D, 0x62C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5E, 0x64D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D5F, 0x62C8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D60, 0x62DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9D61, 0x62CC }, // CJK UNIFIED IDEOGRAPH
    { 0x9D62, 0x62CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9D63, 0x62C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D64, 0x62C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D65, 0x629B }, // CJK UNIFIED IDEOGRAPH
    { 0x9D66, 0x62C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D67, 0x630C }, // CJK UNIFIED IDEOGRAPH
    { 0x9D68, 0x62EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9D69, 0x62F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6A, 0x6327 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6B, 0x6302 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6C, 0x6308 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6D, 0x62EF }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6E, 0x62F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D6F, 0x6350 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D70, 0x633E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D71, 0x634D }, // CJK UNIFIED IDEOGRAPH
    { 0x9D72, 0x641C }, // CJK UNIFIED IDEOGRAPH
    { 0x9D73, 0x634F }, // CJK UNIFIED IDEOGRAPH
    { 0x9D74, 0x6396 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D75, 0x638E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D76, 0x6380 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D77, 0x63AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9D78, 0x6376 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D79, 0x63A3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D7A, 0x638F }, // CJK UNIFIED IDEOGRAPH
    { 0x9D7B, 0x6389 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D7C, 0x639F }, // CJK UNIFIED IDEOGRAPH
    { 0x9D7D, 0x63B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D7E, 0x636B }, // CJK UNIFIED IDEOGRAPH
    { 0x9D80, 0x6369 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D81, 0x63BE }, // CJK UNIFIED IDEOGRAPH
    { 0x9D82, 0x63E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D83, 0x63C0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D84, 0x63C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D85, 0x63E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D86, 0x63C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D87, 0x63D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D88, 0x63F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D89, 0x63C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8A, 0x6416 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8B, 0x6434 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8C, 0x6406 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8D, 0x6413 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8E, 0x6426 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D8F, 0x6436 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D90, 0x651D }, // CJK UNIFIED IDEOGRAPH
    { 0x9D91, 0x6417 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D92, 0x6428 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D93, 0x640F }, // CJK UNIFIED IDEOGRAPH
    { 0x9D94, 0x6467 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D95, 0x646F }, // CJK UNIFIED IDEOGRAPH
    { 0x9D96, 0x6476 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D97, 0x644E }, // CJK UNIFIED IDEOGRAPH
    { 0x9D98, 0x652A }, // CJK UNIFIED IDEOGRAPH
    { 0x9D99, 0x6495 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9A, 0x6493 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9B, 0x64A5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9C, 0x64A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9D, 0x6488 }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9E, 0x64BC }, // CJK UNIFIED IDEOGRAPH
    { 0x9D9F, 0x64DA }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA0, 0x64D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA1, 0x64C5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA2, 0x64C7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA3, 0x64BB }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA4, 0x64D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA5, 0x64C2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA6, 0x64F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA7, 0x64E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA8, 0x8209 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DA9, 0x64E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAA, 0x64E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAB, 0x62AC }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAC, 0x64E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAD, 0x64EF }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAE, 0x652C }, // CJK UNIFIED IDEOGRAPH
    { 0x9DAF, 0x64F6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB0, 0x64F4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB1, 0x64F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB2, 0x64FA }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB3, 0x6500 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB4, 0x64FD }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB5, 0x6518 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB6, 0x651C }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB7, 0x6505 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB8, 0x6524 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DB9, 0x6523 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBA, 0x652B }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBB, 0x6534 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBC, 0x6535 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBD, 0x6537 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBE, 0x6536 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DBF, 0x6538 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC0, 0x754B }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC1, 0x6548 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC2, 0x6556 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC3, 0x6555 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC4, 0x654D }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC5, 0x6558 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC6, 0x655E }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC7, 0x655D }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC8, 0x6572 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DC9, 0x6578 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCA, 0x6582 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCB, 0x6583 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCC, 0x8B8A }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCD, 0x659B }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCE, 0x659F }, // CJK UNIFIED IDEOGRAPH
    { 0x9DCF, 0x65AB }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD0, 0x65B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD1, 0x65C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD2, 0x65C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD3, 0x65C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD4, 0x65C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD5, 0x65CC }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD6, 0x65D2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD7, 0x65DB }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD8, 0x65D9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DD9, 0x65E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDA, 0x65E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDB, 0x65F1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDC, 0x6772 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDD, 0x660A }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDE, 0x6603 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DDF, 0x65FB }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE0, 0x6773 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE1, 0x6635 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE2, 0x6636 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE3, 0x6634 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE4, 0x661C }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE5, 0x664F }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE6, 0x6644 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE7, 0x6649 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE8, 0x6641 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DE9, 0x665E }, // CJK UNIFIED IDEOGRAPH
    { 0x9DEA, 0x665D }, // CJK UNIFIED IDEOGRAPH
    { 0x9DEB, 0x6664 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DEC, 0x6667 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DED, 0x6668 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DEE, 0x665F }, // CJK UNIFIED IDEOGRAPH
    { 0x9DEF, 0x6662 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF0, 0x6670 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF1, 0x6683 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF2, 0x6688 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF3, 0x668E }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF4, 0x6689 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF5, 0x6684 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF6, 0x6698 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF7, 0x669D }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF8, 0x66C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DF9, 0x66B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DFA, 0x66C9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9DFB, 0x66BE }, // CJK UNIFIED IDEOGRAPH
    { 0x9DFC, 0x66BC }, // CJK UNIFIED IDEOGRAPH
    { 0x9E40, 0x66C4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E41, 0x66B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E42, 0x66D6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E43, 0x66DA }, // CJK UNIFIED IDEOGRAPH
    { 0x9E44, 0x66E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E45, 0x663F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E46, 0x66E6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E47, 0x66E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E48, 0x66F0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E49, 0x66F5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4A, 0x66F7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4B, 0x670F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4C, 0x6716 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4D, 0x671E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4E, 0x6726 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E4F, 0x6727 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E50, 0x9738 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E51, 0x672E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E52, 0x673F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E53, 0x6736 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E54, 0x6741 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E55, 0x6738 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E56, 0x6737 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E57, 0x6746 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E58, 0x675E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E59, 0x6760 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5A, 0x6759 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5B, 0x6763 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5C, 0x6764 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5D, 0x6789 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5E, 0x6770 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E5F, 0x67A9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E60, 0x677C }, // CJK UNIFIED IDEOGRAPH
    { 0x9E61, 0x676A }, // CJK UNIFIED IDEOGRAPH
    { 0x9E62, 0x678C }, // CJK UNIFIED IDEOGRAPH
    { 0x9E63, 0x678B }, // CJK UNIFIED IDEOGRAPH
    { 0x9E64, 0x67A6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E65, 0x67A1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E66, 0x6785 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E67, 0x67B7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E68, 0x67EF }, // CJK UNIFIED IDEOGRAPH
    { 0x9E69, 0x67B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6A, 0x67EC }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6B, 0x67B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6C, 0x67E9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6D, 0x67B8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6E, 0x67E4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E6F, 0x67DE }, // CJK UNIFIED IDEOGRAPH
    { 0x9E70, 0x67DD }, // CJK UNIFIED IDEOGRAPH
    { 0x9E71, 0x67E2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E72, 0x67EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9E73, 0x67B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E74, 0x67CE }, // CJK UNIFIED IDEOGRAPH
    { 0x9E75, 0x67C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E76, 0x67E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E77, 0x6A9C }, // CJK UNIFIED IDEOGRAPH
    { 0x9E78, 0x681E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E79, 0x6846 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E7A, 0x6829 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E7B, 0x6840 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E7C, 0x684D }, // CJK UNIFIED IDEOGRAPH
    { 0x9E7D, 0x6832 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E7E, 0x684E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E80, 0x68B3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E81, 0x682B }, // CJK UNIFIED IDEOGRAPH
    { 0x9E82, 0x6859 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E83, 0x6863 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E84, 0x6877 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E85, 0x687F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E86, 0x689F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E87, 0x688F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E88, 0x68AD }, // CJK UNIFIED IDEOGRAPH
    { 0x9E89, 0x6894 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8A, 0x689D }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8B, 0x689B }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8C, 0x6883 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8D, 0x6AAE }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8E, 0x68B9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E8F, 0x6874 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E90, 0x68B5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E91, 0x68A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E92, 0x68BA }, // CJK UNIFIED IDEOGRAPH
    { 0x9E93, 0x690F }, // CJK UNIFIED IDEOGRAPH
    { 0x9E94, 0x688D }, // CJK UNIFIED IDEOGRAPH
    { 0x9E95, 0x687E }, // CJK UNIFIED IDEOGRAPH
    { 0x9E96, 0x6901 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E97, 0x68CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9E98, 0x6908 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E99, 0x68D8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9A, 0x6922 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9B, 0x6926 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9C, 0x68E1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9D, 0x690C }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9E, 0x68CD }, // CJK UNIFIED IDEOGRAPH
    { 0x9E9F, 0x68D4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA0, 0x68E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA1, 0x68D5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA2, 0x6936 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA3, 0x6912 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA4, 0x6904 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA5, 0x68D7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA6, 0x68E3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA7, 0x6925 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA8, 0x68F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EA9, 0x68E0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAA, 0x68EF }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAB, 0x6928 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAC, 0x692A }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAD, 0x691A }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAE, 0x6923 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EAF, 0x6921 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB0, 0x68C6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB1, 0x6979 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB2, 0x6977 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB3, 0x695C }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB4, 0x6978 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB5, 0x696B }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB6, 0x6954 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB7, 0x697E }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB8, 0x696E }, // CJK UNIFIED IDEOGRAPH
    { 0x9EB9, 0x6939 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBA, 0x6974 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBB, 0x693D }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBC, 0x6959 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBD, 0x6930 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBE, 0x6961 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EBF, 0x695E }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC0, 0x695D }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC1, 0x6981 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC2, 0x696A }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC3, 0x69B2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC4, 0x69AE }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC5, 0x69D0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC6, 0x69BF }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC7, 0x69C1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC8, 0x69D3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EC9, 0x69BE }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECA, 0x69CE }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECB, 0x5BE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECC, 0x69CA }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECD, 0x69DD }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECE, 0x69BB }, // CJK UNIFIED IDEOGRAPH
    { 0x9ECF, 0x69C3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED0, 0x69A7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED1, 0x6A2E }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED2, 0x6991 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED3, 0x69A0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED4, 0x699C }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED5, 0x6995 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED6, 0x69B4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED7, 0x69DE }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED8, 0x69E8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9ED9, 0x6A02 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDA, 0x6A1B }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDB, 0x69FF }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDC, 0x6B0A }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDD, 0x69F9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDE, 0x69F2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EDF, 0x69E7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE0, 0x6A05 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE1, 0x69B1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE2, 0x6A1E }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE3, 0x69ED }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE4, 0x6A14 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE5, 0x69EB }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE6, 0x6A0A }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE7, 0x6A12 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE8, 0x6AC1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EE9, 0x6A23 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EEA, 0x6A13 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EEB, 0x6A44 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EEC, 0x6A0C }, // CJK UNIFIED IDEOGRAPH
    { 0x9EED, 0x6A72 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EEE, 0x6A36 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EEF, 0x6A78 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF0, 0x6A47 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF1, 0x6A62 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF2, 0x6A59 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF3, 0x6A66 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF4, 0x6A48 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF5, 0x6A38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF6, 0x6A22 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF7, 0x6A90 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF8, 0x6A8D }, // CJK UNIFIED IDEOGRAPH
    { 0x9EF9, 0x6AA0 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EFA, 0x6A84 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EFB, 0x6AA2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9EFC, 0x6AA3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F40, 0x6A97 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F41, 0x8617 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F42, 0x6ABB }, // CJK UNIFIED IDEOGRAPH
    { 0x9F43, 0x6AC3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F44, 0x6AC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F45, 0x6AB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F46, 0x6AB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F47, 0x6AAC }, // CJK UNIFIED IDEOGRAPH
    { 0x9F48, 0x6ADE }, // CJK UNIFIED IDEOGRAPH
    { 0x9F49, 0x6AD1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4A, 0x6ADF }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4B, 0x6AAA }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4C, 0x6ADA }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4D, 0x6AEA }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4E, 0x6AFB }, // CJK UNIFIED IDEOGRAPH
    { 0x9F4F, 0x6B05 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F50, 0x8616 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F51, 0x6AFA }, // CJK UNIFIED IDEOGRAPH
    { 0x9F52, 0x6B12 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F53, 0x6B16 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F54, 0x9B31 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F55, 0x6B1F }, // CJK UNIFIED IDEOGRAPH
    { 0x9F56, 0x6B38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F57, 0x6B37 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F58, 0x76DC }, // CJK UNIFIED IDEOGRAPH
    { 0x9F59, 0x6B39 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5A, 0x98EE }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5B, 0x6B47 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5C, 0x6B43 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5D, 0x6B49 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5E, 0x6B50 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F5F, 0x6B59 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F60, 0x6B54 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F61, 0x6B5B }, // CJK UNIFIED IDEOGRAPH
    { 0x9F62, 0x6B5F }, // CJK UNIFIED IDEOGRAPH
    { 0x9F63, 0x6B61 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F64, 0x6B78 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F65, 0x6B79 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F66, 0x6B7F }, // CJK UNIFIED IDEOGRAPH
    { 0x9F67, 0x6B80 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F68, 0x6B84 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F69, 0x6B83 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6A, 0x6B8D }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6B, 0x6B98 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6C, 0x6B95 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6D, 0x6B9E }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6E, 0x6BA4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F6F, 0x6BAA }, // CJK UNIFIED IDEOGRAPH
    { 0x9F70, 0x6BAB }, // CJK UNIFIED IDEOGRAPH
    { 0x9F71, 0x6BAF }, // CJK UNIFIED IDEOGRAPH
    { 0x9F72, 0x6BB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F73, 0x6BB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F74, 0x6BB3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F75, 0x6BB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F76, 0x6BBC }, // CJK UNIFIED IDEOGRAPH
    { 0x9F77, 0x6BC6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F78, 0x6BCB }, // CJK UNIFIED IDEOGRAPH
    { 0x9F79, 0x6BD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F7A, 0x6BDF }, // CJK UNIFIED IDEOGRAPH
    { 0x9F7B, 0x6BEC }, // CJK UNIFIED IDEOGRAPH
    { 0x9F7C, 0x6BEB }, // CJK UNIFIED IDEOGRAPH
    { 0x9F7D, 0x6BF3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F7E, 0x6BEF }, // CJK UNIFIED IDEOGRAPH
    { 0x9F80, 0x9EBE }, // CJK UNIFIED IDEOGRAPH
    { 0x9F81, 0x6C08 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F82, 0x6C13 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F83, 0x6C14 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F84, 0x6C1B }, // CJK UNIFIED IDEOGRAPH
    { 0x9F85, 0x6C24 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F86, 0x6C23 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F87, 0x6C5E }, // CJK UNIFIED IDEOGRAPH
    { 0x9F88, 0x6C55 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F89, 0x6C62 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8A, 0x6C6A }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8B, 0x6C82 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8C, 0x6C8D }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8D, 0x6C9A }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8E, 0x6C81 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F8F, 0x6C9B }, // CJK UNIFIED IDEOGRAPH
    { 0x9F90, 0x6C7E }, // CJK UNIFIED IDEOGRAPH
    { 0x9F91, 0x6C68 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F92, 0x6C73 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F93, 0x6C92 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F94, 0x6C90 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F95, 0x6CC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F96, 0x6CF1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F97, 0x6CD3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F98, 0x6CBD }, // CJK UNIFIED IDEOGRAPH
    { 0x9F99, 0x6CD7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9A, 0x6CC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9B, 0x6CDD }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9C, 0x6CAE }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9D, 0x6CB1 }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9E, 0x6CBE }, // CJK UNIFIED IDEOGRAPH
    { 0x9F9F, 0x6CBA }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA0, 0x6CDB }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA1, 0x6CEF }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA2, 0x6CD9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA3, 0x6CEA }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA4, 0x6D1F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA5, 0x884D }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA6, 0x6D36 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA7, 0x6D2B }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA8, 0x6D3D }, // CJK UNIFIED IDEOGRAPH
    { 0x9FA9, 0x6D38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAA, 0x6D19 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAB, 0x6D35 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAC, 0x6D33 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAD, 0x6D12 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAE, 0x6D0C }, // CJK UNIFIED IDEOGRAPH
    { 0x9FAF, 0x6D63 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB0, 0x6D93 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB1, 0x6D64 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB2, 0x6D5A }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB3, 0x6D79 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB4, 0x6D59 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB5, 0x6D8E }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB6, 0x6D95 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB7, 0x6FE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB8, 0x6D85 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FB9, 0x6DF9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBA, 0x6E15 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBB, 0x6E0A }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBC, 0x6DB5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBD, 0x6DC7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBE, 0x6DE6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FBF, 0x6DB8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC0, 0x6DC6 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC1, 0x6DEC }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC2, 0x6DDE }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC3, 0x6DCC }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC4, 0x6DE8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC5, 0x6DD2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC6, 0x6DC5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC7, 0x6DFA }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC8, 0x6DD9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FC9, 0x6DE4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCA, 0x6DD5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCB, 0x6DEA }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCC, 0x6DEE }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCD, 0x6E2D }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCE, 0x6E6E }, // CJK UNIFIED IDEOGRAPH
    { 0x9FCF, 0x6E2E }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD0, 0x6E19 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD1, 0x6E72 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD2, 0x6E5F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD3, 0x6E3E }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD4, 0x6E23 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD5, 0x6E6B }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD6, 0x6E2B }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD7, 0x6E76 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD8, 0x6E4D }, // CJK UNIFIED IDEOGRAPH
    { 0x9FD9, 0x6E1F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDA, 0x6E43 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDB, 0x6E3A }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDC, 0x6E4E }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDD, 0x6E24 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDE, 0x6EFF }, // CJK UNIFIED IDEOGRAPH
    { 0x9FDF, 0x6E1D }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE0, 0x6E38 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE1, 0x6E82 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE2, 0x6EAA }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE3, 0x6E98 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE4, 0x6EC9 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE5, 0x6EB7 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE6, 0x6ED3 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE7, 0x6EBD }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE8, 0x6EAF }, // CJK UNIFIED IDEOGRAPH
    { 0x9FE9, 0x6EC4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FEA, 0x6EB2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FEB, 0x6ED4 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FEC, 0x6ED5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FED, 0x6E8F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FEE, 0x6EA5 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FEF, 0x6EC2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF0, 0x6E9F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF1, 0x6F41 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF2, 0x6F11 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF3, 0x704C }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF4, 0x6EEC }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF5, 0x6EF8 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF6, 0x6EFE }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF7, 0x6F3F }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF8, 0x6EF2 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FF9, 0x6F31 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FFA, 0x6EEF }, // CJK UNIFIED IDEOGRAPH
    { 0x9FFB, 0x6F32 }, // CJK UNIFIED IDEOGRAPH
    { 0x9FFC, 0x6ECC }, // CJK UNIFIED IDEOGRAPH
    { 0xE040, 0x6F3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE041, 0x6F13 }, // CJK UNIFIED IDEOGRAPH
    { 0xE042, 0x6EF7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE043, 0x6F86 }, // CJK UNIFIED IDEOGRAPH
    { 0xE044, 0x6F7A }, // CJK UNIFIED IDEOGRAPH
    { 0xE045, 0x6F78 }, // CJK UNIFIED IDEOGRAPH
    { 0xE046, 0x6F81 }, // CJK UNIFIED IDEOGRAPH
    { 0xE047, 0x6F80 }, // CJK UNIFIED IDEOGRAPH
    { 0xE048, 0x6F6F }, // CJK UNIFIED IDEOGRAPH
    { 0xE049, 0x6F5B }, // CJK UNIFIED IDEOGRAPH
    { 0xE04A, 0x6FF3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE04B, 0x6F6D }, // CJK UNIFIED IDEOGRAPH
    { 0xE04C, 0x6F82 }, // CJK UNIFIED IDEOGRAPH
    { 0xE04D, 0x6F7C }, // CJK UNIFIED IDEOGRAPH
    { 0xE04E, 0x6F58 }, // CJK UNIFIED IDEOGRAPH
    { 0xE04F, 0x6F8E }, // CJK UNIFIED IDEOGRAPH
    { 0xE050, 0x6F91 }, // CJK UNIFIED IDEOGRAPH
    { 0xE051, 0x6FC2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE052, 0x6F66 }, // CJK UNIFIED IDEOGRAPH
    { 0xE053, 0x6FB3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE054, 0x6FA3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE055, 0x6FA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE056, 0x6FA4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE057, 0x6FB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE058, 0x6FC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE059, 0x6FAA }, // CJK UNIFIED IDEOGRAPH
    { 0xE05A, 0x6FDF }, // CJK UNIFIED IDEOGRAPH
    { 0xE05B, 0x6FD5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE05C, 0x6FEC }, // CJK UNIFIED IDEOGRAPH
    { 0xE05D, 0x6FD4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE05E, 0x6FD8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE05F, 0x6FF1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE060, 0x6FEE }, // CJK UNIFIED IDEOGRAPH
    { 0xE061, 0x6FDB }, // CJK UNIFIED IDEOGRAPH
    { 0xE062, 0x7009 }, // CJK UNIFIED IDEOGRAPH
    { 0xE063, 0x700B }, // CJK UNIFIED IDEOGRAPH
    { 0xE064, 0x6FFA }, // CJK UNIFIED IDEOGRAPH
    { 0xE065, 0x7011 }, // CJK UNIFIED IDEOGRAPH
    { 0xE066, 0x7001 }, // CJK UNIFIED IDEOGRAPH
    { 0xE067, 0x700F }, // CJK UNIFIED IDEOGRAPH
    { 0xE068, 0x6FFE }, // CJK UNIFIED IDEOGRAPH
    { 0xE069, 0x701B }, // CJK UNIFIED IDEOGRAPH
    { 0xE06A, 0x701A }, // CJK UNIFIED IDEOGRAPH
    { 0xE06B, 0x6F74 }, // CJK UNIFIED IDEOGRAPH
    { 0xE06C, 0x701D }, // CJK UNIFIED IDEOGRAPH
    { 0xE06D, 0x7018 }, // CJK UNIFIED IDEOGRAPH
    { 0xE06E, 0x701F }, // CJK UNIFIED IDEOGRAPH
    { 0xE06F, 0x7030 }, // CJK UNIFIED IDEOGRAPH
    { 0xE070, 0x703E }, // CJK UNIFIED IDEOGRAPH
    { 0xE071, 0x7032 }, // CJK UNIFIED IDEOGRAPH
    { 0xE072, 0x7051 }, // CJK UNIFIED IDEOGRAPH
    { 0xE073, 0x7063 }, // CJK UNIFIED IDEOGRAPH
    { 0xE074, 0x7099 }, // CJK UNIFIED IDEOGRAPH
    { 0xE075, 0x7092 }, // CJK UNIFIED IDEOGRAPH
    { 0xE076, 0x70AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE077, 0x70F1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE078, 0x70AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE079, 0x70B8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE07A, 0x70B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE07B, 0x70AE }, // CJK UNIFIED IDEOGRAPH
    { 0xE07C, 0x70DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE07D, 0x70CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE07E, 0x70DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE080, 0x70D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE081, 0x7109 }, // CJK UNIFIED IDEOGRAPH
    { 0xE082, 0x70FD }, // CJK UNIFIED IDEOGRAPH
    { 0xE083, 0x711C }, // CJK UNIFIED IDEOGRAPH
    { 0xE084, 0x7119 }, // CJK UNIFIED IDEOGRAPH
    { 0xE085, 0x7165 }, // CJK UNIFIED IDEOGRAPH
    { 0xE086, 0x7155 }, // CJK UNIFIED IDEOGRAPH
    { 0xE087, 0x7188 }, // CJK UNIFIED IDEOGRAPH
    { 0xE088, 0x7166 }, // CJK UNIFIED IDEOGRAPH
    { 0xE089, 0x7162 }, // CJK UNIFIED IDEOGRAPH
    { 0xE08A, 0x714C }, // CJK UNIFIED IDEOGRAPH
    { 0xE08B, 0x7156 }, // CJK UNIFIED IDEOGRAPH
    { 0xE08C, 0x716C }, // CJK UNIFIED IDEOGRAPH
    { 0xE08D, 0x718F }, // CJK UNIFIED IDEOGRAPH
    { 0xE08E, 0x71FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE08F, 0x7184 }, // CJK UNIFIED IDEOGRAPH
    { 0xE090, 0x7195 }, // CJK UNIFIED IDEOGRAPH
    { 0xE091, 0x71A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE092, 0x71AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE093, 0x71D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE094, 0x71B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE095, 0x71BE }, // CJK UNIFIED IDEOGRAPH
    { 0xE096, 0x71D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE097, 0x71C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE098, 0x71D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE099, 0x71CE }, // CJK UNIFIED IDEOGRAPH
    { 0xE09A, 0x71E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE09B, 0x71EC }, // CJK UNIFIED IDEOGRAPH
    { 0xE09C, 0x71E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE09D, 0x71F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE09E, 0x71FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE09F, 0x71F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A0, 0x71FF }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A1, 0x720D }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A2, 0x7210 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A3, 0x721B }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A4, 0x7228 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A5, 0x722D }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A6, 0x722C }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A7, 0x7230 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A8, 0x7232 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0A9, 0x723B }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AA, 0x723C }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AB, 0x723F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AC, 0x7240 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AD, 0x7246 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AE, 0x724B }, // CJK UNIFIED IDEOGRAPH
    { 0xE0AF, 0x7258 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B0, 0x7274 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B1, 0x727E }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B2, 0x7282 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B3, 0x7281 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B4, 0x7287 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B5, 0x7292 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B6, 0x7296 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B7, 0x72A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B8, 0x72A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0B9, 0x72B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BA, 0x72B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BB, 0x72C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BC, 0x72C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BD, 0x72C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BE, 0x72CE }, // CJK UNIFIED IDEOGRAPH
    { 0xE0BF, 0x72D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C0, 0x72E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C1, 0x72E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C2, 0x72E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C3, 0x72F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C4, 0x72F7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C5, 0x500F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C6, 0x7317 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C7, 0x730A }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C8, 0x731C }, // CJK UNIFIED IDEOGRAPH
    { 0xE0C9, 0x7316 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CA, 0x731D }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CB, 0x7334 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CC, 0x732F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CD, 0x7329 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CE, 0x7325 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0CF, 0x733E }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D0, 0x734E }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D1, 0x734F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D2, 0x9ED8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D3, 0x7357 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D4, 0x736A }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D5, 0x7368 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D6, 0x7370 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D7, 0x7378 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D8, 0x7375 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0D9, 0x737B }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DA, 0x737A }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DB, 0x73C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DC, 0x73B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DD, 0x73CE }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DE, 0x73BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE0DF, 0x73C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E0, 0x73E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E1, 0x73EE }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E2, 0x73DE }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E3, 0x74A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E4, 0x7405 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E5, 0x746F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E6, 0x7425 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E7, 0x73F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E8, 0x7432 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0E9, 0x743A }, // CJK UNIFIED IDEOGRAPH
    { 0xE0EA, 0x7455 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0EB, 0x743F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0EC, 0x745F }, // CJK UNIFIED IDEOGRAPH
    { 0xE0ED, 0x7459 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0EE, 0x7441 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0EF, 0x745C }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F0, 0x7469 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F1, 0x7470 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F2, 0x7463 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F3, 0x746A }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F4, 0x7476 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F5, 0x747E }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F6, 0x748B }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F7, 0x749E }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F8, 0x74A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0F9, 0x74CA }, // CJK UNIFIED IDEOGRAPH
    { 0xE0FA, 0x74CF }, // CJK UNIFIED IDEOGRAPH
    { 0xE0FB, 0x74D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE0FC, 0x73F1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE140, 0x74E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE141, 0x74E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE142, 0x74E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE143, 0x74E9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE144, 0x74EE }, // CJK UNIFIED IDEOGRAPH
    { 0xE145, 0x74F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE146, 0x74F0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE147, 0x74F1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE148, 0x74F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE149, 0x74F7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE14A, 0x7504 }, // CJK UNIFIED IDEOGRAPH
    { 0xE14B, 0x7503 }, // CJK UNIFIED IDEOGRAPH
    { 0xE14C, 0x7505 }, // CJK UNIFIED IDEOGRAPH
    { 0xE14D, 0x750C }, // CJK UNIFIED IDEOGRAPH
    { 0xE14E, 0x750E }, // CJK UNIFIED IDEOGRAPH
    { 0xE14F, 0x750D }, // CJK UNIFIED IDEOGRAPH
    { 0xE150, 0x7515 }, // CJK UNIFIED IDEOGRAPH
    { 0xE151, 0x7513 }, // CJK UNIFIED IDEOGRAPH
    { 0xE152, 0x751E }, // CJK UNIFIED IDEOGRAPH
    { 0xE153, 0x7526 }, // CJK UNIFIED IDEOGRAPH
    { 0xE154, 0x752C }, // CJK UNIFIED IDEOGRAPH
    { 0xE155, 0x753C }, // CJK UNIFIED IDEOGRAPH
    { 0xE156, 0x7544 }, // CJK UNIFIED IDEOGRAPH
    { 0xE157, 0x754D }, // CJK UNIFIED IDEOGRAPH
    { 0xE158, 0x754A }, // CJK UNIFIED IDEOGRAPH
    { 0xE159, 0x7549 }, // CJK UNIFIED IDEOGRAPH
    { 0xE15A, 0x755B }, // CJK UNIFIED IDEOGRAPH
    { 0xE15B, 0x7546 }, // CJK UNIFIED IDEOGRAPH
    { 0xE15C, 0x755A }, // CJK UNIFIED IDEOGRAPH
    { 0xE15D, 0x7569 }, // CJK UNIFIED IDEOGRAPH
    { 0xE15E, 0x7564 }, // CJK UNIFIED IDEOGRAPH
    { 0xE15F, 0x7567 }, // CJK UNIFIED IDEOGRAPH
    { 0xE160, 0x756B }, // CJK UNIFIED IDEOGRAPH
    { 0xE161, 0x756D }, // CJK UNIFIED IDEOGRAPH
    { 0xE162, 0x7578 }, // CJK UNIFIED IDEOGRAPH
    { 0xE163, 0x7576 }, // CJK UNIFIED IDEOGRAPH
    { 0xE164, 0x7586 }, // CJK UNIFIED IDEOGRAPH
    { 0xE165, 0x7587 }, // CJK UNIFIED IDEOGRAPH
    { 0xE166, 0x7574 }, // CJK UNIFIED IDEOGRAPH
    { 0xE167, 0x758A }, // CJK UNIFIED IDEOGRAPH
    { 0xE168, 0x7589 }, // CJK UNIFIED IDEOGRAPH
    { 0xE169, 0x7582 }, // CJK UNIFIED IDEOGRAPH
    { 0xE16A, 0x7594 }, // CJK UNIFIED IDEOGRAPH
    { 0xE16B, 0x759A }, // CJK UNIFIED IDEOGRAPH
    { 0xE16C, 0x759D }, // CJK UNIFIED IDEOGRAPH
    { 0xE16D, 0x75A5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE16E, 0x75A3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE16F, 0x75C2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE170, 0x75B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE171, 0x75C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE172, 0x75B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE173, 0x75BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE174, 0x75B8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE175, 0x75BC }, // CJK UNIFIED IDEOGRAPH
    { 0xE176, 0x75B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE177, 0x75CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE178, 0x75CA }, // CJK UNIFIED IDEOGRAPH
    { 0xE179, 0x75D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE17A, 0x75D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE17B, 0x75E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE17C, 0x75DE }, // CJK UNIFIED IDEOGRAPH
    { 0xE17D, 0x75FE }, // CJK UNIFIED IDEOGRAPH
    { 0xE17E, 0x75FF }, // CJK UNIFIED IDEOGRAPH
    { 0xE180, 0x75FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE181, 0x7601 }, // CJK UNIFIED IDEOGRAPH
    { 0xE182, 0x75F0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE183, 0x75FA }, // CJK UNIFIED IDEOGRAPH
    { 0xE184, 0x75F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE185, 0x75F3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE186, 0x760B }, // CJK UNIFIED IDEOGRAPH
    { 0xE187, 0x760D }, // CJK UNIFIED IDEOGRAPH
    { 0xE188, 0x7609 }, // CJK UNIFIED IDEOGRAPH
    { 0xE189, 0x761F }, // CJK UNIFIED IDEOGRAPH
    { 0xE18A, 0x7627 }, // CJK UNIFIED IDEOGRAPH
    { 0xE18B, 0x7620 }, // CJK UNIFIED IDEOGRAPH
    { 0xE18C, 0x7621 }, // CJK UNIFIED IDEOGRAPH
    { 0xE18D, 0x7622 }, // CJK UNIFIED IDEOGRAPH
    { 0xE18E, 0x7624 }, // CJK UNIFIED IDEOGRAPH
    { 0xE18F, 0x7634 }, // CJK UNIFIED IDEOGRAPH
    { 0xE190, 0x7630 }, // CJK UNIFIED IDEOGRAPH
    { 0xE191, 0x763B }, // CJK UNIFIED IDEOGRAPH
    { 0xE192, 0x7647 }, // CJK UNIFIED IDEOGRAPH
    { 0xE193, 0x7648 }, // CJK UNIFIED IDEOGRAPH
    { 0xE194, 0x7646 }, // CJK UNIFIED IDEOGRAPH
    { 0xE195, 0x765C }, // CJK UNIFIED IDEOGRAPH
    { 0xE196, 0x7658 }, // CJK UNIFIED IDEOGRAPH
    { 0xE197, 0x7661 }, // CJK UNIFIED IDEOGRAPH
    { 0xE198, 0x7662 }, // CJK UNIFIED IDEOGRAPH
    { 0xE199, 0x7668 }, // CJK UNIFIED IDEOGRAPH
    { 0xE19A, 0x7669 }, // CJK UNIFIED IDEOGRAPH
    { 0xE19B, 0x766A }, // CJK UNIFIED IDEOGRAPH
    { 0xE19C, 0x7667 }, // CJK UNIFIED IDEOGRAPH
    { 0xE19D, 0x766C }, // CJK UNIFIED IDEOGRAPH
    { 0xE19E, 0x7670 }, // CJK UNIFIED IDEOGRAPH
    { 0xE19F, 0x7672 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A0, 0x7676 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A1, 0x7678 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A2, 0x767C }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A3, 0x7680 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A4, 0x7683 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A5, 0x7688 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A6, 0x768B }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A7, 0x768E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A8, 0x7696 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1A9, 0x7693 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AA, 0x7699 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AB, 0x769A }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AC, 0x76B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AD, 0x76B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AE, 0x76B8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1AF, 0x76B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B0, 0x76BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B1, 0x76C2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B2, 0x76CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B3, 0x76D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B4, 0x76D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B5, 0x76DE }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B6, 0x76E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B7, 0x76E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B8, 0x76E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1B9, 0x76EA }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BA, 0x862F }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BB, 0x76FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BC, 0x7708 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BD, 0x7707 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BE, 0x7704 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1BF, 0x7729 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C0, 0x7724 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C1, 0x771E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C2, 0x7725 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C3, 0x7726 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C4, 0x771B }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C5, 0x7737 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C6, 0x7738 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C7, 0x7747 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C8, 0x775A }, // CJK UNIFIED IDEOGRAPH
    { 0xE1C9, 0x7768 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CA, 0x776B }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CB, 0x775B }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CC, 0x7765 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CD, 0x777F }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CE, 0x777E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1CF, 0x7779 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D0, 0x778E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D1, 0x778B }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D2, 0x7791 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D3, 0x77A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D4, 0x779E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D5, 0x77B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D6, 0x77B6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D7, 0x77B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D8, 0x77BF }, // CJK UNIFIED IDEOGRAPH
    { 0xE1D9, 0x77BC }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DA, 0x77BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DB, 0x77BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DC, 0x77C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DD, 0x77CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DE, 0x77D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1DF, 0x77DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E0, 0x77DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E1, 0x77E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E2, 0x77EE }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E3, 0x77FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E4, 0x780C }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E5, 0x7812 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E6, 0x7926 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E7, 0x7820 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E8, 0x792A }, // CJK UNIFIED IDEOGRAPH
    { 0xE1E9, 0x7845 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1EA, 0x788E }, // CJK UNIFIED IDEOGRAPH
    { 0xE1EB, 0x7874 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1EC, 0x7886 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1ED, 0x787C }, // CJK UNIFIED IDEOGRAPH
    { 0xE1EE, 0x789A }, // CJK UNIFIED IDEOGRAPH
    { 0xE1EF, 0x788C }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F0, 0x78A3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F1, 0x78B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F2, 0x78AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F3, 0x78AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F4, 0x78D1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F5, 0x78C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F6, 0x78CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F7, 0x78D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F8, 0x78BE }, // CJK UNIFIED IDEOGRAPH
    { 0xE1F9, 0x78BC }, // CJK UNIFIED IDEOGRAPH
    { 0xE1FA, 0x78C5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE1FB, 0x78CA }, // CJK UNIFIED IDEOGRAPH
    { 0xE1FC, 0x78EC }, // CJK UNIFIED IDEOGRAPH
    { 0xE240, 0x78E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE241, 0x78DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE242, 0x78FD }, // CJK UNIFIED IDEOGRAPH
    { 0xE243, 0x78F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE244, 0x7907 }, // CJK UNIFIED IDEOGRAPH
    { 0xE245, 0x7912 }, // CJK UNIFIED IDEOGRAPH
    { 0xE246, 0x7911 }, // CJK UNIFIED IDEOGRAPH
    { 0xE247, 0x7919 }, // CJK UNIFIED IDEOGRAPH
    { 0xE248, 0x792C }, // CJK UNIFIED IDEOGRAPH
    { 0xE249, 0x792B }, // CJK UNIFIED IDEOGRAPH
    { 0xE24A, 0x7940 }, // CJK UNIFIED IDEOGRAPH
    { 0xE24B, 0x7960 }, // CJK UNIFIED IDEOGRAPH
    { 0xE24C, 0x7957 }, // CJK UNIFIED IDEOGRAPH
    { 0xE24D, 0x795F }, // CJK UNIFIED IDEOGRAPH
    { 0xE24E, 0x795A }, // CJK UNIFIED IDEOGRAPH
    { 0xE24F, 0x7955 }, // CJK UNIFIED IDEOGRAPH
    { 0xE250, 0x7953 }, // CJK UNIFIED IDEOGRAPH
    { 0xE251, 0x797A }, // CJK UNIFIED IDEOGRAPH
    { 0xE252, 0x797F }, // CJK UNIFIED IDEOGRAPH
    { 0xE253, 0x798A }, // CJK UNIFIED IDEOGRAPH
    { 0xE254, 0x799D }, // CJK UNIFIED IDEOGRAPH
    { 0xE255, 0x79A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE256, 0x9F4B }, // CJK UNIFIED IDEOGRAPH
    { 0xE257, 0x79AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE258, 0x79AE }, // CJK UNIFIED IDEOGRAPH
    { 0xE259, 0x79B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE25A, 0x79B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE25B, 0x79BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE25C, 0x79C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE25D, 0x79D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE25E, 0x79E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE25F, 0x79EC }, // CJK UNIFIED IDEOGRAPH
    { 0xE260, 0x79E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE261, 0x79E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE262, 0x7A08 }, // CJK UNIFIED IDEOGRAPH
    { 0xE263, 0x7A0D }, // CJK UNIFIED IDEOGRAPH
    { 0xE264, 0x7A18 }, // CJK UNIFIED IDEOGRAPH
    { 0xE265, 0x7A19 }, // CJK UNIFIED IDEOGRAPH
    { 0xE266, 0x7A20 }, // CJK UNIFIED IDEOGRAPH
    { 0xE267, 0x7A1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE268, 0x7980 }, // CJK UNIFIED IDEOGRAPH
    { 0xE269, 0x7A31 }, // CJK UNIFIED IDEOGRAPH
    { 0xE26A, 0x7A3B }, // CJK UNIFIED IDEOGRAPH
    { 0xE26B, 0x7A3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE26C, 0x7A37 }, // CJK UNIFIED IDEOGRAPH
    { 0xE26D, 0x7A43 }, // CJK UNIFIED IDEOGRAPH
    { 0xE26E, 0x7A57 }, // CJK UNIFIED IDEOGRAPH
    { 0xE26F, 0x7A49 }, // CJK UNIFIED IDEOGRAPH
    { 0xE270, 0x7A61 }, // CJK UNIFIED IDEOGRAPH
    { 0xE271, 0x7A62 }, // CJK UNIFIED IDEOGRAPH
    { 0xE272, 0x7A69 }, // CJK UNIFIED IDEOGRAPH
    { 0xE273, 0x9F9D }, // CJK UNIFIED IDEOGRAPH
    { 0xE274, 0x7A70 }, // CJK UNIFIED IDEOGRAPH
    { 0xE275, 0x7A79 }, // CJK UNIFIED IDEOGRAPH
    { 0xE276, 0x7A7D }, // CJK UNIFIED IDEOGRAPH
    { 0xE277, 0x7A88 }, // CJK UNIFIED IDEOGRAPH
    { 0xE278, 0x7A97 }, // CJK UNIFIED IDEOGRAPH
    { 0xE279, 0x7A95 }, // CJK UNIFIED IDEOGRAPH
    { 0xE27A, 0x7A98 }, // CJK UNIFIED IDEOGRAPH
    { 0xE27B, 0x7A96 }, // CJK UNIFIED IDEOGRAPH
    { 0xE27C, 0x7AA9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE27D, 0x7AC8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE27E, 0x7AB0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE280, 0x7AB6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE281, 0x7AC5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE282, 0x7AC4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE283, 0x7ABF }, // CJK UNIFIED IDEOGRAPH
    { 0xE284, 0x9083 }, // CJK UNIFIED IDEOGRAPH
    { 0xE285, 0x7AC7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE286, 0x7ACA }, // CJK UNIFIED IDEOGRAPH
    { 0xE287, 0x7ACD }, // CJK UNIFIED IDEOGRAPH
    { 0xE288, 0x7ACF }, // CJK UNIFIED IDEOGRAPH
    { 0xE289, 0x7AD5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE28A, 0x7AD3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE28B, 0x7AD9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE28C, 0x7ADA }, // CJK UNIFIED IDEOGRAPH
    { 0xE28D, 0x7ADD }, // CJK UNIFIED IDEOGRAPH
    { 0xE28E, 0x7AE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE28F, 0x7AE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE290, 0x7AE6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE291, 0x7AED }, // CJK UNIFIED IDEOGRAPH
    { 0xE292, 0x7AF0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE293, 0x7B02 }, // CJK UNIFIED IDEOGRAPH
    { 0xE294, 0x7B0F }, // CJK UNIFIED IDEOGRAPH
    { 0xE295, 0x7B0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE296, 0x7B06 }, // CJK UNIFIED IDEOGRAPH
    { 0xE297, 0x7B33 }, // CJK UNIFIED IDEOGRAPH
    { 0xE298, 0x7B18 }, // CJK UNIFIED IDEOGRAPH
    { 0xE299, 0x7B19 }, // CJK UNIFIED IDEOGRAPH
    { 0xE29A, 0x7B1E }, // CJK UNIFIED IDEOGRAPH
    { 0xE29B, 0x7B35 }, // CJK UNIFIED IDEOGRAPH
    { 0xE29C, 0x7B28 }, // CJK UNIFIED IDEOGRAPH
    { 0xE29D, 0x7B36 }, // CJK UNIFIED IDEOGRAPH
    { 0xE29E, 0x7B50 }, // CJK UNIFIED IDEOGRAPH
    { 0xE29F, 0x7B7A }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A0, 0x7B04 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A1, 0x7B4D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A2, 0x7B0B }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A3, 0x7B4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A4, 0x7B45 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A5, 0x7B75 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A6, 0x7B65 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A7, 0x7B74 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A8, 0x7B67 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2A9, 0x7B70 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AA, 0x7B71 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AB, 0x7B6C }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AC, 0x7B6E }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AD, 0x7B9D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AE, 0x7B98 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2AF, 0x7B9F }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B0, 0x7B8D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B1, 0x7B9C }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B2, 0x7B9A }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B3, 0x7B8B }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B4, 0x7B92 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B5, 0x7B8F }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B6, 0x7B5D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B7, 0x7B99 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B8, 0x7BCB }, // CJK UNIFIED IDEOGRAPH
    { 0xE2B9, 0x7BC1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BA, 0x7BCC }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BB, 0x7BCF }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BC, 0x7BB4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BD, 0x7BC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BE, 0x7BDD }, // CJK UNIFIED IDEOGRAPH
    { 0xE2BF, 0x7BE9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C0, 0x7C11 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C1, 0x7C14 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C2, 0x7BE6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C3, 0x7BE5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C4, 0x7C60 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C5, 0x7C00 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C6, 0x7C07 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C7, 0x7C13 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C8, 0x7BF3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2C9, 0x7BF7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CA, 0x7C17 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CB, 0x7C0D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CC, 0x7BF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CD, 0x7C23 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CE, 0x7C27 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2CF, 0x7C2A }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D0, 0x7C1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D1, 0x7C37 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D2, 0x7C2B }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D3, 0x7C3D }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D4, 0x7C4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D5, 0x7C43 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D6, 0x7C54 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D7, 0x7C4F }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D8, 0x7C40 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2D9, 0x7C50 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DA, 0x7C58 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DB, 0x7C5F }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DC, 0x7C64 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DD, 0x7C56 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DE, 0x7C65 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2DF, 0x7C6C }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E0, 0x7C75 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E1, 0x7C83 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E2, 0x7C90 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E3, 0x7CA4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E4, 0x7CAD }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E5, 0x7CA2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E6, 0x7CAB }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E7, 0x7CA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E8, 0x7CA8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2E9, 0x7CB3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2EA, 0x7CB2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2EB, 0x7CB1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2EC, 0x7CAE }, // CJK UNIFIED IDEOGRAPH
    { 0xE2ED, 0x7CB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2EE, 0x7CBD }, // CJK UNIFIED IDEOGRAPH
    { 0xE2EF, 0x7CC0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F0, 0x7CC5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F1, 0x7CC2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F2, 0x7CD8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F3, 0x7CD2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F4, 0x7CDC }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F5, 0x7CE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F6, 0x9B3B }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F7, 0x7CEF }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F8, 0x7CF2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2F9, 0x7CF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2FA, 0x7CF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE2FB, 0x7CFA }, // CJK UNIFIED IDEOGRAPH
    { 0xE2FC, 0x7D06 }, // CJK UNIFIED IDEOGRAPH
    { 0xE340, 0x7D02 }, // CJK UNIFIED IDEOGRAPH
    { 0xE341, 0x7D1C }, // CJK UNIFIED IDEOGRAPH
    { 0xE342, 0x7D15 }, // CJK UNIFIED IDEOGRAPH
    { 0xE343, 0x7D0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE344, 0x7D45 }, // CJK UNIFIED IDEOGRAPH
    { 0xE345, 0x7D4B }, // CJK UNIFIED IDEOGRAPH
    { 0xE346, 0x7D2E }, // CJK UNIFIED IDEOGRAPH
    { 0xE347, 0x7D32 }, // CJK UNIFIED IDEOGRAPH
    { 0xE348, 0x7D3F }, // CJK UNIFIED IDEOGRAPH
    { 0xE349, 0x7D35 }, // CJK UNIFIED IDEOGRAPH
    { 0xE34A, 0x7D46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE34B, 0x7D73 }, // CJK UNIFIED IDEOGRAPH
    { 0xE34C, 0x7D56 }, // CJK UNIFIED IDEOGRAPH
    { 0xE34D, 0x7D4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE34E, 0x7D72 }, // CJK UNIFIED IDEOGRAPH
    { 0xE34F, 0x7D68 }, // CJK UNIFIED IDEOGRAPH
    { 0xE350, 0x7D6E }, // CJK UNIFIED IDEOGRAPH
    { 0xE351, 0x7D4F }, // CJK UNIFIED IDEOGRAPH
    { 0xE352, 0x7D63 }, // CJK UNIFIED IDEOGRAPH
    { 0xE353, 0x7D93 }, // CJK UNIFIED IDEOGRAPH
    { 0xE354, 0x7D89 }, // CJK UNIFIED IDEOGRAPH
    { 0xE355, 0x7D5B }, // CJK UNIFIED IDEOGRAPH
    { 0xE356, 0x7D8F }, // CJK UNIFIED IDEOGRAPH
    { 0xE357, 0x7D7D }, // CJK UNIFIED IDEOGRAPH
    { 0xE358, 0x7D9B }, // CJK UNIFIED IDEOGRAPH
    { 0xE359, 0x7DBA }, // CJK UNIFIED IDEOGRAPH
    { 0xE35A, 0x7DAE }, // CJK UNIFIED IDEOGRAPH
    { 0xE35B, 0x7DA3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE35C, 0x7DB5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE35D, 0x7DC7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE35E, 0x7DBD }, // CJK UNIFIED IDEOGRAPH
    { 0xE35F, 0x7DAB }, // CJK UNIFIED IDEOGRAPH
    { 0xE360, 0x7E3D }, // CJK UNIFIED IDEOGRAPH
    { 0xE361, 0x7DA2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE362, 0x7DAF }, // CJK UNIFIED IDEOGRAPH
    { 0xE363, 0x7DDC }, // CJK UNIFIED IDEOGRAPH
    { 0xE364, 0x7DB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE365, 0x7D9F }, // CJK UNIFIED IDEOGRAPH
    { 0xE366, 0x7DB0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE367, 0x7DD8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE368, 0x7DDD }, // CJK UNIFIED IDEOGRAPH
    { 0xE369, 0x7DE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE36A, 0x7DDE }, // CJK UNIFIED IDEOGRAPH
    { 0xE36B, 0x7DFB }, // CJK UNIFIED IDEOGRAPH
    { 0xE36C, 0x7DF2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE36D, 0x7DE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE36E, 0x7E05 }, // CJK UNIFIED IDEOGRAPH
    { 0xE36F, 0x7E0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE370, 0x7E23 }, // CJK UNIFIED IDEOGRAPH
    { 0xE371, 0x7E21 }, // CJK UNIFIED IDEOGRAPH
    { 0xE372, 0x7E12 }, // CJK UNIFIED IDEOGRAPH
    { 0xE373, 0x7E31 }, // CJK UNIFIED IDEOGRAPH
    { 0xE374, 0x7E1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE375, 0x7E09 }, // CJK UNIFIED IDEOGRAPH
    { 0xE376, 0x7E0B }, // CJK UNIFIED IDEOGRAPH
    { 0xE377, 0x7E22 }, // CJK UNIFIED IDEOGRAPH
    { 0xE378, 0x7E46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE379, 0x7E66 }, // CJK UNIFIED IDEOGRAPH
    { 0xE37A, 0x7E3B }, // CJK UNIFIED IDEOGRAPH
    { 0xE37B, 0x7E35 }, // CJK UNIFIED IDEOGRAPH
    { 0xE37C, 0x7E39 }, // CJK UNIFIED IDEOGRAPH
    { 0xE37D, 0x7E43 }, // CJK UNIFIED IDEOGRAPH
    { 0xE37E, 0x7E37 }, // CJK UNIFIED IDEOGRAPH
    { 0xE380, 0x7E32 }, // CJK UNIFIED IDEOGRAPH
    { 0xE381, 0x7E3A }, // CJK UNIFIED IDEOGRAPH
    { 0xE382, 0x7E67 }, // CJK UNIFIED IDEOGRAPH
    { 0xE383, 0x7E5D }, // CJK UNIFIED IDEOGRAPH
    { 0xE384, 0x7E56 }, // CJK UNIFIED IDEOGRAPH
    { 0xE385, 0x7E5E }, // CJK UNIFIED IDEOGRAPH
    { 0xE386, 0x7E59 }, // CJK UNIFIED IDEOGRAPH
    { 0xE387, 0x7E5A }, // CJK UNIFIED IDEOGRAPH
    { 0xE388, 0x7E79 }, // CJK UNIFIED IDEOGRAPH
    { 0xE389, 0x7E6A }, // CJK UNIFIED IDEOGRAPH
    { 0xE38A, 0x7E69 }, // CJK UNIFIED IDEOGRAPH
    { 0xE38B, 0x7E7C }, // CJK UNIFIED IDEOGRAPH
    { 0xE38C, 0x7E7B }, // CJK UNIFIED IDEOGRAPH
    { 0xE38D, 0x7E83 }, // CJK UNIFIED IDEOGRAPH
    { 0xE38E, 0x7DD5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE38F, 0x7E7D }, // CJK UNIFIED IDEOGRAPH
    { 0xE390, 0x8FAE }, // CJK UNIFIED IDEOGRAPH
    { 0xE391, 0x7E7F }, // CJK UNIFIED IDEOGRAPH
    { 0xE392, 0x7E88 }, // CJK UNIFIED IDEOGRAPH
    { 0xE393, 0x7E89 }, // CJK UNIFIED IDEOGRAPH
    { 0xE394, 0x7E8C }, // CJK UNIFIED IDEOGRAPH
    { 0xE395, 0x7E92 }, // CJK UNIFIED IDEOGRAPH
    { 0xE396, 0x7E90 }, // CJK UNIFIED IDEOGRAPH
    { 0xE397, 0x7E93 }, // CJK UNIFIED IDEOGRAPH
    { 0xE398, 0x7E94 }, // CJK UNIFIED IDEOGRAPH
    { 0xE399, 0x7E96 }, // CJK UNIFIED IDEOGRAPH
    { 0xE39A, 0x7E8E }, // CJK UNIFIED IDEOGRAPH
    { 0xE39B, 0x7E9B }, // CJK UNIFIED IDEOGRAPH
    { 0xE39C, 0x7E9C }, // CJK UNIFIED IDEOGRAPH
    { 0xE39D, 0x7F38 }, // CJK UNIFIED IDEOGRAPH
    { 0xE39E, 0x7F3A }, // CJK UNIFIED IDEOGRAPH
    { 0xE39F, 0x7F45 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A0, 0x7F4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A1, 0x7F4D }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A2, 0x7F4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A3, 0x7F50 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A4, 0x7F51 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A5, 0x7F55 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A6, 0x7F54 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A7, 0x7F58 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A8, 0x7F5F }, // CJK UNIFIED IDEOGRAPH
    { 0xE3A9, 0x7F60 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AA, 0x7F68 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AB, 0x7F69 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AC, 0x7F67 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AD, 0x7F78 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AE, 0x7F82 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3AF, 0x7F86 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B0, 0x7F83 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B1, 0x7F88 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B2, 0x7F87 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B3, 0x7F8C }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B4, 0x7F94 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B5, 0x7F9E }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B6, 0x7F9D }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B7, 0x7F9A }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B8, 0x7FA3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3B9, 0x7FAF }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BA, 0x7FB2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BB, 0x7FB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BC, 0x7FAE }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BD, 0x7FB6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BE, 0x7FB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3BF, 0x8B71 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C0, 0x7FC5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C1, 0x7FC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C2, 0x7FCA }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C3, 0x7FD5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C4, 0x7FD4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C5, 0x7FE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C6, 0x7FE6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C7, 0x7FE9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C8, 0x7FF3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3C9, 0x7FF9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CA, 0x98DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CB, 0x8006 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CC, 0x8004 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CD, 0x800B }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CE, 0x8012 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3CF, 0x8018 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D0, 0x8019 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D1, 0x801C }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D2, 0x8021 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D3, 0x8028 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D4, 0x803F }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D5, 0x803B }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D6, 0x804A }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D7, 0x8046 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D8, 0x8052 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3D9, 0x8058 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DA, 0x805A }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DB, 0x805F }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DC, 0x8062 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DD, 0x8068 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DE, 0x8073 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3DF, 0x8072 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E0, 0x8070 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E1, 0x8076 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E2, 0x8079 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E3, 0x807D }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E4, 0x807F }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E5, 0x8084 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E6, 0x8086 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E7, 0x8085 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E8, 0x809B }, // CJK UNIFIED IDEOGRAPH
    { 0xE3E9, 0x8093 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3EA, 0x809A }, // CJK UNIFIED IDEOGRAPH
    { 0xE3EB, 0x80AD }, // CJK UNIFIED IDEOGRAPH
    { 0xE3EC, 0x5190 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3ED, 0x80AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE3EE, 0x80DB }, // CJK UNIFIED IDEOGRAPH
    { 0xE3EF, 0x80E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F0, 0x80D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F1, 0x80DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F2, 0x80C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F3, 0x80DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F4, 0x80D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F5, 0x8109 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F6, 0x80EF }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F7, 0x80F1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F8, 0x811B }, // CJK UNIFIED IDEOGRAPH
    { 0xE3F9, 0x8129 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3FA, 0x8123 }, // CJK UNIFIED IDEOGRAPH
    { 0xE3FB, 0x812F }, // CJK UNIFIED IDEOGRAPH
    { 0xE3FC, 0x814B }, // CJK UNIFIED IDEOGRAPH
    { 0xE440, 0x968B }, // CJK UNIFIED IDEOGRAPH
    { 0xE441, 0x8146 }, // CJK UNIFIED IDEOGRAPH
    { 0xE442, 0x813E }, // CJK UNIFIED IDEOGRAPH
    { 0xE443, 0x8153 }, // CJK UNIFIED IDEOGRAPH
    { 0xE444, 0x8151 }, // CJK UNIFIED IDEOGRAPH
    { 0xE445, 0x80FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE446, 0x8171 }, // CJK UNIFIED IDEOGRAPH
    { 0xE447, 0x816E }, // CJK UNIFIED IDEOGRAPH
    { 0xE448, 0x8165 }, // CJK UNIFIED IDEOGRAPH
    { 0xE449, 0x8166 }, // CJK UNIFIED IDEOGRAPH
    { 0xE44A, 0x8174 }, // CJK UNIFIED IDEOGRAPH
    { 0xE44B, 0x8183 }, // CJK UNIFIED IDEOGRAPH
    { 0xE44C, 0x8188 }, // CJK UNIFIED IDEOGRAPH
    { 0xE44D, 0x818A }, // CJK UNIFIED IDEOGRAPH
    { 0xE44E, 0x8180 }, // CJK UNIFIED IDEOGRAPH
    { 0xE44F, 0x8182 }, // CJK UNIFIED IDEOGRAPH
    { 0xE450, 0x81A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE451, 0x8195 }, // CJK UNIFIED IDEOGRAPH
    { 0xE452, 0x81A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE453, 0x81A3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE454, 0x815F }, // CJK UNIFIED IDEOGRAPH
    { 0xE455, 0x8193 }, // CJK UNIFIED IDEOGRAPH
    { 0xE456, 0x81A9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE457, 0x81B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE458, 0x81B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE459, 0x81BE }, // CJK UNIFIED IDEOGRAPH
    { 0xE45A, 0x81B8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE45B, 0x81BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE45C, 0x81C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE45D, 0x81C2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE45E, 0x81BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE45F, 0x81C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE460, 0x81CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE461, 0x81D1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE462, 0x81D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE463, 0x81D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE464, 0x81C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE465, 0x81DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE466, 0x81DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE467, 0x81E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE468, 0x81E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE469, 0x81FA }, // CJK UNIFIED IDEOGRAPH
    { 0xE46A, 0x81FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE46B, 0x81FE }, // CJK UNIFIED IDEOGRAPH
    { 0xE46C, 0x8201 }, // CJK UNIFIED IDEOGRAPH
    { 0xE46D, 0x8202 }, // CJK UNIFIED IDEOGRAPH
    { 0xE46E, 0x8205 }, // CJK UNIFIED IDEOGRAPH
    { 0xE46F, 0x8207 }, // CJK UNIFIED IDEOGRAPH
    { 0xE470, 0x820A }, // CJK UNIFIED IDEOGRAPH
    { 0xE471, 0x820D }, // CJK UNIFIED IDEOGRAPH
    { 0xE472, 0x8210 }, // CJK UNIFIED IDEOGRAPH
    { 0xE473, 0x8216 }, // CJK UNIFIED IDEOGRAPH
    { 0xE474, 0x8229 }, // CJK UNIFIED IDEOGRAPH
    { 0xE475, 0x822B }, // CJK UNIFIED IDEOGRAPH
    { 0xE476, 0x8238 }, // CJK UNIFIED IDEOGRAPH
    { 0xE477, 0x8233 }, // CJK UNIFIED IDEOGRAPH
    { 0xE478, 0x8240 }, // CJK UNIFIED IDEOGRAPH
    { 0xE479, 0x8259 }, // CJK UNIFIED IDEOGRAPH
    { 0xE47A, 0x8258 }, // CJK UNIFIED IDEOGRAPH
    { 0xE47B, 0x825D }, // CJK UNIFIED IDEOGRAPH
    { 0xE47C, 0x825A }, // CJK UNIFIED IDEOGRAPH
    { 0xE47D, 0x825F }, // CJK UNIFIED IDEOGRAPH
    { 0xE47E, 0x8264 }, // CJK UNIFIED IDEOGRAPH
    { 0xE480, 0x8262 }, // CJK UNIFIED IDEOGRAPH
    { 0xE481, 0x8268 }, // CJK UNIFIED IDEOGRAPH
    { 0xE482, 0x826A }, // CJK UNIFIED IDEOGRAPH
    { 0xE483, 0x826B }, // CJK UNIFIED IDEOGRAPH
    { 0xE484, 0x822E }, // CJK UNIFIED IDEOGRAPH
    { 0xE485, 0x8271 }, // CJK UNIFIED IDEOGRAPH
    { 0xE486, 0x8277 }, // CJK UNIFIED IDEOGRAPH
    { 0xE487, 0x8278 }, // CJK UNIFIED IDEOGRAPH
    { 0xE488, 0x827E }, // CJK UNIFIED IDEOGRAPH
    { 0xE489, 0x828D }, // CJK UNIFIED IDEOGRAPH
    { 0xE48A, 0x8292 }, // CJK UNIFIED IDEOGRAPH
    { 0xE48B, 0x82AB }, // CJK UNIFIED IDEOGRAPH
    { 0xE48C, 0x829F }, // CJK UNIFIED IDEOGRAPH
    { 0xE48D, 0x82BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE48E, 0x82AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE48F, 0x82E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE490, 0x82E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE491, 0x82DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE492, 0x82D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE493, 0x82F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE494, 0x82F3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE495, 0x82FA }, // CJK UNIFIED IDEOGRAPH
    { 0xE496, 0x8393 }, // CJK UNIFIED IDEOGRAPH
    { 0xE497, 0x8303 }, // CJK UNIFIED IDEOGRAPH
    { 0xE498, 0x82FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE499, 0x82F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE49A, 0x82DE }, // CJK UNIFIED IDEOGRAPH
    { 0xE49B, 0x8306 }, // CJK UNIFIED IDEOGRAPH
    { 0xE49C, 0x82DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE49D, 0x8309 }, // CJK UNIFIED IDEOGRAPH
    { 0xE49E, 0x82D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE49F, 0x8335 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A0, 0x8334 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A1, 0x8316 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A2, 0x8332 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A3, 0x8331 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A4, 0x8340 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A5, 0x8339 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A6, 0x8350 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A7, 0x8345 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A8, 0x832F }, // CJK UNIFIED IDEOGRAPH
    { 0xE4A9, 0x832B }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AA, 0x8317 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AB, 0x8318 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AC, 0x8385 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AD, 0x839A }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AE, 0x83AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE4AF, 0x839F }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B0, 0x83A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B1, 0x8396 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B2, 0x8323 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B3, 0x838E }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B4, 0x8387 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B5, 0x838A }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B6, 0x837C }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B7, 0x83B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B8, 0x8373 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4B9, 0x8375 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BA, 0x83A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BB, 0x8389 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BC, 0x83A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BD, 0x83F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BE, 0x8413 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4BF, 0x83EB }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C0, 0x83CE }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C1, 0x83FD }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C2, 0x8403 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C3, 0x83D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C4, 0x840B }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C5, 0x83C1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C6, 0x83F7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C7, 0x8407 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C8, 0x83E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4C9, 0x83F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CA, 0x840D }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CB, 0x8422 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CC, 0x8420 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CD, 0x83BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CE, 0x8438 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4CF, 0x8506 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D0, 0x83FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D1, 0x846D }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D2, 0x842A }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D3, 0x843C }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D4, 0x855A }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D5, 0x8484 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D6, 0x8477 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D7, 0x846B }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D8, 0x84AD }, // CJK UNIFIED IDEOGRAPH
    { 0xE4D9, 0x846E }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DA, 0x8482 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DB, 0x8469 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DC, 0x8446 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DD, 0x842C }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DE, 0x846F }, // CJK UNIFIED IDEOGRAPH
    { 0xE4DF, 0x8479 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E0, 0x8435 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E1, 0x84CA }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E2, 0x8462 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E3, 0x84B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E4, 0x84BF }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E5, 0x849F }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E6, 0x84D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E7, 0x84CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E8, 0x84BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE4E9, 0x84DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE4EA, 0x84D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4EB, 0x84C1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4EC, 0x84C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4ED, 0x84D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4EE, 0x84A1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4EF, 0x8521 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F0, 0x84FF }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F1, 0x84F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F2, 0x8517 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F3, 0x8518 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F4, 0x852C }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F5, 0x851F }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F6, 0x8515 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F7, 0x8514 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F8, 0x84FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE4F9, 0x8540 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4FA, 0x8563 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4FB, 0x8558 }, // CJK UNIFIED IDEOGRAPH
    { 0xE4FC, 0x8548 }, // CJK UNIFIED IDEOGRAPH
    { 0xE540, 0x8541 }, // CJK UNIFIED IDEOGRAPH
    { 0xE541, 0x8602 }, // CJK UNIFIED IDEOGRAPH
    { 0xE542, 0x854B }, // CJK UNIFIED IDEOGRAPH
    { 0xE543, 0x8555 }, // CJK UNIFIED IDEOGRAPH
    { 0xE544, 0x8580 }, // CJK UNIFIED IDEOGRAPH
    { 0xE545, 0x85A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE546, 0x8588 }, // CJK UNIFIED IDEOGRAPH
    { 0xE547, 0x8591 }, // CJK UNIFIED IDEOGRAPH
    { 0xE548, 0x858A }, // CJK UNIFIED IDEOGRAPH
    { 0xE549, 0x85A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE54A, 0x856D }, // CJK UNIFIED IDEOGRAPH
    { 0xE54B, 0x8594 }, // CJK UNIFIED IDEOGRAPH
    { 0xE54C, 0x859B }, // CJK UNIFIED IDEOGRAPH
    { 0xE54D, 0x85EA }, // CJK UNIFIED IDEOGRAPH
    { 0xE54E, 0x8587 }, // CJK UNIFIED IDEOGRAPH
    { 0xE54F, 0x859C }, // CJK UNIFIED IDEOGRAPH
    { 0xE550, 0x8577 }, // CJK UNIFIED IDEOGRAPH
    { 0xE551, 0x857E }, // CJK UNIFIED IDEOGRAPH
    { 0xE552, 0x8590 }, // CJK UNIFIED IDEOGRAPH
    { 0xE553, 0x85C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE554, 0x85BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE555, 0x85CF }, // CJK UNIFIED IDEOGRAPH
    { 0xE556, 0x85B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE557, 0x85D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE558, 0x85D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE559, 0x85DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE55A, 0x85E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE55B, 0x85DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE55C, 0x85F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE55D, 0x860A }, // CJK UNIFIED IDEOGRAPH
    { 0xE55E, 0x8613 }, // CJK UNIFIED IDEOGRAPH
    { 0xE55F, 0x860B }, // CJK UNIFIED IDEOGRAPH
    { 0xE560, 0x85FE }, // CJK UNIFIED IDEOGRAPH
    { 0xE561, 0x85FA }, // CJK UNIFIED IDEOGRAPH
    { 0xE562, 0x8606 }, // CJK UNIFIED IDEOGRAPH
    { 0xE563, 0x8622 }, // CJK UNIFIED IDEOGRAPH
    { 0xE564, 0x861A }, // CJK UNIFIED IDEOGRAPH
    { 0xE565, 0x8630 }, // CJK UNIFIED IDEOGRAPH
    { 0xE566, 0x863F }, // CJK UNIFIED IDEOGRAPH
    { 0xE567, 0x864D }, // CJK UNIFIED IDEOGRAPH
    { 0xE568, 0x4E55 }, // CJK UNIFIED IDEOGRAPH
    { 0xE569, 0x8654 }, // CJK UNIFIED IDEOGRAPH
    { 0xE56A, 0x865F }, // CJK UNIFIED IDEOGRAPH
    { 0xE56B, 0x8667 }, // CJK UNIFIED IDEOGRAPH
    { 0xE56C, 0x8671 }, // CJK UNIFIED IDEOGRAPH
    { 0xE56D, 0x8693 }, // CJK UNIFIED IDEOGRAPH
    { 0xE56E, 0x86A3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE56F, 0x86A9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE570, 0x86AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE571, 0x868B }, // CJK UNIFIED IDEOGRAPH
    { 0xE572, 0x868C }, // CJK UNIFIED IDEOGRAPH
    { 0xE573, 0x86B6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE574, 0x86AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE575, 0x86C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE576, 0x86C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE577, 0x86B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE578, 0x86C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE579, 0x8823 }, // CJK UNIFIED IDEOGRAPH
    { 0xE57A, 0x86AB }, // CJK UNIFIED IDEOGRAPH
    { 0xE57B, 0x86D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE57C, 0x86DE }, // CJK UNIFIED IDEOGRAPH
    { 0xE57D, 0x86E9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE57E, 0x86EC }, // CJK UNIFIED IDEOGRAPH
    { 0xE580, 0x86DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE581, 0x86DB }, // CJK UNIFIED IDEOGRAPH
    { 0xE582, 0x86EF }, // CJK UNIFIED IDEOGRAPH
    { 0xE583, 0x8712 }, // CJK UNIFIED IDEOGRAPH
    { 0xE584, 0x8706 }, // CJK UNIFIED IDEOGRAPH
    { 0xE585, 0x8708 }, // CJK UNIFIED IDEOGRAPH
    { 0xE586, 0x8700 }, // CJK UNIFIED IDEOGRAPH
    { 0xE587, 0x8703 }, // CJK UNIFIED IDEOGRAPH
    { 0xE588, 0x86FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE589, 0x8711 }, // CJK UNIFIED IDEOGRAPH
    { 0xE58A, 0x8709 }, // CJK UNIFIED IDEOGRAPH
    { 0xE58B, 0x870D }, // CJK UNIFIED IDEOGRAPH
    { 0xE58C, 0x86F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE58D, 0x870A }, // CJK UNIFIED IDEOGRAPH
    { 0xE58E, 0x8734 }, // CJK UNIFIED IDEOGRAPH
    { 0xE58F, 0x873F }, // CJK UNIFIED IDEOGRAPH
    { 0xE590, 0x8737 }, // CJK UNIFIED IDEOGRAPH
    { 0xE591, 0x873B }, // CJK UNIFIED IDEOGRAPH
    { 0xE592, 0x8725 }, // CJK UNIFIED IDEOGRAPH
    { 0xE593, 0x8729 }, // CJK UNIFIED IDEOGRAPH
    { 0xE594, 0x871A }, // CJK UNIFIED IDEOGRAPH
    { 0xE595, 0x8760 }, // CJK UNIFIED IDEOGRAPH
    { 0xE596, 0x875F }, // CJK UNIFIED IDEOGRAPH
    { 0xE597, 0x8778 }, // CJK UNIFIED IDEOGRAPH
    { 0xE598, 0x874C }, // CJK UNIFIED IDEOGRAPH
    { 0xE599, 0x874E }, // CJK UNIFIED IDEOGRAPH
    { 0xE59A, 0x8774 }, // CJK UNIFIED IDEOGRAPH
    { 0xE59B, 0x8757 }, // CJK UNIFIED IDEOGRAPH
    { 0xE59C, 0x8768 }, // CJK UNIFIED IDEOGRAPH
    { 0xE59D, 0x876E }, // CJK UNIFIED IDEOGRAPH
    { 0xE59E, 0x8759 }, // CJK UNIFIED IDEOGRAPH
    { 0xE59F, 0x8753 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A0, 0x8763 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A1, 0x876A }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A2, 0x8805 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A3, 0x87A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A4, 0x879F }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A5, 0x8782 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A6, 0x87AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A7, 0x87CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A8, 0x87BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE5A9, 0x87C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AA, 0x87D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AB, 0x96D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AC, 0x87AB }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AD, 0x87C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AE, 0x87B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5AF, 0x87C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B0, 0x87C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B1, 0x87BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B2, 0x87EF }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B3, 0x87F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B4, 0x87E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B5, 0x880F }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B6, 0x880D }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B7, 0x87FE }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B8, 0x87F6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5B9, 0x87F7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BA, 0x880E }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BB, 0x87D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BC, 0x8811 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BD, 0x8816 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BE, 0x8815 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5BF, 0x8822 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C0, 0x8821 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C1, 0x8831 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C2, 0x8836 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C3, 0x8839 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C4, 0x8827 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C5, 0x883B }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C6, 0x8844 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C7, 0x8842 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C8, 0x8852 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5C9, 0x8859 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CA, 0x885E }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CB, 0x8862 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CC, 0x886B }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CD, 0x8881 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CE, 0x887E }, // CJK UNIFIED IDEOGRAPH
    { 0xE5CF, 0x889E }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D0, 0x8875 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D1, 0x887D }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D2, 0x88B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D3, 0x8872 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D4, 0x8882 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D5, 0x8897 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D6, 0x8892 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D7, 0x88AE }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D8, 0x8899 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5D9, 0x88A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DA, 0x888D }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DB, 0x88A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DC, 0x88B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DD, 0x88BF }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DE, 0x88B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5DF, 0x88C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E0, 0x88C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E1, 0x88D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E2, 0x88D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E3, 0x88D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E4, 0x88DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E5, 0x88F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E6, 0x8902 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E7, 0x88FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E8, 0x88F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5E9, 0x88E8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5EA, 0x88F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5EB, 0x8904 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5EC, 0x890C }, // CJK UNIFIED IDEOGRAPH
    { 0xE5ED, 0x890A }, // CJK UNIFIED IDEOGRAPH
    { 0xE5EE, 0x8913 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5EF, 0x8943 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F0, 0x891E }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F1, 0x8925 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F2, 0x892A }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F3, 0x892B }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F4, 0x8941 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F5, 0x8944 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F6, 0x893B }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F7, 0x8936 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F8, 0x8938 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5F9, 0x894C }, // CJK UNIFIED IDEOGRAPH
    { 0xE5FA, 0x891D }, // CJK UNIFIED IDEOGRAPH
    { 0xE5FB, 0x8960 }, // CJK UNIFIED IDEOGRAPH
    { 0xE5FC, 0x895E }, // CJK UNIFIED IDEOGRAPH
    { 0xE640, 0x8966 }, // CJK UNIFIED IDEOGRAPH
    { 0xE641, 0x8964 }, // CJK UNIFIED IDEOGRAPH
    { 0xE642, 0x896D }, // CJK UNIFIED IDEOGRAPH
    { 0xE643, 0x896A }, // CJK UNIFIED IDEOGRAPH
    { 0xE644, 0x896F }, // CJK UNIFIED IDEOGRAPH
    { 0xE645, 0x8974 }, // CJK UNIFIED IDEOGRAPH
    { 0xE646, 0x8977 }, // CJK UNIFIED IDEOGRAPH
    { 0xE647, 0x897E }, // CJK UNIFIED IDEOGRAPH
    { 0xE648, 0x8983 }, // CJK UNIFIED IDEOGRAPH
    { 0xE649, 0x8988 }, // CJK UNIFIED IDEOGRAPH
    { 0xE64A, 0x898A }, // CJK UNIFIED IDEOGRAPH
    { 0xE64B, 0x8993 }, // CJK UNIFIED IDEOGRAPH
    { 0xE64C, 0x8998 }, // CJK UNIFIED IDEOGRAPH
    { 0xE64D, 0x89A1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE64E, 0x89A9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE64F, 0x89A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE650, 0x89AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE651, 0x89AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE652, 0x89B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE653, 0x89BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE654, 0x89BD }, // CJK UNIFIED IDEOGRAPH
    { 0xE655, 0x89BF }, // CJK UNIFIED IDEOGRAPH
    { 0xE656, 0x89C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE657, 0x89DA }, // CJK UNIFIED IDEOGRAPH
    { 0xE658, 0x89DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE659, 0x89DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE65A, 0x89E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE65B, 0x89F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE65C, 0x89F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE65D, 0x8A03 }, // CJK UNIFIED IDEOGRAPH
    { 0xE65E, 0x8A16 }, // CJK UNIFIED IDEOGRAPH
    { 0xE65F, 0x8A10 }, // CJK UNIFIED IDEOGRAPH
    { 0xE660, 0x8A0C }, // CJK UNIFIED IDEOGRAPH
    { 0xE661, 0x8A1B }, // CJK UNIFIED IDEOGRAPH
    { 0xE662, 0x8A1D }, // CJK UNIFIED IDEOGRAPH
    { 0xE663, 0x8A25 }, // CJK UNIFIED IDEOGRAPH
    { 0xE664, 0x8A36 }, // CJK UNIFIED IDEOGRAPH
    { 0xE665, 0x8A41 }, // CJK UNIFIED IDEOGRAPH
    { 0xE666, 0x8A5B }, // CJK UNIFIED IDEOGRAPH
    { 0xE667, 0x8A52 }, // CJK UNIFIED IDEOGRAPH
    { 0xE668, 0x8A46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE669, 0x8A48 }, // CJK UNIFIED IDEOGRAPH
    { 0xE66A, 0x8A7C }, // CJK UNIFIED IDEOGRAPH
    { 0xE66B, 0x8A6D }, // CJK UNIFIED IDEOGRAPH
    { 0xE66C, 0x8A6C }, // CJK UNIFIED IDEOGRAPH
    { 0xE66D, 0x8A62 }, // CJK UNIFIED IDEOGRAPH
    { 0xE66E, 0x8A85 }, // CJK UNIFIED IDEOGRAPH
    { 0xE66F, 0x8A82 }, // CJK UNIFIED IDEOGRAPH
    { 0xE670, 0x8A84 }, // CJK UNIFIED IDEOGRAPH
    { 0xE671, 0x8AA8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE672, 0x8AA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE673, 0x8A91 }, // CJK UNIFIED IDEOGRAPH
    { 0xE674, 0x8AA5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE675, 0x8AA6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE676, 0x8A9A }, // CJK UNIFIED IDEOGRAPH
    { 0xE677, 0x8AA3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE678, 0x8AC4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE679, 0x8ACD }, // CJK UNIFIED IDEOGRAPH
    { 0xE67A, 0x8AC2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE67B, 0x8ADA }, // CJK UNIFIED IDEOGRAPH
    { 0xE67C, 0x8AEB }, // CJK UNIFIED IDEOGRAPH
    { 0xE67D, 0x8AF3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE67E, 0x8AE7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE680, 0x8AE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE681, 0x8AF1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE682, 0x8B14 }, // CJK UNIFIED IDEOGRAPH
    { 0xE683, 0x8AE0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE684, 0x8AE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE685, 0x8AF7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE686, 0x8ADE }, // CJK UNIFIED IDEOGRAPH
    { 0xE687, 0x8ADB }, // CJK UNIFIED IDEOGRAPH
    { 0xE688, 0x8B0C }, // CJK UNIFIED IDEOGRAPH
    { 0xE689, 0x8B07 }, // CJK UNIFIED IDEOGRAPH
    { 0xE68A, 0x8B1A }, // CJK UNIFIED IDEOGRAPH
    { 0xE68B, 0x8AE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE68C, 0x8B16 }, // CJK UNIFIED IDEOGRAPH
    { 0xE68D, 0x8B10 }, // CJK UNIFIED IDEOGRAPH
    { 0xE68E, 0x8B17 }, // CJK UNIFIED IDEOGRAPH
    { 0xE68F, 0x8B20 }, // CJK UNIFIED IDEOGRAPH
    { 0xE690, 0x8B33 }, // CJK UNIFIED IDEOGRAPH
    { 0xE691, 0x97AB }, // CJK UNIFIED IDEOGRAPH
    { 0xE692, 0x8B26 }, // CJK UNIFIED IDEOGRAPH
    { 0xE693, 0x8B2B }, // CJK UNIFIED IDEOGRAPH
    { 0xE694, 0x8B3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE695, 0x8B28 }, // CJK UNIFIED IDEOGRAPH
    { 0xE696, 0x8B41 }, // CJK UNIFIED IDEOGRAPH
    { 0xE697, 0x8B4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE698, 0x8B4F }, // CJK UNIFIED IDEOGRAPH
    { 0xE699, 0x8B4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE69A, 0x8B49 }, // CJK UNIFIED IDEOGRAPH
    { 0xE69B, 0x8B56 }, // CJK UNIFIED IDEOGRAPH
    { 0xE69C, 0x8B5B }, // CJK UNIFIED IDEOGRAPH
    { 0xE69D, 0x8B5A }, // CJK UNIFIED IDEOGRAPH
    { 0xE69E, 0x8B6B }, // CJK UNIFIED IDEOGRAPH
    { 0xE69F, 0x8B5F }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A0, 0x8B6C }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A1, 0x8B6F }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A2, 0x8B74 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A3, 0x8B7D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A4, 0x8B80 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A5, 0x8B8C }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A6, 0x8B8E }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A7, 0x8B92 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A8, 0x8B93 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6A9, 0x8B96 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AA, 0x8B99 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AB, 0x8B9A }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AC, 0x8C3A }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AD, 0x8C41 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AE, 0x8C3F }, // CJK UNIFIED IDEOGRAPH
    { 0xE6AF, 0x8C48 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B0, 0x8C4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B1, 0x8C4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B2, 0x8C50 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B3, 0x8C55 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B4, 0x8C62 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B5, 0x8C6C }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B6, 0x8C78 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B7, 0x8C7A }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B8, 0x8C82 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6B9, 0x8C89 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BA, 0x8C85 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BB, 0x8C8A }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BC, 0x8C8D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BD, 0x8C8E }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BE, 0x8C94 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6BF, 0x8C7C }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C0, 0x8C98 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C1, 0x621D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C2, 0x8CAD }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C3, 0x8CAA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C4, 0x8CBD }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C5, 0x8CB2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C6, 0x8CB3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C7, 0x8CAE }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C8, 0x8CB6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6C9, 0x8CC8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CA, 0x8CC1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CB, 0x8CE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CC, 0x8CE3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CD, 0x8CDA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CE, 0x8CFD }, // CJK UNIFIED IDEOGRAPH
    { 0xE6CF, 0x8CFA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D0, 0x8CFB }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D1, 0x8D04 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D2, 0x8D05 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D3, 0x8D0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D4, 0x8D07 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D5, 0x8D0F }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D6, 0x8D0D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D7, 0x8D10 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D8, 0x9F4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE6D9, 0x8D13 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DA, 0x8CCD }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DB, 0x8D14 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DC, 0x8D16 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DD, 0x8D67 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DE, 0x8D6D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6DF, 0x8D71 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E0, 0x8D73 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E1, 0x8D81 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E2, 0x8D99 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E3, 0x8DC2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E4, 0x8DBE }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E5, 0x8DBA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E6, 0x8DCF }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E7, 0x8DDA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E8, 0x8DD6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6E9, 0x8DCC }, // CJK UNIFIED IDEOGRAPH
    { 0xE6EA, 0x8DDB }, // CJK UNIFIED IDEOGRAPH
    { 0xE6EB, 0x8DCB }, // CJK UNIFIED IDEOGRAPH
    { 0xE6EC, 0x8DEA }, // CJK UNIFIED IDEOGRAPH
    { 0xE6ED, 0x8DEB }, // CJK UNIFIED IDEOGRAPH
    { 0xE6EE, 0x8DDF }, // CJK UNIFIED IDEOGRAPH
    { 0xE6EF, 0x8DE3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F0, 0x8DFC }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F1, 0x8E08 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F2, 0x8E09 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F3, 0x8DFF }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F4, 0x8E1D }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F5, 0x8E1E }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F6, 0x8E10 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F7, 0x8E1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F8, 0x8E42 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6F9, 0x8E35 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6FA, 0x8E30 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6FB, 0x8E34 }, // CJK UNIFIED IDEOGRAPH
    { 0xE6FC, 0x8E4A }, // CJK UNIFIED IDEOGRAPH
    { 0xE740, 0x8E47 }, // CJK UNIFIED IDEOGRAPH
    { 0xE741, 0x8E49 }, // CJK UNIFIED IDEOGRAPH
    { 0xE742, 0x8E4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE743, 0x8E50 }, // CJK UNIFIED IDEOGRAPH
    { 0xE744, 0x8E48 }, // CJK UNIFIED IDEOGRAPH
    { 0xE745, 0x8E59 }, // CJK UNIFIED IDEOGRAPH
    { 0xE746, 0x8E64 }, // CJK UNIFIED IDEOGRAPH
    { 0xE747, 0x8E60 }, // CJK UNIFIED IDEOGRAPH
    { 0xE748, 0x8E2A }, // CJK UNIFIED IDEOGRAPH
    { 0xE749, 0x8E63 }, // CJK UNIFIED IDEOGRAPH
    { 0xE74A, 0x8E55 }, // CJK UNIFIED IDEOGRAPH
    { 0xE74B, 0x8E76 }, // CJK UNIFIED IDEOGRAPH
    { 0xE74C, 0x8E72 }, // CJK UNIFIED IDEOGRAPH
    { 0xE74D, 0x8E7C }, // CJK UNIFIED IDEOGRAPH
    { 0xE74E, 0x8E81 }, // CJK UNIFIED IDEOGRAPH
    { 0xE74F, 0x8E87 }, // CJK UNIFIED IDEOGRAPH
    { 0xE750, 0x8E85 }, // CJK UNIFIED IDEOGRAPH
    { 0xE751, 0x8E84 }, // CJK UNIFIED IDEOGRAPH
    { 0xE752, 0x8E8B }, // CJK UNIFIED IDEOGRAPH
    { 0xE753, 0x8E8A }, // CJK UNIFIED IDEOGRAPH
    { 0xE754, 0x8E93 }, // CJK UNIFIED IDEOGRAPH
    { 0xE755, 0x8E91 }, // CJK UNIFIED IDEOGRAPH
    { 0xE756, 0x8E94 }, // CJK UNIFIED IDEOGRAPH
    { 0xE757, 0x8E99 }, // CJK UNIFIED IDEOGRAPH
    { 0xE758, 0x8EAA }, // CJK UNIFIED IDEOGRAPH
    { 0xE759, 0x8EA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE75A, 0x8EAC }, // CJK UNIFIED IDEOGRAPH
    { 0xE75B, 0x8EB0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE75C, 0x8EC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE75D, 0x8EB1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE75E, 0x8EBE }, // CJK UNIFIED IDEOGRAPH
    { 0xE75F, 0x8EC5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE760, 0x8EC8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE761, 0x8ECB }, // CJK UNIFIED IDEOGRAPH
    { 0xE762, 0x8EDB }, // CJK UNIFIED IDEOGRAPH
    { 0xE763, 0x8EE3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE764, 0x8EFC }, // CJK UNIFIED IDEOGRAPH
    { 0xE765, 0x8EFB }, // CJK UNIFIED IDEOGRAPH
    { 0xE766, 0x8EEB }, // CJK UNIFIED IDEOGRAPH
    { 0xE767, 0x8EFE }, // CJK UNIFIED IDEOGRAPH
    { 0xE768, 0x8F0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE769, 0x8F05 }, // CJK UNIFIED IDEOGRAPH
    { 0xE76A, 0x8F15 }, // CJK UNIFIED IDEOGRAPH
    { 0xE76B, 0x8F12 }, // CJK UNIFIED IDEOGRAPH
    { 0xE76C, 0x8F19 }, // CJK UNIFIED IDEOGRAPH
    { 0xE76D, 0x8F13 }, // CJK UNIFIED IDEOGRAPH
    { 0xE76E, 0x8F1C }, // CJK UNIFIED IDEOGRAPH
    { 0xE76F, 0x8F1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE770, 0x8F1B }, // CJK UNIFIED IDEOGRAPH
    { 0xE771, 0x8F0C }, // CJK UNIFIED IDEOGRAPH
    { 0xE772, 0x8F26 }, // CJK UNIFIED IDEOGRAPH
    { 0xE773, 0x8F33 }, // CJK UNIFIED IDEOGRAPH
    { 0xE774, 0x8F3B }, // CJK UNIFIED IDEOGRAPH
    { 0xE775, 0x8F39 }, // CJK UNIFIED IDEOGRAPH
    { 0xE776, 0x8F45 }, // CJK UNIFIED IDEOGRAPH
    { 0xE777, 0x8F42 }, // CJK UNIFIED IDEOGRAPH
    { 0xE778, 0x8F3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE779, 0x8F4C }, // CJK UNIFIED IDEOGRAPH
    { 0xE77A, 0x8F49 }, // CJK UNIFIED IDEOGRAPH
    { 0xE77B, 0x8F46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE77C, 0x8F4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE77D, 0x8F57 }, // CJK UNIFIED IDEOGRAPH
    { 0xE77E, 0x8F5C }, // CJK UNIFIED IDEOGRAPH
    { 0xE780, 0x8F62 }, // CJK UNIFIED IDEOGRAPH
    { 0xE781, 0x8F63 }, // CJK UNIFIED IDEOGRAPH
    { 0xE782, 0x8F64 }, // CJK UNIFIED IDEOGRAPH
    { 0xE783, 0x8F9C }, // CJK UNIFIED IDEOGRAPH
    { 0xE784, 0x8F9F }, // CJK UNIFIED IDEOGRAPH
    { 0xE785, 0x8FA3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE786, 0x8FAD }, // CJK UNIFIED IDEOGRAPH
    { 0xE787, 0x8FAF }, // CJK UNIFIED IDEOGRAPH
    { 0xE788, 0x8FB7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE789, 0x8FDA }, // CJK UNIFIED IDEOGRAPH
    { 0xE78A, 0x8FE5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE78B, 0x8FE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE78C, 0x8FEA }, // CJK UNIFIED IDEOGRAPH
    { 0xE78D, 0x8FEF }, // CJK UNIFIED IDEOGRAPH
    { 0xE78E, 0x9087 }, // CJK UNIFIED IDEOGRAPH
    { 0xE78F, 0x8FF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE790, 0x9005 }, // CJK UNIFIED IDEOGRAPH
    { 0xE791, 0x8FF9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE792, 0x8FFA }, // CJK UNIFIED IDEOGRAPH
    { 0xE793, 0x9011 }, // CJK UNIFIED IDEOGRAPH
    { 0xE794, 0x9015 }, // CJK UNIFIED IDEOGRAPH
    { 0xE795, 0x9021 }, // CJK UNIFIED IDEOGRAPH
    { 0xE796, 0x900D }, // CJK UNIFIED IDEOGRAPH
    { 0xE797, 0x901E }, // CJK UNIFIED IDEOGRAPH
    { 0xE798, 0x9016 }, // CJK UNIFIED IDEOGRAPH
    { 0xE799, 0x900B }, // CJK UNIFIED IDEOGRAPH
    { 0xE79A, 0x9027 }, // CJK UNIFIED IDEOGRAPH
    { 0xE79B, 0x9036 }, // CJK UNIFIED IDEOGRAPH
    { 0xE79C, 0x9035 }, // CJK UNIFIED IDEOGRAPH
    { 0xE79D, 0x9039 }, // CJK UNIFIED IDEOGRAPH
    { 0xE79E, 0x8FF8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE79F, 0x904F }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A0, 0x9050 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A1, 0x9051 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A2, 0x9052 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A3, 0x900E }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A4, 0x9049 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A5, 0x903E }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A6, 0x9056 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A7, 0x9058 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A8, 0x905E }, // CJK UNIFIED IDEOGRAPH
    { 0xE7A9, 0x9068 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AA, 0x906F }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AB, 0x9076 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AC, 0x96A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AD, 0x9072 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AE, 0x9082 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7AF, 0x907D }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B0, 0x9081 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B1, 0x9080 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B2, 0x908A }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B3, 0x9089 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B4, 0x908F }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B5, 0x90A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B6, 0x90AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B7, 0x90B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B8, 0x90B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7B9, 0x90E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BA, 0x90E4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BB, 0x6248 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BC, 0x90DB }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BD, 0x9102 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BE, 0x9112 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7BF, 0x9119 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C0, 0x9132 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C1, 0x9130 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C2, 0x914A }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C3, 0x9156 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C4, 0x9158 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C5, 0x9163 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C6, 0x9165 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C7, 0x9169 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C8, 0x9173 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7C9, 0x9172 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CA, 0x918B }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CB, 0x9189 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CC, 0x9182 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CD, 0x91A2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CE, 0x91AB }, // CJK UNIFIED IDEOGRAPH
    { 0xE7CF, 0x91AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D0, 0x91AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D1, 0x91B5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D2, 0x91B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D3, 0x91BA }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D4, 0x91C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D5, 0x91C1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D6, 0x91C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D7, 0x91CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D8, 0x91D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7D9, 0x91D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DA, 0x91DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DB, 0x91E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DC, 0x91DB }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DD, 0x91FC }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DE, 0x91F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7DF, 0x91F6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E0, 0x921E }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E1, 0x91FF }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E2, 0x9214 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E3, 0x922C }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E4, 0x9215 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E5, 0x9211 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E6, 0x925E }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E7, 0x9257 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E8, 0x9245 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7E9, 0x9249 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7EA, 0x9264 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7EB, 0x9248 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7EC, 0x9295 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7ED, 0x923F }, // CJK UNIFIED IDEOGRAPH
    { 0xE7EE, 0x924B }, // CJK UNIFIED IDEOGRAPH
    { 0xE7EF, 0x9250 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F0, 0x929C }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F1, 0x9296 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F2, 0x9293 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F3, 0x929B }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F4, 0x925A }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F5, 0x92CF }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F6, 0x92B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F7, 0x92B7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F8, 0x92E9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7F9, 0x930F }, // CJK UNIFIED IDEOGRAPH
    { 0xE7FA, 0x92FA }, // CJK UNIFIED IDEOGRAPH
    { 0xE7FB, 0x9344 }, // CJK UNIFIED IDEOGRAPH
    { 0xE7FC, 0x932E }, // CJK UNIFIED IDEOGRAPH
    { 0xE840, 0x9319 }, // CJK UNIFIED IDEOGRAPH
    { 0xE841, 0x9322 }, // CJK UNIFIED IDEOGRAPH
    { 0xE842, 0x931A }, // CJK UNIFIED IDEOGRAPH
    { 0xE843, 0x9323 }, // CJK UNIFIED IDEOGRAPH
    { 0xE844, 0x933A }, // CJK UNIFIED IDEOGRAPH
    { 0xE845, 0x9335 }, // CJK UNIFIED IDEOGRAPH
    { 0xE846, 0x933B }, // CJK UNIFIED IDEOGRAPH
    { 0xE847, 0x935C }, // CJK UNIFIED IDEOGRAPH
    { 0xE848, 0x9360 }, // CJK UNIFIED IDEOGRAPH
    { 0xE849, 0x937C }, // CJK UNIFIED IDEOGRAPH
    { 0xE84A, 0x936E }, // CJK UNIFIED IDEOGRAPH
    { 0xE84B, 0x9356 }, // CJK UNIFIED IDEOGRAPH
    { 0xE84C, 0x93B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE84D, 0x93AC }, // CJK UNIFIED IDEOGRAPH
    { 0xE84E, 0x93AD }, // CJK UNIFIED IDEOGRAPH
    { 0xE84F, 0x9394 }, // CJK UNIFIED IDEOGRAPH
    { 0xE850, 0x93B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE851, 0x93D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE852, 0x93D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE853, 0x93E8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE854, 0x93E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE855, 0x93D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE856, 0x93C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE857, 0x93DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE858, 0x93D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE859, 0x93C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE85A, 0x93E4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE85B, 0x941A }, // CJK UNIFIED IDEOGRAPH
    { 0xE85C, 0x9414 }, // CJK UNIFIED IDEOGRAPH
    { 0xE85D, 0x9413 }, // CJK UNIFIED IDEOGRAPH
    { 0xE85E, 0x9403 }, // CJK UNIFIED IDEOGRAPH
    { 0xE85F, 0x9407 }, // CJK UNIFIED IDEOGRAPH
    { 0xE860, 0x9410 }, // CJK UNIFIED IDEOGRAPH
    { 0xE861, 0x9436 }, // CJK UNIFIED IDEOGRAPH
    { 0xE862, 0x942B }, // CJK UNIFIED IDEOGRAPH
    { 0xE863, 0x9435 }, // CJK UNIFIED IDEOGRAPH
    { 0xE864, 0x9421 }, // CJK UNIFIED IDEOGRAPH
    { 0xE865, 0x943A }, // CJK UNIFIED IDEOGRAPH
    { 0xE866, 0x9441 }, // CJK UNIFIED IDEOGRAPH
    { 0xE867, 0x9452 }, // CJK UNIFIED IDEOGRAPH
    { 0xE868, 0x9444 }, // CJK UNIFIED IDEOGRAPH
    { 0xE869, 0x945B }, // CJK UNIFIED IDEOGRAPH
    { 0xE86A, 0x9460 }, // CJK UNIFIED IDEOGRAPH
    { 0xE86B, 0x9462 }, // CJK UNIFIED IDEOGRAPH
    { 0xE86C, 0x945E }, // CJK UNIFIED IDEOGRAPH
    { 0xE86D, 0x946A }, // CJK UNIFIED IDEOGRAPH
    { 0xE86E, 0x9229 }, // CJK UNIFIED IDEOGRAPH
    { 0xE86F, 0x9470 }, // CJK UNIFIED IDEOGRAPH
    { 0xE870, 0x9475 }, // CJK UNIFIED IDEOGRAPH
    { 0xE871, 0x9477 }, // CJK UNIFIED IDEOGRAPH
    { 0xE872, 0x947D }, // CJK UNIFIED IDEOGRAPH
    { 0xE873, 0x945A }, // CJK UNIFIED IDEOGRAPH
    { 0xE874, 0x947C }, // CJK UNIFIED IDEOGRAPH
    { 0xE875, 0x947E }, // CJK UNIFIED IDEOGRAPH
    { 0xE876, 0x9481 }, // CJK UNIFIED IDEOGRAPH
    { 0xE877, 0x947F }, // CJK UNIFIED IDEOGRAPH
    { 0xE878, 0x9582 }, // CJK UNIFIED IDEOGRAPH
    { 0xE879, 0x9587 }, // CJK UNIFIED IDEOGRAPH
    { 0xE87A, 0x958A }, // CJK UNIFIED IDEOGRAPH
    { 0xE87B, 0x9594 }, // CJK UNIFIED IDEOGRAPH
    { 0xE87C, 0x9596 }, // CJK UNIFIED IDEOGRAPH
    { 0xE87D, 0x9598 }, // CJK UNIFIED IDEOGRAPH
    { 0xE87E, 0x9599 }, // CJK UNIFIED IDEOGRAPH
    { 0xE880, 0x95A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE881, 0x95A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE882, 0x95A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE883, 0x95AD }, // CJK UNIFIED IDEOGRAPH
    { 0xE884, 0x95BC }, // CJK UNIFIED IDEOGRAPH
    { 0xE885, 0x95BB }, // CJK UNIFIED IDEOGRAPH
    { 0xE886, 0x95B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE887, 0x95BE }, // CJK UNIFIED IDEOGRAPH
    { 0xE888, 0x95CA }, // CJK UNIFIED IDEOGRAPH
    { 0xE889, 0x6FF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE88A, 0x95C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE88B, 0x95CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE88C, 0x95CC }, // CJK UNIFIED IDEOGRAPH
    { 0xE88D, 0x95D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE88E, 0x95D4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE88F, 0x95D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE890, 0x95DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE891, 0x95E1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE892, 0x95E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE893, 0x95E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE894, 0x9621 }, // CJK UNIFIED IDEOGRAPH
    { 0xE895, 0x9628 }, // CJK UNIFIED IDEOGRAPH
    { 0xE896, 0x962E }, // CJK UNIFIED IDEOGRAPH
    { 0xE897, 0x962F }, // CJK UNIFIED IDEOGRAPH
    { 0xE898, 0x9642 }, // CJK UNIFIED IDEOGRAPH
    { 0xE899, 0x964C }, // CJK UNIFIED IDEOGRAPH
    { 0xE89A, 0x964F }, // CJK UNIFIED IDEOGRAPH
    { 0xE89B, 0x964B }, // CJK UNIFIED IDEOGRAPH
    { 0xE89C, 0x9677 }, // CJK UNIFIED IDEOGRAPH
    { 0xE89D, 0x965C }, // CJK UNIFIED IDEOGRAPH
    { 0xE89E, 0x965E }, // CJK UNIFIED IDEOGRAPH
    { 0xE89F, 0x965D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A0, 0x965F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A1, 0x9666 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A2, 0x9672 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A3, 0x966C }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A4, 0x968D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A5, 0x9698 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A6, 0x9695 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A7, 0x9697 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A8, 0x96AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE8A9, 0x96A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AA, 0x96B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AB, 0x96B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AC, 0x96B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AD, 0x96B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AE, 0x96B6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8AF, 0x96B8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B0, 0x96B9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B1, 0x96CE }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B2, 0x96CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B3, 0x96C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B4, 0x96CD }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B5, 0x894D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B6, 0x96DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B7, 0x970D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B8, 0x96D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8B9, 0x96F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BA, 0x9704 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BB, 0x9706 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BC, 0x9708 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BD, 0x9713 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BE, 0x970E }, // CJK UNIFIED IDEOGRAPH
    { 0xE8BF, 0x9711 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C0, 0x970F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C1, 0x9716 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C2, 0x9719 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C3, 0x9724 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C4, 0x972A }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C5, 0x9730 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C6, 0x9739 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C7, 0x973D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C8, 0x973E }, // CJK UNIFIED IDEOGRAPH
    { 0xE8C9, 0x9744 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CA, 0x9746 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CB, 0x9748 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CC, 0x9742 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CD, 0x9749 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CE, 0x975C }, // CJK UNIFIED IDEOGRAPH
    { 0xE8CF, 0x9760 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D0, 0x9764 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D1, 0x9766 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D2, 0x9768 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D3, 0x52D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D4, 0x976B }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D5, 0x9771 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D6, 0x9779 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D7, 0x9785 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D8, 0x977C }, // CJK UNIFIED IDEOGRAPH
    { 0xE8D9, 0x9781 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DA, 0x977A }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DB, 0x9786 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DC, 0x978B }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DD, 0x978F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DE, 0x9790 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8DF, 0x979C }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E0, 0x97A8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E1, 0x97A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E2, 0x97A3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E3, 0x97B3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E4, 0x97B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E5, 0x97C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E6, 0x97C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E7, 0x97C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E8, 0x97CB }, // CJK UNIFIED IDEOGRAPH
    { 0xE8E9, 0x97DC }, // CJK UNIFIED IDEOGRAPH
    { 0xE8EA, 0x97ED }, // CJK UNIFIED IDEOGRAPH
    { 0xE8EB, 0x9F4F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8EC, 0x97F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8ED, 0x7ADF }, // CJK UNIFIED IDEOGRAPH
    { 0xE8EE, 0x97F6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8EF, 0x97F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F0, 0x980F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F1, 0x980C }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F2, 0x9838 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F3, 0x9824 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F4, 0x9821 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F5, 0x9837 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F6, 0x983D }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F7, 0x9846 }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F8, 0x984F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8F9, 0x984B }, // CJK UNIFIED IDEOGRAPH
    { 0xE8FA, 0x986B }, // CJK UNIFIED IDEOGRAPH
    { 0xE8FB, 0x986F }, // CJK UNIFIED IDEOGRAPH
    { 0xE8FC, 0x9870 }, // CJK UNIFIED IDEOGRAPH
    { 0xE940, 0x9871 }, // CJK UNIFIED IDEOGRAPH
    { 0xE941, 0x9874 }, // CJK UNIFIED IDEOGRAPH
    { 0xE942, 0x9873 }, // CJK UNIFIED IDEOGRAPH
    { 0xE943, 0x98AA }, // CJK UNIFIED IDEOGRAPH
    { 0xE944, 0x98AF }, // CJK UNIFIED IDEOGRAPH
    { 0xE945, 0x98B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE946, 0x98B6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE947, 0x98C4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE948, 0x98C3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE949, 0x98C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE94A, 0x98E9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE94B, 0x98EB }, // CJK UNIFIED IDEOGRAPH
    { 0xE94C, 0x9903 }, // CJK UNIFIED IDEOGRAPH
    { 0xE94D, 0x9909 }, // CJK UNIFIED IDEOGRAPH
    { 0xE94E, 0x9912 }, // CJK UNIFIED IDEOGRAPH
    { 0xE94F, 0x9914 }, // CJK UNIFIED IDEOGRAPH
    { 0xE950, 0x9918 }, // CJK UNIFIED IDEOGRAPH
    { 0xE951, 0x9921 }, // CJK UNIFIED IDEOGRAPH
    { 0xE952, 0x991D }, // CJK UNIFIED IDEOGRAPH
    { 0xE953, 0x991E }, // CJK UNIFIED IDEOGRAPH
    { 0xE954, 0x9924 }, // CJK UNIFIED IDEOGRAPH
    { 0xE955, 0x9920 }, // CJK UNIFIED IDEOGRAPH
    { 0xE956, 0x992C }, // CJK UNIFIED IDEOGRAPH
    { 0xE957, 0x992E }, // CJK UNIFIED IDEOGRAPH
    { 0xE958, 0x993D }, // CJK UNIFIED IDEOGRAPH
    { 0xE959, 0x993E }, // CJK UNIFIED IDEOGRAPH
    { 0xE95A, 0x9942 }, // CJK UNIFIED IDEOGRAPH
    { 0xE95B, 0x9949 }, // CJK UNIFIED IDEOGRAPH
    { 0xE95C, 0x9945 }, // CJK UNIFIED IDEOGRAPH
    { 0xE95D, 0x9950 }, // CJK UNIFIED IDEOGRAPH
    { 0xE95E, 0x994B }, // CJK UNIFIED IDEOGRAPH
    { 0xE95F, 0x9951 }, // CJK UNIFIED IDEOGRAPH
    { 0xE960, 0x9952 }, // CJK UNIFIED IDEOGRAPH
    { 0xE961, 0x994C }, // CJK UNIFIED IDEOGRAPH
    { 0xE962, 0x9955 }, // CJK UNIFIED IDEOGRAPH
    { 0xE963, 0x9997 }, // CJK UNIFIED IDEOGRAPH
    { 0xE964, 0x9998 }, // CJK UNIFIED IDEOGRAPH
    { 0xE965, 0x99A5 }, // CJK UNIFIED IDEOGRAPH
    { 0xE966, 0x99AD }, // CJK UNIFIED IDEOGRAPH
    { 0xE967, 0x99AE }, // CJK UNIFIED IDEOGRAPH
    { 0xE968, 0x99BC }, // CJK UNIFIED IDEOGRAPH
    { 0xE969, 0x99DF }, // CJK UNIFIED IDEOGRAPH
    { 0xE96A, 0x99DB }, // CJK UNIFIED IDEOGRAPH
    { 0xE96B, 0x99DD }, // CJK UNIFIED IDEOGRAPH
    { 0xE96C, 0x99D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE96D, 0x99D1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE96E, 0x99ED }, // CJK UNIFIED IDEOGRAPH
    { 0xE96F, 0x99EE }, // CJK UNIFIED IDEOGRAPH
    { 0xE970, 0x99F1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE971, 0x99F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE972, 0x99FB }, // CJK UNIFIED IDEOGRAPH
    { 0xE973, 0x99F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE974, 0x9A01 }, // CJK UNIFIED IDEOGRAPH
    { 0xE975, 0x9A0F }, // CJK UNIFIED IDEOGRAPH
    { 0xE976, 0x9A05 }, // CJK UNIFIED IDEOGRAPH
    { 0xE977, 0x99E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE978, 0x9A19 }, // CJK UNIFIED IDEOGRAPH
    { 0xE979, 0x9A2B }, // CJK UNIFIED IDEOGRAPH
    { 0xE97A, 0x9A37 }, // CJK UNIFIED IDEOGRAPH
    { 0xE97B, 0x9A45 }, // CJK UNIFIED IDEOGRAPH
    { 0xE97C, 0x9A42 }, // CJK UNIFIED IDEOGRAPH
    { 0xE97D, 0x9A40 }, // CJK UNIFIED IDEOGRAPH
    { 0xE97E, 0x9A43 }, // CJK UNIFIED IDEOGRAPH
    { 0xE980, 0x9A3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE981, 0x9A55 }, // CJK UNIFIED IDEOGRAPH
    { 0xE982, 0x9A4D }, // CJK UNIFIED IDEOGRAPH
    { 0xE983, 0x9A5B }, // CJK UNIFIED IDEOGRAPH
    { 0xE984, 0x9A57 }, // CJK UNIFIED IDEOGRAPH
    { 0xE985, 0x9A5F }, // CJK UNIFIED IDEOGRAPH
    { 0xE986, 0x9A62 }, // CJK UNIFIED IDEOGRAPH
    { 0xE987, 0x9A65 }, // CJK UNIFIED IDEOGRAPH
    { 0xE988, 0x9A64 }, // CJK UNIFIED IDEOGRAPH
    { 0xE989, 0x9A69 }, // CJK UNIFIED IDEOGRAPH
    { 0xE98A, 0x9A6B }, // CJK UNIFIED IDEOGRAPH
    { 0xE98B, 0x9A6A }, // CJK UNIFIED IDEOGRAPH
    { 0xE98C, 0x9AAD }, // CJK UNIFIED IDEOGRAPH
    { 0xE98D, 0x9AB0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE98E, 0x9ABC }, // CJK UNIFIED IDEOGRAPH
    { 0xE98F, 0x9AC0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE990, 0x9ACF }, // CJK UNIFIED IDEOGRAPH
    { 0xE991, 0x9AD1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE992, 0x9AD3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE993, 0x9AD4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE994, 0x9ADE }, // CJK UNIFIED IDEOGRAPH
    { 0xE995, 0x9ADF }, // CJK UNIFIED IDEOGRAPH
    { 0xE996, 0x9AE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE997, 0x9AE3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE998, 0x9AE6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE999, 0x9AEF }, // CJK UNIFIED IDEOGRAPH
    { 0xE99A, 0x9AEB }, // CJK UNIFIED IDEOGRAPH
    { 0xE99B, 0x9AEE }, // CJK UNIFIED IDEOGRAPH
    { 0xE99C, 0x9AF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE99D, 0x9AF1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE99E, 0x9AF7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE99F, 0x9AFB }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A0, 0x9B06 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A1, 0x9B18 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A2, 0x9B1A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A3, 0x9B1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A4, 0x9B22 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A5, 0x9B23 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A6, 0x9B25 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A7, 0x9B27 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A8, 0x9B28 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9A9, 0x9B29 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AA, 0x9B2A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AB, 0x9B2E }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AC, 0x9B2F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AD, 0x9B32 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AE, 0x9B44 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9AF, 0x9B43 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B0, 0x9B4F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B1, 0x9B4D }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B2, 0x9B4E }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B3, 0x9B51 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B4, 0x9B58 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B5, 0x9B74 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B6, 0x9B93 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B7, 0x9B83 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B8, 0x9B91 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9B9, 0x9B96 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BA, 0x9B97 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BB, 0x9B9F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BC, 0x9BA0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BD, 0x9BA8 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BE, 0x9BB4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9BF, 0x9BC0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C0, 0x9BCA }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C1, 0x9BB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C2, 0x9BC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C3, 0x9BCF }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C4, 0x9BD1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C5, 0x9BD2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C6, 0x9BE3 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C7, 0x9BE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C8, 0x9BE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9C9, 0x9BD4 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CA, 0x9BE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CB, 0x9C3A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CC, 0x9BF2 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CD, 0x9BF1 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CE, 0x9BF0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9CF, 0x9C15 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D0, 0x9C14 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D1, 0x9C09 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D2, 0x9C13 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D3, 0x9C0C }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D4, 0x9C06 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D5, 0x9C08 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D6, 0x9C12 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D7, 0x9C0A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D8, 0x9C04 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9D9, 0x9C2E }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DA, 0x9C1B }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DB, 0x9C25 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DC, 0x9C24 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DD, 0x9C21 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DE, 0x9C30 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9DF, 0x9C47 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E0, 0x9C32 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E1, 0x9C46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E2, 0x9C3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E3, 0x9C5A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E4, 0x9C60 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E5, 0x9C67 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E6, 0x9C76 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E7, 0x9C78 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E8, 0x9CE7 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9E9, 0x9CEC }, // CJK UNIFIED IDEOGRAPH
    { 0xE9EA, 0x9CF0 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9EB, 0x9D09 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9EC, 0x9D08 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9ED, 0x9CEB }, // CJK UNIFIED IDEOGRAPH
    { 0xE9EE, 0x9D03 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9EF, 0x9D06 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F0, 0x9D2A }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F1, 0x9D26 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F2, 0x9DAF }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F3, 0x9D23 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F4, 0x9D1F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F5, 0x9D44 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F6, 0x9D15 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F7, 0x9D12 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F8, 0x9D41 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9F9, 0x9D3F }, // CJK UNIFIED IDEOGRAPH
    { 0xE9FA, 0x9D3E }, // CJK UNIFIED IDEOGRAPH
    { 0xE9FB, 0x9D46 }, // CJK UNIFIED IDEOGRAPH
    { 0xE9FC, 0x9D48 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA40, 0x9D5D }, // CJK UNIFIED IDEOGRAPH
    { 0xEA41, 0x9D5E }, // CJK UNIFIED IDEOGRAPH
    { 0xEA42, 0x9D64 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA43, 0x9D51 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA44, 0x9D50 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA45, 0x9D59 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA46, 0x9D72 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA47, 0x9D89 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA48, 0x9D87 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA49, 0x9DAB }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4A, 0x9D6F }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4B, 0x9D7A }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4C, 0x9D9A }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4D, 0x9DA4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4E, 0x9DA9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA4F, 0x9DB2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA50, 0x9DC4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA51, 0x9DC1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA52, 0x9DBB }, // CJK UNIFIED IDEOGRAPH
    { 0xEA53, 0x9DB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA54, 0x9DBA }, // CJK UNIFIED IDEOGRAPH
    { 0xEA55, 0x9DC6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA56, 0x9DCF }, // CJK UNIFIED IDEOGRAPH
    { 0xEA57, 0x9DC2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA58, 0x9DD9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA59, 0x9DD3 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5A, 0x9DF8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5B, 0x9DE6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5C, 0x9DED }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5D, 0x9DEF }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5E, 0x9DFD }, // CJK UNIFIED IDEOGRAPH
    { 0xEA5F, 0x9E1A }, // CJK UNIFIED IDEOGRAPH
    { 0xEA60, 0x9E1B }, // CJK UNIFIED IDEOGRAPH
    { 0xEA61, 0x9E1E }, // CJK UNIFIED IDEOGRAPH
    { 0xEA62, 0x9E75 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA63, 0x9E79 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA64, 0x9E7D }, // CJK UNIFIED IDEOGRAPH
    { 0xEA65, 0x9E81 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA66, 0x9E88 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA67, 0x9E8B }, // CJK UNIFIED IDEOGRAPH
    { 0xEA68, 0x9E8C }, // CJK UNIFIED IDEOGRAPH
    { 0xEA69, 0x9E92 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6A, 0x9E95 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6B, 0x9E91 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6C, 0x9E9D }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6D, 0x9EA5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6E, 0x9EA9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA6F, 0x9EB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA70, 0x9EAA }, // CJK UNIFIED IDEOGRAPH
    { 0xEA71, 0x9EAD }, // CJK UNIFIED IDEOGRAPH
    { 0xEA72, 0x9761 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA73, 0x9ECC }, // CJK UNIFIED IDEOGRAPH
    { 0xEA74, 0x9ECE }, // CJK UNIFIED IDEOGRAPH
    { 0xEA75, 0x9ECF }, // CJK UNIFIED IDEOGRAPH
    { 0xEA76, 0x9ED0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA77, 0x9ED4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA78, 0x9EDC }, // CJK UNIFIED IDEOGRAPH
    { 0xEA79, 0x9EDE }, // CJK UNIFIED IDEOGRAPH
    { 0xEA7A, 0x9EDD }, // CJK UNIFIED IDEOGRAPH
    { 0xEA7B, 0x9EE0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA7C, 0x9EE5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA7D, 0x9EE8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA7E, 0x9EEF }, // CJK UNIFIED IDEOGRAPH
    { 0xEA80, 0x9EF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA81, 0x9EF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA82, 0x9EF7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA83, 0x9EF9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA84, 0x9EFB }, // CJK UNIFIED IDEOGRAPH
    { 0xEA85, 0x9EFC }, // CJK UNIFIED IDEOGRAPH
    { 0xEA86, 0x9EFD }, // CJK UNIFIED IDEOGRAPH
    { 0xEA87, 0x9F07 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA88, 0x9F08 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA89, 0x76B7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8A, 0x9F15 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8B, 0x9F21 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8C, 0x9F2C }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8D, 0x9F3E }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8E, 0x9F4A }, // CJK UNIFIED IDEOGRAPH
    { 0xEA8F, 0x9F52 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA90, 0x9F54 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA91, 0x9F63 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA92, 0x9F5F }, // CJK UNIFIED IDEOGRAPH
    { 0xEA93, 0x9F60 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA94, 0x9F61 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA95, 0x9F66 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA96, 0x9F67 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA97, 0x9F6C }, // CJK UNIFIED IDEOGRAPH
    { 0xEA98, 0x9F6A }, // CJK UNIFIED IDEOGRAPH
    { 0xEA99, 0x9F77 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9A, 0x9F72 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9B, 0x9F76 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9C, 0x9F95 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9D, 0x9F9C }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9E, 0x9FA0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEA9F, 0x582F }, // CJK UNIFIED IDEOGRAPH
    { 0xEAA0, 0x69C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEAA1, 0x9059 }, // CJK UNIFIED IDEOGRAPH
    { 0xEAA2, 0x7464 }, // CJK UNIFIED IDEOGRAPH
    { 0xEAA3, 0x51DC }, // CJK UNIFIED IDEOGRAPH
    { 0xEAA4, 0x7199 }, // CJK UNIFIED IDEOGRAPH
    { 0xED40, 0x7E8A }, // CJK UNIFIED IDEOGRAPH
    { 0xED41, 0x891C }, // CJK UNIFIED IDEOGRAPH
    { 0xED42, 0x9348 }, // CJK UNIFIED IDEOGRAPH
    { 0xED43, 0x9288 }, // CJK UNIFIED IDEOGRAPH
    { 0xED44, 0x84DC }, // CJK UNIFIED IDEOGRAPH
    { 0xED45, 0x4FC9 }, // CJK UNIFIED IDEOGRAPH
    { 0xED46, 0x70BB }, // CJK UNIFIED IDEOGRAPH
    { 0xED47, 0x6631 }, // CJK UNIFIED IDEOGRAPH
    { 0xED48, 0x68C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xED49, 0x92F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xED4A, 0x66FB }, // CJK UNIFIED IDEOGRAPH
    { 0xED4B, 0x5F45 }, // CJK UNIFIED IDEOGRAPH
    { 0xED4C, 0x4E28 }, // CJK UNIFIED IDEOGRAPH
    { 0xED4D, 0x4EE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xED4E, 0x4EFC }, // CJK UNIFIED IDEOGRAPH
    { 0xED4F, 0x4F00 }, // CJK UNIFIED IDEOGRAPH
    { 0xED50, 0x4F03 }, // CJK UNIFIED IDEOGRAPH
    { 0xED51, 0x4F39 }, // CJK UNIFIED IDEOGRAPH
    { 0xED52, 0x4F56 }, // CJK UNIFIED IDEOGRAPH
    { 0xED53, 0x4F92 }, // CJK UNIFIED IDEOGRAPH
    { 0xED54, 0x4F8A }, // CJK UNIFIED IDEOGRAPH
    { 0xED55, 0x4F9A }, // CJK UNIFIED IDEOGRAPH
    { 0xED56, 0x4F94 }, // CJK UNIFIED IDEOGRAPH
    { 0xED57, 0x4FCD }, // CJK UNIFIED IDEOGRAPH
    { 0xED58, 0x5040 }, // CJK UNIFIED IDEOGRAPH
    { 0xED59, 0x5022 }, // CJK UNIFIED IDEOGRAPH
    { 0xED5A, 0x4FFF }, // CJK UNIFIED IDEOGRAPH
    { 0xED5B, 0x501E }, // CJK UNIFIED IDEOGRAPH
    { 0xED5C, 0x5046 }, // CJK UNIFIED IDEOGRAPH
    { 0xED5D, 0x5070 }, // CJK UNIFIED IDEOGRAPH
    { 0xED5E, 0x5042 }, // CJK UNIFIED IDEOGRAPH
    { 0xED5F, 0x5094 }, // CJK UNIFIED IDEOGRAPH
    { 0xED60, 0x50F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xED61, 0x50D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xED62, 0x514A }, // CJK UNIFIED IDEOGRAPH
    { 0xED63, 0x5164 }, // CJK UNIFIED IDEOGRAPH
    { 0xED64, 0x519D }, // CJK UNIFIED IDEOGRAPH
    { 0xED65, 0x51BE }, // CJK UNIFIED IDEOGRAPH
    { 0xED66, 0x51EC }, // CJK UNIFIED IDEOGRAPH
    { 0xED67, 0x5215 }, // CJK UNIFIED IDEOGRAPH
    { 0xED68, 0x529C }, // CJK UNIFIED IDEOGRAPH
    { 0xED69, 0x52A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xED6A, 0x52C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xED6B, 0x52DB }, // CJK UNIFIED IDEOGRAPH
    { 0xED6C, 0x5300 }, // CJK UNIFIED IDEOGRAPH
    { 0xED6D, 0x5307 }, // CJK UNIFIED IDEOGRAPH
    { 0xED6E, 0x5324 }, // CJK UNIFIED IDEOGRAPH
    { 0xED6F, 0x5372 }, // CJK UNIFIED IDEOGRAPH
    { 0xED70, 0x5393 }, // CJK UNIFIED IDEOGRAPH
    { 0xED71, 0x53B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xED72, 0x53DD }, // CJK UNIFIED IDEOGRAPH
    { 0xED73, 0xFA0E }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xED74, 0x549C }, // CJK UNIFIED IDEOGRAPH
    { 0xED75, 0x548A }, // CJK UNIFIED IDEOGRAPH
    { 0xED76, 0x54A9 }, // CJK UNIFIED IDEOGRAPH
    { 0xED77, 0x54FF }, // CJK UNIFIED IDEOGRAPH
    { 0xED78, 0x5586 }, // CJK UNIFIED IDEOGRAPH
    { 0xED79, 0x5759 }, // CJK UNIFIED IDEOGRAPH
    { 0xED7A, 0x5765 }, // CJK UNIFIED IDEOGRAPH
    { 0xED7B, 0x57AC }, // CJK UNIFIED IDEOGRAPH
    { 0xED7C, 0x57C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xED7D, 0x57C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xED7E, 0xFA0F }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xED80, 0xFA10 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xED81, 0x589E }, // CJK UNIFIED IDEOGRAPH
    { 0xED82, 0x58B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xED83, 0x590B }, // CJK UNIFIED IDEOGRAPH
    { 0xED84, 0x5953 }, // CJK UNIFIED IDEOGRAPH
    { 0xED85, 0x595B }, // CJK UNIFIED IDEOGRAPH
    { 0xED86, 0x595D }, // CJK UNIFIED IDEOGRAPH
    { 0xED87, 0x5963 }, // CJK UNIFIED IDEOGRAPH
    { 0xED88, 0x59A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xED89, 0x59BA }, // CJK UNIFIED IDEOGRAPH
    { 0xED8A, 0x5B56 }, // CJK UNIFIED IDEOGRAPH
    { 0xED8B, 0x5BC0 }, // CJK UNIFIED IDEOGRAPH
    { 0xED8C, 0x752F }, // CJK UNIFIED IDEOGRAPH
    { 0xED8D, 0x5BD8 }, // CJK UNIFIED IDEOGRAPH
    { 0xED8E, 0x5BEC }, // CJK UNIFIED IDEOGRAPH
    { 0xED8F, 0x5C1E }, // CJK UNIFIED IDEOGRAPH
    { 0xED90, 0x5CA6 }, // CJK UNIFIED IDEOGRAPH
    { 0xED91, 0x5CBA }, // CJK UNIFIED IDEOGRAPH
    { 0xED92, 0x5CF5 }, // CJK UNIFIED IDEOGRAPH
    { 0xED93, 0x5D27 }, // CJK UNIFIED IDEOGRAPH
    { 0xED94, 0x5D53 }, // CJK UNIFIED IDEOGRAPH
    { 0xED95, 0xFA11 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xED96, 0x5D42 }, // CJK UNIFIED IDEOGRAPH
    { 0xED97, 0x5D6D }, // CJK UNIFIED IDEOGRAPH
    { 0xED98, 0x5DB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xED99, 0x5DB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9A, 0x5DD0 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9B, 0x5F21 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9C, 0x5F34 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9D, 0x5F67 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9E, 0x5FB7 }, // CJK UNIFIED IDEOGRAPH
    { 0xED9F, 0x5FDE }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA0, 0x605D }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA1, 0x6085 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA2, 0x608A }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA3, 0x60DE }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA4, 0x60D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA5, 0x6120 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA6, 0x60F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA7, 0x6111 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA8, 0x6137 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDA9, 0x6130 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAA, 0x6198 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAB, 0x6213 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAC, 0x62A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAD, 0x63F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAE, 0x6460 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDAF, 0x649D }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB0, 0x64CE }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB1, 0x654E }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB2, 0x6600 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB3, 0x6615 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB4, 0x663B }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB5, 0x6609 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB6, 0x662E }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB7, 0x661E }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB8, 0x6624 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDB9, 0x6665 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDBA, 0x6657 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDBB, 0x6659 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDBC, 0xFA12 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEDBD, 0x6673 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDBE, 0x6699 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDBF, 0x66A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC0, 0x66B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC1, 0x66BF }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC2, 0x66FA }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC3, 0x670E }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC4, 0xF929 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEDC5, 0x6766 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC6, 0x67BB }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC7, 0x6852 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC8, 0x67C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDC9, 0x6801 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDCA, 0x6844 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDCB, 0x68CF }, // CJK UNIFIED IDEOGRAPH
    { 0xEDCC, 0xFA13 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEDCD, 0x6968 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDCE, 0xFA14 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEDCF, 0x6998 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD0, 0x69E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD1, 0x6A30 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD2, 0x6A6B }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD3, 0x6A46 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD4, 0x6A73 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD5, 0x6A7E }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD6, 0x6AE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD7, 0x6AE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD8, 0x6BD6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDD9, 0x6C3F }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDA, 0x6C5C }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDB, 0x6C86 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDC, 0x6C6F }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDD, 0x6CDA }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDE, 0x6D04 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDDF, 0x6D87 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE0, 0x6D6F }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE1, 0x6D96 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE2, 0x6DAC }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE3, 0x6DCF }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE4, 0x6DF8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE5, 0x6DF2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE6, 0x6DFC }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE7, 0x6E39 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE8, 0x6E5C }, // CJK UNIFIED IDEOGRAPH
    { 0xEDE9, 0x6E27 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDEA, 0x6E3C }, // CJK UNIFIED IDEOGRAPH
    { 0xEDEB, 0x6EBF }, // CJK UNIFIED IDEOGRAPH
    { 0xEDEC, 0x6F88 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDED, 0x6FB5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDEE, 0x6FF5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDEF, 0x7005 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF0, 0x7007 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF1, 0x7028 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF2, 0x7085 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF3, 0x70AB }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF4, 0x710F }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF5, 0x7104 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF6, 0x715C }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF7, 0x7146 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF8, 0x7147 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDF9, 0xFA15 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEDFA, 0x71C1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEDFB, 0x71FE }, // CJK UNIFIED IDEOGRAPH
    { 0xEDFC, 0x72B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE40, 0x72BE }, // CJK UNIFIED IDEOGRAPH
    { 0xEE41, 0x7324 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE42, 0xFA16 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE43, 0x7377 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE44, 0x73BD }, // CJK UNIFIED IDEOGRAPH
    { 0xEE45, 0x73C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE46, 0x73D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE47, 0x73E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE48, 0x73D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE49, 0x7407 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4A, 0x73F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4B, 0x7426 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4C, 0x742A }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4D, 0x7429 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4E, 0x742E }, // CJK UNIFIED IDEOGRAPH
    { 0xEE4F, 0x7462 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE50, 0x7489 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE51, 0x749F }, // CJK UNIFIED IDEOGRAPH
    { 0xEE52, 0x7501 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE53, 0x756F }, // CJK UNIFIED IDEOGRAPH
    { 0xEE54, 0x7682 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE55, 0x769C }, // CJK UNIFIED IDEOGRAPH
    { 0xEE56, 0x769E }, // CJK UNIFIED IDEOGRAPH
    { 0xEE57, 0x769B }, // CJK UNIFIED IDEOGRAPH
    { 0xEE58, 0x76A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE59, 0xFA17 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE5A, 0x7746 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE5B, 0x52AF }, // CJK UNIFIED IDEOGRAPH
    { 0xEE5C, 0x7821 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE5D, 0x784E }, // CJK UNIFIED IDEOGRAPH
    { 0xEE5E, 0x7864 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE5F, 0x787A }, // CJK UNIFIED IDEOGRAPH
    { 0xEE60, 0x7930 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE61, 0xFA18 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE62, 0xFA19 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE63, 0xFA1A }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE64, 0x7994 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE65, 0xFA1B }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE66, 0x799B }, // CJK UNIFIED IDEOGRAPH
    { 0xEE67, 0x7AD1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE68, 0x7AE7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE69, 0xFA1C }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE6A, 0x7AEB }, // CJK UNIFIED IDEOGRAPH
    { 0xEE6B, 0x7B9E }, // CJK UNIFIED IDEOGRAPH
    { 0xEE6C, 0xFA1D }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE6D, 0x7D48 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE6E, 0x7D5C }, // CJK UNIFIED IDEOGRAPH
    { 0xEE6F, 0x7DB7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE70, 0x7DA0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE71, 0x7DD6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE72, 0x7E52 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE73, 0x7F47 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE74, 0x7FA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE75, 0xFA1E }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE76, 0x8301 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE77, 0x8362 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE78, 0x837F }, // CJK UNIFIED IDEOGRAPH
    { 0xEE79, 0x83C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE7A, 0x83F6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE7B, 0x8448 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE7C, 0x84B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE7D, 0x8553 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE7E, 0x8559 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE80, 0x856B }, // CJK UNIFIED IDEOGRAPH
    { 0xEE81, 0xFA1F }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE82, 0x85B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE83, 0xFA20 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE84, 0xFA21 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE85, 0x8807 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE86, 0x88F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE87, 0x8A12 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE88, 0x8A37 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE89, 0x8A79 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE8A, 0x8AA7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE8B, 0x8ABE }, // CJK UNIFIED IDEOGRAPH
    { 0xEE8C, 0x8ADF }, // CJK UNIFIED IDEOGRAPH
    { 0xEE8D, 0xFA22 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE8E, 0x8AF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE8F, 0x8B53 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE90, 0x8B7F }, // CJK UNIFIED IDEOGRAPH
    { 0xEE91, 0x8CF0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE92, 0x8CF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE93, 0x8D12 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE94, 0x8D76 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE95, 0xFA23 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE96, 0x8ECF }, // CJK UNIFIED IDEOGRAPH
    { 0xEE97, 0xFA24 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE98, 0xFA25 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE99, 0x9067 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE9A, 0x90DE }, // CJK UNIFIED IDEOGRAPH
    { 0xEE9B, 0xFA26 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEE9C, 0x9115 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE9D, 0x9127 }, // CJK UNIFIED IDEOGRAPH
    { 0xEE9E, 0x91DA }, // CJK UNIFIED IDEOGRAPH
    { 0xEE9F, 0x91D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA0, 0x91DE }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA1, 0x91ED }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA2, 0x91EE }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA3, 0x91E4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA4, 0x91E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA5, 0x9206 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA6, 0x9210 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA7, 0x920A }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA8, 0x923A }, // CJK UNIFIED IDEOGRAPH
    { 0xEEA9, 0x9240 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAA, 0x923C }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAB, 0x924E }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAC, 0x9259 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAD, 0x9251 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAE, 0x9239 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEAF, 0x9267 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB0, 0x92A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB1, 0x9277 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB2, 0x9278 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB3, 0x92E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB4, 0x92D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB5, 0x92D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB6, 0x92D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB7, 0xFA27 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEB8, 0x92D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEB9, 0x92E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEBA, 0x92D3 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEBB, 0x9325 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEBC, 0x9321 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEBD, 0x92FB }, // CJK UNIFIED IDEOGRAPH
    { 0xEEBE, 0xFA28 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEBF, 0x931E }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC0, 0x92FF }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC1, 0x931D }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC2, 0x9302 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC3, 0x9370 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC4, 0x9357 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC5, 0x93A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC6, 0x93C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC7, 0x93DE }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC8, 0x93F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEC9, 0x9431 }, // CJK UNIFIED IDEOGRAPH
    { 0xEECA, 0x9445 }, // CJK UNIFIED IDEOGRAPH
    { 0xEECB, 0x9448 }, // CJK UNIFIED IDEOGRAPH
    { 0xEECC, 0x9592 }, // CJK UNIFIED IDEOGRAPH
    { 0xEECD, 0xF9DC }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEECE, 0xFA29 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEECF, 0x969D }, // CJK UNIFIED IDEOGRAPH
    { 0xEED0, 0x96AF }, // CJK UNIFIED IDEOGRAPH
    { 0xEED1, 0x9733 }, // CJK UNIFIED IDEOGRAPH
    { 0xEED2, 0x973B }, // CJK UNIFIED IDEOGRAPH
    { 0xEED3, 0x9743 }, // CJK UNIFIED IDEOGRAPH
    { 0xEED4, 0x974D }, // CJK UNIFIED IDEOGRAPH
    { 0xEED5, 0x974F }, // CJK UNIFIED IDEOGRAPH
    { 0xEED6, 0x9751 }, // CJK UNIFIED IDEOGRAPH
    { 0xEED7, 0x9755 }, // CJK UNIFIED IDEOGRAPH
    { 0xEED8, 0x9857 }, // CJK UNIFIED IDEOGRAPH
    { 0xEED9, 0x9865 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEDA, 0xFA2A }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEDB, 0xFA2B }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEDC, 0x9927 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEDD, 0xFA2C }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEDE, 0x999E }, // CJK UNIFIED IDEOGRAPH
    { 0xEEDF, 0x9A4E }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE0, 0x9AD9 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE1, 0x9ADC }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE2, 0x9B75 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE3, 0x9B72 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE4, 0x9B8F }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE5, 0x9BB1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE6, 0x9BBB }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE7, 0x9C00 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE8, 0x9D70 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEE9, 0x9D6B }, // CJK UNIFIED IDEOGRAPH
    { 0xEEEA, 0xFA2D }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xEEEB, 0x9E19 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEEC, 0x9ED1 }, // CJK UNIFIED IDEOGRAPH
    { 0xEEEF, 0x2170 }, // SMALL ROMAN NUMERAL ONE
    { 0xEEF0, 0x2171 }, // SMALL ROMAN NUMERAL TWO
    { 0xEEF1, 0x2172 }, // SMALL ROMAN NUMERAL THREE
    { 0xEEF2, 0x2173 }, // SMALL ROMAN NUMERAL FOUR
    { 0xEEF3, 0x2174 }, // SMALL ROMAN NUMERAL FIVE
    { 0xEEF4, 0x2175 }, // SMALL ROMAN NUMERAL SIX
    { 0xEEF5, 0x2176 }, // SMALL ROMAN NUMERAL SEVEN
    { 0xEEF6, 0x2177 }, // SMALL ROMAN NUMERAL EIGHT
    { 0xEEF7, 0x2178 }, // SMALL ROMAN NUMERAL NINE
    { 0xEEF8, 0x2179 }, // SMALL ROMAN NUMERAL TEN
    { 0xEEF9, 0xFFE2 }, // FULLWIDTH NOT SIGN
    { 0xEEFA, 0xFFE4 }, // FULLWIDTH BROKEN BAR
    { 0xEEFB, 0xFF07 }, // FULLWIDTH APOSTROPHE
    { 0xEEFC, 0xFF02 }, // FULLWIDTH QUOTATION MARK
    { 0xFA40, 0x2170 }, // SMALL ROMAN NUMERAL ONE
    { 0xFA41, 0x2171 }, // SMALL ROMAN NUMERAL TWO
    { 0xFA42, 0x2172 }, // SMALL ROMAN NUMERAL THREE
    { 0xFA43, 0x2173 }, // SMALL ROMAN NUMERAL FOUR
    { 0xFA44, 0x2174 }, // SMALL ROMAN NUMERAL FIVE
    { 0xFA45, 0x2175 }, // SMALL ROMAN NUMERAL SIX
    { 0xFA46, 0x2176 }, // SMALL ROMAN NUMERAL SEVEN
    { 0xFA47, 0x2177 }, // SMALL ROMAN NUMERAL EIGHT
    { 0xFA48, 0x2178 }, // SMALL ROMAN NUMERAL NINE
    { 0xFA49, 0x2179 }, // SMALL ROMAN NUMERAL TEN
    { 0xFA4A, 0x2160 }, // ROMAN NUMERAL ONE
    { 0xFA4B, 0x2161 }, // ROMAN NUMERAL TWO
    { 0xFA4C, 0x2162 }, // ROMAN NUMERAL THREE
    { 0xFA4D, 0x2163 }, // ROMAN NUMERAL FOUR
    { 0xFA4E, 0x2164 }, // ROMAN NUMERAL FIVE
    { 0xFA4F, 0x2165 }, // ROMAN NUMERAL SIX
    { 0xFA50, 0x2166 }, // ROMAN NUMERAL SEVEN
    { 0xFA51, 0x2167 }, // ROMAN NUMERAL EIGHT
    { 0xFA52, 0x2168 }, // ROMAN NUMERAL NINE
    { 0xFA53, 0x2169 }, // ROMAN NUMERAL TEN
    { 0xFA54, 0xFFE2 }, // FULLWIDTH NOT SIGN
    { 0xFA55, 0xFFE4 }, // FULLWIDTH BROKEN BAR
    { 0xFA56, 0xFF07 }, // FULLWIDTH APOSTROPHE
    { 0xFA57, 0xFF02 }, // FULLWIDTH QUOTATION MARK
    { 0xFA58, 0x3231 }, // PARENTHESIZED IDEOGRAPH STOCK
    { 0xFA59, 0x2116 }, // NUMERO SIGN
    { 0xFA5A, 0x2121 }, // TELEPHONE SIGN
    { 0xFA5B, 0x2235 }, // BECAUSE
    { 0xFA5C, 0x7E8A }, // CJK UNIFIED IDEOGRAPH
    { 0xFA5D, 0x891C }, // CJK UNIFIED IDEOGRAPH
    { 0xFA5E, 0x9348 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA5F, 0x9288 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA60, 0x84DC }, // CJK UNIFIED IDEOGRAPH
    { 0xFA61, 0x4FC9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA62, 0x70BB }, // CJK UNIFIED IDEOGRAPH
    { 0xFA63, 0x6631 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA64, 0x68C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA65, 0x92F9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA66, 0x66FB }, // CJK UNIFIED IDEOGRAPH
    { 0xFA67, 0x5F45 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA68, 0x4E28 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA69, 0x4EE1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6A, 0x4EFC }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6B, 0x4F00 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6C, 0x4F03 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6D, 0x4F39 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6E, 0x4F56 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA6F, 0x4F92 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA70, 0x4F8A }, // CJK UNIFIED IDEOGRAPH
    { 0xFA71, 0x4F9A }, // CJK UNIFIED IDEOGRAPH
    { 0xFA72, 0x4F94 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA73, 0x4FCD }, // CJK UNIFIED IDEOGRAPH
    { 0xFA74, 0x5040 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA75, 0x5022 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA76, 0x4FFF }, // CJK UNIFIED IDEOGRAPH
    { 0xFA77, 0x501E }, // CJK UNIFIED IDEOGRAPH
    { 0xFA78, 0x5046 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA79, 0x5070 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA7A, 0x5042 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA7B, 0x5094 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA7C, 0x50F4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA7D, 0x50D8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA7E, 0x514A }, // CJK UNIFIED IDEOGRAPH
    { 0xFA80, 0x5164 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA81, 0x519D }, // CJK UNIFIED IDEOGRAPH
    { 0xFA82, 0x51BE }, // CJK UNIFIED IDEOGRAPH
    { 0xFA83, 0x51EC }, // CJK UNIFIED IDEOGRAPH
    { 0xFA84, 0x5215 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA85, 0x529C }, // CJK UNIFIED IDEOGRAPH
    { 0xFA86, 0x52A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA87, 0x52C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA88, 0x52DB }, // CJK UNIFIED IDEOGRAPH
    { 0xFA89, 0x5300 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8A, 0x5307 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8B, 0x5324 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8C, 0x5372 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8D, 0x5393 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8E, 0x53B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA8F, 0x53DD }, // CJK UNIFIED IDEOGRAPH
    { 0xFA90, 0xFA0E }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFA91, 0x549C }, // CJK UNIFIED IDEOGRAPH
    { 0xFA92, 0x548A }, // CJK UNIFIED IDEOGRAPH
    { 0xFA93, 0x54A9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA94, 0x54FF }, // CJK UNIFIED IDEOGRAPH
    { 0xFA95, 0x5586 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA96, 0x5759 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA97, 0x5765 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA98, 0x57AC }, // CJK UNIFIED IDEOGRAPH
    { 0xFA99, 0x57C8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA9A, 0x57C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA9B, 0xFA0F }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFA9C, 0xFA10 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFA9D, 0x589E }, // CJK UNIFIED IDEOGRAPH
    { 0xFA9E, 0x58B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFA9F, 0x590B }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA0, 0x5953 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA1, 0x595B }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA2, 0x595D }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA3, 0x5963 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA4, 0x59A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA5, 0x59BA }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA6, 0x5B56 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA7, 0x5BC0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA8, 0x752F }, // CJK UNIFIED IDEOGRAPH
    { 0xFAA9, 0x5BD8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAA, 0x5BEC }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAB, 0x5C1E }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAC, 0x5CA6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAD, 0x5CBA }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAE, 0x5CF5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAAF, 0x5D27 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB0, 0x5D53 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB1, 0xFA11 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFAB2, 0x5D42 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB3, 0x5D6D }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB4, 0x5DB8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB5, 0x5DB9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB6, 0x5DD0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB7, 0x5F21 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB8, 0x5F34 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAB9, 0x5F67 }, // CJK UNIFIED IDEOGRAPH
    { 0xFABA, 0x5FB7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFABB, 0x5FDE }, // CJK UNIFIED IDEOGRAPH
    { 0xFABC, 0x605D }, // CJK UNIFIED IDEOGRAPH
    { 0xFABD, 0x6085 }, // CJK UNIFIED IDEOGRAPH
    { 0xFABE, 0x608A }, // CJK UNIFIED IDEOGRAPH
    { 0xFABF, 0x60DE }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC0, 0x60D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC1, 0x6120 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC2, 0x60F2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC3, 0x6111 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC4, 0x6137 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC5, 0x6130 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC6, 0x6198 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC7, 0x6213 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC8, 0x62A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAC9, 0x63F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFACA, 0x6460 }, // CJK UNIFIED IDEOGRAPH
    { 0xFACB, 0x649D }, // CJK UNIFIED IDEOGRAPH
    { 0xFACC, 0x64CE }, // CJK UNIFIED IDEOGRAPH
    { 0xFACD, 0x654E }, // CJK UNIFIED IDEOGRAPH
    { 0xFACE, 0x6600 }, // CJK UNIFIED IDEOGRAPH
    { 0xFACF, 0x6615 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD0, 0x663B }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD1, 0x6609 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD2, 0x662E }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD3, 0x661E }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD4, 0x6624 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD5, 0x6665 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD6, 0x6657 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD7, 0x6659 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAD8, 0xFA12 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFAD9, 0x6673 }, // CJK UNIFIED IDEOGRAPH
    { 0xFADA, 0x6699 }, // CJK UNIFIED IDEOGRAPH
    { 0xFADB, 0x66A0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFADC, 0x66B2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFADD, 0x66BF }, // CJK UNIFIED IDEOGRAPH
    { 0xFADE, 0x66FA }, // CJK UNIFIED IDEOGRAPH
    { 0xFADF, 0x670E }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE0, 0xF929 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFAE1, 0x6766 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE2, 0x67BB }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE3, 0x6852 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE4, 0x67C0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE5, 0x6801 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE6, 0x6844 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE7, 0x68CF }, // CJK UNIFIED IDEOGRAPH
    { 0xFAE8, 0xFA13 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFAE9, 0x6968 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAEA, 0xFA14 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFAEB, 0x6998 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAEC, 0x69E2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAED, 0x6A30 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAEE, 0x6A6B }, // CJK UNIFIED IDEOGRAPH
    { 0xFAEF, 0x6A46 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF0, 0x6A73 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF1, 0x6A7E }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF2, 0x6AE2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF3, 0x6AE4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF4, 0x6BD6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF5, 0x6C3F }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF6, 0x6C5C }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF7, 0x6C86 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF8, 0x6C6F }, // CJK UNIFIED IDEOGRAPH
    { 0xFAF9, 0x6CDA }, // CJK UNIFIED IDEOGRAPH
    { 0xFAFA, 0x6D04 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAFB, 0x6D87 }, // CJK UNIFIED IDEOGRAPH
    { 0xFAFC, 0x6D6F }, // CJK UNIFIED IDEOGRAPH
    { 0xFB40, 0x6D96 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB41, 0x6DAC }, // CJK UNIFIED IDEOGRAPH
    { 0xFB42, 0x6DCF }, // CJK UNIFIED IDEOGRAPH
    { 0xFB43, 0x6DF8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB44, 0x6DF2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB45, 0x6DFC }, // CJK UNIFIED IDEOGRAPH
    { 0xFB46, 0x6E39 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB47, 0x6E5C }, // CJK UNIFIED IDEOGRAPH
    { 0xFB48, 0x6E27 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB49, 0x6E3C }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4A, 0x6EBF }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4B, 0x6F88 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4C, 0x6FB5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4D, 0x6FF5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4E, 0x7005 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB4F, 0x7007 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB50, 0x7028 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB51, 0x7085 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB52, 0x70AB }, // CJK UNIFIED IDEOGRAPH
    { 0xFB53, 0x710F }, // CJK UNIFIED IDEOGRAPH
    { 0xFB54, 0x7104 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB55, 0x715C }, // CJK UNIFIED IDEOGRAPH
    { 0xFB56, 0x7146 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB57, 0x7147 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB58, 0xFA15 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB59, 0x71C1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB5A, 0x71FE }, // CJK UNIFIED IDEOGRAPH
    { 0xFB5B, 0x72B1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB5C, 0x72BE }, // CJK UNIFIED IDEOGRAPH
    { 0xFB5D, 0x7324 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB5E, 0xFA16 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB5F, 0x7377 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB60, 0x73BD }, // CJK UNIFIED IDEOGRAPH
    { 0xFB61, 0x73C9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB62, 0x73D6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB63, 0x73E3 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB64, 0x73D2 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB65, 0x7407 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB66, 0x73F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB67, 0x7426 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB68, 0x742A }, // CJK UNIFIED IDEOGRAPH
    { 0xFB69, 0x7429 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6A, 0x742E }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6B, 0x7462 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6C, 0x7489 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6D, 0x749F }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6E, 0x7501 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB6F, 0x756F }, // CJK UNIFIED IDEOGRAPH
    { 0xFB70, 0x7682 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB71, 0x769C }, // CJK UNIFIED IDEOGRAPH
    { 0xFB72, 0x769E }, // CJK UNIFIED IDEOGRAPH
    { 0xFB73, 0x769B }, // CJK UNIFIED IDEOGRAPH
    { 0xFB74, 0x76A6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB75, 0xFA17 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB76, 0x7746 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB77, 0x52AF }, // CJK UNIFIED IDEOGRAPH
    { 0xFB78, 0x7821 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB79, 0x784E }, // CJK UNIFIED IDEOGRAPH
    { 0xFB7A, 0x7864 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB7B, 0x787A }, // CJK UNIFIED IDEOGRAPH
    { 0xFB7C, 0x7930 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB7D, 0xFA18 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB7E, 0xFA19 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB80, 0xFA1A }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB81, 0x7994 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB82, 0xFA1B }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB83, 0x799B }, // CJK UNIFIED IDEOGRAPH
    { 0xFB84, 0x7AD1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB85, 0x7AE7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB86, 0xFA1C }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB87, 0x7AEB }, // CJK UNIFIED IDEOGRAPH
    { 0xFB88, 0x7B9E }, // CJK UNIFIED IDEOGRAPH
    { 0xFB89, 0xFA1D }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB8A, 0x7D48 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB8B, 0x7D5C }, // CJK UNIFIED IDEOGRAPH
    { 0xFB8C, 0x7DB7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB8D, 0x7DA0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB8E, 0x7DD6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB8F, 0x7E52 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB90, 0x7F47 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB91, 0x7FA1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB92, 0xFA1E }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB93, 0x8301 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB94, 0x8362 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB95, 0x837F }, // CJK UNIFIED IDEOGRAPH
    { 0xFB96, 0x83C7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB97, 0x83F6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB98, 0x8448 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB99, 0x84B4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB9A, 0x8553 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB9B, 0x8559 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB9C, 0x856B }, // CJK UNIFIED IDEOGRAPH
    { 0xFB9D, 0xFA1F }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFB9E, 0x85B0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFB9F, 0xFA20 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBA0, 0xFA21 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBA1, 0x8807 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA2, 0x88F5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA3, 0x8A12 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA4, 0x8A37 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA5, 0x8A79 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA6, 0x8AA7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA7, 0x8ABE }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA8, 0x8ADF }, // CJK UNIFIED IDEOGRAPH
    { 0xFBA9, 0xFA22 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBAA, 0x8AF6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBAB, 0x8B53 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBAC, 0x8B7F }, // CJK UNIFIED IDEOGRAPH
    { 0xFBAD, 0x8CF0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBAE, 0x8CF4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBAF, 0x8D12 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB0, 0x8D76 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB1, 0xFA23 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBB2, 0x8ECF }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB3, 0xFA24 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBB4, 0xFA25 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBB5, 0x9067 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB6, 0x90DE }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB7, 0xFA26 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBB8, 0x9115 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBB9, 0x9127 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBA, 0x91DA }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBB, 0x91D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBC, 0x91DE }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBD, 0x91ED }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBE, 0x91EE }, // CJK UNIFIED IDEOGRAPH
    { 0xFBBF, 0x91E4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC0, 0x91E5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC1, 0x9206 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC2, 0x9210 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC3, 0x920A }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC4, 0x923A }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC5, 0x9240 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC6, 0x923C }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC7, 0x924E }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC8, 0x9259 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBC9, 0x9251 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCA, 0x9239 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCB, 0x9267 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCC, 0x92A7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCD, 0x9277 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCE, 0x9278 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBCF, 0x92E7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD0, 0x92D7 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD1, 0x92D9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD2, 0x92D0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD3, 0xFA27 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBD4, 0x92D5 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD5, 0x92E0 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD6, 0x92D3 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD7, 0x9325 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD8, 0x9321 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBD9, 0x92FB }, // CJK UNIFIED IDEOGRAPH
    { 0xFBDA, 0xFA28 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBDB, 0x931E }, // CJK UNIFIED IDEOGRAPH
    { 0xFBDC, 0x92FF }, // CJK UNIFIED IDEOGRAPH
    { 0xFBDD, 0x931D }, // CJK UNIFIED IDEOGRAPH
    { 0xFBDE, 0x9302 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBDF, 0x9370 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE0, 0x9357 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE1, 0x93A4 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE2, 0x93C6 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE3, 0x93DE }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE4, 0x93F8 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE5, 0x9431 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE6, 0x9445 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE7, 0x9448 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE8, 0x9592 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBE9, 0xF9DC }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBEA, 0xFA29 }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBEB, 0x969D }, // CJK UNIFIED IDEOGRAPH
    { 0xFBEC, 0x96AF }, // CJK UNIFIED IDEOGRAPH
    { 0xFBED, 0x9733 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBEE, 0x973B }, // CJK UNIFIED IDEOGRAPH
    { 0xFBEF, 0x9743 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF0, 0x974D }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF1, 0x974F }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF2, 0x9751 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF3, 0x9755 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF4, 0x9857 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF5, 0x9865 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF6, 0xFA2A }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBF7, 0xFA2B }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBF8, 0x9927 }, // CJK UNIFIED IDEOGRAPH
    { 0xFBF9, 0xFA2C }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFBFA, 0x999E }, // CJK UNIFIED IDEOGRAPH
    { 0xFBFB, 0x9A4E }, // CJK UNIFIED IDEOGRAPH
    { 0xFBFC, 0x9AD9 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC40, 0x9ADC }, // CJK UNIFIED IDEOGRAPH
    { 0xFC41, 0x9B75 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC42, 0x9B72 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC43, 0x9B8F }, // CJK UNIFIED IDEOGRAPH
    { 0xFC44, 0x9BB1 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC45, 0x9BBB }, // CJK UNIFIED IDEOGRAPH
    { 0xFC46, 0x9C00 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC47, 0x9D70 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC48, 0x9D6B }, // CJK UNIFIED IDEOGRAPH
    { 0xFC49, 0xFA2D }, // CJK COMPATIBILITY IDEOGRAPH
    { 0xFC4A, 0x9E19 }, // CJK UNIFIED IDEOGRAPH
    { 0xFC4B, 0x9ED1 }, // CJK UNIFIED IDEOGRAPH
};
    
    /*  Adapted from ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP949.TXT
        Column #1 is the cp949 code (in hex)
        Column #2 is the Unicode (in hex as 0xXXXX)
        Column #3 is the Unicode name (follows a comment sign, '//') */
const encoding_convert_entry CP949ToUnicodeTable[17176] =
{
    { 0x8141, 0xAC02 }, // HANGUL SYLLABLE KIYEOK A SSANGKIYEOK
    { 0x8142, 0xAC03 }, // HANGUL SYLLABLE KIYEOK A KIYEOKSIOS
    { 0x8143, 0xAC05 }, // HANGUL SYLLABLE KIYEOK A NIEUNCIEUC
    { 0x8144, 0xAC06 }, // HANGUL SYLLABLE KIYEOK A NIEUNHIEUH
    { 0x8145, 0xAC0B }, // HANGUL SYLLABLE KIYEOK A RIEULPIEUP
    { 0x8146, 0xAC0C }, // HANGUL SYLLABLE KIYEOK A RIEULSIOS
    { 0x8147, 0xAC0D }, // HANGUL SYLLABLE KIYEOK A RIEULTHIEUTH
    { 0x8148, 0xAC0E }, // HANGUL SYLLABLE KIYEOK A RIEULPHIEUPH
    { 0x8149, 0xAC0F }, // HANGUL SYLLABLE KIYEOK A RIEULHIEUH
    { 0x814A, 0xAC18 }, // HANGUL SYLLABLE KIYEOK A KHIEUKH
    { 0x814B, 0xAC1E }, // HANGUL SYLLABLE KIYEOK AE SSANGKIYEOK
    { 0x814C, 0xAC1F }, // HANGUL SYLLABLE KIYEOK AE KIYEOKSIOS
    { 0x814D, 0xAC21 }, // HANGUL SYLLABLE KIYEOK AE NIEUNCIEUC
    { 0x814E, 0xAC22 }, // HANGUL SYLLABLE KIYEOK AE NIEUNHIEUH
    { 0x814F, 0xAC23 }, // HANGUL SYLLABLE KIYEOK AE TIKEUT
    { 0x8150, 0xAC25 }, // HANGUL SYLLABLE KIYEOK AE RIEULKIYEOK
    { 0x8151, 0xAC26 }, // HANGUL SYLLABLE KIYEOK AE RIEULMIEUM
    { 0x8152, 0xAC27 }, // HANGUL SYLLABLE KIYEOK AE RIEULPIEUP
    { 0x8153, 0xAC28 }, // HANGUL SYLLABLE KIYEOK AE RIEULSIOS
    { 0x8154, 0xAC29 }, // HANGUL SYLLABLE KIYEOK AE RIEULTHIEUTH
    { 0x8155, 0xAC2A }, // HANGUL SYLLABLE KIYEOK AE RIEULPHIEUPH
    { 0x8156, 0xAC2B }, // HANGUL SYLLABLE KIYEOK AE RIEULHIEUH
    { 0x8157, 0xAC2E }, // HANGUL SYLLABLE KIYEOK AE PIEUPSIOS
    { 0x8158, 0xAC32 }, // HANGUL SYLLABLE KIYEOK AE CIEUC
    { 0x8159, 0xAC33 }, // HANGUL SYLLABLE KIYEOK AE CHIEUCH
    { 0x815A, 0xAC34 }, // HANGUL SYLLABLE KIYEOK AE KHIEUKH
    { 0x8161, 0xAC35 }, // HANGUL SYLLABLE KIYEOK AE THIEUTH
    { 0x8162, 0xAC36 }, // HANGUL SYLLABLE KIYEOK AE PHIEUPH
    { 0x8163, 0xAC37 }, // HANGUL SYLLABLE KIYEOK AE HIEUH
    { 0x8164, 0xAC3A }, // HANGUL SYLLABLE KIYEOK YA SSANGKIYEOK
    { 0x8165, 0xAC3B }, // HANGUL SYLLABLE KIYEOK YA KIYEOKSIOS
    { 0x8166, 0xAC3D }, // HANGUL SYLLABLE KIYEOK YA NIEUNCIEUC
    { 0x8167, 0xAC3E }, // HANGUL SYLLABLE KIYEOK YA NIEUNHIEUH
    { 0x8168, 0xAC3F }, // HANGUL SYLLABLE KIYEOK YA TIKEUT
    { 0x8169, 0xAC41 }, // HANGUL SYLLABLE KIYEOK YA RIEULKIYEOK
    { 0x816A, 0xAC42 }, // HANGUL SYLLABLE KIYEOK YA RIEULMIEUM
    { 0x816B, 0xAC43 }, // HANGUL SYLLABLE KIYEOK YA RIEULPIEUP
    { 0x816C, 0xAC44 }, // HANGUL SYLLABLE KIYEOK YA RIEULSIOS
    { 0x816D, 0xAC45 }, // HANGUL SYLLABLE KIYEOK YA RIEULTHIEUTH
    { 0x816E, 0xAC46 }, // HANGUL SYLLABLE KIYEOK YA RIEULPHIEUPH
    { 0x816F, 0xAC47 }, // HANGUL SYLLABLE KIYEOK YA RIEULHIEUH
    { 0x8170, 0xAC48 }, // HANGUL SYLLABLE KIYEOK YA MIEUM
    { 0x8171, 0xAC49 }, // HANGUL SYLLABLE KIYEOK YA PIEUP
    { 0x8172, 0xAC4A }, // HANGUL SYLLABLE KIYEOK YA PIEUPSIOS
    { 0x8173, 0xAC4C }, // HANGUL SYLLABLE KIYEOK YA SSANGSIOS
    { 0x8174, 0xAC4E }, // HANGUL SYLLABLE KIYEOK YA CIEUC
    { 0x8175, 0xAC4F }, // HANGUL SYLLABLE KIYEOK YA CHIEUCH
    { 0x8176, 0xAC50 }, // HANGUL SYLLABLE KIYEOK YA KHIEUKH
    { 0x8177, 0xAC51 }, // HANGUL SYLLABLE KIYEOK YA THIEUTH
    { 0x8178, 0xAC52 }, // HANGUL SYLLABLE KIYEOK YA PHIEUPH
    { 0x8179, 0xAC53 }, // HANGUL SYLLABLE KIYEOK YA HIEUH
    { 0x817A, 0xAC55 }, // HANGUL SYLLABLE KIYEOK YAE KIYEOK
    { 0x8181, 0xAC56 }, // HANGUL SYLLABLE KIYEOK YAE SSANGKIYEOK
    { 0x8182, 0xAC57 }, // HANGUL SYLLABLE KIYEOK YAE KIYEOKSIOS
    { 0x8183, 0xAC59 }, // HANGUL SYLLABLE KIYEOK YAE NIEUNCIEUC
    { 0x8184, 0xAC5A }, // HANGUL SYLLABLE KIYEOK YAE NIEUNHIEUH
    { 0x8185, 0xAC5B }, // HANGUL SYLLABLE KIYEOK YAE TIKEUT
    { 0x8186, 0xAC5D }, // HANGUL SYLLABLE KIYEOK YAE RIEULKIYEOK
    { 0x8187, 0xAC5E }, // HANGUL SYLLABLE KIYEOK YAE RIEULMIEUM
    { 0x8188, 0xAC5F }, // HANGUL SYLLABLE KIYEOK YAE RIEULPIEUP
    { 0x8189, 0xAC60 }, // HANGUL SYLLABLE KIYEOK YAE RIEULSIOS
    { 0x818A, 0xAC61 }, // HANGUL SYLLABLE KIYEOK YAE RIEULTHIEUTH
    { 0x818B, 0xAC62 }, // HANGUL SYLLABLE KIYEOK YAE RIEULPHIEUPH
    { 0x818C, 0xAC63 }, // HANGUL SYLLABLE KIYEOK YAE RIEULHIEUH
    { 0x818D, 0xAC64 }, // HANGUL SYLLABLE KIYEOK YAE MIEUM
    { 0x818E, 0xAC65 }, // HANGUL SYLLABLE KIYEOK YAE PIEUP
    { 0x818F, 0xAC66 }, // HANGUL SYLLABLE KIYEOK YAE PIEUPSIOS
    { 0x8190, 0xAC67 }, // HANGUL SYLLABLE KIYEOK YAE SIOS
    { 0x8191, 0xAC68 }, // HANGUL SYLLABLE KIYEOK YAE SSANGSIOS
    { 0x8192, 0xAC69 }, // HANGUL SYLLABLE KIYEOK YAE IEUNG
    { 0x8193, 0xAC6A }, // HANGUL SYLLABLE KIYEOK YAE CIEUC
    { 0x8194, 0xAC6B }, // HANGUL SYLLABLE KIYEOK YAE CHIEUCH
    { 0x8195, 0xAC6C }, // HANGUL SYLLABLE KIYEOK YAE KHIEUKH
    { 0x8196, 0xAC6D }, // HANGUL SYLLABLE KIYEOK YAE THIEUTH
    { 0x8197, 0xAC6E }, // HANGUL SYLLABLE KIYEOK YAE PHIEUPH
    { 0x8198, 0xAC6F }, // HANGUL SYLLABLE KIYEOK YAE HIEUH
    { 0x8199, 0xAC72 }, // HANGUL SYLLABLE KIYEOK EO SSANGKIYEOK
    { 0x819A, 0xAC73 }, // HANGUL SYLLABLE KIYEOK EO KIYEOKSIOS
    { 0x819B, 0xAC75 }, // HANGUL SYLLABLE KIYEOK EO NIEUNCIEUC
    { 0x819C, 0xAC76 }, // HANGUL SYLLABLE KIYEOK EO NIEUNHIEUH
    { 0x819D, 0xAC79 }, // HANGUL SYLLABLE KIYEOK EO RIEULKIYEOK
    { 0x819E, 0xAC7B }, // HANGUL SYLLABLE KIYEOK EO RIEULPIEUP
    { 0x819F, 0xAC7C }, // HANGUL SYLLABLE KIYEOK EO RIEULSIOS
    { 0x81A0, 0xAC7D }, // HANGUL SYLLABLE KIYEOK EO RIEULTHIEUTH
    { 0x81A1, 0xAC7E }, // HANGUL SYLLABLE KIYEOK EO RIEULPHIEUPH
    { 0x81A2, 0xAC7F }, // HANGUL SYLLABLE KIYEOK EO RIEULHIEUH
    { 0x81A3, 0xAC82 }, // HANGUL SYLLABLE KIYEOK EO PIEUPSIOS
    { 0x81A4, 0xAC87 }, // HANGUL SYLLABLE KIYEOK EO CHIEUCH
    { 0x81A5, 0xAC88 }, // HANGUL SYLLABLE KIYEOK EO KHIEUKH
    { 0x81A6, 0xAC8D }, // HANGUL SYLLABLE KIYEOK E KIYEOK
    { 0x81A7, 0xAC8E }, // HANGUL SYLLABLE KIYEOK E SSANGKIYEOK
    { 0x81A8, 0xAC8F }, // HANGUL SYLLABLE KIYEOK E KIYEOKSIOS
    { 0x81A9, 0xAC91 }, // HANGUL SYLLABLE KIYEOK E NIEUNCIEUC
    { 0x81AA, 0xAC92 }, // HANGUL SYLLABLE KIYEOK E NIEUNHIEUH
    { 0x81AB, 0xAC93 }, // HANGUL SYLLABLE KIYEOK E TIKEUT
    { 0x81AC, 0xAC95 }, // HANGUL SYLLABLE KIYEOK E RIEULKIYEOK
    { 0x81AD, 0xAC96 }, // HANGUL SYLLABLE KIYEOK E RIEULMIEUM
    { 0x81AE, 0xAC97 }, // HANGUL SYLLABLE KIYEOK E RIEULPIEUP
    { 0x81AF, 0xAC98 }, // HANGUL SYLLABLE KIYEOK E RIEULSIOS
    { 0x81B0, 0xAC99 }, // HANGUL SYLLABLE KIYEOK E RIEULTHIEUTH
    { 0x81B1, 0xAC9A }, // HANGUL SYLLABLE KIYEOK E RIEULPHIEUPH
    { 0x81B2, 0xAC9B }, // HANGUL SYLLABLE KIYEOK E RIEULHIEUH
    { 0x81B3, 0xAC9E }, // HANGUL SYLLABLE KIYEOK E PIEUPSIOS
    { 0x81B4, 0xACA2 }, // HANGUL SYLLABLE KIYEOK E CIEUC
    { 0x81B5, 0xACA3 }, // HANGUL SYLLABLE KIYEOK E CHIEUCH
    { 0x81B6, 0xACA4 }, // HANGUL SYLLABLE KIYEOK E KHIEUKH
    { 0x81B7, 0xACA5 }, // HANGUL SYLLABLE KIYEOK E THIEUTH
    { 0x81B8, 0xACA6 }, // HANGUL SYLLABLE KIYEOK E PHIEUPH
    { 0x81B9, 0xACA7 }, // HANGUL SYLLABLE KIYEOK E HIEUH
    { 0x81BA, 0xACAB }, // HANGUL SYLLABLE KIYEOK YEO KIYEOKSIOS
    { 0x81BB, 0xACAD }, // HANGUL SYLLABLE KIYEOK YEO NIEUNCIEUC
    { 0x81BC, 0xACAE }, // HANGUL SYLLABLE KIYEOK YEO NIEUNHIEUH
    { 0x81BD, 0xACB1 }, // HANGUL SYLLABLE KIYEOK YEO RIEULKIYEOK
    { 0x81BE, 0xACB2 }, // HANGUL SYLLABLE KIYEOK YEO RIEULMIEUM
    { 0x81BF, 0xACB3 }, // HANGUL SYLLABLE KIYEOK YEO RIEULPIEUP
    { 0x81C0, 0xACB4 }, // HANGUL SYLLABLE KIYEOK YEO RIEULSIOS
    { 0x81C1, 0xACB5 }, // HANGUL SYLLABLE KIYEOK YEO RIEULTHIEUTH
    { 0x81C2, 0xACB6 }, // HANGUL SYLLABLE KIYEOK YEO RIEULPHIEUPH
    { 0x81C3, 0xACB7 }, // HANGUL SYLLABLE KIYEOK YEO RIEULHIEUH
    { 0x81C4, 0xACBA }, // HANGUL SYLLABLE KIYEOK YEO PIEUPSIOS
    { 0x81C5, 0xACBE }, // HANGUL SYLLABLE KIYEOK YEO CIEUC
    { 0x81C6, 0xACBF }, // HANGUL SYLLABLE KIYEOK YEO CHIEUCH
    { 0x81C7, 0xACC0 }, // HANGUL SYLLABLE KIYEOK YEO KHIEUKH
    { 0x81C8, 0xACC2 }, // HANGUL SYLLABLE KIYEOK YEO PHIEUPH
    { 0x81C9, 0xACC3 }, // HANGUL SYLLABLE KIYEOK YEO HIEUH
    { 0x81CA, 0xACC5 }, // HANGUL SYLLABLE KIYEOK YE KIYEOK
    { 0x81CB, 0xACC6 }, // HANGUL SYLLABLE KIYEOK YE SSANGKIYEOK
    { 0x81CC, 0xACC7 }, // HANGUL SYLLABLE KIYEOK YE KIYEOKSIOS
    { 0x81CD, 0xACC9 }, // HANGUL SYLLABLE KIYEOK YE NIEUNCIEUC
    { 0x81CE, 0xACCA }, // HANGUL SYLLABLE KIYEOK YE NIEUNHIEUH
    { 0x81CF, 0xACCB }, // HANGUL SYLLABLE KIYEOK YE TIKEUT
    { 0x81D0, 0xACCD }, // HANGUL SYLLABLE KIYEOK YE RIEULKIYEOK
    { 0x81D1, 0xACCE }, // HANGUL SYLLABLE KIYEOK YE RIEULMIEUM
    { 0x81D2, 0xACCF }, // HANGUL SYLLABLE KIYEOK YE RIEULPIEUP
    { 0x81D3, 0xACD0 }, // HANGUL SYLLABLE KIYEOK YE RIEULSIOS
    { 0x81D4, 0xACD1 }, // HANGUL SYLLABLE KIYEOK YE RIEULTHIEUTH
    { 0x81D5, 0xACD2 }, // HANGUL SYLLABLE KIYEOK YE RIEULPHIEUPH
    { 0x81D6, 0xACD3 }, // HANGUL SYLLABLE KIYEOK YE RIEULHIEUH
    { 0x81D7, 0xACD4 }, // HANGUL SYLLABLE KIYEOK YE MIEUM
    { 0x81D8, 0xACD6 }, // HANGUL SYLLABLE KIYEOK YE PIEUPSIOS
    { 0x81D9, 0xACD8 }, // HANGUL SYLLABLE KIYEOK YE SSANGSIOS
    { 0x81DA, 0xACD9 }, // HANGUL SYLLABLE KIYEOK YE IEUNG
    { 0x81DB, 0xACDA }, // HANGUL SYLLABLE KIYEOK YE CIEUC
    { 0x81DC, 0xACDB }, // HANGUL SYLLABLE KIYEOK YE CHIEUCH
    { 0x81DD, 0xACDC }, // HANGUL SYLLABLE KIYEOK YE KHIEUKH
    { 0x81DE, 0xACDD }, // HANGUL SYLLABLE KIYEOK YE THIEUTH
    { 0x81DF, 0xACDE }, // HANGUL SYLLABLE KIYEOK YE PHIEUPH
    { 0x81E0, 0xACDF }, // HANGUL SYLLABLE KIYEOK YE HIEUH
    { 0x81E1, 0xACE2 }, // HANGUL SYLLABLE KIYEOK O SSANGKIYEOK
    { 0x81E2, 0xACE3 }, // HANGUL SYLLABLE KIYEOK O KIYEOKSIOS
    { 0x81E3, 0xACE5 }, // HANGUL SYLLABLE KIYEOK O NIEUNCIEUC
    { 0x81E4, 0xACE6 }, // HANGUL SYLLABLE KIYEOK O NIEUNHIEUH
    { 0x81E5, 0xACE9 }, // HANGUL SYLLABLE KIYEOK O RIEULKIYEOK
    { 0x81E6, 0xACEB }, // HANGUL SYLLABLE KIYEOK O RIEULPIEUP
    { 0x81E7, 0xACED }, // HANGUL SYLLABLE KIYEOK O RIEULTHIEUTH
    { 0x81E8, 0xACEE }, // HANGUL SYLLABLE KIYEOK O RIEULPHIEUPH
    { 0x81E9, 0xACF2 }, // HANGUL SYLLABLE KIYEOK O PIEUPSIOS
    { 0x81EA, 0xACF4 }, // HANGUL SYLLABLE KIYEOK O SSANGSIOS
    { 0x81EB, 0xACF7 }, // HANGUL SYLLABLE KIYEOK O CHIEUCH
    { 0x81EC, 0xACF8 }, // HANGUL SYLLABLE KIYEOK O KHIEUKH
    { 0x81ED, 0xACF9 }, // HANGUL SYLLABLE KIYEOK O THIEUTH
    { 0x81EE, 0xACFA }, // HANGUL SYLLABLE KIYEOK O PHIEUPH
    { 0x81EF, 0xACFB }, // HANGUL SYLLABLE KIYEOK O HIEUH
    { 0x81F0, 0xACFE }, // HANGUL SYLLABLE KIYEOK WA SSANGKIYEOK
    { 0x81F1, 0xACFF }, // HANGUL SYLLABLE KIYEOK WA KIYEOKSIOS
    { 0x81F2, 0xAD01 }, // HANGUL SYLLABLE KIYEOK WA NIEUNCIEUC
    { 0x81F3, 0xAD02 }, // HANGUL SYLLABLE KIYEOK WA NIEUNHIEUH
    { 0x81F4, 0xAD03 }, // HANGUL SYLLABLE KIYEOK WA TIKEUT
    { 0x81F5, 0xAD05 }, // HANGUL SYLLABLE KIYEOK WA RIEULKIYEOK
    { 0x81F6, 0xAD07 }, // HANGUL SYLLABLE KIYEOK WA RIEULPIEUP
    { 0x81F7, 0xAD08 }, // HANGUL SYLLABLE KIYEOK WA RIEULSIOS
    { 0x81F8, 0xAD09 }, // HANGUL SYLLABLE KIYEOK WA RIEULTHIEUTH
    { 0x81F9, 0xAD0A }, // HANGUL SYLLABLE KIYEOK WA RIEULPHIEUPH
    { 0x81FA, 0xAD0B }, // HANGUL SYLLABLE KIYEOK WA RIEULHIEUH
    { 0x81FB, 0xAD0E }, // HANGUL SYLLABLE KIYEOK WA PIEUPSIOS
    { 0x81FC, 0xAD10 }, // HANGUL SYLLABLE KIYEOK WA SSANGSIOS
    { 0x81FD, 0xAD12 }, // HANGUL SYLLABLE KIYEOK WA CIEUC
    { 0x81FE, 0xAD13 }, // HANGUL SYLLABLE KIYEOK WA CHIEUCH
    { 0x8241, 0xAD14 }, // HANGUL SYLLABLE KIYEOK WA KHIEUKH
    { 0x8242, 0xAD15 }, // HANGUL SYLLABLE KIYEOK WA THIEUTH
    { 0x8243, 0xAD16 }, // HANGUL SYLLABLE KIYEOK WA PHIEUPH
    { 0x8244, 0xAD17 }, // HANGUL SYLLABLE KIYEOK WA HIEUH
    { 0x8245, 0xAD19 }, // HANGUL SYLLABLE KIYEOK WAE KIYEOK
    { 0x8246, 0xAD1A }, // HANGUL SYLLABLE KIYEOK WAE SSANGKIYEOK
    { 0x8247, 0xAD1B }, // HANGUL SYLLABLE KIYEOK WAE KIYEOKSIOS
    { 0x8248, 0xAD1D }, // HANGUL SYLLABLE KIYEOK WAE NIEUNCIEUC
    { 0x8249, 0xAD1E }, // HANGUL SYLLABLE KIYEOK WAE NIEUNHIEUH
    { 0x824A, 0xAD1F }, // HANGUL SYLLABLE KIYEOK WAE TIKEUT
    { 0x824B, 0xAD21 }, // HANGUL SYLLABLE KIYEOK WAE RIEULKIYEOK
    { 0x824C, 0xAD22 }, // HANGUL SYLLABLE KIYEOK WAE RIEULMIEUM
    { 0x824D, 0xAD23 }, // HANGUL SYLLABLE KIYEOK WAE RIEULPIEUP
    { 0x824E, 0xAD24 }, // HANGUL SYLLABLE KIYEOK WAE RIEULSIOS
    { 0x824F, 0xAD25 }, // HANGUL SYLLABLE KIYEOK WAE RIEULTHIEUTH
    { 0x8250, 0xAD26 }, // HANGUL SYLLABLE KIYEOK WAE RIEULPHIEUPH
    { 0x8251, 0xAD27 }, // HANGUL SYLLABLE KIYEOK WAE RIEULHIEUH
    { 0x8252, 0xAD28 }, // HANGUL SYLLABLE KIYEOK WAE MIEUM
    { 0x8253, 0xAD2A }, // HANGUL SYLLABLE KIYEOK WAE PIEUPSIOS
    { 0x8254, 0xAD2B }, // HANGUL SYLLABLE KIYEOK WAE SIOS
    { 0x8255, 0xAD2E }, // HANGUL SYLLABLE KIYEOK WAE CIEUC
    { 0x8256, 0xAD2F }, // HANGUL SYLLABLE KIYEOK WAE CHIEUCH
    { 0x8257, 0xAD30 }, // HANGUL SYLLABLE KIYEOK WAE KHIEUKH
    { 0x8258, 0xAD31 }, // HANGUL SYLLABLE KIYEOK WAE THIEUTH
    { 0x8259, 0xAD32 }, // HANGUL SYLLABLE KIYEOK WAE PHIEUPH
    { 0x825A, 0xAD33 }, // HANGUL SYLLABLE KIYEOK WAE HIEUH
    { 0x8261, 0xAD36 }, // HANGUL SYLLABLE KIYEOK OE SSANGKIYEOK
    { 0x8262, 0xAD37 }, // HANGUL SYLLABLE KIYEOK OE KIYEOKSIOS
    { 0x8263, 0xAD39 }, // HANGUL SYLLABLE KIYEOK OE NIEUNCIEUC
    { 0x8264, 0xAD3A }, // HANGUL SYLLABLE KIYEOK OE NIEUNHIEUH
    { 0x8265, 0xAD3B }, // HANGUL SYLLABLE KIYEOK OE TIKEUT
    { 0x8266, 0xAD3D }, // HANGUL SYLLABLE KIYEOK OE RIEULKIYEOK
    { 0x8267, 0xAD3E }, // HANGUL SYLLABLE KIYEOK OE RIEULMIEUM
    { 0x8268, 0xAD3F }, // HANGUL SYLLABLE KIYEOK OE RIEULPIEUP
    { 0x8269, 0xAD40 }, // HANGUL SYLLABLE KIYEOK OE RIEULSIOS
    { 0x826A, 0xAD41 }, // HANGUL SYLLABLE KIYEOK OE RIEULTHIEUTH
    { 0x826B, 0xAD42 }, // HANGUL SYLLABLE KIYEOK OE RIEULPHIEUPH
    { 0x826C, 0xAD43 }, // HANGUL SYLLABLE KIYEOK OE RIEULHIEUH
    { 0x826D, 0xAD46 }, // HANGUL SYLLABLE KIYEOK OE PIEUPSIOS
    { 0x826E, 0xAD48 }, // HANGUL SYLLABLE KIYEOK OE SSANGSIOS
    { 0x826F, 0xAD4A }, // HANGUL SYLLABLE KIYEOK OE CIEUC
    { 0x8270, 0xAD4B }, // HANGUL SYLLABLE KIYEOK OE CHIEUCH
    { 0x8271, 0xAD4C }, // HANGUL SYLLABLE KIYEOK OE KHIEUKH
    { 0x8272, 0xAD4D }, // HANGUL SYLLABLE KIYEOK OE THIEUTH
    { 0x8273, 0xAD4E }, // HANGUL SYLLABLE KIYEOK OE PHIEUPH
    { 0x8274, 0xAD4F }, // HANGUL SYLLABLE KIYEOK OE HIEUH
    { 0x8275, 0xAD51 }, // HANGUL SYLLABLE KIYEOK YO KIYEOK
    { 0x8276, 0xAD52 }, // HANGUL SYLLABLE KIYEOK YO SSANGKIYEOK
    { 0x8277, 0xAD53 }, // HANGUL SYLLABLE KIYEOK YO KIYEOKSIOS
    { 0x8278, 0xAD55 }, // HANGUL SYLLABLE KIYEOK YO NIEUNCIEUC
    { 0x8279, 0xAD56 }, // HANGUL SYLLABLE KIYEOK YO NIEUNHIEUH
    { 0x827A, 0xAD57 }, // HANGUL SYLLABLE KIYEOK YO TIKEUT
    { 0x8281, 0xAD59 }, // HANGUL SYLLABLE KIYEOK YO RIEULKIYEOK
    { 0x8282, 0xAD5A }, // HANGUL SYLLABLE KIYEOK YO RIEULMIEUM
    { 0x8283, 0xAD5B }, // HANGUL SYLLABLE KIYEOK YO RIEULPIEUP
    { 0x8284, 0xAD5C }, // HANGUL SYLLABLE KIYEOK YO RIEULSIOS
    { 0x8285, 0xAD5D }, // HANGUL SYLLABLE KIYEOK YO RIEULTHIEUTH
    { 0x8286, 0xAD5E }, // HANGUL SYLLABLE KIYEOK YO RIEULPHIEUPH
    { 0x8287, 0xAD5F }, // HANGUL SYLLABLE KIYEOK YO RIEULHIEUH
    { 0x8288, 0xAD60 }, // HANGUL SYLLABLE KIYEOK YO MIEUM
    { 0x8289, 0xAD62 }, // HANGUL SYLLABLE KIYEOK YO PIEUPSIOS
    { 0x828A, 0xAD64 }, // HANGUL SYLLABLE KIYEOK YO SSANGSIOS
    { 0x828B, 0xAD65 }, // HANGUL SYLLABLE KIYEOK YO IEUNG
    { 0x828C, 0xAD66 }, // HANGUL SYLLABLE KIYEOK YO CIEUC
    { 0x828D, 0xAD67 }, // HANGUL SYLLABLE KIYEOK YO CHIEUCH
    { 0x828E, 0xAD68 }, // HANGUL SYLLABLE KIYEOK YO KHIEUKH
    { 0x828F, 0xAD69 }, // HANGUL SYLLABLE KIYEOK YO THIEUTH
    { 0x8290, 0xAD6A }, // HANGUL SYLLABLE KIYEOK YO PHIEUPH
    { 0x8291, 0xAD6B }, // HANGUL SYLLABLE KIYEOK YO HIEUH
    { 0x8292, 0xAD6E }, // HANGUL SYLLABLE KIYEOK U SSANGKIYEOK
    { 0x8293, 0xAD6F }, // HANGUL SYLLABLE KIYEOK U KIYEOKSIOS
    { 0x8294, 0xAD71 }, // HANGUL SYLLABLE KIYEOK U NIEUNCIEUC
    { 0x8295, 0xAD72 }, // HANGUL SYLLABLE KIYEOK U NIEUNHIEUH
    { 0x8296, 0xAD77 }, // HANGUL SYLLABLE KIYEOK U RIEULPIEUP
    { 0x8297, 0xAD78 }, // HANGUL SYLLABLE KIYEOK U RIEULSIOS
    { 0x8298, 0xAD79 }, // HANGUL SYLLABLE KIYEOK U RIEULTHIEUTH
    { 0x8299, 0xAD7A }, // HANGUL SYLLABLE KIYEOK U RIEULPHIEUPH
    { 0x829A, 0xAD7E }, // HANGUL SYLLABLE KIYEOK U PIEUPSIOS
    { 0x829B, 0xAD80 }, // HANGUL SYLLABLE KIYEOK U SSANGSIOS
    { 0x829C, 0xAD83 }, // HANGUL SYLLABLE KIYEOK U CHIEUCH
    { 0x829D, 0xAD84 }, // HANGUL SYLLABLE KIYEOK U KHIEUKH
    { 0x829E, 0xAD85 }, // HANGUL SYLLABLE KIYEOK U THIEUTH
    { 0x829F, 0xAD86 }, // HANGUL SYLLABLE KIYEOK U PHIEUPH
    { 0x82A0, 0xAD87 }, // HANGUL SYLLABLE KIYEOK U HIEUH
    { 0x82A1, 0xAD8A }, // HANGUL SYLLABLE KIYEOK WEO SSANGKIYEOK
    { 0x82A2, 0xAD8B }, // HANGUL SYLLABLE KIYEOK WEO KIYEOKSIOS
    { 0x82A3, 0xAD8D }, // HANGUL SYLLABLE KIYEOK WEO NIEUNCIEUC
    { 0x82A4, 0xAD8E }, // HANGUL SYLLABLE KIYEOK WEO NIEUNHIEUH
    { 0x82A5, 0xAD8F }, // HANGUL SYLLABLE KIYEOK WEO TIKEUT
    { 0x82A6, 0xAD91 }, // HANGUL SYLLABLE KIYEOK WEO RIEULKIYEOK
    { 0x82A7, 0xAD92 }, // HANGUL SYLLABLE KIYEOK WEO RIEULMIEUM
    { 0x82A8, 0xAD93 }, // HANGUL SYLLABLE KIYEOK WEO RIEULPIEUP
    { 0x82A9, 0xAD94 }, // HANGUL SYLLABLE KIYEOK WEO RIEULSIOS
    { 0x82AA, 0xAD95 }, // HANGUL SYLLABLE KIYEOK WEO RIEULTHIEUTH
    { 0x82AB, 0xAD96 }, // HANGUL SYLLABLE KIYEOK WEO RIEULPHIEUPH
    { 0x82AC, 0xAD97 }, // HANGUL SYLLABLE KIYEOK WEO RIEULHIEUH
    { 0x82AD, 0xAD98 }, // HANGUL SYLLABLE KIYEOK WEO MIEUM
    { 0x82AE, 0xAD99 }, // HANGUL SYLLABLE KIYEOK WEO PIEUP
    { 0x82AF, 0xAD9A }, // HANGUL SYLLABLE KIYEOK WEO PIEUPSIOS
    { 0x82B0, 0xAD9B }, // HANGUL SYLLABLE KIYEOK WEO SIOS
    { 0x82B1, 0xAD9E }, // HANGUL SYLLABLE KIYEOK WEO CIEUC
    { 0x82B2, 0xAD9F }, // HANGUL SYLLABLE KIYEOK WEO CHIEUCH
    { 0x82B3, 0xADA0 }, // HANGUL SYLLABLE KIYEOK WEO KHIEUKH
    { 0x82B4, 0xADA1 }, // HANGUL SYLLABLE KIYEOK WEO THIEUTH
    { 0x82B5, 0xADA2 }, // HANGUL SYLLABLE KIYEOK WEO PHIEUPH
    { 0x82B6, 0xADA3 }, // HANGUL SYLLABLE KIYEOK WEO HIEUH
    { 0x82B7, 0xADA5 }, // HANGUL SYLLABLE KIYEOK WE KIYEOK
    { 0x82B8, 0xADA6 }, // HANGUL SYLLABLE KIYEOK WE SSANGKIYEOK
    { 0x82B9, 0xADA7 }, // HANGUL SYLLABLE KIYEOK WE KIYEOKSIOS
    { 0x82BA, 0xADA8 }, // HANGUL SYLLABLE KIYEOK WE NIEUN
    { 0x82BB, 0xADA9 }, // HANGUL SYLLABLE KIYEOK WE NIEUNCIEUC
    { 0x82BC, 0xADAA }, // HANGUL SYLLABLE KIYEOK WE NIEUNHIEUH
    { 0x82BD, 0xADAB }, // HANGUL SYLLABLE KIYEOK WE TIKEUT
    { 0x82BE, 0xADAC }, // HANGUL SYLLABLE KIYEOK WE RIEUL
    { 0x82BF, 0xADAD }, // HANGUL SYLLABLE KIYEOK WE RIEULKIYEOK
    { 0x82C0, 0xADAE }, // HANGUL SYLLABLE KIYEOK WE RIEULMIEUM
    { 0x82C1, 0xADAF }, // HANGUL SYLLABLE KIYEOK WE RIEULPIEUP
    { 0x82C2, 0xADB0 }, // HANGUL SYLLABLE KIYEOK WE RIEULSIOS
    { 0x82C3, 0xADB1 }, // HANGUL SYLLABLE KIYEOK WE RIEULTHIEUTH
    { 0x82C4, 0xADB2 }, // HANGUL SYLLABLE KIYEOK WE RIEULPHIEUPH
    { 0x82C5, 0xADB3 }, // HANGUL SYLLABLE KIYEOK WE RIEULHIEUH
    { 0x82C6, 0xADB4 }, // HANGUL SYLLABLE KIYEOK WE MIEUM
    { 0x82C7, 0xADB5 }, // HANGUL SYLLABLE KIYEOK WE PIEUP
    { 0x82C8, 0xADB6 }, // HANGUL SYLLABLE KIYEOK WE PIEUPSIOS
    { 0x82C9, 0xADB8 }, // HANGUL SYLLABLE KIYEOK WE SSANGSIOS
    { 0x82CA, 0xADB9 }, // HANGUL SYLLABLE KIYEOK WE IEUNG
    { 0x82CB, 0xADBA }, // HANGUL SYLLABLE KIYEOK WE CIEUC
    { 0x82CC, 0xADBB }, // HANGUL SYLLABLE KIYEOK WE CHIEUCH
    { 0x82CD, 0xADBC }, // HANGUL SYLLABLE KIYEOK WE KHIEUKH
    { 0x82CE, 0xADBD }, // HANGUL SYLLABLE KIYEOK WE THIEUTH
    { 0x82CF, 0xADBE }, // HANGUL SYLLABLE KIYEOK WE PHIEUPH
    { 0x82D0, 0xADBF }, // HANGUL SYLLABLE KIYEOK WE HIEUH
    { 0x82D1, 0xADC2 }, // HANGUL SYLLABLE KIYEOK WI SSANGKIYEOK
    { 0x82D2, 0xADC3 }, // HANGUL SYLLABLE KIYEOK WI KIYEOKSIOS
    { 0x82D3, 0xADC5 }, // HANGUL SYLLABLE KIYEOK WI NIEUNCIEUC
    { 0x82D4, 0xADC6 }, // HANGUL SYLLABLE KIYEOK WI NIEUNHIEUH
    { 0x82D5, 0xADC7 }, // HANGUL SYLLABLE KIYEOK WI TIKEUT
    { 0x82D6, 0xADC9 }, // HANGUL SYLLABLE KIYEOK WI RIEULKIYEOK
    { 0x82D7, 0xADCA }, // HANGUL SYLLABLE KIYEOK WI RIEULMIEUM
    { 0x82D8, 0xADCB }, // HANGUL SYLLABLE KIYEOK WI RIEULPIEUP
    { 0x82D9, 0xADCC }, // HANGUL SYLLABLE KIYEOK WI RIEULSIOS
    { 0x82DA, 0xADCD }, // HANGUL SYLLABLE KIYEOK WI RIEULTHIEUTH
    { 0x82DB, 0xADCE }, // HANGUL SYLLABLE KIYEOK WI RIEULPHIEUPH
    { 0x82DC, 0xADCF }, // HANGUL SYLLABLE KIYEOK WI RIEULHIEUH
    { 0x82DD, 0xADD2 }, // HANGUL SYLLABLE KIYEOK WI PIEUPSIOS
    { 0x82DE, 0xADD4 }, // HANGUL SYLLABLE KIYEOK WI SSANGSIOS
    { 0x82DF, 0xADD5 }, // HANGUL SYLLABLE KIYEOK WI IEUNG
    { 0x82E0, 0xADD6 }, // HANGUL SYLLABLE KIYEOK WI CIEUC
    { 0x82E1, 0xADD7 }, // HANGUL SYLLABLE KIYEOK WI CHIEUCH
    { 0x82E2, 0xADD8 }, // HANGUL SYLLABLE KIYEOK WI KHIEUKH
    { 0x82E3, 0xADD9 }, // HANGUL SYLLABLE KIYEOK WI THIEUTH
    { 0x82E4, 0xADDA }, // HANGUL SYLLABLE KIYEOK WI PHIEUPH
    { 0x82E5, 0xADDB }, // HANGUL SYLLABLE KIYEOK WI HIEUH
    { 0x82E6, 0xADDD }, // HANGUL SYLLABLE KIYEOK YU KIYEOK
    { 0x82E7, 0xADDE }, // HANGUL SYLLABLE KIYEOK YU SSANGKIYEOK
    { 0x82E8, 0xADDF }, // HANGUL SYLLABLE KIYEOK YU KIYEOKSIOS
    { 0x82E9, 0xADE1 }, // HANGUL SYLLABLE KIYEOK YU NIEUNCIEUC
    { 0x82EA, 0xADE2 }, // HANGUL SYLLABLE KIYEOK YU NIEUNHIEUH
    { 0x82EB, 0xADE3 }, // HANGUL SYLLABLE KIYEOK YU TIKEUT
    { 0x82EC, 0xADE5 }, // HANGUL SYLLABLE KIYEOK YU RIEULKIYEOK
    { 0x82ED, 0xADE6 }, // HANGUL SYLLABLE KIYEOK YU RIEULMIEUM
    { 0x82EE, 0xADE7 }, // HANGUL SYLLABLE KIYEOK YU RIEULPIEUP
    { 0x82EF, 0xADE8 }, // HANGUL SYLLABLE KIYEOK YU RIEULSIOS
    { 0x82F0, 0xADE9 }, // HANGUL SYLLABLE KIYEOK YU RIEULTHIEUTH
    { 0x82F1, 0xADEA }, // HANGUL SYLLABLE KIYEOK YU RIEULPHIEUPH
    { 0x82F2, 0xADEB }, // HANGUL SYLLABLE KIYEOK YU RIEULHIEUH
    { 0x82F3, 0xADEC }, // HANGUL SYLLABLE KIYEOK YU MIEUM
    { 0x82F4, 0xADED }, // HANGUL SYLLABLE KIYEOK YU PIEUP
    { 0x82F5, 0xADEE }, // HANGUL SYLLABLE KIYEOK YU PIEUPSIOS
    { 0x82F6, 0xADEF }, // HANGUL SYLLABLE KIYEOK YU SIOS
    { 0x82F7, 0xADF0 }, // HANGUL SYLLABLE KIYEOK YU SSANGSIOS
    { 0x82F8, 0xADF1 }, // HANGUL SYLLABLE KIYEOK YU IEUNG
    { 0x82F9, 0xADF2 }, // HANGUL SYLLABLE KIYEOK YU CIEUC
    { 0x82FA, 0xADF3 }, // HANGUL SYLLABLE KIYEOK YU CHIEUCH
    { 0x82FB, 0xADF4 }, // HANGUL SYLLABLE KIYEOK YU KHIEUKH
    { 0x82FC, 0xADF5 }, // HANGUL SYLLABLE KIYEOK YU THIEUTH
    { 0x82FD, 0xADF6 }, // HANGUL SYLLABLE KIYEOK YU PHIEUPH
    { 0x82FE, 0xADF7 }, // HANGUL SYLLABLE KIYEOK YU HIEUH
    { 0x8341, 0xADFA }, // HANGUL SYLLABLE KIYEOK EU SSANGKIYEOK
    { 0x8342, 0xADFB }, // HANGUL SYLLABLE KIYEOK EU KIYEOKSIOS
    { 0x8343, 0xADFD }, // HANGUL SYLLABLE KIYEOK EU NIEUNCIEUC
    { 0x8344, 0xADFE }, // HANGUL SYLLABLE KIYEOK EU NIEUNHIEUH
    { 0x8345, 0xAE02 }, // HANGUL SYLLABLE KIYEOK EU RIEULMIEUM
    { 0x8346, 0xAE03 }, // HANGUL SYLLABLE KIYEOK EU RIEULPIEUP
    { 0x8347, 0xAE04 }, // HANGUL SYLLABLE KIYEOK EU RIEULSIOS
    { 0x8348, 0xAE05 }, // HANGUL SYLLABLE KIYEOK EU RIEULTHIEUTH
    { 0x8349, 0xAE06 }, // HANGUL SYLLABLE KIYEOK EU RIEULPHIEUPH
    { 0x834A, 0xAE07 }, // HANGUL SYLLABLE KIYEOK EU RIEULHIEUH
    { 0x834B, 0xAE0A }, // HANGUL SYLLABLE KIYEOK EU PIEUPSIOS
    { 0x834C, 0xAE0C }, // HANGUL SYLLABLE KIYEOK EU SSANGSIOS
    { 0x834D, 0xAE0E }, // HANGUL SYLLABLE KIYEOK EU CIEUC
    { 0x834E, 0xAE0F }, // HANGUL SYLLABLE KIYEOK EU CHIEUCH
    { 0x834F, 0xAE10 }, // HANGUL SYLLABLE KIYEOK EU KHIEUKH
    { 0x8350, 0xAE11 }, // HANGUL SYLLABLE KIYEOK EU THIEUTH
    { 0x8351, 0xAE12 }, // HANGUL SYLLABLE KIYEOK EU PHIEUPH
    { 0x8352, 0xAE13 }, // HANGUL SYLLABLE KIYEOK EU HIEUH
    { 0x8353, 0xAE15 }, // HANGUL SYLLABLE KIYEOK YI KIYEOK
    { 0x8354, 0xAE16 }, // HANGUL SYLLABLE KIYEOK YI SSANGKIYEOK
    { 0x8355, 0xAE17 }, // HANGUL SYLLABLE KIYEOK YI KIYEOKSIOS
    { 0x8356, 0xAE18 }, // HANGUL SYLLABLE KIYEOK YI NIEUN
    { 0x8357, 0xAE19 }, // HANGUL SYLLABLE KIYEOK YI NIEUNCIEUC
    { 0x8358, 0xAE1A }, // HANGUL SYLLABLE KIYEOK YI NIEUNHIEUH
    { 0x8359, 0xAE1B }, // HANGUL SYLLABLE KIYEOK YI TIKEUT
    { 0x835A, 0xAE1C }, // HANGUL SYLLABLE KIYEOK YI RIEUL
    { 0x8361, 0xAE1D }, // HANGUL SYLLABLE KIYEOK YI RIEULKIYEOK
    { 0x8362, 0xAE1E }, // HANGUL SYLLABLE KIYEOK YI RIEULMIEUM
    { 0x8363, 0xAE1F }, // HANGUL SYLLABLE KIYEOK YI RIEULPIEUP
    { 0x8364, 0xAE20 }, // HANGUL SYLLABLE KIYEOK YI RIEULSIOS
    { 0x8365, 0xAE21 }, // HANGUL SYLLABLE KIYEOK YI RIEULTHIEUTH
    { 0x8366, 0xAE22 }, // HANGUL SYLLABLE KIYEOK YI RIEULPHIEUPH
    { 0x8367, 0xAE23 }, // HANGUL SYLLABLE KIYEOK YI RIEULHIEUH
    { 0x8368, 0xAE24 }, // HANGUL SYLLABLE KIYEOK YI MIEUM
    { 0x8369, 0xAE25 }, // HANGUL SYLLABLE KIYEOK YI PIEUP
    { 0x836A, 0xAE26 }, // HANGUL SYLLABLE KIYEOK YI PIEUPSIOS
    { 0x836B, 0xAE27 }, // HANGUL SYLLABLE KIYEOK YI SIOS
    { 0x836C, 0xAE28 }, // HANGUL SYLLABLE KIYEOK YI SSANGSIOS
    { 0x836D, 0xAE29 }, // HANGUL SYLLABLE KIYEOK YI IEUNG
    { 0x836E, 0xAE2A }, // HANGUL SYLLABLE KIYEOK YI CIEUC
    { 0x836F, 0xAE2B }, // HANGUL SYLLABLE KIYEOK YI CHIEUCH
    { 0x8370, 0xAE2C }, // HANGUL SYLLABLE KIYEOK YI KHIEUKH
    { 0x8371, 0xAE2D }, // HANGUL SYLLABLE KIYEOK YI THIEUTH
    { 0x8372, 0xAE2E }, // HANGUL SYLLABLE KIYEOK YI PHIEUPH
    { 0x8373, 0xAE2F }, // HANGUL SYLLABLE KIYEOK YI HIEUH
    { 0x8374, 0xAE32 }, // HANGUL SYLLABLE KIYEOK I SSANGKIYEOK
    { 0x8375, 0xAE33 }, // HANGUL SYLLABLE KIYEOK I KIYEOKSIOS
    { 0x8376, 0xAE35 }, // HANGUL SYLLABLE KIYEOK I NIEUNCIEUC
    { 0x8377, 0xAE36 }, // HANGUL SYLLABLE KIYEOK I NIEUNHIEUH
    { 0x8378, 0xAE39 }, // HANGUL SYLLABLE KIYEOK I RIEULKIYEOK
    { 0x8379, 0xAE3B }, // HANGUL SYLLABLE KIYEOK I RIEULPIEUP
    { 0x837A, 0xAE3C }, // HANGUL SYLLABLE KIYEOK I RIEULSIOS
    { 0x8381, 0xAE3D }, // HANGUL SYLLABLE KIYEOK I RIEULTHIEUTH
    { 0x8382, 0xAE3E }, // HANGUL SYLLABLE KIYEOK I RIEULPHIEUPH
    { 0x8383, 0xAE3F }, // HANGUL SYLLABLE KIYEOK I RIEULHIEUH
    { 0x8384, 0xAE42 }, // HANGUL SYLLABLE KIYEOK I PIEUPSIOS
    { 0x8385, 0xAE44 }, // HANGUL SYLLABLE KIYEOK I SSANGSIOS
    { 0x8386, 0xAE47 }, // HANGUL SYLLABLE KIYEOK I CHIEUCH
    { 0x8387, 0xAE48 }, // HANGUL SYLLABLE KIYEOK I KHIEUKH
    { 0x8388, 0xAE49 }, // HANGUL SYLLABLE KIYEOK I THIEUTH
    { 0x8389, 0xAE4B }, // HANGUL SYLLABLE KIYEOK I HIEUH
    { 0x838A, 0xAE4F }, // HANGUL SYLLABLE SSANGKIYEOK A KIYEOKSIOS
    { 0x838B, 0xAE51 }, // HANGUL SYLLABLE SSANGKIYEOK A NIEUNCIEUC
    { 0x838C, 0xAE52 }, // HANGUL SYLLABLE SSANGKIYEOK A NIEUNHIEUH
    { 0x838D, 0xAE53 }, // HANGUL SYLLABLE SSANGKIYEOK A TIKEUT
    { 0x838E, 0xAE55 }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULKIYEOK
    { 0x838F, 0xAE57 }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULPIEUP
    { 0x8390, 0xAE58 }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULSIOS
    { 0x8391, 0xAE59 }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULTHIEUTH
    { 0x8392, 0xAE5A }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULPHIEUPH
    { 0x8393, 0xAE5B }, // HANGUL SYLLABLE SSANGKIYEOK A RIEULHIEUH
    { 0x8394, 0xAE5E }, // HANGUL SYLLABLE SSANGKIYEOK A PIEUPSIOS
    { 0x8395, 0xAE62 }, // HANGUL SYLLABLE SSANGKIYEOK A CIEUC
    { 0x8396, 0xAE63 }, // HANGUL SYLLABLE SSANGKIYEOK A CHIEUCH
    { 0x8397, 0xAE64 }, // HANGUL SYLLABLE SSANGKIYEOK A KHIEUKH
    { 0x8398, 0xAE66 }, // HANGUL SYLLABLE SSANGKIYEOK A PHIEUPH
    { 0x8399, 0xAE67 }, // HANGUL SYLLABLE SSANGKIYEOK A HIEUH
    { 0x839A, 0xAE6A }, // HANGUL SYLLABLE SSANGKIYEOK AE SSANGKIYEOK
    { 0x839B, 0xAE6B }, // HANGUL SYLLABLE SSANGKIYEOK AE KIYEOKSIOS
    { 0x839C, 0xAE6D }, // HANGUL SYLLABLE SSANGKIYEOK AE NIEUNCIEUC
    { 0x839D, 0xAE6E }, // HANGUL SYLLABLE SSANGKIYEOK AE NIEUNHIEUH
    { 0x839E, 0xAE6F }, // HANGUL SYLLABLE SSANGKIYEOK AE TIKEUT
    { 0x839F, 0xAE71 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULKIYEOK
    { 0x83A0, 0xAE72 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULMIEUM
    { 0x83A1, 0xAE73 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULPIEUP
    { 0x83A2, 0xAE74 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULSIOS
    { 0x83A3, 0xAE75 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULTHIEUTH
    { 0x83A4, 0xAE76 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULPHIEUPH
    { 0x83A5, 0xAE77 }, // HANGUL SYLLABLE SSANGKIYEOK AE RIEULHIEUH
    { 0x83A6, 0xAE7A }, // HANGUL SYLLABLE SSANGKIYEOK AE PIEUPSIOS
    { 0x83A7, 0xAE7E }, // HANGUL SYLLABLE SSANGKIYEOK AE CIEUC
    { 0x83A8, 0xAE7F }, // HANGUL SYLLABLE SSANGKIYEOK AE CHIEUCH
    { 0x83A9, 0xAE80 }, // HANGUL SYLLABLE SSANGKIYEOK AE KHIEUKH
    { 0x83AA, 0xAE81 }, // HANGUL SYLLABLE SSANGKIYEOK AE THIEUTH
    { 0x83AB, 0xAE82 }, // HANGUL SYLLABLE SSANGKIYEOK AE PHIEUPH
    { 0x83AC, 0xAE83 }, // HANGUL SYLLABLE SSANGKIYEOK AE HIEUH
    { 0x83AD, 0xAE86 }, // HANGUL SYLLABLE SSANGKIYEOK YA SSANGKIYEOK
    { 0x83AE, 0xAE87 }, // HANGUL SYLLABLE SSANGKIYEOK YA KIYEOKSIOS
    { 0x83AF, 0xAE88 }, // HANGUL SYLLABLE SSANGKIYEOK YA NIEUN
    { 0x83B0, 0xAE89 }, // HANGUL SYLLABLE SSANGKIYEOK YA NIEUNCIEUC
    { 0x83B1, 0xAE8A }, // HANGUL SYLLABLE SSANGKIYEOK YA NIEUNHIEUH
    { 0x83B2, 0xAE8B }, // HANGUL SYLLABLE SSANGKIYEOK YA TIKEUT
    { 0x83B3, 0xAE8D }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULKIYEOK
    { 0x83B4, 0xAE8E }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULMIEUM
    { 0x83B5, 0xAE8F }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULPIEUP
    { 0x83B6, 0xAE90 }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULSIOS
    { 0x83B7, 0xAE91 }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULTHIEUTH
    { 0x83B8, 0xAE92 }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULPHIEUPH
    { 0x83B9, 0xAE93 }, // HANGUL SYLLABLE SSANGKIYEOK YA RIEULHIEUH
    { 0x83BA, 0xAE94 }, // HANGUL SYLLABLE SSANGKIYEOK YA MIEUM
    { 0x83BB, 0xAE95 }, // HANGUL SYLLABLE SSANGKIYEOK YA PIEUP
    { 0x83BC, 0xAE96 }, // HANGUL SYLLABLE SSANGKIYEOK YA PIEUPSIOS
    { 0x83BD, 0xAE97 }, // HANGUL SYLLABLE SSANGKIYEOK YA SIOS
    { 0x83BE, 0xAE98 }, // HANGUL SYLLABLE SSANGKIYEOK YA SSANGSIOS
    { 0x83BF, 0xAE99 }, // HANGUL SYLLABLE SSANGKIYEOK YA IEUNG
    { 0x83C0, 0xAE9A }, // HANGUL SYLLABLE SSANGKIYEOK YA CIEUC
    { 0x83C1, 0xAE9B }, // HANGUL SYLLABLE SSANGKIYEOK YA CHIEUCH
    { 0x83C2, 0xAE9C }, // HANGUL SYLLABLE SSANGKIYEOK YA KHIEUKH
    { 0x83C3, 0xAE9D }, // HANGUL SYLLABLE SSANGKIYEOK YA THIEUTH
    { 0x83C4, 0xAE9E }, // HANGUL SYLLABLE SSANGKIYEOK YA PHIEUPH
    { 0x83C5, 0xAE9F }, // HANGUL SYLLABLE SSANGKIYEOK YA HIEUH
    { 0x83C6, 0xAEA0 }, // HANGUL SYLLABLE SSANGKIYEOK YAE
    { 0x83C7, 0xAEA1 }, // HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOK
    { 0x83C8, 0xAEA2 }, // HANGUL SYLLABLE SSANGKIYEOK YAE SSANGKIYEOK
    { 0x83C9, 0xAEA3 }, // HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOKSIOS
    { 0x83CA, 0xAEA4 }, // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUN
    { 0x83CB, 0xAEA5 }, // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNCIEUC
    { 0x83CC, 0xAEA6 }, // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNHIEUH
    { 0x83CD, 0xAEA7 }, // HANGUL SYLLABLE SSANGKIYEOK YAE TIKEUT
    { 0x83CE, 0xAEA8 }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEUL
    { 0x83CF, 0xAEA9 }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULKIYEOK
    { 0x83D0, 0xAEAA }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULMIEUM
    { 0x83D1, 0xAEAB }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPIEUP
    { 0x83D2, 0xAEAC }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULSIOS
    { 0x83D3, 0xAEAD }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULTHIEUTH
    { 0x83D4, 0xAEAE }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPHIEUPH
    { 0x83D5, 0xAEAF }, // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULHIEUH
    { 0x83D6, 0xAEB0 }, // HANGUL SYLLABLE SSANGKIYEOK YAE MIEUM
    { 0x83D7, 0xAEB1 }, // HANGUL SYLLABLE SSANGKIYEOK YAE PIEUP
    { 0x83D8, 0xAEB2 }, // HANGUL SYLLABLE SSANGKIYEOK YAE PIEUPSIOS
    { 0x83D9, 0xAEB3 }, // HANGUL SYLLABLE SSANGKIYEOK YAE SIOS
    { 0x83DA, 0xAEB4 }, // HANGUL SYLLABLE SSANGKIYEOK YAE SSANGSIOS
    { 0x83DB, 0xAEB5 }, // HANGUL SYLLABLE SSANGKIYEOK YAE IEUNG
    { 0x83DC, 0xAEB6 }, // HANGUL SYLLABLE SSANGKIYEOK YAE CIEUC
    { 0x83DD, 0xAEB7 }, // HANGUL SYLLABLE SSANGKIYEOK YAE CHIEUCH
    { 0x83DE, 0xAEB8 }, // HANGUL SYLLABLE SSANGKIYEOK YAE KHIEUKH
    { 0x83DF, 0xAEB9 }, // HANGUL SYLLABLE SSANGKIYEOK YAE THIEUTH
    { 0x83E0, 0xAEBA }, // HANGUL SYLLABLE SSANGKIYEOK YAE PHIEUPH
    { 0x83E1, 0xAEBB }, // HANGUL SYLLABLE SSANGKIYEOK YAE HIEUH
    { 0x83E2, 0xAEBF }, // HANGUL SYLLABLE SSANGKIYEOK EO KIYEOKSIOS
    { 0x83E3, 0xAEC1 }, // HANGUL SYLLABLE SSANGKIYEOK EO NIEUNCIEUC
    { 0x83E4, 0xAEC2 }, // HANGUL SYLLABLE SSANGKIYEOK EO NIEUNHIEUH
    { 0x83E5, 0xAEC3 }, // HANGUL SYLLABLE SSANGKIYEOK EO TIKEUT
    { 0x83E6, 0xAEC5 }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULKIYEOK
    { 0x83E7, 0xAEC6 }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULMIEUM
    { 0x83E8, 0xAEC7 }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULPIEUP
    { 0x83E9, 0xAEC8 }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULSIOS
    { 0x83EA, 0xAEC9 }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULTHIEUTH
    { 0x83EB, 0xAECA }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULPHIEUPH
    { 0x83EC, 0xAECB }, // HANGUL SYLLABLE SSANGKIYEOK EO RIEULHIEUH
    { 0x83ED, 0xAECE }, // HANGUL SYLLABLE SSANGKIYEOK EO PIEUPSIOS
    { 0x83EE, 0xAED2 }, // HANGUL SYLLABLE SSANGKIYEOK EO CIEUC
    { 0x83EF, 0xAED3 }, // HANGUL SYLLABLE SSANGKIYEOK EO CHIEUCH
    { 0x83F0, 0xAED4 }, // HANGUL SYLLABLE SSANGKIYEOK EO KHIEUKH
    { 0x83F1, 0xAED5 }, // HANGUL SYLLABLE SSANGKIYEOK EO THIEUTH
    { 0x83F2, 0xAED6 }, // HANGUL SYLLABLE SSANGKIYEOK EO PHIEUPH
    { 0x83F3, 0xAED7 }, // HANGUL SYLLABLE SSANGKIYEOK EO HIEUH
    { 0x83F4, 0xAEDA }, // HANGUL SYLLABLE SSANGKIYEOK E SSANGKIYEOK
    { 0x83F5, 0xAEDB }, // HANGUL SYLLABLE SSANGKIYEOK E KIYEOKSIOS
    { 0x83F6, 0xAEDD }, // HANGUL SYLLABLE SSANGKIYEOK E NIEUNCIEUC
    { 0x83F7, 0xAEDE }, // HANGUL SYLLABLE SSANGKIYEOK E NIEUNHIEUH
    { 0x83F8, 0xAEDF }, // HANGUL SYLLABLE SSANGKIYEOK E TIKEUT
    { 0x83F9, 0xAEE0 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEUL
    { 0x83FA, 0xAEE1 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULKIYEOK
    { 0x83FB, 0xAEE2 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULMIEUM
    { 0x83FC, 0xAEE3 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULPIEUP
    { 0x83FD, 0xAEE4 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULSIOS
    { 0x83FE, 0xAEE5 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULTHIEUTH
    { 0x8441, 0xAEE6 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULPHIEUPH
    { 0x8442, 0xAEE7 }, // HANGUL SYLLABLE SSANGKIYEOK E RIEULHIEUH
    { 0x8443, 0xAEE9 }, // HANGUL SYLLABLE SSANGKIYEOK E PIEUP
    { 0x8444, 0xAEEA }, // HANGUL SYLLABLE SSANGKIYEOK E PIEUPSIOS
    { 0x8445, 0xAEEC }, // HANGUL SYLLABLE SSANGKIYEOK E SSANGSIOS
    { 0x8446, 0xAEEE }, // HANGUL SYLLABLE SSANGKIYEOK E CIEUC
    { 0x8447, 0xAEEF }, // HANGUL SYLLABLE SSANGKIYEOK E CHIEUCH
    { 0x8448, 0xAEF0 }, // HANGUL SYLLABLE SSANGKIYEOK E KHIEUKH
    { 0x8449, 0xAEF1 }, // HANGUL SYLLABLE SSANGKIYEOK E THIEUTH
    { 0x844A, 0xAEF2 }, // HANGUL SYLLABLE SSANGKIYEOK E PHIEUPH
    { 0x844B, 0xAEF3 }, // HANGUL SYLLABLE SSANGKIYEOK E HIEUH
    { 0x844C, 0xAEF5 }, // HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOK
    { 0x844D, 0xAEF6 }, // HANGUL SYLLABLE SSANGKIYEOK YEO SSANGKIYEOK
    { 0x844E, 0xAEF7 }, // HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOKSIOS
    { 0x844F, 0xAEF9 }, // HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNCIEUC
    { 0x8450, 0xAEFA }, // HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNHIEUH
    { 0x8451, 0xAEFB }, // HANGUL SYLLABLE SSANGKIYEOK YEO TIKEUT
    { 0x8452, 0xAEFD }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULKIYEOK
    { 0x8453, 0xAEFE }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULMIEUM
    { 0x8454, 0xAEFF }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPIEUP
    { 0x8455, 0xAF00 }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULSIOS
    { 0x8456, 0xAF01 }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULTHIEUTH
    { 0x8457, 0xAF02 }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPHIEUPH
    { 0x8458, 0xAF03 }, // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULHIEUH
    { 0x8459, 0xAF04 }, // HANGUL SYLLABLE SSANGKIYEOK YEO MIEUM
    { 0x845A, 0xAF05 }, // HANGUL SYLLABLE SSANGKIYEOK YEO PIEUP
    { 0x8461, 0xAF06 }, // HANGUL SYLLABLE SSANGKIYEOK YEO PIEUPSIOS
    { 0x8462, 0xAF09 }, // HANGUL SYLLABLE SSANGKIYEOK YEO IEUNG
    { 0x8463, 0xAF0A }, // HANGUL SYLLABLE SSANGKIYEOK YEO CIEUC
    { 0x8464, 0xAF0B }, // HANGUL SYLLABLE SSANGKIYEOK YEO CHIEUCH
    { 0x8465, 0xAF0C }, // HANGUL SYLLABLE SSANGKIYEOK YEO KHIEUKH
    { 0x8466, 0xAF0E }, // HANGUL SYLLABLE SSANGKIYEOK YEO PHIEUPH
    { 0x8467, 0xAF0F }, // HANGUL SYLLABLE SSANGKIYEOK YEO HIEUH
    { 0x8468, 0xAF11 }, // HANGUL SYLLABLE SSANGKIYEOK YE KIYEOK
    { 0x8469, 0xAF12 }, // HANGUL SYLLABLE SSANGKIYEOK YE SSANGKIYEOK
    { 0x846A, 0xAF13 }, // HANGUL SYLLABLE SSANGKIYEOK YE KIYEOKSIOS
    { 0x846B, 0xAF14 }, // HANGUL SYLLABLE SSANGKIYEOK YE NIEUN
    { 0x846C, 0xAF15 }, // HANGUL SYLLABLE SSANGKIYEOK YE NIEUNCIEUC
    { 0x846D, 0xAF16 }, // HANGUL SYLLABLE SSANGKIYEOK YE NIEUNHIEUH
    { 0x846E, 0xAF17 }, // HANGUL SYLLABLE SSANGKIYEOK YE TIKEUT
    { 0x846F, 0xAF18 }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEUL
    { 0x8470, 0xAF19 }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULKIYEOK
    { 0x8471, 0xAF1A }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULMIEUM
    { 0x8472, 0xAF1B }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULPIEUP
    { 0x8473, 0xAF1C }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULSIOS
    { 0x8474, 0xAF1D }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULTHIEUTH
    { 0x8475, 0xAF1E }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULPHIEUPH
    { 0x8476, 0xAF1F }, // HANGUL SYLLABLE SSANGKIYEOK YE RIEULHIEUH
    { 0x8477, 0xAF20 }, // HANGUL SYLLABLE SSANGKIYEOK YE MIEUM
    { 0x8478, 0xAF21 }, // HANGUL SYLLABLE SSANGKIYEOK YE PIEUP
    { 0x8479, 0xAF22 }, // HANGUL SYLLABLE SSANGKIYEOK YE PIEUPSIOS
    { 0x847A, 0xAF23 }, // HANGUL SYLLABLE SSANGKIYEOK YE SIOS
    { 0x8481, 0xAF24 }, // HANGUL SYLLABLE SSANGKIYEOK YE SSANGSIOS
    { 0x8482, 0xAF25 }, // HANGUL SYLLABLE SSANGKIYEOK YE IEUNG
    { 0x8483, 0xAF26 }, // HANGUL SYLLABLE SSANGKIYEOK YE CIEUC
    { 0x8484, 0xAF27 }, // HANGUL SYLLABLE SSANGKIYEOK YE CHIEUCH
    { 0x8485, 0xAF28 }, // HANGUL SYLLABLE SSANGKIYEOK YE KHIEUKH
    { 0x8486, 0xAF29 }, // HANGUL SYLLABLE SSANGKIYEOK YE THIEUTH
    { 0x8487, 0xAF2A }, // HANGUL SYLLABLE SSANGKIYEOK YE PHIEUPH
    { 0x8488, 0xAF2B }, // HANGUL SYLLABLE SSANGKIYEOK YE HIEUH
    { 0x8489, 0xAF2E }, // HANGUL SYLLABLE SSANGKIYEOK O SSANGKIYEOK
    { 0x848A, 0xAF2F }, // HANGUL SYLLABLE SSANGKIYEOK O KIYEOKSIOS
    { 0x848B, 0xAF31 }, // HANGUL SYLLABLE SSANGKIYEOK O NIEUNCIEUC
    { 0x848C, 0xAF33 }, // HANGUL SYLLABLE SSANGKIYEOK O TIKEUT
    { 0x848D, 0xAF35 }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULKIYEOK
    { 0x848E, 0xAF36 }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULMIEUM
    { 0x848F, 0xAF37 }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULPIEUP
    { 0x8490, 0xAF38 }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULSIOS
    { 0x8491, 0xAF39 }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULTHIEUTH
    { 0x8492, 0xAF3A }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULPHIEUPH
    { 0x8493, 0xAF3B }, // HANGUL SYLLABLE SSANGKIYEOK O RIEULHIEUH
    { 0x8494, 0xAF3E }, // HANGUL SYLLABLE SSANGKIYEOK O PIEUPSIOS
    { 0x8495, 0xAF40 }, // HANGUL SYLLABLE SSANGKIYEOK O SSANGSIOS
    { 0x8496, 0xAF44 }, // HANGUL SYLLABLE SSANGKIYEOK O KHIEUKH
    { 0x8497, 0xAF45 }, // HANGUL SYLLABLE SSANGKIYEOK O THIEUTH
    { 0x8498, 0xAF46 }, // HANGUL SYLLABLE SSANGKIYEOK O PHIEUPH
    { 0x8499, 0xAF47 }, // HANGUL SYLLABLE SSANGKIYEOK O HIEUH
    { 0x849A, 0xAF4A }, // HANGUL SYLLABLE SSANGKIYEOK WA SSANGKIYEOK
    { 0x849B, 0xAF4B }, // HANGUL SYLLABLE SSANGKIYEOK WA KIYEOKSIOS
    { 0x849C, 0xAF4C }, // HANGUL SYLLABLE SSANGKIYEOK WA NIEUN
    { 0x849D, 0xAF4D }, // HANGUL SYLLABLE SSANGKIYEOK WA NIEUNCIEUC
    { 0x849E, 0xAF4E }, // HANGUL SYLLABLE SSANGKIYEOK WA NIEUNHIEUH
    { 0x849F, 0xAF4F }, // HANGUL SYLLABLE SSANGKIYEOK WA TIKEUT
    { 0x84A0, 0xAF51 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULKIYEOK
    { 0x84A1, 0xAF52 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULMIEUM
    { 0x84A2, 0xAF53 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULPIEUP
    { 0x84A3, 0xAF54 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULSIOS
    { 0x84A4, 0xAF55 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULTHIEUTH
    { 0x84A5, 0xAF56 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULPHIEUPH
    { 0x84A6, 0xAF57 }, // HANGUL SYLLABLE SSANGKIYEOK WA RIEULHIEUH
    { 0x84A7, 0xAF58 }, // HANGUL SYLLABLE SSANGKIYEOK WA MIEUM
    { 0x84A8, 0xAF59 }, // HANGUL SYLLABLE SSANGKIYEOK WA PIEUP
    { 0x84A9, 0xAF5A }, // HANGUL SYLLABLE SSANGKIYEOK WA PIEUPSIOS
    { 0x84AA, 0xAF5B }, // HANGUL SYLLABLE SSANGKIYEOK WA SIOS
    { 0x84AB, 0xAF5E }, // HANGUL SYLLABLE SSANGKIYEOK WA CIEUC
    { 0x84AC, 0xAF5F }, // HANGUL SYLLABLE SSANGKIYEOK WA CHIEUCH
    { 0x84AD, 0xAF60 }, // HANGUL SYLLABLE SSANGKIYEOK WA KHIEUKH
    { 0x84AE, 0xAF61 }, // HANGUL SYLLABLE SSANGKIYEOK WA THIEUTH
    { 0x84AF, 0xAF62 }, // HANGUL SYLLABLE SSANGKIYEOK WA PHIEUPH
    { 0x84B0, 0xAF63 }, // HANGUL SYLLABLE SSANGKIYEOK WA HIEUH
    { 0x84B1, 0xAF66 }, // HANGUL SYLLABLE SSANGKIYEOK WAE SSANGKIYEOK
    { 0x84B2, 0xAF67 }, // HANGUL SYLLABLE SSANGKIYEOK WAE KIYEOKSIOS
    { 0x84B3, 0xAF68 }, // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUN
    { 0x84B4, 0xAF69 }, // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNCIEUC
    { 0x84B5, 0xAF6A }, // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNHIEUH
    { 0x84B6, 0xAF6B }, // HANGUL SYLLABLE SSANGKIYEOK WAE TIKEUT
    { 0x84B7, 0xAF6C }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEUL
    { 0x84B8, 0xAF6D }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULKIYEOK
    { 0x84B9, 0xAF6E }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULMIEUM
    { 0x84BA, 0xAF6F }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPIEUP
    { 0x84BB, 0xAF70 }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULSIOS
    { 0x84BC, 0xAF71 }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULTHIEUTH
    { 0x84BD, 0xAF72 }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPHIEUPH
    { 0x84BE, 0xAF73 }, // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULHIEUH
    { 0x84BF, 0xAF74 }, // HANGUL SYLLABLE SSANGKIYEOK WAE MIEUM
    { 0x84C0, 0xAF75 }, // HANGUL SYLLABLE SSANGKIYEOK WAE PIEUP
    { 0x84C1, 0xAF76 }, // HANGUL SYLLABLE SSANGKIYEOK WAE PIEUPSIOS
    { 0x84C2, 0xAF77 }, // HANGUL SYLLABLE SSANGKIYEOK WAE SIOS
    { 0x84C3, 0xAF78 }, // HANGUL SYLLABLE SSANGKIYEOK WAE SSANGSIOS
    { 0x84C4, 0xAF7A }, // HANGUL SYLLABLE SSANGKIYEOK WAE CIEUC
    { 0x84C5, 0xAF7B }, // HANGUL SYLLABLE SSANGKIYEOK WAE CHIEUCH
    { 0x84C6, 0xAF7C }, // HANGUL SYLLABLE SSANGKIYEOK WAE KHIEUKH
    { 0x84C7, 0xAF7D }, // HANGUL SYLLABLE SSANGKIYEOK WAE THIEUTH
    { 0x84C8, 0xAF7E }, // HANGUL SYLLABLE SSANGKIYEOK WAE PHIEUPH
    { 0x84C9, 0xAF7F }, // HANGUL SYLLABLE SSANGKIYEOK WAE HIEUH
    { 0x84CA, 0xAF81 }, // HANGUL SYLLABLE SSANGKIYEOK OE KIYEOK
    { 0x84CB, 0xAF82 }, // HANGUL SYLLABLE SSANGKIYEOK OE SSANGKIYEOK
    { 0x84CC, 0xAF83 }, // HANGUL SYLLABLE SSANGKIYEOK OE KIYEOKSIOS
    { 0x84CD, 0xAF85 }, // HANGUL SYLLABLE SSANGKIYEOK OE NIEUNCIEUC
    { 0x84CE, 0xAF86 }, // HANGUL SYLLABLE SSANGKIYEOK OE NIEUNHIEUH
    { 0x84CF, 0xAF87 }, // HANGUL SYLLABLE SSANGKIYEOK OE TIKEUT
    { 0x84D0, 0xAF89 }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULKIYEOK
    { 0x84D1, 0xAF8A }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULMIEUM
    { 0x84D2, 0xAF8B }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULPIEUP
    { 0x84D3, 0xAF8C }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULSIOS
    { 0x84D4, 0xAF8D }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULTHIEUTH
    { 0x84D5, 0xAF8E }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULPHIEUPH
    { 0x84D6, 0xAF8F }, // HANGUL SYLLABLE SSANGKIYEOK OE RIEULHIEUH
    { 0x84D7, 0xAF92 }, // HANGUL SYLLABLE SSANGKIYEOK OE PIEUPSIOS
    { 0x84D8, 0xAF93 }, // HANGUL SYLLABLE SSANGKIYEOK OE SIOS
    { 0x84D9, 0xAF94 }, // HANGUL SYLLABLE SSANGKIYEOK OE SSANGSIOS
    { 0x84DA, 0xAF96 }, // HANGUL SYLLABLE SSANGKIYEOK OE CIEUC
    { 0x84DB, 0xAF97 }, // HANGUL SYLLABLE SSANGKIYEOK OE CHIEUCH
    { 0x84DC, 0xAF98 }, // HANGUL SYLLABLE SSANGKIYEOK OE KHIEUKH
    { 0x84DD, 0xAF99 }, // HANGUL SYLLABLE SSANGKIYEOK OE THIEUTH
    { 0x84DE, 0xAF9A }, // HANGUL SYLLABLE SSANGKIYEOK OE PHIEUPH
    { 0x84DF, 0xAF9B }, // HANGUL SYLLABLE SSANGKIYEOK OE HIEUH
    { 0x84E0, 0xAF9D }, // HANGUL SYLLABLE SSANGKIYEOK YO KIYEOK
    { 0x84E1, 0xAF9E }, // HANGUL SYLLABLE SSANGKIYEOK YO SSANGKIYEOK
    { 0x84E2, 0xAF9F }, // HANGUL SYLLABLE SSANGKIYEOK YO KIYEOKSIOS
    { 0x84E3, 0xAFA0 }, // HANGUL SYLLABLE SSANGKIYEOK YO NIEUN
    { 0x84E4, 0xAFA1 }, // HANGUL SYLLABLE SSANGKIYEOK YO NIEUNCIEUC
    { 0x84E5, 0xAFA2 }, // HANGUL SYLLABLE SSANGKIYEOK YO NIEUNHIEUH
    { 0x84E6, 0xAFA3 }, // HANGUL SYLLABLE SSANGKIYEOK YO TIKEUT
    { 0x84E7, 0xAFA4 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEUL
    { 0x84E8, 0xAFA5 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULKIYEOK
    { 0x84E9, 0xAFA6 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULMIEUM
    { 0x84EA, 0xAFA7 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULPIEUP
    { 0x84EB, 0xAFA8 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULSIOS
    { 0x84EC, 0xAFA9 }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULTHIEUTH
    { 0x84ED, 0xAFAA }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULPHIEUPH
    { 0x84EE, 0xAFAB }, // HANGUL SYLLABLE SSANGKIYEOK YO RIEULHIEUH
    { 0x84EF, 0xAFAC }, // HANGUL SYLLABLE SSANGKIYEOK YO MIEUM
    { 0x84F0, 0xAFAD }, // HANGUL SYLLABLE SSANGKIYEOK YO PIEUP
    { 0x84F1, 0xAFAE }, // HANGUL SYLLABLE SSANGKIYEOK YO PIEUPSIOS
    { 0x84F2, 0xAFAF }, // HANGUL SYLLABLE SSANGKIYEOK YO SIOS
    { 0x84F3, 0xAFB0 }, // HANGUL SYLLABLE SSANGKIYEOK YO SSANGSIOS
    { 0x84F4, 0xAFB1 }, // HANGUL SYLLABLE SSANGKIYEOK YO IEUNG
    { 0x84F5, 0xAFB2 }, // HANGUL SYLLABLE SSANGKIYEOK YO CIEUC
    { 0x84F6, 0xAFB3 }, // HANGUL SYLLABLE SSANGKIYEOK YO CHIEUCH
    { 0x84F7, 0xAFB4 }, // HANGUL SYLLABLE SSANGKIYEOK YO KHIEUKH
    { 0x84F8, 0xAFB5 }, // HANGUL SYLLABLE SSANGKIYEOK YO THIEUTH
    { 0x84F9, 0xAFB6 }, // HANGUL SYLLABLE SSANGKIYEOK YO PHIEUPH
    { 0x84FA, 0xAFB7 }, // HANGUL SYLLABLE SSANGKIYEOK YO HIEUH
    { 0x84FB, 0xAFBA }, // HANGUL SYLLABLE SSANGKIYEOK U SSANGKIYEOK
    { 0x84FC, 0xAFBB }, // HANGUL SYLLABLE SSANGKIYEOK U KIYEOKSIOS
    { 0x84FD, 0xAFBD }, // HANGUL SYLLABLE SSANGKIYEOK U NIEUNCIEUC
    { 0x84FE, 0xAFBE }, // HANGUL SYLLABLE SSANGKIYEOK U NIEUNHIEUH
    { 0x8541, 0xAFBF }, // HANGUL SYLLABLE SSANGKIYEOK U TIKEUT
    { 0x8542, 0xAFC1 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULKIYEOK
    { 0x8543, 0xAFC2 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULMIEUM
    { 0x8544, 0xAFC3 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULPIEUP
    { 0x8545, 0xAFC4 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULSIOS
    { 0x8546, 0xAFC5 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULTHIEUTH
    { 0x8547, 0xAFC6 }, // HANGUL SYLLABLE SSANGKIYEOK U RIEULPHIEUPH
    { 0x8548, 0xAFCA }, // HANGUL SYLLABLE SSANGKIYEOK U PIEUPSIOS
    { 0x8549, 0xAFCC }, // HANGUL SYLLABLE SSANGKIYEOK U SSANGSIOS
    { 0x854A, 0xAFCF }, // HANGUL SYLLABLE SSANGKIYEOK U CHIEUCH
    { 0x854B, 0xAFD0 }, // HANGUL SYLLABLE SSANGKIYEOK U KHIEUKH
    { 0x854C, 0xAFD1 }, // HANGUL SYLLABLE SSANGKIYEOK U THIEUTH
    { 0x854D, 0xAFD2 }, // HANGUL SYLLABLE SSANGKIYEOK U PHIEUPH
    { 0x854E, 0xAFD3 }, // HANGUL SYLLABLE SSANGKIYEOK U HIEUH
    { 0x854F, 0xAFD5 }, // HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOK
    { 0x8550, 0xAFD6 }, // HANGUL SYLLABLE SSANGKIYEOK WEO SSANGKIYEOK
    { 0x8551, 0xAFD7 }, // HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOKSIOS
    { 0x8552, 0xAFD8 }, // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUN
    { 0x8553, 0xAFD9 }, // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNCIEUC
    { 0x8554, 0xAFDA }, // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNHIEUH
    { 0x8555, 0xAFDB }, // HANGUL SYLLABLE SSANGKIYEOK WEO TIKEUT
    { 0x8556, 0xAFDD }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULKIYEOK
    { 0x8557, 0xAFDE }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULMIEUM
    { 0x8558, 0xAFDF }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPIEUP
    { 0x8559, 0xAFE0 }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULSIOS
    { 0x855A, 0xAFE1 }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULTHIEUTH
    { 0x8561, 0xAFE2 }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPHIEUPH
    { 0x8562, 0xAFE3 }, // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULHIEUH
    { 0x8563, 0xAFE4 }, // HANGUL SYLLABLE SSANGKIYEOK WEO MIEUM
    { 0x8564, 0xAFE5 }, // HANGUL SYLLABLE SSANGKIYEOK WEO PIEUP
    { 0x8565, 0xAFE6 }, // HANGUL SYLLABLE SSANGKIYEOK WEO PIEUPSIOS
    { 0x8566, 0xAFE7 }, // HANGUL SYLLABLE SSANGKIYEOK WEO SIOS
    { 0x8567, 0xAFEA }, // HANGUL SYLLABLE SSANGKIYEOK WEO CIEUC
    { 0x8568, 0xAFEB }, // HANGUL SYLLABLE SSANGKIYEOK WEO CHIEUCH
    { 0x8569, 0xAFEC }, // HANGUL SYLLABLE SSANGKIYEOK WEO KHIEUKH
    { 0x856A, 0xAFED }, // HANGUL SYLLABLE SSANGKIYEOK WEO THIEUTH
    { 0x856B, 0xAFEE }, // HANGUL SYLLABLE SSANGKIYEOK WEO PHIEUPH
    { 0x856C, 0xAFEF }, // HANGUL SYLLABLE SSANGKIYEOK WEO HIEUH
    { 0x856D, 0xAFF2 }, // HANGUL SYLLABLE SSANGKIYEOK WE SSANGKIYEOK
    { 0x856E, 0xAFF3 }, // HANGUL SYLLABLE SSANGKIYEOK WE KIYEOKSIOS
    { 0x856F, 0xAFF5 }, // HANGUL SYLLABLE SSANGKIYEOK WE NIEUNCIEUC
    { 0x8570, 0xAFF6 }, // HANGUL SYLLABLE SSANGKIYEOK WE NIEUNHIEUH
    { 0x8571, 0xAFF7 }, // HANGUL SYLLABLE SSANGKIYEOK WE TIKEUT
    { 0x8572, 0xAFF9 }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULKIYEOK
    { 0x8573, 0xAFFA }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULMIEUM
    { 0x8574, 0xAFFB }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULPIEUP
    { 0x8575, 0xAFFC }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULSIOS
    { 0x8576, 0xAFFD }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULTHIEUTH
    { 0x8577, 0xAFFE }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULPHIEUPH
    { 0x8578, 0xAFFF }, // HANGUL SYLLABLE SSANGKIYEOK WE RIEULHIEUH
    { 0x8579, 0xB002 }, // HANGUL SYLLABLE SSANGKIYEOK WE PIEUPSIOS
    { 0x857A, 0xB003 }, // HANGUL SYLLABLE SSANGKIYEOK WE SIOS
    { 0x8581, 0xB005 }, // HANGUL SYLLABLE SSANGKIYEOK WE IEUNG
    { 0x8582, 0xB006 }, // HANGUL SYLLABLE SSANGKIYEOK WE CIEUC
    { 0x8583, 0xB007 }, // HANGUL SYLLABLE SSANGKIYEOK WE CHIEUCH
    { 0x8584, 0xB008 }, // HANGUL SYLLABLE SSANGKIYEOK WE KHIEUKH
    { 0x8585, 0xB009 }, // HANGUL SYLLABLE SSANGKIYEOK WE THIEUTH
    { 0x8586, 0xB00A }, // HANGUL SYLLABLE SSANGKIYEOK WE PHIEUPH
    { 0x8587, 0xB00B }, // HANGUL SYLLABLE SSANGKIYEOK WE HIEUH
    { 0x8588, 0xB00D }, // HANGUL SYLLABLE SSANGKIYEOK WI KIYEOK
    { 0x8589, 0xB00E }, // HANGUL SYLLABLE SSANGKIYEOK WI SSANGKIYEOK
    { 0x858A, 0xB00F }, // HANGUL SYLLABLE SSANGKIYEOK WI KIYEOKSIOS
    { 0x858B, 0xB011 }, // HANGUL SYLLABLE SSANGKIYEOK WI NIEUNCIEUC
    { 0x858C, 0xB012 }, // HANGUL SYLLABLE SSANGKIYEOK WI NIEUNHIEUH
    { 0x858D, 0xB013 }, // HANGUL SYLLABLE SSANGKIYEOK WI TIKEUT
    { 0x858E, 0xB015 }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULKIYEOK
    { 0x858F, 0xB016 }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULMIEUM
    { 0x8590, 0xB017 }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULPIEUP
    { 0x8591, 0xB018 }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULSIOS
    { 0x8592, 0xB019 }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULTHIEUTH
    { 0x8593, 0xB01A }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULPHIEUPH
    { 0x8594, 0xB01B }, // HANGUL SYLLABLE SSANGKIYEOK WI RIEULHIEUH
    { 0x8595, 0xB01E }, // HANGUL SYLLABLE SSANGKIYEOK WI PIEUPSIOS
    { 0x8596, 0xB01F }, // HANGUL SYLLABLE SSANGKIYEOK WI SIOS
    { 0x8597, 0xB020 }, // HANGUL SYLLABLE SSANGKIYEOK WI SSANGSIOS
    { 0x8598, 0xB021 }, // HANGUL SYLLABLE SSANGKIYEOK WI IEUNG
    { 0x8599, 0xB022 }, // HANGUL SYLLABLE SSANGKIYEOK WI CIEUC
    { 0x859A, 0xB023 }, // HANGUL SYLLABLE SSANGKIYEOK WI CHIEUCH
    { 0x859B, 0xB024 }, // HANGUL SYLLABLE SSANGKIYEOK WI KHIEUKH
    { 0x859C, 0xB025 }, // HANGUL SYLLABLE SSANGKIYEOK WI THIEUTH
    { 0x859D, 0xB026 }, // HANGUL SYLLABLE SSANGKIYEOK WI PHIEUPH
    { 0x859E, 0xB027 }, // HANGUL SYLLABLE SSANGKIYEOK WI HIEUH
    { 0x859F, 0xB029 }, // HANGUL SYLLABLE SSANGKIYEOK YU KIYEOK
    { 0x85A0, 0xB02A }, // HANGUL SYLLABLE SSANGKIYEOK YU SSANGKIYEOK
    { 0x85A1, 0xB02B }, // HANGUL SYLLABLE SSANGKIYEOK YU KIYEOKSIOS
    { 0x85A2, 0xB02C }, // HANGUL SYLLABLE SSANGKIYEOK YU NIEUN
    { 0x85A3, 0xB02D }, // HANGUL SYLLABLE SSANGKIYEOK YU NIEUNCIEUC
    { 0x85A4, 0xB02E }, // HANGUL SYLLABLE SSANGKIYEOK YU NIEUNHIEUH
    { 0x85A5, 0xB02F }, // HANGUL SYLLABLE SSANGKIYEOK YU TIKEUT
    { 0x85A6, 0xB030 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEUL
    { 0x85A7, 0xB031 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULKIYEOK
    { 0x85A8, 0xB032 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULMIEUM
    { 0x85A9, 0xB033 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULPIEUP
    { 0x85AA, 0xB034 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULSIOS
    { 0x85AB, 0xB035 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULTHIEUTH
    { 0x85AC, 0xB036 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULPHIEUPH
    { 0x85AD, 0xB037 }, // HANGUL SYLLABLE SSANGKIYEOK YU RIEULHIEUH
    { 0x85AE, 0xB038 }, // HANGUL SYLLABLE SSANGKIYEOK YU MIEUM
    { 0x85AF, 0xB039 }, // HANGUL SYLLABLE SSANGKIYEOK YU PIEUP
    { 0x85B0, 0xB03A }, // HANGUL SYLLABLE SSANGKIYEOK YU PIEUPSIOS
    { 0x85B1, 0xB03B }, // HANGUL SYLLABLE SSANGKIYEOK YU SIOS
    { 0x85B2, 0xB03C }, // HANGUL SYLLABLE SSANGKIYEOK YU SSANGSIOS
    { 0x85B3, 0xB03D }, // HANGUL SYLLABLE SSANGKIYEOK YU IEUNG
    { 0x85B4, 0xB03E }, // HANGUL SYLLABLE SSANGKIYEOK YU CIEUC
    { 0x85B5, 0xB03F }, // HANGUL SYLLABLE SSANGKIYEOK YU CHIEUCH
    { 0x85B6, 0xB040 }, // HANGUL SYLLABLE SSANGKIYEOK YU KHIEUKH
    { 0x85B7, 0xB041 }, // HANGUL SYLLABLE SSANGKIYEOK YU THIEUTH
    { 0x85B8, 0xB042 }, // HANGUL SYLLABLE SSANGKIYEOK YU PHIEUPH
    { 0x85B9, 0xB043 }, // HANGUL SYLLABLE SSANGKIYEOK YU HIEUH
    { 0x85BA, 0xB046 }, // HANGUL SYLLABLE SSANGKIYEOK EU SSANGKIYEOK
    { 0x85BB, 0xB047 }, // HANGUL SYLLABLE SSANGKIYEOK EU KIYEOKSIOS
    { 0x85BC, 0xB049 }, // HANGUL SYLLABLE SSANGKIYEOK EU NIEUNCIEUC
    { 0x85BD, 0xB04B }, // HANGUL SYLLABLE SSANGKIYEOK EU TIKEUT
    { 0x85BE, 0xB04D }, // HANGUL SYLLABLE SSANGKIYEOK EU RIEULKIYEOK
    { 0x85BF, 0xB04F }, // HANGUL SYLLABLE SSANGKIYEOK EU RIEULPIEUP
    { 0x85C0, 0xB050 }, // HANGUL SYLLABLE SSANGKIYEOK EU RIEULSIOS
    { 0x85C1, 0xB051 }, // HANGUL SYLLABLE SSANGKIYEOK EU RIEULTHIEUTH
    { 0x85C2, 0xB052 }, // HANGUL SYLLABLE SSANGKIYEOK EU RIEULPHIEUPH
    { 0x85C3, 0xB056 }, // HANGUL SYLLABLE SSANGKIYEOK EU PIEUPSIOS
    { 0x85C4, 0xB058 }, // HANGUL SYLLABLE SSANGKIYEOK EU SSANGSIOS
    { 0x85C5, 0xB05A }, // HANGUL SYLLABLE SSANGKIYEOK EU CIEUC
    { 0x85C6, 0xB05B }, // HANGUL SYLLABLE SSANGKIYEOK EU CHIEUCH
    { 0x85C7, 0xB05C }, // HANGUL SYLLABLE SSANGKIYEOK EU KHIEUKH
    { 0x85C8, 0xB05E }, // HANGUL SYLLABLE SSANGKIYEOK EU PHIEUPH
    { 0x85C9, 0xB05F }, // HANGUL SYLLABLE SSANGKIYEOK EU HIEUH
    { 0x85CA, 0xB060 }, // HANGUL SYLLABLE SSANGKIYEOK YI
    { 0x85CB, 0xB061 }, // HANGUL SYLLABLE SSANGKIYEOK YI KIYEOK
    { 0x85CC, 0xB062 }, // HANGUL SYLLABLE SSANGKIYEOK YI SSANGKIYEOK
    { 0x85CD, 0xB063 }, // HANGUL SYLLABLE SSANGKIYEOK YI KIYEOKSIOS
    { 0x85CE, 0xB064 }, // HANGUL SYLLABLE SSANGKIYEOK YI NIEUN
    { 0x85CF, 0xB065 }, // HANGUL SYLLABLE SSANGKIYEOK YI NIEUNCIEUC
    { 0x85D0, 0xB066 }, // HANGUL SYLLABLE SSANGKIYEOK YI NIEUNHIEUH
    { 0x85D1, 0xB067 }, // HANGUL SYLLABLE SSANGKIYEOK YI TIKEUT
    { 0x85D2, 0xB068 }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEUL
    { 0x85D3, 0xB069 }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULKIYEOK
    { 0x85D4, 0xB06A }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULMIEUM
    { 0x85D5, 0xB06B }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULPIEUP
    { 0x85D6, 0xB06C }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULSIOS
    { 0x85D7, 0xB06D }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULTHIEUTH
    { 0x85D8, 0xB06E }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULPHIEUPH
    { 0x85D9, 0xB06F }, // HANGUL SYLLABLE SSANGKIYEOK YI RIEULHIEUH
    { 0x85DA, 0xB070 }, // HANGUL SYLLABLE SSANGKIYEOK YI MIEUM
    { 0x85DB, 0xB071 }, // HANGUL SYLLABLE SSANGKIYEOK YI PIEUP
    { 0x85DC, 0xB072 }, // HANGUL SYLLABLE SSANGKIYEOK YI PIEUPSIOS
    { 0x85DD, 0xB073 }, // HANGUL SYLLABLE SSANGKIYEOK YI SIOS
    { 0x85DE, 0xB074 }, // HANGUL SYLLABLE SSANGKIYEOK YI SSANGSIOS
    { 0x85DF, 0xB075 }, // HANGUL SYLLABLE SSANGKIYEOK YI IEUNG
    { 0x85E0, 0xB076 }, // HANGUL SYLLABLE SSANGKIYEOK YI CIEUC
    { 0x85E1, 0xB077 }, // HANGUL SYLLABLE SSANGKIYEOK YI CHIEUCH
    { 0x85E2, 0xB078 }, // HANGUL SYLLABLE SSANGKIYEOK YI KHIEUKH
    { 0x85E3, 0xB079 }, // HANGUL SYLLABLE SSANGKIYEOK YI THIEUTH
    { 0x85E4, 0xB07A }, // HANGUL SYLLABLE SSANGKIYEOK YI PHIEUPH
    { 0x85E5, 0xB07B }, // HANGUL SYLLABLE SSANGKIYEOK YI HIEUH
    { 0x85E6, 0xB07E }, // HANGUL SYLLABLE SSANGKIYEOK I SSANGKIYEOK
    { 0x85E7, 0xB07F }, // HANGUL SYLLABLE SSANGKIYEOK I KIYEOKSIOS
    { 0x85E8, 0xB081 }, // HANGUL SYLLABLE SSANGKIYEOK I NIEUNCIEUC
    { 0x85E9, 0xB082 }, // HANGUL SYLLABLE SSANGKIYEOK I NIEUNHIEUH
    { 0x85EA, 0xB083 }, // HANGUL SYLLABLE SSANGKIYEOK I TIKEUT
    { 0x85EB, 0xB085 }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULKIYEOK
    { 0x85EC, 0xB086 }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULMIEUM
    { 0x85ED, 0xB087 }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULPIEUP
    { 0x85EE, 0xB088 }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULSIOS
    { 0x85EF, 0xB089 }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULTHIEUTH
    { 0x85F0, 0xB08A }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULPHIEUPH
    { 0x85F1, 0xB08B }, // HANGUL SYLLABLE SSANGKIYEOK I RIEULHIEUH
    { 0x85F2, 0xB08E }, // HANGUL SYLLABLE SSANGKIYEOK I PIEUPSIOS
    { 0x85F3, 0xB090 }, // HANGUL SYLLABLE SSANGKIYEOK I SSANGSIOS
    { 0x85F4, 0xB092 }, // HANGUL SYLLABLE SSANGKIYEOK I CIEUC
    { 0x85F5, 0xB093 }, // HANGUL SYLLABLE SSANGKIYEOK I CHIEUCH
    { 0x85F6, 0xB094 }, // HANGUL SYLLABLE SSANGKIYEOK I KHIEUKH
    { 0x85F7, 0xB095 }, // HANGUL SYLLABLE SSANGKIYEOK I THIEUTH
    { 0x85F8, 0xB096 }, // HANGUL SYLLABLE SSANGKIYEOK I PHIEUPH
    { 0x85F9, 0xB097 }, // HANGUL SYLLABLE SSANGKIYEOK I HIEUH
    { 0x85FA, 0xB09B }, // HANGUL SYLLABLE NIEUN A KIYEOKSIOS
    { 0x85FB, 0xB09D }, // HANGUL SYLLABLE NIEUN A NIEUNCIEUC
    { 0x85FC, 0xB09E }, // HANGUL SYLLABLE NIEUN A NIEUNHIEUH
    { 0x85FD, 0xB0A3 }, // HANGUL SYLLABLE NIEUN A RIEULPIEUP
    { 0x85FE, 0xB0A4 }, // HANGUL SYLLABLE NIEUN A RIEULSIOS
    { 0x8641, 0xB0A5 }, // HANGUL SYLLABLE NIEUN A RIEULTHIEUTH
    { 0x8642, 0xB0A6 }, // HANGUL SYLLABLE NIEUN A RIEULPHIEUPH
    { 0x8643, 0xB0A7 }, // HANGUL SYLLABLE NIEUN A RIEULHIEUH
    { 0x8644, 0xB0AA }, // HANGUL SYLLABLE NIEUN A PIEUPSIOS
    { 0x8645, 0xB0B0 }, // HANGUL SYLLABLE NIEUN A KHIEUKH
    { 0x8646, 0xB0B2 }, // HANGUL SYLLABLE NIEUN A PHIEUPH
    { 0x8647, 0xB0B6 }, // HANGUL SYLLABLE NIEUN AE SSANGKIYEOK
    { 0x8648, 0xB0B7 }, // HANGUL SYLLABLE NIEUN AE KIYEOKSIOS
    { 0x8649, 0xB0B9 }, // HANGUL SYLLABLE NIEUN AE NIEUNCIEUC
    { 0x864A, 0xB0BA }, // HANGUL SYLLABLE NIEUN AE NIEUNHIEUH
    { 0x864B, 0xB0BB }, // HANGUL SYLLABLE NIEUN AE TIKEUT
    { 0x864C, 0xB0BD }, // HANGUL SYLLABLE NIEUN AE RIEULKIYEOK
    { 0x864D, 0xB0BE }, // HANGUL SYLLABLE NIEUN AE RIEULMIEUM
    { 0x864E, 0xB0BF }, // HANGUL SYLLABLE NIEUN AE RIEULPIEUP
    { 0x864F, 0xB0C0 }, // HANGUL SYLLABLE NIEUN AE RIEULSIOS
    { 0x8650, 0xB0C1 }, // HANGUL SYLLABLE NIEUN AE RIEULTHIEUTH
    { 0x8651, 0xB0C2 }, // HANGUL SYLLABLE NIEUN AE RIEULPHIEUPH
    { 0x8652, 0xB0C3 }, // HANGUL SYLLABLE NIEUN AE RIEULHIEUH
    { 0x8653, 0xB0C6 }, // HANGUL SYLLABLE NIEUN AE PIEUPSIOS
    { 0x8654, 0xB0CA }, // HANGUL SYLLABLE NIEUN AE CIEUC
    { 0x8655, 0xB0CB }, // HANGUL SYLLABLE NIEUN AE CHIEUCH
    { 0x8656, 0xB0CC }, // HANGUL SYLLABLE NIEUN AE KHIEUKH
    { 0x8657, 0xB0CD }, // HANGUL SYLLABLE NIEUN AE THIEUTH
    { 0x8658, 0xB0CE }, // HANGUL SYLLABLE NIEUN AE PHIEUPH
    { 0x8659, 0xB0CF }, // HANGUL SYLLABLE NIEUN AE HIEUH
    { 0x865A, 0xB0D2 }, // HANGUL SYLLABLE NIEUN YA SSANGKIYEOK
    { 0x8661, 0xB0D3 }, // HANGUL SYLLABLE NIEUN YA KIYEOKSIOS
    { 0x8662, 0xB0D5 }, // HANGUL SYLLABLE NIEUN YA NIEUNCIEUC
    { 0x8663, 0xB0D6 }, // HANGUL SYLLABLE NIEUN YA NIEUNHIEUH
    { 0x8664, 0xB0D7 }, // HANGUL SYLLABLE NIEUN YA TIKEUT
    { 0x8665, 0xB0D9 }, // HANGUL SYLLABLE NIEUN YA RIEULKIYEOK
    { 0x8666, 0xB0DA }, // HANGUL SYLLABLE NIEUN YA RIEULMIEUM
    { 0x8667, 0xB0DB }, // HANGUL SYLLABLE NIEUN YA RIEULPIEUP
    { 0x8668, 0xB0DC }, // HANGUL SYLLABLE NIEUN YA RIEULSIOS
    { 0x8669, 0xB0DD }, // HANGUL SYLLABLE NIEUN YA RIEULTHIEUTH
    { 0x866A, 0xB0DE }, // HANGUL SYLLABLE NIEUN YA RIEULPHIEUPH
    { 0x866B, 0xB0DF }, // HANGUL SYLLABLE NIEUN YA RIEULHIEUH
    { 0x866C, 0xB0E1 }, // HANGUL SYLLABLE NIEUN YA PIEUP
    { 0x866D, 0xB0E2 }, // HANGUL SYLLABLE NIEUN YA PIEUPSIOS
    { 0x866E, 0xB0E3 }, // HANGUL SYLLABLE NIEUN YA SIOS
    { 0x866F, 0xB0E4 }, // HANGUL SYLLABLE NIEUN YA SSANGSIOS
    { 0x8670, 0xB0E6 }, // HANGUL SYLLABLE NIEUN YA CIEUC
    { 0x8671, 0xB0E7 }, // HANGUL SYLLABLE NIEUN YA CHIEUCH
    { 0x8672, 0xB0E8 }, // HANGUL SYLLABLE NIEUN YA KHIEUKH
    { 0x8673, 0xB0E9 }, // HANGUL SYLLABLE NIEUN YA THIEUTH
    { 0x8674, 0xB0EA }, // HANGUL SYLLABLE NIEUN YA PHIEUPH
    { 0x8675, 0xB0EB }, // HANGUL SYLLABLE NIEUN YA HIEUH
    { 0x8676, 0xB0EC }, // HANGUL SYLLABLE NIEUN YAE
    { 0x8677, 0xB0ED }, // HANGUL SYLLABLE NIEUN YAE KIYEOK
    { 0x8678, 0xB0EE }, // HANGUL SYLLABLE NIEUN YAE SSANGKIYEOK
    { 0x8679, 0xB0EF }, // HANGUL SYLLABLE NIEUN YAE KIYEOKSIOS
    { 0x867A, 0xB0F0 }, // HANGUL SYLLABLE NIEUN YAE NIEUN
    { 0x8681, 0xB0F1 }, // HANGUL SYLLABLE NIEUN YAE NIEUNCIEUC
    { 0x8682, 0xB0F2 }, // HANGUL SYLLABLE NIEUN YAE NIEUNHIEUH
    { 0x8683, 0xB0F3 }, // HANGUL SYLLABLE NIEUN YAE TIKEUT
    { 0x8684, 0xB0F4 }, // HANGUL SYLLABLE NIEUN YAE RIEUL
    { 0x8685, 0xB0F5 }, // HANGUL SYLLABLE NIEUN YAE RIEULKIYEOK
    { 0x8686, 0xB0F6 }, // HANGUL SYLLABLE NIEUN YAE RIEULMIEUM
    { 0x8687, 0xB0F7 }, // HANGUL SYLLABLE NIEUN YAE RIEULPIEUP
    { 0x8688, 0xB0F8 }, // HANGUL SYLLABLE NIEUN YAE RIEULSIOS
    { 0x8689, 0xB0F9 }, // HANGUL SYLLABLE NIEUN YAE RIEULTHIEUTH
    { 0x868A, 0xB0FA }, // HANGUL SYLLABLE NIEUN YAE RIEULPHIEUPH
    { 0x868B, 0xB0FB }, // HANGUL SYLLABLE NIEUN YAE RIEULHIEUH
    { 0x868C, 0xB0FC }, // HANGUL SYLLABLE NIEUN YAE MIEUM
    { 0x868D, 0xB0FD }, // HANGUL SYLLABLE NIEUN YAE PIEUP
    { 0x868E, 0xB0FE }, // HANGUL SYLLABLE NIEUN YAE PIEUPSIOS
    { 0x868F, 0xB0FF }, // HANGUL SYLLABLE NIEUN YAE SIOS
    { 0x8690, 0xB100 }, // HANGUL SYLLABLE NIEUN YAE SSANGSIOS
    { 0x8691, 0xB101 }, // HANGUL SYLLABLE NIEUN YAE IEUNG
    { 0x8692, 0xB102 }, // HANGUL SYLLABLE NIEUN YAE CIEUC
    { 0x8693, 0xB103 }, // HANGUL SYLLABLE NIEUN YAE CHIEUCH
    { 0x8694, 0xB104 }, // HANGUL SYLLABLE NIEUN YAE KHIEUKH
    { 0x8695, 0xB105 }, // HANGUL SYLLABLE NIEUN YAE THIEUTH
    { 0x8696, 0xB106 }, // HANGUL SYLLABLE NIEUN YAE PHIEUPH
    { 0x8697, 0xB107 }, // HANGUL SYLLABLE NIEUN YAE HIEUH
    { 0x8698, 0xB10A }, // HANGUL SYLLABLE NIEUN EO SSANGKIYEOK
    { 0x8699, 0xB10D }, // HANGUL SYLLABLE NIEUN EO NIEUNCIEUC
    { 0x869A, 0xB10E }, // HANGUL SYLLABLE NIEUN EO NIEUNHIEUH
    { 0x869B, 0xB10F }, // HANGUL SYLLABLE NIEUN EO TIKEUT
    { 0x869C, 0xB111 }, // HANGUL SYLLABLE NIEUN EO RIEULKIYEOK
    { 0x869D, 0xB114 }, // HANGUL SYLLABLE NIEUN EO RIEULSIOS
    { 0x869E, 0xB115 }, // HANGUL SYLLABLE NIEUN EO RIEULTHIEUTH
    { 0x869F, 0xB116 }, // HANGUL SYLLABLE NIEUN EO RIEULPHIEUPH
    { 0x86A0, 0xB117 }, // HANGUL SYLLABLE NIEUN EO RIEULHIEUH
    { 0x86A1, 0xB11A }, // HANGUL SYLLABLE NIEUN EO PIEUPSIOS
    { 0x86A2, 0xB11E }, // HANGUL SYLLABLE NIEUN EO CIEUC
    { 0x86A3, 0xB11F }, // HANGUL SYLLABLE NIEUN EO CHIEUCH
    { 0x86A4, 0xB120 }, // HANGUL SYLLABLE NIEUN EO KHIEUKH
    { 0x86A5, 0xB121 }, // HANGUL SYLLABLE NIEUN EO THIEUTH
    { 0x86A6, 0xB122 }, // HANGUL SYLLABLE NIEUN EO PHIEUPH
    { 0x86A7, 0xB126 }, // HANGUL SYLLABLE NIEUN E SSANGKIYEOK
    { 0x86A8, 0xB127 }, // HANGUL SYLLABLE NIEUN E KIYEOKSIOS
    { 0x86A9, 0xB129 }, // HANGUL SYLLABLE NIEUN E NIEUNCIEUC
    { 0x86AA, 0xB12A }, // HANGUL SYLLABLE NIEUN E NIEUNHIEUH
    { 0x86AB, 0xB12B }, // HANGUL SYLLABLE NIEUN E TIKEUT
    { 0x86AC, 0xB12D }, // HANGUL SYLLABLE NIEUN E RIEULKIYEOK
    { 0x86AD, 0xB12E }, // HANGUL SYLLABLE NIEUN E RIEULMIEUM
    { 0x86AE, 0xB12F }, // HANGUL SYLLABLE NIEUN E RIEULPIEUP
    { 0x86AF, 0xB130 }, // HANGUL SYLLABLE NIEUN E RIEULSIOS
    { 0x86B0, 0xB131 }, // HANGUL SYLLABLE NIEUN E RIEULTHIEUTH
    { 0x86B1, 0xB132 }, // HANGUL SYLLABLE NIEUN E RIEULPHIEUPH
    { 0x86B2, 0xB133 }, // HANGUL SYLLABLE NIEUN E RIEULHIEUH
    { 0x86B3, 0xB136 }, // HANGUL SYLLABLE NIEUN E PIEUPSIOS
    { 0x86B4, 0xB13A }, // HANGUL SYLLABLE NIEUN E CIEUC
    { 0x86B5, 0xB13B }, // HANGUL SYLLABLE NIEUN E CHIEUCH
    { 0x86B6, 0xB13C }, // HANGUL SYLLABLE NIEUN E KHIEUKH
    { 0x86B7, 0xB13D }, // HANGUL SYLLABLE NIEUN E THIEUTH
    { 0x86B8, 0xB13E }, // HANGUL SYLLABLE NIEUN E PHIEUPH
    { 0x86B9, 0xB13F }, // HANGUL SYLLABLE NIEUN E HIEUH
    { 0x86BA, 0xB142 }, // HANGUL SYLLABLE NIEUN YEO SSANGKIYEOK
    { 0x86BB, 0xB143 }, // HANGUL SYLLABLE NIEUN YEO KIYEOKSIOS
    { 0x86BC, 0xB145 }, // HANGUL SYLLABLE NIEUN YEO NIEUNCIEUC
    { 0x86BD, 0xB146 }, // HANGUL SYLLABLE NIEUN YEO NIEUNHIEUH
    { 0x86BE, 0xB147 }, // HANGUL SYLLABLE NIEUN YEO TIKEUT
    { 0x86BF, 0xB149 }, // HANGUL SYLLABLE NIEUN YEO RIEULKIYEOK
    { 0x86C0, 0xB14A }, // HANGUL SYLLABLE NIEUN YEO RIEULMIEUM
    { 0x86C1, 0xB14B }, // HANGUL SYLLABLE NIEUN YEO RIEULPIEUP
    { 0x86C2, 0xB14C }, // HANGUL SYLLABLE NIEUN YEO RIEULSIOS
    { 0x86C3, 0xB14D }, // HANGUL SYLLABLE NIEUN YEO RIEULTHIEUTH
    { 0x86C4, 0xB14E }, // HANGUL SYLLABLE NIEUN YEO RIEULPHIEUPH
    { 0x86C5, 0xB14F }, // HANGUL SYLLABLE NIEUN YEO RIEULHIEUH
    { 0x86C6, 0xB152 }, // HANGUL SYLLABLE NIEUN YEO PIEUPSIOS
    { 0x86C7, 0xB153 }, // HANGUL SYLLABLE NIEUN YEO SIOS
    { 0x86C8, 0xB156 }, // HANGUL SYLLABLE NIEUN YEO CIEUC
    { 0x86C9, 0xB157 }, // HANGUL SYLLABLE NIEUN YEO CHIEUCH
    { 0x86CA, 0xB159 }, // HANGUL SYLLABLE NIEUN YEO THIEUTH
    { 0x86CB, 0xB15A }, // HANGUL SYLLABLE NIEUN YEO PHIEUPH
    { 0x86CC, 0xB15B }, // HANGUL SYLLABLE NIEUN YEO HIEUH
    { 0x86CD, 0xB15D }, // HANGUL SYLLABLE NIEUN YE KIYEOK
    { 0x86CE, 0xB15E }, // HANGUL SYLLABLE NIEUN YE SSANGKIYEOK
    { 0x86CF, 0xB15F }, // HANGUL SYLLABLE NIEUN YE KIYEOKSIOS
    { 0x86D0, 0xB161 }, // HANGUL SYLLABLE NIEUN YE NIEUNCIEUC
    { 0x86D1, 0xB162 }, // HANGUL SYLLABLE NIEUN YE NIEUNHIEUH
    { 0x86D2, 0xB163 }, // HANGUL SYLLABLE NIEUN YE TIKEUT
    { 0x86D3, 0xB164 }, // HANGUL SYLLABLE NIEUN YE RIEUL
    { 0x86D4, 0xB165 }, // HANGUL SYLLABLE NIEUN YE RIEULKIYEOK
    { 0x86D5, 0xB166 }, // HANGUL SYLLABLE NIEUN YE RIEULMIEUM
    { 0x86D6, 0xB167 }, // HANGUL SYLLABLE NIEUN YE RIEULPIEUP
    { 0x86D7, 0xB168 }, // HANGUL SYLLABLE NIEUN YE RIEULSIOS
    { 0x86D8, 0xB169 }, // HANGUL SYLLABLE NIEUN YE RIEULTHIEUTH
    { 0x86D9, 0xB16A }, // HANGUL SYLLABLE NIEUN YE RIEULPHIEUPH
    { 0x86DA, 0xB16B }, // HANGUL SYLLABLE NIEUN YE RIEULHIEUH
    { 0x86DB, 0xB16C }, // HANGUL SYLLABLE NIEUN YE MIEUM
    { 0x86DC, 0xB16D }, // HANGUL SYLLABLE NIEUN YE PIEUP
    { 0x86DD, 0xB16E }, // HANGUL SYLLABLE NIEUN YE PIEUPSIOS
    { 0x86DE, 0xB16F }, // HANGUL SYLLABLE NIEUN YE SIOS
    { 0x86DF, 0xB170 }, // HANGUL SYLLABLE NIEUN YE SSANGSIOS
    { 0x86E0, 0xB171 }, // HANGUL SYLLABLE NIEUN YE IEUNG
    { 0x86E1, 0xB172 }, // HANGUL SYLLABLE NIEUN YE CIEUC
    { 0x86E2, 0xB173 }, // HANGUL SYLLABLE NIEUN YE CHIEUCH
    { 0x86E3, 0xB174 }, // HANGUL SYLLABLE NIEUN YE KHIEUKH
    { 0x86E4, 0xB175 }, // HANGUL SYLLABLE NIEUN YE THIEUTH
    { 0x86E5, 0xB176 }, // HANGUL SYLLABLE NIEUN YE PHIEUPH
    { 0x86E6, 0xB177 }, // HANGUL SYLLABLE NIEUN YE HIEUH
    { 0x86E7, 0xB17A }, // HANGUL SYLLABLE NIEUN O SSANGKIYEOK
    { 0x86E8, 0xB17B }, // HANGUL SYLLABLE NIEUN O KIYEOKSIOS
    { 0x86E9, 0xB17D }, // HANGUL SYLLABLE NIEUN O NIEUNCIEUC
    { 0x86EA, 0xB17E }, // HANGUL SYLLABLE NIEUN O NIEUNHIEUH
    { 0x86EB, 0xB17F }, // HANGUL SYLLABLE NIEUN O TIKEUT
    { 0x86EC, 0xB181 }, // HANGUL SYLLABLE NIEUN O RIEULKIYEOK
    { 0x86ED, 0xB183 }, // HANGUL SYLLABLE NIEUN O RIEULPIEUP
    { 0x86EE, 0xB184 }, // HANGUL SYLLABLE NIEUN O RIEULSIOS
    { 0x86EF, 0xB185 }, // HANGUL SYLLABLE NIEUN O RIEULTHIEUTH
    { 0x86F0, 0xB186 }, // HANGUL SYLLABLE NIEUN O RIEULPHIEUPH
    { 0x86F1, 0xB187 }, // HANGUL SYLLABLE NIEUN O RIEULHIEUH
    { 0x86F2, 0xB18A }, // HANGUL SYLLABLE NIEUN O PIEUPSIOS
    { 0x86F3, 0xB18C }, // HANGUL SYLLABLE NIEUN O SSANGSIOS
    { 0x86F4, 0xB18E }, // HANGUL SYLLABLE NIEUN O CIEUC
    { 0x86F5, 0xB18F }, // HANGUL SYLLABLE NIEUN O CHIEUCH
    { 0x86F6, 0xB190 }, // HANGUL SYLLABLE NIEUN O KHIEUKH
    { 0x86F7, 0xB191 }, // HANGUL SYLLABLE NIEUN O THIEUTH
    { 0x86F8, 0xB195 }, // HANGUL SYLLABLE NIEUN WA KIYEOK
    { 0x86F9, 0xB196 }, // HANGUL SYLLABLE NIEUN WA SSANGKIYEOK
    { 0x86FA, 0xB197 }, // HANGUL SYLLABLE NIEUN WA KIYEOKSIOS
    { 0x86FB, 0xB199 }, // HANGUL SYLLABLE NIEUN WA NIEUNCIEUC
    { 0x86FC, 0xB19A }, // HANGUL SYLLABLE NIEUN WA NIEUNHIEUH
    { 0x86FD, 0xB19B }, // HANGUL SYLLABLE NIEUN WA TIKEUT
    { 0x86FE, 0xB19D }, // HANGUL SYLLABLE NIEUN WA RIEULKIYEOK
    { 0x8741, 0xB19E }, // HANGUL SYLLABLE NIEUN WA RIEULMIEUM
    { 0x8742, 0xB19F }, // HANGUL SYLLABLE NIEUN WA RIEULPIEUP
    { 0x8743, 0xB1A0 }, // HANGUL SYLLABLE NIEUN WA RIEULSIOS
    { 0x8744, 0xB1A1 }, // HANGUL SYLLABLE NIEUN WA RIEULTHIEUTH
    { 0x8745, 0xB1A2 }, // HANGUL SYLLABLE NIEUN WA RIEULPHIEUPH
    { 0x8746, 0xB1A3 }, // HANGUL SYLLABLE NIEUN WA RIEULHIEUH
    { 0x8747, 0xB1A4 }, // HANGUL SYLLABLE NIEUN WA MIEUM
    { 0x8748, 0xB1A5 }, // HANGUL SYLLABLE NIEUN WA PIEUP
    { 0x8749, 0xB1A6 }, // HANGUL SYLLABLE NIEUN WA PIEUPSIOS
    { 0x874A, 0xB1A7 }, // HANGUL SYLLABLE NIEUN WA SIOS
    { 0x874B, 0xB1A9 }, // HANGUL SYLLABLE NIEUN WA IEUNG
    { 0x874C, 0xB1AA }, // HANGUL SYLLABLE NIEUN WA CIEUC
    { 0x874D, 0xB1AB }, // HANGUL SYLLABLE NIEUN WA CHIEUCH
    { 0x874E, 0xB1AC }, // HANGUL SYLLABLE NIEUN WA KHIEUKH
    { 0x874F, 0xB1AD }, // HANGUL SYLLABLE NIEUN WA THIEUTH
    { 0x8750, 0xB1AE }, // HANGUL SYLLABLE NIEUN WA PHIEUPH
    { 0x8751, 0xB1AF }, // HANGUL SYLLABLE NIEUN WA HIEUH
    { 0x8752, 0xB1B0 }, // HANGUL SYLLABLE NIEUN WAE
    { 0x8753, 0xB1B1 }, // HANGUL SYLLABLE NIEUN WAE KIYEOK
    { 0x8754, 0xB1B2 }, // HANGUL SYLLABLE NIEUN WAE SSANGKIYEOK
    { 0x8755, 0xB1B3 }, // HANGUL SYLLABLE NIEUN WAE KIYEOKSIOS
    { 0x8756, 0xB1B4 }, // HANGUL SYLLABLE NIEUN WAE NIEUN
    { 0x8757, 0xB1B5 }, // HANGUL SYLLABLE NIEUN WAE NIEUNCIEUC
    { 0x8758, 0xB1B6 }, // HANGUL SYLLABLE NIEUN WAE NIEUNHIEUH
    { 0x8759, 0xB1B7 }, // HANGUL SYLLABLE NIEUN WAE TIKEUT
    { 0x875A, 0xB1B8 }, // HANGUL SYLLABLE NIEUN WAE RIEUL
    { 0x8761, 0xB1B9 }, // HANGUL SYLLABLE NIEUN WAE RIEULKIYEOK
    { 0x8762, 0xB1BA }, // HANGUL SYLLABLE NIEUN WAE RIEULMIEUM
    { 0x8763, 0xB1BB }, // HANGUL SYLLABLE NIEUN WAE RIEULPIEUP
    { 0x8764, 0xB1BC }, // HANGUL SYLLABLE NIEUN WAE RIEULSIOS
    { 0x8765, 0xB1BD }, // HANGUL SYLLABLE NIEUN WAE RIEULTHIEUTH
    { 0x8766, 0xB1BE }, // HANGUL SYLLABLE NIEUN WAE RIEULPHIEUPH
    { 0x8767, 0xB1BF }, // HANGUL SYLLABLE NIEUN WAE RIEULHIEUH
    { 0x8768, 0xB1C0 }, // HANGUL SYLLABLE NIEUN WAE MIEUM
    { 0x8769, 0xB1C1 }, // HANGUL SYLLABLE NIEUN WAE PIEUP
    { 0x876A, 0xB1C2 }, // HANGUL SYLLABLE NIEUN WAE PIEUPSIOS
    { 0x876B, 0xB1C3 }, // HANGUL SYLLABLE NIEUN WAE SIOS
    { 0x876C, 0xB1C4 }, // HANGUL SYLLABLE NIEUN WAE SSANGSIOS
    { 0x876D, 0xB1C5 }, // HANGUL SYLLABLE NIEUN WAE IEUNG
    { 0x876E, 0xB1C6 }, // HANGUL SYLLABLE NIEUN WAE CIEUC
    { 0x876F, 0xB1C7 }, // HANGUL SYLLABLE NIEUN WAE CHIEUCH
    { 0x8770, 0xB1C8 }, // HANGUL SYLLABLE NIEUN WAE KHIEUKH
    { 0x8771, 0xB1C9 }, // HANGUL SYLLABLE NIEUN WAE THIEUTH
    { 0x8772, 0xB1CA }, // HANGUL SYLLABLE NIEUN WAE PHIEUPH
    { 0x8773, 0xB1CB }, // HANGUL SYLLABLE NIEUN WAE HIEUH
    { 0x8774, 0xB1CD }, // HANGUL SYLLABLE NIEUN OE KIYEOK
    { 0x8775, 0xB1CE }, // HANGUL SYLLABLE NIEUN OE SSANGKIYEOK
    { 0x8776, 0xB1CF }, // HANGUL SYLLABLE NIEUN OE KIYEOKSIOS
    { 0x8777, 0xB1D1 }, // HANGUL SYLLABLE NIEUN OE NIEUNCIEUC
    { 0x8778, 0xB1D2 }, // HANGUL SYLLABLE NIEUN OE NIEUNHIEUH
    { 0x8779, 0xB1D3 }, // HANGUL SYLLABLE NIEUN OE TIKEUT
    { 0x877A, 0xB1D5 }, // HANGUL SYLLABLE NIEUN OE RIEULKIYEOK
    { 0x8781, 0xB1D6 }, // HANGUL SYLLABLE NIEUN OE RIEULMIEUM
    { 0x8782, 0xB1D7 }, // HANGUL SYLLABLE NIEUN OE RIEULPIEUP
    { 0x8783, 0xB1D8 }, // HANGUL SYLLABLE NIEUN OE RIEULSIOS
    { 0x8784, 0xB1D9 }, // HANGUL SYLLABLE NIEUN OE RIEULTHIEUTH
    { 0x8785, 0xB1DA }, // HANGUL SYLLABLE NIEUN OE RIEULPHIEUPH
    { 0x8786, 0xB1DB }, // HANGUL SYLLABLE NIEUN OE RIEULHIEUH
    { 0x8787, 0xB1DE }, // HANGUL SYLLABLE NIEUN OE PIEUPSIOS
    { 0x8788, 0xB1E0 }, // HANGUL SYLLABLE NIEUN OE SSANGSIOS
    { 0x8789, 0xB1E1 }, // HANGUL SYLLABLE NIEUN OE IEUNG
    { 0x878A, 0xB1E2 }, // HANGUL SYLLABLE NIEUN OE CIEUC
    { 0x878B, 0xB1E3 }, // HANGUL SYLLABLE NIEUN OE CHIEUCH
    { 0x878C, 0xB1E4 }, // HANGUL SYLLABLE NIEUN OE KHIEUKH
    { 0x878D, 0xB1E5 }, // HANGUL SYLLABLE NIEUN OE THIEUTH
    { 0x878E, 0xB1E6 }, // HANGUL SYLLABLE NIEUN OE PHIEUPH
    { 0x878F, 0xB1E7 }, // HANGUL SYLLABLE NIEUN OE HIEUH
    { 0x8790, 0xB1EA }, // HANGUL SYLLABLE NIEUN YO SSANGKIYEOK
    { 0x8791, 0xB1EB }, // HANGUL SYLLABLE NIEUN YO KIYEOKSIOS
    { 0x8792, 0xB1ED }, // HANGUL SYLLABLE NIEUN YO NIEUNCIEUC
    { 0x8793, 0xB1EE }, // HANGUL SYLLABLE NIEUN YO NIEUNHIEUH
    { 0x8794, 0xB1EF }, // HANGUL SYLLABLE NIEUN YO TIKEUT
    { 0x8795, 0xB1F1 }, // HANGUL SYLLABLE NIEUN YO RIEULKIYEOK
    { 0x8796, 0xB1F2 }, // HANGUL SYLLABLE NIEUN YO RIEULMIEUM
    { 0x8797, 0xB1F3 }, // HANGUL SYLLABLE NIEUN YO RIEULPIEUP
    { 0x8798, 0xB1F4 }, // HANGUL SYLLABLE NIEUN YO RIEULSIOS
    { 0x8799, 0xB1F5 }, // HANGUL SYLLABLE NIEUN YO RIEULTHIEUTH
    { 0x879A, 0xB1F6 }, // HANGUL SYLLABLE NIEUN YO RIEULPHIEUPH
    { 0x879B, 0xB1F7 }, // HANGUL SYLLABLE NIEUN YO RIEULHIEUH
    { 0x879C, 0xB1F8 }, // HANGUL SYLLABLE NIEUN YO MIEUM
    { 0x879D, 0xB1FA }, // HANGUL SYLLABLE NIEUN YO PIEUPSIOS
    { 0x879E, 0xB1FC }, // HANGUL SYLLABLE NIEUN YO SSANGSIOS
    { 0x879F, 0xB1FE }, // HANGUL SYLLABLE NIEUN YO CIEUC
    { 0x87A0, 0xB1FF }, // HANGUL SYLLABLE NIEUN YO CHIEUCH
    { 0x87A1, 0xB200 }, // HANGUL SYLLABLE NIEUN YO KHIEUKH
    { 0x87A2, 0xB201 }, // HANGUL SYLLABLE NIEUN YO THIEUTH
    { 0x87A3, 0xB202 }, // HANGUL SYLLABLE NIEUN YO PHIEUPH
    { 0x87A4, 0xB203 }, // HANGUL SYLLABLE NIEUN YO HIEUH
    { 0x87A5, 0xB206 }, // HANGUL SYLLABLE NIEUN U SSANGKIYEOK
    { 0x87A6, 0xB207 }, // HANGUL SYLLABLE NIEUN U KIYEOKSIOS
    { 0x87A7, 0xB209 }, // HANGUL SYLLABLE NIEUN U NIEUNCIEUC
    { 0x87A8, 0xB20A }, // HANGUL SYLLABLE NIEUN U NIEUNHIEUH
    { 0x87A9, 0xB20D }, // HANGUL SYLLABLE NIEUN U RIEULKIYEOK
    { 0x87AA, 0xB20E }, // HANGUL SYLLABLE NIEUN U RIEULMIEUM
    { 0x87AB, 0xB20F }, // HANGUL SYLLABLE NIEUN U RIEULPIEUP
    { 0x87AC, 0xB210 }, // HANGUL SYLLABLE NIEUN U RIEULSIOS
    { 0x87AD, 0xB211 }, // HANGUL SYLLABLE NIEUN U RIEULTHIEUTH
    { 0x87AE, 0xB212 }, // HANGUL SYLLABLE NIEUN U RIEULPHIEUPH
    { 0x87AF, 0xB213 }, // HANGUL SYLLABLE NIEUN U RIEULHIEUH
    { 0x87B0, 0xB216 }, // HANGUL SYLLABLE NIEUN U PIEUPSIOS
    { 0x87B1, 0xB218 }, // HANGUL SYLLABLE NIEUN U SSANGSIOS
    { 0x87B2, 0xB21A }, // HANGUL SYLLABLE NIEUN U CIEUC
    { 0x87B3, 0xB21B }, // HANGUL SYLLABLE NIEUN U CHIEUCH
    { 0x87B4, 0xB21C }, // HANGUL SYLLABLE NIEUN U KHIEUKH
    { 0x87B5, 0xB21D }, // HANGUL SYLLABLE NIEUN U THIEUTH
    { 0x87B6, 0xB21E }, // HANGUL SYLLABLE NIEUN U PHIEUPH
    { 0x87B7, 0xB21F }, // HANGUL SYLLABLE NIEUN U HIEUH
    { 0x87B8, 0xB221 }, // HANGUL SYLLABLE NIEUN WEO KIYEOK
    { 0x87B9, 0xB222 }, // HANGUL SYLLABLE NIEUN WEO SSANGKIYEOK
    { 0x87BA, 0xB223 }, // HANGUL SYLLABLE NIEUN WEO KIYEOKSIOS
    { 0x87BB, 0xB224 }, // HANGUL SYLLABLE NIEUN WEO NIEUN
    { 0x87BC, 0xB225 }, // HANGUL SYLLABLE NIEUN WEO NIEUNCIEUC
    { 0x87BD, 0xB226 }, // HANGUL SYLLABLE NIEUN WEO NIEUNHIEUH
    { 0x87BE, 0xB227 }, // HANGUL SYLLABLE NIEUN WEO TIKEUT
    { 0x87BF, 0xB228 }, // HANGUL SYLLABLE NIEUN WEO RIEUL
    { 0x87C0, 0xB229 }, // HANGUL SYLLABLE NIEUN WEO RIEULKIYEOK
    { 0x87C1, 0xB22A }, // HANGUL SYLLABLE NIEUN WEO RIEULMIEUM
    { 0x87C2, 0xB22B }, // HANGUL SYLLABLE NIEUN WEO RIEULPIEUP
    { 0x87C3, 0xB22C }, // HANGUL SYLLABLE NIEUN WEO RIEULSIOS
    { 0x87C4, 0xB22D }, // HANGUL SYLLABLE NIEUN WEO RIEULTHIEUTH
    { 0x87C5, 0xB22E }, // HANGUL SYLLABLE NIEUN WEO RIEULPHIEUPH
    { 0x87C6, 0xB22F }, // HANGUL SYLLABLE NIEUN WEO RIEULHIEUH
    { 0x87C7, 0xB230 }, // HANGUL SYLLABLE NIEUN WEO MIEUM
    { 0x87C8, 0xB231 }, // HANGUL SYLLABLE NIEUN WEO PIEUP
    { 0x87C9, 0xB232 }, // HANGUL SYLLABLE NIEUN WEO PIEUPSIOS
    { 0x87CA, 0xB233 }, // HANGUL SYLLABLE NIEUN WEO SIOS
    { 0x87CB, 0xB235 }, // HANGUL SYLLABLE NIEUN WEO IEUNG
    { 0x87CC, 0xB236 }, // HANGUL SYLLABLE NIEUN WEO CIEUC
    { 0x87CD, 0xB237 }, // HANGUL SYLLABLE NIEUN WEO CHIEUCH
    { 0x87CE, 0xB238 }, // HANGUL SYLLABLE NIEUN WEO KHIEUKH
    { 0x87CF, 0xB239 }, // HANGUL SYLLABLE NIEUN WEO THIEUTH
    { 0x87D0, 0xB23A }, // HANGUL SYLLABLE NIEUN WEO PHIEUPH
    { 0x87D1, 0xB23B }, // HANGUL SYLLABLE NIEUN WEO HIEUH
    { 0x87D2, 0xB23D }, // HANGUL SYLLABLE NIEUN WE KIYEOK
    { 0x87D3, 0xB23E }, // HANGUL SYLLABLE NIEUN WE SSANGKIYEOK
    { 0x87D4, 0xB23F }, // HANGUL SYLLABLE NIEUN WE KIYEOKSIOS
    { 0x87D5, 0xB240 }, // HANGUL SYLLABLE NIEUN WE NIEUN
    { 0x87D6, 0xB241 }, // HANGUL SYLLABLE NIEUN WE NIEUNCIEUC
    { 0x87D7, 0xB242 }, // HANGUL SYLLABLE NIEUN WE NIEUNHIEUH
    { 0x87D8, 0xB243 }, // HANGUL SYLLABLE NIEUN WE TIKEUT
    { 0x87D9, 0xB244 }, // HANGUL SYLLABLE NIEUN WE RIEUL
    { 0x87DA, 0xB245 }, // HANGUL SYLLABLE NIEUN WE RIEULKIYEOK
    { 0x87DB, 0xB246 }, // HANGUL SYLLABLE NIEUN WE RIEULMIEUM
    { 0x87DC, 0xB247 }, // HANGUL SYLLABLE NIEUN WE RIEULPIEUP
    { 0x87DD, 0xB248 }, // HANGUL SYLLABLE NIEUN WE RIEULSIOS
    { 0x87DE, 0xB249 }, // HANGUL SYLLABLE NIEUN WE RIEULTHIEUTH
    { 0x87DF, 0xB24A }, // HANGUL SYLLABLE NIEUN WE RIEULPHIEUPH
    { 0x87E0, 0xB24B }, // HANGUL SYLLABLE NIEUN WE RIEULHIEUH
    { 0x87E1, 0xB24C }, // HANGUL SYLLABLE NIEUN WE MIEUM
    { 0x87E2, 0xB24D }, // HANGUL SYLLABLE NIEUN WE PIEUP
    { 0x87E3, 0xB24E }, // HANGUL SYLLABLE NIEUN WE PIEUPSIOS
    { 0x87E4, 0xB24F }, // HANGUL SYLLABLE NIEUN WE SIOS
    { 0x87E5, 0xB250 }, // HANGUL SYLLABLE NIEUN WE SSANGSIOS
    { 0x87E6, 0xB251 }, // HANGUL SYLLABLE NIEUN WE IEUNG
    { 0x87E7, 0xB252 }, // HANGUL SYLLABLE NIEUN WE CIEUC
    { 0x87E8, 0xB253 }, // HANGUL SYLLABLE NIEUN WE CHIEUCH
    { 0x87E9, 0xB254 }, // HANGUL SYLLABLE NIEUN WE KHIEUKH
    { 0x87EA, 0xB255 }, // HANGUL SYLLABLE NIEUN WE THIEUTH
    { 0x87EB, 0xB256 }, // HANGUL SYLLABLE NIEUN WE PHIEUPH
    { 0x87EC, 0xB257 }, // HANGUL SYLLABLE NIEUN WE HIEUH
    { 0x87ED, 0xB259 }, // HANGUL SYLLABLE NIEUN WI KIYEOK
    { 0x87EE, 0xB25A }, // HANGUL SYLLABLE NIEUN WI SSANGKIYEOK
    { 0x87EF, 0xB25B }, // HANGUL SYLLABLE NIEUN WI KIYEOKSIOS
    { 0x87F0, 0xB25D }, // HANGUL SYLLABLE NIEUN WI NIEUNCIEUC
    { 0x87F1, 0xB25E }, // HANGUL SYLLABLE NIEUN WI NIEUNHIEUH
    { 0x87F2, 0xB25F }, // HANGUL SYLLABLE NIEUN WI TIKEUT
    { 0x87F3, 0xB261 }, // HANGUL SYLLABLE NIEUN WI RIEULKIYEOK
    { 0x87F4, 0xB262 }, // HANGUL SYLLABLE NIEUN WI RIEULMIEUM
    { 0x87F5, 0xB263 }, // HANGUL SYLLABLE NIEUN WI RIEULPIEUP
    { 0x87F6, 0xB264 }, // HANGUL SYLLABLE NIEUN WI RIEULSIOS
    { 0x87F7, 0xB265 }, // HANGUL SYLLABLE NIEUN WI RIEULTHIEUTH
    { 0x87F8, 0xB266 }, // HANGUL SYLLABLE NIEUN WI RIEULPHIEUPH
    { 0x87F9, 0xB267 }, // HANGUL SYLLABLE NIEUN WI RIEULHIEUH
    { 0x87FA, 0xB26A }, // HANGUL SYLLABLE NIEUN WI PIEUPSIOS
    { 0x87FB, 0xB26B }, // HANGUL SYLLABLE NIEUN WI SIOS
    { 0x87FC, 0xB26C }, // HANGUL SYLLABLE NIEUN WI SSANGSIOS
    { 0x87FD, 0xB26D }, // HANGUL SYLLABLE NIEUN WI IEUNG
    { 0x87FE, 0xB26E }, // HANGUL SYLLABLE NIEUN WI CIEUC
    { 0x8841, 0xB26F }, // HANGUL SYLLABLE NIEUN WI CHIEUCH
    { 0x8842, 0xB270 }, // HANGUL SYLLABLE NIEUN WI KHIEUKH
    { 0x8843, 0xB271 }, // HANGUL SYLLABLE NIEUN WI THIEUTH
    { 0x8844, 0xB272 }, // HANGUL SYLLABLE NIEUN WI PHIEUPH
    { 0x8845, 0xB273 }, // HANGUL SYLLABLE NIEUN WI HIEUH
    { 0x8846, 0xB276 }, // HANGUL SYLLABLE NIEUN YU SSANGKIYEOK
    { 0x8847, 0xB277 }, // HANGUL SYLLABLE NIEUN YU KIYEOKSIOS
    { 0x8848, 0xB278 }, // HANGUL SYLLABLE NIEUN YU NIEUN
    { 0x8849, 0xB279 }, // HANGUL SYLLABLE NIEUN YU NIEUNCIEUC
    { 0x884A, 0xB27A }, // HANGUL SYLLABLE NIEUN YU NIEUNHIEUH
    { 0x884B, 0xB27B }, // HANGUL SYLLABLE NIEUN YU TIKEUT
    { 0x884C, 0xB27D }, // HANGUL SYLLABLE NIEUN YU RIEULKIYEOK
    { 0x884D, 0xB27E }, // HANGUL SYLLABLE NIEUN YU RIEULMIEUM
    { 0x884E, 0xB27F }, // HANGUL SYLLABLE NIEUN YU RIEULPIEUP
    { 0x884F, 0xB280 }, // HANGUL SYLLABLE NIEUN YU RIEULSIOS
    { 0x8850, 0xB281 }, // HANGUL SYLLABLE NIEUN YU RIEULTHIEUTH
    { 0x8851, 0xB282 }, // HANGUL SYLLABLE NIEUN YU RIEULPHIEUPH
    { 0x8852, 0xB283 }, // HANGUL SYLLABLE NIEUN YU RIEULHIEUH
    { 0x8853, 0xB286 }, // HANGUL SYLLABLE NIEUN YU PIEUPSIOS
    { 0x8854, 0xB287 }, // HANGUL SYLLABLE NIEUN YU SIOS
    { 0x8855, 0xB288 }, // HANGUL SYLLABLE NIEUN YU SSANGSIOS
    { 0x8856, 0xB28A }, // HANGUL SYLLABLE NIEUN YU CIEUC
    { 0x8857, 0xB28B }, // HANGUL SYLLABLE NIEUN YU CHIEUCH
    { 0x8858, 0xB28C }, // HANGUL SYLLABLE NIEUN YU KHIEUKH
    { 0x8859, 0xB28D }, // HANGUL SYLLABLE NIEUN YU THIEUTH
    { 0x885A, 0xB28E }, // HANGUL SYLLABLE NIEUN YU PHIEUPH
    { 0x8861, 0xB28F }, // HANGUL SYLLABLE NIEUN YU HIEUH
    { 0x8862, 0xB292 }, // HANGUL SYLLABLE NIEUN EU SSANGKIYEOK
    { 0x8863, 0xB293 }, // HANGUL SYLLABLE NIEUN EU KIYEOKSIOS
    { 0x8864, 0xB295 }, // HANGUL SYLLABLE NIEUN EU NIEUNCIEUC
    { 0x8865, 0xB296 }, // HANGUL SYLLABLE NIEUN EU NIEUNHIEUH
    { 0x8866, 0xB297 }, // HANGUL SYLLABLE NIEUN EU TIKEUT
    { 0x8867, 0xB29B }, // HANGUL SYLLABLE NIEUN EU RIEULPIEUP
    { 0x8868, 0xB29C }, // HANGUL SYLLABLE NIEUN EU RIEULSIOS
    { 0x8869, 0xB29D }, // HANGUL SYLLABLE NIEUN EU RIEULTHIEUTH
    { 0x886A, 0xB29E }, // HANGUL SYLLABLE NIEUN EU RIEULPHIEUPH
    { 0x886B, 0xB29F }, // HANGUL SYLLABLE NIEUN EU RIEULHIEUH
    { 0x886C, 0xB2A2 }, // HANGUL SYLLABLE NIEUN EU PIEUPSIOS
    { 0x886D, 0xB2A4 }, // HANGUL SYLLABLE NIEUN EU SSANGSIOS
    { 0x886E, 0xB2A7 }, // HANGUL SYLLABLE NIEUN EU CHIEUCH
    { 0x886F, 0xB2A8 }, // HANGUL SYLLABLE NIEUN EU KHIEUKH
    { 0x8870, 0xB2A9 }, // HANGUL SYLLABLE NIEUN EU THIEUTH
    { 0x8871, 0xB2AB }, // HANGUL SYLLABLE NIEUN EU HIEUH
    { 0x8872, 0xB2AD }, // HANGUL SYLLABLE NIEUN YI KIYEOK
    { 0x8873, 0xB2AE }, // HANGUL SYLLABLE NIEUN YI SSANGKIYEOK
    { 0x8874, 0xB2AF }, // HANGUL SYLLABLE NIEUN YI KIYEOKSIOS
    { 0x8875, 0xB2B1 }, // HANGUL SYLLABLE NIEUN YI NIEUNCIEUC
    { 0x8876, 0xB2B2 }, // HANGUL SYLLABLE NIEUN YI NIEUNHIEUH
    { 0x8877, 0xB2B3 }, // HANGUL SYLLABLE NIEUN YI TIKEUT
    { 0x8878, 0xB2B5 }, // HANGUL SYLLABLE NIEUN YI RIEULKIYEOK
    { 0x8879, 0xB2B6 }, // HANGUL SYLLABLE NIEUN YI RIEULMIEUM
    { 0x887A, 0xB2B7 }, // HANGUL SYLLABLE NIEUN YI RIEULPIEUP
    { 0x8881, 0xB2B8 }, // HANGUL SYLLABLE NIEUN YI RIEULSIOS
    { 0x8882, 0xB2B9 }, // HANGUL SYLLABLE NIEUN YI RIEULTHIEUTH
    { 0x8883, 0xB2BA }, // HANGUL SYLLABLE NIEUN YI RIEULPHIEUPH
    { 0x8884, 0xB2BB }, // HANGUL SYLLABLE NIEUN YI RIEULHIEUH
    { 0x8885, 0xB2BC }, // HANGUL SYLLABLE NIEUN YI MIEUM
    { 0x8886, 0xB2BD }, // HANGUL SYLLABLE NIEUN YI PIEUP
    { 0x8887, 0xB2BE }, // HANGUL SYLLABLE NIEUN YI PIEUPSIOS
    { 0x8888, 0xB2BF }, // HANGUL SYLLABLE NIEUN YI SIOS
    { 0x8889, 0xB2C0 }, // HANGUL SYLLABLE NIEUN YI SSANGSIOS
    { 0x888A, 0xB2C1 }, // HANGUL SYLLABLE NIEUN YI IEUNG
    { 0x888B, 0xB2C2 }, // HANGUL SYLLABLE NIEUN YI CIEUC
    { 0x888C, 0xB2C3 }, // HANGUL SYLLABLE NIEUN YI CHIEUCH
    { 0x888D, 0xB2C4 }, // HANGUL SYLLABLE NIEUN YI KHIEUKH
    { 0x888E, 0xB2C5 }, // HANGUL SYLLABLE NIEUN YI THIEUTH
    { 0x888F, 0xB2C6 }, // HANGUL SYLLABLE NIEUN YI PHIEUPH
    { 0x8890, 0xB2C7 }, // HANGUL SYLLABLE NIEUN YI HIEUH
    { 0x8891, 0xB2CA }, // HANGUL SYLLABLE NIEUN I SSANGKIYEOK
    { 0x8892, 0xB2CB }, // HANGUL SYLLABLE NIEUN I KIYEOKSIOS
    { 0x8893, 0xB2CD }, // HANGUL SYLLABLE NIEUN I NIEUNCIEUC
    { 0x8894, 0xB2CE }, // HANGUL SYLLABLE NIEUN I NIEUNHIEUH
    { 0x8895, 0xB2CF }, // HANGUL SYLLABLE NIEUN I TIKEUT
    { 0x8896, 0xB2D1 }, // HANGUL SYLLABLE NIEUN I RIEULKIYEOK
    { 0x8897, 0xB2D3 }, // HANGUL SYLLABLE NIEUN I RIEULPIEUP
    { 0x8898, 0xB2D4 }, // HANGUL SYLLABLE NIEUN I RIEULSIOS
    { 0x8899, 0xB2D5 }, // HANGUL SYLLABLE NIEUN I RIEULTHIEUTH
    { 0x889A, 0xB2D6 }, // HANGUL SYLLABLE NIEUN I RIEULPHIEUPH
    { 0x889B, 0xB2D7 }, // HANGUL SYLLABLE NIEUN I RIEULHIEUH
    { 0x889C, 0xB2DA }, // HANGUL SYLLABLE NIEUN I PIEUPSIOS
    { 0x889D, 0xB2DC }, // HANGUL SYLLABLE NIEUN I SSANGSIOS
    { 0x889E, 0xB2DE }, // HANGUL SYLLABLE NIEUN I CIEUC
    { 0x889F, 0xB2DF }, // HANGUL SYLLABLE NIEUN I CHIEUCH
    { 0x88A0, 0xB2E0 }, // HANGUL SYLLABLE NIEUN I KHIEUKH
    { 0x88A1, 0xB2E1 }, // HANGUL SYLLABLE NIEUN I THIEUTH
    { 0x88A2, 0xB2E3 }, // HANGUL SYLLABLE NIEUN I HIEUH
    { 0x88A3, 0xB2E7 }, // HANGUL SYLLABLE TIKEUT A KIYEOKSIOS
    { 0x88A4, 0xB2E9 }, // HANGUL SYLLABLE TIKEUT A NIEUNCIEUC
    { 0x88A5, 0xB2EA }, // HANGUL SYLLABLE TIKEUT A NIEUNHIEUH
    { 0x88A6, 0xB2F0 }, // HANGUL SYLLABLE TIKEUT A RIEULSIOS
    { 0x88A7, 0xB2F1 }, // HANGUL SYLLABLE TIKEUT A RIEULTHIEUTH
    { 0x88A8, 0xB2F2 }, // HANGUL SYLLABLE TIKEUT A RIEULPHIEUPH
    { 0x88A9, 0xB2F6 }, // HANGUL SYLLABLE TIKEUT A PIEUPSIOS
    { 0x88AA, 0xB2FC }, // HANGUL SYLLABLE TIKEUT A KHIEUKH
    { 0x88AB, 0xB2FD }, // HANGUL SYLLABLE TIKEUT A THIEUTH
    { 0x88AC, 0xB2FE }, // HANGUL SYLLABLE TIKEUT A PHIEUPH
    { 0x88AD, 0xB302 }, // HANGUL SYLLABLE TIKEUT AE SSANGKIYEOK
    { 0x88AE, 0xB303 }, // HANGUL SYLLABLE TIKEUT AE KIYEOKSIOS
    { 0x88AF, 0xB305 }, // HANGUL SYLLABLE TIKEUT AE NIEUNCIEUC
    { 0x88B0, 0xB306 }, // HANGUL SYLLABLE TIKEUT AE NIEUNHIEUH
    { 0x88B1, 0xB307 }, // HANGUL SYLLABLE TIKEUT AE TIKEUT
    { 0x88B2, 0xB309 }, // HANGUL SYLLABLE TIKEUT AE RIEULKIYEOK
    { 0x88B3, 0xB30A }, // HANGUL SYLLABLE TIKEUT AE RIEULMIEUM
    { 0x88B4, 0xB30B }, // HANGUL SYLLABLE TIKEUT AE RIEULPIEUP
    { 0x88B5, 0xB30C }, // HANGUL SYLLABLE TIKEUT AE RIEULSIOS
    { 0x88B6, 0xB30D }, // HANGUL SYLLABLE TIKEUT AE RIEULTHIEUTH
    { 0x88B7, 0xB30E }, // HANGUL SYLLABLE TIKEUT AE RIEULPHIEUPH
    { 0x88B8, 0xB30F }, // HANGUL SYLLABLE TIKEUT AE RIEULHIEUH
    { 0x88B9, 0xB312 }, // HANGUL SYLLABLE TIKEUT AE PIEUPSIOS
    { 0x88BA, 0xB316 }, // HANGUL SYLLABLE TIKEUT AE CIEUC
    { 0x88BB, 0xB317 }, // HANGUL SYLLABLE TIKEUT AE CHIEUCH
    { 0x88BC, 0xB318 }, // HANGUL SYLLABLE TIKEUT AE KHIEUKH
    { 0x88BD, 0xB319 }, // HANGUL SYLLABLE TIKEUT AE THIEUTH
    { 0x88BE, 0xB31A }, // HANGUL SYLLABLE TIKEUT AE PHIEUPH
    { 0x88BF, 0xB31B }, // HANGUL SYLLABLE TIKEUT AE HIEUH
    { 0x88C0, 0xB31D }, // HANGUL SYLLABLE TIKEUT YA KIYEOK
    { 0x88C1, 0xB31E }, // HANGUL SYLLABLE TIKEUT YA SSANGKIYEOK
    { 0x88C2, 0xB31F }, // HANGUL SYLLABLE TIKEUT YA KIYEOKSIOS
    { 0x88C3, 0xB320 }, // HANGUL SYLLABLE TIKEUT YA NIEUN
    { 0x88C4, 0xB321 }, // HANGUL SYLLABLE TIKEUT YA NIEUNCIEUC
    { 0x88C5, 0xB322 }, // HANGUL SYLLABLE TIKEUT YA NIEUNHIEUH
    { 0x88C6, 0xB323 }, // HANGUL SYLLABLE TIKEUT YA TIKEUT
    { 0x88C7, 0xB324 }, // HANGUL SYLLABLE TIKEUT YA RIEUL
    { 0x88C8, 0xB325 }, // HANGUL SYLLABLE TIKEUT YA RIEULKIYEOK
    { 0x88C9, 0xB326 }, // HANGUL SYLLABLE TIKEUT YA RIEULMIEUM
    { 0x88CA, 0xB327 }, // HANGUL SYLLABLE TIKEUT YA RIEULPIEUP
    { 0x88CB, 0xB328 }, // HANGUL SYLLABLE TIKEUT YA RIEULSIOS
    { 0x88CC, 0xB329 }, // HANGUL SYLLABLE TIKEUT YA RIEULTHIEUTH
    { 0x88CD, 0xB32A }, // HANGUL SYLLABLE TIKEUT YA RIEULPHIEUPH
    { 0x88CE, 0xB32B }, // HANGUL SYLLABLE TIKEUT YA RIEULHIEUH
    { 0x88CF, 0xB32C }, // HANGUL SYLLABLE TIKEUT YA MIEUM
    { 0x88D0, 0xB32D }, // HANGUL SYLLABLE TIKEUT YA PIEUP
    { 0x88D1, 0xB32E }, // HANGUL SYLLABLE TIKEUT YA PIEUPSIOS
    { 0x88D2, 0xB32F }, // HANGUL SYLLABLE TIKEUT YA SIOS
    { 0x88D3, 0xB330 }, // HANGUL SYLLABLE TIKEUT YA SSANGSIOS
    { 0x88D4, 0xB331 }, // HANGUL SYLLABLE TIKEUT YA IEUNG
    { 0x88D5, 0xB332 }, // HANGUL SYLLABLE TIKEUT YA CIEUC
    { 0x88D6, 0xB333 }, // HANGUL SYLLABLE TIKEUT YA CHIEUCH
    { 0x88D7, 0xB334 }, // HANGUL SYLLABLE TIKEUT YA KHIEUKH
    { 0x88D8, 0xB335 }, // HANGUL SYLLABLE TIKEUT YA THIEUTH
    { 0x88D9, 0xB336 }, // HANGUL SYLLABLE TIKEUT YA PHIEUPH
    { 0x88DA, 0xB337 }, // HANGUL SYLLABLE TIKEUT YA HIEUH
    { 0x88DB, 0xB338 }, // HANGUL SYLLABLE TIKEUT YAE
    { 0x88DC, 0xB339 }, // HANGUL SYLLABLE TIKEUT YAE KIYEOK
    { 0x88DD, 0xB33A }, // HANGUL SYLLABLE TIKEUT YAE SSANGKIYEOK
    { 0x88DE, 0xB33B }, // HANGUL SYLLABLE TIKEUT YAE KIYEOKSIOS
    { 0x88DF, 0xB33C }, // HANGUL SYLLABLE TIKEUT YAE NIEUN
    { 0x88E0, 0xB33D }, // HANGUL SYLLABLE TIKEUT YAE NIEUNCIEUC
    { 0x88E1, 0xB33E }, // HANGUL SYLLABLE TIKEUT YAE NIEUNHIEUH
    { 0x88E2, 0xB33F }, // HANGUL SYLLABLE TIKEUT YAE TIKEUT
    { 0x88E3, 0xB340 }, // HANGUL SYLLABLE TIKEUT YAE RIEUL
    { 0x88E4, 0xB341 }, // HANGUL SYLLABLE TIKEUT YAE RIEULKIYEOK
    { 0x88E5, 0xB342 }, // HANGUL SYLLABLE TIKEUT YAE RIEULMIEUM
    { 0x88E6, 0xB343 }, // HANGUL SYLLABLE TIKEUT YAE RIEULPIEUP
    { 0x88E7, 0xB344 }, // HANGUL SYLLABLE TIKEUT YAE RIEULSIOS
    { 0x88E8, 0xB345 }, // HANGUL SYLLABLE TIKEUT YAE RIEULTHIEUTH
    { 0x88E9, 0xB346 }, // HANGUL SYLLABLE TIKEUT YAE RIEULPHIEUPH
    { 0x88EA, 0xB347 }, // HANGUL SYLLABLE TIKEUT YAE RIEULHIEUH
    { 0x88EB, 0xB348 }, // HANGUL SYLLABLE TIKEUT YAE MIEUM
    { 0x88EC, 0xB349 }, // HANGUL SYLLABLE TIKEUT YAE PIEUP
    { 0x88ED, 0xB34A }, // HANGUL SYLLABLE TIKEUT YAE PIEUPSIOS
    { 0x88EE, 0xB34B }, // HANGUL SYLLABLE TIKEUT YAE SIOS
    { 0x88EF, 0xB34C }, // HANGUL SYLLABLE TIKEUT YAE SSANGSIOS
    { 0x88F0, 0xB34D }, // HANGUL SYLLABLE TIKEUT YAE IEUNG
    { 0x88F1, 0xB34E }, // HANGUL SYLLABLE TIKEUT YAE CIEUC
    { 0x88F2, 0xB34F }, // HANGUL SYLLABLE TIKEUT YAE CHIEUCH
    { 0x88F3, 0xB350 }, // HANGUL SYLLABLE TIKEUT YAE KHIEUKH
    { 0x88F4, 0xB351 }, // HANGUL SYLLABLE TIKEUT YAE THIEUTH
    { 0x88F5, 0xB352 }, // HANGUL SYLLABLE TIKEUT YAE PHIEUPH
    { 0x88F6, 0xB353 }, // HANGUL SYLLABLE TIKEUT YAE HIEUH
    { 0x88F7, 0xB357 }, // HANGUL SYLLABLE TIKEUT EO KIYEOKSIOS
    { 0x88F8, 0xB359 }, // HANGUL SYLLABLE TIKEUT EO NIEUNCIEUC
    { 0x88F9, 0xB35A }, // HANGUL SYLLABLE TIKEUT EO NIEUNHIEUH
    { 0x88FA, 0xB35D }, // HANGUL SYLLABLE TIKEUT EO RIEULKIYEOK
    { 0x88FB, 0xB360 }, // HANGUL SYLLABLE TIKEUT EO RIEULSIOS
    { 0x88FC, 0xB361 }, // HANGUL SYLLABLE TIKEUT EO RIEULTHIEUTH
    { 0x88FD, 0xB362 }, // HANGUL SYLLABLE TIKEUT EO RIEULPHIEUPH
    { 0x88FE, 0xB363 }, // HANGUL SYLLABLE TIKEUT EO RIEULHIEUH
    { 0x8941, 0xB366 }, // HANGUL SYLLABLE TIKEUT EO PIEUPSIOS
    { 0x8942, 0xB368 }, // HANGUL SYLLABLE TIKEUT EO SSANGSIOS
    { 0x8943, 0xB36A }, // HANGUL SYLLABLE TIKEUT EO CIEUC
    { 0x8944, 0xB36C }, // HANGUL SYLLABLE TIKEUT EO KHIEUKH
    { 0x8945, 0xB36D }, // HANGUL SYLLABLE TIKEUT EO THIEUTH
    { 0x8946, 0xB36F }, // HANGUL SYLLABLE TIKEUT EO HIEUH
    { 0x8947, 0xB372 }, // HANGUL SYLLABLE TIKEUT E SSANGKIYEOK
    { 0x8948, 0xB373 }, // HANGUL SYLLABLE TIKEUT E KIYEOKSIOS
    { 0x8949, 0xB375 }, // HANGUL SYLLABLE TIKEUT E NIEUNCIEUC
    { 0x894A, 0xB376 }, // HANGUL SYLLABLE TIKEUT E NIEUNHIEUH
    { 0x894B, 0xB377 }, // HANGUL SYLLABLE TIKEUT E TIKEUT
    { 0x894C, 0xB379 }, // HANGUL SYLLABLE TIKEUT E RIEULKIYEOK
    { 0x894D, 0xB37A }, // HANGUL SYLLABLE TIKEUT E RIEULMIEUM
    { 0x894E, 0xB37B }, // HANGUL SYLLABLE TIKEUT E RIEULPIEUP
    { 0x894F, 0xB37C }, // HANGUL SYLLABLE TIKEUT E RIEULSIOS
    { 0x8950, 0xB37D }, // HANGUL SYLLABLE TIKEUT E RIEULTHIEUTH
    { 0x8951, 0xB37E }, // HANGUL SYLLABLE TIKEUT E RIEULPHIEUPH
    { 0x8952, 0xB37F }, // HANGUL SYLLABLE TIKEUT E RIEULHIEUH
    { 0x8953, 0xB382 }, // HANGUL SYLLABLE TIKEUT E PIEUPSIOS
    { 0x8954, 0xB386 }, // HANGUL SYLLABLE TIKEUT E CIEUC
    { 0x8955, 0xB387 }, // HANGUL SYLLABLE TIKEUT E CHIEUCH
    { 0x8956, 0xB388 }, // HANGUL SYLLABLE TIKEUT E KHIEUKH
    { 0x8957, 0xB389 }, // HANGUL SYLLABLE TIKEUT E THIEUTH
    { 0x8958, 0xB38A }, // HANGUL SYLLABLE TIKEUT E PHIEUPH
    { 0x8959, 0xB38B }, // HANGUL SYLLABLE TIKEUT E HIEUH
    { 0x895A, 0xB38D }, // HANGUL SYLLABLE TIKEUT YEO KIYEOK
    { 0x8961, 0xB38E }, // HANGUL SYLLABLE TIKEUT YEO SSANGKIYEOK
    { 0x8962, 0xB38F }, // HANGUL SYLLABLE TIKEUT YEO KIYEOKSIOS
    { 0x8963, 0xB391 }, // HANGUL SYLLABLE TIKEUT YEO NIEUNCIEUC
    { 0x8964, 0xB392 }, // HANGUL SYLLABLE TIKEUT YEO NIEUNHIEUH
    { 0x8965, 0xB393 }, // HANGUL SYLLABLE TIKEUT YEO TIKEUT
    { 0x8966, 0xB395 }, // HANGUL SYLLABLE TIKEUT YEO RIEULKIYEOK
    { 0x8967, 0xB396 }, // HANGUL SYLLABLE TIKEUT YEO RIEULMIEUM
    { 0x8968, 0xB397 }, // HANGUL SYLLABLE TIKEUT YEO RIEULPIEUP
    { 0x8969, 0xB398 }, // HANGUL SYLLABLE TIKEUT YEO RIEULSIOS
    { 0x896A, 0xB399 }, // HANGUL SYLLABLE TIKEUT YEO RIEULTHIEUTH
    { 0x896B, 0xB39A }, // HANGUL SYLLABLE TIKEUT YEO RIEULPHIEUPH
    { 0x896C, 0xB39B }, // HANGUL SYLLABLE TIKEUT YEO RIEULHIEUH
    { 0x896D, 0xB39C }, // HANGUL SYLLABLE TIKEUT YEO MIEUM
    { 0x896E, 0xB39D }, // HANGUL SYLLABLE TIKEUT YEO PIEUP
    { 0x896F, 0xB39E }, // HANGUL SYLLABLE TIKEUT YEO PIEUPSIOS
    { 0x8970, 0xB39F }, // HANGUL SYLLABLE TIKEUT YEO SIOS
    { 0x8971, 0xB3A2 }, // HANGUL SYLLABLE TIKEUT YEO CIEUC
    { 0x8972, 0xB3A3 }, // HANGUL SYLLABLE TIKEUT YEO CHIEUCH
    { 0x8973, 0xB3A4 }, // HANGUL SYLLABLE TIKEUT YEO KHIEUKH
    { 0x8974, 0xB3A5 }, // HANGUL SYLLABLE TIKEUT YEO THIEUTH
    { 0x8975, 0xB3A6 }, // HANGUL SYLLABLE TIKEUT YEO PHIEUPH
    { 0x8976, 0xB3A7 }, // HANGUL SYLLABLE TIKEUT YEO HIEUH
    { 0x8977, 0xB3A9 }, // HANGUL SYLLABLE TIKEUT YE KIYEOK
    { 0x8978, 0xB3AA }, // HANGUL SYLLABLE TIKEUT YE SSANGKIYEOK
    { 0x8979, 0xB3AB }, // HANGUL SYLLABLE TIKEUT YE KIYEOKSIOS
    { 0x897A, 0xB3AD }, // HANGUL SYLLABLE TIKEUT YE NIEUNCIEUC
    { 0x8981, 0xB3AE }, // HANGUL SYLLABLE TIKEUT YE NIEUNHIEUH
    { 0x8982, 0xB3AF }, // HANGUL SYLLABLE TIKEUT YE TIKEUT
    { 0x8983, 0xB3B0 }, // HANGUL SYLLABLE TIKEUT YE RIEUL
    { 0x8984, 0xB3B1 }, // HANGUL SYLLABLE TIKEUT YE RIEULKIYEOK
    { 0x8985, 0xB3B2 }, // HANGUL SYLLABLE TIKEUT YE RIEULMIEUM
    { 0x8986, 0xB3B3 }, // HANGUL SYLLABLE TIKEUT YE RIEULPIEUP
    { 0x8987, 0xB3B4 }, // HANGUL SYLLABLE TIKEUT YE RIEULSIOS
    { 0x8988, 0xB3B5 }, // HANGUL SYLLABLE TIKEUT YE RIEULTHIEUTH
    { 0x8989, 0xB3B6 }, // HANGUL SYLLABLE TIKEUT YE RIEULPHIEUPH
    { 0x898A, 0xB3B7 }, // HANGUL SYLLABLE TIKEUT YE RIEULHIEUH
    { 0x898B, 0xB3B8 }, // HANGUL SYLLABLE TIKEUT YE MIEUM
    { 0x898C, 0xB3B9 }, // HANGUL SYLLABLE TIKEUT YE PIEUP
    { 0x898D, 0xB3BA }, // HANGUL SYLLABLE TIKEUT YE PIEUPSIOS
    { 0x898E, 0xB3BB }, // HANGUL SYLLABLE TIKEUT YE SIOS
    { 0x898F, 0xB3BC }, // HANGUL SYLLABLE TIKEUT YE SSANGSIOS
    { 0x8990, 0xB3BD }, // HANGUL SYLLABLE TIKEUT YE IEUNG
    { 0x8991, 0xB3BE }, // HANGUL SYLLABLE TIKEUT YE CIEUC
    { 0x8992, 0xB3BF }, // HANGUL SYLLABLE TIKEUT YE CHIEUCH
    { 0x8993, 0xB3C0 }, // HANGUL SYLLABLE TIKEUT YE KHIEUKH
    { 0x8994, 0xB3C1 }, // HANGUL SYLLABLE TIKEUT YE THIEUTH
    { 0x8995, 0xB3C2 }, // HANGUL SYLLABLE TIKEUT YE PHIEUPH
    { 0x8996, 0xB3C3 }, // HANGUL SYLLABLE TIKEUT YE HIEUH
    { 0x8997, 0xB3C6 }, // HANGUL SYLLABLE TIKEUT O SSANGKIYEOK
    { 0x8998, 0xB3C7 }, // HANGUL SYLLABLE TIKEUT O KIYEOKSIOS
    { 0x8999, 0xB3C9 }, // HANGUL SYLLABLE TIKEUT O NIEUNCIEUC
    { 0x899A, 0xB3CA }, // HANGUL SYLLABLE TIKEUT O NIEUNHIEUH
    { 0x899B, 0xB3CD }, // HANGUL SYLLABLE TIKEUT O RIEULKIYEOK
    { 0x899C, 0xB3CF }, // HANGUL SYLLABLE TIKEUT O RIEULPIEUP
    { 0x899D, 0xB3D1 }, // HANGUL SYLLABLE TIKEUT O RIEULTHIEUTH
    { 0x899E, 0xB3D2 }, // HANGUL SYLLABLE TIKEUT O RIEULPHIEUPH
    { 0x899F, 0xB3D3 }, // HANGUL SYLLABLE TIKEUT O RIEULHIEUH
    { 0x89A0, 0xB3D6 }, // HANGUL SYLLABLE TIKEUT O PIEUPSIOS
    { 0x89A1, 0xB3D8 }, // HANGUL SYLLABLE TIKEUT O SSANGSIOS
    { 0x89A2, 0xB3DA }, // HANGUL SYLLABLE TIKEUT O CIEUC
    { 0x89A3, 0xB3DC }, // HANGUL SYLLABLE TIKEUT O KHIEUKH
    { 0x89A4, 0xB3DE }, // HANGUL SYLLABLE TIKEUT O PHIEUPH
    { 0x89A5, 0xB3DF }, // HANGUL SYLLABLE TIKEUT O HIEUH
    { 0x89A6, 0xB3E1 }, // HANGUL SYLLABLE TIKEUT WA KIYEOK
    { 0x89A7, 0xB3E2 }, // HANGUL SYLLABLE TIKEUT WA SSANGKIYEOK
    { 0x89A8, 0xB3E3 }, // HANGUL SYLLABLE TIKEUT WA KIYEOKSIOS
    { 0x89A9, 0xB3E5 }, // HANGUL SYLLABLE TIKEUT WA NIEUNCIEUC
    { 0x89AA, 0xB3E6 }, // HANGUL SYLLABLE TIKEUT WA NIEUNHIEUH
    { 0x89AB, 0xB3E7 }, // HANGUL SYLLABLE TIKEUT WA TIKEUT
    { 0x89AC, 0xB3E9 }, // HANGUL SYLLABLE TIKEUT WA RIEULKIYEOK
    { 0x89AD, 0xB3EA }, // HANGUL SYLLABLE TIKEUT WA RIEULMIEUM
    { 0x89AE, 0xB3EB }, // HANGUL SYLLABLE TIKEUT WA RIEULPIEUP
    { 0x89AF, 0xB3EC }, // HANGUL SYLLABLE TIKEUT WA RIEULSIOS
    { 0x89B0, 0xB3ED }, // HANGUL SYLLABLE TIKEUT WA RIEULTHIEUTH
    { 0x89B1, 0xB3EE }, // HANGUL SYLLABLE TIKEUT WA RIEULPHIEUPH
    { 0x89B2, 0xB3EF }, // HANGUL SYLLABLE TIKEUT WA RIEULHIEUH
    { 0x89B3, 0xB3F0 }, // HANGUL SYLLABLE TIKEUT WA MIEUM
    { 0x89B4, 0xB3F1 }, // HANGUL SYLLABLE TIKEUT WA PIEUP
    { 0x89B5, 0xB3F2 }, // HANGUL SYLLABLE TIKEUT WA PIEUPSIOS
    { 0x89B6, 0xB3F3 }, // HANGUL SYLLABLE TIKEUT WA SIOS
    { 0x89B7, 0xB3F4 }, // HANGUL SYLLABLE TIKEUT WA SSANGSIOS
    { 0x89B8, 0xB3F5 }, // HANGUL SYLLABLE TIKEUT WA IEUNG
    { 0x89B9, 0xB3F6 }, // HANGUL SYLLABLE TIKEUT WA CIEUC
    { 0x89BA, 0xB3F7 }, // HANGUL SYLLABLE TIKEUT WA CHIEUCH
    { 0x89BB, 0xB3F8 }, // HANGUL SYLLABLE TIKEUT WA KHIEUKH
    { 0x89BC, 0xB3F9 }, // HANGUL SYLLABLE TIKEUT WA THIEUTH
    { 0x89BD, 0xB3FA }, // HANGUL SYLLABLE TIKEUT WA PHIEUPH
    { 0x89BE, 0xB3FB }, // HANGUL SYLLABLE TIKEUT WA HIEUH
    { 0x89BF, 0xB3FD }, // HANGUL SYLLABLE TIKEUT WAE KIYEOK
    { 0x89C0, 0xB3FE }, // HANGUL SYLLABLE TIKEUT WAE SSANGKIYEOK
    { 0x89C1, 0xB3FF }, // HANGUL SYLLABLE TIKEUT WAE KIYEOKSIOS
    { 0x89C2, 0xB400 }, // HANGUL SYLLABLE TIKEUT WAE NIEUN
    { 0x89C3, 0xB401 }, // HANGUL SYLLABLE TIKEUT WAE NIEUNCIEUC
    { 0x89C4, 0xB402 }, // HANGUL SYLLABLE TIKEUT WAE NIEUNHIEUH
    { 0x89C5, 0xB403 }, // HANGUL SYLLABLE TIKEUT WAE TIKEUT
    { 0x89C6, 0xB404 }, // HANGUL SYLLABLE TIKEUT WAE RIEUL
    { 0x89C7, 0xB405 }, // HANGUL SYLLABLE TIKEUT WAE RIEULKIYEOK
    { 0x89C8, 0xB406 }, // HANGUL SYLLABLE TIKEUT WAE RIEULMIEUM
    { 0x89C9, 0xB407 }, // HANGUL SYLLABLE TIKEUT WAE RIEULPIEUP
    { 0x89CA, 0xB408 }, // HANGUL SYLLABLE TIKEUT WAE RIEULSIOS
    { 0x89CB, 0xB409 }, // HANGUL SYLLABLE TIKEUT WAE RIEULTHIEUTH
    { 0x89CC, 0xB40A }, // HANGUL SYLLABLE TIKEUT WAE RIEULPHIEUPH
    { 0x89CD, 0xB40B }, // HANGUL SYLLABLE TIKEUT WAE RIEULHIEUH
    { 0x89CE, 0xB40C }, // HANGUL SYLLABLE TIKEUT WAE MIEUM
    { 0x89CF, 0xB40D }, // HANGUL SYLLABLE TIKEUT WAE PIEUP
    { 0x89D0, 0xB40E }, // HANGUL SYLLABLE TIKEUT WAE PIEUPSIOS
    { 0x89D1, 0xB40F }, // HANGUL SYLLABLE TIKEUT WAE SIOS
    { 0x89D2, 0xB411 }, // HANGUL SYLLABLE TIKEUT WAE IEUNG
    { 0x89D3, 0xB412 }, // HANGUL SYLLABLE TIKEUT WAE CIEUC
    { 0x89D4, 0xB413 }, // HANGUL SYLLABLE TIKEUT WAE CHIEUCH
    { 0x89D5, 0xB414 }, // HANGUL SYLLABLE TIKEUT WAE KHIEUKH
    { 0x89D6, 0xB415 }, // HANGUL SYLLABLE TIKEUT WAE THIEUTH
    { 0x89D7, 0xB416 }, // HANGUL SYLLABLE TIKEUT WAE PHIEUPH
    { 0x89D8, 0xB417 }, // HANGUL SYLLABLE TIKEUT WAE HIEUH
    { 0x89D9, 0xB419 }, // HANGUL SYLLABLE TIKEUT OE KIYEOK
    { 0x89DA, 0xB41A }, // HANGUL SYLLABLE TIKEUT OE SSANGKIYEOK
    { 0x89DB, 0xB41B }, // HANGUL SYLLABLE TIKEUT OE KIYEOKSIOS
    { 0x89DC, 0xB41D }, // HANGUL SYLLABLE TIKEUT OE NIEUNCIEUC
    { 0x89DD, 0xB41E }, // HANGUL SYLLABLE TIKEUT OE NIEUNHIEUH
    { 0x89DE, 0xB41F }, // HANGUL SYLLABLE TIKEUT OE TIKEUT
    { 0x89DF, 0xB421 }, // HANGUL SYLLABLE TIKEUT OE RIEULKIYEOK
    { 0x89E0, 0xB422 }, // HANGUL SYLLABLE TIKEUT OE RIEULMIEUM
    { 0x89E1, 0xB423 }, // HANGUL SYLLABLE TIKEUT OE RIEULPIEUP
    { 0x89E2, 0xB424 }, // HANGUL SYLLABLE TIKEUT OE RIEULSIOS
    { 0x89E3, 0xB425 }, // HANGUL SYLLABLE TIKEUT OE RIEULTHIEUTH
    { 0x89E4, 0xB426 }, // HANGUL SYLLABLE TIKEUT OE RIEULPHIEUPH
    { 0x89E5, 0xB427 }, // HANGUL SYLLABLE TIKEUT OE RIEULHIEUH
    { 0x89E6, 0xB42A }, // HANGUL SYLLABLE TIKEUT OE PIEUPSIOS
    { 0x89E7, 0xB42C }, // HANGUL SYLLABLE TIKEUT OE SSANGSIOS
    { 0x89E8, 0xB42D }, // HANGUL SYLLABLE TIKEUT OE IEUNG
    { 0x89E9, 0xB42E }, // HANGUL SYLLABLE TIKEUT OE CIEUC
    { 0x89EA, 0xB42F }, // HANGUL SYLLABLE TIKEUT OE CHIEUCH
    { 0x89EB, 0xB430 }, // HANGUL SYLLABLE TIKEUT OE KHIEUKH
    { 0x89EC, 0xB431 }, // HANGUL SYLLABLE TIKEUT OE THIEUTH
    { 0x89ED, 0xB432 }, // HANGUL SYLLABLE TIKEUT OE PHIEUPH
    { 0x89EE, 0xB433 }, // HANGUL SYLLABLE TIKEUT OE HIEUH
    { 0x89EF, 0xB435 }, // HANGUL SYLLABLE TIKEUT YO KIYEOK
    { 0x89F0, 0xB436 }, // HANGUL SYLLABLE TIKEUT YO SSANGKIYEOK
    { 0x89F1, 0xB437 }, // HANGUL SYLLABLE TIKEUT YO KIYEOKSIOS
    { 0x89F2, 0xB438 }, // HANGUL SYLLABLE TIKEUT YO NIEUN
    { 0x89F3, 0xB439 }, // HANGUL SYLLABLE TIKEUT YO NIEUNCIEUC
    { 0x89F4, 0xB43A }, // HANGUL SYLLABLE TIKEUT YO NIEUNHIEUH
    { 0x89F5, 0xB43B }, // HANGUL SYLLABLE TIKEUT YO TIKEUT
    { 0x89F6, 0xB43C }, // HANGUL SYLLABLE TIKEUT YO RIEUL
    { 0x89F7, 0xB43D }, // HANGUL SYLLABLE TIKEUT YO RIEULKIYEOK
    { 0x89F8, 0xB43E }, // HANGUL SYLLABLE TIKEUT YO RIEULMIEUM
    { 0x89F9, 0xB43F }, // HANGUL SYLLABLE TIKEUT YO RIEULPIEUP
    { 0x89FA, 0xB440 }, // HANGUL SYLLABLE TIKEUT YO RIEULSIOS
    { 0x89FB, 0xB441 }, // HANGUL SYLLABLE TIKEUT YO RIEULTHIEUTH
    { 0x89FC, 0xB442 }, // HANGUL SYLLABLE TIKEUT YO RIEULPHIEUPH
    { 0x89FD, 0xB443 }, // HANGUL SYLLABLE TIKEUT YO RIEULHIEUH
    { 0x89FE, 0xB444 }, // HANGUL SYLLABLE TIKEUT YO MIEUM
    { 0x8A41, 0xB445 }, // HANGUL SYLLABLE TIKEUT YO PIEUP
    { 0x8A42, 0xB446 }, // HANGUL SYLLABLE TIKEUT YO PIEUPSIOS
    { 0x8A43, 0xB447 }, // HANGUL SYLLABLE TIKEUT YO SIOS
    { 0x8A44, 0xB448 }, // HANGUL SYLLABLE TIKEUT YO SSANGSIOS
    { 0x8A45, 0xB449 }, // HANGUL SYLLABLE TIKEUT YO IEUNG
    { 0x8A46, 0xB44A }, // HANGUL SYLLABLE TIKEUT YO CIEUC
    { 0x8A47, 0xB44B }, // HANGUL SYLLABLE TIKEUT YO CHIEUCH
    { 0x8A48, 0xB44C }, // HANGUL SYLLABLE TIKEUT YO KHIEUKH
    { 0x8A49, 0xB44D }, // HANGUL SYLLABLE TIKEUT YO THIEUTH
    { 0x8A4A, 0xB44E }, // HANGUL SYLLABLE TIKEUT YO PHIEUPH
    { 0x8A4B, 0xB44F }, // HANGUL SYLLABLE TIKEUT YO HIEUH
    { 0x8A4C, 0xB452 }, // HANGUL SYLLABLE TIKEUT U SSANGKIYEOK
    { 0x8A4D, 0xB453 }, // HANGUL SYLLABLE TIKEUT U KIYEOKSIOS
    { 0x8A4E, 0xB455 }, // HANGUL SYLLABLE TIKEUT U NIEUNCIEUC
    { 0x8A4F, 0xB456 }, // HANGUL SYLLABLE TIKEUT U NIEUNHIEUH
    { 0x8A50, 0xB457 }, // HANGUL SYLLABLE TIKEUT U TIKEUT
    { 0x8A51, 0xB459 }, // HANGUL SYLLABLE TIKEUT U RIEULKIYEOK
    { 0x8A52, 0xB45A }, // HANGUL SYLLABLE TIKEUT U RIEULMIEUM
    { 0x8A53, 0xB45B }, // HANGUL SYLLABLE TIKEUT U RIEULPIEUP
    { 0x8A54, 0xB45C }, // HANGUL SYLLABLE TIKEUT U RIEULSIOS
    { 0x8A55, 0xB45D }, // HANGUL SYLLABLE TIKEUT U RIEULTHIEUTH
    { 0x8A56, 0xB45E }, // HANGUL SYLLABLE TIKEUT U RIEULPHIEUPH
    { 0x8A57, 0xB45F }, // HANGUL SYLLABLE TIKEUT U RIEULHIEUH
    { 0x8A58, 0xB462 }, // HANGUL SYLLABLE TIKEUT U PIEUPSIOS
    { 0x8A59, 0xB464 }, // HANGUL SYLLABLE TIKEUT U SSANGSIOS
    { 0x8A5A, 0xB466 }, // HANGUL SYLLABLE TIKEUT U CIEUC
    { 0x8A61, 0xB467 }, // HANGUL SYLLABLE TIKEUT U CHIEUCH
    { 0x8A62, 0xB468 }, // HANGUL SYLLABLE TIKEUT U KHIEUKH
    { 0x8A63, 0xB469 }, // HANGUL SYLLABLE TIKEUT U THIEUTH
    { 0x8A64, 0xB46A }, // HANGUL SYLLABLE TIKEUT U PHIEUPH
    { 0x8A65, 0xB46B }, // HANGUL SYLLABLE TIKEUT U HIEUH
    { 0x8A66, 0xB46D }, // HANGUL SYLLABLE TIKEUT WEO KIYEOK
    { 0x8A67, 0xB46E }, // HANGUL SYLLABLE TIKEUT WEO SSANGKIYEOK
    { 0x8A68, 0xB46F }, // HANGUL SYLLABLE TIKEUT WEO KIYEOKSIOS
    { 0x8A69, 0xB470 }, // HANGUL SYLLABLE TIKEUT WEO NIEUN
    { 0x8A6A, 0xB471 }, // HANGUL SYLLABLE TIKEUT WEO NIEUNCIEUC
    { 0x8A6B, 0xB472 }, // HANGUL SYLLABLE TIKEUT WEO NIEUNHIEUH
    { 0x8A6C, 0xB473 }, // HANGUL SYLLABLE TIKEUT WEO TIKEUT
    { 0x8A6D, 0xB474 }, // HANGUL SYLLABLE TIKEUT WEO RIEUL
    { 0x8A6E, 0xB475 }, // HANGUL SYLLABLE TIKEUT WEO RIEULKIYEOK
    { 0x8A6F, 0xB476 }, // HANGUL SYLLABLE TIKEUT WEO RIEULMIEUM
    { 0x8A70, 0xB477 }, // HANGUL SYLLABLE TIKEUT WEO RIEULPIEUP
    { 0x8A71, 0xB478 }, // HANGUL SYLLABLE TIKEUT WEO RIEULSIOS
    { 0x8A72, 0xB479 }, // HANGUL SYLLABLE TIKEUT WEO RIEULTHIEUTH
    { 0x8A73, 0xB47A }, // HANGUL SYLLABLE TIKEUT WEO RIEULPHIEUPH
    { 0x8A74, 0xB47B }, // HANGUL SYLLABLE TIKEUT WEO RIEULHIEUH
    { 0x8A75, 0xB47C }, // HANGUL SYLLABLE TIKEUT WEO MIEUM
    { 0x8A76, 0xB47D }, // HANGUL SYLLABLE TIKEUT WEO PIEUP
    { 0x8A77, 0xB47E }, // HANGUL SYLLABLE TIKEUT WEO PIEUPSIOS
    { 0x8A78, 0xB47F }, // HANGUL SYLLABLE TIKEUT WEO SIOS
    { 0x8A79, 0xB481 }, // HANGUL SYLLABLE TIKEUT WEO IEUNG
    { 0x8A7A, 0xB482 }, // HANGUL SYLLABLE TIKEUT WEO CIEUC
    { 0x8A81, 0xB483 }, // HANGUL SYLLABLE TIKEUT WEO CHIEUCH
    { 0x8A82, 0xB484 }, // HANGUL SYLLABLE TIKEUT WEO KHIEUKH
    { 0x8A83, 0xB485 }, // HANGUL SYLLABLE TIKEUT WEO THIEUTH
    { 0x8A84, 0xB486 }, // HANGUL SYLLABLE TIKEUT WEO PHIEUPH
    { 0x8A85, 0xB487 }, // HANGUL SYLLABLE TIKEUT WEO HIEUH
    { 0x8A86, 0xB489 }, // HANGUL SYLLABLE TIKEUT WE KIYEOK
    { 0x8A87, 0xB48A }, // HANGUL SYLLABLE TIKEUT WE SSANGKIYEOK
    { 0x8A88, 0xB48B }, // HANGUL SYLLABLE TIKEUT WE KIYEOKSIOS
    { 0x8A89, 0xB48C }, // HANGUL SYLLABLE TIKEUT WE NIEUN
    { 0x8A8A, 0xB48D }, // HANGUL SYLLABLE TIKEUT WE NIEUNCIEUC
    { 0x8A8B, 0xB48E }, // HANGUL SYLLABLE TIKEUT WE NIEUNHIEUH
    { 0x8A8C, 0xB48F }, // HANGUL SYLLABLE TIKEUT WE TIKEUT
    { 0x8A8D, 0xB490 }, // HANGUL SYLLABLE TIKEUT WE RIEUL
    { 0x8A8E, 0xB491 }, // HANGUL SYLLABLE TIKEUT WE RIEULKIYEOK
    { 0x8A8F, 0xB492 }, // HANGUL SYLLABLE TIKEUT WE RIEULMIEUM
    { 0x8A90, 0xB493 }, // HANGUL SYLLABLE TIKEUT WE RIEULPIEUP
    { 0x8A91, 0xB494 }, // HANGUL SYLLABLE TIKEUT WE RIEULSIOS
    { 0x8A92, 0xB495 }, // HANGUL SYLLABLE TIKEUT WE RIEULTHIEUTH
    { 0x8A93, 0xB496 }, // HANGUL SYLLABLE TIKEUT WE RIEULPHIEUPH
    { 0x8A94, 0xB497 }, // HANGUL SYLLABLE TIKEUT WE RIEULHIEUH
    { 0x8A95, 0xB498 }, // HANGUL SYLLABLE TIKEUT WE MIEUM
    { 0x8A96, 0xB499 }, // HANGUL SYLLABLE TIKEUT WE PIEUP
    { 0x8A97, 0xB49A }, // HANGUL SYLLABLE TIKEUT WE PIEUPSIOS
    { 0x8A98, 0xB49B }, // HANGUL SYLLABLE TIKEUT WE SIOS
    { 0x8A99, 0xB49C }, // HANGUL SYLLABLE TIKEUT WE SSANGSIOS
    { 0x8A9A, 0xB49E }, // HANGUL SYLLABLE TIKEUT WE CIEUC
    { 0x8A9B, 0xB49F }, // HANGUL SYLLABLE TIKEUT WE CHIEUCH
    { 0x8A9C, 0xB4A0 }, // HANGUL SYLLABLE TIKEUT WE KHIEUKH
    { 0x8A9D, 0xB4A1 }, // HANGUL SYLLABLE TIKEUT WE THIEUTH
    { 0x8A9E, 0xB4A2 }, // HANGUL SYLLABLE TIKEUT WE PHIEUPH
    { 0x8A9F, 0xB4A3 }, // HANGUL SYLLABLE TIKEUT WE HIEUH
    { 0x8AA0, 0xB4A5 }, // HANGUL SYLLABLE TIKEUT WI KIYEOK
    { 0x8AA1, 0xB4A6 }, // HANGUL SYLLABLE TIKEUT WI SSANGKIYEOK
    { 0x8AA2, 0xB4A7 }, // HANGUL SYLLABLE TIKEUT WI KIYEOKSIOS
    { 0x8AA3, 0xB4A9 }, // HANGUL SYLLABLE TIKEUT WI NIEUNCIEUC
    { 0x8AA4, 0xB4AA }, // HANGUL SYLLABLE TIKEUT WI NIEUNHIEUH
    { 0x8AA5, 0xB4AB }, // HANGUL SYLLABLE TIKEUT WI TIKEUT
    { 0x8AA6, 0xB4AD }, // HANGUL SYLLABLE TIKEUT WI RIEULKIYEOK
    { 0x8AA7, 0xB4AE }, // HANGUL SYLLABLE TIKEUT WI RIEULMIEUM
    { 0x8AA8, 0xB4AF }, // HANGUL SYLLABLE TIKEUT WI RIEULPIEUP
    { 0x8AA9, 0xB4B0 }, // HANGUL SYLLABLE TIKEUT WI RIEULSIOS
    { 0x8AAA, 0xB4B1 }, // HANGUL SYLLABLE TIKEUT WI RIEULTHIEUTH
    { 0x8AAB, 0xB4B2 }, // HANGUL SYLLABLE TIKEUT WI RIEULPHIEUPH
    { 0x8AAC, 0xB4B3 }, // HANGUL SYLLABLE TIKEUT WI RIEULHIEUH
    { 0x8AAD, 0xB4B4 }, // HANGUL SYLLABLE TIKEUT WI MIEUM
    { 0x8AAE, 0xB4B6 }, // HANGUL SYLLABLE TIKEUT WI PIEUPSIOS
    { 0x8AAF, 0xB4B8 }, // HANGUL SYLLABLE TIKEUT WI SSANGSIOS
    { 0x8AB0, 0xB4BA }, // HANGUL SYLLABLE TIKEUT WI CIEUC
    { 0x8AB1, 0xB4BB }, // HANGUL SYLLABLE TIKEUT WI CHIEUCH
    { 0x8AB2, 0xB4BC }, // HANGUL SYLLABLE TIKEUT WI KHIEUKH
    { 0x8AB3, 0xB4BD }, // HANGUL SYLLABLE TIKEUT WI THIEUTH
    { 0x8AB4, 0xB4BE }, // HANGUL SYLLABLE TIKEUT WI PHIEUPH
    { 0x8AB5, 0xB4BF }, // HANGUL SYLLABLE TIKEUT WI HIEUH
    { 0x8AB6, 0xB4C1 }, // HANGUL SYLLABLE TIKEUT YU KIYEOK
    { 0x8AB7, 0xB4C2 }, // HANGUL SYLLABLE TIKEUT YU SSANGKIYEOK
    { 0x8AB8, 0xB4C3 }, // HANGUL SYLLABLE TIKEUT YU KIYEOKSIOS
    { 0x8AB9, 0xB4C5 }, // HANGUL SYLLABLE TIKEUT YU NIEUNCIEUC
    { 0x8ABA, 0xB4C6 }, // HANGUL SYLLABLE TIKEUT YU NIEUNHIEUH
    { 0x8ABB, 0xB4C7 }, // HANGUL SYLLABLE TIKEUT YU TIKEUT
    { 0x8ABC, 0xB4C9 }, // HANGUL SYLLABLE TIKEUT YU RIEULKIYEOK
    { 0x8ABD, 0xB4CA }, // HANGUL SYLLABLE TIKEUT YU RIEULMIEUM
    { 0x8ABE, 0xB4CB }, // HANGUL SYLLABLE TIKEUT YU RIEULPIEUP
    { 0x8ABF, 0xB4CC }, // HANGUL SYLLABLE TIKEUT YU RIEULSIOS
    { 0x8AC0, 0xB4CD }, // HANGUL SYLLABLE TIKEUT YU RIEULTHIEUTH
    { 0x8AC1, 0xB4CE }, // HANGUL SYLLABLE TIKEUT YU RIEULPHIEUPH
    { 0x8AC2, 0xB4CF }, // HANGUL SYLLABLE TIKEUT YU RIEULHIEUH
    { 0x8AC3, 0xB4D1 }, // HANGUL SYLLABLE TIKEUT YU PIEUP
    { 0x8AC4, 0xB4D2 }, // HANGUL SYLLABLE TIKEUT YU PIEUPSIOS
    { 0x8AC5, 0xB4D3 }, // HANGUL SYLLABLE TIKEUT YU SIOS
    { 0x8AC6, 0xB4D4 }, // HANGUL SYLLABLE TIKEUT YU SSANGSIOS
    { 0x8AC7, 0xB4D6 }, // HANGUL SYLLABLE TIKEUT YU CIEUC
    { 0x8AC8, 0xB4D7 }, // HANGUL SYLLABLE TIKEUT YU CHIEUCH
    { 0x8AC9, 0xB4D8 }, // HANGUL SYLLABLE TIKEUT YU KHIEUKH
    { 0x8ACA, 0xB4D9 }, // HANGUL SYLLABLE TIKEUT YU THIEUTH
    { 0x8ACB, 0xB4DA }, // HANGUL SYLLABLE TIKEUT YU PHIEUPH
    { 0x8ACC, 0xB4DB }, // HANGUL SYLLABLE TIKEUT YU HIEUH
    { 0x8ACD, 0xB4DE }, // HANGUL SYLLABLE TIKEUT EU SSANGKIYEOK
    { 0x8ACE, 0xB4DF }, // HANGUL SYLLABLE TIKEUT EU KIYEOKSIOS
    { 0x8ACF, 0xB4E1 }, // HANGUL SYLLABLE TIKEUT EU NIEUNCIEUC
    { 0x8AD0, 0xB4E2 }, // HANGUL SYLLABLE TIKEUT EU NIEUNHIEUH
    { 0x8AD1, 0xB4E5 }, // HANGUL SYLLABLE TIKEUT EU RIEULKIYEOK
    { 0x8AD2, 0xB4E7 }, // HANGUL SYLLABLE TIKEUT EU RIEULPIEUP
    { 0x8AD3, 0xB4E8 }, // HANGUL SYLLABLE TIKEUT EU RIEULSIOS
    { 0x8AD4, 0xB4E9 }, // HANGUL SYLLABLE TIKEUT EU RIEULTHIEUTH
    { 0x8AD5, 0xB4EA }, // HANGUL SYLLABLE TIKEUT EU RIEULPHIEUPH
    { 0x8AD6, 0xB4EB }, // HANGUL SYLLABLE TIKEUT EU RIEULHIEUH
    { 0x8AD7, 0xB4EE }, // HANGUL SYLLABLE TIKEUT EU PIEUPSIOS
    { 0x8AD8, 0xB4F0 }, // HANGUL SYLLABLE TIKEUT EU SSANGSIOS
    { 0x8AD9, 0xB4F2 }, // HANGUL SYLLABLE TIKEUT EU CIEUC
    { 0x8ADA, 0xB4F3 }, // HANGUL SYLLABLE TIKEUT EU CHIEUCH
    { 0x8ADB, 0xB4F4 }, // HANGUL SYLLABLE TIKEUT EU KHIEUKH
    { 0x8ADC, 0xB4F5 }, // HANGUL SYLLABLE TIKEUT EU THIEUTH
    { 0x8ADD, 0xB4F6 }, // HANGUL SYLLABLE TIKEUT EU PHIEUPH
    { 0x8ADE, 0xB4F7 }, // HANGUL SYLLABLE TIKEUT EU HIEUH
    { 0x8ADF, 0xB4F9 }, // HANGUL SYLLABLE TIKEUT YI KIYEOK
    { 0x8AE0, 0xB4FA }, // HANGUL SYLLABLE TIKEUT YI SSANGKIYEOK
    { 0x8AE1, 0xB4FB }, // HANGUL SYLLABLE TIKEUT YI KIYEOKSIOS
    { 0x8AE2, 0xB4FC }, // HANGUL SYLLABLE TIKEUT YI NIEUN
    { 0x8AE3, 0xB4FD }, // HANGUL SYLLABLE TIKEUT YI NIEUNCIEUC
    { 0x8AE4, 0xB4FE }, // HANGUL SYLLABLE TIKEUT YI NIEUNHIEUH
    { 0x8AE5, 0xB4FF }, // HANGUL SYLLABLE TIKEUT YI TIKEUT
    { 0x8AE6, 0xB500 }, // HANGUL SYLLABLE TIKEUT YI RIEUL
    { 0x8AE7, 0xB501 }, // HANGUL SYLLABLE TIKEUT YI RIEULKIYEOK
    { 0x8AE8, 0xB502 }, // HANGUL SYLLABLE TIKEUT YI RIEULMIEUM
    { 0x8AE9, 0xB503 }, // HANGUL SYLLABLE TIKEUT YI RIEULPIEUP
    { 0x8AEA, 0xB504 }, // HANGUL SYLLABLE TIKEUT YI RIEULSIOS
    { 0x8AEB, 0xB505 }, // HANGUL SYLLABLE TIKEUT YI RIEULTHIEUTH
    { 0x8AEC, 0xB506 }, // HANGUL SYLLABLE TIKEUT YI RIEULPHIEUPH
    { 0x8AED, 0xB507 }, // HANGUL SYLLABLE TIKEUT YI RIEULHIEUH
    { 0x8AEE, 0xB508 }, // HANGUL SYLLABLE TIKEUT YI MIEUM
    { 0x8AEF, 0xB509 }, // HANGUL SYLLABLE TIKEUT YI PIEUP
    { 0x8AF0, 0xB50A }, // HANGUL SYLLABLE TIKEUT YI PIEUPSIOS
    { 0x8AF1, 0xB50B }, // HANGUL SYLLABLE TIKEUT YI SIOS
    { 0x8AF2, 0xB50C }, // HANGUL SYLLABLE TIKEUT YI SSANGSIOS
    { 0x8AF3, 0xB50D }, // HANGUL SYLLABLE TIKEUT YI IEUNG
    { 0x8AF4, 0xB50E }, // HANGUL SYLLABLE TIKEUT YI CIEUC
    { 0x8AF5, 0xB50F }, // HANGUL SYLLABLE TIKEUT YI CHIEUCH
    { 0x8AF6, 0xB510 }, // HANGUL SYLLABLE TIKEUT YI KHIEUKH
    { 0x8AF7, 0xB511 }, // HANGUL SYLLABLE TIKEUT YI THIEUTH
    { 0x8AF8, 0xB512 }, // HANGUL SYLLABLE TIKEUT YI PHIEUPH
    { 0x8AF9, 0xB513 }, // HANGUL SYLLABLE TIKEUT YI HIEUH
    { 0x8AFA, 0xB516 }, // HANGUL SYLLABLE TIKEUT I SSANGKIYEOK
    { 0x8AFB, 0xB517 }, // HANGUL SYLLABLE TIKEUT I KIYEOKSIOS
    { 0x8AFC, 0xB519 }, // HANGUL SYLLABLE TIKEUT I NIEUNCIEUC
    { 0x8AFD, 0xB51A }, // HANGUL SYLLABLE TIKEUT I NIEUNHIEUH
    { 0x8AFE, 0xB51D }, // HANGUL SYLLABLE TIKEUT I RIEULKIYEOK
    { 0x8B41, 0xB51E }, // HANGUL SYLLABLE TIKEUT I RIEULMIEUM
    { 0x8B42, 0xB51F }, // HANGUL SYLLABLE TIKEUT I RIEULPIEUP
    { 0x8B43, 0xB520 }, // HANGUL SYLLABLE TIKEUT I RIEULSIOS
    { 0x8B44, 0xB521 }, // HANGUL SYLLABLE TIKEUT I RIEULTHIEUTH
    { 0x8B45, 0xB522 }, // HANGUL SYLLABLE TIKEUT I RIEULPHIEUPH
    { 0x8B46, 0xB523 }, // HANGUL SYLLABLE TIKEUT I RIEULHIEUH
    { 0x8B47, 0xB526 }, // HANGUL SYLLABLE TIKEUT I PIEUPSIOS
    { 0x8B48, 0xB52B }, // HANGUL SYLLABLE TIKEUT I CHIEUCH
    { 0x8B49, 0xB52C }, // HANGUL SYLLABLE TIKEUT I KHIEUKH
    { 0x8B4A, 0xB52D }, // HANGUL SYLLABLE TIKEUT I THIEUTH
    { 0x8B4B, 0xB52E }, // HANGUL SYLLABLE TIKEUT I PHIEUPH
    { 0x8B4C, 0xB52F }, // HANGUL SYLLABLE TIKEUT I HIEUH
    { 0x8B4D, 0xB532 }, // HANGUL SYLLABLE SSANGTIKEUT A SSANGKIYEOK
    { 0x8B4E, 0xB533 }, // HANGUL SYLLABLE SSANGTIKEUT A KIYEOKSIOS
    { 0x8B4F, 0xB535 }, // HANGUL SYLLABLE SSANGTIKEUT A NIEUNCIEUC
    { 0x8B50, 0xB536 }, // HANGUL SYLLABLE SSANGTIKEUT A NIEUNHIEUH
    { 0x8B51, 0xB537 }, // HANGUL SYLLABLE SSANGTIKEUT A TIKEUT
    { 0x8B52, 0xB539 }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULKIYEOK
    { 0x8B53, 0xB53A }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULMIEUM
    { 0x8B54, 0xB53B }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULPIEUP
    { 0x8B55, 0xB53C }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULSIOS
    { 0x8B56, 0xB53D }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULTHIEUTH
    { 0x8B57, 0xB53E }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULPHIEUPH
    { 0x8B58, 0xB53F }, // HANGUL SYLLABLE SSANGTIKEUT A RIEULHIEUH
    { 0x8B59, 0xB542 }, // HANGUL SYLLABLE SSANGTIKEUT A PIEUPSIOS
    { 0x8B5A, 0xB546 }, // HANGUL SYLLABLE SSANGTIKEUT A CIEUC
    { 0x8B61, 0xB547 }, // HANGUL SYLLABLE SSANGTIKEUT A CHIEUCH
    { 0x8B62, 0xB548 }, // HANGUL SYLLABLE SSANGTIKEUT A KHIEUKH
    { 0x8B63, 0xB549 }, // HANGUL SYLLABLE SSANGTIKEUT A THIEUTH
    { 0x8B64, 0xB54A }, // HANGUL SYLLABLE SSANGTIKEUT A PHIEUPH
    { 0x8B65, 0xB54E }, // HANGUL SYLLABLE SSANGTIKEUT AE SSANGKIYEOK
    { 0x8B66, 0xB54F }, // HANGUL SYLLABLE SSANGTIKEUT AE KIYEOKSIOS
    { 0x8B67, 0xB551 }, // HANGUL SYLLABLE SSANGTIKEUT AE NIEUNCIEUC
    { 0x8B68, 0xB552 }, // HANGUL SYLLABLE SSANGTIKEUT AE NIEUNHIEUH
    { 0x8B69, 0xB553 }, // HANGUL SYLLABLE SSANGTIKEUT AE TIKEUT
    { 0x8B6A, 0xB555 }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULKIYEOK
    { 0x8B6B, 0xB556 }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULMIEUM
    { 0x8B6C, 0xB557 }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULPIEUP
    { 0x8B6D, 0xB558 }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULSIOS
    { 0x8B6E, 0xB559 }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULTHIEUTH
    { 0x8B6F, 0xB55A }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULPHIEUPH
    { 0x8B70, 0xB55B }, // HANGUL SYLLABLE SSANGTIKEUT AE RIEULHIEUH
    { 0x8B71, 0xB55E }, // HANGUL SYLLABLE SSANGTIKEUT AE PIEUPSIOS
    { 0x8B72, 0xB562 }, // HANGUL SYLLABLE SSANGTIKEUT AE CIEUC
    { 0x8B73, 0xB563 }, // HANGUL SYLLABLE SSANGTIKEUT AE CHIEUCH
    { 0x8B74, 0xB564 }, // HANGUL SYLLABLE SSANGTIKEUT AE KHIEUKH
    { 0x8B75, 0xB565 }, // HANGUL SYLLABLE SSANGTIKEUT AE THIEUTH
    { 0x8B76, 0xB566 }, // HANGUL SYLLABLE SSANGTIKEUT AE PHIEUPH
    { 0x8B77, 0xB567 }, // HANGUL SYLLABLE SSANGTIKEUT AE HIEUH
    { 0x8B78, 0xB568 }, // HANGUL SYLLABLE SSANGTIKEUT YA
    { 0x8B79, 0xB569 }, // HANGUL SYLLABLE SSANGTIKEUT YA KIYEOK
    { 0x8B7A, 0xB56A }, // HANGUL SYLLABLE SSANGTIKEUT YA SSANGKIYEOK
    { 0x8B81, 0xB56B }, // HANGUL SYLLABLE SSANGTIKEUT YA KIYEOKSIOS
    { 0x8B82, 0xB56C }, // HANGUL SYLLABLE SSANGTIKEUT YA NIEUN
    { 0x8B83, 0xB56D }, // HANGUL SYLLABLE SSANGTIKEUT YA NIEUNCIEUC
    { 0x8B84, 0xB56E }, // HANGUL SYLLABLE SSANGTIKEUT YA NIEUNHIEUH
    { 0x8B85, 0xB56F }, // HANGUL SYLLABLE SSANGTIKEUT YA TIKEUT
    { 0x8B86, 0xB570 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEUL
    { 0x8B87, 0xB571 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULKIYEOK
    { 0x8B88, 0xB572 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULMIEUM
    { 0x8B89, 0xB573 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULPIEUP
    { 0x8B8A, 0xB574 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULSIOS
    { 0x8B8B, 0xB575 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULTHIEUTH
    { 0x8B8C, 0xB576 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULPHIEUPH
    { 0x8B8D, 0xB577 }, // HANGUL SYLLABLE SSANGTIKEUT YA RIEULHIEUH
    { 0x8B8E, 0xB578 }, // HANGUL SYLLABLE SSANGTIKEUT YA MIEUM
    { 0x8B8F, 0xB579 }, // HANGUL SYLLABLE SSANGTIKEUT YA PIEUP
    { 0x8B90, 0xB57A }, // HANGUL SYLLABLE SSANGTIKEUT YA PIEUPSIOS
    { 0x8B91, 0xB57B }, // HANGUL SYLLABLE SSANGTIKEUT YA SIOS
    { 0x8B92, 0xB57C }, // HANGUL SYLLABLE SSANGTIKEUT YA SSANGSIOS
    { 0x8B93, 0xB57D }, // HANGUL SYLLABLE SSANGTIKEUT YA IEUNG
    { 0x8B94, 0xB57E }, // HANGUL SYLLABLE SSANGTIKEUT YA CIEUC
    { 0x8B95, 0xB57F }, // HANGUL SYLLABLE SSANGTIKEUT YA CHIEUCH
    { 0x8B96, 0xB580 }, // HANGUL SYLLABLE SSANGTIKEUT YA KHIEUKH
    { 0x8B97, 0xB581 }, // HANGUL SYLLABLE SSANGTIKEUT YA THIEUTH
    { 0x8B98, 0xB582 }, /