#pragma region Copyright (c) 2014-2017 OpenRCT2 Developers
/*****************************************************************************
 * OpenRCT2, an open source clone of Roller Coaster Tycoon 2.
 *
 * OpenRCT2 is the work of many authors, a full list can be found in contributors.md
 * For more information, visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * A full copy of the GNU General Public License can be found in licence.txt
 *****************************************************************************/
#pragma endregion

#include <openrct2/interface/Cursors.h>
#include "CursorRepository.h"

namespace OpenRCT2 { namespace Ui
{
    static constexpr const CursorData BlankCursorData =
    {
        { 0, 0 }, { 0 }, { 0 }
    };

    static constexpr const CursorData UpArrowCursorData =
    {
        { 15, 0 },
        {
            0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x04, 0x10, 0x00,
            0x00, 0x08, 0x08, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x1E, 0x3C, 0x00, 0x00, 0x02, 0x20, 0x00,
            0x00, 0x02, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x02, 0x20, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x07, 0xF0, 0x00,
            0x00, 0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x03, 0xE0, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData UpDownArrowCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x02, 0xA0, 0x00,
            0x00, 0x05, 0x50, 0x00, 0x00, 0x0A, 0x28, 0x00, 0x00, 0x17, 0x74, 0x00, 0x00, 0x21, 0x42, 0x00,
            0x00, 0x1D, 0xDC, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x02, 0x20, 0x00,
            0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x05, 0xD0, 0x00, 0x00, 0x1D, 0x5C, 0x00,
            0x00, 0x21, 0x42, 0x00, 0x00, 0x17, 0x74, 0x00, 0x00, 0x0A, 0x28, 0x00, 0x00, 0x05, 0x50, 0x00,
            0x00, 0x02, 0xA0, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00,
            0x00, 0x07, 0x70, 0x00, 0x00, 0x0E, 0x38, 0x00, 0x00, 0x1F, 0x7C, 0x00, 0x00, 0x3F, 0x7E, 0x00,
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00,
            0x00, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x1F, 0x7C, 0x00,
            0x00, 0x3F, 0x7E, 0x00, 0x00, 0x1F, 0x7C, 0x00, 0x00, 0x0E, 0x38, 0x00, 0x00, 0x07, 0x70, 0x00,
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData ZZZCursorData =
    {
        { 0, 0 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C,
            0x00, 0x00, 0x03, 0xE2, 0x00, 0x00, 0xFC, 0x34, 0x00, 0x01, 0x07, 0x62, 0x00, 0x3F, 0xEA, 0xDC,
            0x00, 0x40, 0xD4, 0x20, 0x00, 0x3D, 0xBB, 0xC0, 0x3F, 0xCB, 0x04, 0x00, 0x40, 0x34, 0xF8, 0x00,
            0x40, 0x2F, 0x00, 0x00, 0x3C, 0x40, 0x80, 0x00, 0x08, 0xBF, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
            0x23, 0xC0, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C,
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x3F, 0xFB, 0xDC,
            0x00, 0x7F, 0xF7, 0xE0, 0x00, 0x3F, 0xFB, 0xC0, 0x3F, 0xCF, 0xFC, 0x00, 0x7F, 0xFC, 0xF8, 0x00,
            0x7F, 0xFF, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x0F, 0xBF, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00,
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData DiagonalArrowCursorData =
    {
        { 0, 0 },
        {
            0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00,
            0x48, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00,
            0x00, 0x1C, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0xFE, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00,
            0xFC, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x87, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00,
            0x01, 0xC2, 0x00, 0x00, 0x00, 0xE6, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00,
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData PickerArrowCursorData =
    {
        { 15, 31 },
        {
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x08, 0x60, 0x00, 0x00, 0x13, 0x30, 0x00, 0x00, 0x17, 0xB0, 0x00,
            0x00, 0x17, 0xB0, 0x00, 0x00, 0x13, 0x30, 0x00, 0x00, 0x08, 0x60, 0x00, 0x00, 0x0F, 0xE0, 0x00,
            0x00, 0x0F, 0xE0, 0x00, 0x00, 0x17, 0x30, 0x00, 0x00, 0x12, 0x30, 0x00, 0x00, 0x21, 0x18, 0x00,
            0x00, 0x23, 0x18, 0x00, 0x00, 0x44, 0x8C, 0x00, 0x00, 0x44, 0x8C, 0x00, 0x00, 0x88, 0x46, 0x00,
            0x00, 0x90, 0x26, 0x00, 0x01, 0x10, 0x23, 0x00, 0x01, 0x20, 0x13, 0x00, 0x02, 0x40, 0x09, 0x80,
            0x02, 0x40, 0x09, 0x80, 0x04, 0x80, 0x04, 0xC0, 0x04, 0x80, 0x04, 0xC0, 0x04, 0x80, 0x04, 0xC0,
            0x04, 0x80, 0x04, 0xC0, 0x04, 0x80, 0x04, 0xC0, 0x04, 0x40, 0x08, 0xC0, 0x02, 0x40, 0x09, 0x80,
            0x01, 0x20, 0x13, 0x00, 0x00, 0x90, 0x26, 0x00, 0x00, 0x68, 0x5C, 0x00, 0x00, 0x1C, 0xF0, 0x00,
        },
        {
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xF0, 0x00,
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x0F, 0xE0, 0x00,
            0x00, 0x0F, 0xE0, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xF8, 0x00,
            0x00, 0x3F, 0xF8, 0x00, 0x00, 0x7C, 0xFC, 0x00, 0x00, 0x7C, 0xFC, 0x00, 0x00, 0xF8, 0x7E, 0x00,
            0x00, 0xF0, 0x3E, 0x00, 0x01, 0xF0, 0x3F, 0x00, 0x01, 0xE0, 0x1F, 0x00, 0x03, 0xC0, 0x0F, 0x80,
            0x03, 0xC0, 0x0F, 0x80, 0x07, 0x80, 0x07, 0xC0, 0x07, 0x80, 0x07, 0xC0, 0x07, 0x80, 0x07, 0xC0,
            0x07, 0x80, 0x07, 0xC0, 0x07, 0x80, 0x07, 0xC0, 0x07, 0xC0, 0x0F, 0xC0, 0x03, 0xC0, 0x0F, 0x80,
            0x01, 0xE0, 0x1F, 0x00, 0x00, 0xF0, 0x3E, 0x00, 0x00, 0x78, 0x7C, 0x00, 0x00, 0x1C, 0xF0, 0x00,
        }
    };

    static constexpr const CursorData TreeDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x01, 0x89, 0xC0, 0x00, 0x02, 0x06, 0x20,
            0x00, 0x07, 0x00, 0x18, 0x00, 0x07, 0x40, 0x04, 0x00, 0x03, 0x80, 0x04, 0x00, 0x01, 0xC0, 0x02,
            0x00, 0x03, 0x82, 0x02, 0x00, 0x03, 0xD0, 0x04, 0x00, 0x07, 0xF9, 0x08, 0x00, 0x0F, 0x6E, 0x04,
            0x00, 0x0E, 0xB8, 0x82, 0x00, 0x0F, 0x44, 0x22, 0x00, 0x0F, 0xA8, 0x46, 0x00, 0x0F, 0xFC, 0x16,
            0x00, 0x07, 0xEE, 0x8C, 0x0F, 0x81, 0xFF, 0xD8, 0x08, 0x80, 0x7D, 0xF0, 0x08, 0x80, 0x3A, 0x00,
            0x08, 0x80, 0x1A, 0x00, 0x08, 0x80, 0x1A, 0x00, 0x08, 0x80, 0x12, 0x00, 0x08, 0x80, 0x12, 0x00,
            0x08, 0x80, 0x11, 0x00, 0xF8, 0xF8, 0x60, 0x80, 0x40, 0x11, 0x80, 0x60, 0x20, 0x22, 0x09, 0x90,
            0x10, 0x41, 0xD5, 0x60, 0x08, 0x80, 0x22, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x01, 0xF9, 0xC0, 0x00, 0x03, 0xFF, 0xE0,
            0x00, 0x07, 0xFF, 0xF8, 0x00, 0x07, 0xFF, 0xFC, 0x00, 0x03, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFE,
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x03, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFC,
            0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xFE,
            0x00, 0x07, 0xFF, 0xFC, 0x0F, 0x81, 0xFF, 0xF8, 0x0F, 0x80, 0x7F, 0xF0, 0x0F, 0x80, 0x3E, 0x00,
            0x0F, 0x80, 0x1E, 0x00, 0x0F, 0x80, 0x1E, 0x00, 0x0F, 0x80, 0x1E, 0x00, 0x0F, 0x80, 0x1E, 0x00,
            0x0F, 0x80, 0x1F, 0x00, 0xFF, 0xF8, 0x7F, 0x80, 0x7F, 0xF1, 0xFF, 0xE0, 0x3F, 0xE3, 0xFF, 0xF0,
            0x1F, 0xC1, 0xF7, 0x60, 0x0F, 0x80, 0x22, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData FountainDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0E, 0x00,
            0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x7B, 0xC0, 0x00, 0x01, 0x8B, 0x30, 0x00, 0x02, 0x17, 0xC8,
            0x00, 0x02, 0x0F, 0x88, 0x0F, 0x83, 0x80, 0x38, 0x08, 0x82, 0x7F, 0xD8, 0x08, 0x81, 0x01, 0xF0,
            0x08, 0x80, 0xE3, 0xE0, 0x08, 0x80, 0x3F, 0x80, 0x08, 0x80, 0x17, 0x00, 0x08, 0x80, 0x13, 0x00,
            0x08, 0x80, 0x13, 0x00, 0xF8, 0xF8, 0x27, 0x80, 0x40, 0x10, 0x4E, 0xC0, 0x20, 0x20, 0x80, 0xE0,
            0x10, 0x40, 0xC1, 0xA0, 0x08, 0x80, 0x7F, 0xC0, 0x05, 0x00, 0x1F, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x01, 0x04, 0x00, 0x00, 0x10, 0x10, 0x81, 0x00, 0x00, 0x41, 0x14, 0x00, 0x05, 0x08, 0x20,
            0x00, 0x00, 0x22, 0x81, 0x00, 0x00, 0x88, 0x10, 0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x02, 0x00,
            0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0E, 0x00,
            0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xF8,
            0x00, 0x03, 0xFF, 0xF8, 0x0F, 0x83, 0xFF, 0xF8, 0x0F, 0x83, 0xFF, 0xF8, 0x0F, 0x81, 0xFF, 0xF0,
            0x0F, 0x80, 0xFF, 0xE0, 0x0F, 0x80, 0x3F, 0x80, 0x0F, 0x80, 0x1F, 0x00, 0x0F, 0x80, 0x1F, 0x00,
            0x0F, 0x80, 0x1F, 0x00, 0xFF, 0xF8, 0x3F, 0x80, 0x7F, 0xF0, 0x7F, 0xC0, 0x3F, 0xE0, 0xFF, 0xE0,
            0x1F, 0xC0, 0xFF, 0xE0, 0x0F, 0x80, 0x7F, 0xC0, 0x07, 0x00, 0x1F, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData StatueDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x07, 0x03, 0x30,
            0x00, 0x02, 0x84, 0x98, 0x00, 0x01, 0x44, 0x98, 0x00, 0x00, 0xB5, 0xA8, 0x00, 0x00, 0x4A, 0xD0,
            0x00, 0x00, 0x21, 0x20, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0x10, 0x80,
            0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00,
            0x00, 0x00, 0x05, 0x00, 0x0F, 0x80, 0x08, 0x80, 0x08, 0x80, 0x04, 0x80, 0x08, 0x80, 0x05, 0x00,
            0x08, 0x80, 0x0D, 0x00, 0x08, 0x80, 0x09, 0x00, 0x08, 0x80, 0x3F, 0x80, 0x08, 0x80, 0x20, 0x80,
            0x08, 0x80, 0x20, 0x80, 0xF8, 0xF8, 0x20, 0x80, 0x40, 0x10, 0x20, 0x80, 0x20, 0x20, 0x20, 0x80,
            0x10, 0x40, 0x7F, 0xC0, 0x08, 0x80, 0x80, 0x20, 0x05, 0x00, 0xFF, 0xE0, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10, 0x00, 0x07, 0x03, 0x30,
            0x00, 0x03, 0x87, 0x98, 0x00, 0x01, 0xC7, 0x98, 0x00, 0x00, 0xF7, 0xB8, 0x00, 0x00, 0x7E, 0xF0,
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x1F, 0x80,
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00,
            0x00, 0x00, 0x07, 0x00, 0x0F, 0x80, 0x0F, 0x80, 0x0F, 0x80, 0x07, 0x80, 0x0F, 0x80, 0x07, 0x00,
            0x0F, 0x80, 0x0F, 0x00, 0x0F, 0x80, 0x0F, 0x00, 0x0F, 0x80, 0x3F, 0x80, 0x0F, 0x80, 0x3F, 0x80,
            0x0F, 0x80, 0x3F, 0x80, 0xFF, 0xF8, 0x3F, 0x80, 0x7F, 0xF0, 0x3F, 0x80, 0x3F, 0xE0, 0x3F, 0x80,
            0x1F, 0xC0, 0x7F, 0xC0, 0x0F, 0x80, 0xFF, 0xE0, 0x07, 0x00, 0xFF, 0xE0, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData BenchDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x05, 0x80, 0x00,
            0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x18, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x05, 0x81, 0x80,
            0x00, 0x05, 0x60, 0x60, 0x00, 0x0D, 0x18, 0x18, 0x00, 0x33, 0x06, 0x04, 0x00, 0xC0, 0xC1, 0x84,
            0x00, 0xF0, 0x30, 0x64, 0x00, 0xAC, 0x0C, 0x1C, 0x00, 0xA7, 0x03, 0x14, 0x00, 0x40, 0xC0, 0xD4,
            0x00, 0x00, 0xF0, 0x34, 0x0F, 0x80, 0xAC, 0x0C, 0x08, 0x80, 0xA3, 0x3C, 0x08, 0x80, 0x41, 0xD4,
            0x08, 0x80, 0x01, 0xD4, 0x08, 0x80, 0x01, 0x48, 0x08, 0x80, 0x01, 0x40, 0x08, 0x80, 0x00, 0x80,
            0x08, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00,
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x07, 0xFF, 0x80,
            0x00, 0x07, 0x7F, 0xE0, 0x00, 0x0F, 0x1F, 0xF8, 0x00, 0x3F, 0x07, 0xFC, 0x00, 0xFF, 0xC1, 0xFC,
            0x00, 0xFF, 0xF0, 0x7C, 0x00, 0xEF, 0xFC, 0x1C, 0x00, 0xE7, 0xFF, 0x1C, 0x00, 0x40, 0xFF, 0xDC,
            0x00, 0x00, 0xFF, 0xFC, 0x0F, 0x80, 0xEF, 0xFC, 0x0F, 0x80, 0xE3, 0xFC, 0x0F, 0x80, 0x41, 0xDC,
            0x0F, 0x80, 0x01, 0xDC, 0x0F, 0x80, 0x01, 0xC8, 0x0F, 0x80, 0x01, 0xC0, 0x0F, 0x80, 0x00, 0x80,
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData CrossHairCursorData =
    {
        { 15, 15 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
            0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
            0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE2, 0x3F, 0x80,
            0x10, 0x15, 0x40, 0x40, 0x0F, 0xE2, 0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
            0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
            0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
            0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE2, 0x3F, 0x80,
            0x1F, 0xF7, 0x7F, 0xC0, 0x0F, 0xE2, 0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
            0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData BinDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x22, 0x00,
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xC3, 0x80, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x02, 0x57, 0xE0,
            0x00, 0x02, 0x00, 0x60, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x01, 0x01, 0xC0, 0x00, 0x01, 0x40, 0xC0,
            0x00, 0x01, 0x50, 0xC0, 0x0F, 0x81, 0x50, 0x40, 0x08, 0x81, 0x51, 0x40, 0x08, 0x81, 0x51, 0x40,
            0x08, 0x81, 0x55, 0x40, 0x08, 0x81, 0x55, 0x40, 0x08, 0x81, 0x55, 0x40, 0x08, 0x81, 0x55, 0x40,
            0x08, 0x81, 0x55, 0x40, 0xF8, 0xF9, 0x55, 0x40, 0x40, 0x11, 0x55, 0x40, 0x20, 0x21, 0xFF, 0xC0,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x22, 0x00,
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xE0,
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x01, 0xFF, 0xC0,
            0x00, 0x01, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0,
            0x0F, 0x81, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0, 0x0F, 0x81, 0xFF, 0xC0,
            0x0F, 0x81, 0xFF, 0xC0, 0xFF, 0xF9, 0xFF, 0xC0, 0x7F, 0xF1, 0xFF, 0xC0, 0x3F, 0xE1, 0xFF, 0xC0,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData LampPostDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0xFF, 0x80,
            0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x32, 0x00,
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x94, 0x80,
            0x00, 0x01, 0xF7, 0xC0, 0x00, 0x00, 0x94, 0x80, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00,
            0x00, 0x00, 0x14, 0x00, 0x0F, 0x80, 0x14, 0x00, 0x08, 0x80, 0x14, 0x00, 0x08, 0x80, 0x14, 0x00,
            0x08, 0x80, 0x14, 0x00, 0x08, 0x80, 0x14, 0x00, 0x08, 0x80, 0x14, 0x00, 0x08, 0x80, 0x1C, 0x00,
            0x08, 0x80, 0x1C, 0x00, 0xF8, 0xF8, 0x32, 0x00, 0x40, 0x10, 0x61, 0x00, 0x20, 0x20, 0x61, 0x00,
            0x10, 0x40, 0x71, 0x00, 0x08, 0x80, 0x7D, 0x00, 0x05, 0x00, 0xFF, 0x80, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0xFF, 0x80,
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x3E, 0x00,
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x9C, 0x80,
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, 0x9C, 0x80, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00,
            0x00, 0x00, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00,
            0x0F, 0x80, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00, 0x0F, 0x80, 0x1C, 0x00,
            0x0F, 0x80, 0x1C, 0x00, 0xFF, 0xF8, 0x3E, 0x00, 0x7F, 0xF0, 0x7F, 0x00, 0x3F, 0xE0, 0x7F, 0x00,
            0x1F, 0xC0, 0x7F, 0x00, 0x0F, 0x80, 0x7F, 0x00, 0x07, 0x00, 0xFF, 0x80, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData FenceDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x4E, 0x60, 0x00, 0x00,
            0x43, 0xB0, 0x00, 0x00, 0x20, 0xB1, 0x80, 0x00, 0x2C, 0x3A, 0xC0, 0x00, 0x2F, 0x0E, 0xC6, 0x00,
            0x2C, 0x82, 0xCB, 0x00, 0x2C, 0xB0, 0x6B, 0x18, 0x6C, 0xBC, 0x1B, 0x2C, 0x7C, 0xB2, 0x83, 0x2C,
            0x1E, 0xB2, 0xE1, 0xAC, 0x07, 0xB2, 0xD8, 0x6C, 0x01, 0xF2, 0xCA, 0x0C, 0x00, 0x7A, 0xCB, 0x86,
            0x00, 0x1E, 0xCB, 0x66, 0x0F, 0x87, 0xCB, 0x2E, 0x08, 0x81, 0xEB, 0x2C, 0x08, 0x80, 0x7B, 0x2C,
            0x08, 0x80, 0x1F, 0x2C, 0x08, 0x80, 0x07, 0xAC, 0x08, 0x80, 0x01, 0xEC, 0x08, 0x80, 0x00, 0x78,
            0x08, 0x80, 0x00, 0x18, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x7E, 0x60, 0x00, 0x00,
            0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xF1, 0x80, 0x00, 0x3F, 0xFB, 0xC0, 0x00, 0x3F, 0xFF, 0xC6, 0x00,
            0x3C, 0xFF, 0xCF, 0x00, 0x3C, 0xFF, 0xEF, 0x18, 0x7C, 0xFF, 0xFF, 0x3C, 0x7C, 0xF3, 0xFF, 0x3C,
            0x1E, 0xF3, 0xFF, 0xBC, 0x07, 0xF3, 0xDF, 0xFC, 0x01, 0xF3, 0xCF, 0xFC, 0x00, 0x7B, 0xCF, 0xFE,
            0x00, 0x1F, 0xCF, 0x7E, 0x0F, 0x87, 0xCF, 0x3E, 0x0F, 0x81, 0xEF, 0x3C, 0x0F, 0x80, 0x7F, 0x3C,
            0x0F, 0x80, 0x1F, 0x3C, 0x0F, 0x80, 0x07, 0xBC, 0x0F, 0x80, 0x01, 0xFC, 0x0F, 0x80, 0x00, 0x78,
            0x0F, 0x80, 0x00, 0x18, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData FlowerDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x18, 0x44, 0x30,
            0x00, 0x24, 0x54, 0x48, 0x00, 0x22, 0x54, 0x88, 0x00, 0x11, 0x55, 0x10, 0x00, 0x0A, 0xBA, 0xA0,
            0x00, 0x05, 0xBB, 0x40, 0x00, 0x03, 0xC7, 0x80, 0x00, 0x7C, 0x92, 0x7C, 0x00, 0x83, 0x47, 0x82,
            0x01, 0x1D, 0x89, 0xF1, 0x00, 0x83, 0x23, 0x82, 0x00, 0x7C, 0x8A, 0x7C, 0x00, 0x03, 0xE7, 0x80,
            0x00, 0x05, 0xBB, 0x40, 0x0F, 0x8A, 0xBA, 0xA0, 0x08, 0x91, 0x55, 0x10, 0x08, 0x92, 0x54, 0x90,
            0x08, 0x8C, 0x44, 0x6C, 0x08, 0x98, 0x44, 0x32, 0x08, 0xA6, 0x44, 0x42, 0x08, 0xA1, 0x28, 0x82,
            0x08, 0xA0, 0xB9, 0x24, 0xF8, 0xFA, 0xBA, 0x44, 0x40, 0x11, 0x6A, 0x88, 0x20, 0x28, 0xED, 0x10,
            0x10, 0x46, 0x4A, 0x60, 0x08, 0x81, 0x81, 0x80, 0x05, 0x00, 0x7E, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x18, 0x7C, 0x30,
            0x00, 0x3C, 0x7C, 0x78, 0x00, 0x3E, 0x7C, 0xF8, 0x00, 0x1F, 0x7D, 0xF0, 0x00, 0x0F, 0xBB, 0xE0,
            0x00, 0x07, 0xBB, 0xC0, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x7C, 0xFE, 0x7C, 0x00, 0xFF, 0xFF, 0xFE,
            0x01, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFE, 0x00, 0x7C, 0xFE, 0x7C, 0x00, 0x03, 0xFF, 0x80,
            0x00, 0x07, 0xBB, 0xC0, 0x0F, 0x8F, 0xBB, 0xE0, 0x0F, 0x9F, 0x7D, 0xF0, 0x0F, 0x9E, 0x7C, 0xF0,
            0x0F, 0x8C, 0x7C, 0x6C, 0x0F, 0x98, 0x7C, 0x3E, 0x0F, 0xBE, 0x7C, 0x7E, 0x0F, 0xBF, 0x38, 0xFE,
            0x0F, 0xBF, 0xB9, 0xFC, 0xFF, 0xFF, 0xBB, 0xFC, 0x7F, 0xFF, 0xFB, 0xF8, 0x3F, 0xEF, 0xFF, 0xF0,
            0x1F, 0xC7, 0xFF, 0xE0, 0x0F, 0x81, 0xFF, 0x80, 0x07, 0x00, 0x7E, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData FootpathDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x01, 0x85, 0x80, 0x00,
            0x06, 0x48, 0x60, 0x00, 0x1A, 0x24, 0x58, 0x00, 0x62, 0x3A, 0x46, 0x00, 0x79, 0xC1, 0x45, 0x80,
            0x1E, 0x27, 0xFC, 0x60, 0x07, 0x98, 0x82, 0x58, 0x01, 0xE0, 0x82, 0x46, 0x00, 0x79, 0x45, 0x79,
            0x00, 0x1E, 0x28, 0x87, 0x0F, 0x87, 0x94, 0x9E, 0x08, 0x81, 0xE2, 0x78, 0x08, 0x80, 0x79, 0xE0,
            0x08, 0x80, 0x1F, 0x80, 0x08, 0x80, 0x06, 0x00, 0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00,
            0x08, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01, 0xFF, 0x80, 0x00,
            0x07, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0x80,
            0x1F, 0xFF, 0xFF, 0xE0, 0x07, 0xFF, 0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF,
            0x00, 0x1F, 0xFF, 0xFF, 0x0F, 0x87, 0xFF, 0xFE, 0x0F, 0x81, 0xFF, 0xF8, 0x0F, 0x80, 0x7F, 0xE0,
            0x0F, 0x80, 0x1F, 0x80, 0x0F, 0x80, 0x06, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00,
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData DigDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0xA4,
            0x00, 0x00, 0x01, 0x52, 0x00, 0x00, 0x02, 0x8B, 0x00, 0x00, 0x02, 0x96, 0x00, 0x00, 0x02, 0x6C,
            0x00, 0x00, 0x04, 0x18, 0x00, 0x00, 0x08, 0xF0, 0x00, 0x00, 0x11, 0x80, 0x00, 0x03, 0x2A, 0x00,
            0x00, 0x04, 0xC6, 0x00, 0x00, 0x09, 0x8C, 0x00, 0x00, 0x15, 0x18, 0x00, 0x00, 0x22, 0x30, 0x00,
            0x00, 0x24, 0x78, 0x00, 0x0F, 0xC5, 0xE4, 0x00, 0x08, 0xC7, 0xC4, 0x00, 0x08, 0xC3, 0x28, 0x00,
            0x08, 0xA0, 0x10, 0x00, 0x08, 0x90, 0x20, 0x00, 0x08, 0x88, 0xC0, 0x00, 0x08, 0x87, 0x00, 0x00,
            0x08, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xFC,
            0x00, 0x00, 0x01, 0xDE, 0x00, 0x00, 0x03, 0x8F, 0x00, 0x00, 0x03, 0x9E, 0x00, 0x00, 0x03, 0xFC,
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x03, 0x3E, 0x00,
            0x00, 0x07, 0xFE, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x3F, 0xF0, 0x00,
            0x00, 0x3F, 0xF8, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0xF8, 0x00,
            0x0F, 0xBF, 0xF0, 0x00, 0x0F, 0x9F, 0xE0, 0x00, 0x0F, 0x8F, 0xC0, 0x00, 0x0F, 0x87, 0x00, 0x00,
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData WaterDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x82, 0x00,
            0x08, 0x20, 0x82, 0x00, 0x14, 0x51, 0x45, 0x00, 0x63, 0x8E, 0x38, 0xC0, 0x88, 0x20, 0x82, 0x20,
            0x77, 0xDF, 0x7D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x82, 0x08, 0x00, 0x20, 0x82, 0x08,
            0x00, 0x51, 0x45, 0x14, 0x00, 0x8E, 0x38, 0xE2, 0x0F, 0xA0, 0x82, 0x09, 0x08, 0xDF, 0x7D, 0xF6,
            0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x82, 0x00, 0x08, 0x80, 0x82, 0x00, 0x08, 0x81, 0x45, 0x00,
            0x08, 0x86, 0x38, 0xC0, 0xF8, 0xF8, 0x82, 0x20, 0x40, 0x17, 0x7D, 0xC0, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x82, 0x00,
            0x08, 0x20, 0x82, 0x00, 0x1C, 0x71, 0xC7, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xE0,
            0x77, 0xDF, 0x7D, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x82, 0x08, 0x00, 0x20, 0x82, 0x08,
            0x00, 0x71, 0xC7, 0x1C, 0x00, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0x0F, 0xDF, 0x7D, 0xF6,
            0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x82, 0x00, 0x0F, 0x80, 0x82, 0x00, 0x0F, 0x81, 0xC7, 0x00,
            0x0F, 0x87, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xF7, 0x7D, 0xC0, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData HouseDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xF0, 0x00, 0x00, 0x2A, 0x10,
            0x00, 0x00, 0x45, 0xE0, 0x00, 0x00, 0x93, 0x20, 0x00, 0x01, 0x19, 0x20, 0x00, 0x02, 0x0C, 0x20,
            0x00, 0x04, 0x7E, 0x20, 0x00, 0x08, 0x03, 0x20, 0x00, 0x10, 0xFF, 0x90, 0x00, 0x20, 0x00, 0xC8,
            0x00, 0x47, 0xFF, 0xE4, 0x00, 0xF0, 0x00, 0x7E, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10,
            0x00, 0x11, 0xEF, 0xD0, 0x00, 0x11, 0x28, 0x50, 0x0F, 0x91, 0x28, 0x50, 0x08, 0x91, 0x28, 0x50,
            0x08, 0x91, 0x2F, 0xD0, 0x08, 0x91, 0x20, 0x10, 0x08, 0x91, 0x20, 0x10, 0x08, 0x9F, 0xFF, 0xF0,
            0x08, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xF0, 0x00, 0x00, 0x3B, 0xF0,
            0x00, 0x00, 0x7D, 0xE0, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x01, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xE0,
            0x00, 0x07, 0xFF, 0xE0, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xF8,
            0x00, 0x7F, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xF0,
            0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x1F, 0x38, 0x70, 0x0F, 0x9F, 0x38, 0x70, 0x0F, 0x9F, 0x38, 0x70,
            0x0F, 0x9F, 0x3F, 0xF0, 0x0F, 0x9F, 0x3F, 0xF0, 0x0F, 0x9F, 0x3F, 0xF0, 0x0F, 0x9F, 0xFF, 0xF0,
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData VolcanoDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x08, 0xA0, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x02, 0x40, 0x00,
            0x00, 0x07, 0xB0, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x17, 0x84, 0x00, 0x00, 0x30, 0x1E, 0x00,
            0x00, 0x76, 0x72, 0x00, 0x00, 0x5A, 0x89, 0x00, 0x00, 0x81, 0x1C, 0x80, 0x03, 0x08, 0x0A, 0x70,
            0x04, 0x18, 0x17, 0x88, 0x18, 0x30, 0x0A, 0xA6, 0x23, 0xC2, 0x07, 0x7F, 0x7C, 0x5F, 0x8F, 0xEC,
            0x40, 0xF0, 0xD8, 0xC0, 0x00, 0x40, 0x20, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00,
            0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00,
            0x08, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x08, 0xA0, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x02, 0x40, 0x00,
            0x00, 0x07, 0xB0, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x3F, 0xFE, 0x00,
            0x00, 0x7F, 0xFE, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xF0,
            0x07, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0x7C, 0x7F, 0xFF, 0xEC,
            0x40, 0xF0, 0xF8, 0xC0, 0x00, 0x40, 0x20, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00,
            0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00,
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData WalkDownCursorData =
    {
        { 7, 31 },
        {
            0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00,
            0x02, 0x10, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00,
            0x00, 0x12, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x1C, 0x00,
            0x02, 0x20, 0x22, 0x00, 0x02, 0x10, 0x21, 0x00, 0x01, 0x08, 0x10, 0x80, 0x00, 0x88, 0x08, 0x80,
            0x00, 0x72, 0x07, 0x20, 0x00, 0x0D, 0x00, 0xD0, 0x0F, 0x89, 0x00, 0x90, 0x08, 0x86, 0x00, 0x60,
            0x08, 0x80, 0x00, 0x00, 0x08, 0x80, 0x0E, 0x00, 0x08, 0x80, 0x11, 0x00, 0x08, 0x80, 0x10, 0x80,
            0x08, 0x80, 0x08, 0x40, 0xF8, 0xF8, 0x04, 0x40, 0x40, 0x10, 0x03, 0x90, 0x20, 0x20, 0x00, 0x68,
            0x10, 0x40, 0x00, 0x48, 0x08, 0x80, 0x00, 0x30, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00,
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00,
            0x00, 0x1E, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x1C, 0x00,
            0x03, 0xE0, 0x3E, 0x00, 0x03, 0xF0, 0x3F, 0x00, 0x01, 0xF8, 0x1F, 0x80, 0x00, 0xF8, 0x0F, 0x80,
            0x00, 0x72, 0x07, 0x20, 0x00, 0x0F, 0x00, 0xF0, 0x0F, 0x8F, 0x00, 0xF0, 0x0F, 0x86, 0x00, 0x60,
            0x0F, 0x80, 0x00, 0x00, 0x0F, 0x80, 0x0E, 0x00, 0x0F, 0x80, 0x1F, 0x00, 0x0F, 0x80, 0x1F, 0x80,
            0x0F, 0x80, 0x0F, 0xC0, 0xFF, 0xF8, 0x07, 0xC0, 0x7F, 0xF0, 0x03, 0x90, 0x3F, 0xE0, 0x00, 0x78,
            0x1F, 0xC0, 0x00, 0x78, 0x0F, 0x80, 0x00, 0x30, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData PaintDownCursorData =
    {
        { 8, 30 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFA,
            0x00, 0x00, 0x01, 0xF6, 0x00, 0x00, 0x03, 0xE4, 0x00, 0x03, 0x07, 0xCC, 0x00, 0x07, 0x84, 0x98,
            0x00, 0x0F, 0xC8, 0x70, 0x00, 0x1B, 0xF8, 0x60, 0x00, 0x3D, 0xE0, 0xC0, 0x00, 0x7E, 0xE3, 0x00,
            0x00, 0xFF, 0x62, 0x00, 0x00, 0xDF, 0xBE, 0x00, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0x37, 0xEF, 0x80,
            0x00, 0x1B, 0xF7, 0xC0, 0x07, 0xCF, 0xFB, 0xC0, 0x04, 0x46, 0x9D, 0xC0, 0x04, 0x43, 0x07, 0x80,
            0x04, 0x41, 0x83, 0x00, 0x04, 0x40, 0xC6, 0x00, 0x04, 0x40, 0x6C, 0x00, 0x04, 0x40, 0x28, 0x00,
            0x7C, 0x7C, 0x10, 0x00, 0x20, 0x08, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x08, 0x20, 0x00, 0x00,
            0x04, 0x40, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFE,
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x03, 0x07, 0xFC, 0x00, 0x07, 0x87, 0xF8,
            0x00, 0x0F, 0xCF, 0xF0, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0x00,
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x3F, 0xFF, 0x80,
            0x00, 0x1F, 0xFF, 0xC0, 0x07, 0xCF, 0xFF, 0xC0, 0x07, 0xC7, 0xFF, 0xC0, 0x07, 0xC3, 0xFF, 0x80,
            0x07, 0xC1, 0xFF, 0x00, 0x07, 0xC0, 0xFE, 0x00, 0x07, 0xC0, 0x7C, 0x00, 0x07, 0xC0, 0x38, 0x00,
            0x7F, 0xFC, 0x10, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00,
            0x07, 0xC0, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData EntranceDownCursorData =
    {
        { 7, 31 },
        {
            0x20, 0x00, 0x00, 0x08, 0x50, 0x00, 0x00, 0x14, 0x88, 0x00, 0x00, 0x22, 0x50, 0x00, 0x00, 0x14,
            0x7F, 0xFF, 0xFF, 0xFC, 0x58, 0x00, 0x00, 0x34, 0x54, 0x00, 0x00, 0x54, 0x54, 0x00, 0x00, 0x54,
            0x54, 0x00, 0x00, 0x54, 0x5C, 0x00, 0x00, 0x34, 0x5F, 0xFF, 0xFF, 0xF4, 0x50, 0x00, 0x00, 0x14,
            0x50, 0x00, 0x00, 0x14, 0x50, 0x00, 0x00, 0x14, 0x50, 0x00, 0x00, 0x14, 0x50, 0x00, 0x00, 0x14,
            0x50, 0x00, 0x00, 0x14, 0x5F, 0x80, 0x00, 0x14, 0xD8, 0x80, 0x00, 0x14, 0x58, 0x80, 0x02, 0xB5,
            0x58, 0x80, 0x00, 0x14, 0xD8, 0x80, 0x00, 0x14, 0x58, 0x80, 0x05, 0x74, 0x08, 0x80, 0x00, 0x00,
            0x08, 0x80, 0x00, 0xD2, 0xF8, 0xF8, 0x0E, 0x00, 0x40, 0x10, 0x00, 0x00, 0x20, 0x20, 0x00, 0x00,
            0x10, 0x40, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        },
        {
            0x20, 0x00, 0x00, 0x08, 0x70, 0x00, 0x00, 0x1C, 0xF8, 0x00, 0x00, 0x3E, 0x70, 0x00, 0x00, 0x1C,
            0x7F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFC, 0x77, 0xFF, 0xFF, 0xDC, 0x77, 0xFF, 0xFF, 0xDC,
            0x77, 0xFF, 0xFF, 0xDC, 0x7F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFC, 0x70, 0x00, 0x00, 0x1C,
            0x70, 0x00, 0x00, 0x1C, 0x70, 0x00, 0x00, 0x1C, 0x70, 0x00, 0x00, 0x1C, 0x70, 0x00, 0x00, 0x1C,
            0x70, 0x00, 0x00, 0x1C, 0x7F, 0x80, 0x00, 0x1C, 0xFF, 0x80, 0x00, 0x1C, 0x7F, 0x80, 0x02, 0xBD,
            0x7F, 0x80, 0x00, 0x1C, 0xFF, 0x80, 0x00, 0x1C, 0x7F, 0x80, 0x05, 0x7C, 0x0F, 0x80, 0x00, 0x00,
            0x0F, 0x80, 0x00, 0xD2, 0xFF, 0xF8, 0x0E, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00,
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        }
    };

    static constexpr const CursorData HandOpenDownCursorData =
    {
        { 5, 1 },
        {
            0x00, 0x06, 0x10, 0x00, 0x00, 0x09, 0x38, 0x00, 0x00, 0x09, 0x24, 0x00, 0x03, 0x08, 0xA4, 0x00,
            0x04, 0x88, 0xA4, 0xC0, 0x04, 0x48, 0x63, 0x20, 0x04, 0x24, 0x63, 0x10, 0x06, 0x24, 0x61, 0x90,
            0x02, 0x14, 0x21, 0x90, 0x03, 0x0C, 0x21, 0x10, 0x01, 0x04, 0x21, 0x10, 0x01, 0x86, 0x01, 0x10,
            0x00, 0x82, 0x00, 0x08, 0x00, 0xC0, 0x00, 0x08, 0x00, 0x60, 0x00, 0x08, 0x00, 0x20, 0x00, 0x08,
            0x00, 0x30, 0x00, 0x08, 0x00, 0x30, 0x00, 0x08, 0x00, 0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 0x08,
            0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10,
            0x0F, 0xC0, 0x00, 0x10, 0x10, 0x00, 0x00, 0x08, 0x14, 0x00, 0x00, 0x08, 0x12, 0x00, 0x00, 0x08,
            0x0F, 0x0F, 0x00, 0x04, 0x01, 0xF9, 0x80, 0x04, 0x00, 0x00, 0xC0, 0x18, 0x00, 0x00, 0x7F, 0xE0,
        },
        {
            0x00, 0x06, 0x10, 0x00, 0x00, 0x0F, 0x38, 0x00, 0x00, 0x0F, 0x3C, 0x00, 0x03, 0x0F, 0xBC, 0x00,
            0x07, 0x8F, 0xBC, 0xC0, 0x07, 0xCF, 0xFF, 0xE0, 0x07, 0xE7, 0xFF, 0xF0, 0x07, 0xE7, 0xFF, 0xF0,
            0x03, 0xF7, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xF0,
            0x00, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xF8,
            0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x1F, 0xFF, 0xF8,
            0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xF0,
            0x0F, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xF8,
            0x0F, 0xFF, 0xFF, 0xFC, 0x01, 0xF9, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xE0,
        }
    };

    static constexpr const CursorData HandClosedDownCursorData =
    {
        { 5, 1 },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xE0, 0x00, 0x00, 0x43, 0x10, 0x00, 0x00, 0x41, 0x8C, 0x00,
            0x00, 0x20, 0x87, 0x00, 0x0E, 0x20, 0x42, 0x80, 0x11, 0x98, 0x62, 0x40, 0x10, 0x6C, 0x61, 0x20,
            0x18, 0x14, 0x21, 0x20, 0x0C, 0x0C, 0x21, 0x10, 0x06, 0x04, 0x21, 0x10, 0x03, 0x06, 0x01, 0x10,
            0x00, 0x82, 0x00, 0x08, 0x00, 0xC0, 0x00, 0x08, 0x00, 0x60, 0x00, 0x08, 0x00, 0x20, 0x00, 0x08,
            0x00, 0x30, 0x00, 0x08, 0x00, 0x30, 0x00, 0x08, 0x00, 0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 0x08,
            0x07, 0x10, 0x00, 0x10, 0x08, 0x90, 0x00, 0x10, 0x08, 0x60, 0x00, 0x10, 0x0A, 0x00, 0x00, 0x10,
            0x0A, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x08, 0x03, 0x80, 0x00, 0x08,
            0x00, 0x7F, 0x00, 0x04, 0x00, 0x01, 0x80, 0x04, 0x00, 0x00, 0xC0, 0x18, 0x00, 0x00, 0x7F, 0xE0,
        },
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xE0, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x7F, 0xFC, 0x00,
            0x00, 0x3F, 0xFF, 0x00, 0x0E, 0x3F, 0xFF, 0x80, 0x1F, 0x9F, 0xFF, 0xC0, 0x1F, 0xEF, 0xFF, 0xE0,
            0x1F, 0xF7, 0xFF, 0xE0, 0x0F, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xF0,
            0x00, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xF8,
            0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x1F, 0xFF, 0xF8,
            0x07, 0x1F, 0xFF, 0xF0, 0x0F, 0x9F, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF0,
            0x0F, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xF8,
            0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x7F, 0xE0,
        }
    };

    static constexpr const CursorData * RawCursorData[] =
    {
        nullptr,                    // CURSOR_ARROW
        &BlankCursorData,           // CURSOR_BLANK
        &UpArrowCursorData,         // CURSOR_UP_ARROW
        &UpDownArrowCursorData,     // CURSOR_UP_DOWN_ARROW
        nullptr,                    // CURSOR_HAND_POINT
        &ZZZCursorData,             // CURSOR_ZZZ
        &DiagonalArrowCursorData,   // CURSOR_DIAGONAL_ARROWS
        &PickerArrowCursorData,     // CURSOR_PICKER
        &TreeDownCursorData,        // CURSOR_TREE_DOWN
        &FountainDownCursorData,    // CURSOR_FOUNTAIN_DOWN
        &StatueDownCursorData,      // CURSOR_STATUE_DOWN
        &BenchDownCursorData,       // CURSOR_BENCH_DOWN
        &CrossHairCursorData,       // CURSOR_CROSS_HAIR
        &BinDownCursorData,         // CURSOR_BIN_DOWN
        &LampPostDownCursorData,    // CURSOR_LAMPPOST_DOWN
        &FenceDownCursorData,       // CURSOR_FENCE_DOWN
        &FlowerDownCursorData,      // CURSOR_FLOWER_DOWN
        &FootpathDownCursorData,    // CURSOR_PATH_DOWN
        &DigDownCursorData,         // CURSOR_DIG_DOWN
        &WaterDownCursorData,       // CURSOR_WATER_DOWN
        &HouseDownCursorData,       // CURSOR_HOUSE_DOWN
        &VolcanoDownCursorData,     // CURSOR_VOLCANO_DOWN
        &WalkDownCursorData,        // CURSOR_WALK_DOWN
        &PaintDownCursorData,       // CURSOR_PAINT_DOWN
        &EntranceDownCursorData,    // CURSOR_ENTRANCE_DOWN
        &HandOpenDownCursorData,    // CURSOR_HAND_OPEN
        &HandClosedDownCursorData,  // CURSOR_HAND_CLOSED
    };

    const CursorData * CursorRepository::GetCursorData(CURSOR_ID cursorId)
    {
        const CursorData * result = nullptr;
        if (cursorId >= 0 && cursorId < CURSOR_COUNT)
        {
            result = RawCursorData[cursorId];
        }
        return result;
    }
} }
