# Standard things

sp 		:= $(sp).x
dirstack_$(sp)	:= $(d)
d		:= $(dir)


# Local rules and targets

CF_$(d)		:= -I$(d) -Icommon -Ilanguage
LL_$(d)		:= common/common.a language/language.a

COMOBJS_$(d)	:= $(d)/config.o $(d)/jobs.o $(d)/channels.o
OBJS_$(d)	:= $(COMOBJS_$(d)) $(d)/conftest.o $(d)/bigtest.o $(d)/main.o
DEPS_$(d)	:= $(OBJS_$(d):%=%.d)

CLEAN		:= $(CLEAN) $(OBJS_$(d)) $(DEPS_$(d)) $(d)/defs.h \
		   $(d)/radiusd $(d)/conftest $(d)/bigtest

TGT_SBIN	:= $(TGT_SBIN) $(d)/radiusd
TGT_TEST	:= $(TGT_TEST) $(d)/conftest $(d)/bigtest


# Local rules

$(OBJS_$(d)):	CF_TGT := $(CF_$(d))
$(OBJS_$(d)):	$(d)/Rules.mk $(d)/defs.h common/platform.h

$(d)/conftest.o:	CF_TGT := $(CF_$(d)) -DCONF_TEST
$(d)/conftest.o:	$(d)/config.c
		$(COMP)
$(d)/conftest:	LL_TGT := $(S_LL_CRYPT)

$(d)/bigtest:	LL_TGT := $(S_LL_INET) $(S_LL_CRYPT)
$(d)/bigtest:	$(d)/bigtest.o $(COMOBJS_$(d)) $(LL_$(d))
		$(LINK)

$(d)/radiusd:	LL_TGT := $(S_LL_INET) $(S_LL_CRYPT)
$(d)/radiusd:	$(d)/main.o $(COMOBJS_$(d)) $(LL_$(d))
		$(LINK)

$(d)/%:		$(d)/%.o $(LL_$(d))
		$(LINK)

$(d)/defs.h: $(d)/Rules.mk
		$(DEFHDR) $@ $(S_CF_SIGACTION) -DVERSION=\"$(VERSION)\" \
			-DRADDB=\"$(DIR_ETC)\" \
			-DMODULES=\"$(DIR_LIB)\" \
			-DLOGFILE=\"$(FILE_LOG)\"  


# Standard things

-include	$(DEPS_$(d))

d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))

