# Standard things

sp 		:= $(sp).x
dirstack_$(sp)	:= $(d)
d		:= $(dir)


# Local variables

CF_$(d)		:= -I$(d) -Icommon -Iserver

COMOBJS_$(d)	:= $(d)/langvm.o $(d)/langdisasm.o
LIBOBJS_$(d)	:= $(d)/langcompile.o $(COMOBJS_$(d))
TSTOBJS_$(d)	:= $(d)/langtest.o $(d)/langcomp-tst.o $(COMOBJS_$(d))
OBJS_$(d)	:= $(LIBOBJS_$(d)) $(TSTOBJS_$(d))
DEPS_$(d)	:= $(OBJS_$(d):%=%.d)

CLEAN		:= $(CLEAN) $(OBJS_$(d)) $(DEPS_$(d)) \
		   $(d)/langtest $(d)/language.a

TGT_TEST	:= $(TGT_TEST) $(d)/langtest


# Local rules

$(OBJS_$(d)):	$(d)/Rules.mk common/platform.h
$(OBJS_$(d)):	CF_TGT := $(CF_$(d))

$(d)/langcomp-tst.o:	CF_TGT := $(CF_$(d)) -DCOMP_MEM
$(d)/langcomp-tst.o:	$(d)/langcompile.c
		$(COMP)

$(d)/language.a: $(LIBOBJS_$(d))
		$(ARCHIVE)

$(d)/langtest:	LL_TGT := $(S_LL_CRYPT)
$(d)/langtest:	$(TSTOBJS_$(d)) common/common.a
		$(LINK)


# Standard things

-include	$(DEPS_$(d))

d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))

