/*
 * CONFIG - Server configuration handler
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/26 - EvB - Created
 * 2001/10/29 - EvB - Moved start_conf() from bigtest to here as
 * 		      conf_start(). Not ideal, but still the best place IMHO.
 */


/*
 * INCLUDES & DEFINES
 */


#include <srvtypes.h>

#define CONF_MAX_IDENTLEN	4092		     /* Max identifier length */
#define CONF_MAX_CODELEN	65536		     /* Max. code length */
#define CONF_MAINFNAME		"configuration"	     /* Main file in basepath */
#define EXPR_MAINFNAME		"behaviour"	     /* Main file in basepath */


/*
 * PROTOTYPES
 */


/* Main functions */

CONF *conf_new(META *m, char *basepath, char *modbasepath);

int conf_start(CONF *c, time_t t);		/* Opens sockets, runs childs */
int conf_stop(CONF *c, time_t t);		/* Stops childs, closes socks */

void conf_del(CONF *c);				/* Frees data */

