/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.10
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

/* source: ./../eac.i */

#define SWIGMODULE eac
#define SWIGGO_PREFIX go.eac
/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>



typedef int intgo;
typedef unsigned int uintgo;



typedef struct { char *p; intgo n; } _gostring_;
typedef struct { void* array; intgo len; intgo cap; } _goslice_;



#define SWIGGO_GCCGO

#ifdef __cplusplus
extern "C" {
#endif
extern void *_cgo_allocate(size_t);
extern void _cgo_panic(const char *);
#ifdef __cplusplus
}
#endif

#define _swig_goallocate _cgo_allocate
#define _swig_gopanic _cgo_panic



/* Implementations of SwigCgocall and friends for different versions
   of gccgo.  The Go code will call these functions using C names with
   a prefix of the module name.  The implementations here call the
   routine in libgo.  The routines to call vary depending on the gccgo
   version.  We assume that the version of gcc used to compile this
   file is the same as the version of gccgo.  */

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_GCC_VERSION \
  (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)

#if SWIG_GCC_VERSION < 40700
#define SwigDoCgocall()
#define SwigDoCgocallDone()
#define SwigDoCgocallBack()
#define SwigDoCgocallBackDone()
#elif SWIG_GCC_VERSION == 40700
void SwigDoCgocall(void) __asm__("libgo_syscall.syscall.Entersyscall");
void SwigDoCgocallDone(void) __asm__("libgo_syscall.syscall.Exitsyscall");
void SwigDoCgocallBack(void) __asm__("libgo_syscall.syscall.Exitsyscall");
void SwigDoCgocallBackDone(void) __asm__("libgo_syscall.syscall.Entersyscall");
#else
void SwigDoCgocall(void) __asm__("syscall.Cgocall");
void SwigDoCgocallDone(void) __asm__("syscall.CgocallDone");
void SwigDoCgocallBack(void) __asm__("syscall.CgocallBack");
void SwigDoCgocallBackDone(void) __asm__("syscall.CgocallBackDone");
#endif

#define SWIGSTRINGIFY2(s) #s
#define SWIGSTRINGIFY(s) SWIGSTRINGIFY2(s)

void SwigCgocall()
  __asm__(SWIGSTRINGIFY(SWIGGO_PREFIX) ".SwigCgocall");
void SwigCgocall() {
  SwigDoCgocall();
}

void SwigCgocallDone()
  __asm__(SWIGSTRINGIFY(SWIGGO_PREFIX) ".SwigCgocallDone");
void SwigCgocallDone() {
  SwigDoCgocallDone();
}

void SwigCgocallBack()
  __asm__(SWIGSTRINGIFY(SWIGGO_PREFIX) ".SwigCgocallBack");
void SwigCgocallBack() {
  SwigDoCgocallBack();
}

void SwigCgocallBackDone()
  __asm__(SWIGSTRINGIFY(SWIGGO_PREFIX) ".SwigCgocallBackDone");
void SwigCgocallBackDone() {
  SwigDoCgocallBackDone();
}

#undef SWIGSTRINGIFY
#undef SWIGSTRINGIFY2

#ifdef __cplusplus
}
#endif




/* This is here for backward compatibility, but it will not work
   with Go 1.5 or later.  Do not use it in new code.  */
static _gostring_ _swig_makegostring(const char *p, size_t l) {
  _gostring_ ret;
  ret.p = (char*)_swig_goallocate(l + 1);
  memcpy(ret.p, p, l);
  ret.n = l;
  return ret;
}




#define SWIG_contract_assert(expr, msg) \
  if (!(expr)) { _swig_gopanic(msg); } else


static _gostring_ Swig_AllocateString(const char *p, size_t l) {
  _gostring_ ret;
  ret.p = (char*)malloc(l);
  memcpy(ret.p, p, l);
  ret.n = l;
  return ret;
}


static void Swig_free(void* p) {
  free(p);
}

static void* Swig_malloc(int c) {
  return malloc(c);
}


#include <eac/eac.h>
#include <openssl/bio.h>
#include <stdlib.h>
#include <string.h>

/* included in OpenPACE, but not propagated */
extern void BUF_MEM_clear_free(BUF_MEM *b);


#include <eac/eac.h>
#include <openssl/err.h>
#include <openssl/objects.h>
#include <stdlib.h>
#include <string.h>

/* included in OpenPACE, but not propagated */
extern BUF_MEM *BUF_MEM_create_init(const void *buf, size_t len);


    /*Dumps a BUF_MEM structure to stdout for debugging purposes */
    static void hexdump(const char *title, const BUF_MEM *s) {
        unsigned int n=0;

        if (!s) return;

        fprintf(stdout,"%s",title);
        for(; n < s->length; ++n) {
            if((n%16) == 0)
            fprintf(stdout,"\n    ");
            fprintf(stdout,"%02x:",(unsigned char) s->data[n]);
        }
        fprintf(stdout,"\n");
    }


    static void set_tr_version(EAC_CTX *ctx, int version) {
        switch (version) {
            case 1:
                ctx->tr_version = EAC_TR_VERSION_2_01;
                break;
            case 2:
                ctx->tr_version = EAC_TR_VERSION_2_02;
                break;
            default:
                ctx->tr_version = EAC_TR_VERSION;
                break;
        }
        return;
    }


    /* Converts a binary string and a length into a BUF_MEM structure */
    static BUF_MEM * get_buf(char *in, size_t in_len) {
        BUF_MEM *buf = NULL;
        if (in_len > 0)
            buf = BUF_MEM_create_init(in, in_len);
        return buf;
    }


    /* Print the OpenSSL error stack to stdout */
    static void print_ossl_err(void) {
        /* Might be better to load the strings once on program startup */
        ERR_load_crypto_strings();
        ERR_print_errors_fp(stdout);
        ERR_free_strings();
        return;
    }


#include <eac/ca.h>
#include <eac/cv_cert.h>
#include <eac/objects.h>
#include <stdlib.h>
#include <string.h>

/* included in OpenPACE, but not propagated */
extern void BUF_MEM_clear_free(BUF_MEM *b);


    int
    ca_set_key(const EAC_CTX *ctx,
            char *privkey, size_t privkey_len,
            char *pubkey, size_t pubkey_len)
    {
        return CA_set_key(ctx,
            (unsigned char *) privkey, privkey_len,
            (unsigned char *) pubkey, pubkey_len);
    }


#include <eac/cv_cert.h>
#include <openssl/bio.h>
#include <stdlib.h>
#include <string.h>


    static void CVC_CHAT_PRINT(CVC_CHAT *chat, int indent) {
        BIO *bio_stdout = BIO_new_fp(stdout, BIO_NOCLOSE);
        if (!bio_stdout)
            return;
        cvc_chat_print(bio_stdout, chat, indent);
        BIO_free_all(bio_stdout);
    }

 /* typemap applied */
    static CVC_CERT *cvc_d2i_cvc_cert(char *in, size_t in_len) {
        CVC_CERT *cvc = NULL;
        const unsigned char **p = (const unsigned char **) &in;
        cvc = CVC_d2i_CVC_CERT(NULL, p, in_len);
        return cvc;
    }

 /* typemap applied */
    static CVC_CERTIFICATE_DESCRIPTION *d2i_cvc_certificate_description(char *in, size_t in_len) {
        CVC_CERTIFICATE_DESCRIPTION *description = NULL;
        const unsigned char **p = (const unsigned char **) &in;
        description = d2i_CVC_CERTIFICATE_DESCRIPTION(NULL, p, in_len);
        return description;
    }

 /* typemap applied */
    static CVC_CHAT *d2i_cvc_chat(char *in, size_t in_len) {
        CVC_CHAT *chat = NULL;
        const unsigned char **p = (const unsigned char **) &in;
        chat = d2i_CVC_CHAT(NULL, p, (long) in_len);
        return chat;
    }


    static void print_binary_chat(char *in, size_t in_len) {
        CVC_CHAT *chat = NULL;
        const unsigned char **p;

        if (!in || (in_len <= 0))
            return;

        p = (const unsigned char**)&in;

        /* Convert string to CHAT structure */
        chat = d2i_CVC_CHAT(NULL, p, in_len);
        if (!chat)
            return;

        /* Print CHAT structure */
        CVC_CHAT_PRINT(chat, 0);

        /* Free memory */
        free(chat);
        return;
    }

 /* typemap applied */
    void i2d_cvc_chat(CVC_CHAT *chat, char **out, size_t *out_len) {
        unsigned char *tmp;
        int new_len;

        if (!chat)
            return;

        new_len = i2d_CVC_CHAT(chat, NULL);
        if (new_len < 0) {
            *out_len = 0;
            return;
        }
        *out = (char *) malloc(new_len);
        if (!*out)
            return;

        tmp = (unsigned char *) *out;
        *out_len = i2d_CVC_CHAT(chat, &tmp);
        return;
    }


    static void get_binary_chat(CVC_CHAT *chat, char **out, size_t *out_len) {

        if (!chat || !chat->relative_authorization) {
            /* Return a NULL pointer on error */
            *out = NULL;
            *out_len = 0;
            return;
        }

        *out_len = chat->relative_authorization->length;
        *out = (char *) malloc(*out_len);
        memcpy(*out, chat->relative_authorization->data, *out_len);
        return;

    }


    static void get_chat_role(CVC_CHAT *chat, char **out, size_t *out_len) {
        int role = 0;

        if (!chat || !out || !out_len)
            goto err;

        role = CVC_get_role(chat);
        switch(role) {
            case CVC_Terminal:
                *out_len = 21;
                *out = (char *) malloc(*out_len);
                if (!*out)
                    goto err;
                strncpy(*out, "Terminal certificate", *out_len);
                break;
            case CVC_DV:
                *out_len = 15;
                *out = (char *) malloc(*out_len);
                if (!*out)
                    goto err;
                strncpy(*out, "DV certificate", *out_len);
                break;
            case CVC_DocVer:
                *out_len = 15;
                *out = (char *) malloc(*out_len);
                if (!*out)
                    goto err;
                strncpy(*out, "DV certificate", *out_len);
                break;
            case CVC_CVCA:
                *out_len = 17;
                *out = (char *) malloc(*out_len);
                if (!*out)
                    goto err;
                strncpy(*out, "CVCA certificate", *out_len);
                break;
            default:
                goto err;
        }

        return;

    err:
        if (out) {
            free(*out);
            *out = NULL;
        }
        if (out_len)
            *out_len = 0;
        return;
    }


    static void get_chat_terminal_type(CVC_CHAT *chat, char **out, size_t *out_len) {
        const char *terminal_type = NULL;

        if (!chat || !out || !out_len)
            goto err;

        terminal_type = OBJ_nid2sn(OBJ_obj2nid(chat->terminal_type));
        if (!terminal_type)
            goto err;

        *out_len = strlen(terminal_type) + 1;
        *out = (char *) malloc(*out_len);
        if (!*out)
            goto err;

        strcpy(*out, terminal_type);
        return;

    err:
        if (out) {
            free(*out);
            *out = NULL;
        }
        if (out_len)
            *out_len = 0;
        return;
    }


    /**
     * @brief Get a string representation of a CHAT.
     */
    static void get_chat_rel_auth(CVC_CHAT *chat, char **out, size_t *out_len) {
        BIO *bio = NULL;
        long tmp;

        if (!out || !out_len)
            goto err;

        bio = BIO_new(BIO_s_mem());
        if (!bio)
            goto err;

        cvc_chat_print_authorizations(bio, chat, 0);

        tmp = BIO_ctrl_pending(bio);
        if (tmp < 0)
            goto err;
        *out = (char *) malloc(tmp);
        if (!*out)
            goto err;
        *out_len = tmp;

        if (BIO_read(bio, (void *) *out, *out_len) != tmp)
            goto err;

        BIO_free_all(bio);
        return;

    err:
        if (bio)
            BIO_free_all(bio);
        if (out) {
            free(*out);
            *out = NULL;
        }
        if (out_len)
            *out_len = 0;
        return;
    }


    /**
     * @brief Get a string representation of a CHAT.
     */
    static void get_chat_repr(CVC_CHAT *chat, char **out, size_t *out_len) {
        BIO *bio =  NULL;
        long tmp;

        if (!out || !out_len)
            goto err;

        bio = BIO_new(BIO_s_mem());
        if (!bio)
            return;

        cvc_chat_print(bio, chat, 0);

        tmp = BIO_ctrl_pending(bio);
        if (tmp < 0)
            goto err;
        *out = (char *) malloc(tmp);
        if (!*out)
            goto err;
        *out_len = tmp;

        if (BIO_read(bio, (void *) *out, *out_len) != tmp)
            goto err;

        BIO_free_all(bio);
        return;

    err:
        if (bio)
            BIO_free_all(bio);
        if (out) {
            free(*out);
            *out = NULL;
        }
        if (out_len)
            *out_len = 0;
        return;
    }


    /**
     * @brief Get a string representation of a CHAT.
     */
    static void get_cvc_repr(CVC_CERT *chat, char **out, size_t *out_len) {
        BIO *bio =  NULL;
        long tmp;

        if (!out || !out_len)
            goto err;

        bio = BIO_new(BIO_s_mem());
        if (!bio)
            return;

        CVC_print(bio, chat, 0);

        tmp = BIO_ctrl_pending(bio);
        if (tmp < 0)
            goto err;
        *out = (char *) malloc(tmp);
        if (!*out)
            goto err;
        *out_len = tmp;

        if (BIO_read(bio, (void *) *out, *out_len) != tmp)
            goto err;

        BIO_free_all(bio);
        return;

    err:
        if (bio)
            BIO_free_all(bio);
        if (out) {
            free(*out);
            *out = NULL;
        }
        if (out_len)
            *out_len = 0;
        return;
    }


#include <eac/objects.h>

#ifdef HAVE_PATCHED_OPENSSL

/* OpenSSL has NIDs as defines. So lets get their value into ints */

int id_PACE_DH_GM_3DES_CBC_CBC = NID_id_PACE_DH_GM_3DES_CBC_CBC;
int id_PACE_DH_GM_AES_CBC_CMAC_128 = NID_id_PACE_DH_GM_AES_CBC_CMAC_128;
int id_PACE_DH_GM_AES_CBC_CMAC_192 = NID_id_PACE_DH_GM_AES_CBC_CMAC_192;
int id_PACE_DH_GM_AES_CBC_CMAC_256 = NID_id_PACE_DH_GM_AES_CBC_CMAC_256;
int id_PACE_ECDH_GM_3DES_CBC_CBC = NID_id_PACE_ECDH_GM_3DES_CBC_CBC;
int id_PACE_ECDH_GM_AES_CBC_CMAC_128 = NID_id_PACE_ECDH_GM_AES_CBC_CMAC_128;
int id_PACE_ECDH_GM_AES_CBC_CMAC_192 = NID_id_PACE_ECDH_GM_AES_CBC_CMAC_192;
int id_PACE_ECDH_GM_AES_CBC_CMAC_256 = NID_id_PACE_ECDH_GM_AES_CBC_CMAC_256;
int id_PACE_DH_IM_3DES_CBC_CBC = NID_id_PACE_DH_IM_3DES_CBC_CBC;
int id_PACE_DH_IM_AES_CBC_CMAC_128 = NID_id_PACE_DH_IM_AES_CBC_CMAC_128;
int id_PACE_DH_IM_AES_CBC_CMAC_192 = NID_id_PACE_DH_IM_AES_CBC_CMAC_192;
int id_PACE_DH_IM_AES_CBC_CMAC_256 = NID_id_PACE_DH_IM_AES_CBC_CMAC_256;
int id_PACE_ECDH_IM_3DES_CBC_CBC = NID_id_PACE_ECDH_IM_3DES_CBC_CBC;
int id_PACE_ECDH_IM_AES_CBC_CMAC_128 = NID_id_PACE_ECDH_IM_AES_CBC_CMAC_128;
int id_PACE_ECDH_IM_AES_CBC_CMAC_192 = NID_id_PACE_ECDH_IM_AES_CBC_CMAC_192;
int id_PACE_ECDH_IM_AES_CBC_CMAC_256 = NID_id_PACE_ECDH_IM_AES_CBC_CMAC_256;

int id_CA_DH_3DES_CBC_CBC       = NID_id_CA_DH_3DES_CBC_CBC;
int id_CA_DH_AES_CBC_CMAC_128   = NID_id_CA_DH_AES_CBC_CMAC_128;
int id_CA_DH_AES_CBC_CMAC_192   = NID_id_CA_DH_AES_CBC_CMAC_192;
int id_CA_DH_AES_CBC_CMAC_256   = NID_id_CA_DH_AES_CBC_CMAC_256;
int id_CA_ECDH_3DES_CBC_CBC     = NID_id_CA_ECDH_3DES_CBC_CBC;
int id_CA_ECDH_AES_CBC_CMAC_128 = NID_id_CA_ECDH_AES_CBC_CMAC_128;
int id_CA_ECDH_AES_CBC_CMAC_192 = NID_id_CA_ECDH_AES_CBC_CMAC_192;
int id_CA_ECDH_AES_CBC_CMAC_256 = NID_id_CA_ECDH_AES_CBC_CMAC_256;

int id_RI_DH_SHA_1 = NID_id_RI_DH_SHA_1;
int id_RI_DH_SHA_224 = NID_id_RI_DH_SHA_224;
int id_RI_DH_SHA_256 = NID_id_RI_DH_SHA_256;
int id_RI_DH_SHA_384 = NID_id_RI_DH_SHA_384;
int id_RI_DH_SHA_512 = NID_id_RI_DH_SHA_512;
int id_RI_ECDH_SHA_1 = NID_id_RI_ECDH_SHA_1;
int id_RI_ECDH_SHA_224 = NID_id_RI_ECDH_SHA_224;
int id_RI_ECDH_SHA_256 = NID_id_RI_ECDH_SHA_256;
int id_RI_ECDH_SHA_384 = NID_id_RI_ECDH_SHA_384;
int id_RI_ECDH_SHA_512 = NID_id_RI_ECDH_SHA_512;

#else

/* libeac has NIDs as ints. So lets define id_* to be NID_id_* */

#define id_PACE_DH_GM_3DES_CBC_CBC NID_id_PACE_DH_GM_3DES_CBC_CBC
#define id_PACE_DH_GM_AES_CBC_CMAC_128 NID_id_PACE_DH_GM_AES_CBC_CMAC_128
#define id_PACE_DH_GM_AES_CBC_CMAC_192 NID_id_PACE_DH_GM_AES_CBC_CMAC_192
#define id_PACE_DH_GM_AES_CBC_CMAC_256 NID_id_PACE_DH_GM_AES_CBC_CMAC_256
#define id_PACE_ECDH_GM_3DES_CBC_CBC NID_id_PACE_ECDH_GM_3DES_CBC_CBC
#define id_PACE_ECDH_GM_AES_CBC_CMAC_128 NID_id_PACE_ECDH_GM_AES_CBC_CMAC_128
#define id_PACE_ECDH_GM_AES_CBC_CMAC_192 NID_id_PACE_ECDH_GM_AES_CBC_CMAC_192
#define id_PACE_ECDH_GM_AES_CBC_CMAC_256 NID_id_PACE_ECDH_GM_AES_CBC_CMAC_256
#define id_PACE_DH_IM_3DES_CBC_CBC NID_id_PACE_DH_IM_3DES_CBC_CBC
#define id_PACE_DH_IM_AES_CBC_CMAC_128 NID_id_PACE_DH_IM_AES_CBC_CMAC_128
#define id_PACE_DH_IM_AES_CBC_CMAC_192 NID_id_PACE_DH_IM_AES_CBC_CMAC_192
#define id_PACE_DH_IM_AES_CBC_CMAC_256 NID_id_PACE_DH_IM_AES_CBC_CMAC_256
#define id_PACE_ECDH_IM_3DES_CBC_CBC NID_id_PACE_ECDH_IM_3DES_CBC_CBC
#define id_PACE_ECDH_IM_AES_CBC_CMAC_128 NID_id_PACE_ECDH_IM_AES_CBC_CMAC_128
#define id_PACE_ECDH_IM_AES_CBC_CMAC_192 NID_id_PACE_ECDH_IM_AES_CBC_CMAC_192
#define id_PACE_ECDH_IM_AES_CBC_CMAC_256 NID_id_PACE_ECDH_IM_AES_CBC_CMAC_256

#define id_CA_DH_3DES_CBC_CBC NID_id_CA_DH_3DES_CBC_CBC
#define id_CA_DH_AES_CBC_CMAC_128 NID_id_CA_DH_AES_CBC_CMAC_128
#define id_CA_DH_AES_CBC_CMAC_192 NID_id_CA_DH_AES_CBC_CMAC_192
#define id_CA_DH_AES_CBC_CMAC_256 NID_id_CA_DH_AES_CBC_CMAC_256
#define id_CA_ECDH_3DES_CBC_CBC NID_id_CA_ECDH_3DES_CBC_CBC
#define id_CA_ECDH_AES_CBC_CMAC_128 NID_id_CA_ECDH_AES_CBC_CMAC_128
#define id_CA_ECDH_AES_CBC_CMAC_192 NID_id_CA_ECDH_AES_CBC_CMAC_192
#define id_CA_ECDH_AES_CBC_CMAC_256 NID_id_CA_ECDH_AES_CBC_CMAC_256

#define id_RI_DH_SHA_1 NID_id_RI_DH_SHA_1
#define id_RI_DH_SHA_224 NID_id_RI_DH_SHA_224
#define id_RI_DH_SHA_256 NID_id_RI_DH_SHA_256
#define id_RI_DH_SHA_384 NID_id_RI_DH_SHA_384
#define id_RI_DH_SHA_512 NID_id_RI_DH_SHA_512
#define id_RI_ECDH_SHA_1 NID_id_RI_ECDH_SHA_1
#define id_RI_ECDH_SHA_224 NID_id_RI_ECDH_SHA_224
#define id_RI_ECDH_SHA_256 NID_id_RI_ECDH_SHA_256
#define id_RI_ECDH_SHA_384 NID_id_RI_ECDH_SHA_384
#define id_RI_ECDH_SHA_512 NID_id_RI_ECDH_SHA_512

#endif



#include <eac/pace.h>
#include <openssl/buffer.h>


#include <eac/ta.h>
#include <openssl/buffer.h>
#include <stdlib.h>
#include <string.h>


    static int eac_ctx_init_ef_cardaccess(char *in, size_t in_len, EAC_CTX *ctx) { /* typemap applied */
            return EAC_CTX_init_ef_cardaccess((unsigned char*) in,
                    in_len, ctx);
    }


    static int eac_ctx_init_ef_cardsecurity(char *in, size_t in_len, EAC_CTX *ctx) { /* typemap applied */
            return EAC_CTX_init_ef_cardsecurity((unsigned char*) in,
                    in_len, ctx);
    }


    static int eac_ctx_init_ta(const EAC_CTX *ctx,
            char *privkey, size_t privkey_len, char *cert, size_t cert_len) {
        return EAC_CTX_init_ta(ctx,
            (unsigned char*) privkey, privkey_len,
            (unsigned char*) cert, cert_len);

    }

#ifdef __cplusplus
extern "C" {
#endif

void go__wrap_Swig_free_eac_b0f2c4de9a53017a(void *garg1) __asm__("go.eac__wrap_Swig_free_eac_b0f2c4de9a53017a");
void go__wrap_Swig_free_eac_b0f2c4de9a53017a(void *garg1) {
  void *arg1 = (void *) 0 ;
  
  arg1 = *(void **)&garg1; 
  
  Swig_free(arg1);
  
}


void *go__wrap_Swig_malloc_eac_b0f2c4de9a53017a(intgo garg1) __asm__("go.eac__wrap_Swig_malloc_eac_b0f2c4de9a53017a");
void *go__wrap_Swig_malloc_eac_b0f2c4de9a53017a(intgo garg1) {
  int arg1 ;
  void *result = 0 ;
  void *_swig_go_result;
  
  arg1 = (int)garg1; 
  
  result = (void *)Swig_malloc(arg1);
  *(void **)&_swig_go_result = (void *)result; 
  return _swig_go_result;
}


void go__wrap_BUF_MEM_clear_free_eac_b0f2c4de9a53017a(BUF_MEM *garg1) __asm__("go.eac__wrap_BUF_MEM_clear_free_eac_b0f2c4de9a53017a");
void go__wrap_BUF_MEM_clear_free_eac_b0f2c4de9a53017a(BUF_MEM *garg1) {
  BUF_MEM *arg1 = (BUF_MEM *) 0 ;
  
  arg1 = *(BUF_MEM **)&garg1; 
  
  BUF_MEM_clear_free(arg1);
  
}


intgo go__wrap_OBJ_txt2nid_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_OBJ_txt2nid_eac_b0f2c4de9a53017a");
intgo go__wrap_OBJ_txt2nid_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  int result;
  intgo _swig_go_result;
  
  
  arg1 = (char *)malloc(garg1.n + 1);
  memcpy(arg1, garg1.p, garg1.n);
  arg1[garg1.n] = '\0';
  
  
  result = (int)OBJ_txt2nid(arg1);
  _swig_go_result = result; 
  free(arg1); 
  return _swig_go_result;
}


void go__wrap_EAC_init_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_EAC_init_eac_b0f2c4de9a53017a");
void go__wrap_EAC_init_eac_b0f2c4de9a53017a() {
  EAC_init();
  
}


void go__wrap_EAC_cleanup_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_EAC_cleanup_eac_b0f2c4de9a53017a");
void go__wrap_EAC_cleanup_eac_b0f2c4de9a53017a() {
  EAC_cleanup();
  
}


void go__wrap_hexdump_eac_b0f2c4de9a53017a(_gostring_ garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_hexdump_eac_b0f2c4de9a53017a");
void go__wrap_hexdump_eac_b0f2c4de9a53017a(_gostring_ garg1, BUF_MEM *garg2) {
  char *arg1 = (char *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  
  
  arg1 = (char *)malloc(garg1.n + 1);
  memcpy(arg1, garg1.p, garg1.n);
  arg1[garg1.n] = '\0';
  
  arg2 = *(BUF_MEM **)&garg2; 
  
  hexdump((char const *)arg1,(BUF_MEM const *)arg2);
  
  free(arg1); 
}


void go__wrap_set_tr_version_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2) __asm__("go.eac__wrap_set_tr_version_eac_b0f2c4de9a53017a");
void go__wrap_set_tr_version_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int arg2 ;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (int)garg2; 
  
  set_tr_version(arg1,arg2);
  
}


BUF_MEM *go__wrap_get_buf_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_get_buf_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_get_buf_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  
  result = (BUF_MEM *)get_buf(arg1,arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


void go__wrap_print_ossl_err_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_print_ossl_err_eac_b0f2c4de9a53017a");
void go__wrap_print_ossl_err_eac_b0f2c4de9a53017a() {
  print_ossl_err();
  
}


void go__wrap_CA_disable_passive_authentication_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_CA_disable_passive_authentication_eac_b0f2c4de9a53017a");
void go__wrap_CA_disable_passive_authentication_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  CA_disable_passive_authentication(arg1);
  
}


BUF_MEM *go__wrap_CA_get_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3) __asm__("go.eac__wrap_CA_get_pubkey_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_CA_get_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  size_t arg3 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(unsigned char **)&garg2; 
  arg3 = (size_t)garg3; 
  
  result = (BUF_MEM *)CA_get_pubkey((EAC_CTX const *)arg1,(unsigned char const *)arg2,arg3);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_CA_STEP1_get_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_CA_STEP1_get_pubkey_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_CA_STEP1_get_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)CA_STEP1_get_pubkey((EAC_CTX const *)arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_CA_STEP2_get_eph_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_CA_STEP2_get_eph_pubkey_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_CA_STEP2_get_eph_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)CA_STEP2_get_eph_pubkey((EAC_CTX const *)arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_CA_STEP3_check_pcd_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3) __asm__("go.eac__wrap_CA_STEP3_check_pcd_pubkey_eac_b0f2c4de9a53017a");
intgo go__wrap_CA_STEP3_check_pcd_pubkey_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  
  result = (int)CA_STEP3_check_pcd_pubkey((EAC_CTX const *)arg1,(BUF_MEM const *)arg2,(BUF_MEM const *)arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_CA_STEP4_compute_shared_secret_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_CA_STEP4_compute_shared_secret_eac_b0f2c4de9a53017a");
intgo go__wrap_CA_STEP4_compute_shared_secret_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (int)CA_STEP4_compute_shared_secret((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_CA_STEP6_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3) __asm__("go.eac__wrap_CA_STEP6_derive_keys_eac_b0f2c4de9a53017a");
intgo go__wrap_CA_STEP6_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  
  result = (int)CA_STEP6_derive_keys(arg1,(BUF_MEM const *)arg2,(BUF_MEM const *)arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_CA_set_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1, _gostring_ garg2, _gostring_ garg4) __asm__("go.eac__wrap_CA_set_key_eac_b0f2c4de9a53017a");
intgo go__wrap_CA_set_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1, _gostring_ garg2, _gostring_ garg4) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  arg2 = (char *)garg2.p;
  arg3 = (size_t)garg2.n;
  
  
  arg4 = (char *)garg4.p;
  arg5 = (size_t)garg4.n;
  
  
  result = (int)ca_set_key((EAC_CTX const *)arg1,arg2,arg3,arg4,arg5);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_CA_STEP5_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM **garg3, BUF_MEM **garg4) __asm__("go.eac__wrap_CA_STEP5_derive_keys_eac_b0f2c4de9a53017a");
intgo go__wrap_CA_STEP5_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM **garg3, BUF_MEM **garg4) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM **arg3 = (BUF_MEM **) 0 ;
  BUF_MEM **arg4 = (BUF_MEM **) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  arg3 = *(BUF_MEM ***)&garg3; 
  arg4 = *(BUF_MEM ***)&garg4; 
  
  result = (int)CA_STEP5_derive_keys((EAC_CTX const *)arg1,(BUF_MEM const *)arg2,arg3,arg4);
  _swig_go_result = result; 
  return _swig_go_result;
}


CVC_CERT *go__wrap_CVC_CERT_new_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_CVC_CERT_new_eac_b0f2c4de9a53017a");
CVC_CERT *go__wrap_CVC_CERT_new_eac_b0f2c4de9a53017a() {
  CVC_CERT *result = 0 ;
  CVC_CERT *_swig_go_result;
  
  
  result = (CVC_CERT *)CVC_CERT_new();
  *(CVC_CERT **)&_swig_go_result = (CVC_CERT *)result; 
  return _swig_go_result;
}


void go__wrap_CVC_CERT_free_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_CERT_free_eac_b0f2c4de9a53017a");
void go__wrap_CVC_CERT_free_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  CVC_CERT_free(arg1);
  
}


CVC_CERT *go__wrap_CVC_CERT_dup_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_CERT_dup_eac_b0f2c4de9a53017a");
CVC_CERT *go__wrap_CVC_CERT_dup_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  CVC_CERT *result = 0 ;
  CVC_CERT *_swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (CVC_CERT *)CVC_CERT_dup(arg1);
  *(CVC_CERT **)&_swig_go_result = (CVC_CERT *)result; 
  return _swig_go_result;
}


short go__wrap_CVC_get_profile_identifier_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_get_profile_identifier_eac_b0f2c4de9a53017a");
short go__wrap_CVC_get_profile_identifier_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  short result;
  short _swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (short)CVC_get_profile_identifier((CVC_CERT const *)arg1);
  _swig_go_result = result; 
  return _swig_go_result;
}


_gostring_ go__wrap_CVC_get_car_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_get_car_eac_b0f2c4de9a53017a");
_gostring_ go__wrap_CVC_get_car_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  char *result = 0 ;
  _gostring_ _swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (char *)CVC_get_car((CVC_CERT const *)arg1);
  _swig_go_result = Swig_AllocateString((char*)result, result ? strlen((char*)result) : 0); 
  free(result);
  return _swig_go_result;
}


_gostring_ go__wrap_CVC_get_chr_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_get_chr_eac_b0f2c4de9a53017a");
_gostring_ go__wrap_CVC_get_chr_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  char *result = 0 ;
  _gostring_ _swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (char *)CVC_get_chr((CVC_CERT const *)arg1);
  _swig_go_result = Swig_AllocateString((char*)result, result ? strlen((char*)result) : 0); 
  free(result);
  return _swig_go_result;
}


_gostring_ go__wrap_CVC_get_effective_date_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_get_effective_date_eac_b0f2c4de9a53017a");
_gostring_ go__wrap_CVC_get_effective_date_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  char *result = 0 ;
  _gostring_ _swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (char *)CVC_get_effective_date((CVC_CERT const *)arg1);
  _swig_go_result = Swig_AllocateString((char*)result, result ? strlen((char*)result) : 0); 
  free(result);
  return _swig_go_result;
}


_gostring_ go__wrap_CVC_get_expiration_date_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_CVC_get_expiration_date_eac_b0f2c4de9a53017a");
_gostring_ go__wrap_CVC_get_expiration_date_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  char *result = 0 ;
  _gostring_ _swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (char *)CVC_get_expiration_date((CVC_CERT const *)arg1);
  _swig_go_result = Swig_AllocateString((char*)result, result ? strlen((char*)result) : 0); 
  free(result);
  return _swig_go_result;
}


CVC_CERTIFICATE_DESCRIPTION *go__wrap_CVC_CERTIFICATE_DESCRIPTION_new_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_CVC_CERTIFICATE_DESCRIPTION_new_eac_b0f2c4de9a53017a");
CVC_CERTIFICATE_DESCRIPTION *go__wrap_CVC_CERTIFICATE_DESCRIPTION_new_eac_b0f2c4de9a53017a() {
  CVC_CERTIFICATE_DESCRIPTION *result = 0 ;
  CVC_CERTIFICATE_DESCRIPTION *_swig_go_result;
  
  
  result = (CVC_CERTIFICATE_DESCRIPTION *)CVC_CERTIFICATE_DESCRIPTION_new();
  *(CVC_CERTIFICATE_DESCRIPTION **)&_swig_go_result = (CVC_CERTIFICATE_DESCRIPTION *)result; 
  return _swig_go_result;
}


void go__wrap_CVC_CERTIFICATE_DESCRIPTION_free_eac_b0f2c4de9a53017a(CVC_CERTIFICATE_DESCRIPTION *garg1) __asm__("go.eac__wrap_CVC_CERTIFICATE_DESCRIPTION_free_eac_b0f2c4de9a53017a");
void go__wrap_CVC_CERTIFICATE_DESCRIPTION_free_eac_b0f2c4de9a53017a(CVC_CERTIFICATE_DESCRIPTION *garg1) {
  CVC_CERTIFICATE_DESCRIPTION *arg1 = (CVC_CERTIFICATE_DESCRIPTION *) 0 ;
  
  arg1 = *(CVC_CERTIFICATE_DESCRIPTION **)&garg1; 
  
  CVC_CERTIFICATE_DESCRIPTION_free(arg1);
  
}


void go__wrap_cvc_chat_print_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, intgo garg2) __asm__("go.eac__wrap_cvc_chat_print_eac_b0f2c4de9a53017a");
void go__wrap_cvc_chat_print_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, intgo garg2) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  int arg2 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = (int)garg2; 
  
  CVC_CHAT_PRINT(arg1,arg2);
  
}


CVC_CERT *go__wrap_CVC_d2i_CVC_CERT_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_CVC_d2i_CVC_CERT_eac_b0f2c4de9a53017a");
CVC_CERT *go__wrap_CVC_d2i_CVC_CERT_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  CVC_CERT *result = 0 ;
  CVC_CERT *_swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  
  result = (CVC_CERT *)cvc_d2i_cvc_cert(arg1,arg2);
  *(CVC_CERT **)&_swig_go_result = (CVC_CERT *)result; 
  return _swig_go_result;
}


CVC_CERTIFICATE_DESCRIPTION *go__wrap_d2i_CVC_CERTIFICATE_DESCRIPTION_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_d2i_CVC_CERTIFICATE_DESCRIPTION_eac_b0f2c4de9a53017a");
CVC_CERTIFICATE_DESCRIPTION *go__wrap_d2i_CVC_CERTIFICATE_DESCRIPTION_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  CVC_CERTIFICATE_DESCRIPTION *result = 0 ;
  CVC_CERTIFICATE_DESCRIPTION *_swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  
  result = (CVC_CERTIFICATE_DESCRIPTION *)d2i_cvc_certificate_description(arg1,arg2);
  *(CVC_CERTIFICATE_DESCRIPTION **)&_swig_go_result = (CVC_CERTIFICATE_DESCRIPTION *)result; 
  return _swig_go_result;
}


CVC_CHAT *go__wrap_d2i_CVC_CHAT_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_d2i_CVC_CHAT_eac_b0f2c4de9a53017a");
CVC_CHAT *go__wrap_d2i_CVC_CHAT_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  CVC_CHAT *result = 0 ;
  CVC_CHAT *_swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  
  result = (CVC_CHAT *)d2i_cvc_chat(arg1,arg2);
  *(CVC_CHAT **)&_swig_go_result = (CVC_CHAT *)result; 
  return _swig_go_result;
}


void go__wrap_print_binary_chat_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_print_binary_chat_eac_b0f2c4de9a53017a");
void go__wrap_print_binary_chat_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  
  print_binary_chat(arg1,arg2);
  
}


void go__wrap_i2d_CVC_CHAT_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_i2d_CVC_CHAT_eac_b0f2c4de9a53017a");
void go__wrap_i2d_CVC_CHAT_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  i2d_cvc_chat(arg1,arg2,arg3);
  
}


void go__wrap_get_binary_chat_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_binary_chat_eac_b0f2c4de9a53017a");
void go__wrap_get_binary_chat_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_binary_chat(arg1,arg2,arg3);
  
}


void go__wrap_get_chat_role_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_chat_role_eac_b0f2c4de9a53017a");
void go__wrap_get_chat_role_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_chat_role(arg1,arg2,arg3);
  
}


void go__wrap_get_chat_terminal_type_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_chat_terminal_type_eac_b0f2c4de9a53017a");
void go__wrap_get_chat_terminal_type_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_chat_terminal_type(arg1,arg2,arg3);
  
}


void go__wrap_get_chat_rel_auth_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_chat_rel_auth_eac_b0f2c4de9a53017a");
void go__wrap_get_chat_rel_auth_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_chat_rel_auth(arg1,arg2,arg3);
  
}


void go__wrap_get_chat_repr_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_chat_repr_eac_b0f2c4de9a53017a");
void go__wrap_get_chat_repr_eac_b0f2c4de9a53017a(CVC_CHAT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_chat_repr(arg1,arg2,arg3);
  
}


void go__wrap_get_cvc_repr_eac_b0f2c4de9a53017a(CVC_CERT *garg1, _gostring_* garg2, long long *garg3) __asm__("go.eac__wrap_get_cvc_repr_eac_b0f2c4de9a53017a");
void go__wrap_get_cvc_repr_eac_b0f2c4de9a53017a(CVC_CERT *garg1, _gostring_* garg2, long long *garg3) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  char **arg2 = (char **) 0 ;
  size_t *arg3 = (size_t *) 0 ;
  
  arg1 = *(CVC_CERT **)&garg1; 
  arg2 = *(char ***)&garg2; 
  arg3 = *(size_t **)&garg3; 
  
  get_cvc_repr(arg1,arg2,arg3);
  
}


void go__wrap_CVC_CHAT_free_eac_b0f2c4de9a53017a(CVC_CHAT *garg1) __asm__("go.eac__wrap_CVC_CHAT_free_eac_b0f2c4de9a53017a");
void go__wrap_CVC_CHAT_free_eac_b0f2c4de9a53017a(CVC_CHAT *garg1) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  
  CVC_CHAT_free(arg1);
  
}


CVC_CHAT *go__wrap_cvc_get_chat_eac_b0f2c4de9a53017a(CVC_CERT *garg1) __asm__("go.eac__wrap_cvc_get_chat_eac_b0f2c4de9a53017a");
CVC_CHAT *go__wrap_cvc_get_chat_eac_b0f2c4de9a53017a(CVC_CERT *garg1) {
  CVC_CERT *arg1 = (CVC_CERT *) 0 ;
  CVC_CHAT *result = 0 ;
  CVC_CHAT *_swig_go_result;
  
  arg1 = *(CVC_CERT **)&garg1; 
  
  result = (CVC_CHAT *)cvc_get_chat(arg1);
  *(CVC_CHAT **)&_swig_go_result = (CVC_CHAT *)result; 
  return _swig_go_result;
}


CVC_CHAT *go__wrap_CVC_CHAT_dup_eac_b0f2c4de9a53017a(CVC_CHAT *garg1) __asm__("go.eac__wrap_CVC_CHAT_dup_eac_b0f2c4de9a53017a");
CVC_CHAT *go__wrap_CVC_CHAT_dup_eac_b0f2c4de9a53017a(CVC_CHAT *garg1) {
  CVC_CHAT *arg1 = (CVC_CHAT *) 0 ;
  CVC_CHAT *result = 0 ;
  CVC_CHAT *_swig_go_result;
  
  arg1 = *(CVC_CHAT **)&garg1; 
  
  result = (CVC_CHAT *)CVC_CHAT_dup(arg1);
  *(CVC_CHAT **)&_swig_go_result = (CVC_CHAT *)result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_GM_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_GM_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_GM_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_GM_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_GM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_GM_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_GM_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_GM_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_GM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_GM_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_IM_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_IM_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_IM_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_DH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_DH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_DH_IM_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_IM_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_IM_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_IM_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_IM_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_PACE_ECDH_IM_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_PACE_ECDH_IM_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_DH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_DH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_DH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_DH_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_DH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_DH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_DH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_DH_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_DH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_DH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_DH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_DH_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_DH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_DH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_DH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_DH_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_ECDH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_ECDH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_ECDH_3DES_CBC_CBC_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_ECDH_3DES_CBC_CBC;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_ECDH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_128_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_ECDH_AES_CBC_CMAC_128;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_ECDH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_192_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_ECDH_AES_CBC_CMAC_192;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_CA_ECDH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_CA_ECDH_AES_CBC_CMAC_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_CA_ECDH_AES_CBC_CMAC_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_DH_SHA_1_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_DH_SHA_1_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_DH_SHA_1_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_DH_SHA_1;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_DH_SHA_224_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_DH_SHA_224_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_DH_SHA_224_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_DH_SHA_224;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_DH_SHA_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_DH_SHA_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_DH_SHA_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_DH_SHA_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_DH_SHA_384_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_DH_SHA_384_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_DH_SHA_384_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_DH_SHA_384;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_DH_SHA_512_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_DH_SHA_512_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_DH_SHA_512_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_DH_SHA_512;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_ECDH_SHA_1_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_ECDH_SHA_1_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_ECDH_SHA_1_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_ECDH_SHA_1;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_ECDH_SHA_224_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_ECDH_SHA_224_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_ECDH_SHA_224_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_ECDH_SHA_224;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_ECDH_SHA_256_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_ECDH_SHA_256_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_ECDH_SHA_256_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_ECDH_SHA_256;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_ECDH_SHA_384_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_ECDH_SHA_384_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_ECDH_SHA_384_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_ECDH_SHA_384;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_id_RI_ECDH_SHA_512_get_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_id_RI_ECDH_SHA_512_get_eac_b0f2c4de9a53017a");
intgo go__wrap_id_RI_ECDH_SHA_512_get_eac_b0f2c4de9a53017a() {
  int result;
  intgo _swig_go_result;
  
  
  result = (int)(int)id_RI_ECDH_SHA_512;
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_MRZ_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_MRZ_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_MRZ_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_MRZ;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_CAN_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_CAN_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_CAN_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_CAN;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_PIN_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_PIN_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_PIN_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_PIN;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_PUK_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_PUK_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_PUK_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_PUK;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_RAW_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_RAW_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_RAW_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_RAW;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_SEC_UNDEF_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_PACE_SEC_UNDEF_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_SEC_UNDEF_eac_b0f2c4de9a53017a() {
  enum s_type result;
  intgo _swig_go_result;
  
  
  result = PACE_SEC_UNDEF;
  
  _swig_go_result = (intgo)result; 
  return _swig_go_result;
}


PACE_SEC *go__wrap_PACE_SEC_new_eac_b0f2c4de9a53017a(_gostring_ garg1, intgo garg3) __asm__("go.eac__wrap_PACE_SEC_new_eac_b0f2c4de9a53017a");
PACE_SEC *go__wrap_PACE_SEC_new_eac_b0f2c4de9a53017a(_gostring_ garg1, intgo garg3) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  enum s_type arg3 ;
  PACE_SEC *result = 0 ;
  PACE_SEC *_swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  arg3 = (enum s_type)garg3; 
  
  result = (PACE_SEC *)PACE_SEC_new(arg1,arg2,arg3);
  *(PACE_SEC **)&_swig_go_result = (PACE_SEC *)result; 
  return _swig_go_result;
}


void go__wrap_PACE_SEC_clear_free_eac_b0f2c4de9a53017a(PACE_SEC *garg1) __asm__("go.eac__wrap_PACE_SEC_clear_free_eac_b0f2c4de9a53017a");
void go__wrap_PACE_SEC_clear_free_eac_b0f2c4de9a53017a(PACE_SEC *garg1) {
  PACE_SEC *arg1 = (PACE_SEC *) 0 ;
  
  arg1 = *(PACE_SEC **)&garg1; 
  
  PACE_SEC_clear_free(arg1);
  
}


BUF_MEM *go__wrap_PACE_STEP1_enc_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, PACE_SEC *garg2) __asm__("go.eac__wrap_PACE_STEP1_enc_nonce_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_PACE_STEP1_enc_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, PACE_SEC *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  PACE_SEC *arg2 = (PACE_SEC *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(PACE_SEC **)&garg2; 
  
  result = (BUF_MEM *)PACE_STEP1_enc_nonce((EAC_CTX const *)arg1,(PACE_SEC const *)arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_STEP2_dec_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, PACE_SEC *garg2, BUF_MEM *garg3) __asm__("go.eac__wrap_PACE_STEP2_dec_nonce_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_STEP2_dec_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, PACE_SEC *garg2, BUF_MEM *garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  PACE_SEC *arg2 = (PACE_SEC *) 0 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(PACE_SEC **)&garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  
  result = (int)PACE_STEP2_dec_nonce((EAC_CTX const *)arg1,(PACE_SEC const *)arg2,(BUF_MEM const *)arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_PACE_STEP3A_generate_mapping_data_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_PACE_STEP3A_generate_mapping_data_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_PACE_STEP3A_generate_mapping_data_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)PACE_STEP3A_generate_mapping_data((EAC_CTX const *)arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_STEP3A_map_generator_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_PACE_STEP3A_map_generator_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_STEP3A_map_generator_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (int)PACE_STEP3A_map_generator((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_PACE_STEP3B_generate_ephemeral_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_PACE_STEP3B_generate_ephemeral_key_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_PACE_STEP3B_generate_ephemeral_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)PACE_STEP3B_generate_ephemeral_key(arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_STEP3B_compute_shared_secret_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_PACE_STEP3B_compute_shared_secret_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_STEP3B_compute_shared_secret_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (int)PACE_STEP3B_compute_shared_secret((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_PACE_STEP3D_compute_authentication_token_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_PACE_STEP3D_compute_authentication_token_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_PACE_STEP3D_compute_authentication_token_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (BUF_MEM *)PACE_STEP3D_compute_authentication_token((EAC_CTX const *)arg1,arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_STEP3D_verify_authentication_token_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_PACE_STEP3D_verify_authentication_token_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_STEP3D_verify_authentication_token_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (int)PACE_STEP3D_verify_authentication_token((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_PACE_STEP3C_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_PACE_STEP3C_derive_keys_eac_b0f2c4de9a53017a");
intgo go__wrap_PACE_STEP3C_derive_keys_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (int)PACE_STEP3C_derive_keys((EAC_CTX const *)arg1);
  _swig_go_result = result; 
  return _swig_go_result;
}


void go__wrap_TA_disable_checks_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_TA_disable_checks_eac_b0f2c4de9a53017a");
void go__wrap_TA_disable_checks_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  TA_disable_checks(arg1);
  
}


intgo go__wrap_TA_STEP2_import_certificate_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3) __asm__("go.eac__wrap_TA_STEP2_import_certificate_eac_b0f2c4de9a53017a");
intgo go__wrap_TA_STEP2_import_certificate_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  size_t arg3 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(unsigned char **)&garg2; 
  arg3 = (size_t)garg3; 
  
  result = (int)TA_STEP2_import_certificate((EAC_CTX const *)arg1,(unsigned char const *)arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_TA_STEP3_generate_ephemeral_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_TA_STEP3_generate_ephemeral_key_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_TA_STEP3_generate_ephemeral_key_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)TA_STEP3_generate_ephemeral_key((EAC_CTX const *)arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_TA_STEP4_get_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_TA_STEP4_get_nonce_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_TA_STEP4_get_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (BUF_MEM *)TA_STEP4_get_nonce((EAC_CTX const *)arg1);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_TA_STEP4_set_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_TA_STEP4_set_nonce_eac_b0f2c4de9a53017a");
intgo go__wrap_TA_STEP4_set_nonce_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (int)TA_STEP4_set_nonce((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_TA_STEP5_sign_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3, BUF_MEM *garg4) __asm__("go.eac__wrap_TA_STEP5_sign_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_TA_STEP5_sign_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3, BUF_MEM *garg4) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  BUF_MEM *arg4 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  arg4 = *(BUF_MEM **)&garg4; 
  
  result = (BUF_MEM *)TA_STEP5_sign((EAC_CTX const *)arg1,(BUF_MEM const *)arg2,(BUF_MEM const *)arg3,(BUF_MEM const *)arg4);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_TA_STEP6_verify_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3, BUF_MEM *garg4, BUF_MEM *garg5) __asm__("go.eac__wrap_TA_STEP6_verify_eac_b0f2c4de9a53017a");
intgo go__wrap_TA_STEP6_verify_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2, BUF_MEM *garg3, BUF_MEM *garg4, BUF_MEM *garg5) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  BUF_MEM *arg4 = (BUF_MEM *) 0 ;
  BUF_MEM *arg5 = (BUF_MEM *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  arg4 = *(BUF_MEM **)&garg4; 
  arg5 = *(BUF_MEM **)&garg5; 
  
  result = (int)TA_STEP6_verify((EAC_CTX const *)arg1,(BUF_MEM const *)arg2,(BUF_MEM const *)arg3,(BUF_MEM const *)arg4,(BUF_MEM const *)arg5);
  _swig_go_result = result; 
  return _swig_go_result;
}


EAC_CTX *go__wrap_EAC_CTX_new_eac_b0f2c4de9a53017a() __asm__("go.eac__wrap_EAC_CTX_new_eac_b0f2c4de9a53017a");
EAC_CTX *go__wrap_EAC_CTX_new_eac_b0f2c4de9a53017a() {
  EAC_CTX *result = 0 ;
  EAC_CTX *_swig_go_result;
  
  
  result = (EAC_CTX *)EAC_CTX_new();
  *(EAC_CTX **)&_swig_go_result = (EAC_CTX *)result; 
  return _swig_go_result;
}


void go__wrap_EAC_CTX_clear_free_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_EAC_CTX_clear_free_eac_b0f2c4de9a53017a");
void go__wrap_EAC_CTX_clear_free_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  EAC_CTX_clear_free(arg1);
  
}


intgo go__wrap_EAC_CTX_init_pace_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, intgo garg3) __asm__("go.eac__wrap_EAC_CTX_init_pace_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_pace_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, intgo garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (int)garg2; 
  arg3 = (int)garg3; 
  
  result = (int)EAC_CTX_init_pace(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_EAC_encrypt_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_EAC_encrypt_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_EAC_encrypt_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (BUF_MEM *)EAC_encrypt((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_EAC_decrypt_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_EAC_decrypt_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_EAC_decrypt_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (BUF_MEM *)EAC_decrypt((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_EAC_authenticate_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) __asm__("go.eac__wrap_EAC_authenticate_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_EAC_authenticate_eac_b0f2c4de9a53017a(EAC_CTX *garg1, BUF_MEM *garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  BUF_MEM *arg2 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(BUF_MEM **)&garg2; 
  
  result = (BUF_MEM *)EAC_authenticate((EAC_CTX const *)arg1,(BUF_MEM const *)arg2);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


BUF_MEM *go__wrap_EAC_Comp_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, BUF_MEM *garg3) __asm__("go.eac__wrap_EAC_Comp_eac_b0f2c4de9a53017a");
BUF_MEM *go__wrap_EAC_Comp_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, BUF_MEM *garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int arg2 ;
  BUF_MEM *arg3 = (BUF_MEM *) 0 ;
  BUF_MEM *result = 0 ;
  BUF_MEM *_swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (int)garg2; 
  arg3 = *(BUF_MEM **)&garg3; 
  
  result = (BUF_MEM *)EAC_Comp((EAC_CTX const *)arg1,arg2,(BUF_MEM const *)arg3);
  *(BUF_MEM **)&_swig_go_result = (BUF_MEM *)result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ef_cardaccess__SWIG_0_eac_b0f2c4de9a53017a(char *garg1, long long garg2, EAC_CTX *garg3) __asm__("go.eac__wrap_EAC_CTX_init_ef_cardaccess__SWIG_0_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ef_cardaccess__SWIG_0_eac_b0f2c4de9a53017a(char *garg1, long long garg2, EAC_CTX *garg3) {
  unsigned char *arg1 = (unsigned char *) 0 ;
  size_t arg2 ;
  EAC_CTX *arg3 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(unsigned char **)&garg1; 
  arg2 = (size_t)garg2; 
  arg3 = *(EAC_CTX **)&garg3; 
  
  result = (int)EAC_CTX_init_ef_cardaccess(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_0_eac_b0f2c4de9a53017a(char *garg1, long long garg2, EAC_CTX *garg3) __asm__("go.eac__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_0_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_0_eac_b0f2c4de9a53017a(char *garg1, long long garg2, EAC_CTX *garg3) {
  unsigned char *arg1 = (unsigned char *) 0 ;
  size_t arg2 ;
  EAC_CTX *arg3 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(unsigned char **)&garg1; 
  arg2 = (size_t)garg2; 
  arg3 = *(EAC_CTX **)&garg3; 
  
  result = (int)EAC_CTX_init_ef_cardsecurity(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ta__SWIG_0_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3, char *garg4, long long garg5) __asm__("go.eac__wrap_EAC_CTX_init_ta__SWIG_0_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ta__SWIG_0_eac_b0f2c4de9a53017a(EAC_CTX *garg1, char *garg2, long long garg3, char *garg4, long long garg5) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  size_t arg3 ;
  unsigned char *arg4 = (unsigned char *) 0 ;
  size_t arg5 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = *(unsigned char **)&garg2; 
  arg3 = (size_t)garg3; 
  arg4 = *(unsigned char **)&garg4; 
  arg5 = (size_t)garg5; 
  
  result = (int)EAC_CTX_init_ta((EAC_CTX const *)arg1,(unsigned char const *)arg2,arg3,(unsigned char const *)arg4,arg5);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ef_cardaccess__SWIG_1_eac_b0f2c4de9a53017a(_gostring_ garg1, EAC_CTX *garg3) __asm__("go.eac__wrap_EAC_CTX_init_ef_cardaccess__SWIG_1_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ef_cardaccess__SWIG_1_eac_b0f2c4de9a53017a(_gostring_ garg1, EAC_CTX *garg3) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  EAC_CTX *arg3 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  arg3 = *(EAC_CTX **)&garg3; 
  
  result = (int)eac_ctx_init_ef_cardaccess(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_1_eac_b0f2c4de9a53017a(_gostring_ garg1, EAC_CTX *garg3) __asm__("go.eac__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_1_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ef_cardsecurity__SWIG_1_eac_b0f2c4de9a53017a(_gostring_ garg1, EAC_CTX *garg3) {
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  EAC_CTX *arg3 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  
  arg1 = (char *)garg1.p;
  arg2 = (size_t)garg1.n;
  
  arg3 = *(EAC_CTX **)&garg3; 
  
  result = (int)eac_ctx_init_ef_cardsecurity(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ta__SWIG_1_eac_b0f2c4de9a53017a(EAC_CTX *garg1, _gostring_ garg2, _gostring_ garg4) __asm__("go.eac__wrap_EAC_CTX_init_ta__SWIG_1_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ta__SWIG_1_eac_b0f2c4de9a53017a(EAC_CTX *garg1, _gostring_ garg2, _gostring_ garg4) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  char *arg4 = (char *) 0 ;
  size_t arg5 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  arg2 = (char *)garg2.p;
  arg3 = (size_t)garg2.n;
  
  
  arg4 = (char *)garg4.p;
  arg5 = (size_t)garg4.n;
  
  
  result = (int)eac_ctx_init_ta((EAC_CTX const *)arg1,arg2,arg3,arg4,arg5);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_init_ca_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, intgo garg3) __asm__("go.eac__wrap_EAC_CTX_init_ca_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_init_ca_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2, intgo garg3) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (int)garg2; 
  arg3 = (int)garg3; 
  
  result = (int)EAC_CTX_init_ca(arg1,arg2,arg3);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_CTX_set_encryption_ctx_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2) __asm__("go.eac__wrap_EAC_CTX_set_encryption_ctx_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_CTX_set_encryption_ctx_eac_b0f2c4de9a53017a(EAC_CTX *garg1, intgo garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int arg2 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (int)garg2; 
  
  result = (int)EAC_CTX_set_encryption_ctx(arg1,arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_increment_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_EAC_increment_ssc_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_increment_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (int)EAC_increment_ssc((EAC_CTX const *)arg1);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_reset_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1) __asm__("go.eac__wrap_EAC_reset_ssc_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_reset_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  
  result = (int)EAC_reset_ssc((EAC_CTX const *)arg1);
  _swig_go_result = result; 
  return _swig_go_result;
}


intgo go__wrap_EAC_set_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1, long long garg2) __asm__("go.eac__wrap_EAC_set_ssc_eac_b0f2c4de9a53017a");
intgo go__wrap_EAC_set_ssc_eac_b0f2c4de9a53017a(EAC_CTX *garg1, long long garg2) {
  EAC_CTX *arg1 = (EAC_CTX *) 0 ;
  unsigned long arg2 ;
  int result;
  intgo _swig_go_result;
  
  arg1 = *(EAC_CTX **)&garg1; 
  arg2 = (unsigned long)garg2; 
  
  result = (int)EAC_set_ssc((EAC_CTX const *)arg1,arg2);
  _swig_go_result = result; 
  return _swig_go_result;
}


void go__wrap_EAC_set_cvc_default_dir_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_EAC_set_cvc_default_dir_eac_b0f2c4de9a53017a");
void go__wrap_EAC_set_cvc_default_dir_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  
  
  arg1 = (char *)malloc(garg1.n + 1);
  memcpy(arg1, garg1.p, garg1.n);
  arg1[garg1.n] = '\0';
  
  
  EAC_set_cvc_default_dir((char const *)arg1);
  
  free(arg1); 
}


void go__wrap_EAC_set_x509_default_dir_eac_b0f2c4de9a53017a(_gostring_ garg1) __asm__("go.eac__wrap_EAC_set_x509_default_dir_eac_b0f2c4de9a53017a");
void go__wrap_EAC_set_x509_default_dir_eac_b0f2c4de9a53017a(_gostring_ garg1) {
  char *arg1 = (char *) 0 ;
  
  
  arg1 = (char *)malloc(garg1.n + 1);
  memcpy(arg1, garg1.p, garg1.n);
  arg1[garg1.n] = '\0';
  
  
  EAC_set_x509_default_dir((char const *)arg1);
  
  free(arg1); 
}


#ifdef __cplusplus
}
#endif

